<?php
  
/*
-----------------
Добавление лайков
-----------------
*/

function likes_ajax($id, $type, $user_id, $notification = 1){
  
  if (get('reaction_'.$type.'_'.$id) && user('ID') > 0) {
    
    get_check_valid();
    $reaction_type = 0;
    if (get('reaction_type') >= 0 && get('reaction_type') <= 5) { $reaction_type = esc(tabs(get('reaction_type'))); }
    if (get('delete_reaction') != 'ok' && db::get_column("SELECT COUNT(`ID`) FROM `LIKES` WHERE `USER_ID` = ? AND `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? AND `TYPE` = ? LIMIT 1", [user('ID'), $id, $type, 'reaction']) == 0) {
      
      db::get_add("INSERT INTO `LIKES` (`USER_ID`, `TIME`, `OBJECT_ID`, `OBJECT_TYPE`, `TYPE`, `REACTION`) VALUES (?, ?, ?, ?, ?, ?)", [user('ID'), TM, $id, $type, 'reaction', $reaction_type]);
      
      /*
      --------------------
      Уведомления в журнал
      --------------------
      */
      
      if ($notification == 1 && $type == 'blogs' || $notification == 1 && $type == 'forum' || $notification == 1 && $type == 'wall') {
        
        if ($user_id != user('ID')){
          
          if (db::get_column("SELECT COUNT(*) FROM `NOTIFICATIONS_SETTINGS` WHERE `USER_ID` = ? AND `LIKES` = ? LIMIT 1", [$user_id, 1]) == 1){ 
            
            db::get_add("INSERT INTO `NOTIFICATIONS` (`USER_ID`, `OBJECT_ID`, `OBJECT_ID_LIST`, `TIME`, `TYPE`) VALUES (?, ?, ?, ?, ?)", [$user_id, user('ID'), $id, TM, $type.'_reaction']);
          
          }
        
        }
      
      }
    
    }elseif (get('delete_reaction') == 'ok') {
      
      db::get_set("DELETE FROM `LIKES` WHERE `USER_ID` = ? AND `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? AND `TYPE` = ? LIMIT 1", [user('ID'), $id, $type, 'reaction']);
    
    }
    
  }  
  
  if (get('like'.$id) && user('ID') > 0) {
    
    get_check_valid();
    
    if (db::get_column("SELECT COUNT(`ID`) FROM `LIKES` WHERE `USER_ID` = ? AND `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? AND `TYPE` = ? LIMIT 1", [user('ID'), $id, $type, 'like']) == 0) {
      
      db::get_add("INSERT INTO `LIKES` (`USER_ID`, `TIME`, `OBJECT_ID`, `OBJECT_TYPE`, `TYPE`) VALUES (?, ?, ?, ?, ?)", [user('ID'), TM, $id, $type, 'like']);
      db::get_set("DELETE FROM `LIKES` WHERE `USER_ID` = ? AND `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? AND `TYPE` = ? LIMIT 1", [user('ID'), $id, $type, 'dislike']);
      
      /*
      --------------------
      Уведомления в журнал
      --------------------
      */
      
      if ($notification == 1) {
        
        if ($user_id != user('ID')){
          
          if (db::get_column("SELECT COUNT(*) FROM `NOTIFICATIONS_SETTINGS` WHERE `USER_ID` = ? AND `LIKES` = ? LIMIT 1", [$user_id, 1]) == 1){ 
            
            db::get_add("INSERT INTO `NOTIFICATIONS` (`USER_ID`, `OBJECT_ID`, `OBJECT_ID_LIST`, `TIME`, `TYPE`) VALUES (?, ?, ?, ?, ?)", [$user_id, user('ID'), $id, TM, $type.'_like']);
          
          }
        
        }
      
      }
    
    }else{
      
      db::get_set("DELETE FROM `LIKES` WHERE `USER_ID` = ? AND `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? AND `TYPE` = ? LIMIT 1", [user('ID'), $id, $type, 'like']);
    
    }
  
  }
  
}

/*
--------------------
Добавление дислайков
--------------------
*/

function dislikes_ajax($id, $type){
  
  if (get('dislike'.$id) && user('ID') > 0) {
    
    get_check_valid();
    
    if (db::get_column("SELECT COUNT(`ID`) FROM `LIKES` WHERE `USER_ID` = ? AND `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? AND `TYPE` = ? LIMIT 1", [user('ID'), $id, $type, 'dislike']) == 0) {
      
      db::get_add("INSERT INTO `LIKES` (`USER_ID`, `TIME`, `OBJECT_ID`, `OBJECT_TYPE`, `TYPE`) VALUES (?, ?, ?, ?, ?)", [user('ID'), TM, $id, $type, 'dislike']);
      db::get_set("DELETE FROM `LIKES` WHERE `USER_ID` = ? AND `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? AND `TYPE` = ? LIMIT 1", [user('ID'), $id, $type, 'like']);
    
    }else{
      
      db::get_set("DELETE FROM `LIKES` WHERE `USER_ID` = ? AND `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? AND `TYPE` = ? LIMIT 1", [user('ID'), $id, $type, 'dislike']);
    
    }
  
  }
  
} 

/*
------------
Вывод лайков
------------
*/
  
function mlikes($id, $url, $type, $class, $element = 'like') {
  
  $likes = db::get_column("SELECT COUNT(`ID`) FROM `LIKES` WHERE `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? AND `TYPE` = ? LIMIT 1", [$id, $type, 'like']);
  $ulikes = db::get_column("SELECT COUNT(`ID`) FROM `LIKES` WHERE `OBJECT_ID` = ? AND `USER_ID` = ? AND `OBJECT_TYPE` = ? AND `TYPE` = ? LIMIT 1", [$id, user('ID'), $type, 'like']);
  
  if ($ulikes > 0){
    
    $cl = "color: #3DC999";
  
  }else{
    
    $cl = null;
  
  }
  
  return '<span style="'.$cl.'" class="'.$class.'" onclick="request(\''.url_request_get($url).'like'.$id.'='.$id.'&'.TOKEN_URL.'\', \'#'.$element.'\')">'.icons('thumbs-up', 18, 'fa-fw').' '.$likes.'</span>';
  
}

/*
---------------
Вывод дислайков
---------------
*/

function mdislikes($id, $url, $type, $class, $element = 'like') {
  
  $dislikes = db::get_column("SELECT COUNT(`ID`) FROM `LIKES` WHERE `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? AND `TYPE` = ? LIMIT 1", [$id, $type, 'dislike']);
  $udislikes = db::get_column("SELECT COUNT(`ID`) FROM `LIKES` WHERE `OBJECT_ID` = ? AND `USER_ID` = ? AND `OBJECT_TYPE` = ? AND `TYPE` = ? LIMIT 1", [$id, user('ID'), $type, 'dislike']);
  
  if ($udislikes > 0){
    
    $cd = "color: #FB6083";
  
  }else{
    
    $cd = null;
  
  }
  
  return '<span style="'.$cd.'" class="'.$class.'" onclick="request(\''.url_request_get($url).'dislike'.$id.'='.$id.'&'.TOKEN_URL.'\', \'#'.$element.'\')">'.icons('thumbs-down', 18, 'fa-fw').' '.$dislikes.'</span>';
  
}

/*
---------------------
Вывод тех кто лайкнул
---------------------
*/

function likes_list($id, $type, $url) {
   
  $reaction = null;
  
  $reaction_type_name = array(
    
    0 => lg('Супер'),
    1 => lg('Смешно'),
    2 => lg('Ого!'),
    3 => lg('Восторг'),
    4 => lg('Печаль'),
    5 => lg('Мат')
    
  );
  
  if (user('ID') > 0) {
    
    if (db::get_column("SELECT COUNT(`ID`) FROM `LIKES` WHERE `USER_ID` = ? AND `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? AND `TYPE` = ? LIMIT 1", [user('ID'), $id, $type, 'reaction']) == 0){
      
      $get_set = (get('base') == 'users' && get('path') == 'account' && get('subpath') == 'page' ? '/id'.intval(get('id')).'?' : url_request_get($url));
    
      $reaction = '
      <span id="reaction_'.$type.'_'.$id.'">
      <div class="reaction">
      <span class="reaction_smiles" onclick="request(\''.$get_set.'reaction_'.$type.'_'.$id.'='.$id.'&reaction_type=0&'.TOKEN_URL.'\', \'#reaction_'.$type.'_'.$id.'\')"><img src="/style/reaction/0.gif"><span class="reaction_info">'.$reaction_type_name[0].'</span></span>
      <span class="reaction_smiles" onclick="request(\''.$get_set.'reaction_'.$type.'_'.$id.'='.$id.'&reaction_type=1&'.TOKEN_URL.'\', \'#reaction_'.$type.'_'.$id.'\')"><img src="/style/reaction/1.gif"><span class="reaction_info">'.$reaction_type_name[1].'</span></span>
      <span class="reaction_smiles" onclick="request(\''.$get_set.'reaction_'.$type.'_'.$id.'='.$id.'&reaction_type=2&'.TOKEN_URL.'\', \'#reaction_'.$type.'_'.$id.'\')"><img src="/style/reaction/2.gif"><span class="reaction_info">'.$reaction_type_name[2].'</span></span>
      <span class="reaction_smiles" onclick="request(\''.$get_set.'reaction_'.$type.'_'.$id.'='.$id.'&reaction_type=3&'.TOKEN_URL.'\', \'#reaction_'.$type.'_'.$id.'\')"><img src="/style/reaction/3.gif"><span class="reaction_info">'.$reaction_type_name[3].'</span></span>
      <span class="reaction_smiles" onclick="request(\''.$get_set.'reaction_'.$type.'_'.$id.'='.$id.'&reaction_type=4&'.TOKEN_URL.'\', \'#reaction_'.$type.'_'.$id.'\')"><img src="/style/reaction/4.gif"><span class="reaction_info">'.$reaction_type_name[4].'</span></span>
      <span class="reaction_smiles" onclick="request(\''.$get_set.'reaction_'.$type.'_'.$id.'='.$id.'&reaction_type=5&'.TOKEN_URL.'\', \'#reaction_'.$type.'_'.$id.'\')"><img src="/style/reaction/5.gif"><span class="reaction_info">'.$reaction_type_name[5].'</span></span>
      </div>
      </span>
      ';
      
    }else{
      
      $reaction_type = db::get_column("SELECT `REACTION` FROM `LIKES` WHERE `USER_ID` = ? AND `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? AND `TYPE` = ? LIMIT 1", [user('ID'), $id, $type, 'reaction']);
      
      $reaction = '
      <span id="reaction_'.$type.'_'.$id.'">
      <div class="reaction">
      <span class="reaction_smiles" onclick="request(\''.url_request_get($url).'reaction_'.$type.'_'.$id.'='.$id.'&'.TOKEN_URL.'&delete_reaction=ok\', \'#reaction_'.$type.'_'.$id.'\')"><img src="/style/reaction/'.$reaction_type.'.gif"><span class="reaction_info">'.$reaction_type_name[$reaction_type].'</span> <span class="reaction_info_name">'.icons('check', 13, 'fa-fw').' '.lg('Ваша реакция').'</span></span>
      </div><span class="reaction_info_name" style="left: 11px"><a href="/m/likes/?id='.$id.'&action='.base64_encode($url).'&type='.$type.'&'.TOKEN_URL.'">'.lg('Список реакций').'</a></span>
      </span>
      ';
      
    }
    
  }
  
  if (db::get_column("SELECT COUNT(`ID`) FROM `LIKES` WHERE `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? AND `TYPE` = ? LIMIT 1", [$id, $type, 'like']) > 0){
      
    $s = 0;
    $avatar = null;
    $end = null;
    $data = db::get_string_all("SELECT `USER_ID` FROM `LIKES` WHERE `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? AND `TYPE` = ? ORDER BY `TIME` DESC", [$id, $type, 'like']);
    while ($list = $data->fetch()){
      
      $s++;
      if ($s >= 1 && $s <= 3){
        
        $avatar .= " ".user::avatar($list['USER_ID'], 25)." ";
      
      }
    
    }
    
    if ($s > 3){
      
      $count = $s - 3; 
      
      $end = "<span style='position: relative; bottom: 9px; margin-left: 5px;'>".lg('и ещё')." <span class='count'>".$count."</span> ".lg('чел.')."</span>";
    
    }
      
    return $reaction."<br /><a href='/m/likes/?id=".$id."&action=".base64_encode($url)."&type=".$type."&".TOKEN_URL."'><span style='position: relative; bottom: 9px; margin-right: 5px;'>".lg('Понравилось')."</span>".$avatar.$end."</a>";
    
  }
  
  return $reaction;
  
}