<?php
$account = db::get_string("SELECT `ID`,`ACCESS` FROM `USERS` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);  

acms_header(lg('История блокировок %s на добавление сообщений', user::login_mini($account['ID'])));

if (!isset($account['ID'])) {
  
  error('Пользователь не найден');
  redirect('/');
  
}

?>
<div class='list'><center><b><?=tabs(config('TITLE'))?></b></center></div>
<?

$column = db::get_column("SELECT COUNT(*) FROM `BLOCK_MESSAGES` WHERE `USER_ID` = ?", [$account['ID']]);
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;

if ($column == 0){ 
  
  html::empty(lg('У пользователя %s нет блокировок', user::login_mini($account['ID'])));

}

if (access('block_messages', null) == true && get('delete') && db::get_column("SELECT COUNT(*) FROM `BLOCK_MESSAGES` WHERE `ID` = ? LIMIT 1", [intval(get('delete'))]) > 0){
  
  get_check_valid();
  
  db::get_set("DELETE FROM `BLOCK_MESSAGES` WHERE `ID` = ? LIMIT 1", [intval(get('delete'))]);
  
  success('Блокировка удалена');
  redirect('/m/block/block_messages_list/?id='.$account['ID']);

}

$data = db::get_string_all("SELECT * FROM `BLOCK_MESSAGES` WHERE `USER_ID` = ? ORDER BY `TIME` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [$account['ID']]);
while ($list = $data->fetch()){
  
  if ($list['REASON'] == 1){
    
    $reason = 'СПАМ, реклама';
  
  }elseif ($list['REASON'] == 2){
    
    $reason = 'Мошенничество';
  
  }elseif ($list['REASON'] == 3){
    
    $reason = 'Нецензурная брань, оскорбления';
  
  }elseif ($list['REASON'] == 4){
    
    $reason = 'Разжигание ненависти';
  
  }elseif ($list['REASON'] == 5){
    
    $reason = 'Пропаганда нацизма';
  
  }elseif ($list['REASON'] == 6){
    
    $reason = 'Пропаганда наркотиков';
  
  }elseif ($list['REASON'] == 7){
    
    $reason = 'Систематические нарушения';
  
  }elseif ($list['REASON'] == 0){
    
    $reason = 'Иная';
  
  }
  
  if ($list['BAN_TIME'] == 0){
    
    $block_time = lg('навсегда');
    
  }else{
    
    if ($list['BAN_TIME'] < TM){
      
      $block_time = lg('истек');
    
    }else{
      
      $block_time = lg('до')." ".ftime($list['BAN_TIME']);
    
    }
    
  }
  
  ?>
  <div class='list'>
  <b><?=lg('Причина блокировки')?>:</b> <?=lg($reason)?><br /><br />
  <b><?=lg('Заблокировал')?>:</b> <?=user::login($list['ADM_ID'], 0, 1)?><br /><br />
  <?=lg('Комментарий')?>:</b> <?=text($list['MESSAGE'])?><br /><br />
  <?=lg('Время блокировки')?>:</b> <?=ftime($list['TIME'])?><br /><br />
  <b><?=lg('Срок')?>:</b> <?=$block_time?>
  <?
  
  if (access('block_messages', null) == true) {
    
    ?>
    <br /><br />
    <a href='/m/block/block_messages_list/?id=<?=$account['ID']?>&delete=<?=$list['ID']?>&<?=TOKEN_URL?>' class='btn'><?=icons('trash', 15, 'fa-fw')?> <?=lg('Удалить')?></a>
    <?
      
  }
  
  ?></div><?

}

get_page('/m/block/block_messages_list/?id='.$account['ID'].'&', $spage, $page, 'list');
  
back('/id'.$account['ID']);  
acms_footer();