<?php
  
if (config('ANTIDDOS_ACCESS') == 1) {
  
  $limit_requests = 4;
  
  if (config('ANTIDDOS_MODE') == 2) {
    
    $limit_requests = 3;
    
  }
  
  if (config('ANTIDDOS_MODE') == 3) {
    
    $limit_requests = 2;
    
  }
  
  $window_time = 1;
  $sanitized_ip = preg_replace('/\D/', '', IP);
  $block_file = ROOT.'/files/upload/antiddos/block_status_'.$sanitized_ip.'.json';
  $now = microtime(true);
  $captcha_random_seed = "152639487";
  
  if (!file_exists($block_file)) {
    
    @file_put_contents($block_file, json_encode(['blocked' => false, 'requests' => []]));
  
  }
  
  $data = json_decode(@file_get_contents($block_file), true);
  
  if ($_SERVER['REQUEST_METHOD'] === 'POST' && post('unblock')) {
    
    if (!post('captcha') or !post('captcha_key')) {
      
      redirect(REQUEST_URI);
    
    }
    
    if (md5((int)post('captcha') + $captcha_random_seed) != post('captcha_key')) {
      
      redirect(REQUEST_URI);
    
    }
    
    $data['blocked'] = false;
    $data['requests'] = [];
    @file_put_contents($block_file, json_encode($data));
    
    if (config('ANTIDDOS_LOGS') == 1) {
      
      db::get_add("INSERT INTO `ANTIDDOS` (`BROWSER`, `IP`, `TIME`, `LINK`, `STATUS`) VALUES (?, ?, ?, ?, ?)", [BROWSER, IP, TM, REQUEST_URI, 2]);
    
    }
    
    redirect(REQUEST_URI);
  
  }
  
  if ($data['blocked']) {
    
    $blocked = true;
  
  } else {
    
    $requests = array_filter($data['requests'], function($timestamp) use ($now, $window_time) {
      
      return ($now - $timestamp) < $window_time;
    
    });
    
    $requests[] = $now;
    
    if (count($requests) > $limit_requests) {
      
      $data['blocked'] = true;
      $data['requests'] = $requests;
      @file_put_contents($block_file, json_encode($data));
      $blocked = true;
      
      if (config('ANTIDDOS_LOGS') == 1) {
        
        db::get_add("INSERT INTO `ANTIDDOS` (`BROWSER`, `IP`, `TIME`, `LINK`, `STATUS`) VALUES (?, ?, ?, ?, ?)", [BROWSER, IP, TM, REQUEST_URI, 1]);
        
      }
    
    } else {
      
      $data['requests'] = $requests;
      @file_put_contents($block_file, json_encode($data));
      $blocked = false;
    
    }
  
  }

  ?>
  <?php if ($blocked): ?>
  <style>
  .antiddos_block_container { color: black; margin: auto; font-family: Arial, sans-serif; text-align: center; padding: 30px; box-sizing: border-box; background: #fff; border-radius: 15px; box-shadow: 0 0 10px rgba(0,0,0,0.2); width: 100%; max-width: 600px; margin-top: 20px; }
  .antiddos_block_button { border-radius: 10px; color: white; background: #2B3335; border: none; padding: 10px 20px; font-size: 16px; cursor: pointer; }
  </style>
  <div class="antiddos_block_container">
  <h1><?=lg('Докажите, что вы не робот')?></h1>
  <h2 style='color: #929EA1; font-size: 14px; font-weight: normal;'><?=lg('Зафиксирована подозрительная активность с вашего IP адреса')?> <b><?=IP?></b></h2>
  <p><?=lg('Для продолжения использования сайта введите код ниже и нажмите "Разблокировать доступ"')?>.</p>
  <form method="post">
  <?=html::captcha('Введите числа')?>
  <?=html::button('antiddos_block_button', 'unblock', null, 'Разблокировать доступ')?>
  </form>
  </div>
  <?php exit ?>
  <?php endif ?>
  <?
    
}