<?php
$donats = db::get_string("SELECT * FROM `DONATS` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
acms_header('Донаты - редактировать');
is_active_module('PRIVATE_DONATS');

if (!isset($donats['ID'])) {
  
  error('Неверная директива');
  redirect('/m/donats/');

}

if ($donats['ACT'] == 1 || $donats['ACT'] == 3) {
  
  error('Вы не можете редактировать сбор, который уже получен');
  redirect('/m/donats/show/?id='.$donats['ID']);
  
}

if (post('ok')){
  
  valid::create(array(
    
    'DON_NAME' => ['name', 'text', [2, 200], 'Описание', 0],
    'DON_MAX' => ['max', 'number', [10, abs(config('DONATS_MAX'))], 'Сумма сбора'],
    'DON_SET' => ['set', 'number', [0, 1], 'Размещение на странице']
  
  ));
  
  if (ERROR_LOG == 1){
    
    redirect('/m/donats/edit/?id='.$donats['ID']);
  
  }
  
  db::get_set("UPDATE `DONATS` SET `SET` = ?, `NAME` = ?, `MAX_SUM` = ?, `TIME_EDIT` = ? WHERE `ID` = ? LIMIT 1", [DON_SET, DON_NAME, DON_MAX, TM, $donats['ID']]);
  
  success('Изменения успешно приняты');
  redirect('/m/donats/show/?id='.$donats['ID']);
  
}

?>    
<div class='list'>
<form method='post' class='ajax-form' action='/m/donats/edit/?id=<?=$donats['ID']?>'>
<?=html::input('name', 'Описание', null, null, tabs($donats['NAME']), 'form-control-100', 'text', null, 'text-width', 'Опишите на что вы планируете потратить деньги на сайте')?>
<?=html::input('max', 'Сумма сбора', null, null, abs($donats['MAX_SUM']), 'form-control-30', 'number', null, 'usd')?>
<?=html::checkbox('set', 'Отображать на моей странице', 1, $donats['SET'])?><br /><br />  
<?=html::button('button ajax-button', 'ok', 'save', 'Сохранить изменения')?>
<a class='button-o' href='/m/donats/show/?id=<?=$donats['ID']?>'><?=lg('Отмена')?></a>
</form>
</div>
<?

back('/m/donats/show/?id='.$donats['ID']);
acms_footer();