<?php 
html::title('Антиспам');
acms_header();
access('management');
  
?>
<div class='navigation'>
<a href='/admin/desktop/'><?=icons('home', 25)?></a>
<?=icons('angle-right', 25, 'fa-fw')?>
<a href='/admin/site/'><?=lg('Настройки сайта')?></a>
<?=icons('angle-right', 25, 'fa-fw')?>
<?=lg('Антиспам')?>
</div>
<?

/*
------------------------------
Добавить домен в черный список
------------------------------
*/

if (get('get') == 'add'){
  
  if (post('ok_domain_antispam')){
    
    valid::create(array(
      
      'DMSPAM' => ['domain_antispam', 'text', [1, 1000], 'Домен/фраза', 0]
    
    ));
    
    if (db::get_column("SELECT COUNT(*) FROM `ANTISPAM` WHERE `DOMAIN` = ? LIMIT 1", [DMSPAM]) > 1){
      
      error('Такое доменное имя уже находится в черном списке');
      redirect('/admin/site/antispam/?get=add');
    
    }
        
    db::get_add("INSERT INTO `ANTISPAM` (`DOMAIN`) VALUES (?)", [DMSPAM]);
        
    success('Домен успешно добавлен в черный список');
    redirect('/admin/site/antispam/');
        
  }
  
  ?>
  <div class='list-body6'>
  <div class='list-menu'>  
  <form method='post' class='ajax-form' action='/admin/site/antispam/?get=add'>
  <?=html::input('domain_antispam', null, 'Название домена или фраза', null, null, 'form-control-100', 'text', null, 'text-width')?>
  <?=html::button('button ajax-button', 'ok_domain_antispam', 'ban', 'Добавить в черный список')?>
  </form>
  <br />
  <?=lg('Для эффективной работы модуля рекомендуется писать домены/фразы исключительно на буквах нижнего регистра')?>
  </div>
  </div>
  <br />
  <?
    
  back('/admin/site/antispam/');
  acms_footer();
  
}

/*
-------------------------------
Удалить домен из черного списка
-------------------------------
*/

if (get('delete') && db::get_column("SELECT COUNT(*) FROM `ANTISPAM` WHERE `ID` = ? LIMIT 1", [intval(get('delete'))]) == 1){
  
  get_check_valid();
  
  db::get_set("DELETE FROM `ANTISPAM` WHERE `ID` = ? LIMIT 1", [intval(get('delete'))]);
  
  success('Удаление прошло успешно');  
  redirect('/admin/site/antispam/');
  
}

/*
---------------------------------
Список запрещенных доменов и фраз
---------------------------------
*/

$column = db::get_column("SELECT COUNT(*) FROM `ANTISPAM`");
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;

?>
<div class='list-body'>
<div class='list-menu'>
<a href='/admin/site/antispam/?get=add' class='button'><?=lg('Добавить в черный список')?></a>
</div>
<div class='list-menu list-title'><b><?=lg('Черный список доменов и фраз')?> <span class='count'><?=$column?></span></b></div>
<?

if ($column == 0){ 
  
  html::empty();
  
}

$data = db::get_string_all("SELECT * FROM `ANTISPAM` ORDER BY `ID` DESC LIMIT ".$limit.", ".PAGE_SETTINGS);
while ($list = $data->fetch()) {
  
  ?>
  <div class='list-menu'>
  <b><?=tabs($list['DOMAIN'])?></b><br />
  <br />
  <a class='button2' href='/admin/site/antispam/?delete=<?=$list['ID']?>&<?=TOKEN_URL?>'><?=icons('trash', 15, 'fa-fw')?> <?=lg('Удалить')?></a>
  </div>
  <?

}

get_page('/admin/site/antispam/?', $spage, $page, 'list-menu');

?></div><?

back('/admin/site/');  
acms_footer();