<?php
  
function bb_show() {
  
  ?>    
  <div id='bb' class='bb-show' style='display: none'>    
  <a class='bb-show-ob ssop2' id='bbs_back' data-factor='-1' ajax='no' style='left: 0;'>  
  <?=icons('chevron-left', 25)?>
  </a>    
  <a class='bb-show-ob ssop2' id='bbs_for' data-factor='1' ajax='no' style='right: 50px;'>  
  <?=icons('chevron-right', 25)?>
  </a>    
  <a class='bb-show-ob ssop2' ajax='no' style='right: 0;' onclick="open_or_close('bb')">  
  <?=icons('times', 28)?>
  </a>    
  <div class='bbs_op bb-show-ob-op'>    
  <a class='bbs bb-show-ob' ajax='no' alt='[b]<?=lg('текст')?>[/b]' title='<?=lg('жирный текст')?>'>  
  <?=icons('bold', 21)?>
  </a> 
  <a class='bbs bb-show-ob' ajax='no' alt='[i]<?=lg('текст')?>[/i]' title='<?=lg('курсив')?>'>  
  <?=icons('italic', 21)?>
  </a>
  <a class='bbs bb-show-ob' ajax='no' alt='[u]<?=lg('текст')?>[/u]' title='<?=lg('подчеркнутый текст')?>'>  
  <?=icons('underline', 21)?>
  </a>
  <a class='bbs bb-show-ob' ajax='no' alt='[s]<?=lg('текст')?>[/s]' title='<?=lg('зачеркнутый текст')?>'>  
  <?=icons('strikethrough', 21)?>
  </a>
  <a class='bbs bb-show-ob' ajax='no' alt='[quote]<?=lg('текст')?>[/quote]' title='<?=lg('цитата')?>'>  
  <?=icons('comment', 21)?>
  </a>
  <a class='bbs bb-show-ob' ajax='no' alt='[url=<?=lg('ссылка')?>]<?=lg('имя ссылки')?>[/url]' title='<?=lg('ссылка')?>'>  
  <?=icons('link', 21)?>
  </a>
  <a class='bbs bb-show-ob' ajax='no' alt='[marquee]<?=lg('бегущий текст')?>[/marquee]' title='<?=lg('бегущий текст')?>'>  
  <?=icons('undo', 21)?>
  </a>
  <a class='bbs bb-show-ob' ajax='no' alt='[center]<?=lg('текст по центру')?>[/center]' title='<?=lg('текст по центру')?>'>  
  <?=icons('align-center', 21)?>
  </a>
  <a class='bbs bb-show-ob' ajax='no' alt='[right]<?=lg('текст справа')?>[/right]' title='<?=lg('текст справа')?>'>  
  <?=icons('align-right', 21)?>
  </a>
  <a class='bbs bb-show-ob' ajax='no' alt='[left]<?=lg('текст слева')?>[/left]' title='<?=lg('текст слева')?>'>  
  <?=icons('align-left', 21)?>
  </a>
  <a class='bbs bb-show-ob' ajax='no' alt='[justify]<?=lg('текст по краям')?>[/justify]' title='<?=lg('текст по краям')?>'>  
  <?=icons('align-justify', 21)?>
  </a>
  <a class='bbs bb-show-ob' ajax='no' alt='[ftext]<?=lg('мигающий текст')?>[/ftext]' title='<?=lg('мигающий текст')?>'>  
  <?=icons('magic', 21)?>
  </a>
  <a class='bbs bb-show-ob' ajax='no' alt='[youtube]<?=lg('идентификатор видео (Пример: qTBKohDwLvY)')?>[/youtube]' title='<?=lg('видео с YouTube')?>'>  
  <?=icons('youtube', 21)?>
  </a>
  <a class='bbs bb-show-ob' ajax='no' alt='[img]<?=lg('ссылка на изображение')?>[/img]' title='<?=lg('изображение')?>'>  
  <?=icons('image', 21)?>
  </a>
  <a class='bbs bb-show-ob' ajax='no' alt='[audio]<?=lg('ссылка на аудио')?>[/audio]' title='<?=lg('аудио')?>'> 
  <?=icons('music', 21)?>
  </a>
  <a class='bb-show-ob' ajax='no' onclick="open_or_close('bbcolor')" title='<?=lg('цвет текста')?>'>  
  <?=icons('paint-brush', 21)?>
  </a>
  <a class='bb-show-ob' ajax='no' onclick="open_or_close('bbbcolor')" title='<?=lg('фон текста')?>'>  
  <?=icons('th', 21)?>
  </a>
  <a class='bb-show-ob' ajax='no' onclick="open_or_close('bbsize')" title='<?=lg('размер текста')?>'>  
  <?=icons('object-ungroup', 21)?>
  </a>
  <a class='bb-show-ob' ajax='no' onclick="open_or_close('bbacode')" title='<?=lg('код')?>'>  
  <?=icons('code', 21)?>
  </a>
  </div> 
  </div>    
  <div id='bbcolor' style='display: none; padding-left: 5px; padding-right: 5px; padding-bottom: 12px'>
  <b onclick="open_or_close('bbcolor', 'close')"><?=icons('times', 25, 'fa-fw')?> <?=lg('Выберите цвет текста:')?></b><br /><br />
  <?php require_once (ROOT.'/system/connections/color.php');?>
  </div>    
  <div id='bbbcolor' style='display: none; padding-left: 5px; padding-right: 5px; padding-bottom: 12px'>
  <b onclick="open_or_close('bbbcolor', 'close')"><?=icons('times', 25, 'fa-fw')?> <?=lg('Выберите фон текста:')?></b><br /><br />
  <?php require_once (ROOT.'/system/connections/bcolor.php');?>
  </div>    
  <div id='bbsize' style='display: none; padding-left: 5px; padding-right: 5px; padding-bottom: 12px'>
  <b onclick="open_or_close('bbsize', 'close')"><?=icons('times', 25, 'fa-fw')?> <?=lg('Выберите размер текста:')?></b><br /><br />
  <span class="bbs btn-o" alt="[size10]<?=lg('текст')?>[/size10]">10px</span>
  <span class="bbs btn-o" alt="[size12]<?=lg('текст')?>[/size12]">12px</span>
  <span class="bbs btn-o" alt="[size14]<?=lg('текст')?>[/size14]">14px</span>
  <span class="bbs btn-o" alt="[size16]<?=lg('текст')?>[/size16]">16px</span>
  <span class="bbs btn-o" alt="[size18]<?=lg('текст')?>[/size18]">18px</span>
  <span class="bbs btn-o" alt="[size20]<?=lg('текст')?>[/size20]">20px</span>
  <span class="bbs btn-o" alt="[size24]<?=lg('текст')?>[/size24]">24px</span>
  <span class="bbs btn-o" alt="[size30]<?=lg('текст')?>[/size30]">30px</span>
  </div>    
  <div id='bbacode' style='display: none; padding-left: 5px; padding-right: 5px; padding-bottom: 12px'>
  <b onclick="open_or_close('bbacode', 'close')"><?=icons('times', 25, 'fa-fw')?> <?=lg('Выберите язык программирования:')?></b><br /><br />
  <span class="bbs btn-o" alt="[code=js][/code]" style="cursor: pointer">JavaScript</span>
  <span class="bbs btn-o" alt="[code=php][/code]" style="cursor: pointer">PHP</span> 
  <span class="bbs btn-o" alt="[code=java][/code]" style="cursor: pointer">Java</span>
  <span class="bbs btn-o" alt="[code=html][/code]" style="cursor: pointer">HTML</span>
  <span class="bbs btn-o" alt="[code=css][/code]" style="cursor: pointer">CSS</span>
  <span class="bbs btn-o" alt="[code=python][/code]" style="cursor: pointer">Python</span>
  <span class="bbs btn-o" alt="[code=ruby][/code]" style="cursor: pointer">Ruby</span>
  <span class="bbs btn-o" alt="[code=c++][/code]" style="cursor: pointer">C++</span>
  <span class="bbs btn-o" alt="[code=c#][/code]" style="cursor: pointer">C#</span>
  <span class="bbs btn-o" alt="[code=c][/code]" style="cursor: pointer">C</span>
  </div>  
  <?php
  hooks::challenge('bb', 'bb');  
  hooks::run('bb');
  
}

function color($color) {
  
  if (preg_match('/^#([a-f]|[A-F]|[0-9]){3}(([a-f]|[A-F]|[0-9]){3})?$/i', $color[1])){
    
    return '<span style="color: '.$color[1].';">'.$color[2].'</span>';
    
  }else{
    
    return '<span style="color: #000000;">'.$color[2].'</span>';
    
  }

}

function code($color) {
  
  if ($color[1] == 'js' || $color[1] == 'php' || $color[1] == 'java' || $color[1] == 'html' || $color[1] == 'css' || $color[1] == 'python' || $color[1] == 'ruby' || $color[1] == 'c' || $color[1] == 'c++' || $color[1] == 'c#'){
    
    return '<pre style="background-color: #24292B; padding: 10px; margin: -1px; color: white"><code class="'.$color[1].'">'.$color[2].'</code></pre>';
    
  }else{
    
    return $color[2];
    
  }

}

function bcolor($bcolor) {
  
  if (preg_match('/^#([a-f]|[A-F]|[0-9]){3}(([a-f]|[A-F]|[0-9]){3})?$/i', $bcolor[1])){
    
    return '<div style="background-color: '.$bcolor[1].'; padding: 5px;">'.$bcolor[2].'</div>';
    
  }else{
    
    return '<span style="color: #000000;">'.$bcolor[2].'</span>';
    
  }

}

function img($arr) {
  
  if (@imagecreatefromstring(file_get_contents($arr[1])) && filter_var($arr[1], FILTER_VALIDATE_URL) !== false){
    
    return '<img style="max-width: 100%" src="'.html_entity_decode($arr[1]).'">';		
  
  }else{
    
    return '<img style="max-width: 100%" src="/files/upload/no_photo.jpg?id=1">';	
  
  }

}

function audio($arr){
  
  return '<audio preload="none" style="width: 280px" src="'.html_entity_decode($arr[1]).'" controls></audio>';

}

function bb_code($msg, $param = 1) {

  $msg = preg_replace(array('/alert/', '/document/', '/cookie/', '/script/'), '', $msg);    
  
  if ($param == 1) {
    
    $msg = preg_replace_callback('/\[code=(.+)\](.+)\[\/code\]/isU', 'code', $msg);
    $msg = preg_replace_callback('/\[color=(.+)\](.+)\[\/color\]/isU', 'color', $msg);    
    $msg = preg_replace_callback('/\[bcolor=(.+)\](.+)\[\/bcolor\]/isU', 'bcolor', $msg);  
    $msg = preg_replace_callback('/\[img\](.+)\[\/img\]/isU', 'img', $msg);
    $msg = preg_replace_callback('/\[audio\](.+)\[\/audio\]/isU', 'audio', $msg);
    
  }else{
    
    $msg = preg_replace('/\[code=(.+?)\]/i', '', $msg);
    $msg = preg_replace('/\[\/code]/i', '', $msg);
    $msg = preg_replace('/\[color=(.+?)\]/i', '', $msg);
    $msg = preg_replace('/\[\/color]/i', '', $msg);
    $msg = preg_replace('/\[bcolor=(.+?)\]/i', '', $msg);
    $msg = preg_replace('/\[\/bcolor]/i', '', $msg);
    $msg = preg_replace('/\[img\]/i', '', $msg);
    $msg = preg_replace('/\[\/img]/i', '', $msg);
    $msg = preg_replace('/\[audio\]/i', '', $msg);
    $msg = preg_replace('/\[\/audio]/i', '', $msg);
    
  }
  
  $bbcode = array(
    
    '/\[b\](.+)\[\/b\]/isU' => '<b>$1</b>',
    '/\[u\](.+)\[\/u\]/isU' => '<u>$1</u>',
    '/\[i\](.+)\[\/i\]/isU' => '<i>$1</i>',
    '/\[s\](.+)\[\/s\]/isU' => '<s>$1</s>',
    '/\[quote\](.+)\[\/quote\]/isU' => '<div style="padding: 7px; border-radius: 4px; background-color: #DBE7EC; color: #6C7275;">$1</div>',   
    '/\[center\](.+)\[\/center\]/isU' => '<center>$1</center>',
    '/\[justify\](.+)\[\/justify\]/isU' => '<div style="text-align: justify">$1</div>',
    '/\[right\](.+)\[\/right\]/isU' => '<div style="float: right;">$1</div><br />',
    '/\[left\](.+)\[\/left\]/isU' => '<div style="float: left;">$1</div><br />',
    '/\[marquee\](.+)\[\/marquee\]/isU' => '<marquee>$1</marquee>',
    '/\[ftext\](.+)\[\/ftext\]/isU' => '<style>#blink2 {-webkit-animation: blink2 1s linear infinite;animation: blink2 1s linear infinite;}@-webkit-keyframes blink2 {100% { color: rgba(34, 34, 34, 0); }}@keyframes blink2 {100% { color: rgba(34, 34, 34, 0); }}</style><span id="blink2">$1</span>',    
    '/\[size10\](.+)\[\/size10\]/isU' => '<span style="font-size: 10px;">$1</span>',
    '/\[size12\](.+)\[\/size12\]/isU' => '<span style="font-size: 12px;">$1</span>',
    '/\[size14\](.+)\[\/size14\]/isU' => '<span style="font-size: 14px;">$1</span>',
    '/\[size16\](.+)\[\/size16\]/isU' => '<span style="font-size: 16px;">$1</span>',
    '/\[size18\](.+)\[\/size18\]/isU' => '<span style="font-size: 18px;">$1</span>',
    '/\[size20\](.+)\[\/size20\]/isU' => '<span style="font-size: 20px;">$1</span>',
    '/\[size24\](.+)\[\/size24\]/isU' => '<span style="font-size: 24px;">$1</span>',
    '/\[size30\](.+)\[\/size30\]/isU' => '<span style="font-size: 30px;">$1</span>',    
    '/\[youtube\](.+)\[\/youtube\]/isU' => '<center><iframe width="95%" height="180" src="https://www.youtube.com/embed/$1" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe><center>'
  
  );
  
  hooks::challenge('bb_set', 'bb_set');  
  hooks::run('bb_set');
  
  $msg = preg_replace(array_keys($bbcode), ($param == 1 ? array_values($bbcode) : '$1'), $msg);
  
  return $msg;

}