<?php
acms_header('Добавить сайт', 'users');
is_active_module('PRIVATE_TRS');

if (post('ok_site')){
  
  valid::create(array(
    
    'TRS_NAME' => ['name', 'text', [2, 40], 'Название сайта', 0],
    'TRS_MESSAGE' => ['message', 'text', [0, 80], 'Описание сайта', 0],
    'TRS_DOMAIN' => ['domain', 'link', [3, 60], 'Домен сайта', 0],
    'TRS_CATEGORY' => ['id_cat', 'number', [0, 99999], 'Раздел']
  
  ));
  
  if (db::get_column("SELECT COUNT(*) FROM `TRS_SITES` WHERE `DOMAIN` = ? LIMIT 1", [TRS_DOMAIN]) > 0){
    
    error('Такой сайт уже есть');
    redirect('/m/top_rating_sites/add/');
    
  }
  
  if (strpos(TRS_DOMAIN, 'http://') === false && strpos(TRS_DOMAIN, 'https://') === false){
    
    error('Ссылка должна содержать протокол http:// или https://');
    redirect('/m/top_rating_sites/add/');
    
  }
  
  $sm = substr(TRS_DOMAIN, -3);
  
  if (strpos($sm, '/') !== false){
    
    error('В конце домена не должно быть символов "/"');
    redirect('/m/top_rating_sites/add/');
    
  }
  
  if (ERROR_LOG == 1){
    
    redirect('/m/top_rating_sites/add/');
  
  }
  
  $tkn = rand(11111111,99999999).'_'.substr(base64_encode(TM.user('ID')), 0, -2).'_'.user('ID');  
  $ID = db::get_add("INSERT INTO `TRS_SITES` (`TOKEN`, `NAME`, `USER_ID`, `ID_CATEGORY`, `MESSAGE`, `TIME`, `DOMAIN`) VALUES (?, ?, ?, ?, ?, ?, ?)", [$tkn, TRS_NAME, user('ID'), TRS_CATEGORY, TRS_MESSAGE, TM, TRS_DOMAIN]);
  
  file_put_contents(ROOT.'/files/upload/top_rating_sites/'.$tkn.'.txt', $tkn);
  
  success('Сайт успешно добавлен');
  redirect('/m/top_rating_sites/show/?id='.$ID);
  
}

?>    
<div class='list'>
<form method='post' class='ajax-form' action='/m/top_rating_sites/add/'>
<?=html::input('name', 'Название сайта', null, null, null, 'form-control-100', 'text', null, 'text-width')?>  
<?=html::input('message', 'Описание сайта', null, null, null, 'form-control-100', 'text', null, 'text-width')?>
<?=html::input('domain', 'Домен сайта (с http:// или https://)', null, null, null, 'form-control-100', 'text', null, 'link')?>
<?
$array = array();
$array[0] = ['Без категории', 0];
$data = db::get_string_all("SELECT * FROM `TRS_CATEGORIES` ORDER BY `ID` DESC");  
while ($list = $data->fetch()){
  
  $array[$list['ID']] = [tabs($list['NAME']), (0 == $list['ID'] ? "selected" : null)];

}
?>
<?=html::select('id_cat', $array, 'Категория', 'form-control-100-modify-select', 'folder-open')?>
<?=html::button('button ajax-button', 'ok_site', 'plus', 'Добавить')?>
<a class='button-o' href='/m/top_rating_sites/'><?=lg('Отмена')?></a>
<form>
</div>
<?
  
back('/m/top_rating_sites/');
acms_footer();