<?php
acms_header('Рейтинг сайтов - категории');
is_active_module('PRIVATE_TRS');

?>
<div class='menu-nav-content'>  
<a class='menu-nav' href='/m/top_rating_sites/?'>
<?=lg('ТОП')?>
</a>  
<a class='menu-nav' href='/m/top_rating_sites/new/?'>
<?=lg('Новые сайты')?>
</a>  
<a class='menu-nav h' href='/m/top_rating_sites/category/?'>
<?=lg('Категории')?>
</a>
<a class='menu-nav' href='/m/top_rating_sites/blacklist/?'>
<?=lg('Черный список')?>
</a>
</div>
<?

$name = tabs(esc(session('trs_name')));
require (ROOT.'/modules/top_rating_sites/plugins/search_form.php');
require (ROOT.'/modules/top_rating_sites/plugins/upd.php');

/*
---------------
Показ категории
---------------
*/
  
if (get('id')){
  
  $id = intval(get('id'));  
  $cat = db::get_string("SELECT `NAME` FROM `TRS_CATEGORIES` WHERE `ID` = ? LIMIT 1", [$id]);
  
  if (isset($cat['NAME'])){
    
    if (MANAGEMENT == 1){
      
      /*
      -----------------------
      Редактировать категорию
      -----------------------
      */
      
      if (get('get') == 'edit'){
        
        if (post('ok')){
          
          valid::create(array(
            
            'CAT_NAME' => ['name', 'text', [3, 200], 'Название', 0]
          
          ));
          
          if (CAT_NAME != $cat['NAME'] && db::get_column("SELECT COUNT(*) FROM `TRS_CATEGORIES` WHERE `NAME` = ? LIMIT 1", [CAT_NAME]) > 0){
            
            error('Категория с таким названием уже существует');
            redirect('/m/top_rating_sites/category/?id='.$id.'&get=edit');
          
          }
          
          if (ERROR_LOG == 1){
            
            redirect('/m/top_rating_sites/category/?id='.$id.'&get=edit');
          
          }
          
          db::get_set("UPDATE `TRS_CATEGORIES` SET `NAME` = ? WHERE `ID` = ? LIMIT 1", [CAT_NAME, $id]);
          
          success('Изменения успешно приняты');
          redirect('/m/top_rating_sites/category/?id='.$id);
        
        }
        
        ?>
        <div class='list'>
        <form method='post' class='ajax-form' action='/m/top_rating_sites/category/?id=<?=$id?>&get=edit'>
        <?=html::input('name', 'Название', null, null, tabs($cat['NAME']), 'form-control-100', 'text', null, 'folder-open')?>
        <?=html::button('button ajax-button', 'ok', 'plus', 'Добавить')?>
        <a class='button-o' href='/m/top_rating_sites/category/?id=<?=$id?>'><?=lg('Отмена')?></a>
        </form>
        </div>
        <?
        
        back('/m/top_rating_sites/category/?id='.$id);
        acms_footer();
        
      }
      
      /*
      ----------------
      Удаление раздела
      ----------------
      */
      
      if (get('get') == 'delete_ok'){
        
        get_check_valid();
        
        db::get_set("DELETE FROM `TRS_CATEGORIES` WHERE `ID` = ? LIMIT 1", [$id]);
        
        success('Удаление прошло успешно');
        redirect('/m/top_rating_sites/category/');
      
      }
      
      if (get('get') == 'delete'){
        
        get_check_valid();
        
        ?>
        <div class='list'>
        <?=lg('Вы действительно хотите удалить категорию')?> <b><?=tabs($cat['NAME'])?></b>?<br /><br />
        <a href='/m/top_rating_sites/category/?id=<?=$id?>&get=delete_ok&<?=TOKEN_URL?>' class='button'><?=icons('trash', 17, 'fa-fw')?> <?=lg('Удалить')?></a>
        <a href='/m/top_rating_sites/category/?id=<?=$id?>' class='button-o'><?=lg('Отмена')?></a>
        </div>
        <?
  
      }
      
    }
    
    ?>
    <?php if (user('ID') > 0) : ?>
    <div class='list'>
    <?php if (MANAGEMENT == 1) : ?>
    <a href='/m/top_rating_sites/settings/' class='btn'><?=icons('gear', 15)?> <?=lg('Админка')?></a>
    <a href='/m/top_rating_sites/category/?id=<?=$id?>&get=edit' class='btn'><?=icons('pencil', 15)?> <?=lg('Редактировать')?></a>
    <a href='/m/top_rating_sites/category/?id=<?=$id?>&get=delete&<?=TOKEN_URL?>' class='btn'><?=icons('trash', 15)?> <?=lg('Удалить')?></a>
    <?php endif ?>
    <a href='/m/top_rating_sites/add/' class='btn'><?=icons('plus', 15)?> <?=lg('Добавить сайт')?></a>
    <a href='/m/top_rating_sites/my/' class='btn-o'><?=icons('link', 15)?> <?=lg('Мои сайты')?></a>
    </div>
    <?php endif ?>

    <div class='list'>
    <?=lg('Сайты категории')?> <b><?=lg(tabs($cat['NAME']))?></b>
    </div>
    <?
    
    $column = db::get_column("SELECT COUNT(*) FROM `TRS_SITES` WHERE `ACT` = '1' AND `ID_CATEGORY` = ?", [$id]);
    $spage = spage($column, PAGE_SETTINGS);
    $page = page($spage);
    $limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;
    
    if ($column == 0){ 
      
      html::empty('Пока пусто');
    
    }else{
      
      ?><div class='list-body'><?
      
    }
    
    $data = db::get_string_all("SELECT * FROM `TRS_SITES` WHERE `ACT` = '1' AND `ID_CATEGORY` = ? ORDER BY `TIME` DESC LIMIT ".$limit.", ".PAGE_SETTINGS, [$id]);
    while ($list = $data->fetch()) {
      
      require (ROOT.'/modules/top_rating_sites/plugins/list.php');
      echo $trs_list;
    
    }
    
    if ($column > 0){ 
      
      ?></div><?
      
    }
    
    get_page('/m/top_rating_sites/category/?id='.$id.'&', $spage, $page, 'list');
    
    require (ROOT.'/modules/top_rating_sites/plugins/vip.php');
    
    back('/m/top_rating_sites/category/');
    acms_footer();
    
  }
  
}

/*
---------------
Добавить раздел
---------------
*/
  
if (MANAGEMENT == 1 && get('get') == 'add'){
  
  if (post('ok')){
    
    valid::create(array(
      
      'CAT_NAME' => ['name', 'text', [3, 200], 'Название', 0]
    
    ));
    
    if (db::get_column("SELECT COUNT(*) FROM `TRS_CATEGORIES` WHERE `NAME` = ? LIMIT 1", [CAT_NAME]) > 0){
      
      error('Категория с таким названием уже существует');
      redirect('/m/top_rating_sites/category/?get=add');
    
    }
    
    if (ERROR_LOG == 1){
      
      redirect('/m/top_rating_sites/category/?get=add');
    
    }
    
    $ID = db::get_add("INSERT INTO `TRS_CATEGORIES` (`NAME`) VALUES (?)", [CAT_NAME]);
    
    success('Категория успешно добавлена');
    redirect('/m/top_rating_sites/category/');
    
  }
  
  ?>
  <div class='list'>
  <form method='post' class='ajax-form' action='/m/top_rating_sites/category/?get=add'>  
  <?=html::input('name', 'Название', null, null, null, 'form-control-100', 'text', null, 'folder-open')?>
  <?=html::button('button ajax-button', 'ok', 'plus', 'Добавить')?>
  <a class='button-o' href='/m/top_rating_sites/category/'><?=lg('Отмена')?></a>
  </form>
  </div>
  <?
  
  back('/m/top_rating_sites/category/');
  acms_footer();
  
}

/*
----------------
Список категорий
----------------
*/
  
if (MANAGEMENT == 1) {
  
  ?>
  <div class='list'>
  <a href='/m/top_rating_sites/category/?get=add' class='btn'><?=icons('plus', 15, 'fa-fw')?> <?=lg('Добавить категорию')?></a>
  </div>
  <?

}

$column = db::get_column("SELECT COUNT(*) FROM `TRS_CATEGORIES`");
$spage = spage($column, PAGE_SETTINGS);
$page = page($spage);
$limit = PAGE_SETTINGS * $page - PAGE_SETTINGS;

if ($column == 0){ 
  
  html::empty('Пока нет категорий');
  
}else{
  
  ?><div class='list-body'><?
  
}

$data = db::get_string_all("SELECT * FROM `TRS_CATEGORIES` ORDER BY `ID` DESC LIMIT ".$limit.", ".PAGE_SETTINGS);
while ($list = $data->fetch()) {
  
  ?>
  <a href='/m/top_rating_sites/category/?id=<?=$list['ID']?>'>
  <div class='list-menu hover'>
  <?=icons('folder-open', 17, 'fa-fw')?> <?=lg(tabs($list['NAME']))?> <span class='count'><?=db::get_column("SELECT COUNT(*) FROM `TRS_SITES` WHERE `ACT` = '1' AND `ID_CATEGORY` = ?", [$list['ID']])?></span>
  </div>
  </a>
  <?
  
}

if ($column > 0){ 
  
  ?></div><?
  
}

get_page('/m/top_rating_sites/category/?', $spage, $page, 'list');

back('/', 'На главную');
acms_footer();