<?php
acms_header('Редактировать сайт', 'users');
is_active_module('PRIVATE_TRS');
$site = db::get_string("SELECT * FROM `TRS_SITES` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);

if (!isset($site['ID'])) {
  
  error('Неверная директива');
  redirect('/m/top_rating_sites/');

}

if (MANAGEMENT == 0 && $site['USER_ID'] != user('ID')){
  
  error('Нет прав');
  redirect('/m/top_rating_sites/');
  
}

if (post('ok_site')){
  
  valid::create(array(
    
    'TRS_NAME' => ['name', 'text', [2, 40], 'Название сайта', 0],
    'TRS_MESSAGE' => ['message', 'text', [0, 80], 'Описание сайта', 0],
    'TRS_CATEGORY' => ['id_cat', 'number', [0, 99999], 'Раздел']
  
  ));
  
  if (ERROR_LOG == 1){
    
    redirect('/m/top_rating_sites/edit/?id='.$site['ID']);
  
  }
  
  db::get_set("UPDATE `TRS_SITES` SET `NAME` = ?, `ID_CATEGORY` = ?, `MESSAGE` = ? WHERE `ID` = ? LIMIT 1", [TRS_NAME, TRS_CATEGORY, TRS_MESSAGE, $site['ID']]);
  
  success('Изменения успешно приняты');
  redirect('/m/top_rating_sites/show/?id='.$site['ID']);
  
}

?>
<div class='list'><?=lg('Редактирование сайта')?> <a target='_blank' href='<?=tabs($site['DOMAIN'])?>' ajax='no'><b><?=tabs($site['DOMAIN'])?></b></a></div>
<div class='list'>
<form method='post' class='ajax-form' action='/m/top_rating_sites/edit/?id=<?=$site['ID']?>'>
<?=html::input('name', 'Название сайта', null, null, tabs($site['NAME']), 'form-control-100', 'text', null, 'text-width')?>  
<?=html::input('message', 'Описание сайта', null, null, tabs($site['MESSAGE']), 'form-control-100', 'text', null, 'text-width')?>
<?
$array = array();
$array[0] = ['Без категории', 0];
$data = db::get_string_all("SELECT * FROM `TRS_CATEGORIES` ORDER BY `ID` DESC");  
while ($list = $data->fetch()){
  
  $array[$list['ID']] = [tabs($list['NAME']), ($site['ID_CATEGORY'] == $list['ID'] ? "selected" : null)];

}
?>
<?=html::select('id_cat', $array, 'Категория', 'form-control-100-modify-select', 'folder-open')?>
<?=html::button('button ajax-button', 'ok_site', 'save', 'Сохранить')?>
<a class='button-o' href='/m/top_rating_sites/show/?id=<?=$site['ID']?>'><?=lg('Отмена')?></a>
<form>
</div>
<?
  
back('/m/top_rating_sites/show/?id='.$site['ID']);
acms_footer();