<?php
$site = db::get_string("SELECT * FROM `TRS_SITES` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
$cat = db::get_string("SELECT `ID`,`NAME` FROM `TRS_CATEGORIES` WHERE `ID` = ? LIMIT 1", [$site['ID_CATEGORY']]);
acms_header(lg('Сайт - %s', tabs($site['NAME'])), 'users');
is_active_module('PRIVATE_TRS');

if (!isset($site['ID'])) {
  
  error('Неверная директива');
  redirect('/m/top_rating_sites/');

}

if (MANAGEMENT == 0 && $site['USER_ID'] != user('ID')){
  
  error('Нет прав');
  redirect('/m/top_rating_sites/');
  
}

if ($site['ACT'] != 2 || MANAGEMENT == 1){
  
  require (ROOT.'/modules/top_rating_sites/plugins/delete.php');
  
}

if (get('block') == "ok" && $site['ACT'] != 2){
  
  get_check_valid();
  
  messages::get(config('SYSTEM'), $site['USER_ID'], lg('Сожалеем, но ваш сайт был заблокирован в ТОП рейтинге. %s', '[url=/m/top_rating_sites/show/?id='.$site['ID'].']'.lg('Смотреть').'[/url]'), 0);
  db::get_set("UPDATE `TRS_SITES` SET `ACT` = '2' WHERE `ID` = ? LIMIT 1", [$site['ID']]);
  
  redirect('/m/top_rating_sites/show/?id='.$site['ID']);
  
}

if (get('block') == "no" && $site['ACT'] == 2){
  
  get_check_valid();
  
  messages::get(config('SYSTEM'), $site['USER_ID'], lg('Ваш сайт был разблокирован в ТОП рейтинге. %s', '[url=/m/top_rating_sites/show/?id='.$site['ID'].']'.lg('Смотреть').'[/url]'), 0);
  db::get_set("UPDATE `TRS_SITES` SET `ACT` = '1' WHERE `ID` = ? LIMIT 1", [$site['ID']]);
  
  redirect('/m/top_rating_sites/show/?id='.$site['ID']);
  
}

$banner = intval(get('banner'));

if ($banner >= 1 && $banner <= 8) {
  
  db::get_set("UPDATE `TRS_SITES` SET `BANNER` = ? WHERE `ID` = ? LIMIT 1", [$banner, $site['ID']]);
  
  success('Дизайн баннера успешно сменен');
  redirect('/m/top_rating_sites/show/?id='.$site['ID']);
  
}

if (get('get') == 'i' && $site['ACT'] == 0) {
  
  function isDomainAvailible($domain) {
    
    $curlInit = curl_init($domain);
    curl_setopt($curlInit,CURLOPT_CONNECTTIMEOUT,10);
    curl_setopt($curlInit,CURLOPT_HEADER,false);
    curl_setopt($curlInit,CURLOPT_NOBODY,false);
    curl_setopt($curlInit,CURLOPT_RETURNTRANSFER,true);
    $response = curl_exec($curlInit);
    curl_close($curlInit);
    
    return $response;
  
  }
  
  if (isDomainAvailible(tabs($site['DOMAIN']).'/'.tabs($site['TOKEN']).'.txt') != tabs($site['TOKEN'])) {
    
    error('Не удалось найти файл на вашем сайте');
    redirect('/m/top_rating_sites/show/?id='.$site['ID']);
  
  }
  
  messages::get(config('SYSTEM'), 1, lg('В ТОП рейтинг добавлен новый сайт. %s', '[url=/m/top_rating_sites/show/?id='.$site['ID'].']'.lg('Смотреть').'[/url]'), 0);
  
  db::get_set("UPDATE `TRS_SITES` SET `ACT` = ? WHERE `ID` = ? LIMIT 1", [1, $site['ID']]);
  
  success('Сайт успешно подтвержден');
  redirect('/m/top_rating_sites/show/?id='.$site['ID']);
  
}

?>  
<div class='list'><center><b><?=tabs($site['NAME'])?></b><br /><a ajax='no' href='<?=tabs($site['DOMAIN'])?>'><?=tabs($site['DOMAIN'])?></a></center></div>
  
<div class='list'>
<a href='/m/top_rating_sites/edit/?id=<?=$site['ID']?>' class='btn'><?=icons('edit', 15, 'fa-fw')?> <?=lg('Редактировать')?></a>
<?php if ($site['ACT'] != 2 || MANAGEMENT == 1) : ?>
<a href='/m/top_rating_sites/show/?id=<?=$site['ID']?>&get=delete&<?=TOKEN_URL?>' class='btn'><?=icons('trash', 15, 'fa-fw')?> <?=lg('Удалить')?></a>
<?php endif ?>
<?php if ($site['ACT'] == 2 && MANAGEMENT == 1) : ?>
<a href='/m/top_rating_sites/show/?id=<?=$site['ID']?>&block=no&<?=TOKEN_URL?>' class='btn'><?=icons('ban', 15, 'fa-fw')?> <?=lg('Разблокировать')?></a>
<?php elseif ($site['ACT'] != 2 && MANAGEMENT == 1) : ?>
<a href='/m/top_rating_sites/show/?id=<?=$site['ID']?>&block=ok&<?=TOKEN_URL?>' class='btn'><?=icons('ban', 15, 'fa-fw')?> <?=lg('Заблокировать')?></a>
<?php endif ?>
<a href='/m/top_rating_sites/statistic/?id=<?=$site['ID']?>' class='btn'><?=icons('line-chart', 15, 'fa-fw')?> <?=lg('Статистика')?></a>
<?php if ($site['ACT'] == 1) : ?>
<a href='/m/top_rating_sites/vip/?id=<?=$site['ID']?>' class='btn'><?=icons('diamond', 16, 'fa-fw')?> <?=lg('Купить/продлить VIP')?></a>
<?php endif ?>
</div>

<div class='list'>
<b><?=lg('Подтверждение сайта')?></b><br /><br />
<?php if ($site['ACT'] == 2) : ?>
<font color='red'><?=icons('times', 15, 'fa-fw')?> <?=lg('Сайт заблокирован администрацией')?></font>
<?php elseif ($site['ACT'] == 0) : ?>
<?=lg('Для подтверждения сайта разместите файл в корневой директории вашего сайта')?> <b><?=tabs($site['TOKEN'])?>.txt</b> [<a href='/files/upload/top_rating_sites/<?=tabs($site['TOKEN'])?>.txt' ajax='no' download><?=lg('Скачать')?></a>]<br /><br />
<small><?=lg('Как должно получиться')?>: <a href='<?=tabs($site['DOMAIN'])?>/<?=tabs($site['TOKEN'])?>.txt' ajax='no'><?=tabs($site['DOMAIN'])?>/<?=tabs($site['TOKEN'])?>.txt</a></small><br /><br />
<a href='/m/top_rating_sites/show/?id=<?=$site['ID']?>&<?=TOKEN_URL?>&get=i' class='btn'><?=icons('search', 15, 'fa-fw')?> <?=lg('Проверить')?></a>
<?php else : ?>
<font color='green'><?=icons('check', 15, 'fa-fw')?> <?=lg('Сайт успешно подтвержден')?></font>
<?php endif ?>
</div>

<?php if ($site['ACT'] == 1) : ?>
<div class='list'>
<b><?=lg('Размещение баннера')?></b><br /><br />
<?=lg('Код баннера для главной страницы')?>:<br />
<textarea class='form-control-100' style='padding-left: 10px; height: 90px; resize: none'><iframe src="https://<?=tabs(HTTP_HOST)?>/services/top_rating_sites/?type=big&site_id=<?=$site['ID']?>" frameborder="0" scrolling="no" width="95" height="45"></iframe></textarea><br />
<iframe src="https://<?=tabs(HTTP_HOST)?>/services/top_rating_sites/?type=big&site_id=<?=$site['ID']?>&view=blocked" frameborder="0" scrolling="no" width="95" height="45"></iframe><br /><br />
<?=lg('Код баннера для остальных страниц')?>:<br />
<textarea class='form-control-100' style='padding-left: 10px; height: 90px; resize: none'><iframe src="https://<?=tabs(HTTP_HOST)?>/services/top_rating_sites/?type=small&site_id=<?=$site['ID']?>" frameborder="0" scrolling="no" width="95" height="25"></iframe></textarea><br />
<iframe src="https://<?=tabs(HTTP_HOST)?>/services/top_rating_sites/?type=small&site_id=<?=$site['ID']?>&view=blocked" frameborder="0" scrolling="no" width="95" height="25"></iframe><br /><br />

<?=lg('Вы можете сменить дизайн баннеров:')?><br />

<div style='margin-top: 17px; display: inline-block; width: 100px; height: 80px; text-align: center'>
<iframe src="https://<?=tabs(HTTP_HOST)?>/services/top_rating_sites/?type=big&site_id=<?=$site['ID']?>&color=1&view=blocked" frameborder="0" scrolling="no" width="95" height="45"></iframe><br />
<a href='/m/top_rating_sites/show/?id=<?=$site['ID']?>&banner=1&<?=TOKEN_URL?>' class='btn'><?=lg('Выбрать')?></a>
</div> 
  
<div style='margin-top: 17px; display: inline-block; width: 100px; height: 80px; text-align: center'>
<iframe src="https://<?=tabs(HTTP_HOST)?>/services/top_rating_sites/?type=big&site_id=<?=$site['ID']?>&color=2&view=blocked" frameborder="0" scrolling="no" width="95" height="45"></iframe><br />
<a href='/m/top_rating_sites/show/?id=<?=$site['ID']?>&banner=2&<?=TOKEN_URL?>' class='btn'><?=lg('Выбрать')?></a>
</div>
  
<div style='margin-top: 17px; display: inline-block; width: 100px; height: 80px; text-align: center'>
<iframe src="https://<?=tabs(HTTP_HOST)?>/services/top_rating_sites/?type=big&site_id=<?=$site['ID']?>&color=3&view=blocked" frameborder="0" scrolling="no" width="95" height="45"></iframe><br />
<a href='/m/top_rating_sites/show/?id=<?=$site['ID']?>&banner=3&<?=TOKEN_URL?>' class='btn'><?=lg('Выбрать')?></a>
</div>
  
<div style='margin-top: 17px; display: inline-block; width: 100px; height: 80px; text-align: center'>
<iframe src="https://<?=tabs(HTTP_HOST)?>/services/top_rating_sites/?type=big&site_id=<?=$site['ID']?>&color=4&view=blocked" frameborder="0" scrolling="no" width="95" height="45"></iframe><br />
<a href='/m/top_rating_sites/show/?id=<?=$site['ID']?>&banner=4&<?=TOKEN_URL?>' class='btn'><?=lg('Выбрать')?></a>
</div>
  
<div style='margin-top: 17px; display: inline-block; width: 100px; height: 80px; text-align: center'>
<iframe src="https://<?=tabs(HTTP_HOST)?>/services/top_rating_sites/?type=big&site_id=<?=$site['ID']?>&color=5&view=blocked" frameborder="0" scrolling="no" width="95" height="45"></iframe><br />
<a href='/m/top_rating_sites/show/?id=<?=$site['ID']?>&banner=5&<?=TOKEN_URL?>' class='btn'><?=lg('Выбрать')?></a>
</div>
  
<div style='margin-top: 17px; display: inline-block; width: 100px; height: 80px; text-align: center'>
<iframe src="https://<?=tabs(HTTP_HOST)?>/services/top_rating_sites/?type=big&site_id=<?=$site['ID']?>&color=6&view=blocked" frameborder="0" scrolling="no" width="95" height="45"></iframe><br />
<a href='/m/top_rating_sites/show/?id=<?=$site['ID']?>&banner=6&<?=TOKEN_URL?>' class='btn'><?=lg('Выбрать')?></a>
</div>
  
<div style='margin-top: 17px; display: inline-block; width: 100px; height: 80px; text-align: center'>
<iframe src="https://<?=tabs(HTTP_HOST)?>/services/top_rating_sites/?type=big&site_id=<?=$site['ID']?>&color=7&view=blocked" frameborder="0" scrolling="no" width="95" height="45"></iframe><br />
<a href='/m/top_rating_sites/show/?id=<?=$site['ID']?>&banner=7&<?=TOKEN_URL?>' class='btn'><?=lg('Выбрать')?></a>
</div>
  
<div style='margin-top: 17px; display: inline-block; width: 100px; height: 80px; text-align: center'>
<iframe src="https://<?=tabs(HTTP_HOST)?>/services/top_rating_sites/?type=big&site_id=<?=$site['ID']?>&color=8&view=blocked" frameborder="0" scrolling="no" width="95" height="45"></iframe><br />
<a href='/m/top_rating_sites/show/?id=<?=$site['ID']?>&banner=8&<?=TOKEN_URL?>' class='btn'><?=lg('Выбрать')?></a>
</div>
  
</div>
<?php endif ?>
  
<div class='list'>
<b><?=lg('Общая информация')?></b><br /><br />
<?=lg('Создал')?>: <?=user::login($site['USER_ID'], 0, 1)?><br />
<?=lg('Создан')?>: <?=ftime($site['TIME'])?><br />
<?=lg('Название')?>: <?=tabs($site['NAME'])?><br />
<?=lg('Описание')?>: <?=tabs($site['MESSAGE'])?><br />
<?=lg('Сайт')?>: <a ajax='no' href='<?=tabs($site['DOMAIN'])?>'><?=tabs($site['DOMAIN'])?></a>
<?php if (isset($cat['ID']) && $site['ACT'] == 1) : ?>
<br />
<?=lg('Категория')?>: <a href='/m/top_rating_sites/category/?id=<?=$cat['ID']?>'><?=tabs($cat['NAME'])?></a>
<?php endif ?>
</div>
<?

back('/m/top_rating_sites/');
acms_footer();