<?php
$site = db::get_string("SELECT * FROM `TRS_SITES` WHERE `ID` = ? AND `ACT` = '1' LIMIT 1", [intval(get('id'))]);
$cat = db::get_string("SELECT `ID`,`NAME` FROM `TRS_CATEGORIES` WHERE `ID` = ? LIMIT 1", [$site['ID_CATEGORY']]);
acms_header(lg('Статистика сайта', tabs($site['NAME'])));
is_active_module('PRIVATE_TRS');

if (!isset($site['ID'])) {
  
  error('Неверная директива');
  redirect('/m/top_rating_sites/');

}

$today_date = date("Y-m-d");
$today = db::get_string("SELECT `HOST`,`HIT` FROM `TRS_DATA` WHERE `DATE` = ? AND `SITE_ID` = ? LIMIT 1", [$today_date, $site['ID']]);

$yesterday_date = date('Y-m-d', (strtotime( '-1 day' , strtotime(date("Y-m-d")))));
$yesterday = db::get_string("SELECT `HOST`,`HIT` FROM `TRS_DATA` WHERE `DATE` = ? AND `SITE_ID` = ? LIMIT 1", [$yesterday_date, $site['ID']]);

if (!isset($yesterday['HOST'])) {
  
  $yesterday['HOST'] = lg('Сайт не состоял вчера в ТОПЕ');
  $yesterday['HIT'] = 0;
  
}

$weekend_host = 0;
$weekend_hit = 0;
$weekend_data = db::get_string_all("SELECT `HOST`,`HIT` FROM `TRS_DATA` WHERE `SITE_ID` = ? ORDER BY `ID` DESC LIMIT 7", [$site['ID']]);
while ($weekend_list = $weekend_data->fetch()) {
  
  $weekend_host += $weekend_list['HOST'];
  $weekend_hit += $weekend_list['HIT'];
  
}

$month_host = 0;
$month_hit = 0;
$month_data = db::get_string_all("SELECT `HOST`,`HIT` FROM `TRS_DATA` WHERE `SITE_ID` = ? ORDER BY `ID` DESC LIMIT 30", [$site['ID']]);
while ($month_list = $month_data->fetch()) {
  
  $month_host += $month_list['HOST'];
  $month_hit += $month_list['HIT'];
  
}

$year_host = 0;
$year_hit = 0;
$year_data = db::get_string_all("SELECT `HOST`,`HIT` FROM `TRS_DATA` WHERE `SITE_ID` = ? ORDER BY `ID` DESC LIMIT 360", [$site['ID']]);
while ($year_list = $year_data->fetch()) {
  
  $year_host += $year_list['HOST'];
  $year_hit += $year_list['HIT'];
  
}

?>
<div class='list'>
<center>
<font size='+1'><b><?=lg('Статистика сайта')?> "<?=tabs($site['NAME'])?>"</b></font><br />
<img src='https://www.google.com/s2/favicons?domain=<?=tabs($site['DOMAIN'])?>' style='position: relative; top: 2px'> <a target='_blank' href='<?=tabs($site['DOMAIN'])?>' ajax='no'><?=tabs($site['DOMAIN'])?></a><br /><br />
<?=tabs($site['MESSAGE'])?><br /><br />
<img src='https://mini.s-shot.ru/?<?=tabs($site['DOMAIN'])?>' style='max-width: 280px'>
</center>
</div>

<div class='list'>
<font size='+1'><?=lg('За сегодня')?></font><br /><br />
<?=icons('eye', 15, 'fa-fw')?> <?=lg('Посещений')?>: <b><?=$today['HOST']?></b><br />
<?=icons('mail-forward', 15, 'fa-fw')?> <?=lg('Переходов')?>: <b><?=$today['HIT']?></b>
</div>
  
<div class='list'>
<font size='+1'><?=lg('За вчера')?></font><br /><br />
<?=icons('eye', 15, 'fa-fw')?> <?=lg('Посещений')?>: <b><?=$yesterday['HOST']?></b><br />
<?=icons('mail-forward', 15, 'fa-fw')?> <?=lg('Переходов')?>: <b><?=$yesterday['HIT']?></b>
</div>
  
<div class='list'>
<font size='+1'><?=lg('За неделю')?></font><br /><br />
<?=icons('eye', 15, 'fa-fw')?> <?=lg('Посещений')?>: <b><?=$weekend_host?></b><br />
<?=icons('mail-forward', 15, 'fa-fw')?> <?=lg('Переходов')?>: <b><?=$weekend_hit?></b>
</div>
  
<div class='list'>
<font size='+1'><?=lg('За месяц')?></font><br /><br />
<?=icons('eye', 15, 'fa-fw')?> <?=lg('Посещений')?>: <b><?=$month_host?></b><br />
<?=icons('mail-forward', 15, 'fa-fw')?> <?=lg('Переходов')?>: <b><?=$month_hit?></b>
</div>

<div class='list'>
<font size='+1'><?=lg('За год')?></font><br /><br />
<?=icons('eye', 15, 'fa-fw')?> <?=lg('Посещений')?>: <b><?=$year_host?></b><br />
<?=icons('mail-forward', 15, 'fa-fw')?> <?=lg('Переходов')?>: <b><?=$year_hit?></b>
</div>
  
<div class='list'>
<font size='+1'><?=lg('Дополнительная информация')?></font><br /><br />
<?=lg('Создан')?>: <?=ftime($site['TIME'])?>
<?php if (isset($cat['ID']) && $site['ACT'] == 1) : ?>
<br />
<?=lg('Категория')?>: <a href='/m/top_rating_sites/category/?id=<?=$cat['ID']?>'><?=tabs($cat['NAME'])?></a>
<?php endif ?>
</div>
<?
  
back('/m/top_rating_sites/');
acms_footer();