<?php 
require_once ($_SERVER['DOCUMENT_ROOT'].'/system/connections/core.php');  
  
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");
header("Cache-Control: no-cache, must-revalidate");
header("Pragma: no-cache");

$site = db::get_string("SELECT `ID`,`BANNER`,`DOMAIN` FROM `TRS_SITES` WHERE `ID` = ? AND `ACT` = ? LIMIT 1", [intval(get('site_id')), 1]);

if (!isset($site['ID']) || config('PRIVATE_TRS') == 0 || get('type') != 'big' && get('type') != 'small') { exit; }

$color = $site['BANNER'];
if (intval(get('color')) >= 1 && intval(get('color')) <= 8) { $color = intval(get('color')); }

if ($color == 1) {
  
  $c = 'linear-gradient(to top left, #70C0FF, #3257E9)';
  
}elseif ($color == 2) {
  
  $c = 'linear-gradient(to top left, #ED81FF, #9237BE)';
  
}elseif ($color == 3) {
  
  $c = 'linear-gradient(to top left, #54E09C, #3CAD36)';
  
}elseif ($color == 4) {
  
  $c = 'linear-gradient(to top left, #ECF15C, #A2B926)';
  
}elseif ($color == 5) {
  
  $c = 'linear-gradient(to top left, #FFC568, #E97F2D)';
  
}elseif ($color == 6) {
  
  $c = 'linear-gradient(to top left, #FF7569, #F53159)';
  
}elseif ($color == 7) {
  
  $c = 'linear-gradient(to top left, #58666D, #334249)';
  
}elseif ($color == 8) {
  
  $c = 'linear-gradient(to top left, #5BC2CC, #268B94)';
  
}

if (get('view') != 'blocked') {
  
  $visitor_ip = IP;
  $date = date("Y-m-d");
  
  if (db::get_column("SELECT COUNT(*) FROM `TRS_DATA` WHERE `DATE` = ? AND `SITE_ID` = ? LIMIT 1", [$date, $site['ID']]) == 0) {
    
    db::get_add("INSERT INTO `TRS_DATA` (`DATE`, `SITE_ID`) VALUES (?, ?)", [$date, $site['ID']]);
  
  }
  
  $trs_data = db::get_string("SELECT `HOST`,`HIT`,`ID` FROM `TRS_DATA` WHERE `DATE` = ? AND `SITE_ID` = ? LIMIT 1", [$date, $site['ID']]);
  
  if (db::get_column("SELECT COUNT(*) FROM `TRS_VISIT` WHERE `IP` = ? AND `SITE_ID` = ? LIMIT 1", [$visitor_ip, $site['ID']]) == 0) {
    
    db::get_add("INSERT INTO `TRS_VISIT` (`DATE`, `SITE_ID`, `IP`) VALUES (?, ?, ?)", [$date, $site['ID'], $visitor_ip]);
    db::get_set("UPDATE `TRS_DATA` SET `HOST` = `HOST` + '1', `HIT` = `HIT` + '1' WHERE `ID` = ? LIMIT 1", [$trs_data['ID']]);
  
  }else{

    db::get_set("UPDATE `TRS_DATA` SET `HIT` = `HIT` + '1' WHERE `SITE_ID` = ? AND `DATE` = ? LIMIT 1", [$site['ID'], $date]);
  
  }
  
}else{
  
  $trs_data['HOST'] = 0;
  $trs_data['HIT'] = 0;
  
}
  
?>
<?php if (get('type') == 'big') : ?>
<a target='_blank' href='https://<?=HTTP_HOST?>/m/top_rating_sites/' title='<?=config('TRS_TITLE')?>'>
<div style="font-family: 'Montserrat', sans-serif; position: relative; display: inline-block; background: <?=$c?>; width: 85px; height: 35px; border: 1px #58686E solid; box-sizing: border-box">
<span style='display: inline-block; color: white; padding: 1px 0.4em; font-size: 9px'><?=config('TRS_NAME')?></span>
<span style='display: inline-block; color: white; font-size: 9px; font-weight: bold; position: absolute; top: 13px; left: 5px'><?=$trs_data['HOST']?></span>
<span style='display: inline-block; color: white; font-size: 9px; font-weight: bold; position: absolute; top: 22px; left: 5px'><?=$trs_data['HIT']?></span>
<img src='/services/top_rating_sites/top.png' style='position: absolute; right: 5px; max-width: 14px; top: 14px'>
</div>
</a>
<?php endif ?>
  
<?php if (get('type') == 'small') : ?>
<a target='_blank' href='https://<?=HTTP_HOST?>/m/top_rating_sites/' title='<?=config('TRS_TITLE')?>'>
<div style="font-family: 'Montserrat', sans-serif; position: relative; display: inline-block; background: <?=$c?>; width: 85px; height: 15px; border: 1px #58686E solid; box-sizing: border-box">
<span style='display: inline-block; color: white; padding: 2px 0.4em; font-size: 9px'><?=config('TRS_NAME')?></span>
<img src='/services/top_rating_sites/top.png' style='position: absolute; right: 4px; max-width: 10px; top: 1.5px'>
</div>
</a>
<?php endif ?>