<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

$apac = new apacserver();
$server = new server();
$webserver = new webserver();
$username = htmlspecialchars($allvar['login']);
$user_edit = htmlspecialchars($allvar['user_edit']);

if ($allvar['apifull'] == 'y') {
	$apac->g_root_right = 'y';
}
else {
	$apac->g_root_right = 'n';
}

if (!empty($user_edit) && ($allvar['apifull'] == 'y')) {
	$username = $user_edit;
}
else if (empty($user_edit)) {
	$username = $username;
}
else {
	$mas['code'] = 400;
	$mas['message'] = $lang['bindserver_not_root'];
	echo json_encode($mas);
	exit();
}

$conf_user = $server->config_read($GLOBALS['USERS_PATH'] . $username);
$domain = $apac->apacserver_get_site($username);
$apac->g_username = $username;
$list_www = $apac->apacserver_get_www_table_html($username);

foreach ($list_www as $key => $val) {
	$new_mas_www[$val[0]]['name'] = $val[1];
	$new_mas_www[$val[0]]['type'] = $val[2];
	$new_mas_www[$val[0]]['forwarding'] = $val[3];
	$new_mas_www[$val[0]]['domain'] = $val[4];
	$new_mas_www[$val[0]]['unic_id'] = $val[5];
}

switch ($subdo) {
case 'set_password':
	$json = $apac->apacserver_save_directory_password($allvar['directory'], $username, $allvar['password'], '', $allvar['user_login']);
	echo json_encode($json);
	break;

case 'delete_password':
	$directory = $apac->makesafepath_and_check($conf_user['rootdir'] . '/' . $allvar['directory']);

	if ($directory == -1) {
		$res['code'] = 100;
		$res['message'] = $lang['apacserver_dir_safe'];
		echo json_encode($res);
		exit();
	}

	$json = $apac->apacserver_delete_directory_password($allvar['directory'], '');

	if ($json['code'] == 0) {
		$json['message'] = $lang['msg_apac_ok'];
		echo json_encode($json);
		exit();
	}
	else {
		echo json_encode($json);
		exit();
	}

	break;

case 'list_directory':
	$out = $apac->apacserver_get_directory_table_html($username);

	if ($out) {
		$res['code'] = 0;
		$res['message'] = $lang['apacserver_list_directory'];
		$res['detail'] = $out;
		echo json_encode($res);
		exit();
	}
	else {
		$res['code'] = 100;
		$res['message'] = $lang['apacserver_list_not_directory'];
		echo json_encode($res);
		exit();
	}

	break;

case 'list_http':
	if ($domain) {
		$res['code'] = 0;
		$res['message'] = $lang['apacserver_list_http'];
		$res['detail'] = $domain;
		echo json_encode($res);
		exit();
	}
	else {
		$res['code'] = 100;
		$res['message'] = $lang['apacserver_none_list_http'];
		echo json_encode($res);
		exit();
	}

	break;

case 'list_directory_http':
	$out = $apac->apacserver_get_http_table($username);

	foreach ($out as $key => $val) {
		$new_mas[$val[0]]['user'] = $val[1];
		$new_mas[$val[0]]['http'] = $val[2];
		$new_mas[$val[0]]['unic_id'] = $val[3];
	}

	if ($out) {
		$res['code'] = 0;
		$res['message'] = $lang['apacserver_list_directory_http'];
		$res['detail'] = $new_mas;
		echo json_encode($res);
		exit();
	}
	else {
		$res['code'] = 100;
		$res['message'] = $lang['apacserver_none_list_directory_http'];
		echo json_encode($res);
		exit();
	}

	break;

case 'delete_http':
	if (!in_array($allvar['site'], $domain)) {
		$res['code'] = 100;
		$res['message'] = $lang['apacserver_not_remove'];
		$res['detail'] = $domain;
		echo json_encode($res);
		exit();
	}

	echo json_encode($apac->apacserver_delete_http($allvar['site'], $username, $allvar['uniq_id']));
	break;

case 'add_http':
	if (!in_array($allvar['site'], $domain)) {
		$res['code'] = 100;
		$res['message'] = $lang['apacserver_not_remove'];
		$res['detail'] = $domain;
		echo json_encode($res);
		exit();
	}

	$type = array('http', 'https');
	if (empty($allvar['type']) || !in_array($allvar['type'], $type)) {
		$res['code'] = 101;
		$res['message'] = $lang['apacserver_not_type'];
		$res['detail'] = $type;
		echo json_encode($res);
		exit();
	}

	$json = $apac->apacserver_save_http($allvar['site'], $username, $allvar['type']);
	break;

case 'list_www':
	if ($new_mas_www) {
		$res['code'] = 0;
		$res['message'] = $lang['apacserver_list_forwarding'];
		$res['detail'] = $new_mas_www;
		echo json_encode($res);
		exit();
	}
	else {
		$res['code'] = 100;
		$res['message'] = $lang['apacserver_not_list_forwarding'];
		echo json_encode($res);
		exit();
	}

	break;

case 'delete_www':
	foreach ($new_mas_www as $key => $val) {
		if ($allvar['uniq_id'] == $val['unic_id']) {
			$json = $apac->apacserver_delete_www($key, $val['name'], $val['type'], $val['domain'], $val['unic_id']);
		}
	}

	if ($json) {
		echo json_encode($json);
	}
	else {
		$res['code'] = 100;
		$res['message'] = $lang['apacserver_not_unic_id'];
		echo json_encode($res);
		exit();
	}

	break;

case 'add_www':
	if (!in_array($allvar['domain'], $domain)) {
		$res['code'] = 101;
		$res['message'] = $lang['apacserver_not_domain'];
		$res['detail'] = $domain;
		echo json_encode($res);
		exit();
	}

	$array_forvard = array('www', 'no_www', 'both_www');

	if (!in_array($allvar['select_www'], $array_forvard)) {
		$res['code'] = 102;
		$res['message'] = $lang['apacserver_not_forward'];
		$res['detail'] = $array_forvard;
		echo json_encode($res);
		exit();
	}

	if (!$allvar['site_forwarding']) {
		$res['code'] = 103;
		$res['message'] = $lang['apacserver_not_path_forward'];
		echo json_encode($res);
		exit();
	}

	if (!$allvar['draft']) {
		$draft = 'false';
	}
	else {
		$draft = 'true';
	}

	$json = $apac->apacserver_save_www($allvar['select_www'], $allvar['domain'], $allvar['src'], $username, $draft, $allvar['site_forwarding']);
	echo json_encode($json);
	break;
}

?>
