<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

$backup = new backup();
$username = htmlspecialchars($allvar['login']);
$user_edit = htmlspecialchars($allvar['user_edit']);

if (!empty($user_edit) && ($allvar['apifull'] == 'y')) {
	$username = $user_edit;
}
else if (empty($user_edit)) {
	$username = $username;
}
else {
	$mas['code'] = 400;
	$mas['message'] = $lang['bindserver_not_root'];
	echo json_encode($mas);
	exit();
}

$conf_user = $server->config_read($GLOBALS['USERS_PATH'] . $username);
$conf_user['name'] = $conf_user['username'];
$remote_local = array('local', 'remote');
$compression = array('incr_noarch', 'tar', 'simple_noarch');
$period = array('day', 'week', 'month');
$type_auth = array('key', 'pass');

switch ($subdo) {
case 'generate_key':
	$out = $backup->generatekeyrsa($conf_user);

	if (($out['status'] == 'done') && !empty($out['raw_info']) && !empty($out['raw_info_priv'])) {
		$res['code'] = 0;
		$res['message'] = $lang['backup_susspended'];
		$res['detail'] = $out;
		echo json_encode($res);
		exit();
	}
	else {
		$res['code'] = 100;
		$res['message'] = $lang['backup_err_key'];
		echo json_encode($res);
		exit();
	}

	break;

case 'list_restore':
	$mysql = new dbusage();
	$serialdata['command'] = 'wait';
	$out = $backup->restorebackup($conf_user, json_encode($serialdata), $mysql);

	foreach ($out as $key => $val) {
		foreach ($val as $key1 => $val1) {
			foreach ($val1 as $key2 => $val2) {
				if (!empty($val2)) {
					$mas_history[] = $val2;
				}
			}
		}
	}

	if ($mas_history) {
		$res['code'] = 0;
		$res['message'] = $lang['backup_array_restore'];
		$res['detail'] = $mas_history;
		echo json_encode($res);
		exit();
	}
	else {
		$res['code'] = 100;
		$res['message'] = $lang['backup_not_array_restore'];
		echo json_encode($res);
		exit();
	}

	break;

case 'delete_jobs_backup':
	if (empty($allvar['delete_backup'])) {
		$res['code'] = 100;
		$res['message'] = $lang['backup_select_job_file'];
		echo json_encode($res);
		exit();
	}

	$serialdata['backup_file_config'] = $allvar['delete_backup'];
	$out = $backup->backup_delete_config($conf_user, json_encode($serialdata));

	if ($out['raw_info'] == 1) {
		$res['code'] = 0;
		$res['message'] = $lang['backup_suspended_del_job'];
		echo json_encode($res);
		exit();
	}
	else {
		$res['code'] = 1000;
		$res['message'] = $lang['backup_error_del_job'];
		echo json_encode($res);
		exit();
	}

	break;

case 'create_backup':
	if (empty($allvar['create_backup'])) {
		$res['code'] = 100;
		$res['message'] = $lang['backup_incorecly_file_backup'];
		echo json_encode($res);
		exit();
	}

	$mysql = new dbusage();
	$serialdata['backup_file_config'] = $allvar['create_backup'];
	$serialdata['command'] = 'create';
	$out = $backup->createarch_local2($conf_user, json_encode($serialdata), $mysql);
	$serialdata['command'] = 'wait';
	$out = $backup->createarch_local2($conf_user, json_encode($serialdata), $mysql);

	if ($out) {
		$res['code'] = 0;
		$res['message'] = $lang['backup_susspended'];
		$res['detail'] = $out['stream_id'];
		echo json_encode($res);
		exit();
	}
	else {
		$res['code'] = 1000;
		$res['message'] = $lang['backup_err'];
		echo json_encode($res);
		exit();
	}

	break;

case 'list_jobs_backup':
	$out = $backup->getconfig_filelist($conf_user);

	if ($allvar['apifull'] != 'y') {
		unset($out['users']);
	}
	if ($out) {
		$res['code'] = 0;
		$res['message'] = $lang['backup_array_job'];
		$res['detail'] = $out;
		echo json_encode($res);
		exit();
	}
	else {
		$res['code'] = 100;
		$res['message'] = $lang['backup_none_job'];
		echo json_encode($res);
		exit();
	}

	break;

case 'list_backup':
	$out = $backup->getlistbackups_arch_local($conf_user);

	if ($out) {
		$res['code'] = 0;
		$res['message'] = $lang['backup_array_list_backup'];
		$res['detail'] = $out;
		echo json_encode($res);
		exit();
	}
	else {
		$res['code'] = 100;
		$res['message'] = $lang['backup_array_list_backup_none'];
		echo json_encode($res);
		exit();
	}

	break;

case 'edit_backup':
	$serialdata['backup_configfile'] = $allvar['edit_conf'];
	$serialdata = $backup->getconfig($user_data, json_encode($serialdata));
	$serialdata['backup_file_config'] = $allvar['edit_conf'];

	if (!empty($allvar['remote_local'])) {
		if (!in_array($allvar['remote_local'], $remote_local)) {
			$res['code'] = 101;
			$res['message'] = $lang['backup_not_store'];
			$res['detail'] = $remote_local;
			echo json_encode($res);
			exit();
		}

		$serialdata['backup_repo'] = $allvar['remote_local'];
	}

	if (!empty($allvar['local_path'])) {
		$serialdata['backup_pathlocal'] = $allvar['local_path'];
	}

	if (!empty($allvar['compression'])) {
		if (!in_array($allvar['compression'], $compression)) {
			$res['code'] = 102;
			$res['message'] = $lang['backup_not_compression'];
			$res['detail'] = $compression;
			echo json_encode($res);
			exit();
		}

		$serialdata['backup_type_arch_array'] = $allvar['compression'];
	}

	if (!empty($allvar['level_compress'])) {
		$compress = intval($allvar['level_compress']);
		if (is_int($compress) && (0 < $compress) && ($compress < 10)) {
			$serialdata['backup_level_compress'] = $allvar['level_compress'];
		}
		else {
			$res['code'] = 103;
			$res['message'] = $lang['backup_incorecly_compression'];
			echo json_encode($res);
			exit();
		}
	}

	if (!empty($allvar['period'])) {
		if (!in_array($allvar['period'], $period)) {
			$res['code'] = 104;
			$res['message'] = $lang['backup_incorecly_period'];
			$res['detail'] = $period;
			echo json_encode($res);
			exit();
		}

		$serialdata['backup_period'] = $allvar['period'];
	}

	if (!empty($allvar['time'])) {
		$mas_time = explode('-', $allvar['time']);
		if (!preg_match('/^[0-9]{1,2}[-][0-9]{1,2}[-][0-9]{1,2}/', $allvar['time']) || (23 < intval($mas_time[0])) || (intval($mas_time[0]) < 0) || (59 < intval($mas_time[1])) || (intval($mas_time[1]) < 0) || (59 < intval($mas_time[2])) || (intval($mas_time[2]) < 0)) {
			$res['code'] = 105;
			$res['message'] = $lang['backup_incorecly_time'];
			echo json_encode($res);
			exit();
		}

		$serialdata['backup_time_start_second'] = $mas_time[2];
		$serialdata['backup_time_start_minute'] = $mas_time[1];
		$serialdata['backup_time_start_hour'] = $mas_time[0];
	}

	if (!empty($allvar['speed_limit'])) {
		$speed_limit = intval($allvar['speed_limit']);
		if ($allvar['speed_limit'] && is_int($speed_limit)) {
			$serialdata['backup_rsync_speed_limit_kb'] = $allvar['speed_limit'];
		}
	}

	if (!empty($allvar['select_day'])) {
		if (!preg_match('/([0-1][,]){7}/', $allvar['select_day'])) {
			$res['code'] = 106;
			$res['message'] = $lang['backup_incorecly_day'];
			$res['detail'] = $period;
			echo json_encode($res);
			exit();
		}

		$serialdata['backup_weekly_days'] = $allvar['select_day'];
	}

	if (!empty($allvar['select_day_date'])) {
		if (!preg_match('/([1-31][,]){1,}/', $allvar['select_day_date'])) {
			$res['code'] = 107;
			$res['message'] = $lang['backup_incorecly_day_month'];
			$res['detail'] = $period;
			echo json_encode($res);
			exit();
		}

		$serialdata['backup_monthly_select_date'] = $allvar['select_day_date'];
	}

	if (!empty($allvar['remoteip'])) {
		$serialdata['backup_remoteip'] = $allvar['remoteip'];
	}

	if (!empty($allvar['remote_folder'])) {
		$serialdata['backup_remote_path'] = $allvar['remote_folder'];
	}

	if (!empty($allvar['type_auth'])) {
		if (!in_array($allvar['type_auth'], $type_auth)) {
			$res['code'] = 110;
			$res['message'] = $lang['backup_incorect_aunt'];
			$res['detail'] = $type_auth;
			echo json_encode($res);
			exit();
		}
		else {
			$serialdata['backup_type_auth'] = $allvar['type_auth'];
		}
	}

	if (!empty($allvar['remote_login'])) {
		$serialdata['backup_remote_login'] = $allvar['remote_login'];
	}

	if (!empty($allvar['remote_pass'])) {
		$serialdata['backup_remote_pass'] = $allvar['remote_pass'];
	}

	if (!empty($allvar['public_key'])) {
		$serialdata['keyrsa'] = $allvar['public_key'];
	}

	if (!empty($allvar['private_key'])) {
		$serialdata['keyrsaprivate'] = $allvar['private_key'];
	}

	if ((!empty($allvar['public_key']) && empty($allvar['private_key'])) || (empty($allvar['public_key']) && !empty($allvar['private_key']))) {
		$res['code'] = 130;
		$res['message'] = $lang['backup_not_one_key'];
		echo json_encode($res);
		exit();
	}

	if (!empty($allvar['active'])) {
		$serialdata['backup_conf_stat'] = 1;
	}

	if ($allvar['active'] == '0') {
		$serialdata['backup_conf_stat'] = 0;
	}

	if (($allvar['apifull'] == 'y') && !empty($allvar['all_user'])) {
		$all_users = $backup->getconfig_filelist($conf_user);

		if (empty($allvar['all_user']) == '1') {
			$serialdata['backup_selected_users'] = $all_users['users'];
		}
		else {
			$users_not = array_diff(explode(',', $allvar['all_user']), $out['users']);

			if ($users_not) {
				$res['code'] = 140;
				$res['message'] = $lang['backup_incorecly_user'];
				$res['detail'] = $users_not;
				echo json_encode($res);
				exit();
			}
			else {
				$serialdata['backup_selected_users'] = explode(',', $allvar['all_user']);
			}
		}
	}

	$out = $backup->saveconfig($conf_user, json_encode($serialdata));

	if (!empty($allvar['private_key']) && !empty($allvar['public_key'])) {
		$serialdata['taskconf'] = $out['fileconf'];
		$backup->savekeyrsa($conf_user, json_encode($serialdata));
	}

	if ($out['raw_info'] == 1) {
		$res['code'] = 0;
		$res['message'] = $lang['backup_its_ok'];
	}
	else {
		$res['code'] = 1000;
		$res['message'] = $out['mess'];
	}

	echo json_encode($res);
	break;

case 'add_backup':
	$serialdata['backup_nametask'] = 'backupjob_' . date('d_m_Y_H_i_s') . '_' . rand(0, 1000);

	if (!in_array($allvar['remote_local'], $remote_local)) {
		$res['code'] = 101;
		$res['message'] = $lang['backup_not_store'];
		$res['detail'] = $remote_local;
		echo json_encode($res);
		exit();
	}

	$serialdata['backup_repo'] = $allvar['remote_local'];

	if ($allvar['remote_local'] == 'local') {
		if ($allvar['local_path']) {
			$serialdata['backup_pathlocal'] = $allvar['local_path'];
		}
		else {
			$serialdata['backup_pathlocal'] = '';
		}
	}

	$serialdata['backup_type_auth'] = 'key';

	if ($allvar['remote_local'] == 'remote') {
		if (empty($allvar['remoteip'])) {
			$res['code'] = 108;
			$res['message'] = $lang['backup_remote_server'];
			echo json_encode($res);
			exit();
		}
		else {
			$serialdata['backup_remoteip'] = $allvar['remoteip'];
		}

		if (empty($allvar['remote_folder'])) {
			$res['code'] = 109;
			$res['message'] = $lang['backup_remote_server_not_path'];
			echo json_encode($res);
			exit();
		}
		else {
			$serialdata['backup_remote_path'] = $allvar['remote_folder'];
		}

		if (!in_array($allvar['type_auth'], $type_auth)) {
			$res['code'] = 110;
			$res['message'] = $lang['backup_incorect_aunt'];
			$res['detail'] = $type_auth;
			echo json_encode($res);
			exit();
		}
		else {
			$serialdata['backup_type_auth'] = $allvar['type_auth'];
		}

		if ($allvar['type_auth'] == 'key') {
			if (empty($allvar['public_key'])) {
				$res['code'] = 111;
				$res['message'] = $lang['backup_not_public_key'];
				echo json_encode($res);
				exit();
			}
			else {
				$serialdata['keyrsa'] = $allvar['public_key'];
			}

			if (empty($allvar['private_key'])) {
				$res['code'] = 112;
				$res['message'] = $lang['backup_not_private_key'];
				echo json_encode($res);
				exit();
			}
			else {
				$serialdata['keyrsaprivate'] = $allvar['private_key'];
			}
		}

		if ($allvar['type_auth'] == 'pass') {
			if (empty($allvar['remote_login'])) {
				$res['code'] = 113;
				$res['message'] = $lang['backup_not_remote_login'];
				echo json_encode($res);
				exit();
			}
			else {
				$serialdata['backup_remote_login'] = $allvar['remote_login'];
			}

			if (empty($allvar['remote_pass'])) {
				$res['code'] = 114;
				$res['message'] = $lang['backup_not_remote_pass'];
				echo json_encode($res);
				exit();
			}
			else {
				$serialdata['backup_remote_pass'] = $allvar['remote_pass'];
			}
		}
	}

	if (!in_array($allvar['compression'], $compression)) {
		$res['code'] = 102;
		$res['message'] = $lang['backup_not_compression'];
		$res['detail'] = $compression;
		echo json_encode($res);
		exit();
	}

	$serialdata['backup_type_arch_array'] = $allvar['compression'];
	$serialdata['backup_rsync_speed_limit_kb'] = 0;

	if ($allvar['compression'] == 'incr_noarch') {
		$speed_limit = intval($allvar['speed_limit']);
		if ($allvar['speed_limit'] && is_int($speed_limit)) {
			$serialdata['backup_rsync_speed_limit_kb'] = $allvar['speed_limit'];
		}
		else {
			$serialdata['backup_rsync_speed_limit_kb'] = 0;
		}
	}

	if ($allvar['compression'] == 'tar') {
		$compress = intval($allvar['level_compress']);
		if (is_int($compress) && (0 < $compress) && ($compress < 10)) {
			$serialdata['backup_level_compress'] = $allvar['level_compress'];
		}
		else if (!$allvar['level_compress']) {
			$serialdata['backup_level_compress'] = 1;
		}
		else {
			$res['code'] = 103;
			$res['message'] = $lang['backup_incorecly_compression'];
			echo json_encode($res);
			exit();
		}
	}

	if (!in_array($allvar['period'], $period)) {
		$res['code'] = 104;
		$res['message'] = $lang['backup_incorecly_period'];
		$res['detail'] = $period;
		echo json_encode($res);
		exit();
	}

	$serialdata['backup_monthly_select_date'] = '';
	$serialdata['backup_period'] = $allvar['period'];
	$serialdata['backup_weekly_days'] = '0,0,0,0,0,0,0,';

	if ($allvar['period'] == 'week') {
		if (empty($allvar['select_day']) || !preg_match('/([0-1][,]){7}/', $allvar['select_day'])) {
			$res['code'] = 106;
			$res['message'] = $lang['backup_incorecly_day'];
			$res['detail'] = $period;
			echo json_encode($res);
			exit();
		}

		$serialdata['backup_weekly_days'] = $allvar['select_day'];
	}

	if ($allvar['period'] == 'month') {
		if (empty($allvar['select_day']) || !preg_match('/([1-31][,]){1,}/', $allvar['select_day'])) {
			$res['code'] = 107;
			$res['message'] = $lang['backup_incorecly_day_month'];
			$res['detail'] = $period;
			echo json_encode($res);
			exit();
		}

		$serialdata['backup_monthly_select_date'] = $allvar['select_day'];
	}

	$mas_time = explode('-', $allvar['time']);
	if (!preg_match('/^[0-9]{1,2}[-][0-9]{1,2}[-][0-9]{1,2}/', $allvar['time']) || (23 < intval($mas_time[0])) || (intval($mas_time[0]) < 0) || (59 < intval($mas_time[1])) || (intval($mas_time[1]) < 0) || (59 < intval($mas_time[2])) || (intval($mas_time[2]) < 0)) {
		$res['code'] = 105;
		$res['message'] = $lang['backup_incorecly_time'];
		echo json_encode($res);
		exit();
	}

	$serialdata['backup_time_start_second'] = $mas_time[2];
	$serialdata['backup_time_start_minute'] = $mas_time[1];
	$serialdata['backup_time_start_hour'] = $mas_time[0];
	$serialdata['backup_denywritebackup'] = 0;

	if (empty($allvar['active'])) {
		$serialdata['backup_conf_stat'] = 0;
	}
	else {
		$serialdata['backup_conf_stat'] = 1;
	}

	$serialdata['backup_file_config'] = '';

	if (($allvar['apifull'] == 'y') && !empty($allvar['all_user'])) {
		$all_users = $backup->getconfig_filelist($conf_user);

		if (empty($allvar['all_user']) == '1') {
			$serialdata['backup_selected_users'] = $all_users['users'];
		}
		else {
			$users_not = array_diff(explode(',', $allvar['all_user']), $out['users']);

			if ($users_not) {
				$res['code'] = 140;
				$res['message'] = $lang['backup_incorecly_user'];
				$res['detail'] = $users_not;
				echo json_encode($res);
				exit();
			}
			else {
				$serialdata['backup_selected_users'] = explode(',', $allvar['all_user']);
			}
		}
	}

	$out = $backup->saveconfig($conf_user, json_encode($serialdata));

	if (!empty($allvar['private_key']) && !empty($allvar['public_key'])) {
		$serialdata['taskconf'] = $out['fileconf'];
		$backup->savekeyrsa($conf_user, json_encode($serialdata));
	}

	if ($out['raw_info'] == 1) {
		$res['code'] = 0;
		$res['message'] = $lang['backup_its_ok'];
	}
	else {
		$res['code'] = 1000;
		$res['message'] = $out['mess'];
	}

	echo json_encode($res);
	break;

case 'saveautoinsuser':
	$username = htmlspecialchars($allvar['username'], ENT_QUOTES);
	$out = $backup->backup_autoins_config_user($username);
	break;

case 'saveuserinfo':
	$username = htmlspecialchars($allvar['username'], ENT_QUOTES);
	$out = $backup->backup_user_info($username);
	break;

case 'saveftpsacc':
	$username = htmlspecialchars($allvar['username'], ENT_QUOTES);
	$out = $backup->backup_ftps_acc($username);
	break;

case 'makedumpdbuser':
	$mysql_users = $allvar['mysql_users'];
	$path_to_dump = $allvar['path_to_dump'];
	$mysql = new dbusage();
	$dbs = $allvar['dbs'];
	$out = $backup->makedump_sql_arr_users($mysql_users, $path_to_dump, $mysql, $dbs, $allvar['username']);
	break;

case 'makedumpdb':
	$path_to_dump = $allvar['path_to_dump'];
	$dbs = $allvar['dbs'];
	$out = $backup->makedump_sql_arr($dbs, $path_to_dump, $allvar['username']);
	break;

case 'restoreuser':
	$usergroup = $allvar['usergroup'];
	$username = $allvar['username'];
	$out = $backup->restoreuserinfo($usergroup, $username);
	break;

case 'restoredb':
	$usergroup = $allvar['usergroup'];
	$username = $allvar['username'];
	$path_to_dump = $allvar['path_to_dump'];

	if (isset($allvar['db_list_rest'])) {
		$db_list_rest = $allvar['db_list_rest'];
		$out = $backup->restore_db($usergroup, $username, $path_to_dump, $db_list_rest);
	}
	else {
		$out = $backup->restore_db($usergroup, $username, $path_to_dump);
	}

	break;

case 'restoredbuser':
	$usergroup = $allvar['usergroup'];
	$username = $allvar['username'];
	$path_to_dump = $allvar['path_to_dump'];

	if (isset($allvar['dbuser_list_rest'])) {
		$dbuser_list_rest = $allvar['dbuser_list_rest'];
		$out = $backup->restoredb_user($usergroup, $username, $path_to_dump, $dbuser_list_rest);
	}
	else {
		$out = $backup->restoredb_user($usergroup, $username, $path_to_dump);
	}

	break;

case 'backupvhosts':
	$username = $allvar['username'];
	$out = $backup->backup_vhosts($username);
	break;

case 'restorevhosts':
	$username = $allvar['username'];
	$out = $backup->restore_vhosts($username);
	break;

case 'backupsjobs':
	$username = $allvar['username'];
	$out = $backup->backup_backups_jobs($username);
	break;

case 'backup_emails_user':
	$out = $backup->backup_emails_user($allvar['username']);
	break;

case 'backup_email_forward':
	$out = $backup->backup_email_forward($allvar['username']);
	break;

case 'backup_dns_user':
	$out = $backup->backup_dns_user($allvar['username']);
	break;

case 'backup_dkimkeys_user':
	$out = $backup->backup_dkimkeys_user($allvar['username']);
	break;

case 'backup_webserver_includes_user':
	$out = $backup->backup_webserver_includes_user($allvar['username']);
	break;

case 'fullbackupdatauser':
	$username = htmlspecialchars($allvar['username'], ENT_QUOTES);
	$out = $backup->backup_autoins_config_user($username);
	$out = $backup->backup_user_info($username);
	$out = $backup->backup_ftps_acc($username);
	$out = $backup->backup_backups_jobs($username);
	$out = $backup->backup_vhosts($username);
	$out = $backup->backup_emails_user($username);
	$out = $backup->backup_email_forward($username);
	$out = $backup->backup_dns_user($username);
	$out = $backup->backup_dkimkeys_user($username);
	$out = $backup->backup_webserver_includes_user($username);
	break;
}

echo ();

?>
