<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

$bindserver = new bindserver();
$username = htmlspecialchars($allvar['login']);
$user_edit = htmlspecialchars($allvar['user_edit']);

if (!empty($user_edit) && ($allvar['apifull'] == 'y')) {
	$username = $user_edit;
}
else if (empty($user_edit)) {
	$username = $username;
}
else {
	$mas['code'] = 400;
	$mas['message'] = $lang['bindserver_not_root'];
	echo json_encode($mas);
	exit();
}

if (($subdo == 'operation') || ($subdo == 'edit_cluster') || ($subdo == 'add_cluster') || ($subdo == 'delete_cluster') || ($subdo == 'token') || ($subdo == 'show_claster') || ($subdo == 'edit_ns_server') || ($subdo == 'list_ns_server')) {
	if ($allvar['apifull'] != 'y') {
		$mas['code'] = 400;
		$mas['message'] = $lang['network_tools_not_apifill'];
		echo json_encode($mas);
		exit();
	}
}

switch ($subdo) {
case 'edit_cluster':
	if (empty($allvar['enable'])) {
		$params['enable'] = 1;
	}
	else {
		$params['enable'] = 1;
	}

	if (empty($allvar['id'])) {
		$params['id'] = 1;
	}
	else if (0 < intval($allvar['id'])) {
		$params['id'] = intval($allvar['id']);
	}
	else {
		$mas['code'] = 101;
		$mas['message'] = $lang['bindserver_invalid_id'];
		echo json_encode($mas);
		exit();
	}

	$mas_type = array('one', 'two');

	if (!in_array($allvar['type'], $mas_type) && !empty($allvar['type'])) {
		$mas['code'] = 100;
		$mas['message'] = $lang['bindserver_invalid_type'];
		$mas['detail'] = $mas_type;
		echo json_encode($mas);
		exit();
	}

	$params['ip'] = $allvar['ip'];
	$params['host'] = $allvar['host'];
	$params['key'] = $allvar['key'];
	$params['type'] = $allvar['type'];
	$out = $bindserver->bindserver_saveCluster($params);
	$mas['code'] = $out['error'];
	$mas['message'] = $out['message'];
	echo json_encode($mas);
	break;

case 'add_cluster':
	if (!preg_match('/^[0-9]{1,3}[.]{1}[0-9]{1,3}[.]{1}[0-9]{1,3}[.]{1}[0-9]{1,3}$/', $allvar['ip'])) {
		$mas['code'] = 100;
		$mas['message'] = $lang['bindserver_invalid_ip_addr'];
		echo json_encode($mas);
		exit();
	}

	if (empty($allvar['host'])) {
		$mas['code'] = 101;
		$mas['message'] = $lang['bindserver_not_host'];
		echo json_encode($mas);
		exit();
	}

	if (empty($allvar['key'])) {
		$mas['code'] = 102;
		$mas['message'] = $lang['bindserver_not_key'];
		echo json_encode($mas);
		exit();
	}

	$mas_type = array('one', 'two');

	if (!in_array($allvar['type'], $mas_type)) {
		$mas['code'] = 103;
		$mas['message'] = $lang['bindserver_invalid_type'];
		$mas['detail'] = $mas_type;
		echo json_encode($mas);
		exit();
	}

	$params['bind_ip'] = $allvar['ip'];
	$params['bind_host'] = $allvar['host'];
	$params['bind_key'] = $allvar['key'];
	$params['bind_type'] = $allvar['type'];
	$out = $bindserver->bindserver_addCluster($params, $lang);

	if ($out['error'] == 0) {
		$mas['code'] = 0;
		$mas['message'] = $lang['bindserver_add_server_claster'];
	}
	else if ($out['error'] == 106) {
		$mas['code'] = 106;
		$mas['message'] = $lang['bindserver_no_connect_server'];
	}
	else {
		$mas['code'] = 110;
		$mas['message'] = $out['message'];
	}

	echo json_encode($mas);
	break;

case 'delete_cluster':
	if (!preg_match('/^[0-9]{1,3}[.]{1}[0-9]{1,3}[.]{1}[0-9]{1,3}[.]{1}[0-9]{1,3}$/', $allvar['ip'])) {
		$mas['code'] = 100;
		$mas['message'] = $lang['bindserver_invalid_ip_addr'];
		echo json_encode($mas);
		exit();
	}

	$out = $bindserver->bindserver_deleteCluster($allvar['ip']);
	$mas['code'] = 0;
	$mas['message'] = $lang['bindserver_del_request'];
	$mas['detail'] = $out;
	echo json_encode($mas);
	break;

case 'token':
	$mass_command = array('save', 'generate');

	if (!in_array($allvar['command'], $mass_command)) {
		$mas['code'] = 102;
		$mas['message'] = $lang['bindserver_not_comm'];
		echo json_encode($mas);
		exit();
	}

	if ($allvar['command'] == 'generate') {
		$out = $bindserver->bindserver_generateToken();

		if ($out) {
			$mas['code'] = 0;
			$mas['message'] = $lang['bindserver_succecffuly_key'];
			$mas['detail'] = $out;
		}
		else {
			$mas['code'] = 100;
			$mas['message'] = $lang['bindserver_err_succecffuly_key'];
		}

		echo json_encode($mas);
	}

	if ($allvar['command'] == 'save') {
		if (empty($allvar['token']) || !preg_match('/^[0-9a-z]{1,}$/i', $allvar['token'])) {
			$mas['code'] = 101;
			$mas['message'] = $lang['bindserver_empty_key'];
			echo json_encode($mas);
			exit();
		}

		$server = new server();

		if (!$this->check_value('string', $allvar['token'])) {
			return false;
		}

		$mass['token'] = $allvar['token'];
		$server->config_save('/etc/brainy/data/bindserver/data', $mass);
		$mas['code'] = 0;
		$mas['message'] = $lang['bindserver_saved_key'];
		echo json_encode($mas);
	}

	break;

case 'show_claster':
	$out = $bindserver->bindserver_get_cluster_table_smarty();

	if (is_array($out)) {
		$mas['code'] = 0;
		$mas['message'] = $lang['bindserver_show_claster'];
		$mas['detail'] = $out;
		echo json_encode($mas);
		exit();
	}
	else {
		$mas['code'] = 100;
		$mas['message'] = $lang['bindserver_not_show_claster'];
		echo json_encode($mas);
		exit();
	}

	break;

case 'rebild':
	$out = $bindserver->bindserver_rebuiltDefaultNs($lang);
	$mas['code'] = 0;
	$mas['message'] = $out;
	echo json_encode($mas);
	exit();
	break;

case 'edit_ns_server':
	switch ($allvar['operetion']) {
	case 'edit_claster':
		$arr_params = json_decode($allvar['params']);

		if (!$arr_params) {
			$mas['code'] = 100;
			$mas['message'] = $lang['bindserver_not_array'];
			echo json_encode($mas);
			exit();
		}
		else {
			foreach ($arr_params as $key => $val) {
				if (!$bindserver->bindserver_validate('ipv42', $val)) {
					$mas['code'] = 2;
					$mas['message'] = $lang['msg_add_zone_err_ip'];
					echo json_encode($mas);
					exit();
				}

				if (!$bindserver->bindserver_validate('host', $key)) {
					$mas['code'] = 1;
					$mas['message'] = $lang['msg_add_zone_err_name'];
					echo json_encode($mas);
					exit();
				}
			}

			$mas['code'] = 0;
			$mas['message'] = $bindserver->bindserver_saveDefaultNsTable($arr_params, $lang);
			echo json_encode($mas);
		}

		break;

	case 'edit_number':
		$arr_params = json_decode($allvar['params']);

		if (!$arr_params) {
			$mas['code'] = 100;
			$mas['message'] = $lang['bindserver_not_array'];
			echo json_encode($mas);
			exit();
		}
		else {
			$mas['code'] = 0;
			$mas['message'] = $bindserver->bindserver_saveDefaultNsTable($arr_params, $lang);
			echo json_encode($mas);
		}

		break;

	case 'add':
		echo json_encode($bindserver->bindserver_addDefaultNs($allvar['host'], $allvar['ip'], $lang));
		break;

	case 'delete':
		echo json_encode($bindserver->bindserver_deleteDefaultNs($allvar['host']));
		break;
	}

	break;

case 'list_ns_server':
	$out = $bindserver->bindserver_getDefaultNsTableSmarty();

	if ($out) {
		$mas['code'] = 0;
		$mas['message'] = $lang['bindserver_list_ns_server'];
		$mas['detail'] = $out;
	}
	else {
		$mas['code'] = 101;
		$mas['message'] = $lang['bindserver_not_list_ns_server'];
	}

	echo json_encode($mas);
	break;

case 'operation':
	$command = array('start', 'restart', 'stop');

	if (!in_array($allvar['command'], $command)) {
		$mas['code'] = 100;
		$mas['message'] = $lang['bindserver_error_comand'];
		$mas['detail'] = $command;
		echo json_encode($mas);
		exit();
	}

	$out = $bindserver->bindserver_run('named', $allvar['command']);

	if ($out) {
		$mas['code'] = 0;
		$mas['message'] = $lang['bindserver_comand_is'];
		$mas['detail'] = $out;
	}
	else {
		$mas['code'] = 101;
		$mas['message'] = $lang['bindserver_err_comand_is'];
	}

	echo json_encode($mas);
	break;

case 'add_zones':
	echo json_encode($bindserver->bindserver_addZone($username, $allvar['zone'], $allvar['ip'], 1));
	break;

case 'delete_zones':
	echo json_encode($bindserver->bindserver_deleteZone($allvar['zone'], $username, 1));
	break;

case 'list_zones':
	if (!empty($user_edit) && ($allvar['apifull'] == 'y')) {
		$mas['code'] = 0;
		$mas['message'] = $lang['bindserver_list_zones'];
		$mas['zones'] = $bindserver->bindserver_getZoneTable($user_edit);

		if ($mas['zones']) {
			echo json_encode($mas);
		}
	}
	else if (empty($user_edit) && ($allvar['apifull'] == 'y')) {
		$mas['code'] = 1;
		$mas['message'] = $lang['bindserver_list_all_zones'];
		$mas['zones'] = $bindserver->bindserver_getZone();

		if ($mas['zones']) {
			echo json_encode($mas);
		}
	}
	else if (empty($user_edit)) {
		$mas['code'] = 2;
		$mas['message'] = $lang['bindserver_list_my_zones'];
		$mas['zones'] = $bindserver->bindserver_getZoneTable($username);

		if ($mas['zones']) {
			echo json_encode($mas);
		}
	}

	if (!$mas['zones']) {
		$mas['code'] = 100;
		$mas['message'] = $lang['bindserver_list_err_zones'];
		echo json_encode($mas);
	}

	break;

case 'show_zones':
	if (!empty($user_edit) && ($allvar['apifull'] == 'y')) {
		$mas['zones'] = $bindserver->bindserver_getZoneInfo($allvar['zone']);

		if ($mas['zones']) {
			$mas['code'] = 0;
			$mas['message'] = $lang['bindserver_list_my_zones'];
			echo json_encode($mas);
		}
	}
	else if (empty($user_edit)) {
		$check_user = $bindserver->bindserver_checkUserZone($allvar['zone'], $username);

		if ($check_user) {
			$mas['zones'] = $bindserver->bindserver_getZoneInfo($allvar['zone']);

			if ($mas['zones']) {
				$mas['code'] = 0;
				$mas['message'] = $lang['bindserver_list_my_zones'];
				echo json_encode($mas);
			}
		}
		else {
			$mas['code'] = 100;
			$mas['message'] = $lang['bindserver_list_err_zones'];
			echo json_encode($mas);
		}
	}

	if (!$mas['zones']) {
		$mas['code'] = 101;
		$mas['message'] = $lang['bindserver_list_not_arr_zones'];
		echo json_encode($mas);
	}

	break;

case 'edit_zones':
	if (!$bindserver->bindserver_checkUserZone($allvar['zone'], $username)) {
		$mas['code'] = 100;
		$mas['message'] = $lang['bindserver_list_err_zones'];
		echo json_encode($mas);
		exit();
	}

	$mas_type = array('A', 'AAAA', 'AFSDB', 'CNAME', 'DNAME', 'DS', 'HINFO', 'LOC', 'MX', 'NAPTR', 'NS', 'PTR', 'RP', 'SRV', 'TXT');
	$not_type = array_diff(array(strtoupper($allvar['type'])), $mas_type);

	if ($not_type) {
		$mas['code'] = 101;
		$mas['message'] = $lang['bindserver_not_record_type'];
		$mas['array']['error_type'] = $not_type;
		$mas['array']['all_type'] = $mas_type;
		echo json_encode($mas);
		exit();
	}

	if (!$allvar['zone']) {
		$mas['code'] = 102;
		$mas['message'] = $lang['bindserver_not_zone'];
		echo json_encode($mas);
		exit();
	}

	if (!empty($allvar['line']) && !is_int(intval($allvar['line']))) {
		$mas['code'] = 103;
		$mas['message'] = $lang['bindserver_not_line_int'];
		echo json_encode($mas);
		exit();
	}

	$server = new server();

	if (!$server->check_value('domain', $allvar['zone'])) {
		return false;
	}

	$zones = explode("\n", $bindserver->bindserver_getZoneInfo($allvar['zone']));

	foreach ($zones as $key => $val) {
		$mas2 = explode(':', $val);
		$str_zones = preg_replace('/^ +/', '', trim($mas2[1]));

		if ($str_zones == ')') {
			$num_line = $mas2[0] + 1;
		}

		$array[$mas2[0]] = $str_zones;
		$num_max_line = $mas2[0];
	}

	if ((!empty($allvar['type']) && !empty($allvar['name']) && !empty($allvar['zone']) && !empty($allvar['value']) && !empty($allvar['line']) && empty($allvar['delete'])) || (!empty($allvar['zone']) && !empty($allvar['line']) && !empty($allvar['delete']))) {
		if (($allvar['line'] < $num_line) || ($num_max_line < $allvar['line'])) {
			$mas['code'] = 104;
			$mas['message'] = $lang['bindserver_not_edit_line'];
			$mas['array']['line_min'] = $num_line;
			$mas['array']['line_max'] = $num_max_line;
			echo json_encode($mas);
			exit();
		}
	}

	if ($allvar['type'] == 'TXT') {
		if (!preg_match('/\\"{1}.+/i', $allvar['value'])) {
			$allvar['value'] = '"' . $allvar['value'] . '"';
		}
	}

	if (!empty($allvar['type']) && !empty($allvar['name']) && !empty($allvar['zone']) && !empty($allvar['value']) && empty($allvar['line']) && empty($allvar['delete'])) {
		$out = $bindserver->sudo_ssh($bindserver::PATH_TO_SCRIPT . 'named.sh --edit --zone ' . $allvar['zone'] . ' --name ' . $allvar['name'] . ' --type ' . strtoupper($allvar['type']) . ' --value ' . str_replace('"', '\\"', $allvar['value']) . ' --line new &> /dev/stdout');
	}

	if (!empty($allvar['type']) && !empty($allvar['name']) && !empty($allvar['zone']) && !empty($allvar['value']) && !empty($allvar['line']) && empty($allvar['delete'])) {
		$out = $bindserver->sudo_ssh($bindserver::PATH_TO_SCRIPT . 'named.sh --edit --zone ' . $allvar['zone'] . ' --name ' . $allvar['name'] . ' --line ' . intval($allvar['line']) . '  --type ' . strtoupper($allvar['type']) . ' --value ' . str_replace('"', '\\"', $allvar['value']) . ' &> /dev/stdout');
	}

	if (!empty($allvar['zone']) && !empty($allvar['line']) && !empty($allvar['delete'])) {
		if (preg_match('/^NS/', $array[$allvar['line']])) {
			$out = $bindserver->sudo_ssh($bindserver::PATH_TO_SCRIPT . 'named.sh --edit --zone ' . $allvar['zone'] . ' --type NS --line ' . intval($allvar['line']) . ' --delete &> /dev/stdout');
		}
		else {
			$out = $bindserver->sudo_ssh($bindserver::PATH_TO_SCRIPT . 'named.sh --edit --zone ' . $allvar['zone'] . ' --line ' . intval($allvar['line']) . ' --delete &> /dev/stdout');
		}
	}

	if (preg_match('/\\[ + OK +\\]$/', $out[0])) {
		$mas['code'] = 0;
		$mas['message'] = $lang['bindserver_susspend_record_del'];
		$mas['scrypt_message'] = $out;
		echo json_encode($mas);
	}
	else {
		foreach ($out as $str) {
			if (preg_match('/stop editing$/', trim($str))) {
				$mas['code'] = 501;
				$mas['message'] = $lang['bindserver_error_record_script'];
				$mas['error_script'] = $out;
				echo json_encode($mas);
				exit();
			}

			if (preg_match('/not valid$/', trim($str))) {
				$mas['code'] = 502;
				$mas['message'] = $lang['bindserver_ok_error_script'];
				$mas['error_script'] = $out;
			}
		}

		if ($mas) {
			echo json_encode($mas);
		}
		else {
			$mas['code'] = 500;
			$mas['message'] = $lang['bindserver_error_script'];
			$mas['error_script'] = $out;
			echo json_encode($mas);
		}
	}

	break;
}

?>
