<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

$dbusage = new dbusage();
$username = htmlspecialchars($allvar['login']);
$user_edit = htmlspecialchars($allvar['user_edit']);

if (!empty($user_edit) && ($allvar['apifull'] == 'y')) {
	$username = $user_edit;
}
else if (empty($user_edit)) {
	$username = $username;
}
else {
	$mas['code'] = 400;
	$mas['message'] = $lang['mysql_show_error_root'];
	echo json_encode($mas);
	exit();
}

if (($subdo == 'controls') || ($subdo == 'processlist') || ($subdo == 'change_password') || ($subdo == 'change_setting')) {
	if ($allvar['apifull'] != 'y') {
		$mas['code'] = 400;
		$mas['message'] = $lang['network_tools_not_apifill'];
		echo json_encode($mas);
		exit();
	}
}

switch ($subdo) {
case 'change_setting':
	$conf = $dbusage->get_mycnf_inputs();

	if ($conf == '404') {
		$mas['code'] = 101;
		$mas['message'] = $lang['mysql_not_acses'];
		echo json_encode($mas);
		exit();
	}

	$parametrs['bind_address'] = $allvar['bind_address'];
	$parametrs['long_query_time'] = $allvar['long_query_time'];
	$parametrs['old_password'] = $allvar['old_password'];
	$parametrs['interactive_timeout'] = $allvar['interactive_timeout'];
	$parametrs['wait_timeout'] = $allvar['wait_timeout'];
	$parametrs['connect_timeout'] = $allvar['connect_timeout'];
	$parametrs['key_buffer'] = $allvar['key_buffer'];
	$parametrs['join_buffer'] = $allvar['join_buffer'];
	$parametrs['join_buffer_size'] = $allvar['join_buffer_size'];
	$parametrs['max_allowed_packet'] = $allvar['max_allowed_packet'];
	$parametrs['table_cache'] = $allvar['table_cache'];
	$parametrs['sort_buffer'] = $allvar['sort_buffer'];
	$parametrs['record_buffer'] = $allvar['record_buffer'];
	$parametrs['thread_cache_size'] = $allvar['thread_cache_size'];
	$parametrs['max_user_connections'] = $allvar['max_user_connections'];
	$parametrs['thread_concurrency'] = $allvar['thread_concurrency'];
	$parametrs['myisam_sort_buffer_size'] = $allvar['myisam_sort_buffer_size'];
	$parametrs['max_heap_table_size'] = $allvar['max_heap_table_size'];
	$parametrs['tmp_table_size'] = $allvar['tmp_table_size'];
	$parametrs['innodb_buffer_pool_size'] = $allvar['innodb_buffer_pool_size'];
	$parametrs['query_cache_limit'] = $allvar['query_cache_limit'];
	$parametrs['query_cache_size'] = $allvar['query_cache_size'];
	$parametrs['query_cache_type'] = $allvar['query_cache_type'];
	$parametrs['symbolic_links'] = $allvar['symbolic_links'];
	$parametrs['log_error'] = $allvar['log_error'];
	$parametrs['pid_file'] = $allvar['pid_file'];

	foreach ($parametrs as $key => $val) {
		if (!isset($val)) {
			$parametrs[$key] = $conf[$key];
		}
		else {
			$parametrs[$key] = $parametrs[$key];
		}
	}

	$out = $dbusage->mycnf_edit(implode(':::', $parametrs));

	if ($out) {
		$mas['code'] = 0;
		$mas['message'] = $lang['mysql_successfuly_config'];
	}
	else {
		$mas['code'] = 100;
		$mas['message'] = $lang['mysql_unuccessfuly_config'];
	}

	echo json_encode($mas);
	break;

case 'change_password':
	if (empty($allvar['new_password'])) {
		$mas['code'] = 100;
		$mas['message'] = $lang['mysql_not_str_pwd'];
		echo json_encode($mas);
		exit();
	}

	$out = $dbusage->change_mysql_pass($allvar['new_password']);

	if ($out == '404') {
		$mas['code'] = 101;
		$mas['message'] = $lang['js_mysql_server_notwork'];
	}
	else if ($out == '3') {
		$mas['code'] = 102;
		$mas['message'] = $lang['js_mysql_db_noconnect'];
	}
	else if ($out == '100') {
		$mas['code'] = 103;
		$mas['message'] = $lang['js_mysql_db_nodata'];
	}
	else {
		$mas['code'] = 0;
		$mas['message'] = $lang['js_mysql_passwd_root'];
	}

	echo json_encode($mas);
	break;

case 'processlist':
	$out = $dbusage->mysql_get_processlist();

	if ($out) {
		$mas['code'] = 0;
		$mas['message'] = $lang['mysql_process_list'];
		$mas['detail'] = $out;
	}
	else {
		$mas['code'] = 100;
		$mas['message'] = $lang['mysql_not_process_list'];
	}

	echo json_encode($mas);
	break;

case 'controls':
	$operation = array('start', 'restart', 'stop');

	if (!in_array($allvar['operation'], $operation)) {
		$mas['code'] = 100;
		$mas['message'] = $lang['mysql_not_corect_comand'];
		$mas['detail'] = $operation;
		echo json_encode($mas);
		exit();
	}

	switch ($allvar['operation']) {
	case 'start':
		$msg_console = $dbusage->mysql_start();
		break;

	case 'stop':
		$msg_console = $dbusage->mysql_stop();
		break;

	case 'restart':
		$msg_console = $dbusage->mysql_restart();
		break;
	}

	$mas['code'] = 0;
	$mas['message'] = $lang['mysql_completed_comand'];
	$mas['detail'] = $msg_console;
	echo json_encode($mas);
	break;

case 'show_users':
	$mas['code'] = 0;
	$mas['message'] = $lang['mysql_show_all_users'];
	$mas['array'] = $dbusage->mysql_get_users($username);

	if ($mas['array']) {
		echo json_encode($mas);
	}
	else {
		$mas['code'] = 100;
		$mas['message'] = $lang['mysql_show_error_users'];
		echo json_encode($mas);
	}

	break;

case 'show_db':
	$mas['code'] = 0;
	$mas['message'] = $lang['mysql_show_all_db'];
	$mas['array'] = $dbusage->mysql_get_dbs($username);

	if ($mas['array']) {
		echo json_encode($mas);
	}
	else {
		$mas['code'] = 100;
		$mas['message'] = $lang['mysql_show_error_db'];
		echo json_encode($mas);
	}

	break;

case 'add_user':
	if (empty($allvar['login_user'])) {
		$mas['code'] = 101;
		$mas['message'] = $lang['mysql_name_user_db_error'];
		echo json_encode($mas);
		exit();
	}

	if (empty($allvar['password_user'])) {
		$mas['code'] = 102;
		$mas['message'] = $lang['mysql_pwd_user_db_error'];
		echo json_encode($mas);
		exit();
	}

	$mas = $dbusage->mysql_add_user($allvar['login_user'], $allvar['password_user'], $username);
	echo json_encode($mas);
	break;

case 'add_db':
	if (empty($allvar['name_db'])) {
		$mas['code'] = 100;
		$mas['message'] = $lang['mysql_not_name_db'];
		echo json_encode($mas);
		exit();
	}

	$mas = $dbusage->mysql_add_db($allvar['name_db'], $username);
	echo json_encode($mas);
	break;

case 'show_privilegies':
	if (empty($allvar['name_user'])) {
		$mas['code'] = 101;
		$mas['message'] = $lang['mysql_name_user_db_error'];
		echo json_encode($mas);
		exit();
	}

	if (empty($allvar['name_db'])) {
		$mas['code'] = 102;
		$mas['message'] = $lang['mysql_not_name_db'];
		echo json_encode($mas);
		exit();
	}

	$out = $dbusage->mysql_show_privs($allvar['name_user'], $allvar['name_db']);

	if (!empty($out)) {
		$mas['code'] = 0;
		$mas['message'] = $lang['mysql_list_privilegies'];
		$mas['privilegies'] = explode(': ', $out);
		echo json_encode($mas);
		exit();
	}
	else {
		$mas['code'] = 100;
		$mas['message'] = $lang['mysql_not_privilegies'];
		echo json_encode($mas);
		exit();
	}

	break;

case 'add_user_db':
	$mas_privilegies = array('SELECT', 'INSERT', 'UPDATE', 'DELETE', 'CREATE', 'DROP', 'INDEX', 'ALTER', 'CREATE TEMPORARY TABLES', 'EXECUTE', 'CREATE VIEW', 'CREATE ROUTINE', 'ALTER ROUTINE', 'EVENT', 'TRIGGER');

	if (empty($allvar['name_user'])) {
		$mas['code'] = 101;
		$mas['message'] = $lang['mysql_name_user_db_error'];
		echo json_encode($mas);
		exit();
	}

	if (empty($allvar['name_db'])) {
		$mas['code'] = 102;
		$mas['message'] = $lang['mysql_not_name_db'];
		echo json_encode($mas);
		exit();
	}

	if (!empty($allvar['privilegies']) && ($allvar['privilegies'] != 'all_privilegies')) {
		$mas_priv = explode(',', mb_strtoupper($allvar['privilegies']));
		$not_priv = array_diff($mas_priv, $mas_privilegies);

		if ($not_priv) {
			$mas['code'] = 100;
			$mas['message'] = $lang['mysql_not_write_privilegies'];
			$mas['array'] = $not_priv;
			echo json_encode($mas);
			exit();
		}
	}

	if ($allvar['privilegies'] == 'all_privilegies') {
		$privs = implode(', ', $mas_privilegies);
	}
	else {
		$privs = mb_strtoupper(str_replace(',', ', ', $allvar['privilegies']));
	}

	if (!empty($allvar['open_remote'])) {
		$mas_ip = explode(',', $allvar['open_remote']);

		foreach ($mas_ip as $key => $val) {
			if (!preg_match('/^[0-9]{1,3}[.]{1}[0-9]{1,3}[.]{1}[0-9]{1,3}[.]{1}[0-9]{1,3}$/', $val)) {
				$mas['code'] = 101;
				$mas['message'] = $lang['mysql_not_ip_parce'];
				$mas['array'] = $val;
				echo json_encode($mas);
				exit();
			}
		}
	}

	echo json_encode($dbusage->set_user_to_db($allvar['name_user'], $allvar['name_db'], $privs, $username, implode("\n", $mas_ip)));
	break;
}

?>
