<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class antivirus
{
	const COMMANDS = array('start', 'stop', 'restart', 'update');
	const SERVICES = array('clamav');
	const PATH_TO_SCRIPT = '/etc/brainy/ssh/antivirus/';

	public $pathant = '/etc/brainy/data/antivirus/scanproc';

	public function antivirus_get_version()
	{
		$this->load_vars('../mailserver/config.cnf');
		return $this->module_vars;
	}

	public function antivirus_run($service, $comm)
	{
		if (!in_array($comm, $this::COMMANDS)) {
			return false;
		}

		if (!in_array($service, $this::SERVICES)) {
			return false;
		}

		switch ($comm) {
		case 'start':
		case 'stop':
		case 'restart':
			$result = $this->antivirus_comm_start($service, $comm);
			break;

		case 'update':
			$result = $this->antivirus_update(intval($_GET['check']));
			break;
		}

		return $result;
	}

	public function antivirus_comm_start($service, $act)
	{
		$possible_acts = array('install', 'reinstall', 'remove', 'turnOn', 'turnOff', 'version', 'check', 'update', 'start', 'stop', 'restart', 'reload');

		if (!in_array($act, $possible_acts)) {
			return 0;
		}

		$out = $this->monitor_service_command('clamd', $act);
		return $out;
	}

	public function antivirus_comm_install($service, $act)
	{
		$possible_acts = array('install', 'reinstall', 'remove', 'turnOn', 'turnOff', 'version', 'check', 'update', 'start', 'stop', 'restart', 'reload');
		$possible_services = array('clamav');
		if (!in_array($act, $possible_acts) || !in_array($service, $possible_services)) {
			return 0;
		}

		$stream[0]['comm'] = $this::PATH_TO_SCRIPT . $service . '.sh --' . $act;
		$stream[0]['test'] = 'Complete';
		$stream[0]['array_start'] = array('one' => 'inprogress,#stream_id#');
		$stream[0]['array_succes'] = array('one' => 'success,#stream_id#');
		$stream[0]['array_unsucces'] = array('one' => 'unsuccess,#stream_id#', 'error' => '#error#');
		$out = $this->create_stream($stream);
		return 'ajax';
	}

	public function antivirus_scan_directory($param)
	{
		global $lang;
		$directory = escapeshellcmd($param['directory']);
		$result = $this->sudo_ssh('ls \'' . $directory . '\'');
		$foo = $this->config_read('/etc/brainy/data/antivirus');
		$carant_dir = $foo['carantine_path'];

		if (!$carant_dir) {
			$carant_dir = '/etc/brainy/data/antivirus/carantine/';
		}

		if (count($result) == 0) {
			$result = $lang['msg_antivir_folder_not_faund'];
			return $result;
		}

		$option = '';

		if ((int) $param['auto_carantine'] == 1) {
			$option = '--move ' . $carant_dir;
		}

		if ((int) $param['auto_delete'] == 1) {
			$option .= ' --remove';
		}

		$stream[0]['comm'] = 'clamscan -r ' . $option . ' \'' . $directory . '\'';
		$stream[0]['test'] = 'Time:';
		$stream[0]['array_start'] = array('one' => 'inprogress,#stream_id#');
		$stream[0]['array_succes'] = array('one' => 'success,#stream_id#');
		$stream[0]['array_unsucces'] = array('one' => 'unsuccess,#stream_id#', 'error' => '#error#');
		$out = $this->create_stream($stream);
		global $server;
		$username = $server->user['name'];
		file_put_contents($this->pathant, $out . '|' . $username . '|' . $directory . "\n", FILE_APPEND | LOCK_EX);
		return 'ajax';
	}

	public function antivirus_process_virus_file($file, $action)
	{
		$file = escapeshellcmd($file);

		if ($action == 'carantine') {
			$this->load_vars('config.cnf');
			$arr = $this->module_vars;
			$this->sudo_ssh('mv \'' . $file . '\' ' . $arr['carantine_path']);
			return 'Перенесен в карантин';
		}

		if ($action == 'delete') {
			$this->sudo_ssh('rm -rf \'' . $file . '\'');
			return 'Удален';
		}
	}

	public function antivirus_save_to_history($user = 'root', $data)
	{
		if (!$this->check_user($user)) {
			return 0;
		}

		$result = $this->sudo_ssh('ls /etc/brainy/data/antivirus/history/' . $user);

		if (count($result) == 0) {
			$result = $this->sudo_ssh('mkdir /etc/brainy/data/antivirus/history/' . $user);
		}

		$file = '/etc/brainy/data/antivirus/history/' . $user . '/' . date('Y-m-d_H_i_s') . '_scan.res';
		$out = explode('|', $this->ssh('cat /etc/brainy/data/antivirus/scanproc | grep ' . $data['id_stream'])[0]);

		if ($out[3] == 1) {
			file_put_contents($file, $data['data']);
		}

		return $file;
	}

	public function antivirus_get_scan_history($user = 'root')
	{
		if (!$this->check_user($user)) {
			return 0;
		}

		$result = $this->sudo_ssh('ls -r /etc/brainy/data/antivirus/history/' . $user);
		return $result;
	}

	public function antivirus_history_to_list($history)
	{
		$result = '<ul>';

		foreach ($history as $key) {
			$result .= '<li><a href=\'index.php?do=antivirus&module=history&file=' . $key . '\'>' . $this->antivirus_history_filename_to_time($key) . '</a></li>';
		}

		$result .= '</ul>';
		return $result;
	}

	public function antivirus_history_to_textarea($history)
	{
		$result = '<select id="scan_history_select" size="13" style="width:400px">';

		foreach ($history as $key) {
			$result .= '<option value=\'' . $key . '\'>' . $this->antivirus_history_filename_to_time($key) . '</option>';
		}

		$result .= '</select>';
		return $result;
	}

	public function antivirus_history_filename_to_time($fname)
	{
		$temp = explode('_', $fname);
		return $temp[0] . ' ' . $temp[1] . ':' . $temp[2] . ':' . $temp[3];
	}

	public function antivirus_get_content_from_history_file($user, $file)
	{
		if (!$this->check_user($user)) {
			return 0;
		}

		if (!$this->check_params('filename', $file)) {
			return 0;
		}

		echo '<pre>';
		echo file_get_contents('/etc/brainy/data/antivirus/history/' . $user . '/' . $file);
		echo '</pre>';
		return 1;
	}

	public function antivirus_save_settings($arr)
	{
		global $server;

		if (!sizeof($arr)) {
			return 0;
		}

		$arr['auto_delete'] = (int) $arr['auto_delete'];
		$arr['auto_carantine'] = (int) $arr['auto_carantine'];
		$arr['auto_update'] = (int) $arr['auto_update'];

		if (!$this->check_params('dir', $arr['carantine_path'])) {
			return false;
		}

		if (!is_dir($arr['carantine_path'])) {
			mkdir($arr['carantine_path']);
		}

		$this->set_data($arr, 'config.cnf');

		if ((int) $arr['auto_update'] == 1) {
			$this->antivirus_add_auto_update();
		}

		if ((int) $arr['auto_update'] == 0) {
			$this->antivirus_delete_auto_update();
		}

		return 1;
	}

	public function antivirus_get_base_update()
	{
		return $this->sudo_ssh('clamscan -V')[0];
	}

	public function antivirus_add_auto_update()
	{
		$cron = new crontab();
		$flag = true;
		$command = $cron->crontab_commands();

		foreach ($command as $key) {
			$comm = $cron->crontab_getcron($key);

			if (trim($comm['command']) == 'freshclam') {
				$flag = false;
			}
		}

		if ($flag) {
			$cron->crontab_cronjob_add(0, 2, '*', '*', '*', 'freshclam');
			$cron->crontab_remove_alltasks('root');
			$cron->crontab_load('root');
		}
	}

	public function antivirus_delete_auto_update()
	{
		$cron = new crontab();
		$command = $cron->crontab_commands();
		$id = NULL;
		$i = 0;

		foreach ($command as $key) {
			$comm = $cron->crontab_getcron($key);

			if (trim($comm['command']) == 'freshclam') {
				$id = $i + 1;
			}

			++$i;
		}

		if (0 <= $id) {
			$cron->crontab_delete_command($id, 'root');
			$cron->crontab_remove_alltasks('root');
			$cron->crontab_load('root');
		}
	}

	public function antivirus_get_settings()
	{
		$this->load_vars('config.cnf');
		return $this->module_vars;
	}

	public function antivirus_update($check = 0)
	{
		global $lang;
		$foo = $this->config_read('/etc/brainy/data/antivirus/main');
		$id_stream = explode(',', $foo['one'])[1];
		$dataget = implode("\n", $this->read_stream($id_stream));
		$pid = $this->getexistpid($id_stream);
		$resupdate['stat'] = 0;
		$resupdate['data'] = 0;
		$resupdate['rrr'] = $id_stream;

		if (strlen($id_stream) < 1) {
			$pid = -1;
		}

		if ($check == 1) {
			if ($pid != -1) {
				$resupdate['stat'] = 1;
				$resupdate['data'] = $dataget;
				return $resupdate;
			}

			$resupdate['stat'] = 0;
			$resupdate['data'] = $dataget . $lang['antivirus_update_finish1'];
			return $resupdate;
		}

		$stream[0]['comm'] = 'freshclam';
		$stream[0]['test'] = 'Complete';
		$stream[0]['array_start'] = array('one' => 'inprogress,#stream_id#');
		$stream[0]['array_succes'] = array('one' => 'success,#stream_id#');
		$stream[0]['array_unsucces'] = array('one' => 'unsuccess,#stream_id#');
		file_put_contents('/etc/brainy/data/antivirus/zzz', print_r($stream, 1));
		$resupdate['stat'] = 1;
		$resupdate['data'] = $lang['antivirus_update_start1'];
		$out = $this->create_stream($stream);
		return $resupdate;
	}

	public function antivirus_ajax()
	{
		global $server;
		$username = $server->user['name'];
		$root_rights = $server->user['group_properties']['root'];
		global $lang;
		$getactivescan = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($this->pathant));
		$resstatscan = array();
		$i = 0;
		$counter = 0;

		foreach ($getactivescan as $curscanid) {
			if (strlen($curscanid) < 5) {
				continue;
			}

			$expdata = explode('|', $curscanid);
			$id_stream = $expdata[0];
			$id_stream_userrun = $expdata[1];
			$directory_scan = $expdata[2];
			$counter_check = intval($expdata[3]);

			if ($id_stream_userrun != $username) {
				continue;
			}

			$dataget = implode("\n", $this->read_stream($id_stream));
			$pid = $this->getexistpid($id_stream);

			if ($pid != -1) {
				$resstatscan[$i]['userrun'] = $id_stream_userrun;
				$resstatscan[$i]['id_stream'] = $id_stream;
				$resstatscan[$i]['data'] = $dataget;
				$resstatscan[$i]['directory_scan'] = $directory_scan;
				$resstatscan[$i]['stat'] = 'inprogress';
				++$i;
			}
			else {
				$resstatscan[$i]['userrun'] = $id_stream_userrun;
				$resstatscan[$i]['id_stream'] = $id_stream;
				$resstatscan[$i]['data'] = $dataget;
				$resstatscan[$i]['directory_scan'] = $directory_scan;
				$resstatscan[$i]['stat'] = 'finish';
				++$i;
				++$counter_check;

				if (($key = array_search($curscanid, $getactivescan)) !== false) {
					if (5 < $counter_check) {
						unset($getactivescan[$key]);
					}
				}
			}

			++$counter;
		}

		file_put_contents($this->pathant, '');

		foreach ($getactivescan as $curscanid) {
			if (strlen($curscanid) < 5) {
				continue;
			}

			$expdata = explode('|', $curscanid);
			$id_stream = $expdata[0];
			$id_stream_userrun = $expdata[1];
			$directory_scan = $expdata[2];
			$expdata[3] = intval($counter_check);
			$impdata = implode('|', $expdata);
			file_put_contents($this->pathant, $impdata . "\n", FILE_APPEND | LOCK_EX);
		}

		return $resstatscan;
	}

	public function clear_history($user_name)
	{
		global $lang;

		if (!$this->check_user($user_name)) {
			return array('code' => 1, 'message' => $lang['server_control_error_user']);
		}

		$this->sudo_ssh('rm -f /etc/brainy/data/antivirus/history/' . $user_name . '/*');
		$out['code'] = 0;
		$out['message'] = $lang['antivirus_clear_history_sus'];
		return $out;
	}
}


?>
