<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class apacserver
{
	const PATH_TO_SCRIPT = '/etc/brainy/ssh/apacserver/';
	const USER_BASE_DIR = '/home/';

	public $g_username = '';
	public $g_root_right = '';
	public $array_error = array(403, 404, 500, 501, 502);
	public $path_db = '/etc/brainy/data/apacserver/optimization.db';
	public $path_bacup_files = '/etc/brainy/data/apacserver/bacup_files';
	public $num = 0;
	public $tplWebCacheData = '/etc/brainy/data/apacserver/data';

	public function apacserver_get_directory($user)
	{
		if (!$this->check_user($user)) {
			return false;
		}

		$result = array();
		$web = new Webserver();
		$out = $web->get_virt_hosts($user);

		foreach ($out as $val) {
			$domain = $val['domain'];
			$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
			$args = $this->config_read($file);
			$arr = $this->apacserver_get_ps($domain);

			foreach ($arr as $item) {
				$c = array($item['dir_full'], $item['lg'], $item['ps'], $domain);
				$result[] = $c;
			}
		}

		return $result;
	}

	public function apacserver_get_site($user)
	{
		if (!$this->check_user($user)) {
			return false;
		}

		$hostacc = new hostacc();
		$hostacc->hostacc_username = $user;
		$arr = $hostacc->hostacc_user_domains();
		$result = array();

		if (is_array($arr['data'])) {
			foreach ($arr['data'] as $key => $value) {
				$result[] = $value['domain'];
			}
		}

		return $result;
	}

	public function apacserver_get_site_select($user)
	{
		if (!$this->check_user($user)) {
			return false;
		}

		$arr = $this->apacserver_get_site($user);
		$result = '';

		foreach ($arr as $key) {
			$result .= '<option value=\'' . $key . '\'>' . $key . '</option>';
		}

		return $result;
	}

	public function apacserver_get_www_table_html($user)
	{
		if (!$this->check_user($user)) {
			return false;
		}

		$arr = $this->apacserver_get_www($user);
		return $arr;
	}

	public function start_opt($domain_scan, $user, $data = '')
	{
		global $lang;
		$puny = new idna_convert();
		$domain_scan = $puny->encode(trim($domain_scan));
		$array = $this->apacserver_searche_url('http://' . $domain_scan);

		if (!$array['js'] && !$array['css'] && !$array['img']) {
			$array = $this->apacserver_searche_url('https://' . $domain_scan);
		}

		$dir = $this->config_read($GLOBALS['DATA_VHOSTS'] . $domain_scan . '.conf')['dir'];
		$dir2 = $this->config_read($GLOBALS['USERS_PATH'] . '/' . $user)['rootdir'];
		$array_not_ditectory = array('bin', 'dev', 'etc', 'home', 'lib', 'lib64', 'log', 'mail', 'opt', 'sites', 'stat', 'tmp', 'usr', 'var');
		$path_bacup = $data['path_backup'];

		if (in_array($path_bacup, $array_not_ditectory)) {
			$array_out['code'] = 9;
			$array_out['message'] = $lang['apacserver_error_reserv_directory'];
			return $array_out;
		}

		if ($path_bacup == '/') {
			$array_out['code'] = 5;
			$array_out['message'] = $lang['apacserver_empty_path_1'];
			return $array_out;
		}

		if ($data['bacup_files'] && !$path_bacup) {
			$array_out['code'] = 3;
			$array_out['message'] = $lang['apacserver_empty_path'];
			return $array_out;
		}

		if (!$this->check_params('dir', $path_bacup)) {
			$array_out['code'] = 2;
			$array_out['message'] = $lang['apacserver_error_directory'];
			return $array_out;
		}

		if (!$array['js'] && !$array['css'] && !$array['img']) {
			$array_out['code'] = 1;
			$array_out['message'] = $lang['apacserver_not_files_optimisation'];
			return $array_out;
		}

		$scan_depth = 2;
		$i = 0;

		while ($i < $scan_depth) {
			foreach ($array as $key => $val) {
				if (!$val) {
					$array = array_merge($array, $this->apacserver_searche_url($key, $array));
				}
			}

			++$i;
		}

		$id_bacup = time() . rand(1000, 100000);
		$str_bacup = $domain_scan . '|' . $id_bacup . '|' . $user . '|' . $dir2 . '/' . $path_bacup . '|' . date('Y-m-d h:i:s') . '|';
		$array_zip = array('css', 'js', 'img');

		foreach ($array_zip as $val_zip) {
			foreach ($array[$val_zip] as $val_val) {
				if ($path_bacup && !is_dir($dir2 . '/' . $path_bacup . '/' . $val_zip)) {
					$this->ssh('mkdir -p ' . $dir2 . '/' . $path_bacup . '/' . $val_zip);
					$this->ssh('chown -R ' . $user . ':' . $user . ' ' . $dir2 . '/' . $path_bacup);
				}

				$out_file = file_get_contents($val_val);

				if ($out_file) {
					preg_match_all('/^(http[s]?):\\/\\/(www)?\\.?(.+)/i', $val_val, $result);
					$out_url = explode('/', $result[3][0]);
					$domain = $out_url[0];
					$name_file = $out_url[count($out_url) - 1];
					unset($out_url[0]);
					unset($out_url[count($out_url)]);
					$path_files = implode('/', $out_url);

					if ($path_bacup) {
						if (is_file($dir . '/' . $path_files . '/' . $name_file)) {
							$date = time();
							$this->ssh('cp -f ' . $dir . '/' . $path_files . '/' . $name_file . ' ' . $dir2 . '/' . $path_bacup . '/' . $val_zip . '/' . $name_file . '_' . $date);
							$str_bacup .= $dir2 . '/' . $path_bacup . '/' . $val_zip . '/' . $name_file . '_' . $date . '>>>' . $dir . '/' . $path_files . '/' . $name_file . ';';
						}
					}

					if (is_file($dir . '/' . $path_files . '/' . $name_file)) {
						if (($val_zip == 'css') || ($val_zip == 'js')) {
							$new_files_data = $this->zip_files($out_file, $val_zip);
							$this->write_file($new_files_data, $dir . '/' . $path_files . '/' . $name_file, 'r', $user);
						}
						else if ($val_zip == 'img') {
							$imagick = new Imagick($dir . '/' . $path_files . '/' . $name_file);
							$imagick->setImageCompressionQuality(80);
							$imagick->stripImage();
							$imagick->writeImage($dir . '/' . $path_files . '/' . $name_file);
						}
					}
				}
			}
		}

		if ($path_bacup) {
			$this->write_file($str_bacup, $this->path_bacup_files, 'wa');
		}

		$arr['code'] = 0;
		$arr['message'] = $lang['apacserver_successfully'];
		return $arr;
	}

	public function get_user_dir($user, $domain = '')
	{
		if (!$this->check_user($user)) {
			return false;
		}

		return $this->config_read($GLOBALS['USERS_PATH'] . '/' . $user)['rootdir'];
	}

	public function action_bacup($data)
	{
		global $lang;

		if (!$this->check_params('number', $data['id_bacup'])) {
			$array_out['code'] = 1;
			$array_out['message'] = $lang['apacserver_error_id'];
			return $array_out;
		}

		if (!$this->check_params('domain', $data['domain'])) {
			$array_out['code'] = 2;
			$array_out['message'] = $lang['apacserver_error_domain'];
			return $array_out;
		}

		$out = explode('|', implode('', $this->ssh('cat ' . $this->path_bacup_files . ' |grep \\|' . $data['id_bacup'] . '\\|>&1')));
		$array_bacup = explode(';', $out[5]);

		switch ($data['action']) {
		case 'backup_restore':
			foreach ($array_bacup as $val_bacup) {
				list($bacup_files, $restore_files) = explode('>>>', $val_bacup);
				$this->ssh('cp -f ' . $bacup_files . ' ' . $restore_files);
			}

			$array_out['code'] = 0;
			$array_out['message'] = $lang['apacserver_restore_succesfully'];

			return $array_out;
		case 'backup_remove':
			foreach ($array_bacup as $val_bacup) {
				$file_bacup = explode('>>>', $val_bacup)[0];
				$this->ssh('rm -fr ' . $file_bacup);
			}

			$array_path = array('css', 'js', 'img');

			foreach ($array_path as $val_path) {
				$array_files_path = $this->ssh('ls -al ' . $out[3] . '/' . $val_path . '/* >&1');

				if (!$array_files_path) {
					$this->ssh('rmdir ' . $out[3] . '/' . $val_path);
					$check[$val_path] = 1;
				}
			}

			if (($check['css'] == 1) && ($check['js'] == 1) && ($check['img'] == 1)) {
				$this->ssh('rmdir ' . $out[3]);
			}

			$this->del_string_new($data['id_bacup'], $this->path_bacup_files);
			$array_out['code'] = 0;
			$array_out['message'] = $lang['apacserver_remove_succesfully'];

			return $array_out;
		}
	}

	public function get_bacup($domain, $user)
	{
		if (!$this->check_user($user)) {
			return false;
		}

		if (!$domain || !$this->check_value('domain', $domain)) {
			$domain = $this->apacserver_get_site($user)[0];
		}

		$out = array_diff($this->read_file_n($this->path_bacup_files), array(''));

		foreach ($out as $val) {
			if (preg_match('/^' . $domain . '\\|/i', $val)) {
				$out_array = explode('|', $val);
				$array[$out_array[1]]['id'] = $out_array[1];
				$array[$out_array[1]]['domain'] = $out_array[0];
				$array[$out_array[1]]['user'] = $out_array[2];
				$array[$out_array[1]]['path'] = $out_array[3];
				$array[$out_array[1]]['date'] = $out_array[4];
			}
		}

		return $array;
	}

	public function zip_files($data, $type)
	{
		switch ($type) {
		case 'js':
			$array_preg[] = '/(\\/\\*.*\\*\\/)/iU';
			$array_preg[] = '/(\\/\\/){1}[a-z0-9 \\.\\,\'_]*\\n|\\n\\r|\\r\\n/i';
			$array_preg[] = '/\\t/i';
			$array_preg[] = '/\\n\\r[ ]{1,}/i';
			$array_preg[] = '/\\n[ ]{1,}/i';
			$array_preg[] = '/(\\n|\\r|\\n\\r|\\r\\n)[ ]*\\/\\/.*/i';
			$array_preg[] = '/([}](\\n|\\r|\\n\\r|\\r\\n))/i';
			$array_preg[] = '/([{](\\n|\\r|\\n\\r|\\r\\n))/i';
			$array_preg[] = '/(\\n|\\r|\\n\\r|\\r\\n)(\\/\\/).*(\\n|\\r|\\n\\r|\\r\\n)/i';
			$array_preg[] = '/(\\/\\*){1}(.*(\\n|\\r|\\n\\r|\\r\\n))+(\\*\\/){1}/iU';
			$array_preg[] = '/[ ]{2,}/i';
			$array_preg[] = '/[=][ ]/i';
			$array_preg[] = '/[ ][=]/i';
			$array_preg[] = '/[{][ ]|[ ][{]/i';
			$array_preg[] = '/[(][ ]|[ ][(]/i';
			$array_preg[] = '/[,][ ]|[ ][,]/i';
			$array_preg[] = '/(\\/\\*.*\\*\\/)/i';
			$array_preg[] = '/\\n{2,}/i';
			$array_preg[] = '/^\\n|\\n\\r|\\r\\n/i';
			$array_preg[] = '/[\\)](\\n|\\n\\r|\\r\\n)[\\{]/i';
			$array_preg[] = '/[;]\\n|\\n\\r|\\r\\n/i';
			$array_preg[] = '/[\\)](\\n|\\n\\r|\\r\\n)[\\}]/i';
			$array_replace[] = '';
			$array_replace[] = "\n";
			$array_replace[] = '';
			$array_replace[] = "\n\r";
			$array_replace[] = "\n";
			$array_replace[] = '';
			$array_replace[] = '}';
			$array_replace[] = '{';
			$array_replace[] = '';
			$array_replace[] = '';
			$array_replace[] = '';
			$array_replace[] = '=';
			$array_replace[] = '=';
			$array_replace[] = '{';
			$array_replace[] = '(';
			$array_replace[] = ',';
			$array_replace[] = '';
			$array_replace[] = "\n";
			$array_replace[] = '';
			$array_replace[] = '){';
			$array_replace[] = ';';
			$array_replace[] = ')}';
			return preg_replace($array_preg, $array_replace, $data);
		case 'css':
			$array_preg[] = '/(\\/\\*.*\\*\\/)/i';
			$array_preg[] = '/(\\n|\\r|\\t)/i';
			$array_preg[] = '/[ ]{2,}/i';
			$array_preg[] = '/[}]/i';
			$array_preg[] = '/(\\n|\\r|\\n\\r|\\r\\n)[ ]/i';
			$array_preg[] = '/[{][ ]|[ ][{]/i';
			$array_preg[] = '/[ ];|;[ ]/i';
			$array_preg[] = '/[ ]:|:[ ]/i';
			$array_preg[] = '/(\\/\\*.*\\*\\/)/iU';
			$array_preg[] = '/(\\/\\*){1}(.*(\\n|\\r|\\n\\r|\\r\\n))+(\\*\\/){1}/iU';
			$array_replace[] = '';
			$array_replace[] = '';
			$array_replace[] = ' ';
			$array_replace[] = '}' . "\n";
			$array_replace[] = '';
			$array_replace[] = '{';
			$array_replace[] = ';';
			$array_replace[] = ':';
			$array_replace[] = '';
			$array_replace[] = '';
			return preg_replace($array_preg, $array_replace, $data);
		}
	}

	public function apacserver_searche_url($url, $array = array())
	{
		preg_match_all('/^(http[s]?):\\/\\/(www)?\\.?(.+\\.[a-z]+[^\\/])(\\/.+)?/i', $url, $result1);
		$protocol = $result1[1][0];

		if ($result1[2][0]) {
			$www = $result1[2][0] . '.';
		}
		else {
			$www = '';
		}

		$domain = $result1[3][0];

		if ($result1[4][0]) {
			$path = $result1[4][0];
		}

		$array[$protocol . '://' . $www . $domain . $path] = 1;
		$arr = file_get_contents($url);
		preg_match_all('/<a[^>]+href="?\'?([^"\']+)"?\'?[^>]*>/i', $arr, $result, PREG_SET_ORDER);

		foreach ($result as $val) {
			if (preg_match('/^(http:\\/\\/|https:\\/\\/)(www)?.{1,}\\.(php|html|htm)?|((\\.)|(\\.\\.)|(\\/).{0,}\\.(php|html|htm)?)/i', $val[1])) {
				if (preg_match('/^(\\/){1}[^\\/]/i', $val[1]) && ($array[$protocol . '://' . $www . $domain . $val[1]] != 1)) {
					$array[$protocol . '://' . $www . $domain . $val[1]] = 0;
				}

				if (preg_match('/^(\\.\\/){1}[^\\/]/i', $val[1]) && ($array[$protocol . '://' . $www . $domain . $path] != 1)) {
					$array[$protocol . '://' . $www . $domain . $path] = 0;
				}

				if (preg_match('/^http/i', $val[1]) && ($array[$protocol . '://' . $www . $domain . $path] != 1)) {
					$array[$protocol . '://' . $www . $domain . $path] = 0;
				}
			}
		}

		preg_match_all('/<script[^>]+src="?\'?([^"\']+)"?\'?[^>]*>/i', $arr, $result1, PREG_SET_ORDER);

		foreach ($result1 as $val1) {
			if (preg_match('/\\.js/i', $val1[1])) {
				if (preg_match('/\\?/i', $val1[1])) {
					$val1[1] = explode('?', $val1[1])[0];
				}

				if (preg_match('/^(\\/){1}[^\\/]/i', $val1[1]) && !in_array($protocol . '://' . $www . $domain . $val1[1], $array['js'])) {
					$array['js'][] = $protocol . '://' . $www . $domain . $val1[1];
				}

				if (preg_match('/^(\\.\\/){1}[^\\/]/i', $val1[1]) && !in_array($protocol . '://' . $www . $domain . $val1[1], $array['js'])) {
					$array['js'][] = $protocol . '://' . $www . $domain . $val1[1];
				}

				if (preg_match('/^http/i', $val1[1]) && !in_array($val1[1], $array['js'])) {
					$array['js'][] = $val1[1];
				}

				if (preg_match('/^[^(http|\\/|\\.\\/)]/i', $val1[1]) && !in_array($protocol . '://' . $www . $domain . '/' . $val1[1], $array['js'])) {
					$array['js'][] = $protocol . '://' . $www . $domain . '/' . $val1[1];
				}
			}
		}

		preg_match_all('/<link[^>]+href="?\'?([^"\']+)"?\'?[^>]*>/i', $arr, $result2, PREG_SET_ORDER);

		foreach ($result2 as $val2) {
			if (preg_match('/\\.css/i', $val2[1])) {
				if (preg_match('/\\?/i', $val2[1])) {
					$val2[1] = explode('?', $val2[1])[0];
				}

				if (preg_match('/^(\\/){1}[^\\/]/i', $val2[1]) && !in_array($protocol . '://' . $www . $domain . $val2[1], $array['css'])) {
					$array['css'][] = $protocol . '://' . $www . $domain . $val2[1];
				}

				if (preg_match('/^(\\.\\/){1}[^\\/]/i', $val2[1]) && !in_array($protocol . '://' . $www . $domain . $val2[1], $array['css'])) {
					$array['css'][] = $protocol . '://' . $www . $domain . $val2[1];
				}

				if (preg_match('/^http/i', $val2[1]) && !in_array($val2[1], $array['css'])) {
					$array['css'][] = $val2[1];
				}

				if (preg_match('/^[^(http|\\/|\\.\\/)]/i', $val2[1]) && !in_array($protocol . '://' . $www . $domain . '/' . $val2[1], $array['css'])) {
					$array['css'][] = $protocol . '://' . $www . $domain . '/' . $val2[1];
				}
			}
		}

		preg_match_all('/<img[^>]+src="?\'?([^"\']+)"?\'?[^>]*>/i', $arr, $result3, PREG_SET_ORDER);

		foreach ($result3 as $val3) {
			if (preg_match('/\\.jpeg|\\.png|\\.gif|\\.jpg/i', $val3[1])) {
				if (preg_match('/\\?/i', $val3[1])) {
					$val3[1] = explode('?', $val3[1])[0];
				}

				if (preg_match('/^(\\/){1}[^\\/]/i', $val3[1]) && !in_array($protocol . '://' . $www . $domain . $val3[1], $array['img'])) {
					$array['img'][] = $protocol . '://' . $www . $domain . $val3[1];
				}

				if (preg_match('/^(\\.\\/){1}[^\\/]/i', $val3[1]) && !in_array($protocol . '://' . $www . $domain . $val3[1], $array['img'])) {
					$array['img'][] = $protocol . '://' . $www . $domain . $val3[1];
				}

				if (preg_match('/^http/i', $val3[1]) && !in_array($val3[1], $array['img'])) {
					$array['img'][] = $val3[1];
				}

				if (preg_match('/^[^(http|\\/|\\.\\/)]/i', $val3[1]) && !in_array($protocol . '://' . $www . $domain . '/' . $val3[1], $array['img'])) {
					$array['img'][] = $protocol . '://' . $www . $domain . '/' . $val3[1];
				}
			}
		}

		return $array;
	}

	public function apacserver_remove_error($domain, $user, $error)
	{
		if (!$this->check_value('domain', $domain)) {
			return false;
		}

		if (!$this->check_user($user)) {
			return false;
		}

		if (!in_array($error, $this->array_error)) {
			return false;
		}

		$conf = $this->config_read($GLOBALS['DATA_VHOSTS'] . $domain . '.conf');
		$user_fild = $conf['dir'] . '/.error_pages';
		$out = $this->ssh('rm -fr ' . $user_fild . '/' . $error . '*');
		$this->convert_apache_nginx_error($domain);
		return $out;
	}

	public function apacserver_get_error($domain, $user)
	{
		if (!$this->check_value('domain', $domain)) {
			return false;
		}

		if (!$this->check_user($user)) {
			return false;
		}

		if (empty($domain)) {
			$webserver = new webserver();
			$list_sites = $webserver->get_all_sites($user, 1);
			$domain = $list_sites[0];
		}

		$conf = $this->config_read($GLOBALS['DATA_VHOSTS'] . $domain . '.conf');
		$user_fild = $conf['dir'] . '/.error_pages/';
		$out = $this->ssh('ls -pa ' . $user_fild . ' | grep -E \'(htm|php|html)$\'');

		foreach ($this->array_error as $val) {
			$new_array[$val] = '';

			foreach ($out as $val1) {
				$err = explode('.', $val1)[0];

				if ($err == $val) {
					if (!$new_array[$val]) {
						$new_array[$val] = 'http://' . $domain . '/.error_pages/' . $val1;
					}
				}
			}
		}

		return $new_array;
	}

	public function apacserver_get_optimization($domain, $user)
	{
		if (!$this->check_value('domain', $domain)) {
			return false;
		}

		if (!$this->check_user($user)) {
			return false;
		}

		if (empty($domain)) {
			$webserver = new webserver();
			$list_sites = $webserver->get_all_sites($user, 1);
			$domain = $list_sites[0];
		}

		$puny = new idna_convert();
		$domain = $puny->encode(trim($domain));
		$webserver = new webserver();
		$conf = $this->config_read($GLOBALS['DATA_VHOSTS'] . '/' . $domain . '.conf');

		if (isset($conf['cacheextExp'])) {
			$conf['cacheextExp'] = intval($conf['cacheextExp']) / 60;
		}
		else {
			$tplWebCacheDataValue = $this->config_read($webserver->tplWebCacheData);
			$conf['cacheext'] = $tplWebCacheDataValue['cache'];
			$conf['cacheextExp'] = $tplWebCacheDataValue['expires'];
			$conf['cachestat'] = $tplWebCacheDataValue['cachestat'];
			$conf['gzipstat'] = $tplWebCacheDataValue['gzipstat'];
		}

		$conf['serverconf'] = $webserver->detect_back_server();
		$conf['cacheext'] = str_replace('\\.', '.', $conf['cacheext']);
		return $conf;
	}

	public function apacserver_put_optimization($domain, $user, $data)
	{
		global $lang;

		if (!$this->check_value('domain', $domain)) {
			return false;
		}

		if (!$this->check_user($user)) {
			return false;
		}

		$puny = new idna_convert();
		$domain = $puny->encode(trim($domain));
		$cacheStat = intval($data['cesh']);
		$gzipStat = intval($data['gzip']);
		$cacheext = preg_split('/[\\s,;|]/', $data['extcash']);

		foreach ($cacheext as $key_cache => $curCache) {
			if (preg_match('/[.]{1}/iu', $curCache)) {
				$cacheext[$key_cache] = str_replace('.', '\\.', $curCache);
			}

			$outm['code'] = 105;
			$outm['message'] = $lang['apacserver_cacheHintWrongExt'];

			return $outm;
		}

		$cacheextExp = $data['time_cesh'] * 60;

		if (!$this->check_value('number', $data['time_cesh'])) {
			$outm['code'] = 105;
			$outm['message'] = $lang['apacserver_cacheHintWrongExtExp'];
			return $outm;
		}

		$arrWrite = array('cacheext' => implode('|', $cacheext), 'cacheextExp' => $cacheextExp, 'cachestat' => $cacheStat, 'gzipstat' => $gzipStat);
		$this->config_save($GLOBALS['DATA_VHOSTS'] . '/' . $domain . '.conf', $arrWrite, 'add');
		$webserver = new webserver();
		$webserver->webserver_convert_domain($domain);
		$arr['code'] = 0;
		$arr['message'] = $lang['apacserver_successfully'];
		return $arr;
	}

	public function apacserver_download_error($domain, $user, $files, $error)
	{
		global $lang;

		if (!$this->check_value('domain', $domain)) {
			return false;
		}

		if (!$this->check_user($user)) {
			return false;
		}

		if (!in_array($error, $this->array_error)) {
			return false;
		}

		$conf = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$params = $this->config_read($conf);

		foreach ($files as $file) {
			if ((($file['error'] == 0) && preg_match('/(htm)|(html)$/i', trim($file['type']))) || (($file['error'] == 0) && preg_match('/(php)$/i', mime_content_type($file['tmp_name'])))) {
				$user_fild = $params['dir'] . '/.error_pages';

				if (!file_exists($user_fild)) {
					$this->ssh('mkdir ' . $user_fild);
					$this->ssh('chown ' . $user . ':' . $user . ' ' . $user_fild);
				}

				$this->ssh('rm -fr ' . $user_fild . '/' . $error . '*');
				$type = explode('.', $file['name'])[1];

				if (move_uploaded_file($file['tmp_name'], $user_fild . '/' . $error . '.' . $type)) {
					$this->ssh('chown ' . $user . ':' . $user . ' ' . $user_fild . '/' . $error . '.' . $type);
					$this->ssh('chmod 775 ' . $user_fild . '/' . $error . '.' . $type);
					$this->convert_apache_nginx_error($domain);
					$arr['code'] = 0;
					$arr['user'] = $user;
					$arr['result'] = $domain . '/.error_pages/' . $error . '.' . $type;
				}

				if ($arr['code'] == 0) {
					return $arr;
				}

				$arr['code'] = 404;
				$arr['result'] = $lang['apacserver_error_file_download'];

				return $arr;
			}

			$arr['code'] = 500;
			$arr['result'] = $lang['apacserver_not_file_download'];
			$arr['message'] = mime_content_type($file['tmp_name']) . $lang['apacserver_error_type_files'];

			return $arr;
		}
	}

	public function convert_apache_nginx_error($domain)
	{
		$conf_server = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);
		$conf = $params = $this->config_read($GLOBALS['DATA_VHOSTS'] . $domain . '.conf');
		$user_fild = $conf['dir'];
		$path_nhinx = '/etc/brainy/data/webserver_config/user_includes/' . $conf['user'] . '/' . $domain . '.nginx';
		$out = $this->ssh('ls -pa ' . $user_fild . '/.error_pages/ | grep -E \'(htm|php|html)$\'');

		if ($conf_server['back_server'] != 'nginx') {
			$this->del_strings_between_str('## error pages', '## end error pages', $path_nhinx);
			$this->del_strings_between_str('## error pages', '## end error pages', $user_fild . '/.htaccess');
			$array[] = '## error pages';

			foreach ($out as $val) {
				$array[] = 'ErrorDocument ' . explode('.', $val)[0] . ' /.error_pages/' . $val;
			}

			$array[] = '## end error pages';

			if (2 < count($array)) {
				$old_htassec = $this->read_file($user_fild . '/.htaccess');
				$this->write_file(implode(PHP_EOL, $array) . PHP_EOL . $old_htassec, $user_fild . '/.htaccess', 'r', $conf['user']);
			}
		}
		else {
			$this->del_strings_between_str('## error pages', '## end error pages', $user_fild . '/.htaccess');
			$this->del_strings_between_str('## error pages', '## end error pages', $path_nhinx);
			$array[] = '## error pages';

			foreach ($out as $val) {
				$array[] = 'error_page ' . explode('.', $val)[0] . ' /.error_pages/' . $val . ';';
				$array[] = 'location = /.error_pages/' . $val . ' {';

				if (preg_match('/(.php)$/i', $val)) {
					$array[] = 'fastcgi_pass unix:/var/run/php-fpm/' . $conf['php'] . '-user1.sock;';
					$array[] = 'include fastcgi_params;';
					$array[] = 'fastcgi_split_path_info                 ^(.+?\\.php)(/.*)?$;';
					$array[] = 'fastcgi_param   SCRIPT_FILENAME         $document_root$fastcgi_script_name;';
					$array[] = 'fastcgi_param   PATH_TRANSLATED         $document_root$fastcgi_script_name;';
					$array[] = 'set             $path_info              $fastcgi_path_info;';
					$array[] = 'fastcgi_param   PATH_INFO               $path_info;';
				}

				$array[] = '}';
			}

			$array[] = '## end error pages';

			if (2 < count($array)) {
				$this->write_file(implode(PHP_EOL, $array), $path_nhinx, 'wa');
			}

			$this->ssh('service nginx restart');
		}
	}

	public function apacserver_get_www($user)
	{
		if (!$this->check_user($user)) {
			return false;
		}

		$result = array();
		$web = new Webserver();
		$out = $web->get_virt_hosts($user);

		foreach ($out as $val) {
			$domain = $val['domain'];
			$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
			$args = $this->config_read($file);
			if (!isset($args['www_redirect']) || ($args['www_redirect'] == '') || ($args['www_redirect'] == 'no')) {
				$in = array();
			}
			else {
				$el = trim($args['www_redirect']);
				$in = explode('|', $el);
			}

			foreach ($in as $items) {
				$arr = explode(',', $items);
				$c = array($arr[0], $arr[1], $arr[2], $arr[3], $arr[4], $arr[5], $domain);
				$result[] = $c;
			}
		}

		return $result;
	}

	public function apacserver_get_site_directory($user, $domain)
	{
		if (!$this->check_user($user)) {
			return false;
		}

		$puny = new idna_convert();
		$domain_en = $puny->encode(trim($domain));

		if (!$this->check_value('domain', $domain_en)) {
			return false;
		}

		$hostacc = new hostacc();
		$hostacc->hostacc_username = $user;
		$arr = $hostacc->hostacc_user_domains();

		foreach ($arr['data'] as $key => $value) {
			return $value['dir'];
		}
	}

	public function apacserver_get_directory_table()
	{
		$arr = $this->apacserver_get_directory(NULL);
		$arr[0][] = '<button class="dir_delete">Удалить</button>';
		$i = 0;

		while ($i < count($arr[0])) {
			$arr2[] = '';
			++$i;
		}

		return $this->apacserver_to_smarty_table($arr2);
	}

	public function apacserver_get_www_table()
	{
		global $lang;
		$arr = $this->apacserver_get_www(NULL);
		$arr[0][] = '<button class="www_delete">' . $lang['msg_apac_delete'] . '</button>';
		$i = 0;

		while ($i < count($arr[0])) {
			$arr2[] = '';
			++$i;
		}

		return $this->apacserver_to_smarty_table($arr2);
	}

	public function apacserver_get_directory_table_html($user)
	{
		if (!$this->check_user($user)) {
			return false;
		}

		$result = '';
		$arr = $this->apacserver_get_directory($user);
		return $arr;

		foreach ($this->check_user($user) as $key => $value) {
			$result .= '<tr><td>' . $value[0] . '</td>';
			$result .= '<td>' . $value[1] . '</td>';
			$result .= '<td>' . $value[2] . '</td>';
			$result .= '<td>' . $value[3] . '</td></tr>';
		}

		return $result;
	}

	public function apacserver_get_http($user)
	{
		if (!$this->check_user($user)) {
			return 0;
		}

		$res = array();
		$web = new Webserver();
		$out = $web->get_virt_hosts($user);

		foreach ($out as $val) {
			$domain = $val['domain'];
			$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
			$http_redirect = $this->config_read($file)['http_redirect'];

			if ($http_redirect != 0) {
				$res[] = array($domain, $user, $http_redirect == 1 ? 'http->https' : 'https->http');
			}
		}

		return $res;
	}

	public function apacserver_to_smarty_table($arr)
	{
		$res = array();
		$i = 0;

		while ($i < count($arr)) {
			$k = 0;

			while ($k < count($arr[$i])) {
				$res[] = $arr[$i][$k];
				++$k;
			}

			++$i;
		}

		return $res;
	}

	public function apacserver_delete_directory_from_db($directory)
	{
		$this->del_string_new($directory, $GLOBALS['APACSERVER_DB_PASS_DIR']);
		return true;
	}

	public function change_owner($path, $owner)
	{
		if (!file_exists($path)) {
			return false;
		}

		if (!$this->check_value('user', $owner)) {
			return false;
		}

		$comm = 'chown -R ' . $owner . '.' . $owner . ' ' . $path;
		$this->ssh($comm);
		return true;
	}

	public function nginx_setdirectory_pass($directory, $user, $password, $domain, $user_login)
	{
		$password = $this->strip_quotes_cmd($password);

		if (!$this->check_value('domain', $domain)) {
			return false;
		}

		$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$args = $this->config_read($file);

		if (!sizeof($args)) {
			return false;
		}

		if (!$this->check_value('user', $user)) {
			return false;
		}

		if (!$this->check_value('user', $user_login)) {
			return false;
		}

		$dirdom = $args['dir'];
		$directory = str_replace('//', '/', $directory);
		$directory_full = $dirdom . '/' . $directory;
		$directory_full = $this->makesafepath_and_check($directory_full);

		if (!preg_match('/[\\/]{1}$/i', $directory_full)) {
			$directory = $directory_full . '/';
		}

		$comm = 'htpasswd -bc ' . $directory_full . 'passwd ' . $user_login . ' \'' . $password . '\'';
		$this->ssh($comm);
		$this->change_owner($directory_full . 'passwd', $user);
		$webserver = new webserver();
		$webserver->webserver_convert_domain($domain);
		return true;
	}

	public function makesafepath($directory)
	{
		$directory = preg_replace('/[^0-9a-zа-яЁієї@\\/.\\-_ ]/iu', '', $directory);
		$directory = preg_replace('/\\.{2,}/', '.', $directory);
		$directory = preg_replace('/\\/{2,}/', '/', $directory);
		return $directory;
	}

	public function makesafepath_and_check($directory)
	{
		$directory = preg_replace('/[^0-9a-zа-яЁієї@\\/.\\-_ ]/iu', '', $directory);
		$directory = preg_replace('/\\.{2,}/', '.', $directory);
		$directory = preg_replace('/\\/{2,}/', '/', $directory);

		if (!is_dir($directory)) {
			return -1;
		}

		if (!$this->check_user($this->g_username)) {
			return false;
		}

		if ((0 < stripos($directory, '/' . $this->g_username . '/')) || ($this->g_root_right == 'y')) {
			return $directory;
		}

		return -1;
	}

	public function apacserver_save_directory_password($directory, $user, $password, $domain = NULL, $user_login = NULL)
	{
		global $lang;
		global $server;

		if (($server->user['group_properties']['root'] != 'y') && ($server->user['group_properties']['apacserver_password'] == 'n')) {
			return array('code' => 404, 'message' => $lang['common_access_is_denied']);
		}

		$password_orig = $password;
		$password = $this->strip_quotes_cmd($password);

		if (!$this->check_value('user', $user)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		if (!$this->check_value('user', $user_login)) {
			return array('code' => 2031, 'message' => $lang['server_control_error_user']);
		}

		if (0 < strlen($domain)) {
			if (!$this->check_value('domain', $domain)) {
				return array('code' => 204, 'message' => $lang['server_control_error_user']);
			}
		}

		$dir_path_relat = '/' . $this->makesafepath($directory) . '/';
		$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$args = $this->config_read($file);
		$dirdom = $args['dir'];
		$directory = $dirdom . '/' . $directory;
		$directory = $this->makesafepath_and_check($directory);

		if ($directory == -1) {
			$res['code'] = -1;
			$res['message'] = $lang['apacserver_dir_safe'];
			return $res;
		}

		if (!$this->apacserver_validate_pasword($password)) {
			$res['code'] = -1;
			$res['message'] = $lang['apacserver_pass_safe'];
			return $res;
		}

		if (!$this->isset_dir_pass($domain, $directory)) {
			$this->apacserver_save_new_directory_pass($directory, $user, $password_orig, $domain, $user_login);
			$this->apacserver_create_directory_password($dir_path_relat, $user, $password, $domain, $user_login);
			$res['code'] = 0;
			$res['message'] = $lang['msg_apac_ok'];
		}
		else {
			$res['code'] = -2;
			$res['message'] = $lang['apacserver_add_dir_failed_already_exist'];
		}

		return $res;
	}

	public function apacserver_delete_directory_password($directory, $domain)
	{
		global $lang;
		$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$args = $this->config_read($file);
		$user = $args['user'];

		if (!file_exists($directory)) {
			return 0;
		}

		if (0 < strlen($domain)) {
			if (!$this->check_value('domain', $domain)) {
				return array('code' => 204, 'message' => $lang['server_control_error_user']);
			}
		}

		$directory = $this->makesafepath($directory);
		if ((0 < stripos($directory, '/' . $this->g_username . '/')) || ($this->g_root_right == 'y')) {
			$this->apacserver_delete_directory_pass($domain, $directory);
			$this->apacserver_remove_directory_password($directory);
			$webserver = new webserver();
			$backserver = $webserver->detect_back_server();
			$webserver->webserver_convert_domain($domain);
			$res['code'] = 0;
			$res['message'] = '';
		}
		else {
			$res['code'] = -1;
			$res['message'] = $lang['msg_apac_not_perm'];
		}

		return $res;
	}

	public function apacserver_create_directory_password($directory, $user, $password, $domain = NULL, $user_login = NULL)
	{
		global $lang;

		if ($domain) {
			$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
			$args = $this->config_read($file);

			if (!file_exists(str_replace('//', '/', $args['dir'] . $directory))) {
				return 0;

				if (!file_exists($directory)) {
					return 0;
				}
			}
		}
		else {
			return 0;
			return 0;
		}

		if (!$this->check_value('user', $user)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		if (0 < strlen($domain)) {
			if (!$this->check_value('domain', $domain)) {
				return array('code' => 204, 'message' => $lang['server_control_error_user']);
			}
		}

		$webserver = new webserver();
		$backserver = $webserver->detect_back_server();

		if (!$this->nginx_setdirectory_pass($directory, $user, $password, $domain, $user_login)) {
			return array('code' => 204, 'message' => $lang['server_control_error_user']);
		}

		return array('code' => 0, 'message' => $lang['apacserver_no_error']);
	}

	public function apacserver_remove_directory_password($directory)
	{
		return $this->sudo_ssh($this::PATH_TO_SCRIPT . 'apac.sh deletepassword ' . $directory);
	}

	public function apacserver_get_http_table($user = NULL)
	{
		if (!$this->check_user($user)) {
			return 0;
		}

		$arr = $this->apacserver_get_http($user);
		return $arr;
	}

	public function apacserver_get_http_table_html($user)
	{
		global $lang;

		if (!$this->check_user($user)) {
			return false;
		}

		$arr = $this->apacserver_get_http($user);

		foreach ($arr as $key => $value) {
			$arr[$key][] = '<button class="http_delete">' . $lang['msg_apac_delete'] . '</button>';
		}

		foreach ($arr as $key => $value) {
			$result .= '<tr><td>' . $value[0] . '</td>';
			$result .= '<td>' . $value[1] . '</td>';
			$result .= '<td>' . $value[2] . '</td>';
			$result .= '<td>' . $value[3] . '</td></tr>';
		}

		return $result;
	}

	public function apacserver_save_http($domain, $user, $type)
	{
		global $lang;

		if (!$this->check_value('user', $user)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		if (!$this->check_params('domain', $domain)) {
			return false;
		}

		if (!$this->check_params('string', $type)) {
			return false;
		}

		if (strlen($domain) == 0) {
			$res['code'] = -1;
			$res['message'] = $lang['apacserver_add_www_failed_exist'];
			return $res;
		}

		$this->apacserver_create_http($domain, $user, $type);
		$res['code'] = 0;
		$res['message'] = $lang['apacserver_add_http_redir_ok'];
		return $res;
	}

	public function apacserver_create_http($site, $user, $type)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		$puny = new idna_convert();
		$domain_en = $puny->encode(trim($site));
		$directory = $this->apacserver_get_site_directory($user, $site);
		$file = $GLOBALS['DATA_VHOSTS'] . $domain_en . '.conf';
		$arr['http_redirect'] = 0;

		if ($type == 'http') {
			$arr['http_redirect'] = 2;
		}
		else if ($type == 'https') {
			$arr['http_redirect'] = 1;
		}

		$this->config_save($file, $arr, 'add');
		$webserver = new webserver();
		$backserver = $webserver->detect_back_server();
		$webserver->webserver_convert_domain($site);

		if (($backserver['service'] != 'nginx') && ($backserver['front'] != 'nginx')) {
			$comm = 'systemctl restart httpd';
			$this->ssh($comm);
		}
		else {
			$comm = 'systemctl restart nginx';
			$this->ssh($comm);
		}
	}

	public function apacserver_remove_http($domain, $user)
	{
		$puny = new idna_convert();
		$domain_en = $puny->encode(trim($domain));

		if (!$this->check_value('domain', $domain_en)) {
			return false;
		}

		if (!$this->check_value('user', $user)) {
			return false;
		}

		$directory = $this->apacserver_get_site_directory($user, $domain);
		$file = $GLOBALS['DATA_VHOSTS'] . $domain_en . '.conf';
		$arr['http_redirect'] = 0;
		$this->config_save($file, $arr, 'add');
		$webserver = new webserver();
		$webserver->webserver_convert_domain($domain);
		$comm = 'systemctl restart httpd';
		$this->ssh($comm);
	}

	public function apacserver_remove_http_nginx($domain, $user, $uniq_id = 0)
	{
		$puny = new idna_convert();
		$domain_en = $puny->encode(trim($domain));

		if (!$this->check_value('domain', $domain_en)) {
			return false;
		}

		if (!$this->check_value('user', $user)) {
			return false;
		}

		$file = $GLOBALS['DATA_VHOSTS'] . $domain_en . '.conf';
		$arr['http_redirect'] = 0;
		$this->config_save($file, $arr, 'add');
		$webserver = new webserver();
		$webserver->webserver_convert_domain($domain);
		$comm = 'systemctl restart nginx';
		$this->ssh($comm);
	}

	public function apacserver_delete_http($domain, $user, $uniq_id)
	{
		global $lang;
		$puny = new idna_convert();
		$domain_en = $puny->encode(trim($domain));

		if (!$this->check_value('user', $user)) {
			return false;
		}

		if (!$this->check_value('domain', $domain_en)) {
			return false;
		}

		if (!$this->check_value('number', $uniq_id)) {
			return false;
		}

		$res_perm = $this->apacserver_check_perm_getdir($domain_en);

		if ($res_perm == -1) {
			$res['code'] = -1;
			$res['message'] = $lang['apacserver_add_www_failed_not_perm'];
			return $res;
		}

		$webserver = new webserver();
		$backserver = $webserver->detect_back_server();

		if (($backserver['service'] != 'nginx') && ($backserver['front'] != 'nginx')) {
			$this->apacserver_remove_http($domain, $user);
		}
		else {
			$this->apacserver_remove_http_nginx($domain, $user);
		}

		$res['code'] = 0;
		$res['message'] = $lang['apacserver_delete_http_redir_ok'];
		return $res;
	}

	public function apacserver_check_perm_getdir($domain)
	{
		if (!$this->check_value('domain', $domain)) {
			return false;
		}

		$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$args = $this->config_read($file);
		$dirdom = $args['dir'];
		$directory = $dirdom . '/';
		$directory = $this->makesafepath_and_check($directory);
		return $directory;
	}

	public function apacserver_delete_www($directory, $user, $type, $domain, $uniq_id)
	{
		global $lang;
		$puny = new idna_convert();
		$domain_en = $puny->encode(trim($domain));
		$domain_dec = $puny->decode(trim($domain));

		if (!$this->check_value('domain', $domain_en)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		if (!$this->check_value('user', $user)) {
			return array('code' => 204, 'message' => $lang['server_control_error_user']);
		}

		if (!$this->check_params('dir', $directory)) {
			return false;
		}

		if (!$this->check_params('string', $type)) {
			return false;
		}

		if (!$this->check_params('number', $uniq_id)) {
			return false;
		}

		$webserver = new webserver();
		$backserver = $webserver->detect_back_server();
		$this->apacserver_delete_www_from_db($domain, $user, $uniq_id);

		if (($backserver['service'] != 'nginx') && ($backserver['front'] != 'nginx')) {
			$webserver->webserver_convert_domain($domain);
			$comm = 'systemctl restart httpd';
			$this->ssh($comm);
		}
		else {
			$webserver->webserver_convert_domain($domain);
			$comm = 'systemctl restart nginx';
			$this->ssh($comm);
		}

		$res['code'] = 0;
		$res['message'] = $lang['apacserver_delete_www_redir_ok'];
		return $res;
	}

	public function apacserver_delete_www_from_db($domain, $user, $uniq_id)
	{
		$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$www = $this->config_read($file)['www_redirect'];
		if (!isset($www) || ($www == '') || ($www == 'no')) {
			return false;
		}

		$items = explode('|', $www);
		$b = 0;
		$i = 0;

		while ($i < count($items)) {
			$val = explode(',', $items[$i]);

			if ($val[5] == $uniq_id) {
				$b = 1;
				break;
			}

			++$i;
		}

		if ($b == 0) {
			return false;
		}

		unset($items[$i]);
		$items = array_values($items);
		$arr['www_redirect'] = implode('|', $items);
		$this->config_save($file, $arr, 'add');
		return true;
	}

	public function apacserver_save_www_to_db($directory, $user, $type, $destination, $domain, $uniq_id, $www, $src)
	{
		$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$args = $this->config_read($file);
		$b = 0;
		$in = explode('|', $args['www_redirect']);

		foreach ($in as $item) {
			$el = explode(',', $item);

			$b = 1;
			break;
		}

		if ($b == 1) {
			return false;
		}

		$item = $directory . ',' . $user . ',' . $type . ',' . $destination . ',' . $domain . ',' . $uniq_id . ',' . $www . ',' . $src;
		if (!isset($args['www_redirect']) || ($args['www_redirect'] == '') || ($args['www_redirect'] == 'no')) {
			$arr['www_redirect'] = $item;
		}
		else {
			$arr['www_redirect'] = $args['www_redirect'] . '|' . $item;
		}

		$this->config_save($file, $arr, 'add');
		return true;
	}

	public function escape_ssh($entry)
	{
		$entry = str_replace('/', '\\/', $entry);
		$entry = str_replace('*', '\\*', $entry);
		return $entry;
	}

	public function apacserver_save_www($www, $site, $src, $user, $draft, $dest)
	{
		global $lang;

		if (!$this->check_value('user', $user)) {
			$res['code'] = -1;
			$res['message'] = $lang['apacserver_http_failedadd'];
			return $res;
		}

		if (0 < strlen($src)) {
			$type = 'redirect';

			if ($src[0] == '/') {
				$src = substr($src, 1);
			}

			if (($c = substr($src, -1)) == '/') {
				$src = substr($src, 0, -1);
			}
		}
		else {
			$type = 'permanent';
		}

		if (($type == 'permanent') && ($www == 'both_www')) {
			$check_dest = preg_replace('/https?[\\:]\\/\\//iu', '', $dest);

			if (preg_match('/^www\\./iu', $check_dest)) {
				$check_www = 'no_www';
			}
			else {
				$check_www = 'www';
			}

			if (stripos($check_dest, $site) !== false) {
				$www = $check_www;
			}
		}

		if (!$this->check_params('string', $www)) {
			return false;
		}

		if (!$this->check_params('domain', $site)) {
			return false;
		}

		if (!$this->check_params('string', $src)) {
			$res['code'] = -1;
			$res['message'] = $lang['apacserver_add_www_failed_bad_from'];
			return $res;
		}

		if (!$this->check_params('textCache', $dest)) {
			$res['code'] = -1;
			$res['message'] = $lang['apacserver_wrongdest1'];
			return $res;
		}

		if (!preg_match('/(true|false)?/i', $draft)) {
			return false;
		}

		$puny = new idna_convert();
		$site = $puny->encode(trim($site));
		$res_perm = $this->apacserver_check_perm_getdir($site);

		if ($res_perm == -1) {
			$res['code'] = -1;
			$res['message'] = $lang['apacserver_add_www_failed_not_perm'];
			return $res;
		}

		if (strlen($site) == 0) {
			$res['code'] = -1;
			$res['message'] = $lang['apacserver_add_www_failed_bad_from'];
			return $res;
		}

		if (strlen($dest) == 0) {
			$res['code'] = -1;
			$res['message'] = $lang['apacserver_add_www_failed_bad_to'];
			return $res;
		}

		$webserver = new webserver();
		$backserver = $webserver->detect_back_server();
		$site_in_db = '';
		$site_in_db_only = '';

		if ($www == 'www') {
			$site_in_db_only = 'www.';
		}

		$site_in_db .= $site . '/' . $src;
		$site_in_db_only .= $site . '/' . $src;
		$uniq_id = rand(1000, 9999999) . time();

		if (!$this->apacserver_save_www_to_db($site_in_db_only, $user, $type, $dest, $site, $uniq_id, $www, $src)) {
			$res['code'] = -1;
			$res['message'] = $lang['apacserver_add_www_failed_exist'];
			return $res;
		}

		if (($backserver['service'] != 'nginx') && ($backserver['front'] != 'nginx')) {
			$res2 = $this->apacserver_create_www($site, $site_in_db, $user, $type, $www, $src, $dest, $site_in_db_only);
		}
		else {
			$res2 = $this->apacserver_create_www_nginx($site, $site_in_db, $user, $type, $www, $src, $dest, $site_in_db_only, $uniq_id);
		}

		$res['code'] = 0;
		$res['message'] = $lang['apacserver_add_www_redir_ok'];
		return $res;
	}

	public function apacserver_create_www_nginx($site, $site_in_db, $user, $type, $www, $src, $dest, $site_in_db_only, $uniq_id)
	{
		$puny = new idna_convert();
		$site_dec = $puny->decode(trim($site));
		$directory = $this->apacserver_get_site_directory($user, $site_dec);
		$file = $GLOBALS['DATA_VHOSTS'] . $site . '.conf';
		$args = $this->config_read($file);
		$webserver = new webserver();
		$webserver->webserver_convert_domain($site);
		$comm = 'service nginx reload';
		$this->ssh($comm);
	}

	public function apacserver_create_www($site, $site_in_db, $user, $type, $www, $src, $dest, $site_in_db_only)
	{
		global $smarty;
		$webserver = new webserver();
		$webserver->webserver_convert_domain($site);
		$comm = 'service httpd reload';
		$this->ssh($comm);
	}

	public function apacserver_load_list_www_redirect($domain)
	{
		$arr = array();
		$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$www = $this->config_read($file)['www_redirect'];
		if (!isset($www) || ($www == '') || ($www == 'no')) {
			return $arr;
		}

		$items = explode('|', $www);
		$i = 0;

		while ($i < count($items)) {
			$val = explode(',', $items[$i]);
			$arr[$i]['type_www'] = $val[6];
			$arr[$i]['src_full'] = $val[0];
			$arr[$i]['el'] = $val[7];
			$arr[$i]['jmp'] = $val[2];
			$arr[$i]['domain'] = $val[4];
			$arr[$i]['sw'] = 'http';
			$arr[$i]['dest_full'] = $val[3];

			if ($c = strstr($val[3], 'http://')) {
				$arr[$i]['dest_full'] = substr($c, strlen('http://'));
			}
			else if ($c = strstr($val[3], 'https://')) {
				$arr[$i]['sw'] = 'https';
				$arr[$i]['dest_full'] = substr($c, strlen('https://'));
			}

			$q_uri = explode('/', $arr[$i]['dest_full']);

			if (!isset($q_uri[1])) {
				$q_uri[1] = '/';
			}
			else if ($q_uri[1] == '') {
				$q_uri[1] = '/';
			}
			else if ($q_uri[1] != '') {
				$q_uri[1] = '/' . $q_uri[1];
			}

			$arr[$i]['uri'] = $q_uri[1];
			$arr[$i]['def_http_host'] = '{HTTP_HOST}';
			$arr[$i]['def_req_uri'] = '{REQUEST_URI}';
			$arr[$i]['def_https'] = '{HTTPS}';
			++$i;
		}

		return $arr;
	}

	public function apacserver_validate_pasword($password)
	{
		if (0 < strlen($password)) {
			return true;
		}

		return false;
	}

	public function apacserver_validate_directory($directory)
	{
		if (!$this->check_user($this->g_username)) {
			return false;
		}

		$directory = preg_replace('/[^0-9a-zа-яЁієї@\\/.\\-_ ]/iu', '', $directory);
		$directory = preg_replace('/\\.{2,}/', '.', $directory);
		$directory = preg_replace('/\\/{2,}/', '/', $directory);
		if ((0 < stripos($directory, '/' . $this->g_username . '/')) || ($this->g_root_right == 'y')) {
		}
		else {
			return false;
		}

		if (is_dir($directory) && ($directory != '/etc/brainy/')) {
			return true;
		}

		return false;
	}

	public function apacserver_get_base_dir($user)
	{
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$homeDir = str_replace($user, '', $confUser['rootdir']);
		return $homeDir;
	}

	public function apacserver_reinstall_redirect()
	{
	}

	public function load_dir_passwd($user, $domain)
	{
		$arr['dir_ps'] = '';
		$_ps = 0;
		$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$args = $this->config_read($file);

		if (!sizeof($args)) {
			return $arr;
		}

		if (!$this->check_value('user', $user)) {
			return $arr;
		}

		$dir_host = $args['dir'];
		$list = $args['dir_ps'];
		$arr['pass_root_domain'] = 0;
		$b = 0;
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$i = 0;

		while ($i < count($arr_all_ps)) {
			if (strstr($arr_all_ps[$i], '/' . $user . '/') && strstr($arr_all_ps[$i], '/' . $domain . '/')) {
				$in = explode('|', $arr_all_ps[$i]);
				$lg = trim($in[1]);
				$ps = trim($in[2]);
				$dir_full = trim($in[0]);
				$dir_home = $confUser['rootdir'] . '/sites/' . $domain;
				$dir_subdir = substr($dir_full, strlen($dir_home));
				$dir_home = $confUser['rootdir'];
				$dir_pass = substr($dir_full, strlen($dir_home));
				$arr_out[] = array($lg, $ps, $dir_full, $dir_home, $dir_subdir, $dir_pass);
				$_ps = 1;

				if (($b == 0) && ($dir_subdir == '/')) {
					$b = 1;
					$arr['pass_root_domain'] = 1;
				}
			}
			else {
				continue;
			}

			++$i;
		}

		if ($_ps == 1) {
			foreach ($arr_out as $key => $val) {
				$out = implode(',', $val);

				if ($arr['dir_ps'] == '') {
					$arr['dir_ps'] = $out;
				}
				else {
					$arr['dir_ps'] = $arr['dir_ps'] . '|' . $out;
				}
			}
		}

		unset($arr_out);
		$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$this->config_save($file, $arr, 'add');
		return $arr;
	}

	public function apacserver_get_ps($domain)
	{
		$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$args = $this->config_read($file);
		$user = $args['user'];
		$ps = $args['dir_ps'];

		if (isset($ps) && ($ps != '')) {
			$in = explode('|', trim($ps));
			$out = array();
			$i = 0;

			while ($i < count($in)) {
				$o = explode(',', $in[$i]);
				$out[$i]['lg'] = $o[0];
				$out[$i]['ps'] = $o[1];
				$out[$i]['dir_full'] = $o[2];
				$out[$i]['dir_home'] = $o[3];
				$out[$i]['dir_subdir'] = $o[4];
				$out[$i]['dir_pass'] = $o[5];
				++$i;
			}
		}

		return $out;
	}

	public function isset_dir_pass($domain, $directory)
	{
		$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$args = $this->config_read($file);
		if (!isset($args['dir_ps']) || ($args['dir_ps'] == '')) {
			return false;
		}

		$arr = explode('|', trim($args['dir_ps']));

		foreach ($arr as $val) {
			$out = explode(',', $val);

			return true;
		}

		return false;
	}

	public function apacserver_save_new_directory_pass($directory, $user, $user_ps, $domain, $user_lg)
	{
		$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$args = $this->config_read($file);
		$arr['pass_root_domain'] = 0;
		$arr['dir_ps'] = '';
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$dir_full = $directory;
		$dir_subdir = substr($dir_full, strlen($args['dir']));
		$dir_home = $confUser['rootdir'];
		$dir_pass = substr($dir_full, strlen($dir_home));
		$item[] = array($user_lg, $user_ps, $dir_full, $dir_home, $dir_subdir, $dir_pass);
		if (!isset($args['dir_ps']) || ($args['dir_ps'] == '')) {
			$arr['dir_ps'] = implode(',', $item[0]);
		}
		else {
			$arr['dir_ps'] = $args['dir_ps'] . '|' . implode(',', $item[0]);
		}

		$in = explode('|', $arr['dir_ps']);
		$i = 0;

		while ($i < count($in)) {
			$items = explode(',', $in[$i]);
			$c_root = $items[4];

			if ($c_root == '/') {
				$arr['pass_root_domain'] = 1;
				break;
			}

			++$i;
		}

		$this->config_save($file, $arr, 'add');
	}

	public function apacserver_delete_directory_pass($domain, $directory)
	{
		$b = 0;
		$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$args = $this->config_read($file);
		$in = $args['dir_ps'];
		$items = explode('|', $in);
		$i = 0;

		while ($i < count($items)) {
			$arr = explode(',', $items[$i]);

			if ($arr[2] == $directory) {
				$b = 1;
				break;
			}

			++$i;
		}

		unset($arr);

		if ($b == 1) {
			unset($items[$i]);
			$items = array_values($items);
			$arr['dir_ps'] = implode('|', $items);
			$arr['pass_root_domain'] = 0;
			$in = explode('|', $arr['dir_ps']);
			$i = 0;

			while ($i < count($in)) {
				$items = explode(',', $in[$i]);
				$c_root = $items[4];

				if ($c_root == '/') {
					$arr['pass_root_domain'] = 1;
					break;
				}

				++$i;
			}

			$this->config_save($file, $arr, 'add');
		}
	}
}


?>
