<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class zipadmin
{
	private $file;
	private $folder;
	private $zip;

	public function __construct($filename, $folder)
	{
		$this->zip = new ZipArchive();
		$this->file = $filename;
		$this->folder = $folder;
	}

	public function listzip()
	{
		$res = false;

		if ($this->zip->open($this->folder . $this->file) == true) {
			$i = 0;

			while ($info = $this->zip->statIndex($i)) {
				if ((($info['crc'] == 0) && preg_match('#^[^/]*?/$#', $info['name'])) || (stripos($info['name'], '/') === false)) {
					$res[] = preg_replace('#^([^/]*?)/$#', '$1', $info['name']);
				}

				++$i;
			}
		}

		return $res;
	}
}

class autoins
{
	public $typeapp = array();
	public $typeapp1 = array();
	public $nameapp = array();
	public $priv_def = 'SELECT, INSERT, UPDATE, DELETE, CREATE, ALTER, INDEX, DROP, CREATE TEMPORARY TABLES, CREATE ROUTINE, ALTER ROUTINE, EXECUTE, CREATE VIEW, EVENT, TRIGGER, REFERENCES, LOCK TABLES, SHOW VIEW';
	public $fileact_apps = 'fileactapps.conf';
	public $listactapps = array();
	public $path_user_includes_cms = '/etc/brainy/data/autoins/includes_cms';

	public function getfullapplist_cached()
	{
		if (is_file($GLOBALS['DATA_PATH_AUTOINS_APP_CACHED'])) {
			$this->typeapp = json_decode(file_get_contents($GLOBALS['DATA_PATH_AUTOINS_APP_CACHED']), true);
			return 1;
		}

		return -1;
	}

	public function get_description($data, $user, $select)
	{
		if (!$this->check_user($user)) {
			return false;
		}

		if (!$this->check_value('string', $data)) {
			return false;
		}

		if ($data['user_main']) {
			$lng = parse_ini_file($GLOBALS['PROPERTIES_CONF'])['language'];
		}
		else {
			$lng = $this->config_read($GLOBALS['USERS_PATH'] . $user)['language'];
		}

		$arr_out = $this->typeapp = json_decode(file_get_contents($GLOBALS['DATA_PATH_AUTOINS_APP_CACHED']), true);

		switch ($select) {
		case 'annotation':
			return $arr_out[$data['typeappgroup']][strval($data['nameapp'])][$select . '_' . $lng];
		}
	}

	public function getlistapp()
	{
		$txt = file_get_contents('http://core.brainycp.com/src/cms/list.txt', FILE_USE_INCLUDE_PATH);
		$res = explode("\n", trim($txt));

		foreach ($res as $elem) {
			$this->typeapp1[] = trim($elem);
		}
	}

	public function getlistappbytype()
	{
		$this->typeapp = '';

		foreach ($this->typeapp1 as $app) {
			$txt = file_get_contents('http://core.brainycp.com/src/cms/' . $app . '/list.txt', FILE_USE_INCLUDE_PATH);
			$res = explode("\n", trim($txt));

			foreach ($res as $elem) {
				$this->typeapp[$app]['version'][] = trim($elem);
			}
		}

		return $this->typeapp;
	}

	public function getappversion()
	{
		foreach ($this->typeapp as $key => $app) {
			foreach ($app as $typeap => $eee) {
				foreach ($eee as $version) {
					$arr_conf = $this->config_read_remote('http://core.brainycp.com/src/cms/' . $key . '/' . $version . '/config.txt');
					$new_array[$key][$version]['appname'] = $arr_conf['appname'];
					$new_array[$key][$version]['description_en'] = $arr_conf['description_en'];
					$new_array[$key][$version]['description_ru'] = $arr_conf['description_ru'];
					$new_array[$key][$version]['annotation_ru'] = $arr_conf['annotation_ru'];
					$new_array[$key][$version]['annotation_en'] = $arr_conf['annotation_en'];
				}
			}
		}

		file_put_contents($GLOBALS['DATA_PATH_AUTOINS_APP_CACHED'], json_encode($new_array));
		$this->typeapp = $new_array;
		$out_cms_includes = $this->get_includes_cms();

		foreach ($out_cms_includes as $val_cms_includes) {
			$this->merger_cms($val_cms_includes['url']);
		}

		return $this->typeapp;
	}

	public function randomstring($max)
	{
		$chars = 'qazxswedcvfrtgbnhyujmkiolp1234567890QAZXSWEDCVFRTGBNHYUJMKIOLP';
		$size = StrLen($chars) - 1;
		$random = '';

		while ($max--) {
			$random .= $chars[rand(0, $size)];
		}

		return $random;
	}

	public function randomstring_onlychar($max)
	{
		$chars = 'qazxswedcvfrtgbnhyujmkiolpQAZXSWEDCVFRTGBNHYUJMKIOLP';
		$size = StrLen($chars) - 1;
		$random = '';

		while ($max--) {
			$random .= $chars[rand(0, $size)];
		}

		return $random;
	}

	public function get_string_between($string, $start, $end)
	{
		$string = ' ' . $string;
		$ini = strpos($string, $start);

		if ($ini == 0) {
			return '';
		}

		$ini += strlen($start);
		$len = strpos($string, $end, $ini) - $ini;
		return substr($string, $ini, $len);
	}

	public function get_config_user_cms($remote_url, $mode)
	{
		$config = file_get_contents($remote_url, FILE_USE_INCLUDE_PATH);
		$res = explode(PHP_EOL, trim($config));
		$new_array = array();

		foreach ($res as $val) {
			$val1 = preg_replace('/\\t|\\n|\\r|\\n\\r|\\r\\n/iu', '', $val);
			$val1 = preg_replace('/[ ]{1,}/iu', ' ', $val1);

			if (preg_match('/^(#cms_section)+/iu', $val1)) {
				$array_cms = array();
			}

			$mas_n = explode('=', $val1, 2);

			if (!preg_match('/(#end_cms_section)+|(#cms_section)+/iu', $val1)) {
				if ($mas_n[0] || $mas_n[1]) {
					if ($mas_n[0] == 'appname') {
						$cms_name = str_replace('"', '', $mas_n[1]);
					}

					if ($mas_n[0] == 'version') {
						$cms_version = str_replace('"', '', $mas_n[1]);
					}

					if (($mas_n[0] != 'appname') && ($mas_n[0] != 'version')) {
						switch ($mode) {
						case 'view_cms':
							if (preg_match('/(appname)+|(description_en)+|(description_ru)+|(annotation_ru)+|(annotation_en)+|(input_data)+/iu', $mas_n[0])) {
								$array_cms[$mas_n[0]] = str_replace('"', '', $mas_n[1]);
							}

							break;

						case 'all_view_cms':
							$array_cms[$mas_n[0]] = str_replace('"', '', $mas_n[1]);
							break;
						}
					}
				}
			}
			else {
				break;
			}

			if (preg_match('/^(#end_cms_section)+/iu', $val1)) {
				$array_cms['url_config'] = $remote_url;
				$new_array[$cms_name][$cms_version] = $array_cms;
				$array_cms = array();
			}
		}

		return $new_array;
	}

	public function merger_cms($remote_url)
	{
		$array_include_cms = $this->get_config_user_cms($remote_url, 'view_cms');
		$new_array = array_merge($this->typeapp, $array_include_cms);
		file_put_contents($GLOBALS['DATA_PATH_AUTOINS_APP_CACHED'], json_encode($new_array));
		$this->typeapp = $new_array;
		return $this->typeapp;
	}

	public function get_includes_cms()
	{
		$array_cms = $this->read_file_n($this->path_user_includes_cms);

		foreach ($array_cms as $val_cms) {
			$out = explode('|', $val_cms);
			$array_new[] = array('id' => $out[0], 'url' => $out[1], 'cms' => $out[2]);
		}

		return $array_new;
	}

	public function edit_user_includes($data)
	{
		global $lang;

		switch ($data['operation']) {
		case 'add_url':
			if (!preg_match('/^(http[s]?:\\/\\/.{3,})+/iu', trim($data['urlincludes']))) {
				$outm['code'] = 1;
				$outm['message'] = $lang['autoins_error_remote_url'];
			}

			if (isset($outm)) {
				return $outm;
			}

			$out_includes = implode('', $this->ssh('cat ' . $this->path_user_includes_cms . ' | grep \'' . $data['urlincludes'] . '\''));

			if ($out_includes) {
				$outm['code'] = 4;
				$outm['message'] = $lang['autoins_not_null_cms'];
			}

			$array_include_cms = $this->get_config_user_cms($data['urlincludes'], 'all_view_cms');

			if (!is_array($array_include_cms)) {
				$outm['code'] = 2;
				$outm['message'] = $lang['autoins_error_import_cms'];
			}

			if (isset($outm)) {
				return $outm;
			}

			foreach ($array_include_cms as $key_cms => $val_cms) {
				if (!is_array($val_cms)) {
					$outm['code'] = 2;
					$outm['message'] = $lang['autoins_error_import_cms'];
				}

				if (isset($outm)) {
					return $outm;
				}

				foreach ($val_cms as $key_vers => $version_cms) {
					$array_view_cms[] = $key_cms . ' - ' . $key_vers;
					$array_check_cms = array('input_data' => 0, 'source' => 0, 'db_main' => 0);

					if (preg_match('/inputdata\\.txt$/iu', trim($version_cms['input_data']))) {
						$array_check_cms['input_data'] = 1;
					}

					if (preg_match('/\\.zip$/iu', trim($version_cms['source']))) {
						$array_check_cms['source'] = 1;
					}

					if (preg_match('/main\\.sql$/iu', trim($version_cms['db_main']))) {
						$array_check_cms['db_main'] = 1;
					}

					if ($array_check_cms['input_data'] == 0) {
						$array_parametrs[] = $version_cms['input_data'];
					}

					if ($array_check_cms['source'] == 0) {
						$array_parametrs[] = $version_cms['source'];
					}

					if ($array_check_cms['db_main'] == 0) {
						$array_parametrs[] = $version_cms['db_main'];
					}

					$outm['code'] = 3;
					$outm['message'] = $lang['autoins_error_paranetrs'] . '<br>' . $lang['autoins_cms_error'] . ' - ' . $key_cms . ', ' . $lang['autoins_version_error'] . ' - ' . $key_vers . '<br>' . implode('<br>', $array_parametrs);

					return $outm;
				}
			}

			if (is_array($array_view_cms)) {
				$id = (int) microtime(true) . rand(10, 1000);
				$this->merger_cms($data['urlincludes']);
				$this->write_file($id . '|' . $data['urlincludes'] . '|' . implode(',', $array_view_cms), $this->path_user_includes_cms, 'wb');
				$outm['code'] = 0;
				$outm['message'] = $lang['autoins_succp'];
			}
			else {
				$outm['code'] = 2;
				$outm['message'] = $lang['autoins_error_import_cms'];
			}

			break;

		case 'remove_url':
			if (10000 < $data['id']) {
				$out_data = $this->get_config_user_cms($remote_url, 'view_cms');
				$array_cms = explode(',', $data['cms']);

				foreach ($array_cms as $val_array_cms) {
					$out_array_cms = explode(' - ', $val_array_cms);
					unset($this->typeapp[$out_array_cms[0]][$out_array_cms[1]]);
				}

				file_put_contents($GLOBALS['DATA_PATH_AUTOINS_APP_CACHED'], json_encode($this->typeapp));
				$this->del_string($data['id'], $this->path_user_includes_cms);
				$outm['code'] = 0;
				$outm['message'] = $lang['autoins_succp'];
			}
			else {
				$outm['code'] = 5;
				$outm['message'] = $lang['autoins_error_remove_list_txt'];
			}

			break;
		}

		return $outm;
	}

	public function installapp($user_data, $serialdata, $mysql, $webserver)
	{
		$puny = new idna_convert();
		$decode = json_decode($serialdata, true);

		if (0 < strlen($decode['dirins'])) {
			$decode['dirins'] = escapeshellcmd(str_replace('\\', '', $decode['dirins']));
		}

		global $lang;

		if (isset($decode['dirins'])) {
			if (0 < strlen($decode['dirins'])) {
				if (!preg_match('/^[-a-zA-Z0-9-\\/]+$/u', $decode['dirins'])) {
					$outm['status'] = 'done';
					$outm['code'][] = 105;
					$outm['message'][] = $lang['autoins_preg_match_dirins'];
				}
			}
		}

		if (isset($decode['sitename'])) {
			if (!preg_match('/^[a-zа-яёЁ0-9_ ;,\\-\\.\\+\\:]{2,}$/iu', $decode['sitename'])) {
				$outm['status'] = 'done';
				$outm['code'][] = 105;
				$outm['message'][] = $lang['autoins_preg_match_sitename'];
			}
		}

		if (isset($decode['dbhost'])) {
			if (!preg_match('/^([0-9]{1,}[.]{1}[0-9]{1,}[.]{1}[0-9]{1,}[.]{1}[0-9]{1,})$/i', $decode['dbhost'])) {
				$outm['status'] = 'done';
				$outm['code'][] = 105;
				$outm['message'][] = $lang['autoins_incorrect_ip'];
			}
		}

		if (isset($decode['sitedesc'])) {
			if (!preg_match('/^[a-zа-яёЁ0-9_ ;,\\-\\.\\+\\:]{2,}$/iu', $decode['sitedesc'])) {
				$outm['status'] = 'done';
				$outm['code'][] = 105;
				$outm['message'][] = $lang['autoins_preg_match_sitedesc'];
			}
		}

		if (isset($decode['path_admin_panel'])) {
			if (!preg_match('/^[a-z0-9_-]{4,}$/i', $decode['path_admin_panel'])) {
				$outm['status'] = 'done';
				$outm['code'][] = 105;
				$outm['message'][] = $lang['autoins_path_admin_error'];
			}
		}

		if (array_key_exists('username', $decode)) {
			if (!preg_match('/^[a-z0-9_-]{6,}$/i', $decode['username'])) {
				$outm['status'] = 'done';
				$outm['code'][] = 105;
				$outm['message'][] = $lang['autoins_preg_match_login_admin_short'];
			}
		}

		if (isset($decode['password'])) {
			if (strlen($decode['password']) < 6) {
				$outm['status'] = 'done';
				$outm['code'][] = 105;
				$outm['message'][] = $lang['autoins_preg_match_pass_admin_short'];
			}
		}

		if (isset($decode['realname'])) {
			if (!preg_match('/^[a-zа-яёЁ ]{2,}$/iu', $decode['realname'])) {
				$outm['status'] = 'done';
				$outm['code'][] = 105;
				$outm['message'][] = $lang['autoins_preg_match_realname'];
			}
		}

		if (isset($decode['emailadmin'])) {
			if (!preg_match('/^[\\w\\.\\d-_]+@[\\w\\.\\d-_]+\\.\\w{2,4}$/i', $decode['emailadmin'])) {
				$outm['status'] = 'done';
				$outm['code'][] = 105;
				$outm['message'][] = $lang['autoins_preg_match_email'];
			}
		}

		$domains = $webserver->get_virt_hosts($user_data['name'], 1);
		$dir_unpack = '';
		$decode['domainins'] = $puny->decode($decode['domainins']);
		$qfind_dom = 0;

		foreach ($domains as $curconfdom) {
			$alias_exp = array_map('trim', explode(',', $curconfdom['aliases']));
			$qfind_dom = 1;
			$dir = $curconfdom['dir'];
			$pwd = $curconfdom['php'];
			$dir_unpack = $dir;
			$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user_data['name']);
			$dir_unpack = str_replace($confUser['rootdir'], '', $dir_unpack);
			break;
		}

		if ($qfind_dom == 0) {
			$outm['status'] = 'done';
			$outm['code'][] = 106;
			$outm['message'][] = $lang['autoins_domain_not_select'];
		}

		if (isset($outm)) {
			return $outm;
		}

		if (0 < strlen($decode['dirins'])) {
			$decode['dirins_slash'] = $dir_unpack . '/' . $decode['dirins'] . '/';
			$decode['dirins_slash_no'] = $dir_unpack . '/' . $decode['dirins'];
		}
		else if (0 < strlen($dir_unpack)) {
			$decode['dirins_slash'] = $dir_unpack . '/';
			$decode['dirins_slash_no'] = $dir_unpack;
		}
		else {
			$decode['dirins_slash'] = '';
			$decode['dirins_slash_no'] = '';
		}

		if ($decode['confirmoverwrite'] == 0) {
			if (is_file($user_data['rootdir'] . '/' . $decode['dirins_slash'] . '/index.php')) {
				$out['status'] = 'done';
				$out['raw_info'] = -2;
				return $out;
			}
		}

		$decode['dirins_slash'] = preg_replace('/^\\//', '', $decode['dirins_slash']);

		if ($decode['confirmoverwrite'] == 1) {
			$insdir = $user_data['rootdir'] . '/' . $decode['dirins_slash_no'];
			$insdir = preg_replace('/\\.{2,}/', '.', $insdir);
			$insdir = preg_replace('/\\/{2,}/', '/', $insdir);
			$conf = $GLOBALS['DATA_PATH_AUTOINS_USERS_APP'] . $user_data['name'] . '.conf';
			$vals = parse_ini_file($conf);

			foreach ($vals as $key => $val) {
				$id_app = explode('_', $key);
				$id_app_todel = $id_app[1];
				break;
			}

			$this->delete_app_install($id_app_todel);
		}

		$typeapp = $decode['typeapp'];
		$typeappgroup = $decode['typeappgroup'];
		$nameapp = $decode['nameapp'];
		$remote_url = $decode['remote_url'];
		$pathapp = '/etc/brainy/tmp/tmp_' . time() . '_' . rand(0, 1000);
		$comm = 'mkdir -p ' . $pathapp;
		$this->ssh($comm);

		if ($remote_url) {
			$arr_param_ins = $this->get_config_user_cms($remote_url, 'all_view_cms')[$typeappgroup][strval($nameapp)];

			if (!$arr_param_ins) {
				$outm['status'] = 'done';
				$outm['code'][] = 107;
				$outm['message'][] = $lang['autoins_failed_user_config'];
				return $outm;
			}

			foreach ($arr_param_ins as $key_n => $val_n) {
				if ($key_n == '#files') {
					$ch = 1;
				}

				if ($key_n == '#config_update') {
					$ch = 0;
				}

				if (($ch == 1) && ($key_n != '#sql') && ($key_n != '#files') && (stripos($key_n, 'tmpdir') === false)) {
					preg_match_all('/[-_0-9a-z.]+$/iu', $val_n, $result);
					copy($val_n, $pathapp . '/' . $result[0][0]);
					$arr_param_ins[$key_n] = $result[0][0];

					if (!is_file($pathapp . '/' . $result[0][0]) && !is_dir($pathapp . '/' . $result[0][0])) {
						$outm['status'] = 'done';
						$outm['code'][] = 201;
						$outm['message'][] = $lang['autoins_failed_copy'] . $typeappgroup . '/' . $nameapp . '/' . $result[0][0];
						$this->ssh('rm -rf ' . $pathapp);

						return $outm;
					}
				}
			}
		}
		else {
			$arr_param_ins = $this->config_read_remote('http://core.brainycp.com/src/cms/' . $typeappgroup . '/' . $nameapp . '/config.txt');
			$ch = 0;

			foreach ($arr_param_ins as $key_n => $val_n) {
				if ($key_n == '#files') {
					$ch = 1;
				}

				if ($key_n == '#config_update') {
					$ch = 0;
				}

				if (($ch == 1) && ($key_n != '#sql') && ($key_n != '#files') && (stripos($key_n, 'tmpdir') === false)) {
					copy('http://core.brainycp.com/src/cms/' . $typeappgroup . '/' . $nameapp . '/' . $val_n, $pathapp . '/' . $val_n);

					if (!is_file($pathapp . '/' . $val_n) && !is_dir($pathapp . '/' . $val_n)) {
						$outm['status'] = 'done';
						$outm['code'][] = 201;
						$outm['message'][] = $lang['autoins_failed_copy'] . $typeappgroup . '/' . $nameapp . '/' . $val_n;

						return $outm;
					}
				}
			}
		}

		if (isset($arr_param_ins['db_main'])) {
			$random_pass = $this->randomstring(12);
			$random_user_short = $this->randomstring(6);
			$random_user = $user_data['name'] . '_' . $random_user_short;
			$random_db_short = $this->randomstring(6);
			$random_db = $user_data['name'] . '_' . $random_db_short;
			$random_db_table_prefix = $this->randomstring_onlychar(3) . '_';
			$random_user = $mysql->mysql_add_user($random_user_short, $random_pass, $user_data['name']);
			$random_user = $random_user['dbuser'];

			if (strlen($random_user) < 5) {
				$outm['status'] = 'done';
				$outm['code'][] = 201;
				$outm['message'][] = $lang['autoins_error_connect'];
				return $outm;
			}

			$random_db = $mysql->mysql_add_db($random_db_short, $user_data['name']);
			$random_db = $random_db['database'];
			$mysql->set_user_to_db($random_user, $random_db, $this->priv_def);
		}

		$comm = 'unzip -o ' . $pathapp . '/' . $arr_param_ins['source'] . ' -d ' . $user_data['rootdir'] . '/' . $dir_unpack . '/' . $decode['dirins'];
		$this->ssh($comm);
		$configfilescountupdates_max = intval($arr_param_ins['configfilescountupdates_max']);
		$configparamcountupdates_max = intval($arr_param_ins['configparamcountupdates_max']);
		$arr_paramupd['sellang'] = $decode['sellang'];
		$arr_paramupd['softproto'] = $decode['softproto'];

		if (!$arr_paramupd['softproto']) {
			$arr_paramupd['softproto'] = 'http://';
		}

		$arr_paramupd['sitename'] = $decode['sitename'];
		$arr_paramupd['sitedesc'] = $decode['sitedesc'];
		$arr_paramupd['userdb'] = $random_user;
		$arr_paramupd['passdb'] = $random_pass;
		$arr_paramupd['namedb'] = $random_db;
		$arr_paramupd['tmppath'] = $user_data['rootdir'] . '/' . $decode['dirins_slash'] . 'tmp';
		$arr_paramupd['logpath'] = $user_data['rootdir'] . '/' . $decode['dirins_slash'] . 'logs';
		$arr_paramupd['dbprefix'] = $random_db_table_prefix;
		$arr_paramupd['realnameadmin'] = $decode['realname'];
		$arr_paramupd['usernameadmin'] = $decode['username'];
		$arr_paramupd['emailadmin'] = $decode['emailadmin'];
		$arr_paramupd['passadmin_orig'] = $decode['password'];
		$arr_paramupd['domainins'] = $decode['domainins'];
		$arr_paramupd['path_to_rootapp'] = $user_data['rootdir'] . '/' . $decode['dirins_slash'];
		$arr_paramupd['md5_passwordadmin'] = md5($decode['password']);

		if ($decode['dirins'][0] == '/') {
			$arr_paramupd['urlinstall'] = $arr_paramupd['softproto'] . $decode['domainins'] . $decode['dirins'];
		}
		else {
			$arr_paramupd['urlinstall'] = $arr_paramupd['softproto'] . $decode['domainins'] . '/' . $decode['dirins'];
		}

		$arr_paramupd['db_host'] = '127.0.0.1';
		$arr_paramupd['ip_server'] = $_SERVER['SERVER_ADDR'];
		$arr_paramupd['path_admin_panel'] = $decode['path_admin_panel'];

		if (0 < strlen($decode['dirins'])) {
			$arr_paramupd['onlydirinstall'] = $decode['dirins'] . '/';
		}
		else {
			$arr_paramupd['onlydirinstall'] = '';
		}

		$arr_paramupd['forumname'] = $decode['forumname'];
		$arr_paramupd['blowfish_secret'] = $this->randomstring(16);
		$arr_paramupd['dbhostinput'] = $decode['dbhost'];
		$comm = 'find ' . $user_data['rootdir'] . '/' . $decode['dirins_slash'] . ' -type f -exec chmod 644 {} \\;';
		$this->ssh($comm);
		$comm = 'find ' . $user_data['rootdir'] . '/' . $decode['dirins_slash'] . ' -type d -exec chmod 755 {} \\;';
		$this->ssh($comm);

		if (is_file($user_data['rootdir'] . '/' . $decode['dirins_slash'] . '/cgi-bin/php.fastcgi')) {
			$this->ssh('chmod 755 ' . $user_data['rootdir'] . '/' . $decode['dirins_slash'] . '/cgi-bin/php.fastcgi');
		}

		$comm = 'chown -R ' . $user_data['name'] . '.' . $user_data['name'] . ' ' . $user_data['rootdir'] . '/' . $decode['dirins_slash_no'] . '';
		$this->ssh($comm);
		$comm = 'chown -R ' . $user_data['name'] . '.' . $user_data['name'] . ' ' . $user_data['rootdir'] . '/' . $decode['dirins_slash'] . '*';
		$this->ssh($comm);
		$shell_exec_arr = array();
		$i = 0;

		while ($i < $configfilescountupdates_max) {
			if (is_file($user_data['rootdir'] . '/' . $decode['dirins_slash'] . $arr_param_ins['configfile_' . $i])) {
				$conf_file = file_get_contents($user_data['rootdir'] . '/' . $decode['dirins_slash'] . $arr_param_ins['configfile_' . $i]);
				$ind = 0;

				while ($ind < $configparamcountupdates_max) {
					$val_new_name = $this->get_string_between($arr_param_ins['param' . $ind . '_' . $i], $arr_param_ins['configdelstart'], $arr_param_ins['configdelend']);
					$val_new_replace = str_replace($arr_param_ins['configdelstart'] . $val_new_name . $arr_param_ins['configdelend'], $arr_paramupd[$val_new_name], $arr_param_ins['param' . $ind . '_' . $i]);
					$conf_file = str_replace($arr_param_ins['value_old' . $ind . '_' . $i], $val_new_replace, $conf_file);
					++$ind;
				}

				if (isset($arr_param_ins['secret_key_' . $i])) {
					$secretkey_del = $arr_param_ins['secret_key_del_' . $i];
					$secret_key = $arr_param_ins['secret_key_' . $i];
					$resapi = file_get_contents($secret_key);
					$resapi = preg_split($secretkey_del, $resapi);
					$countapir = count($resapi);
					$ind = 0;

					while ($ind < $configparamcountupdates_max) {
						$val_new_name = $arr_param_ins['secret' . $ind . '_' . $i];
						$indexapi = 0;

						while ($indexapi < $countapir) {
							if (strpos($resapi[$indexapi], $val_new_name) !== false) {
								$conf_file = str_replace($arr_param_ins['sec_value_old' . $ind . '_' . $i], $resapi[$indexapi], $conf_file);
							}

							++$indexapi;
						}

						++$ind;
					}
				}

				if (isset($arr_param_ins['shell_exec_' . $i])) {
					$ind = 0;

					while ($ind < $configparamcountupdates_max) {
						foreach ($arr_paramupd as $key => $param) {
							$arr_param_ins['shell_exec_' . $ind . '_' . $i] = str_replace($arr_param_ins['configdelstart'] . $key . $arr_param_ins['configdelend'], $param, $arr_param_ins['shell_exec_' . $ind . '_' . $i]);
						}

						$shell_exec = $arr_param_ins['shell_exec_' . $ind . '_' . $i];
						$shell_exec_arr[] = $arr_param_ins['shell_exec_' . $ind . '_' . $i];
						++$ind;
					}
				}

				file_put_contents($user_data['rootdir'] . '/' . $decode['dirins_slash'] . $arr_param_ins['configfile_' . $i], $conf_file);
			}

			++$i;
		}

		$comm = 'mkdir ' . $user_data['rootdir'] . '/' . $decode['dirins_slash'] . $arr_param_ins['tmpdir'];
		$this->ssh($comm);

		if (isset($arr_param_ins['db_main'])) {
			$comm = 'cp ' . $pathapp . '/' . $arr_param_ins['db_main'] . ' ' . $user_data['rootdir'] . '/' . $decode['dirins_slash'] . $arr_param_ins['tmpdir'] . '/' . $arr_param_ins['db_main'];
			$this->ssh($comm);
			$dbimport = file_get_contents($user_data['rootdir'] . '/' . $decode['dirins_slash'] . $arr_param_ins['tmpdir'] . '/' . $arr_param_ins['db_main']);
			$dbimport = str_replace('#__', $random_db_table_prefix, $dbimport);
			$dbimport = str_replace('{$newsite$}', $arr_paramupd['softproto'] . $decode['domainins'] . '/' . $decode['dirins'], $dbimport);
			$this->write_file($dbimport, $user_data['rootdir'] . '/' . $decode['dirins_slash'] . $arr_param_ins['tmpdir'] . '/' . $arr_param_ins['db_main'], 'r', NULL, 1);
			$res = $this->mysql_query_doimport($random_db, $user_data['rootdir'] . '/' . $decode['dirins_slash'] . $arr_param_ins['tmpdir'] . '/' . $arr_param_ins['db_main']);

			if ($res != 0) {
				$outm['status'] = 'done';
				$outm['code'][] = 202;
				$outm['message'][] = $lang['autoins_error_mysql'];
				return $outm;
			}
		}

		if ($decode['importexamplesel'] != 'none') {
			$comm = 'cp ' . $pathapp . '/' . $arr_param_ins['db_' . $decode['importexamplesel']] . ' ' . $user_data['rootdir'] . '/' . $decode['dirins_slash'] . $arr_param_ins['tmpdir'] . '/' . $arr_param_ins['db_' . $decode['importexamplesel']];
			$this->ssh($comm);
			$dbimport = file_get_contents($user_data['rootdir'] . '/' . $decode['dirins_slash'] . $arr_param_ins['tmpdir'] . '/' . $arr_param_ins['db_' . $decode['importexamplesel']]);
			$dbimport = str_replace('#__', $random_db_table_prefix, $dbimport);
			$this->write_file($dbimport, $user_data['rootdir'] . '/' . $decode['dirins_slash'] . $arr_param_ins['tmpdir'] . '/' . $arr_param_ins['db_' . $decode['importexamplesel']], 'r', NULL, 1);
			$res = $this->mysql_query_doimport($random_db, $user_data['rootdir'] . '/' . $decode['dirins_slash'] . $arr_param_ins['tmpdir'] . '/' . $arr_param_ins['db_' . $decode['importexamplesel']]);
		}

		foreach ($shell_exec_arr as $shell_exec) {
			$output = '';

			if (5 < strlen($shell_exec)) {
				$shell_exec_exp = explode('>>>', $shell_exec);

				if (1 < count($shell_exec_exp)) {
					exec($shell_exec_exp[0], $output, $return_var);
					$arr_paramupd[$shell_exec_exp[1]] = implode('', $output);
				}
				else {
					exec($shell_exec);
				}
			}
		}

		if (isset($arr_param_ins['db_install_upd'])) {
			$rows_sql_update = $this->config_read($pathapp . '/' . $arr_param_ins['db_install_upd']);
			$count = count($rows_sql_update);
			$count_params = count($arr_paramupd);

			foreach ($rows_sql_update as $keyr => $sql) {
				foreach ($arr_paramupd as $key => $param) {
					$sql = str_replace($arr_param_ins['configdelstart'] . $key . $arr_param_ins['configdelend'], $param, $sql);
				}

				$sql = str_replace('#__', $random_db_table_prefix, $sql);
				$rows_sql_update[$keyr] = $sql;
			}

			foreach ($rows_sql_update as $keyr => $sql) {
				$resdb = $this->mysql_query_do($random_db, $sql);
			}
		}

		$crontab = new crontab();
		$saveparam_cms = array();

		foreach ($arr_param_ins as $key => $curitem) {
			if (stripos($key, 'crontask') !== false) {
				$exp_data_cron = explode(',', $curitem);
				$saveparam_cms['crontask'][] = $curitem;
				$res = $crontab->crontab_cronjob_add($exp_data_cron[0], $exp_data_cron[1], $exp_data_cron[2], $exp_data_cron[3], $exp_data_cron[4], $exp_data_cron[5], $user_data['name']);
			}
		}

		$insdir = $user_data['rootdir'] . '/' . $decode['dirins_slash_no'];
		$insdir = preg_replace('/\\.{2,}/', '.', $insdir);
		$insdir = preg_replace('/\\/{2,}/', '/', $insdir);
		$url_site = $arr_paramupd['urlinstall'] . '/';
		$url_site = preg_replace('/\\/{2,}$/i', '/', $url_site);

		if ($decode['path_admin_panel']) {
			$login_admin = $url_site . $decode['path_admin_panel'];
		}
		else {
			$login_admin = $url_site . $arr_param_ins['login_admin_panel'];
		}

		$numapp = $this->write_app_install($user_data, $typeapp, $typeappgroup, $nameapp, $insdir, $arr_param_ins, $random_db, $random_user, $arr_paramupd['urlinstall'], $saveparam_cms, $login_admin);
		$z = new zipadmin($arr_param_ins['source'], $pathapp . '/');
		$list_rootfile_folder = $z->listzip();

		foreach ($list_rootfile_folder as $cur_src) {
			file_put_contents($GLOBALS['DATA_PATH_AUTOINS_USERS_APP'] . $user_data['name'] . '_appid' . $numapp, $cur_src . "\n", FILE_APPEND);
		}

		$comm = 'rm -rf ' . $user_data['rootdir'] . '/' . $decode['dirins_slash'] . $arr_param_ins['tmpdir'];
		$this->ssh($comm);
		$this->ssh('rm -Rf ' . $pathapp);

		if ($decode['emailadmin']) {
			$message .= $lang['autoins_login_admin'] . ' - ' . $login_admin . '<br>';

			if ($decode['emailadmin']) {
				$message .= $lang['install_app_adminarea_email'] . ' - ' . $decode['emailadmin'] . '<br>';
			}

			if ($decode['username']) {
				$message .= $lang['install_app_adminarea_username'] . ' - ' . $decode['username'] . '<br>';
			}

			if ($decode['password']) {
				$message .= $lang['install_app_adminarea_pass'] . ' - ' . $decode['password'] . '<br>';
			}

			$headers = 'Content-type: text/html; charset="utf-8"' . "\r\n";
			$headers .= 'MIME-Version: 1.0' . "\r\n";
			$headers .= 'From: =?utf-8?B?' . base64_encode($lang['autoins_brainy']) . '?= <noreply@' . $this->get_real_server_ip() . '> ' . "\r\n";
			$headers .= 'Date: ' . date('D, d M Y h:i:s O') . "\r\n";
			mail($decode['emailadmin'], '=?utf-8?b?' . base64_encode($lang['autoins_data_admin_panel'] . '  ' . $decode['domainins']) . '?=', $message, $headers, '-f Brainycp panel');
		}

		$out['status'] = 'done';
		$out['raw_info'] = '1';
		$out['app_name'] = $typeappgroup . ' ' . $nameapp;
		$out['domainpath'] = $arr_paramupd['urlinstall'];
		$out['path'] = $user_data['rootdir'] . '/' . $decode['dirins_slash'];
		$out['db_name'] = $random_db;
		$out['db_user'] = $random_pass;
		$out['login_admin'] = $login_admin;
		$out['num_app'] = $numapp;
		return $out;
	}

	public function write_app_install($user_data, $typeapp, $typeappgroup, $nameapp, $pathapp, $arr_param_ins, $random_db, $random_user, $domainurl, $saveparam_cms, $login_admin = '')
	{
		if (!$this->check_value('user', $user_data['name'])) {
			return 0;
		}

		if (!is_dir($GLOBALS['DATA_PATH_AUTOINS_USERS_APP'])) {
			$comm = 'mkdir ' . $GLOBALS['DATA_PATH_AUTOINS_USERS_APP'];
			$this->ssh($comm);
		}

		$res = $this->config_read($GLOBALS['DATA_PATH_AUTOINS_USERS_APP'] . $user_data['name'] . '.conf');

		if (isset($res['num'])) {
			$num = intval($res['num']);
		}
		else {
			$num = 0;
		}

		if (isset($res['ids'])) {
			$ids = $res['ids'];
		}
		else {
			$ids = '';
		}

		++$num;
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user_data['name']);
		$pathapp = str_replace($confUser['rootdir'], '', $pathapp);
		$random_db = str_replace($user_data['name'] . '_', '', $random_db);
		$random_user = str_replace($user_data['name'] . '_', '', $random_user);
		$pathapp = preg_replace('/\\/{2,}/', '/', $pathapp);
		$arr_ins = array('num' => $num, 'ids' => $ids . $num . ',', 'domainurl_' . $num => $domainurl, 'path_' . $num => $pathapp, 'typeapp_' . $num => $typeapp, 'typeappgroup_' . $num => $typeappgroup, 'nameapp_' . $num => $nameapp, 'login_admin_' . $num => $login_admin, 'date_' . $num => date('d.m.Y H:i:s'));

		if (isset($arr_param_ins['db_main'])) {
			$arr_ins = array_merge($arr_ins, array('db_name_' . $num => $random_db, 'db_user_' . $num => $random_user));
		}

		foreach ($saveparam_cms as $key => $arr_val) {
			foreach ($arr_val as $key2 => $cur_val) {
				$arr_ins[$key . $key2 . '_' . $num] = $cur_val;
			}
		}

		$this->config_save($GLOBALS['DATA_PATH_AUTOINS_USERS_APP'] . $user_data['name'] . '.conf', $arr_ins, 'add');
		return $num;
	}

	public function read_app_install($user_data)
	{
		if (!$this->check_value('user', $user_data['name'])) {
			return 0;
		}

		$res = $this->config_read($GLOBALS['DATA_PATH_AUTOINS_USERS_APP'] . $user_data['name'] . '.conf');

		if (!empty($res['ids'])) {
			$res['ids'] = explode(',', $res['ids']);

			foreach ($res['ids'] as $key => $id) {
				if (strlen($id) < 1) {
					unset($res['ids'][$key]);
				}
			}
		}

		return $res;
	}

	public function delete_app_install($id_app_todel, $array_user = NULL)
	{
		global $server;

		if (!$this->check_value('number', $id_app_todel)) {
			return false;
		}

		$user_data = $server->user;

		if (isset($array_user)) {
			$user_data = $array_user;
		}

		$mysql = new dbusage();
		$list_app = $this->read_app_install($user_data);

		foreach ($list_app['ids'] as $id) {
			if (isset($list_app['db_user_' . $id])) {
				$res_del_user = $mysql->mysql_drop_user($user_data['name'] . '_' . $list_app['db_user_' . $id], $user_data['name']);
				$res_del_db = $mysql->mysql_drop_db($user_data['name'] . '_' . $list_app['db_name_' . $id], $user_data['name']);
			}

			$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user_data['name']);
			$path_rem = $confUser['rootdir'] . $list_app['path_' . $id];

			if (strpos($path_rem, $user_data['rootdir'] . '/') === false) {
				$out['raw_info'] = -1;

				return out;
			}

			$list_files_cms_del = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($GLOBALS['DATA_PATH_AUTOINS_USERS_APP'] . $user_data['name'] . '_appid' . $id_app_todel));

			foreach ($list_files_cms_del as $curfile_del) {
				if (1 < strlen($curfile_del)) {
					$this->ssh('rm -rf ' . $path_rem . '/' . $curfile_del);
				}
			}

			$this->ssh('rm -rf ' . $GLOBALS['DATA_PATH_AUTOINS_USERS_APP'] . $user_data['name'] . '_appid' . $id_app_todel);
			$out['raw_info'] = 1;
			$out['status'] = 'done';
			break;
		}

		if (isset($list_app['path_' . $id_app_todel])) {
			unset($list_app['path_' . $id_app_todel]);
			unset($list_app['domainurl_' . $id_app_todel]);
			unset($list_app['typeapp_' . $id_app_todel]);
			unset($list_app['typeappgroup_' . $id_app_todel]);
			unset($list_app['nameapp_' . $id_app_todel]);
			unset($list_app['login_admin_' . $id_app_todel]);
			unset($list_app['date_' . $id_app_todel]);
			unset($list_app['db_user_' . $id_app_todel]);
			unset($list_app['db_name_' . $id_app_todel]);
			$index_id = array_search($id_app_todel, $list_app['ids']);
			unset($list_app['ids'][$index_id]);
		}

		$crontab = new crontab();

		foreach ($list_app as $key => $currow) {
			if (stripos($key, 'crontask') !== false) {
				if (stripos($key, '_' . $id_app_todel) !== false) {
					unset($list_app[$key]);
					$convert_to_usercronfile = explode(',', $currow);

					foreach ($convert_to_usercronfile as $keytr => $curtrim) {
						$convert_to_usercronfile[$keytr] = trim($curtrim);
					}

					$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user_data['name']);
					$this->del_string_new(implode(' ', $convert_to_usercronfile), $confUser['rootdir'] . '/crontab');
					$crontab->crontab_load($user_data['name']);
				}
			}
		}

		$list_app['ids'] = implode(',', $list_app['ids']) . ',';
		file_put_contents($GLOBALS['DATA_PATH_AUTOINS_USERS_APP'] . $user_data['name'] . '.conf', '');
		$this->config_save($GLOBALS['DATA_PATH_AUTOINS_USERS_APP'] . $user_data['name'] . '.conf', $list_app);
		return $out;
	}

	public function activate_client_autoins($user_data, $serialdata)
	{
		$decode = json_decode($serialdata, true);
		$stat = array('stat' => (int) $decode['stat']);
		$this->config_save($GLOBALS['DATA_PATH_AUTOINS_CLIENT_AUTOINS_STAT'], $stat);
		$out['status'] = 'done';
		$out['raw_info'] = '1';
		return $out;
	}

	public function get_client_autoins_status()
	{
		$status = $this->config_read($GLOBALS['DATA_PATH_AUTOINS_CLIENT_AUTOINS_STAT']);
		return $status['stat'];
	}

	public function updatelistactapps($user_data, $serialdata)
	{
		$decode = json_decode($serialdata, true);

		if (!$this->check_value('number', $decode)) {
			return false;
		}

		file_put_contents($GLOBALS['DATA_PATH_AUTOINS'] . '/' . $this->fileact_apps, $serialdata);
	}

	public function getlistactapps($user_data)
	{
		$this->listactapps = json_decode(file_get_contents($GLOBALS['DATA_PATH_AUTOINS'] . '/' . $this->fileact_apps), true);
		return $this->listactapps;
	}

	public function get_list_inputdata($serialdata)
	{
		$decode = json_decode($serialdata, true);
		$typeappgroup = $decode['typeappgroup'];
		$nameapp = $decode['nameapp'];
		$url_config = $decode['url_config'];

		if (!$this->check_params('string', $typeappgroup)) {
			return false;
		}

		if (!$this->check_params('string', $nameapp)) {
			return false;
		}

		if (!preg_match('/^(http[s]?:\\/\\/.{3,})?/iu', trim($url_config))) {
			return false;
		}
		if ($url_config) {
			$inputdata = $this->config_read_remote($this->typeapp[$typeappgroup][strval($nameapp)]['input_data']);
			$inputdata['remote_url'] = trim($url_config);
		}
		else {
			$inputdata = $this->config_read_remote('http://core.brainycp.com/src/cms/' . $typeappgroup . '/' . $nameapp . '/inputdata.txt');
		}

		return $inputdata;
	}
}


?>
