<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class backup
{
	public $list_backup_conf = array();
	public $listbackup = array();
	public $list_backup_conf_all = array();
	public $user_tmp = 'tmp';
	public $dir_backup_configs = 'tmp/backups_config';
	public $databackupinfofile = 'data_backup.info';
	public $databackup_streamtmp = 'stream_backup.tmp';
	public $datarestore_streamtmp = 'stream_restore.tmp';
	public $mysql_dir_backup = 'db_backups';
	public $backup_jobs = 'backups_jobs';
	public $backup_jobs_tokens_gdrive = 'gdrive';
	public $backup_jobs_tokens_dropbox = 'dropbox';
	public $backup_emails = 'backups_email';
	public $backup_email_file = 'emails';
	public $backup_email_forward = 'emails_forward';
	public $backup_dns_zone = 'dns_zones';
	public $dkim_keys = 'dkim_keys';
	public $webserver_inc = '/etc/brainy/data/webserver_config/user_includes/';
	public $webserver_inc_backup = 'webserver_config';
	public $mask_username_replace = 'someuser_repl';
	public $mask_homedir_replace = '/somehomedir_repl/';
	public $dir_complete = '/etc/brainy/data/backup/stream/';
	public $timecache_listbackup = 600;
	public $tmp_backup = '/var/tmp/backup/';
	public $gdrive_cred = '/etc/brainy/data/backup/gdrive/';
	public $gdrive_ssh = '/etc/brainy/ssh/gdrive';
	public $drop_cred = '/etc/brainy/data/backup/dropbox/';
	public $drop_ssh = '/etc/brainy/ssh/dropbox.sh';
	public $conn_attempts = 1;
	public $conn_timeout = 21600;
	public $conn_timeoutUpDown = 21600;
	public $connTimeoutFastWait = 20;
	public $conn_interval_attempts = 5;
	public $defaultPortSsh = 22;
	public $defaultPortFtp = 21;
	public $dirConfig = '/etc/brainy/data/backup/config/';

	public function __construct()
	{
		if (stripos($this->backup_jobs, $this->dir_backup_configs) === false) {
			$this->mysql_dir_backup = $this->dir_backup_configs . '/' . $this->mysql_dir_backup;
			$this->backup_jobs = $this->dir_backup_configs . '/' . $this->backup_jobs;
		}

		if (stripos($GLOBALS['BACKUP_DIR_AUTOINS'], $this->dir_backup_configs) === false) {
			$GLOBALS['BACKUP_DIR_AUTOINS'] = $this->dir_backup_configs . '/' . $GLOBALS['BACKUP_DIR_AUTOINS'];
			$GLOBALS['TRANSFER_MYSQL_DIR'] = $this->dir_backup_configs . '/' . $GLOBALS['TRANSFER_MYSQL_DIR'];
			$GLOBALS['BACKUP_DIR_FTPS'] = $this->dir_backup_configs . '/' . $GLOBALS['BACKUP_DIR_FTPS'];
			$GLOBALS['BACKUP_VHOSTS_DIR'] = $this->dir_backup_configs . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'];
			$GLOBALS['BACKUP_USER_INFO_FILE'] = $this->dir_backup_configs . '/' . $GLOBALS['BACKUP_USER_INFO_FILE'];
		}

		require_once '/etc/brainy/lib/punycode/idna_convert.php';

		if (!is_dir($this->tmp_backup)) {
			$this->ssh('mkdir -p ' . $this->tmp_backup);
		}

		if (!is_dir($GLOBALS['BACKUP_HISTORY_LOG_DIR'])) {
			$comm = 'mkdir -p ' . $GLOBALS['BACKUP_HISTORY_LOG_DIR'];
			$this->ssh($comm);
		}

		if (!is_dir($this->gdrive_cred)) {
			$comm = 'mkdir -p ' . $this->gdrive_cred;
			$this->ssh($comm);
		}

		if (!is_dir($this->drop_cred)) {
			$comm = 'mkdir -p ' . $this->drop_cred;
			$this->ssh($comm);
		}

		if (!is_dir($this->dirConfig)) {
			$comm = 'mkdir -p ' . $this->dirConfig;
			$this->ssh($comm);
		}
	}

	public function removetokens($username, $right_root, $config)
	{
		$nameu = explode('_', $config);
		global $lang;

		if (!$this->check_params('filename', $config)) {
			$res['status'] = 0;
			$res['message'] = $lang['backup_tokens_remove_failed'];
			return $res;
		}

		if (strlen($config) < 2) {
			$res['status'] = 0;
			$res['message'] = $lang['backup_tokens_remove_failed'];
			return $res;
		}

		if (($right_root == 'y') || ($username == $nameu[0]) || ($username == 'root')) {
			$comm = 'rm -rf ' . $this->gdrive_cred . $config;
			$this->ssh($comm);
			$comm = 'rm -rf ' . $this->drop_cred . $config;
			$this->ssh($comm);
			$res['status'] = 1;
			$res['message'] = $lang['backup_tokens_remove_ok'];
			file_put_contents('/etc/brainy/data/backup/aaaaaaaa', date('d.M.Y H:i:s') . '---' . $config . '---' . $right_root . '---' . $username . '---' . "\n", FILE_APPEND);
			return $res;
		}

		$res['status'] = -1;
		$res['message'] = $lang['backup_tokens_remove_failed'];
		return $res;
	}

	public function exec_com_sudo($comm, $user)
	{
		if (0 < strlen($user)) {
			$comm = 'sudo -u ' . $user . ' ' . $comm;
		}

		$this->ssh($comm);
	}

	public function change_owner($path, $owner)
	{
		if (!$this->check_value('user', $owner)) {
			return false;
		}

		$comm = 'chown -R ' . $owner . '.' . $owner . ' ' . $path;
		$this->ssh($comm);
		return true;
	}

	public function removemassbackups($userdata, $listbackups_remove)
	{
		foreach ($listbackups_remove as $curbackuprem) {
			$serdata['fileconf'] = $curbackuprem['config'];
			$serdata['filebackup'] = $curbackuprem['file'];
			$serdata['updatenow'] = 0;
			$out = $this->removebackup($userdata, json_encode($serdata, 1));
		}

		sleep(3);
		$param_update_list['action'] = 'getlistbackup';
		$param_update_list['page'] = 0;
		$param_update_list['ippBackups'] = 0;
		$param_update_list['search'] = '|';
		$param_update_list['timecache'] = -2;
		$param_update_list_enc = json_encode($param_update_list, 1);
		$this->getlistbackups_arch_local($userdata, '|', -2, NULL);
		return $out;
	}

	public function getPortServFtp($conf, $type)
	{
		if ($type == 'server') {
			$port = $this->defaultPortSsh;
		}

		if ($type == 'ftp') {
			$port = $this->defaultPortFtp;
		}

		if (isset($conf['backupRemoteServFtpPort']) && (0 < intval($conf['backupRemoteServFtpPort']))) {
			$port = intval($conf['backupRemoteServFtpPort']);
		}

		return $port;
	}

	public function removebackup($user_data, $serialdata, $updateimmediat = 1)
	{
		$decode = json_decode($serialdata, true);

		if ($decode['fileconf']) {
			if (!$this->check_value('strdotx2', $decode['fileconf'])) {
				return 0;
			}
		}

		if ($decode['filebackup']) {
			if (!$this->check_value('strdotx2', $decode['filebackup'])) {
				return 0;
			}
		}

		$fileconf = $decode['fileconf'];
		$filebackup_exp = explode('/', $decode['filebackup']);
		$filebackup = $filebackup_exp[count($filebackup_exp) - 1];
		$namersakey = explode('.', $fileconf)[0];
		$res_perm = $this->checkperm_path($user_data, $fileconf, '_', 'remove');
		global $lang;

		if ($res_perm['res'] != 1) {
			$res['error'] = 1;
			$res['message'] = $lang['backup_deletebackup_err'];
			return $res;
		}

		$res_perm = $this->checkperm_path($user_data, $filebackup, '_', 'remove');

		if ($res_perm['res'] != 1) {
			$res['error'] = 1;
			$res['message'] = $lang['backup_deletebackup_err'];
			return $res;
		}

		if (strlen($filebackup) < 2) {
			$res['error'] = 1;
			$res['message'] = $lang['backup_deletebackup_err'];
			return $res;
		}

		$arr_conf = $this->config_read($GLOBALS['BACKUP_CONF'] . $fileconf);

		if ($arr_conf['backup_repo'] == 'local') {
			if (($arr_conf['backup_type_arch_array'] == 'incr_noarch') || ($arr_conf['backup_type_arch_array'] == 'tar') || ($arr_conf['backup_type_arch_array'] == 'simple_noarch')) {
				$comm = 'rm -rf \'' . $this->strip_quotes_cmd($arr_conf['backup_pathlocal'] . '/' . $filebackup) . '\'';
				$this->ssh($comm);
				$res['id'] = 0;
				$res['error'] = '0';
				$res['message'] = 'ok';
			}
		}

		if ($arr_conf['backup_repo'] == 'remote') {
			$port = $this->getPortServFtp($arr_conf, 'server');

			if ($arr_conf['backup_type_auth'] == 'key') {
				if (($arr_conf['backup_type_arch_array'] == 'incr_noarch') || ($arr_conf['backup_type_arch_array'] == 'tar') || ($arr_conf['backup_type_arch_array'] == 'simple_noarch')) {
					$ip = $arr_conf['backup_remoteip'];
					$remote_dir = $arr_conf['backup_remote_path'];
					$pass = $this->decryptmainfunc($arr_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
					$user = $arr_conf['backup_remote_login'];
					$comm = 'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'rm -rf ' . $remote_dir . '/' . $filebackup . ';rm -rf ' . $remote_dir . '/' . $filebackup . '.md5\'';
					$this->ssh($comm);
					$res['id'] = 0;
					$res['error'] = '0';
					$res['message'] = 'ok';
				}
			}

			if ($arr_conf['backup_type_auth'] == 'pass') {
				if (($arr_conf['backup_type_arch_array'] == 'incr_noarch') || ($arr_conf['backup_type_arch_array'] == 'tar') || ($arr_conf['backup_type_arch_array'] == 'simple_noarch')) {
					$ip = $arr_conf['backup_remoteip'];
					$remote_dir = $arr_conf['backup_remote_path'];
					$pass = $this->decryptmainfunc($arr_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
					$user = $arr_conf['backup_remote_login'];
					$comm = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' -o ConnectTimeout=' . $this->connTimeoutFastWait . ' -o ConnectionAttempts=' . $this->conn_attempts . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'rm -rf ' . $remote_dir . '/' . $filebackup . ';rm -rf ' . $remote_dir . '/' . $filebackup . '.md5\'';
					$this->ssh($comm);
					$res['id'] = 0;
					$res['error'] = '0';
					$res['message'] = 'ok';
				}
			}
		}

		if ($arr_conf['backup_repo'] == 'ftp') {
			$ip = $arr_conf['backup_remoteip'];
			$remote_dir = $arr_conf['backup_remote_path'];
			$pass = $this->decryptmainfunc($arr_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
			$user = $arr_conf['backup_remote_login'];
			$port = $this->getPortServFtp($arr_conf, 'ftp');
			$comm = 'lftp -p ' . $port . ' -u \'' . $arr_conf['backup_remote_login'] . ',' . $pass . '\' ' . $arr_conf['backup_remoteip'] . ' -e \'set net:reconnect-interval-base ' . $this->conn_interval_attempts . ';  set net:timeout ' . $this->conn_timeout . '; set net:max-retries ' . $this->conn_attempts . '; rm  ' . $remote_dir . '/' . $filebackup . ';quit\'';
			$this->ssh($comm);
			$res['id'] = 0;
			$res['error'] = '0';
			$res['message'] = 'ok';
		}

		if ($arr_conf['backup_repo'] == 'YandexDisk') {
			$ip = $arr_conf['backup_remoteip'];
			$remote_dir = $arr_conf['backup_remote_path'];
			$pass = $this->decryptmainfunc($arr_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
			$user = $arr_conf['backup_remote_login'];
			$res = array();
			$ydBackup = NULL;

			try {
				$ydBackup = new YDiskBackup($pass, '', '', false, true, false);
				$isConn = $ydBackup->isConn($remote_dir);

				if (0 < $isConn) {
					$res['status'] = 1;
				}
				else {
					$res['status'] = -1;
				}
			}
			catch (Arhitector\Yandex\Client\Exception\UnauthorizedException $exc) {
				$res['code'] = -1;
				$res['status'] = -1;
			}
			catch (Exception $exc) {
				$res['code'] = -1;
				$res['status'] = -1;
				return $res;
			}

			$lang = &json_decode($serialdata, true);

			if ($res['code'] == 1) {
				$res['id'] = -2;
				$res['error'] = -2;
				$res['message'] = $lang['backupYaErrAuthFailed'];
			}
			else {
				$pathToDown = $remote_dir . '/' . $filebackup;
				$pathToDown = preg_replace('/(\\/+)/', '/', $pathToDown);
				$resFile = $ydBackup->disk->getResource($pathToDown);

				if ($resFile->has()) {
					$resFile->delete(true);
				}
				else {
					$res['id'] = -2;
					$res['error'] = -2;
					$res['message'] = $lang['backupYaErrAuthFailed'];
				}
			}

			$res['id'] = 0;
			$res['error'] = '0';
			$res['message'] = 'ok';
		}

		if ($arr_conf['backup_repo'] == 'GoogleDrive') {
			$remote_dir = $arr_conf['backup_remote_path'];
			$filedel = str_replace('/', '', $remote_dir . $filebackup);
			$list = $this->gdrive_ls($fileconf, $remote_dir, $user_data);

			if ((0 < count($list)) && !isset($list['code'])) {
				foreach ($list as $user_backup) {
					$fulldata = preg_split('/[\\s,;]/', $user_backup);
					$fulldata = array_values(array_filter($fulldata));
					$nosl = str_replace('/', '', $fulldata[1]);

					if ($nosl == $filedel) {
						$fileid = $fulldata[0];
						$comm = $this->gdrive_ssh . ' --config ' . $this->gdrive_cred . $fileconf . ' delete ' . $fileid;
						$this->ssh($comm);
					}
				}
			}

			$res['id'] = 0;
			$res['error'] = '0';
			$res['message'] = 'ok';
		}

		if ($arr_conf['backup_repo'] == 'Dropbox') {
			$remote_dir = $arr_conf['backup_remote_path'];
			$filedel = $remote_dir . '/' . $filebackup;
			$comm = $this->drop_ssh . ' -f ' . $this->drop_cred . $fileconf . ' delete \'' . $filedel . '\'';
			$this->ssh($comm);
			$res['id'] = 0;
			$res['error'] = '0';
			$res['message'] = 'ok';
		}

		$update = 1;

		if (isset($decode['updatenow'])) {
			if ($decode['updatenow'] == 0) {
				$update = 0;
			}
		}

		if ($update == 1) {
			$param_update_list['timecache'] = -2;
			$param_update_list_enc = json_encode($param_update_list, 1);

			if ($updateimmediat == 1) {
				$this->getlistbackups_arch_local($user_data, '|', -2);
			}
		}

		return $res;
	}

	public function run_cron_backup($user_data, $mysql)
	{
		$this->checkhistory_restore($user_data);
		$this->checkhistory_backup($user_data);
		$max_diff_for_run_again = 1100;
		$max_diff_cron_delay_check = 700;
		$file_cache = $GLOBALS['BACKUP_CONF'] . '/' . $GLOBALS['BACKUP_CACHE_CRON'];
		$arr_cache_task = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($file_cache));
		echo 'startcron' . "\n";

		foreach ($arr_cache_task as $task_file) {
			$qflag_start_new_task = 0;
			$exp_cron = explode('|', $task_file);

			if (2 < count($exp_cron)) {
				$task = $exp_cron[0];
				$user_checkproc = explode('_', $task)[0];

				if ($user_checkproc == 'config') {
					$user_checkproc = 'root';
				}

				$this->checkhistory_restore(array('name' => $user_checkproc));
				$this->checkhistory_backup(array('name' => $user_checkproc));
				$period = $exp_cron[1];
				$time = $exp_cron[2];
				$time_exp = explode(':', $time);
				$hour = $time_exp[0];
				$minute = $time_exp[1];
				$sec = $time_exp[2];
				$week_days = '';
				$month_days = '';

				if ($period == 'week') {
					$week_days = explode(',', $exp_cron[3]);
				}

				if ($period == 'month') {
					$month_days = explode(',', $exp_cron[3]);
				}

				$crontask_time = new DateTime(date('d.m.Y'));
				$crontask_time->setTime($hour, $minute, $sec);
				$crontask_time = $crontask_time->format('d.m.Y H:i:s');
				$crontask_time = strtotime($crontask_time);
				$timenow = time();
				$diff = $timenow - $crontask_time;

				if (($diff < $max_diff_cron_delay_check) && (0 < $diff)) {
					$stat = $exp_cron[count($exp_cron) - 1];

					if (strpos($stat, 'start') !== false) {
						$stat = str_replace('start', '', $stat);
						$stat = trim(intval($stat));
						$diff_from_start = $timenow - $stat;
						echo $diff_from_start . "\n";

						if ($max_diff_for_run_again < $diff_from_start) {
							if ($period == 'day') {
								$qflag_start_new_task = 1;
							}

							if ($period == 'week') {
								if ($week_days[date('N') - 1] == 1) {
									$qflag_start_new_task = 1;
								}
							}

							if ($period == 'month') {
								if (in_array(date('j'), $month_days)) {
									$qflag_start_new_task = 1;
								}
							}
						}
					}
					else {
						if ($period == 'day') {
							$qflag_start_new_task = 1;
						}

						if ($period == 'week') {
							if ($week_days[date('N') - 1] == 1) {
								$qflag_start_new_task = 1;
							}
						}

						if ($period == 'month') {
							if (in_array(date('j'), $month_days)) {
								$qflag_start_new_task = 1;
							}
						}
					}

					if ($qflag_start_new_task == 1) {
						$week_days = implode(',', $week_days);
						$month_days = implode(',', $month_days);
						$this->update_cache_cron_task($task, $period, $time, $week_days, $month_days, '|start' . time());
						$serdata['command'] = 'create';
						$arr_conf = $this->config_read($GLOBALS['BACKUP_CONF'] . $task);
						$this->createarch_local_stream(time(), 0, $user_data, json_encode($serdata), $arr_conf, 0, $mysql, $task);
					}
				}
			}
		}
	}

	public function add_cache_cron_task($task = NULL, $backup_period = NULL, $backup_time_start = NULL, $backup_weekly_days = NULL, $backup_monthly_select_date = NULL)
	{
		$file_cache = $GLOBALS['BACKUP_CONF'] . '/' . $GLOBALS['BACKUP_CACHE_CRON'];

		if ($backup_period == 'week') {
			file_put_contents($file_cache, $task . '|' . $backup_period . '|' . $backup_time_start . '|' . $backup_weekly_days . "\n", LOCK_EX | FILE_APPEND);
		}

		if ($backup_period == 'month') {
			file_put_contents($file_cache, $task . '|' . $backup_period . '|' . $backup_time_start . '|' . $backup_monthly_select_date . "\n", LOCK_EX | FILE_APPEND);
		}

		if ($backup_period == 'day') {
			file_put_contents($file_cache, $task . '|' . $backup_period . '|' . $backup_time_start . "\n", LOCK_EX | FILE_APPEND);
		}
	}

	public function delete_cache_cron_task($task = NULL)
	{
		$file_cache = $GLOBALS['BACKUP_CONF'] . '/' . $GLOBALS['BACKUP_CACHE_CRON'];
		$arr_cache_task = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($file_cache));
		file_put_contents($file_cache, '', LOCK_EX);

		foreach ($arr_cache_task as $task_file) {
			$exp_task = explode('|', $task_file)[0];

			if ($exp_task != $task) {
				if (1 < strlen($task_file)) {
					file_put_contents($file_cache, $task_file . "\n", FILE_APPEND | LOCK_EX);
				}
			}
		}
	}

	public function update_cache_cron_task($task = NULL, $backup_period = NULL, $backup_time_start = NULL, $backup_weekly_days = NULL, $backup_monthly_select_date = NULL, $stat = NULL)
	{
		$file_cache = $GLOBALS['BACKUP_CONF'] . '/' . $GLOBALS['BACKUP_CACHE_CRON'];
		$arr_cache_task = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($file_cache));
		$upd_ok = 0;
		file_put_contents($file_cache, '', LOCK_EX);

		foreach ($arr_cache_task as $task_file) {
			$exp_task = explode('|', $task_file)[0];

			if ($exp_task != $task) {
				if (1 < strlen($task_file)) {
					if (is_file($GLOBALS['BACKUP_CONF'] . '/' . $exp_task)) {
						file_put_contents($file_cache, $task_file . "\n", FILE_APPEND | LOCK_EX);
					}
				}
			}
			else {
				if (is_null($stat)) {
					$stat = '';
				}

				if ($backup_period == 'week') {
					$upd_ok = 1;
					file_put_contents($file_cache, $task . '|' . $backup_period . '|' . $backup_time_start . '|' . $backup_weekly_days . $stat . "\n", LOCK_EX | FILE_APPEND);
				}

				if ($backup_period == 'month') {
					$upd_ok = 1;
					file_put_contents($file_cache, $task . '|' . $backup_period . '|' . $backup_time_start . '|' . $backup_monthly_select_date . $stat . "\n", LOCK_EX | FILE_APPEND);
				}

				if ($backup_period == 'day') {
					$upd_ok = 1;
					file_put_contents($file_cache, $task . '|' . $backup_period . '|' . $backup_time_start . $stat . "\n", LOCK_EX | FILE_APPEND);
				}
			}
		}

		if ($upd_ok == 0) {
			$this->add_cache_cron_task($task, $backup_period, $backup_time_start, $backup_weekly_days, $backup_monthly_select_date);
		}
	}

	public function cache_cron_task($task = NULL)
	{
		$task = $this->strip_quotes_cmd($task);
		$user_data = NULL;
		$file_cache = $GLOBALS['BACKUP_CONF'] . '/' . $GLOBALS['BACKUP_CACHE_CRON'];

		if (is_null($task)) {
			file_put_contents($file_cache, '', LOCK_EX);
		}

		$res = scandir($GLOBALS['BACKUP_CONF']);

		foreach ($res as $elem) {
			if (is_file($GLOBALS['BACKUP_CONF'] . $elem) && ($elem != '.') && ($elem != '..')) {
				$nameu = explode('_', $elem);

				if (1 < count($nameu)) {
					if (stripos($elem, 'cache') !== false) {
						continue;
					}

					$arrfi['backup_configfile'] = $elem;
					$ser = json_encode($arrfi);
					$arrparamconf = $this->getconfig($user_data, $ser);

					if ($arrparamconf['backup_period'] == 'day') {
						file_put_contents($file_cache, $elem . '|' . $arrparamconf['backup_period'] . '|' . $arrparamconf['backup_time_start'] . "\n", LOCK_EX | FILE_APPEND);
					}

					if ($arrparamconf['backup_period'] == 'week') {
						file_put_contents($file_cache, $elem . '|' . $arrparamconf['backup_period'] . '|' . $arrparamconf['backup_time_start'] . '|' . $arrparamconf['backup_weekly_days'] . "\n", LOCK_EX | FILE_APPEND);
					}

					if ($arrparamconf['backup_period'] == 'month') {
						file_put_contents($file_cache, $elem . '|' . $arrparamconf['backup_period'] . '|' . $arrparamconf['backup_time_start'] . '|' . $arrparamconf['backup_monthly_select_date'] . "\n", LOCK_EX | FILE_APPEND);
					}
				}
			}
		}
	}

	public function getconfig_filelist($user_data, $serialdata)
	{
		if ($user_data['name']) {
			if (!$this->check_value('user', $user_data['name'])) {
				return 0;
			}
		}

		$file_cache_listconf = $GLOBALS['BACKUP_CONF'] . '/listconfcache-' . $user_data['name'];
		$decode = json_decode($serialdata, true);
		$workspace = '';

		if ($user_data['group_properties']['root'] != 'y') {
			$hostacc = new hostacc();
			$workspace = $hostacc->getWorkspace($user_data['username']);

			if (0 < strlen($workspace)) {
				$workspace = $workspace . '/';
			}
		}

		$usersel = '';

		if (isset($decode['usersel'])) {
			$usersel = $decode['usersel'];
		}

		if ($usersel != 'showallusers') {
			if (!$this->check_params('user_string', $usersel)) {
				$usersel = '';
			}
		}
		else {
			$usersel = '';
		}

		$timecache = $this->timecache_listbackup;

		if (isset($decode['timecache'])) {
			$timecache = intval($decode['timecache']);
		}

		$flaggetfull = 0;

		if (is_file($file_cache_listconf)) {
			$timefile = filemtime($file_cache_listconf);

			if ((time() - $timefile) < $timecache) {
				$res = unserialize(file_get_contents($file_cache_listconf));
				return $res;
			}

			$flaggetfull = 1;
		}
		else {
			$flaggetfull = 1;
		}

		if ($flaggetfull == 0) {
			return 1;
		}

		$res = scandir($GLOBALS['BACKUP_CONF']);
		$ind = 0;

		foreach ($res as $elem) {
			if (is_file($GLOBALS['BACKUP_CONF'] . $elem) && ($elem != '.') && ($elem != '..')) {
				$nameu = explode('_', $elem);

				if (1 < count($nameu)) {
					if (($user_data['group_properties']['root'] == 'y') || ($user_data['name'] == $nameu[0])) {
						if (($user_data['group_properties']['root'] == 'y') && (1 < strlen($usersel))) {
							if (($usersel == 'root') && ($nameu[0] == 'config')) {
							}
							else if ($nameu[0] != $usersel) {
								continue;
							}
						}

						$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $nameu[0]);
						$this->list_backup_conf[] = $elem;
						$arrfi['backup_configfile'] = $elem;
						$ser = json_encode($arrfi);

						if (stripos($elem, 'cache') !== false) {
							continue;
						}

						$arrparamconf = $this->getconfig($user_data, $ser);
						$this->list_backup_conf[$ind] = array();
						$this->list_backup_conf[$ind][$elem] = $arrparamconf;
						$this->list_backup_conf[$ind][$elem]['backup_key_priv'] = '';
						$this->list_backup_conf[$ind][$elem]['backup_key'] = '';
						$this->list_backup_conf[$ind][$elem]['backup_remote_pass'] = '';
						$this->list_backup_conf[$ind][$elem]['homepath'] = $confUser['rootdir'];
						$this->list_backup_conf[$ind][$elem]['username'] = $user_data['username'];
						$this->list_backup_conf[$ind][$elem]['workspace'] = $workspace;
						++$ind;
					}
				}
			}
		}

		if ($user_data['group_properties']['root'] == 'y') {
			$list_users = $this->get_users();
			array_multisort($list_users, SORT_ASC, SORT_STRING);
			$this->list_backup_conf['users'] = $list_users;
		}

		if (!is_file($GLOBALS['known_hosts_path'])) {
			$comm = 'cat > ' . $GLOBALS['known_hosts_path'];
			$this->ssh($comm);
		}

		file_put_contents($file_cache_listconf, serialize($this->list_backup_conf));
		return $this->list_backup_conf;
	}

	public function getconfigmain(&$arr_conf)
	{
		$mainconf = preg_split('/\\r\\n|\\r|\\n/', file_get_contents('/etc/brainy/data/backup/mainconf.conf'));

		foreach ($mainconf as $curconfrow) {
			$expdata = explode('=', $curconfrow);
			$arr_conf[$expdata[0]] = explode('|', $expdata[1]);
		}

		return $arr_conf;
	}

	public function getconfig($user_data, $serialdata)
	{
		$decode = json_decode($serialdata, true);

		if (0 < strlen($decode['backup_configfile'])) {
			if (!$this->check_value('dir', $decode['backup_configfile'])) {
				return 0;
			}
		}

		$nameconfig = $decode['backup_configfile'];

		if (stripos($nameconfig, 'cache') !== false) {
			return 0;
		}

		$arr_conf = $this->config_read($GLOBALS['BACKUP_CONF'] . $nameconfig);
		$this->getconfigmain($arr_conf);
		$namersakey = explode('.', $nameconfig)[0];

		if (is_file($GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . $GLOBALS['BACKUP_KEY_RSA_MASK_PUB'])) {
			$arr_conf['backup_key'] = file_get_contents($GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . $GLOBALS['BACKUP_KEY_RSA_MASK_PUB']);
		}

		if (is_file($GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey)) {
			$arr_conf['backup_key_priv'] = file_get_contents($GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey);
		}

		$arr_conf['taskconf'] = $nameconfig;
		$arr_conf['timeconf'] = date('d.m.Y H:i:s', filemtime($GLOBALS['BACKUP_CONF'] . $nameconfig));
		$exp_sel_days_weekly = explode(',', $arr_conf['backup_weekly_days']);
		$arr_conf['backup_weekly_mon'] = $exp_sel_days_weekly[0];
		$arr_conf['backup_weekly_tue'] = $exp_sel_days_weekly[1];
		$arr_conf['backup_weekly_wed'] = $exp_sel_days_weekly[2];
		$arr_conf['backup_weekly_thu'] = $exp_sel_days_weekly[3];
		$arr_conf['backup_weekly_fri'] = $exp_sel_days_weekly[4];
		$arr_conf['backup_weekly_sat'] = $exp_sel_days_weekly[5];
		$arr_conf['backup_weekly_sun'] = $exp_sel_days_weekly[6];
		$exp_timestart = explode(':', $arr_conf['backup_time_start']);
		$arr_conf['backup_time_start_hour'] = $exp_timestart[0];
		$arr_conf['backup_time_start_minute'] = $exp_timestart[1];
		$arr_conf['backup_time_start_second'] = $exp_timestart[2];
		$arr_conf['taskconfcred'] = '';

		if (is_dir($this->gdrive_cred . $nameconfig)) {
			$arr_conf['taskconfcred'] = $nameconfig;
		}

		if (is_file($this->drop_cred . $nameconfig)) {
			$arr_conf['taskconfcred'] = $nameconfig;
		}

		$exp_sel_days_monthly = explode(',', $arr_conf['backup_monthly_select_date']);
		$arr_conf['backup_monthly_days'] = $exp_sel_days_monthly;
		$arr_conf['encfilepass'] = $this->decryptmainfunc($arr_conf['encfilepass'], $GLOBALS['cryptkeymain']);
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user_data['username']);
		$workspace = '';

		if ($user_data['group_properties']['root'] != 'y') {
			$hostacc = new hostacc();
			$workspace = $hostacc->getWorkspace($user_data['username']);

			if (0 < strlen($workspace)) {
				$workspace = $workspace . '/';
			}

			$arr_conf['workspace'] = $confUser['rootdir'] . '/' . $workspace;
		}
		else {
			$arr_conf['workspace'] = '';
		}

		$arr_conf['homepath'] = $confUser['rootdir'];
		$arr_conf['username'] = $user_data['username'];
		$arr_conf['workspace'] = $workspace;
		return $arr_conf;
	}

	public function generatekeyrsa($user_data, $serialdata)
	{
		$decode = json_decode($serialdata, true);

		if (0 < strlen($decode['taskconf'])) {
			if (!$this->check_value('strdot', $decode['taskconf'])) {
				return 0;
			}
		}

		$nameconfig = $decode['taskconf'];
		$namersakey = explode('.', $nameconfig)[0];
		$comm = 'echo -e  \'y' . "\n" . '\' | ssh-keygen -f ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' -t rsa -N \'\'';
		$this->ssh($comm);
		$out['status'] = 'done';
		$out['raw_info'] = file_get_contents($GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . $GLOBALS['BACKUP_KEY_RSA_MASK_PUB']);
		$out['raw_info_priv'] = file_get_contents($GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey);
		return $out;
	}

	public function savekeyrsa($user_data, $serialdata)
	{
		$decode = json_decode($serialdata, true);

		if (0 < strlen($decode['taskconf'])) {
			if (!$this->check_value('strdot', $decode['taskconf'])) {
				return 0;
			}
		}

		$nameconfig = $decode['taskconf'];
		$namersakey = explode('.', $nameconfig)[0];
		$keyrsa = $decode['keyrsa'];
		$keyrsaprivate = $decode['keyrsaprivate'];
		file_put_contents($GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . $GLOBALS['BACKUP_KEY_RSA_MASK_PUB'], $keyrsa);
		file_put_contents($GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey, $keyrsaprivate);
		$out['status'] = 'done';
		$out['raw_info'] = 1;
		$comm = 'chmod 0600 ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey;
		$this->ssh($comm);
		return $out;
	}

	public function saveconfig($user_data, $serialdata)
	{
		if (!is_dir($GLOBALS['BACKUP_CONF'])) {
			$this->ssh('mkdir -p ' . $GLOBALS['BACKUP_CONF']);
		}

		if (!is_dir($GLOBALS['BACKUP_CONF_STREAM'])) {
			$this->ssh('mkdir -p ' . $GLOBALS['BACKUP_CONF_STREAM']);
		}

		$decode = json_decode($serialdata, true);

		if (0 < strlen($decode['backup_file_config'])) {
			$decode['backup_file_config'] = $this->strip_quotes_cmd($decode['backup_file_config']);
		}

		if (0 < strlen($decode['backup_pathlocal'])) {
			$decode['backup_pathlocal'] = $this->strip_quotes_cmd($decode['backup_pathlocal']);
		}

		if (0 < strlen($decode['backup_remote_pass'])) {
			$decode['backup_remote_pass'] = $this->strip_quotes_cmd($decode['backup_remote_pass']);
		}

		if (0 < strlen($decode['backup_repo'])) {
			$decode['backup_repo'] = $this->strip_quotes_cmd($decode['backup_repo']);
		}

		if (0 < strlen($decode['backup_remote_path'])) {
			$decode['backup_remote_path'] = $this->strip_quotes_cmd($decode['backup_remote_path']);
		}

		global $lang;

		if (0 < strlen($decode['backupRemoteServFtpPort'])) {
			if (!is_numeric($decode['backupRemoteServFtpPort'])) {
				$out['err'] = 1;
				$out['mess'][] = $lang['backupRemoteConnPortErr'];
			}
		}
		else {
			$decode['backupRemoteServFtpPort'] = 0;
		}

		$backup_file_config = $decode['backup_file_config'];
		$newtask = 0;

		if (strlen($backup_file_config) < 2) {
			$newtask = 1;
			if (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['root'] == 'y')) {
				$backup_file_config = 'config_' . time() . '.conf';
			}
			else {
				$backup_file_config = $user_data['name'] . '_' . time() . '.conf';
			}
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user_data['name']);
		if (($user_data['group_properties']['root'] != 'y') || (stripos($backup_file_config, 'config_') === false)) {
			if (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['root'] == 'y')) {
				$userbackup = explode('_', $backup_file_config)[0];
			}
			else {
				$userbackup = $user_data['name'];
			}

			if ($decode['backup_repo'] == 'local') {
				if (stripos($decode['backup_pathlocal'], $confUser['rootdir'] . '/') === false) {
					$test = str_replace('/', '', $decode['backup_pathlocal']);

					if (strlen($test) < 1) {
						$out['err'] = 1;
						$out['mess'][] = $lang['backup_local_dir_userbackup'];
					}

					$hostacc = new hostacc();
					$workspace = $hostacc->getWorkspace($userbackup);

					if (0 < strlen($workspace)) {
						$workspace = $workspace . '/';
					}

					$decode['backup_pathlocal'] = $confUser['rootdir'] . '/' . $workspace . $decode['backup_pathlocal'];
					$decode['backup_pathlocal'] = str_replace('//', '/', $decode['backup_pathlocal']);
				}
			}
		}

		if (strpos($decode['backup_remote_pass'], '*****') !== false) {
			$arrfi['backup_configfile'] = $backup_file_config;
			$serialdata = json_encode($arrfi);
			$decode_old_var = $this->getconfig($user_data, $serialdata);
			$decode['backup_remote_pass'] = $this->decryptmainfunc($decode_old_var['backup_remote_pass'], $GLOBALS['cryptkeymain']);
		}

		if ($decode['backup_repo'] == 'local') {
			if (!preg_match('@^[A-z0-9/!=_-]+$@uSi', $decode['backup_pathlocal'])) {
				$out['err'] = 1;
				$out['mess'][] = $lang['backup_pathlocaldir_wrong'];
			}
		}

		if (($decode['backup_pathlocal'][0] != '/') && ($decode['backup_pathlocal'][1] != '/')) {
			$decode['backup_pathlocal'] = '/' . $decode['backup_pathlocal'];
		}

		if (($decode['backup_remote_path'][0] != '/') && ($decode['backup_remote_path'][1] != '/')) {
			$decode['backup_remote_path'] = '/' . $decode['backup_remote_path'];
		}

		if ($decode['backup_repo'] == 'remote') {
			if (!preg_match('@^[A-z0-9/_=.-]+$@uSi', $decode['backup_remoteip'])) {
				$out['err'] = 1;
				$out['mess'][] = $lang['backup_remoteip_wrong'];
			}
		}

		if ($decode['backup_repo'] == 'remote') {
			if (!preg_match('@^([.]{0,1}[A-z0-9/!=_-])+$@uSi', $decode['backup_remote_path'])) {
				$out['err'] = 1;
				$out['mess'][] = $lang['backup_pathremotedir_wrong'];
			}
		}

		if (!preg_match('@^[A-z0-9!=_-]+$@uSi', $decode['backup_type_arch_array'])) {
			$out['err'] = 1;
			$out['mess'][] = $lang['backup_typearch_wrong'];
		}

		if (!preg_match('@^[A-z0-9!=_-]+$@uSi', $decode['backup_repo'])) {
			$out['err'] = 1;
			$out['mess'][] = $lang['backup_typearch_wrong'];
		}

		if (($decode['backup_repo'] == 'remote') && ($decode['backup_type_auth'] == 'pass')) {
			if (!preg_match('@^[A-z0-9!=_-]+$@uSi', $decode['backup_remote_login'])) {
				$out['err'] = 1;
				$out['mess'][] = $lang['backup_remote_login_wrong'];
			}
		}

		if (!preg_match('@^[A-zа-я0-9/!=_-]+$@uSi', $decode['backup_nametask'])) {
			$out['err'] = 1;
			$out['mess'][] = $lang['backup_nametask_wrong'];
		}

		if (!preg_match('@^[A-z0-9!=_-]+$@uSi', $decode['backup_period'])) {
			$out['err'] = 1;
			$out['mess'][] = $lang['backup_period_wrong'];
		}

		if (!preg_match('/(2[0-4]|[01][0-9]|10|[0-9])/', $decode['backup_time_start_hour'])) {
			$out['err'] = 1;
			$out['mess'][] = $lang['backup_time_start_wrong'];
		}

		if (!preg_match('/[0-5][0-9]|[0-9]/', $decode['backup_time_start_minute'])) {
			$out['err'] = 1;
			$out['mess'][] = $lang['backup_time_start_wrong'];
		}

		if (!preg_match('@^[0-1,.]+$@uSi', $decode['backup_weekly_days'])) {
			$out['err'] = 1;
			$out['mess'][] = $lang['backup_weekly_days_wrong'];
		}

		if ($decode['backup_period'] == 'month') {
			if (!preg_match('@^[0-9,]+$@uSi', $decode['backup_monthly_select_date'])) {
				$out['err'] = 1;
				$out['mess'][] = $lang['backup_monthly_select_date_wrong'];
			}
		}

		if ($decode['backup_type_arch_array'] == 'tar') {
			if (!preg_match('@^[0-9]+$@uSi', $decode['backup_level_compress'])) {
				$out['err'] = 1;
				$out['mess'][] = $lang['backup_level_compress_wrong'];
			}
		}

		if (!preg_match('@^[A-zа-я0-9]+$@uSi', $decode['backup_type_auth'])) {
			$out['err'] = 1;
			$out['mess'][] = $lang['backup_type_auth_wrong'];
		}

		if (($decode['backup_type_arch_array'] == 'incr_noarch') || ($decode['backup_type_arch_array'] == 'simple_noarch')) {
			if (!preg_match('@^[0-9]+$@uSi', $decode['backup_rsync_speed_limit_kb'])) {
				$out['err'] = 1;
				$out['mess'][] = $lang['backup_rsync_speed_limit_kb_wrong'];
			}
		}

		if (!preg_match('@^[0-9]+$@uSi', $decode['backup_denywritebackup'])) {
			$out['err'] = 1;
			$out['mess'][] = $lang['backup_denywritebackup_wrong'];
		}

		if (!preg_match('@^[0-9]+$@uSi', $decode['backup_denywritebackup'])) {
			$out['err'] = 1;
			$out['mess'][] = $lang['backup_denywritebackup_wrong'];
		}

		$sendemailaftercomplete = intval($decode['sendemailaftercomplete']);

		if ($sendemailaftercomplete == 1) {
			$listemail = preg_split('/[\\s,;]/', $decode['emaillistcomplete']);

			foreach ($listemail as $curemail) {
				if (!$this->check_value('email', $curemail)) {
					$out['err'] = 1;
					$out['mess'][] = $lang['backup_config_sendemail_aftercomplete_list_fail'];
				}
			}
		}

		$emaillistcomplete = $decode['emaillistcomplete'];
		$encryptbackup = intval($decode['encryptbackup']);

		if ($encryptbackup == 1) {
			if ($decode['encfilepass'] != $decode['encfilepassretype']) {
				$out['err'] = 1;
				$out['mess'][] = $lang['backup_encbackupenterpassmismatch'];
			}
		}

		$encfilepass = $decode['encfilepass'];

		if ($decode['backup_type_arch_array'] != 'incr_noarch') {
			if (!preg_match('@^[0-9]+$@uSi', $decode['backup_maxcountbackups'])) {
				$out['err'] = 1;
				$out['mess'][] = $lang['backup_wrongformat_maxcountbackups'];
			}
		}

		if (isset($out)) {
			$out['status'] = 'done';
			$out['raw_info'] = -1;
			return $out;
		}

		$out['err'] = 0;
		$backup_conf_stat = intval($decode['backup_conf_stat']);
		$backup_pathlocal = htmlspecialchars($decode['backup_pathlocal'], ENT_QUOTES);
		$backup_remoteip = htmlspecialchars($decode['backup_remoteip'], ENT_QUOTES);
		$backup_remote_path = htmlspecialchars($decode['backup_remote_path'], ENT_QUOTES);
		$backup_type_arch_array = htmlspecialchars($decode['backup_type_arch_array'], ENT_QUOTES);
		$backup_repo = htmlspecialchars($decode['backup_repo'], ENT_QUOTES);
		$backup_remote_login = htmlspecialchars($decode['backup_remote_login'], ENT_QUOTES);
		$backup_remote_pass = htmlspecialchars($decode['backup_remote_pass'], ENT_QUOTES);
		$backup_nametask = htmlspecialchars($decode['backup_nametask'], ENT_QUOTES);
		$backup_period = htmlspecialchars($decode['backup_period'], ENT_QUOTES);
		$backup_time_start = $decode['backup_time_start_hour'] . ':' . $decode['backup_time_start_minute'] . ':00';
		$backup_weekly_days = htmlspecialchars($decode['backup_weekly_days'], ENT_QUOTES);
		$backup_monthly_select_date = htmlspecialchars($decode['backup_monthly_select_date'], ENT_QUOTES);
		$backup_level_compress = intval($decode['backup_level_compress']);
		$backup_type_auth = htmlspecialchars($decode['backup_type_auth'], ENT_QUOTES);
		$backup_rsync_speed_limit_kb = intval($decode['backup_rsync_speed_limit_kb']);
		$backup_denywritebackup = intval($decode['backup_denywritebackup']);
		$backupRemoteServFtpPort = intval($decode['backupRemoteServFtpPort']);

		if (($newtask == 1) && ($backup_conf_stat == 1)) {
			$this->add_cache_cron_task($backup_file_config, $backup_period, $backup_time_start, $backup_weekly_days, $backup_monthly_select_date);
		}

		if ($newtask != 1) {
			if ($backup_conf_stat == 1) {
				$this->update_cache_cron_task($backup_file_config, $backup_period, $backup_time_start, $backup_weekly_days, $backup_monthly_select_date);
			}
			else {
				$this->delete_cache_cron_task($backup_file_config);
			}
		}

		if (isset($decode['backup_selected_users'])) {
			$backup_selected_users = '';

			if ($decode['backup_selected_users'] != -1) {
				foreach ($decode['backup_selected_users'] as $selecteduser) {
					$backup_selected_users .= htmlspecialchars($selecteduser, ENT_QUOTES) . ',';
				}
			}
			else {
				$backup_selected_users = -1;
			}

			$backup_make_for_all_users = intval($decode['backup_make_for_all_users']);
		}
		else {
			$backup_selected_users = $user_data['name'];
			$backup_make_for_all_users = -1;
		}

		$backup_maxcountbackups = intval($decode['backup_maxcountbackups']);
		$arr_conf = array('backup_pathlocal' => $backup_pathlocal, 'backup_remoteip' => $backup_remoteip, 'backup_remote_path' => $backup_remote_path, 'backup_type_arch_array' => $backup_type_arch_array, 'backup_repo' => $backup_repo, 'backup_remote_login' => $backup_remote_login, 'backup_remote_pass' => $this->cryptmainfunc($backup_remote_pass, $GLOBALS['cryptkeymain']), 'backup_nametask' => $backup_nametask, 'backup_period' => $backup_period, 'backup_time_start' => $backup_time_start, 'backup_weekly_days' => $backup_weekly_days, 'backup_monthly_select_date' => $backup_monthly_select_date, 'backup_level_compress' => $backup_level_compress, 'backup_type_auth' => $backup_type_auth, 'backup_rsync_speed_limit_kb' => $backup_rsync_speed_limit_kb, 'backup_selected_users' => $backup_selected_users, 'backup_make_for_all_users' => $backup_make_for_all_users, 'backup_denywritebackup' => $backup_denywritebackup, 'backup_conf_stat' => $backup_conf_stat, 'sendemailaftercomplete' => $sendemailaftercomplete, 'emaillistcomplete' => $emaillistcomplete, 'encryptbackup' => $encryptbackup, 'encfilepass' => $this->cryptmainfunc($encfilepass, $GLOBALS['cryptkeymain']), 'backup_maxcountbackups' => $backup_maxcountbackups, 'backupRemoteServFtpPort' => $backupRemoteServFtpPort);
		$this->config_save($GLOBALS['BACKUP_CONF'] . $backup_file_config, $arr_conf);
		$out['fileconf'] = $backup_file_config;
		$out['status'] = 'done';
		$out['raw_info'] = 1;
		$this->ssh('rm -f ' . $GLOBALS['BACKUP_CONF'] . '/listconfcache-' . $user_data['name']);
		return $out;
	}

	public function makedump_sql_arr($dbs, $path_to_dump, $username)
	{
		$root = parse_ini_file($GLOBALS['MYSQL_CONF_PATH'], true);
		$root = $root['root'];

		if (!is_dir($path_to_dump)) {
			$comm = 'mkdir -p ' . $path_to_dump;
			$this->ssh($comm);
			$this->change_owner($path_to_dump, $username);
		}

		foreach ($dbs as $dbname) {
			$dbname_file = str_replace($username . '_', '', $dbname);
			$res[] = 'mysqldump -uroot -p' . $root . ' ' . $dbname . ' > ' . $path_to_dump . '/' . $dbname_file . '.sql';
		}

		return $res;
	}

	public function makedump_sql_arr_users($users_sql, $path_to_dump, $mysql_conn, $dbs, $username)
	{
		$root = parse_ini_file($GLOBALS['MYSQL_CONF_PATH'], true);
		$root = $root['root'];

		if (!is_dir($path_to_dump)) {
			$comm = 'mkdir -p \'' . $this->strip_quotes_cmd($path_to_dump) . '\'';
			$this->ssh($comm);
			$this->change_owner($this->strip_quotes_cmd($path_to_dump), $username);
		}

		if (!is_dir($path_to_dump . '/' . $GLOBALS['BACKUP_DIR_MYSQL_USERS_PRIV'])) {
			$comm = 'mkdir -p ' . $path_to_dump . '/' . $GLOBALS['BACKUP_DIR_MYSQL_USERS_PRIV'];
			$this->ssh($comm);
			$this->change_owner($path_to_dump . '/' . $GLOBALS['BACKUP_DIR_MYSQL_USERS_PRIV'], $username);
		}

		$users = '';
		$i = 0;

		foreach ($users_sql as $user) {
			if ($user == $username) {
				continue;
			}

			if ($i == 0) {
				$users .= 'User=\'' . $user . '\'';
			}
			else {
				$users .= ' or User=\'' . $user . '\'';
			}

			++$i;
		}

		$res = $this->mysql_query_do('mysql', 'SELECT * from user where ' . $users);
		file_put_contents($path_to_dump . '/' . $GLOBALS['BACKUP_FILE_NAME_USERS'], '');

		foreach ($res as $userdump) {
			$userdump = str_replace($username . '_', '', $userdump);
			file_put_contents($path_to_dump . '/' . $GLOBALS['BACKUP_FILE_NAME_USERS'], implode('|', $userdump) . "\n", FILE_APPEND);
		}

		foreach ($users_sql as $user) {
			if ($user == $username) {
				continue;
			}

			foreach ($dbs as $db) {
				$privs = $mysql_conn->mysql_get_grants($user, $db);

				if (2 < strlen($privs)) {
					$user_nopref = str_replace($username . '_', '', $user);
					$db = str_replace($username . '_', '', $db);
					file_put_contents($path_to_dump . '/' . $GLOBALS['BACKUP_DIR_MYSQL_USERS_PRIV'] . $user_nopref, $db . ' = ' . $privs . "\n", FILE_APPEND | LOCK_EX);
				}
			}
		}

		global $lang;
		$out['code'] = 0;
		$out['code'] = $lang['backup_restore_confuser_ok'];
		return $out;
	}

	public function restore_backups_jobs($username)
	{
		if (!is_dir($GLOBALS['BACKUP_CONF'])) {
			$this->ssh('mkdir -p ' . $GLOBALS['BACKUP_CONF']);
		}

		if (!is_dir($GLOBALS['BACKUP_CONF_STREAM'])) {
			$this->ssh('mkdir -p ' . $GLOBALS['BACKUP_CONF_STREAM']);
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$out = $this->mass_rename($confUser['rootdir'] . '/' . $this->backup_jobs, $this->mask_username_replace . '_', $username . '_');
		$out = $this->mass_rename($confUser['rootdir'] . '/' . $this->backup_jobs . '/' . $this->backup_jobs_tokens_gdrive, $this->mask_username_replace . '_', $username . '_');
		$out = $this->mass_rename($confUser['rootdir'] . '/' . $this->backup_jobs . '/' . $this->backup_jobs_tokens_dropbox, $this->mask_username_replace . '_', $username . '_');
		$out = $this->ssh('ls -l ' . $confUser['rootdir'] . '/' . $this->backup_jobs . '/* | awk \'{print $9}\'');

		foreach ($out as $value) {
			if (1 < strlen($value)) {
				$this->ssh('replace \'' . $this->mask_username_replace . '\' \'' . $username . '\' -- ' . $value);
			}
		}

		$res = scandir($confUser['rootdir'] . '/' . $this->backup_jobs);

		foreach ($res as $elem) {
			if (($elem != '.') && ($elem != '..')) {
				$arr['backup_configfile'] = $elem;
				$conf = parse_ini_file($confUser['rootdir'] . '/' . $this->backup_jobs . '/' . $elem);

				if ($conf['backup_conf_stat'] == 1) {
					$this->update_cache_cron_task($elem, $conf['backup_period'], $conf['backup_time_start'], $conf['backup_weekly_days'], $conf['backup_monthly_select_date']);
				}
			}
		}

		$this->ssh('cp -rf ' . $confUser['rootdir'] . '/' . $this->backup_jobs . '/* ' . $GLOBALS['BACKUP_CONF'] . '/');
		$out = $this->mass_rename($this->gdrive_cred, $this->mask_username_replace . '_', $username . '_');
		$out = $this->mass_rename($this->drop_cred, $this->mask_username_replace . '_', $username . '_');
		$this->ssh('rm -rf ' . $GLOBALS['BACKUP_CONF'] . '/listconfcache-' . $username);
	}

	public function backup_backups_jobs($username)
	{
		global $lang;

		if (!$this->check_value('user', $username)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$comm = 'mkdir -p ' . $confUser['rootdir'] . '/' . $this->backup_jobs;
		$this->ssh($comm);
		$comm = 'cp -rf ' . $GLOBALS['BACKUP_CONF'] . $username . '*.conf ' . $confUser['rootdir'] . '/' . $this->backup_jobs;
		$this->ssh($comm);
		$out = $this->mass_rename($confUser['rootdir'] . '/' . $this->backup_jobs, $username . '_', $this->mask_username_replace . '_');
		$out2 = $this->ssh('ls -l ' . $confUser['rootdir'] . '/' . $this->backup_jobs . '/* | awk \'{print $9}\'');

		foreach ($out2 as $value) {
			if ((strlen($value) < 2) || !is_file($value)) {
				continue;
			}

			$this->ssh('replace \'' . $username . '\' \'' . $this->mask_username_replace . '\' -- ' . $value);
		}

		$comm = 'mkdir -p ' . $confUser['rootdir'] . '/' . $this->backup_jobs . '/' . $this->backup_jobs_tokens_gdrive;
		$this->ssh($comm);
		$comm = 'mkdir -p ' . $confUser['rootdir'] . '/' . $this->backup_jobs . '/' . $this->backup_jobs_tokens_dropbox;
		$this->ssh($comm);
		$comm = 'cp -rf ' . $this->gdrive_cred . $username . '*.conf ' . $confUser['rootdir'] . '/' . $this->backup_jobs . '/' . $this->backup_jobs_tokens_gdrive;
		$this->ssh($comm);
		$comm = 'cp -rf ' . $this->drop_cred . $username . '*.conf ' . $confUser['rootdir'] . '/' . $this->backup_jobs . '/' . $this->backup_jobs_tokens_dropbox;
		$this->ssh($comm);
		$out = $this->mass_rename($confUser['rootdir'] . '/' . $this->backup_jobs . '/' . $this->backup_jobs_tokens_gdrive, $username . '_', $this->mask_username_replace . '_');
		$out = $this->mass_rename($confUser['rootdir'] . '/' . $this->backup_jobs . '/' . $this->backup_jobs_tokens_dropbox, $username . '_', $this->mask_username_replace . '_');
		$this->change_owner($confUser['rootdir'] . '/' . $this->backup_jobs . '/', $username);
		global $lang;
		$out['code'] = 0;
		$out['code'] = $lang['backup_backups_jobs_ok'];
		return $out;
	}

	public function backup_autoins_config_user($dir_name_pid)
	{
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $dir_name_pid);
		$comm = 'mkdir -p ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_DIR_AUTOINS'];
		$this->ssh($comm);
		$comm = 'cp ' . $GLOBALS['DATA_PATH_AUTOINS_USERS_APP'] . $dir_name_pid . '.conf ' . $GLOBALS['DATA_PATH_AUTOINS_USERS_APP'] . $dir_name_pid . '_appid* ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_DIR_AUTOINS'];
		$this->ssh($comm);
		$this->change_owner($confUser['rootdir'] . '/' . $GLOBALS['BACKUP_DIR_AUTOINS'] . '/', $dir_name_pid);
		global $lang;
		$out['code'] = 0;
		$out['code'] = $lang['backup_restore_confuser_ok'];
		return $out;
	}

	public function backup_user_info($username)
	{
		global $lang;

		if (!$this->check_value('user', $username)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$comm = 'cp ' . $GLOBALS['USERS_PATH'] . '/' . $username . ' ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_USER_INFO_FILE'];
		$this->ssh($comm);
		$this->ssh('replace \'/' . $username . '\' \'/' . $this->mask_username_replace . '\' -- ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_USER_INFO_FILE']);
		$this->change_owner($GLOBALS['USERS_PATH'] . '/' . $username . ' ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_USER_INFO_FILE'], $username);
		global $lang;
		$out['code'] = 0;
		$out['code'] = $lang['backup_createbackup_confusermain_ok'];
		return $out;
	}

	public function backup_ftps_acc($username)
	{
		global $lang;

		if (!$this->check_value('user', $username)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$comm = 'mkdir -p ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_DIR_FTPS'];
		$this->ssh($comm);
		$comm = 'find ' . $GLOBALS['USERS_PATH_FTP'] . ' -name \'' . $username . '_*\' -exec cp {} ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_DIR_FTPS'] . ' \\;';
		$this->ssh($comm);
		$out = $this->mass_rename($confUser['rootdir'] . '/' . $GLOBALS['BACKUP_DIR_FTPS'], $username . '_', $this->mask_username_replace . '_');
		$out = $this->ssh('ls -l ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_DIR_FTPS'] . '/* | awk \'{print $9}\'');

		foreach ($out as $value) {
			$this->ssh('replace \'' . $username . '\' \'' . $this->mask_username_replace . '\' -- ' . $value);
		}

		$this->change_owner($confUser['rootdir'] . '/' . $GLOBALS['BACKUP_DIR_FTPS'] . '/', $username);
		$out['code'] = 0;
		$out['code'] = $lang['backup_createbackup_usersftp_ok'];
		return $out;
	}

	public function backup_vhosts($username)
	{
		global $lang;

		if (!$this->check_value('user', $username)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$users = $this->request_vars_m('users', $username);
		$sites = explode(',', $users['vhost_list']);
		$comm = 'mkdir -p ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'];
		$this->ssh($comm);
		$i = 0;

		while ($i < count($sites)) {
			if (!!trim($sites[$i])) {
				$site_conf = explode(':', $sites[$i]);
				$site_conf1 = $site_conf[0];
				$comm = 'cp ' . $GLOBALS['DATA_VHOSTS'] . $site_conf1 . '.conf ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'];
				$this->ssh($comm);
				$out = $this->ssh('ls -l ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'] . '/*.conf | awk \'{print $9}\'');

				foreach ($out as $value) {
					$this->ssh('replace \'' . $username . '\' \'' . $this->mask_username_replace . '\' -- ' . $value);
				}

				$conf_dom = parse_ini_file($GLOBALS['DATA_VHOSTS'] . $site_conf1 . '.conf');
				if (isset($conf_dom['key']) || isset($conf_dom['crt'])) {
					if (isset($conf_dom['key'])) {
						$comm = 'cp ' . $conf_dom['key'] . ' ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'];
						$this->ssh($comm);
					}

					if (isset($conf_dom['crt'])) {
						$comm = 'cp ' . $conf_dom['crt'] . ' ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'];
						$this->ssh($comm);
					}

					if (is_file($conf_dom['crt'] . '_v2')) {
						$comm = 'cp ' . $conf_dom['crt'] . '_v2 ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'];
						$this->ssh($comm);
					}

					if (isset($conf_dom['chein'])) {
						$comm = 'cp ' . $conf_dom['chein'] . ' ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'];
						$this->ssh($comm);
					}
				}
			}

			++$i;
		}

		$this->change_owner($confUser['rootdir'] . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'] . '/', $username);
		$out['code'] = 0;
		$out['code'] = $lang['backup_createbackup_usersvhost_ok'];
		return $out;
	}

	public function restore_vhosts($username)
	{
		require_once '/etc/brainy/classes/certs.php';
		$certsObj = new certs();
		global $lang;

		if (!$this->check_value('user', $username)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$out = $this->ssh('ls -l ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'] . '/*.conf | awk \'{print $9}\'');

		foreach ($out as $value) {
			$check_conf = parse_ini_file($value);
			if ((stripos($check_conf['dir'], $this->mask_username_replace) === false) || (stripos($check_conf['user'], $this->mask_username_replace) === false)) {
				$this->ssh('rm -f ' . $value);
				continue;
			}

			if (stripos($check_conf['dir'], $this->mask_homedir_replace) !== false) {
				$this->ssh('replace \'' . $this->mask_homedir_replace . '\' \'' . $GLOBALS['HOME_PATH'] . '\' -- ' . $value);
			}

			$this->ssh('replace \'' . $this->mask_username_replace . '\' \'' . $username . '\' -- ' . $value);

			if (2 < strlen($value)) {
				$confVhost = $this->config_read($value);
				$domainMain = $confVhost['domain'];
				$aliases = explode(',', $confVhost['aliases']);
				file_put_contents('/etc/brainy/data/server_control/vhosts', $domainMain . ':' . $username . "\n", FILE_APPEND | LOCK_EX);

				foreach ($aliases as $value) {
					file_put_contents('/etc/brainy/data/server_control/vhosts', $value . ':' . $username . "\n", FILE_APPEND | LOCK_EX);
				}

				$vhost_lists[] = $domainMain . ':' . implode('+', $aliases);
			}
		}

		$usersConf['vhost_list'] = implode(',', $vhost_lists);
		$this->config_save('/etc/brainy/data/users/' . $username, $usersConf, 'add');
		$users = $this->request_vars_m('users', $username);
		$sites = explode(',', $users['vhost_list']);
		$this->ssh('cp -rn ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'] . '/*.conf ' . $GLOBALS['DATA_VHOSTS'] . '/');
		$this->ssh('mkdir -p /etc/certs/' . $username);
		$this->ssh('cp -rn ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'] . '/*.crt ' . '/etc/certs/' . $username);
		$this->ssh('cp -rn ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'] . '/*.crt_v2 ' . '/etc/certs/' . $username);
		$this->ssh('cp -rn ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'] . '/*.key ' . '/etc/certs/' . $username);
		$this->ssh('cp -rn ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'] . '/*.chein ' . '/etc/certs/' . $username);
		$i = 0;

		while ($i < count($sites)) {
			if (!!trim($sites[$i])) {
				$site_conf = explode(':', $sites[$i]);
				$site_conf1 = $site_conf[0];
				$certsObj->removeFromSNI($site_conf1);
				$certsObj->addToSNI($site_conf1);
			}

			++$i;
		}

		$out['code'] = 0;
		$out['code'] = $lang['backup_restore_usersvhost_ok'];
		return $out;
	}

	public function backup_emails_user($username)
	{
		if (!$this->check_value('user', $username)) {
			return 0;
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$this->ssh('mkdir -p ' . $confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->backup_emails);
		$mailobj = new mailclient();
		$dbconn = $mailobj->getInstance();
		$mysqli = $dbconn->getConnection();

		if (0 < $mysqli->connect_errno) {
			return 1;
		}

		$arr_backup_rows_email = array();
		$sql = 'SELECT * FROM mailbox where name=\'' . mysqli_real_escape_string($mysqli, $username) . '\'';
		$res = mysqli_query($mysqli, $sql);

		if ($res != false) {
			while ($row = $res->fetch_assoc()) {
				$arr_backup_rows_email[] = $row;
			}
		}

		file_put_contents($confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->backup_emails . '/' . $this->backup_email_file, json_encode($arr_backup_rows_email, 1));
		$this->change_owner($confUser['rootdir'] . '/' . $this->dir_backup_configs . '/', $username);
	}

	public function restore_emails_user($username)
	{
		global $lang;

		if (!$this->check_value('user', $username)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		$mailobj = new mailclient();
		$dbconn = $mailobj->getInstance();
		$mysqli = $dbconn->getConnection();

		if (0 < $mysqli->connect_errno) {
			return 1;
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$emails = json_decode(file_get_contents($confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->backup_emails . '/' . $this->backup_email_file), 1);

		foreach ($emails as $email_rest) {
			$sql = 'INSERT INTO mailbox(USERNAME,PASSWORD,UID,GID,NAME,MAILDIR,QUOTA,LOCAL_PART,DOMAIN,CREATED,MODIFIED,ACTIVE,auto_autoresponder,text_autoresponder) VALUES(' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['username']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['password']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['uid']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['gid']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $username) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['maildir']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['quota']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['local_part']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['domain']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['created']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['modified']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['active']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['auto_autoresponder']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['text_autoresponder']) . '\')';
			$res = mysqli_query($mysqli, $sql);
		}

		global $lang;
		$out['code'] = 0;
		$out['code'] = $lang['backup_restore_emails_ok'];
		return $out;
	}

	public function backup_email_forward($username)
	{
		if (!$this->check_value('user', $username)) {
			return 0;
		}

		require_once '/etc/brainy/lib/punycode/idna_convert.php';
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$webserver = new webserver();
		$sites = $webserver->get_all_sites($username);
		$mailobj = new mailclient();
		$this->ssh('mkdir -p ' . $confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->backup_emails);
		$dbconn = $mailobj->getInstance();
		$mysqli = $dbconn->getConnection();

		if (0 < $mysqli->connect_errno) {
			return 1;
		}

		$arr_backup_rows_email = array();

		$sql = 'SELECT * FROM alias where domain=\'' . mysqli_real_escape_string($mysqli, $curdom) . '\'';
		$res = mysqli_query($mysqli, $sql);

		$arr_backup_rows_email[] = $row;

		file_put_contents($confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->backup_emails . '/' . $this->backup_email_forward, json_encode($arr_backup_rows_email, 1));
		$this->change_owner($confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->backup_emails . '/', $username);
	}

	public function restore_email_forward($username)
	{
		global $lang;

		if (!$this->check_value('user', $username)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$mailobj = new mailclient();
		$dbconn = $mailobj->getInstance();
		$mysqli = $dbconn->getConnection();

		if (0 < $mysqli->connect_errno) {
			return 1;
		}

		$emails = json_decode(file_get_contents($confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->backup_emails . '/' . $this->backup_email_forward), 1);

		foreach ($emails as $email_rest) {
			$sql = 'INSERT INTO alias(ADDRESS,GOTO,DOMAIN,CREATED,MODIFIED,ACTIVE) VALUES(' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['address']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['goto']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['domain']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['created']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['modified']) . '\',' . '\'' . mysqli_real_escape_string($mysqli, $email_rest['active']) . '\')';
			$res = mysqli_query($mysqli, $sql);
		}

		$out['code'] = 0;
		$out['code'] = $lang['backup_restore_forward_emails_ok'];
		return $out;
	}

	public function backup_webserver_includes_user($username)
	{
		if (!$this->check_value('user', $username)) {
			return 0;
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$this->ssh('mkdir -p ' . $confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->webserver_inc_backup);
		$this->ssh('cp -rf ' . $this->webserver_inc . '/' . $username . '/* ' . $confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->webserver_inc_backup . '/');
		$this->change_owner($confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->webserver_inc_backup . '/', $username);
	}

	public function restore_webserver_includes_user($username)
	{
		global $lang;

		if (!$this->check_value('user', $username)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$this->ssh('mkdir -p ' . $this->webserver_inc . '/' . $username . '/');
		$this->ssh('cp -rf ' . $confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->webserver_inc_backup . '/* ' . $this->webserver_inc . '/' . $username . '/');
		global $lang;
		$out['code'] = 0;
		$out['code'] = $lang['backup_restore_userincludes_ok'];
		return $out;
	}

	public function backup_dkimkeys_user($username)
	{
		if (!$this->check_value('user', $username)) {
			return 0;
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$this->ssh('mkdir -p ' . $confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->backup_dns_zone . '/' . $this->dkim_keys);
		$webserver = new webserver();
		$allsites = $webserver->get_all_sites($username);

		foreach ($allsites as $cursite) {
			$this->ssh('cp -r \'/etc/opendkim/keys/' . $cursite . '\' ' . $confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->backup_dns_zone . '/' . $this->dkim_keys . '/');
		}

		$this->change_owner($confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->backup_dns_zone . '/' . $this->dkim_keys . '/', $username);
	}

	public function restore_dkimkeys_user($username)
	{
		global $lang;

		if (!$this->check_value('user', $username)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$path_dkim_keys = $confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->backup_dns_zone . '/' . $this->dkim_keys . '/';
		$res = scandir($path_dkim_keys);

		foreach ($res as $dkim_cur) {
			if (is_dir($path_dkim_keys . $dkim_cur) && ($dkim_cur != '.') && ($dkim_cur != '..')) {
				$this->ssh('cp -rn ' . $path_dkim_keys . $dkim_cur . ' /etc/opendkim/keys/');
				$this->ssh('chown -R opendkim.opendkim /etc/opendkim/keys/' . $dkim_cur);
			}
		}

		global $lang;
		$out['code'] = 0;
		$out['code'] = $lang['backup_restore_dkim_keys_user_ok'];
		return $out;
	}

	public function backup_dns_user($username)
	{
		if (!$this->check_value('user', $username)) {
			return 0;
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$this->ssh('mkdir -p ' . $confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->backup_dns_zone);
		$named = new bindserver();
		$dns_zones_list = $named->bindserver_getZoneByUser($username);

		foreach ($dns_zones_list as $curzone) {
			$this->ssh('cp /var/named/named.' . $curzone . ' ' . $confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->backup_dns_zone . '/');
		}

		$this->change_owner($confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->backup_dns_zone . '/', $username);
	}

	public function restore_dns_user($username, $newip)
	{
		global $lang;

		if (!$this->check_value('user', $username)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$path_dns = $confUser['rootdir'] . '/' . $this->dir_backup_configs . '/' . $this->backup_dns_zone . '/';
		$nameddb = '/etc/brainy/ssh/named/user.db';
		$named = new bindserver();
		$dns_zones_list_all = $named->bindserver_getZone();
		$res = scandir($path_dns);

		foreach ($res as $dns_cur) {
			if (is_file($path_dns . $dns_cur) && ($dns_cur != '.') && ($dns_cur != '..')) {
				$exist_zone = 0;

				foreach ($dns_zones_list_all as $curuser) {
					foreach ($curuser as $cur_dom) {
						if (('named.' . $cur_dom) == $dns_cur) {
							$exist_zone = 1;
						}
					}
				}

				if ($exist_zone == 0) {
					$this->ssh('cp -n ' . $path_dns . $dns_cur . ' /var/named/');
					$this->ssh('chown -R root.named /var/named/' . $dns_cur);

					if (2 < strlen($newip)) {
						$this->ssh('sed -i \'s/[0-9]\\{1,3\\}\\.[0-9]\\{1,3\\}\\.[0-9]\\{1,3\\}\\.[0-9]\\{1,3\\}/' . $newip . '/g\' /var/named/' . $dns_cur);
					}

					$dom_ins = str_replace('named.', '', $dns_cur);
					file_put_contents($nameddb, $dom_ins . ':' . $username . ':0' . "\n", FILE_APPEND);
				}

				$zone_2sync = explode('named.', $dns_cur)[1];
				$zonefile = $named->bindserver_readZone($zone_2sync);
				$param['act'] = 'save_zone_to_file';
				$param['zone'] = $zone_2sync;
				$param['text'] = $zonefile;
				$ress = $named->bindserver_send_data_to_cluster($param);
			}
		}

		global $lang;
		$out['code'] = 0;
		$out['code'] = $lang['backup_restore_dns_user_ok'];
		return $out;
	}

	public function sendemailcompleteproc($completebackup_file_log, $completebackup_timestart)
	{
		$file_conf = explode('_', $completebackup_file_log);
		$type_backup_or_username = $file_conf[count($file_conf) - 2];
		$file_conf = $file_conf[count($file_conf) - 2] . '_' . $file_conf[count($file_conf) - 1];

		if (stripos($file_conf, 'config_') !== false) {
			$conf = parse_ini_file($GLOBALS['PROPERTIES_CONF']);
			$langload = $conf['language'];
			$this->lan_include($langload);
		}
		else {
			$conf = parse_ini_file($GLOBALS['USERS_PATH'] . $type_backup_or_username);
			$langload = $conf['language'];
			$this->lan_include($langload);
		}

		$arr_conf = $this->config_read($GLOBALS['BACKUP_CONF'] . $file_conf . '.conf');
		global $smarty;
		$smarty->assign('lang', $this->lang);

		if ($arr_conf['sendemailaftercomplete'] == 1) {
			$email_text = '';
			$email_res = array();
			$ind = 0;
			$res = scandir($this->dir_complete);

			foreach ($res as $logcomplete) {
				if (is_file($this->dir_complete . $logcomplete) && ($logcomplete != '.') && ($logcomplete != '..')) {
					if (stripos($this->dir_complete . $logcomplete, $completebackup_file_log) !== false) {
						$val = file_get_contents($this->dir_complete . $logcomplete);
						$email_text .= $val;
						$val_exp = preg_split('/[\\s,;]/', $val);
						$email_res[$ind]['size'] = $val_exp[0];
						$email_res[$ind]['path'] = $val_exp[1];
						$this->ssh('rm -f ' . $this->dir_complete . $logcomplete);
						++$ind;
					}
				}
			}

			$email_list = preg_split('/[\\s,;]/', $arr_conf['emaillistcomplete']);
			$smarty->assign('email_res', $email_res);
			$smarty->assign('backup_conf', $arr_conf);
			$smarty->assign('completebackup_timestart', $completebackup_timestart);
			$duration = gmdate('H:i:s', time() - strtotime($completebackup_timestart));
			$smarty->assign('duration', $duration);
			$conf_template = parse_ini_file($GLOBALS['PROPERTIES_CONF']);
			$template_path = '/tpl/default/';

			if (isset($conf_template['template'])) {
				$template_path = $conf_template['template'];
			}

			$email_tpl = $smarty->fetch('/etc/brainy' . $template_path . 'backup/completeproc.tpl');
			$mailObj = new mail();

			foreach ($email_list as $curemail) {
				$mailObj->sendmail($curemail, 'You', $this->lang['backup_complete_titleemail'] . $file_conf, $email_tpl);
			}
		}
	}

	public function getlist_backup_fromftp($backupfind, $user_data, &$ind, $roundsize)
	{
		$months[] = 'Jan';
		$months[] = 'Feb';
		$months[] = 'Mar';
		$months[] = 'Apr';
		$months[] = 'May';
		$months[] = 'Jun';
		$months[] = 'Jul';
		$months[] = 'Aug';
		$months[] = 'Sep';
		$months[] = 'Oct';
		$months[] = 'Nov';
		$months[] = 'Dec';
		$pass = $this->decryptmainfunc($backupfind['backup_remote_pass'], $GLOBALS['cryptkeymain']);
		$user_remote = $backupfind['backup_remote_login'];
		$ip = $backupfind['backup_remoteip'];
		$remote_dir = $backupfind['backup_remote_path'];
		$taskconf = $backupfind['filename_taskconfig'];

		if ($this->check_connect_ftp($backupfind, $taskconf, NULL)['status'] != 1) {
			global $lang;
			$res['code'] = -1;
			$res['text'] = $lang['backup_ftp_noconn'];
			$this->listbackup[$ind]['failedconn'] = $lang['backup_ftp_noconn'] . ' ' . $lang['backup_failedconn_getlist_task'] . $backupfind['backup_nametask'];
			++$ind;
			return $res;
		}

		$port = $this->getPortServFtp($backupfind, 'ftp');
		$comm = 'lftp -p ' . $port . ' -u \'' . $this->strip_quotes_cmd($user_remote) . ',' . $this->strip_quotes_cmd($pass) . '\' ' . $this->strip_quotes_cmd($ip) . ':' . $remote_dir . ' -e \'set net:reconnect-interval-base ' . $this->conn_interval_attempts . ';  set net:timeout ' . $this->conn_timeout . '; set net:max-retries ' . $this->conn_attempts . '; ls; exit\'';
		$checkaccess = $this->ssh($comm);

		if (0 < count($checkaccess)) {
			$res_user_backup = $checkaccess;

			foreach ($res_user_backup as $user_backup) {
				$user_backup = preg_split('/[\\s,;]/', $user_backup);
				$user_backup = array_filter($user_backup);
				$user_backup = array_values($user_backup);
				$user_backup = $user_backup[8];
				$user_file = explode('_', $user_backup);
				$user_name_on_backup_name = $user_file[0];
				if (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['root'] == 'y') || ($user_file[0] == $user_data['name'])) {
					$nameu = explode('_', $user_backup);
					$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user_name_on_backup_name);
					if ((strpos($user_backup, '.tar') !== false) || (strpos($user_backup, '.tgz') !== false)) {
						$fileinfo_ssh = 'lftp -p ' . $port . ' -u \'' . $backupfind['backup_remote_login'] . ',' . $pass . '\' ' . $backupfind['backup_remoteip'] . ':' . $backupfind['backup_remote_path'] . ' -e \'ls  ' . $user_backup . ';quit\'';
						$file_info = $this->ssh($fileinfo_ssh);
						$file_info = preg_split('/[\\s,;]/', $file_info[0]);
						$file_info = array_filter($file_info);
						$file_info = array_values($file_info);
						$month_file = array_search($file_info[5], $months) + 1;

						if ($month_file < 10) {
							$month_file = '0' . $month_file;
						}

						if (stripos($file_info[7], ':') !== false) {
							$file_date = $file_info[6] . '.' . $month_file . '.' . date('Y') . ' ' . $file_info[7];
						}
						else {
							$file_date = $file_info[6] . '.' . $month_file . '.' . $file_info[7];
						}

						$file_size = $file_info[4] / 1024 / 1024;
						$check_uniq_backups_remote[] = $backupfind['backup_nametask'] . ':/' . $remote_dir . '/' . $user_backup;
						$this->listbackup[$ind]['ftp'][$user_file[0] . '_' . $ind]['file'] = preg_replace('/(\\/+)/', '/', $backupfind['backup_nametask'] . ':/' . $remote_dir . '/' . $user_backup);
						$this->listbackup[$ind]['ftp'][$user_file[0] . '_' . $ind]['file_path'] = $remote_dir . '/' . $user_backup;
						$this->listbackup[$ind]['ftp'][$user_file[0] . '_' . $ind]['namefileonly'] = $user_backup;
						$this->listbackup[$ind]['ftp'][$user_file[0] . '_' . $ind]['datecreate'] = $file_date;
						$this->listbackup[$ind]['ftp'][$user_file[0] . '_' . $ind]['size'] = round($file_size, $roundsize);

						if ($this->listbackup[$ind]['ftp'][$user_file[0] . '_' . $ind]['size'] == 0) {
							$this->listbackup[$ind]['ftp'][$user_file[0] . '_' . $ind]['size'] = round($file_size, 3);
						}

						$file_backup_stream_tmp = 'cat ' . $confUser['rootdir'] . '/' . $this->databackup_streamtmp;
						$file_restore_stream_tmp = 'cat ' . $confUser['rootdir'] . '/' . $this->datarestore_streamtmp;
						$file_backup_stream_tmp = $this->ssh($file_backup_stream_tmp);
						$file_restore_stream_tmp = $this->ssh($file_restore_stream_tmp);

						if (0 < strlen($file_backup_stream_tmp[0])) {
							$this->listbackup[$ind]['ftp'][$user_file[0] . '_' . $ind]['backupinprogress_stream'] = $file_backup_stream_tmp[0];
						}
						else {
							$this->listbackup[$ind]['ftp'][$user_file[0] . '_' . $ind]['backupinprogress_stream'] = '0';
						}

						if (0 < strlen($file_restore_stream_tmp[0])) {
							$this->listbackup[$ind]['ftp'][$user_file[0] . '_' . $ind]['restoreinprogress_stream'] = $file_restore_stream_tmp[0];
							$this->listbackup[$ind]['ftp'][$user_file[0] . '_' . $ind]['path_to_restore'] = $file_restore_stream_tmp[1];
						}
						else {
							$this->listbackup[$ind]['ftp'][$user_file[0] . '_' . $ind]['restoreinprogress_stream'] = '0';
							$this->listbackup[$ind]['ftp'][$user_file[0] . '_' . $ind]['path_to_restore'] = '0';
						}

						$homePath = str_replace($user_name_on_backup_name, '', $confUser['rootdir']);
						$homePath = str_replace('//', '/', $homePath);
						$this->listbackup[$ind]['ftp'][$user_file[0] . '_' . $ind]['homedir'] = $homePath;
						$this->listbackup[$ind]['ftp'][$user_file[0] . '_' . $ind]['username'] = $user_name_on_backup_name;
						$this->listbackup[$ind]['ftp'][$user_file[0] . '_' . $ind]['filename_taskconfig'] = $backupfind['filename_taskconfig'];
						++$ind;
					}
				}
			}
		}
	}

	public function formatNameBackupFolderArch($arr_conf, $username, $taskconf)
	{
		$task_exp_id = explode('.', $taskconf)[0];
		$task_exp_id = explode('_', $task_exp_id)[1];
		$file_name_pid = $username . '_' . $task_exp_id . '.tgz';

		if ($arr_conf['backup_period'] == 'day') {
			$file_name_pid = $username . '_' . $task_exp_id . '_' . date('Ymd') . '.tgz';
		}

		if ($arr_conf['backup_period'] == 'week') {
			$sel_days = $arr_conf['backup_weekly_days'];
			$file_name_pid = $username . '_' . $task_exp_id . '_' . date('Ymd') . '_' . date('D') . '.tgz';
		}

		if ($arr_conf['backup_period'] == 'month') {
			$file_name_pid = $username . '_' . $task_exp_id . '_' . date('M') . date('d') . '_m.tgz';
		}

		return $file_name_pid;
	}

	public function formatNameBackupFolderName($arr_conf, $cur_user, $taskconf)
	{
		$task_exp_id = explode('.', $taskconf)[0];
		$task_exp_id = explode('_', $task_exp_id)[1];
		$dir_name_pid_backup = '';

		if ($arr_conf['backup_period'] == 'day') {
			$dir_name_pid_backup = $cur_user . '_' . $task_exp_id . '_incr';
		}

		if ($arr_conf['backup_period'] == 'week') {
			$dir_name_pid_backup = $cur_user . '_' . $task_exp_id . '_' . date('D');
		}

		if ($arr_conf['backup_period'] == 'month') {
			$dir_name_pid_backup = $cur_user . '_' . $task_exp_id . '_' . date('d') . '_m';
		}

		if ($arr_conf['backup_type_arch_array'] == 'simple_noarch') {
			if ($arr_conf['backup_period'] == 'day') {
				$dir_name_pid_backup = $cur_user . '_' . $task_exp_id . '_' . date('Ymd') . '_s';
			}

			if ($arr_conf['backup_period'] == 'week') {
				$dir_name_pid_backup = $cur_user . '_' . $task_exp_id . '_' . date('Ymd') . '_' . date('D') . '_s';
			}

			if ($arr_conf['backup_period'] == 'month') {
				$dir_name_pid_backup = $cur_user . '_' . $task_exp_id . '_' . date('Ymd') . '_m_s';
			}
		}

		return $dir_name_pid_backup;
	}

	public function create_backup_toftp(&$stream, $arr_conf, $username, $taskconf, $completebackup_file_log)
	{
		if ($arr_conf['backup_level_compress'] == -1) {
			$arr_conf['backup_level_compress'] = $GLOBALS['BACKUP_LEVEL_COMPRESS'];
		}

		$file_name_pid = $this->formatNameBackupFolderArch($arr_conf, $username, $taskconf);

		if ($arr_conf['encryptbackup'] != 1) {
			$fifoname = $this->tmp_backup . $file_name_pid;
		}
		else {
			$fifoname = $this->tmp_backup . $file_name_pid . '.encoded';
		}

		$this->ssh('mkfifo ' . $fifoname);
		$ftpuser_path = $this->decryptmainfunc($arr_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
		$stream_fifo = array();
		$stream_fifo[0]['test'] = '';
		$exclJail = $this->createExcludePathJail('tar');
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);

		if ($arr_conf['encryptbackup'] != 1) {
			$stream_fifo[]['comm'] = 'cd ' . $confUser['rootdir'] . ' && env GZIP=-' . $arr_conf['backup_level_compress'] . ' tar -cz ' . ' ./ ' . $exclJail . ' > ' . $fifoname;
		}
		else {
			$backuppass = $this->decryptmainfunc($arr_conf['encfilepass'], $GLOBALS['cryptkeymain']);
			$backuppass = $this->strip_quotes_cmd($backuppass);
			$stream_fifo[]['comm'] = 'cd ' . $confUser['rootdir'] . ' && env GZIP=-' . $arr_conf['backup_level_compress'] . ' tar -cz ' . './ ' . $exclJail . ' | openssl enc -k \'' . $backuppass . '\' -e -aes-256-cbc > ' . $fifoname;
		}

		$stream_id = $this->create_stream($stream_fifo);
		$port = $this->getPortServFtp($arr_conf, 'ftp');
		$stream[]['comm'] = 'rt=$(lftp -p ' . $port . ' -u \'' . $arr_conf['backup_remote_login'] . ',' . $ftpuser_path . '\' ' . $arr_conf['backup_remoteip'] . ' -e \'set net:reconnect-interval-base ' . $this->conn_interval_attempts . '; set net:timeout ' . $this->conn_timeoutUpDown . '; set net:max-retries ' . $this->conn_attempts . '; put -O ' . $arr_conf['backup_remote_path'] . ' ' . $fifoname . ';quit\' 2>&1);echo logstatback $rt';
		$stream[]['comm'] = '(du ' . $confUser['rootdir'] . ' -sb ) > ' . $completebackup_file_log . '_' . $username;
		$stream[]['comm'] = 'rm -f ' . $fifoname;
		return $stream;
	}

	public function yadisk_putfile($backup_fileconf, $filename)
	{
		global $lang;
		$backupfind = $this->config_read($GLOBALS['BACKUP_CONF'] . $backup_fileconf);
		$pass = $this->decryptmainfunc($backupfind['backup_remote_pass'], $GLOBALS['cryptkeymain']);
		$user_remote = $backupfind['backup_remote_login'];
		$remote_dir = $backupfind['backup_remote_path'];
		$resUp = '';
		$res = array();

		try {
			$ydBackup = new YDiskBackup($pass, '', '', false, true, false);
			$resExistDirTo = $ydBackup->getExistDir($remote_dir);

			if ($resExistDirTo === false) {
				$res['code'] = -1;
				$res['message'] = $lang['backupYaErrcreateDir'];
				return $res;
			}

			if ($resExistDirTo === -1) {
				$res['code'] = -1;
				$res['message'] = $lang['backupYaErrAuthFailed'];
				return $res;
			}

			$resUp = $ydBackup->backupFile($filename, $remote_dir . '/' . basename($filename));
		}
		catch (Arhitector\Yandex\Client\Exception\UnauthorizedException $exc) {
			$res['code'] = -1;
			$res['message'] = $lang['backupYaErrAuthFailed'];
		}
		catch (Exception $exc) {
			$res['code'] = -1;
			$res['status'] = -1;
			$res['message'] = $lang['backupYaErrAuthFailed'];
			return $res;
		}
	}

	public function yadisk_getfile($backup_fileconf, $file)
	{
		$backupfind = $this->config_read($GLOBALS['BACKUP_CONF'] . $backup_fileconf);
		$pass = $this->decryptmainfunc($backupfind['backup_remote_pass'], $GLOBALS['cryptkeymain']);
		$user_remote = $backupfind['backup_remote_login'];
		$remote_dir = $backupfind['backup_remote_path'];
		$res = array();
		$ydBackup = NULL;

		try {
			$ydBackup = new YDiskBackup($pass, '', '', false, true, false);
			$isConn = $ydBackup->isConn($remote_dir);

			if (0 < $isConn) {
				$res['status'] = 1;
			}
			else {
				$res['status'] = -1;
			}
		}
		catch (Arhitector\Yandex\Client\Exception\UnauthorizedException $exc) {
			$res['code'] = -1;
		}
		catch (Exception $exc) {
			$res['code'] = -1;
			$res['status'] = -1;
			return $res;
		}

		$lang = &($GLOBALS['BACKUP_CONF']);

		if ($res['code'] == 1) {
			$res['code'] = -2;
			$res['text'] = $lang['backupYaErrAuthFailed'];
			return $res;
		}

		$pathToDown = $remote_dir . '/' . $file;
		$pathToDown = preg_replace('/(\\/+)/', '/', $pathToDown);
		$resFile = $ydBackup->disk->getResource($pathToDown);

		if ($resFile->has()) {
			$resFile->download($this->tmp_backup . '/' . $file, true);
		}

		return 0;
	}

	public function create_backup_toyandex(&$stream, $arr_conf, $username, $taskconf, $completebackup_file_log)
	{
		if ($arr_conf['backup_level_compress'] == -1) {
			$arr_conf['backup_level_compress'] = $GLOBALS['BACKUP_LEVEL_COMPRESS'];
		}

		$file_name_pid = $this->formatNameBackupFolderArch($arr_conf, $username, $taskconf);

		if ($arr_conf['encryptbackup'] != 1) {
			$fifoname = $this->tmp_backup . $file_name_pid;
		}
		else {
			$fifoname = $this->tmp_backup . $file_name_pid . '.encoded';
		}

		$yandex_pass = $this->decryptmainfunc($arr_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
		$stream_fifo = array();
		$stream_fifo[0]['test'] = '';
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$exclJail = $this->createExcludePathJail('tar');

		if ($arr_conf['encryptbackup'] != 1) {
			$stream[]['comm'] = 'cd ' . $confUser['rootdir'] . ' && env GZIP=-' . $arr_conf['backup_level_compress'] . ' tar -cz ' . './ ' . $exclJail . ' > ' . $fifoname;
		}
		else {
			$backuppass = $this->decryptmainfunc($arr_conf['encfilepass'], $GLOBALS['cryptkeymain']);
			$backuppass = $this->strip_quotes_cmd($backuppass);
			$stream[]['comm'] = 'cd ' . $confUser['rootdir'] . ' && env GZIP=-' . $arr_conf['backup_level_compress'] . ' tar -cz ' . './ ' . $exclJail . ' | openssl enc -k \'' . $backuppass . '\' -e -aes-256-cbc > ' . $fifoname;
		}

		$param = array('backup_fileconf' => $taskconf, 'filename' => $fifoname);
		$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'yadisk_putfile\' -p=\'' . json_encode($param) . '\'';
		$stream[]['comm'] = '(du ' . $confUser['rootdir'] . ' -sb ) > ' . $completebackup_file_log . '_' . $username;
		$stream[]['comm'] = 'rm -f ' . $fifoname;
		return $stream;
	}

	public function getlistbackup_yandex($backupfind, $user_data, &$ind, $roundsize)
	{
		$months[] = 'Jan';
		$months[] = 'Feb';
		$months[] = 'Mar';
		$months[] = 'Apr';
		$months[] = 'May';
		$months[] = 'Jun';
		$months[] = 'Jul';
		$months[] = 'Aug';
		$months[] = 'Sep';
		$months[] = 'Oct';
		$months[] = 'Nov';
		$months[] = 'Dec';
		$pass = $this->decryptmainfunc($backupfind['backup_remote_pass'], $GLOBALS['cryptkeymain']);
		$user_remote = $backupfind['backup_remote_login'];
		$ip = $backupfind['backup_remoteip'];
		$remote_dir = $backupfind['backup_remote_path'];
		global $lang;
		$res = array();
		$ydBackup = NULL;

		try {
			$ydBackup = new YDiskBackup($pass, '', '', false, true, false);
			$isConn = $ydBackup->isConn($remote_dir);

			if (0 < $isConn) {
				$res['status'] = 1;
			}
			else {
				$res['status'] = -1;
			}
		}
		catch (Arhitector\Yandex\Client\Exception\UnauthorizedException $exc) {
			$res['code'] = -1;
			$res['status'] = -1;
		}
		catch (Exception $exc) {
			$res['code'] = -1;
			$res['status'] = -1;
			return $res;
		}

		if ($backupfind['backup_remote_pass'] == -1) {
			$res['code'] = -2;
			$res['text'] = $lang['backupYaErrAuthFailed'];
			$this->listbackup[$ind]['failedconn'] = $lang['backup_ya_noconn'] . ' ' . $lang['backup_failedconn_getlist_task'] . $backupfind['backup_nametask'];
			++$ind;
			return $res;
		}

		$list_filesRes = $ydBackup->disk->getResource($remote_dir, 1000);
		$list_filesRes->items->getIterator();

		foreach ($list_filesRes->items as $item) {
			$list_files[] = $item->toArray();
		}

		$count_files = count($list_files);

		if (0 < count($count_files)) {
			foreach ($list_files as $user_backup) {
				$curfile_backup = $user_backup['path'];
				$onlyfile = basename($curfile_backup);
				$username = explode('_', $onlyfile)[0];
				if (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['root'] == 'y') || ($username == $user_data['name'])) {
					$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
					if ((strpos($onlyfile, '.tar') !== false) || (strpos($onlyfile, '.tgz') !== false)) {
						$fulldata = $user_backup['modified'];
						$fulldata = preg_split('/[\\s,;T\\-\\+]/', $fulldata);
						$fulldata = array_values(array_filter($fulldata));
						$strTimeZ = strtotime($fulldata[2] . '.' . $fulldata[1] . '.' . $fulldata[0] . ' ' . $fulldata[3]) + date('Z');
						$dateStrZ = date('d.m.Y H:i:s', $strTimeZ);
						$month_file = array_search($fulldata[2], $months) + 1;

						if ($month_file < 10) {
							$month_file = '0' . $month_file;
						}

						$file_date = $dateStrZ;
						$file_size = $user_backup['size'] / 1024 / 1024;
						$check_uniq_backups_remote[] = $backupfind['backup_nametask'] . ':/' . $remote_dir . '/' . $onlyfile;
						$this->listbackup[$ind]['ya'][$username . '_' . $ind]['file'] = preg_replace('/(\\/+)/', '/', $backupfind['backup_nametask'] . ':/' . $remote_dir . '/' . $onlyfile);
						$this->listbackup[$ind]['ya'][$username . '_' . $ind]['file_path'] = $remote_dir . '/' . $onlyfile;
						$this->listbackup[$ind]['ya'][$username . '_' . $ind]['namefileonly'] = $onlyfile;
						$this->listbackup[$ind]['ya'][$username . '_' . $ind]['datecreate'] = $file_date;
						$this->listbackup[$ind]['ya'][$username . '_' . $ind]['size'] = round($file_size, $roundsize);

						if ($this->listbackup[$ind]['ya'][$username . '_' . $ind]['size'] == 0) {
							$this->listbackup[$ind]['ya'][$username . '_' . $ind]['size'] = round($file_size, 3);
						}

						$file_backup_stream_tmp = 'cat ' . $confUser['rootdir'] . '/' . $this->databackup_streamtmp;
						$file_restore_stream_tmp = 'cat ' . $confUser['rootdir'] . '/' . $this->datarestore_streamtmp;
						$file_backup_stream_tmp = $this->ssh($file_backup_stream_tmp);
						$file_restore_stream_tmp = $this->ssh($file_restore_stream_tmp);
						$this->listbackup[$ind]['ya'][$username . '_' . $ind]['backupinprogress_stream'] = '0';

						if (isset($file_backup_stream_tmp[0])) {
							if (0 < strlen($file_backup_stream_tmp[0])) {
								$this->listbackup[$ind]['ya'][$username . '_' . $ind]['backupinprogress_stream'] = $file_backup_stream_tmp[0];
							}
						}

						$this->listbackup[$ind]['ya'][$username . '_' . $ind]['restoreinprogress_stream'] = '0';
						$this->listbackup[$ind]['ya'][$username . '_' . $ind]['path_to_restore'] = '0';

						if (isset($file_restore_stream_tmp[0])) {
							if (0 < strlen($file_restore_stream_tmp[0])) {
								$this->listbackup[$ind]['ya'][$username . '_' . $ind]['restoreinprogress_stream'] = $file_restore_stream_tmp[0];
								$this->listbackup[$ind]['ya'][$username . '_' . $ind]['path_to_restore'] = $file_restore_stream_tmp[1];
							}
						}

						$homePath = str_replace($username, '', $confUser['rootdir']);
						$homePath = str_replace('//', '/', $homePath);
						$this->listbackup[$ind]['ya'][$username . '_' . $ind]['homedir'] = $homePath;
						$this->listbackup[$ind]['ya'][$username . '_' . $ind]['username'] = $username;
						$this->listbackup[$ind]['ya'][$username . '_' . $ind]['filename_taskconfig'] = $backupfind['filename_taskconfig'];
						++$ind;
					}
				}
			}
		}
	}

	public function create_backup_togdrive(&$stream, $arr_conf, $username, $taskconf, $completebackup_file_log)
	{
		if ($arr_conf['backup_level_compress'] == -1) {
			$arr_conf['backup_level_compress'] = $GLOBALS['BACKUP_LEVEL_COMPRESS'];
		}

		$file_name_pid = $this->formatNameBackupFolderArch($arr_conf, $username, $taskconf);

		if ($arr_conf['encryptbackup'] != 1) {
			$fifoname = $this->tmp_backup . $file_name_pid;
		}
		else {
			$fifoname = $this->tmp_backup . $file_name_pid . '.encoded';
		}

		$remote_dir = escapeshellcmd($arr_conf['backup_remote_path']);
		$stream_fifo = array();
		$stream_fifo[0]['test'] = '';
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$exclJail = $this->createExcludePathJail('tar');

		if ($arr_conf['encryptbackup'] != 1) {
			$stream[]['comm'] = 'cd ' . $confUser['rootdir'] . ' && env GZIP=-' . $arr_conf['backup_level_compress'] . ' tar -cz ' . './ ' . $exclJail . ' > ' . $fifoname;
		}
		else {
			$backuppass = $this->decryptmainfunc($arr_conf['encfilepass'], $GLOBALS['cryptkeymain']);
			$backuppass = $this->strip_quotes_cmd($backuppass);
			$stream[]['comm'] = 'cd ' . $confUser['rootdir'] . ' && env GZIP=-' . $arr_conf['backup_level_compress'] . ' tar -cz ' . './ ' . $exclJail . ' | openssl enc -k \'' . $backuppass . '\' -e -aes-256-cbc > ' . $fifoname;
		}

		$remote_dir_exp = explode('/', $remote_dir);
		$remote_dir_onlyletter = str_replace('/', '', $remote_dir);
		$comm = $this->gdrive_ssh . ' --config ' . $this->gdrive_cred . $taskconf . ' list --absolute --max 99999 --name-width 0 | tr -s \' \'';
		$res_list = $this->ssh($comm);
		$exist_part_dir = 0;
		$concat_path = '';
		$remote_dir_exp = array_values(array_filter($remote_dir_exp));
		$exist_part_dir_prev_parid = '';

		foreach ($remote_dir_exp as $key => $curdir) {
			if (1 < strlen($curdir)) {
				$concat_path .= $curdir;
				$exist_part_dir = 0;

				foreach ($res_list as $cur_row) {
					$data = preg_split('/[\\s,;]/', $cur_row);
					$cur_dir_check_exist = str_replace('/', '', $data[1]);

					if ($concat_path == $cur_dir_check_exist) {
						$exist_part_dir = 1;
						$exist_part_dir_prev_parid = $data[0];
					}
				}

				if ($exist_part_dir == 0) {
					if (strlen($exist_part_dir_prev_parid) < 2) {
						$comm = $this->gdrive_ssh . ' --config ' . $this->gdrive_cred . $taskconf . ' mkdir \'' . $curdir . '\'';
						$exist_part_dir_prev_parid = preg_split('/[\\s,;]/', $this->ssh($comm)[0])[1];
					}
					else {
						$comm = $this->gdrive_ssh . ' --config ' . $this->gdrive_cred . $taskconf . ' mkdir \'' . $curdir . '\' --parent ' . $exist_part_dir_prev_parid;
						$exist_part_dir_prev_parid = preg_split('/[\\s,;]/', $this->ssh($comm)[0])[1];
					}
				}
			}
		}

		if (2 < strlen($exist_part_dir_prev_parid)) {
			$stream[]['comm'] = $this->gdrive_ssh . ' --config ' . $this->gdrive_cred . $taskconf . ' upload --parent ' . $exist_part_dir_prev_parid . ' ' . $fifoname;
		}
		else {
			$stream[]['comm'] = $this->gdrive_ssh . ' --config ' . $this->gdrive_cred . $taskconf . ' upload ' . $fifoname;
		}

		$stream[]['comm'] = '(du ' . $confUser['rootdir'] . ' -sb ) > ' . $completebackup_file_log . '_' . $username;
		$stream[]['comm'] = 'rm -f ' . $fifoname;
		return $stream;
	}

	public function gdrive_ls($taskconf, $dir, $user_data)
	{
		global $lang;
		$comm = $this->gdrive_ssh . ' --config ' . $this->gdrive_cred . $taskconf . ' list --absolute --max 99999 --name-width 0 | tr -s \' \'';
		$res_list = $this->ssh($comm);
		$res = array();

		if (count($res_list) < 2) {
			$res['code'] = -1;
			$res['text'] = $lang['backup_gdrive_error_connect'];
			return $res;
		}

		$ls_arr = array();
		$dir = str_replace('/', '', $dir);

		foreach ($res_list as $cur_row) {
			$data = preg_split('/[\\s,;]/', $cur_row);
			$curfile_backup = $data[1];
			$dir_file = dirname($curfile_backup);
			$dir_file = str_replace('/', '', $dir_file);
			$dir_file = str_replace('.', '', $dir_file);

			if ($dir != $dir_file) {
				continue;
			}

			$onlyfile = basename($curfile_backup);
			$username = explode('_', $onlyfile)[0];
			if (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['root'] == 'y') || ($username == $user_data['name'])) {
				if ((strpos($onlyfile, '.tar') !== false) || (strpos($onlyfile, '.tgz') !== false)) {
					$ls_arr[] = $cur_row;
				}
			}
		}

		return $ls_arr;
	}

	public function getlistbackup_gdrive($backupfind, $user_data, &$ind, $roundsize)
	{
		global $lang;
		$remote_dir = $backupfind['backup_remote_path'];
		$taskconf = $backupfind['filename_taskconfig'];

		if ($this->check_connect_gdrive($backupfind, $taskconf, NULL)['status'] != 1) {
			$res['code'] = -1;
			$res['text'] = $lang['backup_gdrive_noconn'];
			$this->listbackup[$ind]['failedconn'] = $lang['backup_gdrive_noconn'] . ' ' . $lang['backup_failedconn_getlist_task'] . $backupfind['backup_nametask'];
			++$ind;
			return $res;
		}

		$list = $this->gdrive_ls($taskconf, $remote_dir, $user_data);

		if ((0 < count($list)) && !isset($list['code'])) {
			foreach ($list as $user_backup) {
				$fulldata = preg_split('/[\\s,;]/', $user_backup);
				$fulldata = array_values(array_filter($fulldata));
				$onlyfile = basename($fulldata[1]);
				$username = explode('_', $onlyfile)[0];
				$date_file_exp = explode('-', $fulldata[5]);
				$file_date = $date_file_exp[2] . '.' . $date_file_exp[1] . '.' . $date_file_exp[0] . ' ' . $fulldata[6];

				if ($fulldata[4] == 'KB') {
					$file_size = floatval($fulldata[3]) / 1024;
				}
				else if ($fulldata[4] == 'B') {
					$file_size = floatval($fulldata[3]) / 1024 / 1024;
				}
				else {
					$file_size = floatval($fulldata[3]);
				}

				$check_uniq_backups_remote[] = $backupfind['backup_nametask'] . ':/' . $remote_dir . '/' . $onlyfile;
				$this->listbackup[$ind]['gdrive'][$username . '_' . $ind]['file'] = preg_replace('/(\\/+)/', '/', $backupfind['backup_nametask'] . ':/' . $remote_dir . '/' . $onlyfile);
				$this->listbackup[$ind]['gdrive'][$username . '_' . $ind]['file_path'] = $remote_dir . '/' . $onlyfile;
				$this->listbackup[$ind]['gdrive'][$username . '_' . $ind]['namefileonly'] = $onlyfile;
				$this->listbackup[$ind]['gdrive'][$username . '_' . $ind]['datecreate'] = $file_date;
				$this->listbackup[$ind]['gdrive'][$username . '_' . $ind]['size'] = round($file_size, $roundsize);

				if ($this->listbackup[$ind]['gdrive'][$username . '_' . $ind]['size'] == 0) {
					$this->listbackup[$ind]['gdrive'][$username . '_' . $ind]['size'] = round($file_size, 3);
				}

				$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
				$file_backup_stream_tmp = 'cat ' . $confUser['rootdir'] . '/' . $this->databackup_streamtmp;
				$file_restore_stream_tmp = 'cat ' . $confUser['rootdir'] . '/' . $this->datarestore_streamtmp;
				$file_backup_stream_tmp = $this->ssh($file_backup_stream_tmp);
				$file_restore_stream_tmp = $this->ssh($file_restore_stream_tmp);

				if (0 < strlen($file_backup_stream_tmp[0])) {
					$this->listbackup[$ind]['gdrive'][$username . '_' . $ind]['backupinprogress_stream'] = $file_backup_stream_tmp[0];
				}
				else {
					$this->listbackup[$ind]['gdrive'][$username . '_' . $ind]['backupinprogress_stream'] = '0';
				}

				if (0 < strlen($file_restore_stream_tmp[0])) {
					$this->listbackup[$ind]['gdrive'][$username . '_' . $ind]['restoreinprogress_stream'] = $file_restore_stream_tmp[0];
					$this->listbackup[$ind]['gdrive'][$username . '_' . $ind]['path_to_restore'] = $file_restore_stream_tmp[1];
				}
				else {
					$this->listbackup[$ind]['gdrive'][$username . '_' . $ind]['restoreinprogress_stream'] = '0';
					$this->listbackup[$ind]['gdrive'][$username . '_' . $ind]['path_to_restore'] = '0';
				}

				$homePath = str_replace($username, '', $confUser['rootdir']);
				$homePath = str_replace('//', '/', $homePath);
				$this->listbackup[$ind]['gdrive'][$username . '_' . $ind]['homedir'] = $homePath;
				$this->listbackup[$ind]['gdrive'][$username . '_' . $ind]['username'] = $username;
				$this->listbackup[$ind]['gdrive'][$username . '_' . $ind]['filename_taskconfig'] = $backupfind['filename_taskconfig'];
				++$ind;
			}
		}
	}

	public function create_backup_todropbox(&$stream, $arr_conf, $username, $taskconf, $completebackup_file_log)
	{
		if ($arr_conf['backup_level_compress'] == -1) {
			$arr_conf['backup_level_compress'] = $GLOBALS['BACKUP_LEVEL_COMPRESS'];
		}

		$file_name_pid = $this->formatNameBackupFolderArch($arr_conf, $username, $taskconf);

		if ($arr_conf['encryptbackup'] != 1) {
			$fifoname = $this->tmp_backup . $file_name_pid;
		}
		else {
			$fifoname = $this->tmp_backup . $file_name_pid . '.encoded';
		}

		if ($this->check_connect_dropbox($arr_conf, $taskconf, NULL)['status'] != 1) {
			global $lang;
			$stream[]['comm'] = 'echo ' . $lang['backup_dropbox_message_createbackup_failed'];
		}

		$stream_fifo = array();
		$stream_fifo[0]['test'] = '';
		$exclJail = $this->createExcludePathJail('tar');
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);

		if ($arr_conf['encryptbackup'] != 1) {
			$stream[]['comm'] = 'cd ' . $confUser['rootdir'] . ' && env GZIP=-' . $arr_conf['backup_level_compress'] . ' tar -cz ' . './ ' . $exclJail . ' > ' . $fifoname;
		}
		else {
			$backuppass = $this->decryptmainfunc($arr_conf['encfilepass'], $GLOBALS['cryptkeymain']);
			$backuppass = $this->strip_quotes_cmd($backuppass);
			$stream[]['comm'] = 'cd ' . $confUser['rootdir'] . ' && env GZIP=-' . $arr_conf['backup_level_compress'] . ' tar -cz ' . './ ' . $exclJail . ' | openssl enc -k \'' . $backuppass . '\' -e -aes-256-cbc > ' . $fifoname;
		}

		$stream[]['comm'] = $this->drop_ssh . ' -f ' . $this->drop_cred . $taskconf . ' upload ' . $fifoname . ' ' . escapeshellcmd($arr_conf['backup_remote_path'] . '/');
		$stream[]['comm'] = '(du ' . $confUser['rootdir'] . ' -sb ) > ' . $completebackup_file_log . '_' . $username;
		$stream[]['comm'] = 'rm -f ' . $fifoname;
		return $stream;
	}

	public function getlistbackup_dropbox($backupfind, $user_data, &$ind, $roundsize)
	{
		$remote_dir = $backupfind['backup_remote_path'];
		$taskconf = $backupfind['filename_taskconfig'];
		global $lang;
		$res = array();

		if ($this->check_connect_dropbox($backupfind, $taskconf, NULL)['status'] != 1) {
			$res['code'] = -1;
			$res['text'] = $lang['backup_dropbox_noconn'];
			$this->listbackup[$ind]['failedconn'] = $lang['backup_dropbox_noconn'] . ' ' . $lang['backup_failedconn_getlist_task'] . $backupfind['backup_nametask'];
			++$ind;
			return $res;
		}

		$comm = $this->drop_ssh . ' -f ' . $this->drop_cred . $taskconf . ' list ' . $remote_dir;
		$list_files = $this->ssh($comm);

		foreach ($list_files as $user_backup) {
			if (stripos($user_backup, ':file;') === false) {
				continue;
			}

			$exp_data = explode(':file;', $user_backup);
			$curfile_backup = $exp_data[0];
			$onlyfile = basename($curfile_backup);
			$username = explode('_', $onlyfile)[0];
			if (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['root'] == 'y') || ($username == $user_data['name'])) {
				if ((strpos($onlyfile, '.tar') !== false) || (strpos($onlyfile, '.tgz') !== false)) {
					$fulldata = explode(';', $exp_data[1])[1];
					$fulldata_date_exp = explode('T', $fulldata);
					$fulldata_date = explode('-', $fulldata_date_exp[0]);
					$fulldata_time = str_replace('Z', '', $fulldata_date_exp[1]);
					$file_date = $fulldata_date[2] . '.' . $fulldata_date[1] . '.' . $fulldata_date[0] . ' ' . $fulldata_time;
					$strTimeZ = strtotime($file_date) + date('Z');
					$file_date = date('d.m.Y H:i:s', $strTimeZ);
					$file_size = intval(explode(';', $exp_data[1])[0]) / 1024 / 1024;
					$check_uniq_backups_remote[] = $backupfind['backup_nametask'] . ':/' . $remote_dir . '/' . $onlyfile;
					$this->listbackup[$ind]['dropbox'][$username . '_' . $ind]['file'] = preg_replace('/(\\/+)/', '/', $backupfind['backup_nametask'] . ':/' . $remote_dir . '/' . $onlyfile);
					$this->listbackup[$ind]['dropbox'][$username . '_' . $ind]['file_path'] = $remote_dir . '/' . $onlyfile;
					$this->listbackup[$ind]['dropbox'][$username . '_' . $ind]['namefileonly'] = $onlyfile;
					$this->listbackup[$ind]['dropbox'][$username . '_' . $ind]['datecreate'] = $file_date;
					$this->listbackup[$ind]['dropbox'][$username . '_' . $ind]['size'] = round($file_size, $roundsize);

					if ($this->listbackup[$ind]['dropbox'][$username . '_' . $ind]['size'] == 0) {
						$this->listbackup[$ind]['dropbox'][$username . '_' . $ind]['size'] = round($file_size, 3);
					}

					$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
					$file_backup_stream_tmp = 'cat ' . $confUser['rootdir'] . '/' . $this->databackup_streamtmp;
					$file_restore_stream_tmp = 'cat ' . $confUser['rootdir'] . '/' . $this->datarestore_streamtmp;
					$file_backup_stream_tmp = $this->ssh($file_backup_stream_tmp);
					$file_restore_stream_tmp = $this->ssh($file_restore_stream_tmp);

					if (0 < strlen($file_backup_stream_tmp[0])) {
						$this->listbackup[$ind]['dropbox'][$username . '_' . $ind]['backupinprogress_stream'] = $file_backup_stream_tmp[0];
					}
					else {
						$this->listbackup[$ind]['dropbox'][$username . '_' . $ind]['backupinprogress_stream'] = '0';
					}

					if (0 < strlen($file_restore_stream_tmp[0])) {
						$this->listbackup[$ind]['dropbox'][$username . '_' . $ind]['restoreinprogress_stream'] = $file_restore_stream_tmp[0];
						$this->listbackup[$ind]['dropbox'][$username . '_' . $ind]['path_to_restore'] = $file_restore_stream_tmp[1];
					}
					else {
						$this->listbackup[$ind]['dropbox'][$username . '_' . $ind]['restoreinprogress_stream'] = '0';
						$this->listbackup[$ind]['dropbox'][$username . '_' . $ind]['path_to_restore'] = '0';
					}

					$homePath = str_replace($username, '', $confUser['rootdir']);
					$homePath = str_replace('//', '/', $homePath);
					$this->listbackup[$ind]['dropbox'][$username . '_' . $ind]['homedir'] = $homePath;
					$this->listbackup[$ind]['dropbox'][$username . '_' . $ind]['username'] = $username;
					$this->listbackup[$ind]['dropbox'][$username . '_' . $ind]['filename_taskconfig'] = $backupfind['filename_taskconfig'];
					++$ind;
				}
			}
		}
	}

	public function createBackupRemote($fileConf, $completebackup_file_log, $cur_user, $dir_name_pid_backup, $typeConn, $logpath = '/etc/brainy/aaa')
	{
		$arr_conf = $this->config_read($GLOBALS['BACKUP_CONF'] . $fileConf);
		$ip = $arr_conf['backup_remoteip'];
		$remote_dir = $arr_conf['backup_remote_path'];
		$bwlimit = intval($arr_conf['backup_rsync_speed_limit_kb']);
		$pass = $this->decryptmainfunc($arr_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
		$user = $arr_conf['backup_remote_login'];
		$connection = NULL;
		$port = $this->getPortServFtp($arr_conf, 'server');

		if ($typeConn == 'pass') {
			$connection = ssh2_connect($ip, $port);
			$resConn = ssh2_auth_password($connection, $user, $pass);
		}

		if ($typeConn == 'key') {
			$nameconfig = $fileConf;
			$namersakey = explode('.', $nameconfig)[0];
			$pathPrivateKey = $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey;
			$pathPublicKey = $pathPrivateKey . $GLOBALS['BACKUP_KEY_RSA_MASK_PUB'];
			$connection = ssh2_connect($ip, $port);
			$resConn = ssh2_auth_pubkey_file($connection, $user, $pathPublicKey, $pathPrivateKey);
		}

		if ($resConn == false) {
			global $lang;
			$this->ssh('echo \'' . $lang['backup_FailedConnWhileCreateBackupRemote'] . '\'');
			file_put_contents($logpath, $lang['backup_FailedConnWhileCreateBackupRemote'] . "\n", FILE_APPEND);
			return -2;
		}

		$resultMK = $this->sendSshQuery($connection, 'mkdir -p ' . $remote_dir . '/' . $dir_name_pid_backup . '/' . $GLOBALS['BACKUP_HOMEDIR']);
		$resultMK = $this->sendSshQuery($connection, 'ls -al ' . $remote_dir . '/' . $dir_name_pid_backup . '/' . $GLOBALS['BACKUP_HOMEDIR']);
		$port = $this->getPortServFtp($arr_conf, 'server');

		if (strlen($resultMK) < 3) {
			global $lang;
			$this->ssh('echo \'' . $lang['backup_FailedCreateDir'] . '\'');
			file_put_contents($logpath, $lang['backup_FailedCreateDir'] . "\n", FILE_APPEND);
			return -2;
		}

		$exclJail = $this->createExcludePathJail('rsync');
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $cur_user);
		$this->ssh('ssh-keygen -R \'' . $this->strip_quotes_cmd($ip) . '\' && ssh-keyscan -H \'' . $this->strip_quotes_cmd($ip) . '\' >>  ~/.ssh/known_hosts');

		if ($typeConn == 'pass') {
			$this->ssh('sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' rsync --bwlimit=' . $bwlimit . ' -azh ' . $exclJail . ' --info=progress2 -e \'ssh -p ' . $port . '\' --delete ' . $confUser['rootdir'] . '/' . ' ' . $user . '@' . $ip . ':' . $remote_dir . '/' . $dir_name_pid_backup . '/' . $GLOBALS['BACKUP_HOMEDIR']);
		}

		if ($typeConn == 'key') {
			$this->ssh('rsync --bwlimit=' . $bwlimit . ' -azh ' . $exclJail . ' --info=progress2 -e \'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . '\'' . ' --delete ' . $confUser['rootdir'] . '/ ' . $user . '@' . $ip . ':' . $remote_dir . '/' . $dir_name_pid_backup . '/' . $GLOBALS['BACKUP_HOMEDIR']);
		}

		$this->sendSshQuery($connection, '(du ' . $remote_dir . '/' . $dir_name_pid_backup . ' -sb && date +%s) > ' . $remote_dir . '/' . $dir_name_pid_backup . '/' . $this->databackupinfofile);
		$stream[]['comm'] = '(du ' . $confUser['rootdir'] . ' -sb) > ' . $completebackup_file_log . '_' . $cur_user;
		$this->sendSshQuery($connection, 'ssh \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \' rm -rf  ' . $remote_dir . '/' . $dir_name_pid_backup . '/' . $this->dir_backup_configs);
		$this->sendSshQuery($connection, 'rm -rf ' . $remote_dir . '/' . $dir_name_pid_backup . '/' . $this->user_tmp . '/');
		$this->sendSshQuery($connection, 'mkdir -p  ' . $remote_dir . '/' . $dir_name_pid_backup . '/' . $this->user_tmp . '/');
		$this->sendSshQuery($connection, 'mv  ' . $remote_dir . '/' . $dir_name_pid_backup . '/' . $GLOBALS['BACKUP_HOMEDIR'] . '/' . $this->dir_backup_configs . ' ' . $remote_dir . '/' . $dir_name_pid_backup . '/' . $this->user_tmp . '/');
		$this->sendSshQuery($connection, 'chown -R  root.root ' . $remote_dir . '/' . $dir_name_pid_backup . '/');
		$this->sendSshQuery($connection, 'find ' . $remote_dir . '/' . $dir_name_pid_backup . ' -type f -exec chmod 644 {} \\;');
		$this->sendSshQuery($connection, 'find ' . $remote_dir . '/' . $dir_name_pid_backup . ' -type d -exec chmod 755 {} \\;');
		$this->sendSshQuery($connection, 'rm -rf ' . $remote_dir . '/' . $dir_name_pid_backup . '/' . $GLOBALS['BACKUP_HOMEDIR'] . '/' . $this->databackup_streamtmp);
	}

	public function str_replace_first_end($search, $replace, $subject)
	{
		$pos = strrpos($subject, $search);

		if ($pos !== false) {
			return substr_replace($subject, $replace, $pos, strlen($search));
		}

		return $subject;
	}

	public function createExcludePathJail($type)
	{
		$hostacc = new hostacc();
		$exclRes = '';

		foreach ($hostacc->listdirJail as $curExcl) {
			if ($type == 'tar') {
				$exclRes .= '--exclude=\'./' . $curExcl . '\' ';
			}

			if ($type == 'rsync') {
				$exclRes .= '--exclude=\'/' . $curExcl . '\' ';
			}
		}

		return $exclRes;
	}

	public function createarch_local_stream($time, $backupcreate, $user_data, $serialdata, $arr_conf, $streamid, $mysql_conn, $taskconf)
	{
		global $lang;
		$decode = json_decode($serialdata, true);

		if ($decode['command'] == 'wait') {
			$pid = $this->getexistpid($streamid);

			if ($pid == -1) {
				$backupcreate = 2;
			}
			else {
				$backupcreate = 1;
			}
		}
		else if (!$this->check_value('number', $time)) {
			return false;
		}
		else if (!$this->check_value('number', $backupcreate)) {
			return false;
		}
		else if (!$this->check_value('number', $streamid)) {
			return false;
		}

		$task_exp_own = explode('.', $taskconf)[0];
		$task_exp_own = explode('_', $task_exp_own)[0];

		if ($decode['command'] != 'wait') {
			$users_arr = explode(',', $arr_conf['backup_selected_users']);

			foreach ($users_arr as $key => $cur_check) {
				if ($task_exp_own != 'config') {
					if ($task_exp_own != $cur_check) {
						unset($users_arr[$key]);
					}
				}

				return 0;
			}
		}

		$backup_all = intval($arr_conf['backup_make_for_all_users']);

		if ($backup_all == 1) {
			if ($task_exp_own == 'config') {
				$users_arr = $this->get_users();
			}
		}

		switch ($backupcreate) {
		case 0:
			$completebackup_file_log = $this->dir_complete . 'complete_' . time() . '_' . rand(100, 99999) . '_' . explode('.', $taskconf)[0];
			$completebackup_timestart = date('d.m.Y H:i:s');

			foreach ($users_arr as $cur_user) {
				if (1 < strlen($cur_user)) {
					$conf_user_hostacc = parse_ini_file($GLOBALS['USERS_PATH'] . $cur_user);

					if ($arr_conf['backup_repo'] == 'local') {
						if ($task_exp_own != 'config') {
							if (stripos($arr_conf['backup_pathlocal'], $conf_user_hostacc['rootdir']) === false) {
								$resmass['status'] = 'done';
								$resmass['stream_id'] = 'nostream';
								$resmass['raw_info'] = $lang['backup_backup_pathlocal_wrong_dir'];

								return $resmass;
							}
						}
					}

					if (!isset($conf_user_hostacc['rootdir']) || (strlen($conf_user_hostacc['rootdir']) < 3)) {
						continue;
					}

					$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $cur_user);
					$this->backup_emails_user($cur_user);
					$this->backup_email_forward($cur_user);
					$this->backup_dns_user($cur_user);
					$this->backup_dkimkeys_user($cur_user);
					$this->backup_webserver_includes_user($cur_user);
					$dbs = $mysql_conn->mysql_get_dbs($cur_user);
					$dbs = array_values(array_filter($dbs));
					$mysql_users = $mysql_conn->mysql_get_users($cur_user);
					$mysql_users = array_values(array_filter($mysql_users));
					$conf_user_hostacc = parse_ini_file($GLOBALS['USERS_PATH'] . $cur_user);
					$dir_name_pid = $cur_user;
					$this->backup_autoins_config_user($dir_name_pid);
					$this->backup_backups_jobs($dir_name_pid);
					$this->backup_user_info($dir_name_pid);
					$this->backup_ftps_acc($dir_name_pid);
					$this->backup_vhosts($cur_user);
					$mysql_users[] = $dir_name_pid;
					$res = $this->makedump_sql_arr_users($mysql_users, $confUser['rootdir'] . '/' . $this->mysql_dir_backup, $mysql_conn, $dbs, $dir_name_pid);
					$res_dump_do = $this->makedump_sql_arr($dbs, $confUser['rootdir'] . '/' . $this->mysql_dir_backup, $dir_name_pid);
					$stream[]['comm'] = 'echo \'createbackuphint #' . $cur_user . '#\' >>/dev/null';

					foreach ($res_dump_do as $curdump) {
						$stream[]['comm'] = $curdump;
					}

					if ($arr_conf['backup_repo'] == 'ftp') {
						$this->create_backup_toftp($stream, $arr_conf, $dir_name_pid, $taskconf, $completebackup_file_log);
					}

					if ($arr_conf['backup_repo'] == 'YandexDisk') {
						$this->create_backup_toyandex($stream, $arr_conf, $dir_name_pid, $taskconf, $completebackup_file_log);
					}

					if ($arr_conf['backup_repo'] == 'GoogleDrive') {
						$this->create_backup_togdrive($stream, $arr_conf, $dir_name_pid, $taskconf, $completebackup_file_log);
					}

					if ($arr_conf['backup_repo'] == 'Dropbox') {
						$this->create_backup_todropbox($stream, $arr_conf, $dir_name_pid, $taskconf, $completebackup_file_log);
					}

					if ($arr_conf['backup_repo'] == 'local') {
						if (!is_dir($arr_conf['backup_pathlocal'])) {
							$this->ssh('mkdir -p ' . $arr_conf['backup_pathlocal']);
							$this->change_owner($arr_conf['backup_pathlocal'] . '/', $cur_user);
						}

						$task_exp_own = explode('.', $taskconf)[0];
						$task_exp_own = explode('_', $task_exp_own)[0];

						if ($task_exp_own != 'config') {
							$relat_path_todir = str_replace($conf_user_hostacc['rootdir'], '', $arr_conf['backup_pathlocal']);
							$relat_exp = explode('/', $relat_path_todir);

							foreach ($relat_exp as $cur_relat) {
								$relat_todir = $cur_relat;
								break;
							}

							$this->ssh('chown -R ' . $task_exp_own . '.' . $task_exp_own . ' ' . $conf_user_hostacc['rootdir'] . '/' . $relat_todir);
						}

						if ($arr_conf['backup_type_arch_array'] == 'tar') {
							if ($arr_conf['backup_level_compress'] == -1) {
								$arr_conf['backup_level_compress'] = $GLOBALS['BACKUP_LEVEL_COMPRESS'];
							}

							$file_name_pid = $this->formatNameBackupFolderArch($arr_conf, $cur_user, $taskconf);
							$stream[]['comm'] = 'mkdir -p ' . $arr_conf['backup_pathlocal'];
							$exclJail = $this->createExcludePathJail('tar');
							$exclude = str_replace($confUser['rootdir'] . '/', '', $arr_conf['backup_pathlocal']);

							if ($exclude[strlen($exclude) - 1] == '/') {
								$exclude = $this->str_replace_first_end('/', '', $exclude);
							}

							if ($arr_conf['encryptbackup'] != 1) {
								$stream[]['comm'] = 'cd ' . $confUser['rootdir'] . ' && env GZIP=-' . $arr_conf['backup_level_compress'] . ' tar czpf ' . $arr_conf['backup_pathlocal'] . '/' . $file_name_pid . ' ./ ' . ' --exclude=\'' . $exclude . '\' ' . $exclJail;
							}
							else {
								$backuppass = $this->decryptmainfunc($arr_conf['encfilepass'], $GLOBALS['cryptkeymain']);
								$backuppass = $this->strip_quotes_cmd($backuppass);
								$stream[]['comm'] = 'cd ' . $confUser['rootdir'] . ' && env GZIP=-' . $arr_conf['backup_level_compress'] . ' tar czpf - ./  --exclude=\'' . $exclude . '\' ' . $exclJail . ' | openssl enc -k \'' . $backuppass . '\' -e -aes-256-cbc > ' . $arr_conf['backup_pathlocal'] . '/' . $file_name_pid . '.encoded ';
							}

							$stream[]['comm'] = '(du ' . $confUser['rootdir'] . ' -sb ) > ' . $completebackup_file_log . '_' . $cur_user;

							if ($task_exp_own != 'config') {
								$stream[]['comm'] = 'chown -R ' . $task_exp_own . '.' . $task_exp_own . ' ' . $arr_conf['backup_pathlocal'] . '/' . $file_name_pid . '*';
							}
							else {
								$stream[]['comm'] = 'chown -R  root.root ' . $arr_conf['backup_pathlocal'] . '/' . $file_name_pid;
							}
						}

						if (($arr_conf['backup_type_arch_array'] == 'incr_noarch') || ($arr_conf['backup_type_arch_array'] == 'simple_noarch')) {
							$dir_name_pid_backup = $this->formatNameBackupFolderName($arr_conf, $cur_user, $taskconf);
							$stream[]['comm'] = 'mkdir -p ' . $arr_conf['backup_pathlocal'] . '/' . $dir_name_pid_backup . '/' . $GLOBALS['BACKUP_HOMEDIR'];
							$exclJail = $this->createExcludePathJail('rsync');
							$exclude = str_replace($confUser['rootdir'] . '/', '', $arr_conf['backup_pathlocal'] . '/');
							$exclude_du = str_replace($confUser['rootdir'] . '/', '', $arr_conf['backup_pathlocal']);
							$stream[]['comm'] = 'rsync -azh --exclude ' . $exclude . ' ' . $exclJail . ' --info=progress2 --delete ' . $confUser['rootdir'] . '/' . ' ' . $arr_conf['backup_pathlocal'] . '/' . $dir_name_pid_backup . '/' . $GLOBALS['BACKUP_HOMEDIR'];
							$stream[]['comm'] = '(du ' . $arr_conf['backup_pathlocal'] . '/' . $dir_name_pid_backup . ' -sb --exclude ' . $exclude_du . ' ' . $exclJail . ' && date +%s) > ' . $arr_conf['backup_pathlocal'] . '/' . $dir_name_pid_backup . '/' . $this->databackupinfofile;
							$stream[]['comm'] = '(du ' . $confUser['rootdir'] . ' -sb --exclude ' . $exclude_du . ' ' . $exclJail . ') > ' . $completebackup_file_log . '_' . $cur_user;
							$stream[]['comm'] = 'rm -rf ' . $arr_conf['backup_pathlocal'] . '/' . $dir_name_pid_backup . '/' . $this->dir_backup_configs;
							$stream[]['comm'] = 'mkdir -p ' . $arr_conf['backup_pathlocal'] . '/' . $dir_name_pid_backup . '/' . $this->user_tmp;
							$stream[]['comm'] = 'mv  ' . $arr_conf['backup_pathlocal'] . '/' . $dir_name_pid_backup . '/' . $GLOBALS['BACKUP_HOMEDIR'] . '/' . $this->dir_backup_configs . ' ' . $arr_conf['backup_pathlocal'] . '/' . $dir_name_pid_backup . '/' . $this->user_tmp . '/';

							if ($task_exp_own != 'config') {
								$stream[]['comm'] = 'chown -R ' . $task_exp_own . '.' . $task_exp_own . ' ' . $arr_conf['backup_pathlocal'] . '/' . $dir_name_pid_backup;
							}
							else {
								$stream[]['comm'] = 'chown -R  root.root ' . $arr_conf['backup_pathlocal'] . '/' . $dir_name_pid_backup;
							}

							$stream[]['comm'] = 'find ' . $arr_conf['backup_pathlocal'] . '/' . $dir_name_pid_backup . ' -type f -exec chmod 644 {} \\;';
							$stream[]['comm'] = 'find ' . $arr_conf['backup_pathlocal'] . '/' . $dir_name_pid_backup . ' -type d -exec chmod 755 {} \\;';
							$stream[]['comm'] = 'rm -rf ' . $arr_conf['backup_pathlocal'] . '/' . $dir_name_pid_backup . '/' . $GLOBALS['BACKUP_HOMEDIR'] . '/' . $this->databackup_streamtmp;
						}
					}

					if ($arr_conf['backup_repo'] == 'remote') {
						$port = $this->getPortServFtp($arr_conf, 'server');
						if (($arr_conf['backup_type_arch_array'] == 'incr_noarch') || ($arr_conf['backup_type_arch_array'] == 'simple_noarch')) {
							$dir_name_pid_backup = $this->formatNameBackupFolderName($arr_conf, $cur_user, $taskconf);

							if ($arr_conf['backup_type_auth'] == 'pass') {
								$param = array('fileconf' => $taskconf, 'completebackup_file_log' => $completebackup_file_log, 'cur_user' => $cur_user, 'dir_name_pid_backup' => $dir_name_pid_backup, 'typeconn' => 'pass');
								$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'createbackupremotersync\' -p=\'' . json_encode($param) . '\'';
							}

							if ($arr_conf['backup_type_auth'] == 'key') {
								$param = array('fileconf' => $taskconf, 'completebackup_file_log' => $completebackup_file_log, 'cur_user' => $cur_user, 'dir_name_pid_backup' => $dir_name_pid_backup, 'typeconn' => 'key');
								$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'createbackupremotersync\' -p=\'' . json_encode($param) . '\'';
							}
						}

						if ($arr_conf['backup_type_arch_array'] == 'tar') {
							$file_name_pid = $this->formatNameBackupFolderArch($arr_conf, $cur_user, $taskconf);

							if ($arr_conf['backup_type_auth'] == 'pass') {
								$ip = $arr_conf['backup_remoteip'];
								$remote_dir = $arr_conf['backup_remote_path'];
								$pass = $this->decryptmainfunc($arr_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
								$user = $arr_conf['backup_remote_login'];
								$stream[]['comm'] = 'ssh-keygen -R \'' . $this->strip_quotes_cmd($ip) . '\' && ssh-keyscan -H \'' . $this->strip_quotes_cmd($ip) . '\' >>  ~/.ssh/known_hosts';
								$tarstream_create = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'echo  streamid ' . ' > ' . $remote_dir . '/' . $dir_name_pid . '_' . $this->databackup_streamtmp . '\'';
								$stream[]['comm'] = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'mkdir -p ' . $remote_dir . '\'';
								$exclJail = $this->createExcludePathJail('tar');

								if ($arr_conf['encryptbackup'] != 1) {
									$stream[]['comm'] = 'cd ' . $confUser['rootdir'] . ' && env GZIP=-' . $arr_conf['backup_level_compress'] . ' && tar -czf - ./ ' . $exclJail . ' | sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'cat ' . ' > ' . $remote_dir . '/' . $file_name_pid . '\'';
									$stream[]['comm'] = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'md5sum ' . $remote_dir . '/' . $file_name_pid . ' >' . $remote_dir . '/' . $file_name_pid . '.md5\'';
								}
								else {
									$backuppass = $this->decryptmainfunc($arr_conf['encfilepass'], $GLOBALS['cryptkeymain']);
									$backuppass = $this->strip_quotes_cmd($backuppass);
									$stream[]['comm'] = 'cd ' . $confUser['rootdir'] . ' && env GZIP=-' . $arr_conf['backup_level_compress'] . ' && tar -czf - ./ ' . $exclJail . ' | openssl enc -k \'' . $backuppass . '\' -e -aes-256-cbc | sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'cat ' . ' > ' . $remote_dir . '/' . $file_name_pid . '.encoded\' ';
									$stream[]['comm'] = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'md5sum ' . $remote_dir . '/' . $file_name_pid . '.encoded >' . $remote_dir . '/' . $file_name_pid . '.encoded.md5\'';
								}

								$stream[]['comm'] = '(du ' . $confUser['rootdir'] . ' -sb) > ' . $completebackup_file_log . '_' . $cur_user;
								$stream[]['comm'] = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'rm ' . $remote_dir . '/' . $dir_name_pid . '_' . $this->databackup_streamtmp . '\'';
							}

							if ($arr_conf['backup_type_auth'] == 'key') {
								$nameconfig = $taskconf;
								$namersakey = explode('.', $nameconfig)[0];
								$dir_name_pid = $cur_user;
								$ip = $arr_conf['backup_remoteip'];
								$remote_dir = $arr_conf['backup_remote_path'];
								$pass = $this->decryptmainfunc($arr_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
								$user = $arr_conf['backup_remote_login'];
								$stream[]['comm'] = 'ssh-keygen -R \'' . $ip . '\' && ssh-keyscan -H \'' . $ip . '\' >>  ~/.ssh/known_hosts';
								$tarstream_create = 'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'echo  streamid ' . ' > ' . $remote_dir . '/' . $dir_name_pid . '_' . $this->databackup_streamtmp . '\'';
								$stream[]['comm'] = 'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'mkdir -p ' . $remote_dir . '\'';
								$exclJail = $this->createExcludePathJail('tar');

								if ($arr_conf['encryptbackup'] != 1) {
									$stream[]['comm'] = 'cd ' . $confUser['rootdir'] . ' && env GZIP=-' . $arr_conf['backup_level_compress'] . ' && tar -czf - ./ ' . $exclJail . ' | ssh -p ' . $port . ' -i \'' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . '\' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'cat ' . ' > ' . $remote_dir . '/' . $file_name_pid . '\'';
									$stream[]['comm'] = 'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'md5sum ' . $remote_dir . '/' . $file_name_pid . ' >' . $remote_dir . '/' . $file_name_pid . '.md5\'';
								}
								else {
									$backuppass = $this->decryptmainfunc($arr_conf['encfilepass'], $GLOBALS['cryptkeymain']);
									$backuppass = $this->strip_quotes_cmd($backuppass);
									$stream[]['comm'] = 'cd ' . $confUser['rootdir'] . ' && env GZIP=-' . $arr_conf['backup_level_compress'] . ' && tar -czf - ./ ' . $exclJail . ' | openssl enc -k \'' . $backuppass . '\' -e -aes-256-cbc | ssh -p ' . $port . ' -i \'' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . '\' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'cat ' . ' > ' . $remote_dir . '/' . $file_name_pid . '.encoded\' ';
									$stream[]['comm'] = 'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'md5sum ' . $remote_dir . '/' . $file_name_pid . '.encoded >' . $remote_dir . '/' . $file_name_pid . '.encoded.md5\'';
								}

								$stream[]['comm'] = '(du ' . $confUser['rootdir'] . ' -sb) > ' . $completebackup_file_log . '_' . $cur_user;
								$stream[]['comm'] = 'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'rm ' . $remote_dir . '/' . $dir_name_pid . '_' . $this->databackup_streamtmp . '\'';
							}
						}
					}

					$stream[]['comm'] = 'rm -rf ' . $confUser['rootdir'] . '/' . $this->databackup_streamtmp;
					$stream[]['comm'] = 'rm -rf ' . $confUser['rootdir'] . '/' . $this->dir_backup_configs;
					$param = array('username' => $dir_name_pid, 'backup_fileconf' => $taskconf, 'userdata' => $user_data);
					$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'calcbackupsfordelete\' -p=\'' . json_encode($param) . '\'';
				}
			}

			$param = array('completebackup_file_log' => $completebackup_file_log, 'completebackup_timestart' => $completebackup_timestart);
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'emailsendcomplete\' -p=\'' . json_encode($param) . '\'';
			$stream[]['comm'] = 'echo \'completecreatebackup\' >> /dev/null';
			$stream[0]['array_start'] = array('backupcreate_#stream_id#_#stream_pid#' => '1', 'backupcreate_name_#stream_id#_#stream_pid#' => $user_data['name'], 'starttime_#stream_id#_#stream_pid#' => $time);
			$stream[0]['test'] = '';
			$stream[0]['array_success'] = array('backupcreate_#stream_id#_#stream_pid#' => '2', 'endtime_#stream_id#_#stream_pid#' => $time);
			$stream[0]['array_unsucces'] = array('backupcreate_#stream_id#_#stream_pid#' => '3', 'endtime_#stream_id#_#stream_pid#' => $time);
			$backupParamFile = '/etc/brainy/data/streams/backup_param_' . time() . '_' . rand(100, 99999);
			$stream[]['comm'] = 'rm -f ' . $backupParamFile;
			file_put_contents($backupParamFile, json_encode($stream, 1));
			$stream_id = $this->create_stream($stream, $backupParamFile);
			$out1 = $this->read_stream($stream_id, 1);

			if ($arr_conf['backup_repo'] == 'local') {
				$pathbackup = $arr_conf['backup_pathlocal'];
			}
			else if ($arr_conf['backup_repo'] == 'YandexDisk') {
				$pathbackup = $arr_conf['backup_remote_path'];
			}
			else {
				$pathbackup = $arr_conf['backup_remoteip'] . $arr_conf['backup_remote_path'];
			}

			$this->writelog_backup($stream_id, $arr_conf['backup_nametask'], $pathbackup, $user_data, $taskconf);
			$resmass['status'] = 'inprogress';
			$resmass['stream_id'] = $stream_id;

			if (!is_dir($GLOBALS['BACKUP_CONF_STREAM'])) {
				$comm = 'mkdir -p ' . $GLOBALS['BACKUP_CONF_STREAM'];
				$this->ssh($comm);
			}

			file_put_contents($GLOBALS['BACKUP_CONF_STREAM'] . '/' . $user_data['name'] . '_backup.conf', $stream_id . "\n", FILE_APPEND | LOCK_EX);

			foreach ($users_arr as $cur_user) {
				if (1 < strlen($cur_user)) {
					file_put_contents($confUser['rootdir'] . '/' . $this->databackup_streamtmp, $stream_id, LOCK_EX);
					$this->ssh('chown -R ' . $cur_user . '.' . $cur_user . ' ' . $confUser['rootdir'] . '/' . $this->databackup_streamtmp);

					if (isset($tarstream_create)) {
						$tarstream_create = str_replace('streamid', $stream_id, $tarstream_create);
						$this->ssh($tarstream_create);
					}
				}
			}

			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		case 1:
			$out1 = $this->read_stream($streamid, 1);
			$arr_res = preg_split('/\\r\\n|\\r|\\n/', $out1[count($out1) - 1]);
			$arr_progress_cur = preg_split('/\\r\\n|\\r|\\n\\t|\\s+/', $arr_res[count($arr_res) - 1]);
			$arr_progress_cur = array_values(array_filter($arr_progress_cur));
			$resmass['status'] = 'inprogress';
			$resmass['stream_id'] = $streamid;
			$resmass['raw_info'] = implode("\n", $out1);
			$resmass['raw_process'] = $arr_progress_cur;
			return $resmass;
		case 2:
			$out1 = $this->read_stream($streamid, 1);
			$resmass['status'] = 'done';
			$resmass['stream_id'] = $streamid;
			$resmass['raw_info'] = implode("\n", $out1);
			$resmass['streamfull'] = $streamid;
			return $resmass;
		case 3:
			$out1 = $this->read_stream($streamid, 1);
			$resmass['status'] = 'failed';
			$resmass['stream_id'] = $streamid;
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}
	}

	public function createarch_local2($user_data, $serialdata, $mysql)
	{
		$this->load_vars();
		$decode = json_decode($serialdata, true);

		if (!$this->check_value('user', $user_data['name'])) {
			return 0;
		}

		if (0 < strlen($decode['backup_file_config'])) {
			if (!$this->check_value('dir', $decode['backup_file_config'])) {
				return 0;
			}
		}

		$file_conf = $decode['backup_file_config'];
		$arr_conf = $this->config_read($GLOBALS['BACKUP_CONF'] . $file_conf);
		$command = $decode['command'];
		$arr_backuplist = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($GLOBALS['BACKUP_CONF_STREAM'] . $user_data['name'] . '_backup.conf'));
		$time = time();

		if ($command == 'create') {
			$res[] = $this->createarch_local_stream($time, 0, $user_data, $serialdata, $arr_conf, 0, $mysql, $file_conf);
			return $res;
		}

		if (1 < count($arr_backuplist)) {
			foreach ($arr_backuplist as $streamid) {
				if (strlen($streamid) < 3) {
					continue;
				}

				$backupcreate = intval($this->module_vars['backupcreate_' . $streamid]);
				$res[] = $this->createarch_local_stream($time, $backupcreate, $user_data, $serialdata, $arr_conf, $streamid, $mysql, $file_conf);
			}

			if (count($res) < 1) {
				$res['status'] = 'done';
				$res['raw_info'] = 'no stream backup';
			}
		}
		else {
			$res['status'] = 'done';
			$res['raw_info'] = 'no stream backup';
		}

		foreach ($res as $item) {
			if (isset($item['streamfull'])) {
				$key = array_search($item['streamfull'], $arr_backuplist);

				if ($key !== false) {
					unset($arr_backuplist[$key]);
				}
			}
		}

		file_put_contents($GLOBALS['BACKUP_CONF_STREAM'] . '/' . $user_data['name'] . '_backup.conf', '', LOCK_EX);

		foreach ($arr_backuplist as $item) {
			if (1 < strlen($item)) {
				file_put_contents($GLOBALS['BACKUP_CONF_STREAM'] . '/' . $user_data['name'] . '_backup.conf', $item . "\n", FILE_APPEND | LOCK_EX);
			}
		}

		return $res;
	}

	public function check_db_is_load($user_data, $db, $user_name, $local_dir = NULL)
	{
		if (is_null($local_dir)) {
			$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user_name);

			if (is_file($confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $db)) {
				$db_time = filemtime($confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $db);
				$timenow = time();
				$diff = round(abs($timenow - $db_time) / 3600, 2);

				if ($diff < 5) {
					return 1;
				}

				return 0;
			}

			return 0;
		}

		if (is_file($local_dir . '/' . $user_name . '/' . $this->mysql_dir_backup . '/' . $db)) {
			return 1;
		}

		return 0;
	}

	public function prepare_dbs_download_remote($user_data, $serialdata)
	{
		$time = time();
		$decode = json_decode($serialdata, true);

		if (!$this->check_value('user', $decode['username'])) {
			return 0;
		}

		if (!$this->check_value('strdotx2', $decode['taskconf'])) {
			return 0;
		}

		if (!$this->check_value('dir', $decode['homedir'])) {
			return 0;
		}

		$task_name = $decode['taskconf'];
		$res_perm = $this->checkperm_path($user_data, $task_name, '_');

		if ($res_perm['res'] != 1) {
			return $res_perm;
		}

		$arrfi['backup_configfile'] = $task_name;
		$serialdata = json_encode($arrfi);
		$arr_param_backup_conf = $this->getconfig($user_data, $serialdata);
		$user_name = explode('_', $decode['username'])[0];
		$res_perm = $this->checkperm_path($user_data, $user_name, '_');

		if ($res_perm['res'] != 1) {
			return $res_perm;
		}

		$user_path_backup = $decode['username'];
		$dbsload = $decode['dbsload'];
		$db_all_string = '';

		if (is_array($dbsload)) {
			foreach ($dbsload as $db) {
				$res_perm = $this->checkperm_path($user_data, $db, '_');
				$db_all_string .= $db . ',';

				return $res_perm;
			}
		}
		else {
			$res_perm = $this->checkperm_path($user_data, $dbsload, '_');
			$db_all_string .= $dbsload . ',';

			if ($res_perm['res'] != 1) {
				return $res_perm;
			}
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user_name);

		if ($decode['command'] != 'wait_copy_dbs') {
			if (!is_dir($confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS'])) {
				$comm = 'mkdir -p ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS'];
				$this->ssh($comm);
				$this->ssh('chown -R ' . $user_name . '.' . $user_name . ' ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/*');
				$this->ssh('chown -R ' . $user_name . '.' . $user_name . ' ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR']);
			}

			if ($arr_param_backup_conf['backup_repo'] == 'remote') {
				$port = $this->getPortServFtp($arr_param_backup_conf, 'server');
				if (($arr_param_backup_conf['backup_type_arch_array'] == 'incr_noarch') || ($arr_param_backup_conf['backup_type_arch_array'] == 'simple_noarch')) {
					if ($arr_param_backup_conf['backup_type_auth'] == 'key') {
						$ip = $arr_param_backup_conf['backup_remoteip'];
						$remote_dir = $arr_param_backup_conf['backup_remote_path'];
						$pass = $this->decryptmainfunc($arr_param_backup_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
						$user = $arr_param_backup_conf['backup_remote_login'];
						$namersakey = explode('.', $task_name)[0];

						if (is_array($dbsload)) {
							$dbs = '';

							foreach ($dbsload as $db) {
								$stream[]['comm'] = 'scp -P ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' ' . $user . '@' . $ip . ':' . $remote_dir . '/' . $user_path_backup . '/' . $this->mysql_dir_backup . '/' . $db . ' ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/';
								$dbs .= $db . ' ';
							}

							$stream[]['comm'] = 'tar cf ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $user_name . '_dbs.tar -C ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/ ' . $dbs;
						}
						else {
							$stream[]['comm'] = 'scp -P ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' ' . $user . '@' . $ip . ':' . $remote_dir . '/' . $user_path_backup . '/' . $this->mysql_dir_backup . '/' . $dbsload . ' ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/';
						}
					}

					if ($arr_param_backup_conf['backup_type_auth'] == 'pass') {
						$ip = $arr_param_backup_conf['backup_remoteip'];
						$remote_dir = $arr_param_backup_conf['backup_remote_path'];
						$pass = $this->decryptmainfunc($arr_param_backup_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
						$user = $arr_param_backup_conf['backup_remote_login'];

						if (is_array($dbsload)) {
							$dbs = '';

							foreach ($dbsload as $db) {
								$stream[]['comm'] = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' scp -P ' . $port . ' \'' . $this->strip_quotes_cmd($ip) . ':' . $remote_dir . '/' . $user_path_backup . '/' . $this->mysql_dir_backup . '/' . $db . '\' ' . ' ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/';
								$dbs .= $db . ' ';
							}

							$stream[]['comm'] = 'tar cf ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $user_name . '_dbs.tar -C ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/ ' . $dbs;
						}
						else {
							$stream[]['comm'] = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' scp -P ' . $port . ' \'' . $this->strip_quotes_cmd($ip) . ':' . $remote_dir . '/' . $user_path_backup . '/' . $this->mysql_dir_backup . '/' . $dbsload . '\' ' . ' ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/';
						}
					}
				}
			}

			if ($arr_param_backup_conf['backup_repo'] == 'local') {
				if (($arr_param_backup_conf['backup_type_arch_array'] == 'incr_noarch') || ($arr_param_backup_conf['backup_type_arch_array'] == 'simple_noarch')) {
					$remote_dir = $arr_param_backup_conf['backup_pathlocal'];

					if (is_array($dbsload)) {
						$dbs = '';
						$dbs_spl = '';

						foreach ($dbsload as $db) {
							$dbs .= $db . ' ';
							$dbs_spl .= $db . ',';
						}

						$comm = 'tar cf ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $user_name . '_dbs.tar -C ' . $remote_dir . '/' . $user_path_backup . '/' . $this->mysql_dir_backup . '/ ' . $dbs;
					}
					else {
						$comm = 'tar cf ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $user_name . '_dbs.tar -C ' . $remote_dir . '/' . $user_path_backup . '/' . $this->mysql_dir_backup . '/' . $dbsload;
					}

					$this->ssh($comm);
					$resmass[0]['status'] = 'done';
					$resmass[0]['db'] = $dbs_spl;
					$resmass[0]['path'] = $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/';
					$resmass[0]['dbs_arch'] = $user_name . '_dbs.tar';
					return $resmass;
				}
			}

			$stream[]['comm'] = 'chown -R ' . $user_name . '.' . $user_name . ' ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/*';
			$stream[0]['array_start'] = array('copydbs_#stream_id#_#stream_pid#' => '1', 'copydbs_name#stream_id#_#stream_pid#' => $user_data['name'], 'starttime_#stream_id#_#stream_pid#' => $time);
			$stream[0]['test'] = '';
			$stream[0]['array_success'] = array('copydbs_#stream_id#_#stream_pid#' => '2', 'endtime_#stream_id#_#stream_pid#' => $time);
			$stream[0]['array_unsucces'] = array('copydbs_#stream_id#_#stream_pid#' => '3', 'endtime_#stream_id#_#stream_pid#' => $time);
			$stream_id = $this->create_stream($stream);
			$out1 = $this->read_stream($stream_id, 1);
			$resmass[0]['status'] = 'inprogress';
			$resmass[0]['db'] = $db_all_string;
			file_put_contents($confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS'] . '/' . $user_name . '_' . 'db_' . $stream_id . '_copy.tmp', $stream_id . "\n" . print_r($db_all_string, 1) . "\n", FILE_APPEND);
			$this->ssh('chown -R ' . $user_name . '.' . $user_name . ' ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS'] . '/' . $user_name . '_' . 'db_' . $stream_id . '_copy.tmp');
			return $resmass;
		}

		$path = $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS'];
		$res = scandir($path);

		foreach ($res as $elem) {
			if (is_file($confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS'] . '/' . $elem) && ($elem != '.') && ($elem != '..')) {
				$nameu = explode('_', $elem);
				if (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['root'] == 'y') || ($user_name == $nameu[0])) {
					$data_stream[] = preg_split('/\\r\\n|\\r|\\n|\\t|\\s+/', file_get_contents($confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS'] . '/' . $elem));
				}
			}
		}

		$i = 0;

		foreach ($data_stream as $streamid) {
			$pid = $this->getexistpid($streamid[0]);

			if ($pid == -1) {
				$copydbs = 2;
			}
			else {
				$copydbs = 1;
			}

			switch ($copydbs) {
			case 1:
				$out1 = $this->read_stream($streamid[0], 1);
				$arr_res = preg_split('/\\r\\n|\\r|\\n/', $out1[count($out1) - 1]);
				$arr_progress_cur = preg_split('/\\r\\n|\\r|\\n\\t|\\s+/', $arr_res[count($arr_res) - 1]);
				$arr_progress_cur = array_values(array_filter($arr_progress_cur));
				$resmass[$i]['status'] = 'inprogress';
				$resmass[$i]['db'] = $streamid[1];
				break;

			case 2:
				$out1 = $this->read_stream($streamid[0], 1);
				$resmass[$i]['status'] = 'done';
				$resmass[$i]['db'] = $streamid[1];
				$resmass[$i]['path'] = $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/';
				$resmass[$i]['dbs_arch'] = $user_name . '_dbs.tar';
				$comm = 'rm -rf ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS'] . '/' . $user_name . '_db_' . $streamid[0] . '_copy.tmp';
				$this->ssh($comm);
				break;
			}
		}

		return $resmass;
	}

	public function parse_backups_db_users($user_data, $getlistdb_users_res)
	{
		$getusers = array();

		foreach ($getlistdb_users_res as $curuser) {
			$exp_data = explode('|', $curuser);

			if (!in_array($exp_data[1], $getusers)) {
				$getusers[] = $exp_data[1];
			}
		}

		array_multisort($getusers, SORT_ASC, SORT_STRING);
		return $getusers;
	}

	public function getlist_backups_db($user_data, $serialdata)
	{
		$decode = json_decode($serialdata, true);

		if (!$this->check_value('strdotx2', $decode['file_path'])) {
			return 0;
		}

		if (!$this->check_value('strdotx2', $decode['taskconf'])) {
			return 0;
		}

		if (!$this->check_value('dir', $decode['homedir'])) {
			return 0;
		}

		$task_name = $decode['taskconf'];
		$res_perm = $this->checkperm_path($user_data, $task_name, '_');

		if ($res_perm['res'] != 1) {
			return $res_perm;
		}

		$username = pathinfo($decode['file_path'])['basename'];
		$res_perm = $this->checkperm_path($user_data, $username, '_');

		if ($res_perm['res'] != 1) {
			return $res_perm;
		}

		$arrfi['backup_configfile'] = $task_name;
		$serialdata = json_encode($arrfi);
		$arr_param_backup_conf = $this->getconfig($user_data, $serialdata);
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);

		if ($arr_param_backup_conf['backup_repo'] == 'remote') {
			$port = $this->getPortServFtp($arr_param_backup_conf, 'server');

			if ($arr_param_backup_conf['backup_type_auth'] == 'key') {
				$ip = $arr_param_backup_conf['backup_remoteip'];
				$remote_dir = $arr_param_backup_conf['backup_remote_path'];
				$pass = $this->decryptmainfunc($arr_param_backup_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
				$user = $arr_param_backup_conf['backup_remote_login'];
				$namersakey = explode('.', $task_name)[0];
				$getlistdb = 'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' " ls ' . $remote_dir . '/' . $username . '/' . $this->mysql_dir_backup . '/ --time-style=\'+%Y-%m-%d %H:%M\' -l | grep -v \'^d\' | awk \'{ print \\$5,\\$6,\\$7,\\$8 }\' "';
				$getlistdb_res = $this->ssh($getlistdb);
				$i = 0;

				foreach ($getlistdb_res as $db) {
					$db_info = explode(' ', $db);

					if (($db_info[3] != 'users_dump.info') && (1 < strlen($db))) {
						$db_arr[$i]['size'] = $db_info[0];
						$db_arr[$i]['date'] = $db_info[1];
						$db_arr[$i]['time'] = $db_info[2];
						$db_arr[$i]['name'] = $db_info[3];
						$db_arr[$i]['isload'] = $this->check_db_is_load($user_data, $db_info[3], $username);
						$db_arr[$i]['ispath'] = $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $db_arr[$i]['name'];
						++$i;
					}
				}

				$getlistdb_users = 'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' " cat ' . $remote_dir . '/' . $username . '/' . $this->mysql_dir_backup . '/' . $GLOBALS['BACKUP_FILE_NAME_USERS'] . ' "';
				$getlistdb_users_res = $this->ssh($getlistdb_users);
				$res_out['dbs'] = $db_arr;
				$res_out['db_users'] = $this->parse_backups_db_users($user_data, $getlistdb_users_res);
				$res_out['task_name'] = $task_name;
				$res_out['username'] = $username;
				return $res_out;
			}

			if ($arr_param_backup_conf['backup_type_auth'] == 'pass') {
				$ip = $arr_param_backup_conf['backup_remoteip'];
				$remote_dir = $arr_param_backup_conf['backup_remote_path'];
				$pass = $this->decryptmainfunc($arr_param_backup_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
				$user = $arr_param_backup_conf['backup_remote_login'];
				$getlistdb = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' " ls ' . $remote_dir . '/' . $username . '/' . $this->mysql_dir_backup . '/ --time-style=\'+%Y-%m-%d %H:%M\' -l | grep -v \'^d\' | awk \'{ print \\$5,\\$6,\\$7,\\$8 }\' "';
				$getlistdb_res = $this->ssh($getlistdb);
				$i = 0;

				foreach ($getlistdb_res as $db) {
					$db_info = explode(' ', $db);

					if (($db_info[3] != 'users_dump.info') && (1 < strlen($db))) {
						$db_arr[$i]['size'] = $db_info[0];
						$db_arr[$i]['date'] = $db_info[1];
						$db_arr[$i]['time'] = $db_info[2];
						$db_arr[$i]['name'] = $db_info[3];
						$db_arr[$i]['isload'] = $this->check_db_is_load($user_data, $db_info[3], $username);
						$db_arr[$i]['ispath'] = $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $db_arr[$i]['name'];
						++$i;
					}
				}

				$getlistdb_users = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' " cat ' . $remote_dir . '/' . $username . '/' . $this->mysql_dir_backup . '/' . $GLOBALS['BACKUP_FILE_NAME_USERS'] . ' "';
				$getlistdb_users_res = $this->ssh($getlistdb_users);
				$res_out['dbs'] = $db_arr;
				$res_out['db_users'] = $this->parse_backups_db_users($user_data, $getlistdb_users_res);
				$res_out['task_name'] = $task_name;
				$res_out['username'] = $username;
				return $res_out;
			}
		}

		if ($arr_param_backup_conf['backup_repo'] == 'local') {
			$local_dir = $arr_param_backup_conf['backup_pathlocal'];
			$getlistdb = 'ls ' . $local_dir . '/' . $username . '/' . $this->mysql_dir_backup . '/ --time-style=\'+%Y-%m-%d %H:%M\' -l | grep -v \'^d\' | awk \'{ print $5,$6,$7,$8 }\' ';
			$getlistdb_res = $this->ssh($getlistdb);
			$i = 0;

			foreach ($getlistdb_res as $db) {
				$db_info = explode(' ', $db);

				if (($db_info[3] != 'users_dump.info') && (1 < strlen($db))) {
					$db_arr[$i]['size'] = $db_info[0];
					$db_arr[$i]['date'] = $db_info[1];
					$db_arr[$i]['time'] = $db_info[2];
					$db_arr[$i]['name'] = $db_info[3];
					$db_arr[$i]['isload'] = $this->check_db_is_load($user_data, $db_info[3], $username, $local_dir);
					$db_arr[$i]['ispath'] = $local_dir . '/' . $username . '/' . $this->mysql_dir_backup . '/' . $db_arr[$i]['name'];
					++$i;
				}
			}

			$getlistdb_users = 'cat ' . $local_dir . '/' . $username . '/' . $this->mysql_dir_backup . '/' . $GLOBALS['BACKUP_FILE_NAME_USERS'];
			$getlistdb_users_res = $this->ssh($getlistdb_users);
			$res_out['dbs'] = $db_arr;
			$res_out['db_users'] = $this->parse_backups_db_users($user_data, $getlistdb_users_res);
			$res_out['task_name'] = $task_name;
			$res_out['username'] = $username;
			return $res_out;
		}
	}

	public function checkperm_path($user_data, $fullpath, $delimeter, $action = '')
	{
		$exp_path_to_restore = explode($delimeter, $fullpath);
		$c1 = 0;

		foreach ($exp_path_to_restore as $path) {
			if ($action == 'remove') {
				if (($user_data['group_properties']['root'] != 'y') && ($user_data['group_properties']['root'] != 'y') && ($path == 'config')) {
					$c1 = 0;
					break;
				}
			}

			$c1 = 1;
			break;
		}

		if ($c1 == 0) {
			$resmass['status'] = 'done';
			$resmass['res'] = 'not perm';
			return $resmass;
		}

		$resmass['status'] = 'perm yes';
		$resmass['res'] = 1;
		return $resmass;
	}

	public function restore_proc_tar($rootRights, $path_to_restore, $user_name_on_backup_name, $dbflag_restdb, $dbflag_restdb_end, $dbflag_restuser, $dbflag_restuser_end)
	{
		if (($rootRights == 'y') || ($rootRights == 'y')) {
			$this->ssh('cp -f ' . $path_to_restore . '/' . $GLOBALS['BACKUP_USER_INFO_FILE'] . ' ' . $GLOBALS['USERS_PATH'] . '/' . $user_name_on_backup_name);
			$param = array('usergroup' => $rootRights, 'username' => $user_name_on_backup_name);
			$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restoreuser\' -p=\'' . json_encode($param) . '\'');
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user_name_on_backup_name);
		$path_to_restoreDefault = str_replace('//', '/', $path_to_restore);
		$path_to_restore = $confUser['rootdir'];
		$path_to_restore = str_replace('//', '/', $path_to_restore);

		if ($path_to_restoreDefault != $path_to_restore) {
			$this->ssh('mv ' . $path_to_restoreDefault . '/* ' . $path_to_restore);
			$this->ssh('yes | cp -rvp ' . $path_to_restoreDefault . '/. ' . $path_to_restore . '/');
			$this->ssh('rm -rf ' . $path_to_restoreDefault);
		}

		$db_dbuser_list_str_arr = NULL;
		$this->restore_stream_prepare_run('', $rootRights, $user_name_on_backup_name, $db_dbuser_list_str_arr, $dbflag_restdb, $dbflag_restdb_end, $dbflag_restuser, $dbflag_restuser_end, $path_to_restore, $user_name_on_backup_name);

		if (strlen($path_to_restore) < 5) {
			$path_to_restore = $confUser['rootdir'];
		}

		$this->ssh('chown -R ' . $user_name_on_backup_name . '.' . $user_name_on_backup_name . ' ' . $path_to_restore . '/');
		$this->ssh('rm -rf ' . $path_to_restore . '/' . $this->datarestore_streamtmp);
		$this->ssh('rm -rf ' . $path_to_restore . '/' . $this->databackupinfofile);
		$this->ssh('rm -rf ' . $path_to_restore . '/' . $GLOBALS['BACKUP_USER_INFO_FILE']);
	}

	public function restore_stream_prepare_run($relat_path_to_select_rest, $rootRights, $user_name_on_backup_name, $db_dbuser_list_str_arr, $dbflag_restdb, $dbflag_restdb_end, $dbflag_restuser, $dbflag_restuser_end, $path_to_restore, $dir_name_pid, $decode = NULL)
	{
		if (strlen($relat_path_to_select_rest) < 1) {
			$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user_name_on_backup_name);
			$param = array('usergroup' => $rootRights, 'username' => $user_name_on_backup_name, 'path_to_dump' => $confUser['rootdir'] . '/' . $GLOBALS['TRANSFER_MYSQL_DIR'], 'dbuser_list_rest' => $db_dbuser_list_str_arr);
			$dbtrace = ' ' . $dbflag_restuser;

			if (is_array($db_dbuser_list_str_arr)) {
				foreach ($db_dbuser_list_str_arr as $dbel) {
					$dbtrace .= $dbel . ' ';
				}
			}

			$dbtrace .= $dbflag_restuser_end;
			$this->ssh('echo ' . $dbtrace);
			$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restoredbuser\' -p=\'' . json_encode($param) . '\'');
			$param = array('usergroup' => $rootRights, 'username' => $user_name_on_backup_name, 'path_to_dump' => $confUser['rootdir'] . '/' . $GLOBALS['TRANSFER_MYSQL_DIR'], 'db_list_rest' => $db_dbuser_list_str_arr);
			$dbtrace = ' ' . $dbflag_restdb;

			if (is_array($db_dbuser_list_str_arr)) {
				foreach ($db_dbuser_list_str_arr as $dbel) {
					$dbtrace .= $dbel . ' ';
				}
			}

			$dbtrace .= $dbflag_restdb_end;
			$this->ssh('echo ' . $dbtrace);
			$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restoredb\' -p=\'' . json_encode($param) . '\'');
			if (!isset($decode['dbselrest']) || is_null($decode)) {
				$this->ssh('cp ' . $path_to_restore . '/' . $GLOBALS['BACKUP_DIR_AUTOINS'] . '/' . $dir_name_pid . '.conf ' . $path_to_restore . '/' . $GLOBALS['BACKUP_DIR_AUTOINS'] . '/' . $dir_name_pid . '_appid* ' . $GLOBALS['DATA_PATH_AUTOINS_USERS_APP'] . '/');
				$param = array('username' => $user_name_on_backup_name);
				$this->restore_backups_jobs($user_name_on_backup_name);
				$param = array('usergroup' => $rootRights, 'username' => $user_name_on_backup_name);
				$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restoreftpacc\' -p=\'' . json_encode($param) . '\'');
				$param = array('username' => $user_name_on_backup_name);

				if (isset($decode['ipset']) && (1 < strlen($decode['ipset'])) && ($this->check_params('ip', $decode['ipset']) == true)) {
					$hostacc = new hostacc();
					$hostacc->hostaccChangeIP($user_name_on_backup_name, $decode['ipset']);
					$param['ip'] = $decode['ipset'];
				}

				$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restorevhosts\' -p=\'' . json_encode($param) . '\'');
				$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'vhostsrebuild\' -p=\'' . json_encode($param) . '\'');
				$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'addzones\' -p=\'' . json_encode($param) . '\'');
				$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restore_emails_user\' -p=\'' . json_encode($param) . '\'');
				$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restore_email_forward\' -p=\'' . json_encode($param) . '\'');
				$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restore_dns_user\' -p=\'' . json_encode($param) . '\'');
				$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restore_dkimkeys_user\' -p=\'' . json_encode($param) . '\'');
				$this->ssh('crontab -u ' . $user_name_on_backup_name . ' ' . $path_to_restore . '/crontab');
			}
		}

		$this->ssh('rm -rf ' . $path_to_restore . '/' . $this->dir_backup_configs);
		$this->ssh('rm -rf ' . $path_to_restore . '/' . $this->datarestore_streamtmp);
		$this->ssh('rm -rf ' . $path_to_restore . '/' . $this->databackupinfofile);
	}

	public function sendemailcompleteproc_rest($username, $completebackup_timestart, $completebackup_file_log, $email_list)
	{
		$file_conf = explode('_', $completebackup_file_log);
		$type_backup_or_username = $file_conf[count($file_conf) - 2];
		$file_conf = $file_conf[count($file_conf) - 2] . '_' . $file_conf[count($file_conf) - 1];

		if (stripos($file_conf, 'config_') !== false) {
			$conf = parse_ini_file($GLOBALS['PROPERTIES_CONF']);
			$langload = $conf['language'];
			$this->lan_include($langload);
		}
		else {
			$conf = parse_ini_file($GLOBALS['USERS_PATH'] . $type_backup_or_username);
			$langload = $conf['language'];
			$this->lan_include($langload);
		}

		$arr_conf = $this->config_read($GLOBALS['BACKUP_CONF'] . $file_conf . '.conf');
		global $smarty;
		$smarty->assign('lang', $this->lang);

		if (0 < strlen($email_list)) {
			$email_text = '';
			$email_res = array();
			$ind = 0;
			$email_list = preg_split('/[\\s,;]/', $email_list);
			$smarty->assign('email_res', $email_res);
			$smarty->assign('username', $username);
			$smarty->assign('completebackup_timestart', $completebackup_timestart);
			$duration = gmdate('H:i:s', time() - strtotime($completebackup_timestart));
			$smarty->assign('duration', $duration);
			$conf_template = parse_ini_file($GLOBALS['PROPERTIES_CONF']);
			$template_path = '/tpl/default/';

			if (isset($conf_template['template'])) {
				$template_path = $conf_template['template'];
			}

			$email_tpl = $smarty->fetch('/etc/brainy' . $template_path . 'backup/complete_rest.tpl');
			$mailObj = new mail();

			foreach ($email_list as $curemail) {
				$mailObj->sendmail($curemail, 'You', $this->lang['backup_complete_titleemail_rest'] . $file_conf, $email_tpl);
			}
		}
	}

	public function clearuserdata($username)
	{
		if (file_exists($GLOBALS['MYSQL_CONF_PATH'])) {
			$mysql = new dbusage();
			$users = $mysql->mysql_get_users($username);

			if (is_array($users)) {
				foreach ($users as $user) {
					$this->logAction('DBUSER: ' . $user . '-' . $username);
					$mysql->mysql_drop_user($user, $username);
				}
			}

			$mysql->mysql_drop_user($username, $username);
			$dbs = $mysql->mysql_get_dbs($username);

			if (is_array($dbs)) {
				foreach ($dbs as $db) {
					$this->logAction('DB: ' . $db . '-' . $username);
					$mysql->mysql_drop_db($db, $username);
				}
			}
		}

		$hostacc = new hostacc();
		$hostacc->unmountAllData($username);
		$hostacc->delete_all_userdata($username, 1);
	}

	public function refractor_stream_encodebackup(&$stream)
	{
		$tobuff = '';

		foreach ($stream as $keycomm => $curcomm) {
			$tobuff = $stream[$keycomm]['comm'];
			unset($stream[$keycomm]);
			$stream = array_filter(array_values($stream));
			break;
		}

		$stream[]['comm'] = $tobuff;
	}

	public function restoreMass($arrRest, $ip, $email)
	{
		$time = time();
		$backuprestore = 0;
		$userData['username'] = 'root';
		$userData['name'] = 'root';
		$userData['group_properties'] = array('root' => 'y');
		$serData = array();
		global $lang;

		if (0 < strlen($email)) {
			$listemail = preg_split('/[\\s,;]/', $email);

			foreach ($listemail as $curemail) {
				$resmass['code'] = 1;
				$resmass['message'] = $lang['backup_config_sendemail_aftercomplete_list_fail_rest'];

				return $resmass;
			}
		}

		foreach ($arrRest as $curRest) {
			$user = explode('_', $curRest['file'])[0];
			array_push($serData, array('filenamebackup' => $curRest['file'], 'pathtorestore' => $GLOBALS['HOME_PATH'] . $user, 'taskconf' => $curRest['task'], 'confirm_overwrite' => 1, 'emaillist' => $email, 'ipset' => $ip, 'command' => 'restore', 'action' => 'backup_restore'));
		}

		$res = $this->restore_local_stream($time, $backuprestore, $userData, $serData, 0);
		return $res;
	}

	public function restore_local_stream($time, $backuprestore, $user_data, $serialdata, $streamid)
	{
		$path_to_restoreArr = '';
		global $lang;
		$restArr = array();
		$qRestArr = 0;
		$decode = array();

		if (!is_array($serialdata)) {
			$decode = json_decode($serialdata, true);
			$restArr = $decode;
		}
		else {
			$restArr = $serialdata;
			$qRestArr = 1;
			$decode['emaillist'] = $restArr[0]['emaillist'];
			$decode['ipset'] = $restArr[0]['ipset'];
			$decode['confirm_overwrite'] = $restArr[0]['confirm_overwrite'];
			$decode['filenamebackup'] = $restArr[0]['filenamebackup'];
			$decode['pathtorestore'] = $restArr[0]['pathtorestore'];
			$decode['taskconf'] = $restArr[0]['taskconf'];
		}

		if ($decode['command'] == 'wait') {
			$pid = $this->getexistpid($streamid);

			if ($pid == -1) {
				$backuprestore = 2;
			}
			else {
				$backuprestore = 1;
			}
		}

		if (0 < strlen($decode['emaillist'])) {
			$listemail = preg_split('/[\\s,;]/', $decode['emaillist']);

			foreach ($listemail as $curemail) {
				$resmass['code'] = 112;
				$resmass['raw_info'] = $lang['backup_config_sendemail_aftercomplete_list_fail_rest'];

				return $resmass;
			}
		}

		if ($backuprestore == 0) {
			if (isset($decode['elfind_restore'])) {
				$file = pathinfo($decode['path_backup'])['basename'];
			}
			else {
				$file = pathinfo($decode['filenamebackup'])['basename'];
				$type_rest = 'FULL';
			}

			if (isset($decode['dbselrest']) || isset($decode['dbuserselrest'])) {
				$file = $decode['username'];
				$type_rest = 'DB';
			}

			$user_file = explode('_', $file);
			$user_name_on_backup_name = $user_file[0];

			if (($user_data['group_properties']['root'] != 'y') && ($user_data['group_properties']['root'] != 'y') && ($user_file[0] !== $user_data['name'])) {
				$resmass['status'] = 'done';
				$resmass['raw_info'] = 'not perm t';
				return $resmass;
			}
		}

		$type_rep = 'notset';
		$file_rest_elfind = '';
		$dir_rest_elfind = '';
		$relat_path_to_select_rest = '';
		$completebackup_file_log = $this->dir_complete . 'complete_' . time() . '_' . rand(100, 99999) . '_' . $user_data['name'];
		$completebackup_timestart = date('d.m.Y H:i:s');

		if (isset($decode['elfind_restore'])) {
			$type_rest = 'FILE_DIR';
			$task_name = $decode['taskconf'];
			$res_perm = $this->checkperm_path($user_data, $task_name, '_');

			if ($res_perm['res'] != 1) {
				return $res_perm;
			}

			$ext = 'noarch';
			$arrfi['backup_configfile'] = $task_name;
			$serialdata = json_encode($arrfi);
			$arr_param_backup_conf = $this->getconfig($user_data, $serialdata);

			if ($arr_param_backup_conf['backup_repo'] == 'remote') {
				$type_rep = 'remote';
			}

			if ($arr_param_backup_conf['backup_repo'] == 'local') {
				$type_rep = 'local';
			}

			$file = pathinfo($decode['path_backup'])['basename'];
			$path_to_restore = $decode['pathtorestore'];
			$res_perm = $this->checkperm_path($user_data, $path_to_restore, '/');

			if ($res_perm['res'] != 1) {
				return $res_perm;
			}

			$relat_path_to_select_rest = $decode['pathbackup_relat'];
			$relat_path_to_select_rest = str_replace('../', '', $relat_path_to_select_rest);
			$relat_path_to_select_rest = str_replace('/../', '', $relat_path_to_select_rest);

			if (isset($decode['file_backup'])) {
				$file_rest_elfind = $decode['file_backup'];
				$file_rest_elfind = str_replace('/', '', $file_rest_elfind);
				$file_rest_elfind_exp = explode('|', $file_rest_elfind);
				$list_space_rest_data = '';

				foreach ($file_rest_elfind_exp as $curdata) {
					if (0 < strlen($curdata)) {
						$list_space_rest_data .= $GLOBALS['BACKUP_HOMEDIR'] . '/' . $relat_path_to_select_rest . $curdata . '|';
					}
				}

				$file_rest_elfind = $list_space_rest_data;
			}

			if (isset($decode['dir_backup'])) {
				$dir_rest_elfind = $decode['dir_backup'];
				$dir_rest_elfind = str_replace('/', '', $dir_rest_elfind);
				$dir_rest_elfind = $GLOBALS['BACKUP_HOMEDIR'] . '/' . $relat_path_to_select_rest . $dir_rest_elfind;
			}

			if ((strlen($file_rest_elfind) == 0) && (strlen($dir_rest_elfind) == 0)) {
				$file_rest_elfind = $GLOBALS['BACKUP_HOMEDIR'] . '/' . $relat_path_to_select_rest;
			}
		}
		else {
			$fullpath = $decode['filenamebackup'];
			$file = pathinfo($decode['filenamebackup'])['basename'];
			$ext = pathinfo($decode['filenamebackup'])['extension'];
			$path_to_restore = $decode['pathtorestore'];

			if (isset($decode['taskconf'])) {
				$task_name = $decode['taskconf'];
				$res_perm = $this->checkperm_path($user_data, $task_name, '_');

				if ($res_perm['res'] != 1) {
					return $res_perm;
				}
			}
		}

		$confUser['rootdir'] = $GLOBALS['HOME_PATH'] . $user_name_on_backup_name;

		if (is_file($GLOBALS['USERS_PATH'] . $user_name_on_backup_name)) {
			$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user_name_on_backup_name);

			if (!isset($confUser['rootdir'])) {
				$confUser['rootdir'] = $GLOBALS['HOME_PATH'] . $user_name_on_backup_name;
			}
		}

		$dbflag_rest = '';
		if (isset($decode['dbselrest']) || isset($decode['dbuserselrest'])) {
			if (isset($decode['dbselrest'])) {
				$dbflag_rest = 'db_rest';
				$type_rest = 'DB';
			}
			else {
				$dbflag_rest = 'dbuser_rest';
				$type_rest = 'DBUSER';
			}

			$decode['dbselrest'] = 1;
			$task_name = $decode['taskconf'];
			$res_perm = $this->checkperm_path($user_data, $task_name, '_');

			if ($res_perm['res'] != 1) {
				return $res_perm;
			}

			$username = $decode['username'];
			$file = $username;
			$user_name_on_backup_name = explode('_', $username)[0];
			$res_perm = $this->checkperm_path($user_data, $username, '_');

			if ($res_perm['res'] != 1) {
				return $res_perm;
			}

			$path_to_restore = $confUser['rootdir'];
			$dbsrest = $decode['dbsrest'];
			$db_list_str = '';
			$db_dbuser_list_str_arr = array();

			if (is_array($dbsrest)) {
				foreach ($dbsrest as $db) {
					$db_list_str .= $db . ' ';
					$db_dbuser_list_str_arr[] = $db;
				}
			}
			else {
				$db_list_str = $dbsrest;
				$db_dbuser_list_str_arr[] = $dbsrest;
			}
		}

		$arrfi['backup_configfile'] = $task_name;
		$serialdata = json_encode($arrfi);
		$arr_param_backup_conf = $this->getconfig($user_data, $serialdata);
		$type_rep = $arr_param_backup_conf['backup_repo'];
		$dbflag_restdb = 'dbrest';
		$dbflag_restdb_end = 'dbrestend';
		$dbflag_restuser = 'dbuser_rest';
		$dbflag_restuser_end = 'dbuser_restend';

		if (($user_data['group_properties']['root'] != 'y') && ($user_data['group_properties']['root'] != 'y')) {
			$decode['pathtorestore'] = $confUser['rootdir'];
			$path_to_restore = $confUser['rootdir'];
		}

		if (is_file($GLOBALS['BACKUP_HISTORY_LOG_DIR'] . $user_data['name'] . '.log')) {
			$list_backup_hist = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($GLOBALS['BACKUP_HISTORY_LOG_DIR'] . $user_data['name'] . '.log'));
		}
		else {
			$list_backup_hist = array();
		}

		$resmass['raw_list_backup_hist'] = $list_backup_hist;

		if ($backuprestore != 2) {
			foreach ($list_backup_hist as $currest) {
				$exp_res = explode('|', $currest);

				if (0 < stripos($exp_res[3], '/' . $user_name_on_backup_name . '/')) {
					if (strlen($exp_res[5]) < 2) {
						$backuprestore = 1;
						$resmass['timestartalready'] = $exp_res[1];
					}
				}
			}
		}

		$path_to_restore = $confUser['rootdir'];

		switch ($backuprestore) {
		case 0:
			foreach ($restArr as $curRest) {
				if ($qRestArr == 1) {
					$user_file = explode('_', $curRest['filenamebackup']);
					$user_name_on_backup_name = $user_file[0];
					$arrfi['backup_configfile'] = $curRest['taskconf'];
					$serGetConfBackup = json_encode($arrfi);
					$arr_param_backup_conf = $this->getconfig($user_data, $serGetConfBackup);
					$type_rep = $arr_param_backup_conf['backup_repo'];
					$task_name = $curRest['taskconf'];
					$file = $curRest['filenamebackup'];
					$confUser['rootdir'] = $GLOBALS['HOME_PATH'] . $user_name_on_backup_name;

					if (is_file($GLOBALS['USERS_PATH'] . $user_name_on_backup_name)) {
						$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user_name_on_backup_name);

						if (!isset($confUser['rootdir'])) {
							$confUser['rootdir'] = $GLOBALS['HOME_PATH'] . $user_name_on_backup_name;
						}
					}

					$path_to_restore = $confUser['rootdir'];
					$decode['filenamebackup'] = $curRest['filenamebackup'];
					$decode['pathtorestore'] = $curRest['pathtorestore'];
					$decode['taskconf'] = $curRest['taskconf'];
					$decode['confirm_overwrite'] = $curRest['confirm_overwrite'];
					$decode['emaillist'] = $curRest['emaillist'];
					$decode['ipset'] = $curRest['ipset'];
				}

				if (!$this->check_params('user_string', $user_name_on_backup_name) || (strlen($user_name_on_backup_name) < 2)) {
					print_r('failedparam');
					exit();
				}

				$stream[]['comm'] = 'echo \'restorebackuphint #' . $user_name_on_backup_name . '#\' >>/dev/null';
				$param = array('username' => $user_name_on_backup_name);

				if (!isset($decode['dbselrest']) && !isset($decode['dbuserselrest']) && !isset($decode['elfind_restore'])) {
					$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'clearuserdata\' -p=\'' . json_encode($param) . '\'';
				}

				if (!isset($decode['dbselrest']) && !isset($decode['dbuserselrest']) && !isset($decode['elfind_restore']) && (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['root'] == 'y'))) {
					$comm = 'ls -l ' . $confUser['rootdir'] . '/';
					$exist_homedir_rest_user = $this->ssh($comm)[0];

					if ((0 < strlen($exist_homedir_rest_user)) && (intval($decode['confirm_overwrite']) == 0)) {
						$resmass['code'] = 111;
						$resmass['raw_info'] = $lang['backup_confirm_rest_user_exist'];

						return $resmass;
					}
				}

				$param = array('username' => $user_name_on_backup_name);
				$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'hostaccjailoff\' -p=\'' . json_encode($param) . '\'';
				if (($ext == 'tgz') || ($ext == 'tar') || ($ext == 'encoded')) {
					if (($arr_param_backup_conf['encryptbackup'] == 1) && (strlen($decode['backupenterpass']) < 1) && ($ext == 'encoded')) {
						$resmass['code'] = 501;
						$resmass['raw_info'] = $lang['backup_titleDialogEnterpassRequire'];

						return $resmass;
					}

					$path_to_restore = $confUser['rootdir'];

					if ($type_rep == 'Dropbox') {
						$remote_dir = $arr_param_backup_conf['backup_remote_path'];
						$fullpathtobackup = $remote_dir . '/' . $file;
						$stream[]['comm'] = $this->drop_ssh . ' -f ' . $this->drop_cred . $task_name . ' download ' . $fullpathtobackup . ' ' . $this->tmp_backup . '/' . $file;

						if (strlen($decode['backupenterpass']) < 1) {
							$stream[]['comm'] = 'find ' . $confUser['rootdir'] . ' -type l -or -type f -or -type d \\( -path ' . '/' . ' -o -path ' . $confUser['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
							$stream[]['comm'] = 'mkdir -p ' . $confUser['rootdir'];
							$stream[]['comm'] = 'tar xzf ' . $this->tmp_backup . $file . ' -C ' . $path_to_restore;
							$stream[]['comm'] = 'rm -f ' . $this->tmp_backup . $file;
						}
						else {
							$passback1 = $decode['backupenterpass'];
							$passback1 = $this->strip_quotes_cmd($passback1);
							$stream[]['comm'] = 'rt=$(openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $this->tmp_backup . $file . ' 2>&1 1>/dev/null);echo $rt';
							$this->refractor_stream_encodebackup($stream);
							$stream[]['comm'] = 'find ' . $confUser['rootdir'] . ' -type l -or -type f -or -type d \\( -path ' . '/' . ' -o -path ' . $confUser['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
							$stream[]['comm'] = 'mkdir -p ' . $confUser['rootdir'];
							$stream[]['comm'] = 'openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $this->tmp_backup . $file . '  | tar -xz ' . ' -C ' . $path_to_restore;
							$stream[]['comm'] = 'rm -f ' . $this->tmp_backup . $file;
						}
					}

					if ($type_rep == 'GoogleDrive') {
						$remote_dir = $arr_param_backup_conf['backup_remote_path'];
						$list_file = $this->gdrive_ls($task_name, $remote_dir, $user_data);
						$fullpathtobackup_nosl = str_replace('/', '', $remote_dir) . $file;
						$file_id_down = '';

						foreach ($list_file as $curfile) {
							$fulldata = preg_split('/[\\s,;]/', $curfile);
							$fulldata = array_values(array_filter($fulldata));
							$nosl = str_replace('/', '', $fulldata[1]);

							if ($fullpathtobackup_nosl == $nosl) {
								$file_id_down = $fulldata[0];
							}
						}

						$stream[]['comm'] = $this->gdrive_ssh . ' --config ' . $this->gdrive_cred . $task_name . ' download ' . $file_id_down . ' --path ' . $this->tmp_backup;

						if (strlen($decode['backupenterpass']) < 1) {
							$stream[]['comm'] = 'find ' . $confUser['rootdir'] . ' -type l -or -type f -or -type d \\( -path ' . '/' . ' -o -path ' . $confUser['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
							$stream[]['comm'] = 'mkdir -p ' . $confUser['rootdir'];
							$stream[]['comm'] = 'tar xzf ' . $this->tmp_backup . $file . ' -C ' . $path_to_restore;
							$stream[]['comm'] = 'rm -f ' . $this->tmp_backup . $file;
						}
						else {
							$passback1 = $decode['backupenterpass'];
							$passback1 = $this->strip_quotes_cmd($passback1);
							$stream[]['comm'] = 'rt=$(openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $this->tmp_backup . $file . ' 2>&1 1>/dev/null);echo $rt';
							$this->refractor_stream_encodebackup($stream);
							$stream[]['comm'] = 'find ' . $confUser['rootdir'] . ' -type l -or -type f -or -type d \\( -path ' . '/' . ' -o -path ' . $confUser['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
							$stream[]['comm'] = 'mkdir -p ' . $confUser['rootdir'];
							$stream[]['comm'] = 'openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $this->tmp_backup . $file . '  | tar -xz ' . ' -C ' . $path_to_restore;
							$stream[]['comm'] = 'rm -f ' . $this->tmp_backup . $file;
						}
					}

					if ($type_rep == 'YandexDisk') {
						$remote_dir = $arr_param_backup_conf['backup_remote_path'];
						$pass = $this->decryptmainfunc($arr_param_backup_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
						$user = $arr_param_backup_conf['backup_remote_login'];
						$param = array('backup_fileconf' => $task_name, 'file' => $file);
						$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'yadisk_getfile\' -p=\'' . json_encode($param) . '\'';

						if (strlen($decode['backupenterpass']) < 1) {
							$stream[]['comm'] = 'find ' . $confUser['rootdir'] . ' -type l -or -type f -or -type d \\( -path ' . '/' . ' -o -path ' . $confUser['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
							$stream[]['comm'] = 'mkdir -p ' . $confUser['rootdir'];
							$stream[]['comm'] = 'tar xzf ' . $this->tmp_backup . $file . ' -C ' . $path_to_restore;
							$stream[]['comm'] = 'rm -f ' . $this->tmp_backup . $file;
						}
						else {
							$passback1 = $decode['backupenterpass'];
							$passback1 = $this->strip_quotes_cmd($passback1);
							$param = array('backup_fileconf' => $task_name, 'file' => $file);
							$stream[]['comm'] = 'rt=$(openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $this->tmp_backup . $file . ' 2>&1 1>/dev/null);echo $rt';
							$this->refractor_stream_encodebackup($stream);
							$stream[]['comm'] = 'find ' . $confUser['rootdir'] . ' -type l -or -type f -or -type d \\( -path ' . '/' . ' -o -path ' . $confUser['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
							$stream[]['comm'] = 'mkdir -p ' . $confUser['rootdir'];
							$stream[]['comm'] = 'openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $this->tmp_backup . $file . '  | tar -xz ' . ' -C ' . $path_to_restore;
							$stream[]['comm'] = 'rm -f ' . $this->tmp_backup . $file;
						}
					}

					if ($type_rep == 'ftp') {
						$ip = $arr_param_backup_conf['backup_remoteip'];
						$remote_dir = $arr_param_backup_conf['backup_remote_path'];
						$pass = $this->decryptmainfunc($arr_param_backup_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
						$user = $arr_param_backup_conf['backup_remote_login'];
						$port = $this->getPortServFtp($arr_param_backup_conf, 'ftp');
						$stream[]['comm'] = 'cd ' . $this->tmp_backup . ' && lftp -p ' . $port . ' -u \'' . $user . ',' . $pass . '\' ' . $ip . ' -e \'set net:reconnect-interval-base ' . $this->conn_interval_attempts . '; set net:timeout ' . $this->conn_timeoutUpDown . '; set net:max-retries ' . $this->conn_attempts . '; get  ' . $remote_dir . '/' . $file . ';quit\' ;';

						if (strlen($decode['backupenterpass']) < 1) {
							$stream[]['comm'] = 'find ' . $confUser['rootdir'] . ' -type l -or -type f -or -type d \\( -path ' . '/' . ' -o -path ' . $confUser['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
							$stream[]['comm'] = 'mkdir -p ' . $confUser['rootdir'];
							$stream[]['comm'] = 'tar xzf ' . $this->tmp_backup . $file . ' -C ' . $path_to_restore;
							$stream[]['comm'] = 'rm -f ' . $this->tmp_backup . $file;
						}
						else {
							$passback1 = $decode['backupenterpass'];
							$passback1 = $this->strip_quotes_cmd($passback1);
							$checkpass = 'rt=$(cd ' . $this->tmp_backup . ' && lftp -p ' . $port . ' -u \'' . $user . ',' . $pass . '\' ' . $ip . ' -e \'set net:reconnect-interval-base ' . $this->conn_interval_attempts . '; set net:timeout ' . $this->conn_timeoutUpDown . '; set net:max-retries ' . $this->conn_attempts . '; get  ' . $remote_dir . '/' . $file . ';quit\' ; openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $this->tmp_backup . $file . ' 2>&1 1>/dev/null);echo $rt';
							$rescheck = shell_exec($checkpass);
							$stream[]['comm'] = 'rt=$(openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $this->tmp_backup . $file . ' 2>&1 1>/dev/null);echo $rt';
							$this->refractor_stream_encodebackup($stream);
							$stream[]['comm'] = 'find ' . $confUser['rootdir'] . ' -type l -or -type f -or -type d \\( -path ' . '/' . ' -o -path ' . $confUser['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
							$stream[]['comm'] = 'mkdir -p ' . $confUser['rootdir'];
							$stream[]['comm'] = 'openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $this->tmp_backup . $file . '  | tar -xz ' . ' -C ' . $path_to_restore;
							$stream[]['comm'] = 'rm -f ' . $this->tmp_backup . $file;
						}
					}

					if ($type_rep == 'local') {
						$backups_path = $arr_param_backup_conf['backup_pathlocal'];
						$backups_path = str_replace('//', '/', $backups_path);

						if ($backups_path[strlen($backups_path) - 1] == '/') {
							$backups_path = $this->str_replace_first_end('/', '', $backups_path);
						}

						if ($arr_param_backup_conf['encryptbackup'] != 1) {
							$stream[]['comm'] = 'find ' . $confUser['rootdir'] . ' -type l -or -type f -or -type d \\( -path "' . $backups_path . '" -o -path ' . $confUser['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
							$stream[]['comm'] = 'mkdir -p ' . $confUser['rootdir'];
							$stream[]['comm'] = 'tar xzf ' . $backups_path . '/' . $file . ' -C ' . $path_to_restore;
						}
						else {
							$passback1 = $decode['backupenterpass'];
							$passback1 = $this->strip_quotes_cmd($passback1);
							$checkpass = 'rt=$(openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $backups_path . '/' . $file . ' 2>&1 1>/dev/null);echo $rt';
							$rescheck = shell_exec($checkpass);

							if (stripos($rescheck, 'bad decrypt') !== false) {
								$resmass['code'] = 311;
								$resmass['raw_info'] = $lang['backup_enterpassencback_wrong'];

								return $resmass;
							}

							$stream[]['comm'] = 'find ' . $confUser['rootdir'] . ' -type l -or -type f -or -type d \\( -path "' . $backups_path . '" -o -path ' . $confUser['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
							$stream[]['comm'] = 'mkdir -p ' . $confUser['rootdir'];
							$stream[]['comm'] = 'openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $backups_path . '/' . $file . ' | tar -xz ' . ' -C ' . $path_to_restore;
						}
					}

					if ($type_rep == 'remote') {
						$port = $this->getPortServFtp($arr_param_backup_conf, 'server');

						if ($arr_param_backup_conf['backup_type_auth'] == 'pass') {
							$ip = $arr_param_backup_conf['backup_remoteip'];
							$remote_dir = $arr_param_backup_conf['backup_remote_path'];
							$pass = $this->decryptmainfunc($arr_param_backup_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
							$user = $arr_param_backup_conf['backup_remote_login'];
							$stream[]['comm'] = 'ssh-keygen -R \'' . $this->strip_quotes_cmd($ip) . '\' && ssh-keyscan -H \'' . $this->strip_quotes_cmd($ip) . '\' >>  ~/.ssh/known_hosts';

							if (strlen($decode['backupenterpass']) < 1) {
								$stream[]['comm'] = 'find ' . $confUser['rootdir'] . ' -type l -or -type f -or -type d \\( -path ' . '/' . ' -o -path ' . $confUser['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
								$stream[]['comm'] = 'mkdir -p ' . $confUser['rootdir'];
								$stream[]['comm'] = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \' cat ' . $remote_dir . '/' . $file . '\' | tar xzf - -C ' . $path_to_restore;
							}
							else {
								$passback1 = $decode['backupenterpass'];
								$passback1 = $this->strip_quotes_cmd($passback1);
								$checkpass = 'rt=$(sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $remote_dir . '/' . $file . ' 2>&1 1>/dev/null);echo $rt';
								$rescheck = shell_exec($checkpass);

								if (stripos($rescheck, 'bad decrypt') !== false) {
									$resmass['code'] = 311;
									$resmass['raw_info'] = $lang['backup_enterpassencback_wrong'];

									return $resmass;
								}

								$stream[]['comm'] = 'find ' . $confUser['rootdir'] . ' -type l -or -type f -or -type d \\( -path ' . '/' . ' -o -path ' . $confUser['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
								$stream[]['comm'] = 'mkdir -p ' . $confUser['rootdir'];
								$stream[]['comm'] = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $remote_dir . '/' . $file . ' | tar -xz ' . ' -C ' . $path_to_restore;
							}
						}

						if ($arr_param_backup_conf['backup_type_auth'] == 'key') {
							$ip = $arr_param_backup_conf['backup_remoteip'];
							$remote_dir = $arr_param_backup_conf['backup_remote_path'];
							$pass = $this->decryptmainfunc($arr_param_backup_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
							$user = $arr_param_backup_conf['backup_remote_login'];
							$namersakey = explode('.', $task_name)[0];
							$stream[]['comm'] = 'ssh-keygen -R \'' . $this->strip_quotes_cmd($ip) . '\' && ssh-keyscan -H \'' . $this->strip_quotes_cmd($ip) . '\' >>  ~/.ssh/known_hosts';

							if (strlen($decode['backupenterpass']) < 1) {
								$stream[]['comm'] = 'find ' . $confUser['rootdir'] . ' -type l -or -type f -or -type d \\( -path ' . '/' . ' -o -path ' . $confUser['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
								$stream[]['comm'] = 'mkdir -p ' . $confUser['rootdir'];
								$stream[]['comm'] = 'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \' cat ' . $remote_dir . '/' . $file . '\' | tar xzf - -C ' . $path_to_restore;
							}
							else {
								$passback1 = $decode['backupenterpass'];
								$passback1 = $this->strip_quotes_cmd($passback1);
								$checkpass = 'rt=$(ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $remote_dir . '/' . $file . ' 2>&1 1>/dev/null);echo $rt';
								$rescheck = shell_exec($checkpass);

								if (stripos($rescheck, 'bad decrypt') !== false) {
									$resmass['code'] = 311;
									$resmass['raw_info'] = $lang['backup_enterpassencback_wrong'];

									return $resmass;
								}

								$stream[]['comm'] = 'find ' . $confUser['rootdir'] . ' -type l -or -type f -or -type d \\( -path ' . '/' . ' -o -path ' . $confUser['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
								$stream[]['comm'] = 'mkdir -p ' . $confUser['rootdir'];
								$stream[]['comm'] = 'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $remote_dir . '/' . $file . ' | tar -xz ' . ' -C ' . $path_to_restore;
							}
						}
					}

					$param = array('usergroup' => $user_data['group_properties']['root'], 'rootRights' => $user_data['group_properties']['root'], 'path_to_restore' => $path_to_restore, 'username' => $user_name_on_backup_name, 'dbflag_restdb' => $dbflag_restdb, 'dbflag_restdb_end' => $dbflag_restdb_end, 'dbflag_restuser' => $dbflag_restuser, 'dbflag_restuser_end' => $dbflag_restuser_end);
					$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restoreproctar\' -p=\'' . json_encode($param) . '\'';
					$stream[]['comm'] = 'rm ' . $confUser['rootdir'] . '/' . $this->databackup_streamtmp;
				}

				if (($ext != 'tar') && ($ext != 'tgz') && ($ext != 'encoded')) {
					if ($type_rep == 'notset') {
						$nametask = explode(':/', $fullpath)[0];
						$dir_name_pid = $user_name_on_backup_name;

						foreach ($this->list_backup_conf as $fileback_cur_config) {
							$file_config_backup = array_search($fileback_cur_config, $this->list_backup_conf);
							break;
						}

						$arrfi['backup_configfile'] = $file_config_backup;
						$serialdata = json_encode($arrfi);
						$arr_param_backup_conf = $this->getconfig($user_data, $serialdata);
					}

					if ($type_rep == 'remote') {
						$dir_name_pid = $user_name_on_backup_name;
						$ip = $arr_param_backup_conf['backup_remoteip'];
						$remote_dir = $arr_param_backup_conf['backup_remote_path'];
						$pass = $this->decryptmainfunc($arr_param_backup_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
						$user = $arr_param_backup_conf['backup_remote_login'];
						if (($arr_param_backup_conf['backup_type_arch_array'] == 'incr_noarch') || ($arr_param_backup_conf['backup_type_arch_array'] == 'simple_noarch')) {
							$stream[]['comm'] = 'ssh-keygen -R \'' . $this->strip_quotes_cmd($ip) . '\' && ssh-keyscan -H \'' . $this->strip_quotes_cmd($ip) . '\' >>  ~/.ssh/known_hosts';

							if ($arr_param_backup_conf['backup_type_auth'] == 'pass') {
							}

							if ($arr_param_backup_conf['backup_type_auth'] == 'key') {
							}
						}
					}
					else {
						$dir_name_pid = $user_name_on_backup_name;
					}

					$param = array('usergroup' => $user_data['group_properties']['root'], 'username' => $user_name_on_backup_name, 'fileBackupConfig' => $task_name, 'usernameRestore' => $user_name_on_backup_name, 'rootRights' => $user_data['group_properties']['root'], 'file_rest_elfind' => $file_rest_elfind, 'file' => $file, 'dir_rest_elfind' => $dir_rest_elfind, 'relat_path_to_select_rest' => $relat_path_to_select_rest, 'db_dbuser_list_str_arr' => $db_dbuser_list_str_arr, 'dbflag_restdb' => $dbflag_restdb, 'dbflag_restdb_end' => $dbflag_restdb_end, 'dbflag_restuser' => $dbflag_restuser, 'dbflag_restuser_end' => $dbflag_restuser_end, 'decode' => $decode);
					$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restorebackupFilenoarchbypass\' -p=\'' . json_encode($param) . '\'';
				}

				$param = array('username' => $user_name_on_backup_name);
				$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'hostaccsetjailhost\' -p=\'' . json_encode($param) . '\'';
				$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'hostaccsetjailphp\' -p=\'' . json_encode($param) . '\'';
				$stream[]['comm'] = 'echo \'restorebackuphintend #' . $user_name_on_backup_name . '#\' >>/dev/null';
				$path_to_restoreArr .= $path_to_restore . '/;';

				break;
			}

			$param = array('username' => $user_name_on_backup_name, 'completebackup_timestart' => $completebackup_timestart, 'completebackup_file_log' => $completebackup_file_log, 'emailist' => $decode['emaillist']);
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'emailsendcompleterest\' -p=\'' . json_encode($param) . '\'';
			$stream[0]['array_start'] = array('backuprestore_#stream_id#_#stream_pid#' => '1', 'backuprestore_name_#stream_id#_#stream_pid#' => $user_data['name'], 'starttime_#stream_id#_#stream_pid#' => $time);
			$stream[0]['test'] = '';
			$stream[0]['array_success'] = array('backuprestore_#stream_id#_#stream_pid#' => '2', 'endtime_#stream_id#_#stream_pid#' => $time);
			$stream[0]['array_unsucces'] = array('backuprestore_#stream_id#_#stream_pid#' => '3', 'endtime_#stream_id#_#stream_pid#' => $time);
			$backupParamFile = '/etc/brainy/data/streams/backup_paramrest_' . time() . '_' . rand(100, 99999);
			$stream[]['comm'] = 'rm -f ' . $backupParamFile;
			file_put_contents($backupParamFile, json_encode($stream, 1));
			$stream_id = $this->create_stream($stream, $backupParamFile);
			$out1 = $this->read_stream($stream_id, 1);
			$resmass['status'] = 'inprogress';
			$resmass['stream_id'] = $stream_id;

			if (!is_dir($GLOBALS['BACKUP_CONF_STREAM'])) {
				$comm = 'mkdir -p ' . $GLOBALS['BACKUP_CONF_STREAM'];
				$this->ssh($comm);
			}

			if (($ext == 'tar') || ($ext == 'tgz') || ($ext == 'encoded')) {
				file_put_contents($confUser['rootdir'] . '/' . $this->datarestore_streamtmp, $stream_id . "\n");
				file_put_contents($confUser['rootdir'] . '/' . $this->datarestore_streamtmp, $path_to_restore, FILE_APPEND);
			}
			else if ($type_rep == 'remote') {
				$port = $this->getPortServFtp($arr_param_backup_conf, 'server');

				if ($arr_param_backup_conf['backup_type_auth'] == 'pass') {
					$comm = 'ssh-keygen -R \'' . $this->strip_quotes_cmd($ip) . '\' && ssh-keyscan -H \'' . $this->strip_quotes_cmd($ip) . '\' >>  ~/.ssh/known_hosts && ' . ' sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'echo ' . $stream_id . ' >' . $remote_dir . '/' . $file . '/' . $this->datarestore_streamtmp . '\'';
					$this->ssh($comm);
					$comm = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'echo ' . $path_to_restore . '  >>' . $remote_dir . '/' . $file . '/' . $this->datarestore_streamtmp . '\'';
					$this->ssh($comm);
				}

				if ($arr_param_backup_conf['backup_type_auth'] == 'key') {
					$nameconfig = $decode['taskconf'];
					$namersakey = explode('.', $nameconfig)[0];
					$comm = 'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'echo ' . $stream_id . ' >' . $remote_dir . '/' . $file . '/' . $this->datarestore_streamtmp . '\'';
					$this->ssh($comm);
					$comm = 'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'echo ' . $path_to_restore . '  >>' . $remote_dir . '/' . $file . '/' . $this->datarestore_streamtmp . '\'';
					$this->ssh($comm);
				}
			}
			else {
				file_put_contents($arr_param_backup_conf['backup_pathlocal'] . '/' . $file . '/' . $this->datarestore_streamtmp, $stream_id . "\n");
				file_put_contents($arr_param_backup_conf['backup_pathlocal'] . '/' . $file . '/' . $this->datarestore_streamtmp, $path_to_restore, FILE_APPEND);
			}

			$resmass['raw_info'] = implode("\n", $out1);
			$path_to_restoreArr = preg_replace('/^\\//', '/', $path_to_restoreArr);
			$this->writelog_restore($stream_id, $arr_param_backup_conf['backup_nametask'], $path_to_restoreArr, $user_data, $type_rest, $file);

			if (is_file($GLOBALS['BACKUP_HISTORY_LOG_DIR'] . $user_data['name'] . '.log')) {
				$list_backup_hist = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($GLOBALS['BACKUP_HISTORY_LOG_DIR'] . $user_data['name'] . '.log'));
			}
			else {
				$list_backup_hist = array();
			}

			$resmass['raw_list_backup_hist'] = $list_backup_hist;
			$resmass['raw_process'] = '1%';
			$resmass['code'] = 503;
			$resmass['messageshow'] = $lang['backup_restoring_startModal'];
			if (($ext == 'tgz') || ($ext == 'tar') || ($ext == 'encoded')) {
				if ($arr_param_backup_conf['encryptbackup'] == 1) {
					if (($type_rep == 'Dropbox') || ($type_rep == 'GoogleDrive') || ($type_rep == 'YandexDisk') || ($type_rep == 'ftp')) {
						$resmass['code'] = 502;
						$resmass['messageshow'] = $lang['backup_enterpassencback_okPending'];
					}
					else {
						$resmass['code'] = 502;
						$resmass['messageshow'] = $lang['backup_enterpassencback_ok'];
					}
				}
			}

			return $resmass;
		case 1:
			$out1 = $this->read_stream($streamid, 1);
			$arr_res = preg_split('/\\r\\n|\\r|\\n/', $out1[count($out1) - 1]);
			$arr_progress_cur = preg_split('/\\r\\n|\\r|\\n\\t|\\s+/', $arr_res[count($arr_res) - 1]);
			$arr_progress_cur = array_values(array_filter($arr_progress_cur));
			$resmass['status'] = 'inprogress';
			$resmass['stream_id'] = $streamid;
			$resmass['raw_info'] = implode("\n", $out1);
			$resmass['raw_process'] = $arr_progress_cur;

			if (is_file($GLOBALS['BACKUP_HISTORY_LOG_DIR'] . $user_data['name'] . '.log')) {
				$list_backup_hist = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($GLOBALS['BACKUP_HISTORY_LOG_DIR'] . $user_data['name'] . '.log'));
			}
			else {
				$list_backup_hist = array();
			}

			$resmass['raw_list_backup_hist'] = $list_backup_hist;
			return $resmass;
		case 2:
			$out1 = $this->read_stream($streamid, 1);
			$resmass['status'] = 'done';
			$resmass['stream_id'] = $streamid;
			$resmass['raw_info'] = implode("\n", $out1);
			$resmass['streamfull'] = $streamid;
			$this->checkhistory_restore($user_data);
			$list_backup_hist = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($GLOBALS['BACKUP_HISTORY_LOG_DIR'] . $user_data['name'] . '.log'));
			$resmass['raw_list_backup_hist'] = $list_backup_hist;
			return $resmass;
		case 3:
			$out1 = $this->read_stream($streamid, 1);
			$resmass['status'] = 'failed';
			$resmass['stream_id'] = $streamid;
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}
	}

	public function restoreBackupFileNoArchRsyncPass($fileBackupConfig, $usernameRestore, $rootRights, $file_rest_elfind, $file, $dir_rest_elfind, $relat_path_to_select_rest, $db_dbuser_list_str_arr, $dbflag_restdb, $dbflag_restdb_end, $dbflag_restuser, $dbflag_restuser_end, $decode)
	{
		$arr_param_backup_conf = parse_ini_file($GLOBALS['BACKUP_CONF'] . $fileBackupConfig);
		$ip = $arr_param_backup_conf['backup_remoteip'];
		$remote_dir = $arr_param_backup_conf['backup_remote_path'];
		$pass = $this->decryptmainfunc($arr_param_backup_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
		$user = $arr_param_backup_conf['backup_remote_login'];
		$namersakey = explode('.', $fileBackupConfig)[0];

		if (strlen($relat_path_to_select_rest) < 1) {
			if (!isset($decode['dbselrest'])) {
				if (($rootRights == 'y') || ($rootRights == 'y')) {
					if ($arr_param_backup_conf['backup_repo'] == 'remote') {
						$port = $this->getPortServFtp($arr_param_backup_conf, 'server');

						if ($arr_param_backup_conf['backup_type_auth'] == 'pass') {
							$this->ssh('sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' rsync  -azh --info=progress2 -e \'ssh -p ' . $port . '\' --delete ' . $user . '@' . $ip . ':' . $remote_dir . '/' . $file . '/' . $GLOBALS['BACKUP_USER_INFO_FILE'] . ' ' . $GLOBALS['USERS_PATH'] . '/' . $usernameRestore);
						}

						if ($arr_param_backup_conf['backup_type_auth'] == 'key') {
							$this->ssh('rsync  -azh --info=progress2 -e \'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . '\'' . ' --delete ' . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . ':' . $remote_dir . '/' . $file . '/' . $GLOBALS['BACKUP_USER_INFO_FILE'] . '\' ' . $GLOBALS['USERS_PATH'] . '/' . $usernameRestore);
						}
					}

					if ($arr_param_backup_conf['backup_repo'] == 'local') {
						$this->ssh('rsync  -azh --info=progress2 -e --delete ' . $arr_param_backup_conf['backup_pathlocal'] . '/' . $file . '/' . $GLOBALS['BACKUP_USER_INFO_FILE'] . ' ' . $GLOBALS['USERS_PATH'] . '/' . $usernameRestore);
					}

					$param = array('usergroup' => $rootRights, 'username' => $usernameRestore);
					$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restoreuser\' -p=\'' . json_encode($param) . '\'');
				}
			}
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $usernameRestore);
		$path_to_restore = $confUser['rootdir'];
		$path_to_restore = str_replace('//', '/', $path_to_restore);
		$hostacc = new hostacc();
		$arrJail[0]['hostaccjail'] = $usernameRestore;
		$arrJail[0]['statjail'] = 0;
		$arrJail[0]['statjailphp'] = 0;
		$hostacc->setJailHostStat($arrJail, 'api');
		$hostacc->setJailHostStatPHP($arrJail, 'api');
		$this->config_save($GLOBALS['USERS_PATH'] . $usernameRestore, $confUser, 'add');

		if ($arr_param_backup_conf['backup_repo'] == 'remote') {
			$port = $this->getPortServFtp($arr_param_backup_conf, 'server');

			if ($arr_param_backup_conf['backup_type_auth'] == 'pass') {
				if (!isset($decode['dbselrest'])) {
					if (stripos($file_rest_elfind, '|') === false) {
						$this->ssh('sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' rsync  -azh --info=progress2 -e \'ssh -p ' . $port . '\' --delete ' . $user . '@' . $ip . ':' . $remote_dir . '/' . $file . '/' . $GLOBALS['BACKUP_HOMEDIR'] . '/' . $file_rest_elfind . $dir_rest_elfind . ' ' . $path_to_restore . $relat_path_to_select_rest);
					}
					else {
						$file_rest_elfind_exp = explode('|', $file_rest_elfind);
						$files_list = '';

						foreach ($file_rest_elfind_exp as $curdata) {
							if (1 < strlen($curdata)) {
								$files_list .= $user . '@' . $ip . ':' . $remote_dir . '/' . $file . '/' . $curdata . ' ';
							}
						}

						$this->ssh('sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' rsync  -azh --info=progress2 -e \'ssh -p ' . $port . '\' --delete ' . $files_list . ' ' . $path_to_restore . $relat_path_to_select_rest);
					}
				}

				if (strlen($relat_path_to_select_rest) < 1) {
					$exclJail = $this->createExcludePathJail('rsync');
					$this->ssh('sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' rsync  -azh --exclude ' . $exclJail . ' --info=progress2 -e \'ssh -p ' . $port . '\' --delete ' . $user . '@' . $ip . ':' . $remote_dir . '/' . $file . '/' . $this->dir_backup_configs . ' ' . $path_to_restore . '/' . $this->user_tmp);
				}
			}

			if ($arr_param_backup_conf['backup_type_auth'] == 'key') {
				if (!isset($decode['dbselrest'])) {
					if (stripos($file_rest_elfind, '|') === false) {
						$this->ssh('rsync  -azh --info=progress2 -e \'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . '\'' . ' --delete ' . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . ':' . $remote_dir . '/' . $file . '/' . $GLOBALS['BACKUP_HOMEDIR'] . '/' . $file_rest_elfind . $dir_rest_elfind . '\' ' . $path_to_restore . $relat_path_to_select_rest);
					}
					else {
						$file_rest_elfind_exp = explode('|', $file_rest_elfind);
						$files_list = '';

						foreach ($file_rest_elfind_exp as $curdata) {
							if (1 < strlen($curdata)) {
								$files_list .= ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . ':' . $remote_dir . '/' . $file . '/' . $curdata . '\' ';
							}
						}

						$this->ssh('rsync  -azh --info=progress2 -e \'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . '\' --delete ' . $files_list . $path_to_restore . $relat_path_to_select_rest);
					}
				}

				if (strlen($relat_path_to_select_rest) < 1) {
					$exclJail = $this->createExcludePathJail('rsync');
					$this->ssh('rsync  -azh --info=progress2 -e \'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . '\'' . ' --delete ' . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . ':' . $remote_dir . '/' . $file . '/' . $this->dir_backup_configs . '\' ' . $path_to_restore . '/' . $this->user_tmp);
				}
			}
		}

		if ($arr_param_backup_conf['backup_repo'] == 'local') {
			if (!isset($decode['dbselrest'])) {
				if (stripos($file_rest_elfind, '|') === false) {
					if (stripos($arr_param_backup_conf['backup_pathlocal'] . '/' . $file . '/' . $GLOBALS['BACKUP_USER_INFO_FILE'], $path_to_restore) === false) {
						$this->ssh('rsync -azh --info=progress2 --delete ' . $arr_param_backup_conf['backup_pathlocal'] . '/' . $file . '/' . $GLOBALS['BACKUP_HOMEDIR'] . '/' . $file_rest_elfind . $dir_rest_elfind . ' ' . $path_to_restore . $relat_path_to_select_rest);
					}
					else {
						$this->ssh('find \'' . $path_to_restore . $relat_path_to_select_rest . '\' ! -path \'' . $path_to_restore . $relat_path_to_select_rest . '\' -type \'d\' -or -type \'f\' -or -type \'l\' | grep -v \'' . $arr_param_backup_conf['backup_pathlocal'] . '\' | xargs rm -rf');
						$this->ssh('cp -rf ' . $arr_param_backup_conf['backup_pathlocal'] . '/' . $file . '/' . $GLOBALS['BACKUP_HOMEDIR'] . '/.[^.]* ' . $file_rest_elfind . $dir_rest_elfind . ' ' . $path_to_restore . $relat_path_to_select_rest);
						$this->ssh('cp -rf ' . $arr_param_backup_conf['backup_pathlocal'] . '/' . $file . '/' . $GLOBALS['BACKUP_HOMEDIR'] . '/* ' . $file_rest_elfind . $dir_rest_elfind . ' ' . $path_to_restore . $relat_path_to_select_rest);
					}
				}
				else {
					$file_rest_elfind_exp = explode('|', $file_rest_elfind);
					$files_list = '';

					foreach ($file_rest_elfind_exp as $curdata) {
						if (1 < strlen($curdata)) {
							$files_list .= $arr_param_backup_conf['backup_pathlocal'] . '/' . $file . '/' . $curdata . ' ';
						}
					}

					$this->ssh('rsync -azh --info=progress2 --delete ' . $files_list . ' ' . $path_to_restore . $relat_path_to_select_rest);
				}
			}

			if (strlen($relat_path_to_select_rest) < 1) {
				$exclJail = $this->createExcludePathJail('rsync');
				$this->ssh('rsync -azh --exclude ' . $exclJail . ' --info=progress2 --delete ' . $arr_param_backup_conf['backup_pathlocal'] . '/' . $file . '/' . $this->dir_backup_configs . ' ' . $path_to_restore . '/' . $this->user_tmp);

				if (!isset($decode['dbselrest'])) {
				}
			}
		}

		$this->restore_stream_prepare_run($relat_path_to_select_rest, $rootRights, $usernameRestore, $db_dbuser_list_str_arr, $dbflag_restdb, $dbflag_restdb_end, $dbflag_restuser, $dbflag_restuser_end, $path_to_restore, $usernameRestore, $decode);

		if ($arr_param_backup_conf['backup_repo'] == 'remote') {
			$port = $this->getPortServFtp($arr_param_backup_conf, 'server');

			if ($arr_param_backup_conf['backup_type_auth'] == 'pass') {
				$this->ssh('sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'rm -rf ' . $remote_dir . '/' . $file . '/' . $this->datarestore_streamtmp . '\'');
			}

			if ($arr_param_backup_conf['backup_type_auth'] == 'key') {
				$this->ssh('ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' ' . ' \'rm -rf ' . $remote_dir . '/' . $file . '/' . $this->datarestore_streamtmp . '\'');
			}
		}

		if ($arr_param_backup_conf['backup_repo'] == 'local') {
			$this->ssh('rm -rf ' . $arr_param_backup_conf['backup_pathlocal'] . '/' . $file . '/' . $this->datarestore_streamtmp);
		}

		if (!isset($decode['dbselrest'])) {
			$this->ssh('chown -R ' . $usernameRestore . '.' . $usernameRestore . ' ' . $path_to_restore . '/');
		}
	}

	public function restorebackup($user_data, $serialdata)
	{
		$this->load_vars();
		$decode = json_decode($serialdata, true);

		if ($decode['command']) {
			if (!$this->check_value('string', $decode['command'])) {
				return 0;
			}
		}

		if ($decode['pathtorestore']) {
			if (!$this->check_value('dir', $decode['pathtorestore'])) {
				return 0;
			}
		}

		if ($decode['taskconf']) {
			if (!$this->check_value('strdotx2', $decode['taskconf'])) {
				return 0;
			}
		}

		$command = $decode['command'];
		$time = time();

		if ($command == 'restore') {
			$res[] = $this->restore_local_stream($time, 0, $user_data, $serialdata, 0);
			return $res;
		}

		$res[0]['raw_list_backup_hist'] = '';
		return $res;
	}

	public function backup_delete_config($user_data, $serialdata)
	{
		$decode = json_decode($serialdata, true);

		if (!$this->check_value('user', $user_data['name'])) {
			return 0;
		}

		if (0 < strlen($decode['backup_configfile'])) {
			if (!$this->check_value('dir', $decode['backup_configfile'])) {
				return 0;
			}
		}

		$file_conf = $decode['backup_file_config'];
		$res_perm = $this->checkperm_path($user_data, $file_conf, '_');

		if ($res_perm['res'] != 1) {
			return $res_perm;
		}

		$this->delete_cache_cron_task($file_conf);
		$comm = 'rm -f ' . $GLOBALS['BACKUP_CONF'] . '/listconfcache-' . $user_data['name'];
		$this->ssh($comm);
		$comm = 'rm -f ' . $GLOBALS['BACKUP_CONF'] . $file_conf;
		$this->ssh($comm);
		$comm = 'rm -f ' . $GLOBALS['BACKUP_CONF'] . '/backuplistcache-' . $user_data['name'];
		$this->ssh($comm);
		$arr_data['timecache'] = 1;

		if (intval($decode['deluser']) != 1) {
			$this->getconfig_filelist($user_data, json_encode($arr_data));
		}

		$out['status'] = 'done';
		$out['raw_info'] = '1';
		return $out;
	}

	public function check_connect_dropbox($backupfind, $nameconfig, $vercode)
	{
		global $lang;
		$remote_dir = $backupfind['backup_remote_path'];

		if (5 < strlen($vercode)) {
			$comm = 'echo -e \'' . $vercode . "\n" . 'y\' | ' . $this->drop_ssh . ' -f ' . $this->drop_cred . $nameconfig . ' list';
		}
		else {
			$comm = $this->drop_ssh . ' -f ' . $this->drop_cred . $nameconfig . ' list';
		}

		$res_conn = $this->ssh($comm);
		$res_check['status'] = 0;

		if (5 < strlen($vercode)) {
			$comm = $this->drop_ssh . ' -f ' . $this->drop_cred . $nameconfig . ' list';
			$res_conn = $this->ssh($comm);
		}

		foreach ($res_conn as $rowres) {
			file_put_contents('/etc/brainy/data/backup/bbbbbbb', date('d.M.Y H:i:s') . '---' . $rowres . '---' . $nameconfig . '---' . '---CHECK_CONN_DROP' . "\n", FILE_APPEND);
			$comm = 'rm -rf ' . $this->drop_cred . $nameconfig;
			$this->ssh($comm);
			$comm = $this->drop_ssh . ' -f ' . $this->drop_cred . $nameconfig . ' list';
			$res_conn = $this->ssh($comm);
			break;
		}

		foreach ($res_conn as $rowres) {
			if (stripos($rowres, 'This is the first time you run this script') !== false) {
				$res_check['status'] = -3;
				$res_check['dropmessage'] = str_replace('``', '\\'', $lang['backup_gdrive_label_access_token_instr']);

				return $res_check;
			}

			$res_check['status'] = 1;

			return $res_check;
		}

		if ($res_check['status'] == -3) {
			return $res_check;
		}

		$res_check['status'] = 1;
		return $res_check;
	}

	public function check_connect_gdrive($backupfind, $nameconfig, $gdrive_vercode)
	{
		$remote_dir = $backupfind['backup_remote_path'];

		if (5 < strlen($gdrive_vercode)) {
			$comm = 'echo -e \'' . $gdrive_vercode . '\' | ' . $this->gdrive_ssh . ' --config ' . $this->gdrive_cred . $nameconfig . ' list';
		}
		else {
			$comm = $this->gdrive_ssh . ' --config ' . $this->gdrive_cred . $nameconfig . ' list';
		}

		$res_conn = $this->ssh($comm);
		$res_check['status'] = 0;

		foreach ($res_conn as $rowres) {
			file_put_contents('/etc/brainy/data/backup/aaaaaaaa', date('d.M.Y H:i:s') . '---' . $rowres . '---' . $nameconfig . '---' . '---CHECK_CONN' . "\n", FILE_APPEND);

			if (stripos($rowres, 'Invalid Credentials') !== false) {
				$comm = 'rm -rf ' . $this->gdrive_cred . $nameconfig;
				$this->ssh($comm);
				$comm = $this->gdrive_ssh . ' --config ' . $this->gdrive_cred . $nameconfig . ' list';
				$res_conn = $this->ssh($comm);
			}
			else if ((stripos($rowres, 'Invalid Credentials') === false) && (stripos($rowres, 'https://accounts') === false) && (stripos($rowres, 'Created') !== false) && (stripos($rowres, 'createdTime') !== false)) {
				$res_check['status'] = -303;

				return $res_check;
			}

			break;
		}

		foreach ($res_conn as $rowres) {
			if (stripos($rowres, 'Authentication needed') !== false) {
				$res_check['status'] = -2;
			}

			if (stripos($rowres, 'https://accounts') !== false) {
				$res_check['gdrivelink'] = $rowres;
			}

			$res_check['status'] = 1;

			return $res_check;
		}

		if ($res_check['status'] == -2) {
			return $res_check;
		}

		$res_check['status'] = 1;
		return $res_check;
	}

	public function check_connect_ya($backupfind)
	{
		$pass = $this->decryptmainfunc($backupfind['backup_remote_pass'], $GLOBALS['cryptkeymain']);
		$remote_dir = $backupfind['backup_remote_path'];
		$res = array();

		try {
			$ydBackup = new YDiskBackup($pass, '', '', false, true, false);
			$isConn = $ydBackup->isConn($remote_dir);

			if (0 < $isConn) {
				$res['status'] = 1;
			}
			else {
				$res['status'] = -1;
			}

			return $res;
		}
		catch (Arhitector\Yandex\Client\Exception\UnauthorizedException $exc) {
			$res['code'] = -1;
			$res['status'] = -1;
			return $res;
		}
		catch (Exception $exc) {
			$res['code'] = -1;
			$res['status'] = -1;
			return $res;
		}

		return $res_check;
	}

	public function check_connect_ftp($backupfind, $nameconfig, $gdrive_vercode)
	{
		$pass = $this->decryptmainfunc($backupfind['backup_remote_pass'], $GLOBALS['cryptkeymain']);
		$user_remote = $backupfind['backup_remote_login'];
		$ip = $backupfind['backup_remoteip'];
		$remote_dir = $backupfind['backup_remote_path'];
		$port = $this->getPortServFtp($backupfind, 'ftp');
		$comm = 'lftp -p ' . $port . ' -u \'' . $this->strip_quotes_cmd($user_remote) . ',' . $this->strip_quotes_cmd($pass) . '\' ' . $this->strip_quotes_cmd($ip) . ' -e \'set net:reconnect-interval-base ' . $this->conn_interval_attempts . ';  set net:timeout ' . $this->connTimeoutFastWait . '; set net:max-retries ' . $this->conn_attempts . '; ls -al; exit\'';
		$checkaccess = $this->ssh($comm);

		if (0 < count($checkaccess)) {
			$res_check['status'] = 1;
			return $res_check;
		}

		$res_check['status'] = -1;
		return $res_check;
	}

	public function check_connect_remote($user_data, $file_conf, $nameconfig, $gdrive_vercode = '')
	{
		$list_users = $this->get_users();
		$res = scandir($GLOBALS['BACKUP_CONF']);
		global $lang;

		foreach ($res as $elem) {
			$nameu = explode('_', $elem);
			$res_user = in_array($nameu[0], $list_users, false);
			if (is_file($GLOBALS['BACKUP_CONF'] . $elem) && ($elem != '.') && ($elem != '..')) {
				$nameu = explode('_', $elem);
				if (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['root'] == 'y') || ($user_data['name'] == $nameu[0])) {
					$this->list_backup_conf_all[]['file'] = $elem;
					$last_key = key(array_slice($this->list_backup_conf_all, -1, 1, true));
					$arrfi['backup_configfile'] = $elem;
					$ser = json_encode($arrfi);
					$arrparamconf = $this->getconfig($user_data, $ser);
					$this->list_backup_conf_all[$last_key]['uniq_name'] = $elem . ' - ' . $arrparamconf['backup_nametask'];
					$this->list_backup_conf_all[$last_key]['filename'] = $elem;
					$this->list_backup_conf_all[$last_key]['name'] = $arrparamconf['backup_nametask'];
					$this->list_backup_conf_all[$last_key]['backup_pathlocal'] = $arrparamconf['backup_pathlocal'];
					$this->list_backup_conf_all[$last_key]['backup_remoteip'] = $arrparamconf['backup_remoteip'];
					$this->list_backup_conf_all[$last_key]['backup_remote_path'] = $arrparamconf['backup_remote_path'];
					$this->list_backup_conf_all[$last_key]['backup_type_arch_array'] = $arrparamconf['backup_type_arch_array'];
					$this->list_backup_conf_all[$last_key]['backup_repo'] = $arrparamconf['backup_repo'];
					$this->list_backup_conf_all[$last_key]['backup_remote_login'] = $arrparamconf['backup_remote_login'];
					$this->list_backup_conf_all[$last_key]['backup_remote_pass'] = $arrparamconf['backup_remote_pass'];
					$this->list_backup_conf_all[$last_key]['backup_type_auth'] = $arrparamconf['backup_type_auth'];
					$this->list_backup_conf_all[$last_key]['backup_nametask'] = $arrparamconf['backup_nametask'];
					$this->list_backup_conf_all[$last_key]['backupRemoteServFtpPort'] = $arrparamconf['backupRemoteServFtpPort'];
				}
			}
		}

		$namersakey = explode('.', $nameconfig)[0];

		foreach ($this->list_backup_conf_all as $backupfind) {
			if ($backupfind['backup_repo'] == 'Dropbox') {
				return $this->check_connect_dropbox($backupfind, $nameconfig, $gdrive_vercode);
			}

			if ($backupfind['backup_repo'] == 'GoogleDrive') {
				return $this->check_connect_gdrive($backupfind, $nameconfig, $gdrive_vercode);
			}

			if ($backupfind['backup_repo'] == 'YandexDisk') {
				return $this->check_connect_ya($backupfind);
			}

			if ($backupfind['backup_repo'] == 'ftp') {
				return $this->check_connect_ftp($backupfind, $nameconfig, $gdrive_vercode);
			}

			$port = $this->getPortServFtp($backupfind, 'server');
			$pass = $this->decryptmainfunc($backupfind['backup_remote_pass'], $GLOBALS['cryptkeymain']);
			$user_remote = $backupfind['backup_remote_login'];
			$ip = $backupfind['backup_remoteip'];
			$remote_dir = $backupfind['backup_remote_path'];

			if ($backupfind['backup_type_auth'] == 'pass') {
				$comm = 'ssh-keygen -R \'' . $this->strip_quotes_cmd($ip) . '\' && ssh-keyscan -H \'' . $this->strip_quotes_cmd($ip) . '\' >>  ~/.ssh/known_hosts';
				$this->ssh($comm);
				$checkaccess = ' sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' -o ConnectTimeout=' . $this->connTimeoutFastWait . ' -o StrictHostKeyChecking=no -o ConnectionAttempts=' . $this->conn_attempts . '   \'' . $this->strip_quotes_cmd($user_remote) . '@' . $this->strip_quotes_cmd($ip) . '\' ls';
				$checkaccess = $this->ssh($checkaccess);

				if ((0 < count($checkaccess)) && (stripos($checkaccess[0], 'denied') === false)) {
					$res_check['status'] = 1;

					return $res_check;
				}

				$res_check['status'] = -1;

				return $res_check;
			}

			$comm = 'ssh-keygen -R \'' . $this->strip_quotes_cmd($ip) . '\' && ssh-keyscan -H \'' . $this->strip_quotes_cmd($ip) . '\' >>  ~/.ssh/known_hosts';
			$this->ssh($comm);
			$checkaccess = 'ssh -p ' . $port . ' -o ConnectTimeout=' . $this->connTimeoutFastWait . ' -o StrictHostKeyChecking=no -o ConnectionAttempts=' . $this->conn_attempts . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user_remote) . '@' . $this->strip_quotes_cmd($ip) . '\' ls -al';
			$checkaccess = $this->ssh($checkaccess);

			if (0 < count($checkaccess)) {
				$res_check['status'] = 1;

				return $res_check;
			}

			$res_check['status'] = -1;

			return $res_check;
		}

		$res_check['status'] = -1;
		return $res_check;
	}

	public function array_sort_by_column(&$arr, $col, $dir = SORT_ASC)
	{
		$sort_col = array();

		foreach ($arr as $key => $row) {
			$sort_col[$key] = $row[$col];
		}

		array_multisort($sort_col, $dir, $arr);
	}

	public function calcbackupsfordelete($username, $backup_fileconf, $userdata)
	{
		$conf_user = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$conf_user['name'] = $conf_user['username'];
		$query['getbyconf'] = $backup_fileconf;
		$serdata = json_encode($query, 1);
		$listbackups = $this->getlistbackups_arch_local($userdata, '|', 600, $backup_fileconf);
		$fff = '/etc/brainy/data/backup/qqqqqq';
		$arr_conf = $this->config_read($GLOBALS['BACKUP_CONF'] . $backup_fileconf);
		$backup_maxcountbackups = $arr_conf['backup_maxcountbackups'];

		if ($backup_maxcountbackups <= 0) {
			return 0;
		}

		$array_user_count_backup = array();
		$cc = 0;

		foreach ($listbackups as $curbackuptype) {
			foreach ($curbackuptype as $curuser) {
				foreach ($curuser as $keyuser => $confuser_each) {
					$user = explode('_', $keyuser)[0];

					if (!isset($array_user_count_backup[$user])) {
						$cc = 0;
						$array_user_count_backup[$user] = array();
					}

					$array_user_count_backup[$user][$cc] = array();
					$array_user_count_backup[$user][$cc]['filename_taskconfig'] = $confuser_each['filename_taskconfig'];
					$array_user_count_backup[$user][$cc]['file_path'] = $confuser_each['file_path'];
					$array_user_count_backup[$user][$cc]['datecreate'] = $confuser_each['datecreate'];
					$array_user_count_backup[$user][$cc]['datecreate_linux'] = strtotime($confuser_each['datecreate']);
					++$cc;
				}
			}
		}

		foreach ($array_user_count_backup as $key => $curuser) {
			$this->array_sort_by_column($array_user_count_backup[$key], 'datecreate_linux');
		}

		global $server;

		foreach ($array_user_count_backup as $key => $curuser) {
			$realcount = count($curuser);

			if ($backup_maxcountbackups < $realcount) {
				$countto_del = $realcount - $backup_maxcountbackups;
				$totaldel = 0;

				foreach ($curuser as $curbackupinfo) {
					$serdata_toremove['fileconf'] = $curbackupinfo['filename_taskconfig'];
					$serdata_toremove['filebackup'] = $curbackupinfo['file_path'];
					$out_res = $this->removebackup($userdata, json_encode($serdata_toremove, 1), 0);
					++$totaldel;

					break;
				}
			}
		}
	}

	public function getlistbackups_arch_local($user_data, $search = '|', $timecache = NULL, $getbyconf = NULL, $colorder = 'date', $typeorder = 'desc', $usersel = '')
	{
		global $lang;

		if ($usersel != 'showallusers') {
			if (!$this->check_params('user_string', $usersel)) {
				$usersel = '';
			}
		}
		else {
			$usersel = '';
		}

		$roundsize = 2;
		$search_exp = explode('|', $search);
		$search_data_dif = $search_exp[0];
		$search_bydate = $search_exp[1];
		$file_cache_backup_list = $GLOBALS['BACKUP_CONF'] . '/backuplistcache-' . $user_data['name'];

		if (!isset($timecache)) {
			$timecache = 1400;
		}
		else {
			$timecache = intval($timecache);
		}

		$timefile = filemtime($file_cache_backup_list);
		$flaggetfull = 0;
		$failed_rec_count = 0;

		if (!isset($getbyconf)) {
			if (is_file($file_cache_backup_list)) {
				if ((time() - $timefile) < $timecache) {
					$res = unserialize(file_get_contents($file_cache_backup_list));
					$count_total_backups = $res['countlist_backups'];
					if ((1 < strlen($search)) || (($usersel != 'showallusers') && (0 < strlen($usersel)))) {
						foreach ($res as $key1 => $item) {
							foreach ($item as $key2 => $userconfarr) {
								foreach ($userconfarr as $key3 => $userconf) {
									$unset = 0;

									if (($usersel != 'showallusers') && (0 < strlen($usersel))) {
										$expNameBackItem = explode('/', $userconf['file']);
										$expNameBackItem = $expNameBackItem[count($expNameBackItem) - 1];
										$expNameBackItem = explode('_', $expNameBackItem)[0];

										if ($usersel != $expNameBackItem) {
											unset($res[$key1][$key2][$key3]);
											$unset = 2;
											--$count_total_backups;
										}
									}

									if (0 < strlen($search_data_dif)) {
										if ((stripos($userconf['file'], $search_data_dif) === false) && ($unset == 0)) {
											unset($res[$key1][$key2][$key3]);
											$unset = 1;
											--$count_total_backups;
										}
									}

									if (0 < strlen($search_bydate)) {
										if ((stripos($userconf['datecreate'], $search_bydate) === false) && ($unset == 0)) {
											unset($res[$key1][$key2][$key3]);
											--$count_total_backups;
										}
									}
								}
							}
						}
					}

					$confUser = parse_ini_file($this->dirConfig . $user_data['name']);

					if (isset($confUser['ordercol'])) {
						if ($colorder != 'default') {
							if (($confUser['ordercol'] != $colorder) || ($confUser['orderasc'] != $typeorder) || ($res[0]['ordercol'] != $colorder) || ($res[0]['orderasc'] != $typeorder)) {
								$this->orderlist($res, $colorder, $typeorder);
								$arrConfig = array('ordercol' => $colorder, 'orderasc' => $typeorder);
								$this->config_save($this->dirConfig . $user_data['name'], $arrConfig, 'add');

								if (!isset($getbyconf)) {
									if (((strlen($usersel) == 0) || ($usersel == 'showallusers')) && (strlen($search) == 0)) {
										file_put_contents($file_cache_backup_list, serialize($res));
									}
								}
							}
						}
					}

					array_unshift($res, array('timelist' => date('d.m.Y H:i:s', $timefile), 'countlist_backups' => $count_total_backups));
					return $res;
				}

				$flaggetfull = 1;
			}
			else {
				$flaggetfull = 1;
			}
		}
		else {
			$flaggetfull = 1;
		}

		if ($flaggetfull == 0) {
			return 1;
		}

		$res = scandir($GLOBALS['BACKUP_CONF']);

		foreach ($res as $elem) {
			$nameu = explode('_', $elem);
			if (is_file($GLOBALS['BACKUP_CONF'] . $elem) && ($elem != '.') && ($elem != '..')) {
				$nameu = explode('_', $elem);
				if (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['root'] == 'y') || ('config' == $nameu[0]) || ($user_data['name'] == $nameu[0])) {
					if (isset($getbyconf)) {
						if ($getbyconf != $elem) {
							continue;
						}
					}

					$arrfi['backup_configfile'] = $elem;
					$ser = json_encode($arrfi);
					$arrparamconf = $this->getconfig($user_data, $ser);

					if (intval($arrparamconf['backup_conf_stat']) == 1) {
						$this->list_backup_conf_all[]['file'] = $elem;
						$last_key = key(array_slice($this->list_backup_conf_all, -1, 1, true));
						$this->list_backup_conf_all[$last_key]['filename_taskconfig'] = $elem;
						$this->list_backup_conf_all[$last_key]['uniq_name'] = $elem . '-' . $arrparamconf['backup_nametask'];
						$this->list_backup_conf_all[$last_key]['name'] = $arrparamconf['backup_nametask'];
						$this->list_backup_conf_all[$last_key]['backup_pathlocal'] = preg_replace('/^\\//', '/', $arrparamconf['backup_pathlocal']);
						$this->list_backup_conf_all[$last_key]['backup_remoteip'] = $arrparamconf['backup_remoteip'];
						$this->list_backup_conf_all[$last_key]['backup_remote_path'] = preg_replace('/^\\//', '/', $arrparamconf['backup_remote_path']);
						$this->list_backup_conf_all[$last_key]['backup_type_arch_array'] = $arrparamconf['backup_type_arch_array'];
						$this->list_backup_conf_all[$last_key]['backup_repo'] = $arrparamconf['backup_repo'];
						$this->list_backup_conf_all[$last_key]['backup_remote_login'] = $arrparamconf['backup_remote_login'];
						$this->list_backup_conf_all[$last_key]['backup_remote_pass'] = $arrparamconf['backup_remote_pass'];
						$this->list_backup_conf_all[$last_key]['backup_type_auth'] = $arrparamconf['backup_type_auth'];
						$this->list_backup_conf_all[$last_key]['backup_nametask'] = $arrparamconf['backup_nametask'];
						$this->list_backup_conf_all[$last_key]['taskconf'] = $elem;
						$this->list_backup_conf_all[$last_key]['backupRemoteServFtpPort'] = $arrparamconf['backupRemoteServFtpPort'];
					}
				}
			}
		}

		$ind = 0;
		$check_uniq_backups_local = array();
		$check_uniq_backups_remote = array();

		foreach ($this->list_backup_conf_all as $backupfind) {
			$taskID = explode('.', $backupfind['filename_taskconfig']);
			$taskID = explode('_', $taskID[0])[1];

			if ($backupfind['backup_repo'] == 'YandexDisk') {
				$res_conn_status = $this->getlistbackup_yandex($backupfind, $user_data, $ind, $roundsize);
				if (($res_conn_status['code'] == -1) || ($res_conn_status['code'] == -2)) {
					++$failed_rec_count;
				}
			}

			if ($backupfind['backup_repo'] == 'ftp') {
				$res_conn_status = $this->getlist_backup_fromftp($backupfind, $user_data, $ind, $roundsize);
				if (($res_conn_status['code'] == -1) || ($res_conn_status['code'] == -2)) {
					++$failed_rec_count;
				}
			}

			if ($backupfind['backup_repo'] == 'GoogleDrive') {
				$res_conn_status = $this->getlistbackup_gdrive($backupfind, $user_data, $ind, $roundsize);
				if (($res_conn_status['code'] == -1) || ($res_conn_status['code'] == -2)) {
					++$failed_rec_count;
				}
			}

			if ($backupfind['backup_repo'] == 'Dropbox') {
				$res_conn_status = $this->getlistbackup_dropbox($backupfind, $user_data, $ind, $roundsize);
				if (($res_conn_status['code'] == -1) || ($res_conn_status['code'] == -2)) {
					++$failed_rec_count;
				}
			}

			if ($backupfind['backup_repo'] == 'local') {
				$path_backup = $backupfind['backup_pathlocal'] . '/';

				if (!is_dir($path_backup)) {
					continue;
				}

				$res = scandir($path_backup);

				foreach ($res as $elem) {
					$user_file = explode('_', $elem);
					$user_name_on_backup_name = $user_file[0];
					if (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['root'] == 'y') || ($user_file[0] == $user_data['name'])) {
						$nameu = explode('_', $elem);
						if (is_file($path_backup . $elem) && ($elem != '.') && ($elem != '..')) {
							if (in_array($backupfind['backup_nametask'] . '-' . $path_backup . $elem, $check_uniq_backups_local) == true) {
								continue;
							}

							$check_uniq_backups_local[] = $backupfind['backup_nametask'] . ':/' . $path_backup . $elem;
							$this->listbackup[$ind]['localarch'][$user_name_on_backup_name . '_' . $ind]['file'] = preg_replace('/(\\/+)/', '/', preg_replace('/^\\//', '/', $backupfind['backup_nametask'] . ':/' . $path_backup . $elem));
							$this->listbackup[$ind]['localarch'][$user_name_on_backup_name . '_' . $ind]['datecreate'] = date('d.m.Y H:i:s', filemtime($path_backup . $elem));
							$this->listbackup[$ind]['localarch'][$user_name_on_backup_name . '_' . $ind]['size'] = round(filesize($path_backup . $elem) / 1024 / 1024, $roundsize);

							if ($this->listbackup[$ind]['localarch'][$user_name_on_backup_name . '_' . $ind]['size'] == 0) {
								$this->listbackup[$ind]['localarch'][$user_name_on_backup_name . '_' . $ind]['size'] = round(filesize($path_backup . $elem) / 1024 / 1024, 3);
							}

							$this->listbackup[$ind]['localarch'][$user_file[0] . '_' . $ind]['file'] = preg_replace('/(\\/+)/', '/', $backupfind['backup_nametask'] . ':/' . $path_backup . '/' . $elem);
							$this->listbackup[$ind]['localarch'][$user_file[0] . '_' . $ind]['file_path'] = preg_replace('/^\\//', '/', $path_backup . '/' . $elem);
							$this->listbackup[$ind]['localarch'][$user_file[0] . '_' . $ind]['namefileonly'] = $elem;
							$confUserData = $this->config_read($GLOBALS['USERS_PATH'] . $user_name_on_backup_name);
							$file_backup_stream_tmp = 'cat ' . $confUserData['rootdir'] . '/' . $this->databackup_streamtmp;
							$file_restore_stream_tmp = 'cat ' . $confUserData['rootdir'] . '/' . $this->datarestore_streamtmp;
							$file_backup_stream_tmp = $this->ssh($file_backup_stream_tmp);
							$file_restore_stream_tmp = $this->ssh($file_restore_stream_tmp);

							if (0 < strlen($file_backup_stream_tmp[0])) {
								$this->listbackup[$ind]['localarch'][$user_file[0] . '_' . $ind]['backupinprogress_stream'] = $file_backup_stream_tmp[0];
							}
							else {
								$this->listbackup[$ind]['localarch'][$user_file[0] . '_' . $ind]['backupinprogress_stream'] = '0';
							}

							if (0 < strlen($file_restore_stream_tmp[0])) {
								$this->listbackup[$ind]['localarch'][$user_file[0] . '_' . $ind]['restoreinprogress_stream'] = $file_restore_stream_tmp[0];
								$this->listbackup[$ind]['localarch'][$user_file[0] . '_' . $ind]['path_to_restore'] = $file_restore_stream_tmp[1];
							}
							else {
								$this->listbackup[$ind]['localarch'][$user_file[0] . '_' . $ind]['restoreinprogress_stream'] = '0';
								$this->listbackup[$ind]['localarch'][$user_file[0] . '_' . $ind]['path_to_restore'] = '0';
							}

							$homePath = str_replace($user_name_on_backup_name, '', $confUserData['rootdir']);
							$homePath = str_replace('//', '/', $homePath);
							$this->listbackup[$ind]['localarch'][$user_file[0] . '_' . $ind]['homedir'] = $homePath;
							$this->listbackup[$ind]['localarch'][$user_file[0] . '_' . $ind]['username'] = $user_name_on_backup_name;
							$this->listbackup[$ind]['localarch'][$user_file[0] . '_' . $ind]['filename_taskconfig'] = $backupfind['filename_taskconfig'];
							++$ind;
							continue;
						}

						if (is_dir($path_backup . $elem) && ($elem != '.') && ($elem != '..')) {
							if (in_array($backupfind['backup_nametask'] . '-' . $path_backup . $elem, $check_uniq_backups_local) == true) {
								continue;
							}

							$check_uniq_backups_local[] = $backupfind['backup_nametask'] . '-' . $path_backup . $elem;
							$data_backup = preg_split('/\\r\\n|\\r|\\n|\\t|\\s+/', file_get_contents($path_backup . $elem . '/' . $this->databackupinfofile));

							if ((intval($data_backup[0]) < 5) && !is_file($path_backup . $elem . '/' . $GLOBALS['BACKUP_HOMEDIR'] . '/' . $this->databackup_streamtmp)) {
								continue;
							}

							$this->listbackup[$ind]['localrsync'][$elem . $ind]['file'] = preg_replace('/(\\/+)/', '/', $backupfind['backup_nametask'] . ':/' . $path_backup . $elem);
							$this->listbackup[$ind]['localrsync'][$elem . $ind]['file_path'] = $path_backup . '/' . $elem;
							$this->listbackup[$ind]['localrsync'][$elem . $ind]['datecreate'] = date('d.m.Y H:i:s', intval($data_backup[2]));
							$this->listbackup[$ind]['localrsync'][$elem . $ind]['size'] = round(intval($data_backup[0]) / 1024 / 1024, 2);

							if (is_file($path_backup . $elem . '/' . $GLOBALS['BACKUP_HOMEDIR'] . '/' . $this->databackup_streamtmp)) {
								$this->listbackup[$ind]['localrsync'][$elem . $ind]['backupinprogress_stream'] = file_get_contents($path_backup . $elem . '/' . $GLOBALS['BACKUP_HOMEDIR'] . '/' . $this->databackup_streamtmp);
							}
							else {
								$this->listbackup[$ind]['localrsync'][$elem . $ind]['backupinprogress_stream'] = '0';
							}

							if (is_file($path_backup . $elem . '/' . $this->datarestore_streamtmp)) {
								$data_restore = preg_split('/\\r\\n|\\r|\\n|\\t|\\s+/', file_get_contents($path_backup . $elem . '/' . $this->datarestore_streamtmp));
							}
							else {
								$data_restore = '';
							}

							if (is_file($path_backup . $elem . '/' . $this->datarestore_streamtmp)) {
								$this->listbackup[$ind]['localrsync'][$elem . $ind]['restoreinprogress_stream'] = $data_restore[0];
								$this->listbackup[$ind]['localrsync'][$elem . $ind]['path_to_restore'] = $data_restore[1];
							}
							else {
								$this->listbackup[$ind]['localrsync'][$elem . $ind]['restoreinprogress_stream'] = '0';
								$this->listbackup[$ind]['localrsync'][$elem . $ind]['path_to_restore'] = '0';
							}

							$confUserData = $this->config_read($GLOBALS['USERS_PATH'] . $user_name_on_backup_name);
							$homePath = str_replace($user_name_on_backup_name, '', $confUserData['rootdir']);
							$homePath = str_replace('//', '/', $homePath);
							$this->listbackup[$ind]['localrsync'][$elem . $ind]['homedir'] = $homePath;
							$this->listbackup[$ind]['localrsync'][$elem . $ind]['username'] = $user_name_on_backup_name;
							$this->listbackup[$ind]['localrsync'][$elem . $ind]['filename_taskconfig'] = $backupfind['filename_taskconfig'];
							++$ind;
						}
					}
				}
			}

			if ($backupfind['backup_repo'] == 'remote') {
				$pass = $this->decryptmainfunc($backupfind['backup_remote_pass'], $GLOBALS['cryptkeymain']);
				$user_remote = $backupfind['backup_remote_login'];
				$ip = $backupfind['backup_remoteip'];
				$remote_dir = $backupfind['backup_remote_path'];
				$connection = NULL;
				$qConnRemote = false;

				if ($backupfind['backup_type_auth'] == 'key') {
					$nameconfig = $backupfind['taskconf'];
					$namersakey = explode('.', $nameconfig)[0];
					$pathPrivateKey = $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey;
					$pathPublicKey = $pathPrivateKey . $GLOBALS['BACKUP_KEY_RSA_MASK_PUB'];
					$port = $this->getPortServFtp($backupfind, 'server');
					$connection = ssh2_connect($ip, $port);
					$resConn = ssh2_auth_pubkey_file($connection, $user_remote, $pathPublicKey, $pathPrivateKey);

					if ($resConn !== false) {
						$qConnRemote = true;
					}
					else {
						$this->listbackup[$ind]['failedconn'] = $lang['backup_remoteserv_noconn'] . ' ' . $lang['backup_failedconn_getlist_task'] . $backupfind['backup_nametask'];
						++$ind;
						++$failed_rec_count;
					}
				}

				if ($backupfind['backup_type_auth'] == 'pass') {
					$port = $this->getPortServFtp($backupfind, 'server');
					$connection = ssh2_connect($ip, $port);
					$resConn = ssh2_auth_password($connection, $user_remote, $pass);

					if ($resConn !== false) {
						$qConnRemote = true;
					}
					else {
						$this->listbackup[$ind]['failedconn'] = $lang['backup_remoteserv_noconn'] . ' ' . $lang['backup_failedconn_getlist_task'] . $backupfind['backup_nametask'];
						++$ind;
						++$failed_rec_count;
					}
				}

				if ($qConnRemote == true) {
					$res_user_backup = preg_split('/\\r\\n|\\r|\\n/', $this->sendSshQuery($connection, 'ls ' . $remote_dir . '/'));

					foreach ($res_user_backup as $user_backup) {
						$user_file = explode('_', $user_backup);
						$user_name_on_backup_name = $user_file[0];
						if (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['root'] == 'y') || ($user_file[0] == $user_data['name'])) {
							$nameu = explode('_', $user_backup);
							$fileinfo = $this->sendSshQuery($connection, 'cat ' . $remote_dir . '/' . $user_backup . '/' . $this->databackupinfofile);
							$file_backup_stream_tmp = $this->sendSshQuery($connection, 'cat ' . $remote_dir . '/' . $user_backup . '/' . $GLOBALS['BACKUP_HOMEDIR'] . '/' . $this->databackup_streamtmp);
							$file_restore_stream_tmp = $this->sendSshQuery($connection, 'cat ' . $remote_dir . '/' . $user_backup . '/' . $this->datarestore_streamtmp);
							$data_backup = preg_split('/\\r\\n|\\r|\\n|\\t|\\s+/', $fileinfo);

							if (in_array($backupfind['backup_nametask'] . ':/' . $remote_dir . '/' . $user_backup, $check_uniq_backups_remote) == true) {
								continue;
							}

							if ((intval($data_backup[0]) < 3) && (strlen($file_backup_stream_tmp[0]) < 1)) {
								if (stripos($user_backup, '.md5') !== false) {
									continue;
								}

								if ((strpos($user_backup, '.tar') !== false) || (strpos($user_backup, '.tgz') !== false)) {
									$file_date = trim($this->sendSshQuery($connection, 'date +\'%d.%m.%Y %H:%M:%S\' -r ' . $remote_dir . '/' . $user_backup));
									$file_size = $this->sendSshQuery($connection, 'stat --printf=\'%s\' ' . $remote_dir . '/' . $user_backup);
									$check_uniq_backups_remote[] = $backupfind['backup_nametask'] . ':/' . $remote_dir . '/' . $user_backup;
									$this->listbackup[$ind]['remotearch'][$user_file[0] . '_' . $ind]['file'] = preg_replace('/(\\/+)/', '/', $backupfind['backup_nametask'] . ':/' . $remote_dir . '/' . $user_backup);
									$this->listbackup[$ind]['remotearch'][$user_file[0] . '_' . $ind]['file_path'] = $remote_dir . '/' . $user_backup;
									$this->listbackup[$ind]['remotearch'][$user_file[0] . '_' . $ind]['namefileonly'] = $user_backup;
									$this->listbackup[$ind]['remotearch'][$user_file[0] . '_' . $ind]['datecreate'] = $file_date;
									$this->listbackup[$ind]['remotearch'][$user_file[0] . '_' . $ind]['size'] = round($file_size / 1024 / 1024, $roundsize);

									if ($this->listbackup[$ind]['remotearch'][$user_file[0] . '_' . $ind]['size'] == 0) {
										$this->listbackup[$ind]['remotearch'][$user_file[0] . '_' . $ind]['size'] = round($file_size / 1024 / 1024, 3);
									}

									$confUserData = $this->config_read($GLOBALS['USERS_PATH'] . $user_name_on_backup_name);
									$file_backup_stream_tmp = 'cat ' . $confUserData['rootdir'] . '/' . $this->databackup_streamtmp;
									$file_restore_stream_tmp = 'cat ' . $confUserData['rootdir'] . '/' . $this->datarestore_streamtmp;
									$file_backup_stream_tmp = $this->ssh($file_backup_stream_tmp);
									$file_restore_stream_tmp = $this->ssh($file_restore_stream_tmp);

									if (0 < strlen($file_backup_stream_tmp[0])) {
										$this->listbackup[$ind]['remotearch'][$user_file[0] . '_' . $ind]['backupinprogress_stream'] = $file_backup_stream_tmp[0];
									}
									else {
										$this->listbackup[$ind]['remotearch'][$user_file[0] . '_' . $ind]['backupinprogress_stream'] = '0';
									}

									if (0 < strlen($file_restore_stream_tmp[0])) {
										$this->listbackup[$ind]['remotearch'][$user_file[0] . '_' . $ind]['restoreinprogress_stream'] = $file_restore_stream_tmp[0];
										$this->listbackup[$ind]['remotearch'][$user_file[0] . '_' . $ind]['path_to_restore'] = $file_restore_stream_tmp[1];
									}
									else {
										$this->listbackup[$ind]['remotearch'][$user_file[0] . '_' . $ind]['restoreinprogress_stream'] = '0';
										$this->listbackup[$ind]['remotearch'][$user_file[0] . '_' . $ind]['path_to_restore'] = '0';
									}

									$homePath = str_replace($user_name_on_backup_name, '', $confUserData['rootdir']);
									$homePath = str_replace('//', '/', $homePath);
									$this->listbackup[$ind]['remotearch'][$user_file[0] . '_' . $ind]['homedir'] = $homePath;
									$this->listbackup[$ind]['remotearch'][$user_file[0] . '_' . $ind]['username'] = $user_name_on_backup_name;
									$this->listbackup[$ind]['remotearch'][$user_file[0] . '_' . $ind]['filename_taskconfig'] = $backupfind['filename_taskconfig'];
									++$ind;
									continue;
								}

								continue;
							}

							$check_uniq_backups_remote[] = $backupfind['backup_nametask'] . ':/' . $remote_dir . '/' . $user_backup;
							$this->listbackup[$ind]['remotersync'][$user_backup . $ind]['file'] = preg_replace('/(\\/+)/', '/', $backupfind['backup_nametask'] . ':/' . $remote_dir . '/' . $user_backup);
							$this->listbackup[$ind]['remotersync'][$user_backup . $ind]['file_path'] = $remote_dir . '/' . $user_backup;
							$this->listbackup[$ind]['remotersync'][$user_backup . $ind]['datecreate'] = date('d.m.Y H:i:s', intval($data_backup[2]));
							$this->listbackup[$ind]['remotersync'][$user_backup . $ind]['size'] = round(intval($data_backup[0]) / 1024 / 1024, $roundsize);

							if ($this->listbackup[$ind]['remotersync'][$user_backup . $ind]['size'] == 0) {
								$this->listbackup[$ind]['remotersync'][$user_backup . $ind]['size'] = round(intval($data_backup[0]) / 1024 / 1024, 3);
							}

							if (0 < strlen($file_backup_stream_tmp[0])) {
								$this->listbackup[$ind]['remotersync'][$user_backup . $ind]['backupinprogress_stream'] = $file_backup_stream_tmp[0];
							}
							else {
								$this->listbackup[$ind]['remotersync'][$user_backup . $ind]['backupinprogress_stream'] = '0';
							}

							if (0 < strlen($file_restore_stream_tmp[0])) {
								$this->listbackup[$ind]['remotersync'][$user_backup . $ind]['restoreinprogress_stream'] = $file_restore_stream_tmp[0];
								$this->listbackup[$ind]['remotersync'][$user_backup . $ind]['path_to_restore'] = $file_restore_stream_tmp[1];
							}
							else {
								$this->listbackup[$ind]['remotersync'][$user_backup . $ind]['restoreinprogress_stream'] = '0';
								$this->listbackup[$ind]['remotersync'][$user_backup . $ind]['path_to_restore'] = '0';
							}

							$confUserData = $this->config_read($GLOBALS['USERS_PATH'] . $user_name_on_backup_name);
							$homePath = str_replace($user_name_on_backup_name, '', $confUserData['rootdir']);
							$homePath = str_replace('//', '/', $homePath);
							$this->listbackup[$ind]['remotersync'][$user_backup . $ind]['homedir'] = $homePath;
							$this->listbackup[$ind]['remotersync'][$user_backup . $ind]['username'] = $user_name_on_backup_name;
							$this->listbackup[$ind]['remotersync'][$user_backup . $ind]['filename_taskconfig'] = $backupfind['filename_taskconfig'];
							++$ind;
						}
					}
				}
			}

			$this->listbackup['countlist_backups'] = $ind - $failed_rec_count;
		}

		$res = $this->listbackup;

		if ($colorder == 'default') {
			$confUser = parse_ini_file($this->dirConfig . $user_data['name']);

			if (isset($confUser['ordercol'])) {
				$colorder = $confUser['ordercol'];
				$typeorder = $confUser['orderasc'];
			}
			else {
				$colorder = 'date';
				$typeorder = 'desc';
			}
		}

		$arrConfig = array('ordercol' => $colorder, 'orderasc' => $typeorder);
		$this->config_save($this->dirConfig . $user_data['name'], $arrConfig, 'add');
		$this->orderlist($res, $colorder, $typeorder);

		if (!isset($getbyconf)) {
			file_put_contents($file_cache_backup_list, serialize($res));
		}
		else {
			$search = '';
		}

		$count_total_backups = $this->listbackup['countlist_backups'];

		if (1 < strlen($search)) {
			foreach ($this->listbackup as $key1 => $item) {
				foreach ($item as $key2 => $userconfarr) {
					foreach ($userconfarr as $key3 => $userconf) {
						$unset = 0;

						if (0 < strlen($search_data_dif)) {
							if (stripos($userconf['file'], $search_data_dif) === false) {
								if (isset($res[$key1][$key2][$key3])) {
									unset($res[$key1][$key2][$key3]);
									$unset = 1;
									--$count_total_backups;
								}
							}
						}

						if (0 < strlen($search_bydate)) {
							if ((stripos($userconf['datecreate'], $search_bydate) === false) && ($unset == 0)) {
								if (isset($res[$key1][$key2][$key3])) {
									unset($res[$key1][$key2][$key3]);
									--$count_total_backups;
								}
							}
						}
					}
				}
			}
		}

		array_unshift($res, array('timelist' => date('d.m.Y H:i:s', time()), 'countlist_backups' => $count_total_backups));
		return $res;
	}

	public function orderlist(&$res, $colorder = 'date', $typeorder = 'desc')
	{
		$count_list = count($res);
		$ii1 = 0;

		while ($ii1 < ($count_list - 1)) {
			foreach ($res[$ii1] as $key_type => $item_user_arr) {
				foreach ($item_user_arr as $key_user => $item_user_backup_conf) {
					$ii2 = $ii1 + 1;

					while ($ii2 < $count_list) {
						if (isset($res[$ii2]['failedconn'])) {
							$item_user_backup_conf = $res[$ii2];
							$this->array_swap($res, $ii1, $ii2);
						}

						if (!isset($res[$ii2])) {
							continue;
						}

						foreach ($res[$ii2] as $key_type2 => $item_user_arr2) {
							foreach ($item_user_arr2 as $key_user2 => $item_user_backup_conf2) {
								if ($item_user_backup_conf == $item_user_backup_conf2) {
									continue;
								}

								$date1 = strtotime($item_user_backup_conf['datecreate']);
								$date2 = strtotime($item_user_backup_conf2['datecreate']);

								if ($colorder == 'date') {
									if ($typeorder == 'desc') {
										if ($date1 < $date2) {
											$item_user_backup_conf = $item_user_backup_conf2;
											$this->array_swap($res, $ii1, $ii2);
										}
									}

									if ($typeorder == 'asc') {
										if ($date2 < $date1) {
											$item_user_backup_conf = $item_user_backup_conf2;
											$this->array_swap($res, $ii1, $ii2);
										}
									}
								}

								if ($colorder == 'size') {
									if ($typeorder == 'desc') {
										if ($item_user_backup_conf['size'] < $item_user_backup_conf2['size']) {
											$item_user_backup_conf = $item_user_backup_conf2;
											$this->array_swap($res, $ii1, $ii2);
										}
									}

									if ($typeorder == 'asc') {
										if ($item_user_backup_conf2['size'] < $item_user_backup_conf['size']) {
											$item_user_backup_conf = $item_user_backup_conf2;
											$this->array_swap($res, $ii1, $ii2);
										}
									}
								}

								if ($colorder == 'name') {
									if ($typeorder == 'desc') {
										if (strcmp($item_user_backup_conf['namefileonly'], $item_user_backup_conf2['namefileonly']) < 0) {
											$item_user_backup_conf = $item_user_backup_conf2;
											$this->array_swap($res, $ii1, $ii2);
										}
									}

									if ($typeorder == 'asc') {
										if (0 < strcmp($item_user_backup_conf['namefileonly'], $item_user_backup_conf2['namefileonly'])) {
											$item_user_backup_conf = $item_user_backup_conf2;
											$this->array_swap($res, $ii1, $ii2);
										}
									}
								}
							}
						}

						++$ii2;
					}
				}
			}

			++$ii1;
		}
	}

	public function array_swap(&$array, $swap_a, $swap_b)
	{
		$array[$swap_b] = array($array[$swap_b], $array[$swap_a])[1];
		$array[$swap_a] = array($array[$swap_b], $array[$swap_a])[0];
	}

	public function backup_manager_check_permis($user_data, $serialdata)
	{
		$decode = json_decode($serialdata, true);
		$file_path = $decode['file_path'];
		$taskconf = $decode['taskconf'];
		$homedir = $decode['homedir'];

		if (!$this->check_value('strdotx2', $file_path)) {
			return 0;
		}

		if (!$this->check_value('strdotx2', $taskconf)) {
			return 0;
		}

		if (!$this->check_value('dir', $homedir)) {
			return 0;
		}

		$exp_file_path = explode('/', $file_path);
		$c1 = 0;
		$c2 = 0;
		$c3 = 0;

		foreach ($exp_file_path as $part_path) {
			$part_path = explode('_', $part_path)[0];
			if (($user_data['group_properties']['root'] == 'y') || ($part_path == $user_data['name'])) {
				$c1 = 1;
			}
		}

		$exp_taskconf = explode('_', $taskconf);

		foreach ($exp_taskconf as $part_path) {
			if (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['root'] == 'y') || ($part_path == 'config') || ($part_path == $user_data['name'])) {
				$c2 = 1;
			}
		}

		$exp_homedir = explode('/', $homedir);

		foreach ($exp_homedir as $part_path) {
			if (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['root'] == 'y') || ($part_path == $user_data['name'])) {
				$c3 = 1;
			}
		}

		if (($c1 == 1) && ($c2 == 1) && ($c3 == 1)) {
			$res['status'] = 1;
			$res['file_path'] = $file_path;
			$res['taskconf'] = $taskconf;
			$res['homedir'] = $homedir;
			return $res;
		}

		$res['status'] = -1;
		return $res;
	}

	public function prepare_full_download($user_data, $serialdata)
	{
		$time = time();
		$decode = json_decode($serialdata, true);

		if (!$this->check_value('user', $decode['username'])) {
			return 0;
		}

		if ($decode['taskconf']) {
			if (!$this->check_value('strdotx2', $decode['taskconf'])) {
				return 0;
			}
		}

		if ($decode['reprapare']) {
			if (!$this->check_value('number', $decode['reprapare'])) {
				return 0;
			}
		}

		if ($decode['onlycheck']) {
			if (!$this->check_value('number', $decode['onlycheck'])) {
				return 0;
			}
		}

		$user_name = $decode['username'];
		$task_name = $decode['taskconf'];
		$res_perm = $this->checkperm_path($user_data, $task_name, '_');

		if ($res_perm['res'] != 1) {
			return $res_perm;
		}

		$res_perm = $this->checkperm_path($user_data, $user_name, '_');

		if ($res_perm['res'] != 1) {
			return $res_perm;
		}

		$task_exp_id = explode('.', $task_name)[0];
		$task_exp_id = explode('_', $task_exp_id)[1];
		$task_exp_id = '_' . $task_exp_id . '.tgz';
		$confUserData = $this->config_read($GLOBALS['USERS_PATH'] . $user_name);

		if (intval($decode['reprapare']) != 1) {
			if ($decode['onlycheck'] == 1) {
				$path = $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS_FULL'];

				if (!is_dir($path)) {
					return 0;
				}

				$res = scandir($path);

				if (!is_array($res)) {
					return 0;
				}

				foreach ($res as $elem) {
					if (is_file($confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS_FULL'] . '/' . $elem) && ($elem != '.') && ($elem != '..')) {
						$nameu = explode('_', $elem);
						if (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['root'] == 'y') || ($user_name == $nameu[0])) {
							$data_stream[] = preg_split('/\\r\\n|\\r|\\n|\\t|\\s+/', file_get_contents($confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS_FULL'] . '/' . $elem));
						}
					}
				}

				$i = 0;

				if (0 < count($data_stream)) {
					foreach ($data_stream as $streamid) {
						$pid = $this->getexistpid($streamid[0]);

						if ($pid == -1) {
							$fullprep = 2;
						}
						else {
							$fullprep = 1;
						}

						switch ($fullprep) {
						case 1:
							$out1 = $this->read_stream($streamid[0], 1);
							$arr_res = preg_split('/\\r\\n|\\r|\\n/', $out1[count($out1) - 1]);
							$arr_progress_cur = preg_split('/\\r\\n|\\r|\\n\\t|\\s+/', $arr_res[count($arr_res) - 1]);
							$arr_progress_cur = array_values(array_filter($arr_progress_cur));
							$resmass2[$i]['status'] = 'inprogress';
							$resmass2[$i]['username'] = $streamid[1];
							$resmass2[$i]['taskid'] = $streamid[2];
							$resmass2[$i]['raw_info'] = $out1;
							$resmass2[$i]['kkkkkk'] = 'cccccccc';
							$task_cur = $streamid[2];
							$task_exp_id = explode('.', $task_cur)[0];
							$task_exp_id = explode('_', $task_exp_id)[1];
							$folder_backup_exp = explode('/', $decode['file']);
							$folder_backup_exp_partname = $folder_backup_exp[count($folder_backup_exp) - 1];
							$task_exp_id = '_' . $task_exp_id . '.tgz';
							$resmass2[$i]['path'] = 'no';
							$resmass2[$i]['path_check'] = '/' . $folder_backup_exp_partname . $task_exp_id;
							$confUserData = $this->config_read($GLOBALS['USERS_PATH'] . $streamid[1]);
							$resmass2[$i]['datecreate'] = date('d.m.Y H:i:s', filemtime($confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $task_exp_id));
							break;

						case 2:
							$out1 = $this->read_stream($streamid[0], 1);
							$resmass2[$i]['username'] = $streamid[1];
							$resmass2[$i]['taskid'] = $task_name;
							$resmass2[$i]['onlycheck'] = 1;
							$resmass2[$i]['status'] = 'checkdone';
							$resmass2[$i]['username'] = $streamid[1];
							$user_cur = $streamid[1];
							$resmass[$i]['taskid'] = $streamid[2];
							$task_cur = $streamid[2];
							$task_exp_id = explode('.', $task_cur)[0];
							$task_exp_id = explode('_', $task_exp_id)[1];
							$task_exp_id = '_' . $task_exp_id . '.tgz';
							$folder_backup_exp = explode('/', $decode['file']);
							$folder_backup_exp_partname = $folder_backup_exp[count($folder_backup_exp) - 1];

							if (strlen($user_cur) < 1) {
								$user_cur = '111';
							}

							$confUserData = $this->config_read($GLOBALS['USERS_PATH'] . $user_cur);

							if (is_file($confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $task_exp_id)) {
								$resmass2[$i]['path'] = $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $task_exp_id;
								$resmass2[$i]['path_check'] = '/' . $folder_backup_exp_partname . $task_exp_id;
								$resmass2[$i]['datecreate'] = date('d.m.Y H:i:s', filemtime($confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $task_exp_id));
							}
							else {
								$resmass2[$i]['path'] = 'no';
								$resmass2[$i]['path_check'] = '/' . $folder_backup_exp_partname . $task_exp_id;
								$resmass2[$i]['datecreate'] = date('d.m.Y H:i:s', filemtime($confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $task_exp_id));
							}

							$comm = 'rm -rf ' . $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS_FULL'] . '/' . $user_cur . '_full_' . $streamid[0] . '_full.tmp';
							$this->ssh($comm);
							break;
						}
					}
				}

				$q = 0;

				if (0 < count($resmass2)) {
					foreach ($resmass2 as $item) {
						if ($item['taskid'] == $task_name) {
							$q = 1;
						}
					}
				}

				$folder_backup_exp = explode('/', $decode['file']);
				$folder_backup_exp_partname = $folder_backup_exp[count($folder_backup_exp) - 1];

				if ($q == 0) {
					$comm = 'du ' . $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $task_exp_id . ' -sh | awk \'{print $1}\'';
					$res = $this->ssh($comm);

					if (count($res) < 1) {
						$task_exp_id = '';
						$comm = 'du ' . $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $task_exp_id . ' -sh | awk \'{print $1}\'';
						$res = $this->ssh($comm);
					}

					if (0 < count($res)) {
						$folderUnpack = str_replace('.tgz', '.log', $task_exp_id);
						$getLogInfo = file_get_contents($confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $folderUnpack);

						if (stripos($getLogInfo, 'not in gzip format') !== false) {
							global $lang;
							$resmass2[$i]['unpackLog'] = $lang['backup_btnUnpackFailedLog'];
						}
						else {
							$resmass2[$i]['unpackLog'] = '';
						}

						$resmass2[$i]['status'] = 'checkdone';
						$resmass2[$i]['onlycheck'] = 1;
						$resmass2[$i]['raw_info'] = 'done';
						$resmass2[$i]['username'] = $user_name;
						$resmass2[$i]['path'] = $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $task_exp_id;
						$resmass2[$i]['path_check'] = '/' . $folder_backup_exp_partname . $task_exp_id;
						$resmass2[$i]['datecreate'] = date('d.m.Y H:i:s', filemtime($confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $task_exp_id));
						$resmass2[$i]['taskid'] = $task_name;
					}
				}

				return $resmass2;
			}
		}

		$folder_backup_exp = explode('/', $decode['file']);
		$folder_backup_exp_partname = $folder_backup_exp[count($folder_backup_exp) - 1];

		if (($decode['command'] != 'wait_makearch_full') && ($decode['command'] != 'wait_copy_arch')) {
			$task_name = $decode['taskconf'];
			$res_perm = $this->checkperm_path($user_data, $task_name, '_');

			if ($res_perm['res'] != 1) {
				return $res_perm;
			}

			$arrfi['backup_configfile'] = $task_name;
			$serialdata = json_encode($arrfi);
			$arr_param_backup_conf = $this->getconfig($user_data, $serialdata);
			$user_name = $decode['username'];
			$folder_backup_exp = explode('/', $decode['file']);
			$folder_backup_exp = $folder_backup_exp[count($folder_backup_exp) - 1];
			$res_perm = $this->checkperm_path($user_data, $user_name, '_');

			if ($res_perm['res'] != 1) {
				return $res_perm;
			}

			if (isset($decode['namefileonly'])) {
				$namefileonly = $decode['namefileonly'];

				if (0 < strlen($namefileonly)) {
					$checkname_file = explode('_', $namefileonly)[0];
					$res_perm = $this->checkperm_path($user_data, $checkname_file, '_');

					if ($res_perm['res'] != 1) {
						return $res_perm;
					}
				}
			}

			$filePathPrepare = $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $task_exp_id;
			$stream[0]['comm'] = 'echo \'preparedownloadbackup #' . $user_name . '#\' >>/dev/null';

			if (!is_dir($confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS_FULL'])) {
				$comm = 'mkdir -p ' . $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS_FULL'];
				$this->ssh($comm);
				$this->ssh('chown -R ' . $user_name . '.' . $user_name . ' ' . $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/*');
				$this->ssh('chown -R ' . $user_name . '.' . $user_name . ' ' . $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR']);
			}

			if ($arr_param_backup_conf['backup_repo'] == 'remote') {
				$port = $this->getPortServFtp($arr_param_backup_conf, 'server');

				if ($arr_param_backup_conf['backup_type_auth'] == 'key') {
					$ip = $arr_param_backup_conf['backup_remoteip'];
					$remote_dir = $arr_param_backup_conf['backup_remote_path'];
					$pass = $this->decryptmainfunc($arr_param_backup_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
					$user = $arr_param_backup_conf['backup_remote_login'];
					$stream[]['comm'] = 'ssh-keygen -R \'' . $this->strip_quotes_cmd($ip) . '\' && ssh-keyscan -H \'' . $this->strip_quotes_cmd($ip) . '\' >>  ~/.ssh/known_hosts';
					$nameconfig = $task_name;
					$namersakey = explode('.', $nameconfig)[0];
					if (($arr_param_backup_conf['backup_type_arch_array'] == 'incr_noarch') || ($arr_param_backup_conf['backup_type_arch_array'] == 'simple_noarch')) {
						$stream[]['comm'] = 'ssh -p ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' tar -cf - ' . $remote_dir . '/' . $folder_backup_exp . ' > ' . $filePathPrepare;
					}

					if ($arr_param_backup_conf['backup_type_arch_array'] == 'tar') {
						$stream[]['comm'] = 'scp -P ' . $port . ' -i ' . $GLOBALS['BACKUP_KEY_RSA_PATH'] . $GLOBALS['BACKUP_KEY_RSA_MASK'] . $namersakey . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . ':/' . $remote_dir . '/' . $namefileonly . '\' ' . $filePathPrepare;
					}
				}

				if ($arr_param_backup_conf['backup_type_auth'] == 'pass') {
					$ip = $arr_param_backup_conf['backup_remoteip'];
					$remote_dir = $arr_param_backup_conf['backup_remote_path'];
					$pass = $this->decryptmainfunc($arr_param_backup_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
					$user = $arr_param_backup_conf['backup_remote_login'];
					$stream[]['comm'] = 'ssh-keygen -R \'' . $this->strip_quotes_cmd($ip) . '\' && ssh-keyscan -H \'' . $this->strip_quotes_cmd($ip) . '\' >>  ~/.ssh/known_hosts';
					if (($arr_param_backup_conf['backup_type_arch_array'] == 'incr_noarch') || ($arr_param_backup_conf['backup_type_arch_array'] == 'simple_noarch')) {
						$stream[]['comm'] = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh -p ' . $port . ' -o ConnectTimeout=' . $this->conn_timeout . ' -o ConnectionAttempts=' . $this->conn_attempts . ' \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' tar -cf - ' . $remote_dir . '/' . $folder_backup_exp . ' > ' . $filePathPrepare;
					}

					if ($arr_param_backup_conf['backup_type_arch_array'] == 'tar') {
						$stream[]['comm'] = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' scp -P ' . $port . ' -o ConnectTimeout=' . $this->conn_timeout . ' -o ConnectionAttempts=' . $this->conn_attempts . ' ' . $user . '@' . $ip . ':/' . $remote_dir . '/' . $namefileonly . ' ' . $filePathPrepare;
					}
				}
			}

			if ($arr_param_backup_conf['backup_repo'] == 'local') {
				$remote_dir = $arr_param_backup_conf['backup_pathlocal'];
				if (($arr_param_backup_conf['backup_type_arch_array'] == 'incr_noarch') || ($arr_param_backup_conf['backup_type_arch_array'] == 'simple_noarch')) {
					$stream[]['comm'] = 'tar -cf - ' . $remote_dir . '/' . $folder_backup_exp . ' > ' . $filePathPrepare;
				}
			}

			if ($arr_param_backup_conf['backup_repo'] == 'ftp') {
				$ip = $arr_param_backup_conf['backup_remoteip'];
				$remote_dir = $arr_param_backup_conf['backup_remote_path'];
				$pass = $this->decryptmainfunc($arr_param_backup_conf['backup_remote_pass'], $GLOBALS['cryptkeymain']);
				$user = $arr_param_backup_conf['backup_remote_login'];
				$port = $this->getPortServFtp($arr_param_backup_conf, 'ftp');
				$stream[]['comm'] = 'cd ' . $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . ' && lftp -p ' . $port . ' -u \'' . $user . ',' . $pass . '\' ' . $ip . ' -e \'set net:reconnect-interval-base ' . $this->conn_interval_attempts . ';  set net:timeout ' . $this->conn_timeoutUpDown . '; set net:max-retries ' . $this->conn_attempts . '; get  ' . $remote_dir . '/' . $namefileonly . ';quit\'';
				$stream[]['comm'] = 'mv ' . $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $namefileonly . ' ' . $filePathPrepare;
			}

			if ($arr_param_backup_conf['backup_repo'] == 'YandexDisk') {
				$remote_dir = $arr_param_backup_conf['backup_remote_path'];
				$param = array('backup_fileconf' => $task_name, 'file' => $namefileonly);
				$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'yadisk_getfile\' -p=\'' . json_encode($param) . '\'';
				$stream[]['comm'] = 'mv ' . $this->tmp_backup . $namefileonly . ' ' . $filePathPrepare;
			}

			if ($arr_param_backup_conf['backup_repo'] == 'GoogleDrive') {
				$remote_dir = $arr_param_backup_conf['backup_remote_path'];
				$list_file = $this->gdrive_ls($task_name, $remote_dir, $user_data);
				$fullpathtobackup_nosl = str_replace('/', '', $remote_dir) . $namefileonly;
				$file_id_down = '';

				foreach ($list_file as $curfile) {
					$fulldata = preg_split('/[\\s,;]/', $curfile);
					$fulldata = array_values(array_filter($fulldata));
					$nosl = str_replace('/', '', $fulldata[1]);

					if ($fullpathtobackup_nosl == $nosl) {
						$file_id_down = $fulldata[0];
					}
				}

				$stream[]['comm'] = $this->gdrive_ssh . ' --config ' . $this->gdrive_cred . $task_name . ' download ' . $file_id_down . ' --path ' . $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'];
				$stream[]['comm'] = 'mv ' . $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $namefileonly . ' ' . $filePathPrepare;
			}

			if ($arr_param_backup_conf['backup_repo'] == 'Dropbox') {
				$remote_dir = $arr_param_backup_conf['backup_remote_path'];
				$fullpathtobackup = $remote_dir . '/' . $namefileonly;
				$stream[]['comm'] = $this->drop_ssh . ' -f ' . $this->drop_cred . $task_name . ' download ' . $fullpathtobackup . ' ' . $filePathPrepare;
			}

			if (intval($decode['unpack']) == 1) {
				$folderUnpack = str_replace('.tgz', '', $task_exp_id);
				$stream[]['comm'] = 'mkdir  ' . $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $folderUnpack;
				$stream[]['comm'] = 'openssl enc -k \'' . escapeshellcmd($decode['unpackPass']) . '\' -d -aes-256-cbc -in ' . $filePathPrepare . ' | tar -xz ' . ' -C ' . $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $folderUnpack . ' 2>' . $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $folderUnpack . '.log';
			}

			$stream[]['comm'] = 'chown -R ' . $user_name . '.' . $user_name . ' ' . $filePathPrepare;
			$stream[]['comm'] = 'chown -R ' . $user_name . '.' . $user_name . ' ' . $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/*';
			$stream[0]['array_start'] = array('copydbs_#stream_id#_#stream_pid#' => '1', 'copydbs_name#stream_id#_#stream_pid#' => $user_data['name'], 'starttime_#stream_id#_#stream_pid#' => $time);
			$stream[0]['test'] = '';
			$stream[0]['array_success'] = array('copydbs_#stream_id#_#stream_pid#' => '2', 'endtime_#stream_id#_#stream_pid#' => $time);
			$stream[0]['array_unsucces'] = array('copydbs_#stream_id#_#stream_pid#' => '3', 'endtime_#stream_id#_#stream_pid#' => $time);
			$stream_id = $this->create_stream($stream);
			$out1 = $this->read_stream($stream_id, 1);
			$resmass[0]['status'] = 'inprogress';
			$resmass[0]['preparefullbackup'] = '1';
			$resmass[0]['username'] = $user_name;
			$resmass[0]['taskid'] = $task_name;
			$resmass[0]['path_check'] = '/' . $folder_backup_exp_partname . $task_exp_id;
			file_put_contents($confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS_FULL'] . '/' . $user_name . '_' . 'full_' . $stream_id . '_full.tmp', $stream_id . "\n" . $user_name . "\n" . $task_name . "\n", FILE_APPEND);
			return $resmass;
		}

		$path = $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS_FULL'];
		$res = scandir($path);

		foreach ($res as $elem) {
			if (is_file($confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS_FULL'] . '/' . $elem) && ($elem != '.') && ($elem != '..')) {
				$nameu = explode('_', $elem);
				if (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['root'] == 'y') || ($user_name == $nameu[0])) {
					$data_stream[] = preg_split('/\\r\\n|\\r|\\n|\\t|\\s+/', file_get_contents($confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS_FULL'] . '/' . $elem));
				}
			}
		}

		$i = 0;

		foreach ($data_stream as $streamid) {
			$pid = $this->getexistpid($streamid[0]);

			if ($pid == -1) {
				$fullprep = 2;
			}
			else {
				$fullprep = 1;
			}

			switch ($fullprep) {
			case 1:
				$out1 = $this->read_stream($streamid[0], 1);
				$arr_res = preg_split('/\\r\\n|\\r|\\n/', $out1[count($out1) - 1]);
				$arr_progress_cur = preg_split('/\\r\\n|\\r|\\n\\t|\\s+/', $arr_res[count($arr_res) - 1]);
				$arr_progress_cur = array_values(array_filter($arr_progress_cur));
				$resmass[$i]['status'] = 'inprogress';
				$resmass[$i]['username'] = $streamid[1];
				$resmass[$i]['taskid'] = $streamid[2];
				$task_cur = $streamid[2];
				$resmass[$i]['raw_info'] = $out1;
				$user_cur = $streamid[1];
				$task_cur = $streamid[2];
				$task_exp_id = explode('.', $task_cur)[0];
				$task_exp_id = explode('_', $task_exp_id)[1];
				$task_exp_id = '_' . $task_exp_id . '.tgz';
				$folder_backup_exp = explode('/', $decode['file']);
				$folder_backup_exp_partname = $folder_backup_exp[count($folder_backup_exp) - 1];
				$resmass[$i]['path'] = 'no';
				$resmass[$i]['path_check'] = '/' . $folder_backup_exp_partname . $task_exp_id;
				$resmass[$i]['datecreate'] = date('d.m.Y H:i:s', filemtime($confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $task_exp_id));
				break;

			case 2:
				$out1 = $this->read_stream($streamid[0], 1);
				$resmass[$i]['status'] = 'done';
				$resmass[$i]['username'] = $streamid[1];
				$user_cur = $streamid[1];
				$resmass[$i]['taskid'] = $streamid[2];
				$task_cur = $streamid[2];
				$task_exp_id = explode('.', $task_cur)[0];
				$task_exp_id = explode('_', $task_exp_id)[1];
				$task_exp_id = '_' . $task_exp_id . '.tgz';
				$folderUnpack = str_replace('.tgz', '.log', $task_exp_id);
				$getLogInfo = file_get_contents($confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $folderUnpack);

				if (stripos($getLogInfo, 'not in gzip format') !== false) {
					global $lang;
					$resmass[$i]['unpackLog'] = $lang['backup_btnUnpackFailedLog'];
				}
				else {
					$resmass[$i]['unpackLog'] = '';
				}

				$folder_backup_exp = explode('/', $decode['file']);
				$folder_backup_exp_partname = $folder_backup_exp[count($folder_backup_exp) - 1];
				$resmass[$i]['path_check'] = '/' . $folder_backup_exp_partname . $task_exp_id;
				$resmass[$i]['path'] = $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $task_exp_id;
				$resmass[$i]['datecreate'] = date('d.m.Y H:i:s', filemtime($confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $folder_backup_exp_partname . $task_exp_id));
				$comm = 'rm -rf ' . $confUserData['rootdir'] . '/' . $GLOBALS['BACKUP_TMP_DIR'] . '/' . $GLOBALS['BACKUP_TMP_DIR_STREAMS_FULL'] . '/' . $user_cur . '_full_' . $streamid[0] . '_full.tmp';
				$this->ssh($comm);
				break;
			}
		}

		return $resmass;
	}

	public function restoreuserinfo($user_group, $user_name)
	{
		require_once $GLOBALS['CLASSES_PATH'] . '/hostacc.php';
		$hostacc = new hostacc();
		$confUserData = $this->config_read($GLOBALS['USERS_PATH'] . $user_name);

		if (stripos($confUserData['rootdir'], $this->mask_homedir_replace) !== false) {
			$confUserData['rootdir'] = $GLOBALS['HOME_PATH'] . $user_name;
		}

		$this->ssh('replace \'' . $this->mask_homedir_replace . $this->mask_username_replace . '\' \'' . $confUserData['rootdir'] . '\' -- ' . $GLOBALS['USERS_PATH'] . '/' . $user_name);
		$this->ssh('replace \'' . $this->mask_username_replace . '\' \'' . $user_name . '\' -- ' . $GLOBALS['USERS_PATH'] . '/' . $user_name);
		$out = $hostacc->config_read($GLOBALS['USERS_PATH'] . '/' . $user_name);

		if ($user_group == 'y') {
			$hostacc->hostacc_username = htmlspecialchars($out['username']);
			$qwe123 = '/etc/brainy/api/u1';
			$server = new server();
			$unhash = $server->decryptmainfunc($out['passhash'], $GLOBALS['cryptkeymain']);

			if (strlen($unhash) < 5) {
				$unhash = $server->gen_pass(7);
			}

			$hostacc->hostacc_pass = $unhash;
			$hostacc->hostacc_emailboxes = htmlspecialchars($out['emailboxes']);
			$hostacc->hostacc_bandwidth = intval(intval($out['bandwidth']) / 1024 / 1024);
			$hostacc->hostacc_sites = htmlspecialchars($out['sites']);
			$hostacc->hostacc_dns_zones = htmlspecialchars($out['dns_zones']);
			$hostacc->hostacc_mailperhour = htmlspecialchars($out['mailperhour']);
			$hostacc->hostacc_disk = intval(intval($out['disk']) / 1024 / 1024);
			$hostacc->hostacc_ftp_accounts = htmlspecialchars($out['ftp_accounts']);
			$hostacc->hostacc_template = htmlspecialchars($out['template']);
			$hostacc->hostacc_shell_access = htmlspecialchars($out['shell_access']);
			$hostacc->hostacc_plan = htmlspecialchars($out['plan']);
			$hostacc->hostacc_lang = htmlspecialchars($out['language']);
			$hostacc->hostacc_databases = htmlspecialchars($out['databases']);
			$hostacc->hostacc_ip = htmlspecialchars($out['ip']);
			$hostacc->hostacc_group = htmlspecialchars($out['group']);
			$hostacc->hostacc_owner = htmlspecialchars($out['owner']);
			$hostacc->hostacc_rootdir = htmlspecialchars($out['rootdir']);
			$res1 = $hostacc->hostacc_add();
		}

		global $lang;
		$out['code'] = 0;
		$out['code'] = $lang['backup_restore_useracc_ok'];
		return $out;
	}

	public function restore_db($user_group, $user_name, $path_to_dump, $db_list_rest = NULL)
	{
		global $lang;
		require_once $GLOBALS['CLASSES_PATH'] . '/dbusage.php';
		require_once $GLOBALS['CLASSES_PATH'] . '/server.php';
		$mysql_conn = new dbusage();
		$server = new server();

		foreach ($db_list_rest as $keydb => $curuserdb) {
			if (stripos($curuserdb, '_') !== false) {
				$db_list_rest[$keydb] = explode('_', $curuserdb)[1];
			}
		}

		$res = scandir($path_to_dump);

		foreach ($res as $elem) {
			if (!is_null($db_list_rest)) {
				if (!in_array($elem, $db_list_rest)) {
					continue;
				}
			}

			if (is_file($path_to_dump . '/' . $elem) && ($elem != '.') && ($elem != '..') && ($elem != $GLOBALS['BACKUP_FILE_NAME_USERS'])) {
				$pathName = $elem;
				$elem = str_replace('.sql', '', $elem);
				$elem_prefix = $user_name . '_';

				if ($user_group == 'y') {
				}

				$res = $server->mysql_query_do('INFORMATION_SCHEMA', 'SELECT * FROM SCHEMATA where SCHEMA_NAME=\'' . $elem_prefix . $elem . '\'');

				if ($res == 0) {
					$db_name = $elem;
					$resadddb = $mysql_conn->mysql_add_db($db_name, $user_name);
					$res = $server->mysql_query_doimport($elem_prefix . $elem, $path_to_dump . '/' . $pathName);

					if ($res != 0) {
						$out['code'] = 1;
						$out['code'] = $res;

						return $out;
					}
				}
			}
		}

		$out['code'] = 0;
		$out['code'] = $lang['backup_restore_dbs_ok'];
		return $out;
	}

	public function restoredb_user($user_group, $user_name, $path_to_dump, $dbuser_list_rest = NULL)
	{
		$arrNullField[] = 'password_last_changed';
		$arrNullField[] = 'password_lifetime';
		require_once $GLOBALS['CLASSES_PATH'] . '/dbusage.php';
		require_once $GLOBALS['CLASSES_PATH'] . '/server.php';

		foreach ($dbuser_list_rest as $keydb => $curuserdb) {
			if (stripos($curuserdb, '_') !== false) {
				$dbuser_list_rest[$keydb] = explode('_', $curuserdb)[1];
			}
		}

		$mysql_conn = new dbusage();
		$server = new server();
		$user_pass_get = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($path_to_dump . '/' . $GLOBALS['BACKUP_FILE_NAME_USERS']));
		$get_all_col_user_tbl = 'SELECT `COLUMN_NAME` FROM `INFORMATION_SCHEMA`.`COLUMNS` WHERE `TABLE_SCHEMA`=\'mysql\' AND `TABLE_NAME`=\'user\'';
		$res_all_col_user = $server->mysql_query_do('mysql', $get_all_col_user_tbl);
		$prefix_elem = $user_name . '_';
		$arr_alr_ins = array();
		$file_users = $GLOBALS['USERS_PATH'] . $user_name;
		$users = parse_ini_file($file_users, true);

		foreach ($user_pass_get as $curusersett) {
			$curuserconf_arr = explode('|', $curusersett);
			$elem = $curuserconf_arr[1];

			if (!is_null($dbuser_list_rest)) {
				if (!in_array($curuserconf_arr[1], $dbuser_list_rest)) {
					continue;
				}
			}

			$arr_alr_ins[] = $prefix_elem . $elem;

			if (isset($users['mysql_users'])) {
				$users['mysql_users'] = $users['mysql_users'] . ',' . $prefix_elem . $elem;
			}
			else {
				$users['mysql_users'] = $prefix_elem . $elem;
			}

			$iCol = 0;
			$ins_query = '';

			foreach ($res_all_col_user as $colname) {
				if ($iCol == 0) {
					$ins_query .= '(' . $colname[0] . '';
				}
				else {
					$ins_query .= ',' . $colname[0] . '';
				}

				++$iCol;
			}

			$i = 0;
			$ins_query .= ') VALUES';
			$host_empty = 0;

			foreach ($curuserconf_arr as $col_val) {
				if (($i == 0) && (strlen($col_val) < 1)) {
					$host_empty = 1;
					break;
				}

				if ($i == 1) {
					$col_val = $prefix_elem . $col_val;
				}

				if (!in_array($res_all_col_user[$i][0], $arrNullField)) {
					if ($i == 0) {
						$ins_query .= '(\'' . $col_val . '\'';
					}
					else {
						$ins_query .= ',\'' . $col_val . '\'';
					}
				}
				else if ($i == 0) {
					$ins_query .= '(null';
				}
				else {
					$ins_query .= ',null';
				}

				++$i;

				break;
			}

			if ($i < $iCol) {
				$inse = $i;

				while ($inse < $iCol) {
					$ins_query .= ',\'' . $col_val . '\'';
					++$inse;
				}
			}

			$ins_query .= ')';

			if ($host_empty == 0) {
				$res2 = $server->mysql_query_do('mysql', 'INSERT INTO user ' . $ins_query);
			}
		}

		$this->config_save($file_users, $users);
		$server->mysql_query_do_nodb('FLUSH PRIVILEGES;');
		$res = scandir($path_to_dump . '/' . $GLOBALS['BACKUP_DIR_MYSQL_USERS_PRIV']);

		foreach ($res as $elem) {
			if (($elem == '.') || ($elem == '..')) {
				continue;
			}

			if (!is_null($dbuser_list_rest)) {
				if (!in_array($elem, $dbuser_list_rest)) {
					continue;
				}
			}

			$user_get_privs = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($path_to_dump . '/' . $GLOBALS['BACKUP_DIR_MYSQL_USERS_PRIV'] . '/' . $elem));

			foreach ($user_get_privs as $privdb) {
				$rowpriv_db = explode('=', $privdb);
				$db = trim($rowpriv_db[0]);
				$privs = explode(':', $rowpriv_db[1]);
				$privs = implode(',', $privs);

				if (2 < strlen($privs)) {
					$host_arr_open = $mysql_conn->get_user_hosts($prefix_elem . $elem);
					$host_arr_open_str = '';

					if (is_array($host_arr_open)) {
						$host_arr_open_str = implode(' ', $host_arr_open);
					}

					$ww = $mysql_conn->set_user_to_db($prefix_elem . $elem, $prefix_elem . $db, $privs, '', $host_arr_open_str);
				}
			}
		}

		$root = parse_ini_file($GLOBALS['MYSQL_CONF_PATH'], true);
		$root = $root['root'];

		foreach ($user_get_privs as $privdb) {
			$rowpriv_db = explode('=', $privdb);
			$db = trim($rowpriv_db[0]);
			$comm = 'mysql -uroot -p' . $root . ' -e' . '\'' . 'GRANT ALL ON ' . $prefix_elem . $db . '.* TO "' . $user_name . '"@"127.0.0.1";' . '\'' . ' mysql';
		}

		global $lang;
		$out['code'] = 0;
		$out['code'] = $lang['backup_restore_dbsusers_ok'];
		return $out;
	}

	public function is_url_exist($url)
	{
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_NOBODY, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_exec($ch);
		$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

		if ($code == 200) {
			$status = true;
		}
		else {
			$status = false;
		}

		curl_close($ch);
		return $status;
	}

	public function restorefromfile($userdata, $filename = NULL, $pathfile, $size, $input_path_backupone = NULL, $input_enterpass_1 = NULL, $input_enterpass_2 = NULL, $input_enterpass_3 = NULL, $typerestval = 0, $input_path_backupone_url = '', $input_path_backupone_ftp = '', $input_enterpass_4 = NULL)
	{
		global $lang;

		if ($typerestval == 1) {
			$fullname = pathinfo($filename)['basename'];
		}

		if ($typerestval == 2) {
			$fullname = pathinfo($input_path_backupone)['basename'];
		}

		if ($typerestval == 3) {
			$fullname = pathinfo($input_path_backupone_url)['basename'];
		}

		if ($typerestval == 4) {
			$fullname = pathinfo($input_path_backupone_ftp)['basename'];
		}

		$username = explode('_', $fullname)[0];
		$stream[0]['comm'] = 'echo \'restorebackuphint #' . $username . '#\' >>/dev/null';
		$this->ssh('rm -f ' . $this->tmp_backup . $fullname);
		$param = array('username' => $username);
		$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'clearuserdata\' -p=\'' . json_encode($param) . '\'';

		if ($typerestval == 1) {
			move_uploaded_file($pathfile, $this->tmp_backup . $filename);
			$ext = pathinfo($filename)['extension'];
		}

		if ($typerestval == 2) {
			if (!is_file($input_path_backupone)) {
				$res['code'] = -5;
				$res['mess'] = $lang['backup_restoreone_pathnotexist_local'];
				return $res;
			}

			$ext = pathinfo($input_path_backupone)['extension'];
		}

		if ($typerestval == 3) {
			$input_path_backupone_url = $this->strip_quotes_cmd($input_path_backupone_url);

			if ($this->is_url_exist($input_path_backupone_url) === false) {
				$res['code'] = -5;
				$res['mess'] = $lang['backup_restoreone_pathnotexist_url'];
				return $res;
			}

			$stream[]['comm'] = 'wget --timeout 20 -t 3 --no-check-certificate ' . $input_path_backupone_url . ' -P ' . $this->tmp_backup . ' &>/dev/null';
			$ext = pathinfo($input_path_backupone_url)['extension'];
		}

		if ($typerestval == 4) {
			$input_path_backupone_url = $this->strip_quotes_cmd($input_path_backupone_ftp);
			$resCheckQ = 'wget --timeout 10 -t 2 --spider ' . $input_path_backupone_ftp . '  2>&1';
			$resC = implode(',', $this->ssh($resCheckQ));
			if ((stripos($resC, 'No such file') !== false) || (stripos($resC, 'unable to resolve') !== false) || (stripos($resC, 'incorrect') !== false) || (stripos($resC, 'timed out') !== false)) {
				$res['code'] = -5;
				$res['mess'] = $lang['backup_restoreone_pathnotexist_ftp'];
				return $res;
			}

			$stream[]['comm'] = 'wget --timeout 10 -t 3 --no-check-certificate ' . $input_path_backupone_ftp . ' -P ' . $this->tmp_backup . ' 2>/dev/stdout';
			$ext = pathinfo($input_path_backupone_ftp)['extension'];
		}

		$dbflag_restdb = 'dbrest';
		$dbflag_restdb_end = 'dbrestend';
		$dbflag_restuser = 'dbuser_rest';
		$dbflag_restuser_end = 'dbuser_restend';

		if (is_file($GLOBALS['USERS_PATH'] . $username)) {
			$confUserData = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		}
		else {
			$confUserData['rootdir'] = $GLOBALS['HOME_PATH'] . $username;
		}

		$path_to_restore = '';
		if (($userdata['group_properties']['root'] == 'y') || ($userdata['group_properties']['root'] == 'y')) {
			$path_to_restore = $confUserData['rootdir'];
		}

		if ($userdata['username'] == $username) {
			$path_to_restore = $confUserData['rootdir'];
		}

		if (strlen($path_to_restore) < 2) {
			$res['code'] = -1;
			$res['mess'] = $lang['backup_restonefile_warning_ownerdeny'];
			return $res;
		}

		if (($this->check_params('user_string', $username) === false) || (strlen($username) < 2)) {
			$res['code'] = '-2' . $username;
			$res['mess'] = $lang['backup_restonefile_warning_ownerdeny'];
			return $res;
		}

		$typerest = '';

		if ($ext != 'encoded') {
			if ($typerestval == 1) {
				$typerest = $lang['backup_restonefile_selarch_loadhard_short'];
				$stream[]['comm'] = 'find ' . $confUserData['rootdir'] . ' -type l -or -type f -or -type d \\( -path ' . '/' . ' -o -path ' . $confUserData['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
				$stream[]['comm'] = 'mkdir -p ' . $confUserData['rootdir'];
				$stream[]['comm'] = 'tar xzf ' . $this->tmp_backup . $filename . ' -C ' . $path_to_restore;
				$stream[]['comm'] = 'rm -f ' . $this->tmp_backup . $filename;
			}

			if ($typerestval == 2) {
				$typerest = $lang['backup_restonefile_selarch_local'];
				$backups_path = pathinfo(str_replace('//', '/', $input_path_backupone))['dirname'];

				if ($backups_path[strlen($backups_path) - 1] == '/') {
					$backups_path = $this->str_replace_first_end('/', '', $backups_path);
				}

				$stream[]['comm'] = 'find ' . $confUserData['rootdir'] . ' -type l -or -type f -or -type d \\( -path "' . $backups_path . '" -o -path ' . $confUserData['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
				$stream[]['comm'] = 'mkdir -p ' . $confUserData['rootdir'];
				$stream[]['comm'] = 'tar xzf ' . $input_path_backupone . ' -C ' . $path_to_restore;
			}

			if ($typerestval == 3) {
				$typerest = $lang['backup_restonefile_selarch_url'];
				$stream[]['comm'] = 'find ' . $confUserData['rootdir'] . ' -type l -or -type f -or -type d \\( -path "' . $backups_path . '" -o -path ' . $confUserData['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
				$stream[]['comm'] = 'mkdir -p ' . $confUserData['rootdir'];
				$stream[]['comm'] = 'tar xzf ' . $this->tmp_backup . $fullname . ' -C ' . $path_to_restore;
				$stream[]['comm'] = 'rm -f ' . $this->tmp_backup . $fullname;
			}

			if ($typerestval == 4) {
				$typerest = $lang['backup_restonefile_selarch_ftp'];
				$stream[]['comm'] = 'find ' . $confUserData['rootdir'] . ' -type l -or -type f -or -type d \\( -path "' . $backups_path . '" -o -path ' . $confUserData['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
				$stream[]['comm'] = 'mkdir -p ' . $confUserData['rootdir'];
				$stream[]['comm'] = 'tar xzf ' . $this->tmp_backup . $fullname . ' -C ' . $path_to_restore;
				$stream[]['comm'] = 'rm -f ' . $this->tmp_backup . $fullname;
			}
		}
		else {
			if ($typerestval == 1) {
				$typerest = $lang['backup_restonefile_selarch_loadhard_short'];
				$passback1 = $input_enterpass_1;
				$passback1 = $this->strip_quotes_cmd($passback1);
				$stream[]['comm'] = 'rt=$(openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $this->tmp_backup . $fullname . ' 2>&1 1>/dev/null);echo $rt';
				$this->refractor_stream_encodebackup($stream);
				$stream[]['comm'] = 'find ' . $confUserData['rootdir'] . ' -type l -or -type f -or -type d \\( -path ' . '/' . ' -o -path ' . $confUserData['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
				$stream[]['comm'] = 'mkdir -p ' . $confUserData['rootdir'];
				$stream[]['comm'] = 'openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $this->tmp_backup . $filename . '  | tar -xz ' . ' -C ' . $path_to_restore;
				$stream[]['comm'] = 'rm -f ' . $this->tmp_backup . $filename;
			}

			if ($typerestval == 2) {
				$typerest = $lang['backup_restonefile_selarch_local'];
				$passback1 = $input_enterpass_2;
				$passback1 = $this->strip_quotes_cmd($passback1);
				$stream[]['comm'] = 'rt=$(openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $input_path_backupone . ' 2>&1 1>/dev/null);echo $rt';
				$this->refractor_stream_encodebackup($stream);
				$backups_path = pathinfo(str_replace('//', '/', $input_path_backupone))['dirname'];

				if ($backups_path[strlen($backups_path) - 1] == '/') {
					$backups_path = $this->str_replace_first_end('/', '', $backups_path);
				}

				$stream[]['comm'] = 'find ' . $confUserData['rootdir'] . ' -type l -or -type f -or -type d \\( -path "' . $backups_path . '" -o -path ' . $confUserData['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
				$stream[]['comm'] = 'mkdir -p ' . $confUserData['rootdir'];
				$stream[]['comm'] = 'openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $input_path_backupone . '  | tar -xz ' . ' -C ' . $path_to_restore;
			}

			if ($typerestval == 3) {
				$typerest = $lang['backup_restonefile_selarch_url'];
				$passback1 = $input_enterpass_3;
				$passback1 = $this->strip_quotes_cmd($passback1);
				$stream[]['comm'] = 'rt=$(openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $this->tmp_backup . $fullname . ' 2>&1 1>/dev/null);echo $rt';
				$this->refractor_stream_encodebackup($stream);
				$stream[]['comm'] = 'find ' . $confUserData['rootdir'] . ' -type l -or -type f -or -type d \\( -path ' . '/' . ' -o -path ' . $confUserData['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
				$stream[]['comm'] = 'mkdir -p ' . $confUserData['rootdir'];
				$stream[]['comm'] = 'openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $this->tmp_backup . $fullname . '  | tar -xz ' . ' -C ' . $path_to_restore;
				$stream[]['comm'] = 'rm -f ' . $this->tmp_backup . $fullname;
			}

			if ($typerestval == 4) {
				$typerest = $lang['backup_restonefile_selarch_ftp'];
				$passback1 = $input_enterpass_4;
				$passback1 = $this->strip_quotes_cmd($passback1);
				$stream[]['comm'] = 'rt=$(openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $this->tmp_backup . $fullname . ' 2>&1 1>/dev/null);echo $rt';
				$this->refractor_stream_encodebackup($stream);
				$stream[]['comm'] = 'find ' . $confUserData['rootdir'] . ' -type l -or -type f -or -type d \\( -path ' . '/' . ' -o -path ' . $confUserData['rootdir'] . '/var \\) -prune -o -print | awk \'{if(NR>1)print}\' | xargs rm -rf';
				$stream[]['comm'] = 'mkdir -p ' . $confUserData['rootdir'];
				$stream[]['comm'] = 'openssl enc -k \'' . $passback1 . '\' -d -aes-256-cbc -in ' . $this->tmp_backup . $fullname . '  | tar -xz ' . ' -C ' . $path_to_restore;
				$stream[]['comm'] = 'rm -f ' . $this->tmp_backup . $fullname;
			}
		}

		$param = array('usergroup' => $userdata['group_properties']['root'], 'rootRights' => $userdata['group_properties']['root'], 'path_to_restore' => $path_to_restore, 'username' => $username, 'dbflag_restdb' => $dbflag_restdb, 'dbflag_restdb_end' => $dbflag_restdb_end, 'dbflag_restuser' => $dbflag_restuser, 'dbflag_restuser_end' => $dbflag_restuser_end);
		$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restoreproctar\' -p=\'' . json_encode($param) . '\'';
		$param = array('usergroup' => $userdata['group_properties']['root'], 'username' => $username);
		$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'hostaccsetjailhost\' -p=\'' . json_encode($param) . '\'';
		$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'hostaccsetjailphp\' -p=\'' . json_encode($param) . '\'';
		$stream[]['comm'] = 'rm ' . $confUserData['rootdir'] . '/' . $this->databackup_streamtmp;
		$stream[]['comm'] = 'echo \'restorebackuphintend #' . $username . '#\' >>/dev/null';
		$stream_id = $this->create_stream($stream);
		$this->writelog_restore($stream_id, $typerest, $path_to_restore . '/', $userdata, $typerest, $fullname);
		$res2['code'] = 0;
		$res2['mess'] = '';
		return $res2;
	}

	public function writelog_restore($stream_id, $typerest, $path_to_restore, $userdata, $type_full_db_or, $file_backup)
	{
		$file_log = $GLOBALS['BACKUP_HISTORY_LOG_DIR'] . $userdata['name'] . '.log';
		$handle = fopen($file_log, 'a+');
		flock($handle, LOCK_EX);

		if (is_file($file_log)) {
			$list_transfer_hist = preg_split('/\\r\\n|\\r|\\n/', fread($handle, filesize($file_log)));
		}
		else {
			$list_transfer_hist = array();
		}

		$count_hist = count($list_transfer_hist);
		$j = 0;
		$row_save = array();
		$ah = 0;

		while ($ah < $count_hist) {
			if ($GLOBALS['BACKUP_MAX_HISTORY_RECORD'] < $j) {
				break;
			}

			$row_save[] = preg_replace('/[^А-Яа-яA-Za-z0-9\\-|.\\/_:; ]/iu', '', $list_transfer_hist[$ah]);
			++$j;
			++$ah;
		}

		ftruncate($handle, 0);
		fwrite($handle, $stream_id . '|' . date('d.m.Y H:i:s') . '|' . $typerest . '/' . $file_backup . '|' . $path_to_restore . '|' . $type_full_db_or . '|' . "\n");

		foreach ($row_save as $curhist) {
			if (5 < strlen($curhist)) {
				fwrite($handle, $curhist . "\n");
			}
		}

		fflush($handle);
		flock($handle, LOCK_UN);
		fclose($handle);
	}

	public function writelog_backup($stream_id, $nameconf, $pathbackup, $userdata, $taskconf)
	{
		$user_onnametask = explode('_', $taskconf)[0];

		if ($user_onnametask == 'config') {
			$userdata['name'] = 'root';
		}
		else {
			$userdata['name'] = $user_onnametask;
		}

		$file_log = $GLOBALS['BACKUP_HISTORY_LOG_DIR'] . $userdata['name'] . '.backup_log';
		$handle = fopen($file_log, 'a+');
		flock($handle, LOCK_EX);

		if (is_file($file_log)) {
			$list_hist_backup = preg_split('/\\r\\n|\\r|\\n/', fread($handle, filesize($file_log)));
		}
		else {
			$list_hist_backup = array();
		}

		$count_hist = count($list_hist_backup);
		$j = 0;
		$ah = 0;

		while ($ah < $count_hist) {
			if ($GLOBALS['BACKUP_MAX_HISTORY_RECORD'] < $j) {
				break;
			}

			$row_save[] = $list_hist_backup[$ah];
			++$j;
			++$ah;
		}

		ftruncate($handle, 0);
		fwrite($handle, $stream_id . '|' . date('d.m.Y H:i:s') . '|' . $nameconf . '|' . $pathbackup . '|' . $taskconf . '|' . "\n");

		foreach ($row_save as $curhist) {
			$curhist2 = preg_replace('/[^А-Яа-яA-Za-z0-9\\-|.\\/_: ]/iu', '', $curhist);

			if (5 < strlen($curhist2)) {
				fwrite($handle, $curhist2 . "\n");
			}
		}

		fflush($handle);
		flock($handle, LOCK_UN);
		fclose($handle);
	}

	public function checkhistory_restore($userdata)
	{
		$file_log = $GLOBALS['BACKUP_HISTORY_LOG_DIR'] . $userdata['name'] . '.log';
		$handle = fopen($file_log, 'a+');
		flock($handle, LOCK_EX);

		if (is_file($file_log)) {
			$logrows = preg_split('/\\r\\n|\\r|\\n/', fread($handle, filesize($file_log)));
		}
		else {
			$logrows = array();
		}

		foreach ($logrows as $keyrow => $currow) {
			$expdatarow = explode('|', $currow);

			if (strlen($expdatarow[5]) < 3) {
				$pid = $this->getexistpid($expdatarow[0]);

				if ($pid == -1) {
					$logrows .= $keyrow;
				}
			}

			$logrows[$keyrow] = preg_replace('/[^А-Яа-яA-Za-z0-9\\-|.\\/_:; ]/iu', '', $logrows[$keyrow]);
		}

		ftruncate($handle, 0);

		foreach ($logrows as $curhist) {
			if (5 < strlen($curhist)) {
				fwrite($handle, $curhist . "\n");
			}
		}

		$resmass['raw_list_backup_hist'] = $logrows;
		fflush($handle);
		flock($handle, LOCK_UN);
		fclose($handle);
		return $resmass;
	}

	public function checkhistory_backup($userdata)
	{
		$file_log = $GLOBALS['BACKUP_HISTORY_LOG_DIR'] . $userdata['name'] . '.backup_log';
		$handle = fopen($file_log, 'a+');
		flock($handle, LOCK_EX);

		if (is_file($file_log)) {
			$logrows = preg_split('/\\r\\n|\\r|\\n/', fread($handle, filesize($file_log)));
		}
		else {
			$logrows = array();
		}

		foreach ($logrows as $keyrow => $currow) {
			$expdatarow = explode('|', $currow);

			if (strlen($expdatarow[5]) < 3) {
				$pid = $this->getexistpid($expdatarow[0]);

				if ($pid == -1) {
					$logrows .= $keyrow;
				}
			}

			$logrows[$keyrow] = preg_replace('/[^А-Яа-яA-Za-z0-9\\-|.\\/_: ]/iu', '', $logrows[$keyrow]);
		}

		ftruncate($handle, 0);

		foreach ($logrows as $currow) {
			if (5 < strlen($currow)) {
				fwrite($handle, $currow . "\n");
			}
		}

		$resmass['raw_list_backup_hist'] = $logrows;
		fflush($handle);
		flock($handle, LOCK_UN);
		fclose($handle);
		return $resmass;
	}

	public function getHintConn($type)
	{
		global $lang;
		$res = array();

		if ($type == 'GoogleDrive') {
			$res[] = $lang['backup_gdrive_verifyplease'];
			$res[] = $lang['backup_gdrive_verifypleaseHintOpt'];
			$res[] = $lang['backup_gdrive_verifyplease_enterhere'];
			$res[] = $lang['backup_verifypleaseSucOk'];
		}

		if ($type == 'Dropbox') {
			$res[] = str_replace('``', '\\'', $lang['backup_gdrive_label_access_token_instr']);
		}

		if ($type == 'YandexDisk') {
			$res[] = str_replace('``', '\\'', $lang['backupYandexInstructionGetOAuth']);
		}

		if ($type == 'authKey') {
			$res[] = str_replace('``', '\\'', $lang['backupHintUseKeysAuth']);
		}

		return $res;
	}

	public function getListAllDB()
	{
		$res = $this->mysql_query_do_nodb('show databases;');
		file_put_contents('/etc/brainy/data/mysql/listDB_' . date('d.m.Y_H.i.s') . '.log', print_r($res, 1) . "\n", FILE_APPEND);
	}

	public function cancelBackup($stream, $user, $rootRights)
	{
		$fileLog = $GLOBALS['BACKUP_HISTORY_LOG_DIR'] . $user . '.backup_log';
		$handle = fopen($fileLog, 'a+');
		flock($handle, LOCK_EX);

		if (is_file($fileLog)) {
			$logrows = preg_split('/\\r\\n|\\r|\\n/', fread($handle, filesize($fileLog)));
		}
		else {
			$logrows = array();
		}

		global $lang;

		foreach ($logrows as $keyrow => $currow) {
			$expData = explode('|', $currow);
			$fileBackupConf = $expData[4];
			$this->kill_stream($stream);
			file_put_contents($GLOBALS['STREAMS_PATH'] . $stream, $lang['backupStopMakeBackupCancelLog'] . "\n", FILE_APPEND);
			$arr_conf = $this->config_read($GLOBALS['BACKUP_CONF'] . $fileBackupConf);
			$backup_all = intval($arr_conf['backup_make_for_all_users']);

			if ($backup_all == 1) {
				if (stripos($fileBackupConf, 'config_') !== false) {
					$usersArr = $this->get_users();
				}
			}
			else {
				$usersArr = explode(',', $arr_conf['backup_selected_users']);

				foreach ($usersArr as $key => $cur_check) {
					if (stripos($fileBackupConf, 'config_') === false) {
						unset($usersArr[$key]);
					}

					if (!$this->check_value('user', $cur_check)) {
						unset($usersArr[$key]);
					}
				}
			}

			foreach ($usersArr as $curUser) {
				$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $curUser);

				if (2 < strlen($confUser['rootdir'])) {
					$this->ssh('rm -rf ' . $confUser['rootdir'] . '/' . $this->databackup_streamtmp);
					$this->ssh('rm -rf ' . $confUser['rootdir'] . '/' . $this->dir_backup_configs);
				}
			}

			$res['code'] = 0;
			$res['message'] = $lang['backupStopMakeBackupOk'];

			return $res;
		}
	}

	public function cancelRestore($stream, $user, $rootRights)
	{
		$fileLog = $GLOBALS['BACKUP_HISTORY_LOG_DIR'] . $user . '.log';
		$handle = fopen($fileLog, 'a+');
		flock($handle, LOCK_EX);

		if (is_file($fileLog)) {
			$logrows = preg_split('/\\r\\n|\\r|\\n/', fread($handle, filesize($fileLog)));
		}
		else {
			$logrows = array();
		}

		global $lang;

		foreach ($logrows as $keyrow => $currow) {
			$expData = explode('|', $currow);
			$this->kill_stream($stream);
			file_put_contents($GLOBALS['STREAMS_PATH'] . $stream, $lang['backupStopMakeRestoreCancelLog'] . "\n", FILE_APPEND);
			$pathRest = $expData[3];
			$pathRestArr = explode(';', $pathRest);

			foreach ($pathRestArr as $curRestPath) {
				$userName = explode('/', $curRestPath);
				$userName = $userName[count($userName) - 2];

				if (2 < strlen($userName)) {
					$this->kill_stream($userName . '_');
					$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $userName);

					if (2 < strlen($confUser['rootdir'])) {
						$this->ssh('rm -rf ' . $confUser['rootdir'] . '/' . $this->datarestore_streamtmp);
						$this->ssh('rm -rf ' . $confUser['rootdir'] . '/' . $this->dir_backup_configs);
					}
				}
			}

			$res['code'] = 0;
			$res['message'] = $lang['backupStopMakeRestoreOk'];

			return $res;
		}
	}
}


?>
