<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class bindserver
{
	const PATH_TO_SCRIPT = '/etc/brainy/ssh/named/';

	public $commands = array('start', 'stop', 'restart', 'install', 'delete', 'reinstall', 'reload');
	public $services = array('named');

	public function bindserver_getAllZone()
	{
		$zones = $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh -l');
		$arr = array();

		foreach ($zones as $key) {
			$temp = explode(':', $key);
			$arr[$temp[1]][] = trim($temp[0]);
		}

		return $arr;
	}

	public function update_dns_zone()
	{
		global $lang;
		$dns = $this->filelist('/var/named/', 'named*', 'f');
		$dns_user = $this->read_file_n(self::PATH_TO_SCRIPT . 'user.db');
		$mas_user = array();

		foreach ($dns_user as $key => $val) {
			array_push($mas_user, explode(':', $val));
		}

		$str = '';

		foreach ($dns as $value) {
			$preg = preg_replace('/^named./', '', $value);
			if (($preg == 'ca') || ($preg == 'empty') || ($preg == 'empty') || ($preg == 'localhost') || ($preg == 'loopback')) {
				continue;
			}

			$config = $this->config_read('/etc/brainy/data/vhosts/' . $preg . '.conf');

			if (is_array($config)) {
				if (!empty($preg)) {
					$str .= $preg . ':' . $config['user'] . ':0' . PHP_EOL;
				}
			}
			else {
				$user = '';

				foreach ($mas_user as $key => $vall) {
					if ($preg == $vall[0]) {
						$user = $vall[1];
					}
				}

				if (empty($user)) {
					$user = 'root';
				}

				if (!empty($preg)) {
					$str .= $preg . ':' . $user . ':0' . PHP_EOL;
				}
			}
		}

		$this->write_file($str, self::PATH_TO_SCRIPT . 'user.db');
		$this->rebuild_rndc();
		$this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --rebuildns');
		$arr['mesage'] = $lang['bindserver_completed'];
		$arr['mesage1'] = $lang['bindserver_update_cache'];
		return $arr;
	}

	public function bindserver_addAddrToZone($zone, $name, $type, $value)
	{
		$out = implode("\n", $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --edit --zone ' . $zone . ' --name ' . $name . ' --type ' . $type . ' --value \'' . $value . '\' --line new 2>&1'));

		if (0 < stripos($out, 'not found here')) {
			$zone = $this->ssh('grep -rl ' . $zone . '. /var/named/ 2>/dev/null');

			if (count($zone) != 0) {
				$zone = explode('named.', $zone[0])[1];
				$out = implode("\n", $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --edit --zone ' . $zone . ' --name ' . $name . ' --type ' . $type . ' --value \'' . $value . '\' --line new'));
			}
		}

		$zonefile = $this->bindserver_readZone($zone);
		$param['act'] = 'save_zone_to_file';
		$param['zone'] = $zone;
		$param['text'] = $zonefile;
		$this->bindserver_send_data_to_cluster($param);
		return $out;
	}

	public function bindserver_getZone()
	{
		$arr = array();
		$zones = $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh -l');

		foreach ($zones as $key) {
			$temp = explode(':', $key);
			$arr[$temp[1]][] = $temp[0];
		}

		return $arr;
	}

	public function bindserver_readZone($zonename)
	{
		$zones = file_get_contents('/var/named/named.' . $zonename);
		$zonemass = explode("\n", trim($zones));

		if (3 < count($zonemass)) {
			return $zones;
		}

		$zone = $this->ssh('grep -rl ' . $zonename . '. /var/named/ 2>/dev/null');

		if (count($zone) != 0) {
			$zone = explode('named.', $zone[0])[1];
			$zones = file_get_contents('/var/named/named.' . $zone);
			return $zones;
		}
	}

	public function bindserver_deleteZone($zone, $user, $needcluster = NULL)
	{
		global $lang;

		if ($GLOBALS['DEMO'] == 1) {
			$res['mess'] = $lang['common_demo_message'];
			$res['error'] = 101;
			return $res;
		}

		if (!$this->check_value('domain', $zone) || !$this->check_value('user', $user)) {
			return false;
		}

		$zones = $this->bindserver_getZoneByUser($user);

		if (is_array($zone)) {
			foreach ($zone as $val_zone) {
				$this->bind_delete_zone2($val_zone);
			}
		}
		else {
			if (is_array($zones) && in_array($zone, $zones)) {
				$this->bind_delete_zone2($zone);
			}
			else {
				return $lang['bindserver_bad_user'];
			}
		}

		$hostacc = new hostacc();
		$hostacc->hostacc_count_dns_zones($user, 1);
	}

	public function bind_delete_zone2($zone)
	{
		$param['act'] = 'delete_btn';
		$param['zone'] = $zone;
		$file = file_get_contents('/etc/brainy/data/bindserver/cluster.info');
		$arr = explode("\n", $file);

		foreach ($arr as $key) {
			$arr_claster = explode('|', $key);

			if ($arr_claster[6] == 1) {
				$this->bindserver_send_data_to_cluster($param);
			}
		}

		$out_old_host = $this->ssh('cat /var/named/3bf305731dd26307.nzf | grep \'"' . $zone . '"\'');

		if ($out_old_host) {
			$this->ssh('sed -i \'/"' . $zone . '"/d\' /var/named/3bf305731dd26307.nzf');
		}

		$resD = implode("\n", $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh -d --zone ' . $zone));
		$out_db = implode('', $this->ssh('cat ' . $this::PATH_TO_SCRIPT . 'ns.db | grep ' . $zone . ':'));

		if ($out_db) {
			$this->del_string_new($zone . ':', $this::PATH_TO_SCRIPT . 'ns.db');
			$this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --rebuildns');
			$this->rebuild_rndc();
		}
	}

	public function bindserver_checkUserZone($zone, $user)
	{
		global $server;
		if (!$this->check_value('domain', $zone) || !$this->check_value('user', $user)) {
			return false;
		}

		$zones = $this->bindserver_getZoneByUser($user);
		if (is_array($zones) && in_array($zone, $zones)) {
			return true;
		}

		return false;
	}

	public function bindserver_getDefaultNsArray()
	{
		$ns = $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --defns list');
		$arr = array();

		foreach ($ns as $key) {
			$temp = explode(':', $key);
			$arr[] = $temp[0];
		}

		return $arr;
	}

	public function bindserver_getDefaultNsIP($host)
	{
		$ns = $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --defns list');
		$arr = array();

		foreach ($ns as $key) {
			$temp = explode(':', $key);

			return $temp[1];
		}

		return false;
	}

	public function bindserver_getDefaultNsTableSmarty()
	{
		global $lang;
		$ns = $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --defns list');
		$arr = array();

		foreach ($ns as $key) {
			$temp = explode(':', $key);
			$a = array();
			$a[] = $temp[0];
			$a[] = $temp[1];
			$arr[] = $a;
		}

		return $arr;
	}

	public function bindserver_saveDefaultNsTable($zone, $lang)
	{
		foreach ($zone as $key1 => $val1) {
			return false;
		}

		$ns = $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --defns list');

		foreach ($ns as $key) {
			$temp = explode(':', $key);
			$this->bindserver_deleteDefaultNs($temp[0]);
		}

		foreach ($zone as $key => $value) {
			$this->bindserver_addDefaultNs($key, $value);
		}

		return $lang['msg_save_ns_table'];
	}

	public function bindserver_rebuiltDefaultNs($lang)
	{
		$this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --rebuildns');
		$this->rebuild_rndc();
		return $lang['msg_rebuild_ns_table'];
	}

	public function bindserver_show_version()
	{
		global $lang;
		$this->load_vars('config.cnf');
		$arr = $this->module_vars;
		$result['version'] = $arr['bindserver'] . ' ' . $lang['version'] . ':' . $arr['bindserver_version'];
		$result['available'] = $this->bindserver_get_available('named');
		return $result;
	}

	public function bindserver_get_available($service)
	{
		global $lang;
		$service = $this->strip_quotes_cmd($service);
		$out = $this->ssh('named -v 2> /dev/null');

		if ($out) {
			$result = $this->ssh('/sbin/service \'' . $service . '\' status');

			switch ($GLOBALS['OS_VERSION']) {
			case 'centos7':
				$preg = '/active {1,}\\(running\\)/i';
				break;
			}

			if (preg_match($preg, implode('', $result))) {
				$out_1['status'] = $lang['started'];
			}
			else {
				$out_1['status'] = $lang['stoped'];
			}

			$out_1['code'] = 0;
		}
		else {
			$out_1['code'] = 404;
			$out_1['status'] = $lang['bindserver_not_install'];
		}

		return $out_1;
	}

	public function bindserver_get_progress()
	{
		$this->load_vars();
		return $this->module_vars;
	}

	public function bindserver_delete_record($zone, $line)
	{
		$out = implode("\n", $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --edit --zone ' . $zone . ' --line ' . $line . ' --delete 2>&1'));

		if (0 < stripos($out, 'not found here')) {
			$zone = $this->ssh('grep -rl ' . $zone . '. /var/named/ 2>/dev/null');

			if (count($zone) != 0) {
				$zone = explode('named.', $zone[0])[1];
				$out = implode("\n", $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --edit --zone ' . $zone . ' --line ' . $line . ' --delete 2>&1'));
			}
		}

		$zonefile = $this->bindserver_readZone($zone);
		$param['act'] = 'save_zone_to_file';
		$param['zone'] = $zone;
		$param['text'] = $zonefile;
		$this->bindserver_send_data_to_cluster($param);
		$line = intval($line);
		$out['result'] = $out;
		$out['error'] = 0;
		return $out;
	}

	public function bindserver_deleteDefaultNs($host)
	{
		global $lang;

		if (!$this->check_value('domain', $host)) {
			return false;
		}

		if ($GLOBALS['DEMO'] == 1) {
			$res['mess'] = $lang['common_demo_message'];
			$res['error'] = 101;
			return $res;
		}

		$out_old_host = $this->ssh('cat /var/named/3bf305731dd26307.nzf | grep \'"' . $host . '"\'');

		if ($out_old_host) {
			$this->ssh('sed -i \'/"' . $host . '"/d\' /var/named/3bf305731dd26307.nzf');
		}

		$out = implode("\n", $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --defns del --zone ' . $host));
		$this->rebuild_rndc();
		return $out;
	}

	public function bindserver_addDefaultNs($host, $ip, $lang)
	{
		global $lang;
		$res['error'] = 0;
		$res['message'] = $lang['msg_default_ok'];

		if ($GLOBALS['DEMO'] == 1) {
			$res['error'] = 5;
			$res['message'] = $lang['common_demo_message'];
			return $res;
		}

		if (!$this->check_value('domain', $host) || !$host) {
			$res['error'] = 1;
			$res['message'] = $lang['msg_add_zone_err_name'];
			return $res;
		}

		if ($this->bindserver_validate('ipv42', $ip) == 0) {
			$res['error'] = 2;
			$res['message'] = $lang['msg_add_zone_err_ip'];
			return $res;
		}

		$dns_user = $this->read_file_n(self::PATH_TO_SCRIPT . 'user.db');

		foreach ($dns_user as $val_dns) {
			$array_dns[] = explode(':', trim($val_dns))[0];
		}

		if (in_array($host, $array_dns)) {
			$res['error'] = 6;
			$res['message'] = $host . ' ' . $lang['bindserver_zone_alredy_exists'];
			return $res;
		}

		$res['message'] = implode("\n", $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --defns add --value ' . $host . ':' . $ip));
		return $res;
	}

	public function bindserver_saveDefaultNs($oldhost, $host, $ip, $rebuild, $zone = NULL, $lang)
	{
		$res['error'] = 0;
		$res['message'] = $lang['msg_default_ok'];

		if ($GLOBALS['DEMO'] == 1) {
			$res['message'] = $lang['common_demo_message'];
			$res['error'] = 101;
			return $res;
		}

		if ($this->bindserver_validate('host', $host) == 0) {
			$res['error'] = 1;
			$res['message'] = $lang['msg_add_zone_err_name'];
			return $res;
		}

		if ($this->bindserver_validate('ipv42', $ip) == 0) {
			$res['error'] = 2;
			$res['message'] = $lang['msg_add_zone_err_ip'];
			return $res;
		}

		foreach ($zone as $key => $value) {
			if (!$this->check_value('domain', $value['host']) || !$this->check_value('ip', $value['ip'])) {
				return false;
			}

			$this->bindserver_deleteDefaultNs($value['host']);

			if ($value['host'] == $oldhost) {
				$zone[$key]['ip'] = $ip;
				$zone[$key]['host'] = $host;
			}
		}

		$out_old_host = $this->ssh('cat /var/named/3bf305731dd26307.nzf | grep \'"' . $oldhost . '"\'');

		if ($out_old_host) {
			$this->ssh('sed -i \'/"' . $oldhost . '"/d\' /var/named/3bf305731dd26307.nzf');
		}

		foreach ($zone as $key => $value) {
			if (!$this->check_value('domain', $value['host']) || !$this->check_value('ip', $value['ip'])) {
				return false;
			}

			$result = implode("\n", $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --defns add --value ' . $value['host'] . ':' . $value['ip']));
		}

		if ($rebuild == 'rebuildns') {
			$result .= '<br>' . implode("\n", $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --rebuildns'));
			$this->rebuild_rndc();
		}

		return $res;
	}

	public function bindserver_getZoneByUser($user)
	{
		return $this->bindserver_getZone()[$user];
	}

	public function bindserver_getZoneInfo($zone)
	{
		if (!$this->check_value('domain', $zone)) {
			return false;
		}

		$zone = $this->strip_quotes_cmd($zone);
		return implode("\n", $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh -r -z ' . $zone));
	}

	public function bindserver_getZoneParam($info)
	{
		$start = strpos($info, '$TTL ') + 5;
		$end = strpos($info, CHR(10), $start);
		$length = $end - $start;
		$arr['ttl'] = substr($info, $start, $length);
		$start = strpos($info, CHR(9) . 'A' . CHR(9)) + 3;
		$end = strpos($info, CHR(9), $start);

		if ($end == NULL) {
			$end = strlen($info);
		}

		$length = $end - $start;
		$arr['ip'] = substr($info, $start, $length);
		$end = $start - 6;
		$start = strrpos($info, CHR(32), $end - strlen($info)) + 1;
		$length = $end - $start;
		$arr['zone'] = substr($info, $start, $length);
		return $arr;
	}

	public function bindserver_getZoneTable($user, $decode = 0)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		$zones = $this->bindserver_getZoneByUser($user);
		$puny = new idna_convert();
		$result = array();
		$i = 0;

		if (is_array($zones)) {
			foreach ($zones as $key) {
				if ($decode == 0) {
					$result[$i][0] = $key;
					$result[$i]['domain_decode'] = $key;
				}
				else {
					$result[$i][0] = $key;
					$result[$i]['domain_decode'] = $puny->decode($key);
				}

				++$i;
			}
		}

		return $result;
	}

	public function bindserver_getZoneTable_forCluster($params)
	{
		global $lang;
		$zone = $this->bindserver_getZoneByUser('root');
		$result = '';

		foreach ($zone as $key) {
			if (in_array($key, $params['zones'])) {
				continue;
			}

			$result .= '<tr><td>' . $key . '</td>';
			$edit = '<td><a href="#" data="' . $key . '" data-cluster="' . $params['ip'] . '" data-token="' . $params['token'] . '" class="edit_cluster_btn">Edit' . $lang['edit'] . '</a>';
			$delete = '<a href="#" data="' . $key . '" data-cluster="' . $params['ip'] . '" data-token="' . $params['token'] . '" class="delete_cluster_btn">Delete' . $lang['delete'] . '</a></td></tr>';
			$result .= $edit . ' ' . $delete;
		}

		return $result;
	}

	public function bindserver_getZone_forCluster($params)
	{
		$zone = $this->bindserver_getZoneByUser('root');
		return $zone;
	}

	public function bindserver_getZoneTableForSelect()
	{
		$zones = $this->bindserver_getAllZone();
		return $zones;
	}

	public function bindserver_getZoneTableSmarty($user, $decode = 0)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		$table = $this->bindserver_getZoneTable($user, $decode);
		return $table;
	}

	public function toSmartyTable($arr)
	{
		$res = array();
		$i = 0;

		while ($i < count($arr)) {
			$k = 0;

			while ($k < count($arr[$i])) {
				$res[] = $arr[$i][$k];
				++$k;
			}

			++$i;
		}

		return $res;
	}

	public function bindserver_addZone($user, $zone, $ip, $needcluster = NULL)
	{
		global $lang;

		if ($GLOBALS['DEMO'] == 1) {
			$res['mess'] = $lang['common_demo_message'];
			$res['error'] = 101;
			return $res;
		}

		$hostacc = new hostacc();

		if ($user != 'root') {
			if (is_file($GLOBALS['USERS_PATH'] . '/' . $user)) {
				$user_info = $this->config_read($GLOBALS['USERS_PATH'] . '/' . $user);

				if (($user_info['dns_zones'] <= $user_info['r_dnszones']) && ($user_info['dns_zones'] != 0)) {
					$res['mess'] = $lang['bindserver_dnsOverLimitForuser'] . $user . $lang['bindserver_dnsOverLimit'] . ' ' . $user_info['dns_zones'];
					$res['error'] = 1;
					return $res;
				}
			}
		}

		$puny = new idna_convert();
		$zone = $puny->encode($zone);

		if (!$this->check_value('domain', $zone)) {
			$res['mess'] = $lang['msg_add_zone_err_name'];
			$res['error'] = 1;
			return $res;
		}

		$black_domain = new black_domain();
		$black_domain_list = $black_domain->get_black_domain();

		if (in_array($zone, $black_domain_list)) {
			return array('error' => 230, 'mess' => $lang['black_domain_black']);
		}

		if (!$this->check_value('ip', $ip)) {
			$res['mess'] = $lang['msg_add_zone_err_ip'];
			$res['error'] = 2;
			return $res;
		}

		if (!$this->check_value('user', $user)) {
			return false;
		}

		$zone = $this->strip_quotes_cmd($zone);
		$res['mess'] = $lang['msg_add_zone_good'];
		$res['error'] = 0;

		if (strlen($zone) < 1) {
			$res['mess'] = $lang['msg_add_zone_err_name'];
			$res['error'] = 1;
			return $res;
		}

		if ($this->bindserver_validate('host', $zone) == 0) {
			$res['mess'] = $lang['msg_add_zone_err_name'];
			$res['error'] = 1;
			return $res;
		}

		if ($this->bindserver_validate('ipv4', $ip) == 0) {
			$res['mess'] = $lang['msg_add_zone_err_ip'];
			$res['error'] = 2;
			return $res;
		}

		$res['raw'] = implode("\n", $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --add --zone ' . $zone . ' -ip ' . $ip . ' --ttl 86400 --type A -o ' . $user . ' 2>&1'));
		$zonefile = $this->bindserver_readZone($zone);
		$param['act'] = 'save_zone_to_file';
		$param['zone'] = $zone;
		$param['ip'] = $ip;
		$param['text'] = $zonefile;

		if ($needcluster == '1') {
			$this->bindserver_send_data_to_cluster($param);
		}

		if ($user != 'root') {
			$hostacc->hostacc_count_dns_zones($user, 1);
		}

		return $res;
	}

	public function bindserver_edit_save_zone($zone, $file, $needcluster = NULL)
	{
		global $lang;

		if (!$this->check_value('domain', $zone)) {
			return false;
		}

		if (!$this->check_value('string', $file['top'])) {
			return false;
		}

		if (!$this->check_value('string', $file['bottom'])) {
			return false;
		}

		$puny = new idna_convert();
		$ttl = $file['top']['ttl'];
		$zonename = $puny->encode(trim($file['top']['zonename']));
		$black_domain = new black_domain();
		$black_domain_list = $black_domain->get_black_domain();

		foreach ($black_domain_list as $val_black) {
			$domain_check = preg_replace('/(^www)+|(^\\.)+|(^\\.www)+|(\\.)+$/i', '', $zonename);
			$domain_check = str_replace('.', '\\.', $domain_check);

			return array('error' => 230, 'mess' => $lang['black_domain_edit_black'], 'type' => '', 'data' => '', 'info' => '');
		}

		$soa_ns = $file['top']['soa_ns'];
		$email = $file['top']['email'];
		$serial = $file['top']['serial'];
		$refresh = $file['top']['refresh'];
		$expire = $file['top']['expire'];
		$retry = $file['top']['retry'];
		$minimum = $file['top']['minimum'];
		$orig = '   $ORIGIN .' . "\n" . '$TTL ' . $ttl . "\n" . $zonename . '                       IN SOA ' . $soa_ns . ' ' . $email . ' (' . "\n" . '                                        ' . $serial . "\t" . '; serial' . "\n" . '                                        ' . $refresh . '    ; refresh' . "\n" . '                                        ' . $retry . '     ; retry' . "\n" . '                                        ' . $expire . '  ; expire' . "\n" . '                                        ' . $minimum . '     ; minimum' . "\n" . '                                        )';
		$result = true;
		$ttl = $file['top']['ttl'];
		$zonename = $puny->encode(trim($file['top']['zonename']));
		$soa = $file['top']['soa_ns'];
		$email = $file['top']['email'];
		$serial = $file['top']['serial'];
		$refresh = $file['top']['refresh'];
		$retry = $file['top']['retry'];
		$expire = $file['top']['expire'];
		$min = $file['top']['minimum'];
		$mess = $lang['msg_alert_err_mess'];
		$arr = array('ttl' => $ttl, 'serial' => $serial, 'refresh' => $refresh, 'retry' => $retry, 'expire' => $expire, 'minimum' => $min);

		foreach ($arr as $key => $num) {
			$info = $lang['msg_alert_err_info'] . ' ' . $key . ' ' . $lang['msg_alert_err_info_n'];
			$err_pos = $num;
			$result = false;
			break;
		}

		if ($result) {
			$arr = array('Zone name' => $zonename, 'SOA' => $soa, 'email' => $email);

			foreach ($arr as $key => $host) {
				$host = $puny->encode($host);

				$info = $lang['msg_alert_err_info'] . ' ' . $key . ' ' . $lang['msg_alert_err_info_d'];
				$err_pos = $host;
				$result = false;
				break;
			}

			if ($result) {
				foreach ($file['bottom'] as $key => $value) {
					$type = $value['type'];

					if ($value['type'] == 'NS') {
						$data = $value['def'][0];
						$data = $puny->encode($data);
						$info = $lang['msg_alert_err_info'] . ' ' . $lang['bindserver_needSetNSorIP'];
						$err_pos = $data;
						$result = false;
						break;
					}

					if ($value['type'] == 'MX') {
						$name = $value['name'];
						$name = $puny->encode($name);
						$num = $value['def'][0];
						$data = $value['def'][1];
						$data = $puny->encode($data);

						if (!$this->bindserver_validate('string', $name)) {
							if (!$this->check_value('domain', $name)) {
								$info = $lang['msg_alert_err_info'] . ' MX ' . $lang['msg_alert_err_info_h'];
								$err_pos = $name;
								$result = false;
								break;
							}
						}

						if (!$this->bindserver_validate('number', $num)) {
							$info = $lang['msg_alert_err_info'] . ' MX ' . $lang['msg_alert_err_info_n'];
							$err_pos = $num;
							$result = false;
							break;
						}

						$info = $lang['msg_alert_err_info'] . ' MX ' . $lang['msg_alert_err_info_dh'];
						$err_pos = $data;
						$result = false;
						break;
					}

					if ($value['type'] == 'A') {
						$name = $value['name'];
						$name = $puny->encode($name);
						$ip = $value['def'][0];

						if (!$this->bindserver_validate('string', $name)) {
							if (!$this->check_value('domain', $name)) {
								$info = $lang['msg_alert_err_info'] . ' A ' . $lang['msg_alert_err_info_dh'];
								$err_pos = $data;
								$result = false;
								break;
							}
						}

						$info = $lang['msg_alert_err_info'] . ' A ' . $lang['msg_alert_err_info_ip4'];
						$err_pos = $ip;
						$result = false;
						break;
					}

					if ($value['type'] == 'AAAA') {
						$name = $value['name'];
						$name = $puny->encode($name);
						$ip = $value['def'][0];

						if (!$this->bindserver_validate('string', $name)) {
							if (!$this->check_value('domain', $name)) {
								$info = $lang['msg_alert_err_info'] . ' AAA ' . $lang['msg_alert_err_info_dh'];
								$err_pos = $data;
								$result = false;
								break;
							}
						}

						$info = $lang['msg_alert_err_info'] . ' AAAA ' . $lang['msg_alert_err_info_ip6'];
						$err_pos = $ip;
						$result = false;
						break;
					}

					if (($value['type'] == 'CNAME') || ($value['type'] == 'DNAME')) {
						$type = $value['type'];
						$name = $value['name'];
						$name = $puny->encode($name);
						$data = $value['def'][0];

						if (!$this->bindserver_validate('string2', $data)) {
							if (!$this->check_value('domain', $data)) {
								$info = $lang['msg_alert_err_info'] . ' ' . $type . ' ' . $lang['msg_alert_err_info_dh'];
								$err_pos = $data;
								$result = false;
								break;
							}
						}

						$name = $puny->encode($name);
						$info = $lang['msg_alert_err_info'] . ' ' . $type . ' ' . $lang['msg_alert_err_info_dh'];
						$err_pos = $data;
						$result = false;
						break;
					}

					if ($value['type'] == 'PTR') {
						$type = $value['type'];
						$name = $value['name'];
						$data = $value['def'][0];
						$info = $lang['msg_alert_err_info'] . ' ' . $type . ' ' . $lang['msg_alert_err_info_d'];
						$err_pos = $data;
						$result = false;
						break;
					}

					if ($value['type'] == 'SRV') {
						$type = $value['type'];
						$name = $value['name'];
						$priority = $value['def'][0];
						$weight = $value['def'][1];
						$port = $value['def'][2];
						$host = $value['def'][3];
						$arr = array('priority' => $priority, 'weight' => $weight, 'port' => $port);

						foreach ($arr as $key => $num) {
							$info = $lang['msg_alert_err_info'] . ' ' . $key . ' ' . $lang['msg_alert_err_info_n'];
							$err_pos = $num;
							$result = false;
							break;
						}

						if (!$result) {
							break;
						}

						if (!$this->check_value('domain', $name)) {
							$info = $lang['msg_alert_err_info'] . ' ' . $type . ' ' . $lang['msg_alert_err_info_d'];
							$err_pos = $name;
							$result = false;
							break;
						}

						$info = $lang['msg_alert_err_info'] . ' ' . $type . ' ' . $lang['msg_alert_err_info_d'];
						$err_pos = $host;
						$result = false;
						break;
					}

					if ($value['type'] == 'RP') {
						$type = $value['type'];
						$email = $value['def'][0];
						$data = $value['def'][1];
						$info = $lang['msg_alert_err_info'] . ' ' . $type . ' ' . $lang['bindserver_not_corect_email'];
						$err_pos = $email;
						$result = false;
						break;
					}

					$type = $value['type'];
					$name = $value['name'];

					$info = $lang['msg_alert_err_info'] . ' ' . $type . ' ' . $lang['msg_alert_err_info_d'];
					$err_pos = $name;
					$result = false;
					break;
				}
			}
		}

		if (!$result) {
			$res['error'] = 1;
			$res['mess'] = $mess;
			$res['type'] = $lang['msg_alert_err_obj'] . ' ' . $value['type'];
			$res['data'] = $lang['msg_alert_err_data'] . ' ' . $err_pos;
			$res['info'] = $info;
			return $res;
		}

		$orig = explode("\n", $orig);
		$readfile = $this->read_file_n('/var/named/named.' . $zone);

		foreach ($readfile as $key => $value) {
			if ($orig[$key]) {
				$readfile[$key] = $orig[$key];
			}
			else {
				$readfile[$key] = trim($value);
			}
		}

		$file_itog = implode("\n", $readfile);
		$this->write_file($file_itog, '/var/named/named.' . $zone, 'r');

		foreach ($file['bottom'] as $key => $value) {
			$val = implode(' ', $value['def']);

			if ($value['type']) {
				if ($value['type'] == 'NS') {
					$value['name'] = $zone . '.';
				}

				if ($value['type'] == 'TXT') {
					if (!preg_match('/^["]{1}/i', $val)) {
						$val = '"' . $val;
					}

					if (!preg_match('/["]{1}$/i', $val)) {
						$val = $val . '"';
					}
				}

				if ($value['type'] == 'HINFO') {
					$mas_hinfo = explode(' ', $val);

					foreach ($mas_hinfo as $key1 => $val1) {
						if (!preg_match('/^["]{1}/i', $val1)) {
							$mas_hinfo[$key1] = '"' . trim($mas_hinfo[$key1]);
						}

						if (!preg_match('/["]{1}$/i', $val1)) {
							$mas_hinfo[$key1] = trim($mas_hinfo[$key1]) . '"';
						}
					}

					$val = trim(implode(' ', $mas_hinfo));
				}

				if ($value['type'] == 'TXT') {
					$val = preg_replace('/^["]{1}/i', '\\'"', preg_replace('/["]{1}$/i', '"\'', $val));
					$val = str_replace('-', '~~~', $val);
				}

				if ($value['type'] == 'HINFO') {
					$val = str_replace('"', '\\"', $val);
				}

				$this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --edit --zone ' . $zone . ' --name ' . $value['name'] . ' --line ' . ($key + 1) . ' --type ' . $value['type'] . ' --value ' . $val);
			}
		}

		foreach (array_reverse($file['bottom']) as $key => $value) {
			$val = implode(' ', $value['def']);

			if (!$value['type']) {
				$this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh --edit --zone ' . $zone . ' --line ' . ($value['id'] + 1) . ' --delete');
			}
		}

		$zonefile = implode('', $this->read_file_n('/var/named/named.' . $zone));
		$param['act'] = 'save_zone_to_file';
		$param['zone'] = $zone;
		$param['text'] = $zonefile;

		if ($needcluster == '1') {
			$this->bindserver_send_data_to_cluster($param);
		}

		$res['error'] = 0;
		$res['mess'] = $lang['msg_alert_ok'];
		$res['type'] = '';
		$res['data'] = '';
		$res['detail'] = $file['bottom'];
		return $res;
	}

	public function bindserver_editZone($zone)
	{
		if (!$this->check_value('domain', $zone)) {
			return false;
		}

		$zone = $this->strip_quotes_cmd($zone);
		return $this->sudo_ssh('cat /var/named/named.' . $zone);
	}

	public function bindserver_checkZone($zone)
	{
		if (!$this->check_value('domain', $zone)) {
			return false;
		}

		$zone = $this->strip_quotes_cmd($zone);
		$result = $this->sudo_ssh('ls /var/named/named.' . $zone);

		if ($result[0] == '/var/named/named.' . $zone) {
			return true;
		}

		return false;
	}

	public function bindserver_parseNamedString($str)
	{
		return 'cool';
	}

	public function bindserver_parsePerSymbol($str)
	{
		$s = '';
		$i = 0;

		while ($i < strlen($str)) {
			$s .= ORD($str[$i]) . ' ';
			++$i;
		}

		echo $s;
	}

	public function bindserver_parsePerChr9($str, $row)
	{
		global $lang;
		echo '<tr>';
		echo '<td>' . $row . '</td>';
		$temp = explode(CHR(9), $str);
		$res = array();
		$i = 0;

		while ($i < count($temp)) {
			$temp2 = explode(CHR(32), $temp[$i]);
			$k = 0;

			while ($k < count($temp2)) {
				$res[] = $temp2[$k];
				echo $this->bindserver_testPart($temp2[$k], $i) . ' ';
				++$k;
			}

			++$i;
		}

		if (8 < $row) {
			echo '<td class="remove"><button class="delete_record" onclick="delete_dns_record(this);">' . $lang['delete_record'] . '</button></td>';
		}

		echo '</tr>';
	}

	public function bindserver_testPart($part, $position)
	{
		$arr1 = array('$ORIGIN', '.', '$TTL', '(', ')', '', 'expire', 'serial', 'refresh', 'retry', 'minimum', 'IN', 'SOA');
		$arr2 = array('A', 'AAAA', 'MX', 'NS', 'CNAME', 'PTR', 'SRV', 'TXT');

		if ($part == ';') {
			return '';
		}

		if ($part == '') {
			if (1 < $position) {
				return '';
			}

			return '<td style="border:0px solid grey;"></td>';
		}

		if (in_array($part, $arr1)) {
			return '<td style="border:0px solid grey;">' . $part . '</td>';
		}

		if (in_array($part, $arr2)) {
			return $this->bindserver_returnSelect($part);
		}

		return $this->bindserver_returnInput($part);
	}

	public function bindserver_returnInput($param)
	{
		return '<td style="border:0px solid grey;"><input type="text" value="' . $param . '"></td>';
	}

	public function bindserver_returnSelect($param)
	{
		$arr = array('A', 'AAAA', 'CNAME', 'TXT', 'PTR', 'NS', 'MX', 'SRV');
		$result = '<td style="border:0px solid grey;"><select class="record_type2">';
		$i = 0;

		while ($i < count($arr)) {
			$result .= '<option value=\'' . $arr[$i] . '\' ';

			if ($param == $arr[$i]) {
				$result .= 'selected ';
			}

			$result .= '>' . $arr[$i] . '</option>';
			++$i;
		}

		$result .= '</select></td>';
		return $result;
	}

	public function bindserver_showZone($zone)
	{
		$puny = new idna_convert();

		if (!$this->check_value('domain', $zone)) {
			return false;
		}

		$arr = $this->bindserver_editZone($zone);
		$kkey = 'top';

		foreach ($arr as $key => $value) {
			$foo = preg_replace('|[\\s]+|s', ' ', $value);
			$foo1 = explode(' ', $foo);

			if (0 < substr_count($foo, '"')) {
				preg_match_all('~"(.*?)(?:"|$)|([^"]+)~', $foo, $m, PREG_SET_ORDER);
			}

			if ($foo1[0] == 'NS') {
				$foo1[2] = $foo1[1];
				$foo1[1] = $foo1[0];
				$foo1[0] = '';
			}

			if ($foo1[1] == 'NS') {
				$foo1[0] = '';
			}

			$str = '';

			if ($foo1[1] == 'TXT') {
				$i = 0;

				while ($i < count($foo1)) {
					if (($i == 0) || ($i == 1)) {
						continue;
					}

					$str .= $foo1[$i] . ' ';
					++$i;
				}

				$foo1[2] = trim($str);
			}

			$newarr[$kkey][$key] = $foo1;

			if (0 < substr_count($foo, ')')) {
				$kkey = 'bottom';
			}
		}

		$newarr['ttl'] = $newarr['top'][1][1];
		$newarr['zonename'] = $newarr['top'][2][0];
		$newarr['soa_ns'] = $newarr['top'][2][3];
		$newarr['email'] = $puny->decode($newarr['top'][2][4]);
		$newarr['serial'] = $newarr['top'][3][1];
		$newarr['refresh'] = $newarr['top'][4][1];
		$newarr['expire'] = $newarr['top'][6][1];
		$newarr['retry'] = $newarr['top'][5][1];
		$newarr['minimum'] = $newarr['top'][7][1];
		$newarr['zonename_decode'] = $puny->decode($newarr['top'][2][0]);
		unset($foo);

		foreach ($newarr['bottom'] as $key => $value) {
			$foo[$key]['zonename_decode'] = $puny->decode($value[0]);

			if ($value[1] == 'MX') {
				$value[3] = $puny->decode($value[3]);
			}

			$foo[$key]['type'] = $value[1];
			unset($value[0]);
			unset($value[1]);
			$foo[$key]['def'] = array_values($value);
		}

		$newarr['strings'] = $foo;
		return $newarr;
	}

	public function bindserver_showZone_old($zone)
	{
		$arr = $this->bindserver_editZone($zone);
		echo '<table id="zone_table" zone_name="' . $zone . '">';
		$i = 0;

		foreach ($arr as $key) {
			$this->bindserver_parsePerChr9($key, $i);
			++$i;
		}

		echo '</table';
	}

	public function bindserver_showZone_fromCluster($zone, $content)
	{
		$arr = explode('\\n', $content);
		echo '<table id="zone_table" zone_name="' . $zone . '">';
		$i = 0;

		foreach ($arr as $key) {
			$this->bindserver_parsePerChr9($key, $i);
			++$i;
		}

		echo '</table';
	}

	public function bindserver_saveZone($zone, $content)
	{
		return $this->sudo_ssh('echo \'' . $content . '\' > /var/named/named.' . $zone);
	}

	public function bindserver_getDefaultNS()
	{
		return implode("\n", $this->sudo_ssh($this::PATH_TO_SCRIPT . 'named.sh -dn list'));
	}

	public function bindserver_get_version()
	{
		$this->load_vars('config.cnf');
		return $this->module_vars;
	}

	public function get_status_install()
	{
		$out = $this->ssh('named -v 2> /dev/null');

		if ($out) {
			$status = true;
		}
		else {
			$status = false;
		}

		return $status;
	}

	public function bindserver_run($service, $comm)
	{
		if (!in_array($comm, $this->commands)) {
			return false;
		}

		if (!in_array($service, $this->services)) {
			return false;
		}

		switch ($comm) {
		case 'start':
		case 'stop':
		case 'restart':
			$result = $this->bindserver_comm_start($service, $comm);
			break;

		case 'install':
		case 'delete':
		case 'reinstall':
		case 'reload':
			$result = $this->bindserver_comm_install($service, $comm, 'result1');
			break;
		}

		return $result;
	}

	public function bindserver_comm_start($service, $act)
	{
		$out = $this->sudo_ssh('service ' . $service . ' ' . $act);
		return $out;
	}

	public function bindserver_comm_install($service, $act, $screen)
	{
		$stream[0]['comm'] = $this::PATH_TO_SCRIPT . $service . '.sh --' . $act;
		$stream[0]['test'] = 'Complete';
		$stream[0]['screen'] = 'result1';
		$stream[0]['array_start'] = array('one' => 'inprogress,#stream_id#', 'screen' => $screen);
		$stream[0]['array_succes'] = array('one' => 'success,#stream_id#');
		$stream[0]['array_unsucces'] = array('one' => 'unsuccess,#stream_id#', 'error' => '#error#');
		$out = $this->create_stream($stream);
		return 'ajax';
	}

	public function bindserver_ajax()
	{
		global $lang;
		$this->load_vars();
		$one = $this->module_vars['one'];
		$one = explode(',', $one);
		$result['stream_output'] = implode("\n", $this->read_stream($one[1]));
		$result['status'] = $one[0];

		if ($result['status'] == 'unsuccess') {
			$result['status_detail'] = '<br>' . $lang['unsuccess_text'] . ': ' . $this->module_vars['error'];
		}

		if ($result['status'] == 'success') {
			$result['status_detail'] = '<br>' . $lang['success_text'] . '.';
		}

		return $result;
	}

	public function bindserver_validate($type, $data)
	{
		if ($type == 'ipv4') {
			return $this->bindserver_validateIpV4($data);
		}

		if ($type == 'ipv6') {
			return $this->bindserver_validateIpV6($data);
		}

		if ($type == 'host') {
			return $this->bindserver_validateHost($data);
		}

		if ($type == 'string') {
			return $this->bindserver_validateString($data);
		}

		if ($type == 'string2') {
			return $this->bindserver_validateString2($data);
		}

		if ($type == 'ipv42') {
			return $this->bindserver_validateIpV42($data);
		}

		if ($type == 'ipv62') {
			return $this->bindserver_validateIpV62($data);
		}

		if ($type == 'number') {
			return $this->bindserver_validateNumber($data);
		}

		if ($type == 'email') {
			return $this->bindserver_validateEmail($data);
		}

		return false;
	}

	public function bindserver_validateEmail($data)
	{
		return preg_match('/^([a-zA-Z0-9_\\.\\-]+)@([a-zA-Z0-9_\\.\\-]+)\\.([a-zA-Z0-9\\.\\-]{2,20})$/', $data);
	}

	public function bindserver_validateIpV62($data)
	{
		return preg_match('/^([0-9a-f]{1,4}){1}:([0-9a-f]{0,4}:){1,6}[0-9a-f]{1,4}$/', $data);
	}

	public function bindserver_validateString($data)
	{
		if (strlen($data) == 0) {
			return false;
		}

		return true;
	}

	public function bindserver_validateString2($data)
	{
		return preg_match('/^[a-z0-9_]{1,50}$/', $data);
	}

	public function bindserver_validateNumber($data)
	{
		return preg_match('/^[0-9]{1,20}$/', $data);
	}

	public function bindserver_validateIpV4($data)
	{
		return preg_match('/^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.' . '(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.' . '(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.' . '(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)/', $data);
	}

	public function bindserver_validateIpV42($data)
	{
		return preg_match('/^[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}+$/', $data);
	}

	public function bindserver_validateIpV6($data)
	{
		return filter_var($data, FILTER_VALIDATE_IP);
	}

	public function bindserver_validateHost($data)
	{
		if (preg_match('/^([a-zA-Z0-9\\-]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9\\-])?\\.)+[a-zA-Z0-9\\-]{1,20}$/', $data) || (substr_count($data, '.') == 0)) {
			return 1;
		}

		return 0;
	}

	public function bindserver_get_cluster_table_smarty()
	{
		global $lang;
		$info_mass = $this->config_read('/etc/brainy/data/bindserver/main');
		$file = file_get_contents('/etc/brainy/data/bindserver/cluster.info');
		$result = array();
		$arr = explode("\n", $file);
		$arr = array_filter($arr);

		foreach ($arr as $key) {
			$cur_cluster_status = '';
			$cur_cluster_status_id = '';
			$temp = explode('|', $key);
			$temp[3] = trim($temp[3]);
			$temp[6] = intval(trim($temp[6]));
			$foo = $info_mass['two_' . $temp[5]];

			if ($foo) {
				$foo = explode(',', $foo);
				$cur_cluster_status = $foo[0];
				$cur_cluster_status_id = $foo[1];
			}

			$temp[] = $cur_cluster_status;
			$temp[] = $cur_cluster_status_id;
			$result[] = $temp;
		}

		return $result;
	}

	public function bindserver_get_sync_status()
	{
		$info_mass = $this->config_read('/etc/brainy/data/bindserver/main');
		$out = $this->bindserver_get_cluster_table_smarty();

		foreach ($out as $value) {
			$sid = $value[5];
		}

		return $result;
	}

	public function bindserver_generateToken()
	{
		$latin = array('Alea jacta est', 'Amicus Plato, sed magis amica est veritas', 'Carpe diem', 'Cogito, ergo sum', 'De mortuis aut bene, aut nihil', 'De gustibus non est disputandum', 'Dura lex, sed lex');
		return hash('sha256', str_shuffle($latin[mt_rand(0, count($latin) - 1)]));
	}

	public function bindserver_saveToken($token)
	{
		if ($GLOBALS['DEMO'] == 1) {
			global $lang;
			return $lang['common_demo_message'];
		}

		if (!$this->check_value('string', $token)) {
			return false;
		}

		$arr['token'] = $token;
		$this->set_data($arr, 'data');
	}

	public function bindserver_getToken()
	{
		$this->load_vars('data');
		return $this->module_vars['token'];
	}

	public function bindserver_send_request_to_cluster($ip, $token)
	{
		if ((!$this->check_value('ip', $ip) && $this->check_value('domain', $ip)) || ($this->check_value('ip', $ip) && !$this->check_value('domain', $ip))) {
			return false;
		}

		if (!$this->check_value('string', $token) || !$token) {
			return false;
		}

		$rowsClusters = preg_split('/\\r\\n|\\r|\\n/', file_get_contents('/etc/brainy/data/bindserver/cluster.info'));

		foreach ($rowsClusters as $curCluster) {
			$varExp = explode('|', $curCluster);

			if ($varExp[0] == $ip) {
				$typeClust = $varExp[4];
			}
		}

		if ($typeClust == 'cpanel') {
			$params['bind_key'] = $token;
			$params['bind_ip'] = $ip;
			$resCheckCpanel = $this->addToClusterCpanel($params, 1);

			if ($resCheckCpanel == 1) {
				$out['result'] = 1;
				$out['response'] = 'OK';
				return $out;
			}

			$out['result'] = 0;
			$out['response'] = 'Failed';
			$this->bindserver_add_attemp_to_cluster($ip);
			return $out;
		}

		if ($typeClust == 'cpanel') {
			$url = 'https://' . $ip . ':8000/scripts/bindcluster.php';
			$data = array('token' => $token);
			$curl = curl_init($url);
			curl_setopt($curl, CURLOPT_POST, true);
			curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 2);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
			$response = curl_exec($curl);
			curl_close($curl);

			if ($response) {
				return json_decode($response, true);
			}

			return $response;
		}
	}

	public function bindserver_send_data_to_cluster($param)
	{
		$data1 = $this->bindserver_get_cluster_enable();

		if (!$this->check_value('string', $param['act'])) {
			return false;
		}

		if (!$this->check_value('domain', $param['zone'])) {
			return false;
		}

		if (!$this->check_value('ip', $param['ip'])) {
			return false;
		}

		$rowsClusters = preg_split('/\\r\\n|\\r|\\n/', file_get_contents('/etc/brainy/data/bindserver/cluster.info'));

		if (is_array($data1)) {
			foreach ($data1 as $key => $value) {
				unset($data);

				foreach ($rowsClusters as $curCluster) {
					$varExp = explode('|', $curCluster);

					if ($varExp[0] == $key) {
						$typeClust = $varExp[4];
					}
				}

				if ($typeClust == 'cpanel') {
					$param['bind_key'] = $value;
					$param['bind_ip'] = $key;
					$param['domain'] = $param['zone'];
					$param['zone'] = $param['zone'];
					$param['text'] = trim($param['text']);
					$resCheckCpanel = $this->addToClusterCpanelTocpanel($param);

					return $resCheckCpanel;
				}

				if ($typeClust == 'brainy') {
					$data['token'] = $value;

					if (!$data['token']) {
						exit('TOKEN IS EMPTY');
					}

					$data['act'] = $param['act'];
					$data['zone'] = $param['zone'];
					$data['ip'] = $key;
					$data['text'] = trim($param['text']);

					if ($param['act'] == 'delete_btn') {
						$data['user'] = 'root';
					}

					$url = 'https://' . $key . ':8000/scripts/bindcluster.php';
					$curl = curl_init($url);
					curl_setopt($curl, CURLOPT_POST, true);
					curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
					curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
					curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
					curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 2);
					curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
					$response = curl_exec($curl);
					curl_close($curl);

					if ($response) {
						$result = json_decode($response, true);

						if ($result['success'] != 2) {
							$this->bindserver_add_attemp_to_cluster($data['ip']);
						}
					}
					else {
						$this->bindserver_add_attemp_to_cluster($data['ip']);
					}
				}
			}
		}
	}

	public function bindserver_send_data_to_cluster_new($ip, $act, $token, $sid = NULL, $typeClust = NULL)
	{
		if (!$token) {
			exit('TOKEN IS EMPTY');
		}

		$out['result'] = 0;
		$data['ip'] = $ip;
		$data['act'] = $act;
		$data['token'] = $token;
		$data['sid'] = $sid;
		$rowsClusters = preg_split('/\\r\\n|\\r|\\n/', file_get_contents('/etc/brainy/data/bindserver/cluster.info'));

		foreach ($rowsClusters as $curCluster) {
			$varExp = explode('|', $curCluster);

			if ($varExp[0] == $ip) {
				$typeClust = $varExp[4];
			}
		}

		if ($typeClust == 'cpanel') {
			$params['bind_key'] = $token;
			$params['bind_ip'] = $ip;
			$resCheckCpanel = $this->addToClusterCpanel($params, 1);

			if ($resCheckCpanel == 1) {
				$out['result'] = 1;
				$out['response'] = 'OK';
				return $out;
			}

			$out['result'] = 0;
			$out['response'] = 'Failed';
			$this->bindserver_add_attemp_to_cluster($data['ip']);
			return $out;
		}

		if ($typeClust == 'brainy') {
			$url = 'https://' . $data['ip'] . ':8000/scripts/bindcluster.php';
			$curl = curl_init($url);
			curl_setopt($curl, CURLOPT_POST, true);
			curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 2);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
			$response = curl_exec($curl);
			curl_close($curl);

			if ($response) {
				$result = json_decode($response, true);

				if ($result['success'] != 2) {
					$this->bindserver_add_attemp_to_cluster($data['ip']);
					$out['response'] = $result;
					$out['result'] = 0;
					return $out;
				}

				$out['result'] = 1;
				$out['response'] = $result;
				return $out;
			}

			$this->bindserver_add_attemp_to_cluster($data['ip']);
			$out['result'] = 0;
			$out['response'] = $response;
			return $out;
		}
	}

	public function bindserver_addCluster($params, $lang)
	{
		global $lang;
		$res['message'] = '';
		$res['error'] = '0';

		if ($GLOBALS['DEMO'] == 1) {
			$res['message'] = $lang['common_demo_message'];
			$res['error'] = '123';
			return $res;
		}

		if (!$this->bindserver_validate('ipv4', $params['bind_ip'])) {
			$res['message'] = $lang['bindserver_invalid_ip'];
			$res['error'] = '101';
			return $res;
		}

		if (!$this->bindserver_validate('host', $params['bind_host'])) {
			$res['message'] = $lang['bindserver_invalid_hostname'];
			$res['error'] = '101';
			return $res;
		}

		if (!$this->bindserver_validate('string', $params['bind_key']) || !$params['bind_key']) {
			$res['message'] = $lang['bindserver_invalid_key'];
			$res['error'] = '101';
			return $res;
		}

		$outm = $this->bindserver_get_cluster_table_smarty();

		foreach ($outm as $value) {
			$res['message'] = $lang['bindserver_ip_already'];
			$res['error'] = '101';

			return $res;
		}

		$params['bindserver_uniqid'] = md5($params['bind_ip'] + round(0, 2));

		if ($params['bind_type_server'] == 'cpanel') {
			$res_conn = $this->addToClusterCpanel($params, 1);

			if ($res_conn != 1) {
				$res['message'] = $lang['bindserver_no_connect_server'];
				$res['error'] = '106';
				return $res;
			}

			file_put_contents('/etc/brainy/data/bindserver/cluster.info', implode('|', $params) . '|1|0' . "\n", FILE_APPEND);
			$res['params'] = implode('|', $params);
			return $res;
		}

		if ($params['bind_type_server'] == 'brainy') {
			$outcheck = $this->bindserver_send_data_to_cluster_new($params['bind_ip'], $act, $params['bind_key'], $params['bindserver_uniqid'], $params['bind_type_server']);

			if ($outcheck['result'] != '1') {
				$res['message'] = $lang['bindserver_no_connect_server'];
				$res['error'] = '106';
				return $res;
			}

			file_put_contents('/etc/brainy/data/bindserver/cluster.info', implode('|', $params) . '|1|0' . "\n", FILE_APPEND);
			$res['params'] = implode('|', $params);
			return $res;
		}
	}

	public function bindserver_deleteCluster($cluster)
	{
		if (!$this->check_value('ip', $cluster)) {
			return false;
		}

		$file = file_get_contents('/etc/brainy/data/bindserver/cluster.info');
		$arr = explode("\n", $file);
		$arr = array_filter($arr);
		$result = '';

		foreach ($arr as $key) {
			$temp = explode('|', $key);

			if ($temp[0] != $cluster) {
				$result .= implode('|', $temp) . "\n";
			}
		}

		file_put_contents('/etc/brainy/data/bindserver/cluster.info', $result);
		return $cluster;
	}

	public function bindserver_saveCluster($params)
	{
		global $lang;
		$res['message'] = $lang['bindserver_sucessfully_edited'];
		$res['error'] = '0';
		$params['attemps'] = 0;
		$params['id'] = $params['id'];
		$params['enable'] = (int) $params['enable'];

		if (!$params['id']) {
			$res['message'] = $lang['bindserver_invalid_id'];
			$res['error'] = '101';
			return $res;
		}

		if (!$this->bindserver_validate('ipv4', $params['ip'])) {
			$res['message'] = $lang['bindserver_invalid_ip'];
			$res['error'] = '102';
			return $res;
		}

		if (!$this->bindserver_validate('host', $params['host'])) {
			$res['message'] = $lang['bindserver_invalid_host'];
			$res['error'] = '103';
			return $res;
		}

		if (!$this->bindserver_validate('string', $params['key']) || !$params['key']) {
			$res['message'] = $lang['bindserver_invalid_key'];
			$res['error'] = '104';
			return $res;
		}

		if (!$this->bindserver_validate('string', $params['typeserv']) || !$params['typeserv']) {
			$res['message'] = $lang['bindserver_cluster_type_server_type_failed'];
			$res['error'] = '105';
			return $res;
		}

		$outcheck = $this->bindserver_send_data_to_cluster_new($params['ip'], $act, $params['key'], $params['id']);

		if ($outcheck['result'] != '1') {
			$res['message'] = $lang['bindserver_no_connect_server'];
			$res['error'] = '106';
			return $res;
		}

		$line = $params['ip'] . '|' . $params['host'] . '|' . $params['key'] . '|' . $params['type'] . '|' . $params['typeserv'] . '|' . $params['id'] . '|' . $params['enable'] . '|' . $params['attemps'];
		$file = file_get_contents('/etc/brainy/data/bindserver/cluster.info');
		$arr = explode("\n", $file);
		$arr = array_filter($arr);
		$result = '';

		foreach ($arr as $key) {
			$temp = explode('|', $key);

			if ($temp[0] != $params['ip']) {
				$result .= implode('|', $temp) . "\n";
			}
			else {
				$result .= $line . "\n";
			}
		}

		file_put_contents('/etc/brainy/data/bindserver/cluster.info', $result);
		return $res;
	}

	public function bindserver_attempsCluster($cluster)
	{
		if (!$this->check_value('ip', $cluster)) {
			return false;
		}

		$file = file_get_contents('/etc/brainy/data/bindserver/cluster.info');
		$arr = explode("\n", $file);
		$arr = array_filter($arr);
		$result = '';

		foreach ($arr as $key) {
			$temp = explode('|', $key);
			$temp[6] = $cluster[$temp[0]]['enable'];
			$temp[7] = $cluster[$temp[0]]['attemps'];
			$result .= implode('|', $temp) . "\n";
		}

		file_put_contents('/etc/brainy/data/bindserver/cluster.info', $result);
		return 'cool!';
	}

	public function bindserver_add_attemp_to_cluster($cluster)
	{
		$file = file_get_contents('/etc/brainy/data/bindserver/cluster.info');
		$arr = explode("\n", $file);
		$arr = array_filter($arr);
		$result = '';

		foreach ($arr as $key) {
			$temp = explode('|', $key);

			if ($temp[0] == $cluster) {
				++$temp[7];

				if (5 < $temp[7]) {
					$temp[7] = 0;
					$temp[6] = 0;
				}
			}

			$result .= implode('|', $temp) . "\n";
		}

		file_put_contents('/etc/brainy/data/bindserver/cluster.info', $result);
	}

	public function bindserver_get_cluster()
	{
		$file = file_get_contents('/etc/brainy/data/bindserver/cluster.info');
		$arr = explode("\n", $file);
		$arr = array_filter($arr);
		$result = '';

		foreach ($arr as $key) {
			$temp = explode('|', $key);

			if (($temp[3] == 'two') && ($temp[6] == '1')) {
				$result[$temp[0]] = $temp[2];
			}
		}

		return $result;
	}

	public function stop_synchronize($sid, $originalk)
	{
		if (!$this->check_value('string', $sid)) {
			return false;
		}

		if (!$this->check_value('string', $originalk)) {
			return false;
		}

		$mass = $this->config_read('/etc/brainy/data/bindserver/main');
		$var = $mass['two_' . $sid];
		$vars = explode(',', $var);
		$vars[0] = 'success';
		$var = implode(',', $vars);
		$mass['two_' . $sid] = $var;
		$this->kill_stream($vars[1]);
		$this->kill_stream($originalk);
		$this->config_save('/etc/brainy/data/bindserver/main', $mass);
		return 1;
	}

	public function bindserver_cluster_server_onff($sid, $onoff, $typeserv)
	{
		global $lang;

		if (!$this->check_value('string', $sid)) {
			return false;
		}

		if (!$this->check_value('number', $onoff)) {
			return false;
		}

		$file = $this->read_file_n('/etc/brainy/data/bindserver/cluster.info');

		foreach ($file as $kkey => $value) {
			$foo = explode('|', $value);

			if ($sid == $foo[5]) {
				$ip = $foo[0];
				$key = $foo[2];

				if (!$key) {
					exit('There is no KEY');
				}

				if ($onoff == 1) {
					if ($typeserv == 'brainy') {
						$json = $this->bindserver_send_data_to_cluster_new($ip, '', $key, $sid);
					}

					if ($typeserv == 'cpanel') {
						$params['bind_key'] = $key;
						$params['bind_ip'] = $ip;
						$res_conn = $this->addToClusterCpanel($params, 1);

						if ($res_conn != 1) {
							$onoff = 1;
							$json['result'] = -1;
						}
						else {
							$onoff = 1;
							$json['result'] = 1;
						}
					}
				}
				else {
					$json['result'] = 1;
				}

				switch ($onoff) {
				case '0':
					$foo[6] = 0;
					$file[$kkey] = implode('|', $foo);
					$res['message'] = $lang['bindserver_successfuly_done'];
					$res['error'] = 0;
					break;

				case '1':
					if ($json['result'] == 1) {
						$foo[6] = 1;
						$file[$kkey] = implode('|', $foo);
						$res['message'] = $lang['bindserver_successfuly_done'];
						$res['error'] = 0;
					}
					else {
						$res['message'] = $lang['bindserver_no_connect'];
						$res['error'] = 2;
					}

					break;
				}
			}
			else {
				break;
			}
		}

		$this->write_file(implode('', $file), '/etc/brainy/data/bindserver/cluster.info', 'r');
		return $res;
	}

	public function bindserver_get_cluster_enable()
	{
		$file = file_get_contents('/etc/brainy/data/bindserver/cluster.info');
		$arr = explode("\n", $file);
		$arr = array_filter($arr);
		$result = '';

		foreach ($arr as $key) {
			$temp = explode('|', $key);

			if ($temp[6] == '1') {
				$result[$temp[0]] = $temp[2];
			}
		}

		return $result;
	}

	public function bindserver_named_options()
	{
		$result = $this->sudo_ssh('ls /etc/named/named.conf.options');

		if ($result[0] == '/etc/named/named.conf.options') {
			return true;
		}

		$result = $this->sudo_ssh('cp /etc/brainy/ssh/named/named.conf.options /etc/named/named.conf.options');
		return $result;
	}

	public function bindserver_synchronize_cluster($type, $cluster, $token, $server_id = NULL, $typeserv)
	{
		if (!$server_id) {
			return 0;
		}

		if (!$token) {
			return 0;
		}

		$type_claster = array('cluster', 'server', '');

		if (!in_array($type, $type_claster)) {
			return false;
		}

		if (!$this->check_value('ip', $cluster)) {
			return false;
		}

		if (!$this->check_value('string', $token)) {
			return false;
		}

		if (!$this->check_value('string', $server_id)) {
			return false;
		}

		$stream[0]['comm'] = '/etc/brainy/src/compiled/php5/bin/php -f /etc/brainy/scripts/bindsync.php type=' . $type . ' cluster=' . $cluster . ' token=' . $token . ' typeserv=' . $typeserv;
		$stream[0]['test'] = 'Complete';
		$stream[0]['array_start'] = array('two_' . $server_id => 'inprogress,#stream_id#', 'two_screen_' . $server_id => 'result1');
		$stream[0]['array_succes'] = array('two_' . $server_id => 'success,#stream_id#');
		$stream[0]['array_unsucces'] = array('two_' . $server_id => 'unsuccess,#stream_id#', 'two_error_' . $server_id => '#error#');
		$out['strid'] = $this->create_stream($stream);
		$out['result'] = 'success';
		$out['server_id'] = $server_id;
		return $out;
	}

	public function bindserver_ajax2()
	{
		global $lang;
		$this->load_vars();
		$two = $this->module_vars['two'];
		$two = explode(',', $two);
		$result['stream_output'] = implode("\n", $this->read_stream($two[1]));
		$result['status'] = $two[0];

		if ($result['status'] == 'unsuccess') {
			$result['status_detail'] = '<br>' . $lang['unsuccess_text'] . ': ' . $this->module_vars['two_error'];
		}

		if ($result['status'] == 'success') {
			$result['status_detail'] = '<br>' . $lang['success_text'] . '.';
		}

		return $result;
	}

	public function rebuild_rndc()
	{
		$out = $this->sudo_ssh('/etc/brainy/ssh/named/named.sh --defns list');

		foreach ($out as $key => $value) {
			$foo = explode(':', $value);
			$ns[$key]['name'] = $foo[0];
			$ns[$key]['ip'] = $foo[1];
			$nsdom = $foo[0];
			$nsredunpart = strstr($nsdom, '.', 1);
			$nssfull[] = $nsdom;
			$nsmainpart = str_replace($nsredunpart . '.', '', $nsdom);
			$nss[] = $nsmainpart;
		}

		$dir_named = '/var/named/';
		$this->ssh('rndc reload');
		$res = scandir($dir_named);

		foreach ($res as $elem) {
			if (is_file($dir_named . $elem) && ($elem != '.') && ($elem != '..') && (1 < substr_count($elem, '.'))) {
				$named_zone = str_replace('named.', '', $elem);
				$domPartNS = 0;

				foreach ($nssfull as $curNS) {
					if (stripos($curNS, '.' . $named_zone) !== false) {
						$domPartNS = 1;
					}
				}

				if (in_array($named_zone, $nssfull, 1) || ($domPartNS == 1)) {
					foreach ($ns as $kkey => $vvalue) {
						$out1 = $this->sudo_ssh('cat ' . $dir_named . $elem);
						$cc = 0;

						foreach ($out1 as $vvvalue) {
							++$cc;
							break;
						}

						if ($cc == 0) {
							$this->sudo_ssh('/etc/brainy/ssh/named/named.sh --edit --zone ' . $named_zone . ' --line new --type A --name ' . $vvalue['name'] . '. --value ' . $vvalue['ip']);
						}
					}
				}

				$this->ssh('rndc addzone ' . $named_zone . '. \'{type master; file "/var/named/named.' . $named_zone . '";};\'');
			}
		}

		$this->ssh('rndc reload');
	}

	public function calc_in_arr($part, $zones)
	{
		$count = 0;

		foreach ($zones as $zone) {
			if (stripos($zone, $part) !== false) {
				++$count;
			}
		}

		return $count;
	}

	public function bindserver_addzones($username, $domains_edit = NULL)
	{
		$zone_real_exist = array();

		foreach ($domains_edit as $old_zone_user) {
			$this->bindserver_deleteZone($old_zone_user, $username);
		}

		$file = '/etc/brainy/api/aaaaa223';
		$domain = $domains_edit[0];
		$zone = $domain;
		$vhost = parse_ini_file($GLOBALS['DATA_VHOSTS'] . $domain . '.conf');
		$ip = $vhost['ip'];
		$username = $vhost['user'];
		$arr_addr = preg_split('/[\\s,;]/', $vhost['aliases']);
		error_reporting(0);

		if ($this->bindserver_checkUserZone($domain, $username) == false) {
			$this->bindserver_addZone($username, $domain, $ip);
			$this->bindserver_addAddrToZone($domain, '@', 'MX', '10 mail');
			$this->bindserver_addAddrToZone($domain, 'mail', 'A', $ip);
		}

		foreach ($arr_addr as $key1 => $alias1) {
			$addr = str_replace('.' . $domain, '', $alias1);

			if ($addr != $alias1) {
				if (preg_match('/\\*/i', $alias1)) {
					$this->bindserver_addZone($username, $domain, $ip);
					$this->bindserver_addAddrToZone($domain, $alias1 . '.', 'A', $ip);
					$this->bindserver_addAddrToZone($domain, $alias1 . '.', 'MX', '10 mail');
					$this->bindserver_addAddrToZone($domain, 'mail' . $alias1 . '.', 'A', $ip);
				}
				else {
					$this->bindserver_addAddrToZone($domain, $addr, 'A', $ip);
				}
			}
			else if ($this->bindserver_checkUserZone($alias1, $username) == false) {
				if (preg_match('/\\*/i', $alias1)) {
					$this->bindserver_addZone($username, $domain, $ip);
					$this->bindserver_addAddrToZone($domain, $alias1 . '.', 'A', $ip);
					$this->bindserver_addAddrToZone($domain, $alias1 . '.', 'MX', '10 mail');
					$this->bindserver_addAddrToZone($domain, 'mail' . $alias1 . '.', 'A', $ip);
				}
				else {
					$this->bindserver_addZone($username, $alias1, $ip);
					$this->bindserver_addAddrToZone($alias1, '@', 'MX', '10 mail');
					$this->bindserver_addAddrToZone($alias1, 'mail', 'A', $ip);
				}
			}
		}

		return 1;

		foreach (array() as $key1 => $alias1) {
			$addr = str_replace('.' . $domain, '', $alias1);

			if (preg_match('/\\*/i', $alias1)) {
				$this->bindserver_addZone($username, $domain, $ip);
				$this->bindserver_addAddrToZone($domain, $alias1 . '.', 'A', $ip);
				$this->bindserver_addAddrToZone($domain, $alias1 . '.', 'MX', '10 mail');
				$this->bindserver_addAddrToZone($domain, 'mail' . $alias1 . '.', 'A', $ip);
			}
			else {
				$this->bindserver_addZone($username, $domain, $ip);
				$this->bindserver_addAddrToZone($domain, $addr, 'A', $ip);
				$this->bindserver_addAddrToZone($alias1, '@', 'MX', '10 mail');
				$this->bindserver_addAddrToZone($alias1, 'mail', 'A', $ip);
			}
		}
	}

	public function str_replace_first_end($search, $replace, $subject)
	{
		$pos = strrpos($subject, $search);

		if ($pos !== false) {
			return substr_replace($subject, $replace, $pos, strlen($search));
		}

		return $subject;
	}

	public function updateZoneBrainy($txt, $domain)
	{
		$this->ssh('echo \'' . $txt . '\' > /var/named/named.' . $domain);
		$this->ssh('chmown -R root.named /var/named/named.' . $domain);
		$this->ssh('chmod 770 /var/named/named.' . $domain);
	}

	public function editZoneBrainyFromCpanel($curZoneBrainy, $resDumpCpanelZone, $curZoneCpanel)
	{
		$resDumpBrainyZone_rows = $this->bindserver_editZone($curZoneBrainy);
		$resDumpBrainyZone = $this->dumpBrainyZone($resDumpBrainyZone_rows);
		$qArrEq = array();
		$qArrEdit = array();

		foreach ($resDumpCpanelZone['data']['zone'][0]['record'] as $curZoneRowCpanel) {
			$qEq = 0;
			$qEdit = 0;
			$typeField = strtolower($curZoneRowCpanel['type']);

			foreach ($resDumpBrainyZone[$typeField]['zonename'] as $keyB => $valB) {
				if ($curZoneRowCpanel['type'] == 'NS') {
					if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && ($curZoneRowCpanel['nsdname'] == $resDumpBrainyZone[$typeField]['value'][$keyB])) {
						$qArrEq[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
						$qEq = 1;
						break;
					}
				}

				if ($curZoneRowCpanel['type'] == 'A') {
					if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && ($curZoneRowCpanel['address'] == $resDumpBrainyZone[$typeField]['value'][$keyB])) {
						$qArrEq[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
						$qEq = 1;
						break;
					}
				}

				if ($curZoneRowCpanel['type'] == 'MX') {
					if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && ($curZoneRowCpanel['preference'] == $resDumpBrainyZone[$typeField]['preference'][$keyB]) && ($curZoneRowCpanel['exchange'] == $resDumpBrainyZone[$typeField]['exchange'][$keyB])) {
						$qArrEq[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
						$qEq = 1;
						break;
					}
				}

				if ($curZoneRowCpanel['type'] == 'CNAME') {
					if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && ($curZoneRowCpanel['cname'] == $resDumpBrainyZone[$typeField]['cname'][$keyB])) {
						$qArrEq[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
						$qEq = 1;
						break;
					}
				}

				if ($curZoneRowCpanel['type'] == 'TXT') {
					if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && ($curZoneRowCpanel['txtdata'] == $resDumpBrainyZone[$typeField]['txtdata'][$keyB])) {
						$qArrEq[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
						$qEq = 1;
						break;
					}
				}

				if ($curZoneRowCpanel['type'] == 'AAAA') {
					if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && ($curZoneRowCpanel['address'] == $resDumpBrainyZone[$typeField]['address'][$keyB])) {
						$qArrEq[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
						$qEq = 1;
						break;
					}
				}

				if ($curZoneRowCpanel['type'] == 'PTR') {
					if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && (($curZoneRowCpanel['ptrdname'] . '.') == $resDumpBrainyZone[$typeField]['ptrdname'][$keyB])) {
						$qArrEq[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
						$qEq = 1;
						break;
					}
				}

				if ($curZoneRowCpanel['type'] == 'SRV') {
					if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && ($curZoneRowCpanel['priority'] == $resDumpBrainyZone[$typeField]['priority'][$keyB]) && ($curZoneRowCpanel['weight'] == $resDumpBrainyZone[$typeField]['weight'][$keyB]) && ($curZoneRowCpanel['port'] == $resDumpBrainyZone[$typeField]['port'][$keyB]) && (($curZoneRowCpanel['target'] . '.') == $resDumpBrainyZone[$typeField]['target'][$keyB])) {
						$qArrEq[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
						$qEq = 1;
						break;
					}
				}

				if ($curZoneRowCpanel['type'] == 'AFSDB') {
					if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && ($curZoneRowCpanel['subtype'] == $resDumpBrainyZone[$typeField]['subtype'][$keyB]) && (($curZoneRowCpanel['hostname'] . '.') == $resDumpBrainyZone[$typeField]['hostname'][$keyB])) {
						$qArrEq[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
						$qEq = 1;
						break;
					}
				}

				if ($curZoneRowCpanel['type'] == 'DNAME') {
					if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && ($curZoneRowCpanel['dname'] == $resDumpBrainyZone[$typeField]['dname'][$keyB])) {
						$qArrEq[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
						$qEq = 1;
						break;
					}
				}

				if ($curZoneRowCpanel['type'] == 'DS') {
					if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && ($curZoneRowCpanel['keytag'] == $resDumpBrainyZone[$typeField]['keyname'][$keyB]) && ($curZoneRowCpanel['algorithm'] == $resDumpBrainyZone[$typeField]['algorithm'][$keyB]) && ($curZoneRowCpanel['digtype'] == $resDumpBrainyZone[$typeField]['digitype'][$keyB]) && ($curZoneRowCpanel['digest'] == $resDumpBrainyZone[$typeField]['digest'][$keyB])) {
						$qArrEq[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
						$qEq = 1;
						break;
					}
				}

				if ($curZoneRowCpanel['type'] == 'HINFO') {
					if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && ($curZoneRowCpanel['cpu'] == $resDumpBrainyZone[$typeField]['cpu'][$keyB]) && ($curZoneRowCpanel['os'] == $resDumpBrainyZone[$typeField]['os'][$keyB])) {
						$qArrEq[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
						$qEq = 1;
						break;
					}
				}

				if ($curZoneRowCpanel['type'] == 'RP') {
					if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && (($curZoneRowCpanel['mbox'] . '.') == $resDumpBrainyZone[$typeField]['mbox'][$keyB]) && (($curZoneRowCpanel['txtdname'] . '.') == $resDumpBrainyZone[$typeField]['txtdname'][$keyB])) {
						$qArrEq[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
						$qEq = 1;
						break;
					}
				}
			}

			if ($qEq == 0) {
				foreach ($resDumpBrainyZone[$typeField]['zonename'] as $keyB => $valB) {
					if ($curZoneRowCpanel['type'] == 'NS') {
						if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && !in_array($resDumpBrainyZone[$typeField]['line'][$keyB], $qArrEdit)) {
							$qArrEdit[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
							$qEdit = 1;
							$partToReplace = preg_split('/\\sNS\\s/', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]])[1];
							$updateBrainyFieldZone = preg_replace('/' . $partToReplace . '/', $curZoneRowCpanel['nsdname'] . '.', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]]);
							$resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]] = $updateBrainyFieldZone;
							break;
						}
					}

					if ($curZoneRowCpanel['type'] == 'A') {
						if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && !in_array($resDumpBrainyZone[$typeField]['line'][$keyB], $qArrEdit)) {
							$qArrEdit[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
							$qEdit = 1;
							$partToReplace = preg_split('/\\sA\\s/', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]])[1];
							$updateBrainyFieldZone = preg_replace('/' . $partToReplace . '/', $curZoneRowCpanel['address'], $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]]);
							$resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]] = $updateBrainyFieldZone;
							break;
						}
					}

					if ($curZoneRowCpanel['type'] == 'MX') {
						if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && !in_array($resDumpBrainyZone[$typeField]['line'][$keyB], $qArrEdit)) {
							$qArrEdit[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
							$qEdit = 1;
							$partToReplace = preg_split('/\\sMX\\s/', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]])[1];
							$updateBrainyFieldZone = preg_replace('/' . $partToReplace . '/', $curZoneRowCpanel['preference'] . "\t" . $curZoneRowCpanel['exchange'] . '.', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]]);
							$resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]] = $updateBrainyFieldZone;
							break;
						}
					}

					if ($curZoneRowCpanel['type'] == 'CNAME') {
						if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && !in_array($resDumpBrainyZone[$typeField]['line'][$keyB], $qArrEdit)) {
							$qArrEdit[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
							$qEdit = 1;
							$partToReplace = preg_split('/\\sCNAME\\s/', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]])[1];
							$updateBrainyFieldZone = preg_replace('/' . $partToReplace . '/', $curZoneRowCpanel['cname'] . '.', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]]);
							$resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]] = $updateBrainyFieldZone;
							break;
						}
					}

					if ($curZoneRowCpanel['type'] == 'TXT') {
						if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && !in_array($resDumpBrainyZone[$typeField]['line'][$keyB], $qArrEdit)) {
							$qArrEdit[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
							$qEdit = 1;
							$partToReplace = preg_split('/\\sTXT\\s/', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]])[1];
							$updateBrainyFieldZone = preg_replace('/' . $partToReplace . '/', '"' . $curZoneRowCpanel['txtdata'] . '"', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]]);
							$resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]] = $updateBrainyFieldZone;
							break;
						}
					}

					if ($curZoneRowCpanel['type'] == 'AAAA') {
						if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && !in_array($resDumpBrainyZone[$typeField]['line'][$keyB], $qArrEdit)) {
							$qArrEdit[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
							$qEdit = 1;
							$partToReplace = preg_split('/\\sAAAA\\s/', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]])[1];
							$updateBrainyFieldZone = preg_replace('/' . $partToReplace . '/', $curZoneRowCpanel['address'], $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]]);
							$resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]] = $updateBrainyFieldZone;
							break;
						}
					}

					if ($curZoneRowCpanel['type'] == 'PTR') {
						if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && !in_array($resDumpBrainyZone[$typeField]['line'][$keyB], $qArrEdit)) {
							$qArrEdit[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
							$qEdit = 1;
							$partToReplace = preg_split('/\\sPTR\\s/', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]])[1];
							$updateBrainyFieldZone = preg_replace('/' . $partToReplace . '/', $curZoneRowCpanel['ptrdname'] . '.', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]]);
							$resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]] = $updateBrainyFieldZone;
							break;
						}
					}

					if ($curZoneRowCpanel['type'] == 'SRV') {
						if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && !in_array($resDumpBrainyZone[$typeField]['line'][$keyB], $qArrEdit)) {
							$qArrEdit[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
							$qEdit = 1;
							$partToReplace = preg_split('/\\sSRV\\s/', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]])[1];
							$updateBrainyFieldZone = preg_replace('/' . $partToReplace . '/', $curZoneRowCpanel['priority'] . "\t" . $curZoneRowCpanel['weight'] . "\t" . $curZoneRowCpanel['port'] . "\t" . $curZoneRowCpanel['target'] . '.', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]]);
							$resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]] = $updateBrainyFieldZone;
							break;
						}
					}

					if ($curZoneRowCpanel['type'] == 'AFSDB') {
						if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && !in_array($resDumpBrainyZone[$typeField]['line'][$keyB], $qArrEdit)) {
							$qArrEdit[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
							$qEdit = 1;
							$partToReplace = preg_split('/\\sAFSDB\\s/', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]])[1];
							$updateBrainyFieldZone = preg_replace('/' . $partToReplace . '/', $curZoneRowCpanel['subtype'] . "\t" . $curZoneRowCpanel['hostname'] . '.', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]]);
							$resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]] = $updateBrainyFieldZone;
							break;
						}
					}

					if ($curZoneRowCpanel['type'] == 'DNAME') {
						if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && !in_array($resDumpBrainyZone[$typeField]['line'][$keyB], $qArrEdit)) {
							$qArrEdit[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
							$qEdit = 1;
							$partToReplace = preg_split('/\\sDNAME\\s/', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]])[1];
							$updateBrainyFieldZone = preg_replace('/' . $partToReplace . '/', $curZoneRowCpanel['dname'] . '.', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]]);
							$resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]] = $updateBrainyFieldZone;
							break;
						}
					}

					if ($curZoneRowCpanel['type'] == 'DS') {
						if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && !in_array($resDumpBrainyZone[$typeField]['line'][$keyB], $qArrEdit)) {
							$qArrEdit[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
							$qEdit = 1;
							$partToReplace = preg_split('/\\sDS\\s/', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]])[1];
							$updateBrainyFieldZone = preg_replace('/' . $partToReplace . '/', $curZoneRowCpanel['keytag'] . "\t" . $curZoneRowCpanel['algorithm'] . "\t" . $curZoneRowCpanel['digtype'] . "\t" . $curZoneRowCpanel['digest'], $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]]);
							$resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]] = $updateBrainyFieldZone;
							break;
						}
					}

					if ($curZoneRowCpanel['type'] == 'HINFO') {
						if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && !in_array($resDumpBrainyZone[$typeField]['line'][$keyB], $qArrEdit)) {
							$qArrEdit[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
							$qEdit = 1;
							$partToReplace = preg_split('/\\sHINFO\\s/', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]])[1];
							$updateBrainyFieldZone = preg_replace('/' . $partToReplace . '/', $curZoneRowCpanel['cpu'] . "\t" . $curZoneRowCpanel['os'], $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]]);
							$resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]] = $updateBrainyFieldZone;
							break;
						}
					}

					if ($curZoneRowCpanel['type'] == 'RP') {
						if (($curZoneRowCpanel['name'] == $resDumpBrainyZone[$typeField]['zonename'][$keyB] . '.') && !in_array($resDumpBrainyZone[$typeField]['line'][$keyB], $qArrEdit)) {
							$qArrEdit[] = $resDumpBrainyZone[$typeField]['line'][$keyB];
							$qEdit = 1;
							$partToReplace = preg_split('/\\sRP\\s/', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]])[1];
							$updateBrainyFieldZone = preg_replace('/' . $partToReplace . '/', $curZoneRowCpanel['mbox'] . '.' . "\t" . $curZoneRowCpanel['txtdname'] . '.', $resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]]);
							$resDumpBrainyZone_rows[$resDumpBrainyZone[$typeField]['line'][$keyB]] = $updateBrainyFieldZone;
							break;
						}
					}
				}
			}

			if (($qEq == 0) && ($qEdit == 0)) {
				if ($curZoneRowCpanel['type'] == 'NS') {
					$resDumpBrainyZone_rows[] = $curZoneRowCpanel['name'] . "\t\t\t" . 'NS' . "\t" . $curZoneRowCpanel['nsdname'] . '.';
					$qArrEdit[] = count($resDumpBrainyZone_rows) - 1;
				}

				if ($curZoneRowCpanel['type'] == 'A') {
					$resDumpBrainyZone_rows[] = $curZoneRowCpanel['name'] . "\t\t\t" . 'A' . "\t" . $curZoneRowCpanel['address'];
					$qArrEdit[] = count($resDumpBrainyZone_rows) - 1;
				}

				if ($curZoneRowCpanel['type'] == 'MX') {
					$resDumpBrainyZone_rows[] = $curZoneRowCpanel['name'] . "\t\t\t" . 'MX' . "\t" . $curZoneRowCpanel['preference'] . "\t" . $curZoneRowCpanel['exchange'] . '.';
					$qArrEdit[] = count($resDumpBrainyZone_rows) - 1;
				}

				if ($curZoneRowCpanel['type'] == 'CNAME') {
					$resDumpBrainyZone_rows[] = $curZoneRowCpanel['name'] . "\t\t\t" . 'CNAME' . "\t" . $curZoneRowCpanel['cname'] . '.';
					$qArrEdit[] = count($resDumpBrainyZone_rows) - 1;
				}

				if ($curZoneRowCpanel['type'] == 'TXT') {
					$resDumpBrainyZone_rows[] = $curZoneRowCpanel['name'] . "\t\t\t" . 'TXT' . "\t" . '"' . $curZoneRowCpanel['txtdata'] . '"';
					$qArrEdit[] = count($resDumpBrainyZone_rows) - 1;
				}

				if ($curZoneRowCpanel['type'] == 'AAAA') {
					$resDumpBrainyZone_rows[] = $curZoneRowCpanel['name'] . "\t\t\t" . 'AAAA' . "\t" . $curZoneRowCpanel['address'];
					$qArrEdit[] = count($resDumpBrainyZone_rows) - 1;
				}

				if ($curZoneRowCpanel['type'] == 'PTR') {
					$resDumpBrainyZone_rows[] = $curZoneRowCpanel['name'] . "\t\t\t" . 'PTR' . "\t" . $curZoneRowCpanel['ptrdname'] . '.';
					$qArrEdit[] = count($resDumpBrainyZone_rows) - 1;
				}

				if ($curZoneRowCpanel['type'] == 'SRV') {
					$resDumpBrainyZone_rows[] = $curZoneRowCpanel['name'] . "\t\t\t" . 'SRV' . "\t" . $curZoneRowCpanel['priority'] . "\t" . $curZoneRowCpanel['weight'] . "\t" . $curZoneRowCpanel['port'] . "\t" . $curZoneRowCpanel['target'] . '.';
					$qArrEdit[] = count($resDumpBrainyZone_rows) - 1;
				}

				if ($curZoneRowCpanel['type'] == 'AFSDB') {
					$resDumpBrainyZone_rows[] = $curZoneRowCpanel['name'] . "\t\t\t" . 'AFSDB' . "\t" . $curZoneRowCpanel['subtype'] . "\t" . $curZoneRowCpanel['hostname'] . '.';
					$qArrEdit[] = count($resDumpBrainyZone_rows) - 1;
				}

				if ($curZoneRowCpanel['type'] == 'DNAME') {
					$resDumpBrainyZone_rows[] = $curZoneRowCpanel['name'] . "\t\t\t" . 'DNAME' . "\t" . $curZoneRowCpanel['dname'] . '.';
					$qArrEdit[] = count($resDumpBrainyZone_rows) - 1;
				}

				if ($curZoneRowCpanel['type'] == 'DS') {
					$resDumpBrainyZone_rows[] = $curZoneRowCpanel['name'] . "\t\t\t" . 'DS' . "\t" . $curZoneRowCpanel['keytag'] . "\t" . $curZoneRowCpanel['algorithm'] . "\t" . $curZoneRowCpanel['digtype'] . "\t" . $curZoneRowCpanel['digest'];
					$qArrEdit[] = count($resDumpBrainyZone_rows) - 1;
				}

				if ($curZoneRowCpanel['type'] == 'HINFO') {
					$resDumpBrainyZone_rows[] = $curZoneRowCpanel['name'] . "\t\t\t" . 'HINFO' . "\t" . $curZoneRowCpanel['cpu'] . "\t" . $curZoneRowCpanel['os'];
					$qArrEdit[] = count($resDumpBrainyZone_rows) - 1;
				}

				if ($curZoneRowCpanel['type'] == 'RP') {
					$resDumpBrainyZone_rows[] = $curZoneRowCpanel['name'] . "\t\t\t" . 'RP' . "\t" . $curZoneRowCpanel['mbox'] . '.' . "\t" . $curZoneRowCpanel['txtdname'] . '.';
					$qArrEdit[] = count($resDumpBrainyZone_rows) - 1;
				}
			}
		}

		if (0 < count($qArrEdit)) {
			foreach ($resDumpBrainyZone_rows as $keyNum => $keyVal) {
				if (preg_match('/\\sNS\\s/', $keyVal) || preg_match('/\\sA\\s/', $keyVal) || preg_match('/\\sMX\\s/', $keyVal) || preg_match('/\\sCNAME\\s/', $keyVal) || preg_match('/\\sTXT\\s/', $keyVal) || preg_match('/\\sAAAA\\s/', $keyVal) || preg_match('/\\sPTR\\s/', $keyVal) || preg_match('/\\sSRV\\s/', $keyVal) || preg_match('/\\sAFSDB\\s/', $keyVal) || preg_match('/\\sDNAME\\s/', $keyVal) || preg_match('/\\sDS\\s/', $keyVal) || preg_match('/\\sHINFO\\s/', $keyVal) || preg_match('/\\sRP\\s/', $keyVal)) {
					if (!in_array($keyNum, $qArrEq) && !in_array($keyNum, $qArrEdit)) {
						unset($resDumpBrainyZone_rows[$keyNum]);
					}
				}
			}

			$this->updateZoneBrainy(implode("\n", $resDumpBrainyZone_rows), $curZoneCpanel['domain']);
		}
	}

	public function addToClusterCpanelFromcpanel($param)
	{
		$user = 'root';
		$token = $param['bind_key'];
		$query = 'https://' . $param['bind_ip'] . ':2087/json-api/listzones?api.version=1';
		$resListZoneCpanel = $this->queryToCPanel($param, $query);
		$resListZoneCpanel = json_decode($resListZoneCpanel, 1);
		$resListZoneBrainy = $param['listzones'];
		$qExistBrInCpanel = 0;

		foreach ($resListZoneBrainy as $nameUser => $key_user) {
			foreach ($key_user as $curZoneBrainy) {
				$qExistBrInCpanel = 0;

				foreach ($resListZoneCpanel['data']['zone'] as $curZoneCpanel) {
					$qExistBrInCpanel = 1;
					break;
				}

				if ($qExistBrInCpanel == 0) {
					$this->bindserver_deleteZone($curZoneBrainy, $nameUser);
					echo 'Delete from Brainy ' . $nameUser . ' ' . $curZoneBrainy . "\n";
				}
			}
		}

		echo 'Start add and edit zones' . "\n";
		$countCpanelZone = count($resListZoneCpanel['data']['zone']);
		$ii = 0;

		foreach ($resListZoneCpanel['data']['zone'] as $curZoneCpanel) {
			$qZoneExistBrainy = 0;
			$query = 'https://' . $param['bind_ip'] . ':2087/json-api/dumpzone?api.version=1&domain=' . $curZoneCpanel['domain'];
			$resDumpCpanelZone = $this->queryToCPanel($param, $query);
			$resDumpCpanelZone = iconv('UTF-8', 'UTF-8//IGNORE', utf8_encode($resDumpCpanelZone));
			$resDumpCpanelZone = json_decode($resDumpCpanelZone, 1);
			echo $curZoneCpanel['domain'] . ' ' . round(($ii / $countCpanelZone) * 100, 4) . '%' . "\n";
			++$ii;

			foreach ($resListZoneBrainy as $key_user) {
				foreach ($key_user as $curZoneBrainy) {
					$qZoneExistBrainy = 1;
					$this->editZoneBrainyFromCpanel($curZoneBrainy, $resDumpCpanelZone, $curZoneCpanel);
					break;
				}
			}

			if ($qZoneExistBrainy == 0) {
				$ipZoneAdd = '';

				foreach ($resDumpCpanelZone['data']['zone'][0]['record'] as $curZoneRowCpanel4Add) {
					if (($curZoneRowCpanel4Add['type'] == 'A') && ($curZoneRowCpanel4Add['name'] == $curZoneCpanel['domain'] . '.')) {
						$ipZoneAdd = $curZoneRowCpanel4Add['address'];
						break;
					}
				}

				$this->bindserver_addZone('root', $curZoneCpanel['domain'], $ipZoneAdd, 0);
				$this->editZoneBrainyFromCpanel($curZoneCpanel['domain'], $resDumpCpanelZone, $curZoneCpanel);
			}
		}

		$this->rebuild_rndc();
	}

	public function dumpBrainyZone($arr_data)
	{
		foreach ($arr_data as $numRow => $curRow) {
			if (stripos($curRow, 'TTL') !== false) {
				$ttl = preg_split('/[\\s,;]/', $curRow)[1];
				continue;
			}

			$in_soa = 0;
			if ((stripos($curRow, 'IN SOA') !== false) || ($in_soa == 1)) {
				if ($in_soa == 0) {
					$exp = preg_split('/[\\s,;]/', $curRow, 3);
					$zonename = $this->str_replace_first_end('.', '', $exp[0]);
					$in_soa = 1;
					continue;
				}

				if (stripos($curRow, ')') !== false) {
					$in_soa = 0;
				}

				$listDoDNS['class']['zonename'] = $zonename;
				continue;
			}

			if (preg_match('/\\sNS\\s/', $curRow)) {
				$nsVal_exp = array_values(array_filter(preg_split('/[\\s,;]/', $curRow)));
				$nsVal = $this->str_replace_first_end('.', '', $nsVal_exp[1]);

				if (2 < count($nsVal_exp)) {
					$zonename = $this->str_replace_first_end('.', '', $nsVal_exp[0]);
					$nsVal = $this->str_replace_first_end('.', '', $nsVal_exp[2]);
				}

				$listDoDNS['ns']['zonename'][] = $zonename . '.';
				$listDoDNS['ns']['value'][] = $nsVal;
				$listDoDNS['ns']['line'][] = $numRow;
			}

			if (preg_match('/\\sA\\s/', $curRow)) {
				$valExp = array_values(array_filter(preg_split('/[\\s,;]/', $curRow)));
				$val = $valExp[2];
				$zonename = $valExp[0];
				$listDoDNS['a']['zonename'][] = $zonename;
				$listDoDNS['a']['value'][] = $val;
				$listDoDNS['a']['line'][] = $numRow;
			}

			if (preg_match('/\\sMX\\s/', $curRow)) {
				$valExp = array_values(array_diff(preg_split('/[\\s,;]/', $curRow), array('/\\s/', ' ', '', NULL, false)));
				$zonename = $valExp[0];
				$listDoDNS['mx']['zonename'][] = $zonename;
				$listDoDNS['mx']['preference'][] = $valExp[2];
				$listDoDNS['mx']['exchange'][] = $nsVal = $this->str_replace_first_end('.', '', $valExp[3]);
				$listDoDNS['mx']['line'][] = $numRow;
			}

			if (preg_match('/\\sTXT\\s/', $curRow)) {
				$valExp = array_values(array_filter(preg_split('/[\\s,;]/', $curRow)));
				$valExp2 = explode('"', $curRow);
				$zonename = $valExp[0];
				$listDoDNS['txt']['zonename'][] = $zonename;
				$listDoDNS['txt']['txtdata'][] = $valExp2[1];
				$listDoDNS['txt']['line'][] = $numRow;
			}

			if (preg_match('/\\sAAAA\\s/', $curRow)) {
				$valExp = array_values(array_filter(preg_split('/[\\s,;]/', $curRow)));
				$zonename = $valExp[0];
				$listDoDNS['aaaa']['zonename'][] = $zonename;
				$listDoDNS['aaaa']['address'][] = $valExp[2];
				$listDoDNS['aaaa']['line'][] = $numRow;
			}

			if (preg_match('/\\sAFSDB\\s/', $curRow)) {
				$valExp = array_values(array_filter(preg_split('/[\\s,;]/', $curRow)));
				$zonename = $valExp[0];
				$listDoDNS['afsdb']['zonename'][] = $zonename;
				$listDoDNS['afsdb']['subtype'][] = $valExp[2];
				$listDoDNS['afsdb']['hostname'][] = $valExp[3];
				$listDoDNS['afsdb']['line'][] = $numRow;
			}

			if (preg_match('/\\sCNAME\\s/', $curRow)) {
				$valExp = array_values(array_filter(preg_split('/[\\s,;]/', $curRow)));
				$zonename = $valExp[0];
				$listDoDNS['cname']['zonename'][] = $zonename;
				$listDoDNS['cname']['cname'][] = $this->str_replace_first_end('.', '', $valExp[2]);
				$listDoDNS['cname']['line'][] = $numRow;
			}

			if (preg_match('/\\sDNAME\\s/', $curRow)) {
				$valExp = array_values(array_filter(preg_split('/[\\s,;]/', $curRow)));
				$zonename = $valExp[0];
				$listDoDNS['dname']['zonename'][] = $zonename;
				$listDoDNS['dname']['dname'][] = $this->str_replace_first_end('.', '', $valExp[2]);
				$listDoDNS['dname']['line'][] = $numRow;
			}

			if (preg_match('/\\sDS\\s/', $curRow)) {
				$valExp = array_values(array_filter(preg_split('/[\\s,;]/', $curRow)));
				$zonename = $valExp[0];
				$listDoDNS['ds']['zonename'][] = $zonename;
				$listDoDNS['ds']['keyname'][] = $valExp[2];
				$listDoDNS['ds']['algorithm'][] = $valExp[3];
				$listDoDNS['ds']['digitype'][] = $valExp[4];
				$listDoDNS['ds']['digest'][] = $valExp[5];
				$listDoDNS['ds']['line'][] = $numRow;
			}

			if (preg_match('/\\sHINFO\\s/', $curRow)) {
				$valExp = array_values(array_filter(preg_split('/[\\s,;]/', $curRow)));
				$zonename = $valExp[0];
				$listDoDNS['hinfo']['zonename'][] = $zonename;
				$listDoDNS['hinfo']['cpu'][] = str_replace('"', '"', $valExp[2]);
				$listDoDNS['hinfo']['os'][] = str_replace('"', '"', $valExp[3]);
				$listDoDNS['hinfo']['line'][] = $numRow;
			}

			if (preg_match('/\\sPTR\\s/', $curRow)) {
				$valExp = array_values(array_filter(preg_split('/[\\s,;]/', $curRow)));
				$zonename = $valExp[0];
				$listDoDNS['ptr']['zonename'][] = $zonename;
				$listDoDNS['ptr']['ptrdname'][] = $valExp[2];
				$listDoDNS['ptr']['line'][] = $numRow;
			}

			if (preg_match('/\\sRP\\s/', $curRow)) {
				$valExp = array_values(array_filter(preg_split('/[\\s,;]/', $curRow)));
				$zonename = $valExp[0];
				$listDoDNS['rp']['zonename'][] = $zonename;
				$listDoDNS['rp']['mbox'][] = str_replace('@', '.', $valExp[2]);
				$listDoDNS['rp']['txtdname'][] = $valExp[3];
				$listDoDNS['rp']['line'][] = $numRow;
			}

			if (preg_match('/\\sSRV\\s/', $curRow)) {
				$valExp = array_values(array_diff(preg_split('/[\\s,;]/', $curRow), array('/\\s/', ' ', '', NULL, false)));
				$zonename = $this->str_replace_first_end('.', '', $valExp[0]);
				$listDoDNS['srv']['zonename'][] = $zonename;
				$listDoDNS['srv']['priority'][] = $valExp[2];
				$listDoDNS['srv']['weight'][] = $valExp[3];
				$listDoDNS['srv']['port'][] = $valExp[4];
				$listDoDNS['srv']['target'][] = $valExp[5];
				$listDoDNS['srv']['line'][] = $numRow;
			}
		}

		return $listDoDNS;
	}

	public function addToClusterCpanelTocpanel($param)
	{
		$user = 'root';
		$token = $param['bind_key'];
		$dnszonefile = $param['text'];
		$query = 'https://' . $param['bind_ip'] . ':2087/json-api/addzonerecord?api.version=1&domain=' . $param['domain'];
		$arr_data = preg_split('/\\r\\n|\\r|\\n/', $dnszonefile);
		$ttl = 0;
		$in_soa = '';
		$class_zone = '';
		$typerec = '';
		$listDoDNS = array();
		$listDoDNS = $this->dumpBrainyZone($arr_data);
		$qEditAutoAddOrExistDNSZone = 1;

		if ($param['act'] == 'delete_btn') {
			$query = 'https://' . $param['bind_ip'] . ':2087/json-api/killdns?api.version=1&domain=' . $param['domain'];
			$resDump = $this->queryToCPanel($param, $query);
			return 1;
		}

		$query = 'https://' . $param['bind_ip'] . ':2087/json-api/dumpzone?api.version=1&domain=' . $param['domain'];
		$resDump = $this->queryToCPanel($param, $query);
		$timelog = date('d.m.Y_H_i_s');
		$resDecDump = json_decode($resDump, 1);
		file_put_contents('/etc/brainy/data/streams/bind_' . $timelog, print_r($resDecDump, 1) . ' R1DumpDNSStart' . "\n", FILE_APPEND);

		if (stripos($resDecDump['metadata']['reason'], 'Zone does not exist') !== false) {
			foreach ($listDoDNS['a']['zonename'] as $keyInd => $curARecord) {
				$query = 'https://' . $param['bind_ip'] . ':2087/json-api/adddns?api.version=1&domain=' . $param['domain'] . '&ip=' . $listDoDNS['a']['value'][$keyInd];
				file_put_contents('/etc/brainy/data/streams/bind_' . $timelog, $query . ' Q1addDNS' . "\n", FILE_APPEND);
				$res = $this->queryToCPanel($param, $query);
				$res_decode = json_decode($res, 1);
				file_put_contents('/etc/brainy/data/streams/bind_' . $timelog, $res . ' R1DumpDNS' . "\n", FILE_APPEND);
				$reason = $res_decode['metadata']['reason'];
				$query = 'https://' . $param['bind_ip'] . ':2087/json-api/dumpzone?api.version=1&domain=' . $param['domain'];
				$resDump = $this->queryToCPanel($param, $query);
				$timelog = date('d.m.Y_H_i_s');
				$resDecDump = json_decode($resDump, 1);
				file_put_contents('/etc/brainy/data/streams/bind_' . $timelog, print_r($resDecDump, 1) . ' R1DumpDNSAfterAdd' . "\n", FILE_APPEND);

				if ($res_decode['metadata']['result'] == 0) {
				}

				break;
			}
		}

		if ($qEditAutoAddOrExistDNSZone == 1) {
			$arrAllRecForDelComm = array();
			$curFieldZone = 'srv';
			$arrTypeOper = array();
			$arrEditLine = array();
			$arrDoLine = array();

			foreach ($resDecDump['data']['zone'][0]['record'] as $curRec) {
				if ($curRec['type'] != strtoupper($curFieldZone)) {
					continue;
				}

				$q_exist_eq = 0;
				$q_exist = 0;

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['priority'] == $listDoDNS[$curFieldZone]['priority'][$keyInd]) && ($curRec['weight'] == $listDoDNS[$curFieldZone]['weight'][$keyInd]) && ($curRec['port'] == $listDoDNS[$curFieldZone]['port'][$keyInd]) && ($curRec['target'] == $listDoDNS[$curFieldZone]['target'][$keyInd]) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '.' . $param['domain'] . '.')) {
						$arrTypeOper['q_exist_eq'][] = $keyInd;
						$arrEditLine[] = $curRec['Line'];
						$arrDoLine[] = $keyInd;
						$q_exist_eq = 1;
						continue;
					}
				}

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '.' . $param['domain'] . '.') {
						$editLine = $curRec['Line'];

						if (!in_array($editLine, $arrEditLine) && !in_array($keyInd, $arrDoLine)) {
							$arrEditLine[] = $editLine;
							$arrDoLine[] = $keyInd;
							$arrTypeOper['q_exist'][] = $keyInd;
							$q_exist = 1;
							$query = 'https://' . $param['bind_ip'] . ':2087/json-api/editzonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $editLine . '&name=' . $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '&class=IN&ttl=' . $curRec['ttl'] . '&type=' . strtoupper($curFieldZone) . '&priority=' . $listDoDNS[$curFieldZone]['priority'][$keyInd] . '&weight=' . $listDoDNS[$curFieldZone]['weight'][$keyInd] . '&port=' . $listDoDNS[$curFieldZone]['port'][$keyInd] . '&target=' . $listDoDNS[$curFieldZone]['target'][$keyInd];
							$res = $this->queryToCPanel($param, $query);
							continue;
						}
					}
				}

				if (($q_exist == 0) && ($q_exist_eq == 0)) {
					$delLine = $curRec['Line'];
					$arrAllRecForDelComm[$delLine] = 'https://' . $param['bind_ip'] . ':2087/json-api/removezonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $delLine;
				}
			}

			foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
				if (!in_array($keyInd, $arrTypeOper['q_exist']) && !in_array($keyInd, $arrTypeOper['q_exist_eq'])) {
					$query = 'https://' . $param['bind_ip'] . ':2087/json-api/addzonerecord?api.version=1&domain=' . $param['domain'] . '&name=' . $curRecordDo . '&class=IN' . '&ttl=' . $ttl . '&type=' . strtoupper($curFieldZone) . '&priority=' . $listDoDNS[$curFieldZone]['priority'][$keyInd] . '&weight=' . $listDoDNS[$curFieldZone]['weight'][$keyInd] . '&port=' . $listDoDNS[$curFieldZone]['port'][$keyInd] . '&target=' . $listDoDNS[$curFieldZone]['target'][$keyInd];
					$res = $this->queryToCPanel($param, $query);
				}
			}

			$curFieldZone = 'rp';
			$arrTypeOper = array();
			$arrEditLine = array();
			$arrDoLine = array();

			foreach ($resDecDump['data']['zone'][0]['record'] as $curRec) {
				if ($curRec['type'] != strtoupper($curFieldZone)) {
					continue;
				}

				$q_exist_eq = 0;
				$q_exist = 0;

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['mbox'] == $listDoDNS[$curFieldZone]['mbox'][$keyInd]) && ($curRec['txtdname'] == $listDoDNS[$curFieldZone]['txtdname'][$keyInd]) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '.' . $param['domain'] . '.')) {
						$arrTypeOper['q_exist_eq'][] = $keyInd;
						$arrEditLine[] = $curRec['Line'];
						$arrDoLine[] = $keyInd;
						$q_exist_eq = 1;
						continue;
					}
				}

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '.' . $param['domain'] . '.') {
						$editLine = $curRec['Line'];

						if (!in_array($editLine, $arrEditLine) && !in_array($keyInd, $arrDoLine)) {
							$arrEditLine[] = $editLine;
							$arrDoLine[] = $keyInd;
							$arrTypeOper['q_exist'][] = $keyInd;
							$q_exist = 1;
							$query = 'https://' . $param['bind_ip'] . ':2087/json-api/editzonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $editLine . '&name=' . $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '&class=IN&ttl=' . $curRec['ttl'] . '&type=' . strtoupper($curFieldZone) . '&mbox=' . urlencode($listDoDNS[$curFieldZone]['mbox'][$keyInd]) . '&txtdname=' . urlencode($listDoDNS[$curFieldZone]['txtdname'][$keyInd]);
							$res = $this->queryToCPanel($param, $query);
							continue;
						}
					}
				}

				if (($q_exist == 0) && ($q_exist_eq == 0)) {
					$delLine = $curRec['Line'];
					$arrAllRecForDelComm[$delLine] = 'https://' . $param['bind_ip'] . ':2087/json-api/removezonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $delLine;
				}
			}

			foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
				if (!in_array($keyInd, $arrTypeOper['q_exist']) && !in_array($keyInd, $arrTypeOper['q_exist_eq'])) {
					$query = 'https://' . $param['bind_ip'] . ':2087/json-api/addzonerecord?api.version=1&domain=' . $param['domain'] . '&name=' . $curRecordDo . '&class=IN' . '&ttl=' . $ttl . '&type=' . strtoupper($curFieldZone) . '&mbox=' . $listDoDNS[$curFieldZone]['mbox'][$keyInd] . '&txtdname=' . $listDoDNS[$curFieldZone]['txtdname'][$keyInd];
					$res = $this->queryToCPanel($param, $query);
				}
			}

			$curFieldZone = 'ptr';
			$arrTypeOper = array();
			$arrEditLine = array();
			$arrDoLine = array();

			foreach ($resDecDump['data']['zone'][0]['record'] as $curRec) {
				if ($curRec['type'] != strtoupper($curFieldZone)) {
					continue;
				}

				$q_exist_eq = 0;
				$q_exist = 0;

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['ptrdname'] == $listDoDNS[$curFieldZone]['ptrdname'][$keyInd]) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '.' . $param['domain'] . '.')) {
						$arrTypeOper['q_exist_eq'][] = $keyInd;
						$arrEditLine[] = $curRec['Line'];
						$arrDoLine[] = $keyInd;
						$q_exist_eq = 1;
						continue;
					}
				}

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '.' . $param['domain'] . '.') {
						$editLine = $curRec['Line'];

						if (!in_array($editLine, $arrEditLine) && !in_array($keyInd, $arrDoLine)) {
							$arrEditLine[] = $editLine;
							$arrDoLine[] = $keyInd;
							$arrTypeOper['q_exist'][] = $keyInd;
							$q_exist = 1;
							$query = 'https://' . $param['bind_ip'] . ':2087/json-api/editzonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $editLine . '&name=' . $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '&class=IN&ttl=' . $curRec['ttl'] . '&type=' . strtoupper($curFieldZone) . '&ptrdname=' . urlencode($listDoDNS[$curFieldZone]['ptrdname'][$keyInd]);
							$res = $this->queryToCPanel($param, $query);
							continue;
						}
					}
				}

				if (($q_exist == 0) && ($q_exist_eq == 0)) {
					$delLine = $curRec['Line'];
					$arrAllRecForDelComm[$delLine] = 'https://' . $param['bind_ip'] . ':2087/json-api/removezonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $delLine;
				}
			}

			foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
				if (!in_array($keyInd, $arrTypeOper['q_exist']) && !in_array($keyInd, $arrTypeOper['q_exist_eq'])) {
					$query = 'https://' . $param['bind_ip'] . ':2087/json-api/addzonerecord?api.version=1&domain=' . $param['domain'] . '&name=' . $curRecordDo . '&class=IN' . '&ttl=' . $ttl . '&type=' . strtoupper($curFieldZone) . '&ptrdname=' . $listDoDNS[$curFieldZone]['ptrdname'][$keyInd];
					$res = $this->queryToCPanel($param, $query);
				}
			}

			$curFieldZone = 'hinfo';
			$arrTypeOper = array();
			$arrEditLine = array();
			$arrDoLine = array();

			foreach ($resDecDump['data']['zone'][0]['record'] as $curRec) {
				if ($curRec['type'] != strtoupper($curFieldZone)) {
					continue;
				}

				$q_exist_eq = 0;
				$q_exist = 0;

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['cpu'] == $listDoDNS[$curFieldZone]['cpu'][$keyInd]) && ($curRec['os'] == $listDoDNS[$curFieldZone]['os'][$keyInd]) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '.' . $param['domain'] . '.')) {
						$arrTypeOper['q_exist_eq'][] = $keyInd;
						$arrEditLine[] = $curRec['Line'];
						$arrDoLine[] = $keyInd;
						$q_exist_eq = 1;
						continue;
					}
				}

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '.' . $param['domain'] . '.') {
						$editLine = $curRec['Line'];

						if (!in_array($editLine, $arrEditLine) && !in_array($keyInd, $arrDoLine)) {
							$arrEditLine[] = $editLine;
							$arrDoLine[] = $keyInd;
							$arrTypeOper['q_exist'][] = $keyInd;
							$q_exist = 1;
							$query = 'https://' . $param['bind_ip'] . ':2087/json-api/editzonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $editLine . '&name=' . $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '&class=IN&ttl=' . $curRec['ttl'] . '&type=' . strtoupper($curFieldZone) . '&cpu=' . urlencode($listDoDNS[$curFieldZone]['cpu'][$keyInd]) . '&os=' . urlencode($listDoDNS[$curFieldZone]['os'][$keyInd]) . '&unencoded=0';
							$res = $this->queryToCPanel($param, $query);
							continue;
						}
					}
				}

				if (($q_exist == 0) && ($q_exist_eq == 0)) {
					$delLine = $curRec['Line'];
					$arrAllRecForDelComm[$delLine] = 'https://' . $param['bind_ip'] . ':2087/json-api/removezonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $delLine;
				}
			}

			foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
				if (!in_array($keyInd, $arrTypeOper['q_exist']) && !in_array($keyInd, $arrTypeOper['q_exist_eq'])) {
					$query = 'https://' . $param['bind_ip'] . ':2087/json-api/addzonerecord?api.version=1&domain=' . $param['domain'] . '&name=' . $curRecordDo . '&class=IN' . '&ttl=' . $ttl . '&type=' . strtoupper($curFieldZone) . '&cpu=' . urlencode($listDoDNS[$curFieldZone]['cpu'][$keyInd]) . '&os=' . urlencode($listDoDNS[$curFieldZone]['os'][$keyInd]) . '&unencoded=1';
					$res = $this->queryToCPanel($param, $query);
				}
			}

			$curFieldZone = 'ds';
			$arrTypeOper = array();
			$arrEditLine = array();
			$arrDoLine = array();

			foreach ($resDecDump['data']['zone'][0]['record'] as $curRec) {
				if ($curRec['type'] != strtoupper($curFieldZone)) {
					continue;
				}

				$q_exist_eq = 0;
				$q_exist = 0;

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['keyname'] == $listDoDNS[$curFieldZone]['keyname'][$keyInd]) && ($curRec['algorithm'] == $listDoDNS[$curFieldZone]['algorithm'][$keyInd]) && ($curRec['digitype'] == $listDoDNS[$curFieldZone]['digitype'][$keyInd]) && ($curRec['digest'] == $listDoDNS[$curFieldZone]['digest'][$keyInd]) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '.' . $param['domain'] . '.')) {
						$arrTypeOper['q_exist_eq'][] = $keyInd;
						$arrEditLine[] = $curRec['Line'];
						$arrDoLine[] = $keyInd;
						$q_exist_eq = 1;
						continue;
					}
				}

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '.' . $param['domain'] . '.') {
						$editLine = $curRec['Line'];

						if (!in_array($editLine, $arrEditLine) && !in_array($keyInd, $arrDoLine)) {
							$arrEditLine[] = $editLine;
							$arrDoLine[] = $keyInd;
							$arrTypeOper['q_exist'][] = $keyInd;
							$q_exist = 1;
							$query = 'https://' . $param['bind_ip'] . ':2087/json-api/editzonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $editLine . '&name=' . $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '&class=IN&ttl=' . $curRec['ttl'] . '&type=' . strtoupper($curFieldZone) . '&keyname=' . $listDoDNS[$curFieldZone]['keyname'][$keyInd] . '&algorithm=' . $listDoDNS[$curFieldZone]['algorithm'][$keyInd] . '&digitype=' . $listDoDNS[$curFieldZone]['digitype'][$keyInd] . '&digest=' . $listDoDNS[$curFieldZone]['digest'][$keyInd];
							$res = $this->queryToCPanel($param, $query);
							continue;
						}
					}
				}

				if (($q_exist == 0) && ($q_exist_eq == 0)) {
					$delLine = $curRec['Line'];
					$arrAllRecForDelComm[$delLine] = 'https://' . $param['bind_ip'] . ':2087/json-api/removezonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $delLine;
				}
			}

			foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
				if (!in_array($keyInd, $arrTypeOper['q_exist']) && !in_array($keyInd, $arrTypeOper['q_exist_eq'])) {
					$query = 'https://' . $param['bind_ip'] . ':2087/json-api/addzonerecord?api.version=1&domain=' . $param['domain'] . '&name=' . $curRecordDo . '&class=IN' . '&ttl=' . $ttl . '&type=' . strtoupper($curFieldZone) . '&keyname=' . $listDoDNS[$curFieldZone]['keyname'][$keyInd] . '&algorithm=' . $listDoDNS[$curFieldZone]['algorithm'][$keyInd] . '&digitype=' . $listDoDNS[$curFieldZone]['digitype'][$keyInd] . '&digest=' . $listDoDNS[$curFieldZone]['digest'][$keyInd];
					$res = $this->queryToCPanel($param, $query);
				}
			}

			$arrTypeOper = array();
			$arrEditLine = array();
			$arrDoLine = array();

			foreach ($resDecDump['data']['zone'][0]['record'] as $curRec) {
				$q_exist_eq = 0;
				$q_exist = 0;

				foreach ($listDoDNS['ns']['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['type'] == 'NS') && ($curRec['nsdname'] == $listDoDNS['ns']['value'][$keyInd]) && ($curRec['name'] == $listDoDNS['ns']['zonename'][$keyInd])) {
						$arrTypeOper['q_exist_eq'][] = $keyInd;
						$arrEditLine[] = $curRec['Line'];
						$arrDoLine[] = $keyInd;
						$q_exist_eq = 1;
						file_put_contents('/etc/brainy/data/streams/bind_' . $timelog, $keyInd . ' ---EqNS' . "\n", FILE_APPEND);
						continue;
					}
				}

				foreach ($listDoDNS['ns']['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['type'] == 'NS') && ($curRec['name'] == $listDoDNS['ns']['zonename'][$keyInd])) {
						$editLine = $curRec['Line'];

						if (!in_array($editLine, $arrEditLine) && !in_array($keyInd, $arrDoLine)) {
							$arrEditLine[] = $editLine;
							$arrDoLine[] = $keyInd;
							$arrTypeOper['q_exist'][] = $keyInd;
							$q_exist = 1;
							$query = 'https://' . $param['bind_ip'] . ':2087/json-api/editzonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $editLine . '&name=' . $listDoDNS['ns']['zonename'][$keyInd] . '&class=IN&ttl=' . $curRec['ttl'] . '&type=NS&nsdname=' . $listDoDNS['ns']['value'][$keyInd];
							file_put_contents('/etc/brainy/data/streams/bind_' . $timelog, $query . ' ---EditNS' . "\n", FILE_APPEND);
							$res = $this->queryToCPanel($param, $query);
							continue;
						}
					}
				}

				if (($q_exist == 0) && ($q_exist_eq == 0) && ($curRec['type'] == 'NS')) {
					$delLine = $curRec['Line'];
					$arrAllRecForDelComm[$delLine] = 'https://' . $param['bind_ip'] . ':2087/json-api/removezonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $delLine;
					file_put_contents('/etc/brainy/data/streams/bind_' . $timelog, print_r($arrAllRecForDelComm, 1) . ' ---DelNS' . "\n", FILE_APPEND);
				}
			}

			foreach ($listDoDNS['ns']['zonename'] as $keyInd => $curRecordDo) {
				if (!in_array($keyInd, $arrTypeOper['q_exist']) && !in_array($keyInd, $arrTypeOper['q_exist_eq'])) {
					$query = 'https://' . $param['bind_ip'] . ':2087/json-api/addzonerecord?api.version=1&domain=' . $param['domain'] . '&name=' . $curRecordDo . '&class=IN' . '&ttl=' . $ttl . '&type=NS&nsdname=' . $listDoDNS['ns']['value'][$keyInd];
					file_put_contents('/etc/brainy/data/streams/bind_' . $timelog, $query . ' ---AddNS' . "\n", FILE_APPEND);
					$res = $this->queryToCPanel($param, $query);
				}
			}

			$arrTypeOper = array();
			$arrEditLine = array();
			$arrDoLine = array();

			foreach ($resDecDump['data']['zone'][0]['record'] as $curRec) {
				$q_exist_eq = 0;
				$q_exist = 0;

				foreach ($listDoDNS['a']['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['type'] == 'A') && ($curRec['address'] == $listDoDNS['a']['value'][$keyInd]) && ($curRec['name'] == $listDoDNS['a']['zonename'][$keyInd])) {
						$arrTypeOper['q_exist_eq'][] = $keyInd;
						$arrEditLine[] = $curRec['Line'];
						$arrDoLine[] = $keyInd;
						$q_exist_eq = 1;
						continue;
					}
				}

				foreach ($listDoDNS['a']['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['type'] == 'A') && ($curRec['name'] == $listDoDNS['a']['zonename'][$keyInd])) {
						$editLine = $curRec['Line'];

						if (!in_array($editLine, $arrEditLine) && !in_array($keyInd, $arrDoLine)) {
							$arrEditLine[] = $editLine;
							$arrDoLine[] = $keyInd;
							$arrTypeOper['q_exist'][] = $keyInd;
							$q_exist = 1;
							$query = 'https://' . $param['bind_ip'] . ':2087/json-api/editzonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $editLine . '&name=' . $listDoDNS['a']['zonename'][$keyInd] . '&class=IN&ttl=' . $curRec['ttl'] . '&type=A&address=' . $listDoDNS['a']['value'][$keyInd];
							$res = $this->queryToCPanel($param, $query);
							continue;
						}
					}
				}

				if (($q_exist == 0) && ($q_exist_eq == 0) && ($curRec['type'] == 'A')) {
					$delLine = $curRec['Line'];
					$arrAllRecForDelComm[$delLine] = 'https://' . $param['bind_ip'] . ':2087/json-api/removezonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $delLine;
				}
			}

			foreach ($listDoDNS['a']['zonename'] as $keyInd => $curRecordDo) {
				if (!in_array($keyInd, $arrTypeOper['q_exist']) && !in_array($keyInd, $arrTypeOper['q_exist_eq'])) {
					$query = 'https://' . $param['bind_ip'] . ':2087/json-api/addzonerecord?api.version=1&domain=' . $param['domain'] . '&name=' . $curRecordDo . '&class=IN' . '&ttl=' . $ttl . '&type=A&address=' . $listDoDNS['a']['value'][$keyInd];
					$res = $this->queryToCPanel($param, $query);
				}
			}

			$curFieldZone = 'mx';
			$arrTypeOper = array();
			$arrEditLine = array();
			$arrDoLine = array();

			foreach ($resDecDump['data']['zone'][0]['record'] as $curRec) {
				$q_exist_eq = 0;
				$q_exist = 0;

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['type'] == strtoupper($curFieldZone)) && ($curRec['preference'] == $listDoDNS[$curFieldZone]['preference'][$keyInd]) && ($curRec['exchange'] == $listDoDNS[$curFieldZone]['exchange'][$keyInd]) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd])) {
						$arrTypeOper['q_exist_eq'][] = $keyInd;
						$arrEditLine[] = $curRec['Line'];
						$arrDoLine[] = $keyInd;
						$q_exist_eq = 1;
						continue;
					}
				}

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['type'] == strtoupper($curFieldZone)) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd])) {
						$editLine = $curRec['Line'];

						if (!in_array($editLine, $arrEditLine) && !in_array($keyInd, $arrDoLine)) {
							$arrEditLine[] = $editLine;
							$arrDoLine[] = $keyInd;
							$arrTypeOper['q_exist'][] = $keyInd;
							$q_exist = 1;
							$query = 'https://' . $param['bind_ip'] . ':2087/json-api/editzonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $editLine . '&name=' . $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '&class=IN&ttl=' . $curRec['ttl'] . '&type=' . strtoupper($curFieldZone) . '&preference=' . $listDoDNS[$curFieldZone]['preference'][$keyInd] . '&exchange=' . $listDoDNS[$curFieldZone]['exchange'][$keyInd];
							$res = $this->queryToCPanel($param, $query);
							continue;
						}
					}
				}

				if (($q_exist == 0) && ($q_exist_eq == 0) && ($curRec['type'] == strtoupper($curFieldZone))) {
					$delLine = $curRec['Line'];
					$arrAllRecForDelComm[$delLine] = 'https://' . $param['bind_ip'] . ':2087/json-api/removezonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $delLine;
				}
			}

			foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
				if (!in_array($keyInd, $arrTypeOper['q_exist']) && !in_array($keyInd, $arrTypeOper['q_exist_eq'])) {
					$query = 'https://' . $param['bind_ip'] . ':2087/json-api/addzonerecord?api.version=1&domain=' . $param['domain'] . '&name=' . $curRecordDo . '&class=IN' . '&ttl=' . $ttl . '&type=' . strtoupper($curFieldZone) . '&preference=' . $listDoDNS[$curFieldZone]['preference'][$keyInd] . '&exchange=' . $listDoDNS[$curFieldZone]['exchange'][$keyInd];
					$res = $this->queryToCPanel($param, $query);
				}
			}

			$curFieldZone = 'txt';
			$arrTypeOper = array();
			$arrEditLine = array();
			$arrDoLine = array();

			foreach ($resDecDump['data']['zone'][0]['record'] as $curRec) {
				$q_exist_eq = 0;
				$q_exist = 0;

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['type'] == strtoupper($curFieldZone)) && ($curRec['txtdata'] == $listDoDNS[$curFieldZone]['txtdata'][$keyInd]) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd])) {
						$arrTypeOper['q_exist_eq'][] = $keyInd;
						$arrEditLine[] = $curRec['Line'];
						$arrDoLine[] = $keyInd;
						$q_exist_eq = 1;
						continue;
					}
				}

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['type'] == strtoupper($curFieldZone)) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd])) {
						$editLine = $curRec['Line'];

						if (!in_array($editLine, $arrEditLine) && !in_array($keyInd, $arrDoLine)) {
							$arrEditLine[] = $editLine;
							$arrDoLine[] = $keyInd;
							$arrTypeOper['q_exist'][] = $keyInd;
							$q_exist = 1;
							$query = 'https://' . $param['bind_ip'] . ':2087/json-api/editzonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $editLine . '&name=' . $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '&class=IN&ttl=' . $curRec['ttl'] . '&type=' . strtoupper($curFieldZone) . '&txtdata=' . urlencode($listDoDNS[$curFieldZone]['txtdata'][$keyInd]) . '&unencoded=1';
							$res = $this->queryToCPanel($param, $query);
							continue;
						}
					}
				}

				if (($q_exist == 0) && ($q_exist_eq == 0) && ($curRec['type'] == strtoupper($curFieldZone))) {
					$delLine = $curRec['Line'];
					$arrAllRecForDelComm[$delLine] = 'https://' . $param['bind_ip'] . ':2087/json-api/removezonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $delLine;
				}
			}

			foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
				if (!in_array($keyInd, $arrTypeOper['q_exist']) && !in_array($keyInd, $arrTypeOper['q_exist_eq'])) {
					$query = 'https://' . $param['bind_ip'] . ':2087/json-api/addzonerecord?api.version=1&domain=' . $param['domain'] . '&name=' . $curRecordDo . '&class=IN' . '&ttl=' . $ttl . '&type=' . strtoupper($curFieldZone) . '&txtdata=' . urlencode($listDoDNS[$curFieldZone]['txtdata'][$keyInd]) . '&unencoded=1';
					$res = $this->queryToCPanel($param, $query);
				}
			}

			$curFieldZone = 'aaaa';
			$arrTypeOper = array();
			$arrEditLine = array();
			$arrDoLine = array();

			foreach ($resDecDump['data']['zone'][0]['record'] as $curRec) {
				$q_exist_eq = 0;
				$q_exist = 0;

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['type'] == strtoupper($curFieldZone)) && ($curRec['address'] == $listDoDNS[$curFieldZone]['address'][$keyInd]) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd])) {
						$arrTypeOper['q_exist_eq'][] = $keyInd;
						$arrEditLine[] = $curRec['Line'];
						$arrDoLine[] = $keyInd;
						$q_exist_eq = 1;
						continue;
					}
				}

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['type'] == strtoupper($curFieldZone)) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd])) {
						$editLine = $curRec['Line'];

						if (!in_array($editLine, $arrEditLine) && !in_array($keyInd, $arrDoLine)) {
							$arrEditLine[] = $editLine;
							$arrDoLine[] = $keyInd;
							$arrTypeOper['q_exist'][] = $keyInd;
							$q_exist = 1;
							$query = 'https://' . $param['bind_ip'] . ':2087/json-api/editzonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $editLine . '&name=' . $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '&class=IN&ttl=' . $curRec['ttl'] . '&type=' . strtoupper($curFieldZone) . '&address=' . urlencode($listDoDNS[$curFieldZone]['address'][$keyInd]);
							$res = $this->queryToCPanel($param, $query);
							continue;
						}
					}
				}

				if (($q_exist == 0) && ($q_exist_eq == 0) && ($curRec['type'] == strtoupper($curFieldZone))) {
					$delLine = $curRec['Line'];
					$arrAllRecForDelComm[$delLine] = 'https://' . $param['bind_ip'] . ':2087/json-api/removezonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $delLine;
				}
			}

			foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
				if (!in_array($keyInd, $arrTypeOper['q_exist']) && !in_array($keyInd, $arrTypeOper['q_exist_eq'])) {
					$query = 'https://' . $param['bind_ip'] . ':2087/json-api/addzonerecord?api.version=1&domain=' . $param['domain'] . '&name=' . $curRecordDo . '&class=IN' . '&ttl=' . $ttl . '&type=' . strtoupper($curFieldZone) . '&address=' . urlencode($listDoDNS[$curFieldZone]['address'][$keyInd]);
					$res = $this->queryToCPanel($param, $query);
				}
			}

			$curFieldZone = 'afsdb';
			$arrTypeOper = array();
			$arrEditLine = array();
			$arrDoLine = array();

			foreach ($resDecDump['data']['zone'][0]['record'] as $curRec) {
				$q_exist_eq = 0;
				$q_exist = 0;

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['type'] == strtoupper($curFieldZone)) && ($curRec['subtype'] == $listDoDNS[$curFieldZone]['subtype'][$keyInd]) && ($curRec['hostname'] == $listDoDNS[$curFieldZone]['hostname'][$keyInd]) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd])) {
						$arrTypeOper['q_exist_eq'][] = $keyInd;
						$arrEditLine[] = $curRec['Line'];
						$arrDoLine[] = $keyInd;
						$q_exist_eq = 1;
						continue;
					}
				}

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['type'] == strtoupper($curFieldZone)) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd])) {
						$editLine = $curRec['Line'];

						if (!in_array($editLine, $arrEditLine) && !in_array($keyInd, $arrDoLine)) {
							$arrEditLine[] = $editLine;
							$arrDoLine[] = $keyInd;
							$arrTypeOper['q_exist'][] = $keyInd;
							$q_exist = 1;
							$query = 'https://' . $param['bind_ip'] . ':2087/json-api/editzonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $editLine . '&name=' . $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '&class=IN&ttl=' . $curRec['ttl'] . '&type=' . strtoupper($curFieldZone) . '&subtype=' . intval($listDoDNS[$curFieldZone]['subtype'][$keyInd]) . '&hostname=' . $listDoDNS[$curFieldZone]['hostname'][$keyInd];
							$res = $this->queryToCPanel($param, $query);
							continue;
						}
					}
				}

				if (($q_exist == 0) && ($q_exist_eq == 0) && ($curRec['type'] == strtoupper($curFieldZone))) {
					$delLine = $curRec['Line'];
					$arrAllRecForDelComm[$delLine] = 'https://' . $param['bind_ip'] . ':2087/json-api/removezonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $delLine;
				}
			}

			foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
				if (!in_array($keyInd, $arrTypeOper['q_exist']) && !in_array($keyInd, $arrTypeOper['q_exist_eq'])) {
					$query = 'https://' . $param['bind_ip'] . ':2087/json-api/addzonerecord?api.version=1&domain=' . $param['domain'] . '&name=' . $curRecordDo . '&class=IN' . '&ttl=' . $ttl . '&type=' . strtoupper($curFieldZone) . '&subtype=' . intval($listDoDNS[$curFieldZone]['subtype'][$keyInd]) . '&hostname=' . $listDoDNS[$curFieldZone]['hostname'][$keyInd];
					$res = $this->queryToCPanel($param, $query);
				}
			}

			$curFieldZone = 'cname';
			$arrTypeOper = array();
			$arrEditLine = array();
			$arrDoLine = array();

			foreach ($resDecDump['data']['zone'][0]['record'] as $curRec) {
				$q_exist_eq = 0;
				$q_exist = 0;

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['type'] == strtoupper($curFieldZone)) && ($curRec['cname'] == $listDoDNS[$curFieldZone]['cname'][$keyInd]) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd])) {
						$arrTypeOper['q_exist_eq'][] = $keyInd;
						$arrEditLine[] = $curRec['Line'];
						$arrDoLine[] = $keyInd;
						$q_exist_eq = 1;
						continue;
					}
				}

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['type'] == strtoupper($curFieldZone)) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd])) {
						$editLine = $curRec['Line'];

						if (!in_array($editLine, $arrEditLine) && !in_array($keyInd, $arrDoLine)) {
							$arrEditLine[] = $editLine;
							$arrDoLine[] = $keyInd;
							$arrTypeOper['q_exist'][] = $keyInd;
							$q_exist = 1;
							$query = 'https://' . $param['bind_ip'] . ':2087/json-api/editzonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $editLine . '&name=' . $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '&class=IN&ttl=' . $curRec['ttl'] . '&type=' . strtoupper($curFieldZone) . '&cname=' . $listDoDNS[$curFieldZone]['cname'][$keyInd];
							$res = $this->queryToCPanel($param, $query);
							continue;
						}
					}
				}

				if (($q_exist == 0) && ($q_exist_eq == 0) && ($curRec['type'] == strtoupper($curFieldZone))) {
					$delLine = $curRec['Line'];
					$arrAllRecForDelComm[$delLine] = 'https://' . $param['bind_ip'] . ':2087/json-api/removezonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $delLine;
				}
			}

			foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
				if (!in_array($keyInd, $arrTypeOper['q_exist']) && !in_array($keyInd, $arrTypeOper['q_exist_eq'])) {
					$query = 'https://' . $param['bind_ip'] . ':2087/json-api/addzonerecord?api.version=1&domain=' . $param['domain'] . '&name=' . $curRecordDo . '&class=IN' . '&ttl=' . $ttl . '&type=' . strtoupper($curFieldZone) . '&cname=' . $listDoDNS[$curFieldZone]['cname'][$keyInd];
					$res = $this->queryToCPanel($param, $query);
				}
			}

			$curFieldZone = 'dname';
			$arrTypeOper = array();
			$arrEditLine = array();
			$arrDoLine = array();

			foreach ($resDecDump['data']['zone'][0]['record'] as $curRec) {
				$q_exist_eq = 0;
				$q_exist = 0;

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['type'] == strtoupper($curFieldZone)) && ($curRec['dname'] == $listDoDNS[$curFieldZone]['dname'][$keyInd]) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd])) {
						$arrTypeOper['q_exist_eq'][] = $keyInd;
						$arrEditLine[] = $curRec['Line'];
						$arrDoLine[] = $keyInd;
						$q_exist_eq = 1;
						continue;
					}
				}

				foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
					if (($curRec['type'] == strtoupper($curFieldZone)) && ($curRec['name'] == $listDoDNS[$curFieldZone]['zonename'][$keyInd])) {
						$editLine = $curRec['Line'];

						if (!in_array($editLine, $arrEditLine) && !in_array($keyInd, $arrDoLine)) {
							$arrEditLine[] = $editLine;
							$arrDoLine[] = $keyInd;
							$arrTypeOper['q_exist'][] = $keyInd;
							$q_exist = 1;
							$query = 'https://' . $param['bind_ip'] . ':2087/json-api/editzonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $editLine . '&name=' . $listDoDNS[$curFieldZone]['zonename'][$keyInd] . '&class=IN&ttl=' . $curRec['ttl'] . '&type=' . strtoupper($curFieldZone) . '&dname=' . $listDoDNS[$curFieldZone]['dname'][$keyInd];
							$res = $this->queryToCPanel($param, $query);
							continue;
						}
					}
				}

				if (($q_exist == 0) && ($q_exist_eq == 0) && ($curRec['type'] == strtoupper($curFieldZone))) {
					$delLine = $curRec['Line'];
					$arrAllRecForDelComm[$delLine] = 'https://' . $param['bind_ip'] . ':2087/json-api/removezonerecord?api.version=1&domain=' . $param['domain'] . '&line=' . $delLine;
				}
			}

			foreach ($listDoDNS[$curFieldZone]['zonename'] as $keyInd => $curRecordDo) {
				if (!in_array($keyInd, $arrTypeOper['q_exist']) && !in_array($keyInd, $arrTypeOper['q_exist_eq'])) {
					$query = 'https://' . $param['bind_ip'] . ':2087/json-api/addzonerecord?api.version=1&domain=' . $param['domain'] . '&name=' . $curRecordDo . '&class=IN' . '&ttl=' . $ttl . '&type=' . strtoupper($curFieldZone) . '&dname=' . $listDoDNS[$curFieldZone]['dname'][$keyInd];
					$res = $this->queryToCPanel($param, $query);
				}
			}

			krsort($arrAllRecForDelComm);

			foreach ($arrAllRecForDelComm as $curQuery) {
				$res = $this->queryToCPanel($param, $curQuery);
			}
		}
	}

	public function queryToCPanel($param, $url)
	{
		$user = 'root';
		$token = $param['bind_key'];
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 20);
		$header[0] = 'Authorization: whm ' . $user . ':' . $token;
		curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
		curl_setopt($curl, CURLOPT_URL, $url);
		$result = curl_exec($curl);

		if ($result == false) {
			error_log('curl_exec threw error "' . curl_error($curl) . '" for ' . $url);
			return -2304;
		}

		curl_close($curl);
		$data_res = json_decode($result, 1);

		if (stripos($data_res['error'], 'Access denied') !== false) {
			return -2303;
		}

		return $result;
	}

	public function addToClusterCpanel($param, $checkconn = 0)
	{
		$user = 'root';
		$token = $param['bind_key'];

		if ($checkconn == 1) {
			$query = 'https://' . $param['bind_ip'] . ':2087/json-api/listaccts?api.version=1';
		}
		else {
			$query = 'https://' . $param['bind_ip'] . ':2087/json-api/addzonerecord?api.version=1&domain=' . $param['domain'] . '&name=' . $param['zone'] . '&class=IN&TTL=86400';
		}

		$curl = curl_init();
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 20);
		$header[0] = 'Authorization: whm ' . $user . ':' . $token;
		curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
		curl_setopt($curl, CURLOPT_URL, $query);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
		$result = curl_exec($curl);

		if ($result == false) {
			error_log('curl_exec threw error "' . curl_error($curl) . '" for ' . $query);
			return -2301;
		}

		curl_close($curl);
		$data_res = json_decode($result, 1);

		if (stripos($data_res['error'], 'Access denied') !== false) {
			return -1;
		}

		if (stripos($data_res['cpanelresult']['error'], 'Access denied') !== false) {
			return -1;
		}

		if (is_file('/etc/csf/csf.conf')) {
			$this->ssh('csf -a ' . $param['bind_ip']);
		}
		else {
			$this->ssh('iptables -I INPUT -s ' . $param['bind_ip'] . ' -j ACCEPT');
			$this->ssh('service iptables save');
		}

		if ($checkconn == 1) {
			return 1;
		}
	}
}


?>
