<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class blacklist
{
	public $path_server_bl = '/etc/brainy/data/blacklist/blacklist';
	public $path_main = '/etc/brainy/data/blacklist/main';
	public $path_scan = '/etc/brainy/data/blacklist/scan';

	public function save_blacklist($data)
	{
		global $lang;
		$blacklist = explode(PHP_EOL, $data);

		foreach ($blacklist as $val) {
			$out_array['code'] = 100;
			$out_array['message'] = $val . ' ' . $lang['blacklist_error_domain'];

			return $out_array;
		}

		$this->write_file(implode(PHP_EOL, array_diff($blacklist, array(''))), $this->path_server_bl, 'r');
		$out_array['code'] = 0;
		$out_array['message'] = $lang['blacklist_succesfully'];
		return $out_array;
	}

	public function monitor($data)
	{
		global $lang;
		if (!$this->check_value('number', $data['time']) || !isset($data['time'])) {
			$out_array['code'] = 100;
			$out_array['message'] = $lang['blacklist_error_minutes'];
			return $out_array;
		}

		$hour = '*';

		if (1440 < $data['time']) {
			$return_array['code'] = 100;
			$return_array['message'] = $lang['blacklist_many_minutes'];
			return $return_array;
		}

		if (59 < $data['time']) {
			$hour = '*/' . floor($data['time'] / 60);

			if (($data['time'] - (floor($data['time'] / 60) * 60)) == 0) {
				$minutes = '0';
			}
			else {
				$val_minutes = $data['time'] - (floor($data['time'] / 60) * 60);
				$minutes = $val_minutes;
			}
		}
		else if ((0 < $data['time']) && ($data['time'] < 60)) {
			$minutes = '*/' . $data['time'];
		}
		else {
			if ($data['time'] == 0) {
				$this->del_string_new('blacklist.php', '/etc/brainy/conf/cron_exec_config');
				$this->del_string_new('blacklist.php', '/etc/brainy/data/crontab/next_exec');
			}

			$crontab = new crontab();
			$dir = $GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/crontab/crontab';
			$this->del_string_new('blacklist.php', $dir);
			$crontab->crontab_load('root');
			$return_array['code'] = 0;
			$return_array['message'] = $lang['blacklist_disabled_scan'];
			$this->config_save($this->path_main, array('time_scan' => $data['time']));
			return $return_array;
		}

		$crontab = new crontab();
		$check_comand = implode('', $this->ssh('cat /etc/brainy/data/crontab/crontab | grep blacklist.php'));
		if (is_file('/etc/brainy/conf/cron_exec_config') && !$check_comand) {
			$this->del_string_new('blacklist.php', '/etc/brainy/conf/cron_exec_config');
			$this->del_string_new('blacklist.php', '/etc/brainy/data/crontab/next_exec');
			$crontab->edit_config_script_cron('/etc/brainy/src/compiled/php5/bin/php -q /etc/brainy/scripts/blacklist.php > /dev/null 2> /dev/null', $minutes, $hour);
		}
		else {
			$dir = $GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/crontab/crontab';
			$this->del_string_new('blacklist.php', $dir);
			$cron_command = '/etc/brainy/src/compiled/php5/bin/php -q /etc/brainy/scripts/blacklist.php';
			$return_array = $crontab->crontab_cronjob_add($minutes, $hour, '*', '*', '*', $cron_command);
		}

		$return_array['code'] = 0;
		$return_array['message'] = $lang['blacklist_succesfully'];
		$this->config_save($this->path_main, array('time_scan' => $data['time']));
		return $return_array;
	}

	public function get_status_blacklist()
	{
		return $this->config_read('/etc/brainy/data/blacklist/main')['time_scan'];
	}

	public function get_check_black_list()
	{
		$data_blacklist = $this->read_file_n($this->path_scan);
		$check_black = 0;

		foreach ($data_blacklist as $key_black => $val_black) {
			$val_data = explode('|', trim($val_black));

			if ($val_data[1]) {
				$check_black = 1;
			}
		}

		return $check_black;
	}

	public function get_blacklist()
	{
		return $this->read_file($this->path_server_bl);
	}

	public function scan_local_ip()
	{
		$newips = $this->sudo_ssh('/usr/sbin/ip addr list');
		$i = 0;

		foreach ($newips as $value) {
			preg_match_all('@inet ([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})/[0-9]{1,2}.*scope (host|global).*([a-z0-9:]+)$@Usi', $value, $out);

			if (!isset($out[1][0])) {
				continue;
			}

			if ($out[1][0] && ($out[1][0] != '127.0.0.1')) {
				$ip[$i]['ip'] = $out[1][0];
				$ip[$i]['availability'] = $out[2][0];
				$ip[$i]['int'] = $out[3][0];
				++$i;
			}
		}

		$blacklist = $this->read_file_n($this->path_server_bl);

		foreach ($ip as $val_ip) {
			if (preg_match('/^(192[.]168[.])|(10[.][0][.])|(10[.][1][.])|(127[.][0][.][0][.][1])/i', $val_ip['ip'])) {
				continue;
			}

			$reverse_ip = implode('.', array_reverse(explode('.', $val_ip['ip'])));
			$array_black = NULL;

			foreach ($blacklist as $host) {
				$record = @dns_get_record($reverse_ip . '.' . trim($host), DNS_ANY);
				if (is_array($record) && !empty($record)) {
					$check_black = 0;

					foreach ($record as $val) {
						if (preg_match('/' . trim($host) . '$/iu', $val['host'])) {
							$check_black = 1;
							$array_black[] = trim($host);
						}
					}
				}
			}

			if (!$array_black || !$check_black) {
				$array[] = $val_ip['ip'] . '|0';
			}
			else {
				$array[] = $val_ip['ip'] . '|' . implode(',', $array_black);
			}
		}

		$this->write_file(implode(PHP_EOL, $array), $this->path_scan, 'r');
	}

	public function search_ip()
	{
		$ip = $this->ipmanager_listips();
		$blacklist = $this->read_file_n($this->path_server_bl);

		foreach ($ip as $val_ip) {
			if (preg_match('/^(192[.]168[.])|(10[.][0][.])|(10[.][1][.])|(127[.][0][.][0][.][1])/i', $val_ip['ip'])) {
				continue;
			}

			$reverse_ip = implode('.', array_reverse(explode('.', $val_ip['ip'])));

			foreach ($blacklist as $host) {
				$record = @dns_get_record($reverse_ip . '.' . trim($host), DNS_ANY);
				if (is_array($record) && !empty($record)) {
					$array_check['array_check'][$host]['status'] = 1;
					$check_black = 0;

					foreach ($record as $val) {
						if (preg_match('/' . trim($host) . '$/iu', $val['host'])) {
							$check_black = 1;
						}

						$info = $val['txt'];

						break;
					}

					if ($check_black == 1) {
						$array_check['array_check'][$host]['info'][] = $info;
						$array_check['array_check'][$host]['block_ip'][] = $val_ip['ip'];
					}
					else {
						$array_check['array_check'][$host]['status'] = 0;
					}
				}
				else {
					$array_check['array_check'][$host]['status'] = 0;
				}
			}
		}

		return $array_check;
	}
}


?>
