<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class certs
{
	public $dir_certs = '/etc/certs/';
	public $snifile = '/etc/dovecot/sni.conf';
	public $brainy_cert = '/etc/brainy/src/compiled/brainy/ssl/apache.crt';
	public $brainy_key = '/etc/brainy/src/compiled/brainy/ssl/apache.key';
	public $brainy_chain = '/etc/brainy/src/compiled/brainy/ssl/apache.chain';
	public $path_cert = '/etc/brainy/src/ssl/';
	public $brainy_conf = '/etc/brainy/src/compiled/brainy/conf/httpd.conf';

	public function certs_key_first($arr, $key)
	{
		$arr = array_diff($arr, array($key));
		array_unshift($arr, $key);
		return implode(';', $arr);
	}

	public function certs_new_keygen($user, $data, $domain, $size, $name)
	{
		global $lang;
		$res['err'] = 0;
		$res['list_csr'] = '';
		$res['list_key'] = '';
		$len = strlen(trim($data['C']));

		if ($domain == '') {
			$res['err'] = 1;
			$mess = $lang['msg_cert_err_nodomain'];
		}
		else if ($len != 2) {
			$res['err'] = 1;
			$mess = $lang['msg_cert_err_nocode'];
		}
		else {
			$name = $domain . '_' . time();
			$name = $this->certs_keygen($user, $domain, $size, $name);
			$mess = $this->certs_reqgen($user, $data, $name);
			$list_csr = $this->certs_getcrts($user);
			$res['list_csr'] = $list_csr;
			$list_key = $this->certs_getkeys($user);
			$res['list_key'] = $list_key;
		}

		$res['mess'] = $mess;
		$res['key_name'] = $name;
		return $res;
	}

	public function certs_keygen($user, $domain, $size, $name)
	{
		if (!empty($user) && !empty($size)) {
			$conf = $this->get_user_data($user);
			$rootdir = $this->dir_certs . $user . '/';
			$comm = 'mkdir -p ' . $rootdir;
			$this->sudo_ssh($comm);
			$size = intval($size);

			if (empty($name)) {
				$name = 'key_' . time();
			}
			else {
				$name = escapeshellcmd($name);
			}

			$comm = 'openssl genrsa ' . '-out \'' . $rootdir . $name . '.key\' ' . $size . ' &>/dev/stdout';
			$this->sudo_ssh($comm);

			if (is_file('/etc/brainy/data/certs_control/keylist')) {
				$config = $this->config_read('/etc/brainy/data/certs_control/keylist');
			}

			$config[$name] = 'free';
			$this->config_save('/etc/brainy/data/certs_control/keylist', $config, 'add');
			return $name;
		}
	}

	public function writeUTF8File($filename, $content)
	{
		$f = fopen($filename, 'wb');
		$file = '﻿' . $content;
		fputs($f, $content);
		fclose($f);
	}

	public function certs_keyload($user, $domain, $data, $name)
	{
		global $lang;
		$data = escapeshellcmd($data);
		$data = str_replace('"', '\\'', $data);

		if (!empty($user) && !empty($data)) {
			$this->certs_removekey($user, $domain);
			$conf = $this->get_user_data($user);
			$rootdir = $this->dir_certs . $user . '/';
			$comm = 'mkdir -p' . $rootdir;
			$this->sudo_ssh($comm);

			if (empty($name)) {
				$name = 'key_' . time();
			}
		}
		else {
			$name = escapeshellcmd($name);
		}

		$data = urldecode($data);
		$data = str_replace("\r\n", "\n", $data);
		$data = str_replace("\r", "\n", $data);
		file_put_contents($rootdir . $name . '.key', $data);
		$comm = 'res=$(openssl rsa -in ' . $rootdir . $name . '.key -check  2>&1);echo $res;';
		$rescheck = $this->ssh($comm);
		if ((stripos($rescheck[0], 'unable') !== false) || (stripos($rescheck[0], 'error') !== false)) {
			$this->ssh('rm -f ' . $rootdir . $name . '.key');
			$res['code'] = 2;
			$res['message'] = $lang['certs_control_keyload_wrongformat'];
			return $res;
		}

		if (is_file('/etc/brainy/data/certs_control/keylist')) {
			$config = $this->config_read('/etc/brainy/data/certs_control/keylist');
		}

		$conf[$name] = 'free';
		$this->config_save('/etc/brainy/data/certs_control/keylist', $conf, 'add');
		$res['code'] = 0;
		$res['message'] = $lang['certs_control_keyload_ok'];
		return $res;
	}

	public function certs_reqgen($user, $data, $keyname)
	{
		global $lang;

		if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $user)) {
			return 0;
		}

		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $keyname)) {
			return 0;
		}

		foreach ($data as $key => $value) {
			$data[$key] = str_replace('"', '\\'', escapeshellcmd($value));
		}

		$len = strlen(trim($data['C']));

		if ($len != 2) {
			$mess = $lang['msg_cert_err_nocode'];
			return $mess;
		}

		if (!$this->check_params('strdot', $data['C'])) {
			$mess = $lang['msg_cert_err_nocode'];
			return $mess;
		}

		if (!$this->check_params('strdot', $data['ST']) || (strlen($data['ST']) < 2)) {
			$mess = $lang['msg_cert_err_State'];
			return $mess;
		}

		if (!$this->check_params('strdot', $data['L']) || (strlen($data['L']) < 2)) {
			$mess = $lang['msg_cert_errCity'];
			return $mess;
		}

		if (!$this->check_params('strdot', $data['CN']) || (strlen($data['CN']) < 2)) {
			$mess = $lang['msg_cert_errCompany'];
			return $mess;
		}

		if (!$this->check_params('strdot', $data['O']) || (strlen($data['O']) < 2)) {
			$mess = $lang['msg_cert_errOtdel'];
			return $mess;
		}

		if (!empty($user) && !empty($data) && !empty($keyname)) {
			$conf = $this->get_user_data($user);
			$rootdir = $this->dir_certs . $user . '/';

			if (is_file($rootdir . $keyname . '.key')) {
				$comm = 'openssl req -x509 -new -key ' . $rootdir . $keyname . '.key -subj "/C=' . $data['C'] . '/ST=' . $data['ST'] . '/L=' . $data['L'] . '/O=' . $data['O'] . '/CN=' . $data['CN'] . '"' . ' -out ' . $rootdir . $keyname . '' . '.crt &>/dev/stdout';
				$out = $this->sudo_ssh($comm);

				if (!sizeof($out)) {
					$res = $lang['msg_cert_create_info0'] . ' ' . $keyname . ' ' . $lang['msg_cert_create_info1'];
				}
				else {
					$res = implode("\n", $out);
				}
			}
			else {
				$res = $lang['msg_cert_err_create_domain'];
			}

			if (is_file('/etc/brainy/data/certs_control/crtlist')) {
				$config = $this->config_read('/etc/brainy/data/certs_control/crtlist');
			}

			$config[$keyname] = 'unbinded';
			$this->config_save('/etc/brainy/data/certs_control/crtlist', $config, 'add');

			if (is_file('/etc/brainy/data/certs_control/keylist')) {
				$list = $this->config_read('/etc/brainy/data/certs_control/keylist');
			}

			$list[$keyname] = 'certed';
			$list = $this->config_save('/etc/brainy/data/certs_control/keylist', $list, 'add');
			return $res;
		}
	}

	public function certs_reqload($user, $data, $keyname)
	{
		global $lang;

		if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $user)) {
			$res['code'] = 1;
			return $res;
		}

		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $keyname)) {
			$res['code'] = 1;
			$res['message'] = $lang['certs_control_certload_failedname'];
			return $res;
		}

		$rootdir = $this->dir_certs . '' . $user . '/';

		if (!empty($user) && !empty($keyname) && !empty($data)) {
			$this->certs_removereq($user, $domain);
			$conf = $this->get_user_data($user);
			$rootdir = $this->dir_certs . '' . $user . '/';
			$comm = 'mkdir ' . $rootdir;
			$this->sudo_ssh($comm);
			$data = urldecode($data);
			$data = str_replace("\r\n", "\n", $data);
			$data = str_replace("\r", "\n", $data);
			file_put_contents($rootdir . $keyname . '.crt', $data);
			$comm = 'res=$(openssl x509 -in ' . $rootdir . $keyname . '.crt -text -noout  2>&1);echo $res;';
			$rescheck = $this->ssh($comm);
			$res['data'] = $comm;
			$res['check'] = $rescheck;
			if ((stripos($rescheck[0], 'unable') !== false) || (stripos($rescheck[0], 'error') !== false)) {
				$this->ssh('rm -f ' . $rootdir . $keyname . '.crt');
				$res['code'] = 2;
				$res['message'] = $lang['certs_control_certload_wrongformat'];
				return $res;
			}

			if (is_file('/etc/brainy/data/certs_control/crtlist')) {
				$config = $this->config_read('/etc/brainy/data/certs_control/crtlist');
			}

			$config[$keyname] = 'unbinded';
			$this->config_save('/etc/brainy/data/certs_control/crtlist', $config, 'add');

			if (is_file('/etc/brainy/data/certs_control/keylist')) {
				$list = $this->config_read('/etc/brainy/data/certs_control/keylist');
			}

			$list[$keyname] = 'certed';
			$list = $this->config_save('/etc/brainy/data/certs_control/keylist', $list, 'add');
		}

		if (empty($data)) {
			$res['code'] = 2;
			$res['message'] = $lang['certs_control_certload_wrongformat'];
			return $res;
		}

		$res['code'] = 0;
		$res['message'] = $lang['certs_control_certload_ok'];
		return $res;
	}

	public function certs_getdomains($user)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $user)) {
			return 0;
		}

		$puny = new idna_convert();
		$rootdir = $this->dir_certs . '' . $user . '/';
		$this->sudo_ssh('mkdir -p ' . $rootdir);
		$res = parse_ini_file($GLOBALS['USERS_PATH'] . $user);
		$res = explode(',', $res['vhost_list']);

		foreach ($res as $site) {
			$site = trim($site);

			if (!empty($site)) {
				$site = explode(':', $site);
				$ret[] = $puny->decode(trim($site[0]));
			}
		}

		if (is_array($ret)) {
			$ret = array_unique($ret);
		}

		return $ret;
	}

	public function certs_getcrtdomains($user)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $user)) {
			return 0;
		}

		$conf = $this->get_user_data($user);
		$rootdir = $this->dir_certs . $user . '/';
		$comm = 'find ' . $rootdir . ' -name *.crt';
		$ans = $this->sudo_ssh($comm);

		foreach ($ans as $domain) {
			$domain = end(explode('/', $domain));
			$domains[] = substr($domain, 0, -4);
		}

		if (is_array($domains)) {
			$domains = array_unique($domains);
		}

		return $domains;
	}

	public function certs_getkeydomains($user, $webserver)
	{
		if (!preg_match('/^[a-zA-Z0-9_]+$/', $user)) {
			return 0;
		}

		$conf = $this->config_read('/etc/brainy/data/certs_control/crtlist');
		$domains = $webserver->webserver_getdomains($user);

		foreach ($conf as $key => $value) {
			$curr_domains = explode(',', $value);

			foreach ($curr_domains as $value_domain) {
				$all_keydomains[] = $value_domain;
			}
		}

		$all_keydomains = array_diff($all_keydomains, array('', ' '));
	}

	public function certs_getkeys($user)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $user)) {
			return 0;
		}

		$conf = $this->get_user_data($user);
		$rootdir = $this->dir_certs . $user . '/';
		$comm = 'find ' . $rootdir . ' -name *.key';
		$ans = $this->sudo_ssh($comm);

		foreach ($ans as $key) {
			$key = end(explode('/', $key));
			$keys[] = substr($key, 0, -4);
		}

		if (is_array($keys)) {
			$keys = array_unique($keys);
		}

		return $keys;
	}

	public function certs_getcrts($user)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $user)) {
			return 0;
		}

		$conf = $this->get_user_data($user);
		$rootdir = $this->dir_certs . $user . '/';
		$comm = 'find ' . $rootdir . ' -name *.crt';
		$ans = $this->sudo_ssh($comm);

		foreach ($ans as $key) {
			$key = end(explode('/', $key));
			$keys[] = substr($key, 0, -4);
		}

		if (is_array($keys)) {
			$keys = array_unique($keys);
		}

		return $keys;
	}

	public function certs_getdomains_signed($user)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $user)) {
			return 0;
		}

		$webserver = new webserver();
		$ret = $webserver->webserver_getdomains($user);

		if (is_array($ret)) {
			foreach ($ret as $value) {
				$vhost_data = $this->config_read('/etc/brainy/data/vhosts/' . $value . '.conf');

				if ($vhost_data['ssl'] == 1) {
					$end[] = $value;
				}
			}
		}

		return $end;
	}

	public function certs_getdomains_signed_all()
	{
		$out = $this->sudo_ssh('grep -rl \'ssl=1\' /etc/brainy/data/vhosts');

		foreach ($out as $value) {
			$value = strrchr($value, '/');
			$value = str_replace(array('/', '.conf'), '', $value);
			$newmass[] = $value;
		}

		return $newmass;
	}

	public function certs_getdomains_real_signed($user)
	{
		$webserver = new webserver();
		$ret = $webserver->webserver_getdomains($user);

		foreach ($ret as $value) {
			$vhost_data = $this->config_read('/etc/brainy/data/vhosts/' . $value . '.conf');

			if ($vhost_data['ssl'] == 1) {
				$end[] = $value;
			}
		}

		return $end;
	}

	public function certs_removekey($user, $name)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $user)) {
			return 0;
		}

		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $name)) {
			return 0;
		}

		global $lang;
		$res = $this->certs_getkeys($user);

		if (($c = (string) array_search($name, $res)) == '') {
			$out['err'] = 2;
			$out['mess'] = $lang['msg_cert_nocertkey'];
			$out['res'] = array();
			return $out;
		}

		$conf = $this->get_user_data($user);
		$rootdir = $this->dir_certs . $user . '/';
		$keyfile = $name . '.key';
		$arr = $this->sudo_ssh('grep -rw \'key=\' /etc/brainy/data/vhosts');
		$host = '';
		$out = '';
		$i = 0;

		while ($i < count($arr)) {
			$p = explode(':key="' . $rootdir, $arr[$i]);

			if (stripos($p[1], $keyfile) !== false) {
				$b = true;
				$len = strlen('/etc/brainy/data/vhosts/');
				$host = substr($p[0], $len);
				break;
			}

			++$i;
		}

		if ($b) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_cert_err_del_cert'] . ' ' . $host;
			$out['res'] = array();
		}
		else {
			$ret = $this->certs_removereq($user, $name);

			if ($ret['err'] == 0) {
				$comm = 'rm -f \'' . $rootdir . $name . '.key\'';
				$this->sudo_ssh($comm);
				$comm = 'rm -f \'' . $rootdir . $name . '.chein\'';
				$this->sudo_ssh($comm);
				$comm = 'rm -f \'' . $rootdir . $name . '.crt_v2\'';
				$this->sudo_ssh($comm);
				$list = $this->config_read('/etc/brainy/data/certs_control/keylist');
				unset($list[$name]);
				$list = $this->config_save('/etc/brainy/data/certs_control/keylist');
				$res = $this->certs_getkeys($user);
				$out['err'] = 0;
				$out['mess'] = $lang['msg_cert_ok_del_cert'];
				$out['res'] = $res;
			}
			else {
				$used = $ret['host'];
				$out['err'] = 1;
				$out['mess'] = $lang['msg_cert_err_del_cert'] . ' ' . $used;
				$out['res'] = array();
			}
		}

		return $out;
	}

	public function certs_removereq($user, $name)
	{
		global $lang;

		if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $user)) {
			return 0;
		}

		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $name)) {
			return 0;
		}

		$conf = $this->get_user_data($user);
		$rootdir = $this->dir_certs . $user . '/';
		$crtfile = $name . '.crt';
		$arr = $this->sudo_ssh('grep -rw \'crt=\' /etc/brainy/data/vhosts');
		$b = false;
		$host = '';
		$out = '';
		$i = 0;

		while ($i < count($arr)) {
			$p = explode(':crt="' . $rootdir, $arr[$i]);

			if (stripos($p[1], $crtfile) !== false) {
				$b = true;
				$len = strlen('/etc/brainy/data/vhosts/');
				$host = substr($p[0], $len);
				break;
			}

			++$i;
		}

		if ($b) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_cert_err_del_cert_cert'] . ' ' . $host;
			$out['res'] = array();
			$out['host'] = $host;
		}
		else {
			$comm = 'rm -f ' . $rootdir . $name . '.crt';
			$this->sudo_ssh($comm);
			$list = $this->config_read('/etc/brainy/data/certs_control/crtlist');
			unset($list[$name]);
			$list = $this->config_save('/etc/brainy/data/certs_control/crtlist');
			$list = $this->config_read('/etc/brainy/data/certs_control/keylist');
			$list[$name] = '0';
			$list = $this->config_save('/etc/brainy/data/certs_control/keylist');
			$res = $this->certs_getcrts($user);
			$out['err'] = 0;
			$out['mess'] = $lang['msg_cert_ok_del_cert1'];
			$out['res'] = $res;
			$out['host'] = '';
		}

		return $out;
	}

	public function certs_remove_domain($user, $domain)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $user)) {
			return 0;
		}

		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $domain)) {
			return 0;
		}

		$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);
		$rootdir = $this->dir_certs . $user . '/';

		if ($conf['back_server'] == 'apache2.2') {
			$apache_path = $GLOBALS['APACHE22_PATH'];
			$apache_modules = $GLOBALS['APACHE22_MODULES'];
			$apache_comm = 'httpd';
		}

		if ($conf['back_server'] == 'apache2.4') {
			$apache_path = $GLOBALS['APACHE24_PATH'];
			$apache_modules = $GLOBALS['APACHE24_MODULES'];
			$apache_comm = 'httpd';
		}

		$file = $GLOBALS['USERS_PATH'] . $user;
		$users = $this->config_read($file);
		$sites = explode(',', $users['vhost_list']);
		$counter = count($sites);
		$i = 0;

		while ($i < $counter) {
			$site = explode(':', $sites[$i]);
			$cur_dom = $site[0];

			if ($cur_dom == $domain) {
				$this->del_string($cur_dom . ':' . $user, '/etc/brainy/data/server_control/vhosts');
				$foo = explode('+', $site[1]);

				foreach ($foo as $value) {
					$this->del_string($value . ':' . $user, '/etc/brainy/data/server_control/vhosts');
				}

				unset($sites[$i]);
			}

			++$i;
		}

		if (0 < count($sites)) {
			$users['vhost_list'] = implode(',', $sites);
		}
		else {
			$users['vhost_list'] = '';
		}

		$this->config_save($file, $users, 'add');
		$comm = 'rm -f /opt/rh/httpd24/root/etc/httpd/vhost.d/' . $domain . '.conf';
		$this->sudo_ssh($comm);
		$comm = 'rm -f /etc/httpd/vhost.d/' . $domain . '.conf';
		$this->sudo_ssh($comm);
		$comm = 'rm -f /etc/httpd/vhost.d/@000-' . $user . '.' . $domain . '*';
		$this->sudo_ssh($comm);
		$comm = 'rm -f /etc/nginx/sites-available/' . $domain;
		$this->sudo_ssh($comm);
		$comm = 'rm -f ' . $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$this->sudo_ssh($comm);
		$comm = 'rm -f /etc/nginx/sites-available/' . $domain . '.conf';
		$this->sudo_ssh($comm);
		$webserver = new webserver();
		$webserver->webservers_reloadconf(0);
		return $domain;
	}

	public function certs_show_key($user, $domain)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $user)) {
			return 0;
		}

		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $domain)) {
			return 0;
		}

		$conf = $this->get_user_data($user);
		$rootdir = $this->dir_certs . $user . '/';
		$ans = file_get_contents($rootdir . $domain . '.key');
		return $ans;
	}

	public function certs_show_csr($user, $domain)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $user)) {
			return 0;
		}

		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $domain)) {
			return 0;
		}

		$conf = $this->get_user_data($user);
		$rootdir = $this->dir_certs . $user . '/';
		$ans = file_get_contents($rootdir . $domain . '.crt');
		return $ans;
	}

	public function certs_autofill_1($user, $domain, $key = NULL, $crt = NULL)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $user)) {
			return 0;
		}

		if (0 < strlen($domain)) {
			if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $domain)) {
				return 0;
			}
		}

		$rootdir = $this->dir_certs . $user . '/';
		$md5key = $this->sudo_ssh('openssl rsa -noout -modulus -in \'' . $rootdir . $key . '.key\'' . ' | md5sum &>/dev/stdout');
		$out = $this->certs_getcrts($user);
		$list = array();
		$i = 0;

		while ($i < count($out)) {
			$out[$i] = escapeshellcmd($out[$i]);
			$md5crt = $this->sudo_ssh('openssl x509 -noout -modulus -in \'' . $rootdir . $out[$i] . '.crt\'' . ' | md5sum &>/dev/stdout');

			if (($md5key == $md5crt) && ($md5key != 'd41d8cd98f00b204e9800998ecf8427e -')) {
				array_unshift($list, $out[$i]);
			}

			++$i;
		}

		if (!sizeof($list)) {
			array_unshift($list, 'новый');
		}
		if ($key) {
			$domain = $key;
		}
		if ($crt) {
			$domain = $crt;
		}

		$conf = $this->get_user_data($user);
		$rootdir = $this->dir_certs . $user . '/';
		$ans['list'] = implode(';', $list);
		$crt_first = $list[0];
		$key = file_get_contents($rootdir . $domain . '.key');
		$crt = file_get_contents($rootdir . $crt_first . '.crt');
		$chain = file_get_contents($rootdir . $crt_first . '.chein');
		$ans['key'] = !$key ? '' : $key;
		$ans['crt'] = !$crt ? '' : $crt;
		$ans['chain'] = !$chain ? '' : $chain;
		return $ans;
	}

	public function certs_autofill($user, $domain, $key = NULL, $crt = NULL)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $user)) {
			return 0;
		}

		if (0 < strlen($domain)) {
			if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $domain)) {
				return 0;
			}
		}
		if ($key) {
			$domain = $key;
		}
		if ($crt) {
			$domain = $crt;
		}

		$conf = $this->get_user_data($user);
		$rootdir = $this->dir_certs . $user . '/';

		if (is_file($rootdir . $domain . '.key')) {
			$ans['key'] = file_get_contents($rootdir . $domain . '.key');
		}

		if (is_file($rootdir . $domain . '.crt')) {
			$ans['crt'] = file_get_contents($rootdir . $domain . '.crt');
		}

		return $ans;
	}

	public function certs_installcrt($user, $domain, $keyname, $data, $webserver)
	{
		$puny = new idna_convert();
		$domain = $puny->encode(trim($domain));

		if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $user)) {
			return 0;
		}

		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $domain)) {
			return 0;
		}

		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $keyname)) {
			return 0;
		}

		global $lang;
		$conf_web = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);

		if ($data['crt'] == 'no_cert') {
			certs_uninstallcrt($domain);
			$res['code'] = 101;
			$res['message'] = $lang['msg_cert_ok_unset_dom'];
			return $res;
		}

		if ((trim($data['crt']) == '') || (trim($data['key']) == '')) {
			$res['code'] = 102;
			$res['message'] = $lang['msg_cert_err_load_certs'];
			return $res;
		}

		$key = str_replace(' ', '+', $data['key']);
		$key = str_replace('BEGIN+PRIVATE+KEY', 'BEGIN PRIVATE KEY', $key);
		$key = str_replace('BEGIN+RSA+PRIVATE+KEY', 'BEGIN RSA PRIVATE KEY', $key);
		$key = str_replace('END+PRIVATE+KEY', 'END PRIVATE KEY', $key);
		$key = str_replace('END+RSA+PRIVATE+KEY', 'END RSA PRIVATE KEY', $key);
		$crt = str_replace(' ', '+', $data['crt']);
		$crt = str_replace('BEGIN+CERTIFICATE', 'BEGIN CERTIFICATE', $crt);
		$crt = str_replace('END+CERTIFICATE', 'END CERTIFICATE', $crt);
		$rootdir = $this->dir_certs . $user . '/';
		file_put_contents('/etc/brainy/data/certs_control/test.key', $key);
		file_put_contents('/etc/brainy/data/certs_control/test.crt', $crt);

		if (trim($data['cabundle']) != '') {
			$chein = str_replace(' ', '+', $data['cabundle']);
			$chein = str_replace('BEGIN+CERTIFICATE', 'BEGIN CERTIFICATE', $chein);
			$chein = str_replace('END+CERTIFICATE', 'END CERTIFICATE', $chein);
			file_put_contents('/etc/brainy/data/certs_control/test.chein', $chein);
			$out_test_chein = implode('', $this->sudo_ssh('openssl verify /etc/brainy/data/certs_control/test.chein /etc/brainy/data/certs_control/test.crt'));

			if (!preg_match('/(test\\.chein\\: OK)/i', $out_test_chein)) {
				$res['code'] = 1;
				$res['message'] = $lang['certs_control_error_validcert_chain'];
				return $res;
			}
		}

		$md5key = $this->sudo_ssh('openssl rsa -noout -modulus -in /etc/brainy/data/certs_control/test.key | md5sum &>/dev/stdout');
		$md5crt = $this->sudo_ssh('openssl x509 -noout -modulus -in /etc/brainy/data/certs_control/test.crt | md5sum &>/dev/stdout');

		if ($md5key[0] != $md5crt[0]) {
			$res['code'] = 1;
			$res['message'] = $lang['certs_control_error_validcert'];
			return $res;
		}

		if (strstr($md5key[0], 'd41d8cd98f00b204e9800998ecf8427e') || strstr($md5crt[0], 'd41d8cd98f00b204e9800998ecf8427e')) {
			$res['code'] = 1;
			$res['message'] = $lang['certs_control_error_validcert'];
			return $res;
		}

		if (!$keyname) {
			$keyname = $domain . '_' . time();
		}

		if (!empty($data['key']) && !empty($data['crt'])) {
			$conf = $this->get_user_data($user);
			$vhost_data = $this->config_read('/etc/brainy/data/vhosts/' . $domain . '.conf');
			$vhost_data['lets_autorenew'] = 0;
			$vhost_data['ssl'] = '1';
			$vhost_data['key'] = $rootdir . $keyname . '.key';
			$vhost_data['crt'] = $rootdir . $keyname . '.crt';
			$vhost_data['mail_ssl'] = $data['mail_ssl'];
			file_put_contents($vhost_data['key'], $key);
			file_put_contents($vhost_data['crt'], $crt);

			if (!empty($data['cabundle'])) {
				$vhost_data['chein'] = $rootdir . $keyname . '.chein';
				file_put_contents($vhost_data['chein'], $chein);
				$crt = trim($crt) . "\n";
				file_put_contents($rootdir . $keyname . '.crt_v2', $crt . $chein);
			}

			$this->config_save('/etc/brainy/data/vhosts/' . $domain . '.conf', $vhost_data, 'add');
			file_put_contents($rootdir . $keyname . '.key', $key);
			file_put_contents($rootdir . $keyname . '.crt', $crt);
			$webserver->webserver_convert_domain($domain, $vhost_data['php'], $vhost_data['bridge']);

			if (is_file('/etc/brainy/data/certs_control/crtlist')) {
				$config = $this->config_read('/etc/brainy/data/certs_control/crtlist');
			}

			if ($config[$keyname] == 'unbinded') {
				$config[$keyname] = $domain;
			}
			else {
				$config .= $keyname;
			}

			$this->config_save('/etc/brainy/data/certs_control/crtlist', $config, 'add');
			$this->removeFromSNI($domain);
			$this->addToSNI($domain, $vhost_data['crt'], $vhost_data['key']);
			$resm['code'] = 0;
			$resm['message'] = $lang['msg_certs_control_certs_info0'] . $rootdir . $keyname . $lang['msg_certs_control_certs_info1'];
			return $resm;
		}
	}

	public function certs_uninstallcrt($domain, $mail_ssl = NULL)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $domain)) {
			return 0;
		}

		global $lang;
		global $lang;
		$vhost_data = $this->config_read('/etc/brainy/data/vhosts/' . $domain . '.conf');
		$vhost_data['ssl'] = '0';
		$vhost_data['key'] = '';
		$vhost_data['crt'] = '';
		$vhost_data['chein'] = '';

		if (isset($mail_ssl)) {
			$vhost_data['mail_ssl'] = $mail_ssl;
		}

		$this->config_save('/etc/brainy/data/vhosts/' . $domain . '.conf', $vhost_data);
		$this->remove_file_a('/etc/httpd/vhost.d/ssl.' . $domain . '.conf');
		$this->remove_file_a('/etc/httpd/vhost.d/!ssl.' . $domain . '.conf');
		$this->remove_file_a('/etc/nginx/sites-available/!ssl.' . $domain . '.conf');
		$this->remove_file_a('/etc/nginx/sites-available/ssl.' . $domain . '.conf');
		$conf = $this->config_read('/etc/brainy/data/server_control/main');

		if ($conf['back_server'] == 'apache2.2') {
			$apache_comm = 'httpd';
		}

		if ($conf['back_server'] == 'apache2.4') {
			$apache_comm = 'httpd';
		}

		$webserver = new webserver();
		$webserver->webservers_reloadconf(0);

		if (is_file('/etc/brainy/data/certs_control/crtlist')) {
			$config = $this->parse_config_read('/etc/brainy/data/certs_control/crtlist', array($domain), '=', array('#'));
		}

		$finded = $config[0];
		$pos = strripos($finded, ',');

		if ($pos === false) {
			$config[0] = 'unbinded';
		}
		else {
			$finded = explode(',', $finded);

			if (($key = array_search($domain, $finded)) !== false) {
				unset($finded[$key]);
			}

			$finded = implode(',', $finded);
			$config[0] = $finded;
		}

		$this->config_save('/etc/brainy/data/certs_control/crtlist', $config, 'add');
		$this->removeFromSNI($domain);
		return $lang['msg_cert_ok_unset_dom'];
	}

	public function certs_allinfo()
	{
		global $lang;
		$domains = $this->certs_getdomains_signed_all();

		foreach ($domains as $key => $value) {
			if (!empty($value)) {
				$cur_domain = $value;
				$cur_vhost_data = $this->config_read('/etc/brainy/data/vhosts/' . $cur_domain . '.conf');
				$cur_user = $cur_vhost_data['user'];
				$user_data = $this->config_read('/etc/brainy/data/users/' . $cur_user);
				$cur_vhost_data['crt'] = explode('.', $cur_vhost_data['crt']);
				$cur_vhost_data['crt'] = $cur_vhost_data['crt'][0];
				$list[$cur_user]['alldomains'][$cur_domain] = array('cert_status' => '', 'owner' => $cur_user, 'root_dir' => $user_data['rootdir'] . '/' . $cur_domain, 'ip' => $user_data['ip'], 'default_domain' => '', 'key_size' => '');
				$list[$cur_user]['alldomains'][$cur_domain]['cert_status'] = 'enabled';

				if (is_file('/etc/httpd/vhost.d/@000-' . $cur_user . '.' . $cur_domain . '.conf')) {
					$list[$cur_user]['alldomains'][$cur_domain]['default_domain'] = 'yes';
				}
				else {
					$list[$cur_user]['alldomains'][$cur_domain]['default_domain'] = 'no';
				}

				if (is_file($cur_vhost_data['key'])) {
					$key_size = $this->sudo_ssh('openssl rsa -in ' . $cur_vhost_data['key'] . ' -text -noout | grep "Private-Key"');
					$list[$cur_user]['alldomains'][$cur_domain]['key_size'] = $key_size[0];
				}
				else {
					$list[$cur_user]['alldomains'][$cur_domain]['key_size'] = $lang['msg_key_not_installed_yet'];
				}

				$list[$cur_user]['alldomains'][$cur_domain]['default_ssl'] = $cur_vhost_data['default_ssl'];
			}
		}

		if (is_array($vhosts_list)) {
			foreach ($vhosts_list as $key => $value) {
				$list[$cur_user]['root'][] = $user_data['rootdir'] . '/' . $value;
			}
		}

		if (is_array($list[$cur_user]['allcerts'])) {
			$no_cert_hosts = array_diff($vhosts_list, $list[$cur_user]['allcerts']);
		}

		$list[$cur_user]['no_cert'] = $no_cert_hosts;
		return $list;
	}

	public function certs_set_vhost_apache($domain)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $domain)) {
			return 0;
		}

		$domain_conf = $this->config_read('/etc/brainy/data/vhosts/' . $domain . '.conf');
		$ip = $domain_conf['ip'];
		$domains = $this->sudo_ssh('grep -rlh \'' . $ip . ':443\' /etc/httpd/vhost.d');

		if ($domain == '!!default') {
			$domain = 'default';
			$new_file = '/etc/httpd/vhost.d/!!ssl.' . $domain . '.conf';
		}
		else {
			$new_file = '/etc/httpd/vhost.d/!ssl.' . $domain . '.conf';
		}

		$dirconf = '/etc/httpd/vhost.d/';
		$old_file = '/etc/httpd/vhost.d/ssl.' . $domain . '.conf';
		$this->sudo_ssh('mv ' . $old_file . ' ' . $new_file);
		$len = strlen('/etc/httpd/vhost.d/');

		foreach ($domains as $key => $val) {
			$n_file = str_replace('!', '', $val);
			$this->sudo_ssh('mv ' . $val . ' ' . $n_file);
		}

		$this->sudo_ssh('mv ' . $old_file . ' ' . $new_file);
	}

	public function certs_set_vhost_nginx($domain)
	{
		$domain_conf = $this->config_read('/etc/brainy/data/vhosts/' . $domain . '.conf');
		$ip = $domain_conf['ip'];
		$domains = $this->sudo_ssh('grep -rlh \'' . $ip . ':443\' /etc/nginx/sites-available');
		$dirconf = '/etc/nginx/sites-available/';
		$old_file = '/etc/nginx/sites-available/ssl.' . $domain . '.conf';
		$new_file = '/etc/nginx/sites-available/!ssl.' . $domain . '.conf';
		$this->sudo_ssh('mv ' . $old_file . ' ' . $new_file);
		$len = strlen('/etc/nginx/sites-available/');

		foreach ($domains as $key => $val) {
			$n_file = str_replace('!', '', $val);
			$this->sudo_ssh('mv ' . $val . ' ' . $n_file);
		}

		$this->sudo_ssh('mv ' . $old_file . ' ' . $new_file);
	}

	public function certs_def_domain($user, $domain, $webobj)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $domain)) {
			return 0;
		}

		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $user)) {
			return 0;
		}

		$domain_conf = $this->config_read('/etc/brainy/data/vhosts/' . $domain . '.conf');
		$ip = $domain_conf['ip'];
		$domains = $this->sudo_ssh('grep -rl \'ip="' . $ip . '"\' /etc/brainy/data/vhosts');

		foreach ($domains as $value) {
			$foo = $this->config_read($value);

			if ($foo['default_ssl'] == 1) {
				$arr = array('default_ssl' => '0');
				$this->config_save($value, $arr, 'add');
			}
		}

		$arr = array('default_ssl' => '1');
		$this->config_save('/etc/brainy/data/vhosts/' . $domain . '.conf', $arr, 'add');
		$conf = $this->config_read('/etc/brainy/data/server_control/main');
		if (($conf['back_server'] == 'nginx') || ($conf['front_server'] == 'nginx')) {
			$this->certs_set_vhost_nginx($domain);
		}
		else {
			$this->certs_set_vhost_apache($domain);
		}

		if ($conf['back_server'] == 'apache2.2') {
			$apache_comm = 'httpd';
		}

		if ($conf['back_server'] == 'apache2.4') {
			$apache_comm = 'httpd';
		}

		$webserver = new webserver();
		$webserver->webservers_reloadconf(0);
	}

	public function certs_allinfo_client($user)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $user)) {
			return 0;
		}

		global $lang;
		$value = $user;
		$domains = $this->certs_getdomains_signed($value);
		$cur_user = $value;
		$list[$cur_user]['allcerts'] = $domains;
		$user_data = $this->get_user_data($cur_user);
		$rootdir = $user_data['rootdir'];

		if (is_array($domains)) {
			foreach ($domains as $key => $value) {
				$res = $this->new_filelist('/etc/httpd/vhost.d/', 'ssl.' . $value . '.conf', 'f');
				$list[$cur_user]['keys'][] = $key;

				if (!empty($res)) {
					$res = $res['three'][''][''][0];
					$res = explode('.', $res);
					unset($res[0]);
					$len = count($res);
					unset($res[$len]);
					$res = implode('.', $res);

					if (!empty($res)) {
						$list[$cur_user]['enabled'][] = $res;
					}
				}
			}
		}

		if (!empty($list[$cur_user]['enabled'])) {
			$list[$cur_user]['disabled'] = array_diff($list[$cur_user]['allcerts'], $list[$cur_user]['enabled']);
		}
		else {
			$list[$cur_user]['disabled'] = $list[$cur_user]['allcerts'];
		}

		$list[$cur_user]['ip'] = $user_data['ip'];
		$vhost_list = explode(',', $user_data['vhost_list']);

		foreach ($vhost_list as $key => $value) {
			if (!empty($value)) {
				$exp = explode(':', $value);
				$vhosts_list[] = $exp[0];
				$cur_domain = $exp[0];
				$cur_vhost_data = $this->config_read('/etc/brainy/data/vhosts/' . $cur_domain . '.conf');
				$cur_vhost_data['crt'] = substr($cur_vhost_data['crt'], 0, strrpos($cur_vhost_data['crt'], '.'));
				$puny = new idna_convert();
				$list[$cur_user]['alldomains'][$cur_domain] = array('cert_status' => '', 'owner' => $cur_user, 'root_dir' => $user_data['rootdir'] . '/' . $cur_domain, 'ip' => $user_data['ip'], 'default_domain' => '', 'key_size' => '', 'puny_domain' => $puny->decode(trim($cur_domain)));
				$list[$cur_user]['alldomains'][$cur_domain]['lets_autorenew'] = $cur_vhost_data['lets_autorenew'];

				if (in_array($cur_domain, $list[$cur_user]['enabled'])) {
					$list[$cur_user]['alldomains'][$cur_domain]['cert_status'] = 'enabled';
					$list[$cur_user]['alldomains'][$cur_domain]['current_cert'] = $cur_vhost_data['crt'];
					$list[$cur_user]['alldomains'][$cur_domain]['current_key'] = $cur_vhost_data['key'];
				}

				if (in_array($cur_domain, $list[$cur_user]['disabled'])) {
					$list[$cur_user]['alldomains'][$cur_domain]['cert_status'] = 'disabled';
					$list[$cur_user]['alldomains'][$cur_domain]['current_cert'] = $cur_vhost_data['crt'];
					$list[$cur_user]['alldomains'][$cur_domain]['current_key'] = $cur_vhost_data['key'];
				}

				if (!in_array($cur_domain, $list[$cur_user]['allcerts'])) {
					$list[$cur_user]['alldomains'][$cur_domain]['cert_status'] = $lang['msg_cert_not_installed_yet'];
					$list[$cur_user]['alldomains'][$cur_domain]['current_cert'] = $lang['msg_cert_not_installed_yet'];
				}

				$list[$cur_user]['alldomains'][$cur_domain]['mail_ssl'] = $cur_vhost_data['mail_ssl'];

				if (is_file('/etc/httpd/vhost.d/@000-' . $cur_user . '.' . $cur_domain . '.conf')) {
					$list[$cur_user]['alldomains'][$cur_domain]['default_domain'] = 'yes';
				}
				else {
					$list[$cur_user]['alldomains'][$cur_domain]['default_domain'] = 'no';
				}

				$list[$cur_user]['alldomains'][$cur_domain]['default_ssl'] = $cur_vhost_data['default_ssl'];
				$list[$cur_user]['alldomains'][$cur_domain]['dom_ip'] = $cur_vhost_data['ip'];

				if (is_file($list[$cur_user]['alldomains'][$cur_domain]['current_key'])) {
					$key_size = $this->sudo_ssh(' openssl rsa -in ' . $cur_vhost_data['key'] . ' -text -noout | grep "Private-Key"');
					$list[$cur_user]['alldomains'][$cur_domain]['key_size'] = $key_size[0];
					$cert = file_get_contents($list[$cur_user]['alldomains'][$cur_domain]['current_cert'] . '.crt');
					$info_cert = $this->service_ssl_getinfo($cert, $list[$cur_user]['alldomains'][$cur_domain]['current_cert'] . '.key');
					$list[$cur_user]['alldomains'][$cur_domain]['time'] = $info_cert['time'];
					$list[$cur_user]['alldomains'][$cur_domain]['issuer'] = $info_cert['issuer'];
					$list[$cur_user]['alldomains'][$cur_domain]['time_from'] = $info_cert['time_from'];
				}
				else {
					$list[$cur_user]['alldomains'][$cur_domain]['key_size'] = $lang['msg_key_not_installed_yet'];
				}
			}
		}

		if (is_array($vhosts_list)) {
			foreach ($vhosts_list as $key => $value) {
				$list[$cur_user]['root'][] = $user_data['rootdir'] . '/' . $value;
			}
		}

		if (is_array($list[$cur_user]['allcerts'])) {
			$no_cert_hosts = array_diff($vhosts_list, $list[$cur_user]['allcerts']);
			$list[$cur_user]['no_cert'] = $no_cert_hosts;
		}

		return $list;
	}

	public function create_letencert($user, $domain, $crt, $webserver, $mail_ssl = NULL)
	{
		global $server;
		$path_todatacert = '/etc/brainy/data/certs_control/';
		$username_oper = $server->user['username'];
		$currun = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($path_todatacert . $username_oper));
		$qexist = 0;

		foreach ($currun as $key => $item_stream) {
			if (3 < strlen($item_stream)) {
				$qexist = 1;
				$result['inprogress'] = 1;
				$out = $this->read_stream($item_stream, 1);
				unset($out[0]);
				unset($out[1]);

				if (is_null($out)) {
					$out = array();
				}

				$result['message'] = implode('', $out);
				$result['error'] = '0';
				$pid = $this->getexistpid($item_stream);

				if ($pid == -1) {
					unset($currun[$key]);
				}
			}
		}

		file_put_contents($path_todatacert . $username_oper, '');

		foreach ($currun as $key => $item_stream) {
			if (3 < strlen($item_stream)) {
				file_put_contents($path_todatacert . $username_oper, $item_stream . "\n", FILE_APPEND);
			}
		}

		if (($qexist == 0) && ($_GET['check'] != 1)) {
			$param = array('username_oper' => $username_oper, 'user' => $user, 'domain' => $domain, 'crt' => $crt, 'webserver' => $webserver, 'mail_ssl' => $mail_ssl);
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/certs.php -a=\'create_letencert\' -p=\'' . json_encode($param) . '\'';
			$stream_id = $this->create_stream($stream);
			$out = $this->read_stream($item_stream, 1);
			unset($out[0]);
			unset($out[1]);

			if (is_null($out)) {
				$out = array();
			}

			$result['message'] = implode('', $out);
			$result['inprogress'] = 1;
			$result['error'] = '0';

			if (!is_dir($path_todatacert)) {
				$this->ssh('mkdir -p ' . $path_todatacert);
			}

			file_put_contents($path_todatacert . $username_oper, $stream_id . "\n", FILE_APPEND);
		}

		if (!$result) {
			$result['message'] = '';
			$result['inprogress'] = 0;
			$result['error'] = '0';
		}

		return $result;
	}

	public function create_letencert2($user, $domain, $crt, $webserver, $mail_ssl = NULL)
	{
		global $lang;

		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $domain)) {
			return 0;
		}

		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $user)) {
			return 0;
		}

		$conf = $this->get_user_data($user);
		$vhost_data = $this->config_read('/etc/brainy/data/vhosts/' . $domain . '.conf');
		$dir = $vhost_data['dir'];
		$alias_list = explode(',', $vhost_data['aliases']);
		$list_dom_cert = ' -d ' . $domain;
		$qflagAllowChange = 0;

		if (is_file('/etc/httpd/vhost.d/' . $domain . '.conf')) {
			file_put_contents($dir . '/.well-known/acme-challenge/test', 'readtest');
			$resTest = file_get_contents('http://' . $domain . '/.well-known/acme-challenge/test');

			if (stripos($resTest, 'readtest') !== false) {
				$qflagAllowChange = 1;
				$this->ssh('sed -i "/AllowOverride/cAllowOverride None" ' . '/etc/httpd/vhost.d/' . $domain . '.conf');
				$this->monitor_comm_os('httpd', 'reload');
			}
		}

		foreach ($alias_list as $curalias) {
			if (1 < strlen($curalias)) {
				$list_dom_cert .= ' -d ' . $curalias;
			}
		}

		$vhost_data['letencrypt0'] = '<Directory \'' . $dir . '/.well-known\'>';
		$vhost_data['letencrypt1'] = 'Options Indexes FollowSymLinks Includes ExecCGI';
		$vhost_data['letencrypt2'] = 'ForceType \'text/plain\'';
		$vhost_data['letencrypt3'] = 'AddDefaultCharset 0';
		$vhost_data['letencrypt4'] = 'Order deny,allow';
		$vhost_data['letencrypt5'] = 'Allow from all';
		$vhost_data['letencrypt6'] = '</Directory>';
		$this->config_save('/etc/brainy/data/vhosts/' . $domain . '.conf', $vhost_data, 'add');
		$webserver = new webserver();
		$webserver->webserver_convert_domain($domain, $vhost_data['php'], $vhost_data['bridge']);
		$users = $this->config_read('/etc/brainy/data/users/' . $user);
		$rootcert = $this->dir_certs . $user;
		$this->sudo_ssh('mkdir -p ' . $rootcert);
		$b = true;
		$typeer = 0;
		$time = date('d-m-Y_h:i:s', time());
		$conf_web = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);

		if (is_file('/etc/letsencrypt/renewal/' . $domain . '.conf')) {
			$this->ssh('rm -f ' . '/etc/letsencrypt/renewal/' . $domain . '.conf');
			$this->ssh('rm -rf ' . '/etc/letsencrypt/archive/' . $domain);
			$this->ssh('rm -rf ' . '/etc/letsencrypt/live/' . $domain);

			if (stripos($GLOBALS['OS_VERSION'], 'centos6') !== false) {
				$out = $this->sudo_ssh('scl enable python27 "/usr/local/bin/certbot-auto certonly --force-renew --register-unsafely-without-email --agree-tos --webroot-path ' . $vhost_data['dir'] . ' --webroot -n ' . $list_dom_cert . '" &>/dev/stdout');
			}
			else {
				$out = $this->sudo_ssh('/usr/local/bin/certbot-auto certonly --force-renew --register-unsafely-without-email --agree-tos --webroot-path ' . $vhost_data['dir'] . ' --webroot -n ' . $list_dom_cert . ' &>/dev/stdout');
			}

			$out = implode(' <br>', $out);

			if (strstr($out, 'not yet due for renewal')) {
				$typeer = 1;
				$b = false;
				$out = $lang['certs_control_letsfailedexistgen'] . $domain;
			}

			if (($typeer == 1) || ($b == true)) {
				$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domain . '/cert.pem ' . $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.crt');
				$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domain . '/chain.pem ' . $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.chein');
				$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domain . '/privkey.pem ' . $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.key');
				$crt_load = file_get_contents($rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.crt');
				$chain_load = file_get_contents($rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.chein');
				$crt_load = trim($crt_load) . "\n";
				file_put_contents($rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.crt_v2', $crt_load . $chain_load);
			}

			if ($b == true) {
				if (!is_file('/etc/letsencrypt/live/' . $domain . '/cert.pem')) {
					$b = false;
				}
				else {
					$out = $lang['msg_cert_let_info0'] . ' ' . $domain . ' ' . $lang['msg_cert_let_info1'];
				}
			}
		}
		else {
			$this->sudo_ssh('mkdir -p ' . $dir . '/.well-known/acme-challenge/');

			if (stripos($GLOBALS['OS_VERSION'], 'centos6') !== false) {
				$out = $this->sudo_ssh('scl enable python27 "/usr/local/bin/certbot-auto certonly --register-unsafely-without-email --webroot --agree-tos --webroot-path ' . $dir . ' ' . $list_dom_cert . '" &>/dev/stdout');
			}
			else {
				$out = $this->sudo_ssh('/usr/local/bin/certbot-auto certonly --register-unsafely-without-email --webroot --agree-tos --webroot-path ' . $dir . ' ' . $list_dom_cert . ' &>/dev/stdout');
			}

			$out = implode(' <br>', $out);

			if (strstr($out, 'Congratulations!')) {
				$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domain . '/cert.pem ' . $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.crt');
				$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domain . '/chain.pem ' . $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.chein');
				$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domain . '/privkey.pem ' . $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.key');
				$crt_load = file_get_contents($rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.crt');
				$chain_load = file_get_contents($rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.chein');
				$crt_load = trim($crt_load) . "\n";
				file_put_contents($rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.crt_v2', $crt_load . $chain_load);
				$out = $lang['msg_cert_let_info0'] . ' ' . $domain . ' ' . $lang['msg_cert_let_info1'];
			}
			else {
				$typeer = 2;
				$b = false;
			}
		}

		if (($b == true) || ($typeer == 1)) {
			$vhost_data['ssl'] = '1';
			$vhost_data['key'] = $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.key';
			$vhost_data['crt'] = $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.crt';
			$vhost_data['chein'] = $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.chein';

			if (isset($mail_ssl)) {
				$vhost_data['mail_ssl'] = $mail_ssl;
			}

			if (is_file('/etc/letsencrypt/options-ssl-apache.conf')) {
				$vhost_data['ssl_options'] = '/etc/letsencrypt/options-ssl-apache.conf';
			}

			$this->config_save('/etc/brainy/data/vhosts/' . $domain . '.conf', $vhost_data, 'add');
			$webserver->webserver_convert_domain($domain, $vhost_data['php'], $vhost_data['bridge']);
			$this->removeFromSNI($domain);
			$this->addToSNI($domain, $vhost_data['crt'], $vhost_data['key']);
		}
		else {
			$vhost_data['ssl'] = '0';
			$vhost_data['mail_ssl'] = '0';
			$this->config_save('/etc/brainy/data/vhosts/' . $domain . '.conf', $vhost_data, 'add');
			$webserver->webserver_convert_domain($domain, $vhost_data['php'], $vhost_data['bridge']);
			$this->removeFromSNI($domain);

			if ($typeer != 1) {
				$qEr1 = 0;

				if (stripos($out, 'DNS problem: NXDOMAIN looking up A') !== false) {
					$domParse = explode('DNS problem: NXDOMAIN looking up A for ', $out)[1];
					$domParse = explode(' ', $domParse)[0];
					$out = $lang['certs_control_failed_gen_letsen'] . '<br/>' . $lang['certs_error_nxdomaingencertlets'] . $domParse;
					$qEr1 = 1;
				}

				if (stripos($out, 'The client lacks sufficient authorization :: Invalid response from') !== false) {
					$domParse = explode('The client lacks sufficient authorization :: Invalid response from ', $out)[1];
					$domParse = explode(' ', $domParse)[0];
					$out = $lang['certs_control_failed_gen_letsen'] . '<br/>' . $lang['certs_error_genletssuffauth'] . $domParse . '<br/>' . $lang['certs_error_genletssuffauth_check'];
					$qEr1 = 1;
				}

				if ($qEr1 == 0) {
					if (preg_match('/too many certificates/iu', $out)) {
						$out = $lang['certs_too_many_cert'] . '<br/>' . $out;
					}
					else if (preg_match('/too many requests/iu', $out)) {
						$out = $lang['certs_too_many_error'] . '<br/>' . $out;
					}
					else {
						$out = $lang['certs_control_failed_gen_letsen'] . '<br/>' . $out;
					}
				}
			}
		}

		if ($qflagAllowChange == 1) {
			$this->ssh('sed -i "/AllowOverride/cAllowOverride All" ' . '/etc/httpd/vhost.d/' . $domain . '.conf');
			$this->monitor_comm_os('httpd', 'reload');
		}

		return $out;
	}

	public function getkeybycertfile($user, $cert)
	{
		$rootdir = $this->dir_certs . $user . '/';
		$md5crt = $this->sudo_ssh('openssl x509 -noout -modulus -in \'' . $rootdir . $cert . '.crt\'' . ' | md5sum &>/dev/stdout');
		$out = $this->certs_getkeys($user);
		$list = array();
		$i = 0;

		while ($i < count($out)) {
			$out[$i] = escapeshellcmd($out[$i]);
			$md5key = $this->sudo_ssh('openssl rsa -noout -modulus -in \'' . $rootdir . $out[$i] . '.key\'' . ' | md5sum &>/dev/stdout');

			if (($md5key == $md5crt) && ($md5key != 'd41d8cd98f00b204e9800998ecf8427e -')) {
				return $out[$i];
			}

			++$i;
		}
	}

	public function save_full_cert($user, $domain, $crt, $webserver, $mail_ssl = NULL)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $domain)) {
			return 0;
		}

		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $user)) {
			return 0;
		}

		global $lang;

		if ($crt == 'no_cert') {
			$this->certs_uninstallcrt($domain, $mail_ssl);
			$vhost_data = $this->config_read('/etc/brainy/data/vhosts/' . $domain . '.conf');
			$vhost_data['default_ssl'] = 0;
			$this->config_save('/etc/brainy/data/vhosts/' . $domain . '.conf', $vhost_data, 'add');
			$webserver->webserver_convert_domain($domain);
			return $lang['msg_cert_ok_unset_dom'];
		}

		if (!empty($crt)) {
			$conf = $this->get_user_data($user);
			$rootdir = $this->dir_certs . $user . '/';
			$vhost_data = $this->config_read('/etc/brainy/data/vhosts/' . $domain . '.conf');
			$vhost_data['ssl'] = '1';
			$keyfilepath = $this->getkeybycertfile($user, $crt);
			$vhost_data['key'] = $rootdir . $keyfilepath . '.key';
			$vhost_data['crt'] = $rootdir . $crt . '.crt';
			if (strstr($crt, 'letencrypt') || strstr($crt, 'letsen')) {
				$vhost_data['chein'] = $rootdir . $crt . '.chein';
			}

			if (is_file($rootdir . $crt . '.chein')) {
				$vhost_data['chein'] = $rootdir . $crt . '.chein';
			}
			else {
				$vhost_data['chein'] = '';
			}

			if (isset($mail_ssl)) {
				$vhost_data['mail_ssl'] = $mail_ssl;
			}

			if (is_file('/etc/letsencrypt/options-ssl-apache.conf')) {
				$vhost_data['ssl_options'] = '/etc/letsencrypt/options-ssl-apache.conf';
			}

			$this->config_save('/etc/brainy/data/vhosts/' . $domain . '.conf', $vhost_data, 'add');
			$webserver->webserver_convert_domain($domain, $vhost_data['php'], $vhost_data['bridge']);

			if (is_file('/etc/brainy/data/certs_control/crtlist')) {
				$config = $this->config_read('/etc/brainy/data/certs_control/crtlist');
			}

			if ($config[$keyname] == 'unbinded') {
				$config[$keyname] = $domain;
			}
			else {
				$config .= $keyname;
			}

			$this->config_save('/etc/brainy/data/certs_control/crtlist', $config, 'add');
			$this->removeFromSNI($domain);
			$this->addToSNI($domain, $vhost_data['crt'], $vhost_data['key']);
			return $lang['msg_cert_installed_ok'];
		}
	}

	public function service_ssl_getinfo($cert, $pkey)
	{
		$cert_info = openssl_x509_parse($cert);
		$time_from = date('d.m.Y H:i:s', $cert_info['validFrom_time_t']);
		$time = date('d.m.Y H:i:s', $cert_info['validTo_time_t']);
		$issue = $cert_info['issuer']['O'];
		$domains = $cert_info['extensions']['subjectAltName'];
		$domains = str_replace('DNS:', '', $domains);

		if (strlen($domains) < 2) {
			$domains = $cert_info['subject']['CN'];
		}

		$comm = 'openssl rsa -in ' . $pkey . ' -text -noout | grep "Private-Key"';
		$keysize = $this->ssh($comm);
		$keysize = str_replace('Private-Key: (', '', $keysize[0]);
		$keysize = str_replace(')', '', $keysize);
		$res['time'] = $time;
		$res['time_from'] = $time_from;
		$res['issuer'] = $issue;
		$res['domains'] = $domains;
		$res['keysize'] = $keysize;
		return $res;
	}

	public function service_getlist_cert()
	{
		$com_ssl_cert = 'find /etc/brainy/src/ssl/ -name \'*.crt\' | sed \'s/.*\\///\'';
		$cert_list = $this->ssh($com_ssl_cert);
		$count = count($cert_list);
		$j = 0;
		$cert_list2 = array();
		$i = 0;

		while ($i < $count) {
			$checkexist = file_get_contents('/etc/brainy/src/ssl/' . $cert_list[$i]);

			if (10 < strlen($checkexist)) {
				$cert_list2[$j] = str_replace('./', '', $cert_list[$i]);
				$cert_list2[$j] = basename($cert_list[$i], '.crt');
				++$j;
			}

			++$i;
		}

		return $cert_list2;
	}

	public function service_certs_load()
	{
		$file_list = '/etc/brainy/data/certs_control/service_cert.conf';
		$list_service_cert = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($file_list));
		$res = array();

		foreach ($list_service_cert as $serv_cert) {
			if (strlen($serv_cert) < 2) {
				continue;
			}

			$exp_serv_cert = explode('=', $serv_cert);
			$res[$exp_serv_cert[0]]['path'] = $exp_serv_cert[1];
			$path = str_replace('"', '', $exp_serv_cert[1]);
			$cert = file_get_contents($path);
			$file_name = basename($path);
			$file_name = str_replace('"', '', $file_name);
			$file_name = basename($file_name, '.crt');
			$path = pathinfo($path)['dirname'];
			$path = str_replace('"', '', $path);
			$info_cert = $this->service_ssl_getinfo($cert, $path . '/' . $file_name . '.key');
			$res[$exp_serv_cert[0]]['time'] = $info_cert['time'];
			$res[$exp_serv_cert[0]]['time_from'] = $info_cert['time_from'];
			$res[$exp_serv_cert[0]]['issuer'] = $info_cert['issuer'];
			$res[$exp_serv_cert[0]]['domains'] = $info_cert['domains'];
			$res[$exp_serv_cert[0]]['keysize'] = $info_cert['keysize'];
		}

		return $res;
	}

	public function updatecert_service_brainy($service_name, $crt, $key, $chain)
	{
		if ($service_name == 'brainy') {
			if (file_exists('/etc/nginxb') || file_exists('/etc/brainy/src/compiled/nginxb')) {
				$this->brainy_cert = '/etc/brainy/src/compiled/php5/ssl/brainy.crt';
				$this->brainy_key = '/etc/brainy/src/compiled/php5/ssl/brainy.key';
				$this->brainy_chain = '/etc/brainy/src/compiled/php5/ssl/brainy.chain';
			}

			if (2 < strlen($crt)) {
				file_put_contents($this->brainy_cert, $crt);
				file_put_contents($this->brainy_key, $key);
				file_put_contents($this->brainy_chain, $chain);
				$comm = 'sed -i "/SSLEngine On/s/^#//" ' . $this->brainy_conf;
				$this->ssh($comm);
				$comm = 'sed -i "/SSLCertificateFile \\/etc\\/brainy/s/^#//" ' . $this->brainy_conf;
				$this->ssh($comm);
				$comm = 'sed -i "/SSLCertificateKeyFile/s/^#//" ' . $this->brainy_conf;
				$this->ssh($comm);

				if (2 < strlen($chain)) {
					$comm = 'sed -i "/SSLCertificateChainFile/s/^#//" ' . $this->brainy_conf;
					$this->ssh($comm);
				}
				else {
					$comm = 'sed -i "/SSLCertificateChainFile/s/^/#/" ' . $this->brainy_conf;
					$this->ssh($comm);
				}
			}
			else {
				file_put_contents($this->brainy_cert, $crt);
				file_put_contents($this->brainy_key, $key);
				file_put_contents($this->brainy_chain, $chain);
				$comm = 'sed -i "/SSLEngine On/s/^/#/" ' . $this->brainy_conf;
				$this->ssh($comm);
				$comm = 'sed -i "/SSLCertificateFile \\/etc\\/brainy/s/^/#/" ' . $this->brainy_conf;
				$this->ssh($comm);
				$comm = 'sed -i "/SSLCertificateKeyFile/s/^/#/" ' . $this->brainy_conf;
				$this->ssh($comm);
				$comm = 'sed -i "/SSLCertificateChainFile/s/^/#/" ' . $this->brainy_conf;
				$this->ssh($comm);
			}

			$this->monitor_comm_os('brainy', 'restart');
		}
	}

	public function apply_exist_cert($serialdata)
	{
		$path_cert = '/etc/brainy/src/ssl/';
		$decode = json_decode($serialdata, true);
		$service_name = $decode['servname'];
		$exist_cert = $decode['cert_path'];

		if (!$this->check_value('string', $service_name)) {
			return false;
		}

		if (!$this->check_value('string', $exist_cert)) {
			return false;
		}

		$path_exist_cert = $path_cert . $exist_cert . '.crt';
		$cert = file_get_contents($path_exist_cert);
		file_put_contents($path_cert . $service_name . '.crt', $cert);
		$key = file_get_contents($path_cert . $exist_cert . '.key');
		file_put_contents($path_cert . $service_name . '.key', $key);
		$cert_ba = file_get_contents($path_cert . $exist_cert . '.ca-bundle');
		file_put_contents($path_cert . $service_name . '.ca-bundle', $cert_ba);
		$cert = trim($cert) . "\n";
		file_put_contents($path_cert . $service_name . '.crt_v2', $cert . $cert_ba);
		if (($service_name == 'smtp') || ($service_name == 'ftp')) {
			if (!file_exists('/var/lib/ssl')) {
				$this->ssh('mkdir /var/lib/ssl ; chmod 755 /var/lib/ssl');
			}

			file_put_contents('/var/lib/ssl/' . $service_name . '.crt', $cert);
			file_put_contents('/var/lib/ssl/' . $service_name . '.key', $key);
		}

		if ($service_name == 'ftp') {
			$this->ssh('cat /etc/brainy/src/ssl/ftp.crt /etc/brainy/src/ssl/ftp.key >/var/lib/ssl/ftp.pem');
			$this->monitor_comm_os('pure-ftpd', 'restart');
			$this->monitor_comm_os('proftpd', 'restart');
		}

		global $lang;
		$res['code'] = 0;
		$res['message'] = $lang['service_applyexist_ok'];
		$webserver = new webserver();
		$webserver->webserver_convert_domain('!!default');
		$webserver->webservers_reloadconf(1);
		$this->updatecert_service_brainy($service_name, $cert, $key, $cert_ba);
		return $res;
	}

	public function service_install_newcert($cert, $key, $cabundle, $listservice, $check_install = 0)
	{
		global $lang;
		$out_install_stream = $this->config_read('/etc/brainy/data/certs_control/main');
		$this->module_vars = $out_install_stream;
		$one = $this->module_vars['cert_service'];
		$one = explode(',', $one);

		if (($one[0] == 'inprogress') && ($check_install == 1)) {
			$res['code'] = 2222;
			return $res;
		}

		if (($one[0] == 'succes') && ($check_install == 1)) {
			file_put_contents('/etc/brainy/data/certs_control/main', '');
			$res['code'] = 0;
			$res['message'] = $lang['service_install_new_ok'];
			return $res;
		}

		$rescheck = $this->certs_check_valid($cert, $key, $cabundle);

		if ($rescheck['code'] != 0) {
			return $rescheck;
		}

		$param = array('cert' => $cert, 'key' => $key, 'cabundle' => $cabundle, 'listservice' => $listservice);
		$stream[0]['array_start'] = array('cert_service' => 'inprogress,#stream_id#,#stream_pid#');
		$stream[0]['array_succes'] = array('cert_service' => 'succes,#stream_id#');
		$stream[0]['array_unsucces'] = array('cert_service' => 'unsucces,#stream_id#', 'install_cert_service_error' => '#error#');
		$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/certs.php -a=\'install_cert_service\' -p=\'' . json_encode($param) . '\'';
		$stream_id = $this->create_stream($stream);
		$res['code'] = 2222;
		return $res;
	}

	public function reinstall_cert_prep($serialdata)
	{
		$decode = json_decode($serialdata, 1);
		$servname = $decode['servname'];

		if (!$this->check_value('filename_without_dot', $servname)) {
			return false;
		}

		$file_list = '/etc/brainy/data/certs_control/service_cert.conf';
		$list_service_cert = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($file_list));

		foreach ($list_service_cert as $serv_cert) {
			$exp_serv_cert = explode('=', $serv_cert);
			$nameserv = $exp_serv_cert[0];
			$pathserv_cert = $exp_serv_cert[1];

			if ($nameserv == $servname) {
				$file_name = basename($pathserv_cert);
				$file_name = str_replace('"', '', $file_name);
				$file_name = basename($file_name, '.crt');
				$path = pathinfo($pathserv_cert)['dirname'];
				$path = str_replace('"', '', $path);
				$res_cert['cert'] = file_get_contents($path . '/' . $file_name . '.crt');
				$res_cert['key'] = file_get_contents($path . '/' . $file_name . '.key');
				$res_cert['cabundle'] = file_get_contents($path . '/' . $file_name . '.ca-bundle');
				$info_cert = $this->service_ssl_getinfo($res_cert['cert'], $path . '/' . $file_name . '.key');
				$res_cert['time'] = $info_cert['time'];
				$res_cert['time_from'] = $info_cert['time_from'];
				$res_cert['issuer'] = $info_cert['issuer'];
				$res_cert['domains'] = $info_cert['domains'];
				$res_cert['keysize'] = $info_cert['keysize'];

				if ($info_cert['domains'] == gethostname()) {
					$vhost_data = $this->config_read('/etc/brainy/data/vhosts/!!default.conf');
					$res_cert['stat_autorenew'] = intval($vhost_data['lets_autorenew']);
				}
			}
		}

		$webserver = new webserver();
		$webserver->webserver_convert_domain('!!default');
		$webserver->webservers_reloadconf(1);
		return $res_cert;
	}

	public function service_del_cert($serialdata)
	{
		global $lang;
		$path_cert = '/etc/brainy/src/ssl/';
		$decode = json_decode($serialdata, 1);
		$servname = $decode['servname'];

		if (!$this->check_value('filename_without_dot', $servname)) {
			return false;
		}

		file_put_contents($path_cert . '/' . $servname . '.crt', '');
		file_put_contents($path_cert . '/' . $servname . '.key', '');
		file_put_contents($path_cert . '/' . $servname . '.ca-bundle', '');
		$res['code'] = 0;
		$res['message'] = $lang['service_cert_del_complete'];
		$webserver = new webserver();
		$webserver->webserver_convert_domain('!!default');
		$webserver->webservers_reloadconf(1);
		$this->updatecert_service_brainy($servname, '', '', '');
		return $res;
	}

	public function service_cert_view($serialdata)
	{
		return $this->reinstall_cert_prep($serialdata);
	}

	public function certs_letencrypt_check()
	{
		$pm = new packet_manager();
		$service = 'certbot';
		$patch = '/usr/local/bin/certbot-auto';
		$arr = $pm->pm_get_cur_status($service, $patch);
		return intval($arr['progress']);
	}

	public function certs_check_valid($cert, $key, $cabundle)
	{
		global $lang;
		if ((strlen(trim($cert)) == 0) || (strlen(trim($key)) == 0)) {
			$res['code'] = 1;
			$res['message'] = $lang['msg_cert_err_load_certs'];
			return $res;
		}

		$key = str_replace(' ', '+', $key);
		$key = str_replace('BEGIN+PRIVATE+KEY', 'BEGIN PRIVATE KEY', $key);
		$key = str_replace('END+PRIVATE+KEY', 'END PRIVATE KEY', $key);
		$key = str_replace('BEGIN+RSA+PRIVATE+KEY', 'BEGIN RSA PRIVATE KEY', $key);
		$key = str_replace('END+RSA+PRIVATE+KEY', 'END RSA PRIVATE KEY', $key);
		$crt = str_replace(' ', '+', $cert);
		$crt = str_replace('BEGIN+CERTIFICATE', 'BEGIN CERTIFICATE', $crt);
		$crt = str_replace('END+CERTIFICATE', 'END CERTIFICATE', $crt);
		$crt_bundle = str_replace(' ', '+', $cabundle);
		$crt_bundle = str_replace('BEGIN+CERTIFICATE', 'BEGIN CERTIFICATE', $crt_bundle);
		$crt_bundle = str_replace('END+CERTIFICATE', 'END CERTIFICATE', $crt_bundle);
		file_put_contents('/etc/brainy/data/certs_control/test.key', $key);
		file_put_contents('/etc/brainy/data/certs_control/test.crt', $crt);

		if (trim($cabundle) != '') {
			file_put_contents('/etc/brainy/data/certs_control/test_bundle.crt', $crt_bundle);
			$chein = str_replace(' ', '+', $cabundle);
			$chein = str_replace('BEGIN+CERTIFICATE', 'BEGIN CERTIFICATE', $chein);
			$chein = str_replace('END+CERTIFICATE', 'END CERTIFICATE', $chein);
			file_put_contents('/etc/brainy/data/certs_control/test.chein', $chein);
			$md5bundle = $this->sudo_ssh('openssl x509 -noout -modulus -in /etc/brainy/data/certs_control/test_bundle.crt | md5sum &>/dev/stdout');

			if (strstr($md5bundle[0], 'd41d8cd98f00b204e9800998ecf8427e')) {
				$md5bundle = $this->sudo_ssh('openssl x509 -noout -modulus -in /etc/brainy/data/certs_control/test.chein | md5sum &>/dev/stdout');
			}
		}

		$md5key = $this->sudo_ssh('openssl rsa -noout -modulus -in /etc/brainy/data/certs_control/test.key | md5sum &>/dev/stdout');
		$md5crt = $this->sudo_ssh('openssl x509 -noout -modulus -in /etc/brainy/data/certs_control/test.crt | md5sum &>/dev/stdout');
		$res['code'] = 0;

		if ($md5key[0] != $md5crt[0]) {
			$res['code'] = 1;
			$res['message'] = $lang['certs_control_error_validcert'];
			return $res;
		}

		if (strstr($md5key[0], 'd41d8cd98f00b204e9800998ecf8427e') || strstr($md5crt[0], 'd41d8cd98f00b204e9800998ecf8427e')) {
			$res['code'] = 1;
			$res['message'] = $lang['certs_control_error_validcert'];
			return $res;
		}

		if (5 < strlen(trim($cabundle))) {
			if (strstr($md5bundle[0], 'd41d8cd98f00b204e9800998ecf8427e')) {
				$res['code'] = 1;
				$res['message'] = $lang['certs_control_error_validcert'];
				return $res;
			}
		}

		return $res;
	}

	public function rebuild_sni_file()
	{
		file_put_contents($this->snifile, '', LOCK_EX);
		$dir = opendir($GLOBALS['DATA_VHOSTS']);

		while (false !== $filename = readdir($dir)) {
			if ($filename[0] == '.') {
				continue;
			}

			$domains[] = substr($filename, 0, strrpos($filename, '.'));
		}

		foreach ($domains as $cur_dom) {
			$file = $GLOBALS['DATA_VHOSTS'] . $cur_dom . '.conf';
			$dom_conf = $this->config_read($file);
			if (is_file($dom_conf['crt']) && is_file($dom_conf['key'])) {
				if (($dom_conf['mail_ssl'] == 1) && (1 < strlen($dom_conf['crt']))) {
					file_put_contents($this->snifile, 'local_name ' . $cur_dom . ' {' . "\n" . 'ssl_cert = <' . $dom_conf['crt'] . "\n" . 'ssl_key = <' . $dom_conf['key'] . "\n" . '}' . "\n", FILE_APPEND | LOCK_EX);
				}
			}
		}
	}

	public function removeFromSNI($domain)
	{
		$this->del_strings_between_str('local_name ' . $domain . ' {', '} #tag_' . $domain . '_tag', $this->snifile);
	}

	public function addToSNI($domain, $cert = '', $key = '')
	{
		$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$dom_conf = $this->config_read($file);
		if (is_file($dom_conf['crt']) && is_file($dom_conf['key'])) {
			if (($dom_conf['mail_ssl'] == 1) && (1 < strlen($dom_conf['crt']))) {
				file_put_contents($this->snifile, 'local_name ' . $domain . ' {' . "\n" . 'ssl_cert = <' . $dom_conf['crt'] . "\n" . 'ssl_key = <' . $dom_conf['key'] . "\n" . '} #tag_' . $domain . '_tag' . "\n", FILE_APPEND | LOCK_EX);
			}
		}
	}

	public function check_cert_exist($certname)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $certname)) {
			return 0;
		}

		if (($certname == 'smtp') || ($certname == 'ftp')) {
			if (!is_file('/var/lib/ssl/' . $certname . '.crt') || !is_file('/var/lib/ssl/' . $certname . '.key')) {
				return 0;
			}

			if ((strlen(file_get_contents('/var/lib/ssl/' . $certname . '.crt')) < 10) || (strlen(file_get_contents('/var/lib/ssl/' . $certname . '.key')) < 10)) {
				return 0;
			}
		}

		if (!is_file('/etc/brainy/src/ssl/' . $certname . '.crt') || !is_file('/etc/brainy/src/ssl/' . $certname . '.key')) {
			return 0;
		}

		if ((strlen(file_get_contents('/etc/brainy/src/ssl/' . $certname . '.crt')) < 10) || (strlen(file_get_contents('/etc/brainy/src/ssl/' . $certname . '.key')) < 10)) {
			return 0;
		}

		return 1;
	}

	public function generate_cert($certname = 'tmp', $keyname = 'tmp')
	{
		if ($certname == 'webpanel') {
			if ($this->get_webpanel()) {
				$domain = $this->get_webpanel();
			}
			else {
				$domain = gethostname();
			}
		}
		else {
			$domain = gethostname();
		}

		$comm = 'openssl req -new -x509 -days 1000 -nodes -out "/etc/brainy/src/ssl/' . $certname . '.crt" -keyout "/etc/brainy/src/ssl/' . $keyname . '.key" -subj "/C=UA/ST=Default/L=Default/O=Brainy/CN=' . $domain . '"';
		$this->ssh($comm);
		$res['crt'] = file_get_contents('/etc/brainy/src/ssl/' . $certname . '.crt');
		$res['key'] = file_get_contents('/etc/brainy/src/ssl/' . $certname . '.key');
		$info_cert = $this->service_ssl_getinfo($res['crt'], '/etc/brainy/src/ssl/' . $certname . '.key');
		$res['code'] = 0;
		$res['time'] = $info_cert['time'];
		$res['time_from'] = $info_cert['time_from'];
		$res['issuer'] = $info_cert['issuer'];
		$res['domains'] = $info_cert['domains'];
		$res['keysize'] = $info_cert['keysize'];
		return $res;
	}

	public function create_letencert_service($renew, $checlpanelgen = 0)
	{
		global $lang;

		if ($checlpanelgen) {
			if ($this->get_webpanel()) {
				$domain = $this->get_webpanel();
			}
			else {
				$domain = gethostname();
			}
		}
		else {
			$domain = gethostname();
		}

		$crt = 'lets';
		$rootcert = '/etc/brainy/src/ssl';
		$b = true;
		$time = date('d-m-Y_h:i:s', time());
		$webserver = new webserver();
		$res_exist = $this->load_letencert_service();
		$renew = 1;

		if ($renew == 0) {
			if ($res_exist['code'] == 0) {
				$time_cert = strtotime($res_exist['time']);
				$delta = round(abs(time() - $time_cert) / 60 / 60 / 24, 2);

				if (is_file('/etc/letsencrypt/live/' . $domain . '/cert.pem')) {
					$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domain . '/cert.pem ' . $rootcert . '/' . $domain . '_' . $crt . '.crt');
					$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domain . '/chain.pem ' . $rootcert . '/' . $domain . '_' . $crt . '.ca-bundle');
					$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domain . '/privkey.pem ' . $rootcert . '/' . $domain . '_' . $crt . '.key');
				}

				if (1 < $delta) {
					$res_exist['canrenew'] = 0;
				}
				else {
					$res_exist['canrenew'] = 1;
				}

				return $res_exist;
			}
		}

		$vhost_data = $this->config_read('/etc/brainy/data/vhosts/!!default.conf');
		$dir = $vhost_data['dir'];
		$vhost_data['letencrypt0'] = '<Directory \'' . $dir . '/.well-known\'>';
		$vhost_data['letencrypt1'] = 'Options Indexes FollowSymLinks Includes ExecCGI';
		$vhost_data['letencrypt2'] = 'ForceType \'text/plain\'';
		$vhost_data['letencrypt3'] = 'AddDefaultCharset 0';
		$vhost_data['letencrypt4'] = 'Order deny,allow';
		$vhost_data['letencrypt5'] = 'Allow from all';
		$vhost_data['letencrypt6'] = '</Directory>';
		$vhost_data['aliases'] = $domain;
		$this->config_save('/etc/brainy/data/vhosts/!!default.conf', $vhost_data, 'add');

		if (is_file($GLOBALS['DATA_VHOSTS'] . '/' . $domain . '.conf')) {
			$vhost_data = parse_ini_file($GLOBALS['DATA_VHOSTS'] . '/' . $domain . '.conf');
		}

		if ($vhost_data['default_ssl'] == 1) {
			$dir = $vhost_data['dir'];
			$alias_list = explode(',', $vhost_data['aliases']);
			$list_dom_cert = '';

			foreach ($alias_list as $curalias) {
				if (1 < strlen($curalias)) {
					$list_dom_cert .= ' -d ' . $curalias;
				}
			}
		}
		else {
			$vhost_data = $this->config_read('/etc/brainy/data/vhosts/!!default.conf');
			$dir = $vhost_data['dir'];
			$webserver->webserver_convert_domain('!!default');
		}

		$domainPanelGen = '';

		if ($checlpanelgen == 1) {
			$domainPanel = $this->get_webpanel();
		}

		if (is_file('/etc/letsencrypt/renewal/' . $domain . '.conf')) {
			$this->ssh('rm -f ' . '/etc/letsencrypt/renewal/' . $domain . '.conf');
			$this->ssh('rm -rf ' . '/etc/letsencrypt/archive/' . $domain);
			$this->ssh('rm -rf ' . '/etc/letsencrypt/live/' . $domain);
			$this->sudo_ssh('mkdir -p ' . $dir . '/.well-known/acme-challenge/');

			if (stripos($GLOBALS['OS_VERSION'], 'centos6') !== false) {
				$out = $this->sudo_ssh('scl enable python27 "/usr/local/bin/certbot-auto certonly --force-renew --register-unsafely-without-email --agree-tos --webroot-path ' . $vhost_data['dir'] . ' --webroot -n -d ' . $domain . $list_dom_cert . $domainPanelGen . ' &>/dev/stdout"');
			}
			else {
				$out = $this->sudo_ssh('/usr/local/bin/certbot-auto certonly --force-renew --register-unsafely-without-email --agree-tos --webroot-path ' . $vhost_data['dir'] . ' --webroot -n -d ' . $domain . $list_dom_cert . $domainPanelGen . ' &>/dev/stdout');
			}

			$out = implode('<br/>', $out);
			$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domain . '/cert.pem ' . $rootcert . '/' . $domain . '_' . $crt . '.crt');
			$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domain . '/chain.pem ' . $rootcert . '/' . $domain . '_' . $crt . '.ca-bundle');
			$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domain . '/privkey.pem ' . $rootcert . '/' . $domain . '_' . $crt . '.key');
			$crt_load = file_get_contents($rootcert . '/' . $domain . '_' . $crt . '.crt');
			$chain_load = file_get_contents($rootcert . '/' . $domain . '_' . $crt . '.chein');
			$crt_load = trim($crt_load) . "\n";
			file_put_contents($rootcert . '/' . $domain . '_' . $crt . '.crt_v2', $crt_load . $chain_load);

			if (!is_file('/etc/letsencrypt/live/' . $domain . '/cert.pem')) {
				$b = false;
			}
			else {
				$out_res['code'] = 2;
				$out_res['message'] = $lang['msg_cert_let_info0'] . ' ' . $domain . ' ' . $lang['msg_cert_let_info1'];

				if ($checlpanelgen) {
					$out_res = array_merge($out_res, $this->load_letencert_service('webpanel'));
				}
				else {
					$out_res = array_merge($out_res, $this->load_letencert_service());
				}
			}
		}
		else {
			$this->sudo_ssh('mkdir -p ' . $dir . '/.well-known/acme-challenge/');

			if (stripos($GLOBALS['OS_VERSION'], 'centos6') !== false) {
				$out = $this->sudo_ssh('scl enable python27 "/usr/local/bin/certbot-auto certonly --register-unsafely-without-email --agree-tos --webroot-path ' . $vhost_data['dir'] . ' --webroot -n -d ' . $domain . $list_dom_cert . $domainPanelGen . ' &>/dev/stdout"');
			}
			else {
				$out = $this->sudo_ssh('/usr/local/bin/certbot-auto certonly --register-unsafely-without-email --agree-tos --webroot-path ' . $vhost_data['dir'] . ' --webroot -n -d ' . $domain . $list_dom_cert . $domainPanelGen . ' &>/dev/stdout');
			}

			$out = implode('<br>', $out);

			if (strstr($out, 'Congratulations!')) {
				$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domain . '/cert.pem ' . $rootcert . '/' . $domain . '_' . $crt . '.crt');
				$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domain . '/chain.pem ' . $rootcert . '/' . $domain . '_' . $crt . '.ca-bundle');
				$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domain . '/privkey.pem ' . $rootcert . '/' . $domain . '_' . $crt . '.key');
				$crt_load = file_get_contents($rootcert . '/' . $domain . '_' . $crt . '.crt');
				$chain_load = file_get_contents($rootcert . '/' . $domain . '_' . $crt . '.chein');
				$crt_load = trim($crt_load) . "\n";
				file_put_contents($rootcert . '/' . $domain . '_' . $crt . '.crt_v2', $crt_load . $chain_load);
				$out_res['message'] = $lang['msg_cert_let_info0'] . ' ' . $domain . ' ' . $lang['msg_cert_let_info1'];
				$out_res['code'] = 0;

				if ($checlpanelgen) {
					$out_res = array_merge($out_res, $this->load_letencert_service('webpanel'));
				}
				else {
					$out_res = array_merge($out_res, $this->load_letencert_service());
				}
			}
			else {
				$b = false;
			}
		}

		if ($b === false) {
			$out_res['code'] = 4;

			if (preg_match('/too many certificates/iu', $out)) {
				$out_res['message'] = $lang['certs_too_many_cert_services'] . '<br/>' . $out;
			}
			else {
				$out_res['message'] = $lang['certs_control_failed_gen_letsen_serv'] . '<br/>' . $out;
			}
		}

		if ($checlpanelgen == 1) {
			$this->ssh('mv /etc/brainy/src/ssl/' . $domainPanel . '_lets.crt_v2 /etc/brainy/src/ssl/webpanel.crt_v2');
			$this->ssh('mv /etc/brainy/src/ssl/' . $domainPanel . '_lets.key /etc/brainy/src/ssl/webpanel.key');
			$webserver->webserver_convert_domain($domainPanel);
		}

		$this->del_string_new('aliases=', '/etc/brainy/data/vhosts/!!default.conf');
		$webserver->webserver_convert_domain('!!default');
		$webserver->webservers_reloadconf(1);
		return $out_res;
	}

	public function load_letencert_service($webpanel = NULL)
	{
		$crt = 'lets';

		if ($webpanel) {
			$domain = $this->get_webpanel();
		}
		else {
			$domain = gethostname();
		}

		if (is_file('/etc/brainy/src/ssl/' . $domain . '_' . $crt . '.key')) {
			$cert = file_get_contents('/etc/brainy/src/ssl/' . $domain . '_' . $crt . '.crt');
			$key = file_get_contents('/etc/brainy/src/ssl/' . $domain . '_' . $crt . '.key');
			$chein = file_get_contents('/etc/brainy/src/ssl/' . $domain . '_' . $crt . '.ca-bundle');
			$info_cert = $this->service_ssl_getinfo($cert, '/etc/brainy/src/ssl/' . $domain . '_' . $crt . '.key');
			$res['code'] = 0;
			$res['time'] = $info_cert['time'];
			$res['time_from'] = $info_cert['time_from'];
			$res['issuer'] = $info_cert['issuer'];
			$res['domains'] = $info_cert['domains'];
			$res['keysize'] = $info_cert['keysize'];
			$res['cert'] = $cert;
			$res['key'] = $key;
			$res['chein'] = $chein;
		}
		else {
			$res['code'] = 1;
			$res['message'] = 'nocert';
		}

		return $res;
	}

	public function letencert_renew()
	{
		global $lang;
		$webserver = new webserver();
		$path_cert_renew = '/etc/letsencrypt/renewal/';
		$res = array_diff(scandir($path_cert_renew), array('.', '..'));
		$domain_hostname = gethostname();
		$timelog = date('d_m_Y_H') . 'H';

		foreach ($res as $elem) {
			if (is_file($path_cert_renew . '/' . $elem)) {
				if (is_file('/etc/brainy/data/vhosts/' . $elem) || ($elem == $domain_hostname . '.conf')) {
					if ($elem == $domain_hostname . '.conf') {
						$vhost_data = $this->config_read('/etc/brainy/data/vhosts/!!default.conf');
					}
					else {
						$vhost_data = $this->config_read('/etc/brainy/data/vhosts/' . $elem);
					}

					if ($vhost_data['lets_autorenew'] == 1) {
						$dir = $vhost_data['dir'];
						$user = $vhost_data['user'];

						if ($vhost_data['domain'] == 'default') {
							$domain = $domain_hostname;
						}
						else {
							$domain = $vhost_data['domain'];
						}

						$users = $this->config_read('/etc/brainy/data/users/' . $user);
						$alias_list = explode(',', $vhost_data['aliases']);
						$list_dom_cert = ' -d ' . $domain;

						foreach ($alias_list as $curalias) {
							if (1 < strlen($curalias)) {
								$list_dom_cert .= ' -d ' . $curalias;
							}
						}

						$rootcert = $this->dir_certs . $user;
						$this->sudo_ssh('mkdir -p ' . $rootcert);
						$b = true;
						$time = 'autorenew';
						$crt = 'letsen';

						if (stripos($GLOBALS['OS_VERSION'], 'centos6') !== false) {
							$out = $this->sudo_ssh('scl enable python27 "/usr/local/bin/certbot-auto certonly --register-unsafely-without-email --agree-tos --webroot -n ' . $list_dom_cert . '" &>/dev/stdout');
						}
						else {
							$out = $this->sudo_ssh('/usr/local/bin/certbot-auto certonly --register-unsafely-without-email --agree-tos --webroot-path ' . $vhost_data['dir'] . ' --webroot -n ' . $list_dom_cert . ' &>/dev/stdout');
						}

						$out = implode('', $out);
						file_put_contents('/etc/brainy/data/streams/certbotauto_' . $timelog, $out . "\n", FILE_APPEND);

						if (stripos($out, 'Certificate not yet due for renewal') === false) {
							$getpathforcert = $this->ssh('ls -t ' . $domain . '* | head -1')[0];
							$domPath = $domain;

							if (stripos($getpathforcert, $domain) !== false) {
								$domPath = str_replace(':', '', $getpathforcert);
							}

							$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domPath . '/cert.pem ' . $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.crt');
							$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domPath . '/chain.pem ' . $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.chein');
							$this->sudo_ssh('cp -f /etc/letsencrypt/live/' . $domPath . '/privkey.pem ' . $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.key');
							var_dump('cp -f /etc/letsencrypt/live/' . $domPath . '/cert.pem ' . $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.crt');
							$crt_load = file_get_contents($rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.crt');
							$chain_load = file_get_contents($rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.chein');
							$key_load = file_get_contents($rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.key');
							$crt_load = trim($crt_load) . "\n";
							file_put_contents($rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.crt_v2', $crt_load . $chain_load);
							$out = $lang['msg_cert_let_info0'] . ' ' . $domain . ' ' . $lang['msg_cert_let_info1'];
							$domainPanel = $this->get_webpanel();

							if ($vhost_data['domain'] == $domainPanel) {
								$this->ssh('mv ' . $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.crt_v2  /etc/brainy/src/ssl/webpanel.crt_v2');
								$this->ssh('mv ' . $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.key  /etc/brainy/src/ssl/webpanel.key');
								$webserver->webserver_convert_domain($domainPanel);
								$out_res[$elem] = 'renewok';
							}
							else if ($vhost_data['domain'] == 'default') {
								$array_service = explode(',', $vhost_data['service_list']);

								if (0 < count($array_service)) {
									$this->service_install_newcert($crt_load, $key_load, $crt_load, $array_service);
									$out_res[$elem] = 'renewok';
								}
								else {
									$out_res[$elem] = 'Certificate not service renewal';
								}
							}
							else if (($b == true) && ($vhost_data['domain'] != 'default')) {
								$vhost_data['ssl'] = '1';
								$vhost_data['key'] = $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.key';
								$vhost_data['crt'] = $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.crt';
								$vhost_data['chein'] = $rootcert . '/' . $domain . '_' . $time . '_' . $crt . '.chein';
								$this->config_save('/etc/brainy/data/vhosts/' . $domain . '.conf', $vhost_data, 'add');
								$webserver->webserver_convert_domain($domain, $vhost_data['php'], $vhost_data['bridge']);
								$this->removeFromSNI($domain);
								$this->addToSNI($domain, $vhost_data['crt'], $vhost_data['key']);
								$out_res[$elem] = 'renewok';
							}
							else {
								$out_res[$elem] = $lang['certs_control_failed_gen_letsen'];
							}
						}
						else {
							$out_res[$elem] = 'Certificate not yet due for renewal';
						}
					}
					else {
						$out_res[$elem] = 'Certificate autorenew off';
					}
				}
			}
		}

		file_put_contents('/etc/brainy/data/streams/certbotauto_' . $timelog, print_r($out_res, 1) . "\n", FILE_APPEND);
		return $out_res;
	}

	public function save_certlets_autorenew($user, $domain, $autorenew)
	{
		$autorenew = intval($autorenew);
		if (($domain == 'hostname') || ($domain == 'webpanel')) {
			$this->save_certlets_autorenew_service($autorenew, $domain);
			exit();
		}

		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $domain)) {
			return 0;
		}

		if (!preg_match('/^[a-zA-Z0-9_\\-\\.:]+$/', $user)) {
			return 0;
		}

		$dom_conf = $this->config_read('/etc/brainy/data/vhosts/' . $domain . '.conf');

		if ($dom_conf['user'] == $user) {
			$update_domain['lets_autorenew'] = $autorenew;
			$this->config_save('/etc/brainy/data/vhosts/' . $domain . '.conf', $update_domain, 'add');
		}
	}

	public function save_certlets_autorenew_service($autorenew, $data_serv = '')
	{
		$autorenew = intval($autorenew);
		$file_conf = '!!default.conf';

		if ($data_serv == 'webpanel') {
			$file_conf = $this->get_webpanel() . '.conf';
		}

		$dom_conf = $this->config_read('/etc/brainy/data/vhosts/' . $file_conf);
		$update_domain['lets_autorenew'] = $autorenew;
		$this->config_save('/etc/brainy/data/vhosts/' . $file_conf, $update_domain, 'add');
	}
}


?>
