<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class cloudflare
{
	public $path_data = '/etc/brainy/data/cloudflare/main';
	public $path_data_domain = '/etc/brainy/data/cloudflare/domain';
	public $script_bind = '/etc/brainy/ssh/named/named.sh';
	public $mode_operation = '/etc/brainy/data/cloudflare/mode_operation';

	public function rm_auth($data)
	{
		global $lang;
		$data = (array) json_decode($data);
		$user = $data['user'];

		if (!$this->check_value('user', $user)) {
			$arr_out['code'] = 2;
			$arr_out['message'] = $lang['cloudflare_error_user'];
		}
		if ($arr_out) {
			return $arr_out;
		}

		$this->del_string_new($user . '|', $this->path_data);
		$arr_out['code'] = 0;
		$arr_out['message'] = $lang['cloudflare_succesfully'];
		$arr_out['user'] = $user;
		return $arr_out;
	}

	public function get_user_domain_info($domain)
	{
		$arr = $this->config_read('/etc/brainy/data/vhosts/' . $domain . '.conf');
		return $arr['user'];
	}

	public function get_domain_cloudflare($user)
	{
		$webserver = new webserver();
		$domains = $webserver->get_all_sites($user);
		$puny = new idna_convert();
		$out_file = $this->read_file_n($this->path_data_domain);

		foreach ($out_file as $val_out) {
			$array = explode('|', $val_out);

			if (in_array($puny->encode(trim($array[1])), $domains)) {
				$array_out[] = $array[1];
			}
		}

		return $array_out;
	}

	public function save_auth($data)
	{
		global $lang;
		$data = (array) json_decode($data);
		$user = $data['user'];
		$email = $data['email'];
		$auth_key = $data['auth_key'];
		$ca_key = $data['ca_key'];

		if (!empty($user) && !empty($email) && !empty($auth_key)) {
			if (!preg_match('/[a-z0-9\\-\\.]{0,}/i', $ca_key)) {
				$arr_out['code'] = 5;
				$arr_out['message'] = $lang['cloudflare_error_ca_key'];
			}

			if (!preg_match('/[a-z0-9]{30,}/i', $auth_key)) {
				$arr_out['code'] = 4;
				$arr_out['message'] = $lang['cloudflare_error_api_key'];
			}

			if (!$this->check_value('email', $email)) {
				$arr_out['code'] = 3;
				$arr_out['message'] = $lang['cloudflare_error_email'];
			}

			if (!$this->check_value('user', $user)) {
				$arr_out['code'] = 2;
				$arr_out['message'] = $lang['cloudflare_error_user'];
			}
		}
		else {
			$arr_out['code'] = 1;
			$arr_out['message'] = $lang['cloudflare_not_param'];
		}

		if ($arr_out) {
			return $arr_out;
		}

		$out_ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/user" -H "X-Auth-Email: ' . trim($email) . '" -H "X-Auth-Key: ' . trim($auth_key) . '" -H "Content-Type: application/json"'));
		$out_ssh = (array) json_decode($out_ssh);

		if (!$out_ssh['success']) {
			$arr_out['code'] = 404;
			$arr_out['message'] = $lang['cloudflare_error_regestration_data'];
		}
		if ($arr_out) {
			return $arr_out;
		}

		$out_file = $this->read_file_n($this->path_data);

		foreach ($out_file as $key_val => $val_file) {
			$val_file = trim($val_file);

			if (preg_match('/^(' . $user . '[|])+/i', $val_file)) {
				$edit_user = 1;
				$new_array_reg[$key_val] = $user . '|' . $email . '|' . $auth_key . '|' . trim($ca_key);
			}
			else {
				$new_array_reg[$key_val] = $val_file;
			}
		}

		if ($edit_user == 1) {
			$this->write_file(implode(PHP_EOL, $new_array_reg), $this->path_data, 'r');
		}
		else {
			$this->write_file($user . '|' . $email . '|' . $auth_key . '|' . trim($ca_key) . PHP_EOL, $this->path_data, 'wb');
		}

		$arr_out['code'] = 0;
		$arr_out['message'] = $lang['cloudflare_succesfully_user'];
		$arr_out['user'] = $user;
		return $arr_out;
	}

	public function mode_operation($data)
	{
		global $lang;

		if (!preg_match('/[0-9]+/i', $data)) {
			$arr_out['code'] = 1;
			$arr_out['message'] = $lang['cloudflare_error_data'];
		}
		if ($arr_out) {
			return $arr_out;
		}

		$this->write_file($data, $this->mode_operation, 'r');
		$this->write_file('', $this->path_data_domain, 'r');
		$arr_out['code'] = 0;
		$arr_out['message'] = $lang['cloudflare_succesfully'];
		return $arr_out;
	}

	public function get_operation()
	{
		return trim($this->read_file($this->mode_operation));
	}

	public function get_data_user($user)
	{
		global $lang;
		if (!$this->check_value('user', $user) || empty($user)) {
			$arr_out['code'] = 2;
			$arr_out['message'] = $lang['cloudflare_error_user'];
		}
		if ($arr_out) {
			return $arr_out;
		}

		$out_ssh = implode('', $this->ssh('cat ' . $this->path_data . ' | grep \'' . $user . '|\''));

		if (!$out_ssh) {
			return false;
		}

		return explode('|', $out_ssh);
	}

	public function check_domain($data, $user)
	{
		$puny = new idna_convert();

		foreach ($data as $val) {
			$val = $puny->decode(trim($val));
			$out_ssh = implode('', $this->ssh('cat ' . $this->path_data_domain . ' | grep \'' . $val . '|\''));

			if (!$out_ssh) {
				$data = '';
				$nameserver = '';
			}
			else {
				$data = $out = explode('|', $out_ssh);
				$nameserver = explode(',', $data[4]);
			}

			$array[] = array($val, $user, $data, $nameserver);
		}

		return $array;
	}

	public function get_include_domain($user)
	{
		global $lang;
		if (!$this->check_value('user', $user) || empty($user)) {
			$arr_out['code'] = 2;
			$arr_out['message'] = $lang['cloudflare_error_user'];
		}

		$out_ssh = $this->ssh('cat ' . $this->path_data_domain . ' | grep \'' . $user . '|\'');

		foreach ($out_ssh as $key => $val) {
			$out_ssh[$key] = explode('|', $val);
		}

		return $out_ssh;
	}

	public function chech_whois($data)
	{
		$data = (array) json_decode($data);
		$out_file = $this->read_file_n($this->path_data_domain);

		foreach ($out_file as $key_file => $val_file) {
			$out_str = explode('|', trim($val_file));

			foreach ($data as $domains) {
				if ($domains == $out_str[1]) {
					$named = explode(',', $out_str[4]);
					$out_ssh = implode('', $this->ssh('whois ' . $out_str[1] . ' &> /dev/stdout'));
					$check = 0;

					foreach ($named as $key_named => $val_named) {
						if (preg_match('/(' . str_replace('.', '\\.', $val_named) . ')+/i', $out_ssh)) {
							++$check;
						}
					}

					$check_whois = 0;

					if ($check == count($named)) {
						$check_whois = 1;
					}

					$return_array[$domains] = $check_whois;
				}
			}
		}

		if (!$return_array) {
			foreach ($data as $domains) {
				$return_array[] = 0;
			}
		}

		return $return_array;
	}

	public function select_domain($data)
	{
		global $lang;
		$data = (array) json_decode($data);
		$domain = $data['domain'];

		if (!$this->check_value('domain', $domain)) {
			return false;
		}

		$out_ssh = implode('', $this->ssh('cat ' . $this->path_data_domain . ' | grep \'' . $domain . '|\''));

		if ($out_ssh) {
			$out = explode('|', $out_ssh);
			return $out[1];
		}

		return false;
	}

	public function get_user_domain($user, $domain)
	{
		if (!$this->check_value('domain', $domain)) {
			$arr_out['code'] = 7;
			$arr_out['message'] = $lang['cloudflare_error_domain'];
		}

		if (!$this->check_value('user', $user)) {
			$arr_out['code'] = 2;
			$arr_out['message'] = $lang['cloudflare_error_user'];
		}
		if ($arr_out) {
			return $arr_out;
		}

		$out_ssh = implode('', $this->ssh('cat ' . $this->path_data_domain . ' | grep \'' . $domain . '|\''));
		$user_domain = explode('|', $out_ssh)[0];
		$id_domain = explode('|', $out_ssh)[2];
		$mode = $this->get_operation();

		if ($mode != 1) {
			$webserver = new Webserver();
			$domains = $webserver->webserver_getdomains($user);
			$puny = new idna_convert();
			$domain = $puny->encode(trim($domain));

			if (in_array($domain, $domains)) {
				$check_domain = true;
			}
		}

		if (($user == 'root') || ($user == $user_domain) || $check_domain) {
			$arr_out['code'] = 0;
			$arr_out['user'] = $user_domain;
			$arr_out['domain_one'] = $domain;
			$arr_out['id_domain'] = $id_domain;
		}
		else {
			$arr_out['code'] = 404;
		}

		return $arr_out;
	}

	public function add_record_other_modules($domain, $operation, $name, $value, $type_record = '')
	{
		if (!$this->check_value('domain', $domain)) {
			return 0;
		}

		$puny = new idna_convert();
		$name = $puny->decode(trim($name));
		$data_reg = trim($this->read_file($this->mode_operation));

		switch ($data_reg) {
		case 1:
			$config = $this->config_read($GLOBALS['DATA_VHOSTS'] . $domain . '.conf');
			$out_ssh = implode('', $this->ssh('cat ' . $this->path_data . ' | grep \'' . $config['user'] . '|\''));
			$user = $config['user'];
			break;

		case 0:
			$out_ssh = implode('', $this->ssh('cat ' . $this->path_data . ' | grep \'root|\''));
			$user = 'root';
			break;
		}

		$out_ssh = (, $out_ssh);
		$domain_decode = $puny->decode(trim($domain));
		$out_ssh = implode('', $this->ssh('cat ' . $this->path_data_domain . ' | grep \'' . $domain_decode . '|\''));
		$user_domain = explode('|', $out_ssh)[0];
		$id_domain = explode('|', $out_ssh)[2];
		$array_record = $this->get_user_setting('dns', $user, $domain_decode)['value_record'];
		$check_record = 0;

		foreach ($array_record as $val) {
			if ($type_record == 'dkim') {
				if ($val['name'] == $name) {
					$check_record = 1;
					$id_record[] = $val['id'];
				}
			}
			else if ($val['type'] == 'TXT') {
				if (($val['name'] == $name) && ($val['name'] == $name)) {
					$check_record = 1;
					$id_record = $val['id'];
				}
			}
		}

		$data['type_dns'] = 'TXT';
		$data['ttl'] = 1;
		$data['name'] = $name;
		$data['value'] = $value;
		$data['user'] = $user;
		$data['id_domain'] = $id_domain;
		$data['proxy'] = false;

		switch ($operation) {
		case 'add_record':
			if ($check_record == 0) {
				$data['oper'] = 'add_record';
				$data = json_encode($data);
				$this->edit_domain($data);
			}

			break;

		case 'remove_record':
			if ($check_record == 1) {
				$data['oper'] = 'rm_record';

				if ($type_record == 'dkim') {
					foreach ($id_record as $val_id_record) {
						$data['id_record'] = $val_id_record;
						$data = json_encode($data);
						$this->edit_domain($data);
					}
				}
				else {
					$data['id_record'] = $id_record;
					$data = json_encode($data);
					$this->edit_domain($data);
				}
			}

			break;

		case 'edit_record':
			break;
		}
	}

	public function get_user_setting($tpl, $user, $domain)
	{
		global $lang;

		if (!$this->check_value('domain', $domain)) {
			$arr_out['code'] = 7;
			$arr_out['message'] = $lang['cloudflare_error_domain'];
		}

		if (!$this->check_value('user', $user)) {
			$arr_out['code'] = 2;
			$arr_out['message'] = $lang['cloudflare_error_user'];
		}

		if (!preg_match('/^[a-z0-9_]+$/i', $tpl)) {
			$arr_out['code'] = 11;
			$arr_out['message'] = $lang['cloudflare_error_tpl'];
		}
		if ($arr_out) {
			return $arr_out;
		}

		$puny = new idna_convert();
		$domain = $puny->decode(trim($domain));
		$out_ssh = implode('', $this->ssh('cat ' . $this->path_data . ' | grep \'' . $user . '|\''));
		$out_ssh = explode('|', $out_ssh);
		$out_ssh = implode('', $this->ssh('cat ' . $this->path_data_domain . ' | grep \'' . $domain . '|\''));
		$id_domain = explode('|', $out_ssh)[2];

		switch ($tpl) {
		case 'firewall':
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/firewall/access_rules/rules" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);

			foreach ($ssh['result'] as $key => $val) {
				$arrau_mode = array('/block/', '/challenge/', '/whitelist/', '/js_challenge/');
				$arrau_replace = array($lang['cloudflare_block'], $lang['cloudflare_captcha'], $lang['cloudflare_whitelist'], $lang['cloudflare_js']);
				$mode = preg_replace($arrau_mode, $arrau_replace, $val->mode);
				$array_result[$key]['mode'] = $mode;
				$array_result[$key]['id'] = $val->id;
				$array_result[$key]['value'] = $val->configuration->value;
				$array_result[$key]['notes'] = $val->notes;
				preg_match_all('/^[0-9]{2,4}[-][0-9]{2}[-][0-9]{2}T[0-9]{2}\\:[0-9]{2}\\:[0-9]{2}/i', $val->created_on, $result);
				$array_result[$key]['date'] = str_replace('T', ' ', $result[0][0]);
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/security_level" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['security_level'] = $ssh['result']->value;
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/challenge_ttl" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['blocking_time'] = $ssh['result']->value;
			$array_out['result'] = $array_result;
			break;

		case 'speed':
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/minify" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['js'] = $ssh['result']->value->js;
			$array_out['css'] = $ssh['result']->value->css;
			$array_out['html'] = $ssh['result']->value->html;
			break;

		case 'caching':
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/cache_level" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['caching_level'] = $ssh['result']->value;
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/browser_cache_ttl" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['cashing_time'] = $ssh['result']->value;
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/always_online" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['cashing_online'] = $ssh['result']->value;
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/development_mode" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['development_mode'] = $ssh['result']->value;
			$array_out['domain'] = $domain;
			break;

		case 'page_rules':
			$array_out['domain'] = $domain;
			break;

		case 'network':
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/websockets" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['websockets'] = $ssh['result']->value;
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/ip_geolocation" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['ipgeolocation'] = $ssh['result']->value;
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/pseudo_ipv4" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['pseudoipv4'] = $ssh['result']->value;
			break;

		case 'scrape_shield':
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/emailobfuscation" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['emailobfuscation'] = $ssh['result']->value;
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/server_side_exclude" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['server_side_excludes'] = $ssh['result']->value;
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/hotlink_protection" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['hotlink_protection'] = $ssh['result']->value;
			break;

		case 'dns':
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/dns_records" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$out = $ssh['result'];

			foreach ($out as $key => $val) {
				$array_out['value_record'][$key] = (array) $val;
			}

			break;

		case 'ssl':
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/ssl" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['ssl'] = $ssh['result']->value;
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/always_use_https" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['redirect'] = $ssh['result']->value;
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/tls_client_auth" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['origin_pulls'] = $ssh['result']->value;
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/opportunistic_encryption" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['encryption'] = $ssh['result']->value;
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/tls_1_3" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['tls_1_3'] = $ssh['result']->value;
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/automatic_https_rewrites" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);
			$array_out['rewrites_https_auto'] = $ssh['result']->value;
			$array_out['domain'] = $domain;
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/certificates?zone_id=' . $id_domain . '" -H "X-Auth-User-Service-Key: ' . $auth_ca . '"'));
			$ssh = (array) json_decode($ssh);
			$array_out['list_certs'] = $ssh['result'];
			break;
		}

		if (!()) {
			return array();
		}

		return $array_out;
	}

	public function edit_domain($data)
	{
		global $lang;
		$data = (array) json_decode($data);
		$user = $data['user'];
		$oper = $data['oper'];

		if ($oper != 'add_domain') {
			$id_domain = $data['id_domain'];

			if (!preg_match('/[a-z0-9]{30,}/i', $id_domain)) {
				$arr_out['code'] = 8;
				$arr_out['message'] = $lang['cloudflare_error_id_domain'];
			}
		}
		else {
			$domain = $data['domain'];

			if (!$this->check_value('domain', $domain)) {
				$arr_out['code'] = 7;
				$arr_out['message'] = $lang['cloudflare_error_domain'];
			}
		}

		if (!$this->check_value('user', $user)) {
			$arr_out['code'] = 2;
			$arr_out['message'] = $lang['cloudflare_error_user'];
		}

		if (!preg_match('/[a-z0-9]+/i', $oper)) {
			$arr_out['code'] = 5;
			$arr_out['message'] = $lang['cloudflare_error_oper'];
		}

		if (!$this->get_operation()) {
			$out_ssh = implode('', $this->ssh('cat ' . $this->path_data . ' | grep \'root|\''));
		}
		else {
			$out_ssh = implode('', $this->ssh('cat ' . $this->path_data . ' | grep \'' . $user . '|\''));
		}

		$out_ssh = explode('|', $out_ssh);

		if (empty($user) && empty($email) && empty($auth_key)) {
			$arr_out['code'] = 6;
			$arr_out['message'] = $lang['cloudflare_not_data'];
		}
		if ($arr_out) {
			return $arr_out;
		}

		switch ($oper) {
		case 'rm_ssl':
			$id_rm_certs = $data['id_rm_certs'];

			if (!preg_match('/^[a-z0-9]{5,}$/i', $id_rm_certs)) {
				$arr_out['code'] = 34;
				$arr_out['message'] = $lang['cloudflare_error_id_cert'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X DELETE "https://api.cloudflare.com/client/v4/certificates/' . $id_rm_certs . '" -H "X-Auth-User-Service-Key: ' . $auth_ca . '"'));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'create_ssl':
			$domain = $data['domain'];

			if (!$this->check_value('domain', $domain)) {
				$arr_out['code'] = 7;
				$arr_out['message'] = $lang['cloudflare_error_domain'];
			}

			$time_ssl = $data['time_ssl'];

			if (!preg_match('/^[0-9]+$/i', $time_ssl)) {
				$arr_out['code'] = 32;
				$arr_out['message'] = $lang['cloudflare_error_time_ssl'];
			}

			$list_zones = $data['list_zones'];

			if (!preg_match('/^[а-яёЁ0-9a-z\\.\\-\\*\\, ]+$/iu', $list_zones)) {
				$arr_out['code'] = 33;
				$arr_out['message'] = $lang['cloudflare_error_list_ssl'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$get_oper = $this->get_operation();

			if (!$get_oper) {
				$user = $this->config_read($GLOBALS['DATA_VHOSTS'] . $domain . '.conf')['user'];
			}

			if (!is_dir('/etc/certs/' . $user)) {
				$this->ssh('mkdir -p /etc/certs/' . $user);
			}

			$time = date('d-m-Y_h:i:s', time());
			$name_private_key = '/etc/certs/' . $user . '/' . $domain . '_' . $time . '_cloudflare.key';
			$out_ssl = implode(PHP_EOL, $this->ssh('openssl req -new -newkey rsa:2048 -nodes -days ' . $time_ssl . ' -keyout ' . $name_private_key . ' -out /dev/stdout -subj "/C=UA/ST=kyiv/L=kyiv/O=Global Security/OU=IT Department/CN=' . $domain . '" 2> /dev/null'));
			$this->ssh('rm -rf /etc/brainy/.rnd');
			$array_zones = explode(',', $list_zones);

			foreach ($array_zones as $key_zones => $val_zones) {
				$array_zones[$key_zones] = '"' . preg_replace('/[ ]{1,}/i', '', trim($val_zones)) . '"';
			}

			$out_ssl = preg_replace('/^(\\n|\\r|\\n\\r)|(\\n|\\r|\\n\\r)$/i', '', $out_ssl);
			$out_ssl = preg_replace('/\\n/i', '\\n', $out_ssl);
			$zones_ssl = implode(',', $array_zones);
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X POST "https://api.cloudflare.com/client/v4/certificates" -H "X-Auth-User-Service-Key: ' . $auth_ca . '" --data \'{"hostnames":[' . $zones_ssl . '],"requested_validity":' . $time_ssl . ',"request_type":"origin-rsa","csr":"' . $out_ssl . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				if ($ssh['code']) {
					$arr_out['code'] = $ssh['code'];
					$arr_out['message'] = $ssh['message'];
				}
				else {
					$arr_out['code'] = $ssh['errors'][0]->code;
					$arr_out['message'] = $ssh['errors'][0]->message;
				}

				$this->ssh('rm -rf ' . $name_private_key);
			}
			if ($arr_out) {
				return $arr_out;
			}

			$this->ssh('echo \'' . $ssh['result']->certificate . '\' > /etc/certs/' . $user . '/' . $domain . '_' . $time . '_cloudflare.crt');
			$arr_out['id_cert'] = $ssh['result']->id;
			$arr_out['hostnames'] = implode(', ', $ssh['result']->hostnames);
			$time_cert = explode(' ', $ssh['result']->expires_on);
			$arr_out['time_cert'] = $time_cert[0] . ' ' . $time_cert[1];
			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'] . '<br>' . $lang['cloudflare_incl_certc'] . '<br><a href="/index.php?do=certs_control">' . $lang['cloudflare_certc'] . '</a>';
			break;

		case 'rewrites_https_auto':
			$rewrites_https_auto = $data['rewrites_https_auto'];

			if (!preg_match('/^(on)+$|^(off)+$/i', $rewrites_https_auto)) {
				$arr_out['code'] = 18;
				$arr_out['message'] = $lang['cloudflare_error_online_data'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/automatic_https_rewrites" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $rewrites_https_auto . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			if ($rewrites_https_auto == 'on') {
				$status = 0;
			}
			else {
				$status = 1;
			}

			$arr_out['status'] = $status;
			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'tls_1_3':
			$tls = $data['tls'];

			if (!preg_match('/^(on)+$|^(off)+$/i', $tls)) {
				$arr_out['code'] = 18;
				$arr_out['message'] = $lang['cloudflare_error_online_data'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/tls_1_3" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $tls . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'encryption':
			$encryption = $data['encryption'];

			if (!preg_match('/^(on)+$|^(off)+$/i', $encryption)) {
				$arr_out['code'] = 18;
				$arr_out['message'] = $lang['cloudflare_error_online_data'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/opportunistic_encryption" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $encryption . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			if ($encryption == 'on') {
				$status = 0;
			}
			else {
				$status = 1;
			}

			$arr_out['status'] = $status;
			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'origin_pulls':
			$origin_pulls = $data['origin_pulls'];

			if (!preg_match('/^(on)+$|^(off)+$/i', $origin_pulls)) {
				$arr_out['code'] = 18;
				$arr_out['message'] = $lang['cloudflare_error_online_data'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/tls_client_auth" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $origin_pulls . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			if ($origin_pulls == 'on') {
				$status = 0;
			}
			else {
				$status = 1;
			}

			$arr_out['status'] = $status;
			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'redirect_https':
			$redirect_https = $data['redirect_https'];

			if (!preg_match('/^(on)+$|^(off)+$/i', $redirect_https)) {
				$arr_out['code'] = 18;
				$arr_out['message'] = $lang['cloudflare_error_online_data'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/always_use_https" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $redirect_https . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			if ($redirect_https == 'on') {
				$status = 0;
			}
			else {
				$status = 1;
			}

			$arr_out['status'] = $status;
			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'using_ssl':
			$ssl_mode = $data['ssl_mode'];

			if (!preg_match('/^(flexible)+$|^(off)+$|^(full)+$|^(strict)+$/i', $ssl_mode)) {
				$arr_out['code'] = 31;
				$arr_out['message'] = $lang['cloudflare_error_ssl'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/ssl" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $ssl_mode . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'edit_record':
			$type_dns = $data['type_dns'];
			$ttl = $data['ttl'];
			$name = $data['name'];
			$value = $data['value'];
			$proxy = $data['proxy'];
			$id_record = $data['id_record'];

			if (!preg_match('/[a-z0-9]{30,}/i', $id_record)) {
				$arr_out['code'] = 24;
				$arr_out['message'] = $lang['cloudflare_error_id_record'];
			}

			if (!is_bool($proxy)) {
				$arr_out['code'] = 23;
				$arr_out['message'] = $lang['cloudflare_error_proxy'];
			}

			if (!preg_match('/^[0-9]+$/i', $ttl)) {
				$arr_out['code'] = 20;
				$arr_out['message'] = $lang['cloudflare_error_ttl'];
			}

			if (!preg_match('/^[a-z]+$/i', $type_dns)) {
				$arr_out['code'] = 19;
				$arr_out['message'] = $lang['cloudflare_error_type_record'];
			}

			if (!preg_match('/^[а-яёЁa-z0-9_\\-\\*\\.]+$/iu', $name)) {
				$arr_out['code'] = 21;
				$arr_out['message'] = $lang['cloudflare_error_name'];
			}

			if (($type_dns != 'TXT') && ($type_dns != 'SPF')) {
				if (!preg_match('/^[a-z0-9- \\:\\_\\*\\~\\.\\=\\@]+$/i', trim($value))) {
					$arr_out['code'] = 22;
					$arr_out['message'] = $lang['cloudflare_error_val'];
				}
			}
			else {
				$value = addslashes($value);
			}

			if ($arr_out) {
				return $arr_out;
			}
			if ($proxy) {
				$proxy = 'true';
			}
			else {
				$proxy = 'false';
			}

			switch ($type_dns) {
			case 'A':
			case 'AAAA':
			case 'CNAME':
				$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PUT "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/dns_records/' . $id_record . '" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"type":"' . $type_dns . '","name":"' . $name . '","content":"' . $value . '","ttl":"' . $ttl . '","proxiable":true,"proxied":' . $proxy . '}\''));
				break;

			case 'SPF':
			case 'TXT':
			case 'NS':
				$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PUT "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/dns_records/' . $id_record . '" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"type":"' . $type_dns . '","name":"' . $name . '","content":"' . $value . '","ttl":"' . $ttl . '","proxied":' . $proxy . '}\''));
				break;

			case 'MX':
				$priority = $data['priority'];

				if (!preg_match('/^[0-9]+$/i', $priority)) {
					$arr_out['code'] = 24;
					$arr_out['message'] = $lang['cloudflare_error_priority'];
				}
				if ($arr_out) {
					return $arr_out;
				}

				$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PUT "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/dns_records/' . $id_record . '" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"type":"' . $type_dns . '","name":"' . $name . '","content":"' . $value . '","priority":"' . $priority . '","ttl":"' . $ttl . '","proxied":' . $proxy . '}\''));
				break;

			case 'SRV':
				$priority = $data['priority'];
				$weight = $data['weight'];
				$port = $data['port'];
				$service_name = $data['service_name'];
				$domain_srv = $data['domain_srv'];
				$srv_name = trim($data['srv_name']);
				$proto = str_replace('_', '', $data['proto']);

				if (!preg_match('/^[0-9]+$/i', $priority)) {
					$arr_out['code'] = 24;
					$arr_out['message'] = $lang['cloudflare_error_priority'];
				}

				if (!preg_match('/^[0-9]+$/i', $weight)) {
					$arr_out['code'] = 25;
					$arr_out['message'] = $lang['cloudflare_error_weight'];
				}

				if (!preg_match('/^[0-9]+$/i', $port)) {
					$arr_out['code'] = 26;
					$arr_out['message'] = $lang['cloudflare_error_port'];
				}

				if (!preg_match('/^[_]+[a-z0-9_\\-\\*\\.]+$/i', $service_name)) {
					$arr_out['code'] = 27;
					$arr_out['message'] = $lang['cloudflare_error_service_name'];
				}

				if (!preg_match('/^[a-z0-9_\\-\\*\\.]+$/i', $domain_srv)) {
					$arr_out['code'] = 28;
					$arr_out['message'] = $lang['cloudflare_error_domain_name'];
				}

				if (!preg_match('/^[a-z0-9_\\-\\*\\.]+$/i', $srv_name)) {
					$arr_out['code'] = 29;
					$arr_out['message'] = $lang['cloudflare_error_name_srv'];
				}

				if (!preg_match('/^[a-z]+$/i', $proto)) {
					$arr_out['code'] = 30;
					$arr_out['message'] = $lang['cloudflare_error_proto'];
				}
				if ($arr_out) {
					return $arr_out;
				}

				$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PUT "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/dns_records/' . $id_record . '" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"type":"' . $type_dns . '","name":"' . $name . '","content":"SRV 8 8 30 ee.ee.","data":{"priority":' . $priority . ',"weight":' . $weight . ',"port":' . $port . ',"target":"' . $domain_srv . '","service":"' . $service_name . '","proto":"_' . $proto . '","name":"' . $srv_name . '"},"meta":{"auto_added": false},"ttl":"' . $ttl . '","proxied":' . $proxy . '}\''));
				break;

			case 'LOC':
				list(, , $lat_degrees, $lat_minutes, $lat_seconds, $lat_direction, $long_degrees, $long_minutes, $long_seconds, $long_direction, $altitude, $size, $precision_horz, $precision_vert) = explode(' ', $value);
				$altitude = preg_replace('/[a-z]+/i', '', $altitude);
				$size = preg_replace('/[a-z]+/i', '', $size);
				$precision_horz = preg_replace('/[a-z]+/i', '', $precision_horz);
				$precision_vert = preg_replace('/[a-z]+/i', '', $precision_vert);
				$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PUT "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/dns_records/' . $id_record . '" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"type":"' . $type_dns . '","name":"' . $name . '","content":"' . $value . '","data":{"altitude":' . $altitude . ',"lat_degrees":' . $lat_degrees . ',"lat_direction":"' . $lat_direction . '","lat_minutes":' . $lat_minutes . ',"lat_seconds":' . $lat_seconds . ',"long_degrees":' . $long_degrees . ',"long_direction":"' . $long_direction . '","long_minutes":' . $long_minutes . ',"long_seconds":' . $long_seconds . ',"precision_horz":' . $precision_horz . ',"precision_vert":' . $precision_vert . ',"size":' . $size . '},"ttl":"' . $ttl . '","proxied":' . $proxy . '}\''));
				break;
			}

			$ssh = (array) ();

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;

				if ($ssh['errors'][0]->error_chain) {
					$arr_out['message2'] = $ssh['errors'][0]->error_chain[0]->message;
				}
			}
			if ($arr_out) {
				return $arr_out;
			}

			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'rm_record':
			$id_record = $data['id_record'];

			if (!preg_match('/[a-z0-9]{30,}/i', $id_record)) {
				$arr_out['code'] = 24;
				$arr_out['message'] = $lang['cloudflare_error_id_record'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X DELETE "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/dns_records/' . $id_record . '" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'add_record':
			$type_dns = $data['type_dns'];
			$ttl = $data['ttl'];
			$name = $data['name'];
			$value = $data['value'];
			$proxy = $data['proxy'];

			if (!is_bool($proxy)) {
				$arr_out['code'] = 23;
				$arr_out['message'] = $lang['cloudflare_error_proxy'];
			}

			if (!preg_match('/^[0-9]+$/i', $ttl)) {
				$arr_out['code'] = 20;
				$arr_out['message'] = $lang['cloudflare_error_ttl'];
			}

			if (!preg_match('/^[a-z]+$/i', $type_dns)) {
				$arr_out['code'] = 19;
				$arr_out['message'] = $lang['cloudflare_error_type_record'];
			}

			if (!preg_match('/^[а-яёЁa-z0-9_\\-\\*\\.]+$/iu', $name)) {
				$arr_out['code'] = 21;
				$arr_out['message'] = $lang['cloudflare_error_name'];
			}

			if (($type_dns != 'TXT') && ($type_dns != 'SPF')) {
				if (!preg_match('/^[a-z0-9- \\:\\_\\*\\~\\.\\=\\@]+$/i', $value)) {
					$arr_out['code'] = 22;
					$arr_out['message'] = $lang['cloudflare_error_val'];
				}
			}
			else {
				$value = addslashes($value);
			}

			if ($arr_out) {
				return $arr_out;
			}
			if ($proxy) {
				$proxy = 'true';
			}
			else {
				$proxy = 'false';
			}

			switch ($type_dns) {
			case 'A':
			case 'AAAA':
			case 'CNAME':
				$ssh = implode('', $this->ssh('curl --tlsv1.2 -X POST "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/dns_records" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"type":"' . $type_dns . '","name":"' . $name . '","content":"' . $value . '","ttl":"' . $ttl . '","proxiable":true,"proxied":' . $proxy . '}\''));
				break;

			case 'SPF':
			case 'TXT':
			case 'NS':
				$ssh = implode('', $this->ssh('curl --tlsv1.2 -X POST "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/dns_records" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"type":"' . $type_dns . '","name":"' . $name . '","content":"' . $value . '","ttl":"' . $ttl . '","proxied":' . $proxy . '}\''));
				break;

			case 'MX':
				$priority = $data['priority'];

				if (!preg_match('/^[0-9]+$/i', $priority)) {
					$arr_out['code'] = 24;
					$arr_out['message'] = $lang['cloudflare_error_priority'];
				}
				if ($arr_out) {
					return $arr_out;
				}

				$ssh = implode('', $this->ssh('curl --tlsv1.2 -X POST "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/dns_records" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"type":"' . $type_dns . '","name":"' . $name . '","content":"' . $value . '","priority":"' . $priority . '","ttl":"' . $ttl . '","proxied":' . $proxy . '}\''));
				break;

			case 'LOC':
				list(, , $lat_degrees, $lat_minutes, $lat_seconds, $lat_direction, $long_degrees, $long_minutes, $long_seconds, $long_direction, $altitude, $size, $precision_horz, $precision_vert) = explode(' ', $value);
				$altitude = preg_replace('/[a-z]+/i', '', $altitude);
				$size = preg_replace('/[a-z]+/i', '', $size);
				$precision_horz = preg_replace('/[a-z]+/i', '', $precision_horz);
				$precision_vert = preg_replace('/[a-z]+/i', '', $precision_vert);
				$ssh = implode('', $this->ssh('curl --tlsv1.2 -X POST "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/dns_records" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"type":"' . $type_dns . '","name":"' . $name . '","content":"' . $value . '","data":{"altitude":' . $altitude . ',"lat_degrees":' . $lat_degrees . ',"lat_direction":"' . $lat_direction . '","lat_minutes":' . $lat_minutes . ',"lat_seconds":' . $lat_seconds . ',"long_degrees":' . $long_degrees . ',"long_direction":"' . $long_direction . '","long_minutes":' . $long_minutes . ',"long_seconds":' . $long_seconds . ',"precision_horz":' . $precision_horz . ',"precision_vert":' . $precision_vert . ',"size":' . $size . '},"ttl":"' . $ttl . '","proxied":' . $proxy . '}\''));
				break;

			case 'SRV':
				$priority = $data['priority'];
				$weight = $data['weight'];
				$port = $data['port'];
				$service_name = $data['service_name'];
				$domain_srv = $data['domain_srv'];
				$srv_name = $data['srv_name'];
				$proto = $data['proto'];

				if (!preg_match('/^[0-9]+$/i', $priority)) {
					$arr_out['code'] = 24;
					$arr_out['message'] = $lang['cloudflare_error_priority'];
				}

				if (!preg_match('/^[0-9]+$/i', $weight)) {
					$arr_out['code'] = 25;
					$arr_out['message'] = $lang['cloudflare_error_weight'];
				}

				if (!preg_match('/^[0-9]+$/i', $port)) {
					$arr_out['code'] = 26;
					$arr_out['message'] = $lang['cloudflare_error_port'];
				}

				if (!preg_match('/^[_]+[a-z0-9_\\-\\*\\.]+$/i', $service_name)) {
					$arr_out['code'] = 27;
					$arr_out['message'] = $lang['cloudflare_error_service_name'];
				}

				if (!preg_match('/^[a-z0-9_\\-\\*\\.]+$/i', $domain_srv)) {
					$arr_out['code'] = 28;
					$arr_out['message'] = $lang['cloudflare_error_domain_name'];
				}

				if (!preg_match('/^[a-z0-9_\\-\\*\\.]+$/i', $srv_name)) {
					$arr_out['code'] = 29;
					$arr_out['message'] = $lang['cloudflare_error_name_srv'];
				}

				if (!preg_match('/^[a-z]+$/i', $proto)) {
					$arr_out['code'] = 30;
					$arr_out['message'] = $lang['cloudflare_error_proto'];
				}
				if ($arr_out) {
					return $arr_out;
				}

				$ssh = implode('', $this->ssh('curl --tlsv1.2 -X POST "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/dns_records" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"type":"' . $type_dns . '","name":"' . $name . '","content":"' . $value . '","data":{"priority":' . $priority . ',"weight":' . $weight . ',"port":' . $port . ',"target":"' . $domain_srv . '","service":"' . $service_name . '","proto":"_' . $proto . '","name":"' . $srv_name . '"},"ttl":"' . $ttl . '","proxied":' . $proxy . '}\''));
				break;
			}

			$ssh = (array) ();

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;

				if ($ssh['errors'][0]->error_chain) {
					$arr_out['message2'] = $ssh['errors'][0]->error_chain[0]->message;
				}
			}
			if ($arr_out) {
				return $arr_out;
			}

			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'hotlink_protection':
			$hotlink_protection = $data['hotlink_protection'];

			if (!preg_match('/^(on)+$|^(off)+$/i', $hotlink_protection)) {
				$arr_out['code'] = 18;
				$arr_out['message'] = $lang['cloudflare_error_online_data'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/hotlink_protection" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $hotlink_protection . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			if ($hotlink_protection == 'on') {
				$status = 0;
			}
			else {
				$status = 1;
			}

			$arr_out['status'] = $status;
			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'server_side_excludes':
			$server_side_excludes = $data['server_side_excludes'];

			if (!preg_match('/^(on)+$|^(off)+$/i', $server_side_excludes)) {
				$arr_out['code'] = 18;
				$arr_out['message'] = $lang['cloudflare_error_online_data'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/server_side_exclude" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $server_side_excludes . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			if ($server_side_excludes == 'on') {
				$status = 0;
			}
			else {
				$status = 1;
			}

			$arr_out['status'] = $status;
			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'emailobfuscation':
			$emailobfuscation = $data['emailobfuscation'];

			if (!preg_match('/^(on)+$|^(off)+$/i', $emailobfuscation)) {
				$arr_out['code'] = 18;
				$arr_out['message'] = $lang['cloudflare_error_online_data'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/emailobfuscation" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $emailobfuscation . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			if ($emailobfuscation == 'on') {
				$status = 0;
			}
			else {
				$status = 1;
			}

			$arr_out['status'] = $status;
			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'pseudoipv4':
			$pseudoipv4 = $data['pseudoipv4'];

			if (!preg_match('/[a-z_]+/i', $pseudoipv4)) {
				$arr_out['code'] = 18;
				$arr_out['message'] = $lang['cloudflare_error_online_data'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/pseudo_ipv4" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $pseudoipv4 . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'ipgeolocation':
			$ipgeolocation = $data['ipgeolocation'];

			if (!preg_match('/^(on)+$|^(off)+$/i', $ipgeolocation)) {
				$arr_out['code'] = 18;
				$arr_out['message'] = $lang['cloudflare_error_online_data'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/ip_geolocation" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $ipgeolocation . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			if ($ipgeolocation == 'on') {
				$status = 0;
			}
			else {
				$status = 1;
			}

			$arr_out['status'] = $status;
			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'websockets':
			$websockets = $data['websockets'];

			if (!preg_match('/^(on)+$|^(off)+$/i', $websockets)) {
				$arr_out['code'] = 18;
				$arr_out['message'] = $lang['cloudflare_error_online_data'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/websockets" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $websockets . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			if ($websockets == 'on') {
				$status = 0;
			}
			else {
				$status = 1;
			}

			$arr_out['status'] = $status;
			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'clear_cashe_file':
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X DELETE "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/purge_cache" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"purge_everything":true}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'development_mode':
			$development_mode = $data['development_mode'];

			if (!preg_match('/^(on)+$|^(off)+$/i', $development_mode)) {
				$arr_out['code'] = 18;
				$arr_out['message'] = $lang['cloudflare_error_online_data'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/development_mode" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $development_mode . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			if ($development_mode == 'on') {
				$status = 0;
			}
			else {
				$status = 1;
			}

			$arr_out['status'] = $status;
			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'cashing_online':
			$cashing_online = $data['cashing_online'];

			if (!preg_match('/^(on)+$|^(off)+$/i', $cashing_online)) {
				$arr_out['code'] = 18;
				$arr_out['message'] = $lang['cloudflare_error_online_data'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/always_online" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $cashing_online . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			if ($cashing_online == 'on') {
				$status = 0;
			}
			else {
				$status = 1;
			}

			$arr_out['status'] = $status;
			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'cashing_time':
			$cashing_time = $data['cashing_time'];

			if (!preg_match('/[0-9]+/i', $cashing_time)) {
				$arr_out['code'] = 17;
				$arr_out['message'] = $lang['cloudflare_error_time_cached'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/browser_cache_ttl" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":' . $cashing_time . '}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'caching_level':
			$caching_level = $data['caching_level'];

			if (!preg_match('/[a-z]+/i', $caching_level)) {
				$arr_out['code'] = 16;
				$arr_out['message'] = $lang['cloudflare_error_level_cached'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/cache_level" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $caching_level . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'save_optimisation':
			$js = $data['js'];
			$css = $data['css'];
			$html = $data['html'];

			if (!is_bool($js) && !is_bool($css) && !is_bool($html)) {
				$arr_out['code'] = 15;
				$arr_out['message'] = $lang['cloudflare_optimisation_error_type'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			if (!$js) {
				$js = 'off';
			}
			else {
				$js = 'on';
			}

			if (!$css) {
				$css = 'off';
			}
			else {
				$css = 'on';
			}

			if (!$html) {
				$html = 'off';
			}
			else {
				$html = 'on';
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/minify" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":{"css":"' . $css . '","html":"' . $html . '","js":"' . $js . '"}}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'blocking_time':
			$blocking_time = $data['blocking_time'];

			if (!preg_match('/[0-9]{3,}/i', $blocking_time)) {
				$arr_out['code'] = 14;
				$arr_out['message'] = $lang['cloudflare_error_blocking_time'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/challenge_ttl" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $blocking_time . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'delete_rules_firewall':
			$id_rules = $data['id_rules'];

			if (!preg_match('/[a-z0-9]{30,}/i', $id_rules)) {
				$arr_out['code'] = 12;
				$arr_out['message'] = $lang['cloudflare_error_id_rules'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X DELETE "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/firewall/access_rules/rules/' . $id_rules . '" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"cascade":"none"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'security_level':
			$security_level = $data['security_level'];

			if (!preg_match('/[a-z_]+/i', $security_level)) {
				$arr_out['code'] = 13;
				$arr_out['message'] = $lang['cloudflare_error_level_security'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X PATCH "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/settings/security_level" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"value":"' . $security_level . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			$arr_out['code'] = 0;
			$arr_out['security_level'] = $security_level;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			$out_file_d = $this->read_file_n($this->path_data_domain);

			foreach ($out_file_d as $key_filed => $val_filed) {
				$val_filed = trim($val_filed);

				if (preg_match('/(' . $id_domain . ')+/i', $val_filed)) {
					$out_str_f = explode('|', $val_filed);
					$out_str_f[5] = $security_level;
					$array_new_domain[$key_filed] = implode('|', $out_str_f);
				}
				else {
					$array_new_domain[$key_filed] = $val_filed;
				}
			}

			$this->write_file(implode(PHP_EOL, $array_new_domain), $this->path_data_domain, 'r');
			break;

		case 'save_firewall':
			$mode = $data['mode'];

			if (!preg_match('/[a-z]+/i', $mode)) {
				$arr_out['code'] = 9;
				$arr_out['message'] = $lang['cloudflare_error_mode'];
			}

			$data_ip = $data['data_ip'];

			if (!preg_match('/^([a-z]{2})$|^(([0-9]{1,3}[\\.]){3}[0-9]{1,3}(\\/[0-9]{1,3})?)$/i', $data_ip)) {
				$arr_out['code'] = 10;
				$arr_out['message'] = $lang['cloudflare_error_ip_str'];
			}

			if (preg_match('/^[a-z]{2}$/i', $data_ip)) {
				$target = 'country';
			}
			else if (preg_match('/^([0-9]{1,3}[\\.]){3}[0-9]{1,3}(\\/[0-9]{1,3})+$/i', $data_ip)) {
				$target = 'ip_range';
			}
			else {
				$target = 'ip';
			}

			if ($arr_out) {
				return $arr_out;
			}

			$anotation = $data['anotation'];
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X POST "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '/firewall/access_rules/rules" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"mode":"' . $mode . '", "configuration":{"target":"' . $target . '","value":"' . $data_ip . '"},"notes":"' . $anotation . '"}\''));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['cloudflare_succesfully'];
			break;

		case 'add_domain':
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X POST "https://api.cloudflare.com/client/v4/zones" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json" --data \'{"name":"' . $domain . '","jump_start":true}\''));
			$ssh = (array) json_decode($ssh);

			if ($ssh['errors'][0]->code == 1061) {
				$arr_out['code'] = 1061;
				$arr_out['message'] = $lang['cloudflare_add_domain_check'];
			}
			else if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			$ssh1 = implode('', $this->ssh('curl --tlsv1.2 -X GET "https://api.cloudflare.com/client/v4/zones/' . $ssh['result']->id . '/settings/security_level" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh1 = (array) json_decode($ssh1);
			$arr_out['security_level'] = $ssh1['result']->value;
			$this->write_file($user . '|' . $ssh['result']->name . '|' . $ssh['result']->id . '|' . implode(',', $ip_old_record_a) . '|' . implode(',', $ssh['result']->name_servers) . '|' . $arr_out['security_level'] . '|0' . PHP_EOL, $this->path_data_domain, 'wb');
			$arr_out['code'] = 0;
			$arr_out['status'] = 0;
			$arr_out['username'] = $user;
			$arr_out['id_domain'] = $ssh['result']->id;
			$arr_out['nameservers'] = $ssh['result']->name_servers;
			$arr_out['message'] = $lang['cloudflare_succesfully_domain'];
			break;

		case 'remove_domain':
			$ssh = implode('', $this->ssh('curl --tlsv1.2 -X DELETE "https://api.cloudflare.com/client/v4/zones/' . $id_domain . '" -H "X-Auth-Email: ' . $email . '" -H "X-Auth-Key: ' . $auth_key . '" -H "Content-Type: application/json"'));
			$ssh = (array) json_decode($ssh);

			if (!$ssh['success']) {
				$arr_out['code'] = $ssh['errors'][0]->code;
				$arr_out['message'] = $ssh['errors'][0]->message;
			}
			if ($arr_out) {
				return $arr_out;
			}

			$this->del_string_new($id_domain, $this->path_data_domain);
			$arr_out['code'] = 0;
			$arr_out['status'] = 1;
			$arr_out['username'] = $user;
			$arr_out['message'] = $lang['cloudflare_succesfully_remove_domain'];
			break;
		}
	}

	public function get_data_cloudflare($domain)
	{
		if (!$this->check_value('domain', $domain)) {
			return 0;
		}

		$data_reg = trim($this->read_file($this->mode_operation));

		if ($data_reg == '1') {
			$config = $this->config_read($GLOBALS['DATA_VHOSTS'] . $domain . '.conf');
			$out_ssh = implode('', $this->ssh('cat ' . $this->path_data . ' | grep \'' . $config['user'] . '|\''));
			$user = $config['user'];
		}
		else {
			$out_ssh = implode('', $this->ssh('cat ' . $this->path_data . ' | grep \'root|\''));
			$user = 'root';
		}

		$out_ssh = explode('|', $out_ssh);
		$puny = new idna_convert();
		$domain_decode = $puny->decode(trim($domain));
		$out_ssh = implode('', $this->ssh('cat ' . $this->path_data_domain . ' | grep \'' . $domain_decode . '|\''));
		$data['auth_key'] = $auth_key;
		$data['email'] = $email;
		$data['user'] = $user;
		$data['user_domain'] = explode('|', $out_ssh)[0];
		$data['id_domain'] = explode('|', $out_ssh)[2];
		return $data;
	}
}


?>
