<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class crontab
{
	const URL_USER = '/etc/brainy/data/users/';
	const ROOT_USER = '/etc/brainy/data/crontab/';

	public $crontab_minute;
	public $crontab_hour;
	public $crontab_week;
	public $crontab_month;
	public $crontab_year;
	public $crontab_command;
	public $crontab_force_flag;

	public function show_info($user)
	{
		if ($user && ($user != 'root')) {
			if (!$this->check_value('user', $user)) {
				return false;
			}

			$result = $this->config_read(self::URL_USER . $user);
		}
		else {
			$result = $this->config_read(self::ROOT_USER . 'main');
		}

		return $result;
	}

	public function edit_crontab($user, $cron_email)
	{
		global $lang;
		if ($user && ($user != 'root')) {
			if (!$this->check_value('user', $user)) {
				return false;
			}

			$src = self::URL_USER . $user;
		}
		else {
			$src = self::ROOT_USER . 'main';
		}

		$mas_read = $this->config_read($src);
		if (preg_match('/^[\\w\\.\\d-_]+@[\\w\\.\\d-_]+\\.\\w{2,4}$/i', $cron_email) || empty($cron_email)) {
			if (!empty($cron_email)) {
				$mas_read['send_mail_cron'] = $cron_email;
				$this->config_save($src, $mas_read);
				$this->remove_add_crontab($mas_read, $user);
				$out['mesage'] = $lang['cron_save_ok'];
				return $out;
			}

			if (empty($cron_email)) {
				$mas_read['send_mail_cron'] = '';
				$this->config_save($src, $mas_read);
				$this->remove_add_crontab($mas_read, $user);
				$out['mesage'] = $lang['cron_save_ok'];
				return $out;
			}
		}
		else {
			return $out;
			$out['mesage'] = $lang['cron_null'];
			return $out;
		}
	}

	public function remove_add_crontab($mas, $user)
	{
		if (strlen(0 < $user)) {
			if (!$this->check_value('user', $user)) {
				return false;
			}
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);

		if (!empty($user) && ($user != 'root')) {
			$src = $confUser['rootdir'] . '/crontab';
		}
		else {
			$src = '/etc/brainy/data/crontab/crontab';
		}

		$result = $this->read_file_n($src);

		if (!preg_match('/^MAILTO/', $result[0])) {
			if (!$this->check_value('email', $mas['send_mail_cron'])) {
				return false;
			}

			array_unshift($result, 'MAILTO=' . $mas['send_mail_cron'] . PHP_EOL);

			if ($this->write_file(implode('', $result), $src, 'r')) {
				$this->crontab_load($user);
			}
		}
		else if (!$this->check_value('email', $mas['send_mail_cron'])) {
			return false;
		}
		else {
			return false;

			if ($mas['send_mail_cron']) {
				$result[0] = 'MAILTO=' . $mas['send_mail_cron'] . "\n";
			}
			else {
				unset($result[0]);
			}

			$this->write_file(implode('', $result), $src, 'r');
			$this->crontab_load($user);
		}

		return true;
	}

	public function crontab_check_is_job($command, $like = 1)
	{
		$outs = $this->crontab_commands();

		foreach ($outs as $value) {
			$val1 = trim($value);
			$val1 = explode(' ', $val1);
			$timerun = $val1[0] . ' ' . $val1[1] . ' ' . $val1[2] . ' ' . $val1[3] . ' ' . $val1[4];
			unset($val1[0]);
			unset($val1[1]);
			unset($val1[2]);
			unset($val1[3]);
			unset($val1[4]);
			$val1 = implode('', $val1);
			$command1 = str_replace(' ', '', $command);

			if ($like == 1) {
				return $timerun;
			}

			$outm['timerun'] = $timerun;

			return $timerun;
		}

		return '';
	}

	public function edit_config_script_cron($comnd, $minutes, $hour)
	{
		$dir = $GLOBALS['DOCUMENT_ROOT_PATH'] . '/etc/brainy/conf/cron_exec_config';
		$file_out_array = explode(PHP_EOL, trim(file_get_contents('/etc/brainy/conf/cron_exec_config')));

		foreach ($file_out_array as $key_val_array => $val_array) {
			list($comand, $time_exec) = explode('|', trim($val_array));
			$comand = trim($comand);
			$time_exec = trim($time_exec);

			if (($comand == $comnd) && $time_exec) {
				$new_array[$key_val_array] = $comnd . '|' . $minutes . ',' . $hour;
				$check_conf = 1;
			}
			else {
				if ($time_exec && $comand) {
					$new_array[$key_val_array] = trim($val_array);
				}
			}
		}

		if (!$check_conf) {
			$new_array[] = $comnd . '|' . $minutes . ',' . $hour;
		}

		$this->write_file(implode(PHP_EOL, $new_array), '/etc/brainy/conf/cron_exec_config', 'new');
	}

	public function crontab_check_brainy_status_command($command, $force_install = NULL, $timemass = array('minutes' => '*', 'hours' => '*', 'days' => '*', 'months' => '*', 'weekdays' => '*'))
	{
		$out = $this->crontab_checkstatus();
		if ((0 < substr_count($out, 'running')) || ((stripos($out, 'active') !== false) && (stripos($out, 'inactive') === false))) {
			$outm['crond_status'] = 1;
		}
		else {
			$outm['crond_status'] = 0;
		}

		$outs = $this->crontab_commands();
		$outm['crond_command_status'] = 0;

		foreach ($outs as $value) {
			$val1 = trim($value);
			$val1 = explode(' ', $val1);
			unset($val1[0]);
			unset($val1[1]);
			unset($val1[2]);
			unset($val1[3]);
			unset($val1[4]);
			$val1 = implode('', $val1);
			$command1 = str_replace(' ', '', $command);

			$outm['crond_command_status'] = 1;
			break;
		}

		if (($force_install == 1) && ($outm['crond_command_status'] == 0) && ($outm['crond_status'] == 1)) {
			$minutes = $timemass['minutes'];
			$hours = $timemass['hours'];
			$days = $timemass['days'];
			$months = $timemass['months'];
			$weekdays = $timemass['weekdays'];
			$this->crontab_cronjob_add($minutes, $hours, $days, $months, $weekdays, $command);
			$outs = $this->crontab_commands();
			$outm['crond_command_status'] = 0;

			foreach ($outs as $value) {
				$val1 = trim($value);
				$val1 = explode(' ', $val1);
				unset($val1[0]);
				unset($val1[1]);
				unset($val1[2]);
				unset($val1[3]);
				unset($val1[4]);
				$val1 = implode('', $val1);
				$command1 = str_replace(' ', '', $command);

				$outm['crond_command_status'] = 1;
				break;
			}
		}

		return $outm;
	}

	public function crontab_restart()
	{
		$out = $this->sudo_ssh('service crond restart');
		return $this->getstat_systemctl();
	}

	public function crontab_stop()
	{
		$out = $this->sudo_ssh('service crond stop');
		return $this->getstat_systemctl();
	}

	public function crontab_start()
	{
		$out = $this->sudo_ssh('service crond start');
		$out = implode('', $out);
		return $this->getstat_systemctl();
	}

	public function getstat_systemctl($act = 'status')
	{
		global $lang;

		if (stripos($GLOBALS['OS_VERSION'], 'centos7') !== false) {
			$stat = implode(',', $this->sudo_ssh('systemctl is-active crond'));
			if ((stripos($stat, 'inactive') !== false) || ($act == 'stop')) {
				$out = $lang['cron_stop_ok'];
				return $out;
			}

			if (stripos($stat, 'failed') !== false) {
				$out = $lang['cron_start_failed'];
			}

			if ((stripos($stat, 'active') !== false) && (stripos($stat, 'inactive') === false)) {
				$out = $lang['cron_start_ok'];
			}
		}
		else {
			$out = implode(',', $this->sudo_ssh('service crond status'));

			if (0 < substr_count($out, 'running')) {
				$out = $lang['cron_start_ok'];
			}
		}

		return $out;
	}

	public function crontab_checkstatus()
	{
		if (stripos($GLOBALS['OS_VERSION'], 'centos7') !== false) {
			$stat = implode(',', $this->sudo_ssh('systemctl is-active crond'));
			return $stat;
		}

		$out = $this->sudo_ssh('service crond status');
		return implode('<br>', $out);
	}

	public function crontab_commands($user = NULL)
	{
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		if ($user && ($user != 'root')) {
			if (!$this->check_value('user', $user)) {
				return false;
			}

			$dir = $confUser['rootdir'] . '/';
		}
		else {
			$dir = $GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/crontab/';
		}

		$out = $this->read_file_n($dir . 'crontab');
		$i = 1;

		if (is_array($out)) {
			foreach ($out as $value) {
				$nout[$i] = $value;
				++$i;
			}
		}

		if (preg_match('/^MAILTO/', $nout[1])) {
			unset($nout[1]);
		}

		if (preg_match('/^SHELL/', $nout[2])) {
			unset($nout[2]);
		}

		if (preg_match('/^SHELL/', $nout[1])) {
			unset($nout[1]);
		}

		return $nout;
	}

	public function crontab_delete_command($id, $user = NULL)
	{
		if (!$this->check_value('number', $id)) {
			return false;
		}

		if ($user && ($user != 'root')) {
			if (!$this->check_value('user', $user)) {
				return false;
			}

			$res_susp = $this->check_susp_cron($user);

			if ($res_susp != 0) {
				return $res_susp;
			}
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		if ($user && ($user != 'root')) {
			$dir = $confUser['rootdir'] . '/';
		}
		else {
			$dir = $GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/crontab/';
		}

		$out = $this->del_string_n($id - 1, $dir . 'crontab');
		$this->crontab_load($user);
		$res['code'] = 0;
		$res['message'] = 'ok';
		return $res;
	}

	public function crontab_getcron($command)
	{
		$freq = explode(' ', $command);
		$nfreq = array_slice($freq, 0, 5);
		$cr_comm = array_slice($freq, 5);
		$cr_comm = implode(' ', $cr_comm);
		$mass['minutes'] = $nfreq[0];
		$mass['hours'] = $nfreq[1];
		$mass['days'] = $nfreq[2];
		$mass['months'] = $nfreq[3];
		$mass['weekdays'] = $nfreq[4];
		$mass['command'] = $cr_comm;
		return $mass;
	}

	public function crontab_cronjob_edit($minutes, $hours, $days, $months, $weekdays, $command, $command_id, $user = NULL)
	{
		global $lang;

		if (preg_match('/^([0-9]{1,2},{1}){1,}[0-9]{1,2}$/', $minutes)) {
			$array_data = explode(',', $minutes);

			foreach ($array_data as $val_datatime) {
				$res['code'] = 2;
				$res['message'] = $lang['cron_min_fail_format'];

				return $res;
			}
		}

		if (!preg_match('/^([\\*]{0,1})$|^(([\\*]{1,1})([\\/]{1,1})([0-9]{1,1}|[0-5]{1,1}[0-9]{0,1}))$|^(([0-9]{1,1}[0-9]{0,1},{1}){1,}[0-9]{1,1}[0-9]{0,1})$/', $minutes) || (empty($minutes) && ($minutes != '0'))) {
			if (!preg_match('/^([0-9]{0,1}|[0-5]{0,1}[0-9]{0,1})$/', $minutes) || (empty($minutes) && ($minutes != '0'))) {
				$res['code'] = 2;
				$res['message'] = $lang['cron_min_fail_format'];
				return $res;
			}
		}

		if (preg_match('/^([0-9]{1,2},{1}){1,}[0-9]{1,2}$/', $hours)) {
			$array_data = explode(',', $hours);

			foreach ($array_data as $val_datatime) {
				$res['code'] = 2;
				$res['message'] = $lang['cron_hours_fail_format'];

				return $res;
			}
		}

		if (!preg_match('/^([\\*]{0,1})$|^(([\\*]{1,1})([\\/]{1,1})([0-9]{1,1}|[0-2]{1,1}[0-9]{0,1}))$|^((([0-9]{1,1}[0-9]{0,1}),{1}){1,}[0-9]{1,1}[0-9]{0,1})$/', $hours) || (empty($hours) && ($hours != '0')) || (24 <= $hours)) {
			if (!preg_match('/^([0-9]{0,1}|[0-2]{0,1}[0-9]{0,1})$/', $hours) || (empty($hours) && ($hours != '0')) || (24 <= $hours)) {
				$out['code'] = 2;
				$out['message'] = $lang['cron_hours_fail_format'];
				return $out;
			}
		}

		if (preg_match('/^([0-9]{1,2},{1}){1,}[0-9]{1,2}$/', $days)) {
			$array_data = explode(',', $days);

			foreach ($array_data as $val_datatime) {
				$res['code'] = 2;
				$res['message'] = $lang['cron_days_fail_format'];

				return $res;
			}
		}

		if (!preg_match('/^([\\*]{0,1})$|^(([\\*]{1,1})([\\/]{1,1})([0-9]{1,1}|[0-3]{1,1}[0-9]{0,1}))$|^(([0-9]{1,1}[0-9]{0,1},{1}){1,}[0-9]{1,1}[0-9]{0,1})$/', $days) || empty($days) || (31 < $days)) {
			if (!preg_match('/^([0-9]{0,1}|[0-3]{0,1}[0-9]{0,1})$/', $days) || empty($days) || (31 < $days)) {
				$out['code'] = 2;
				$out['message'] = $lang['cron_days_fail_format'];
				return $out;
			}
		}

		if (!preg_match('/^[0-9]{1,2}|[\\*]{1,1}$/', $months) || !trim($months)) {
			$res['code'] = 2;
			$res['message'] = $lang['cron_month_err'];
			return $res;
		}

		$val = array('mon', 'tue', 'wed', 'thu', 'fri', 'sat', 'sun', '*');

		if (!in_array($weekdays, $val)) {
			$res['code'] = 2;
			$res['message'] = $lang['cron_day_err'];
			return $res;
		}
		if ($user) {
			if (!$this->check_user($user)) {
				$res['code'] = 2;
				$res['message'] = $lang['cron_username_err'];
				return $res;
			}

			$res_susp = $this->check_susp_cron($user);

			if ($res_susp != 0) {
				return $res_susp;
			}
		}

		if (intval($command_id) == 0) {
			$res['code'] = 2;
			$res['message'] = $lang['cron_params_err'];
			return $res;
		}

		$allcomm = $minutes . ' ' . $hours . ' ' . $days . ' ' . $months . ' ' . $weekdays . ' ' . $command;
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		if ($user && ($user != 'root')) {
			$dir = $confUser['rootdir'] . '/';
		}
		else {
			$dir = $GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/crontab/';
		}

		$allcomm = str_replace('/', '\\/', $allcomm);
		$this->replace_string_n($command_id - 1, $allcomm, $dir . 'crontab');
		$this->crontab_load($user);
		$res['code'] = 0;
		$res['message'] = 'ok';
		return $res;
	}

	public function crontab_cronjob_add($minutes, $hours, $days, $months, $weekdays, $command, $user = NULL)
	{
		global $lang;

		if (preg_match('/^([0-9]{1,2},{1}){1,}[0-9]{1,2}$/', $minutes)) {
			$array_data = explode(',', $minutes);

			foreach ($array_data as $val_datatime) {
				$res['code'] = 2;
				$res['message'] = $lang['cron_min_fail_format'];

				return $res;
			}
		}

		if (!preg_match('/^([\\*]{0,1})$|^(([\\*]{1,1})([\\/]{1,1})([0-9]{1,1}|[0-5]{1,1}[0-9]{0,1}))$|^(([0-9]{1,1}[0-9]{0,1},{1}){1,}[0-9]{1,1}[0-9]{0,1})$/', $minutes) || (empty($minutes) && ($minutes != '0'))) {
			if (!preg_match('/^([0-9]{0,1}|[0-5]{0,1}[0-9]{0,1})$/', $minutes) || (empty($minutes) && ($minutes != '0'))) {
				$res['code'] = 2;
				$res['message'] = $lang['cron_min_fail_format'];
				return $res;
			}
		}

		if (preg_match('/^([0-9]{1,2},{1}){1,}[0-9]{1,2}$/', $hours)) {
			$array_data = explode(',', $hours);

			foreach ($array_data as $val_datatime) {
				$res['code'] = 2;
				$res['message'] = $lang['cron_hours_fail_format'];

				return $res;
			}
		}

		if (!preg_match('/^([\\*]{0,1})$|^(([\\*]{1,1})([\\/]{1,1})([0-9]{1,1}|[0-2]{1,1}[0-9]{0,1}))$|^(([0-9]{1,1}[0-9]{0,1},{1}){1,}[0-9]{1,1}[0-9]{0,1})$/', $hours) || (empty($hours) && ($hours != '0')) || (24 <= $hours)) {
			if (!preg_match('/^([0-9]{0,1}|[0-2]{0,1}[0-9]{0,1})$/', $hours) || (empty($hours) && ($hours != '0')) || (24 <= $hours)) {
				$out['code'] = 2;
				$out['message'] = $lang['cron_hours_fail_format'];
				return $out;
			}
		}

		if (preg_match('/^([0-9]{1,2},{1}){1,}[0-9]{1,2}$/', $days)) {
			$array_data = explode(',', $days);

			foreach ($array_data as $val_datatime) {
				$res['code'] = 2;
				$res['message'] = $lang['cron_days_fail_format'];

				return $res;
			}
		}

		if (!preg_match('/^([\\*]{0,1})$|^(([\\*]{1,1})([\\/]{1,1})([0-9]{1,1}|[0-3]{1,1}[0-9]{0,1}))$|^(([0-9]{1,1}[0-9]{0,1},{1}){1,}[0-9]{1,1}[0-9]{0,1})$/', $days) || empty($days) || (31 < $days)) {
			if (!preg_match('/^([0-9]{0,1}|[0-3]{0,1}[0-9]{0,1})$/', $days) || empty($days) || (31 < $days)) {
				$out['code'] = 2;
				$out['message'] = $lang['cron_days_fail_format'];
				return $out;
			}
		}

		if (!trim($command)) {
			$res['code'] = 2;
			$res['message'] = $lang['cron_command_err'];
			return $res;
		}

		if (!preg_match('/^[0-9]{1,2}$|^[\\*]{1,1}$/', $months) || !trim($months)) {
			$res['code'] = 2;
			$res['message'] = $lang['cron_month_err'];
			return $res;
		}

		$val = array('mon', 'tue', 'wed', 'thu', 'fri', 'sat', 'sun', '*');

		if (!in_array($weekdays, $val)) {
			$res['code'] = 2;
			$res['message'] = $lang['cron_day_err'];
			return $res;
		}
		if ($user) {
			if (!$this->check_user($user)) {
				$res['code'] = 2;
				$res['message'] = $lang['cron_username_err'];
				return $res;
			}

			$res_susp = $this->check_susp_cron($user);

			if ($res_susp != 0) {
				return $res_susp;
			}
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		if ($user && ($user != 'root')) {
			$dir = $confUser['rootdir'] . '/';
		}
		else {
			$dir = $GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/crontab/';
		}

		$loadC = preg_split('/[\\s,;]/', file_get_contents($dir . 'crontab'));

		if (2 < strlen($loadC[count($loadC) - 1])) {
			file_put_contents($dir . 'crontab', "\n", FILE_APPEND);
		}

		file_put_contents($dir . 'crontab', $minutes . ' ' . $hours . ' ' . $days . ' ' . $months . ' ' . $weekdays . ' ' . $command . "\n", FILE_APPEND);
		$this->crontab_load($user);
		$res['code'] = 0;
		$res['message'] = 'ok';
		return $res;
	}

	public function crontab_load($user = NULL)
	{
		if ($GLOBALS['DEMO'] == 1) {
			return NULL;
		}

		if ($user && ($user != 'root')) {
			if (!$this->check_user($user)) {
				return 0;
			}

			$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
			$user_info = $this->config_read($GLOBALS['USERS_PATH'] . '/' . $user);

			if ($user_info['jailstatset'] == 1) {
				$cronFile = $confUser['rootdir'] . '/crontab';
				$resFileCrons = file_get_contents($cronFile);

				if (stripos($resFileCrons, 'jk_chrootsh') === false) {
					$this->insert_string_n(1, 'SHELL=/usr/sbin/jk_chrootsh', $cronFile);
				}
			}

			$dir = $confUser['rootdir'] . '/';
			$loadC = preg_split('/[\\s,;]/', file_get_contents($dir . 'crontab'));

			if (2 < strlen($loadC[count($loadC) - 1])) {
				file_put_contents($dir . 'crontab', "\n", FILE_APPEND);
			}

			$this->sudo_ssh('crontab -u ' . $user . ' ' . $dir . 'crontab');
		}
		else {
			$dir = $GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/crontab/';
			$loadC = preg_split('/[\\s,;]/', file_get_contents($dir . 'crontab'));

			if (2 < strlen($loadC[count($loadC) - 1])) {
				file_put_contents($dir . 'crontab', "\n", FILE_APPEND);
			}

			$this->sudo_ssh('crontab -u root ' . $dir . 'crontab');
		}
	}

	public function crontab_remove_alltasks_new($username)
	{
		if ($username) {
			$this->sudo_ssh('crontab -u ' . $username . ' -r');
		}
	}

	public function crontab_remove_alltasks($user = NULL)
	{
		if ($user && ($user != 'root')) {
			$this->ssh_user($user, 'crontab -r');
		}
		else {
			$this->sudo_ssh('crontab -r');
		}
	}

	public function crontab_install()
	{
		$this->load_vars();
		$time = time();
		$install_status = $this->module_vars['install_status'];
		$install_status = explode(',', $install_status);
		$installed = intval($this->module_vars['installed']);
		$last_unsuccess_time = $this->module_vars['last_install_unsuccess_time'];
		$delta_time = $time - $last_unsuccess_time;

		if (($installed == 0) && ($install_status[0] != 'inprogress') && (intval($_GET['check']) == 0)) {
			$stream[0]['comm'] = $GLOBALS['DOCUMENT_ROOT_PATH'] . '/ssh/crontab install';
			$stream[0]['array_start'] = array('install_status' => 'inprogress,#stream_id#');
			$stream[0]['test'] = 'Complete!';
			$stream[0]['array_succes'] = array('install_status' => 'success,#stream_id#', 'installed' => '1');
			$stream[0]['array_unsucces'] = array('install_status' => 'unsucces,#stream_id#', 'last_install_unsuccess_time' => $time);
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php -q /etc/brainy/ssh/monitor/scaner.php > /dev/null 2> /dev/null';
			$stream_id = $this->create_stream($stream);
			$out1 = $this->read_stream($stream_id);
			$resmass['status'] = 'inprogress';
			$resmass['stream_id'] = $stream_id;
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}

		if (($installed == 0) && ($install_status[0] == 'inprogress')) {
			$out1 = $this->read_stream($install_status[1]);
			$resmass['status'] = 'inprogress';
			$resmass['stream_id'] = $install_status[1];
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}

		if (($installed == 1) && ($install_status[0] == 'success')) {
			$out1 = $this->read_stream($install_status[1]);
			$resmass['status'] = 'done';
			$resmass['stream_id'] = $install_status[1];
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}

		if (($installed == 1) && ($install_status[0] == 'unsucces')) {
			$out1 = $this->read_stream($install_status[1]);
			$resmass['status'] = 'failed';
			$resmass['stream_id'] = $install_status[1];
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}
	}

	public function crontab_delete()
	{
		$this->load_vars();
		$time = time();
		$delete_status = $this->module_vars['delete_status'];
		$delete_status = explode(',', $delete_status);
		$installed = intval($this->module_vars['installed']);
		$last_unsuccess_time = $this->module_vars['last_delete_unsuccess_time'];
		$delta_time = $time - $last_unsuccess_time;

		if (($this->check_service_installed('crond') == 1) && ($delete_status[0] != 'inprogress') && (intval($_GET['check']) == 0)) {
			$stream[0]['comm'] = $GLOBALS['DOCUMENT_ROOT_PATH'] . '/ssh/crontab delete';
			$stream[0]['array_start'] = array('delete_status' => 'inprogress,#stream_id#');
			$stream[0]['test'] = 'Complete!';
			$stream[0]['array_succes'] = array('delete_status' => 'success,#stream_id#', 'installed' => '0');
			$stream[0]['array_unsucces'] = array('delete_status' => 'unsucces,#stream_id#', 'last_delete_unsuccess_time' => $time);
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php -q /etc/brainy/ssh/monitor/scaner.php > /dev/null 2> /dev/null';
			$stream_id = $this->create_stream($stream);
			$out1 = $this->read_stream($stream_id);
			$resmass['status'] = 'inprogress';
			$resmass['stream_id'] = $stream_id;
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}

		if ($delete_status[0] == 'inprogress') {
			$out1 = $this->read_stream($delete_status[1]);
			$resmass['status'] = 'inprogress';
			$resmass['stream_id'] = $delete_status[1];
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}

		if (($this->check_service_installed('crond') == 0) && ($delete_status[0] == 'success')) {
			$out1 = $this->read_stream($delete_status[1]);
			$resmass['status'] = 'done';
			$resmass['stream_id'] = $delete_status[1];
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}

		if (($this->check_service_installed('crond') == 1) && ($delete_status[0] == 'unsucces')) {
			$out1 = $this->read_stream($delete_status[1]);
			$resmass['status'] = 'failed';
			$resmass['stream_id'] = $delete_status[1];
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}
	}

	public function crontab_reinstall()
	{
		$this->load_vars();
		$time = time();
		$install_status = $this->module_vars['reinstall_status'];
		$install_status = explode(',', $install_status);
		$installed = intval($this->module_vars['installed']);
		$start_time = $this->module_vars['start_time'];
		$last_unsuccess_time = $this->module_vars['last_reinstall_unsuccess_time'];
		$delta_time = $time - $last_unsuccess_time;
		$delta_start_time = $time - $start_time;

		if (($install_status[0] != 'inprogress') && (intval($_GET['check']) == 0)) {
			$stream[0]['comm'] = $GLOBALS['DOCUMENT_ROOT_PATH'] . '/ssh/crontab reinstall';
			$stream[0]['array_start'] = array('reinstall_status' => 'inprogress,#stream_id#', 'start_time' => $time);
			$stream[0]['test'] = 'Complete!';
			$stream[0]['array_succes'] = array('reinstall_status' => 'success,#stream_id#', 'installed' => '1', 'last_reinstall_finished_time' => $time);
			$stream[0]['array_unsucces'] = array('reinstall_status' => 'unsucces,#stream_id#', 'last_reinstall_finished_time' => $time);
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php -q /etc/brainy/ssh/monitor/scaner.php > /dev/null 2> /dev/null';
			$stream_id = $this->create_stream($stream);
			$out1 = $this->read_stream($stream_id);
			$resmass['status'] = 'inprogress';
			$resmass['stream_id'] = $stream_id;
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}

		if ($install_status[0] == 'inprogress') {
			$out1 = $this->read_stream($install_status[1]);
			$resmass['status'] = 'inprogress';
			$resmass['stream_id'] = $install_status[1];
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}

		if ($install_status[0] == 'success') {
			$out1 = $this->read_stream($install_status[1]);
			$resmass['status'] = 'done';
			$resmass['stream_id'] = $install_status[1];
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}

		if ($install_status[0] == 'unsucces') {
			$out1 = $this->read_stream($install_status[1]);
			$resmass['status'] = 'failed';
			$resmass['stream_id'] = $install_status[1];
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}
	}

	public function check_susp_cron($username)
	{
		if (!$this->check_value('user', $username)) {
			return 0;
		}

		global $lang;
		$config = $this->config_read($GLOBALS['USERS_PATH'] . $username);

		if ($config['suspended_cron'] == 1) {
			$res['code'] = 1;
			$res['message'] = $lang['cron_suspended_acc'];
			return $res;
		}

		return 0;
	}

	public function get_minutes_hour_for_day($val)
	{
		global $lang;
		if (!$this->check_value('number', $val) || !isset($val)) {
			$out_array['code'] = 100;
			$out_array['message'] = $lang['blacklist_error_minutes'];
			return $out_array;
		}

		$array['hour'] = '*';

		if (1440 < $val) {
			$return_array['code'] = 100;
			$return_array['message'] = $lang['blacklist_many_minutes'];
			return $return_array;
		}

		if (59 < $val) {
			$array['hour'] = '*/' . floor($val / 60);

			if (($val - (floor($val / 60) * 60)) == 0) {
				$array['minutes'] = '0';
			}
			else {
				$val_minutes = $val - (floor($val / 60) * 60);
				$array['minutes'] = $val_minutes;
			}
		}
		else if ((0 < $val) && ($val < 60)) {
			$array['minutes'] = '*/' . $val;
		}

		return $array;
	}

	public function getperiodcron_human($timecron)
	{
		$res = '';
		global $lang;
		$timecron_exp = explode(' ', $timecron);
		$usehoursin = 0;

		if (stripos($timecron_exp[1], '*') !== false) {
			$fullh = $timecron_exp[1];
			$timecron_exp[1] = str_replace(array('/', '*'), '', $timecron_exp[1]);

			if (strlen($timecron_exp[1]) < 1) {
				$timecron_exp[1] = 1;
			}

			if (2 < strlen($fullh)) {
				switch ($timecron_exp[1]) {
				case '1':
					$res .= $lang['common_every1hour'] . ' ' . $timecron_exp[1] . ' ' . $lang['common_hour1hour'];
					break;
				}

				switch ($timecron_exp[1]) {
				case $GLOBALS['lang'] && ($timecron_exp[1] <= 24):
					$res .= $lang['common_every2to24'] . ' ' . $timecron_exp[1] . ' ' . $lang['common_hour1hour'];
					break;
				}
			}
		}
		else {
			$usehoursin = 1;
			$res .= $lang['common_inhour'] . ' ' . $timecron_exp[1];
			$timecron_exp[1] = str_replace(array('/', '*'), '', $timecron_exp[1]);

			if (0 < strlen($res)) {
				switch ($timecron_exp[1]) {
				case '1':
					$res .= ' ' . $lang['common_hour1hour'];
					break;
				}

				switch ($timecron_exp[1]) {
				case $GLOBALS['lang'] && ($timecron_exp[1] <= 4):
					$res .= ' ' . $lang['common_hour2to4'];
					break;
				}

				switch ($timecron_exp[1]) {
				case $GLOBALS['lang'] && ($timecron_exp[1] <= 24):
					$res .= ' ' . $lang['common_hour5to24'];
					break;
				}
			}
		}

		$qminstart = 0;

		if (stripos($timecron_exp[0], '*') !== false) {
			$qminstart = 1;
			$timecron_exp[0] = str_replace(array('/', '*'), '', $timecron_exp[0]);

			if (strlen($timecron_exp[0]) < 1) {
				$timecron_exp[0] = 1;
			}

			switch ($timecron_exp[0]) {
			case '1':
				$res .= ' ' . $lang['common_every1minute'];
				break;
			}

			switch ($timecron_exp[0]) {
			case $GLOBALS['lang'] && ($timecron_exp[0] <= 60):
				$res .= ' ' . $lang['common_every2to60'];
				break;
			}
		}
		else if ($usehoursin == 0) {
			$res .= ' ' . $lang['common_inhour'];
		}

		$timecron_exp[0] = intval(str_replace(array('/', '*'), '', $timecron_exp[0]));

		if ($timecron_exp[0] == 1) {
			$res .= ' ' . $timecron_exp[0] . ' ' . $lang['common_minute1hour'];
		}
		else if ((2 <= $timecron_exp[0]) && ($timecron_exp[0] <= 4)) {
			$res .= ' ' . $timecron_exp[0] . ' ' . $lang['common_minute2to4'] . $timecron_exp[0];
		}
		else {
			if (((5 <= $timecron_exp[0]) && ($timecron_exp[0] <= 60)) || ($timecron_exp[0] == 0)) {
				$res .= ' ' . $timecron_exp[0] . ' ' . $lang['common_minute5to60and0'];
			}
		}

		if (($fullh == '*') && ($qminstart == 0)) {
			$res .= ' ' . $lang['common_everyhoursend'];
		}

		return $res;
	}

	public function testjobrun($user, $comm)
	{
		global $lang;
		$res = implode("\n", $this->ssh_user($user, $comm));
		return $lang['cron_comand_sucessf'] . $res;
	}
}


?>
