<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class ftp
{
	public $typeftp = 'noftp';
	public $mask_username_replace = 'someuser_repl';
	public $mask_homedir_replace = '/somehomedir_repl/';

	public function getservicename()
	{
		$foo = $this->config_read('/etc/brainy/data/ftp/main');
		$this->module_vars = $foo;
		$res['typeftp'] = $this->module_vars['ftp_servername_installed'];
		$this->typeftp = $res['typeftp'];
		$res = $this->getservicename_real();
		return $res;
	}

	public function getservicename_real()
	{
		$os_version = $GLOBALS['OS_VERSION'];
		$servicename = 'pure-ftpd';

		if ($os_version == 'debian8') {
			$comm = 'dpkg -l | grep ' . $servicename;
		}
		else {
			$comm = 'rpm -qa | grep ' . $servicename;
		}

		$file111 = '/etc/brainy/111111';
		$curr_versionftp = implode($this->ssh($comm));
		$res['typeftp'] = 'noftp';

		if (0 < strlen($curr_versionftp)) {
			$res['typeftp'] = $servicename;
		}
		else {
			$servicename = 'proftpd';

			if ($os_version == 'debian8') {
				$comm = 'dpkg -l | grep ' . $servicename;
			}
			else {
				$comm = 'rpm -qa | grep ' . $servicename;
			}

			$curr_versionftp = implode($this->sudo_ssh($comm));

			if (0 < strlen($curr_versionftp)) {
				$res['typeftp'] = $servicename;
			}
			else {
				$servicename = 'vsftpd';

				if ($os_version == 'debian8') {
					$comm = 'dpkg -l | grep ' . $servicename;
				}
				else {
					$comm = 'rpm -qa | grep ' . $servicename;
				}

				$curr_versionftp = implode($this->sudo_ssh($comm));

				if (0 < strlen($curr_versionftp)) {
					$res['typeftp'] = $servicename;
				}
			}
		}

		$this->typeftp = $res['typeftp'];
		return $res;
	}

	public function ftp_get_anyftp_listfulluser($main_user)
	{
		if (0 < strlen($main_user)) {
			if (!$this->check_value('string', $main_user)) {
				return 0;
			}
		}

		$getservname = $this->getservicename();

		switch ($getservname['typeftp']) {
		case 'pure-ftpd':
			$res = $this->ftp_getuser_pureftpd_all($main_user);
			break;

		case 'proftpd':
			$res = $this->ftp_getuser_proftpd_all($main_user);
			break;
		}

		return $res;
	}

	public function ftp_getuser_pureftpd_all($main_user)
	{
		if (0 < strlen($main_user)) {
			if (!$this->check_value('string', $main_user)) {
				return 0;
			}
		}

		$mass = array('PureDB');
		$del = ' ';
		$comm = array('#');
		$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PURE_FTPD_PATH'], $mass, $del, $comm);
		$ftp_pathfileuser = $ftp_pathfileuser['PureDB'];

		if (strlen($ftp_pathfileuser < 1)) {
			$ftp_pathfileuser = $GLOBALS['PureDB'];
		}

		$ftp_pathfileuser = str_replace('.pdb', '.passwd', $ftp_pathfileuser);
		$comm = 'cat ' . $ftp_pathfileuser . ' | grep "/' . $main_user . '/" | sed s/:.*// | tr "\\n" " "';
		$subuserftp = explode(' ', implode($this->ssh($comm)));
		asort($subuserftp);
		return $subuserftp;
	}

	public function generate_userlog_pureftpd()
	{
		$full_log_arr = 'cat /var/log/messages | grep \'pure-ftpd:\'';
		$full_log_arr = $this->ssh($full_log_arr);
		$user_mass = $this->get_users();
		sort($user_mass);
		$hostacc = new hostacc();

		foreach ($user_mass as $user) {
			$workspace = $hostacc->getWorkspace($user);

			if (0 < strlen($workspace)) {
				$workspace = $workspace . '/';
			}

			$subuser = $this->ftp_getuser_pureftpd_all($user);
			$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
			$file_user_log = $confUser['rootdir'] . '/' . $workspace . 'log/ftp_log_' . date('M_Y');
			$this->ssh('rm -rf ' . $file_user_log);

			foreach ($full_log_arr as $row_log) {
				foreach ($subuser as $onesub) {
					if (0 < strpos($row_log, '(' . $onesub . '@')) {
						file_put_contents($file_user_log, $row_log . "\n", FILE_APPEND | LOCK_EX);
					}
				}
			}

			$this->ssh('chown -R ' . $user . '.' . $user . ' ' . $file_user_log);
		}
	}

	public function ftp_getuser_proftpd_all($main_user)
	{
		if (0 < strlen($main_user)) {
			if (!$this->check_value('string', $main_user)) {
				return 0;
			}
		}

		$mass = array('AuthUserFile');
		$del = ' ';
		$comm = array('#');
		$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
		$ftp_pathfileuser = $ftp_pathfileuser['AuthUserFile'];
		$comm = 'cat ' . $ftp_pathfileuser . ' | grep "/' . $main_user . '[/,:]" | sed s/:.*// | tr "\\n" " "';
		$subuserftp = explode(' ', implode($this->ssh($comm)));
		asort($subuserftp);
		return $subuserftp;
	}

	public function generate_userlog_proftpd()
	{
		$mass = array('ExtendedLog');
		$del = ' ';
		$comm = array('#');
		$ftp_filelog = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
		$ftp_filelog = $ftp_filelog['ExtendedLog'];
		$ftp_filelog = explode(' ', $ftp_filelog)[0];
		$full_log_arr = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($ftp_filelog));
		$user_mass = $this->get_users();
		sort($user_mass);
		$hostacc = new hostacc();

		foreach ($user_mass as $user) {
			$subuser = $this->ftp_getuser_proftpd_all($user);
			$workspace = $hostacc->getWorkspace($user);

			if (0 < strlen($workspace)) {
				$workspace = $workspace . '/';
			}

			$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
			$file_user_log = $confUser['rootdir'] . '/' . $workspace . 'log/ftp_log_' . date('M_Y');
			$this->ssh('rm -rf ' . $file_user_log);

			foreach ($full_log_arr as $row_log) {
				foreach ($subuser as $onesub) {
					if (0 < strpos($row_log, ' ' . $onesub . ' [')) {
						file_put_contents($file_user_log, $row_log . "\n", FILE_APPEND | LOCK_EX);
					}
				}
			}

			$this->ssh('chown -R ' . $user . '.' . $user . ' ' . $file_user_log);
		}
	}

	public function generate_userlog()
	{
		$getservname = $this->getservicename();

		switch ($getservname['typeftp']) {
		case 'pure-ftpd':
			$this->generate_userlog_pureftpd();
			break;

		case 'proftpd':
			$this->generate_userlog_proftpd();
			break;
		}

		global $lang;
		$out['error'] = 0;
		$out['message'] = $lang['ftp_generatelog_ok'];
		return $out;
	}

	public function installftp($typeservftp, $getstreamonline = NULL)
	{
		$os_version = $GLOBALS['OS_VERSION'];

		if (!$this->check_value('string', $typeservftp)) {
			return 0;
		}
		if ($getstreamonline) {
			if (!$this->check_value('number', $getstreamonline)) {
				return 0;
			}
		}

		if (!is_dir($GLOBALS['USERS_PATH_FTP'])) {
			$comm = 'mkdir -p ' . $GLOBALS['USERS_PATH_FTP'];
			$this->ssh($comm);
		}

		$foo = $this->config_read('/etc/brainy/data/ftp/main');
		$this->module_vars = $foo;
		$time = time();
		$install_status = $this->module_vars['install_status'];
		$install_status = explode(',', $install_status);
		$installed = intval($this->module_vars['installed']);
		$last_unsuccess_time = $this->module_vars['last_install_unsuccess_time'];
		$delta_time = $time - $last_unsuccess_time;
		$ftp_ins = $this->module_vars['ftp_ins'];

		if (($installed == 0) && ($install_status[0] != 'inprogress') && (intval($_GET['check']) == 0)) {
			if ($typeservftp == 'pure-ftpd') {
				$this->ssh('mkdir -p /etc/pure-ftpd/');
			}

			if ($typeservftp == 'proftpd') {
				$this->ssh('mkdir -p /etc/proftpd/');
			}

			switch ($os_version) {
			case 'debian8':
				$stream[0]['comm'] = $GLOBALS['DOCUMENT_ROOT_PATH'] . '/ssh/ftp.sh install ' . $typeservftp;
				$stream[0]['array_start'] = array('install_status' => 'inprogress,#stream_id#', 'ftp_ins' => $typeservftp);
				$stream[0]['test'] = 'no';
				break;
			}

			$stream[0]['comm'] = ($os_version = $GLOBALS['OS_VERSION']) . '/ssh/ftp.sh install ' . $typeservftp;
			$stream[0]['array_start'] = array('install_status' => 'inprogress,#stream_id#', 'ftp_ins' => $typeservftp);
			$stream[0]['test'] = 'Complete!';
			$param = array('typeservftp' => $typeservftp);
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/ftp.php -a=\'installcert\' -p=\'' . json_encode($param) . '\'';
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/ftp.php -a=\'repairconf\' -p=\'' . json_encode($param) . '\'';
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/ftp.php -a=\'ftp_import_all_subftp\' -p=\'' . json_encode($param) . '\'';
			$param = array('typeservftp' => $typeservftp, 'action' => 'startftp');
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/ftp.php -a=\'actionftp\' -p=\'' . json_encode($param) . '\'';
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php -q /etc/brainy/ssh/monitor/scaner.php > /dev/null 2> /dev/null';

			if ($typeservftp == 'pure-ftpd') {
				$stream[]['comm'] = 'pure-pw mkdb';
			}

			$stream[0]['array_succes'] = array('ftp_servername_installed' => $typeservftp, 'install_status' => 'success,#stream_id#', 'installed' => '1');
			$stream[0]['array_unsucces'] = array('install_status' => 'unsucces,#stream_id#', 'last_install_unsuccess_time' => $time);

			if ($getstreamonline == 1) {
				$stream_id = $this->create_stream_online($stream, 'ftp');
			}
			else {
				$stream_id = $this->create_stream($stream);
			}

			$out1 = $this->read_stream($stream_id);
			$resmass['status'] = 'inprogress';
			$resmass['stream_id'] = $stream_id;
			$resmass['ftp_ins'] = $ftp_ins;
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}

		if ($install_status[0] == 'inprogress') {
			$out1 = $this->read_stream($install_status[1]);
			$resmass['status'] = 'inprogress';
			$resmass['stream_id'] = $install_status[1];
			$resmass['ftp_ins'] = $ftp_ins;
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}

		if ($install_status[0] == 'success') {
			$out1 = $this->read_stream($install_status[1]);
			$resmass['status'] = 'done';
			$resmass['stream_id'] = $install_status[1];
			$resmass['raw_info'] = implode("\n", $out1);
			$resmass['ftp_ins'] = $ftp_ins;
			$this->typeftp = $typeservftp;
			return $resmass;
		}

		if (($installed == 1) && ($install_status[0] == 'unsucces')) {
			$out1 = $this->read_stream($install_status[1]);
			$resmass['status'] = 'failed';
			$resmass['ftp_ins'] = $ftp_ins;
			$resmass['stream_id'] = $install_status[1];
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}
	}

	public function deleteftp($typeservftp, $getstreamonline = NULL)
	{
		$os_version = $GLOBALS['OS_VERSION'];

		if (!$this->check_value('string', $typeservftp)) {
			return 0;
		}
		if ($getstreamonline) {
			if (!$this->check_value('number', $getstreamonline)) {
				return 0;
			}
		}

		$foo = $this->config_read('/etc/brainy/data/ftp/main');
		$this->module_vars = $foo;
		$time = time();
		$delete_status = $this->module_vars['delete_status'];
		$delete_status = explode(',', $delete_status);
		$installed = intval($this->module_vars['installed']);
		$last_unsuccess_time = $this->module_vars['last_delete_unsuccess_time'];
		$ftp_ins = $this->module_vars['ftp_ins'];
		$delta_time = $time - $last_unsuccess_time;

		if (($delete_status[0] != 'inprogress') && (intval($_GET['check']) == 0)) {
			switch ($os_version) {
			case 'debian8':
				$stream[0]['comm'] = $GLOBALS['DOCUMENT_ROOT_PATH'] . '/ssh/ftp.sh delete ' . $typeservftp;
				$stream[0]['array_start'] = array('delete_status' => 'inprogress,#stream_id#', 'ftp_ins' => $typeservftp);
				$stream[0]['test'] = 'no';
				break;
			}

			$stream[0]['comm'] = ($os_version = $GLOBALS['OS_VERSION']) . '/ssh/ftp.sh delete ' . $typeservftp;
			$stream[0]['array_start'] = array('delete_status' => 'inprogress,#stream_id#', 'ftp_ins' => $typeservftp);
			$stream[0]['test'] = 'Complete!';
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php -q /etc/brainy/ssh/monitor/scaner.php > /dev/null 2> /dev/null';
			$stream[0]['array_succes'] = array('ftp_servername_installed' => 'noftp', 'delete_status' => 'success,#stream_id#', 'installed' => '"0"', 'start_time' => '0', 'last_reinstall_finished_time' => '0');
			$stream[0]['array_unsucces'] = array('delete_status' => 'unsucces,#stream_id#', 'last_delete_unsuccess_time' => $time);

			if ($getstreamonline == 1) {
				$stream_id = $this->create_stream_online($stream, 'ftp');
			}
			else {
				$stream_id = $this->create_stream($stream);
			}

			$out1 = $this->read_stream($stream_id);
			$resmass['status'] = 'inprogress';
			$resmass['stream_id'] = $stream_id;
			$resmass['ftp_ins'] = $ftp_ins;
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}

		if ($delete_status[0] == 'inprogress') {
			$out1 = $this->read_stream($delete_status[1]);
			$resmass['status'] = 'inprogress';
			$resmass['stream_id'] = $delete_status[1];
			$resmass['ftp_ins'] = $ftp_ins;
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}

		if ($delete_status[0] == 'success') {
			$out1 = $this->read_stream($delete_status[1]);
			$resmass['status'] = 'done';
			$resmass['stream_id'] = $delete_status[1];
			$resmass['ftp_ins'] = $ftp_ins;
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}

		if (($installed == 1) && ($delete_status[0] == 'unsucces')) {
			$out1 = $this->read_stream($delete_status[1]);
			$resmass['status'] = 'failed';
			$resmass['stream_id'] = $delete_status[1];
			$resmass['ftp_ins'] = $ftp_ins;
			$resmass['raw_info'] = implode("\n", $out1);
			return $resmass;
		}
	}

	public function reinstallftp($typeservftp, $getstreamonline = NULL)
	{
		$os_version = $GLOBALS['OS_VERSION'];

		if (!$this->check_value('string', $typeservftp)) {
			return 0;
		}
		if ($getstreamonline) {
			if (!$this->check_value('number', $getstreamonline)) {
				return 0;
			}
		}

		if (!is_dir($GLOBALS['USERS_PATH_FTP'])) {
			$comm = 'mkdir -p ' . $GLOBALS['USERS_PATH_FTP'];
			$this->ssh($comm);
		}

		$foo = $this->config_read('/etc/brainy/data/ftp/main');
		$this->module_vars = $foo;
		$time = time();
		$install_status = $this->module_vars['reinstall_status'];
		$install_status = explode(',', $install_status);
		$installed = intval($this->module_vars['installed']);
		$start_time = $this->module_vars['start_time'];
		$last_unsuccess_time = $this->module_vars['last_reinstall_unsuccess_time'];
		$ftp_ins = $this->module_vars['ftp_ins'];
		$delta_time = $time - $last_unsuccess_time;
		$delta_start_time = $time - $start_time;

		if (($install_status[0] != 'inprogress') && (intval($_GET['check']) == 0)) {
			if ($typeservftp == 'pure-ftpd') {
				$this->ssh('mkdir -p /etc/pure-ftpd/');
			}

			if ($typeservftp == 'proftpd') {
				$this->ssh('mkdir -p /etc/proftpd/');
			}

			switch ($os_version) {
			case 'debian8':
				$stream[0]['comm'] = $GLOBALS['DOCUMENT_ROOT_PATH'] . '/ssh/ftp.sh reinstall ' . $typeservftp;
				$stream[0]['array_start'] = array('reinstall_status' => 'inprogress,#stream_id#', 'start_time' => $time, 'ftp_ins' => $typeservftp);
				$stream[0]['test'] = 'no';
				break;
			}

			$stream[0]['comm'] = ($os_version = $GLOBALS['OS_VERSION']) . '/ssh/ftp.sh reinstall ' . $typeservftp;
			$stream[0]['array_start'] = array('reinstall_status' => 'inprogress,#stream_id#', 'start_time' => $time, 'ftp_ins' => $typeservftp);
			$stream[0]['test'] = 'Complete!';
			$param = array('typeservftp' => $typeservftp);
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/ftp.php -a=\'installcert\' -p=\'' . json_encode($param) . '\'';
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/ftp.php -a=\'repairconf\' -p=\'' . json_encode($param) . '\'';
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/ftp.php -a=\'ftp_import_all_subftp\' -p=\'' . json_encode($param) . '\'';
			$param = array('typeservftp' => $typeservftp, 'action' => 'startftp');
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/ftp.php -a=\'actionftp\' -p=\'' . json_encode($param) . '\'';
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php -q /etc/brainy/ssh/monitor/scaner.php > /dev/null 2> /dev/null';

			if ($typeservftp == 'pure-ftpd') {
				$stream[]['comm'] = 'pure-pw mkdb';
			}

			$stream[0]['array_succes'] = array('ftp_servername_installed' => $typeservftp, 'reinstall_status' => 'success,#stream_id#', 'installed' => '1', 'last_reinstall_finished_time' => $time);
			$stream[0]['array_unsucces'] = array('reinstall_status' => 'unsucces,#stream_id#', 'last_reinstall_finished_time' => $time);

			if ($getstreamonline == 1) {
				$stream_id = $this->create_stream_online($stream, 'ftp');
			}
			else {
				$stream_id = $this->create_stream($stream);
			}

			$out1 = $this->read_stream($stream_id);
			$resmass['status'] = 'inprogress';
			$resmass['stream_id'] = $stream_id;
			$resmass['raw_info'] = implode("\n", $out1);
			$resmass['ftp_ins'] = $ftp_ins;
			return $resmass;
		}

		if ($install_status[0] == 'inprogress') {
			$out1 = $this->read_stream($install_status[1]);
			$resmass['status'] = 'inprogress';
			$resmass['stream_id'] = $install_status[1];
			$resmass['raw_info'] = implode("\n", $out1);
			$resmass['ftp_ins'] = $ftp_ins;
			return $resmass;
		}

		if ($install_status[0] == 'success') {
			$out1 = $this->read_stream($install_status[1]);
			$resmass['status'] = 'done';
			$resmass['stream_id'] = $install_status[1];
			$resmass['raw_info'] = implode("\n", $out1);
			$resmass['ftp_ins'] = $ftp_ins;
			$this->typeftp = $typeservftp;
			return $resmass;
		}

		if ($install_status[0] == 'unsucces') {
			$out1 = $this->read_stream($install_status[1]);
			$resmass['status'] = 'failed';
			$resmass['stream_id'] = $install_status[1];
			$resmass['raw_info'] = implode("\n", $out1);
			$resmass['ftp_ins'] = $ftp_ins;
			return $resmass;
		}
	}

	public function getstatofserver()
	{
		$comm = 'pidof ' . $this->typeftp;
		$statofserver['statofserver'] = implode($this->sudo_ssh($comm));

		if (intval($statofserver['statofserver']) < 1) {
			$statofserver['statofserver'] = -1;
		}

		return $statofserver;
	}

	public function changestatftp($oper)
	{
		if ($oper) {
			if (!$this->check_value('string', $oper)) {
				$resmass['status_changed'] = 'failed';
				return $resmass;
			}
		}

		$comm = $GLOBALS['DOCUMENT_ROOT_PATH'] . '/ssh/ftp.sh ' . $oper . ' ' . $this->typeftp . ' &>/dev/stdout';
		$statofserver = implode($this->ssh($comm));
		$resmass['status'] = 'done';

		if (stripos($statofserver, 'failed') === false) {
			$resmass['status_changed'] = 'ok';
		}
		else {
			$resmass['status_changed'] = 'failed';
		}

		return $resmass;
	}

	public function parseconfig()
	{
		$file_conf = '';
		$file_inputs = '';
		$del = '=';
		$comm = array('#');
		if (!$this->typeftp || ($this->typeftp == 'noftp')) {
			$this->getservicename();
		}

		switch ($this->typeftp) {
		case 'vsftpd':
			$file_conf = $GLOBALS['VS_FTPD_PATH'];
			$file_inputs = $GLOBALS['MY_VS_FTPD_INPUTS'];
			$del = '=';
			$comm = array('#');
			break;

		case 'pure-ftpd':
			$file_conf = $GLOBALS['PURE_FTPD_PATH'];
			$file_inputs = $GLOBALS['MY_PURE_FTPD_INPUTS'];
			$del = ' ';
			$comm = array('#');
			break;

		case 'proftpd':
			$file_conf = $GLOBALS['PRO_FTPD_PATH'];
			$file_inputs = $GLOBALS['MY_PRO_FTPD_INPUTS'];
			$del = ' ';
			$comm = array('#');
			break;
		}

		$mass = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($file_inputs));
		$inputs_conf = $this->parse_config_read_param($file_conf, $mass, $del, $comm);
		$temp = file_get_contents($file_conf);
		$fullfileconf = htmlspecialchars($temp);
		$res['raw_info'] = $inputs_conf;
		$res['fullfileconf'] = $fullfileconf;
		$res['status'] = 'done';
		return $res;
	}

	public function saveconfig_inputs($serialdata)
	{
		global $lang;
		$file_conf = '';
		$file_inputs = '';
		$file_conf_my = '';
		$del = '=';
		$comm = array('#');
		if (!$this->typeftp || ($this->typeftp == 'noftp')) {
			$this->getservicename();
		}

		switch ($this->typeftp) {
		case 'vsftpd':
			$file_conf = $GLOBALS['VS_FTPD_PATH'];
			$file_conf_my = $GLOBALS['MY_VS_FTPD_PATH'];
			$file_inputs = $GLOBALS['MY_VS_FTPD_INPUTS'];
			$del = '=';
			$comm = array('#');
			break;

		case 'pure-ftpd':
			$file_conf = $GLOBALS['PURE_FTPD_PATH'];
			$file_conf_my = $GLOBALS['MY_PURE_FTPD_PATH'];
			$file_inputs = $GLOBALS['MY_PURE_FTPD_INPUTS'];
			$del = '         ';
			$comm = array('#');
			break;

		case 'proftpd':
			$file_conf = $GLOBALS['PRO_FTPD_PATH'];
			$file_conf_my = $GLOBALS['MY_PRO_FTPD_PATH'];
			$file_inputs = $GLOBALS['MY_PRO_FTPD_INPUTS'];
			$del = ' ';
			$comm = array('#');
			break;
		}

		$arr_input = json_decode($serialdata, true);

		foreach ($serialdata as $key => $value) {
			if (in_array($key, array('PureDB', 'AltLog'))) {
				return false;
			}

			return false;
		}

		$this->parse_config_save($file_conf, $arr_input, $del, $comm);
		$this->parse_config_save($file_conf_my, $arr_input, $del, $comm);
		$res['mess'] = $lang['ftp_conf_save_success'];
		$res['raw_info'] = '1';
		$res['status'] = 'done';
		return $res;
	}

	public function saveftpconfigfile($serialdata)
	{
		global $lang;
		$file_conf = '';
		$file_inputs = '';
		$file_conf_my = '';
		if (!$this->typeftp || ($this->typeftp == 'noftp')) {
			$this->getservicename();
		}

		switch ($this->typeftp) {
		case 'vsftpd':
			$file_conf = $GLOBALS['VS_FTPD_PATH'];
			$file_conf_my = $GLOBALS['MY_VS_FTPD_PATH'];
			$file_inputs = $GLOBALS['MY_VS_FTPD_INPUTS'];
			break;

		case 'pure-ftpd':
			$file_conf = $GLOBALS['PURE_FTPD_PATH'];
			$file_conf_my = $GLOBALS['MY_PURE_FTPD_PATH'];
			$file_inputs = $GLOBALS['MY_PURE_FTPD_INPUTS'];
			break;

		case 'proftpd':
			$file_conf = $GLOBALS['PRO_FTPD_PATH'];
			$file_conf_my = $GLOBALS['MY_PRO_FTPD_PATH'];
			$file_inputs = $GLOBALS['MY_PRO_FTPD_INPUTS'];
			break;
		}

		$arr_input = json_decode($serialdata, true);
		$del = '=';
		$comm = array('#');
		$this->write_file($arr_input['val'], $file_conf, 'r', NULL, 1);
		$this->write_file($arr_input['val'], $file_conf_my, 'r', NULL, 1);
		$res['mess'] = $lang['ftp_conf_save_success'];
		$res['raw_info'] = '1';
		$res['status'] = 'done';
		return $res;
	}

	public function restoredefault()
	{
		$file_conf = '';
		$file_conf_default = '';
		$file_inputs = '';
		$file_conf_my = '';
		if (!$this->typeftp || ($this->typeftp == 'noftp')) {
			$this->getservicename();
		}

		switch ($this->typeftp) {
		case 'vsftpd':
			$file_conf = $GLOBALS['VS_FTPD_PATH'];
			$file_conf_default = $GLOBALS['DEFAULT_VS_FTPD'];
			$file_conf_my = $GLOBALS['MY_VS_FTPD_PATH'];
			$file_inputs = $GLOBALS['MY_VS_FTPD_INPUTS'];
			break;

		case 'pure-ftpd':
			$file_conf = $GLOBALS['PURE_FTPD_PATH'];
			$file_conf_default = $GLOBALS['DEFAULT_PURE_FTPD'];
			$file_conf_my = $GLOBALS['MY_PURE_FTPD_PATH'];
			$file_inputs = $GLOBALS['MY_PURE_FTPD_INPUTS'];
			break;

		case 'proftpd':
			$file_conf = $GLOBALS['PRO_FTPD_PATH'];
			$file_conf_default = $GLOBALS['DEFAULT_PRO_FTPD'];
			$file_conf_my = $GLOBALS['MY_PRO_FTPD_PATH'];
			$file_inputs = $GLOBALS['MY_PRO_FTPD_INPUTS'];
			break;
		}

		copy($file_conf_default, $file_conf);
		$res['raw_info'] = '1';
		$res['status'] = 'done';
		return $res;
	}

	public function repairconfmy($modules = '')
	{
		$file_conf = '';
		$file_conf_default = '';
		$file_inputs = '';
		$file_conf_my = '';
		if (!$this->typeftp || ($this->typeftp == 'noftp')) {
			$this->getservicename();
		}

		if ($modules == 'packet_manager') {
			$packet_manager2 = new packet_manager2();
			$array_packet = $packet_manager2->get_packets();

			if (is_file($array_packet['ftp']['config'][$this->typeftp])) {
				$conf_edit = $array_packet['ftp']['config'][$this->typeftp];
			}
		}

		switch ($this->typeftp) {
		case 'vsftpd':
			$file_conf = $GLOBALS['VS_FTPD_PATH'];
			$file_conf_default = $GLOBALS['DEFAULT_VS_FTPD'];
			$file_conf_my = $GLOBALS['MY_VS_FTPD_PATH'];
			$file_inputs = $GLOBALS['MY_VS_FTPD_INPUTS'];
			break;

		case 'pure-ftpd':
			$file_conf = $GLOBALS['PURE_FTPD_PATH'];
			$file_conf_default = $GLOBALS['DEFAULT_PURE_FTPD'];
			$file_conf_my = ($conf_edit ? $conf_edit : $GLOBALS['MY_PURE_FTPD_PATH']);
			$file_inputs = $GLOBALS['MY_PURE_FTPD_INPUTS'];
			break;

		case 'proftpd':
			$file_conf = $GLOBALS['PRO_FTPD_PATH'];
			$file_conf_default = $GLOBALS['DEFAULT_PRO_FTPD'];
			$file_conf_my = ($conf_edit ? $conf_edit : $GLOBALS['MY_PRO_FTPD_PATH']);
			$file_inputs = $GLOBALS['MY_PRO_FTPD_INPUTS'];
			break;
		}

		copy($file_conf_my, $file_conf);
		$res['raw_info'] = '1';
		$res['status'] = 'done';
		return $res;
	}

	public function ftp_write_user_file_config($user_data_main, $serialdata)
	{
		if (!$this->check_value('user', $user_data_main['name'])) {
			return 0;
		}

		$arr_input = json_decode($serialdata);
		$logsafe = htmlspecialchars($arr_input->login, ENT_QUOTES);
		$passsafe = $this->strip_quotes_cmd($this->escape_slash_echoe($arr_input->pass));
		$homedir = htmlspecialchars($arr_input->ftp_user_dir, ENT_QUOTES);
		$ftp_user_quota = intval($arr_input->ftp_user_quota);
		$ftp_user_readonly = intval($arr_input->readonly);
		$loginUser = $user_data_main['name'] . '_' . $logsafe;
		$arrValueMain = 0;

		if (isset($arr_input->mainuser) && ($arr_input->mainuser == 1)) {
			$loginUser = $user_data_main['name'];
			$arrValueMain = 1;
		}

		$arr = array('owner' => $user_data_main['name'], 'owner_rootdir' => $user_data_main['rootdir'], 'login' => $loginUser, 'pass' => $this->cryptmainfunc($passsafe, $GLOBALS['cryptkeymain']), 'homedir' => $homedir, 'quota' => $ftp_user_quota, 'readonly' => $ftp_user_readonly);
		$arr['mainuser'] = $arrValueMain;
		$this->config_save($GLOBALS['USERS_PATH_FTP'] . $user_data_main['name'] . '_' . $loginUser, $arr);
	}

	public function ftp_update_user_file_config($field, $value, $subuser, $mainuser)
	{
		global $lang;

		if (0 < strlen($field)) {
			if (!$this->check_value('string', $field)) {
				$out['status'] = 2;
				return $out;
			}
		}

		if (0 < strlen($subuser)) {
			if (!$this->check_value('string', $subuser)) {
				$out['status'] = 2;
				return $out;
			}
		}

		if (!$this->check_value('user', $mainuser)) {
			$out['status'] = 2;
			return $out;
		}

		$del = '=';
		$comm = array('#');

		if ($field != 'pass') {
			$arr_input = array($field => $value);
		}
		else {
			$arr_input = array($field => $this->cryptmainfunc($value, $GLOBALS['cryptkeymain']));
		}

		$this->config_save_my($GLOBALS['USERS_PATH_FTP'] . $mainuser . '_' . $subuser, $arr_input, 'add');
	}

	public function ftp_import_all_subftp($typeservftp, $ftplist_rest = NULL)
	{
		global $lang;

		if (0 < strlen($typeservftp)) {
			if (!$this->check_value('string', $typeservftp)) {
				$out['status'] = 2;
				return $out;
			}
		}
		if ($ftplist_rest) {
			$username = explode('_', $ftplist_rest[0])[0];

			if (!$this->check_value('user', $username)) {
				$out['status'] = 2;
				return $out;
			}
		}

		$anslogin = array();
		$ansconfig = array();
		$ansconfigfile = array();

		if (!is_null($ftplist_rest)) {
			if (isset($ftplist_rest[0])) {
				$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
				$path_dump_ftps = $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_DIR_FTPS'];
			}
			else {
				exit();
			}
		}
		else {
			$path_dump_ftps = $GLOBALS['USERS_PATH_FTP'];
		}

		if ($handle = opendir($path_dump_ftps)) {
			while (false !== $file = readdir($handle)) {
				if (($file != '.') && ($file != '..')) {
					if (!is_null($ftplist_rest)) {
						if (!in_array($file, $ftplist_rest)) {
							continue;
						}
					}

					$anslogin[] = $file;
					$ansconfig[] = parse_ini_file($path_dump_ftps . '/' . $file);
				}
			}

			closedir($handle);
		}

		if ($typeservftp == 'pure-ftpd') {
			$mass = array('PureDB');
			$del = ' ';
			$comm = array('#');
			$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PURE_FTPD_PATH'], $mass, $del, $comm);
			$ftp_pathfileuser = $ftp_pathfileuser['PureDB'];

			if (strlen($ftp_pathfileuser < 1)) {
				$ftp_pathfileuser = $GLOBALS['PureDB'];
			}

			$ftp_pathfileuser = str_replace('.pdb', '.passwd', $ftp_pathfileuser);

			if (is_null($ftplist_rest)) {
				file_put_contents($ftp_pathfileuser, '');
			}
		}

		if ($typeservftp == 'proftpd') {
			$mass = array('AuthUserFile');
			$del = ' ';
			$comm = array('#');
			$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
			$ftp_pathfileuser = $ftp_pathfileuser['AuthUserFile'];

			if (!is_dir($GLOBALS['PRO_FTPD_DIR_PATH'])) {
				$comm = 'mkdir ' . $GLOBALS['PRO_FTPD_DIR_PATH'];
				$this->ssh($comm);
			}

			if (is_null($ftplist_rest)) {
				file_put_contents($ftp_pathfileuser, '');
				$this->ssh('chmod 640 ' . $ftp_pathfileuser);
			}

			$mass = array('QuotaLimitTable');
			$del = ' ';
			$comm = array('#');
			$dir_user_file_quota = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
			$dir_user_file_quota = $dir_user_file_quota['QuotaLimitTable'];
			$dir_user_file_quota = str_replace('file:', '', $dir_user_file_quota);
			$comm = 'rm -rf ' . $dir_user_file_quota;
			$this->ssh($comm);
			$mass = array('QuotaTallyTable');
			$del = ' ';
			$comm = array('#');
			$dir_user_file_quota_tally = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
			$dir_user_file_quota_tally = $dir_user_file_quota_tally['QuotaTallyTable'];
			$dir_user_file_quota_tally = str_replace('file:', '', $dir_user_file_quota_tally);
			$comm = 'rm -rf ' . $dir_user_file_quota_tally;
			$this->ssh($comm);
		}

		$resimp = array();
		$i = 0;

		foreach ($ansconfig as $user) {
			$user_data_main = array();
			$user_data_main['name'] = $user['owner'];
			$user_data_main['rootdir'] = $user['owner_rootdir'];
			$ftp_conf = array();
			$ftp_conf['login'] = str_replace($user['owner'] . '_', '', $user['login']);
			$ftp_conf['pass'] = $this->decryptmainfunc($user['pass'], $GLOBALS['cryptkeymain']);
			$ftp_conf['ftp_user_dir'] = $user['homedir'];
			$ftp_conf['ftp_user_quota'] = $user['quota'];
			$ftp_conf['readonly'] = $user['readonly'];
			$ftp_conf['mainuser'] = $user['mainuser'];
			$serialdata = json_encode($ftp_conf);

			if ($typeservftp == 'pure-ftpd') {
				if ($this->ftp_useradd_pureftpd($user_data_main, $serialdata)['err'] == 0) {
					$this->ftp_write_user_file_config($user_data_main, $serialdata);
					$resimp[$i]['login'] = $ftp_conf['login'];
					$resimp[$i]['status'] = 1;
				}
				else {
					$resimp[$i]['login'] = $ftp_conf['login'];
					$resimp[$i]['status'] = 0;
				}
			}

			if ($typeservftp == 'proftpd') {
				if ($this->ftp_useradd_proftpd($user_data_main, $serialdata)['err'] == 0) {
					$this->ftp_write_user_file_config($user_data_main, $serialdata);
					$resimp[$i]['login'] = $ftp_conf['login'];
					$resimp[$i]['status'] = 1;
				}
				else {
					$resimp[$i]['login'] = $ftp_conf['login'];
					$resimp[$i]['status'] = 0;
				}
			}

			++$i;
		}

		$comm = 'service ' . $typeservftp . ' restart';
		$this->ssh($comm);
		return $resimp;
	}

	public function ftp_useradd_pureftpd($user_data_main, $serialdata)
	{
		global $lang;

		if (!$this->check_value('user', $user_data_main['name'])) {
			$res['err'] = 3;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
		}

		if (!isset($user_data_main['name'])) {
			$out['err'] = -3;
			$out['mess'] = 'User not found';
			return $out;
		}

		$arr_input = json_decode($serialdata);

		if (isset($arr_input->mainuser) && ($arr_input->mainuser == 1)) {
			$logsafe = $user_data_main['name'];
		}
		else {
			$logsafe = $user_data_main['name'] . '_' . htmlspecialchars($arr_input->login, ENT_QUOTES);
		}

		$passsafe = $this->strip_quotes_cmd($this->escape_slash_echoe($arr_input->pass));
		$homedir = htmlspecialchars($arr_input->ftp_user_dir, ENT_QUOTES);
		$ftp_user_quota = intval($arr_input->ftp_user_quota);
		$ftpuser_readonly = intval($arr_input->readonly);
		$hostacc = new hostacc();
		$workspace = $hostacc->getWorkspace($user_data_main['name']);

		if (0 < strlen($workspace)) {
			$workspace = $workspace . '/';
		}

		$out['err'] = 0;
		$out['mess'] = $lang['ftp_user_add_ok'];

		if (!preg_match('|^[\\d]+$|', $ftp_user_quota)) {
			$out['err'] = 1;
			$out['mess'] = $lang['ftp_user_quota_wrong'];
		}

		if (0 < strlen($homedir)) {
			if (!$this->check_params('dir', $homedir)) {
				$out['err'] = 1;
				$out['mess'] = $lang['ftp_user_userdir_wrong'];
			}
		}
		else {
			$homedir = '/';
		}

		if (!preg_match('/^[A-z0-9\\@_-]+$/uSi', $logsafe)) {
			$out['err'] = 1;
			$out['mess'] = $lang['ftp_user_login_new_wrong'];
		}

		$mass = array('PureDB');
		$del = ' ';
		$comm = array('#');
		$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PURE_FTPD_PATH'], $mass, $del, $comm);
		$ftp_pathfileuser = $ftp_pathfileuser['PureDB'];

		if (strlen($ftp_pathfileuser < 1)) {
			$ftp_pathfileuser = $GLOBALS['PureDB'];
		}

		$ftp_pathfileuser = str_replace('.pdb', '.passwd', $ftp_pathfileuser);
		$comm = 'cat ' . $ftp_pathfileuser . ' | grep \'^' . $logsafe . ':\' | cut -d \':\' -f1';
		$resans = $this->ssh($comm);

		if (0 < count($resans)) {
			$out['err'] = -1;
			$out['mess'] = $lang['ftp_error_add_user_exist'];
			return $out;
		}

		if ($ftpuser_readonly != 1) {
			$comm = '(echo \'' . $passsafe . '\'; echo \'' . $passsafe . '\';) | pure-pw useradd ' . $logsafe . ' -f ' . $ftp_pathfileuser . ' -u ' . $user_data_main['name'] . ' -g ' . $user_data_main['name'] . ' -d ' . $user_data_main['rootdir'] . '/' . $homedir . ' -m';
		}
		else {
			$comm = '(echo \'' . $passsafe . '\'; echo \'' . $passsafe . '\';) | pure-pw useradd ' . $logsafe . ' -f ' . $ftp_pathfileuser . ' -u ftpuser-read ' . ' -g ftpgroup ' . ' -d ' . $user_data_main['rootdir'] . '/' . $homedir . ' -m';
		}

		$resAdd = $this->ssh($comm);
		$comm = 'mkdir ' . $user_data_main['rootdir'] . '/' . $homedir;
		$this->ssh($comm);
		if ((0 < strlen($workspace)) || (1 < strlen($homedir))) {
			$comm = 'chown ' . $user_data_main['name'] . '.' . $user_data_main['name'] . ' ' . $user_data_main['rootdir'] . '/' . $homedir;
			$this->ssh($comm);
		}

		if ($ftp_user_quota != 0) {
			$comm = 'pure-pw usermod "' . $logsafe . '" -f ' . $ftp_pathfileuser . ' -N ' . $ftp_user_quota . ' -m';
		}

		$this->ssh($comm);
		$comm = 'pure-ftpwho -s | grep "^' . $logsafe . '" | cut -d "|" -f1 | xargs kill';
		$this->ssh($comm);
		$out['err'] = 0;
		$out['mess'] = $lang['ftp_user_add_ok'];
		return $out;
	}

	public function ftp_useradd_proftpd($user_data_main, $serialdata)
	{
		global $lang;

		if (!$this->check_value('user', $user_data_main['name'])) {
			$res['err'] = 3;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
		}

		if (!isset($user_data_main['name'])) {
			$out['err'] = -3;
			$out['mess'] = 'User not found';
			return $out;
		}

		$hostacc = new hostacc();
		$workspace = $hostacc->getWorkspace($user_data_main['name']);

		if (0 < strlen($workspace)) {
			$workspace = $workspace . '/';
		}

		$arr_input = json_decode($serialdata);

		if (isset($arr_input->mainuser) && ($arr_input->mainuser == 1)) {
			$logsafe = $user_data_main['name'];
		}
		else {
			$logsafe = $user_data_main['name'] . '_' . htmlspecialchars($arr_input->login, ENT_QUOTES);
		}

		$passsafe = $this->strip_quotes_cmd($this->escape_slash_echoe($arr_input->pass));
		$homedir = htmlspecialchars($arr_input->ftp_user_dir, ENT_QUOTES);
		$homedir = str_replace('//', '/', $homedir);
		$homedir = str_replace('\\', '', $homedir);
		$ftp_user_quota = intval($arr_input->ftp_user_quota);
		$ftp_user_readonly = intval($arr_input->readonly);
		$out['err'] = 0;
		$out['mess'] = $lang['ftp_user_add_ok'];

		if (!preg_match('|^[\\d]+$|', $ftp_user_quota)) {
			$out['err'] = 1;
			$out['mess'] = $lang['ftp_user_quota_wrong'];
		}

		if (0 < strlen($homedir)) {
			if (!$this->check_params('dir', $homedir)) {
				$out['err'] = 1;
				$out['mess'] = $lang['ftp_user_userdir_wrong'];
			}
		}
		else {
			$homedir = '/';
		}

		if (!preg_match('/^[A-z0-9\\@_-]+$/uSi', $logsafe)) {
			$out['err'] = 1;
			$out['mess'] = $lang['ftp_user_login_new_wrong'];
		}

		$mass = array('AuthUserFile');
		$del = ' ';
		$comm = array('#');
		$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
		$ftp_pathfileuser = $ftp_pathfileuser['AuthUserFile'];

		if (!is_dir($GLOBALS['PRO_FTPD_DIR_PATH'])) {
			$comm = 'mkdir ' . $GLOBALS['PRO_FTPD_DIR_PATH'];
			$this->ssh($comm);
		}

		$comm = 'cat ' . $ftp_pathfileuser . ' | grep "/' . $user_data_main['name'] . '/" | grep "^' . $logsafe . ':" | sed s/:.*// | tr "\\n" " "';
		$resans = $this->ssh($comm);

		if (0 < count($resans)) {
			$out['err'] = -1;
			$out['mess'] = $lang['ftp_error_add_user_exist'];
			return $out;
		}

		if ($ftp_user_readonly != 1) {
			$comm = 'getent passwd | grep "^' . $user_data_main['name'] . ':" | cut -d ":" -f3 | tr "\\n" " "';
			$ownerid = intval(implode($this->ssh($comm)));
			$comm = 'getent passwd | grep "^' . $user_data_main['name'] . ':" | cut -d ":" -f4 | tr "\\n" " "';
			$ownergroupid = intval(implode($this->ssh($comm)));
			$comm = '(echo \'' . $passsafe . '\'; echo \'' . $passsafe . '\';) | /usr/local/bin/ftpasswd --stdin --file=' . $ftp_pathfileuser . ' --passwd --name=' . $logsafe . ' --home=' . $user_data_main['rootdir'] . '/' . $homedir . ' --shell=/bin/false --uid=' . $ownerid . ' --gid=' . $ownergroupid;
			$this->ssh($comm);
		}
		else {
			$comm = 'getent passwd | grep "^ftpuser-read:" | cut -d ":" -f3 | tr "\\n" " "';
			$ownerid = intval(implode($this->ssh($comm)));
			$comm = 'getent passwd | grep "^ftpuser-read:" | cut -d ":" -f4 | tr "\\n" " "';
			$ownergroupid = intval(implode($this->ssh($comm)));
			$comm = '(echo \'' . $passsafe . '\'; echo \'' . $passsafe . '\';) | /usr/local/bin/ftpasswd --stdin --file=' . $ftp_pathfileuser . ' --passwd --name=' . $logsafe . ' --home=' . $user_data_main['rootdir'] . '/' . $homedir . ' --shell=/bin/false --uid=' . $ownerid . ' --gid=' . $ownergroupid;
			$this->ssh($comm);
		}

		$comm = 'mkdir ' . $user_data_main['rootdir'] . '/' . $homedir;
		$this->ssh($comm);
		if ((0 < strlen($workspace)) || (1 < strlen($homedir))) {
			$comm = 'chown ' . $user_data_main['name'] . '.' . $user_data_main['name'] . ' ' . $user_data_main['rootdir'] . '/' . $homedir;
			$this->ssh($comm);
		}

		$comm = 'chmod 600 ' . $ftp_pathfileuser;
		$this->ssh($comm);
		$mass = array('QuotaLimitTable');
		$del = ' ';
		$comm = array('#');
		$dir_user_file_quota = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
		$dir_user_file_quota = $dir_user_file_quota['QuotaLimitTable'];
		$dir_user_file_quota = str_replace('file:', '', $dir_user_file_quota);
		$mass = array('QuotaTallyTable');
		$del = ' ';
		$comm = array('#');
		$dir_user_file_quota_tally = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
		$dir_user_file_quota_tally = $dir_user_file_quota_tally['QuotaTallyTable'];
		$dir_user_file_quota_tally = str_replace('file:', '', $dir_user_file_quota_tally);

		if (!is_file($dir_user_file_quota)) {
			$comm1 = '/usr/local/bin/ftpquota --create-table --type=limit --table-path=' . $dir_user_file_quota;
			$comm2 = '/usr/local/bin/ftpquota --create-table --type=tally --table-path=' . $dir_user_file_quota_tally;
			$res = implode($this->ssh($comm1));
			$res = implode($this->ssh($comm2));
		}

		if ($ftp_user_quota != 0) {
			$comm1 = '/usr/local/bin/ftpquota --update-record --type=limit --name=' . $logsafe . ' --quota-type=user --bytes-upload=' . $ftp_user_quota . ' --units=Mb --table-path=' . $dir_user_file_quota;
			$res = implode($this->ssh($comm1));

			if (0 < strpos($res, 'no match found')) {
				$comm1 = '/usr/local/bin/ftpquota --add-record --type=limit --name=' . $logsafe . ' --quota-type=user --bytes-upload=' . $ftp_user_quota . ' --units=Mb --table-path=' . $dir_user_file_quota;
				$res = implode($this->ssh($comm1));
			}
		}
		else {
			$comm1 = '/usr/local/bin/ftpquota --update-record --type=limit --name=' . $logsafe . ' --quota-type=user --bytes-upload=-1 --units=Mb --table-path=' . $dir_user_file_quota;
			$res = implode($this->ssh($comm1));

			if (0 < strpos($res, 'no match found')) {
				$comm1 = '/usr/local/bin/ftpquota --add-record --type=limit --name=' . $logsafe . ' --quota-type=user --bytes-upload=-1 --units=Mb --table-path=' . $dir_user_file_quota;
				$res = implode($this->ssh($comm1));
			}
		}

		$out['err'] = 0;
		$out['mess'] = $lang['ftp_user_add_ok'];
		return $out;
	}

	public function ftp_user_add($user_data_main, $serialdata)
	{
		global $lang;

		if (!$this->check_value('user', $user_data_main['name'])) {
			$res['error'] = 2;
			$res['message'] = $lang['ftp_searchftpacc'];
			return $res;
		}

		$user_info = $this->config_read($GLOBALS['USERS_PATH'] . '/' . $user_data_main['name']);
		$all_ftps_count = count($this->ftp_get_anyftp_listfulluser($user_data_main['name']));

		if ($user_info['ftp_accounts'] != 0) {
			if ($user_info['ftp_accounts'] <= $all_ftps_count) {
				$outm['error'] = 301;
				$outm['message'] = $lang['ftp_adduser_failed_overlimit'] . $user_info['ftp_accounts'];
				return $outm;
			}
		}

		$res = json_decode($serialdata, true);

		if (!$this->check_value('string', $res['login'])) {
			$out['error'] = 3;
			$out['message'] = $lang['ftp_user_login_new_wrong'];
			$out['mess'] = $lang['ftp_user_login_new_wrong'];
			return $out;
		}

		if ($res['ftp_user_quota']) {
			if (!$this->check_value('number', $res['ftp_user_quota'])) {
				$out['error'] = 4;
				$out['message'] = $lang['ftp_user_quota_wrong'];
				$out['mess'] = $lang['ftp_user_quota_wrong'];
				return $out;
			}
		}

		if ($res['ftp_user_dir']) {
			if (!$this->check_value('dir', $res['ftp_user_dir'])) {
				$out['error'] = 5;
				$out['message'] = $lang['ftp_user_userdir_wrong'];
				$out['mess'] = $lang['ftp_user_userdir_wrong'];
				return $out;
			}
		}

		$out = $this->config_read($GLOBALS['USERS_PATH'] . $user_data_main['name']);

		if ($out['suspended_ftp'] == 1) {
			$res2['error'] = 1;
			$res2['message'] = $lang['ftp_suspended_acc'];
			$res2['status'] = 'done';
			return $res2;
		}

		if (!$this->typeftp || ($this->typeftp == 'noftp')) {
			$this->getservicename();
		}

		switch ($this->typeftp) {
		case 'vsftpd':
			break;

		case 'pure-ftpd':
			$res = $this->ftp_useradd_pureftpd($user_data_main, $serialdata);
			break;

		case 'proftpd':
			$res = $this->ftp_useradd_proftpd($user_data_main, $serialdata);
			break;
		}

		$res['mess'] = $lang['ftp_noftpins'];
		break;

		switch ($res['err']) {
		case 0:
			$this->ftp_write_user_file_config($user_data_main, $serialdata);
			$res2['raw_info'] = '1';
			$res2['status'] = 'done';
			$res2['error'] = 0;
			$res2['mess'] = $lang['ftp_newuser_add_success'];
			break;

		case -2:
			$res2['raw_info'] = '-2';
			$res2['error'] = -2;
			$res2['mess'] = $lang['ftp_noftpins'];
			$res2['status'] = 'done';
			break;

		case -3:
			$res2['raw_info'] = '-3';
			$res2['error'] = -3;
			$res2['status'] = 'done';
			$res2['mess'] = $lang['ftp_user_exist'];
			break;
		}

		$res2['error'] = -1;
		$res2['status'] = 'done';
		$res2['mess'] = $lang['ftp_user_exist'];
		break;

		$hostacc = new hostacc();
		$hostacc->hostacc_count_ftp_accounts($user_data_main['name'], 1);
		return $res2;
	}

	public function ftp_getuser_pureftpd($user_data_main, $serialdata, $rec_onpage)
	{
		$data = json_decode($serialdata);
		$curpage = intval($data->curpage);
		$search = $data->nameacc;
		$mass = array('PureDB');
		$del = ' ';
		$comm = array('#');
		$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PURE_FTPD_PATH'], $mass, $del, $comm);
		$ftp_pathfileuser = $ftp_pathfileuser['PureDB'];

		if (strlen($ftp_pathfileuser < 1)) {
			$ftp_pathfileuser = $GLOBALS['PureDB'];
		}

		$ftp_pathfileuser = str_replace('.pdb', '.passwd', $ftp_pathfileuser);
		if (($user_data_main['group_properties']['root'] == 'y') || ($user_data_main['group_properties']['users_management'] == 'y')) {
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep "/' . $user_data_main['name'] . '/" | sed s/:.*// | tr "\\n" " "';
		}
		else if (0 < strlen($search)) {
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep "/' . $user_data_main['name'] . '/" | grep "' . $search . '*:" | sed s/:.*// | tr "\\n" " "';
		}
		else {
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep "/' . $user_data_main['name'] . '/" | sed s/:.*// | tr "\\n" " "';
		}

		$subuserftp = explode(' ', implode($this->ssh($comm)));
		asort($subuserftp);
		$count_all = count($subuserftp);
		$count_pages = floor($count_all / $rec_onpage);

		if (($count_all % $rec_onpage) != 0) {
			++$count_pages;
		}

		$res['usersvar']['countall'] = $count_all;
		$res['usersvar']['countpages'] = $count_pages;
		$subuserftp = array_slice($subuserftp, $curpage * $rec_onpage, $rec_onpage);

		foreach ($subuserftp as $user) {
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep "^' . $user . ':" | cut -d ":" -f6 | tr "\\n" " "';
			$subuserftp_homedir[] = explode(' ', implode($this->ssh($comm)))[0];
		}

		$i = 0;

		while ($i < count($subuserftp_homedir)) {
			$subuserftp_homedir[$i] = str_replace('./', '', $subuserftp_homedir[$i]);
			++$i;
		}

		$i = 0;

		foreach ($subuserftp as $user) {
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep \'^' . $user . ':\' | cut -d \':\' -f13';
			$subuserftp_quota[$i] = implode($this->ssh($comm));
			$subuserftp_quota[$i] = round(intval($subuserftp_quota[$i]) / 1024 / 1024, 2);
			$comm = 'cat ' . $subuserftp_homedir[$i] . '.ftpquota | cut -d \' \' -f2';
			$used = $this->ssh($comm)[0];
			$subuserftp_used[$i] = round(intval($used) / 1024 / 1024, 2);
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep \'^' . $user . ':\' | cut -d \':\' -f4';
			$user_group = $this->ssh($comm)[0];
			$comm = 'cat /etc/passwd | grep \':' . $user_group . '::\' | cut -d \':\' -f1';
			$user_group_name = $this->ssh($comm)[0];

			if (stripos($user_group_name, 'ftpuser-read') !== false) {
				$subuserftp_user_group_readonly[$i] = 1;
			}
			else {
				$subuserftp_user_group_readonly[$i] = 0;
			}

			++$i;
		}

		$res['users']['subuserftplogin'] = $subuserftp;
		$res['users']['subuserftp_homedir'] = $subuserftp_homedir;
		$res['users']['subuserftp_quota'] = $subuserftp_quota;
		$res['users']['subuserftp_used'] = $subuserftp_used;
		$res['users']['subuserftp_readonly'] = $subuserftp_user_group_readonly;
		$res['status'] = 'done';
		$res['raw_info'] = 1;
		return $res;
	}

	public function ftp_getuser_proftpd($user_data_main, $serialdata, $rec_onpage)
	{
		$data = json_decode($serialdata);
		$curpage = intval($data->curpage);
		$search = $data->nameacc;
		$mass = array('AuthUserFile');
		$del = ' ';
		$comm = array('#');
		$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
		$ftp_pathfileuser = $ftp_pathfileuser['AuthUserFile'];
		if (($user_data_main['group_properties']['root'] == 'y') || ($user_data_main['group_properties']['users_management'] == 'y')) {
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep "' . $user_data_main['name'] . '" | grep "' . $search . '" | sed s/:.*// | tr "\\n" " "';
		}
		else if (1 < strlen($search)) {
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep "/' . $user_data_main['name'] . '[/,:]" | grep "' . $search . '" | sed s/:.*// | tr "\\n" " "';
		}
		else {
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep "/' . $user_data_main['name'] . '[/,:]" | sed s/:.*// | tr "\\n" " "';
		}

		$subuserftp = explode(' ', implode($this->ssh($comm)));
		asort($subuserftp);
		$count_all = count($subuserftp);
		$count_pages = floor($count_all / $rec_onpage);

		if (($count_all % $rec_onpage) != 0) {
			++$count_pages;
		}

		$res['usersvar']['countall'] = $count_all;
		$res['usersvar']['countpages'] = $count_pages;
		$subuserftp = array_slice($subuserftp, $curpage * $rec_onpage, $rec_onpage);
		$i = 0;

		foreach ($subuserftp as $user) {
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep "^' . $user . ':" | cut -d ":" -f6 | tr "\\n" " "';
			$subuserftp_homedir[] = explode(' ', implode($this->ssh($comm)))[0];
		}

		$i = 0;

		while ($i < count($subuserftp_homedir)) {
			$subuserftp_homedir[$i] = str_replace('./', '', $subuserftp_homedir[$i]);
			++$i;
		}

		$mass = array('QuotaLimitTable');
		$del = ' ';
		$comm = array('#');
		$dir_user_file_quota = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
		$dir_user_file_quota = $dir_user_file_quota['QuotaLimitTable'];
		$dir_user_file_quota = str_replace('file:', '', $dir_user_file_quota);

		if (is_file($dir_user_file_quota)) {
			$comm_quota = '/usr/local/bin/ftpquota --show-records --type=limit --table-path=' . $dir_user_file_quota . ' | grep "Uploaded bytes';

			foreach ($subuserftp as $user) {
				$comm_quota .= '\\|' . $user . '$';
				++$i;
			}

			$comm_quota .= '" | cut -d ":" -f2';
			$all_user_quota = $this->ssh($comm_quota);
			$j = 0;

			foreach ($subuserftp as $user) {
				$subuserftp_quota[$j] = 0;
				$i = 0;

				while ($i < count($all_user_quota)) {
					if ($user == trim($all_user_quota[$i])) {
						$subuserftp_quota[$j] = round(intval($all_user_quota[$i + 1]) / 1024 / 1024, 2);
						break;
					}

					++$i;
				}

				++$j;
			}
		}

		$mass = array('QuotaTallyTable');
		$del = ' ';
		$comm = array('#');
		$dir_user_file_quota = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
		$dir_user_file_quota = $dir_user_file_quota['QuotaTallyTable'];
		$dir_user_file_quota = str_replace('file:', '', $dir_user_file_quota);

		if (is_file($dir_user_file_quota)) {
			$comm_quota = '/usr/local/bin/ftpquota --show-records --type=tally --table-path=' . $dir_user_file_quota . ' | grep "Uploaded bytes';

			foreach ($subuserftp as $user) {
				$comm_quota .= '\\|' . $user . '$';
				++$i;
			}

			$comm_quota .= '" | cut -d ":" -f2';
			$all_user_quota = $this->ssh($comm_quota);
			$j = 0;

			foreach ($subuserftp as $user) {
				$subuserftp_used[$j] = 0;
				$i = 0;

				while ($i < count($all_user_quota)) {
					if ($user == trim($all_user_quota[$i])) {
						$subuserftp_used[$j] = round(intval($all_user_quota[$i + 1]) / 1024 / 1024, 2);
						break;
					}

					++$i;
				}

				++$j;
			}
		}

		foreach ($subuserftp as $user) {
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep "^' . $user . ':" | cut -d ":" -f4';
			$user_group = $this->ssh($comm)[0];
			$comm = 'cat /etc/passwd | grep \':' . $user_group . '::\' | cut -d \':\' -f1';
			$user_group_name = $this->ssh($comm)[0];

			if (stripos($user_group_name, 'ftpuser-read') !== false) {
				$subuserftp_user_group_readonly[] = 1;
			}
			else {
				$subuserftp_user_group_readonly[] = 0;
			}
		}

		$res['users']['subuserftplogin'] = $subuserftp;
		$res['users']['subuserftp_homedir'] = $subuserftp_homedir;
		$res['users']['subuserftp_quota'] = $subuserftp_quota;
		$res['users']['subuserftp_used'] = $subuserftp_used;
		$res['users']['subuserftp_readonly'] = $subuserftp_user_group_readonly;
		$res['status'] = 'done';
		$res['raw_info'] = 1;
		return $res;
	}

	public function ftp_user_listsub($user_data_main, $serialdata, $full_list = NULL)
	{
		global $lang;

		if (!$this->check_value('user', $user_data_main['name'])) {
			$res['error'] = 2;
			$res['message'] = $lang['ftp_searchftpacc'];
			return $res;
		}
		if ($full_list) {
			if (!$this->check_value('number', $full_list)) {
				$res['error'] = 2;
				$res['message'] = $lang['server_control_error_user'];
				return $res;
			}
		}

		if (($user_data_main['group_properties']['root'] != 'y') && ($user_data_main['group_properties']['users_management'] != 'y')) {
			if (!isset($user_data_main['name'])) {
				$res['error'] = 1;
				$res['mess'] = 'user isp incorrect';
				return $res;
			}

			if ($user_data_main['name'] == '') {
				$res['error'] = 1;
				$res['mess'] = 'user isp incorrect';
				return $res;
			}
		}

		if (!isset($_COOKIE['ftpacc_onpage'])) {
			$onpage = $this->config_read('/etc/brainy/data/ftp/style.conf');

			if (!isset($onpage['record_show'])) {
				$onpage = array();
				$onpage['record_show'] = 10;
			}

			setcookie('ftpacc_onpage', intval($onpage['record_show']), time() + 360000);
			$rec_onpage = intval($onpage['record_show']);
		}
		else {
			$rec_onpage = intval($_COOKIE['ftpacc_onpage']);
		}

		if ($rec_onpage == 0) {
			$rec_onpage = 10;
		}

		if ($full_list == 1) {
			$rec_onpage = 999999;
		}

		if (!$this->typeftp || ($this->typeftp == 'noftp')) {
			$this->getservicename();

			if (!$this->typeftp) {
				$res['error'] = 2;
				$res['mess'] = 'No detect ftp server';
				$res['error_info'] = 'error: function ftp_user_listsub(); no detect ftp';
				return $res;
			}
		}

		switch ($this->typeftp) {
		case 'vsftpd':
			break;

		case 'pure-ftpd':
			$res = $this->ftp_getuser_pureftpd($user_data_main, $serialdata, $rec_onpage);
			break;

		case 'proftpd':
			$res = $this->ftp_getuser_proftpd($user_data_main, $serialdata, $rec_onpage);
			break;
		}

		$res['onpageview'] = $rec_onpage;
		$res['error'] = 0;
		return $res;
	}

	public function ftp_user_set_quota_pureftpd($user_data_main, $serialdata)
	{
		global $lang;
		$decode = json_decode($serialdata, true);

		if (!$this->check_value('number', $decode['quotasize'])) {
			$res['error'] = 2;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
		}

		if (!$this->check_value('string', $decode['username'])) {
			$res['error'] = 3;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
		}

		$res_user_sub_all = $this->ftp_user_listsub($user_data_main, $serialdata, 1);

		if ($res_user_sub_all['error'] != 0) {
			$res_user_sub_all['raw_info'] = -5;
			$res_user_sub_all['error_info'] = 'error: function ftp_user_set_quota_pureftpd() -> function ftp_user_listsub(); user not found';
			return $res_user_sub_all;
		}

		$decode = json_decode($serialdata, true);
		$username_ch = htmlspecialchars($decode['username'], ENT_QUOTES);
		$quotasize = intval($decode['quotasize']);
		$action = intval($decode['action']);
		$q = 0;
		$mainUserOwner = '';

		if (($user_data_main['group_properties']['root'] != 'y') && ($user_data_main['group_properties']['users_management'] != 'y')) {
			foreach ($res_user_sub_all['users']['subuserftplogin'] as $useritem) {
				$q = 1;
				break;
			}

			$mainUserOwner = $user_data_main['username'];
		}
		else {
			$q = 1;
			$expD = explode('_', $username_ch);
			$mainUserOwner = $expD[0];
		}

		$mass = array('PureDB');
		$del = ' ';
		$comm = array('#');
		$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PURE_FTPD_PATH'], $mass, $del, $comm);
		$ftp_pathfileuser = $ftp_pathfileuser['PureDB'];

		if (strlen($ftp_pathfileuser < 1)) {
			$ftp_pathfileuser = $GLOBALS['PureDB'];
		}

		$ftp_pathfileuser = str_replace('.pdb', '.passwd', $ftp_pathfileuser);

		if ($q == 1) {
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep "^' . $username_ch . ':" | cut -d ":" -f6 | tr "\\n" " "';
			$subuserftp_homedir = explode(' ', implode($this->ssh($comm)));
			$i = 0;

			while ($i < count($subuserftp_homedir)) {
				$subuserftp_homedir[$i] = str_replace('./', '', $subuserftp_homedir[$i]);
				++$i;
			}

			$userparse4admin = $mainUserOwner;

			if ($action == 'changequotamb') {
				if ($quotasize != 0) {
					$comm = 'pure-pw usermod "' . $username_ch . '" -f ' . $ftp_pathfileuser . ' -N ' . $quotasize . ' -m';
				}
				else {
					$comm = 'pure-pw usermod "' . $username_ch . '" -f ' . $ftp_pathfileuser . ' -N "" -m';
				}

				$this->ssh($comm);
			}

			if ($action == 'changequotafilecount') {
				if ($quotasize != 0) {
					$comm = 'pure-pw usermod "' . $username_ch . '" -f ' . $ftp_pathfileuser . ' -n ' . $quotasize . ' -m';
				}
				else {
					$comm = 'pure-pw usermod "' . $username_ch . '" -f ' . $ftp_pathfileuser . ' -n "" -m';
				}

				$this->ssh($comm);
			}

			$this->ftp_kill_userproc($userparse4admin, $username_ch);
			global $lang;
			$res['mainuser'] = $userparse4admin;
			$res['raw_info'] = 1;
			$res['status'] = 'done';
			$res['message'] = $lang['ftp_quota_change_ok'];
			$res['error'] = 0;
			return $res;
		}

		$res['raw_info'] = -1;
		$res['status'] = 'done';
		$res['error'] = 2;
		$res['error_info'] = 'error: function ftp_user_set_quota_pureftpd() -> function ftp_user_listsub(): user not found';
		return $res;
	}

	public function ftp_user_set_quota_proftpd($user_data_main, $serialdata)
	{
		global $lang;
		$decode = json_decode($serialdata, true);

		if (!$this->check_value('number', $decode['quotasize'])) {
			$res['error'] = 2;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
		}

		if (!$this->check_value('string', $decode['username'])) {
			$res['error'] = 3;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
		}

		$res_user_sub_all = $this->ftp_user_listsub($user_data_main, $serialdata, 1);

		if ($res_user_sub_all['error'] != 0) {
			$res_user_sub_all['raw_info'] = -5;
			$res_user_sub_all['error_info'] = 'error: function ftp_user_set_quota_proftpd() -> function ftp_user_listsub(); user not found';
			return $res_user_sub_all;
		}

		$decode = json_decode($serialdata, true);
		$logsafe = htmlspecialchars($decode['username'], ENT_QUOTES);
		$ftp_user_quota = intval($decode['quotasize']);
		$action = intval($decode['action']);
		$q = 0;
		$mainUserOwner = '';

		if (($user_data_main['group_properties']['root'] != 'y') && ($user_data_main['group_properties']['users_management'] != 'y')) {
			foreach ($res_user_sub_all['users']['subuserftplogin'] as $useritem) {
				$q = 1;
				break;
			}

			$mainUserOwner = $user_data_main['username'];
		}
		else {
			$q = 1;
			$expD = explode('_', $logsafe);
			$mainUserOwner = $expD[0];
		}

		if ($q == 1) {
			$mass = array('AuthUserFile');
			$del = ' ';
			$comm = array('#');
			$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
			$ftp_pathfileuser = $ftp_pathfileuser['AuthUserFile'];
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep "^' . $logsafe . ':" | cut -d ":" -f6 | tr "\\n" " "';
			$subuserftp_homedir = explode(' ', implode($this->ssh($comm)));
			$i = 0;

			while ($i < count($subuserftp_homedir)) {
				$subuserftp_homedir[$i] = str_replace('./', '', $subuserftp_homedir[$i]);
				++$i;
			}

			$userparse4admin = $mainUserOwner;
			$mass = array('QuotaLimitTable');
			$del = ' ';
			$comm = array('#');
			$dir_user_file_quota = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
			$dir_user_file_quota = $dir_user_file_quota['QuotaLimitTable'];
			$dir_user_file_quota = str_replace('file:', '', $dir_user_file_quota);
			$mass = array('QuotaTallyTable');
			$del = ' ';
			$comm = array('#');
			$dir_user_file_quota_tally = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
			$dir_user_file_quota_tally = $dir_user_file_quota_tally['QuotaTallyTable'];
			$dir_user_file_quota_tally = str_replace('file:', '', $dir_user_file_quota_tally);

			if (!is_file($dir_user_file_quota)) {
				$comm1 = '/usr/local/bin/ftpquota --create-table --type=limit --table-path=' . $dir_user_file_quota;
				$comm2 = '/usr/local/bin/ftpquota --create-table --type=tally --table-path=' . $dir_user_file_quota_tally;
				$res = implode($this->ssh($comm1));
				$res = implode($this->ssh($comm2));
			}

			if ($ftp_user_quota != 0) {
				$comm1 = '/usr/local/bin/ftpquota --update-record --type=limit --name=' . $logsafe . ' --quota-type=user --bytes-upload=' . $ftp_user_quota . ' --units=Mb --table-path=' . $dir_user_file_quota;
				$res = implode($this->ssh($comm1));

				if (0 < strpos($res, 'no match found')) {
					$comm1 = '/usr/local/bin/ftpquota --add-record --type=limit --name=' . $logsafe . ' --quota-type=user --bytes-upload=' . $ftp_user_quota . ' --units=Mb --table-path=' . $dir_user_file_quota;
					$res = implode($this->ssh($comm1));
				}
			}
			else {
				$comm1 = '/usr/local/bin/ftpquota --update-record --type=limit --name=' . $logsafe . ' --quota-type=user --bytes-upload=-1 --units=Mb --table-path=' . $dir_user_file_quota;
				$res = implode($this->ssh($comm1));

				if (0 < strpos($res, 'no match found')) {
					$comm1 = '/usr/local/bin/ftpquota --add-record --type=limit --name=' . $logsafe . ' --quota-type=user --bytes-upload=-1 --units=Mb --table-path=' . $dir_user_file_quota;
					$res = implode($this->ssh($comm1));
				}
			}

			$mass = array('ScoreboardFile');
			$del = ' ';
			$comm = array('#');
			$scoreboardFile = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
			$scoreboardFile = $scoreboardFile['ScoreboardFile'];
			$this->ftp_kill_userproc($userparse4admin, $logsafe);
			global $lang;
			$res['mainuser'] = $userparse4admin;
			$res['raw_info'] = 1;
			$res['status'] = 'done';
			$res['message'] = $lang['ftp_quota_change_ok'];
			$res['error'] = 0;
			return $res;
		}

		$res['raw_info'] = -1;
		$res['status'] = 'done';
		$res['error'] = 2;
		$res['error_info'] = 'error: function ftp_user_set_quota_proftpd() -> function ftp_user_listsub(): user not found';
		return $res;
	}

	public function ftp_user_set_quota($user_data_main, $serialdata)
	{
		global $lang;

		if (!$this->check_value('user', $user_data_main['name'])) {
			$res['error'] = 2;
			$res['message'] = $lang['ftp_searchftpacc'];
			return $res;
		}

		$decode = json_decode($serialdata, true);

		if (!$this->check_value('number', $decode['quotasize'])) {
			$res['error'] = 3;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
		}

		$out = $this->config_read($GLOBALS['USERS_PATH'] . $user_data_main['name']);

		if ($out['suspended_ftp'] == 1) {
			$res2['error'] = 1;
			$res2['message'] = $lang['ftp_suspended_acc'];
			$res2['status'] = 'done';
			return $res2;
		}

		if (!$this->typeftp || ($this->typeftp == 'noftp')) {
			$this->getservicename();

			if (!$this->typeftp) {
				$res['error'] = 2;
				$res['raw_info'] = -2;
				$res['mess'] = 'No detect ftp server';
				$res['error_info'] = 'error: function ftp_user_set_quota(); no detect ftp server';
				return $res;
			}
		}

		switch ($this->typeftp) {
		case 'vsftpd':
			break;

		case 'pure-ftpd':
			$res = $this->ftp_user_set_quota_pureftpd($user_data_main, $serialdata);
			break;

		case 'proftpd':
			$res = $this->ftp_user_set_quota_proftpd($user_data_main, $serialdata);
			break;
		}

		if ($res['error'] != 0) {
			return $res;
		}

		if (($user_data_main['group_properties']['root'] != 'y') && ($user_data_main['group_properties']['users_management'] != 'y')) {
			$decode = json_decode($serialdata, true);
			$mainuser = $user_data_main['name'];
			$subuser = $decode['username'];
			$field = 'quota';
			$value = intval($decode['quotasize']);
			$this->ftp_update_user_file_config($field, $value, $subuser, $mainuser);
		}
		else {
			$userparse4admin = $res['mainuser'];
			$decode = json_decode($serialdata, true);
			$mainuser = $userparse4admin;
			$subuser = $decode['username'];
			$field = 'quota';
			$value = intval($decode['quotasize']);
			$this->ftp_update_user_file_config($field, $value, $subuser, $mainuser);
		}

		return $res;
	}

	public function ftp_user_set_quota_countfile($user_data_main, $serialdata)
	{
		if (!$this->typeftp || ($this->typeftp == 'noftp')) {
			$this->getservicename();
		}

		switch ($this->typeftp) {
		case 'vsftpd':
			break;

		case 'pure-ftpd':
			$res = $this->ftp_user_set_quota_pureftpd($user_data_main, $serialdata);
			break;

		case 'proftpd':
			break;
		}

		return $res;
	}

	public function ftp_user_changepass_pureftpd($user_data_main, $serialdata)
	{
		global $lang;
		$decode = json_decode($serialdata, true);
		$newpass = $decode['newpass'];

		if (!$this->check_value('string', $decode['username'])) {
			$res['error'] = 3;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
		}

		$newpass = $this->strip_quotes_cmd($this->escape_slash_echoe($newpass));
		$res_user_sub_all = $this->ftp_user_listsub($user_data_main, $serialdata, 1);

		if ($res_user_sub_all['error'] != 0) {
			$res_user_sub_all['raw_info'] = -5;
			$res_user_sub_all['error_info'] = 'error: function ftp_user_changepass_pureftpd() -> function ftp_user_listsub(); user not found';
			return $res_user_sub_all;
		}

		$decode = json_decode($serialdata, true);
		$username_ch = $decode['username'];
		$q = 0;
		$mainUserOwner = '';

		if (($user_data_main['group_properties']['root'] != 'y') && ($user_data_main['group_properties']['users_management'] != 'y')) {
			foreach ($res_user_sub_all['users']['subuserftplogin'] as $useritem) {
				$q = 1;
				break;
			}

			$mainUserOwner = $user_data_main['username'];
		}
		else {
			$q = 1;
			$expD = explode('_', $username_ch);
			$mainUserOwner = $expD[0];
		}

		$mass = array('PureDB');
		$del = ' ';
		$comm = array('#');
		$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PURE_FTPD_PATH'], $mass, $del, $comm);
		$ftp_pathfileuser = $ftp_pathfileuser['PureDB'];

		if (strlen($ftp_pathfileuser < 1)) {
			$ftp_pathfileuser = $GLOBALS['PureDB'];
		}

		$ftp_pathfileuser = str_replace('.pdb', '.passwd', $ftp_pathfileuser);
		$comm = 'cat ' . $ftp_pathfileuser . ' | grep "^' . $username_ch . ':" | cut -d ":" -f6 | tr "\\n" " "';
		$subuserftp_homedir = explode(' ', implode($this->ssh($comm)));
		$i = 0;

		while ($i < count($subuserftp_homedir)) {
			$subuserftp_homedir[$i] = str_replace('./', '', $subuserftp_homedir[$i]);
			++$i;
		}

		$userparse4admin = $mainUserOwner;

		if ($q == 1) {
			$comm = '(echo \'' . $newpass . '\'; echo \'' . $newpass . '\';) | pure-pw passwd \'' . $username_ch . '\' -f ' . $ftp_pathfileuser . ' -m';
			$this->ssh($comm);
			$this->ftp_kill_userproc($userparse4admin, $username_ch);
			global $lang;
			$res['mainuser'] = $userparse4admin;
			$res['raw_info'] = 1;
			$res['status'] = 'done';
			$res['message'] = $lang['ftp_pass_change_ok'];
			return $res;
		}

		$res['raw_info'] = -1;
		$res['status'] = 'done';
		return $res;
	}

	public function ftp_user_changepass_proftpd($user_data_main, $serialdata)
	{
		global $lang;
		$decode = json_decode($serialdata, true);
		$newpass = $this->strip_quotes_cmd($this->escape_slash_echoe($decode['newpass']));

		if (!$this->check_value('string', $decode['username'])) {
			$res['error'] = 3;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
		}

		$res_user_sub_all = $this->ftp_user_listsub($user_data_main, $serialdata, 1);

		if ($res_user_sub_all['error'] != 0) {
			$res_user_sub_all['raw_info'] = -5;
			$res_user_sub_all['error_info'] = 'error: function ftp_user_changepass_proftpd() -> function ftp_user_listsub(); user not found';
			return $res_user_sub_all;
		}

		$decode = json_decode($serialdata, true);
		$username_ch = $decode['username'];
		$q = 0;
		$mainUserOwner = '';

		if (($user_data_main['group_properties']['root'] != 'y') && ($user_data_main['group_properties']['users_management'] != 'y')) {
			foreach ($res_user_sub_all['users']['subuserftplogin'] as $useritem) {
				$q = 1;
				break;
			}

			$mainUserOwner = $user_data_main['username'];
		}
		else {
			$q = 1;
			$expD = explode('_', $username_ch);
			$mainUserOwner = $expD[0];
		}

		$mass = array('AuthUserFile');
		$del = ' ';
		$comm = array('#');
		$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
		$ftp_pathfileuser = $ftp_pathfileuser['AuthUserFile'];
		$comm = 'cat ' . $ftp_pathfileuser . ' | grep "^' . $username_ch . ':" | cut -d ":" -f6 | tr "\\n" " "';
		$subuserftp_homedir = explode(' ', implode($this->ssh($comm)));
		$i = 0;

		while ($i < count($subuserftp_homedir)) {
			$subuserftp_homedir[$i] = str_replace('./', '', $subuserftp_homedir[$i]);
			++$i;
		}

		$userparse4admin = $mainUserOwner;

		if ($q == 1) {
			$mass = array('ScoreboardFile');
			$del = ' ';
			$comm = array('#');
			$scoreboardFile = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
			$scoreboardFile = $scoreboardFile['ScoreboardFile'];
			$this->ftp_kill_userproc($userparse4admin, $username_ch);
			$comm = '(echo \'' . $newpass . '\'; echo \'' . $newpass . '\';) | /usr/local/bin/ftpasswd --stdin --file=' . $ftp_pathfileuser . ' --passwd --name=\'' . $username_ch . '\' --change-password';
			$this->ssh($comm);
			$comm = 'chmod 600 ' . $ftp_pathfileuser;
			$this->ssh($comm);
			global $lang;
			$res['mainuser'] = $userparse4admin;
			$res['raw_info'] = 1;
			$res['status'] = 'done';
			$res['message'] = $lang['ftp_pass_change_ok'];
			return $res;
		}

		$res['raw_info'] = -1;
		$res['status'] = 'done';
		return $res;
	}

	public function ftp_user_changepass($user_data_main, $serialdata)
	{
		global $lang;
		$decode = json_decode($serialdata, true);

		if (!$this->check_value('user', $user_data_main['name'])) {
			$res['error'] = 2;
			$res['message'] = $lang['ftp_searchftpacc'];
			return $res;
		}

		if (!$this->check_value('string', $decode['username'])) {
			$res['error'] = 3;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
		}

		if (!$this->typeftp || ($this->typeftp == 'noftp')) {
			$this->getservicename();
		}

		$out = $this->config_read($GLOBALS['USERS_PATH'] . $user_data_main['name']);

		if ($out['suspended_ftp'] == 1) {
			$res2['error'] = 1;
			$res2['message'] = $lang['ftp_suspended_acc'];
			$res2['status'] = 'done';
			return $res2;
		}

		switch ($this->typeftp) {
		case 'vsftpd':
			break;

		case 'pure-ftpd':
			$res = $this->ftp_user_changepass_pureftpd($user_data_main, $serialdata);
			$comm = 'service pure-ftpd restart';
			$this->ssh($comm);
			break;

		case 'proftpd':
			$res = $this->ftp_user_changepass_proftpd($user_data_main, $serialdata);
			$comm = 'service proftpd restart';
			$this->ssh($comm);
			break;
		}

		$res['raw_info'] = -2;
		$res['mess'] = $lang['ftp_noftpins'];
		if (($user_data_main['group_properties']['root'] != 'y') && ($user_data_main['group_properties']['users_management'] != 'y')) {
			$decode = json_decode($serialdata, true);
			$mainuser = $user_data_main['name'];
			$subuser = $decode['username'];
			$field = 'pass';
			$value = $decode['newpass'];
			$this->ftp_update_user_file_config($field, $value, $subuser, $mainuser);
		}
		else {
			$userparse4admin = $res['mainuser'];
			$decode = json_decode($serialdata, true);
			$mainuser = $userparse4admin;
			$subuser = $decode['username'];
			$field = 'pass';
			$value = $decode['newpass'];
			$this->ftp_update_user_file_config($field, $value, $subuser, $mainuser);
		}

		return $res;
	}

	public function ftp_user_delete_pureftpd($user_data_main, $serialdata)
	{
		$decode = json_decode($serialdata, true);
		$res_user_sub_all = $this->ftp_user_listsub($user_data_main, $serialdata, 1);

		if ($res_user_sub_all['error'] != 0) {
			$res_user_sub_all['raw_info'] = -5;
			$res_user_sub_all['error_info'] = 'error: function ftp_user_delete_pureftpd() -> function ftp_user_listsub(); user not found';
			return $res_user_sub_all;
		}

		$username_ch = htmlspecialchars($decode['username'], ENT_QUOTES);
		$deluserdir = intval($decode['deluserdir']);
		if (!isset($username_ch) || ($username_ch == '')) {
			$res['raw_info'] = -2;
			$res['status'] = 'done';
			return $res;
		}

		$q = 0;
		$mainUserOwner = '';

		if (($user_data_main['group_properties']['root'] != 'y') && ($user_data_main['group_properties']['users_management'] != 'y')) {
			foreach ($res_user_sub_all['users']['subuserftplogin'] as $useritem) {
				$q = 1;
				break;
			}

			$mainUserOwner = $user_data_main['username'];
		}
		else {
			$q = 1;
			$expD = explode('_', $username_ch);
			$mainUserOwner = $expD[0];
		}

		$mass = array('PureDB');
		$del = ' ';
		$comm = array('#');
		$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PURE_FTPD_PATH'], $mass, $del, $comm);
		$ftp_pathfileuser = $ftp_pathfileuser['PureDB'];

		if (strlen($ftp_pathfileuser < 1)) {
			$ftp_pathfileuser = $GLOBALS['PureDB'];
		}

		$ftp_pathfileuser = str_replace('.pdb', '.passwd', $ftp_pathfileuser);

		if ($q == 1) {
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep "^' . $username_ch . ':" | cut -d ":" -f6 | tr "\\n" " "';
			$subuserftp_homedir = explode(' ', implode($this->ssh($comm)));
			$i = 0;

			while ($i < count($subuserftp_homedir)) {
				$subuserftp_homedir[$i] = str_replace('./', '', $subuserftp_homedir[$i]);
				++$i;
			}

			$userparse4admin = $mainUserOwner;
			$user_homedir = $subuserftp_homedir[0];

			if ($deluserdir == 1) {
				if (3 < strlen($user_homedir)) {
					$comm = 'rm -rf ' . $user_homedir;
					$this->ssh($comm);
				}
			}

			$comm = 'pure-pw userdel "' . $username_ch . '" -f ' . $ftp_pathfileuser . ' -m';
			$this->ssh($comm);
			$comm = 'pure-ftpwho -s | grep "^' . $username_ch . '" | cut -d "|" -f1 | xargs kill';
			$this->ssh($comm);
			$res['mainuser'] = $userparse4admin;
			$res['raw_info'] = 1;
			$res['status'] = 'done';
			return $res;
		}

		$res['raw_info'] = -1;
		$res['status'] = 'done';
		return $res;
	}

	public function ftp_user_delete_proftpd($user_data_main, $serialdata)
	{
		$res_user_sub_all = $this->ftp_user_listsub($user_data_main, $serialdata, 1);

		if ($res_user_sub_all['error'] != 0) {
			$res_user_sub_all['raw_info'] = -5;
			$res_user_sub_all['error_info'] = 'error: function ftp_user_delete_proftpd() -> function ftp_user_listsub(); user not found';
			return $res_user_sub_all;
		}

		$decode = json_decode($serialdata, true);
		$username_ch = htmlspecialchars($decode['username'], ENT_QUOTES);
		if (!isset($username_ch) || ($username_ch == '')) {
			$res['raw_info'] = -2;
			$res['status'] = 'done';
			return $res;
		}

		$deluserdir = intval($decode['deluserdir']);
		$q = 0;
		$mass = array('ScoreboardFile');
		$del = ' ';
		$comm = array('#');
		$scoreboardFile = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
		$scoreboardFile = $scoreboardFile['ScoreboardFile'];
		$comm = '/usr/local/bin/ftpwho -f ' . $scoreboardFile . ' | grep " ' . $username_ch . ' " | cut -d " " -f1 | xargs kill';
		$this->ssh($comm);
		$mainUserOwner = '';

		if (($user_data_main['group_properties']['root'] != 'y') && ($user_data_main['group_properties']['users_management'] != 'y')) {
			foreach ($res_user_sub_all['users']['subuserftplogin'] as $useritem) {
				$q = 1;
				break;
			}

			$mainUserOwner = $user_data_main['username'];
		}
		else {
			$q = 1;
			$expD = explode('_', $username_ch);
			$mainUserOwner = $expD[0];
		}

		$mass = array('AuthUserFile');
		$del = ' ';
		$comm = array('#');
		$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
		$ftp_pathfileuser = $ftp_pathfileuser['AuthUserFile'];

		if ($q == 1) {
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep "^' . $username_ch . ':" | cut -d ":" -f6 | tr "\\n" " "';
			$subuserftp_homedir = explode(' ', implode($this->ssh($comm)));
			$i = 0;

			while ($i < count($subuserftp_homedir)) {
				$subuserftp_homedir[$i] = str_replace('./', '', $subuserftp_homedir[$i]);
				++$i;
			}

			$userparse4admin = $mainUserOwner;
			$user_homedir = $subuserftp_homedir[0];

			if ($deluserdir == 1) {
				if (3 < strlen($user_homedir)) {
					$comm = 'rm -rf ' . $user_homedir;
					$this->ssh($comm);
				}
			}

			$comm = '/usr/local/bin/ftpasswd --file=' . $ftp_pathfileuser . ' --passwd --name=\'' . $username_ch . '\' --delete-user';
			$this->ssh($comm);
			$mass = array('ScoreboardFile');
			$del = ' ';
			$comm = array('#');
			$scoreboardFile = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
			$scoreboardFile = $scoreboardFile['ScoreboardFile'];
			$comm = '/usr/local/bin/ftpwho -f ' . $scoreboardFile . ' | grep " ' . $username_ch . ' " | cut -d " " -f1 | xargs kill';
			$this->ssh($comm);
			$res['mainuser'] = $userparse4admin;
			$res['raw_info'] = 1;
			$res['status'] = 'done';
			return $res;
		}

		$res['raw_info'] = -1;
		$res['status'] = 'done';
		return $res;
	}

	public function ftp_user_delete($user_data_main, $serialdata, $blockedftp = NULL)
	{
		global $lang;
		$decode = json_decode($serialdata, true);

		if (!$this->check_value('user', $user_data_main['name'])) {
			$res['error'] = 2;
			$res['message'] = $lang['ftp_searchftpacc'];
			return $res;
		}

		if (0 < strlen($decode['username'])) {
			if (!$this->check_value('string', $decode['username'])) {
				$res['error'] = 3;
				$res['message'] = $lang['server_control_error_user'];
				return $res;
			}
		}

		if (0 < strlen($decode['action'])) {
			if (!$this->check_value('string', $decode['action'])) {
				$res['error'] = 3;
				$res['message'] = $lang['server_control_error_user'];
				return $res;
			}
		}

		$out = $this->config_read($GLOBALS['USERS_PATH'] . $user_data_main['name']);

		if ($out['suspended_ftp'] == 1) {
			$res2['error'] = 1;
			$res2['message'] = $lang['ftp_suspended_acc'];
			$res2['status'] = 'done';
			return $res2;
		}

		if (!$this->typeftp || ($this->typeftp == 'noftp')) {
			$this->getservicename();
		}

		switch ($this->typeftp) {
		case 'vsftpd':
			break;

		case 'pure-ftpd':
			$res = $this->ftp_user_delete_pureftpd($user_data_main, $serialdata);
			break;

		case 'proftpd':
			$res = $this->ftp_user_delete_proftpd($user_data_main, $serialdata);
			break;
		}

		$decode = json_decode($serialdata, true);
		$username_ch = $decode['username'];
		$this->ftp_kill_userproc(NULL, $username_ch);

		if ($blockedftp == 1) {
			return $res;
		}

		if (($user_data_main['group_properties']['root'] != 'y') && ($user_data_main['group_properties']['users_management'] != 'y')) {
			$decode = json_decode($serialdata, true);
			$username_ch = $decode['username'];
			$this->remove_file_a($GLOBALS['USERS_PATH_FTP'] . $user_data_main['name'] . '_' . $username_ch);
		}
		else {
			$userparse4admin = $res['mainuser'];
			$decode = json_decode($serialdata, true);
			$username_ch = $decode['username'];
			$this->remove_file_a($GLOBALS['USERS_PATH_FTP'] . $userparse4admin . '_' . $username_ch);
		}

		$userm = explode('_', $username_ch);
		$hostacc = new hostacc();
		$hostacc->hostacc_count_ftp_accounts($userm[0], 1);
		return $res;
	}

	public function ftp_save_count_show_row_user($user_data, $serialdata)
	{
		global $lang;
		$decode = json_decode($serialdata, true);

		if (!$this->check_value('number', $decode['onpagecount'])) {
			$res['raw_info'] = -1;
			$res['raw_info'] = $lang['server_control_error_user'];
			return $res;
		}

		if (($user_data['group_properties']['root'] == 'y') || ($user_data['group_properties']['users_management'] == 'y')) {
			$arr = array('record_show' => intval($decode['onpagecount']));
			$this->set_data($arr, 'style.conf');
		}

		setcookie('ftpacc_onpage', intval($decode['onpagecount']), time() + 360000);
		$res['status'] = 'done';
		$res['raw_info'] = 1;
		return $res;
	}

	public function ftp_get_count_show_row_user()
	{
		$res = $this->load_vars_m('style.conf');
		$res['status'] = 'done';
		$res['raw_info'] = 1;
		return $res;
	}

	public function getquotaunix($user_data, $serialdata)
	{
		$decode = json_decode($serialdata, true);

		if (!$this->check_value('string', $decode['userun'])) {
			return false;
		}

		$comm = 'quota ' . $decode['userun'] . ' | sed -n 4p | tr -s \' \' | sed \'0,/ /{s/ //}\' | cut -d \' \' -f1';

		if (strlen($this->ssh($comm)[0]) < 2) {
			$comm = 'quota ' . $decode['userun'] . ' | sed -n 3p | tr -s \' \' | sed \'0,/ /{s/ //}\' | cut -d \' \' -f2';
		}

		$res['raw_info'] = round(intval($this->ssh($comm)[0]) / 1024, 2);
		$res['status'] = 'done';
		return $res;
	}

	public function getquotaunix_user($user)
	{
		$comm = 'quota ' . $user . ' | sed -n 4p | tr -s \' \' | sed \'0,/ /{s/ //}\' | cut -d \' \' -f1';

		if (strlen($this->ssh($comm)[0]) < 2) {
			$comm = 'quota ' . $user . ' | sed -n 3p | tr -s \' \' | sed \'0,/ /{s/ //}\' | cut -d \' \' -f2';
		}

		return round(intval($this->ssh($comm)[0]) / 1024, 2);
	}

	public function restore_ftps_acc($user_group, $user_name)
	{
		if ($user_name) {
			if (!$this->check_value('user', $user_name)) {
				return 0;
			}
		}

		require_once $GLOBALS['CLASSES_PATH'] . '/hostacc.php';
		$hostacc = new hostacc();
		$ftp = new ftp();
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user_name);
		$path_ftp_backs = $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_DIR_FTPS'];
		$out = $this->mass_rename($confUser['rootdir'] . '/' . $GLOBALS['BACKUP_DIR_FTPS'], $this->mask_username_replace . '_', $user_name . '_');
		$out = $this->ssh('ls -l ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_DIR_FTPS'] . '/* | awk \'{print $9}\'');

		foreach ($out as $value) {
			$this->ssh('replace \'' . $this->mask_username_replace . '\' \'' . $user_name . '\' -- ' . $value);
		}

		$res = scandir($path_ftp_backs);

		foreach ($res as $elem) {
			if (is_file($path_ftp_backs . '/' . $elem) && ($elem != '.') && ($elem != '..')) {
				$nameu = explode('_', $elem);
				if (($user_group == 'y') || ($user_name == $nameu[0])) {
					$ftplist_rest[] = $elem;
				}
			}
		}

		$ftp_type = $ftp->getservicename()['typeftp'];
		$ftp_imp_res = $ftp->ftp_import_all_subftp($ftp_type, $ftplist_rest);
		return 0;
	}

	public function ftp_import_subftp_oneuser($mainuser)
	{
		$getservname = $this->getservicename();
		$typeservftp = $getservname['typeftp'];
		$anslogin = array();
		$ansconfig = array();
		$ansconfigfile = array();
		$path_dump_ftps = $GLOBALS['USERS_PATH_FTP'];

		if ($handle = opendir($path_dump_ftps)) {
			while (false !== $file = readdir($handle)) {
				if (($file != '.') && ($file != '..')) {
					if (stripos($file, $mainuser . '_') === false) {
						continue;
					}

					$anslogin[] = $file;
					$ansconfig[] = $this->config_read($path_dump_ftps . '/' . $file);
				}
			}

			closedir($handle);
		}

		$resimp = array();
		$i = 0;

		foreach ($ansconfig as $user) {
			$user_data_main = array();
			$user_data_main['name'] = $user['owner'];
			$user_data_main['rootdir'] = $user['owner_rootdir'];
			$ftp_conf = array();
			$ftp_conf['login'] = str_replace($user['owner'] . '_', '', $user['login']);
			$ftp_conf['pass'] = $this->decryptmainfunc($user['pass'], $GLOBALS['cryptkeymain']);
			$ftp_conf['ftp_user_dir'] = $user['homedir'];
			$ftp_conf['ftp_user_quota'] = $user['quota'];
			$ftp_conf['readonly'] = $user['readonly'];
			$serialdata = json_encode($ftp_conf);

			if ($typeservftp == 'pure-ftpd') {
				if ($this->ftp_useradd_pureftpd($user_data_main, $serialdata)['err'] == 0) {
					$this->ftp_write_user_file_config($user_data_main, $serialdata);
					$resimp[$i]['login'] = $ftp_conf['login'];
					$resimp[$i]['status'] = 1;
				}
				else {
					$resimp[$i]['login'] = $ftp_conf['login'];
					$resimp[$i]['status'] = 0;
				}
			}

			if ($typeservftp == 'proftpd') {
				if ($this->ftp_useradd_proftpd($user_data_main, $serialdata)['err'] == 0) {
					$this->ftp_write_user_file_config($user_data_main, $serialdata);
					$resimp[$i]['login'] = $ftp_conf['login'];
					$resimp[$i]['status'] = 1;
				}
				else {
					$resimp[$i]['login'] = $ftp_conf['login'];
					$resimp[$i]['status'] = 0;
				}
			}

			++$i;
		}

		return $resimp;
	}

	public function ftp_kill_userproc($main_user, $oneuser = NULL)
	{
		if (0 < strlen($main_user)) {
			if (!$this->check_value('string', $main_user)) {
				return 0;
			}
		}

		$getservname = $this->getservicename();

		switch ($getservname['typeftp']) {
		case 'pure-ftpd':
			if (!is_null($oneuser)) {
				$comm = 'pure-ftpwho -s | grep "|' . $oneuser . '|" | xargs | cut -d "|" -f1 | xargs kill';
				$this->ssh($comm);

				return 0;
			}

			$list_ftp = $this->ftp_getuser_pureftpd_all($main_user);

			foreach ($list_ftp as $ftp_user) {
				$comm = 'pure-ftpwho -s | grep "|' . $ftp_user . '|" | xargs | cut -d "|" -f1 | xargs kill';
				$this->ssh($comm);
			}

			break;

		case 'proftpd':
			$mass = array('ScoreboardFile');
			$del = ' ';
			$comm = array('#');
			$scoreboardFile = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
			$scoreboardFile = $scoreboardFile['ScoreboardFile'];

			if (!is_null($oneuser)) {
				$comm = '/usr/local/bin/ftpwho -f ' . $scoreboardFile . ' | grep " ' . $oneuser . ' " | xargs | cut -d " " -f1 | xargs kill';
				$this->ssh($comm);

				return 0;
			}

			$list_ftp = $this->ftp_getuser_proftpd_all($main_user);

			foreach ($list_ftp as $ftp_user) {
				$comm = '/usr/local/bin/ftpwho -f ' . $scoreboardFile . ' | grep " ' . $ftp_user . ' " | xargs | cut -d " " -f1 | xargs kill';
				$this->ssh($comm);
			}

			break;
		}

		return 0;
	}

	public function rename_ftp_prefix($username_old, $username_new)
	{
		$ftp = new ftp();
		$ftp->ftp_kill_userproc($username_old);
		$list_ftp = $ftp->ftp_get_anyftp_listfulluser($username_old);
		$user_conf = array(
			'group_properties' => array('root' => 'y')
			);

		foreach ($list_ftp as $ftp_user) {
			$res = $ftp->ftp_user_delete($user_conf, json_encode(array('username' => $ftp_user)), 1);
		}

		$this->mass_rename('/etc/brainy/data/users_ftp', $username_old . '_', $username_new . '_');
		$out = $this->ssh('ls -l /etc/brainy/data/users_ftp/*' . $username_new . '_* | awk \'{print $9}\'');

		foreach ($out as $value) {
			$this->ssh('replace \'' . $username_old . '\' \'' . $username_new . '\' -- ' . $value);
		}

		$list_ftp = $ftp->ftp_import_subftp_oneuser($username_new);
		$failed_import = array();

		foreach ($list_ftp as $ftp_res_unblock) {
			if ($ftp_res_unblock['status'] == 0) {
				$failed_import[] = $ftp_res_unblock['login'];
			}
		}
	}

	public function changereadonly($user_data_main, $readonly, $username)
	{
		global $lang;

		if (!$this->check_value('user', $user_data_main['name'])) {
			$res['error'] = 2;
			$res['message'] = $lang['ftp_searchftpacc'];
			return $res;
		}

		if (!$this->check_value('number', $readonly)) {
			$res['error'] = 3;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
		}

		if (!$this->check_value('string', $username)) {
			$res['error'] = 3;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
		}

		$out = $this->config_read($GLOBALS['USERS_PATH'] . $user_data_main['name']);

		if ($out['suspended_ftp'] == 1) {
			$res2['error'] = 1;
			$res2['message'] = $lang['ftp_suspended_acc'];
			$res2['status'] = 'done';
			return $res2;
		}

		if (!$this->typeftp || ($this->typeftp == 'noftp')) {
			$this->getservicename();

			if (!$this->typeftp) {
				$res['error'] = 2;
				$res['raw_info'] = -2;
				$res['mess'] = 'No detect ftp server';
				$res['message'] = 'error: function changereadonly(); no detect ftp server';
				return $res;
			}
		}

		switch ($this->typeftp) {
		case 'vsftpd':
			break;

		case 'pure-ftpd':
			$res = $this->changereadonly_pure($user_data_main, $readonly, $username);
			break;

		case 'proftpd':
			$res = $this->changereadonly_pro($user_data_main, $readonly, $username);
			break;
		}

		if ($res['error'] != 0) {
			return $res;
		}

		if (($user_data_main['group_properties']['root'] != 'y') && ($user_data_main['group_properties']['users_management'] != 'y')) {
			$mainuser = $user_data_main['name'];
			$subuser = $username;
			$field = 'readonly';
			$value = intval($readonly);
		}
		else {
			$userparse4admin = $res['mainuser'];
			$mainuser = $userparse4admin;
			$subuser = $username;
			$field = 'readonly';
			$value = intval($readonly);
		}

		return $res;
	}

	public function get_pure_configfile()
	{
		$mass = array('PureDB');
		$del = ' ';
		$comm = array('#');
		$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PURE_FTPD_PATH'], $mass, $del, $comm);
		$ftp_pathfileuser = $ftp_pathfileuser['PureDB'];

		if (strlen($ftp_pathfileuser < 1)) {
			$ftp_pathfileuser = $GLOBALS['PureDB'];
		}

		$ftp_pathfileuser = str_replace('.pdb', '.passwd', $ftp_pathfileuser);
		return $ftp_pathfileuser;
	}

	public function changereadonly_pure($user_data_main, $readonly, $username)
	{
		if ($user_data_main['group_properties']['root'] == 'y') {
			$username_exp_get = explode('_', $username)[0];
			$res_user_sub_all = $this->ftp_getuser_pureftpd_all($username_exp_get);
		}
		else {
			$username_exp_get = $user_data_main['name'];
			$res_user_sub_all = $this->ftp_getuser_pureftpd_all($user_data_main['name']);
		}

		if ($res_user_sub_all['error'] != 0) {
			$res_user_sub_all['error'] = -6;
			$res_user_sub_all['raw_info'] = -5;
			$res_user_sub_all['message'] = 'error: function changereadonly_pure() -> function ftp_user_listsub(); user not found';
			return $res_user_sub_all;
		}

		if (($user_data_main['group_properties']['root'] != 'y') && ($user_data_main['group_properties']['users_management'] != 'y')) {
			foreach ($res_user_sub_all as $useritem) {
				$q = 1;
				break;
			}
		}
		else {
			$q = 1;
		}

		$ftp_pathfileuser = $this->get_pure_configfile();

		if ($q == 1) {
			if ($readonly == 0) {
				$comm = 'pure-pw usermod "' . $username . '" -f ' . $ftp_pathfileuser . ' -g ' . $username_exp_get . ' -u ' . $username_exp_get . ' -m';
			}
			else {
				$comm = 'pure-pw usermod "' . $username . '" -f ' . $ftp_pathfileuser . ' -g ftpgroup -u ftpuser-read  -m';
			}

			$this->ssh($comm);
			$this->ftp_kill_userproc($username_exp_get, $username);
			$arr = array('readonly' => $readonly);
			$this->config_save($GLOBALS['USERS_PATH_FTP'] . $username_exp_get . '_' . $username, $arr);
			global $lang;
			$res['raw_info'] = 1;
			$res['status'] = 'done';
			$res['message'] = $lang['ftp_user_readonly_res_ok_save'];
			$res['error'] = 0;
			return $res;
		}

		$res['raw_info'] = -1;
		$res['status'] = 'done';
		$res['error'] = 2;
		$res['message'] = 'error: function changereadonly_pure() -> function ftp_user_listsub(): user not found';
		return $res;
	}

	public function changereadonly_pro($user_data_main, $readonly, $username)
	{
		if ($user_data_main['group_properties']['root'] == 'y') {
			$username_exp_get = explode('_', $username)[0];
			$res_user_sub_all = $this->ftp_getuser_proftpd_all($username_exp_get);
		}
		else {
			$username_exp_get = $user_data_main['name'];
			$res_user_sub_all = $this->ftp_getuser_proftpd_all($user_data_main['name']);
		}

		if ($res_user_sub_all['error'] != 0) {
			$res_user_sub_all['error'] = -6;
			$res_user_sub_all['raw_info'] = -5;
			$res_user_sub_all['message'] = 'error: function changereadonly_pro() -> function ftp_user_listsub(); user not found';
			return $res_user_sub_all;
		}

		if (($user_data_main['group_properties']['root'] != 'y') && ($user_data_main['group_properties']['users_management'] != 'y')) {
			foreach ($res_user_sub_all as $useritem) {
				$q = 1;
				break;
			}
		}
		else {
			$q = 1;
		}

		$mass = array('AuthUserFile');
		$del = ' ';
		$comm = array('#');
		$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
		$ftp_pathfileuser = $ftp_pathfileuser['AuthUserFile'];

		if ($q == 1) {
			if ($readonly != 1) {
				$comm = 'getent passwd | grep "^' . $username_exp_get . ':" | cut -d ":" -f3 | tr "\\n" " "';
				$ownerid = intval(implode($this->ssh($comm)));
				$comm = 'getent passwd | grep "^' . $username_exp_get . ':" | cut -d ":" -f4 | tr "\\n" " "';
				$ownergroupid = intval(implode($this->ssh($comm)));
			}
			else {
				$comm = 'getent passwd | grep "^ftpuser-read:" | cut -d ":" -f3 | tr "\\n" " "';
				$ownerid = intval(implode($this->ssh($comm)));
				$comm = 'getent passwd | grep "^ftpuser-read:" | cut -d ":" -f4 | tr "\\n" " "';
				$ownergroupid = intval(implode($this->ssh($comm)));
			}

			$comm = 'cat ' . $ftp_pathfileuser . ' | grep "^' . $username . ':"';
			$user_row_data = $this->ssh($comm)[0];
			$user_row_data_orig = $user_row_data;
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep "^' . $username . ':" | cut -d ":" -f3';
			$user_uid = $this->ssh($comm)[0];
			$comm = 'cat ' . $ftp_pathfileuser . ' | grep "^' . $username . ':" | cut -d ":" -f4';
			$user_gid = $this->ssh($comm)[0];
			$user_row_data = str_replace(':' . $user_uid . ':', ':' . $ownerid . ':', $user_row_data);
			$user_row_data = str_replace(':' . $user_gid . ':', ':' . $ownergroupid . ':', $user_row_data);
			$full_users_rows = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($ftp_pathfileuser));

			foreach ($full_users_rows as $key => $cur_user) {
				if ($cur_user == $user_row_data_orig) {
					$full_users_rows[$key] = $user_row_data;
				}
			}

			file_put_contents($ftp_pathfileuser, '', LOCK_EX);

			foreach ($full_users_rows as $key => $cur_user) {
				if (1 < strlen($cur_user)) {
					file_put_contents($ftp_pathfileuser, $cur_user . "\n", FILE_APPEND | LOCK_EX);
				}
			}

			$this->ssh($comm);
			$arr = array('readonly' => $readonly);
			$this->config_save($GLOBALS['USERS_PATH_FTP'] . $username_exp_get . '_' . $username, $arr);
			$mass = array('ScoreboardFile');
			$del = ' ';
			$comm = array('#');
			$scoreboardFile = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
			$scoreboardFile = $scoreboardFile['ScoreboardFile'];
			$this->ftp_kill_userproc($username_exp_get, $username);
			global $lang;
			$res['raw_info'] = 1;
			$res['status'] = 'done';
			$res['message'] = $lang['ftp_user_readonly_res_ok_save'];
			$res['error'] = 0;
			return $res;
		}

		$res['raw_info'] = -1;
		$res['status'] = 'done';
		$res['error'] = 2;
		$res['message'] = 'error: function changereadonly_pro() -> function ftp_user_listsub(): user not found';
		return $res;
	}
}


?>
