<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class hashmon
{
	public $pathdata = '/etc/brainy/data/hashmon/';
	public $job_pref = 'hashjob_';
	public $job_cachecron = 'cronhashjob';

	public function __construct()
	{
		if (!is_dir($this->pathdata)) {
			$this->ssh('mkdir -p ' . $this->pathdata);
		}
	}

	public function loaduserdata($user)
	{
		$userdata = parse_ini_file($GLOBALS['USERS_PATH'] . $user);
		$out['user_homedir'] = $userdata['rootdir'];
		$webserver = new webserver();
		$out['domains'] = $webserver->get_virt_hosts($user, 1);
		$out = array_merge($out, $this->loadhashlist($user, 0));
		return $out;
	}

	public function array_sort_by_column(&$arr, $col, $dir = SORT_ASC)
	{
		$sort_col = array();

		foreach ($arr as $key => $row) {
			$sort_col[$key] = $row[$col];
		}

		array_multisort($sort_col, $dir, $arr);
	}

	public function loadhashlist($user, $simplearr = 1)
	{
		$listhashes = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($this->pathdata . $user));
		$i = 0;

		foreach ($listhashes as $curhash) {
			$expdata = explode('|', $curhash);
			$t1 = explode('#', $expdata[0]);
			$t2 = str_replace('_', '/', $t1[1]);

			if (1 < strlen($t2)) {
				$exphash[$i]['file'] = basename($expdata[0]);
				$exphash[$i]['srcmon'] = str_replace('//', '/', $t2);
				$exphash[$i]['date'] = date('d.m.Y H:i:s', $expdata[1]);
				$exphash[$i]['datehidesort'] = intval($expdata[1]);
				$exphash[$i]['hashmain'] = intval($expdata[2]);
				++$i;
			}
		}

		$this->array_sort_by_column($exphash, 'datehidesort', SORT_DESC);

		if ($simplearr == 1) {
			$out = $exphash;
		}
		else {
			$out['user_hashes'] = $exphash;
		}

		return $out;
	}

	public function check_access_hash($user, $path)
	{
		$list_hash = $this->loadhashlist($user);
		$decode = json_decode($_POST['serdata'], 1);
		$quser = 0;

		foreach ($list_hash as $curhash) {
			if ($curhash['file'] == basename($path)) {
				$quser = 1;
			}
		}

		global $lang;

		if ($quser == 0) {
			$res['code'] = -1;
			$res['message'] = $lang['hashmon_option_denydeletehash'];
		}
		else {
			$res['code'] = 0;
		}

		return $res;
	}

	public function mainhash_onoff($user)
	{
		$main_onoff = intval($_POST['main_onoff']);
		$path = $this->pathdata . '/' . $_POST['path'];

		if (!$this->check_value('user', $user)) {
			return 0;
		}

		if (!$this->check_value('file', $path)) {
			return 0;
		}

		$res = $this->check_access_hash($user, $path);

		if ($res['code'] == -1) {
			return $res;
		}

		$listhashes = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($this->pathdata . $user));
		$i = 0;
		$qu = 0;
		$basemainnow = str_replace('_', '', explode('#', basename($path))[1]);

		foreach ($listhashes as $key => $curhash) {
			if (str_replace('_', '', explode('#', basename($curhash))[1]) == $basemainnow) {
				$exp_data = explode('|', $curhash);
				$exp_data[2] = 0;
				$impl = implode('|', $exp_data);
				$listhashes[$key] = $impl;
			}
		}

		foreach ($listhashes as $key => $curhash) {
			$exp_data = explode('|', $curhash);

			$exp_data[2] = $main_onoff;
			$impl = implode('|', $exp_data);
			$listhashes[$key] = $impl;
			$qu = 1;
			break;
		}

		if ($qu == 1) {
			file_put_contents($this->pathdata . $user, '');

			foreach ($listhashes as $key => $curhash) {
				if (1 < strlen($curhash)) {
					file_put_contents($this->pathdata . $user, $curhash . "\n", FILE_APPEND);
				}
			}
		}
	}

	public function createhash($user, $namejob = NULL)
	{
		$decode = json_decode($_POST['serdata'], 1);
		global $lang;
		$time = time();

		if (!isset($namejob)) {
			if (!$this->check_params('dir', $decode['path'])) {
				$ans['code'] = -1;
				$ans['message'] = $lang['hashmon_wrongdir'];
				return $ans;
			}

			if (!$this->check_params('text', $decode['incparam'])) {
				$ans['code'] = -1;
				$ans['message'] = $lang['hashmon_wrong_findonlywith'];
				return $ans;
			}

			if (!$this->check_params('text', $decode['excparam'])) {
				$ans['code'] = -1;
				$ans['message'] = $lang['hashmon_wrong_findonlywithout'];
				return $ans;
			}

			$includeext = preg_split('/[\\s,;]/', $decode['incparam']);
			$excludeext = preg_split('/[\\s,;]/', $decode['excparam']);
			$userdata = parse_ini_file($GLOBALS['USERS_PATH'] . $user);
			$user_homedir = $userdata['rootdir'];
			$mon_dir = $user_homedir . '/' . $decode['path'] . '/';
		}
		else {
			$confjob = parse_ini_file($this->pathdata . $this->job_pref . $user . '_' . $namejob);
			$includeext = preg_split('/[\\s,;]/', $confjob['includeparam']);
			$excludeext = preg_split('/[\\s,;]/', $confjob['excludeparam']);
			$mon_dir = $confjob['pathtoscan'];
		}

		$includeext = array_filter($includeext);
		$excludeext = array_filter($excludeext);
		$include_dir = array();
		$exclude_dir = array();

		foreach ($includeext as $key => $curext) {
			if (stripos($curext, 'dir:') !== false) {
				$include_dir[] = trim(str_replace('dir:', '', $curext));
				unset($includeext[$key]);
			}
		}

		foreach ($excludeext as $key => $curext) {
			if (stripos($curext, 'dir:') !== false) {
				$exclude_dir[] = trim(str_replace('dir:', '', $curext));
				unset($excludeext[$key]);
			}
		}

		$scanfiles = scandir($mon_dir);
		$array_calc_md5 = array();

		try {
			$rii = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($mon_dir));
		}
		catch (UnexpectedValueException $ew) {
			$res['code'] = -1;
			$res['message'] = $lang['hashmon_pathnotexist'];
			return $res;
		}

		foreach ($_POST['serdata'] as $curfileobj) {
			if ($curfileobj->isDir()) {
				continue;
			}

			$curfile = $curfileobj->getFilename();
			$ext = pathinfo($mon_dir . $curfile);
			$q_anal_file = -1;
			if ((0 < count($includeext)) || (0 < count($excludeext)) || (0 < count($include_dir)) || (0 < count($exclude_dir))) {
				if (0 < count($includeext)) {
					$q_anal_file = 0;

					if (in_array($ext['extension'], $includeext)) {
						$q_anal_file = 1;

						foreach ($include_dir as $currule) {
							if (strlen($currule) < 1) {
								continue;
							}

							$rulefix = str_replace('dir:', '', $currule);
							$rulefix = str_replace('//', '/', $rulefix);

							if (stripos($rulefix, '||') !== false) {
								$rulefix_exp = explode('||', $rulefix);
								$rulefix = $rulefix_exp[0];
								$rulefix_incl_ext_indir = array();

								foreach ($rulefix_exp as $keyi => $itemi) {
									if (0 < $keyi) {
										$rulefix_incl_ext_indir[] = $itemi;
									}
								}

								$mon_fix = str_replace('//', '/', dirname($curfileobj->getPathname())) . '/';

								if (stripos($mon_fix, $rulefix) !== false) {
									if (!in_array($ext['extension'], $rulefix_incl_ext_indir)) {
										$q_anal_file = 0;
										continue;
										$mon_fix = str_replace('//', '/', dirname($curfileobj->getPathname())) . '/';

										if (stripos($mon_fix, $rulefix) !== false) {
											$q_anal_file = 1;
										}
									}
								}
							}
							else {
								continue;
								$mon_fix = str_replace('//', '/', dirname($curfileobj->getPathname())) . '/';
								$q_anal_file = 1;
							}
						}
					}
				}

				if ($q_anal_file == 0) {
					foreach ($include_dir as $currule) {
						$q_anal_file = 0;
						$rulefix = str_replace('dir:', '', $currule);
						$rulefix = str_replace('//', '/', $rulefix);

						if (stripos($rulefix, '||') !== false) {
							$rulefix_exp = explode('||', $rulefix);
							$rulefix = $rulefix_exp[0];
							$rulefix_incl_ext_indir = array();

							foreach ($rulefix_exp as $keyi => $itemi) {
								if (0 < $keyi) {
									$rulefix_incl_ext_indir[] = $itemi;
								}
							}

							if (!in_array($ext['extension'], $rulefix_incl_ext_indir)) {
								continue;
							}
						}

						$mon_fix = str_replace('//', '/', dirname($curfileobj->getPathname())) . '/';

						$q_anal_file = 1;
						break;
					}
				}

				if (($q_anal_file == -1) || ($q_anal_file == 1)) {
					if (0 < count($excludeext)) {
						$q_anal_file = 0;

						if (!in_array($ext['extension'], $excludeext)) {
							$q_anal_file = 1;

							foreach ($exclude_dir as $currule) {
								if (strlen($currule) < 1) {
									continue;
								}

								$rulefix = str_replace('dir:', '', $currule);
								$rulefix = str_replace('//', '/', $rulefix);

								if (stripos($rulefix, '||') !== false) {
									$rulefix_exp = explode('||', $rulefix);
									$rulefix = $rulefix_exp[0];
									$rulefix_incl_ext_indir = array();

									foreach ($rulefix_exp as $keyi => $itemi) {
										if (0 < $keyi) {
											$rulefix_incl_ext_indir[] = $itemi;
										}
									}

									$mon_fix = str_replace('//', '/', dirname($curfileobj->getPathname())) . '/';

									if (stripos($mon_fix, $rulefix) !== false) {
										if (in_array($ext['extension'], $rulefix_incl_ext_indir)) {
											$q_anal_file = 0;
											continue;
											$mon_fix = str_replace('//', '/', dirname($curfileobj->getPathname())) . '/';

											if (stripos($mon_fix, $rulefix) !== false) {
												$q_anal_file = 0;
											}
										}
									}
								}
								else {
									continue;
									$mon_fix = str_replace('//', '/', dirname($curfileobj->getPathname())) . '/';
									$q_anal_file = 0;
								}
							}
						}
					}
					else {
						foreach ($exclude_dir as $currule) {
							if (strlen($currule) < 1) {
								continue;
							}

							$q_anal_file = 1;
							$rulefix = str_replace('dir:', '', $currule);
							$rulefix = str_replace('//', '/', $rulefix);

							if (stripos($rulefix, '||') !== false) {
								$rulefix_exp = explode('||', $rulefix);
								$rulefix = $rulefix_exp[0];
								$rulefix_incl_ext_indir = array();

								foreach ($rulefix_exp as $keyi => $itemi) {
									if (0 < $keyi) {
										$rulefix_incl_ext_indir[] = $itemi;
									}
								}

								if (in_array($ext['extension'], $rulefix_incl_ext_indir)) {
									continue;
								}
							}

							$mon_fix = str_replace('//', '/', dirname($curfileobj->getPathname())) . '/';

							$q_anal_file = 0;
							break;
						}
					}
				}

				if ($q_anal_file == 1) {
					$array_calc_md5[] = $curfileobj->getPathname();
				}
			}
			else {
				$array_calc_md5[] = $curfileobj->getPathname();
			}
		}

		$file_res_calcmd5 = $this->pathdata . '/' . $user . '#' . str_replace('/', '_', $mon_dir) . '_#' . $time;
		$file_res_calcmd5 = str_replace('__', '_', $file_res_calcmd5);
		$res['code'] = -1;
		$res['message'] = $lang['hashmon_nofindbymask'];

		foreach ($array_calc_md5 as $curfile) {
			$res['code'] = 1;
			$res['message'] = $lang['hashmon_findbymask'];
			$res['filehash'] = $file_res_calcmd5;
			$md5file = md5_file($curfile);
			file_put_contents($file_res_calcmd5, str_replace('//', '/', $curfile) . '|' . $md5file . "\n", FILE_APPEND);
		}

		if ($res['code'] == 1) {
			$file_list_res = $this->pathdata . '/' . $user;
			file_put_contents($file_list_res, $file_res_calcmd5 . '|' . $time . "\n", FILE_APPEND);
		}

		return $res;
	}

	public function hash_remove($user)
	{
		$list_hash = $this->loadhashlist($user);
		$decode = json_decode($_POST['serdata'], 1);
		$path = $this->pathdata . '/' . $decode['path'];
		$quser = 0;

		foreach ($list_hash as $curhash) {
			if (basename($curhash['file']) == basename($path)) {
				$quser = 1;
			}
		}

		global $lang;

		if ($quser == 0) {
			$res['code'] = -1;
			$res['message'] = $lang['hashmon_option_denydeletehash'];
			return $res;
		}

		unlink($path);
		$this->del_string_new($path, $this->pathdata . $user);
		$res['code'] = 0;
		return $res;
	}

	public function getcomparelist($user)
	{
		if (!$this->check_value('user', $user)) {
			return 0;
		}

		$listhashes = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($this->pathdata . $user . '_compare'));
		$i = 0;

		foreach ($listhashes as $curhash) {
			$expdata = explode('|', $curhash);
			$t1 = explode('#', $expdata[0]);
			$t2 = str_replace('_', '/', $t1[1]);

			if (1 < strlen($t2)) {
				$hash0 = $expdata[0];
				$hash1 = $expdata[1];
				$base0_part0_comp = basename($hash0);
				$base0 = basename($hash0);
				$time0Time = explode('#', $base0)[2];
				$time0 = date('d.m.Y H:i:s', explode('#', $base0)[2]);
				$base0 = str_replace('_', '/', explode('#', $base0)[1]);
				$base0 = str_replace('//', '/', $base0);
				$base1 = basename($hash1);
				$base1_part1_comp = basename($hash1);
				$time1 = date('d.m.Y H:i:s', explode('#', $base1)[2]);
				$base1 = str_replace('_', '/', explode('#', $base1)[1]);
				$base1 = str_replace('//', '/', $base1);
				$exphash[$i]['base0'] = $base0;
				$exphash[$i]['base1'] = $base1;
				$exphash[$i]['time0'] = $time0;
				$exphash[$i]['time0time'] = $time0Time;
				$exphash[$i]['time1'] = $time1;
				$exphash[$i]['pathcomp'] = $base0_part0_comp . '##' . $base1_part1_comp;
				++$i;
			}
		}

		$this->array_sort_by_column($exphash, 'time0time', SORT_DESC);
		return $exphash;
	}

	public function remove_compareitem($user)
	{
		global $lang;
		$decode = json_decode($_POST['serdata'], 1);
		$compareitem = $decode['compareitem'];

		if (stripos($compareitem, $user . '#') === false) {
			$res['error'] = -1;
			$res['message'] = $lang['hashmon_comphash_table_compared_del_deny'];
			return $res;
		}

		if ($this->check_value('file', $this->pathdata . $compareitem)) {
			unlink($this->pathdata . $compareitem);
		}

		$arr_find[] = explode('##', $compareitem)[0];
		$arr_find[] = explode('##', $compareitem)[1];
		$this->del_string_from_file($this->pathdata . $user . '_compare', $arr_find);
		$res['error'] = 0;
		$res['message'] = $lang['hashmon_delcapt_comp_succ'];
		return $res;
	}

	public function view_compare($user, $fullpath_compres = NULL)
	{
		global $lang;

		if (!isset($fullpath_compres)) {
			$decode = json_decode($_POST['serdata'], 1);
			$compareitem = $decode['compareitem'];
		}
		else {
			$compareitem = basename($fullpath_compres);
		}

		if ((stripos($compareitem, $user . '#') === false) || !$this->check_value('file', $this->pathdata . $compareitem)) {
			$res['error'] = -1;
			$res['message'] = $lang['hashmon_comphash_table_compared_view_deny'];
			return $res;
		}

		$comp_res = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($this->pathdata . $compareitem));
		$res_arr = array();
		$res_arr['exist0'] = array();
		$res_arr['exist1'] = array();
		$res_arr['diff'] = array();

		foreach ($comp_res as $currow) {
			if (stripos($currow, 'exist0|') !== false) {
				$res_arr['exist0'][] = explode('|', $currow)[1];
			}

			if (stripos($currow, 'exist1|') !== false) {
				$res_arr['exist1'][] = explode('|', $currow)[1];
			}

			if (stripos($currow, 'diff|') !== false) {
				$res_arr['diff'][] = explode('|', $currow)[2];
			}
		}

		return $res_arr;
	}

	public function sendemail_notify($user, $fullpathjob, $fullpath_compres)
	{
		global $lang;
		$confjob = parse_ini_file($fullpathjob);
		$rec_comp = $this->view_compare($user, $fullpath_compres);

		if (isset($rec_comp['code'])) {
			$res['code'] = -1;
			$res['message'] = $lang['hashmon_email_erorr_send'];
			return $res;
		}

		$mail_notify = preg_split('/[\\s,;|]/', $confjob['emails']);
		$text_email = '';
		$len0 = count($rec_comp['exist0']);
		$len1 = count($rec_comp['exist1']);
		$difflen = count($rec_comp['diff']);
		$text_email .= $lang['hashmon_comphash_table_compared_view_newin'] . ' ' . $len0 . '<br/>';

		if (0 < $len0) {
			foreach ($rec_comp['exist0'] as $currow_comp) {
				$text_email .= $currow_comp . '<br/>';
			}
		}
		else {
			$text_email .= $lang['hashmon_comphash_table_compared_view_newin_not'];
		}

		$text_email .= '<br/>' . $lang['hashmon_comphash_table_compared_view_remove'] . ' ' . $len1 . '<br/>';

		if (0 < $len1) {
			foreach ($rec_comp['exist1'] as $currow_comp) {
				$text_email .= $currow_comp . '<br/>';
			}
		}
		else {
			$text_email .= $lang['hashmon_comphash_table_compared_view_newin_not'];
		}

		$text_email .= '<br/>' . $lang['hashmon_comphash_table_compared_view_diff'] . $difflen . '<br/>';

		if (0 < $difflen) {
			foreach ($rec_comp['diff'] as $currow_comp) {
				$text_email .= $currow_comp . '<br/>';
			}
		}
		else {
			$text_email .= $lang['hashmon_comphash_table_compared_view_diff_no'];
		}

		$mailObj = new mail();

		foreach ($mail_notify as $curemail) {
			$mailObj->sendmail($curemail, 'You', $lang['hashmon_email_res_monit'] . $confjob['pathtoscan'], $text_email);
		}
	}

	public function getcompareprocess($user)
	{
	}

	public function preparestream_comparehash($user, $oper = 'cron')
	{
		$decode = json_decode($_POST['serdata'], 1);
		$pathhash0 = $this->pathdata . '/' . $decode['hashpath0'];
		$pathhash1 = $this->pathdata . '/' . $decode['hashpath1'];

		if (!$this->check_value('user', $user)) {
			return 0;
		}

		$list_hash = $this->loadhashlist($user);
		$quser = 0;
		$user_runcomp = $this->pathdata . $user . '_runcomp';
		$file_list_compare_user = $this->pathdata . $user . '_compare';
		$pid_arr = array();
		$datehash0 = '';
		$datehash1 = '';

		if ($_GET['check'] == 0) {
			foreach ($list_hash as $curhash) {
				if (basename($curhash['file']) == basename($pathhash0)) {
					$datehash0 = $curhash['date'];
					++$quser;
				}

				if (basename($curhash['file']) == basename($pathhash1)) {
					$datehash1 = $curhash['date'];
					++$quser;
				}
			}

			global $lang;

			if ($quser < 2) {
				$res['code'] = -1;
				$res['message'] = $lang['hashmon_option_denydeletehash'];
				return $res;
			}

			if (filemtime($pathhash0) < filemtime($pathhash1)) {
				$t = $pathhash0;
				$pathhash0 = $pathhash1;
				$pathhash1 = $t;
			}

			$param = array('oper' => $oper, 'hashpath0' => $pathhash0, 'hashpath1' => $pathhash1, 'username' => $user);
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/hashmon.php -a=\'hashmon_compare\' -p=\'' . json_encode($param) . '\'';
			$timecur = time();
			$stream_id = $this->create_stream($stream);
			$pid_arr[0]['streamid'] = $stream_id;
			$pid_arr[0]['hash0full'] = $pathhash0;
			$pid_arr[0]['timestart'] = date('d.m.Y H:i:s', $timecur);
			$path0_exp = explode('#', $pathhash0);
			$path0_exp = $path0_exp[1];
			$path0_exp = str_replace('_', '/', $path0_exp);
			$path0_exp = str_replace('//', '/', $path0_exp);
			$pid_arr[0]['hash0'] = $path0_exp;
			$pid_arr[0]['date0'] = $datehash0;
			$path1_exp = explode('#', $pathhash1);
			$path1_exp = $path1_exp[1];
			$path1_exp = str_replace('_', '/', $path1_exp);
			$path1_exp = str_replace('//', '/', $path1_exp);
			$pid_arr[0]['hash1'] = $path1_exp;
			$pid_arr[0]['date1'] = $datehash1;
			$this->del_string_new($pathhash0 . '|' . $pathhash1, $file_list_compare_user);
			$savecompto = $this->pathdata . basename($pathhash0) . '##' . basename($pathhash1);
			file_put_contents($file_list_compare_user, $pathhash0 . '|' . $pathhash1 . '|' . $timecur . '|' . $stream_id . "\n", FILE_APPEND | LOCK_EX);
			file_put_contents($user_runcomp, $stream_id . '|' . $timecur . '|' . $path0_exp . '|' . $path1_exp . '|' . $datehash0 . '|' . $datehash1 . '|' . $savecompto . '|' . $pathhash0 . "\n", FILE_APPEND);
			$pid_arr[0]['percentcomplete'] = 1;
		}
		else {
			$getliststream = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($user_runcomp));
			$count = 0;

			foreach ($getliststream as $key => $curcomp_stream) {
				if (1 < strlen($curcomp_stream)) {
					$stream_exp = explode('|', $curcomp_stream);
					$stream_curid = $stream_exp[0];
					$pid = $this->getexistpid($stream_curid);

					if ($pid == -1) {
						unset($getliststream[$key]);
					}
					else {
						$pid_arr[$count]['streamid'] = $pid;
						$pid_arr[$count]['timestart'] = date('d.m.Y H:i:s', $stream_exp[1]);
						$pid_arr[$count]['hash0'] = $stream_exp[2];
						$pid_arr[$count]['hash1'] = $stream_exp[3];
						$pid_arr[$count]['date0'] = $stream_exp[4];
						$pid_arr[$count]['date1'] = $stream_exp[5];
						$pid_arr[$count]['savecompto'] = $stream_exp[6];
						$pid_arr[$count]['hash0full'] = basename($stream_exp[7]);
						$progress_arr = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($pid_arr[$count]['savecompto']));
						$percent = 0;

						foreach ($progress_arr as $curprogress) {
							if (stripos($curprogress, 'progress') !== false) {
								$percent_exp = explode('|', $curprogress);
								$percent = round((floatval($percent_exp[1]) / floatval($percent_exp[2])) * 100);
							}
						}

						$pid_arr[$count]['percentcomplete'] = $percent;
						++$count;
					}
				}
			}

			if (0 < count($getliststream)) {
				file_put_contents($user_runcomp, '');
			}

			foreach ($getliststream as $key => $curcomp_stream) {
				if (1 < strlen($curcomp_stream)) {
					file_put_contents($user_runcomp, $curcomp_stream . "\n", FILE_APPEND);
				}
			}
		}

		return $pid_arr;
	}

	public function comparehash($user, $oper = 'cron', $pathhash0, $pathhash1, $cronparam = NULL)
	{
		$short = 1;
		$file_list_compare_user = $this->pathdata . $user . '_compare';
		$list_hash = $this->loadhashlist($user);
		$write2file_rescompare = $this->pathdata . basename($pathhash0) . '##' . basename($pathhash1);
		file_put_contents($write2file_rescompare, '');
		$quser = 0;

		foreach ($list_hash as $curhash) {
			if (basename($curhash['file']) == basename($pathhash0)) {
				++$quser;
			}

			if (basename($curhash['file']) == basename($pathhash1)) {
				++$quser;
			}
		}

		if (isset($cronparam)) {
			$file_list_compare_user = $this->pathdata . $user . '_compare';
			file_put_contents($file_list_compare_user, $pathhash0 . '|' . $pathhash1 . '|' . time() . '|cronrun' . "\n", FILE_APPEND | LOCK_EX);
		}

		global $lang;

		if ($quser < 2) {
			$res['code'] = -1;
			$res['message'] = $lang['hashmon_option_denydeletehash'];
			return $res;
		}

		$list1 = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($pathhash0));
		$list2 = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($pathhash1));
		$count1 = count($list1);
		$count2 = count($list2);
		$arr_diff = array();
		$list1_par = array();
		$list2_par = array();
		$list1_par[] = array();
		$list2_par[] = array();
		$i = 0;

		while ($i < $count1) {
			$list1_par[$i]['stat'] = 2;
			++$i;
		}

		$i = 0;

		while ($i < $count2) {
			$list2_par[$i]['stat'] = 2;
			++$i;
		}

		$i = 0;

		while ($i < $count1) {
			if (($i % 100) == 0) {
				$this->putorprint($oper, $write2file_rescompare, 'progress|' . $i . '|' . $count1 . "\n");
			}

			$j = 0;

			while ($j < $count2) {
				if ($list2_par[$j]['stat'] != 2) {
					continue;
				}

				$exp1 = preg_split('/[\\s,;|]/', $list1[$i]);
				$exp1 = array_values(array_filter($exp1));
				$exp2 = preg_split('/[\\s,;|]/', $list2[$j]);
				$exp2 = array_values(array_filter($exp2));

				if (isset($exp2[0]) && isset($exp1[0]) && (trim($exp2[0]) == trim($exp1[0]))) {
					if ($exp2[1] == $exp1[1]) {
						$list1_par[$i]['stat'] = 0;
						$list2_par[$j]['stat'] = 0;
					}
					else {
						$list1_par[$i]['stat'] = 1;
						$list2_par[$j]['stat'] = 1;
						$arr_diff[$exp1[1]]['path'] = $exp1[0];
						$arr_diff[$exp1[1]]['val1'] = $exp1[1];
						$arr_diff[$exp1[1]]['val2'] = $exp2[1];
					}

					break;
				}

				++$j;
			}

			++$i;
		}

		$this->putorprint($oper, $write2file_rescompare, 'existname0|' . $pathhash0 . "\n");
		$nn = 0;
		$i = 0;

		while ($i < $count1) {
			if (($list1_par[$i]['stat'] == 2) && (1 < strlen($list1[$i]))) {
				$this->putorprint($oper, $write2file_rescompare, 'exist0|' . $list1[$i] . "\n");
				++$nn;
			}

			++$i;
		}

		$this->putorprint($oper, $write2file_rescompare, 'existname1|' . $pathhash1 . "\n");
		$nn = 0;
		$i = 0;

		while ($i < $count2) {
			if (($list2_par[$i]['stat'] == 2) && (1 < strlen($list2[$i]))) {
				$this->putorprint($oper, $write2file_rescompare, 'exist1|' . $list2[$i] . "\n");
				++$nn;
			}

			++$i;
		}

		$this->putorprint($oper, $write2file_rescompare, 'comp_hashhash0|' . $pathhash0 . "\n");
		$this->putorprint($oper, $write2file_rescompare, 'comp_hashhash1|' . $pathhash1 . "\n");
		$i = 0;

		foreach ($arr_diff as $curdiff) {
			$this->putorprint($oper, $write2file_rescompare, 'diff|' . $i . '|' . $curdiff['path'] . '|' . $curdiff['val1'] . '|' . $curdiff['val2'] . "\n");
			++$i;
		}

		$res['code'] = 0;
		$res['file_comp'] = $write2file_rescompare;
		$res['message'] = $lang['hashmon_option_complete_compare'];
		return $res;
	}

	public function putorprint($oper, $fileres, $val)
	{
		if ($oper == 'cron') {
			file_put_contents($fileres, $val, FILE_APPEND);
		}
		else {
			echo $val;
		}
	}

	public function updatecachecronjob($user, $namejob, $starttime = NULL)
	{
		global $lang;

		if (!is_file($this->pathdata . $this->job_pref . $user . '_' . $namejob)) {
			$rescheck['code'] = -1;
			$rescheck['message'] = $lang['hashmon_namejob_exist_noedit'];
			return $rescheck;
		}

		$arr_find[] = $this->job_pref . $user . '_' . $namejob;
		$this->del_string_from_file($this->pathdata . $this->job_cachecron, $arr_find);
		$datajob = parse_ini_file($this->pathdata . $this->job_pref . $user . '_' . $namejob);

		if (intval($datajob['status']) == 1) {
			if (isset($starttime)) {
				file_put_contents($this->pathdata . $this->job_cachecron, 'namejob::' . $this->job_pref . $user . '_' . $namejob . '|' . 'run_period::' . $datajob['run_period'] . '|' . 'time_start_hour::' . $datajob['time_start_hour'] . '|' . 'time_start_minute::' . $datajob['time_start_minute'] . '|' . 'weekly_days::' . $datajob['weekly_days'] . '|' . 'monthly_select_date::' . $datajob['monthly_select_date'] . '|' . 'starttime::' . $starttime . '|' . "\n", FILE_APPEND);
			}
			else {
				file_put_contents($this->pathdata . $this->job_cachecron, 'namejob::' . $this->job_pref . $user . '_' . $namejob . '|' . 'run_period::' . $datajob['run_period'] . '|' . 'time_start_hour::' . $datajob['time_start_hour'] . '|' . 'time_start_minute::' . $datajob['time_start_minute'] . '|' . 'weekly_days::' . $datajob['weekly_days'] . '|' . 'monthly_select_date::' . $datajob['monthly_select_date'] . '|' . "\n", FILE_APPEND);
			}
		}
	}

	public function managejob($user)
	{
		if (!$this->check_value('user', $user)) {
			return 0;
		}

		$userdata = parse_ini_file($GLOBALS['USERS_PATH'] . $user);
		$user_home = $userdata['rootdir'];

		if (isset($_GET['editstat'])) {
			global $lang;
			$decode = json_decode($_POST['serdata'], 1);
			$namejob = $decode['namejob'];
			$stat = $decode['stat'];

			if (!is_file($this->pathdata . $this->job_pref . $user . '_' . $namejob)) {
				$rescheck['code'] = -1;
				$rescheck['message'] = $lang['hashmon_namejob_exist_noedit'];
			}

			$arrconf = array('namejob' => $namejob, 'status' => $stat);

			if ($rescheck['code'] != 0) {
				return $rescheck;
			}

			$this->config_save($this->pathdata . $this->job_pref . $user . '_' . $namejob, $arrconf);
			$rescheck['code'] = 0;
			$rescheck['message'] = $lang['hashmon_job_save_complete'];
			$this->updatecachecronjob($user, $namejob);
			return $rescheck;
		}

		global $lang;
		$decode = json_decode($_POST['serdata'], 1);
		$act = $decode['act'];
		$namejob = $decode['namejob'];
		$pathtoscan = str_replace('//', '/', $user_home . '/' . $decode['pathtoscan']);
		$includeparam = $decode['includeparam'];
		$excludeparam = $decode['excludeparam'];
		$run_period = $decode['backup_period'];
		$time_start_hour = intval($decode['backup_time_start_hour']);
		$time_start_minute = $decode['backup_time_start_minute'];
		$weekly_days = $decode['backup_weekly_days'];
		$monthly_select_date = $decode['backup_monthly_select_date'];
		$email_list = $decode['email'];
		$selmaincapt = $decode['selmaincapt'];
		$status = intval($decode['status']);
		$rescheck['code'] = 0;

		if ($act == 'add') {
			if (is_file($this->pathdata . $this->job_pref . $user . '_' . $namejob)) {
				$rescheck['code'] = -1;
				$rescheck['message'] = $lang['hashmon_namejob_exist'];
			}
		}
		else if (!is_file($this->pathdata . $this->job_pref . $user . '_' . $namejob)) {
			$rescheck['code'] = -1;
			$rescheck['message'] = $lang['hashmon_namejob_exist_noedit'];
		}

		$email_list = preg_split('/[\\s,;]/', $email_list);

		foreach ($email_list as $curemail) {
			if (!$this->check_value('email', $curemail)) {
				$rescheck['code'] = -1;
				$rescheck['message'] = $lang['hashmon_emaillistnotify_wrong'];
			}
		}

		if (!is_file($this->pathdata . $selmaincapt)) {
			$rescheck['code'] = -1;
			$rescheck['message'] = $lang['hashmon_notexistmaincapt'];
		}

		if (!$this->check_value('dir', $user_home . $pathtoscan)) {
			$rescheck['code'] = -1;
			$rescheck['message'] = $lang['hashmon_wrongdir_format'];
		}

		if (($act != 'add') && ($act != 'edit')) {
			$rescheck['code'] = -1;
			$rescheck['message'] = $lang['hashmon_wrong_oper'];
		}

		if (strlen($namejob) < 1) {
			$rescheck['code'] = -1;
			$rescheck['message'] = $lang['hashmon_namejob_empty'];
		}

		if (!$this->check_value('filename', $namejob)) {
			$rescheck['code'] = -1;
			$rescheck['message'] = $lang['hashmon_wrong_namejob'];
		}

		if ((stripos($namejob, '_') !== false) || (stripos($namejob, ' ') !== false)) {
			$rescheck['code'] = -1;
			$rescheck['message'] = $lang['hashmon_denyusespecsymbol'];
		}

		if (!$this->check_value('text', $includeparam)) {
			$rescheck['code'] = -1;
			$rescheck['message'] = $lang['hashmon_wrong_findonlywith'];
		}

		if (!$this->check_value('text', $excludeparam)) {
			$rescheck['code'] = -1;
			$rescheck['message'] = $lang['hashmon_wrong_findonlywithout'];
		}

		if (!$this->check_value('text', $run_period)) {
			$rescheck['code'] = -1;
			$rescheck['message'] = $lang['hashmon_wrong_period'];
		}

		if (!preg_match('/(2[0-4]|[01][0-9]|10|[0-9])/', $time_start_hour)) {
			$rescheck['code'] = -1;
			$rescheck['message'] = $lang['hashmon_wrong_timehourmin'];
		}

		if (!preg_match('/[0-5][0-9]|[0-9]/', $time_start_minute)) {
			$rescheck['code'] = -1;
			$rescheck['message'] = $lang['hashmon_wrong_timehourmin'];
		}

		if (!preg_match('@^[0-1,.]+$@uSi', $weekly_days)) {
			$rescheck['code'] = -1;
			$rescheck['message'] = $lang['hashmon_wrong_timehourmin'];
		}

		if ($run_period == 'month') {
			if (!preg_match('@^[0-9,]+$@uSi', $monthly_select_date)) {
				$rescheck['code'] = -1;
				$rescheck['message'] = $lang['hashmon_wrong_numbermonth'];
			}
		}

		$dayarr = explode(',', $monthly_select_date);
		$dayarr = array_filter(array_unique($dayarr));
		asort($dayarr);
		$monthly_select_date = implode(',', $dayarr);
		$arrconf = array('namejob' => $namejob, 'pathtoscan' => $pathtoscan, 'includeparam' => $includeparam, 'excludeparam' => $excludeparam, 'run_period' => $run_period, 'time_start_hour' => $time_start_hour, 'time_start_minute' => $time_start_minute, 'weekly_days' => $weekly_days, 'monthly_select_date' => $monthly_select_date, 'emails' => implode(',', $email_list), 'maincapt' => $selmaincapt, 'status' => $status);

		if ($rescheck['code'] != 0) {
			return $rescheck;
		}

		$this->config_save($this->pathdata . $this->job_pref . $user . '_' . $namejob, $arrconf);
		$rescheck['code'] = 0;
		$rescheck['message'] = $lang['hashmon_job_save_complete'];
		$this->updatecachecronjob($user, $namejob);
		return $rescheck;
	}

	public function findfile_mask($mask, $dir)
	{
		$files_arr = array();
		$scanfiles = scandir($dir);

		foreach ($scanfiles as $curfile) {
			if (is_file($dir . $curfile) && ($curfile != '..') && ($curfile != '.')) {
				if (stripos($curfile, $mask) !== false) {
					$files_arr[] = $dir . $curfile;
				}
			}
		}

		return $files_arr;
	}

	public function hash_loadjobs($user)
	{
		$file_jobs = $this->findfile_mask($this->job_pref . $user . '_', $this->pathdata);
		$i = 0;
		$job_arr_user = array();
		$userdata = parse_ini_file($GLOBALS['USERS_PATH'] . $user);
		$user_home = $userdata['rootdir'];

		foreach ($file_jobs as $curjob) {
			$data_job = parse_ini_file($curjob);
			$job_arr_user[$i]['namejob'] = $data_job['namejob'];
			$job_arr_user[$i]['pathtoscan'] = $data_job['pathtoscan'];
			$job_arr_user[$i]['includeparam'] = $data_job['includeparam'];
			$job_arr_user[$i]['excludeparam'] = $data_job['excludeparam'];
			$job_arr_user[$i]['run_period'] = $data_job['run_period'];
			$job_arr_user[$i]['time_start_hour'] = $data_job['time_start_hour'];
			$job_arr_user[$i]['time_start_minute'] = $data_job['time_start_minute'];
			$job_arr_user[$i]['weekly_days'] = $data_job['weekly_days'];
			$job_arr_user[$i]['monthly_select_date'] = $data_job['monthly_select_date'];
			$job_arr_user[$i]['emails'] = $data_job['emails'];
			$job_arr_user[$i]['maincapt'] = $data_job['maincapt'];
			$exp = explode('#', $data_job['maincapt']);
			$path = str_replace('_', '/', $exp[1]);
			$path = str_replace('//', '/', $path);
			$time = date('d.m.Y H:i:s', $exp[2]);
			$job_arr_user[$i]['maincapt_human'] = $path . ' - ' . $time;
			$job_arr_user[$i]['status'] = intval($data_job['status']);
			$job_arr_user[$i]['filejob'] = basename($curjob);
			++$i;
		}

		return $job_arr_user;
	}

	public function removejob($user)
	{
		$filejob = $_GET['filejob'];
		global $lang;

		if (stripos($filejob, $this->job_pref . $user . '_') === false) {
			$res['code'] = -1;
			$res['message'] = $lang['hashmon_tablejob_removedeny'];
		}
		else {
			unlink($this->pathdata . $filejob);
			$res['code'] = 0;
			$res['message'] = $lang['hashmon_tablejob_removeok'];
		}

		return $res;
	}
}


?>
