<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class hostacc
{
	public $hostacc_username;
	public $hostacc_rootdir;
	public $hostacc_plan;
	public $hostacc_disk;
	public $hostacc_ip;
	public $hostacc_pass;
	public $hostacc_bandwidth;
	public $hostacc_sites;
	public $hostacc_subdomains;
	public $hostacc_databases;
	public $hostacc_emailboxes;
	public $hostacc_mailperhour;
	public $hostacc_ftp_accounts;
	public $hostacc_shell_access;
	public $hostacc_template;
	public $hostacc_lang;
	public $hostacc_group;
	public $hostacc_owner;
	public $hostacc_dns_zones;
	public $databases_max_queries;
	public $databases_max_updates;
	public $databases_max_user_connections;
	public $databases_max_connections;
	public $ctl_max_user_task;
	public $ctl_max_user_memory;
	public $ctl_max_user_cpu;
	public $ctl_max_user_ior;
	public $ctl_max_user_iow;
	public $autoins_path = '/etc/brainy/data/users_autoins/';
	public $webserver_config_includes = '/etc/brainy/data/webserver_config/user_includes/';
	public $listdirJail = array('bin', 'dev', 'etc', 'lib64', 'usr', 'lib', 'opt', 'var', '/var/run/mysqld', 'tmpb');
	public $userDirJail = 'sites';

	public function __construct()
	{
		$this->load_cl();
	}

	public function hostacc_grouplist($username)
	{
		if (!$this->check_value('user', $username)) {
			return false;
		}
		if ($username) {
			$zapr = $username . '_*';
		}
		else {
			$zapr = '';
		}

		$out = $this->filelist($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/groups', $zapr, 'f');
		return $out;
	}

	public function hostacc_group_add($groupname, $arr)
	{
		global $lang;

		if (!$this->check_value('strdot', $groupname)) {
			$out_array['code'] = 1;
			$out_array['message'] = $lang['hostacc_error_name_group'];
			return $out_array;
		}

		$groupfields = $this->hostacc_grouplist_fields();

		foreach ($groupfields as $value) {
			$newm[$value['field']] = $value['field_level'];
		}

		foreach ($arr as $key => $value) {
			if (($value == 'y') || ($value == 'n') || ($value == '')) {
				$newarr[$key] = $value;
				$newarr[$key . '_type'] = $newm[$key];
			}
		}

		if ($groupname) {
			$out = $this->config_save($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/groups/' . $groupname, $newarr);
			return $out;
		}
	}

	public function hostacc_group_get($groupname)
	{
		if (!$this->check_value('string', $groupname)) {
			$out['code'] = -1;
			return $out;
		}
		if ($groupname) {
			if (is_file($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/groups/' . $groupname)) {
				$out = $this->config_read($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/groups/' . $groupname);
			}
			else {
				$out['code'] = -1;
			}

			return $out;
		}
	}

	public function change_name_group($groupname, $new_group_name, $sel = '')
	{
		global $lang;
		if (!$this->check_value('strdot', $groupname) || !$this->check_value('strdot', $new_group_name)) {
			$out_array['code'] = 1;
			$out_array['message'] = $lang['hostacc_error_name_group'];
			return $out_array;
		}

		if (!empty($groupname) && !empty($new_group_name)) {
			if ($sel == 'host') {
				$this->ssh('mv ' . $GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/groups/' . $groupname . ' ' . $GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/groups/' . $new_group_name);
			}
			else {
				$arr_out = $this->config_read($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/hostacc/plan_' . $groupname);
				$arr_out['name'] = $new_group_name;
				$this->config_save($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/hostacc/plan_' . $groupname, $arr_out);
				$this->ssh('mv ' . $GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/hostacc/plan_' . $groupname . ' ' . $GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/hostacc/plan_' . $new_group_name);
			}

			$arr['code'] = 0;
			$arr['message'] = $lang['hostacc_suc_change'];
		}
		else {
			$arr['code'] = 1;
			$arr['message'] = $lang['hostacc_suc_change_empty'];
		}

		return $arr;
	}

	public function hostacc_group_delete($groupname)
	{
		if (!$this->check_value('string', $groupname)) {
			return false;
		}
		if ($groupname) {
			$out = $this->remove_file_a($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/groups/' . $groupname);
			return $out;
		}
	}

	public function hostacc_grouplist_fields()
	{
		global $lang;
		$out = $this->read_file($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/groups/fields/group_fields');
		$out = explode("\n", $out);

		foreach ($out as $key => $value) {
			$foo = explode('|', $value);
			$s_key = $foo[1];
			$newmass[$key]['field'] = $foo[0];
			$newmass[$key]['field_type'] = $foo[2];
			$newmass[$key]['field_name'] = $lang[$s_key];

			if (0 < strlen(trim($foo[3]))) {
				$newmass[$key]['field_info'] = $lang[$foo[3]];
			}
			else {
				$newmass[$key]['field_info'] = 0;
			}

			$newmass[$key]['field_level'] = $foo[4];
		}

		return $newmass;
	}

	public function hostacc_grouprights($name = NULL)
	{
		if (!$this->check_value('string', $name) && $name) {
			return false;
		}
		if ($name) {
			$out = $this->config_read($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/groups/' . $name);
		}
		else {
			$out1 = $this->hostacc_grouplist_fields();

			foreach ($out1 as $value) {
				$out[$value['field'] . '_type'] = $value['field_level'];
			}
		}

		return $out;
	}

	public function hostacc_getgroup($name = 'root')
	{
		if (!$this->check_value('user', $name)) {
			return false;
		}

		$out = $this->config_read($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/users/' . $name);
		$group = $out['group'];

		if (!$group) {
			$group = 'users';
		}

		return $group;
	}

	public function hostacc_planlist($plan_username = NULL)
	{
		if ($plan_username) {
			$plan_username = $plan_username . '_';
			$zapr = 'plan_' . $plan_username . '*';
		}
		else {
			$zapr = 'plan*';
		}

		$out = $this->filelist($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/hostacc', $zapr, 'f');

		foreach ($out as $value) {
			$out1[] = str_replace('plan_', '', $value);
		}

		return $out1;
	}

	public function hostacc_addplan($edit = NULL)
	{
		global $lang;
		$out['err'] = 0;
		$out['mess'] = $lang['msg_seccess_added'];

		if (is_array($this->iplistPlan)) {
			foreach ($this->iplistPlan as $value) {
				if (!preg_match('/^(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[0-9]{2}|[0-9])(\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[0-9]{2}|[0-9])){3}$/', $value)) {
					$out['err'] = 1;
					$out['mess'] = $lang['msg_ip_wrong'];
				}
			}
		}

		if (!preg_match('|^[\\d]+$|', $this->hostacc_bandwidth)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_only_number_bandwith'];
		}

		if (!preg_match('|^[\\d]+$|', $this->hostacc_sites)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_only_number_sites'];
		}

		$this->hostacc_sites = intval($this->hostacc_sites);

		if (!preg_match('|^[\\d]+$|', $this->hostacc_dns_zones)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_only_number_dnz_zones'];
		}

		$this->hostacc_dns_zones = intval($this->hostacc_dns_zones);

		if (!preg_match('|^[\\d]+$|', $this->hostacc_databases)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_only_number_databases'];
		}

		if (intval($this->hostacc_emailboxes) == 0) {
			$val_emailboxes = 99999999;
		}
		else {
			$val_emailboxes = $this->hostacc_emailboxes;
		}

		if (!preg_match('|^[\\d]+$|', $val_emailboxes)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_only_number_mailbox'];
		}

		if (!preg_match('|^[\\d]+$|', $this->hostacc_ftp_accounts)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_only_number_ftp_acct'];
		}

		if (!preg_match('|^[\\d]+$|', $this->hostacc_disk)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_only_number_disk'];
		}

		if (!preg_match('|^[\\d]+$|', $this->databases_max_queries) && $this->databases_max_queries) {
			$out['err'] = 1;
			$out['mess'] = $lang['hostacc_error_msg_questions'];
		}

		if (!preg_match('|^[\\d]+$|', $this->databases_max_updates) && $this->databases_max_updates) {
			$out['err'] = 1;
			$out['mess'] = $lang['hostacc_error_msg_updates'];
		}

		if (!preg_match('|^[\\d]+$|', $this->databases_max_user_connections) && $this->databases_max_user_connections) {
			$out['err'] = 1;
			$out['mess'] = $lang['hostacc_error_msg_user_connections'];
		}

		if (!preg_match('|^[\\d]+$|', $this->databases_max_connections) && $this->databases_max_connections) {
			$out['err'] = 1;
			$out['mess'] = $lang['hostacc_error_msg_connections'];
		}

		if (!preg_match('@^[A-z0-9]+$@uSi', $this->hostacc_lang)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_both_lang'];
		}

		if (!preg_match('@^[A-z0-9]+$@uSi', $this->hostacc_shell_access)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_both_shell'];
		}

		if (!preg_match('/^[a-z0-9]+$/uSi', $this->hostacc_plan)) {
			$out['err'] = 1;
			$out['mess'] = $lang['hostacc_incorecly_simbol'];
		}

		if (!$this->hostacc_plan) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_both_plan'];
		}

		if ($out['err'] == 1) {
			return $out;
		}

		$already_plans = $this->hostacc_planlist();

		if ($edit) {
			if (!$this->check_value('string', $edit)) {
				return false;
			}

			if ($out['err'] == 0) {
				$out['mess'] = $lang['msg_seccess_edit'];
			}

			if ($this->hostacc_plan != $edit) {
				$this->rename_file_m('plan_' . $edit, 'plan_' . $this->hostacc_plan);
			}
		}

		if (in_array($this->hostacc_plan, $already_plans) && !$edit) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_exists_plan'];
		}

		$arr = array('name' => $this->hostacc_plan, 'bandwidth' => $this->hostacc_bandwidth, 'sites' => $this->hostacc_sites, 'dns_zones' => $this->hostacc_dns_zones, 'databases' => $this->hostacc_databases, 'emailboxes' => $this->hostacc_emailboxes, 'mailperhour' => $this->hostacc_mailperhour, 'ftp_accounts' => $this->hostacc_ftp_accounts, 'shell_access' => $this->hostacc_shell_access, 'disk' => $this->hostacc_disk, 'owner' => $this->hostacc_plan_owner, 'databases_max_queries' => $this->databases_max_queries, 'databases_max_updates' => $this->databases_max_updates, 'databases_max_user_connections' => $this->databases_max_user_connections, 'databases_max_connections' => $this->databases_max_connections, 'ip' => implode(' ', $this->iplistPlan), 'language' => $this->hostacc_lang);

		if ($out['err'] == '0') {
			$this->set_data($arr, 'plan_' . $this->hostacc_plan);
		}

		return $out;
	}

	public function hostacc_loadplan($plan)
	{
		$file = $GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/hostacc/plan_' . $plan;

		if (is_file($file)) {
			$data = $this->config_read($file);
			return array('err' => 0, 'data' => $data, 'mess' => 'Done');
		}

		return array('err' => 1, 'mess' => 'file not found');
	}

	public function hostacc_saveplan($plan, $arr, $api_permission = NULL)
	{
		global $lang;
		$perm = $this->check_permission($api_permission);

		if ($perm == '0') {
			$check['err'] = 101;
			$check['mess'] = $lang['msg_no_permission_edit'];
			return $check;
		}

		$file = $GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/hostacc/plan_' . $plan;
		$this->config_save($file, $arr, 'add');
		return array('err' => 0, 'data' => '', 'mess' => 'Done');
	}

	public function hostacc_delplan($plan, $api_permission = NULL)
	{
		global $lang;
		$perm = $this->check_permission($api_permission);

		if ($perm == '0') {
			$check['err'] = 101;
			$check['mess'] = $lang['msg_no_permission_edit'];
			return $check;
		}

		$file = $GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/hostacc/plan_' . $plan;
		$this->sudo_ssh('rm -f ' . $file . ' &>/dev/null');
		return array('err' => 0, 'mess' => 'Done');
	}

	public function hostacc_readplan($edit = NULL)
	{
		if ($edit) {
			$out = $this->load_vars_m('plan_' . $edit);
		}
		else {
			$out = $this->load_vars_m('plan_' . $this->hostacc_plan);
		}

		return $out;
	}

	public function check_permission($api_permission = NULL)
	{
		if ($api_permission == 'api') {
			return 1;
		}

		if (!$this->check_value('user', $this->hostacc_username)) {
			return false;
		}

		$out = $this->config_read($GLOBALS['USERS_PATH'] . $this->hostacc_username);
		global $server;
		$owner = $out['owner'];
		$root_rights = $server->user['group_properties']['root'];
		$is_reseller = $server->user['group_properties']['is_reseller'];
		$username = $server->user['name'];
		if (($root_rights == 'y') || (($is_reseller == 'y') && ($owner == $username))) {
			return 1;
		}

		return 0;
	}

	public function hostacc_readacc()
	{
		if (!$this->check_value('user', $this->hostacc_username)) {
			return false;
		}

		$out = $this->config_read($GLOBALS['USERS_PATH'] . $this->hostacc_username);

		if (is_array($out)) {
			$mail = new mailserver();
			$out4 = $mail->mailserver_get_exim_vars();
			$out['mailperhour'] = intval($out4['mail_per_hour_limit']);
			$disk = floatval($out['disk'] / (1024 * 1024));
			$bandwidth = $out['bandwidth'] / (1024 * 1024);
			$out['r_traffic'] = array_sum(explode('/', $out['traffic']));
			$out['h_disk'] = round($disk, 2);
			$out['h_bandwidth'] = round($bandwidth, 2);
			$out['h_r_disk'] = round($out['r_disk'], 2);
			$out['h_r_traffic'] = round($out['r_traffic'] / (1024 * 1024), 2);
		}

		return $out;
	}

	public function hostacc_user_domains()
	{
		if (!$this->check_value('user', $this->hostacc_username)) {
			return false;
		}

		$webserver = new webserver();
		$out = $webserver->get_virt_hosts($this->hostacc_username, 1);
		$out1['counter'] = count($out);
		$out1['data'] = $out;
		return $out1;
	}

	public function hostacc_user_dbs()
	{
		if (!$this->check_value('user', $this->hostacc_username)) {
			return false;
		}

		$dbusage = new dbusage();
		$out = $dbusage->mysql_count_dbs($this->hostacc_username);
		return $out;
	}

	public function hostacc_setplan()
	{
		$out = $this->hostacc_readplan();
		$arr = array('plan' => $this->hostacc_plan, 'disk' => $this->hostacc_disk, 'bandwidth' => $this->hostacc_bandwidth, 'sites' => $this->hostacc_sites, 'dns_zones' => $this->hostacc_dns_zones, 'databases' => $this->hostacc_databases, 'emailboxes' => $this->hostacc_emailboxes, 'mailperhour' => $this->hostacc_mailperhour, 'ftp_accounts' => $this->hostacc_ftp_accounts, 'shell_access' => $this->hostacc_shell_access, 'template' => $this->hostacc_template, 'language' => $this->hostacc_lang);

		if (!$this->check_value('user', $this->hostacc_username)) {
			return false;
		}

		$this->config_save($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/users/' . $this->hostacc_username, $arr, 'add');
		return $out;
	}

	public function hostacc_deleteplan()
	{
		global $lang;

		if (!$this->check_value('string', $this->hostacc_plan)) {
			return false;
		}

		$this->remove_file_m('plan_' . $this->hostacc_plan);
		return $lang['msg_done'];
	}

	public function mountMysql($basedir, $tryI = 0)
	{
		$qMount = 0;

		if (is_dir($basedir . '/var/run/mysqld')) {
			$qMount = 1;
		}

		if ($this->monitor_get_service_status('xinetd') == 'off') {
			$this->monitor_service_command('xinetd', 'restart');
		}

		$comm = 'mkdir -p ' . $basedir . '/var/run/mysqld';
		$this->ssh($comm);
		$checkExist = 'ls -al ' . $basedir . '/var/run/mysqld/mysql.sock 2>/dev/stdout';
		$resCheck = $this->ssh($checkExist)[0];
		$resMountCheck = $this->AF_Socket('checkls', 'check', $basedir . '/var/run/mysqld/mysql.sock 2>/dev/stdout');
		if (($qMount == 0) || (stripos($resCheck, 'cannot') !== false) || (stripos($resMountCheck['mess'], 'mysql.sock') === false)) {
			$resMount = $this->AF_Socket('add', '/var/run/mysqld', $basedir . '/var/run/mysqld');
		}

		$checkExist = 'ls -al ' . $basedir . '/var/run/mysqld/mysql.sock 2>/dev/stdout';
		$resCheck = $this->ssh($checkExist)[0];
		if ((stripos($resCheck, 'cannot') === false) || (stripos($resMountCheck['mess'], 'mysql.sock') !== false)) {
			return 1;
		}

		if (0 < $tryI) {
			$this->monitor_service_command('mysqld', 'restart');
			sleep(5);
		}

		return 0;
	}

	public function unMountMysql($basedir)
	{
		$qMount = 0;

		if (is_dir($basedir . '/var/run/mysqld')) {
			$qMount = 1;
		}

		$comm = 'mkdir -p ' . $basedir . '/var/run/mysqld';
		$this->ssh($comm);
		$checkExist = 'ls -al ' . $basedir . '/var/run/mysqld/mysql.sock 2>/dev/stdout';
		$resCheck = $this->ssh($checkExist)[0];
		if (($qMount == 1) || (stripos($resCheck, 'cannot') === false)) {
			$resUnmount = $this->AF_Socket('rm', '/var/run/mysqld', $basedir . '/var/run/mysqld');
		}

		$checkExist = 'ls -al ' . $basedir . '/var/run/mysqld/mysql.sock 2>/dev/stdout';
		$resCheck = $this->ssh($checkExist)[0];

		if (stripos($resCheck, 'cannot') !== false) {
			return 1;
		}

		return 0;
	}

	public function mountDirs($basedir, $pathMount, $tryI = 0)
	{
		$qMount = 0;

		if (is_dir($basedir . $pathMount)) {
			$qMount = 1;
		}

		if ($this->monitor_get_service_status('xinetd') == 'off') {
			$this->monitor_service_command('xinetd', 'restart');
		}

		$comm = 'mkdir -p ' . $basedir . $pathMount;
		$this->ssh($comm);
		$checkExist = 'ls -al ' . $basedir . $pathMount . '/bin 2>/dev/stdout';
		$resCheck = $this->ssh($checkExist)[0];
		$resMountCheck = $this->AF_Socket('checkls', 'check', $basedir . $pathMount . '/bin 2>/dev/stdout');
		if (($qMount == 0) || (stripos($resCheck, 'cannot') !== false) || (stripos($resMountCheck['mess'], 'bin') === false)) {
			$resMount = $this->AF_Socket('add', $pathMount, $basedir . $pathMount);
		}

		$checkExist = 'ls -al ' . $basedir . $pathMount . ' 2>/dev/stdout';
		$resCheck = $this->ssh($checkExist)[0];

		if (stripos($resCheck, 'cannot') === false) {
			return 1;
		}

		return 0;
	}

	public function unMountDirs($basedir, $pathMount)
	{
		$qMount = 0;

		if (is_dir($basedir . $pathMount)) {
			$qMount = 1;
		}

		$comm = 'mkdir -p ' . $basedir . $pathMount;
		$this->ssh($comm);
		$checkExist = 'ls -al ' . $basedir . $pathMount . ' 2>/dev/stdout';
		$resCheck = $this->ssh($checkExist)[0];
		if (($qMount == 1) || (stripos($resCheck, 'cannot') === false)) {
			$resUnmount = $this->AF_Socket('rm', $pathMount, $basedir . $pathMount);
		}

		$checkExist = 'ls -al ' . $basedir . $pathMount . ' 2>/dev/stdout';
		$resCheck = $this->ssh($checkExist)[0];

		if (stripos($resCheck, 'cannot') !== false) {
			return 1;
		}

		return 0;
	}

	public function createJail($basedir, $logsafe)
	{
		if ((strlen($basedir) < 2) || (stripos($basedir, $logsafe) === false)) {
			return false;
		}

		$comm = 'chown -R root:root ' . $basedir;
		$this->ssh($comm);
		$comm = 'chmod -R 755 ' . $basedir . '/var';
		$this->ssh($comm);
		$comm = 'chmod 755 ' . $basedir . '/var/run/mysqld';
		$this->ssh($comm);
		$comm = 'chmod -R 777 ' . $basedir . '/var/run/mysqld/mysql.sock';
		$this->ssh($comm);
		$comm = 'chown root:root ' . $basedir . '/var';
		$this->ssh($comm);
		$comm = 'chmod 755 ' . $basedir . '';
		$this->ssh($comm);
		$this->ssh('rm -f ' . $basedir . '/etc/passwd');
		$this->ssh('rm -f ' . $basedir . '/etc/group');
		$workspace = $this->getWorkspace($logsafe);

		if (strlen($workspace) < 1) {
			$workspace = '/';
		}
		else {
			$workspace = '/' . $workspace . '/';
		}

		$defaultHomeDir = '';

		if (strlen($workspace) < 2) {
			$defaultHomeDir = $this->userDirJail;
		}

		if (is_file('/etc/brainy/data/users/' . $logsafe)) {
			$usersConf = $this->config_read('/etc/brainy/data/users/' . $logsafe);
		}

		$cutuser = $this->ssh('cat /etc/passwd | grep ^' . $logsafe . ':');
		$cutuser = str_replace('/bin/bash', '/usr/sbin/jk_chrootsh', $cutuser[0]);
		$cutuser_part_repl = explode(':', $cutuser)[5];

		if (!isset($usersConf['rootdir'])) {
			$usersConf['rootdir'] = $cutuser_part_repl;
			$usersConf['rootdir'] = rtrim($usersConf['rootdir'], '/');
		}

		$cutuser = str_replace($cutuser_part_repl, $usersConf['rootdir'] . '/.' . $workspace . $defaultHomeDir, $cutuser);
		$this->ssh('sed -i "/^' . $logsafe . ':/c' . $cutuser . '" ' . '/etc/passwd');
		$homeDir = str_replace($logsafe, '', $basedir);
		$comm = 'mkdir ' . $basedir;
		$this->ssh($comm);
		$webserver = new webserver();
		$listphps_conf = parse_ini_file($webserver->serv_datapath . 'phps');
		$phps_list = explode(',', $listphps_conf['phplist']);

		foreach ($phps_list as $curPHP) {
			$this->ssh('jk_cp -v -f ' . $basedir . ' /etc/' . $curPHP . 'w');
			$this->mountDirs($basedir, '/usr/bin/' . $curPHP);
		}

		$comm = 'jk_init -v ' . $basedir . ' basicshell';
		$ttt = $this->ssh($comm);
		$comm = 'jk_init -v ' . $basedir . ' netutils';
		$this->ssh($comm);
		$comm = 'jk_init -v ' . $basedir . ' ssh';
		$this->ssh($comm);
		$comm = 'jk_init -v ' . $basedir . ' jk_lsh';
		$this->ssh($comm);
		$comm = 'jk_init -v ' . $basedir . ' mysql';
		$this->ssh($comm);
		$comm = 'jk_init -v ' . $basedir . ' exim';
		$this->ssh($comm);
		$comm = 'jk_jailuser -m -j ' . $basedir . ' ' . $logsafe;
		$ttt = $this->ssh($comm);
		$comm = 'jk_cp -v -f ' . $basedir . ' ' . $GLOBALS['BASH_PATH'];
		$this->ssh($comm);
		$comm = 'jk_cp -v -f ' . $basedir . ' /usr/share/zoneinfo';
		$this->ssh($comm);
		$comm = 'jk_cp -v -f ' . $basedir . ' /usr/share/snmp';
		$this->ssh($comm);
		$comm = 'jk_cp -v -f ' . $basedir . ' /usr/bin/curl';
		$this->ssh($comm);
		$comm = 'jk_cp -v -f ' . $basedir . ' /usr/bin/du';
		$this->ssh($comm);
		$comm = 'jk_cp -v -f ' . $basedir . ' /usr/bin/md5sum';
		$this->ssh($comm);
		$comm = 'jk_cp -v -f ' . $basedir . ' /usr/bin/openssl';
		$this->ssh($comm);
		$comm = 'jk_cp -v -f ' . $basedir . ' /usr/bin/stat';
		$this->ssh($comm);
		$comm = 'jk_cp -v -f ' . $basedir . ' /usr/bin/awk';
		$this->ssh($comm);
		$comm = 'jk_cp -v -f ' . $basedir . ' /etc/pki';
		$this->ssh($comm);
		$comm = 'mkdir ' . $basedir . '/lib';
		$this->ssh($comm);
		$comm = 'mkdir ' . $basedir . '/opt';
		$this->ssh($comm);
		$comm = 'mkdir -p ' . $basedir . '/var/log/exim';
		$this->ssh($comm);
		$comm = 'mkdir -p ' . $basedir . '/var/spool/exim/db';
		$this->ssh($comm);
		$comm = 'mkdir -p ' . $basedir . '/var/spool/exim/input';
		$this->ssh($comm);
		$comm = 'mkdir -p ' . $basedir . '/var/spool/exim/msglog';
		$this->ssh($comm);
		$comm = 'ln -s /usr/sbin/sendmail ' . $basedir . '/usr/bin/sendmail';
		$this->ssh($comm);
		$comm = 'ln -s /usr/sbin/exim ' . $basedir . '/usr/bin/exim';
		$this->ssh($comm);
		$resMysql = 0;
		$this->fixMysqlRights($basedir);
		$ic = 0;

		while ($ic < 3) {
			$resMysql = $this->mountMysql($basedir, $ic);

			if ($resMysql == 1) {
				break;
			}

			++$ic;
		}

		if ($resMysql == 0) {
			global $lang;
			$addout['err'] = 2;
			$addout['code'] = 299;
			$addout['message'] = $lang['hostacc_jailerrorMountMysql'];
			$addout['mess'] = $lang['hostacc_jailerrorMountMysql'];
		}

		$comm = 'mkdir -p ' . $basedir . '/etc/exim';
		$this->ssh($comm);
		$comm = 'rm -f ' . $basedir . '/etc/exim/exim.conf';
		$this->ssh($comm);
		$comm = 'rm -f ' . $basedir . '/etc/exim/block_user';
		$this->ssh($comm);
		$comm = 'cp /etc/exim/exim.conf ' . $basedir . '/etc/exim/exim.conf';
		$this->ssh($comm);
		$comm = 'cp /etc/exim/block_user ' . $basedir . '/etc/exim/block_user';
		$this->ssh($comm);
		$comm = 'rm -f ' . $basedir . '/usr/sbin/exim';
		$this->ssh($comm);
		$comm = 'cp /usr/sbin/exim ' . $basedir . '/usr/sbin';
		$this->ssh($comm);

		if (!is_link($basedir . $basedir)) {
			$comm = 'ln -s ' . '../' . ' ' . $basedir . $basedir;
			$this->ssh($comm);
		}

		$comm = 'jk_update -j ' . $basedir . ' -d';
		$this->ssh($comm);
		$comm = 'mkdir ' . $basedir . $workspace . $this->userDirJail;
		$this->ssh($comm);
		$comm = 'chown -R ' . $logsafe . ':' . $logsafe . ' ' . $basedir . $homeDir;
		$this->ssh($comm);
		$comm = 'chown ' . $logsafe . ':' . $logsafe . ' ' . $basedir . $workspace . $this->userDirJail;
		$this->ssh($comm);

		if (1 < strlen($workspace)) {
			$comm = 'chmod -R 755 ' . $basedir . $workspace;
			$this->ssh($comm);
		}
		else {
			$comm = 'chmod 755 ' . $basedir . $workspace . $this->userDirJail;
			$this->ssh($comm);
		}

		$comm = 'chmod 640 ' . $basedir . '/etc/exim/exim.conf';
		$this->ssh($comm);
		$comm = 'chmod 644 ' . $basedir . '/etc/exim/block_user';
		$this->ssh($comm);
		$comm = 'chown exim:exim ' . $basedir . '/etc/exim/block_user';
		$this->ssh($comm);
		$comm = 'chmod -R 777 ' . $basedir . '/var';
		$this->ssh($comm);
		$comm = 'chmod 755 ' . $basedir . '/var';
		$this->ssh($comm);
		$getEtcPasswdJail = file_get_contents($basedir . '/etc/passwd');
		$getEtcPasswdJail = str_replace('/usr/sbin/jk_lsh', '/bin/bash', $getEtcPasswdJail);
		file_put_contents($basedir . '/etc/passwd', $getEtcPasswdJail);
		$cut = $this->ssh('cat /etc/passwd | grep ^exim:');
		file_put_contents($basedir . '/etc/passwd', "\n" . $cut[0] . "\n", FILE_APPEND);
		$cut = $this->ssh('cat /etc/passwd | grep ^mail:');
		file_put_contents($basedir . '/etc/passwd', $cut[0] . "\n", FILE_APPEND);
		$cut = $this->ssh('cat /etc/passwd | grep ^dovecot:');
		file_put_contents($basedir . '/etc/passwd', $cut[0] . "\n", FILE_APPEND);
		$cut = $this->ssh('cat /etc/group | grep ^exim:');
		file_put_contents($basedir . '/etc/group', "\n" . $cut[0] . "\n", FILE_APPEND);
		$cut = $this->ssh('cat /etc/group | grep ^mail:');
		file_put_contents($basedir . '/etc/group', $cut[0] . "\n", FILE_APPEND);
		$cut = $this->ssh('cat /etc/group | grep ^dovecot:');
		file_put_contents($basedir . '/etc/group', $cut[0] . "\n", FILE_APPEND);
		$rcLocalFile = '/etc/rc.d/rc.local';

		if (!is_file($rcLocalFile)) {
			$rcLocalFile = '/etc/rc.local';
		}

		$resRcLocal = file_get_contents($rcLocalFile);

		if (stripos($resRcLocal, 'sleep') === false) {
			file_put_contents($rcLocalFile, "\n" . 'sleep 15' . "\n", FILE_APPEND);
		}

		if (stripos($resRcLocal, $basedir) === false) {
			file_put_contents($rcLocalFile, 'umount -l ' . $basedir . '/var/run/mysqld' . "\n", FILE_APPEND);
			file_put_contents($rcLocalFile, 'umount -f ' . $basedir . '/var/run/mysqld' . "\n", FILE_APPEND);
			file_put_contents($rcLocalFile, 'mount --bind /var/run/mysqld ' . $basedir . '/var/run/mysqld' . "\n", FILE_APPEND);
			$this->ssh('chmod +x ' . $rcLocalFile);

			foreach ($phps_list as $curPHP) {
				file_put_contents($rcLocalFile, 'umount -l ' . $basedir . '/usr/bin/' . $curPHP . "\n", FILE_APPEND);
				file_put_contents($rcLocalFile, 'mount --bind ' . '/usr/bin/' . $curPHP . ' ' . $basedir . '/usr/bin/' . $curPHP . "\n", FILE_APPEND);
			}

			file_put_contents($rcLocalFile, 'umount -l ' . $basedir . '/usr/lib64' . "\n", FILE_APPEND);
			file_put_contents($rcLocalFile, 'umount -f ' . $basedir . '/usr/lib64' . "\n", FILE_APPEND);
			file_put_contents($rcLocalFile, 'mount --bind /usr/lib64 ' . $basedir . '/usr/lib64' . "\n", FILE_APPEND);
		}

		$this->set_proper_chown($logsafe);

		foreach ($this->listdirJail as $curdirJail) {
			if ($curdirJail == 'tmpb') {
				continue;
			}

			$this->sudo_ssh('chown -R root:root ' . $basedir . '/' . $curdirJail);
		}

		foreach ($phps_list as $curPHP) {
			$this->ssh('chown -R ' . $logsafe . ':' . $logsafe . ' ' . $basedir . '/etc/' . $curPHP . 'w');
		}

		$this->ssh('chmod 4755 ' . $basedir . '/usr/sbin/sendmail');
		$this->ssh('chmod 4755 ' . $basedir . '/usr/sbin/exim');
		$this->ssh('chmod 4755 /usr/sbin/jk_chrootsh');
		$this->fixMysqlRights($basedir);
		$this->mountDirs($basedir, '/usr/lib64');

		if (!is_file($basedir . '/.ftpquota')) {
			file_put_contents($basedir . '/.ftpquota', '0 0 ' . "\n");
			$this->ssh('chown -R ' . $logsafe . ':' . $logsafe . ' ' . $basedir . '/.ftpquota/');
		}

		if (isset($addout['code'])) {
			return $addout;
		}
	}

	public function fixMysqlRights($basedir)
	{
		$comm = 'chmod 755 ' . $basedir . '/var/run/mysqld';
		$this->ssh($comm);
		$comm = 'chmod -R 777 ' . $basedir . '/var/run/mysqld/mysql.sock';
		$this->ssh($comm);
		$comm = 'chown -R mysql:mysql ' . $basedir . '/var/run/mysqld';
		$this->ssh($comm);
		$comm = 'chown -R mysql:mysql ' . $basedir . '/var/run';
		$this->ssh($comm);
	}

	public function hostacc_addunixuser()
	{
		$out['err'] = 0;

		if (!$this->check_value('user', $this->hostacc_username)) {
			return false;
		}

		$logsafe = $this->hostacc_username;
		$passsafe = $this->hostacc_pass;
		$basedir = $this->hostacc_rootdir;

		if (!$this->check_value('user', $logsafe)) {
			return false;
		}

		if (!$this->check_value('dir', $basedir)) {
			return false;
		}

		$passsafe = $this->strip_quotes_cmd_auth($passsafe);
		$comm = 'groupadd ' . $logsafe;
		$this->sudo_ssh($comm);
		$comm = 'useradd  -g ' . $logsafe . ' -d ' . $basedir . '/' . ' -m ' . $logsafe . ' -s ' . '/usr/sbin/jk_chrootsh' . ' -p $(echo \'' . $passsafe . '\' | openssl passwd -1 -stdin) ' . ' &>/dev/stdout';
		$res = $this->ssh($comm);

		if ((0 < substr_count($res[0], 'already')) && (stripos($res[0], 'the home directory already exists') === false)) {
			$out['err'] = 1;
			global $lang;
			$out['mess'] = $lang['hostacc_user_alreadyexist'];
			return $out;
		}

		$addout = $this->createJail($basedir, $logsafe);
		$autojail = $this->config_read($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/jail/main.conf');

		if ($autojail['newaccshell'] == 0) {
			$cutuser = $this->ssh('cat /etc/passwd | grep ^' . $logsafe . ':');
			$cutuser = str_replace('/usr/sbin/jk_chrootsh', '/bin/bash', $cutuser[0]);
			$this->ssh('sed -i "/^' . $logsafe . ':/c' . $cutuser . '" ' . '/etc/passwd');
			$comm = 'chown ' . $logsafe . '.' . $logsafe . ' ' . $basedir;
			$this->ssh($comm);
		}

		if (isset($addout['code'])) {
			return $addout;
		}

		return $out;
	}

	public function hostacc_createuserdir()
	{
		$this->hostacc_rootdir = $GLOBALS['HOME_PATH'] . $this->hostacc_username;

		if (is_file($GLOBALS['USERS_PATH'] . $this->hostacc_username)) {
			$confUserData = $this->config_read($GLOBALS['USERS_PATH'] . $this->hostacc_username);
			$this->hostacc_rootdir = $confUserData['rootdir'];
		}

		$logsafe = $this->hostacc_username;
		$passsafe = $this->hostacc_pass;
		$basedir = $this->hostacc_rootdir;

		if (!$this->check_value('user', $logsafe)) {
			return false;
		}

		if (!$this->check_value('dir', $basedir)) {
			return false;
		}

		$comm = ' mkdir -p ' . $basedir;
		$this->sudo_ssh($comm);
	}

	public function hostacc_setquota()
	{
		$logsafe = htmlspecialchars($this->hostacc_username, ENT_QUOTES);
		$quota = $this->hostacc_disk / 1024;

		if (!$this->check_value('user', $this->hostacc_username)) {
			return false;
		}

		if (0 < intval($quota)) {
			$comm = 'setquota -u ' . $logsafe . ' ' . $quota . ' ' . $quota . ' 0 0 -a';
			$this->sudo_ssh($comm);
		}
		else {
			$comm = 'setquota -u ' . $logsafe . ' 0 0 0 0 -a';
			$this->sudo_ssh($comm);
		}
	}

	public function hostacc_setrootmysql($edit = 0)
	{
		if (!$this->check_value('user', $this->hostacc_username)) {
			return false;
		}

		$logsafe = $this->hostacc_username;
		$chars = 'qazxswedcvfrtgbnhyujmkiolp1234567890QAZXSWEDCVFRTGBNHYUJMKIOLP';
		$max = 8;
		$size = StrLen($chars) - 1;
		$random_pass = NULL;
		$postfix = '';

		while ($max--) {
			$random_pass .= $chars[rand(0, $size)];
			$postfix .= $chars[rand(0, $size)];
		}

		$crypted_pass = $random_pass . $postfix;

		if (file_exists($GLOBALS['MYSQL_CONF_PATH'])) {
			if ($edit == 0) {
				$query = 'CREATE USER "' . $logsafe . '"@"localhost" IDENTIFIED BY "' . $crypted_pass . '"';
				$query1 = 'CREATE USER "' . $logsafe . '"@"127.0.0.1" IDENTIFIED BY "' . $crypted_pass . '"';
				$this->mysql_query_do('mysql', $query);
				$this->mysql_query_do('mysql', $query1);
				$this->set_limit_mysql($logsafe);
				$arr = array('mysql_pass' => $crypted_pass);
				$this->config_save($GLOBALS['USERS_PATH'] . $logsafe, $arr, 'add');
			}
		}
	}

	public function set_limit_mysql($user)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		if ($this->databases_max_queries) {
			$array_limits[] = 'max_questions = ' . $this->databases_max_queries;
		}
		else {
			$array_limits[] = 'max_questions = 0';
		}

		if ($this->databases_max_updates) {
			$array_limits[] = 'max_updates = ' . $this->databases_max_updates;
		}
		else {
			$array_limits[] = 'max_updates = 0';
		}

		if ($this->databases_max_user_connections) {
			$array_limits[] = 'max_user_connections = ' . $this->databases_max_user_connections;
		}
		else {
			$array_limits[] = 'max_user_connections = 0';
		}

		if ($this->databases_max_connections) {
			$array_limits[] = 'max_connections = ' . $this->databases_max_connections;
		}
		else {
			$array_limits[] = 'max_connections = 0';
		}

		$this->mysql_query_do('mysql', 'UPDATE mysql.user SET ' . implode(', ', $array_limits) . ' WHERE user=\'' . $user . '\';');
	}

	public function hostacc_changename($oldname)
	{
		if (!$this->check_value('user', $oldname)) {
			return false;
		}

		if (!$this->check_value('string', $this->hostacc_username)) {
			return false;
		}

		$this->sudo_ssh('service php55-fpm stop');
		$this->sudo_ssh('service php54-fpm stop');
		$this->sudo_ssh('service php53-fpm stop');
		$this->sudo_ssh('service php56-fpm stop');
		$this->sudo_ssh('service php70-fpm stop');
		$this->sudo_ssh('service php71-fpm stop');
		$this->sudo_ssh('service php72-fpm stop');
		$this->sudo_ssh('service php52-fpm stop');
		$this->sudo_ssh('killall -9 -u ' . $oldname);
		$this->sudo_ssh('sleep 3');
		$this->sudo_ssh('usermod -l ' . $this->hostacc_username . ' ' . $oldname);
		$this->sudo_ssh('groupadd ' . $this->hostacc_username);
		$this->sudo_ssh('usermod -g ' . $this->hostacc_username . ' ' . $this->hostacc_username);
		$this->sudo_ssh('groupdel ' . $oldname);
		$this->rename_file_a($GLOBALS['USERS_PATH'] . $oldname, $GLOBALS['USERS_PATH'] . $this->hostacc_username);
		$arr = array('username' => $this->hostacc_username);
		$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
		$out1 = $this->config_read($GLOBALS['USERS_PATH'] . $this->hostacc_username);
		$olddir = $out1['rootdir'];
		$homeDir = str_replace($oldname, '', $olddir);
		$newdir = $homeDir . $this->hostacc_username;
		$this->hostacc_changedir($olddir, $newdir);
		$this->sudo_ssh('usermod -d ' . $this->hostacc_rootdir . ' ' . $this->hostacc_username);

		if (file_exists('/etc/php53w/php-fpm.d/' . $oldname . '.conf')) {
			rename('/etc/php53w/php-fpm.d/' . $oldname . '.conf', '/etc/php53w/php-fpm.d/' . $this->hostacc_username . '.conf');
			$this->sudo_ssh('replace \'' . $oldname . '\' \'' . $this->hostacc_username . '\' -- \'/etc/php53w/php-fpm.d/\'.' . $this->hostacc_username . '.\'.conf\'');
		}

		if (file_exists('/etc/php54w/php-fpm.d/' . $oldname . '.conf')) {
			rename('/etc/php54w/php-fpm.d/' . $oldname . '.conf', '/etc/php54w/php-fpm.d/' . $this->hostacc_username . '.conf');
			$this->sudo_ssh('replace \'' . $oldname . '\' \'' . $this->hostacc_username . '\' -- \'/etc/php54w/php-fpm.d/\'.' . $this->hostacc_username . '.\'.conf\'');
		}

		if (file_exists('/etc/php55w/php-fpm.d/' . $oldname . '.conf')) {
			rename('/etc/php55w/php-fpm.d/' . $oldname . '.conf', '/etc/php55w/php-fpm.d/' . $this->hostacc_username . '.conf');
			$this->sudo_ssh('replace \'' . $oldname . '\' \'' . $this->hostacc_username . '\' -- \'/etc/php55w/php-fpm.d/\'.' . $this->hostacc_username . '.\'.conf\'');
		}

		if (file_exists('/etc/php56w/php-fpm.d/' . $oldname . '.conf')) {
			rename('/etc/php56w/php-fpm.d/' . $oldname . '.conf', '/etc/php56w/php-fpm.d/' . $this->hostacc_username . '.conf');
			$this->sudo_ssh('replace \'' . $oldname . '\' \'' . $this->hostacc_username . '\' -- \'/etc/php56w/php-fpm.d/\'.' . $this->hostacc_username . '.\'.conf\'');
		}

		if (file_exists('/etc/php70w/php-fpm.d/' . $oldname . '.conf')) {
			rename('/etc/php70w/php-fpm.d/' . $oldname . '.conf', '/etc/php70w/php-fpm.d/' . $this->hostacc_username . '.conf');
			$this->sudo_ssh('replace \'' . $oldname . '\' \'' . $this->hostacc_username . '\' -- \'/etc/php70w/php-fpm.d/\'.' . $this->hostacc_username . '.\'.conf\'');
		}

		if (file_exists('/etc/php71w/php-fpm.d/' . $oldname . '.conf')) {
			rename('/etc/php71w/php-fpm.d/' . $oldname . '.conf', '/etc/php71w/php-fpm.d/' . $this->hostacc_username . '.conf');
			$this->sudo_ssh('replace \'' . $oldname . '\' \'' . $this->hostacc_username . '\' -- \'/etc/php71w/php-fpm.d/\'.' . $this->hostacc_username . '.\'.conf\'');
		}

		if (file_exists('/etc/php72w/php-fpm.d/' . $oldname . '.conf')) {
			rename('/etc/php72w/php-fpm.d/' . $oldname . '.conf', '/etc/php72w/php-fpm.d/' . $this->hostacc_username . '.conf');
			$this->sudo_ssh('replace \'' . $oldname . '\' \'' . $this->hostacc_username . '\' -- \'/etc/php72w/php-fpm.d/\'.' . $this->hostacc_username . '.\'.conf\'');
		}

		$this->sudo_ssh('replace \'' . $oldname . '\' \'' . $this->hostacc_username . '\' -- \'/etc/php52w/php-fpm.conf\'');
		$this->sudo_ssh('service php55-fpm start');
		$this->sudo_ssh('service php54-fpm start');
		$this->sudo_ssh('service php53-fpm start');
		$this->sudo_ssh('service php56-fpm start');
		$this->sudo_ssh('service php70-fpm start');
		$this->sudo_ssh('service php71-fpm start');
		$this->sudo_ssh('service php72-fpm start');
		$this->sudo_ssh('service php52-fpm start');
		$this->sudo_ssh('find /etc/brainy/data/vhosts -type f -exec replace \'="' . $oldname . '"\' \'="' . $this->hostacc_username . '"\' -- {} \\;');
		$this->sudo_ssh('find /etc/brainy/data/vhosts -type f -exec replace \'/' . $oldname . '/\' \'/' . $this->hostacc_username . '/\' -- {} \\;');
		$this->sudo_ssh('find /etc/brainy/data/apacserver -type f -name "*.db" -exec replace \'|' . $oldname . '|\' \'|' . $this->hostacc_username . '|\' -- {} \\;');
		$db = new dbusage();
		$db_users = $db->mysql_get_users_n($oldname);

		foreach ($db_users as $value) {
			$newvalue = str_replace($oldname . '_', $this->hostacc_username . '_', $value);
			$db->mysql_rename_user($value, $newvalue);
			$this->sudo_ssh('find ' . $newdir . ' -type f -exec sed -i s/' . $value . '/' . $newvalue . '/g {} +');
		}

		$db->mysql_rename_user($oldname, $this->hostacc_username);
		$dbs = $db->mysql_get_dbs($oldname);

		foreach ($dbs as $value) {
			$newvalue = str_replace($oldname . '_', $this->hostacc_username . '_', $value);
			$db->mysql_rename_database($value, $newvalue);
			$this->sudo_ssh('find ' . $newdir . ' -type f -exec sed -i s/' . $value . '/' . $newvalue . '/g {} +');
		}

		$user_info = new user_info();
		$user_info->edit_user($oldname, 'rename_user', '', $this->hostacc_username);
		$ftp = new ftp();
		$ftp->rename_ftp_prefix($oldname, $this->hostacc_username);
		$out = $this->sudo_ssh('ls -l /etc/brainy/data/users_autoins/' . $oldname . '_* | awk \'{print $9}\'');

		foreach ($out as $value) {
			$this->sudo_ssh('replace \'/' . $oldname . '/\' \'/' . $this->hostacc_username . '/\' -- ' . $value);
			$this->sudo_ssh('replace \'' . $oldname . '_\' \'' . $this->hostacc_username . '_\' -- ' . $value);
		}

		$this->mass_rename('/etc/brainy/data/users_autoins', $oldname . '_', $this->hostacc_username . '_');
		$this->sudo_ssh('replace \'' . $oldname . '_\' \'/' . $this->hostacc_username . '_\' -- /etc/brainy/data/users_autoins/' . $oldname . '.conf');
		$this->sudo_ssh('replace \'/' . $oldname . '/\' \'/' . $this->hostacc_username . '/\' -- /etc/brainy/data/users_autoins/' . $oldname . '.conf');

		if (file_exists('/etc/brainy/data/users_autoins/' . $oldname . '.conf')) {
			rename('/etc/brainy/data/users_autoins/' . $oldname . '.conf', '/etc/brainy/data/users_autoins/' . $this->hostacc_username . '.conf');
		}

		$this->sudo_ssh('/etc/brainy/ssh/mailserver/mail.sh change_owner ' . $this->hostacc_username . ' ' . $oldname);
		$this->sudo_ssh('replace \':' . $oldname . ':\' \':' . $this->hostacc_username . ':\' -- /etc/brainy/ssh/named/user.db');

		if (file_exists('/etc/brainy/data/webserver_config/user_includes/' . $oldname)) {
			rename('/etc/brainy/data/webserver_config/user_includes/' . $oldname, '/etc/brainy/data/webserver_config/user_includes/' . $this->hostacc_username);
		}

		$crontab = new crontab();
		$crontab->crontab_load($this->hostacc_username);

		if (file_exists('/etc/certs/' . $oldname)) {
			rename('/etc/certs/' . $oldname, '/etc/certs/' . $this->hostacc_username);
		}

		$this->sudo_ssh('find /etc/brainy/data/traffic_usage -type f -exec replace \'' . $oldname . ':\' \'' . $this->hostacc_username . ':\' -- {} \\;');
		$this->sudo_ssh('find /etc/brainy/data/d_average_load -type f -name "*.tdb" -exec replace \'' . $oldname . '|\' \'' . $this->hostacc_username . '|\' -- {} \\;');

		if (file_exists('/etc/brainy/data/monitor/xdata_' . $oldname)) {
			rename('/etc/brainy/data/monitor/xdata_' . $oldname, '/etc/brainy/data/monitor/xdata_' . $this->hostacc_username);
		}

		if (file_exists('/etc/brainy/data/antivirus/history/' . $oldname)) {
			rename('/etc/brainy/data/antivirus/history/' . $oldname, '/etc/brainy/data/antivirus/history/' . $this->hostacc_username);
		}

		$out = $this->sudo_ssh('ls -l /etc/brainy/data/backup/' . $oldname . '_*.conf | awk \'{print $9}\'');

		foreach ($out as $value) {
			$foo = $this->config_read($value);
			$path = $foo['backup_pathlocal'];
			$this->mass_rename($path, $oldname . '_', $this->hostacc_username . '_');
		}

		$this->sudo_ssh('find /etc/brainy/data/backup -type f -exec replace \'"' . $oldname . '"\' \'"' . $this->hostacc_username . '"\' -- {} \\;');
		$this->sudo_ssh('find /etc/brainy/data/backup -type f -exec replace \'/' . $oldname . '/\' \'/' . $this->hostacc_username . '/\' -- {} \\;');
		$this->sudo_ssh('find /etc/brainy/data/backup -type f -exec replace \'' . $oldname . '_\' \'' . $this->hostacc_username . '_\' -- {} \\;');

		if (file_exists('/etc/brainy/data/backup/backuplistcache-' . $oldname)) {
			unlink('/etc/brainy/data/backup/backuplistcache-' . $oldname);
		}

		if (file_exists('/etc/brainy/data/backup/listconfcache-' . $oldname)) {
			unlink('/etc/brainy/data/backup/listconfcache-' . $oldname);
		}

		if (file_exists('/etc/brainy/data/backup/log/' . $oldname . '.conf')) {
			rename('/etc/brainy/data/backup/log/' . $oldname . '.conf', '/etc/brainy/data/backup/log/' . $this->hostacc_username . '.conf');
		}

		$this->mass_rename('/etc/brainy/data/backup', $oldname . '_', $this->hostacc_username . '_');
		$this->mass_rename('/etc/brainy/data/backup/stream', $oldname . '_', $this->hostacc_username . '_');
		$out_block = $this->read_file_n('/etc/brainy/data/mailclient/block_user');

		foreach ($out_block as $val_out) {
			if (trim($val_out) === trim($oldname)) {
				$status_block = 1;
				$this->ssh('sed -i \'/^' . trim($oldname) . '$/d\' /etc/brainy/data/mailclient/block_user');
			}
		}

		if ($status_block) {
			$this->write_file($this->hostacc_username . PHP_EOL, '/etc/brainy/data/mailclient/block_user', 'wb');
			$this->ssh('cp -f /etc/brainy/data/mailclient/block_user /etc/exim/block_user');
		}

		$webserver = new webserver();
		$domains = $this->hostacc_user_domains();

		if (is_array($domains['data'])) {
			foreach ($domains['data'] as $domain) {
				$webserver->webserver_convert_domain($domain['domain']);
			}
		}
	}

	public function getWorkspace($username)
	{
		$user_info = $this->config_read($GLOBALS['USERS_PATH'] . '/' . $username);
		$conf_prorerties = $this->config_read($GLOBALS['PROPERTIES_CONF']);
		$workspace = '';

		if ($conf_prorerties['workspace'] == 1) {
			if (isset($user_info['workspace']) && (0 < strlen($user_info['workspace']))) {
				$workspace = $user_info['workspace'];
			}
			else {
				$workspace = '';
				if (!is_file($GLOBALS['USERS_PATH'] . '/' . $username) || !isset($user_info['workspace'])) {
					$workspace = $conf_prorerties['workspace_value'];
				}
			}
		}

		return $workspace;
	}

	public function hostacc_changedir($oldpath, $newdir)
	{
		if (!$this->check_value('dir', $newdir) || !$this->check_value('dir', $oldpath)) {
			return false;
		}

		if (!$this->check_value('user', $this->hostacc_username)) {
			return false;
		}

		$workspace = $this->getWorkspace($this->hostacc_username);
		$this->rename_dir($oldpath, $newdir);
		$this->sudo_ssh('usermod -m ' . $newdir . ' ' . $this->hostacc_username);
		$arr = array('rootdir' => $newdir);
		$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
		$this->sudo_ssh('chown -R ' . $this->hostacc_username . '.' . $this->hostacc_username . ' ' . $newdir . '/' . $workspace . '/' . $this->userDirJail);
		$this->hostacc_rootdir = $newdir;
		$this->sudo_ssh('chmod 4755 ' . $newdir . '/usr/sbin/sendmail');
		$this->sudo_ssh('chmod 4755 ' . $newdir . '/usr/sbin/exim');
	}

	public function hostacc_changepass($newpass)
	{
		global $lang;

		if (strlen($newpass) < 7) {
			$out['code'] = 1;
			$out['message'] = $lang['msg_done_pass'];
			return $out;
		}

		$newpass = $this->strip_quotes_cmd_auth($newpass);

		if (!$this->check_value('user_exist', $this->hostacc_username)) {
			return false;
		}
		if ($newpass) {
			$this->sudo_ssh('usermod  -p $(echo \'' . $newpass . '\' | openssl passwd -1 -stdin) ' . $this->hostacc_username);
			$this->hostacc_pass = $newpass;
			$passhash = $this->cryptmainfunc($newpass, $GLOBALS['cryptkeymain']);
			$arr = array('last_modify_date' => time(), 'passhash' => $passhash);
			$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
			$res['code'] = 0;
			$res['message'] = $lang['hostacc_change_pass_exec_ok'];
			return $res;
		}
	}

	public function hostaccChangeIP($username, $newip)
	{
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $username);
		$out = $this->ssh('ls -l ' . $confUser['rootdir'] . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'] . '/*.conf | awk \'{print $9}\'');

		foreach ($out as $value) {
			$this->ssh('sed -i "/ip=/cip=\\"' . $newip . '\\"" ' . $value);
		}

		$this->ssh('sed -i "/ip=/cip=\\"' . $newip . '\\"" ' . $GLOBALS['USERS_PATH'] . $username);
	}

	public function hostacc_edit($edit, $api_permission = NULL)
	{
		global $lang;
		$this->hostacc_disk = $this->hostacc_disk * 1024 * 1024;
		$this->hostacc_bandwidth = $this->hostacc_bandwidth * 1024 * 1024;
		$param_all = $this->hostacc_readacc();
		$check = $this->check_data_entered(1);
		$this->hostacc_ip = implode(' ', $this->hostacc_ip);

		if ($check['err'] != 0) {
			return json_encode($check);
		}

		$perm = $this->check_permission($api_permission);

		if ($perm == '0') {
			$check['err'] = 101;
			$check['mess'] = $lang['msg_no_permission_edit'];
			return json_encode($check);
		}

		if (!$this->check_value('user', $edit)) {
			return false;
		}

		if (!$this->check_value('user', $this->hostacc_username)) {
			return false;
		}

		$out = $this->hostacc_readacc($edit);
		$old_ips = explode(' ', $out['ip']);
		$new_ips = explode(' ', $this->hostacc_ip);
		$ipma = new ipmanager();
		$webserver = new webserver();
		$user_doms = $webserver->get_virt_hosts($edit);
		$ip_doms_use_namedom = array();
		$all_dom_count = 0;

		foreach ($user_doms as $cur_dom) {
			$ipuse = parse_ini_file($GLOBALS['DATA_VHOSTS'] . $cur_dom['domain'] . '.conf')['ip'];
			$ip_doms_use[] = $ipuse;
			$ip_doms_use_namedom[$ipuse][$all_dom_count] = $cur_dom['domain'];
			++$all_dom_count;
		}

		$del_ip_fail = 0;

		foreach ($old_ips as $one_old_ip) {
			if (!in_array($one_old_ip, $new_ips)) {
				if (in_array($one_old_ip, $ip_doms_use)) {
					$ip_cant_del['ip'][$del_ip_fail] = $one_old_ip;
					$ip_cant_del['dom'][$del_ip_fail] = implode(',', $ip_doms_use_namedom[$one_old_ip]);
					++$del_ip_fail;
				}
			}
		}

		if (0 < $del_ip_fail) {
			if (($this->confirmipchange == 1) && ($this->ipchange_on != '0')) {
				$arr_vhost_upd = array('ip' => $this->ipchange_on);

				foreach ($ip_cant_del['dom'] as $curdom) {
					$dom_exp = explode(',', $curdom);

					foreach ($dom_exp as $curdom_one) {
						$this->config_save('/etc/brainy/data/vhosts/' . $curdom_one . '.conf', $arr_vhost_upd, 'add');
						$webserver->webserver_convert_domain($curdom_one);
					}
				}
			}
			else {
				$mess_fail = $lang['hostacc_delete_ip_from_acc_failed'];
				$mess_fail = str_replace('{ips}', implode('| ', $ip_cant_del['ip']), $mess_fail);
				$mess_fail = str_replace('{domains}', implode('| ', $ip_cant_del['dom']), $mess_fail);
				$check['err'] = 102;
				$check['mess'] = $mess_fail;
				return json_encode($check);
			}
		}

		$this->hostacc_rootdir = $out['rootdir'];
		$olddir = $this->hostacc_rootdir;

		if ($edit != $this->hostacc_username) {
			$this->hostacc_changename($edit);
		}

		if ($out['disk'] != $this->hostacc_disk) {
			$this->hostacc_setquota();
		}

		if ($this->hostacc_pass) {
			$this->hostacc_changepass($this->hostacc_pass);
			$this->hostacc_setrootmysql(1);
			$passhash = $this->cryptmainfunc($this->hostacc_pass, $GLOBALS['cryptkeymain']);
		}

		$this->set_limit_mysql($this->hostacc_username);
		$arr = array('username' => $this->hostacc_username, 'rootdir' => $this->hostacc_rootdir, 'plan' => $this->hostacc_plan, 'disk' => $this->hostacc_disk, 'bandwidth' => $this->hostacc_bandwidth, 'sites' => $this->hostacc_sites, 'dns_zones' => $this->hostacc_dns_zones, 'databases' => $this->hostacc_databases, 'emailboxes' => $this->hostacc_emailboxes, 'mailperhour' => $this->hostacc_mailperhour, 'ftp_accounts' => $this->hostacc_ftp_accounts, 'shell_access' => $this->hostacc_shell_access, 'template' => $this->hostacc_template, 'language' => $this->hostacc_lang, 'ip' => $this->hostacc_ip, 'group' => $this->hostacc_group, 'databases_max_queries' => intval($this->databases_max_queries), 'databases_max_updates' => intval($this->databases_max_updates), 'databases_max_user_connections' => intval($this->databases_max_user_connections), 'databases_max_connections' => intval($this->databases_max_connections), 'ctl_max_user_task' => intval($this->ctl_max_user_task), 'ctl_max_user_memory' => intval($this->ctl_max_user_memory), 'ctl_max_user_cpu' => intval($this->ctl_max_user_cpu), 'ctl_max_user_ior' => intval($this->ctl_max_user_ior), 'ctl_max_user_iow' => intval($this->ctl_max_user_iow), 'last_modify_date' => time());

		if (isset($passhash)) {
			$arr['passhash'] = $passhash;
		}

		$ip = $this->hostacc_ip;

		if (3 < strlen($ip)) {
			$ipmanager = new ipmanager();
			$ips = preg_split('/[\\s,;]/', $ip);

			foreach ($ips as $ip_cur) {
				$nn = $ipmanager->ipmanager_check_ip_status($ip_cur);

				if ($nn == 0) {
					$this->del_string_new($ip_cur . '|', $GLOBALS['IPMANAGER_LISTIPS']);
					file_put_contents($GLOBALS['IPMANAGER_LISTIPS'], $ip_cur . '|1' . "\n", FILE_APPEND | LOCK_EX);
				}
			}
		}

		$this->switch_shell_onoff();

		if (!$this->check_value('user', $this->hostacc_username)) {
			return false;
		}

		$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
		$this->hostacc_delctl($this->hostacc_username);

		if ($GLOBALS['v2'] == 'yes') {
			if ((0 < intval($this->ctl_max_user_task)) || (0 < intval($this->ctl_max_user_memory)) || (0 < intval($this->ctl_max_user_cpu))) {
				$this->hostacc_setctl($this->hostacc_username);
			}
		}

		$ip = $param_all['ip'];

		if (3 < strlen($ip)) {
			$ipmanager = new ipmanager();
			$ips = preg_split('/[\\s,;]/', $ip);

			foreach ($ips as $ip_cur) {
				$nn = $ipmanager->ipmanager_check_ip_status($ip_cur);

				if ($nn == 0) {
					$this->del_string_new($ip_cur . '|', $GLOBALS['IPMANAGER_LISTIPS']);
					file_put_contents($GLOBALS['IPMANAGER_LISTIPS'], $ip_cur . '|0' . "\n", FILE_APPEND | LOCK_EX);
				}
			}
		}

		return json_encode($check);
	}

	public function check_data_entered($edit = NULL)
	{
		global $lang;
		$out['err'] = 0;
		$out['mess'] = $lang['msg_everything_good'];

		if (!$this->hostacc_shell_access) {
			$this->hostacc_shell_access = 'n';
		}

		if (!$this->hostacc_lang) {
			$this->hostacc_shell_access = 'default';
		}

		if (is_array($this->hostacc_ip)) {
			foreach ($this->hostacc_ip as $value) {
				if (!preg_match('/^(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[0-9]{2}|[0-9])(\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[0-9]{2}|[0-9])){3}$/', $value)) {
					$out['err'] = 1;
					$out['mess'] = $lang['msg_ip_wrong'];
				}
			}
		}

		if (!preg_match('|^[\\d]+$|', $this->hostacc_bandwidth)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_only_number_bandwith'];
		}

		if (!preg_match('|^[\\d]+$|', $this->hostacc_sites)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_only_number_sites'];
		}

		if (!preg_match('|^[\\d]+$|', $this->hostacc_dns_zones)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_only_number_dnz_zones'];
		}

		if (!preg_match('|^[\\d]+$|', $this->hostacc_databases)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_only_number_databases'];
		}

		if (!preg_match('|^[\\d]+$|', $this->hostacc_emailboxes)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_only_number_mailbox'];
		}

		if (!preg_match('|^[\\d]+$|', $this->hostacc_mailperhour)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_only_number_mailperhour'];
		}

		if (!preg_match('|^[\\d]+$|', $this->hostacc_ftp_accounts)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_only_number_ftp_acct'];
		}

		if (!preg_match('@^[A-z0-9]+$@uSi', $this->hostacc_lang)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_both_lang'];
		}

		if (!preg_match('@^[A-z0-9]+$@uSi', $this->hostacc_shell_access)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_both_shell'];
		}

		if (!preg_match('|^[\\d]+$|', $this->databases_max_queries) && $this->databases_max_queries) {
			$out['err'] = 1;
			$out['mess'] = $lang['hostacc_error_msg_questions'];
		}

		if (!preg_match('|^[\\d]+$|', $this->databases_max_updates) && $this->databases_max_updates) {
			$out['err'] = 1;
			$out['mess'] = $lang['hostacc_error_msg_updates'];
		}

		if (!preg_match('|^[\\d]+$|', $this->databases_max_user_connections) && $this->databases_max_user_connections) {
			$out['err'] = 1;
			$out['mess'] = $lang['hostacc_error_msg_user_connections'];
		}

		if (!preg_match('|^[\\d]+$|', $this->databases_max_connections) && $this->databases_max_connections) {
			$out['err'] = 1;
			$out['mess'] = $lang['hostacc_error_msg_connections'];
		}

		if (($edit == NULL) || $this->hostacc_pass) {
			if (strlen($this->hostacc_pass) < 7) {
				$out['err'] = 1;
				$out['mess'] = $lang['msg_done_pass'];
			}
		}

		if ((strlen($this->hostacc_username) == 0) || (8 < strlen($this->hostacc_username))) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_done_username'];
		}

		if (!preg_match('|^[A-Z0-9]{3,}$|i', $this->hostacc_username)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_both_username'];
		}

		if ($this->hostacc_group && !preg_match('@^[A-z0-9-]+$@uSi', $this->hostacc_group)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_both_group'];
		}

		if (!preg_match('@^[A-z0-9]+$@uSi', $this->hostacc_lang)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_both_lang'];
		}

		if ($this->hostacc_template && !preg_match('@^[A-z0-9]+$@uSi', $this->hostacc_template)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_both_template'];
		}

		if (!preg_match('|^[A-Z0-9]+$|i', $this->hostacc_username)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_both_username'];
		}

		if ($this->hostacc_plan && !preg_match('@^[A-z0-9]+$@uSi', $this->hostacc_plan)) {
			$out['err'] = 1;
			$out['mess'] = $lang['msg_both_plan'];
		}

		if (($this->ipchange_on != '0') && ($this->confirmipchange != '0')) {
			if ($this->check_params('ip', $this->ipchange_on) == false) {
				$out['err'] = 1;
				$out['mess'] = $lang['msg_ip_wrong'];
			}
		}

		return $out;
	}

	public function hostacc_add()
	{
		global $lang;
		$this->hostacc_disk = $this->hostacc_disk * 1024 * 1024;
		$this->hostacc_bandwidth = $this->hostacc_bandwidth * 1024 * 1024;
		$check = $this->check_data_entered();

		if ($check['err'] != 0) {
			return json_encode($check);
		}

		if (strlen($this->hostacc_rootdir) < 2) {
			$this->hostacc_rootdir = $GLOBALS['HOME_PATH'] . $this->hostacc_username;
		}

		if (is_file($GLOBALS['USERS_PATH'] . $this->hostacc_username)) {
			$confUserData = $this->config_read($GLOBALS['USERS_PATH'] . $this->hostacc_username);
			$this->hostacc_rootdir = $confUserData['rootdir'];
		}

		$check2 = $this->hostacc_addunixuser();

		if ($check2['code'] != 299) {
			if ($check2['err'] != 0) {
				return json_encode($check2);
			}
		}

		if (is_array($this->hostacc_ip)) {
			$this->hostacc_ip = implode(' ', $this->hostacc_ip);
		}
		else {
			$this->hostacc_ip = $this->hostacc_ip;
		}

		$this->hostacc_createuserdir();
		$this->hostacc_setrootmysql();
		$this->hostacc_setquota();

		if (!$this->hostacc_owner) {
			$this->hostacc_owner = 'root';
		}

		if (!$this->check_params('user', $this->hostacc_owner) && ($this->hostacc_owner != 'root')) {
			$addout['err'] = 1;
			$addout['mess'] = $lang['hostacc_error_no_user'];
			return json_encode($addout);
		}

		$plan = $this->hostacc_plan;

		if (empty($plan)) {
			$plansafe = 'none';
		}
		else {
			$plansafe = $this->hostacc_plan;
		}

		if (!$this->hostacc_ip || ($this->hostacc_ip == '')) {
			$ip_list = $this->ipmanager_listips();
			$this->hostacc_ip = $ip_list[0]['ip'];
		}

		$conf_prorerties = $this->config_read($GLOBALS['PROPERTIES_CONF']);
		$workspace = '';

		if ($conf_prorerties['workspace'] == 1) {
			$workspace = $this->getWorkspace($this->hostacc_username);
		}

		$passhash = $this->cryptmainfunc($this->hostacc_pass, $GLOBALS['cryptkeymain']);
		$autojail = $this->config_read($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/jail/main.conf');

		if ($GLOBALS['v2'] == 'yes') {
			if ((0 < intval($this->ctl_max_user_task)) || (0 < intval($this->ctl_max_user_memory)) || (0 < intval($this->ctl_max_user_cpu))) {
				$this->hostacc_setctl($this->hostacc_username);
			}
		}

		$arr = array('username' => $this->hostacc_username, 'rootdir' => $this->hostacc_rootdir, 'plan' => $plansafe, 'disk' => floatval($this->hostacc_disk), 'bandwidth' => floatval($this->hostacc_bandwidth), 'sites' => intval($this->hostacc_sites), 'dns_zones' => intval($this->hostacc_dns_zones), 'databases' => intval($this->hostacc_databases), 'emailboxes' => intval($this->hostacc_emailboxes), 'mailperhour' => intval($this->hostacc_mailperhour), 'ftp_accounts' => intval($this->hostacc_ftp_accounts), 'shell_access' => $this->hostacc_shell_access, 'template' => $this->hostacc_template, 'language' => $this->hostacc_lang, 'ip' => $this->hostacc_ip, 'group' => $this->hostacc_group, 'adding_date' => time(), 'owner' => $this->hostacc_owner, 'passhash' => $passhash, 'last_modify_date' => time(), 'jailstatset' => intval($autojail['newaccshell']), 'jailstatsetphp' => intval($autojail['newaccphp']), 'databases_max_queries' => intval($this->databases_max_queries), 'databases_max_updates' => intval($this->databases_max_updates), 'databases_max_user_connections' => intval($this->databases_max_user_connections), 'databases_max_connections' => intval($this->databases_max_connections), 'workspace' => $workspace, 'ctl_max_user_task' => intval($this->ctl_max_user_task), 'ctl_max_user_memory' => intval($this->ctl_max_user_memory), 'ctl_max_user_cpu' => intval($this->ctl_max_user_cpu), 'ctl_max_user_ior' => intval($this->ctl_max_user_ior), 'ctl_max_user_iow' => intval($this->ctl_max_user_iow));
		$this->config_save($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/users/' . $this->hostacc_username, $arr, 'add');
		$this->set_userdir_tree();
		$this->set_proper_chown();
		$this->set_proper_chmod();
		$this->switch_shell_onoff();

		if (3 < strlen($this->hostacc_ip)) {
			$ip_exp = explode(' ', $this->hostacc_ip);

			foreach ($ip_exp as $curipcheck) {
				$this->del_string_new($curipcheck . '|', $GLOBALS['IPMANAGER_LISTIPS']);
				file_put_contents($GLOBALS['IPMANAGER_LISTIPS'], $curipcheck . '|1' . "\n", FILE_APPEND);
			}
		}

		$user_info = new user_info();
		$user_info->edit_user($this->hostacc_username, 'add_user');
		$addout['err'] = 0;
		$addout['mess'] = $lang['hostacc_successf_add'];
		require_once '/etc/brainy/classes/ftp.php';
		$ftp = new ftp();
		$workspace = $this->getWorkspace($this->hostacc_username);
		$userparam['name'] = $this->hostacc_username;
		$userparam['rootdir'] = $this->hostacc_rootdir . '/' . $workspace . '/sites';
		$userparam['rootdir'] = preg_replace('/(\\/+)/', '/', $userparam['rootdir']);
		$jsonData['login'] = $this->hostacc_username;
		$jsonData['pass'] = $this->hostacc_pass;
		$jsonData['ftp_user_quota'] = floatval($this->hostacc_disk) / 1024 / 1024;
		$jsonData['ftp_user_dir'] = '';
		$jsonData['mainuser'] = 1;
		$resftp = $ftp->ftp_user_add($userparam, json_encode($jsonData, 1));

		if ($check2['code'] == 299) {
			return json_encode($check2);
		}

		return json_encode($addout);
	}

	public function hostacc_setctl($user = '')
	{
		if ($user == '') {
			return -1;
		}

		$id = trim(implode("\n", $this->ssh('id -u ' . $user . ' | xargs')));
		if (($id < 100) || ($id == '')) {
			return -1;
		}

		$dir = '/usr/lib/systemd/system/user-' . $id . '.slice.d';
		$dir_f = $dir . '/10-defaults.conf';
		$this->ssh('rm -f ' . $dir_f);
		$this->ssh('rm -r ' . $dir);
		$this->ssh('mkdir -p ' . $dir);
		$this->ssh('cp /etc/brainy/src/third_party/systemctl/10-defaults.conf ' . $dir_f);

		if (0 < intval($this->ctl_max_user_task)) {
			$update = 'TasksMax=' . intval($this->ctl_max_user_task);
			$this->ssh('sed -i "/#TasksMax/c' . $update . '" ' . $dir_f);
		}

		if (0 < intval($this->ctl_max_user_cpu)) {
			$update = 'CPUQuota=' . intval($this->ctl_max_user_cpu) . '%';
			$this->ssh('sed -i "/#CPUQuota/c' . $update . '" ' . $dir_f);
		}

		if (0 < intval($this->ctl_max_user_memory)) {
			$update = 'MemoryLimit=' . intval($this->ctl_max_user_memory) . 'M';
			$this->ssh('sed -i "/#MemoryLimit/c' . $update . '" ' . $dir_f);
		}

		if (0 < intval($this->ctl_max_user_ior)) {
			$update = 'IOr=' . intval($this->ctl_max_user_ior) . 'bytes';
			$this->ssh('sed -i "/#IOr/c' . $update . '" ' . $dir_f);
		}

		if (0 < intval($this->ctl_max_user_iow)) {
			$update = 'IOw=' . intval($this->ctl_max_user_iow) . 'bytes';
			$this->ssh('sed -i "/#IOw/c' . $update . '" ' . $dir_f);
		}

		$this->ssh('systemctl daemon-reload');
		return $id;
	}

	public function hostacc_delctl($user = '')
	{
		if ($user == '') {
			return -1;
		}

		$id = trim(implode("\n", $this->ssh('id -u ' . $user . ' | xargs')));
		if (($id < 100) || ($id == '')) {
			return -1;
		}

		$dir = '/usr/lib/systemd/system/user-' . $id . '.slice.d';
		$dir_f = $dir . '/10-defaults.conf';
		$this->ssh('rm -f ' . $dir_f);
		$this->ssh('rm -r ' . $dir);
		$this->ssh('systemctl daemon-reload');
		return $id;
	}

	public function set_userdir_tree()
	{
		$tree = array('/tmp', '/sites', '/mail', '/log', '/.brainy', '/.brainy/statistics', '/.brainy/crontab', '/.brainy/ftp');
		$workspace = $this->getWorkspace($this->hostacc_username);
		$rootdir = $this->hostacc_rootdir;
		$dirlist = $this->new_filelist($rootdir, '*', 'd', 2);

		foreach ($dirlist['list'] as $value) {
			$dirlist1[] = $value['path'];
		}

		foreach ($tree as $value) {
			if (!in_array($value, $dirlist1)) {
				if (($value == '/sites') || ($value == '/log')) {
					$this->ssh('mkdir -p ' . $rootdir . '/' . $workspace . $value);
				}
				else {
					$this->ssh('mkdir -p ' . $rootdir . $value);
				}
			}
		}

		$homeDir = str_replace($this->hostacc_username, '', $rootdir);
		$comm = 'mkdir -p ' . $rootdir . $homeDir;
		$this->ssh($comm);
		$comm = 'ln -s ' . '../' . ' ' . $rootdir . $rootdir;
		$this->ssh($comm);
	}

	public function set_proper_chown($username = NULL)
	{
		if (!isset($username)) {
			$rootdir = $this->hostacc_rootdir;
			$username = $this->hostacc_username;
		}
		else {
			$rootdir = $this->config_read($GLOBALS['USERS_PATH'] . $username)['rootdir'];
		}

		if (strlen($rootdir) < 3) {
			if (!isset($username)) {
				$rootdir = $GLOBALS['HOME_PATH'] . $this->hostacc_username;
			}
			else {
				$rootdir = $GLOBALS['HOME_PATH'] . $username;
			}
		}

		if (!$this->check_value('user', $username)) {
			return false;
		}

		if (!$this->check_value('dir', $rootdir)) {
			return false;
		}

		$this->sudo_ssh('chown -R ' . $username . ':' . $username . ' ' . $rootdir);

		foreach ($this->listdirJail as $curdirJail) {
			if ($curdirJail == 'tmpb') {
				continue;
			}

			$this->sudo_ssh('chown -R root:root ' . $rootdir . '/' . $curdirJail);
		}

		$this->sudo_ssh('chown root:root ' . $rootdir);
		$webserver = new webserver();
		$listphps_conf = parse_ini_file($webserver->serv_datapath . 'phps');
		$phps_list = explode(',', $listphps_conf['phplist']);

		foreach ($phps_list as $curPHP) {
			$this->ssh('chown -R ' . $username . ':' . $username . ' ' . $rootdir . '/etc/' . $curPHP . 'w');
		}

		$this->sudo_ssh('chmod 4755 ' . $rootdir . '/usr/sbin/sendmail');
		$this->sudo_ssh('chmod 4755 ' . $rootdir . '/usr/sbin/exim');
		$this->fixMysqlRights($rootdir);
	}

	public function set_proper_chmod()
	{
		$rootdir = $this->hostacc_rootdir;

		if (!$this->check_value('dir', $rootdir)) {
			return false;
		}

		$this->sudo_ssh('chmod 4755 ' . $rootdir . '/usr/sbin/sendmail');
		$this->sudo_ssh('chmod 4755 ' . $rootdir . '/usr/sbin/exim');
	}

	public function delete_all_userdata($deletesafe, $restore_backup = 0)
	{
		if (!$this->check_value('string', $deletesafe)) {
			return false;
		}

		$dirdata_apac = '/etc/brainy/data/apacserver/';
		$this->del_string_new('|' . $deletesafe . '|', $dirdata_apac . 'http.db');
		$this->del_string_new('|' . $deletesafe . '|', $dirdata_apac . 'www.db');
		$this->del_string_new('/' . $deletesafe . '/', $dirdata_apac . 'directory.db');
		$this->del_string_new('|' . $deletesafe . '|', $dirdata_apac . 'optimization.db');
		$ftp = new ftp();
		$ftp->ftp_kill_userproc($deletesafe);
		$list_ftp = $ftp->ftp_get_anyftp_listfulluser($deletesafe);
		$user_data_main_delftp['group_properties']['root'] = 'y';

		foreach ($list_ftp as $ftp_user) {
			$user_data_main_delftp['name'] = $ftp_user;
			$res = $ftp->ftp_user_delete($user_data_main_delftp, json_encode(array('username' => $ftp_user)));
		}

		$mailobj = new mailclient();
		$listforward = $mailobj->mailclient_getEmailForwardingTable($deletesafe);

		foreach ($listforward as $curemailforward) {
			$params['src'] = $curemailforward[0];
			$params['trg'] = $curemailforward[1];
			$mailobj->mailclient_comm_alias('deleteforward_email', $params);
		}

		$antivir = new antivirus();
		$antivir->clear_history($deletesafe);
		$crontab = new crontab();
		$crontab->crontab_remove_alltasks_new($deletesafe);
		$email = new mailclient();
		$emails_list = $email->mailclient_getEmails($deletesafe);

		foreach ($emails_list as $curemail) {
			$params['email'] = $curemail[0];
			$params['user'] = $deletesafe;
			$email->mailclient_comm_start('deletemail', $params);
		}

		$webserver = new webserver();
		$sitesall = $webserver->get_all_sites($deletesafe);

		if (is_array($sitesall)) {
			foreach ($sitesall as $cursite) {
				$webserver->webserver_remove_domain($cursite, $deletesafe);
				$comm = 'rm -f ' . $GLOBALS['HTTPD_VHOSTLOGS'] . '/' . $cursite . '_access';
				$this->ssh($comm);
				$comm = 'rm -f ' . $GLOBALS['HTTPD_VHOSTLOGS'] . '/' . $cursite . '_error';
				$this->ssh($comm);
				$comm = 'rm -f ' . $GLOBALS['NGINX_VHOSTLOGS'] . '/' . $cursite . '_access';
				$this->ssh($comm);
				$comm = 'rm -f ' . $GLOBALS['NGINX_VHOSTLOGS'] . '/' . $cursite . '_error';
				$this->ssh($comm);
				$this->ssh('rm -rf \'/etc/opendkim/keys/' . $cursite . '\'');
			}
		}

		$backup = new backup();
		$p_userdata = array('name' => $deletesafe);
		$serdata = json_encode(array('timecache' => 1));
		$listbackup_conf = $backup->getconfig_filelist($p_userdata, $serdata);
		$serdata = json_encode(array('timecache' => 1));

		foreach ($listbackup_conf as $keyname => $filetask) {
			foreach ($filetask as $key_task_name => $val_task) {
				$serdata = json_encode(array('backup_file_config' => $key_task_name, 'deluser' => 1));
				$backup->backup_delete_config($p_userdata, $serdata);

				if ($restore_backup == 0) {
					$backup->removetokens($deletesafe, 'y', $key_task_name);
				}
			}
		}

		$this->ssh('rm -rf ' . $this->autoins_path . $deletesafe . '.conf');
		$this->ssh('rm -rf ' . $this->autoins_path . $deletesafe . '_appid*');
		$this->ssh('rm -rf ' . $this->webserver_config_includes . $deletesafe);
		$cert = new certs();
		$certs_list = $cert->certs_getcrtdomains($deletesafe);

		if (is_array($certs_list)) {
			foreach ($certs_list as $cert_dom) {
				$cert->certs_removereq($deletesafe, $cert_dom);
			}
		}

		$this->ssh('rm -rf ' . $cert->dir_certs . $deletesafe);
		$bind = new bindserver();
		$listnamed = $bind->bindserver_getZoneTable($deletesafe);

		foreach ($listnamed as $curnamed) {
			$bind->bindserver_deleteZone($curnamed[0], $deletesafe);
		}

		$mailobj = new mailclient();
		$listforward = $mailobj->mailclient_getEmailForwardingTable($deletesafe);
	}

	public function unmountAllData($username)
	{
		$usersConf = $this->config_read('/etc/brainy/data/users/' . $username);
		$ic = 0;

		while ($ic < 3) {
			$resMysql = $this->unMountMysql($usersConf['rootdir']);
			$this->logAction('Try umount MYSQL USER ' . $username . ' Attempt--- ' . $ic . ' RES = ' . $resMysql);

			if ($resMysql == 1) {
				break;
			}

			++$ic;
		}

		$webserver = new webserver();
		$listphps_conf = parse_ini_file($webserver->serv_datapath . 'phps');
		$phps_list = explode(',', $listphps_conf['phplist']);

		foreach ($phps_list as $curPHP) {
			$this->unmountDirs($usersConf['rootdir'], '/usr/bin/' . $curPHP);
		}

		$this->unmountDirs($usersConf['rootdir'], '/usr/lib64');
	}

	public function hostacc_deleteacct($api_permission = NULL)
	{
		global $lang;
		$login = $this->hostacc_username;
		$param_all = $this->hostacc_readacc();

		if (!$this->check_value('user_exist', $login)) {
			return false;
		}

		$perm = $this->check_permission($api_permission);

		if ($perm == '0') {
			$check['err'] = 101;
			$check['mess'] = $lang['hostacc_unsuspended_user_del'];
			return $check;
		}

		$deletesafe = htmlspecialchars($login, ENT_QUOTES);

		if (file_exists($GLOBALS['MYSQL_CONF_PATH'])) {
			$mysql = new dbusage();
			$users = $mysql->mysql_get_users($deletesafe);

			if (is_array($users)) {
				foreach ($users as $user) {
					$mysql->mysql_drop_user($user, $deletesafe);
				}
			}

			$mysql->mysql_drop_user($this->hostacc_username, $this->hostacc_username);
			$dbs = $mysql->mysql_get_dbs($deletesafe);

			if (is_array($dbs)) {
				foreach ($dbs as $db) {
					$mysql->mysql_drop_db($db, $deletesafe);
				}
			}
		}

		$this->hostacc_unsuspend_email($this->hostacc_username);
		$this->delete_all_userdata($deletesafe);
		$usersConf = $this->config_read('/etc/brainy/data/users/' . $deletesafe);
		$ic = 0;

		while ($ic < 3) {
			$resMysql = $this->unMountMysql($usersConf['rootdir']);
			$this->logAction('Try umount MYSQL USER ' . $deletesafe . ' Attempt--- ' . $ic . ' RES = ' . $resMysql);

			if ($resMysql == 1) {
				break;
			}

			++$ic;
		}

		$webserver = new webserver();
		$listphps_conf = parse_ini_file($webserver->serv_datapath . 'phps');
		$phps_list = explode(',', $listphps_conf['phplist']);

		foreach ($phps_list as $curPHP) {
			$this->unmountDirs($usersConf['rootdir'], '/usr/bin/' . $curPHP);
		}

		$this->unmountDirs($usersConf['rootdir'], '/usr/lib64');
		$comm = 'umount -l ' . $usersConf['rootdir'] . '/proc';
		$this->sudo_ssh($comm);
		$comm = 'umount -f ' . $usersConf['rootdir'] . '/proc';
		$this->sudo_ssh($comm);
		$rcLocalFile = '/etc/rc.d/rc.local';

		if (!is_file($rcLocalFile)) {
			$rcLocalFile = '/etc/rc.local';
		}

		$this->del_string_new($usersConf['rootdir'], $rcLocalFile);
		$user_info = new user_info();
		$user_info->edit_user($this->hostacc_username, 'remove_user');
		$this->hostacc_delctl($deletesafe);
		$comm = 'userdel -f -r ' . $deletesafe;
		$this->sudo_ssh($comm);

		if (2 < strlen($deletesafe)) {
			$comm = 'rm -rf ' . $usersConf['rootdir'];
			$this->sudo_ssh($comm);
		}

		$comm = 'rm -f ' . $GLOBALS['USERS_PATH'] . $deletesafe;
		$this->sudo_ssh($comm);
		$comm = 'rm -f ' . $GLOBALS['DATA_PATH_AUTOINS_USERS_APP'] . $deletesafe . '.conf';
		$this->sudo_ssh($comm);
		$ip = $param_all['ip'];

		if (3 < strlen($ip)) {
			$ip_user_arr = preg_split('/[\\s,;]/', $ip);
			$ipmanager = new ipmanager();

			foreach ($ip_user_arr as $ip) {
				$nn = $ipmanager->ipmanager_check_ip_status($ip);

				if ($nn == 0) {
					$this->del_string_new($ip . '|', $GLOBALS['IPMANAGER_LISTIPS']);
					file_put_contents($GLOBALS['IPMANAGER_LISTIPS'], $ip . '|0' . "\n", FILE_APPEND);
				}
			}
		}

		$check['err'] = 0;
		$check['mess'] = $lang['hostacc_unsuspended_user_del_ok'];
		return $check;
	}

	public function hostacc_list_all($owner = NULL, $search = NULL)
	{
		$list = array();
		$dir = $GLOBALS['USERS_PATH'];
		$dh = opendir($dir);
		global $lang;

		if (0 < strlen($search)) {
			if (!$this->check_value('string', $search)) {
				$res['code'] = 12;
				$res['message'] = $lang['hostacc_user_search_res_empty'];
				return $res;
			}

			$out = $this->ssh('grep -rl \'' . $search . '\' ' . $GLOBALS['USERS_PATH'] . ' --fixed-strings');

			foreach ($out as $key => $value) {
				$files[] = basename($value);
			}

			if (count($files) == 0) {
				$res['code'] = 14;
				$res['message'] = $lang['hostacc_user_search_res_empty'];
				return $res;

				while (false !== $filename = readdir($dh)) {
					if ($filename[0] == '.') {
						continue;
					}

					$files[] = $filename;
				}
			}
		}
		else {
			return $res;
			continue;
			$files[] = $filename;
		}

		asort($files);

		foreach ($files as $key => $file) {
			if ($file == 'root') {
				continue;
			}

			$addr = $GLOBALS['USERS_PATH'] . $file;
			$list[$file] = $this->config_read($addr);

			if (!$list[$file]['username']) {
				unset($list[$file]);
			}

			if (($list[$file]['owner'] != $owner) && $owner) {
				unset($list[$file]);
			}

			if (empty($list[$file]['r_disk'])) {
				$list[$file]['r_disk'] = 0;
			}

			if (isset($list[$file]['traffic'])) {
				$list[$file]['r_traffic'] = array_sum(explode('/', $list[$file]['traffic']));
			}
			else {
				$list[$file]['r_traffic'] = array_sum(explode('/', '0/0/0'));
			}

			$list[$file]['h_disk'] = round($list[$file]['disk'] / (1024 * 1024), 2);
			$list[$file]['h_bandwidth'] = round($list[$file]['bandwidth'] / (1024 * 1024), 2);
			$list[$file]['h_r_disk'] = round($list[$file]['r_disk'], 2);
			$list[$file]['h_r_traffic'] = round($list[$file]['r_traffic'] / (1024 * 1024), 2);
			$list[$file]['suspended_full'] = $list[$file]['suspended_full'];
			$list[$file]['suspended_sites'] = $list[$file]['suspended_sites'];
			$list[$file]['suspended_ftp'] = $list[$file]['suspended_ftp'];
			$list[$file]['suspended_cron'] = $list[$file]['suspended_cron'];
			$list[$file]['suspended_panel'] = $list[$file]['suspended_panel'];
			$list[$file]['hostacc_stat_susp_reason_share'] = $list[$file]['hostacc_stat_susp_reason_share'];
		}

		return $list;
	}

	public function hostacc_list($login)
	{
		$list = array();

		if (!$this->check_value('string', $login)) {
			return false;
		}

		$addr = $GLOBALS['USERS_PATH'] . $login;
		$list = parse_ini_file($addr, true);
		return $list;
	}

	public function hostacc_user_sites($username, $decode = 0)
	{
		$puny = new idna_convert();

		if (!$this->check_value('user', $username)) {
			return false;
		}

		$users = $this->config_read('/etc/brainy/data/users/' . $username);

		if (!is_array($users)) {
			return NULL;
		}

		$doms = $users['vhost_list'];

		if ($doms) {
			$domsfoo = explode(',', $doms);
			$counter = 0;

			foreach ($domsfoo as $value) {
				$foo = explode(':', $value);

				if ($decode == 0) {
					$doms_m[$counter] = $foo[0];
				}
				else {
					$doms_m[$counter] = $puny->decode(trim($foo[0]));
				}

				$aliases = $foo[1];
				$aliases_m = explode('+', $aliases);

				if (is_array($aliases_m)) {
					foreach ($aliases_m as $vvalue) {
						++$counter;

						if (0 < strlen($vvalue)) {
							if ($decode == 0) {
								$doms_m[$counter] = $vvalue;
							}
							else {
								$doms_m[$counter] = $puny->decode(trim($vvalue));
							}
						}
					}
				}

				++$counter;
			}
		}

		return $doms_m;
	}

	public function hostacc_suspend_sites($username, $reason_susp)
	{
		global $lang;

		if (!$username) {
			$res['code'] = -1;
			$res['message'] = $lang['msg_no_user_sel'];
			return $res;
		}

		$conf_template = parse_ini_file($GLOBALS['PROPERTIES_CONF']);
		$template_path = '/tpl/default/';

		if (isset($conf_template['template'])) {
			$template_path = $conf_template['template'];
		}

		$susp_path = '/etc/brainy' . $template_path . 'suspended/';

		if (!$this->check_value('user_exist', $this->hostacc_username)) {
			return false;
		}

		if (!$this->check_value('user', $username)) {
			return false;
		}

		if (!$this->check_value('text', $reason_susp)) {
			return false;
		}

		$ipserv = $this->get_real_server_ip();
		$arr['suspended_sites'] = 1;
		$arr['hostacc_susp_date_last'] = date('d.m.Y H:i:s');
		$arr['hostacc_stat_susp_reason_share'] = $reason_susp;
		$this->config_save($GLOBALS['USERS_PATH'] . $username, $arr, 'add');
		$webserver = new webserver();
		$domains = $this->hostacc_user_domains();

		if (is_array($domains['data'])) {
			foreach ($domains['data'] as $domain) {
				$webserver->webserver_convert_domain($domain['domain']);

				if (($domain['bridge'] != 'nophp') && ($domain['php'] != 'nophpw')) {
					$susp_file = 'suspended.php';
				}
				else {
					$susp_file = 'suspended.html';
				}

				$res_fetch = file_get_contents($susp_path . $susp_file);
				$res_fetch = str_replace('{$ip}', $ipserv, $res_fetch);
				file_put_contents($domain['rootdir'] . '/' . $domain['enddir'] . '/' . $susp_file, $res_fetch);
				$comm = 'chown -R ' . $username . '.' . $username . ' ' . $domain['rootdir'] . '/' . $domain['enddir'] . '/' . $susp_file;
				$this->ssh($comm);
				$comm = 'chmod 644 ' . $domain['rootdir'] . '/' . $domain['enddir'] . '/' . $susp_file;
				$this->ssh($comm);
			}
		}

		$res['code'] = 0;
		$res['message'] = $lang['hostacc_suspended_sites_ok'];
		return $res;
	}

	public function hostacc_unsuspend_sites($username)
	{
		global $lang;
		require_once '/etc/brainy/classes/webserver.php';
		require_once '/etc/brainy/lib/punycode/idna_convert.php';

		if (!$this->check_value('user_exist', $this->hostacc_username)) {
			return false;
		}

		if (!$this->check_value('user', $username)) {
			return false;
		}

		if (!$username) {
			$res['code'] = -1;
			$res['message'] = $lang['msg_no_user_sel'];
			return $res;
		}

		$conf_template = parse_ini_file($GLOBALS['PROPERTIES_CONF']);
		$template_path = '/tpl/default/';

		if (isset($conf_template['template'])) {
			$template_path = $conf_template['template'];
		}

		$susp_path = '/etc/brainy' . $template_path . 'suspended/';
		$arr['suspended_sites'] = 0;
		$arr['hostacc_unsusp_date_last'] = date('d.m.Y H:i:s');
		$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
		$webserver = new webserver();
		$domains = $this->hostacc_user_domains();

		if (is_array($domains['data'])) {
			foreach ($domains['data'] as $domain) {
				$webserver->webserver_convert_domain($domain['domain']);

				if (($domain['bridge'] != 'nophp') && ($domain['php'] != 'nophpw')) {
					$susp_file = 'suspended.php';
				}
				else {
					$susp_file = 'suspended.html';
				}

				$comm = 'rm -f ' . $domain['rootdir'] . '/' . $domain['enddir'] . '/suspended.php';
				$this->ssh($comm);
				$comm = 'rm -f ' . $domain['rootdir'] . '/' . $domain['enddir'] . '/suspended.html';
				$this->ssh($comm);
			}
		}

		$res['code'] = 0;
		$res['message'] = $lang['hostacc_unsuspended_sites_ok'];
		return $res;
	}

	public function hostacc_suspend_email($username, $reason_susp)
	{
		global $lang;

		if (!$this->check_value('user_exist', $this->hostacc_username)) {
			return false;
		}

		if (!$this->check_value('user', $username)) {
			return false;
		}

		if (!$this->check_value('text', $reason_susp)) {
			return false;
		}

		if (!$username) {
			$res['code'] = -1;
			$res['message'] = $lang['msg_no_user_sel'];
			return $res;
		}

		$arr['suspended_email'] = 1;
		$arr['hostacc_susp_date_last'] = date('d.m.Y H:i:s');
		$arr['hostacc_stat_susp_reason_share'] = $reason_susp;
		$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
		$out = $this->read_file_n('/etc/brainy/data/mailclient/block_user');

		foreach ($out as $val_out) {
			if ($val_out === $username) {
				$status = 1;
			}
		}

		if (!$status) {
			$this->write_file($username . PHP_EOL, '/etc/brainy/data/mailclient/block_user', 'wb');
		}

		$this->ssh('cp -f /etc/brainy/data/mailclient/block_user /etc/exim/block_user');
		$res['code'] = 0;
		$res['message'] = $lang['hostacc_suspended_email_ok'];
		return $res;
	}

	public function hostacc_unsuspend_email($username)
	{
		global $lang;

		if (!$this->check_value('user_exist', $this->hostacc_username)) {
			return false;
		}

		if (!$this->check_value('user_exist', $username)) {
			return false;
		}

		if (!$username) {
			$res['code'] = -1;
			$res['message'] = $lang['msg_no_user_sel'];
			return $res;
		}

		$arr['suspended_email'] = 0;
		$arr['hostacc_unsusp_date_last'] = date('d.m.Y H:i:s');
		$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
		$this->ssh('sed -i \'/^' . $username . '$/d\' /etc/brainy/data/mailclient/block_user');
		$this->ssh('cp -f /etc/brainy/data/mailclient/block_user /etc/exim/block_user');
		$res['code'] = 0;
		$res['message'] = $lang['hostacc_unsuspended_email_ok'];
		return $res;
	}

	public function hostacc_suspend_ftp($username, $reason_susp)
	{
		global $lang;

		if (!$this->check_value('user_exist', $this->hostacc_username)) {
			return false;
		}

		if (!$this->check_value('user', $username)) {
			return false;
		}

		if (!$this->check_value('text', $reason_susp)) {
			return false;
		}

		if (!$username) {
			$res['code'] = -1;
			$res['message'] = $lang['msg_no_user_sel'];
			return $res;
		}

		$arr['suspended_ftp'] = 1;
		$arr['hostacc_susp_date_last'] = date('d.m.Y H:i:s');
		$arr['hostacc_stat_susp_reason_share'] = $reason_susp;
		$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
		$ftp = new ftp();
		$ftp->ftp_kill_userproc($username);
		$list_ftp = $ftp->ftp_get_anyftp_listfulluser($username);

		foreach ($list_ftp as $ftp_user) {
			$res = $ftp->ftp_user_delete(array('group' => 'admin'), json_encode(array('username' => $ftp_user)), 1);
		}

		$res['code'] = 0;
		$res['message'] = $lang['hostacc_suspended_ftp_ok'];
		return $res;
	}

	public function hostacc_unsuspend_ftp($username)
	{
		global $lang;

		if (!$this->check_value('user_exist', $this->hostacc_username)) {
			return false;
		}

		if (!$this->check_value('user_exist', $username)) {
			return false;
		}

		if (!$username) {
			$res['code'] = -1;
			$res['message'] = $lang['msg_no_user_sel'];
			return $res;
		}

		$arr['suspended_ftp'] = 0;
		$arr['hostacc_unsusp_date_last'] = date('d.m.Y H:i:s');
		$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
		$ftp = new ftp();
		$list_ftp = $ftp->ftp_import_subftp_oneuser($username);
		$failed_import = array();

		foreach ($list_ftp as $ftp_res_unblock) {
			if ($ftp_res_unblock['status'] == 0) {
				$failed_import[] = $ftp_res_unblock['login'];
			}
		}

		if (0 < count($failed_import)) {
			$res['users_failed_unblocked'] = $failed_import;
		}

		$res['code'] = 0;
		$res['message'] = $lang['hostacc_unsuspended_ftp_ok'];
		return $res;
	}

	public function switch_shell_onoff()
	{
		global $lang;
		$username = $this->hostacc_username;

		if (!$username) {
			exit();
		}

		if (!$this->check_value('user', $username)) {
			return false;
		}

		$onoff = $this->hostacc_shell_access;

		switch ($onoff) {
		case 'y':
			$comm = 'gpasswd -d ' . $username . ' no_sshgroup';
			$this->ssh($comm);
			$out['error'] = 0;
			$out['mess'] = $lang['msg_everything'];
			$this->hostacc_unsuspend_shell($username);
			break;
		}

		$comm = 'groupadd no_sshgroup';
		$this->ssh($comm);
		$comm = 'usermod -G no_sshgroup ' . $username;
		$this->ssh($comm);
		$out['error'] = 0;
		$out['mess'] = $lang['msg_everything'];
		$this->hostacc_suspend_shell($username);
		break;
		$arr = array('shell_access' => $this->hostacc_shell_access);
		$this->config_save($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/users/' . $username, $arr, 'add');
		return $out;
	}

	public function change_lang()
	{
		$langs = $this->get_langs();

		if (in_array($this->hostacc_lang, $langs)) {
			$arr = array('language' => $this->hostacc_lang);

			if (!$this->check_value('user', $this->hostacc_username)) {
				return false;
			}

			$this->config_save($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/users/' . $this->hostacc_username, $arr, 'add');
			return 1;
		}

		return 0;
	}

	public function hostacc_suspend_shell($username, $reason_susp = NULL)
	{
		global $lang;

		if (!$this->check_value('user_exist', $this->hostacc_username)) {
			return false;
		}

		if (!$this->check_value('user_exist', $username)) {
			return false;
		}

		if (!$this->check_value('text', $reason_susp)) {
			return false;
		}

		if (!$username) {
			$res['code'] = -1;
			$res['message'] = $lang['msg_no_user_sel'];
			return $res;
		}

		$arr['suspended_shell'] = 1;
		$arr['hostacc_susp_date_last'] = date('d.m.Y H:i:s');
		$arr['hostacc_stat_susp_reason_share'] = $reason_susp;
		$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
		$comm = 'groupadd no_sshgroup';
		$this->ssh($comm);
		$comm = 'usermod -G no_sshgroup ' . $username;
		$this->ssh($comm);
		$res['code'] = 0;
		$res['message'] = $lang['hostacc_suspended_shell_ok'];
		$ssh = new ssh();
		$ssh_config = $ssh->ssh_load_etc_config();

		if (isset($ssh_config['denygroups'][1])) {
			if (stripos($ssh_config['denygroups'][1], 'no_sshgroup') === false) {
				$ssh_denygroups = $ssh_config['denygroups'][1] . ' no_sshgroup';
				$ssh_full = file_get_contents($GLOBALS['HOSTACC_SSHD_CONFIG']);
				$ssh_full = str_replace($ssh_config['denygroups'][1], $ssh_denygroups, $ssh_full);
				file_put_contents($GLOBALS['HOSTACC_SSHD_CONFIG'], $ssh_full);
			}
		}
		else {
			$ssh_denygroups = 'DenyGroups no_sshgroup';
			file_put_contents($GLOBALS['HOSTACC_SSHD_CONFIG'], "\n" . $ssh_denygroups . "\n", FILE_APPEND);
		}

		$ssh->ssh_service('restart');
		return $res;
	}

	public function hostacc_unsuspend_shell($username)
	{
		global $lang;

		if (!$this->check_value('user_exist', $this->hostacc_username)) {
			return false;
		}

		if (!$this->check_value('user', $username)) {
			return false;
		}

		if (!$username) {
			$res['code'] = -1;
			$res['message'] = $lang['msg_no_user_sel'];
			return $res;
		}

		$arr['suspended_shell'] = 0;
		$arr['hostacc_unsusp_date_last'] = date('d.m.Y H:i:s');
		$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
		$comm = 'gpasswd -d ' . $username . ' no_sshgroup';
		$this->ssh($comm);
		$ssh = new ssh();
		$ssh->ssh_service('restart');
		$res['code'] = 0;
		$res['message'] = $lang['hostacc_unsuspended_shell_ok'];
		return $res;
	}

	public function hostacc_suspend_cron($username, $reason_susp)
	{
		global $lang;

		if (!$this->check_value('user_exist', $this->hostacc_username)) {
			return false;
		}

		if (!$this->check_value('user_exist', $username)) {
			return false;
		}

		if (!$this->check_value('text', $reason_susp)) {
			return false;
		}

		if (!$username) {
			$res['code'] = -1;
			$res['message'] = $lang['msg_no_user_sel'];
			return $res;
		}

		$arr['suspended_cron'] = 1;
		$arr['hostacc_susp_date_last'] = date('d.m.Y H:i:s');
		$arr['hostacc_stat_susp_reason_share'] = $reason_susp;
		$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
		$crontab = new crontab();
		$crontab->crontab_remove_alltasks_new($username);
		$res['code'] = 0;
		$res['message'] = $lang['hostacc_suspended_cron_ok'];
		return $res;
	}

	public function hostacc_unsuspend_cron($username)
	{
		global $lang;

		if (!$this->check_value('user_exist', $this->hostacc_username)) {
			return false;
		}

		if (!$this->check_value('user_exist', $username)) {
			return false;
		}

		if (!$username) {
			$res['code'] = -1;
			$res['message'] = $lang['msg_no_user_sel'];
			return $res;
		}

		$arr['suspended_cron'] = 0;
		$arr['hostacc_unsusp_date_last'] = date('d.m.Y H:i:s');
		$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
		$crontab = new crontab();
		$crontab->crontab_load($username);
		$res['code'] = 0;
		$res['message'] = $lang['hostacc_unsuspended_cron_ok'];
		return $res;
	}

	public function hostacc_suspend_panel($username, $reason_susp)
	{
		global $lang;

		if (!$this->check_value('user_exist', $this->hostacc_username)) {
			return false;
		}

		if (!$this->check_value('user_exist', $username)) {
			return false;
		}

		if (!$this->check_value('text', $reason_susp)) {
			return false;
		}

		if (!$username) {
			$res['code'] = -1;
			$res['message'] = $lang['msg_no_user_sel'];
			return $res;
		}

		$arr['suspended_panel'] = 1;
		$arr['hostacc_susp_date_last'] = date('d.m.Y H:i:s');
		$arr['hostacc_stat_susp_reason_share'] = $reason_susp;
		$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
		$res['code'] = 0;
		$res['message'] = $lang['hostacc_suspended_panel_ok'];
		return $res;
	}

	public function hostacc_unsuspend_panel($username)
	{
		global $lang;

		if (!$this->check_value('user_exist', $this->hostacc_username)) {
			return false;
		}

		if (!$this->check_value('user_exist', $username)) {
			return false;
		}

		if (!$username) {
			$res['code'] = -1;
			$res['message'] = $lang['msg_no_user_sel'];
			return $res;
		}

		$arr['suspended_panel'] = 0;
		$arr['hostacc_unsusp_date_last'] = date('d.m.Y H:i:s');
		$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
		$res['code'] = 0;
		$res['message'] = $lang['hostacc_unsuspended_panel_ok'];
		return $res;
	}

	public function hostacc_suspend_full($username, $reason_susp)
	{
		global $lang;

		if (!$this->check_value('user_exist', $this->hostacc_username)) {
			return false;
		}

		if (!$this->check_value('user_exist', $username)) {
			return false;
		}

		if (!$this->check_value('text', $reason_susp)) {
			return false;
		}

		if (!$username) {
			$res['code'] = -1;
			$res['message'] = $lang['msg_no_user_sel'];
			return $res;
		}

		$arr['suspended_full'] = 1;
		$arr['hostacc_susp_date_last'] = date('d.m.Y H:i:s');
		$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
		$this->hostacc_suspend_sites($username, $reason_susp);
		$this->hostacc_suspend_ftp($username, $reason_susp);
		$this->hostacc_suspend_email($username, $reason_susp);
		$this->hostacc_suspend_shell($username, $reason_susp);
		$this->hostacc_suspend_cron($username, $reason_susp);
		$this->hostacc_suspend_panel($username, $reason_susp);
		$res['code'] = 0;
		$res['message'] = $lang['hostacc_suspended_full_ok'];
		return $res;
	}

	public function hostacc_unsuspend_full($username)
	{
		global $lang;

		if (!$this->check_value('user_exist', $this->hostacc_username)) {
			return false;
		}

		if (!$this->check_value('user_exist', $username)) {
			return false;
		}

		if (!$username) {
			$res['code'] = -1;
			$res['message'] = $lang['msg_no_user_sel'];
			return $res;
		}

		$arr['suspended_full'] = 0;
		$arr['hostacc_unsusp_date_last'] = date('d.m.Y H:i:s');
		$this->config_save($GLOBALS['USERS_PATH'] . $this->hostacc_username, $arr, 'add');
		$this->hostacc_unsuspend_sites($username);
		$this->hostacc_unsuspend_ftp($username);
		$this->hostacc_unsuspend_email($username);
		$this->hostacc_unsuspend_shell($username);
		$this->hostacc_unsuspend_cron($username);
		$this->hostacc_unsuspend_panel($username);
		$res['code'] = 0;
		$res['message'] = $lang['hostacc_unsuspended_full_ok'];
		return $res;
	}

	public function hostacc_count_discusage($accname, $w = NULL)
	{
		if (!$this->check_value('user', $accname)) {
			return false;
		}

		$this->hostacc_username = $accname;
		$out = $this->hostacc_readacc();
		$rootdir = $out['rootdir'];
		$oo = implode('', $this->ssh('quota -u \'' . $accname . '\' | grep \'/dev/\' |awk \'{print $2}\''));

		if (1 < strlen($oo)) {
			$oo = round($oo / 1024, 3);
		}
		else if ($rootdir) {
			$disk_val = implode('', $this->sudo_ssh('du -sx ' . $rootdir . ' | awk \'{print $1}\''));
		}
		else {
			$disk_val = implode('', $this->sudo_ssh('du -sx ' . $rootdir . ' | awk \'{print $1}\''));
			$oo = round($disk_val / 1024, 3);
		}

		if ($w) {
			$arr = array('r_disk' => $oo);
			$this->config_save('/etc/brainy/data/users/' . $accname, $arr);
		}

		return $oo;
	}

	public function hostacc_count_sites($accname, $w = NULL)
	{
		if (!$this->check_value('user', $accname)) {
			return false;
		}

		$out = $this->sudo_ssh('grep -rl \'user="' . $accname . '"\' \'/etc/brainy/data/vhosts/\'');

		if ($w) {
			if ($out[0]) {
				$num = count($out);
			}
			else {
				$num = '0';
			}

			$arr = array('r_sites' => $num);
			$this->config_save('/etc/brainy/data/users/' . $accname, $arr);
		}

		return count($out);
	}

	public function hostacc_count_dns_zones($accname, $w = NULL)
	{
		if (!$this->check_value('user', $accname)) {
			return false;
		}

		$bind = new bindserver();
		$num = count($bind->bindserver_getZoneByUser($accname));

		if ($w) {
			$arr = array('r_dnszones' => $num);
			$this->config_save('/etc/brainy/data/users/' . $accname, $arr);
		}

		return $num;
	}

	public function hostacc_count_dbs($accname, $w = NULL)
	{
		if (!$this->check_value('user', $accname)) {
			return false;
		}

		$db = new dbusage();
		$out = $db->mysql_count_dbs($accname);

		if ($w) {
			$arr = array('r_databases' => intval($out));
			$this->config_save('/etc/brainy/data/users/' . $accname, $arr);
		}

		return intval($out);
	}

	public function hostacc_count_mails($accname, $w = NULL)
	{
		if (!$this->check_value('user', $accname)) {
			return false;
		}

		$mailclient = new mailclient();
		$out = $mailclient->mailclient_getEmails($accname);

		if ($w) {
			if ($out[0]) {
				$num = count($out);
			}
			else {
				$num = '0';
			}

			$arr = array('r_emailboxes' => $num);
			$this->config_save('/etc/brainy/data/users/' . $accname, $arr);
		}

		return count($out);
	}

	public function hostacc_count_ftp_accounts($accname, $w = NULL)
	{
		if (!$this->check_value('user', $accname)) {
			return false;
		}

		$ftp = new ftp();
		$out = $ftp->ftp_get_anyftp_listfulluser($accname);

		if ($w) {
			if ($out[0]) {
				$num = count($out);
			}
			else {
				$num = '0';
			}

			$arr = array('r_ftp_accounts' => $num);
			$this->config_save('/etc/brainy/data/users/' . $accname, $arr);
		}

		return count($out);
	}

	public function hostacc_count_all_data($accname)
	{
		if (!$accname) {
			exit();
		}

		if (!$this->check_value('user', $accname)) {
			return false;
		}

		$sites = $this->hostacc_count_sites($accname);
		$dns_zones = $this->hostacc_count_dns_zones($accname);
		$dbs = $this->hostacc_count_dbs($accname);
		$emails = $this->hostacc_count_mails($accname);
		$disk = $this->hostacc_count_discusage($accname);
		$ftp = $this->hostacc_count_ftp_accounts($accname);
		$arr = array('r_disk' => $disk, 'r_sites' => $sites, 'r_dnszones' => $dns_zones, 'r_emailboxes' => $emails, 'r_databases' => $dbs, 'r_ftp_accounts' => $ftp);
		$this->config_save('/etc/brainy/data/users/' . $accname, $arr);
	}

	public function hostacc_count_all_user_data()
	{
		$out = $this->get_users();

		foreach ($out as $value) {
			$this->hostacc_count_all_data($value);
		}
	}

	public function hostacc_refresh_cache($username)
	{
		if (!$this->check_value('user', $username)) {
			return false;
		}

		$this->hostacc_count_all_data($username);
		$this->user_main_db_update_pass($username);
		$this->user_refresh_domain_cache($username);
		global $lang;
		$res['code'] = 0;
		$res['message'] = $lang['hostacc_refresh_user_cache_ok'];
		return $res;
	}

	public function user_refresh_domain_cache($username)
	{
		if (!$this->check_value('user', $username)) {
			return false;
		}

		$users = $this->config_read('/etc/brainy/data/users/' . $username);

		if (!is_array($users)) {
			return NULL;
		}

		$doms = $users['vhost_list'];
		$vhost_list_new = '';

		if ($doms) {
			$domsfoo = explode(',', $doms);
			$counter = 0;

			foreach ($domsfoo as $value) {
				$foo = explode(':', $value);
				$maidom = $foo[0];
				$aliases = $foo[1];

				if (is_file($GLOBALS['DATA_VHOSTS'] . $maidom . '.conf')) {
					if (0 < $counter) {
						$vhost_list_new .= ',';
					}

					$vhost_list_new .= $maidom . ':' . $aliases;
					++$counter;
				}
			}

			$arr['vhost_list'] = $vhost_list_new;
			$this->config_save($GLOBALS['USERS_PATH'] . $username, $arr, 'add');
		}
	}

	public function user_main_db_update_pass($username)
	{
		if (!$this->check_value('user', $username)) {
			return false;
		}

		$user = parse_ini_file($GLOBALS['USERS_PATH'] . $username, true);

		if (empty($user['mysql_pass'])) {
			$chars = 'qazxswedcvfrtgbnhyujmkiolp1234567890QAZXSWEDCVFRTGBNHYUJMKIOLP';
			$max = 8;
			$size = StrLen($chars) - 1;
			$random_pass = NULL;
			$postfix = '';

			while ($max--) {
				$random_pass .= $chars[rand(0, $size)];
				$postfix .= $chars[rand(0, $size)];
			}

			$crypted_pass = $random_pass . $postfix;
		}
		else {
			$crypted_pass = $user['mysql_pass'];
		}

		if (file_exists($GLOBALS['MYSQL_CONF_PATH'])) {
			$exist[] = '127.0.0.1';
			$exist[] = 'localhost';

			foreach ($exist as $host) {
				$comm = 'DROP USER "' . $username . '"@"' . $host . '"';
				$res1 = $this->mysql_query_do_nodb($comm);
			}

			$query = 'CREATE USER "' . $username . '"@"localhost" IDENTIFIED BY "' . $crypted_pass . '"';
			$query1 = 'CREATE USER "' . $username . '"@"127.0.0.1" IDENTIFIED BY "' . $crypted_pass . '"';
			$this->mysql_query_do('mysql', $query);
			$this->mysql_query_do('mysql', $query1);
			$arr = array('mysql_pass' => $crypted_pass);
			$root = parse_ini_file($GLOBALS['MYSQL_CONF_PATH'], true);
			$root = $root['root'];
			$out = $this->mysql_query_do_nodb('show databases like \'' . $username . '\\_%\'');

			if (is_array($out)) {
				foreach ($out as $key => $value) {
					$dbs[$key] = $value[0];
					$comm = 'mysql -uroot -p' . $root . ' -e' . '\'' . 'GRANT ALL ON ' . $value[0] . '.* TO "' . $username . '"@"127.0.0.1";' . '\'' . ' mysql';
					$this->sudo_ssh($comm);
					$comm = 'mysql -uroot -p' . $root . ' -e' . '\'' . 'GRANT ALL ON ' . $value[0] . '.* TO "' . $username . '"@"localhost";' . '\'' . ' mysql';
					$this->sudo_ssh($comm);
				}
			}

			$this->config_save($GLOBALS['USERS_PATH'] . $username, $arr, 'add');
		}
	}

	public function getDefaultNewAcc()
	{
		$autojail = $this->config_read($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/jail/main.conf');
		return $autojail;
	}

	public function setDefaultNewAcc($newaccshell, $newaccphp)
	{
		global $lang;
		$newaccshell = intval($newaccshell);
		$newaccphp = intval($newaccphp);
		$arr = array('newaccshell' => $newaccshell, 'newaccphp' => $newaccphp);
		$this->config_save($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/jail/main.conf', $arr, 'add');
		$res['code'] = 0;
		$res['message'] = $lang['hostacc_jailStatusAutoNewAccSaveok'];
		return $res;
	}

	public function setJailHostStat($listStat, $api_permission = NULL)
	{
		global $lang;
		$perm = $this->check_permission($api_permission);

		if ($perm == '0') {
			$check['err'] = 101;
			$check['mess'] = $lang['msg_no_permission_edit'];
			return json_encode($check);
		}

		foreach ($listStat as $curHost) {
			$statJailSet = intval($curHost['statjail']);
			$usercur = $curHost['hostaccjail'];
			$usersConf = $this->config_read('/etc/brainy/data/users/' . $usercur);

			if (!$this->check_value('user', $usercur)) {
				return false;
			}

			$arr = array('jailstatset' => $statJailSet);
			$crontab = new crontab();

			if ($statJailSet != 1) {
				$cutuser = $this->ssh('cat /etc/passwd | grep ^' . $usercur . ':');
				$cutuser = str_replace('/usr/sbin/jk_chrootsh', '/bin/bash', $cutuser[0]);
				$this->ssh('sed -i "/^' . $usercur . ':/c' . $cutuser . '" ' . '/etc/passwd');
				$comm = 'chown ' . $usercur . '.' . $usercur . ' ' . $usersConf['rootdir'];
				$this->ssh($comm);
				$this->ssh('sed -i \'/^SHELL/d\' ' . $usersConf['rootdir'] . '/crontab');
				$ic = 0;

				while ($ic < 3) {
					$resMysql = $this->unMountMysql($usersConf['rootdir']);

					if ($resMysql == 1) {
						break;
					}

					++$ic;
				}

				$this->unmountAllData($usercur);
			}

			if ($statJailSet == 1) {
				$this->unmountAllData($usercur);
				$addout = $this->createJail($usersConf['rootdir'], $usercur);
				$cronFile = $usersConf['rootdir'] . '/crontab';
				$resFileCrons = file_get_contents($cronFile);

				if (stripos($resFileCrons, 'jk_chrootsh') === false) {
					$this->insert_string_n(1, 'SHELL=/usr/sbin/jk_chrootsh', $cronFile);
				}
			}

			$this->config_save($GLOBALS['USERS_PATH'] . $usercur, $arr, 'add');
			$crontab->crontab_load($usercur);
		}

		if (isset($addout['code'])) {
			return $addout;
		}

		$res['code'] = 0;
		$res['message'] = $lang['hostacc_jailStatusSetResOk'];
		return $res;
	}

	public function setJailHostStatPHP($listStat, $api_permission = NULL, $force = 0)
	{
		global $lang;
		$perm = $this->check_permission($api_permission);

		if ($perm == '0') {
			$check['err'] = 101;
			$check['mess'] = $lang['msg_no_permission_edit'];
			return json_encode($check);
		}

		$webserver = new webserver();

		foreach ($listStat as $curHost) {
			$statJailSet = intval($curHost['statjailphp']);
			$usercur = $curHost['hostaccjail'];
			$usersConf = $this->config_read('/etc/brainy/data/users/' . $usercur);
			$confUserOld = $this->config_read($GLOBALS['USERS_PATH'] . $usercur);

			if (!$this->check_value('user', $usercur)) {
				return false;
			}

			$arr = array('jailstatsetphp' => $statJailSet);

			if ($statJailSet != 1) {
			}

			if ($statJailSet == 1) {
				$this->unmountAllData($usercur);
				$addout = $this->createJail($usersConf['rootdir'], $usercur);
			}

			$this->config_save($GLOBALS['USERS_PATH'] . $usercur, $arr, 'add');
			if (($confUserOld['jailstatsetphp'] != $statJailSet) || ($force == 1)) {
				$this->hostacc_username = $usercur;
				$domains = $this->hostacc_user_domains();

				if (is_array($domains['data'])) {
					foreach ($domains['data'] as $domain) {
						$webserver->webserver_convert_domain($domain['domain']);
					}
				}
			}
		}

		if (isset($addout['code'])) {
			return $addout;
		}

		$res['code'] = 0;
		$res['message'] = $lang['hostacc_jailStatusSetResOk'];
		return $res;
	}
}


?>
