<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class ipmanager
{
	public $addr4 = '/etc/brainy/data/ipmanager/ipv4';
	public $addr6 = '/etc/brainy/data/ipmanager/ipv6';
	public $current_inet_dev = '';

	public function ipmanager_get()
	{
		$ips = $this->ipmanager_listips();
		$ints = $this->sudo_ssh('ip link show | grep -v \'lo:\' | egrep "[0-9]+\\: " | awk \'{print $2}\' | sed \'s/[ \\:]*$//\'');
		return $ints;
	}

	public function get_ips_data4()
	{
	}

	public function get_ips_data6()
	{
	}

	public function write_ips_data4($ip, $net, $int)
	{
	}

	public function write_ips_data6($ip, $net, $int)
	{
		$entry = array($ip => $ip . ' ' . $net . ' ' . $int);
		$this->config_save($this->addr6, $entry);
	}

	public function del_ips_data4($ip)
	{
	}

	public function del_ips_data6($ip)
	{
	}

	public function load_ips_data4()
	{
	}

	public function load_ips_data6()
	{
	}

	public function ipmanager_get_network_interface()
	{
		$ips = $this->ipmanager_listips();
		$ips[0] = trim($ips[0]);
		$out = $this->sudo_ssh('grep -rl \'' . $ips[0] . '\' /etc/sysconfig/network-scripts');
		$out[0] = str_replace('/etc/sysconfig/network-scripts/ifcfg-', '', $out[0]);
		$outt = strstr($out[0], ':', 1);

		if (!$outt) {
			$outt = $out[0];
		}

		return $outt;
	}

	public function ipmanager_ipv4()
	{
		$ips_stat = $this->getallips_list_stat();
		$ips = $this->ipmanager_listips();
		$arr = array();

		if (is_array($ips)) {
			foreach ($ips as $key => $value) {
				$val = $value;
				$val['stat'] = -1;

				if (is_array($ips_stat)) {
					foreach ($ips_stat as $curipstat) {
						$val['stat'] = $curipstat['stat'];
						break;
					}
				}

				$arr[] = $val;
			}
		}

		return $arr;
	}

	public function ipmanager_ipv6()
	{
	}

	public function ipmanager_get_network_next_number($inter = 'z')
	{
		$ips = $this->ipmanager_listips();
		$int = '';

		foreach ($ips as $key => $val) {
			$int = $val['int'];
			break;
		}

		if ($int == '') {
			return 0;
		}

		if (0 < substr_count($int, ':')) {
			$first = strstr($int, ':', true);
			$value = str_replace(':', '', strstr($int, ':'));
			$num = $first . ':' . ($value + 1);
		}
		else {
			$num = $int . ':1';
		}

		return $num;
	}

	public function ipmanager_add_nat($ip, $mask, $inter, $code = '0')
	{
		if ($code != 2) {
			return false;
		}

		if (empty($mask)) {
			$mask = '255.255.255.255';
		}

		$dev = $this->current_inet_dev;
		$ip_netmask = trim(implode("\n", $this->sudo_ssh('ip a | grep \'inet \' | grep \'' . $inter . '\' | grep -v \'' . $inter . ':\' | awk \'{print $2}\' | xargs')));
		$ipp = explode('/', $ip_netmask);
		$ip_net = $ipp[0];
		$prefix = $ipp[1];
		$arr = array('dev' => $dev, 'ip' => $ip, 'mask' => $mask, 'active' => 'yes', 'ip_netmask' => $ip_netmask, 'rule0' => 'PREROUTING -p tcp --dport 80 -d ' . $ip_net . ' -j DNAT --to-destination ' . $ip . ':80', 'rule1' => 'POSTROUTING -p tcp --dport 80 -d ' . $ip . ' -j SNAT --to-source ' . $ip_net, 'rule2' => 'PREROUTING -p tcp --dport 443 -d ' . $ip_net . ' -j DNAT --to-destination ' . $ip . ':443', 'rule3' => 'POSTROUTING -p tcp --dport 443 -d ' . $ip . ' -j SNAT --to-source ' . $ip_net);
		$this->config_save('/etc/brainy/data/ipmanager/nat', $arr);
		$this->sudo_ssh('iptables -t nat -A PREROUTING -p tcp --dport 80 -d ' . $ip_net . ' -j DNAT --to-destination ' . $ip . ':80');
		$this->sudo_ssh('iptables -t nat -A POSTROUTING -p tcp --dport 80 -d ' . $ip . ' -j SNAT --to-source ' . $ip_net);
		$this->sudo_ssh('iptables -t nat -A PREROUTING -p tcp --dport 443 -d ' . $ip_net . ' -j DNAT --to-destination ' . $ip . ':443');
		$this->sudo_ssh('iptables -t nat -A POSTROUTING -p tcp --dport 443 -d ' . $ip . ' -j SNAT --to-source ' . $ip_net);
		$this->sudo_ssh('iptables-save > /etc/sysconfig/iptables');
		$this->sudo_ssh('systemctl restart iptables');
		return true;
	}

	public function ipmanager_check_nat()
	{
		$mass = $this->config_read('/etc/brainy/data/ipmanager/nat');

		if (isset($mass['active']) && ($mass['active'] == 'yes')) {
			return true;
		}

		return false;
	}

	public function ipmanager_get_nat_info()
	{
		$arr = array();
		$mass = $this->config_read('/etc/brainy/data/ipmanager/nat');

		if (isset($mass['active']) && (($mass['active'] == 'yes') || ($mass['active'] == 'no'))) {
			$arr[0]['dev'] = $mass['active'];
			$arr[0]['ip'] = $mass['ip'];
			$arr[0]['ip_nat'] = $mass['ip_netmask'];
			$arr[0]['active'] = $mass['active'];
			$arr[0]['rule0'] = $mass['rule0'];
			$arr[0]['rule1'] = $mass['rule1'];
			$arr[0]['rule2'] = $mass['rule2'];
			$arr[0]['rule3'] = $mass['rule3'];
		}

		return $arr;
	}

	public function ipmanager_check_addip($ip, $netmask, $gateway, $ipexclude, $inter, $nat = 'no')
	{
		global $lang;

		if (($nat == 'yes') && $this->ipmanager_check_nat()) {
			$out['code'] = 5;
			$out['message'] = $lang['ipmanager_nat_error0'] . '';
			return $out;
		}

		if (strripos($ip, '.')) {
			$out = $this->ipmanager_addnewip($ip, $netmask, $gateway, $ipexclude, $inter);
			$webserver = new webserver();
			$webserver->rebuildnamevirt_apache();
		}
		else if (strripos($ip, ':')) {
			$out = $this->ipmanager_addnewipv6($ip, $netmask, $inter);

			if (strripos($ip, '-')) {
				$out = $this->ipmanager_addrangeipv6($ip, $ipexclude, $netmask, $inter);
			}
		}
		else {
			$resr['code'] = 3;
			$resr['message'] = $lang['ipmanager_error_data_wrongip'];
			return $resr;
		}

		if ($nat == 'yes') {
			if ($this->ipmanager_add_nat($ip, $mask, $inter, $out['code'])) {
				$out['message'] = $lang['ipmanager_nat_ok'] . '';
				$webserver = new Webserver();
				$webserver->rebuild_virt_host();
				$f = file_get_contents('/var/www/html/index.html');

				if (strstr($f, '<!-- NATBRAINY -->')) {
					$this->sudo_ssh('rm -f /var/www/html/index.html');
					$this->sudo_ssh('cp /etc/brainy/tpl/basic/server_control/default1.html /var/www/html/index.html');
					$foo = array('{$server_addr}', '{/literal}', '{literal}');
					$bar = array($ip, '', '');
					$f = str_replace($foo, $bar, $f);
					file_put_contents('/var/www/html/index.html', $f);
					$this->sudo_ssh('echo \'<!-- NATBRAINY -->\' /var/www/html/index.html');
				}
			}
			else {
				$out['code'] = 3;
				$out['message'] = $lang['ipmanager_nat_error'] . '';
			}
		}

		return $out;
	}

	public function ipmanager_check_delip($ip, $inter)
	{
		if (strripos($ip, '.')) {
			$out = $this->ipmanager_deleteip($ip);
		}
		else if (strripos($ip, ':')) {
			$out = $this->ipmanager_delnewipv6($ip, $inter);
		}

		return $out;
	}

	public function ipv6_formatter($ip)
	{
		$clean_ip = $ip;

		if (strripos($clean_ip, '::')) {
			$ip_exp = explode(':', $clean_ip);
			$i = 0;

			while ($i < (9 - count($ip_exp))) {
				$lost .= ':0000';
				++$i;
			}

			$lost .= ':';
			$uncut_ip = str_replace('::', $lost, $clean_ip);
		}
		else {
			$uncut_ip = $clean_ip;
		}

		$uncut_exp = explode(':', $uncut_ip);

		foreach ($uncut_exp as $section) {
			if (strlen($section) < 4) {
				$i = 0;

				while ($i < (strlen($section) - 4)) {
					$uncut_section .= '0';
					++$i;
				}

				$uncut_section .= $section;
			}
			else if (4 < strlen($section)) {
				$sum = strlen($section) - 4;
				$uncut_section = substr($section, $sum);
			}
			else if (strlen($section) == 4) {
				$uncut_section = $section;
			}

			$uncut_sections_all[] = $uncut_section;
		}

		$totally16 = implode(':', $uncut_sections_all);
		return $totally16;
	}

	public function ipmanager_addrangeipv6($ip, $ipexclude, $netmask, $inter)
	{
		if (!$this->check_value('string', $inter)) {
			return false;
		}

		global $lang;

		if (strripos($ip, '/')) {
			$exp_net = explode('/', $ip);
			$ip = $exp_net[0];
			$net = $exp_net[1];
		}
		else {
			$exp_net = explode('/', $ip);
			$ip = $exp_net[0];
			$net = '128';
		}

		if (!empty($inter)) {
			$int = $inter;
		}
		else {
			$ints = $this->ipmanager_get();
			$int = $ints[0];
		}

		$addr = '/etc/sysconfig/network-scripts/ifcfg-' . $int;
		$range = explode('::', $ip);
		$range_arr = explode('-', end($range));
		$first_num = hexdec($range_arr[0]);
		$last_num = hexdec($range_arr[1]);
		$i = $first_num;

		while ($i < ($last_num + 1)) {
			$new_ips[] = $range[0] . '::' . dechex($i) . '/' . $net;
			++$i;
		}

		if (!empty($ipexclude)) {
			$ipexclude = explode(' ', $ipexclude);

			foreach ($ipexclude as $ip) {
				$key = array_search($ip, $new_ips);
				unset($new_ips[$key]);
			}
		}

		$config = $this->parse_config_read_param($addr, array('IPV6ADDR_SECONDARIES'), '=', array('#'));

		if (is_array($new_ips)) {
			foreach ($new_ips as $value) {
				$exp = explode('/', $value);
				$this->write_ips_data6($exp[0], $exp[1], $int);
			}
		}

		if (array_key_exists('IPV6ADDR_SECONDARIES', $config)) {
			$ips = str_replace('"', '', $config['IPV6ADDR_SECONDARIES']);
			$ips = explode(' ', $ips);
			$ips = array_merge($ips, $new_ips);
			$ips = array_unique($ips);
			$ips = implode(' ', $ips);
			$ips = '"' . $ips . '"';
			$config['IPV6ADDR_SECONDARIES'] = $ips;
			$this->parse_config_save($addr, $config, '=', array('#'));
		}
		else {
			$ips = $new_ips;
			$ips = array_unique($ips);
			$ips = implode(' ', $ips);
			$entry = 'IPV6ADDR_SECONDARIES=' . '"' . $ips . '"';
			$this->write_file($entry, $addr, 'wa');
		}

		$this->sudo_ssh('ifup ' . $addr);
		$ans['code'] = 1;
		$ans['message'] = $lang['ipmanager_added'];
		return $ans;
	}

	public function ipmanager_addnewipv6($ip, $inter)
	{
		if (!$this->check_value('string', $inter)) {
			return false;
		}

		global $lang;

		if (strripos($ip, '/')) {
			$exp_net = explode('/', $ip);
			$ip = $exp_net[0];
			$net = $exp_net[1];
		}
		else {
			$exp_net = explode('/', $ip);
			$ip = $exp_net[0];
			$net = '128';
		}

		if (!empty($inter)) {
			$int = $inter;
		}
		else {
			$ints = $this->ipmanager_get();
			$int = $ints[0];
		}

		$addr = '/etc/sysconfig/network-scripts/ifcfg-' . $int;
		$config = $this->parse_config_read_param($addr, array('IPV6ADDR_SECONDARIES'), '=', array('#'));

		if (array_key_exists('IPV6ADDR_SECONDARIES', $config)) {
			$ips = str_replace('"', '', $config['IPV6ADDR_SECONDARIES']);
			$ips = explode(' ', $ips);

			if (in_array($ip, $ips)) {
				$ans['code'] = 4;
				$ans['message'] = $lang['ipmanager_error'];
				return $ans;
			}

			$ips[] = $ip . '/' . $net;
			$ips = implode(' ', $ips);
			$ips = '"' . $ips . '"';
			$config['IPV6ADDR_SECONDARIES'] = $ips;
			$this->parse_config_save($addr, $config, '=', array('#'));
		}
		else {
			$entry = 'IPV6ADDR_SECONDARIES=' . '"' . $ip . '/' . $net . '"';
			$this->write_file($entry, $addr, 'wa');
		}

		$this->sudo_ssh('ifup ' . $addr);
		$ans['code'] = 1;
		$ans['message'] = $ip . ' ' . $lang['ipmanager_added'];
		$this->write_ips_data6($ip, $net, $int);
		return $ans;
	}

	public function ipmanager_delnewipv6($ip, $inter)
	{
		global $lang;

		if (!empty($inter)) {
			$int = $inter;
		}
		else {
			$ints = $this->ipmanager_get();
			$int = $ints[0];
		}

		$addr = '/etc/sysconfig/network-scripts/ifcfg-' . $int;
		$config = $this->parse_config_read_param($addr, array('IPV6ADDR_SECONDARIES'), '=', array('#'));
		$ips = str_replace('"', '', $config['IPV6ADDR_SECONDARIES']);
		$ips = explode(' ', $ips);
		$ips = array_unique($ips);
		$key = array_search($ip, $ips);
		$pure_ip = explode('/', $ips[$key]);
		$this->del_ips_data6($pure_ip[0]);
		unset($ips[$key]);
		$ips = implode(' ', $ips);
		$ips = '"' . $ips . '"';
		$config['IPV6ADDR_SECONDARIES'] = $ips;
		$this->parse_config_save($addr, $config, '=', array('#'));
		$this->sudo_ssh('service network reload');
		$ans['code'] = 1;
		$ans['message'] = $ip . ' ' . $lang['ipmanager_deleted'];
		return $ans;
	}

	public function ipmanager_addnewip_one($ip, $netmask, $gateway, $real_ips, $ips, $num)
	{
		global $lang;

		if (empty($netmask)) {
			$netmask = '255.255.255.255';
		}

		if (in_array($ip, $real_ips)) {
			$resr['code'] = 3;
			$resr['message'] = $lang['ipmanager_ip_exists'];
		}
		else {
			if (!$ip || !$netmask) {
				$resr['code'] = 4;
				$resr['message'] = $lang['ipmanager_error_data'];
			}
			else {
				if ($ip && $netmask && !in_array($ip, $ips)) {
					$newipfile = 'DEVICE=' . $num . "\n" . 'BOOTPROTO=static' . "\n" . 'ONBOOT=yes' . "\n" . 'ARPCHECK=no' . "\n" . 'IPADDR=' . $ip . "\n" . 'NETMASK=' . $netmask;

					if (1 < strlen($gateway)) {
						$newipfile .= "\n" . 'GATEWAY=' . $gateway;
					}

					$this->write_file($newipfile, '/etc/sysconfig/network-scripts/ifcfg-' . $num);
					$res = implode($this->sudo_ssh('ifup ' . $num));

					if (substr_count($res, 'Error') == 0) {
						$resr['code'] = 2;
						$resr['message'] = $res . $lang['ipmanager_done_success'];
						$this->write_ips_data4($ip, $netmask, $num);
						$this->current_inet_dev = $num;
					}
					else {
						unlink('/etc/sysconfig/network-scripts/ifcfg-' . $num);
						$resr['code'] = 1;
						$resr['message'] = $res;
					}
				}
			}
		}

		file_put_contents($GLOBALS['IPMANAGER_LISTIPS'], $ip . '|0' . "\n", FILE_APPEND | LOCK_EX);
		return $resr;
	}

	public function ipmanager_addnewip($ip, $netmask, $gateway = NULL, $ipexclude = NULL, $inter)
	{
		$ips = $this->ipmanager_listips();

		if (is_array($ips)) {
			foreach ($ips as $value) {
				$real_ips[] = $value['ip'];
			}
		}

		$arr_ip_excl = array();
		if ((strpos($ipexclude, '-') !== false) || (strpos($ipexclude, '/') !== false) || (strpos($ipexclude, ',') !== false) || (strpos($ipexclude, ';') !== false) || (strpos($ipexclude, "\n") !== false)) {
			$ip_exp_excl = preg_split('/,|;|\\t|\\s+|$\\R?^/m', $ipexclude);

			foreach ($ip_exp_excl as $ip_excl_one) {
				if (strpos($ip_excl_one, '-') !== false) {
					$ip_exp_excl_one = explode('-', $ip_excl_one);
					$ip1 = $ip_exp_excl_one[0];
					$ip_end = $ip_exp_excl_one[1];
					$ip_exp_comm = explode('.', $ip1);
					$ip_start = intval($ip_exp_comm[count($ip_exp_comm) - 1]);
					$ip_first_part = $ip_exp_comm[0] . '.' . $ip_exp_comm[1] . '.' . $ip_exp_comm[2];
					$a = $ip_start;

					while ($a <= $ip_end) {
						$arr_ip_excl[] = $ip_first_part . '.' . $a;
						++$a;
					}
				}
				else if (strpos($ip_excl_one, '/') !== false) {
					$ip_exp_excl_one = explode('/', $ip_excl_one);
					$ip_start = $ip_exp_excl_one[0];
					$ip_range = intval($ip_exp_excl_one[1]);
					$ip_count = 1 << (32 - $ip_range);
					$start = ip2long($ip_start);
					$i = 0;

					while ($i < $ip_count) {
						$ip_a = long2ip($start + $i);
						$arr_ip_excl[] = $ip_a;
						++$i;
					}
				}
				else if (1 < strlen($ip_excl_one)) {
					$arr_ip_excl[] = $ip_excl_one;
				}
			}
		}
		else {
			$arr_ip_excl[] = $ipexclude;
		}

		if ((strpos($ip, '-') !== false) || (strpos($ip, '/') !== false)) {
			if (strpos($ip, '-') !== false) {
				$ip_exp = explode('-', $ip);
				$ip1 = $ip_exp[0];
				$ip_end = $ip_exp[1];
				$ip_exp_comm = explode('.', $ip1);
				$ip_start = intval($ip_exp_comm[count($ip_exp_comm) - 1]);
				$ip_first_part = $ip_exp_comm[0] . '.' . $ip_exp_comm[1] . '.' . $ip_exp_comm[2];
				$a = $ip_start;

				while ($a <= $ip_end) {
					$ip_ins = $ip_first_part . '.' . $a;

					if (!in_array($ip_ins, $arr_ip_excl) && ($ip_ins != $gateway)) {
						$num = $this->ipmanager_get_network_next_number($inter);
						$resr = $this->ipmanager_addnewip_one($ip_ins, $netmask, $gateway, $real_ips, $ips, $num);
					}

					++$a;
				}
			}

			if (strpos($ip, '/') !== false) {
				$ip_exp_excl_one = explode('/', $ip);
				$ip_start = $ip_exp_excl_one[0];
				$ip_range = intval($ip_exp_excl_one[1]);
				$ip_count = 1 << (32 - $ip_range);
				$start = ip2long($ip_start);
				$i = 0;

				while ($i < $ip_count) {
					$ip_a = long2ip($start + $i);

					if (!in_array($ip_a, $arr_ip_excl) && ($ip_a != $gateway)) {
						$num = $this->ipmanager_get_network_next_number($inter);
						$resr = $this->ipmanager_addnewip_one($ip_a, $netmask, $gateway, $real_ips, $ips, $num);
					}

					++$i;
				}
			}
		}
		else if (!in_array($ip, $arr_ip_excl) && ($ip != $gateway)) {
			$num = $this->ipmanager_get_network_next_number($inter);
			$resr = $this->ipmanager_addnewip_one($ip, $netmask, $gateway, $real_ips, $ips, $num);
		}

		return $resr;
	}

	public function get_device_by_ip($ip)
	{
		$ip = trim($ip);
		$ips = $this->ipmanager_listips();
		$dev = array();

		if (is_array($ips)) {
			foreach ($ips as $value) {
				$cur_ip = $value['ip'];

				if ($cur_ip == $ip) {
					$dev = $value['int'];
				}
			}
		}

		return $dev;
	}

	public function check_ipusing_userconf($ip)
	{
		$param = $this->strip_quotes_cmd($ip);
		$param = str_replace('\'', '"', $param);
		$out = $this->ssh('grep -rl \'' . $param . '\' ' . $GLOBALS['USERS_PATH'] . ' --fixed-strings');

		if (is_array($out)) {
			foreach ($out as $key => $value) {
				$out[$key] = $value;
			}
		}

		return $out;
	}

	public function ipmanager_deleteip($ip)
	{
		global $lang;
		$nn = $this->find_vhosts($ip);
		$nn_users = $this->check_ipusing_userconf($ip);

		if (0 < count($nn)) {
			$resr['code'] = 4;
			$resr['message'] = $lang['ipmanager_del_ip'] . count($nn);
			return $resr;
		}

		if (0 < count($nn_users)) {
			$resr['code'] = 4;
			$resr['message'] = $lang['ipmanager_del_ip_failed_userset'] . count($nn_users);
			return $resr;
		}

		$ip = trim($ip);
		$ips = $this->ipmanager_listips();
		$main_ip = $ips[0]['ip'];
		$out = $this->sudo_ssh('grep -rl \'' . $this->strip_quotes_new_cmd($ip) . '\' /etc/sysconfig/network-scripts');

		if ($main_ip != $ip) {
			$dev = $this->get_device_by_ip($ip);
			$nat_dev = '';
			$nat_active = '';
			$mass = $this->config_read('/etc/brainy/data/ipmanager/nat');

			if (isset($mass['dev'])) {
				$nat_dev = $mass['dev'];
			}

			if (isset($mass['active'])) {
				$nat_active = $mass['active'];
			}
			if ($dev) {
				$this->sudo_ssh('ifdown ' . $dev);
				$this->sudo_ssh('rm -rf /etc/sysconfig/network-scripts/ifcfg-' . $dev);
				$resr['code'] = 2;
				$resr['message'] = $lang['ipmanager_done_success'];
				$this->del_ips_data4($ip);
				$this->del_string_new($ip . '|', $GLOBALS['IPMANAGER_LISTIPS']);

				if (($nat_dev == $dev) && ($nat_active == 'yes')) {
					$rule0 = $mass['rule0'];
					$rule1 = $mass['rule1'];
					$rule2 = $mass['rule2'];
					$rule3 = $mass['rule3'];
					$this->sudo_ssh('rm -rf /etc/brainy/data/ipmanager/nat');
					$this->sudo_ssh('iptables -t nat -D ' . $rule0);
					$this->sudo_ssh('iptables -t nat -D ' . $rule1);
					$this->sudo_ssh('iptables -t nat -D ' . $rule2);
					$this->sudo_ssh('iptables -t nat -D ' . $rule3);
					$this->sudo_ssh('iptables-save > /etc/sysconfig/iptables');
					$this->sudo_ssh('systemctl restart iptables');
					$webserver = new Webserver();
					$webserver->rebuild_virt_host();
				}

				return $resr;
			}
		}
		else {
			return $resr;
			$resr['code'] = 4;
			$resr['message'] = $lang['ipmanager_not_deleted'];
			return $resr;
		}
	}

	public function getfreeips_list()
	{
		if (is_file($GLOBALS['IPMANAGER_LISTIPS'])) {
			$ips_all = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($GLOBALS['IPMANAGER_LISTIPS']));
		}

		$ip_list = array();

		if (is_array($ips_all)) {
			foreach ($ips_all as $ip) {
				$ip_exp = explode('|', $ip);

				if ($ip_exp[1] == 0) {
					$ip_list[] = $ip_exp[0];
				}
			}
		}

		return $ip_list;
	}

	public function getallips_list_stat()
	{
		if (is_file($GLOBALS['IPMANAGER_LISTIPS'])) {
			$ips_all = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($GLOBALS['IPMANAGER_LISTIPS']));
		}

		$i = 0;
		$ip_list = array();

		if (is_array($ips_all)) {
			foreach ($ips_all as $ip) {
				$ip_exp = explode('|', $ip);

				if (1 < count($ip_exp)) {
					$ip_list[$i]['ip'] = $ip_exp[0];
					$ip_list[$i]['stat'] = $ip_exp[1];
				}

				++$i;
			}
		}

		return $ip_list;
	}

	public function getbusyips_list()
	{
		if (is_file($GLOBALS['IPMANAGER_LISTIPS'])) {
			$ips_all = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($GLOBALS['IPMANAGER_LISTIPS']));
		}

		$ip_list = array();

		if (is_array($ips_all)) {
			foreach ($ips_all as $ip) {
				$ip_exp = explode('|', $ip);

				if (1 < count($ip_exp)) {
					if ($ip_exp[1] == 1) {
						$ip_list[] = $ip_exp[0];
					}
				}
			}
		}

		return $ip_list;
	}

	public function change_ips_domains($username, $newip)
	{
		if (strlen($newip) < 3) {
			return 1;
		}

		$users = $this->request_vars_m('users', $username);
		$sites = explode(',', $users['vhost_list']);
		$i = 0;

		while ($i < count($sites)) {
			if (!!trim($sites[$i])) {
				$site_conf = explode(':', $sites[$i]);
				$site_conf1 = $site_conf[0];
				$arr_conf = array('ip' => $newip);
				$this->config_save_my($GLOBALS['DATA_VHOSTS'] . $site_conf1 . '.conf', $arr_conf, 'add');
				$this->config_save_my($GLOBALS['USERS_PATH'] . $username, $arr_conf, 'add');
			}

			++$i;
		}
	}

	public function ipmanager_find_vhosts($param)
	{
		$param = str_replace('\'', '"', $param);
		$out = $this->sudo_ssh('grep -rl \'"' . $param . '"\' ' . $GLOBALS['DATA_VHOSTS']);

		if (is_array($out)) {
			foreach ($out as $key => $value) {
				$out[$key] = str_replace(array($GLOBALS['DATA_VHOSTS'], '.conf'), '', $value);
			}
		}

		return $out;
	}

	public function ipmanager_find_ip_acc($ip)
	{
		$param = str_replace('\'', '"', $ip);
		$out = $this->sudo_ssh('grep -rl \'"' . $param . '"\' ' . $GLOBALS['USERS_PATH'] . ' --fixed-strings');

		if (is_array($out)) {
			foreach ($out as $key => $value) {
				$out[$key] = str_replace(array($GLOBALS['USERS_PATH'], '.conf'), '', $value);
			}
		}

		return $out;
	}

	public function ipmanager_check_ip_status($ip)
	{
		$nn = count($this->ipmanager_find_ip_acc($ip));

		if ($nn != 0) {
			return 1;
		}

		$nn = count($this->ipmanager_find_vhosts($ip));

		if ($nn != 0) {
			return 1;
		}

		return 0;
	}

	public function update_allip_status()
	{
		file_put_contents($GLOBALS['IPMANAGER_LISTIPS'], '');
		$ips = $this->ipmanager_listips();

		if (is_array($ips)) {
			foreach ($ips as $curip) {
				if ($this->ipmanager_check_ip_status($curip['ip']) == 0) {
					file_put_contents($GLOBALS['IPMANAGER_LISTIPS'], $curip['ip'] . '|0' . "\n", FILE_APPEND | LOCK_EX);
				}
				else {
					file_put_contents($GLOBALS['IPMANAGER_LISTIPS'], $curip['ip'] . '|1' . "\n", FILE_APPEND | LOCK_EX);
				}
			}
		}

		$res['code'] = 0;
		return $res;
	}

	public function getmainip()
	{
		$ips = $this->ipmanager_listips();
		$main_ip = $ips[0]['ip'];
		return $main_ip;
	}
}


?>
