<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class logging
{
	public $dir_logs_dir = '/home';
	public $logConfRotate = '/etc/brainy/data/logging/logwebserverrot';
	public $logGlobalConf = '/etc/logrotate.conf';
	public $confUserLogrot = '/etc/brainy/data/logging/users/';
	public $confUserDefault = '/etc/brainy/data/logging/defuser.conf';
	public $scriptRunRot = '/etc/cron.daily/logrotateuser';

	public function logging_get_log_list($group, $user = NULL, $domain = NULL, $from_replace = NULL, $to_replace = NULL)
	{
		if ($user && !$this->check_user($user)) {
			return 0;
		}

		$hostacc = new hostacc();
		$workspace = $hostacc->getWorkspace($user);

		if (0 < strlen($workspace)) {
			$workspace = $workspace . '/';
		}

		$webserver = new webserver();
		$domains = $webserver->webserver_getdomains($user);
		$backserver = $webserver->detect_back_server()['service'];
		$puny = new idna_convert();

		if ($user) {
			$out = $this->get_user_data($user);
			$rootdir = $out['rootdir'];
			$out = $this->filelist($rootdir . '/' . $workspace . 'log/', '!*gz');

			foreach ($out as $key => $value) {
				if (stripos($value, 'webaliz') === false) {
					if ($domain && (strripos($value, $domain) !== false)) {
						$namemass = 'dommass';
					}
					else {
						$namemass = 'newmass1';
					}

					$$namemass[$key]['path'] = $rootdir . '/' . $workspace . 'log/' . $value;
					$value_exp = explode('_', $value);
					$$namemass[$key]['name'] = $user . '-' . $puny->decode($value_exp[0]) . '_' . $value_exp[1];
				}
			}

			if ($backserver != 'nginx') {
				$base = $GLOBALS['HTTPD_VHOSTLOGS'];
			}
			else {
				$base = $GLOBALS['NGINX_VHOSTLOGS'];
			}

			$out = $this->filelist($base, '!*tar.gz');

			foreach ($out as $key => $value) {
				if (is_array($domains)) {
					foreach ($domains as $curdom) {
						if ((($curdom . '_access') == $value) || (($curdom . '_error') == $value)) {
							if ($domain && (strripos($value, $domain) !== false)) {
								$namemass = 'dommass';
							}
							else {
								$namemass = 'newmass1';
							}

							$$namemass[$key]['path'] = $base . $value;
							$value_exp = explode('_', $value);
							$$namemass[$key]['name'] = 'realtime-' . $user . '-' . $puny->decode($value_exp[0]) . '_' . $value_exp[1];
						}
					}
				}
			}
		}

		if (0 < count($dommass)) {
			$newmass1 = array_values(array_merge($dommass, $newmass1));
		}

		if ($group == 'admin') {
			$out = $this->read_file_n($GLOBALS['DATA_PATH'] . 'logging/log_list');

			foreach ($out as $key => $value) {
				$foo = explode('|', $value);

				if ($group == 'admin') {
					$newmass[$key]['path'] = $foo[0];
					$newmass[$key]['name'] = $foo[1];
					$newmass[$key]['user'] = $foo[2];
				}
				else if ($foo[2] == 2) {
					$newmass[$key]['path'] = str_replace($from_replace, $to_replace, $foo[0]);
					$newmass[$key]['name'] = str_replace($from_replace, $to_replace, $foo[1]);
					$newmass[$key]['user'] = $foo[2];
				}
			}
		}

		if (is_array($newmass1) && is_array($newmass)) {
			$fullmass = array_values(array_merge($newmass1, $newmass));
		}

		if (is_array($newmass1) && !is_array($newmass)) {
			$fullmass = array_values($newmass1);
		}

		if (!is_array($newmass1) && is_array($newmass)) {
			$fullmass = array_values($newmass);
		}

		return $fullmass;
	}

	public function logging_log_show($path, $from, $to, $search_string)
	{
		$to = intval($to);
		$from = intval($from);

		if (!$this->check_params('dir', $path)) {
			return false;
		}

		if (!$this->check_params('string', $search_string)) {
			return false;
		}

		$counter = $to + $from;

		if (!$search_string) {
			$zapr = 'tail -' . $counter . ' \'' . $path . '\' | head -n ' . $to;
		}
		else {
			$zapr = 'grep \'' . $search_string . '\'  \'' . $path . '\'| tail -' . $counter . ' | head -n ' . $to;
		}

		$out = $this->sudo_ssh($zapr);
		$out = implode("\n", $out);
		return $out;
	}

	public function logging_check_logrotate()
	{
		if (file_exists('/usr/sbin/logrotate')) {
			return 1;
		}

		return 0;
	}

	public function logging_install_logrotate()
	{
		$check = $this->logging_check_logrotate();

		if (!$check) {
			$this->sudo_ssh('yum -y install logrotate');
			$check = $this->logging_check_logrotate();
		}

		if (!$check) {
			return '0';
		}

		global $lang;
		$this->set_data(array('status' => $lang['logging_stat_ins']));
		return '1';
	}

	public function get_logrotate_status()
	{
		$out = $this->load_vars_m();
		global $lang;

		if ($out['status'] == 'enabled') {
			return $lang['logging_stat_ins'];
		}

		return $out['status'];
	}

	public function logging_list_logrotate()
	{
		$out = $this->filelist('/etc/brainy/src/logrotate/logs');
		$out1 = $this->filelist('/etc/logrotate.d');
		$out1_string = implode(' ', $out1);

		foreach ($out as $key => $value) {
			$newmass[$key]['name'] = $value;

			if (0 < substr_count($out1_string, $value)) {
				$newmass[$key]['enabled'] = 1;
			}
			else {
				$newmass[$key]['enabled'] = 0;
			}
		}

		return $newmass;
	}

	public function logging_gettorotation($item)
	{
		if (!$this->check_value('string', $item)) {
			return false;
		}

		if (!$item) {
			exit();
		}

		if (copy('/etc/brainy/src/logrotate/logs/' . $item, '/etc/logrotate.d/' . $item)) {
			return 1;
		}

		return 0;
	}

	public function logging_getfromrotation($item)
	{
		if (!$this->check_value('string', $item)) {
			return false;
		}

		if (!$item) {
			exit();
		}

		if (unlink('/etc/logrotate.d/' . $item)) {
			return 1;
		}

		return 0;
	}

	public function logging_get_userloglist($user = NULL)
	{
		if (!$user) {
			return 0;
		}

		if (!$this->check_user($user)) {
			return 0;
		}

		$hostacc = new hostacc();
		$workspace = $hostacc->getWorkspace($user);

		if (0 < strlen($workspace)) {
			$workspace = $workspace . '/';
		}

		$out = $this->get_user_data($user);
		$rootdir = $out['rootdir'];
		$out1 = $this->filelist($rootdir . '/' . $workspace . 'log/', '*gz');

		foreach ($out1 as $key => $value) {
			$out2[$key]['name'] = $value;
			$out2[$key]['path'] = $rootdir . '/' . $workspace . 'log/' . $value;
		}

		return $out2;
	}

	public function logging_go_proccess_archiving()
	{
		$arr = $this->logging_get_logs_httpd();

		foreach ($arr as $user => $val) {
			foreach ($val as $host => $file_c) {
				foreach ($file_c as $key => $file) {
					$i = 0;

					while ($i < 5) {
						$offset = $this->logging_get_offset($user, $file);
						$arr = $this->logging_read_file($user, $file, 0, $offset);
						$reload = $arr['reload'];
						$arr = $this->logging_save_tar($user, $file, $arr['filetmp'], $arr['date'], $arr['offset']);

						if ($reload == 'no') {
							break;
						}

						++$i;
					}
				}
			}
		}
	}

	public function logging_get_logs_httpd()
	{
		$web = new webserver();
		$users = $this->get_users();

		foreach ($users as $key => $user) {
			$hosts = $web->get_virt_hosts_quick($user);

			foreach ($hosts as $key_c => $host) {
				$host = escapeshellcmd($host);
				$arr[$user][$host] = $this->sudo_ssh('ls /etc/httpd/vhost_logs | grep \'' . $host . '_\' &>/dev/stdout');
			}
		}

		return $arr;
	}

	public function logging_get_offset($user, $file)
	{
		if (!$this->check_user($user)) {
			return 0;
		}

		$file = escapeshellcmd($file);
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$dir_file_tar = $confUser['rootdir'] . '/log/';
		$p = $this->sudo_ssh('ls ' . $dir_file_tar . ' | grep \'' . $file . '\' | sort -n &>/dev/stdout');

		if (!sizeof($p)) {
			$offset = 0;
			return $offset;
		}

		$last = explode('_', array_pop($p));
		$offset = substr($last[3], 0, -4);
		return $offset;
	}

	public function logging_read_file($user, $file = '', $i = 0, $offset = 0)
	{
		global $lang;

		if (!$this->check_user($user)) {
			return 0;
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$date = date('m-Y', time());
		$dir_filename = '/etc/httpd/vhost_logs/' . $file;
		$dir_filetmp = $confUser['rootdir'] . '/tmp';
		$filetmp = $confUser['rootdir'] . '/tmp/' . $file;
		$dir_file_tar = $confUser['rootdir'] . '/log/';
		$search_file_tar = escapeshellcmd($file . '_' . $date . '_');
		$p = $this->sudo_ssh('ls ' . $dir_file_tar . ' | grep \'' . $search_file_tar . '\' &>/dev/stdout');

		if (1 < sizeof($p)) {
			return array('err' => 4, 'mess' => 'error: found more than one file ' . $search_file_tar);
		}

		if (sizeof($p) == 1) {
			$file_tar = $confUser['rootdir'] . '/log/' . escapeshellcmd($p[0]);
		}
		else {
			$file_tar = $confUser['rootdir'] . '/log/' . 'not_found';
		}

		$this->sudo_ssh('mkdir -p ' . $dir_filetmp);

		if (!is_file($dir_filename)) {
			return array('err' => 1, 'mess' => 'file not found ' . $dir_filename, 'line' => 0, 'data' => 0, 'offset' => $offset, 'filetmp' => '');
		}

		if (filesize($dir_filename) == 0) {
			return array('err' => 2, 'mess' => 'file has zero length ' . $dir_filename, 'line' => 0, 'data' => 0, 'offset' => $offset, 'filetmp' => '', 'date' => $date);
		}

		if (strstr($file, '_access')) {
			$regex = '/^(\\S+) (\\S+) (\\S+) \\[([^:]+):(\\d+:\\d+:\\d+) ([^\\]]+)\\] \\"(\\S+) (.*?) (\\S+)\\" (\\S+) (\\S+) "([^"]*)" "([^"]*)"$/';
			$log_type = 'access';
		}
		else if (strstr($file, '_error')) {
			$regex = '/^\\[([^\\]]+)\\] \\[([^\\]]+)\\] (?:\\[client ([^\\]]+)\\])?\\s*(.*)$/i';
			$log_type = 'error';
		}
		else {
			return array('err' => 5, 'mess' => 'Unidentified log file format', 'file' => $file, 'date' => $date);
		}

		$h = fopen($dir_filename, 'r');

		if (is_file($file_tar)) {
			$file_tar = escapeshellcmd($file_tar);
			$this->sudo_ssh('cd ' . $dir_filetmp . ' && tar -xvf \'' . $file_tar . '\'');
			$offindex = explode('_', $file_tar);
			$t = fopen($filetmp, 'a+');
			$tar_found = 'yes';
		}
		else {
			$offindex = array();
			$t = fopen($filetmp, 'w+');
			$tar_found = 'no';
		}

		if (intval($offset) != 0) {
			fseek($h, $offset);
		}

		flock($t, LOCK_EX);
		$b = false;
		$reload = 'no';

		while (!feof($h)) {
			$offset_old = ftell($h);
			$buff = fgets($h, 4096);
			++$i;
			preg_match($regex, $buff, $return);

			if ($log_type == 'access') {
				$date_log = explode('/', $return[4]);
				$date_log_str = $this->logging_man_mn($date_log[1]) . '-' . $date_log[2];
			}
			else {
				$date_log = explode(' ', $return[1]);
				$date_log_str = $this->logging_man_mn($date_log[1]) . '-' . $date_log[4];
			}

			if (($date != $date_log_str) && ($date_log_str != '-') && !$b) {
				$reload = 'yes';
				$b = true;
				$date = $date_log_str;
			}

			if (($date != $date_log_str) && ($date_log_str != '-') && $b) {
				$offset = $offset_old;
				break;
			}

			fwrite($t, $buff);
		}

		flock($t, LOCK_UN);

		if (!$b) {
			$offset = ftell($h);
		}

		fclose($t);
		fclose($h);
		unset($t);
		unset($h);
		$file_tar = escapeshellcmd($file_tar);
		$this->sudo_ssh('rm -f \'' . $file_tar . '\' &>/dev/null');
		return array('arr' => 0, 'mess' => 'Done', 'filetmp' => $filetmp, 'filename' => $dir_filename, 'add_line' => $i, 'offset' => $offset, 'date' => $date, 'tar_found' => $tar_found, 'offindex' => $offindex, 'file_tar' => $file_tar, 'dir_file_tar' => $dir_file_tar, 'search_file_tar' => $search_file_tar, 'reload' => $reload, 'p' => $p, 'b' => $b);
	}

	public function logging_save_tar($user = '', $domain_file = '', $filetmp = '', $date = '', $offset = 0)
	{
		global $lang;

		if (!$date) {
			return array('err' => 1, 'mess' => 'error data format');
		}

		if (!$filetmp || !$domain_file) {
			return array('err' => 2, 'mess' => 'error file name');
		}

		if (!$user) {
			return array('err' => 3, 'mess' => 'user not found');
		}

		if (!$this->check_user($user)) {
			return 0;
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$dir = $confUser['rootdir'] . '/log';
		$this->sudo_ssh('mkdir -p ' . $dir . ' &>/dev/null');
		$file_tar = escapeshellcmd($dir . '/' . $domain_file);
		$dir_filetmp = escapeshellcmd(substr($filetmp, 0, strrpos($filetmp, '/')));
		$filetmp = escapeshellcmd($filetmp);
		$file_tarname_save = escapeshellcmd($file_tar . '_' . $date . '_' . $offset);
		$out = $this->sudo_ssh('rootenv=`pwd` && rm -f \'' . $file_tarname_save . '.tgz\'' . ' && cd \'' . $dir_filetmp . '\' && tar -czPf \'' . $file_tarname_save . '.tgz ./' . $domain_file . '\' && cd $rootenv &>/dev/null');
		$this->sudo_ssh('rm -f \'' . $filetmp . '\' && chown \'' . $user . '\' \'' . $file_tarname_save . '.tgz\'' . ' && chgrp \'' . $user . '\' \'' . $file_tarname_save . '.tgz\'' . ' &>/dev/null');
		$arr = array('err' => 0, 'tar_save_filename' => $file_tarname_save . '.tgz');
		return $arr;
	}

	public function logging_man_mn($m)
	{
		switch ($m) {
		case 'Jan':
			return 1;
		case 'Feb':
			return 2;
		case 'Mar':
			return 3;
		case 'Apr':
			return 4;
		case 'May':
			return 5;
		case 'Jun':
			return 6;
		case 'Jul':
			return 7;
		case 'Aug':
			return 8;
		case 'Sep':
			return 9;
		case 'Oct':
			return 10;
		case 'Nov':
			return 11;
		case 'Dec':
			return 12;
		}
	}

	public function loggingGetConfig($confFile = '')
	{
		if ($confFile == '') {
			$confFile = $this->logGlobalConf;
		}
		else {
			$confFile = $this->confUserLogrot . $confFile . '.conf';
		}

		$confData['period'] = array('hourly', 'daily', 'weekly', 'monthly');
		$confRowsDataFile = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($confFile));
		$curConf = array();
		$curConf['period'] = '';
		$curConf['rotate'] = 0;
		$curConf['compress'] = 'nocompress';
		$curConf['format'] = 'number';

		foreach ($confRowsDataFile as $key => $curRow) {
			if (20 < $key) {
				break;
			}

			$curRow = trim($curRow);

			if (in_array($curRow, $confData['period'])) {
				$curConf['period'] = $curRow;
			}

			if (stripos($curRow, 'rotate') === 0) {
				$test = explode(' ', $curRow);
				$count = intval($test[1]);

				if (0 < $count) {
					$curConf['rotate'] = $count;
				}
			}

			if (stripos($curRow, 'compress') === 0) {
				$curConf['compress'] = 'compress';
			}

			if ((stripos($curRow, 'nocompress') === 0) || (stripos($curRow, '#compress') === 0)) {
				$curConf['compress'] = 'nocompress';
			}

			if (stripos($curRow, 'dateext') === 0) {
				$curConf['format'] = 'dateext';
			}
		}

		return $curConf;
	}

	public function loggingSetConfigAll($period, $rotate, $compress, $format)
	{
		$users = $this->get_users();

		foreach ($users as $curUser) {
			$this->loggingSetConfig($period, $rotate, $compress, $format, $curUser);
		}

		global $lang;
		$res['code'] = 0;
		$res['message'] = $lang['logging_confLogrotSaveok'];
		return $res;
	}

	public function loggingSetConfig($period, $rotate, $compress, $format, $confFile = '')
	{
		switch ($confFile) {
		case '':
			$confFile = $this->logGlobalConf;
			break;
		}

		$confFile = $this->logGlobalConf . '.conf';
		$newVal['period'] = $period;
		$newVal['rotate'] = 'rotate ' . $rotate;
		$newVal['compress'] = $compress == 1 ? 'compress' : 'nocompress';
		$newVal['format'] = $format == 'dateext' ? 'dateext' : '#dateext';
		$confData['period'] = array('hourly', 'daily', 'weekly', 'monthly');
		$confRowsDataFile = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($confFile));
		$curConf = array();

		foreach ($confRowsDataFile as $key => $curRow) {
			if (20 < $key) {
				break;
			}

			$curRow = trim($curRow);

			if (in_array($curRow, $confData['period'])) {
				$curConf['period']['row'] = $key;
			}

			if (stripos($curRow, 'rotate') === 0) {
				$test = explode(' ', $curRow);
				$count = intval($test[1]);

				if (0 < $count) {
					$curConf['rotate']['row'] = $key;
				}
			}

			if ((stripos($curRow, 'compress') === 0) || (stripos($curRow, 'nocompress') === 0) || (stripos($curRow, '#compress') === 0)) {
				$curConf['compress']['row'] = $key;
			}

			if ((stripos($curRow, 'dateext') === 0) || (stripos($curRow, '#dateext') === 0)) {
				$curConf['format']['row'] = $key;
			}
		}

		foreach ($newVal as $keyParam => $setNewVal) {
			if (isset($curConf[$keyParam]['row'])) {
				$confRowsDataFile[$curConf[$keyParam]['row']] = $newVal[$keyParam];
			}
			else {
				array_unshift($confRowsDataFile, $setNewVal);
			}
		}

		file_put_contents($confFile, '');

		foreach ($confRowsDataFile as $curRow) {
			file_put_contents($confFile, $curRow . "\n", FILE_APPEND);
		}

		global $lang;
		$res['code'] = 0;
		$res['message'] = $lang['logging_confLogrotSaveok'];
		return $res;
	}

	public function setLogRotUserStat($stat = 0)
	{
		$resConfLog = json_decode(file_get_contents($this->logConfRotate), 1);
		$timeLast = 0;
		if (is_array($resConfLog) && isset($resConfLog['logrotstat'])) {
			$timeLast = $resConfLog['lasttime'];
		}

		$resConfLog['logrotstat'] = intval($stat);
		file_put_contents($this->logConfRotate, json_encode($resConfLog));

		if ($stat == 0) {
			$this->ssh('rm -f ' . $this->scriptRunRot);
		}

		if ($stat == 1) {
			file_put_contents($this->scriptRunRot, '#!/bin/sh' . "\n\n");
			$users = $this->get_users();
			$hostacc = new hostacc();
			$defaultConf = file_get_contents($this->confUserDefault);

			foreach ($users as $curUser) {
				$workspace = $hostacc->getWorkspace($curUser);

				if (0 < strlen($workspace)) {
					$workspace = $workspace . '/';
				}

				$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $curUser);

				if (!is_file($this->confUserLogrot . $curUser . '.conf')) {
					$valConfUserRot = str_replace('{$logdir}', $confUser['rootdir'] . '/' . $workspace . 'log', $defaultConf);
					file_put_contents($this->confUserLogrot . $curUser . '.conf', $valConfUserRot);
				}

				file_put_contents($this->scriptRunRot, '/usr/sbin/logrotate -s /var/lib/logrotate/logrotate.status ' . $this->confUserLogrot . $curUser . '.conf' . "\n", FILE_APPEND);
			}

			file_put_contents($this->scriptRunRot, 'EXITVALUE=$?' . "\n" . 'if [ $EXITVALUE != 0 ]; then' . "\n" . '    /usr/bin/logger -t logrotate "ALERT exited abnormally with [$EXITVALUE]"' . "\n" . 'fi' . "\n" . 'exit 0', FILE_APPEND);
			$this->ssh('chmod 755 ' . $this->scriptRunRot);
		}

		global $lang;
		$res['code'] = 0;
		$res['message'] = $lang['logging_confLogrotEnDisOk'];
		return $res;
	}
}


?>
