<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class mailclient
{
	const PATH_TO_SCRIPTS = '/etc/brainy/ssh/mailserver/';

	private $_connection;
	static private $_instance;
	private $_host;
	private $_username;
	private $_password;
	private $_database;
	public $COMMANDS = array('check', 'addmail', 'deletemail', 'addforward_email', 'deleteforward_email', 'addforward_domain', 'deleteforward_domain');
	public $COMMANDS2 = array('start', 'stop', 'restart', 'install', 'delete', 'reinstall', 'remove', 'install1', 'install2', 'on', 'off');
	public $SERVICES = array('dovecot', 'exim', 'postfix', 'clamav', 'clamd@scan', 'spamassassin', 'opendkim', 'roundcube', 'webmaillite', 'squirrelmail', 'mailserver');
	private $path_log_exim = '/var/log/exim';
	public $failedconn = array();

	public function getInstance()
	{
		if (!self::$_instance) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	public function __construct()
	{
		global $lang;
		$this->module_vars = $this->config_read('/etc/brainy/data/mailclient/db.cnf');
		$vars = $this->module_vars;
		$this->_host = $vars['host'];
		$this->_username = $vars['username'];
		$this->_password = $vars['password'];
		$this->_database = $vars['database'];
		$this->_connection = new mysqli($this->_host, $this->_username, $this->_password, $this->_database);

		if (0 < mysqli_connect_errno()) {
			$this->failedconn['errordb'] = mysqli_connect_errno();
			$this->failedconn['errmessagedb'] = mysqli_connect_error();
			return $this->failedconn;
		}

		if (mysqli_connect_error()) {
			trigger_error($lang['msg_mail_err_mysql_connect'] . mysqli_connect_error(), 256);
		}
	}

	private function __clone()
	{
	}

	public function getConnection()
	{
		return $this->_connection;
	}

	public function mailclient_get_service_status($service)
	{
		if (!$this->check_value('string', $service)) {
			return 0;
		}

		$arr = $this->mailclient_get_version();
		$maping = array('opendkim' => 'dkim', 'spamassassin' => 'antispam', 'clamav' => 'antivirus');
		$result['install'] = $arr[$maping[$service]] == 'Not installed' ? false : true;
		$result['available'] = $this->mailclient_get_available($service);
		return $result;
	}

	public function get_email($user)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		$db = self::getInstance();

		if (is_array($db)) {
			return $db;
		}

		$mysqli = $db->getConnection();
		$sql_query = 'SELECT username FROM mailbox WHERE name=\'' . $user . '\'';

		if ($res = $mysqli->query($sql_query)) {
			while ($row = $res->fetch_row()) {
				$result[] = $row[0];
			}
		}
		else {
			$result = NULL;
		}

		return $result;
	}

	public function add_remove_group_mailing($user, $group, $action)
	{
		global $lang;

		if (!$this->check_value('user', $user)) {
			$arr['code'] = 1;
			$arr['message'] = $lang['mailclient_not_user'];
		}

		if (!preg_match('/^[a-z0-9_-]{3,}$/i', $group)) {
			$arr['code'] = 2;
			$arr['message'] = $lang['mailclient_error_group'];
		}
		if ($arr) {
			return $arr;
		}

		$data_user = $this->config_read('/etc/brainy/data/users/' . $user);
		$path_dir_mailing = $data_user['rootdir'] . '/mailing';

		switch ($action) {
		case 'add_group':
			if (!file_exists($path_dir_mailing)) {
				$this->ssh('mkdir ' . $path_dir_mailing);
				$this->ssh('chown ' . $user . ':' . $user . ' ' . $path_dir_mailing);
			}

			if (!file_exists($path_dir_mailing . '/group_' . $group)) {
				$this->write_file('', $path_dir_mailing . '/group_' . $group, 'r', $user);

				if ($group == 'black-list') {
					$this->write_file($group . '|0' . PHP_EOL, $path_dir_mailing . '/list_group', 'wa', $user);
				}
				else {
					$this->write_file($group . '|0' . PHP_EOL, $path_dir_mailing . '/list_group', 'wb', $user);
				}

				$arr['code'] = 0;
				$arr['message'] = $lang['mailclient_group_file_suceesuele'];
			}
			else {
				$arr['code'] = 3;
				$arr['message'] = $lang['mailclient_error_group_file'];
			}

			break;

		case 'remove_group':
			$this->del_string($group . '|', $path_dir_mailing . '/list_group');
			$this->ssh('rm -rf ' . $path_dir_mailing . '/group_' . $group);
			$arr['code'] = 0;
			$arr['message'] = $lang['mailclient_succes_remove'];
			break;
		}
	}

	public function delete_create_mailing($user, $id)
	{
		global $lang;

		if (!$this->check_value('user', $user)) {
			$return_array['code'] = 1;
			$return_array['message'] = $lang['mailclient_not_user'];
		}

		if (!preg_match('/^[0-9a-z_]+$/i', $id)) {
			$return_array['code'] = 2;
			$return_array['message'] = $lang['mailclient_error_id'];
		}
		if ($return_array) {
			return $return_array;
		}

		$data_user = $this->config_read('/etc/brainy/data/users/' . $user);
		$path_dir_mailing = $data_user['rootdir'] . '/mailing';
		$out = $this->read_file_n($path_dir_mailing . '/create_mailing');

		foreach ($out as $val) {
			if (preg_match('/^' . $id . '/i', $val)) {
				$array_date = explode(',', trim($val));

				if ($array_date[2] == 0) {
					$crontab = new crontab();
					$dir = $GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/crontab/crontab';
					$this->del_string_new($id, $dir);
					$crontab->crontab_load('root');
				}
			}
		}

		$this->del_string($id, $path_dir_mailing . '/create_mailing');
		$this->ssh('rm -rf ' . $path_dir_mailing . '/' . $id);
		$name_file = str_replace('create_', 'statistic_', $id);
		$this->ssh('rm -rf ' . $path_dir_mailing . '/' . $name_file);
		$return_array['code'] = 0;
		$return_array['message'] = $lang['mailclient_succec_remove'];
		return $return_array;
	}

	public function show_statistic_mailing($user, $id)
	{
		global $lang;

		if (!$this->check_value('user', $user)) {
			$return_array['code'] = 1;
			$return_array['message'] = $lang['mailclient_not_user'];
		}

		if (!preg_match('/^[0-9a-z_]+$/i', $id)) {
			$return_array['code'] = 2;
			$return_array['message'] = $lang['mailclient_error_id'];
		}
		if ($return_array) {
			return $return_array;
		}

		$data_user = $this->config_read('/etc/brainy/data/users/' . $user);
		$path_dir_mailing = $data_user['rootdir'] . '/mailing';
		$array_m = $this->read_file_n($path_dir_mailing . '/' . $id);
		$send = 0;
		$all = 0;

		foreach ($array_m as $val_m) {
			if ($val_m) {
				++$all;
				$out = explode(',', $val_m);

				if ($out[1]) {
					++$send;
				}
			}
		}

		$name_file = str_replace('create_', 'statistic_', $id);

		if (!is_file($path_dir_mailing . '/' . $name_file)) {
			$array['open'] = 0;
			$redirect = 0;
		}
		else {
			$array_o = $this->config_read($path_dir_mailing . '/' . $name_file);

			foreach ($array_o as $key_o => $val_o) {
				if ($key_o == 'open') {
					$array['open'] = $array_o['open'];
				}
				else if ($key_o) {
					$redirect += $array_o[$key_o];
					$array['redirect_array'][] = array($key_o, $val_o);
				}
			}
		}

		$array['redirect'] = $redirect;
		$array['send'] = $send;
		$array['all'] = $all;
		$array['blocking'] = $all - $send;
		return $array;
	}

	public function check_data_mailing($user, $email_user, $name_user, $group, $action, $lastname2 = '', $phone = '', $address = '')
	{
		global $lang;

		if (!$this->check_value('user', $user)) {
			$return_array['code'] = 1;
			$return_array['message'] = $lang['mailclient_not_user'];
		}

		if (!$this->check_value('email', $email_user)) {
			$return_array['code'] = 2;
			$return_array['message'] = $lang['mailclient_not_email_reg'];
		}

		if (!preg_match('/^[a-zа-яЁё\']*$/iu', $name_user) || !preg_match('/^[a-zа-яЁё\']*$/iu', $lastname2)) {
			$return_array['code'] = 3;
			$return_array['message'] = $lang['mailclient_name_user_error'];
		}

		if (!$this->check_value('strdot', $group)) {
			$return_array['code'] = 4;
			$return_array['message'] = $lang['mailclient_error_group'];
		}

		if (!preg_match('/^[a-z_]*$/i', $action)) {
			$return_array['code'] = 5;
			$return_array['message'] = $lang['mailclient_error_active'];
		}

		if (!preg_match('/^[0-9\\+\\-\\: ]*$/i', $phone)) {
			$return_array['code'] = 6;
			$return_array['message'] = $lang['mailclient_phone_error'];
		}

		if (!preg_match('/^[a-zA-Zа-яёЁ0-9_ ;,\\-\\.\\+\\: ]*$/iu', $address)) {
			$return_array['code'] = 7;
			$return_array['message'] = $lang['mailclient_address_error'];
		}

		return $return_array;
	}

	public function hesh_str($str)
	{
		$str_decode = base64_encode($str);
		$solt = $this->gen_pass(10);
		$str_decode_solt = base64_encode($solt . $str_decode);
		$num_qw = substr_count($str_decode_solt, '=');
		return preg_replace('/={1,}$/i', $num_qw, $str_decode_solt);
	}

	public function send_mailing($user, $group, $id_message, $name_send, $from = '')
	{
		$data_user = $this->config_read('/etc/brainy/data/users/' . $user);
		$path_dir_mailing = $data_user['rootdir'] . '/mailing';
		$out_message = $this->read_file_n($path_dir_mailing . '/list_message');
		$out_group = $this->read_file_n($path_dir_mailing . '/group_' . $group);

		foreach ($out_message as $val_message) {
			if (preg_match('/^' . $id_message . '/i', $val_message)) {
				$data_message = explode('|', $val_message);
			}
		}

		if (!is_file($path_dir_mailing . '/create_mailing')) {
			$this->write_file('', $path_dir_mailing . '/create_mailing', 'r', $user);
		}

		$ip = $this->get_real_server_ip();
		$date = date('Y-m-d h:i:s');
		$send_num = 0;
		$not_send_num = 0;

		foreach ($out_group as $val_group) {
			$message = $this->read_file($data_user['rootdir'] . '/mailing/' . $data_message[0]);
			$val_group = trim($val_group);
			$data_val_group = explode('|', $val_group);
			$data_group = explode(',', $data_val_group[0]);
			$send = explode(',', $data_val_group[1])[0];
			$subject = $data_message[1];
			$str_email = 'unsubscribe|' . $user . '|' . $group . '|' . $data_group[0];
			$str_decode_solt = $this->hesh_str($str_email);
			$data_group[10] = '<a href=\'http://' . $ip . ':8002/scripts/create_mailing.php?data=' . $str_decode_solt . '\'>';
			$data_group[11] = '</a>';
			$preg_replacments[0] = '/{\\$email}/';
			$preg_replacments[1] = '/{\\$name}/';
			$preg_replacments[2] = '/{\\$lastname}/';
			$preg_replacments[3] = '/{\\$phone}/';
			$preg_replacments[4] = '/{\\$address}/';
			$preg_replacments[5] = '/{\\$other1}/';
			$preg_replacments[6] = '/{\\$other2}/';
			$preg_replacments[7] = '/{\\$other3}/';
			$preg_replacments[8] = '/{\\$other4}/';
			$preg_replacments[9] = '/{\\$other5}/';
			$preg_replacments[10] = '/&lt;unsubscribe&gt;/';
			$preg_replacments[11] = '/&lt;\\/unsubscribe&gt;/';
			preg_match_all('/<a[^>]+href="?\'?([^"\']+)"?\'?[^>]*>/i', $message, $result, PREG_SET_ORDER);

			foreach ($result as $val) {
				$str_code = $data_group[0] . '|' . $val[1] . '|' . $name_send . '|' . $path_dir_mailing . '|' . $user;
				$str_decode_s = $this->hesh_str($str_code);
				$message = str_replace('href="' . $val[1] . '"', 'href="http://' . $ip . ':8002/scripts/redirect_mailing.php?data=' . $str_decode_s . '"', $message);
			}

			$message = preg_replace($preg_replacments, $data_group, $message);
			$subject = preg_replace($preg_replacments, $data_group, $subject);
			$to = $data_group[0];
			$from = trim($from);
			$headers = 'Content-type: text/html; charset="utf-8"' . "\r\n";
			$headers .= 'MIME-Version: 1.0' . "\r\n";
			$headers .= 'From: =?utf-8?B?' . base64_encode($from) . '?= <' . $from . '> ' . "\r\n";
			$headers .= 'Date: ' . date('D, d M Y h:i:s O') . "\r\n";
			$id_img = $this->hesh_str($to . '|' . $name_send . '|' . $path_dir_mailing . '|' . $user);
			$local_ip = $this->get_real_server_ip();
			$message .= '<img src="http://' . $local_ip . ':8002/scripts/statistic_mailing.php?data=' . $id_img . '" alt="" />';
			$num_send_out = explode(',', $data_val_group[2]);

			if (!$num_send_out[0]) {
				$num_send_out[0] = 0;
			}

			if ($send == 1) {
				if (mail($to, '=?utf-8?b?' . base64_encode($subject) . '?=', $message, $headers, '-f' . $from)) {
					++$send_num;
					++$num_send_out[0];
					$this->write_file($to . ',1,' . $date . ',0' . PHP_EOL, $path_dir_mailing . '/' . $name_send, 'wb', $user);
				}
				else {
					$this->write_file($to . ',0,' . $date . ',0' . PHP_EOL, $path_dir_mailing . '/' . $name_send, 'wb', $user);
					++$not_send_num;
				}
			}
			else {
				$this->write_file($to . ',0,' . $date . ',0' . PHP_EOL, $path_dir_mailing . '/' . $name_send, 'wb', $user);
				++$not_send_num;
			}

			$data_val_group[2] = implode(',', $num_send_out);
			$new_array_group[] = implode('|', $data_val_group);
		}

		$out_create_mailing = $this->read_file_n($path_dir_mailing . '/create_mailing');

		foreach ($out_create_mailing as $key_create => $val_create) {
			if (preg_match('/^' . $name_send . '/i', $val_create)) {
				$array_line = explode('|', trim($val_create));
				$array_line[2] = 1;
				$array_line[5] = $send_num;
				$array_line[6] = $not_send_num;
				$out_create_mailing[$key_create] = implode('|', $array_line) . PHP_EOL;
			}
		}

		$this->write_file(implode(PHP_EOL, $new_array_group), $path_dir_mailing . '/group_' . $group, 'r', $user);
		$this->write_file(implode('', $out_create_mailing), $path_dir_mailing . '/create_mailing', 'r', $user);
	}

	public function show_create_mailing($user)
	{
		if (!$this->check_value('user', $user)) {
			$return_array['code'] = 1;
			$return_array['message'] = $lang['mailclient_not_user'];
		}
		if ($return_array) {
			return $return_array;
		}

		$data_user = $this->config_read('/etc/brainy/data/users/' . $user);
		$path_dir_mailing = $data_user['rootdir'] . '/mailing';
		$out_mailing = $this->read_file_n($path_dir_mailing . '/create_mailing');

		foreach ($out_mailing as $val) {
			if ($val) {
				$return_array[] = explode('|', $val);
			}
		}

		return $return_array;
	}

	public function create_mailing($user, $data)
	{
		global $lang;
		$data = (array) json_decode($data);

		if (!$this->check_value('user', $user)) {
			$return_array['code'] = 1;
			$return_array['message'] = $lang['mailclient_not_user'];
		}

		if (!preg_match('/^[a-z0-9_]+$/i', $data['id_message'])) {
			$return_array['code'] = 2;
			$return_array['message'] = $lang['mailclient_error_id'];
		}

		if (!$this->check_value('strdot', $data['group']) || empty($data['group'])) {
			$return_array['code'] = 3;
			$return_array['message'] = $lang['mailclient_error_group'];
		}

		if ((!$this->check_value('email', $data['email_recipient']) || empty($data['email_recipient'])) && ($data['action'] == 'create_test')) {
			$return_array['code'] = 2;
			$return_array['message'] = $lang['mailclient_not_email_reg'];
		}

		if (!$this->check_value('email', $data['from']) || empty($data['from'])) {
			$return_array['code'] = 4;
			$return_array['message'] = $lang['mailclient_not_email_reg'];
		}
		if ($return_array) {
			return $return_array;
		}

		$data_user = $this->config_read('/etc/brainy/data/users/' . $user);
		$path_dir_mailing = $data_user['rootdir'] . '/mailing';

		if (!is_file($path_dir_mailing . '/create_mailing')) {
			$this->write_file('', $path_dir_mailing . '/create_mailing', 'r', $user);
		}

		$out_group = $this->read_file_n($path_dir_mailing . '/group_' . $data['group']);
		$out_message = $this->read_file_n($path_dir_mailing . '/list_message');

		foreach ($out_message as $val_message) {
			if (preg_match('/^' . $data['id_message'] . '/i', $val_message)) {
				$data_message = explode('|', $val_message);
			}
		}

		$number_piople = count(array_diff($out_group, array('')));
		$name_send = 'create_' . (int) microtime(true);
		$date = date('Y-m-d h:i:s');
		$subject = $data_message[1];

		switch ($data['action']) {
		case 'create_test':
			$ip = $this->get_real_server_ip();

			foreach ($out_group as $key_group => $val_group) {
				$data_group = explode(',', explode('|', $val_group)[0]);

				if ($data_group[0] == $data['email_recipient']) {
					$str_email = 'unsubscribe|' . $user . '|' . $data['group'] . '|' . $data['email_recipient'];
					$str_decode_solt = $this->hesh_str($str_email);
					$data_group[10] = '<a href=\'http://' . $ip . ':8002/scripts/create_mailing.php?data=' . $str_decode_solt . '\'>';
					$data_group[11] = '</a>';
					break;
				}

				$data_group = '';
			}

			$message = $this->read_file($data_user['rootdir'] . '/mailing/' . $data_message[0]);
			$to = $data['email_recipient'];
			$preg_replacments[0] = '/{\\$email}/';
			$preg_replacments[1] = '/{\\$name}/';
			$preg_replacments[2] = '/{\\$lastname}/';
			$preg_replacments[3] = '/{\\$phone}/';
			$preg_replacments[4] = '/{\\$address}/';
			$preg_replacments[5] = '/{\\$other1}/';
			$preg_replacments[6] = '/{\\$other2}/';
			$preg_replacments[7] = '/{\\$other3}/';
			$preg_replacments[8] = '/{\\$other4}/';
			$preg_replacments[9] = '/{\\$other5}/';
			$preg_replacments[10] = '/&lt;unsubscribe&gt;/';
			$preg_replacments[11] = '/&lt;\\/unsubscribe&gt;/';
			preg_match_all('/<a[^>]+href="?\'?([^"\']+)"?\'?[^>]*>/i', $message, $result, PREG_SET_ORDER);

			foreach ($result as $val) {
				$str_code = $data['email_recipient'] . '|' . $val[1] . '|' . $name_send . '|' . $path_dir_mailing . '|' . $user;
				$str_decode_s = $this->hesh_str($str_code);
				$message = str_replace('href="' . $val[1] . '"', 'href="http://' . $ip . ':8002/scripts/redirect_mailing.php?data=' . $str_decode_s . '"', $message);
			}

			$message = preg_replace($preg_replacments, $data_group, $message);
			$subject = preg_replace($preg_replacments, $data_group, $subject);
			$from = trim($data['from']);
			$headers = 'Content-type: text/html; charset="utf-8"' . "\r\n";
			$headers .= 'MIME-Version: 1.0' . "\r\n";
			$headers .= 'From: =?utf-8?B?' . base64_encode($from) . '?= <' . $from . '> ' . "\r\n";
			$headers .= 'Date: ' . date('D, d M Y h:i:s O') . "\r\n";
			$num_send = 0;
			$not_num_send = 0;
			$id_img = $this->hesh_str($to . '|' . $name_send . '|' . $path_dir_mailing . '|' . $user);
			$message .= '<img src="http://' . $ip . ':8002/scripts/statistic_mailing.php?data=' . $id_img . '" alt="">';

			if (mail($to, '=?utf-8?b?' . base64_encode($subject) . '?=', $message, $headers, '-f' . $from)) {
				$return_array['code'] = 0;
				$num_send = 1;
				$return_array['message'] = $lang['mailclient_send_succec'];
				$this->write_file($to . ',1,' . $date . ',0' . PHP_EOL, $path_dir_mailing . '/' . $name_send, 'r', $user);

				foreach ($out_group as $key_group => $val_group) {
					$val_group = trim($val_group);

					if (preg_match('/^' . $data['email_recipient'] . '/i', $val_group)) {
						$check_rewrite = 1;
						$out_val = explode('|', $val_group);
						$detail_val = explode(',', $out_val[2]);

						if (!$detail_val[0]) {
							$detail_val[0] = 0;
						}

						++$detail_val[0];
						$out_val[2] = implode(',', $detail_val);
						$new_array_group[$key_group] = implode('|', $out_val);
					}
					else {
						$new_array_group[$key_group] = $val_group;
					}
				}
			}
			else {
				$not_num_send = 1;
				$return_array['code'] = 10;
				$return_array = $lang['mailclient_send_error'];
				$this->write_file($to . ',0,' . $date . ',0' . PHP_EOL, $path_dir_mailing . '/' . $name_send, 'r', $user);
			}

			$this->write_file($name_send . '|' . $data['group'] . '|1|' . trim($subject) . '|1|' . $num_send . '|' . $not_num_send . '|' . $date . PHP_EOL, $path_dir_mailing . '/create_mailing', 'wb', $user);

			if ($check_rewrite) {
				$this->write_file(implode(PHP_EOL, $new_array_group), $path_dir_mailing . '/group_' . $data['group'], 'r', $user);
			}

			break;

		case 'send_now':
			$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/create_mailing.php ' . $user . ' ' . $data['group'] . ' ' . $data['id_message'] . ' ' . $name_send . ' ' . $data['from'];

			if ($this->create_stream($stream)) {
				$this->write_file($name_send . '|' . $data['group'] . '|0|' . trim($subject) . '|' . $number_piople . '|0|0|' . $date . PHP_EOL, $path_dir_mailing . '/create_mailing', 'wb', $user);
				$return_array['code'] = 0;
				$return_array['message'] = $lang['mailclient_add_mailing_send'];
			}
			else {
				$return_array['code'] = 10;
				$return_array = $lang['mailclient_send_error'];
			}

			break;

		case 'add_cron_mailing':
			list($s_e, $s_m, $s_d, $s_h, $r_min, $s_sec) = explode('-', implode('', $this->ssh('date +"%Y-%m-%d-%H-%M-%S"')));

			foreach ($data['data_cron'] as $val_data_cron) {
				$val_data_cron = (array) $val_data_cron;
				$data_cron[$val_data_cron['name']] = $val_data_cron['value'];
			}

			$data_cron['days'] = explode('-', $data_cron['data'])[2];
			$data_cron['months'] = explode('-', $data_cron['data'])[1];
			$data_cron['year'] = explode('-', $data_cron['data'])[0];
			$server_date_u = mktime($s_h, $r_min, $s_sec, $s_m, $s_d, $s_e);
			$user_date_u = mktime($data_cron['hours'], $data_cron['minutes'], '00', $data_cron['months'], $data_cron['days'], $data_cron['year']);

			if ($user_date_u <= $server_date_u) {
				$return_array['code'] = 5;
				$return_array['message'] = $lang['mailclient_not_ecvaldata_time'];

				return $return_array;
			}

			$crontab = new crontab();
			$num_work = (int) microtime(true) . rand(0, 1000);
			$this->write_file($name_send . '|' . $data['group'] . '|0|' . trim($subject) . '|' . $number_piople . '|0|0|' . $data_cron['data'] . ' ' . $data_cron['hours'] . ':' . $data_cron['minutes'] . ':00' . PHP_EOL, $path_dir_mailing . '/create_mailing', 'wb', $user);
			$cron_command = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/create_mailing.php ' . $user . ' ' . $data['group'] . ' ' . $data['id_message'] . ' ' . $name_send . ' ' . $data['from'] . ' ' . $num_work;
			$return_array = $crontab->crontab_cronjob_add($data_cron['minutes'], $data_cron['hours'], $data_cron['days'], $data_cron['months'], '*', $cron_command);

			if ($return_array['code'] == 0) {
				$return_array['message'] = $lang['mailclient_add_mailing_send'];
			}

			break;
		}

		return $return_array;
	}

	public function add_user_money_prepare($user, $data, $files = NULL)
	{
		global $lang;

		if (!$this->check_value('user', $user)) {
			return false;
		}

		$name_file = 'prepare_' . (int) microtime(true);
		$data_user = $this->config_read('/etc/brainy/data/users/' . $user);
		$path_dir_temp = $data_user['rootdir'] . '/tmp';

		if ($files) {
			foreach ($files as $file) {
				if (mime_content_type($file['tmp_name']) == 'text/plain') {
					if (move_uploaded_file($file['tmp_name'], $data_user['rootdir'] . '/tmp/' . $name_file)) {
						$data = file_get_contents($path_dir_temp . '/' . $name_file);
					}
					else {
						$return_array['code'] = 11;
						$return_array['message'] = $lang['mailclient_error_file_save'];
					}
				}
				else {
					$return_array['code'] = 12;
					$return_array['message'] = $lang['mailclient_error_file_data'];
				}
			}
		}

		$data = explode(PHP_EOL, $data);
		$count_field = 0;

		foreach ($data as $val) {
			$array = preg_split('/[|,;:' . "\t" . ']+/', $val);
			$num = 0;
			$count_str = count($array);

			if ($count_field <= $count_str) {
				$count_field = $count_str;
			}

			$chech_email = 0;

			foreach ($array as $val1) {
				if (preg_match('/^.+@.+[.]+.+$/i', $val1)) {
					$array_user[0] = trim($val1);
					$chech_email = 1;
				}
				else if (!preg_match('/^([0-9а-яa-zЁё _.-@\\"\' ]*)$/iu', trim($val1))) {
					$array_user[++$num] = trim(utf8_encode($val1));
				}
				else {
					$array_user[++$num] = trim($val1);
				}
			}

			if ($chech_email) {
				$arraynew_user['array'][] = $array_user;
			}

			$arraynew_user['count'] = $count_field;
		}

		if ($arraynew_user['array']) {
			$arraynew_user['name_file'] = $name_file;
			$this->write_file(serialize($arraynew_user), $path_dir_temp . '/' . $name_file, 'r', $user);
		}

		return $arraynew_user;
	}

	public function get_lang_user($user)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		return $this->config_read('/etc/brainy/data/users/' . $user)['language'];
	}

	public function edit_user_mailing($user, $email_user, $group, $value)
	{
		global $lang;
		$return_array = $this->check_data_mailing($user, $email_user, '', $group, '', '', '', '');

		if (!$this->check_value('number', $value)) {
			$return_array['code'] = 8;
			$return_array['message'] = $lang['mailclient_not_number'];
		}
		if ($return_array) {
			return $return_array;
		}

		$data_user = $this->config_read('/etc/brainy/data/users/' . $user);
		$path_dir_mailing = $data_user['rootdir'] . '/mailing';

		if (!is_file($path_dir_mailing . '/group_' . $group)) {
			$return_array['code'] = 9;
			$return_array['message'] = $lang['mailclient_not_file'];
			return $return_array;
		}

		$old_file_list = $this->read_file_n($path_dir_mailing . '/group_' . $group);

		foreach ($old_file_list as $key => $val) {
			if (preg_match('/^' . $email_user . '/i', $val)) {
				if ($value == 1) {
					$value = 0;
				}
				else {
					$value = 1;
				}

				$data1 = explode('|', $val);
				$data = explode(',', $data1[1]);
				$data[0] = $value;
				$data1[1] = trim(implode(',', $data));
				$array_new_list_user[] = trim(implode('|', $data1)) . PHP_EOL;
			}
			else if ($val) {
				$array_new_list_user[] = $val;
			}
		}

		$this->write_file(implode('', $array_new_list_user), $path_dir_mailing . '/group_' . $group, 'r', $user);

		if ($value == 1) {
			$return_array['message'] = $lang['mailclient_add_send'];
		}
		else {
			$return_array['message'] = $lang['mailclient_remove_send'];
		}

		return $return_array;
	}

	public function add_user_mailing($user, $email_user = '', $name_user = '', $group, $action, $lastname2 = '', $phone = '', $address = '', $file_prepare = '', $array_data_user = '', $user_value = '')
	{
		global $lang;
		$return_array = $this->check_data_mailing($user, $email_user, $name_user, $group, $action, $lastname2, $phone, $address);

		if ($return_array) {
			return $return_array;
		}

		$data_user = $this->config_read('/etc/brainy/data/users/' . $user);
		$path_dir_mailing = $data_user['rootdir'] . '/mailing';
		if (((empty($user) || empty($email_user) || empty($group)) && ($action == 'add_user')) || ((empty($user) || empty($email_user) || empty($group)) && ($action == 'remove_user'))) {
			$return_array['code'] = 8;
			$return_array['message'] = $lang['mailclient_not_all_data'];
		}
		else {
			if ($action == 'add_black_list') {
				$this->add_remove_group_mailing($user, 'black-list', 'add_group');
			}

			$out = $this->read_file_n($path_dir_mailing . '/list_group');

			foreach ($out as $key => $val) {
				$arr_explode = explode('|', $val);
				$num_old_piople = (int) $arr_explode[1];

				if ($arr_explode[0] == $group) {
					$date = date('Y-m-d');

					if (is_file($path_dir_mailing . '/group_black-list')) {
						$old_file_black_list = $this->read_file_n($path_dir_mailing . '/group_black-list');
					}

					switch ($action) {
					case 'add_user':
						$old_file_list = $this->read_file_n($path_dir_mailing . '/group_' . $group);

						foreach ($old_file_list as $val_old_file) {
							if (preg_match('/^' . $email_user . '/i', $val_old_file)) {
								$error_email = 1;
							}
						}

						if ($old_file_black_list) {
							foreach ($old_file_black_list as $val_black_list) {
								if (preg_match('/^' . $email_user . '/i', $val_black_list)) {
									$error_email_black = 1;
								}
							}
						}

						if (($error_email != 1) && ($error_email_black != 1)) {
							$user_value = implode(',', $user_value);
							$this->write_file($email_user . ',' . $name_user . ',' . $lastname2 . ',' . $phone . ',' . $address . ',' . $user_value . '|1,' . $date . '|0' . PHP_EOL, $path_dir_mailing . '/group_' . $group, 'wb', $user);
							$number_piople = $num_old_piople + 1;
							$return_array['message'] = $lang['mailclient_succesfulle_add_user'];
						}
						else if ($error_email == 1) {
							$number_piople = $num_old_piople;
							$return_array['message'] = $lang['mailclient_parse_email'];
						}
						else if ($error_email_black == 1) {
							$number_piople = $num_old_piople;
							$return_array['message'] = $lang['mailclient_add_black_list_succ_user'];
						}

						$out[$key] = $group . '|' . $number_piople . PHP_EOL;
						$return_array['code'] = 0;
						$return_array['number_piople'] = $number_piople;
						break;

					case 'remove_user':
						sleep(1);
						$old_file_list = $this->read_file_n($path_dir_mailing . '/group_' . $group);

						foreach ($old_file_list as $val_old_file) {
							$array_email_list[] = explode(',', explode('|', $val_old_file)[0])[0];
						}

						if (in_array($email_user, $array_email_list)) {
							$this->del_string($email_user, $path_dir_mailing . '/group_' . $group);
						}

						$number_piople = count(array_diff($this->read_file_n($path_dir_mailing . '/group_' . $group), array('')));
						$out[$key] = $group . '|' . $number_piople . PHP_EOL;
						$return_array['code'] = 0;
						$return_array['message'] = $email_user . '  ' . $lang['mailclient_remove_succesfully'];
						$return_array['number_piople'] = $number_piople;
						break;

					case 'add_black_list':
						$data_black_list = '';
						$old_file_list = $this->read_file_n($path_dir_mailing . '/group_' . $group);

						foreach ($old_file_list as $val_old_file) {
							$array_email_list[] = explode(',', explode('|', $val_old_file)[0])[0];

							if (preg_match('/^' . $email_user . '/i', $val_old_file)) {
								$data_black_list = trim($val_old_file);
							}
						}

						if (in_array($email_user, $array_email_list)) {
							$this->del_string($email_user, $path_dir_mailing . '/group_' . $group);
							$this->write_file($data_black_list . PHP_EOL, $path_dir_mailing . '/group_black-list', 'wb', $user);
							$add_black = 1;
						}

						$number_piople = count(array_diff($this->read_file_n($path_dir_mailing . '/group_' . $group), array('')));
						$out[$key] = $group . '|' . $number_piople . PHP_EOL;
						$return_array['code'] = 0;
						$return_array['message'] = $email_user . '  ' . $lang['mailclient_add_black_list_succ'];
						$return_array['number_piople'] = $number_piople;
						break;

					case 'add_user_prepare':
						if (!is_file($data_user['rootdir'] . '/tmp/' . $file_prepare)) {
							$return_array['code'] = 9;
							$return_array['message'] = $lang['mailclient_not_file_prepere'];
						}
						if ($return_array) {
							return $return_array;
						}

						$out_array_prepare = (array) unserialize(file_get_contents($data_user['rootdir'] . '/tmp/' . $file_prepare));
						$old_file_list = $this->read_file_n($path_dir_mailing . '/group_' . $group);
						$error_str = 0;
						$error_email = 0;
						$error_email_black = 0;
						$array_check_user = '';

						foreach ($old_file_list as $val_old_file) {
							$array_email_list[] = explode(',', explode('|', $val_old_file)[0])[0];
						}

						if ($old_file_black_list && ($group != 'black-list')) {
							foreach ($old_file_black_list as $val_black_list) {
								$array_email_black_list[] = explode(',', explode('|', $val_black_list)[0])[0];
							}
						}

						foreach ($out_array_prepare['array'] as $key_array => $val_array) {
							$dataaaa = NULL;

							foreach ($array_data_user as $key_user => $val_user) {
								if (0 <= $val_user) {
									$dataaaa[$val_user] = $val_array[$key_user];
								}
							}

							if ($dataaaa) {
								$j = 0;

								while ($j < 10) {
									if (!$dataaaa[$j]) {
										$dataaaa[$j] = '';
									}

									++$j;
								}

								ksort($dataaaa);

								if (!$this->check_data_mailing('', $dataaaa[0], $dataaaa[1], '', '', $dataaaa[2], $dataaaa[3], $dataaaa[4])) {
									if (preg_match('/^([a-zA-Z0-9_\\.\\-]+)@([a-zA-Z0-9_\\.\\-]+)\\.([a-zA-Z0-9\\.\\-]{2,20})$/', $dataaaa[0])) {
										if (!in_array($dataaaa[0], $array_check_user)) {
											$nnn = 0;

											if (in_array($dataaaa[0], $array_email_list)) {
												$nnn = 1;
												++$error_email;
											}

											if (in_array($dataaaa[0], $array_email_black_list)) {
												$nnn = 1;
												++$error_email_black;
											}

											if (($nnn == 0) && $dataaaa) {
												$clear_data[] = implode(',', $dataaaa) . '|1,' . $date . '|0';
											}
										}
										else {
											++$error_email;
										}

										$array_check_user[] = $dataaaa[0];
									}
									else {
										++$error_str;
									}
								}
								else {
									++$error_str;
								}
							}
						}

						$number_piople = $num_old_piople + count($clear_data);
						$out[$key] = $group . '|' . $number_piople . PHP_EOL;

						if ($clear_data) {
							$this->write_file(implode(PHP_EOL, $clear_data) . PHP_EOL, $path_dir_mailing . '/group_' . $group, 'wb', $user);
						}

						$return_array['code'] = 0;
						$return_array['number_piople'] = $number_piople;
						$return_array['piople_add'] = count($clear_data);
						$return_array['num_email'] = $error_email;
						$return_array['num_black_list'] = $error_email_black;
						$return_array['error_str'] = $error_str;
						$this->ssh('rm -rf ' . $data_user['rootdir'] . '/tmp/prepare_*');
						break;
					}
				}
				else {
					break;
				}

				if (($arr_explode[0] == 'black-list') && ($action == 'add_black_list') && ($add_black == 1)) {
					$number_piople = count(array_diff($this->read_file_n($path_dir_mailing . '/group_black-list'), array('')));
					$out[$key] = 'black-list|' . $number_piople . PHP_EOL;
					$return_array['number_piople_black_list'] = $number_piople;
				}
			}

			$this->write_file(implode('', $out), $path_dir_mailing . '/list_group', 'r', $user);

			if (!$return_array) {
				$return_array['code'] = 400;
				$return_array['message'] = $lang['mailclient_error_add_user'];
			}
		}

		return $return_array;
	}

	public function show_create_mailing_detail($user, $id, $page = 1)
	{
		global $lang;

		if (!$this->check_value('user', $user)) {
			$return_array['code'] = 1;
			$return_array['message'] = $lang['mailclient_not_user'];
		}

		if (!preg_match('/^[0-9a-z_]+$/i', $id)) {
			$return_array['code'] = 2;
			$return_array['message'] = $lang['mailclient_error_id'];
		}
		if ($return_array) {
			return $return_array;
		}

		$data_user = $this->config_read('/etc/brainy/data/users/' . $user);
		$path_dir_mailing = $data_user['rootdir'] . '/mailing';
		$out = $this->read_file_n($path_dir_mailing . '/' . $id);
		$limit = 50;
		$num_begin = ($page - 1) * $limit;
		$end_begin = $page * $limit;
		$i = 0;
		$preg_replacments[0] = '/,0,/';
		$preg_replacments[1] = '/,1,/';
		$data_replaced[0] = ', ' . $lang['mailclient_send_not'] . ' ,';
		$data_replaced[1] = ', ' . $lang['mailclient_send_ok'] . ' ,';

		foreach ($out as $key => $val) {
			if (($num_begin <= $i) && ($i < $end_begin)) {
				$foo = preg_replace($preg_replacments, $data_replaced, $val);
				$out_array[$key] = explode(',', trim($foo));
			}

			++$i;
		}

		$out_array['detail'] = $out_array;
		$out_array['user'] = $user;
		$out_array['id'] = $id;
		$out_array['number_page'] = ceil(count($out) / $limit);
		$out_array['page'] = $page;
		$out_array['limit'] = $limit;
		return $out_array;
	}

	public function get_list_user($user, $group, $page = 1)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		if (!$this->check_value('strdot', $group)) {
			return false;
		}

		if (!$this->check_value('number', $page)) {
			return false;
		}

		$data_user = $this->config_read('/etc/brainy/data/users/' . $user);
		$out = $this->read_file_n($data_user['rootdir'] . '/mailing/group_' . $group);
		$limit = 50;
		$num_begin = ($page - 1) * $limit;
		$end_begin = $page * $limit;
		$i = 0;

		foreach ($out as $val) {
			if (($num_begin <= $i) && ($i < $end_begin)) {
				$data_user_array = explode('|', $val);
				$array_data = explode(',', $data_user_array[0]);
				$email = $array_data[0];
				$str_data = '';
				$j = 1;

				while ($j < count($array_data)) {
					if ($array_data[$j]) {
						$str_data .= ', ' . $array_data[$j] . ', ';
					}

					++$j;
				}

				$str_data = preg_replace('/(^(, ){1,}|(, ){1,}$)/i', '', preg_replace('/(, ){1,}/', ', ', $str_data));
				$array_group['list_user'][$email]['data'] = $str_data;
				$array_group['list_user'][$email]['substription'] = explode(',', $data_user_array[1]);
				$array_group['list_user'][$email]['send_detail'] = explode(',', $data_user_array[2]);
			}

			++$i;
		}

		$array_group['number_page'] = ceil(count($out) / $limit);
		$array_group['page'] = $page;
		$array_group['limit'] = $limit;
		return $array_group;
	}

	public function get_group_mailing($user)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		$data_user = $this->config_read('/etc/brainy/data/users/' . $user);
		$path_dir_mailing = $data_user['rootdir'] . '/mailing/list_group';
		$out = $this->read_file_n($path_dir_mailing);

		foreach ($out as $val) {
			$array_group[] = explode('|', $val);
		}

		return $array_group;
	}

	public function message($user, $data)
	{
		global $lang;
		$data = (array) json_decode($data);

		if (!$this->check_value('user', $user)) {
			return false;
		}

		$data_user = $this->config_read('/etc/brainy/data/users/' . $user);
		$path_dir_mailing = $data_user['rootdir'] . '/mailing';

		switch ($data['action']) {
		case 'save_message':
			if (!file_exists($path_dir_mailing)) {
				$this->ssh('mkdir ' . $path_dir_mailing);
				$this->ssh('chown ' . $user . ':' . $user . ' ' . $path_dir_mailing);
			}

			if (!preg_match('/^[0-9a-zа-яЁё\' @_!.?:;,\\{\\$\\}]+$/iu', $data['thema'])) {
				$return_array['code'] = 1;
				$return_array['message'] = $lang['mailclient_error_thema'];
			}
			if ($return_array) {
				return $return_array;
			}

			$name_file = 'message_' . (int) microtime(true);
			$this->write_file($data['message'], $path_dir_mailing . '/' . $name_file, 'wb', $user);
			$this->write_file($name_file . '|' . $data['thema'] . '|' . $data['from'] . PHP_EOL, $path_dir_mailing . '/list_message', 'wb', $user);
			$return_array['code'] = 0;

			return $return_array;
		case 'remove_message':
			if (!preg_match('/^[a-z0-9_]+$/i', $data['id_message'])) {
				$return_array['code'] = 3;
				$return_array['message'] = $lang['mailclient_error_id'];
			}
			if ($return_array) {
				return $return_array;
			}

			$this->del_string($data['id_message'], $path_dir_mailing . '/list_message');
			$this->ssh('rm -rf ' . $path_dir_mailing . '/' . $data['id_message']);
			$return_array['code'] = 0;

			return $return_array;
		case 'view_message':
			if (!preg_match('/^[a-z0-9_]+$/i', $data['id_message'])) {
				$return_array['code'] = 3;
				$return_array['message'] = $lang['mailclient_error_id'];
			}
			if ($return_array) {
				return $return_array;
			}

			$out = $this->read_file_n($path_dir_mailing . '/list_message');

			foreach ($out as $val) {
				if (preg_match('/^' . $data['id_message'] . '/i', $val)) {
					$data_message = explode('|', trim($val));
					$return_array['thema_message'] = $data_message[1];
					$return_array['get_from_email'] = $data_message[2];
					$return_array['message_tyni'] = $this->read_file($path_dir_mailing . '/' . $data['id_message']);
				}
			}

			$return_array['code'] = 0;

			return $return_array;
		case 'edit_message':
			if (!preg_match('/^[0-9a-zа-яЁё\' @_!.,?:;\\{\\$\\}]+$/iu', $data['thema'])) {
				$return_array['code'] = 1;
				$return_array['message'] = $lang['mailclient_error_thema'];
			}

			if (!preg_match('/^[a-z0-9_]+$/i', $data['id_message'])) {
				$return_array['code'] = 3;
				$return_array['message'] = $lang['mailclient_error_id'];
			}
			if ($return_array) {
				return $return_array;
			}

			$out = $this->read_file_n($path_dir_mailing . '/list_message');

			foreach ($out as $key => $val) {
				if (preg_match('/^' . $data['id_message'] . '/i', $val)) {
					$this->write_file($data['message'], $path_dir_mailing . '/' . $data['id_message'], 'r', $user);
					$out[$key] = $data['id_message'] . '|' . $data['thema'] . '|' . $data['from'] . PHP_EOL;
				}
			}

			$this->write_file(implode('', $out), $path_dir_mailing . '/list_message', 'r', $user);
			$return_array['code'] = 0;

			return $return_array;
		}
	}

	public function get_message($user)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		$data_user = $this->config_read('/etc/brainy/data/users/' . $user);
		$out = $this->read_file_n($data_user['rootdir'] . '/mailing/list_message');

		foreach ($out as $val) {
			$array_group[] = explode('|', $val);
		}

		return $array_group;
	}

	public function create_filter($data)
	{
		global $smarty;
		global $lang;

		if (!$this->check_value('user', $data['user'])) {
			$return_array['code'] = 1;
			$return_array['message'] = $lang['mailclient_not_user'];
		}

		if (!preg_match('/^[a-z0-9_]{5,}$/i', $data['name_filter'])) {
			$return_array['code'] = 2;
			$return_array['message'] = $lang['mailclient_name_filter'];
		}

		if (!preg_match('/^[a-z]+$/i', $data['filter_1'])) {
			$return_array['code'] = 3;
			$return_array['message'] = $lang['mailclient_not_filter_1'];
		}

		if (!preg_match('/^[a-z_]+$/i', $data['filter_2'])) {
			$return_array['code'] = 4;
			$return_array['message'] = $lang['mailclient_not_filter_2'];
		}

		if (!preg_match('/^.{2,}$/i', $data['text_filter'])) {
			$return_array['code'] = 5;
			$return_array['message'] = $lang['mailclient_not_text_filter'];
		}

		if (!preg_match('/^[a-z]+$/i', $data['action'])) {
			$return_array['code'] = 6;
			$return_array['message'] = $lang['mailclient_not_action'];
		}

		if (!$this->check_value('email', $data['email']) || empty($data['email'])) {
			$return_array['code'] = 7;
			$return_array['message'] = $lang['mailclient_not_email_reg'];
		}

		if ($data['action'] == 'save') {
			if (!$this->check_value('dir', $data['dir']) || empty($data['dir']) || !preg_match('/^.+(\\/|\\/\\/).+$/i', $data['dir'])) {
				$return_array['code'] = 8;
				$return_array['message'] = $lang['mailclient_error_folder'];
			}
		}

		if ($data['action'] == 'redirect') {
			if (!$this->check_value('email', $data['redirect']) || empty($data['redirect'])) {
				$return_array['code'] = 9;
				$return_array['message'] = $lang['mailclient_not_email_reg'];
			}
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $data['user']);

		if ($return_array) {
			return $return_array;
		}

		$data['dir'] = preg_replace('/(\\/)+/i', '/', $data['dir']);
		$data['dir'] = preg_replace('/^\\//i', '', $data['dir']);
		$data['dir'] = preg_replace('/\\/$/i', '', $data['dir']);
		$file = $confUser['rootdir'] . '/mail/' . $data['email'] . '/.forward';

		if (!is_file($file)) {
			$this->ssh('echo \'# Exim filter ' . "\n" . '\' > ' . $file);
			$this->ssh('chown ' . $data['user'] . ':' . $data['user'] . ' ' . $file);
		}

		$smarty->assign($data);
		$smarty->clearCompiledTemplate('/etc/brainy/' . $GLOBALS['template_path'] . '/client/mailclient/forward_filter.tpl');
		$filter_out = $smarty->fetch('/etc/brainy/' . $GLOBALS['template_path'] . '/client/mailclient/forward_filter.tpl');
		$this->del_strings_between_str('### ' . $data['name_filter'], '### end ' . $data['name_filter'], $file);
		$this->write_file($filter_out, $file, 'wa', $data['user']);
		$filter_db_path = $confUser['rootdir'] . '/mail/' . $data['email'] . '/.filter';

		if (!is_file($filter_db_path)) {
			$this->ssh('touch ' . $filter_db_path);
		}

		$db_out = $this->read_file_n($filter_db_path);
		$chech_n_db = 0;

		foreach ($db_out as $key => $val) {
			$val = trim($val);
			$array_db = explode('||', $val);

			if ($array_db[0] == $data['name_filter']) {
				$chech_n_db = 1;

				switch ($data['action']) {
				case 'delete':
					$array_new_filter[] = trim($data['name_filter'] . '||' . $data['filter_1'] . '=(' . $data['filter_2'] . '\'' . $data['text_filter'] . '\') -> ' . $data['action']);
					break;

				case 'redirect':
					$array_new_filter[] = trim($data['name_filter'] . '||' . $data['filter_1'] . '=(' . $data['filter_2'] . '\'' . $data['text_filter'] . '\') -> ' . $data['action'] . '=(\'' . $data['redirect'] . '\')');
					break;

				case 'save':
					$array_new_filter[] = trim($data['name_filter'] . '||' . $data['filter_1'] . '=(' . $data['filter_2'] . '\'' . $data['text_filter'] . '\') -> ' . $data['action'] . '=(\'' . $data['dir'] . '\')');
					break;
				}

				continue;
			}
			if ($val) {
				$array_new_filter[] = $val;
			}
		}

		if ($chech_n_db == 0) {
			switch ($data['action']) {
			case 'delete':
				$array_new_filter[] = trim($data['name_filter'] . '||' . $data['filter_1'] . '=(' . $data['filter_2'] . '\'' . $data['text_filter'] . '\') -> ' . $data['action']);
				break;

			case 'redirect':
				$array_new_filter[] = trim($data['name_filter'] . '||' . $data['filter_1'] . '=(' . $data['filter_2'] . '\'' . $data['text_filter'] . '\') -> ' . $data['action'] . '=(\'' . $data['redirect'] . '\')');
				break;

			case 'save':
				$array_new_filter[] = trim($data['name_filter'] . '||' . $data['filter_1'] . '=(' . $data['filter_2'] . '\'' . $data['text_filter'] . '\') -> ' . $data['action'] . '=(\'' . $data['dir'] . '\')');
				break;
			}
		}

		$this->write_file(implode(PHP_EOL, $array_new_filter), $filter_db_path, 'r', $data['user']);
	}

	public function get_filter($user, $email)
	{
		global $lang;

		if (!$this->check_value('user', $user)) {
			return false;
		}

		if (!$this->check_value('email', $email) || empty($email)) {
			return false;
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$filter_db_path = $confUser['rootdir'] . '/mail/' . $email . '/.filter';

		if (!is_file($filter_db_path)) {
			$arr['code'] = 1;
			$arr['message'] = $lang['mailclient_not_filter_include'];
		}
		else {
			$arr['code'] = 0;
			$db_out = $this->read_file_n($filter_db_path);

			foreach ($db_out as $val) {
				$array_db = explode('||', $val);
				$filter_array[$array_db[0]] = $array_db[1];
			}

			$arr['filter_arr'] = $filter_array;
		}

		return $arr;
	}

	public function remove_filter($user, $email, $name_filter)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		if (!$this->check_value('email', $email) || empty($email)) {
			return false;
		}

		if (!preg_match('/^[a-z0-9_]{5,}$/i', $name_filter)) {
			return false;
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$filter_db_path = $confUser['rootdir'] . '/mail/' . $email . '/.filter';
		$db_out = $this->read_file_n($filter_db_path);

		foreach ($db_out as $val) {
			$val = trim($val);
			$array_db = explode('|', $val);

			if (($array_db[0] != $name_filter) && $val) {
				$filter_array[] = $val;
			}
		}

		$file = $confUser['rootdir'] . '/mail/' . $email . '/.forward';
		$this->write_file(implode(PHP_EOL, $filter_array), $filter_db_path, 'r', $user);
		$this->del_strings_between_str('### ' . $name_filter, '### end ' . $name_filter, $file);
		return $this->get_filter($user, $email);
	}

	public function get_statistic_exim($user)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		$array = $this->get_email($user);

		if ($array) {
			foreach ($array as $val) {
				$array_unique_msg[] = $this->ssh('tail -n 100000 ' . $this->path_log_exim . '/main.log | grep \'' . $val . '\' | cut -f 3 -d\' \'');
			}

			foreach ($array_unique_msg as $val) {
				foreach ($val as $val1) {
					$grep_str .= $val1 . ' \\|';
				}
			}

			$grep_searche = preg_replace('/( \\\\\\|)$/i', '', $grep_str);

			if ($grep_searche) {
				$return_array = $this->ssh('tail -n 100000 ' . $this->path_log_exim . '/main.log | grep \'' . $grep_searche . '\' | sort -k2');

				foreach ($return_array as $val) {
					if (preg_match('/.*(delay).*/i', $val)) {
						if (preg_match('/.*(' . implode('|', $array) . ').*/i', $val)) {
							$ssh_array[] = $val;
						}
					}
					else {
						$ssh_array[] = $val;
					}
				}
			}

			return $ssh_array;
		}
	}

	public function mailclient_get_version()
	{
		$this->load_vars('../mailserver/config.cnf');
		return $this->module_vars;
	}

	public function mailclient_get_available($service)
	{
		if (!$this->check_value('stringservice', $service)) {
			return 0;
		}

		if ($service == 'clamav') {
			if ($GLOBALS['v2'] == 'yes') {
				$service = 'clamd@scan';
			}
			else {
				$service = 'clamd';
			}
		}

		$result = $this->monitor_get_service_status($service);

		if ($result == 'on') {
			return true;
		}

		return false;
	}

	public function mailclient_getUserDomain($user, $decode = 0)
	{
		if (!$this->check_value('user', $user)) {
			return 0;
		}

		$arr = $this->mailclient_getUserDomain_ForFilter($user, $decode);
		$result = '';

		foreach ($arr as $key) {
			if (!preg_match('/[\\*]/i', $key)) {
				$result .= '<option value=\'' . $key . '\'>' . $key . '</option>';
			}
		}

		return $result;
	}

	public function mailclient_getUserDomain_ForFilter($user, $decode = 0)
	{
		if (!$this->check_value('user', $user)) {
			return 0;
		}

		$hostacc = new hostacc();
		$arr = $hostacc->hostacc_user_sites($user, $decode);

		if (is_array($arr)) {
			foreach ($arr as $key) {
				if (!$this->mailclient_checkDomainInDb($key)) {
					$this->mailclient_addDomainToDb($key);
				}
			}
		}

		return $arr;
	}

	public function mailclient_getEmails($user)
	{
		if ($user) {
			if (!$this->check_value('user', $user)) {
				return 0;
			}
		}

		$result = array();
		$db = self::getInstance();

		if (is_array($db)) {
			return $db;
		}

		$mysqli = $db->getConnection();
		$sql_query = 'SELECT mailbox.username,mailbox.quota,mailbox.auto_autoresponder,mailbox.text_autoresponder,quota2.bytes,quota2.messages FROM mailbox LEFT JOIN quota2 on (quota2.username=mailbox.username) WHERE name=\'' . $user . '\' and active=1';

		if ($res = $mysqli->query($sql_query)) {
			while ($row = $res->fetch_row()) {
				$result[] = $row;
			}
		}
		else {
			$result = NULL;
		}

		return $result;
	}

	public function mailclient_getEmailTable($user, $decode = 0)
	{
		global $lang;

		if ($user) {
			if (!$this->check_value('user', $user)) {
				return 0;
			}
		}

		$result = self::mailclient_getEmails($user);

		if ($decode == 1) {
			$puny = new idna_convert();
			$i = 0;

			while ($i < count($result)) {
				$result[$i]['enc'] = trim($result[$i][0]);
				$result[$i][0] = $puny->decode(trim($result[$i][0]));
				++$i;
			}
		}
		else {
			$i = 0;

			while ($i < count($result)) {
				$result[$i]['enc'] = trim($result[$i][0]);
				++$i;
			}
		}

		$i = 0;

		while ($i < count($result)) {
			$result[$i][1] = round($result[$i][1] / 1024 / 1024);
			$result[$i][1] = $result[$i][1] . 'MB';
			++$i;
		}

		$i = 0;

		while ($i < count($result)) {
			$new_element = '<a href=\'#\' id=\'go\' data-email=\'' . $result[$i][0] . '\'>' . $lang['msg_mail_webmail'] . '</a>';
			$result[$i][] = $new_element;
			++$i;
		}

		$i = 0;

		while ($i < count($result)) {
			$new_element = '<a href=\'#\' id=\'delete_mail\' data-email=\'' . $result[$i][0] . '\'>' . $lang['msg_mail_delete'] . '</a><br>';
			$result[$i][] = $new_element;
			++$i;
		}

		return $result;
	}

	public function mailclient_getSpamassassinTable()
	{
		$result = self::mailclient_getEmails();
		$i = 0;

		while ($i < count($result)) {
			$result[$i][1] = 'Spam Filter';
			++$i;
		}

		$res = array();
		$i = 0;

		while ($i < count($result)) {
			$k = 0;

			while ($k < count($result[$i])) {
				$res[] = $result[$i][$k];
				++$k;
			}

			++$i;
		}

		return $res;
	}

	public function mailclient_getClamavTable()
	{
		$result = self::mailclient_getEmails();
		$i = 0;

		while ($i < count($result)) {
			$result[$i][1] = 'Antivirus';
			++$i;
		}

		$res = array();
		$i = 0;

		while ($i < count($result)) {
			$k = 0;

			while ($k < count($result[$i])) {
				$res[] = $result[$i][$k];
				++$k;
			}

			++$i;
		}

		return $res;
	}

	public function mailclient_getDomainForwardingTable($user)
	{
		global $lang;

		if ($user) {
			if (!$this->check_value('user', $user)) {
				return 0;
			}
		}

		$result = array();
		$db = self::getInstance();

		if (is_array($db)) {
			return $db;
		}

		$mysqli = $db->getConnection();
		$sql_query = 'SELECT alias_domain,target_domain FROM alias_domain WHERE active=1';

		if ($res = $mysqli->query($sql_query)) {
			while ($row = $res->fetch_row()) {
				$result[] = $row;
			}
		}
		else {
			$result = NULL;
		}

		$domain = $this->mailclient_getUserDomain_ForFilter($user);
		$count = count($result);
		$i = 0;

		while ($i < $count) {
			if (!in_array($result[$i][0], $domain)) {
				unset($result[$i]);
			}

			++$i;
		}

		$i = 0;

		while ($i < count($result)) {
			$new_element = '<a href=\'#\' id=\'delete_forward_domain\' data-src=\'' . $result[$i][0] . '\' data-trg=\'' . $result[$i][1] . '\'>' . $lang['msg_mail_delete'] . '</a><br>';
			$result[$i][] = $new_element;
			++$i;
		}

		return $result;
	}

	public function mailclient_getEmailForwardingTable($user, $decode = 0)
	{
		global $lang;

		if ($user) {
			if (!$this->check_value('user', $user)) {
				return 0;
			}
		}

		$puny = new idna_convert();
		$result = array();
		$db = self::getInstance();

		if (is_array($db)) {
			return $db;
		}

		$mysqli = $db->getConnection();
		$sql_query = 'SELECT address,goto FROM alias WHERE active=1';

		if ($res = $mysqli->query($sql_query)) {
			$counter = 0;

			while ($row = $res->fetch_row()) {
				$result[] = $row;

				if ($decode == 1) {
					$result[$counter][0] = $puny->decode(trim($row[0]));
					$toemail = explode(',', $row[1]);

					foreach ($toemail as $keym => $curtogo) {
						$toemail[$keym] = $puny->decode(trim($curtogo));
					}

					$row[1] = implode(',', $toemail);
					$result[$counter][1] = $puny->decode(trim($row[1]));
					$result[$counter][2] = $puny->decode(trim($row[2]));
				}

				++$counter;
			}
		}
		else {
			$result = NULL;
		}

		$domain = $this->mailclient_getUserDomain_ForFilter($user, $decode);

		if (!is_array($domain)) {
			$domain = array();
		}

		$count = count($result);
		$i = 0;

		while ($i < $count) {
			if (!in_array(explode('@', $result[$i][0])[1], $domain)) {
				unset($result[$i]);
			}

			++$i;
		}

		$result = array_values($result);
		return $result;
	}

	public function mailclient_getDomainTable($user, $decode = 0)
	{
		if ($user) {
			if (!$this->check_value('user', $user)) {
				return 0;
			}
		}

		$result = array();
		$r = $this->mailclient_getUserDomain_ForFilter($user);
		$i = 0;
		$puny = new idna_convert();

		if (is_array($r)) {
			foreach ($r as $key) {
				if ((trim($key) == '') || preg_match('/[\\*]/i', $key)) {
					continue;
				}

				$result[$i][0] = trim($key);

				if ($decode == 0) {
					$result[$i][0] = trim($key);
					$result[$i]['domain_decode'] = trim($key);
				}
				else {
					$result[$i][0] = trim($key);
					$result[$i]['domain_decode'] = $puny->decode(trim($key));
				}

				++$i;
			}
		}

		$count = $i;
		$lng = array('on' => 'Включить', 'off' => 'Выключить');
		$i = 0;

		while ($i < $count) {
			$status = ($this->mailclient_checkOpenDkim($result[$i][0]) == 'TRUE' ? 'on' : 'off');
			$do = ($status == 'on' ? 'off' : 'on');
			$result[$i][1] = $status;
			$result[$i][2] = '<a href=\'#\' id=\'dkim_do\' data-host=\'' . $result[$i][0] . '\' data-do=\'' . $do . '\'>' . $lng[$do] . '</a>';
			++$i;
		}

		return $result;
	}

	public function mailclient_checkMailClient(&$result)
	{
		$result['roundcube_status'] = parent::sudo_ssh('[ -f /usr/share/roundcube/index.php ] && echo \'true\' || echo \'false\' ')[0];
		$result['squirrelmail_status'] = parent::sudo_ssh('[ -f /usr/share/squirrelmail/index.php ] && echo \'true\' || echo \'false\' ')[0];
		$result['webmaillite_status'] = parent::sudo_ssh('[ -f /usr/share/webmaillite/index.php ] && echo \'true\' || echo \'false\' ')[0];
		return $result;
	}

	public function mailclient_checkDomainInBrainy($domains, $host)
	{
		if ($host) {
			if (!$this->check_value('domain', $host)) {
				return 0;
			}
		}

		if (in_array($host, $domains)) {
			if (!self::mailclient_checkDomainInDb($host)) {
				self::mailclient_addDomainToDb($host);
			}

			return true;
		}

		return false;
	}

	public function mailclient_checkDomainInDb($domain)
	{
		if ($domain) {
			if (!$this->check_value('domain', $domain)) {
				return 0;
			}
		}

		$db = self::getInstance();

		if (is_array($db)) {
			return $db;
		}

		$mysqli = $db->getConnection();
		$sql_query = 'SELECT domain FROM domain WHERE domain=\'' . $domain . '\'';
		$res = $mysqli->query($sql_query);

		if ($res->num_rows == 0) {
			return false;
		}

		return true;
	}

	public function mailclient_checkexistemail_bydomain($domain)
	{
		if ($domain) {
			if (!$this->check_value('domain', $domain)) {
				return 0;
			}
		}

		$db = self::getInstance();

		if (is_array($db)) {
			return $db;
		}

		$mysqli = $db->getConnection();
		$sql_query = 'SELECT domain FROM mailbox WHERE domain =\'' . mysqli_real_escape_string($mysqli, $domain) . '\'';

		if ($res = $mysqli->query($sql_query)) {
			while ($row = $res->fetch_assoc()) {
				$result[] = $row;
			}
		}

		foreach ($result as $dom) {
			return true;
		}

		return false;
	}

	public function mailclient_addDomainToDb($domain)
	{
		if ($domain) {
			if (!$this->check_value('domain', $domain)) {
				return 0;
			}
		}

		$db = self::getInstance();

		if (is_array($db)) {
			return $db;
		}

		$mysqli = $db->getConnection();
		$sql_query = 'INSERT INTO domain (domain,description,aliases,mailboxes,maxquota,quota,transport,backupmx,created,modified,active)';
		$sql_query .= ' VALUES (\'' . $domain . '\',\'\',0,0,0,0,\'\',0,now(),now(),1)';
		$res = $mysqli->query($sql_query);
		return $res;
	}

	public function mailclient_removeDomainDb($domain)
	{
		if ($domain) {
			if (!$this->check_value('domain', $domain)) {
				return 0;
			}
		}

		$db = self::getInstance();

		if (is_array($db)) {
			return $db;
		}

		$mysqli = $db->getConnection();
		$sql_query = 'DELETE FROM domain where domain=\'' . mysqli_real_escape_string($mysqli, $domain) . '\'';
		$res = $mysqli->query($sql_query);
		return $res;
	}

	public function mailclient_checkOpenDkim($domain)
	{
		if ($domain) {
			if (!$this->check_value('domain', $domain)) {
				return 0;
			}
		}

		return parent::sudo_ssh($this::PATH_TO_SCRIPTS . 'opendkim.sh check ' . $domain)[0];
	}

	public function mailclient_changeOpenDkim($domain, $act)
	{
		if ($domain) {
			if (!$this->check_value('domain', $domain)) {
				return 0;
			}
		}
		if ($act) {
			if (!$this->check_value('string', $act)) {
				return 0;
			}
		}

		$out = implode(' ', parent::sudo_ssh($this::PATH_TO_SCRIPTS . 'opendkim.sh ' . $act . ' ' . $domain));
		$dns = new bindserver();

		if ($act == 'add') {
			$dnsfile = $this->read_file('/etc/opendkim/keys/' . $domain . '/' . $domain . '.dns');
			preg_match_all('|default._domainkey IN TXT "v=DKIM1; k=rsa; p=(.*)" ; ----- DKIM|Usi', $dnsfile, $outdnsfile);

			if (strlen($outdnsfile[1][0]) < 1) {
				preg_match_all('|"p=(.*)"|Usi', $dnsfile, $outdnsfile);
			}

			$public_key = $outdnsfile[1][0];
			$zonefile = $dns->bindserver_readZone($domain);
			$zonemass = explode("\n", trim($zonefile));
			$zone = $this->ssh('find /var/named -maxdepth 1 -exec grep -l \'^' . $domain . '\\.\' {} \\; 2>/dev/null');
			$cloudflare = new cloudflare();

			if (count($zone) != 0) {
				$zone = explode('named.', $zone[0])[1];

				if (trim($zone) != trim($domain)) {
					$zoneadd = str_replace('.' . $zone, '', $domain);
				}
				else {
					$zoneadd = $domain . '.';
				}

				$dns->bindserver_addAddrToZone($domain, 'default._domainkey.' . $zoneadd, 'TXT', '"v=DKIM1; k=rsa; p=' . $public_key . '"');
				$cloudflare->add_record_other_modules($domain, 'add_record', 'default._domainkey.' . $domain, '"v=DKIM1; k=rsa; p=' . $public_key . '"');
			}

			return $out;
		}

		if ($act == 'delete') {
			$zonefile = $dns->bindserver_readZone($domain);
			$zonemass = explode("\n", trim($zonefile));

			if (3 < count($zonemass)) {
				foreach ($zonemass as $key => $value) {
					if ((0 < substr_count($value, 'DKIM')) && (0 < substr_count($value, 'domainkey.' . $domain))) {
						$delkeys[] = $key + 1;
					}
				}
			}
			else {
				$zone = $this->ssh('grep -rl ' . $domain . '. /var/named/ 2>/dev/null');

				if (count($zone) != 0) {
					$zone = explode('named.', $zone[0])[1];
					$zonefile = $dns->bindserver_readZone($zone);
					$zonemass = explode("\n", trim($zonefile));

					foreach ($zonemass as $key => $value) {
						if ((0 < substr_count($value, 'DKIM')) && (0 < substr_count($value, 'domainkey.' . $domain))) {
							$delkeys[] = $key + 1;
						}
					}
				}
			}

			arsort($delkeys);

			foreach ($delkeys as $value) {
				$dns->bindserver_delete_record($domain, $value);
			}

			$cloudflare = new cloudflare();
			$cloudflare->add_record_other_modules($domain, 'remove_record', 'default._domainkey.' . $domain, '', 'dkim');
		}

		return $out;
	}

	public function mailclient_checkService($service)
	{
		if ($service) {
			if (!$this->check_value('strdot', $service)) {
				return 0;
			}
		}

		return parent::sudo_ssh($this::PATH_TO_SCRIPTS . $service . '.sh check');
	}

	public function save_email_param($data)
	{
		global $lang;
		global $server;

		if ($GLOBALS['DEMO'] == 1) {
			$out['code'] = 9999;
			$out['message'] = $lang['server_control_demo_message'];
		}

		if (($data['checkcustdomain'] == 1) && ($server->user['group_properties']['root'] != 'y') && ($server->user['group_properties']['function_anyemaildomain'] == 'n')) {
			$out['code'] = 404;
			$out['message'] = $lang['common_access_is_denied'];
		}

		if (isset($this->failedconn['errordb'])) {
			$out['code'] = 1;
			$out['message'] = $lang['msg_mail_err_mysql_connect'];
		}
		if ($out) {
			return $out;
		}

		$cur_user = $data['user'];
		$webserver = new webserver();
		$arr['domain'] = $webserver->get_all_sites($cur_user, 1);
		$this->mailclient_checkDomainInBrainy($arr['domain'], $data['host']);
		$setcustdomain = (isset($data['setcustdomain']) ? $data['setcustdomain'] : '');
		$checkcustdomain = (isset($data['checkcustdomain']) ? intval($data['checkcustdomain']) : 0);

		if ($checkcustdomain == 1) {
			$emailBuild = $data['email'] . '@' . $setcustdomain;
		}
		else {
			$emailBuild = $data['email'] . '@' . $data['host'];
		}

		$params = array('email' => $emailBuild, 'password' => $data['password'], 'quota' => $data['quota'], 'user' => $cur_user, 'setspf' => intval($data['setspf']), 'setdkim' => intval($data['setdkim']), 'auto_autoresponder' => intval($data['auto_autoresponder']), 'text_autoresponder' => $data['text_autoresponder'], 'setcustdomain' => isset($data['setcustdomain']) ? $data['setcustdomain'] : NULL, 'checkcustdomain' => isset($data['checkcustdomain']) ? intval($data['checkcustdomain']) : NULL);
		$this->mailclient_checkMailClient($arr);
		$out['result'] = $this->mailclient_run('addmail', $params);
		return $out;
	}

	public function mailclient_run($comm, $params)
	{
		global $lang;
		$puny = new idna_convert();
		$params['email'] = $puny->encode(trim($params['email']));

		if ($comm == 'deletemail') {
			if (!$this->check_value('email', $params['email'])) {
				$res['code'] = 4;
				$res['message'] = $lang['server_control_error_user'];
				return $res;

				if (!$this->check_value('email', $params['email'])) {
					$res['code'] = 4;
					$res['message'] = $lang['server_control_error_user'];
					return $res;
				}

				if (!$this->check_value('domain', $params['host'])) {
					$res['code'] = 5;
					$res['message'] = $lang['server_control_error_user'];
					return $res;
				}

				if ($comm == 'addmail') {
					if (strlen($params['quota']) < 1) {
						$res['code'] = 6;
						$res['message'] = $lang['mailclient_addmail_failed_quotaformat'];
						return $res;
					}
				}

				if (!$this->check_value('number', $params['quota'])) {
					$res['code'] = 6;
					$res['message'] = $lang['mailclient_addmail_failed_quotaformat'];
					return $res;
				}

				if (!$this->check_value('number', $params['auto_autoresponder'])) {
					$res['code'] = 7;
					$res['message'] = $lang['mailclient_error_number'];
					return $res;
				}

				if (($params['auto_autoresponder'] == 1) && empty($params['text_autoresponder'])) {
					$res['code'] = 8;
					$res['message'] = $lang['mailclient_not_text'];
					return $res;
				}

				$params['password'] = $this->strip_quotes_cmd($params['password']);
			}
		}
		else {
			return $res;
			$res['code'] = 4;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
			$res['code'] = 5;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
			$res['code'] = 6;
			$res['message'] = $lang['mailclient_addmail_failed_quotaformat'];
			return $res;
			$res['code'] = 6;
			$res['message'] = $lang['mailclient_addmail_failed_quotaformat'];
			return $res;
			$res['code'] = 7;
			$res['message'] = $lang['mailclient_error_number'];
			return $res;
			$res['code'] = 8;
			$res['message'] = $lang['mailclient_not_text'];
			return $res;
			$params['password'] = $this->strip_quotes_cmd($params['password']);
		}

		if (!$this->check_value('user', $params['user'])) {
			return false;
		}

		if (!in_array($comm, $this->COMMANDS)) {
			return false;
		}

		if ($comm == 'addmail') {
			if (isset($params['checkcustdomain'])) {
				if (intval($params['checkcustdomain']) == 1) {
					if (!$this->check_value('domain', $params['setcustdomain'])) {
						$res['code'] = 5;
						$res['message'] = $lang['mailclient_customdomain_failedformat'];
						return $res;
					}
				}
			}
		}

		if (isset($params['setdkim'])) {
			$domain = explode('@', $params['email'])[1];

			if ($params['setdkim'] == 1) {
				$status_dkim = ($this->mailclient_checkOpenDkim($domain) == 'TRUE' ? 1 : 0);

				if ($status_dkim == 0) {
					$this->mailclient_changeOpenDkim($domain, 'add');
				}
			}
			else {
				$this->mailclient_changeOpenDkim($domain, 'delete');
			}
		}

		if (isset($params['setspf'])) {
			$domain = explode('@', $params['email'])[1];
			$setspf = new mailserver();
			$info = $setspf->mailserver_readspf($domain);

			if ($params['setspf'] == 1) {
				if ($info['line'] == 0) {
					$setspf->mailserver_spfcreate($domain, 1);
				}
			}
			else {
				$setspf->mailserver_spfcreate($domain, 0, $info['line']);
			}
		}

		switch ($comm) {
		case 'addmail':
		case 'deletemail':
		case 'check':
			$result = self::mailclient_comm_start($comm, $params);
			break;

		case 'addforward_email':
		case 'deleteforward_email':
		case 'addforward_domain':
		case 'deleteforward_domain':
			$result = self::mailclient_comm_alias($comm, $params);
			break;
		}

		return $result;
	}

	public function mailclient_comm_alias($act, $params)
	{
		$maping = array('addforward_email' => 'addmail', 'deleteforward_email' => 'deletemail', 'addforward_domain' => 'adddomain', 'deleteforward_domain' => 'deletedomain');
		$puny = new idna_convert();
		$params['src'] = $puny->encode(trim($params['src']));
		$params['trg'] = $puny->encode(trim($params['trg']));

		if ($act == 'addforward_email') {
			if (!$this->mailclient_validateEmail($params['src'])) {
				return 'Wrong source email';
			}

			$valCheck = preg_split('/[,;]/', $params['trg']);

			foreach ($valCheck as $keyPipe => $curCheck) {
				if (stripos($curCheck, '@') !== false) {
					if (!$this->mailclient_validateEmail($curCheck)) {
						return 'Wrong target email';

						if (!$this->check_params('text', $curCheck)) {
							return 'Wrong target email';
						}

						$valCheck[$keyPipe] = '"|' . $curCheck . '"';
					}
				}
				else {
					return 'Wrong target email';

					return 'Wrong target email';
					$valCheck[$keyPipe] = '"|' . $curCheck . '"';
				}
			}

			$params['trg'] = implode(',', $valCheck);
		}

		if ($act == 'addforward_domain') {
			if (!$this->mailclient_validateHost($params['src'])) {
				return 'Wrong source domain';
			}

			if (!$this->mailclient_validateHost($params['trg'])) {
				if (!$this->mailclient_validateEmail($params['trg'])) {
					return 'Wrong target domain';
				}
			}
		}

		if (($params['save_local'] == 1) && !preg_match('|^\\*\\@|Usi', $params['src'])) {
			$foo[] = $params['trg'];
			$foo[] = $params['src'];
			$params['trg'] = implode(',', $foo);
		}

		$execScript = $this::PATH_TO_SCRIPTS . 'alias.sh ' . $maping[$act] . ' ' . $params['src'] . ' "' . $this->strip_doublequotes_cmd($params['trg']) . '"';
		$out = parent::sudo_ssh($execScript);
		return $out;
	}

	public function mailclient_validateHost($data)
	{
		return preg_match('/^([a-zA-Z0-9\\-]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9\\-])?\\.)+[a-zA-Z0-9\\-]{1,20}$/', $data);
	}

	public function mailclient_validateEmail($data)
	{
		$data = explode(', ', $data);
		$data = implode(',', $data);
		$data = explode(',', $data);
		$out = true;
		$puny = new idna_convert();

		foreach ($data as $value) {
			$value = $puny->encode(trim($value));
			$out = preg_match('/^([a-zA-Z0-9_\\.\\-]+)@([a-zA-Z0-9_\\.\\-]+)\\.([a-zA-Z0-9\\.\\-]{2,20})$/', $value);

			break;
		}

		return $out;
	}

	public function mailclient_comm_start($act, $params)
	{
		global $lang;

		if ($act == 'deletemail') {
			if (!$this->check_value('email', $params['email'])) {
				$res['code'] = 4;
				$res['message'] = $lang['server_control_error_user'];
				return $res;

				if (!$this->check_value('email', $params['email'])) {
					$res['code'] = 4;
					$res['message'] = $lang['server_control_error_user'];
					return $res;
				}

				if (!$this->check_value('domain', $params['host'])) {
					$res['code'] = 5;
					$res['message'] = $lang['server_control_error_user'];
					return $res;
				}

				if (!$this->check_value('number', $params['quota'])) {
					$res['code'] = 6;
					$res['message'] = $lang['mailclient_addmail_failed_quotaformat'];
					return $res;
				}
			}
		}
		else {
			return $res;
			$res['code'] = 4;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
			$res['code'] = 5;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
			$res['code'] = 6;
			$res['message'] = $lang['mailclient_addmail_failed_quotaformat'];
			return $res;
		}

		if (!$this->check_value('user', $params['user'])) {
			$res['code'] = 7;
			$res['message'] = $lang['server_control_error_user'];
			return $res;
		}

		$maping = array('addmail' => 'create', 'deletemail' => 'delete', 'check' => 'check');

		if ($act == 'addmail') {
			$user_info = $this->config_read($GLOBALS['USERS_PATH'] . '/' . $params['user']);
			$all_emailboxes_count = count($this->mailclient_getEmails($params['user']));

			if ($user_info['emailboxes'] != 0) {
				if ($user_info['emailboxes'] <= $all_emailboxes_count) {
					$outm['code'] = 301;
					$outm['message'] = $lang['mailclient_addmail_failed_overlimit'] . $user_info['emailboxes'];
					return $outm;
				}
			}

			if (!$this->mailclient_validateEmail($params['email'])) {
				$res['code'] = 1;
				$res['message'] = $lang['js_mail_email_error'];
				return $res;
			}

			if (strlen($params['password']) == 0) {
				$res['code'] = 2;
				$res['message'] = $lang['js_mail_passwd_error_len'];
				return $res;
			}

			if (!$this->check_params('number', $params['quota'])) {
				$res['code'] = 3;
				$res['message'] = $lang['mailclient_addmail_failed_quotaformat'];
				return $res;
			}

			$params['quota'] = $params['quota'] * 1024 * 1024;
		}

		if ($maping[$act] == 'delete') {
			$listemails = $this->mailclient_getEmails($params['user']);
			$q = 0;

			foreach ($listemails as $curmail) {
				if ($curmail[0] == $params['email']) {
					$q = 1;
				}
			}

			$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $params['user']);
			$homeUser = $confUser['rootdir'];

			if ($q == 1) {
				$this->ssh('rm -rf ' . $homeUser . '/mail/' . $params['email']);
			}
		}

		$res['code'] = 0;
		$comm_esc = $this::PATH_TO_SCRIPTS . 'mail.sh ';

		if (0 < strlen($maping[$act])) {
			$comm_esc .= ' \'' . $maping[$act] . '\' ';
		}

		if (0 < strlen($params['email'])) {
			$comm_esc .= ' \'' . $params['email'] . '\' ';
		}

		if (0 < strlen($params['user'])) {
			$comm_esc .= ' \'' . $params['user'] . '\' ';
		}

		if (0 < strlen($params['password'])) {
			$comm_esc .= ' \'' . $params['password'] . '\' ';
		}

		if (0 < strlen($params['quota'])) {
			$comm_esc .= ' \'' . $params['quota'] . '\' ';
		}

		if (isset($params['checkcustdomain'])) {
			$comm_esc .= ' \'' . intval($params['checkcustdomain']) . '\' ';
		}
		else {
			$comm_esc .= ' \'0\' ';
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $params['user']);
		$homeUser = str_replace($params['user'], '', $confUser['rootdir']);
		$comm_esc .= ' \'' . $homeUser . '\' ';
		$res['message'] = parent::sudo_ssh($comm_esc);

		if ($maping[$act] == 'create') {
			$this->execute_query($params['email'], $params['auto_autoresponder'], $params['text_autoresponder']);
		}

		$hostacc = new hostacc();
		$hostacc->hostacc_count_mails($params['user'], 1);
		return $res;
	}

	public function execute_query($email, $active, $text)
	{
		global $lang;

		if (!$this->check_value('email', $email)) {
			return $lang['mailclient_data_not_corected'];
		}

		if (!$this->check_value('number', $active)) {
			return $lang['mailclient_data_not_corected'];
		}

		if (!$this->check_value('text', $text)) {
			return $lang['mailclient_data_not_corected'];
		}

		$db = self::getInstance();

		if (is_array($db)) {
			return $db;
		}

		$mysqli = $db->getConnection();
		$text = addslashes($text);
		$sql_query = 'UPDATE smtp.mailbox SET auto_autoresponder=\'' . $active . '\',text_autoresponder=\'' . $text . '\' WHERE username=\'' . $email . '\'';
		$res = $mysqli->query($sql_query);

		if ($res) {
			return $lang['mailclient_change_succecfully'];
		}

		return $lang['msg_mail_err_mysql_connect'];
	}

	public function mailclient_change_pass($email, $pass, $username)
	{
		global $lang;
		$out = $this->mailclient_getEmails($username);

		foreach ($out as $value) {
			$user_emails[] = $value[0];
		}

		if (!in_array($email, $user_emails)) {
			$res['code'] = 100;
			$res['message'] = $lang['mailclient_no_rights'];
			return $res;
		}

		$pass = $this->strip_quotes_cmd($pass);

		if (!$pass) {
			$res['message'] = $lang['mailclient_empty_field'];
		}
		else {
			$res['code'] = 0;
			$res['message'] = parent::sudo_ssh($this::PATH_TO_SCRIPTS . 'mail.sh change_pass \'' . $email . '\' \'' . $pass . '\'');
			$res['message'] = $lang['mailclient_successfully_done'];
		}

		return $res;
	}

	public function mailclient_change_quota($email, $quota, $username)
	{
		global $lang;

		if (strlen($quota) < 1) {
			$res['message'] = $lang['mailclient_empty_field'];
			return $res;
		}

		if (!is_numeric($quota)) {
			$res['message'] = $lang['mailclient_addmail_failed_quotaformat'];
			return $res;
		}

		$quota = intval($quota) * 1024 * 1024;
		$out = $this->mailclient_getEmails($username);

		foreach ($out as $value) {
			$user_emails[] = $value[0];
		}

		if (!in_array($email, $user_emails)) {
			$res['code'] = 100;
			$res['message'] = $lang['mailclient_no_rights'];
			return $res;
		}

		$res['code'] = 0;
		$res['message'] = parent::sudo_ssh($this::PATH_TO_SCRIPTS . 'mail.sh change_quota ' . $email . ' ' . $quota);
		$res['message'] = $lang['mailclient_successfully_done'];
		return $res;
	}

	public function mailclient_run2($service, $comm)
	{
		if (!in_array($comm, $this->COMMANDS2)) {
			return false;
		}

		if (!in_array($service, $this->SERVICES)) {
			return false;
		}

		switch ($comm) {
		case 'start':
		case 'stop':
		case 'restart':
			$result = $this->mailclient_comm_start2($service, $comm);
			break;

		case 'on':
		case 'off':
		case 'install':
		case 'delete':
		case 'reinstall':
		case 'install1':
		case 'install2':
		case 'remove':
			$result = $this->mailclient_comm_install2($service, $comm);
			break;
		}

		return $result;
	}

	public function mailclient_comm_start2($service, $act)
	{
		if (!$this->check_value('strdot', $service)) {
			return false;
		}

		if (!$this->check_value('string', $act)) {
			return false;
		}

		$out = $this->sudo_ssh('service ' . $service . ' ' . $act);
		return $out;
	}

	public function mailclient_comm_install2($service, $act)
	{
		if (!$this->check_value('string', $act)) {
			return false;
		}

		if (!$this->check_value('strdot', $service)) {
			return false;
		}

		if ($act == 'delete') {
			$act = 'remove';
		}

		$stream[0]['comm'] = $this::PATH_TO_SCRIPTS . $service . '.sh ' . $act;
		$stream[0]['test'] = 'Complete';
		$stream[0]['array_start'] = array('one' => 'inprogress,#stream_id#');
		$stream[0]['array_succes'] = array('one' => 'success,#stream_id#');
		$stream[0]['array_unsucces'] = array('one' => 'unsuccess,#stream_id#', 'error' => '#error#');
		$out = $this->create_stream($stream);
		return 'ajax';
	}

	public function mailclient_client_changestatus($service, $act)
	{
		if (!$this->check_value('string', $act)) {
			return false;
		}

		if (!$this->check_value('strdot', $service)) {
			return false;
		}

		if ($act == 'delete') {
			$act = 'remove';
		}

		$out = $this->sudo_ssh($this::PATH_TO_SCRIPTS . $service . '.sh ' . $act);
		$out = $this->sudo_ssh($this::PATH_TO_SCRIPTS . $service . '.sh check');
		$outm['result'] = implode('', $out);
		return $outm;
	}

	public function mailclient_ajax()
	{
		global $lang;
		$this->load_vars();
		$one = $this->module_vars['one'];
		$one = explode(',', $one);
		$result['stream_output'] = implode("\n", $this->read_stream($one[1]));
		$result['status'] = $one[0];

		if ($result['status'] == 'unsuccess') {
			$result['status_detail'] = '<br>' . $lang['msg_mail_process_ok'] . ' ' . $lang['msg_mail_process_last_log'] . $this->module_vars['error'];
		}

		if ($result['status'] == 'success') {
			$result['status_detail'] = '<br>' . $lang['msg_mail_process_ok'];
		}

		return $result;
	}

	public function mailclient_check_default_mail_in_db($domain)
	{
		if (!$this->check_value('domain', $domain)) {
			return false;
		}

		$text = file_get_contents('/etc/brainy/data/mailclient/defaultmail.db');
		$arr = explode("\n", $text);
		$arr = array_filter($arr);

		foreach ($arr as $key) {
			$temp = explode('|', $key);

			return true;
		}

		return false;
	}

	public function mailclient_add_default_mail_to_db($param)
	{
		$line = $param['domain'] . '|' . $param['user'] . '|' . $param['type'] . '|' . $param['mail'] . "\n";
		file_put_contents('/etc/brainy/data/mailclient/defaultmail.db', $line, FILE_APPEND);

		if (!is_dir('/etc/valiases')) {
			mkdir('/etc/valiases');
		}

		if ($param['type'] == 'failed') {
			$content = '*: :fail: No such person at this address.';
			$content2 = '';
		}

		if ($param['type'] == 'defmail') {
			$content = '*: ' . $param['mail'];
			$content2 = '@' . $param['domain'] . ' ' . $param['mail'];
		}

		if ($param['type'] == 'nothing') {
			$content = '*: :blackhole:';
			$content2 = '@' . $param['domain'] . ' nobody';
		}

		file_put_contents('/etc/valiases/' . $param['domain'], $content);

		if (file_exists('/etc/postfix/virtual')) {
			$this->sudo_ssh('sed -i \'/.' . $param['domain'] . '/d\' /etc/postfix/virtual');
			file_put_contents('/etc/postfix/virtual', $content2, FILE_APPEND);
			$this->sudo_ssh('/usr/sbin/postmap /etc/postfix/virtual');
		}
	}

	public function mailclient_delete_default_mail_from_db($domain)
	{
		$text = file_get_contents('/etc/brainy/data/mailclient/defaultmail.db');
		$arr = explode("\n", $text);
		$arr = array_filter($arr);
		$result = '';

		foreach ($arr as $key) {
			$temp = explode('|', $key);

			if ($temp[0] != $domain) {
				$result .= implode('|', $temp) . "\n";
			}
		}

		file_put_contents('/etc/brainy/data/mailclient/defaultmail.db', $result);
		unlink('/etc/valiases/' . $domain);
		$this->sudo_ssh('sed -i \'/.' . $domain . '/d\' /etc/postfix/virtual');
		$this->sudo_ssh('/usr/sbin/postmap /etc/postfix/virtual');
	}

	public function mailclient_get_default_mail_table($user)
	{
		if (!$this->check_user($user)) {
			return false;
		}

		$webserver = new webserver();
		$vhosts = $webserver->get_virt_hosts($user, 1);
		$result = array();

		foreach ($vhosts as $vhost) {
			$result[$vhost['domain']][] = $vhost['domain'];
			$val = $this->config_read($GLOBALS['DATA_VHOSTS'] . $vhost['domain'] . '.conf')['defmail'];
			$exp_val = explode('|', $val);
			$result[$vhost['domain']][] = $exp_val[0];

			if (isset($exp_val[1])) {
				$result[$vhost['domain']][] = $exp_val[1];
			}
		}

		return $result;
	}

	public function set_def_action_mail_in_vhost($data)
	{
		global $lang;
		$webserver = new webserver();
		$user = $data['username'];

		if (!$this->check_user($user)) {
			return false;
		}

		$puny = new idna_convert();
		$domain = $puny->encode(trim($data['dom']));
		$email = $data['defemail'];

		if (!$this->check_params('email', $email)) {
			return false;
		}

		$vhosts = $webserver->get_virt_hosts($user);
		$q = 0;

		foreach ($vhosts as $vhost) {
			$q = 1;
			break;
		}

		if ($q == 0) {
			$res['error_code'] = -1;
			$res['message'] = $lang['msg_mail_not_your_domain'];
			return $res;
		}

		$def_action = array('notset', 'blackhole', 'faileddel', 'defaultmail');

		if (!in_array($data['defaction'], $def_action)) {
			$res['error_code'] = 3;
			$res['message'] = $lang['msg_mail_enter_def_action'];
			return $res;
		}

		$arr_update_conf['defmail'] = $data['defaction'];

		if ($data['defaction'] == 'defaultmail') {
			if (!$this->mailclient_validateEmail($email)) {
				$res['error_code'] = 2;
				$res['message'] = $lang['msg_mail_enter_email'];
				return $res;
			}

			$arr_update_conf .= 'defmail';
		}

		$this->config_save($GLOBALS['DATA_VHOSTS'] . $domain . '.conf', $arr_update_conf, 'add');
		$res['error_code'] = 0;
		$res['message'] = $lang['msg_mail_process_ok'];
		return $res;
	}

	public function mailclient_add_default_mail($param)
	{
		global $lang;

		if (0 < strlen($param['type'])) {
			if (!$this->check_value('string', $param['type'])) {
				$res['error_code'] = 2;
				$res['error_text'] = $lang['server_control_error_user'];
				return $res;
			}
		}

		$res = array();
		$res['error_code'] = 0;
		$types = array('failed', 'nothing', 'defmail');

		if (strlen($param['user']) == 0) {
			$res['error_code'] = 1;
			$res['error_text'] = $lang['msg_mail_choose_user'];
			return $res;
		}

		if (!$this->mailclient_validateHost($param['domain'])) {
			$res['error_code'] = 1;
			$res['error_text'] = $lang['msg_mail_enter_domain'];
			return $res;
		}

		if ($this->mailclient_check_default_mail_in_db($param['domain'])) {
			$res['error_code'] = 1;
			$res['error_text'] = $lang['msg_mail_already_domain'];
			return $res;
		}

		if (!in_array($param['type'], $types)) {
			$res['error_code'] = 1;
			$res['error_text'] = $lang['msg_mail_chouse_option'];
			return $res;
		}

		if ($param['type'] == 'defmail') {
			if (!$this->mailclient_validateEmail($param['mail'])) {
				$res['error_code'] = 1;
				$res['error_text'] = $lang['msg_mail_enter_email'];
				return $res;
			}
		}

		$this->mailclient_add_default_mail_to_db($param);
		return $res;
	}

	public function mailclient_check_autoanswer_in_db($mail)
	{
		$text = file_get_contents('/etc/brainy/data/mailclient/autoanswer.db');
		$arr = explode("\n", $text);
		$arr = array_filter($arr);

		foreach ($arr as $key) {
			$temp = explode('|', $key);

			return true;
		}

		return false;
	}

	public function mailclient_add_autoanswer_to_db($param)
	{
		$param['body'] = mysqli_real_escape_string($param['body']);

		if (!$this->check_params('email', $param['mail'])) {
			return false;
		}

		if (!$this->check_params('string', $param['subject'])) {
			return false;
		}

		if (!$this->check_params('number', $param['timer'])) {
			return false;
		}

		$line = $param['mail'] . '|' . $param['user'] . '|' . $param['timer'] . '|' . $param['from'] . '|' . $param['subject'] . "\n";
		file_put_contents('/etc/brainy/data/mailclient/autoanswer.db', $line, FILE_APPEND);
		file_put_contents('/etc/brainy/data/mailclient/autotpl/' . $param['mail'] . '.tpl', $param['body']);
		$db = self::getInstance();

		if (is_array($db)) {
			return $db;
		}

		$mysqli = $db->getConnection();
		$sql_query = 'INSERT INTO vacation (email,subject,body,interval_time,active)';
		$sql_query .= ' VALUES (\'' . $param['mail'] . '\',\'' . $param['subject'] . '\',\'' . $param['body'] . '\',\'' . $param['timer'] . '\',1)';
		$res = $mysqli->query($sql_query);
	}

	public function mailclient_delete_autoanswer_from_db($mail)
	{
		if (!$this->check_params('email', $mail)) {
			return false;
		}

		$text = file_get_contents('/etc/brainy/data/mailclient/autoanswer.db');
		$arr = explode("\n", $text);
		$arr = array_filter($arr);
		$result = '';

		foreach ($arr as $key) {
			$temp = explode('|', $key);

			if ($temp[0] != $mail) {
				$result .= implode('|', $temp) . "\n";
			}
			else {
				$out = $this->sudo_ssh('rm -rf /etc/brainy/data/mailclient/autotpl/' . $mail . '.tpl');
			}
		}

		file_put_contents('/etc/brainy/data/mailclient/autoanswer.db', $result);
		$db = self::getInstance();

		if (is_array($db)) {
			return $db;
		}

		$mysqli = $db->getConnection();
		$sql_query = 'DELETE FROM vacation WHERE email=\'' . $mail . '\'';
		$res = $mysqli->query($sql_query);
	}

	public function mailclient_get_autoanswer_table($user)
	{
		$text = file_get_contents('/etc/brainy/data/mailclient/autoanswer.db');
		$arr = explode("\n", $text);
		$arr = array_filter($arr);
		$result = array();
		$i = 0;

		foreach ($arr as $key) {
			$temp = explode('|', $key);

			if ($temp[1] == $user) {
				$result[$i][0] = $temp[0];
				$result[$i][1] = $temp[4];
				++$i;
			}
		}

		return $result;
	}

	public function mailclient_add_autoanswer($param)
	{
		global $lang;
		$res = array();
		$res['error_code'] = 0;

		if (strlen($param['user']) == 0) {
			$res['error_code'] = 1;
			$res['error_text'] = $lang['msg_mail_choose_user'];
			return $res;
		}

		if (!$this->mailclient_validateEmail($param['mail'])) {
			$res['error_code'] = 1;
			$res['error_text'] = $lang['msg_mail_enter_email'];
			return $res;
		}

		if ($this->mailclient_check_autoanswer_in_db($param['mail'])) {
			$res['error_code'] = 1;
			$res['error_text'] = $lang['msg_mail_already_autoanswer'];
			return $res;
		}

		if (strlen($param['timer']) == 0) {
			$res['error_code'] = 1;
			$res['error_text'] = $lang['msg_mail_enter_time'];
			return $res;
		}

		if (strlen($param['from']) == 0) {
			$res['error_code'] = 1;
			$res['error_text'] = $lang['msg_mail_enter_text'];
			return $res;
		}

		if (strlen($param['subject']) == 0) {
			$res['error_code'] = 1;
			$res['error_text'] = $lang['msg_mail_enter_subject'];
			return $res;
		}

		if (strlen($param['body']) == 0) {
			$res['error_code'] = 1;
			$res['error_text'] = $lang['msg_mail_enter_body'];
			return $res;
		}

		$this->mailclient_add_autoanswer_to_db($param);
		return $res;
	}

	public function getValueQualifyDomain($user)
	{
		global $lang;
		$userConf = $this->config_read($GLOBALS['USERS_PATH'] . $user);

		if (isset($userConf['jailstatset']) && ($userConf['jailstatset'] == 1)) {
			$res['code'] = 0;
			$quaDomain = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($userConf['rootdir'] . '/etc/exim/exim.conf'));
			$quaDomain_val = '';

			foreach ($quaDomain as $curVal) {
				$quaDomain_val = trim(explode('=', $curVal)[1]);
				break;
			}

			$res['qualify_domain'] = $quaDomain_val;
		}
		else {
			$res['code'] = -1;
			$res['message'] = $lang['mailclient_qualifyCantSetQualifyNotJail'];
			$quaDomain = preg_split('/\\r\\n|\\r|\\n/', file_get_contents('/etc/exim/exim.conf'));
			$quaDomain_val = '';

			foreach ($quaDomain as $curVal) {
				$quaDomain_val = trim(explode('=', $curVal)[1]);
				break;
			}

			$res['qualify_domain'] = $quaDomain_val;
		}

		return $res;
	}

	public function updateQualifyDomain($user, $domain)
	{
		global $lang;
		$userConf = $this->config_read($GLOBALS['USERS_PATH'] . $user);

		if (isset($userConf['jailstatset']) && ($userConf['jailstatset'] == 1)) {
			if (!implode('', $this->ssh('cat ' . $userConf['rootdir'] . '/etc/exim/exim.conf | grep "qualify_domain"'))) {
				$res['message'] = $lang['mailclient_not_quality_domain'];
				return $res;
			}

			if (!$this->check_params('domain', $domain) && ($domain != 'localhost')) {
				$res['message'] = $lang['mailclient_qualify_save_failed'];
				return $res;
			}
			if ($domain) {
				$upd_to = 'qualify_domain = ' . $domain;
			}
			else {
				$upd_to = '#qualify_domain = ' . $domain;
			}

			$doUpd = 'sed -i "/qualify_domain/c' . $upd_to . '" ' . $userConf['rootdir'] . '/etc/exim/exim.conf';
			$this->ssh($doUpd);
			$res['message'] = $lang['mailclient_qualify_save_ok'];
		}
		else {
			$res['message'] = $lang['mailclient_qualifyCantSetQualifyNotJail'];
		}

		return $res;
	}
}


?>
