<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class mailserver
{
	const PATH_TO_SCRIPTS = '/etc/brainy/ssh/mailserver/';

	static public $COMMANDS = array('start', 'stop', 'restart', 'install', 'delete', 'reinstall', 'remove', 'install1', 'install2', 'on', 'off');
	static public $SERVICES = array('dovecot', 'exim', 'postfix', 'clamav', 'clamd@scan', 'spamassassin', 'opendkim', 'opendmarc', 'roundcube', 'webmaillite', 'squirrelmail', 'mailserver');

	public function mailserver_get_version()
	{
		$this->load_vars('config.cnf');
		return $this->module_vars;
	}

	public function mailserver_show_version($server)
	{
		global $lang;
		$this->load_vars('config.cnf');
		$arr = $this->module_vars;

		if ($server == 'sendserver') {
			if (($arr['sendserver'] == 'Not installed') || (strlen($arr['sendserver']) < 2)) {
				$result['version'][] = $lang['tpl_mail_not_install'];
			}
			else {
				$result['version'][] = $arr['sendserver'] . $lang['msg_mail_ver_txt'] . $arr['sendserver_version'];
			}

			$result['nn'] = 0;
			if (($arr['dkim'] == 'Not installed') || (strlen($arr['dkim']) < 2)) {
				$result['version'][] = $lang['tpl_mail_not_install'];
			}
			else {
				$result['version'][] = $arr['dkim'] . $lang['msg_mail_ver_txt'] . $arr['dkim_version'];
			}

			++$result['nn'];
			if (($arr['antispam'] == 'Not installed') || (strlen($arr['antispam']) < 2)) {
				$result['version'][] = $lang['tpl_mail_not_install'];
			}
			else {
				$result['version'][] = $arr['antispam'] . $lang['msg_mail_ver_txt'] . $arr['antispam_version'];
			}

			++$result['nn'];
			if (($arr['antivirus'] == 'Not installed') || (strlen($arr['antivirus']) < 2)) {
				$result['version'][] = $lang['tpl_mail_not_install'];
			}
			else {
				$result['version'][] = $arr['antivirus'] . $lang['msg_mail_ver_txt'] . $arr['antivirus_version'];
			}

			++$result['nn'];
			if (($arr['dmarc'] == 'Not installed') || (strlen($arr['dmarc']) < 2)) {
				$result['version'][] = $lang['tpl_mail_not_install'];
			}
			else {
				$result['version'][] = $arr['dmarc'] . $lang['msg_mail_ver_txt'] . $arr['dmarc_version'];
			}

			++$result['nn'];
			$result['service'][0] = $arr['sendserver'];

			if ($result['service'][0] == 'Not installed') {
				$result['service'][0] = 'Postfix';
			}

			$result['service'][1] = $result['service'][0] == 'Postfix' ? 'Exim' : 'Postfix';
			$result['available'][] = $this->mailserver_get_available(strtolower($arr['sendserver']));
			$result['available'][] = $this->mailserver_get_available('opendkim');
			$result['available'][] = $this->mailserver_get_available('spamassassin');

			if ($GLOBALS['v2'] == 'yes') {
				$result['available'][] = $this->mailserver_get_available('clamd@scan');
			}
			else {
				$result['available'][] = $this->mailserver_get_available('clamd');
			}

			$result['available'][] = $this->mailserver_get_available('opendmarc');
		}

		if ($server == 'receiveserver') {
			if (($arr['receiveserver'] == 'Not installed') || (strlen($arr['receiveserver']) < 2)) {
				$result['version'][] = $lang['tpl_mail_not_install'];
			}
			else {
				$result['version'][] = $arr['receiveserver'] . $lang['msg_mail_ver_txt'] . $arr['receiveserver_version'];
			}

			$result['nn'] = 0;
			if (($arr['roundcube'] == 'Not installed') || (strlen($arr['roundcube']) < 2)) {
				$result['version'][] = $lang['tpl_mail_not_install'];
			}
			else {
				$result['version'][] = $arr['roundcube'] . $lang['msg_mail_ver_txt'] . $arr['roundcube_version'];
			}

			++$result['nn'];
			if (($arr['squirrelmail'] == 'Not installed') || (strlen($arr['squirrelmail']) < 2)) {
				$result['version'][] = $lang['tpl_mail_not_install'];
			}
			else {
				$result['version'][] = $arr['squirrelmail'] . $lang['msg_mail_ver_txt'] . $arr['squirrelmail_version'];
			}

			++$result['nn'];
			if (($arr['webmaillite'] == 'Not installed') || (strlen($arr['webmaillite']) < 2)) {
				$result['version'][] = $lang['tpl_mail_not_install'];
			}
			else {
				$result['version'][] = $arr['webmaillite'] . $lang['msg_mail_ver_txt'] . $arr['webmaillite_version'];
			}

			++$result['nn'];
			$result['available'][] = $this->mailserver_get_available('dovecot');
		}

		return $result;
	}

	public function mailserver_get_available($service)
	{
		global $lang;
		$service = escapeshellcmd($service);
		$result = $this->monitor_get_service_status($service);

		if ($result == 'on') {
			return $lang['msg_mail_run'];
		}

		return $lang['msg_mail_stoped'];
	}

	public function mailserver_set_exim_vars($array)
	{
		global $lang;
		$array_config = $this->config_read('/etc/brainy/data/mailserver/conf_exim');

		foreach ($array as $key => $value) {
			if (!preg_match('|^[0-9]+$|Usi', $value)) {
				$out['error'] = '100';
				$out['message'] = $lang['mailserver_error_format_number'];

				return $out;
			}

			switch ($key) {
			case 'mail_per_hour':
				$val_param = $value . ' \\/ 1h \\/ leaky';
				$this->sudo_ssh('sed -i "s@ratelimit =.*@ratelimit = ' . $value . ' \\/ 1h \\/ leaky@g" /etc/exim/exim.conf');
				$key = 'ratelimit';
				break;

			case 'message_size_limit':
				$val_param = $value . 'M';
				$this->sudo_ssh('sed -i "s@message_size_limit =.*@message_size_limit = ' . $value . 'M@g" /etc/exim/exim.conf');
				break;
			}

			$array_config[$key] = $value;
		}

		$this->config_save('/etc/brainy/data/mailserver/conf_exim', $array_config, 'r');
		$this->ssh('echo "' . "\r" . '" >> /etc/brainy/data/mailserver/conf_exim');
		$out['error'] = '0';
		$out['message'] = $lang['mailserver_success'];
		$this->sudo_ssh('service exim reload');
		return $out;
	}

	public function mailserver_get_exim_vars()
	{
		$out = $this->read_file('/etc/exim/exim.conf');
		preg_match_all('|ratelimit = ([0-9]+) / 1h / leaky|Usi', $out, $out1);
		$out2['mail_per_hour_limit'] = $out1[1][0];

		if (!$out1[1][0]) {
			$out2['mail_per_hour_limit'] = 0;
		}

		preg_match_all('/message_size_limit = ([0-9]+)/iu', $out, $out1);
		$out2['message_size_limit'] = $out1[1][0];
		return $out2;
	}

	public function mailserver_get_progress()
	{
		$this->load_vars();
		return $this->module_vars;
	}

	public function mailserver_run($service, $comm, $screen)
	{
		if (!$this->check_value('stringservice', $screen)) {
			return false;
		}

		if (!in_array($comm, $this::$COMMANDS)) {
			return false;
		}

		if (!in_array($service, $this::$SERVICES)) {
			return false;
		}

		switch ($comm) {
		case 'start':
		case 'stop':
		case 'restart':
			$result = $this->mailserver_comm_start($service, $comm);
			break;

		case 'on':
		case 'off':
		case 'install':
		case 'delete':
		case 'reinstall':
		case 'install1':
		case 'install2':
		case 'remove':
			$result = $this->mailserver_comm_install($service, $comm, $screen);
			break;
		}

		return $result;
	}

	public function getstat_systemctl($stat, $act = 'status')
	{
		global $lang;
		$out = array();
		if ((stripos($stat, 'inactive') !== false) || ($act == 'stop')) {
			$out[] = $lang['mailserver_stop_ok'];
			return $out;
		}

		if (stripos($stat, 'failed') !== false) {
			$out[] = $lang['mailserver_start_failed'];
		}

		if ((stripos($stat, 'active') !== false) && (stripos($stat, 'inactive') === false)) {
			$out[] = $lang['mailserver_start_ok'];
		}

		return $out;
	}

	public function mailserver_comm_start($service, $act)
	{
		if ($service == 'clamav') {
			$service = 'clamd';
		}

		if (stripos($GLOBALS['OS_VERSION'], 'centos7') !== false) {
			if ($act == 'status') {
				$stat = implode(',', $this->sudo_ssh('systemctl is-active ' . $service));
				$out = $this->getstat_systemctl($stat);
			}
			else {
				$this->sudo_ssh('systemctl ' . $act . ' ' . $service);
				sleep(2);
				$stat = implode(',', $this->sudo_ssh('systemctl is-active ' . $service));
				$out = $this->getstat_systemctl($stat, $act);
			}
		}
		else {
			$out = $this->sudo_ssh('service ' . $service . ' ' . $act);
		}

		if ($service == 'clamd') {
			$service = 'clamav';
		}

		if (($service == 'clamav') || ($service == 'spamassassin')) {
			$mail = new mailclient();

			if ($act == 'stop') {
				$mail->mailclient_run2($service, 'off');
			}

			if ($act == 'start') {
				$mail->mailclient_run2($service, 'on');
			}

			if ($act == 'restart') {
				if ($stat == 'active') {
					$mail->mailclient_run2($service, 'on');
				}
				else {
					$mail->mailclient_run2($service, 'off');
				}
			}
		}

		return $out;
	}

	public function mailserver_comm_install($service, $act, $screen)
	{
		if ($act == 'delete') {
			$act = 'remove';
		}

		$certs = new certs();

		if ($certs->check_cert_exist('smtp') == 0) {
			$datares = $certs->generate_cert('smtp', 'smtp');
			$certs->service_install_newcert($datares['crt'], $datares['key'], '', array('smtp'));
		}

		if ($certs->check_cert_exist('imap') == 0) {
			$datares = $certs->generate_cert('imap', 'imap');
			$certs->service_install_newcert($datares['crt'], $datares['key'], '', array('imap'));
		}

		if (($act == 'remove') && ($service == 'clamav')) {
			$mail = new mailclient();
			$mail->mailclient_run2($service, 'off');
		}

		$stream[0]['comm'] = $this::PATH_TO_SCRIPTS . $service . '.sh ' . $act . ' ' . gethostbyname(gethostname());
		$stream[0]['test'] = 'Complete';
		$stream[0]['array_start'] = array('one' => 'inprogress,#stream_id#', 'screen' => $screen);
		$stream[0]['array_succes'] = array('one' => 'success,#stream_id#');
		$stream[0]['array_unsucces'] = array('one' => 'unsuccess,#stream_id#', 'error' => '#error#');
		$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php -q /etc/brainy/ssh/monitor/scaner.php > /dev/null 2> /dev/null';
		$out = $this->create_stream($stream);
		return 'ajax';
	}

	public function mailserver_comm_cust($service, $cust, $act)
	{
		if (!$this->check_value('string', $service) || !$this->check_value('string', $cust) || !$this->check_value('string', $act)) {
			return false;
		}

		$out = $this->sudo_ssh($this::PATH_TO_SCRIPTS . $service . '_cust.sh ' . $cust . ' ' . $act);

		if ($service == 'exim') {
			if ($act != 'check') {
				$array_config = $this->config_read('/etc/brainy/data/mailserver/conf_exim');
				$array_config[$cust] = $act;
				$this->config_save('/etc/brainy/data/mailserver/conf_exim', $array_config, 'r');
				$this->ssh('echo "' . "\r" . '" >> /etc/brainy/data/mailserver/conf_exim');
			}
		}

		return $out[0];
	}

	public function mailserver_comm_txt($service, $act, $txt)
	{
		if (!$this->check_value('string', $service) || !$this->check_value('string', $act)) {
			return false;
		}

		$txt = trim($txt);
		$out = $this->sudo_ssh($this::PATH_TO_SCRIPTS . 'save_txt.sh ' . $service . ' ' . $act . ' \'' . $txt . '\'');
		return $out[0] . $service . ' ' . $act . ' ' . $txt;
	}

	public function get_all_sites_dmarc($user, $decode = 0)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		$bindserver = new bindserver();
		$sites = $bindserver->bindserver_getZoneByUser($user);
		$puny = new idna_convert();

		if (is_array($sites)) {
			foreach ($sites as $key => $value) {
				if ($decode == 0) {
					$newmass[$key]['domain'] = $value;
				}
				else {
					$newmass[$key]['domain'] = $value;
					$newmass[$key]['domain_decode'] = $puny->decode($value);
				}

				$foo = $this->mailserver_read_dmarc($value);
				$newmass[$key]['dmarc'] = $foo;

				if ($newmass[$key]['dmarc']['zone'] == 'no') {
					$newmass[$key]['onoff'] = 1;
				}
				else {
					$newmass[$key]['onoff'] = 0;
				}
			}
		}

		return $newmass;
	}

	public function mailserver_read_dmarc($domain)
	{
		if (!$this->check_value('domain', $domain)) {
			return false;
		}

		$dmarc['zone'] = 'no';
		$dmarc['line'] = 0;
		$bindserver = new bindserver();
		$onoff = 1;
		$zone = $bindserver->bindserver_readZone($domain);
		$zone = explode("\n", trim($zone));
		$DEBUG = false;

		if ($DEBUG) {
			print_r($zone);
		}

		foreach ($zone as $key => $value) {
			$foo = preg_replace('|[\\s]+|s', ' ', $value);
			$foo = explode(' ', $foo);
			$type = $foo[1];

			if ($DEBUG) {
				print_r($foo);
			}

			$dmarc['jmp'] = array('none', 'reject', 'quarantine');

			if ($type == 'TXT') {
				unset($foo[1]);
				unset($foo[0]);
				$foo = implode(' ', $foo);

				if ($DEBUG) {
					print('line: ' . $value . '<br>');
				}

				if ((0 < substr_count($value, 'v=DMARC')) && (0 < substr_count($value, $domain))) {
					$dmarc['zone'] = $foo;
					$dmarc['line'] = $key + 1;

					if ($c = strstr($value, 'p=')) {
						$c = substr($c, 2);
						$c = str_replace('"', '', $c);
						$j = explode(';', $c);
						$dmarc['jmp'] = array_diff($dmarc['jmp'], array($j[0]));
						array_unshift($dmarc['jmp'], $j[0]);
					}

					if ($c = strstr($value, 'rua=mailto:')) {
						$c = substr($c, 11);
						$j = explode(';', $c);
						$dmarc['mailto'] = array_diff($dmarc['mailto'], array($j[0]));
					}
				}
			}
		}

		if ($DEBUG) {
			print_r($dmarc);
		}

		return $dmarc;
	}

	public function mailserver_dmarc_create($domain, $onoff, $line = NULL, $jmp, $mailto)
	{
		global $lang;
		$bindserver = new bindserver();

		if (!$this->check_value('domain', $domain)) {
			return false;
		}

		if (($line != NULL) && !$this->check_value('number', $line)) {
			return false;
		}

		if (is_file('/etc/brainy/data/vhosts/' . $domain . '.conf')) {
			$config = $this->config_read('/etc/brainy/data/vhosts/' . $domain . '.conf');
		}
		else {
			$file_main = $this->getmaindomain_byalias($domain);
			$config = $this->config_read($file_main);
		}

		$ip = $config['ip'];
		$to = '';

		if (trim($mailto)) {
			$to = '; rua=mailto:' . $mailto;
		}

		$command = '"v=DMARC1; p=' . $jmp . $to . '"';

		if ($onoff == 1) {
			$out['comm_result'] = $bindserver->bindserver_addAddrToZone($domain, '_dmarc.' . $domain . '.', 'txt', $command);
			$out['error'] = 0;
			$out['command'] = $command;
			$out['mess'] = $lang['msg_mail_success_edit'];
			$foo = $this->mailserver_read_dmarc($domain);
			$out['line'] = $foo['line'];
			$cloudflare = new cloudflare();
			$cloudflare->add_record_other_modules($domain, 'add_record', $domain, $command);
		}
		else {
			$out['comm_result'] = $bindserver->bindserver_delete_record($domain, $line);
			$out['error'] = 0;
			$out['command'] = 'no';
			$out['mess'] = $lang['msg_mail_success_edit'];
			$cloudflare = new cloudflare();
			$cloudflare->add_record_other_modules($domain, 'remove_record', $domain, $command);
		}

		return $out;
	}

	public function mailserver_spfcreate($domain, $onoff, $line = NULL)
	{
		global $lang;
		$bindserver = new bindserver();

		if (!$this->check_value('domain', $domain)) {
			return false;
		}

		if (($line != NULL) && !$this->check_value('number', $line)) {
			return false;
		}

		if (is_file('/etc/brainy/data/vhosts/' . $domain . '.conf')) {
			$config = $this->config_read('/etc/brainy/data/vhosts/' . $domain . '.conf');
		}
		else {
			$file_main = $this->getmaindomain_byalias($domain);
			$config = $this->config_read($file_main);
		}

		$ip = $config['ip'];
		$command = '"v=spf1 +a +mx +ip4:' . $ip . ' ~all"';

		if ($onoff == 1) {
			$out['comm_result'] = $bindserver->bindserver_addAddrToZone($domain, $domain . '.', 'txt', $command);
			$out['error'] = 0;
			$out['command'] = $command;
			$out['mess'] = $lang['msg_mail_success_edit'];
			$foo = $this->mailserver_readspf($domain);
			$out['line'] = $foo['line'];
			$cloudflare = new cloudflare();
			$cloudflare->add_record_other_modules($domain, 'add_record', $domain, $command);
		}
		else {
			$out['comm_result'] = $bindserver->bindserver_delete_record($domain, $line);
			$out['error'] = 0;
			$out['command'] = 'no';
			$out['mess'] = $lang['msg_mail_success_edit'];
			$cloudflare = new cloudflare();
			$cloudflare->add_record_other_modules($domain, 'remove_record', $domain, $command);
		}

		return $out;
	}

	public function get_all_sites_spf($user, $decode = 0)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		$bindserver = new bindserver();
		$sites = $bindserver->bindserver_getZoneByUser($user);
		$puny = new idna_convert();

		if (is_array($sites)) {
			foreach ($sites as $key => $value) {
				if ($decode == 0) {
					$newmass[$key]['domain'] = $value;
				}
				else {
					$newmass[$key]['domain'] = $value;
					$newmass[$key]['domain_decode'] = $puny->decode($value);
				}

				$foo = $this->mailserver_readspf($value);
				$newmass[$key]['spf'] = $foo;

				if ($newmass[$key]['spf']['zone'] == 'no') {
					$newmass[$key]['onoff'] = 1;
				}
				else {
					$newmass[$key]['onoff'] = 0;
				}
			}
		}

		return $newmass;
	}

	public function mailserver_readspf($domain)
	{
		if (!$this->check_value('domain', $domain)) {
			return false;
		}

		$myspf['zone'] = 'no';
		$myspf['line'] = 0;
		$bindserver = new bindserver();
		$onoff = 1;
		$zone = $bindserver->bindserver_readZone($domain);
		$zone = explode("\n", trim($zone));

		foreach ($zone as $key => $value) {
			$foo = preg_replace('|[\\s]+|s', ' ', $value);
			$foo = explode(' ', $foo);
			$type = $foo[1];

			if ($type == 'TXT') {
				unset($foo[1]);
				unset($foo[0]);
				$foo = implode(' ', $foo);

				if ((0 < substr_count($value, 'v=spf')) && (0 < substr_count($value, $domain)) && (substr_count($value, '.' . $domain) == 0)) {
					$myspf['zone'] = $foo;
					$myspf['line'] = $key + 1;
				}
			}
		}

		return $myspf;
	}

	public function mailserver_ajax()
	{
		global $lang;
		$this->load_vars();
		$one = $this->module_vars['one'];
		$one = explode(',', $one);
		$result['stream_output'] = implode("\n", $this->read_stream($one[1]));
		$result['status'] = $one[0];

		if ($result['status'] == 'unsuccess') {
			$result['status_detail'] = $lang['msg_mail_process_ok'] . ' ' . $lang['msg_mail_process_last_log'] . $this->module_vars['error'];
		}

		if ($result['status'] == 'success') {
			$result['status_detail'] = $lang['msg_mail_process_ok'];
		}

		return $result;
	}

	public function mailserver_getCustomazing($service)
	{
		global $lang;

		if (!$this->check_value('string', $service)) {
			return false;
		}

		$cust = array(
			array($lang['mailserver_reject_remote_mail']),
			array($lang['mailserver_reject_spf']),
			array($lang['mailserver_reject_bounce']),
			array($lang['mailserver_reject_smtp_sender']),
			array($lang['mailserver_reject_dmarc'])
			);
		$i = 0;

		while ($i < count($cust)) {
			$cust[$i][] = $this->mailserver_comm_cust($service, $i, 'check');
			++$i;
		}

		return $cust;
	}

	public function mailserver_getMailips()
	{
		return implode('', file('/etc/mailips'));
	}

	public function mailserver_getRBL($service)
	{
		if (!$this->check_value('string', $service)) {
			return false;
		}

		return implode('', file('/etc/' . $service . '/rbl_reject'));
	}

	public function mailserver_get_mail_queue($server)
	{
		if ($server == 'Postfix') {
			$out = $this->sudo_ssh('postqueue -p | awk "NR >1"');

			if ($out[0] == 'Mail queue is empty') {
				return NULL;
			}

			$res_queue_parse = array();
			$i = -1;
			$j = 0;

			foreach ($out as $row) {
				$res = preg_match_all('/^Mon|Tue|Wed|Thu|Fri|Sat|Sun/', $row, $matches);

				if ($res) {
					++$i;
					$j = 0;
				}
				else {
					++$j;
				}

				$exp = preg_split('/\\r\\n|\\r|\\n\\t|\\s+/', $row);

				if ($j == 0) {
					$res_queue_parse[$i][2] = $exp[0];
					$res_queue_parse[$i][4] = $exp[1];
					$res_queue_parse[$i][0] = $exp[2] . ' ' . $exp[3] . ' ' . $exp[4] . ' ' . $exp[5];
					$res_queue_parse[$i][7] = $exp[6];
				}

				if ($j == 1) {
					if (0 < stripos($row, 'connect')) {
						$res_queue_parse[$i][5] = $row;
					}
					else {
						$res_queue_parse[$i][3] = $row;
					}
				}

				if ($j == 2) {
					if (2 < strlen($row)) {
						$res_queue_parse[$i][3] = $row;
					}
				}

				$res_queue_parse[$i][6] = 'Postfix';
			}

			return $res_queue_parse;
		}

		if ($server == 'Exim') {
			$out = $this->sudo_ssh('mailq');
		}

		if ($server == 'Not installed') {
			return NULL;
		}

		$result = array();
		$i = 0;
		$t = 0;
		$a = 0;

		while ($a < count($out)) {
			$out[$a] = trim(preg_replace('/\\s+/', ' ', $out[$a]));
			$temp = explode(' ', $out[$a]);
			$result[$t][0] = $temp[0];
			$result[$t][4] = $temp[1];
			$result[$t][5] = $temp[5];
			$result[$t][1] = $temp[4];
			$result[$t][2] = $temp[2];
			$result[$t][6] = $server;
			$result[$t][3] = trim($out[$a + 1]);
			++$t;
			$a = $a + 3;
		}

		return $result;
	}

	public function mailserver_delete_mail_from_queue($id, $server)
	{
		if (!$this->check_value('string', $id)) {
			return false;
		}

		if ($server == 'Postfix') {
			$out = $this->sudo_ssh('postsuper -d ' . $id);
		}

		if ($server == 'Exim') {
			$out = $this->sudo_ssh('exim -Mg ' . $id);
		}

		return true;
	}

	public function mailserver_get_user_email($user)
	{
		if ($user) {
			if (!$this->check_value('user', $user)) {
				return false;
			}
		}

		$mail = new mailclient();
		return $mail->mailclient_getEmails($user);
	}

	public function mailserver_viewmessage_byid($idmess)
	{
		if (!$this->check_value('string', $idmess)) {
			return false;
		}

		$this->load_vars('config.cnf');
		$arr = $this->module_vars;
		$idmess = escapeshellcmd($idmess);

		if ($arr['sendserver'] == 'Exim') {
			$idmess = substr($idmess, 0, 25);
			$res['header'] = $this->ssh('exim -Mvh \'' . $idmess . '\'');
			$res['body'] = $this->ssh('exim -Mvb \'' . $idmess . '\'');
			$res['log'] = $this->ssh('exim -Mvl \'' . $idmess . '\'');
		}

		if ($arr['sendserver'] == 'Postfix') {
			$idmess = substr($idmess, 0, 25);
			$res['header'] = $this->ssh('postcat -q \'' . $idmess . '\'');
			$res['body'] = '';
			$res['log'] = '';
		}

		return $res;
	}

	public function mailserver_clearqueue()
	{
		$this->load_vars('config.cnf');
		$arr = $this->module_vars;

		if ($arr['sendserver'] == 'Exim') {
			$res['result'] = $this->ssh('exipick -i | xargs exim -Mrm');
			$res['code'] = 0;
		}

		if ($arr['sendserver'] == 'Postfix') {
			$res['result'] = $this->ssh('postsuper -d ALL');
			$res['code'] = 0;
		}

		return $res;
	}

	public function mailserver_clearqueue_force()
	{
		$this->load_vars('config.cnf');
		$arr = $this->module_vars;

		if ($arr['sendserver'] == 'Exim') {
			$res1 = $this->ssh('rm -rf /var/spool/exim/db/');
			$res1 = $this->ssh('rm -rf /var/spool/exim/input/');
			$res1 = $this->ssh('rm -rf /var/spool/exim/msglog/');
			$res1 = $this->ssh('rm -rf /var/spool/exim/scan/');
			$res['stat'] = $this->ssh('service exim restart');
			$res['code'] = 0;
		}

		return $res;
	}

	public function mailserver_count_mess_queue()
	{
		$this->load_vars('config.cnf');
		$arr = $this->module_vars;

		if ($arr['sendserver'] == 'Exim') {
			$res['count'] = $this->ssh('exim -bpc');
			$res['code'] = 0;
		}

		if ($arr['sendserver'] == 'Postfix') {
			$res['count'] = $this->ssh('time find /var/spool/postfix/{deferred,active,maildrop,incoming}/ -type f | wc -l');
			$res['code'] = 0;
		}

		return $res;
	}

	public function mailserver_clearqueue_frozen()
	{
		$this->load_vars('config.cnf');
		$arr = $this->module_vars;

		if ($arr['sendserver'] == 'Exim') {
			$res['count'] = $this->ssh('exipick -zi | xargs exim -Mrm');
			$res['code'] = 0;
		}

		return $res;
	}

	public function mailserver_queue_resendmail($idmess)
	{
		if (!$this->check_value('string', $idmess)) {
			return false;
		}

		$idmess = escapeshellcmd($idmess);
		$this->load_vars('config.cnf');
		$arr = $this->module_vars;

		if ($arr['sendserver'] == 'Exim') {
			$res['resend1'] = $this->ssh('exim -Mt \'' . $idmess . '\'');
			$res['resend2'] = $this->ssh('exim -M \'' . $idmess . '\'');
			$res['code'] = 0;
		}

		if ($arr['sendserver'] == 'Postfix') {
			$res['resend1'] = $this->ssh('postsuper -r \'' . $idmess . '\'');
			$res['code'] = 0;
		}

		return $res;
	}

	public function updateexim_conf()
	{
		$mainip = $this->get_real_server_ip();
		$updateto = 'local_interfaces = 127.0.0.1 : ' . $mainip;
		$this->ssh('sed -i "/local_interfaces = 127.0.0.1/c' . $updateto . '" ' . '/etc/exim/exim.conf');
		$this->ssh('service exim restart');
	}

	public function updateQualifyDomain($domain)
	{
		global $lang;

		if (!implode('', $this->ssh('cat /etc/exim/exim.conf | grep "qualify_domain"'))) {
			$res['message'] = $lang['mailserver_not_quality_domain'];
			return $res;
		}

		if (!$this->check_params('domain', $domain) && ($domain != 'localhost')) {
			$res['message'] = $lang['mailserver_qualify_save_failed'];
			return $res;
		}
		if ($domain) {
			$upd_to = 'qualify_domain = ' . $domain;
		}
		else {
			$upd_to = '#qualify_domain = ' . $domain;
		}

		$doUpd = 'sed -i "/qualify_domain/c' . $upd_to . '" /etc/exim/exim.conf';
		$this->ssh($doUpd);
		$this->ssh('service exim restart');
		$res['message'] = $lang['mailserver_qualify_save_ok'];
		return $res;
	}

	public function mailserver_pkgBIND_present()
	{
		$comm = 'rpm -qi bind | grep Version | xargs | tr -d \' \' | tr -d \'' . "\n" . '\'';
		$out = implode("\n", $this->ssh($comm));

		if ($out == '') {
			return -1;
		}

		return 0;
	}
}


?>
