<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class mod_security
{
	private $path_mod_security_conf = '/etc/brainy/data/mod_security/main';
	private $path_mod_security = '/etc/httpd/conf.d/mod_security.conf';
	private $path_rules = '/etc/httpd/modsecurity.d/activated_rules/';
	private $path_rules_nginx = '/etc/nginx/modsecurity.d/activated_rules/';
	private $path_act_rules = '/etc/httpd/modsecurity.d/rules/';
	private $path_act_rules_nginx = '/etc/nginx/modsecurity.d/rules/';
	private $path_config = '/etc/httpd/conf.d/mod_security.conf';
	private $path_config_nginx = '/etc/nginx/modsecurity.conf';
	private $array_control = array('SecRuleEngine', 'SecAuditLog', 'SecDebugLogLevel', 'SecRequestBodyAccess', 'SecRequestBodyLimit', 'SecRequestBodyInMemoryLimit', 'SecRequestBodyNoFilesLimit', 'SecAuditLogType', 'SecDebugLog');

	public function get_config_mod_security($server = '')
	{
		$server_back = $this->status_webserver();

		$str = $this->read_file($this->path_config_nginx);

		$str = $this->read_file($this->path_config);

		switch ($server) {
		case 'apache':
			$str = $this->read_file($this->path_config);
			break;

		case 'nginx':
			$str = $this->read_file($this->path_config_nginx);
			break;
		}

		$mas_config = (!$server, $str);

		foreach ($mas_config as $key) {
			$add_str = preg_replace('/^(([ ])|(\\t))+/i', '', trim($key));

			if (!empty($add_str) && ($add_str != '')) {
				$new_mas_config[] = $add_str;
			}
		}

		$new_mas_config = array_diff($new_mas_config, array('', ' '));

		foreach ($new_mas_config as $key1) {
			$prew_mas = explode(' ', trim($key1));
			$mas_n[$prew_mas[0]] = $prew_mas[1];
		}

		foreach ($mas_n as $key2 => $val2) {
			if (in_array($key2, $this->array_control)) {
				$return_mas_config[$key2] = $val2;
			}
		}

		return $return_mas_config;
	}

	public function check_val($elem_array, $data)
	{
		if ($elem_array == 'SecRuleEngine') {
			return $this->check_value('string', $data);
		}

		if ($elem_array == 'SecAuditLog') {
			return $this->check_value('dir', $data);
		}

		if ($elem_array == 'SecDebugLog') {
			return $this->check_value('dir', $data);
		}

		if ($elem_array == 'SecDebugLogLevel') {
			return $this->check_value('number', $data);
		}

		if ($elem_array == 'SecRequestBodyAccess') {
			return $this->check_value('string', $data);
		}

		if ($elem_array == 'SecRequestBodyLimit') {
			return $this->check_value('number', $data);
		}

		if ($elem_array == 'SecRequestBodyInMemoryLimit') {
			return $this->check_value('number', $data);
		}

		if ($elem_array == 'SecRequestBodyNoFilesLimit') {
			return $this->check_value('number', $data);
		}

		if ($elem_array == 'SecAuditLogType') {
			return $this->check_value('string', $data);
		}
	}

	public function create_folder_rules($service = '')
	{
		$os_version = $GLOBALS['OS_VERSION'];

		if (stripos($service, 'nginx') !== false) {
			if (!file_exists('/etc/nginx/modsecurity.d')) {
				$this->ssh('mkdir /etc/nginx/modsecurity.d');
			}

			if (!file_exists('/etc/nginx/modsecurity.d/rules')) {
				$this->ssh('mkdir /etc/nginx/modsecurity.d/rules');
				$this->ssh('cp -fr /etc/brainy/data/mod_security/rules_nginx/* /etc/nginx/modsecurity.d/rules/');
			}

			if (!file_exists('/etc/nginx/modsecurity.d/activated_rules')) {
				$this->ssh('mkdir /etc/nginx/modsecurity.d/activated_rules');
			}
			else {
				$this->ssh('rm -f /etc/nginx/modsecurity.d/activated_rules/*');
			}
		}

		if (stripos($service, 'nginx') === false) {
			if (!file_exists('/etc/httpd/modsecurity.d/rules')) {
				$this->ssh('mkdir /etc/httpd/modsecurity.d/rules');
			}

			$this->ssh('cp -fr /etc/brainy/data/mod_security/rules_httpd/* /etc/httpd/modsecurity.d/rules/');

			if (!file_exists('/etc/httpd/modsecurity.d/activated_rules')) {
				$this->ssh('mkdir /etc/httpd/modsecurity.d/activated_rules');
			}
			else {
				$this->ssh('rm -f /etc/httpd/modsecurity.d/activated_rules/*');
			}

			$this->ssh('cp -fr /etc/brainy/data/mod_security/modules/* /etc/httpd/modsecurity.d/activated_rules/');

			if ($os_version == 'debian8') {
				$this->ssh('touch /etc/httpd/modsecurity.d/activated_rules/default.conf');
			}
		}
	}

	public function controll_panel($array)
	{
		global $lang;
		$old_config = $this->get_config_mod_security($array['server']);
		$new_config = $array;

		switch ($array['server']) {
		case 'nginx':
			$str = $this->read_file($this->path_config_nginx);
			$path_config = $this->path_config_nginx;
			break;
		}

		if ($GLOBALS['lang']) {
			$this->ssh('mv -f /etc/httpd/conf.d/mod_security.conf_off /etc/httpd/conf.d/mod_security.conf');
			$this->ssh('sed -i "/SecRuleEngine Off/SecRuleEngine On" /etc/httpd/conf.d/mod_security.conf &> /dev/null');
		}

		if ($new_config['SecRuleEngine'] == 'Off') {
			$this->ssh('sed -i "/SecRuleEngine On/SecRuleEngine Off" /etc/httpd/conf.d/mod_security.conf &> /dev/null');
			$this->ssh('mv -f /etc/httpd/conf.d/mod_security.conf /etc/httpd/conf.d/mod_security.conf_off');
		}

		$str = $this->read_file($this->path_config);
		$path_config = $this->path_config;
		break;

		$mas_config = explode(PHP_EOL, $str);

		if (5 < count($mas_config)) {
			foreach ($mas_config as $key => $val) {
				foreach ($old_config as $key_old_config => $val_old_config) {
					foreach ($new_config as $key_new_config => $val_new_config) {
						if ($key_old_config == $key_new_config) {
							$mas_config[$key] = preg_replace('/' . $key_old_config . '[ ]{1,}.*/i', $key_old_config . ' ' . $val_new_config, $val);
						}
						else {
						}

						$arr['code'] = 200;
						$arr['message'] = $lang['mod_security_error_check'];

						return $arr;
					}
				}
			}

			$text_load = implode(PHP_EOL, $mas_config);
			$this->write_file($text_load, $path_config);
		}

		$arr = $this->relode_webserver($array['server']);

		if ($array['detail'] == 'remove_file') {
			foreach ($old_config as $key1 => $val1) {
				foreach ($new_config as $key2 => $val2) {
					if (($key1 == $key2) && ($arr['code'] == 0) && ($val1 != $val2)) {
						$this->ssh('rm -f ' . $val1);
					}
				}
			}
		}

		$webserverReb = new webserver();
		$webserverReb->rebuild_virt_host();
		global $smarty;
		$smarty->assign('lang', $lang);
		return $arr;
	}

	public function save_edit_rules($data)
	{
		global $lang;

		if (!$this->check_value('filename', $data['name_rules'])) {
			$arr['code'] = 105;
			$arr['message'] = $lang['mod_security_error_literal'];
			return $arr;
		}

		$server_back = $data['server'];
		$data_file = $this->get_data_files($data['name_rules'], $server_back);

		if (!empty($data['str_rules'])) {
			if ($server_back == 'nginx') {
				$this->write_file($data['str_rules'], $this->path_act_rules_nginx . $data['name_rules']);
			}
			else {
				$this->write_file($data['str_rules'], $this->path_act_rules . $data['name_rules']);
			}

			$arr_include_rules = $this->get_include_rules($server_back);
			$status = $this->check_webserver($server_back);

			if ($status) {
				if (in_array($data['name_rules'], $arr_include_rules)) {
					$arr = $this->relode_webserver($server_back);
				}
				else {
					$arr['code'] = 0;
					$arr['message'] = $lang['mod_security_edit_successully'];
				}
			}
			else {
				if ($server_back == 'nginx') {
					$this->ssh('rm -f ' . $this->path_rules_nginx . $data['name_rules']);

					foreach ($data_file as $key_data => $val_data) {
						if (is_file($this->path_rules_nginx . $val_data)) {
							$this->ssh('rm -f ' . $this->path_rules_nginx . $val_data);
						}
					}

					$file_include = array_diff(scandir($this->path_rules_nginx), array('.', '..'));

					if (!$file_include) {
						$this->del_string('IncludeOptional', '/etc/nginx/modsecurity.conf');
					}
				}
				else {
					$this->ssh('rm -f ' . $this->path_rules . $data['name_rules']);

					foreach ($data_file as $key_data => $val_data) {
						if (is_file($this->path_rules . $val_data)) {
							$this->ssh('rm -f ' . $this->path_rules . $val_data);
						}
					}
				}

				$arr = $this->relode_webserver($server_back);
				$arr['code'] = 103;
				$arr['message'] = $lang['mod_security_error_edit_rules'];
			}
		}
		else {
			$arr['code'] = 109;
			$arr['message'] = $lang['mod_security_empty_str_rules'];
		}

		return $arr;
	}

	public function edit_rules($rules, $server)
	{
		global $lang;

		if (!preg_match('/^[a-z_0-9\\-.]+$/i', $rules)) {
			$arr['code'] = 105;
			$arr['message'] = $lang['mod_security_error_literal'];
			return $arr;
		}

		if ($server == 'nginx') {
			$out = $this->read_file($this->path_act_rules_nginx . $rules);
		}
		else {
			$out = $this->read_file($this->path_act_rules . $rules);
		}

		if ($out) {
			$arr['code'] = 0;
			$arr['str_rules'] = $out;
		}
		else {
			$arr['code'] = 108;
			$arr['message'] = $lang['mod_security_empty_rules'];
		}

		return $arr;
	}

	public function get_data_files($rules, $server_back)
	{
		if ($server_back == 'nginx') {
			$data_file = array_unique($this->ssh('cat ' . $this->path_act_rules_nginx . $rules . '  | grep -E -o \'((@pm([+a-zA-Z0-9_-])+)|(@[a-zA-Z_-]+FromFile))+ ([+a-zA-Z0-9_-])+\\.{0,1}[a-zA-Z]{0,}[^ ]"\'| grep -E -o \'[^ ]([+a-zA-Z0-9_-])+\\.{0,1}[a-zA-Z]{0,}"$\'| grep -E -o \'.*[^"]\' &>/dev/stdout'));
		}
		else {
			$data_file = array_unique($this->ssh('cat ' . $this->path_act_rules . $rules . '  | grep -E -o \'((@pm([+a-zA-Z0-9_-])+)|(@[a-zA-Z_-]+FromFile))+ ([+a-zA-Z0-9_-])+\\.{0,1}[a-zA-Z]{0,}[^ ]"\'| grep -E -o \'[^ ]([+a-zA-Z0-9_-])+\\.{0,1}[a-zA-Z]{0,}"$\'| grep -E -o \'.*[^"]\' &>/dev/stdout'));
		}

		return $data_file;
	}

	public function delete_rules($rules, $server_back)
	{
		global $lang;

		if (!preg_match('/^[a-z_0-9\\-.]+$/i', $rules)) {
			$arr['code'] = 105;
			$arr['message'] = $lang['mod_security_error_literal'];
			return $arr;
		}

		if (!$this->check_value('string', $server_back)) {
			return false;
		}

		$data_file = $this->get_data_files($rules, $server_back);

		if ($server_back == 'nginx') {
			$this->ssh('rm -f ' . $this->path_rules_nginx . $rules);
			$status = $this->check_webserver($server_back);

			if ($status) {
				$this->ssh('rm -f ' . $this->path_act_rules_nginx . $rules);

				foreach ($data_file as $key_data => $val_data) {
					if (is_file($this->path_rules_nginx . $val_data)) {
						$this->ssh('rm -f ' . $this->path_rules_nginx . $val_data);
					}

					if (is_file($this->path_act_rules_nginx . $val_data)) {
						$this->ssh('rm -f ' . $this->path_act_rules_nginx . $val_data);
					}
				}

				$file_include = array_diff(scandir($this->path_rules_nginx), array('.', '..'));

				if (!$file_include) {
					$this->del_string('IncludeOptional', '/etc/nginx/modsecurity.conf');
				}
			}
			else {
				$out = $this->ssh('ln -s ' . $this->path_act_rules_nginx . $rules . ' ' . $this->path_rules_nginx);
				$arr['code'] = 10;
				$arr['message'] = $lang['mod_security_delete_file_error'];
				return $arr;
			}
		}
		else {
			return $arr;
			$this->ssh('rm -f ' . $this->path_rules . $rules);
			$status = $this->check_webserver($server_back);

			if ($status) {
				$this->ssh('rm -f ' . $this->path_act_rules . $rules);

				foreach ($data_file as $key_data => $val_data) {
					if (is_file($this->path_rules . $val_data)) {
						$this->ssh('rm -f ' . $this->path_rules . $val_data);
					}

					if (is_file($this->path_act_rules . $val_data)) {
						$this->ssh('rm -f ' . $this->path_act_rules . $val_data);
					}
				}
			}
			else {
				$out = $this->ssh('ln -s ' . $this->path_act_rules . $rules . ' ' . $this->path_rules);
				$arr['code'] = 10;
				$arr['message'] = $lang['mod_security_delete_file_error'];
				return $arr;
			}
		}

		return $this->relode_webserver($server_back);
	}

	public function add_rules($command, $data, $files = NULL, $end_file = '', $server = '')
	{
		if (!$end_file) {
			$end_file = '.conf';
		}
		else {
			$end_file = '';
		}

		global $lang;
		if (($command == 'url') || ($command == 'text')) {
			if (!preg_match('/^[a-z_0-9\\-.]+$/i', $data['name_rules'])) {
				$arr['code'] = 105;
				$arr['message'] = $lang['mod_security_error_literal'];
				return $arr;

				if (!preg_match('/^[a-z_0-9\\-.]+$/i', $data)) {
					$arr['code'] = 105;
					$arr['message'] = $lang['mod_security_error_literal'];
					return $arr;
				}
			}
		}
		else {
			return $arr;
			$arr['code'] = 105;
			$arr['message'] = $lang['mod_security_error_literal'];
			return $arr;
		}

		$server_back = $this->status_webserver();
		if (($command == 'url') || ($command == 'text')) {
			$data_back = $data['server'];
		}
		else {
			$data_back = $server;
		}

		switch ($data_back) {
		case 'nginx':
			$path_webserver = $this->path_act_rules_nginx;
			break;
		}

		if (is_file($path_webserver . $data['name_rules'] . $end_file)) {
			$arr['code'] = -2;
			$arr['message'] = $lang['mod_security_fileexistnamedataorrule'];
			return $arr;
		}

		switch ($command) {
		case 'url':
			if (!empty($data['url_rules']) && !empty($data['name_rules'])) {
				$rules = file_get_contents($data['url_rules'], FILE_USE_INCLUDE_PATH);

				if (!empty($rules)) {
					$this->write_file($rules, $path_webserver . $data['name_rules'] . $end_file);
					$arr['code'] = 0;
					$arr['message'] = $lang['mod_security_succecfully_add_rules'];
					$arr['rules'] = $data['name_rules'] . $end_file;
				}
				else {
					$arr['code'] = 104;
					$arr['message'] = $lang['mod_security_not_rules_str'];
				}
			}
			else {
				$arr['code'] = 103;
				$arr['message'] = $lang['mod_security_not_name_url'];
			}

			return $arr;
		case 'text':
			if (!empty($data['name_rules']) && !empty($data['text_rules'])) {
				$this->write_file($data['text_rules'], $path_webserver . $data['name_rules'] . $end_file);
				$arr['code'] = 0;
				$arr['message'] = $lang['mod_security_succecfully_add_rules'];
				$arr['rules'] = $data['name_rules'] . $end_file;
			}
			else {
				$arr['code'] = 106;
				$arr['message'] = $lang['mod_security_not_entered_rules_name'];
			}

			return $arr;
		case 'file':
			foreach ($files as $file) {
				if ($file['error'] == 0) {
					if ($server_back == 'nginx') {
						$fileconf = $path_webserver . $data . $end_file;
					}
					else {
						$fileconf = $path_webserver . $data . $end_file;
					}

					if (move_uploaded_file($file['tmp_name'], $fileconf)) {
						$arr['code'] = 0;
						$arr['message'] = $lang['mod_security_succecfully_add_rules'];
						$arr['name_rules'] = $data . $end_file;
					}
				}
			}

			if (is_array($arr)) {
				return $arr;
			}

			$arr['code'] = 107;
			$arr['message'] = $lang['mod_security_error_save_file'];
			return $arr;
		}
	}

	public function status_webserver()
	{
		$out = $this->config_read('/etc/brainy/data/server_control/main');

		if ($out['front_server'] == 'nginx') {
			return 'all';
		}

		if ($out['back_server'] == 'nginx') {
			return 'nginx';
		}

		return 'apache';
	}

	public function check_webserver($server = '')
	{
		$server_back = $server;

		if ($server_back == 'nginx') {
			$str = implode('', $this->ssh('nginx -t 2> /dev/stdout'));
			$patern = '/syntax is ok/i';
		}
		else {
			$str = implode('', $this->ssh('httpd -t 2> /dev/stdout'));
			$patern = '/Syntax OK/i';
		}

		if (preg_match($patern, $str)) {
			return 1;
		}

		return 0;
	}

	public function status($server)
	{
		global $lang;

		switch ($server) {
		case 'nginx':
			$str = $this->ssh('nginx -V 2> /dev/stdout | grep -E -o "modsecurity"');

			if (preg_match('/modsecurity/i', trim(implode('', $str)))) {
				return 1;
			}

			return 0;
		case 'apache':
		case 'all':
			$str = $this->ssh('httpd -M &> /dev/stdout');

			foreach ($str as $key) {
				return 1;
			}

			$str = $this->ssh('rpm -qa | grep mod_security');

			if (0 < count($str)) {
				return 1;
			}

			$str = $this->ssh('dpkg --get-selections | grep security');

			if (0 < count($str)) {
				return 1;
			}

			return 0;
		}
	}

	public function get_include_rules($server = '')
	{
		$server_back = $this->status_webserver();

		switch ($server_back) {
		case 'nginx':
			$get_rules = $this->ssh('ls ' . $this->path_rules_nginx . '*.conf');
			return str_replace($this->path_rules_nginx, '', $get_rules);
		case 'all':
			switch ($server) {
			case 'nginx':
				$path_server = $this->path_rules_nginx;
				break;
			}

			break;
			$get_rules = $this->ssh('ls ' . $path_server . '*.conf');
			return str_replace($path_server, '', $get_rules);
		}

		$get_rules = ($this->status_webserver() . $this->path_rules . '*.conf');
		return str_replace($this->path_rules, '', $get_rules);
	}

	public function get_rules($server = '')
	{
		global $lang;

		if (!$this->check_value('string', $server)) {
			return false;
		}

		$server_back = $this->status_webserver();

		switch ($server_back) {
		case 'nginx':
			$out = $this->ssh('ls -t ' . $this->path_act_rules_nginx . '*.conf');

			foreach ($out as $key) {
				$mas_rules['rules'][] = str_replace($this->path_act_rules_nginx, '', $key);
			}

			$out = $this->ssh('ls -r ' . $this->path_act_rules_nginx . ' | grep -E -v \'\\.conf\'');

			foreach ($out as $key) {
				$mas_rules['data'][] = str_replace($this->path_act_rules_nginx, '', $key);
			}

			break;

		case 'all':
			switch ($server) {
			case 'nginx':
				$path_server = $this->path_act_rules_nginx;
				break;
			}

			break;
			$out = $this->ssh('ls -t ' . $path_server . '*.conf');

			foreach ($out as $key) {
				$mas_rules['rules'][] = str_replace($path_server, '', $key);
			}

			$out = $this->ssh('ls -r ' . $path_server . ' | grep -E -v \'\\.conf\'');

			foreach ($out as $key) {
				$mas_rules['data'][] = str_replace($path_server, '', $key);
			}

			break;
		}

		$out = ($GLOBALS['lang'] . $this->path_act_rules . '*.conf ');

		foreach ($out as $key) {
			$mas_rules['rules'][] = str_replace($this->path_act_rules, '', $key);
		}

		$out = $this->ssh('ls -r ' . $this->path_act_rules . ' | grep -E -v \'\\.conf\'');

		foreach ($out as $key) {
			$mas_rules['data'][] = str_replace($this->path_act_rules, '', $key);
		}

		if (is_array($mas_rules)) {
			$mas_rules['include_rules'] = $this->get_include_rules($server);
			return $mas_rules;
		}

		$arr['code'] = 100;
		$arr['message'] = $lang['mod_security_status_not_rules'];
		return $arr;
	}

	public function relode_webserver($server = '')
	{
		global $lang;

		switch ($server) {
		case 'nginx':
			$cons_out = $this->ssh('service nginx restart &> /dev/stdout');

			if (!preg_match('/(?=failed)+/i', implode('', $cons_out))) {
				$arr['code'] = 0;
				$arr['message'] = $lang['mod_security_incl_succecfully'];
				return $arr;
			}

			$arr['code'] = 102;
			$arr['message'] = $lang['mod_security_error_reboot_nginx'];
			return $arr;
		}

		$cons_out = (, $this->ssh('service httpd restart &> /dev/stdout'));
		if (preg_match('/[\\[ OK]\\]+$/i', $cons_out) || strlen($cons_out < 2)) {
			$arr['code'] = 0;
			$arr['message'] = $lang['mod_security_incl_succecfully'];
		}
		else {
			$arr['code'] = 102;
			$arr['message'] = $lang['mod_security_error_reboot_apache'];
		}

		return $arr;
	}

	public function incl_reincl_mod_security($rules, $command, $server = '')
	{
		global $lang;

		if (!$this->check_value('filename', $rules)) {
			return false;
		}

		$server_back = $server;
		$data_file = $this->get_data_files($rules, $server);

		switch ($command) {
		case 'include':
			$data_file_message = $data_file;

			if ($server_back == 'nginx') {
				$file_include = array_diff(scandir($this->path_rules_nginx), array('.', '..'));
				$out = $this->ssh('ln -s ' . $this->path_act_rules_nginx . $rules . ' ' . $this->path_rules_nginx);

				if (file($this->path_rules_nginx . $rules)) {
					if (!$file_include) {
						$this->ssh('echo "IncludeOptional /etc/nginx/modsecurity.d/activated_rules/*.conf">>/etc/nginx/modsecurity.conf');
					}
				}

				foreach ($data_file_message as $key_data => $val_data) {
					if (is_file($this->path_act_rules_nginx . $val_data)) {
						$this->ssh('ln -s ' . $this->path_act_rules_nginx . $val_data . ' ' . $this->path_rules_nginx);
						unset($data_file_message[$key_data]);
					}
				}
			}
			else {
				$out = $this->ssh('ln -s ' . $this->path_act_rules . $rules . ' ' . $this->path_rules);

				foreach ($data_file_message as $key_data => $val_data) {
					if (is_file($this->path_act_rules . $val_data)) {
						$this->ssh('ln -s ' . $this->path_act_rules . $val_data . ' ' . $this->path_rules);
						unset($data_file_message[$key_data]);
					}
				}
			}

			$status = $this->check_webserver($server_back);

			if ($status) {
				if (empty($out)) {
					return $this->relode_webserver($server_back);
				}

				$arr['code'] = 101;
				$arr['message'] = $lang['mod_security_incl_not_succecfully'];
				return $arr;
			}

			if ($server_back == 'nginx') {
				$this->ssh('rm -f ' . $this->path_rules_nginx . $rules);
				$file_include = array_diff(scandir($this->path_rules_nginx), array('.', '..'));

				foreach ($data_file as $key_data => $val_data) {
					if (is_file($this->path_rules_nginx . $val_data)) {
						$this->ssh('rm -f ' . $this->path_rules_nginx . $val_data);
					}
				}

				if (!$file_include) {
					$this->del_string('IncludeOptional', '/etc/nginx/modsecurity.conf');
				}
				if ($data_file_message) {
					$arr['message'] = $lang['mod_security_not_data_file'] . '<br>' . implode('<br>', $data_file_message);
				}
			}
			else {
				$this->ssh('rm -f ' . $this->path_rules . $rules);

				foreach ($data_file as $key_data => $val_data) {
					if (is_file($this->path_rules . $val_data)) {
						$this->ssh('rm -f ' . $this->path_rules . $val_data);
					}
				}

				if ($data_file_message) {
					$arr['message'] = $lang['mod_security_not_data_file'] . '<br>' . implode('<br>', $data_file_message);
				}
			}

			$arr['code'] = 102;

			if (!$arr['message']) {
				$arr['message'] = $lang['mod_security_error_rules'];
			}

			return $arr;
		case 'reinclude':
			if ($server_back == 'nginx') {
				$this->ssh('rm -f ' . $this->path_rules_nginx . $rules);

				foreach ($data_file as $key_data => $val_data) {
					if (is_file($this->path_rules_nginx . $val_data)) {
						$this->ssh('rm -f ' . $this->path_rules_nginx . $val_data);
					}
				}

				$file_include = array_diff(scandir($this->path_rules_nginx), array('.', '..'));

				if (!$file_include) {
					$this->del_string('IncludeOptional', '/etc/nginx/modsecurity.conf');
				}
			}
			else {
				$this->ssh('rm -f ' . $this->path_rules . $rules);

				foreach ($data_file as $key_data => $val_data) {
					if (is_file($this->path_rules . $val_data)) {
						$this->ssh('rm -f ' . $this->path_rules . $val_data);
					}
				}
			}

			$this->relode_webserver($server_back);
			$arr['code'] = 0;
			$arr['message'] = $lang['mod_security_reinclude_succecfully'];
			return $arr;
		}
	}

	public function default_modsec_stat_webserv_set($server, $stat = 0)
	{
		switch ($server) {
		case 'nginx':
			$arr_update = array('defaultvirthost_mod_nginx' => intval($stat));
			$this->config_save('/etc/brainy/data/mod_security/modsec.conf', $arr_update, 'add');
			break;

		case 'apache':
			$arr_update = array('defaultvirthost_mod_apache' => intval($stat));
			$this->config_save('/etc/brainy/data/mod_security/modsec.conf', $arr_update, 'add');
			break;

		case 'all':
			$arr_update = array('defaultvirthost_mod_nginx' => intval($stat));
			$this->config_save('/etc/brainy/data/mod_security/modsec.conf', $arr_update, 'add');
			break;
		}

		$arr['code'] = 0;
		$arr['message'] = $lang['mod_security_conf_active_modsec_onvirtcreate_setok'];
		return $arr;
	}

	public function default_modsec_stat_webserv_get($server)
	{
		$conf = $this->config_read('/etc/brainy/data/mod_security/modsec.conf');

		switch ($server) {
		case 'nginx':
			return $conf['defaultvirthost_mod_nginx'];
		case 'apache':
			return $conf['defaultvirthost_mod_apache'];
		case 'all':
			return $conf['defaultvirthost_mod_nginx'];
		}
	}

	public function modsec_allvirt_stat_set($stat)
	{
		$dh = opendir($GLOBALS['DATA_VHOSTS']);

		while (false !== $filename = readdir($dh)) {
			if (($filename[0] == '.') || ($filename == '!!default.conf')) {
				continue;
			}

			$domains[] = substr($filename, 0, strrpos($filename, '.'));

			if ($stat == 1) {
				$arr_set = array('modsec_stat' => 1);
			}
			else {
				$arr_set = array('modsec_stat' => 0);
			}

			$this->config_save($GLOBALS['DATA_VHOSTS'] . '/' . $filename, $arr_set, 'add');
		}

		$webserver = new webserver();
		$webserver->rebuild_virt_host();
		global $lang;
		$arr['code'] = 0;

		if ($stat == 0) {
			$arr['message'] = $lang['mod_security_btn_modsecvirthostall_userconfirm_ok_off'];
		}
		else {
			$arr['message'] = $lang['mod_security_btn_modsecvirthostall_userconfirm_ok_on'];
		}

		return $arr;
	}
}


?>
