<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class monitor
{
	const PATH_TO_SCRIPT = '/etc/brainy/ssh/monitor/';
	const PATH_TO_DATA = '/etc/brainy/data/monitor/';

	public $dataConf = '/etc/brainy/data/monitor/data.cnf';

	public function monitor_get_topinfostrip()
	{
		global $server;

		if (is_file($this::PATH_TO_DATA . 'xdata_' . $server->user['name'])) {
			$file = file_get_contents($this::PATH_TO_DATA . 'xdata_' . $server->user['name']);
		}
		else {
			$file = file_get_contents($this::PATH_TO_DATA . 'xdata_root');
		}

		return $file;
	}

	public function monitor_save_topinfostrip($conf)
	{
		global $server;
		$decode = json_decode($conf, 1);

		foreach ($decode as $key => $val) {
			foreach ($val as $key1 => $val1) {
				if (!$this->check_value('stringservice', $key1)) {
					return false;
				}

				return false;
			}

			if ($key == 'act') {
				return false;
			}

			return false;
		}

		file_put_contents($this::PATH_TO_DATA . 'xdata_' . $server->user['name'], json_encode($decode['param']));
		return 1;
	}

	public function monitor_array_get_status($arr)
	{
		global $server;
		global $lang;

		foreach ($arr as $key => $value) {
			if (($value[4] == 0) || ($server->user['group_properties']['root'] == 'y') || ($server->user['group_properties']['users_management'] == 'y')) {
				$name_service = $value[1];
				$name_service_short = $value[0];
				$result[$value[0]]['name'] = $this->getnameservice_full($name_service);
				$result[$value[0]]['name_short'] = $this->getnameservice_full($name_service_short);
				$result[$value[0]]['status'] = $this->monitor_get_service_status($value[2]);
			}
		}

		return $result;
	}

	public function monitor_array_get_status_n($arr)
	{
		global $server;
		global $lang;

		foreach ($arr as $key => $value) {
			if (($value[4] == 0) || ($server->user['group_properties']['root'] == 'y') || ($server->user['group_properties']['users_management'] == 'y')) {
				$name_service = $value[1];
				$name_service_short = $value[0];
				$result[$value[0]]['name'] = $this->getnameservice_full($name_service);
				$result[$value[0]]['name_short'] = $this->getnameservice_full($name_service_short);
			}
		}

		return $result;
	}

	public function monitor_array_to_Smarty($arr, $user = 0)
	{
		global $lang;
		$topinfostrip = json_decode($this->monitor_get_topinfostrip(), 1);
		global $server;

		foreach ($arr as $key => $value) {
			if (($value[4] == 0) || ($server->user['group_properties']['root'] == 'y') || ($server->user['group_properties']['users_management'] == 'y') || ($user == 0)) {
				$result[] = $value[0];
				$name_service = $value[1];
				$result[] = $this->getnameservice_full($name_service);
				$result[] = $this->monitor_get_service_status($value[2]);

				if ($user == 0) {
					$result[] = $this->monitor_return_checkbox($value[3], 'is_restart');
					$result[] = $this->monitor_return_checkbox($value[4], 'is_admin');
					$result[] = $this->monitor_return_checkbox($value[5], 'is_monitor');
					$result[] = $this->monitor_return_checkbox($topinfostrip[$value[0]], $value[0] . ' is_showtopinfo');
				}
			}
		}

		return $result;
	}

	public function monitor_array_to_Smarty_for_user($arr)
	{
		$result = $this->monitor_array_to_Smarty($arr, 1);
		return $result;
	}

	public function getnameservice_full($service_param)
	{
		global $lang;
		if ((strpos($service_param, 'webserver') !== false) || (strpos($service_param, 'httpd') !== false)) {
			$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);

			if ($conf['back_server'] == 'apache2.2') {
				$webserver = 'Apache 2.2';
			}

			if ($conf['back_server'] == 'apache2.4') {
				$webserver = 'Apache 2.4';
			}

			$service_param = str_replace('webserver', $webserver, $service_param);
			$service_param = str_replace('httpd', $webserver, $service_param);
		}

		if (0 < strpos($service_param, 'dbservice')) {
			$arr_mysql = $this->config_read('/etc/brainy/data/mysql/main');
			$service_param = str_replace('dbservice', $arr_mysql['mysql_install'], $service_param);
		}

		if (stripos($service_param, 'lang.') !== false) {
			$version_service = explode('_', $service_param)[1];
			$service_param_lang = str_replace('lang.', '', $service_param);

			if (1 < strlen($version_service)) {
				$service_param_lang = substr($service_param_lang, 0, strpos($service_param_lang, '_'));
			}

			$res = $lang['monitor_service_name_' . $service_param_lang] . ' ' . $version_service;
		}
		else {
			$res = $service_param;
		}

		return $res;
	}

	public function monitor_disc_array_to_Smarty_topinfo($arr)
	{
		global $lang;
		$settings = $this->monitor_get_settings_new();

		foreach ($arr as $key => $value) {
			$result[$value[5]]['fs'] = $value[0];
			$result[$value[5]]['size'] = $value[1];
			$result[$value[5]]['busy'] = $value[2];
			$result[$value[5]]['free'] = $value[3];
			$result[$value[5]]['busyper'] = $value[4];
			$result[$value[5]]['pointmount'] = $value[5];
			$available = 100 - $value[4];
			$result[$value[5]]['freeper'] = $available . '%';

			if (empty($settings['settings_disk'])) {
				$settings['settings_disk'] = 0;
			}

			if ($available < $settings['settings_disk']) {
				$result[$value[5]]['param'] = '0';
			}
			else {
				$result[$value[5]]['param'] = '1';
			}
		}

		return $result;
	}

	public function monitor_show_service()
	{
		$result = $this->monitor_get_service();
		$result = $this->monitor_file_to_array($result);
		$result = $this->monitor_array_to_Smarty($result);
		return $result;
	}

	public function monitor_show_service_for_user()
	{
		$result = $this->monitor_get_service();
		$result = $this->monitor_file_to_array($result);
		$result = $this->monitor_array_to_Smarty_for_user($result);
		return $result;
	}

	public function monitor_show_disc()
	{
		$result = $this->monitor_get_disc();
		$result = $this->monitor_disc_array_to_Smarty($result);
		return $result;
	}

	public function monitor_show_la()
	{
		return $this->sudo_ssh('uptime')[0];
	}

	public function monitor_get_service()
	{
		$file = file_get_contents($this::PATH_TO_DATA . 'data_s');
		return $file;
	}

	public function monitor_get_disc()
	{
		$result = $this->sudo_ssh('/bin/df -h -P | sort -k 6');

		foreach ($result as $key) {
			if (stripos($key, 'Filesystem') === false) {
				$key = preg_replace('!\\s+!', ' ', $key);
				$res[] = explode(CHR(32), $key);
			}
		}

		return $res;
	}

	public function monitor_disc_array_to_Smarty($arr)
	{
		global $lang;
		$settings = $this->monitor_get_settings_new();

		foreach ($arr as $key => $value) {
			$result[] = $value[0];
			$result[] = $value[1];
			$result[] = $value[2];
			$result[] = $value[3];
			$result[] = $value[4];
			$result[] = $value[5];
			$available = 100 - $value[4];
			$result[] = $available . '%';

			if ($available < $settings['settings_disk']) {
				$result[] = '0';
			}
			else {
				$result[] = '1';
			}
		}

		return $result;
	}

	public function check_service_installed($service)
	{
		if ($service == 'clamav') {
			$service = 'clamd';
		}

		if ($service == 'cron') {
			$service = 'crond';
		}

		if ($service == 'mysql') {
			$service = 'mysqld';
		}

		if ($service == 'clamdscan') {
			$service = 'clamd@scan';
		}

		$serv = new server();
		return $serv->check_service_installed($service);
	}

	public function monitor_file_to_array($file)
	{
		$lines = explode("\n", $file);
		array_pop($lines);

		foreach ($lines as $key) {
			$temp = explode('=', $key);

			if ($this->check_service_installed($temp[0]) == 1) {
				$result[] = $temp;
			}
		}

		return $result;
	}

	public function monitor_file_to_array2($file)
	{
		$lines = explode("\n", $file);
		array_pop($lines);

		foreach ($lines as $key) {
			$temp = explode('=', $key);

			if ($this->check_service_installed($temp[0]) == 1) {
				$result[$temp[0]][0] = $temp[1];
				$result[$temp[0]][1] = $temp[2];
			}
		}

		return $result;
	}

	public function monitor_return_checkbox($status, $name)
	{
		if ($status == 1) {
			$option = ' checked ';
		}
		else {
			$option = '';
		}

		return '<input type=\'checkbox\' class=\'' . $name . '\' ' . $option . '>';
	}

	public function monitor_save_service_settings($text)
	{
		global $lang;

		if (!$this->check_value('text', $text)) {
			return false;
		}

		$file = $this::PATH_TO_DATA . 'data_s';
		$new_rows = preg_split('/\\r\\n|\\r|\\n/', $text);
		$old_rows = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($file));

		foreach ($old_rows as $key_o => $row_old) {
			$exp_oldrow_param = explode('=', $row_old);

			foreach ($new_rows as $key_n => $row_new) {
				$exp_newrow_param = explode('=', $row_new);

				if ($exp_newrow_param[0] == $exp_oldrow_param[0]) {
					foreach ($exp_oldrow_param as $key_num => $paramcur) {
						if (2 < $key_num) {
							$exp_oldrow_param[$key_num] = $exp_newrow_param[$key_num];
						}
					}

					$old_rows[$key_o] = implode('=', $exp_oldrow_param);
				}
			}
		}

		file_put_contents($file, '');

		foreach ($old_rows as $key_o => $row_old_update) {
			if (2 < strlen($row_old_update)) {
				file_put_contents($file, $row_old_update . "\n", FILE_APPEND);
			}
		}

		return $lang['monitor_file_saved'] . $file;
	}

	public function monitor_save_settings($arr)
	{
		global $lang;
		$qcreatemonxml = 0;

		foreach ($arr as $key => $val) {
			if ($key == 'act') {
				if (!$this->check_value('stringservice', $val)) {
					return false;

					foreach ($val as $key1 => $val1) {
						if (!$this->check_value('stringservice', $key1)) {
							return $lang['monitor_not_preg_match'];
						}

						if ($key1 == 'emails_notify') {
							$mailsTest = preg_split('/[\\s,;]/', $val1);

							foreach ($mailsTest as $curEmail) {
								return $lang['monitor_not_preg_match'];
							}
						}
						else if ($key1 == 'monitor_ip_monitor') {
							if (!preg_match('/^[0-9\\.]*$/imsu', preg_replace('/((\\r)|(\\n)|(\\n\\r)|(\\r\\n)|(\\t))/', '', $val1))) {
								return $lang['monitor_not_preg_match'];

								if (!$this->check_value('stringservice', $val1)) {
									return $lang['monitor_not_preg_match'];
								}
							}
						}
						else {
							return $lang['monitor_not_preg_match'];

							return $lang['monitor_not_preg_match'];
						}

						if ($key1 == 'monitor_enableded_xml') {
							if ($val1 == 1) {
								$qcreatemonxml = 1;
								$this->create_xml();
							}
							else if (is_file('/etc/brainy/data/monitor/monitor.xml')) {
								$this->ssh('rm -f /etc/brainy/data/monitor/monitor.xml');
							}
						}

						if ($key1 == 'all_connection_port') {
							$portarr = explode(',', $val1);
							$portarr = array_unique($portarr);
							$arr['settings'][$key1] = implode(',', $portarr);
						}

						if ($key1 == 'show_time_local_ip') {
							$data['time'] = $val1;
							$blacklist = new blacklist();
							$out = $blacklist->monitor($data);

							if (0 < $out['code']) {
								return $out['message'];
							}

							if ($data['time']) {
								$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/blacklist.php';
								$this->create_stream($stream);
							}
						}
					}
				}
			}
			else {
				return false;

				return $lang['monitor_not_preg_match'];
				$mailsTest = preg_split('/[\\s,;]/', $val1);

				return $lang['monitor_not_preg_match'];

				return $lang['monitor_not_preg_match'];

				return $lang['monitor_not_preg_match'];
				$qcreatemonxml = 1;
				$this->create_xml();
				$this->ssh('rm -f /etc/brainy/data/monitor/monitor.xml');
				$portarr = explode(',', $val1);
				$portarr = array_unique($portarr);
				$arr['settings'][$key1] = implode(',', $portarr);
				$data['time'] = $val1;
				$blacklist = new blacklist();
				$out = $blacklist->monitor($data);

				return $out['message'];
				$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/blacklist.php';
				$this->create_stream($stream);
			}

			return false;
		}

		$this->set_data($arr, 'config.cnf');

		if ($arr['settings']['settings_autocheck'] == 1) {
			$this->monitor_delete_auto_scan();
			$this->monitor_add_auto_scan($arr['settings']['settings_min']);
		}
		else {
			$this->monitor_delete_auto_scan();
		}

		if ($qcreatemonxml == 1) {
			$this->create_xml();
		}

		return $lang['monitor_setting_saved'];
	}

	public function monitor_get_settings_new()
	{
		$res = parse_ini_file('/etc/brainy/data/monitor/config.cnf');
		return $res;
	}

	public function monitor_get_settings()
	{
		$this->load_vars('config.cnf');
		return $this->module_vars;
	}

	public function monitor_load_service_info()
	{
		$file = file_get_contents($this::PATH_TO_DATA . 'data_m');
		return $file;
	}

	public function monitor_save_service_info($arr)
	{
		$file = $this::PATH_TO_DATA . 'data_m';
		$result = '';

		foreach ($arr as $key => $value) {
			$result .= $key . '=' . $value[0] . '=' . $value[1] . "\n";
		}

		$new_rows = preg_split('/\\r\\n|\\r|\\n/', $result);
		$old_rows = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($file));

		foreach ($old_rows as $key_o => $row_old) {
			$exp_oldrow_param = explode('=', $row_old);

			foreach ($new_rows as $key_n => $row_new) {
				$exp_newrow_param = explode('=', $row_new);

				if ($exp_newrow_param[0] == $exp_oldrow_param[0]) {
					foreach ($exp_oldrow_param as $key_num => $paramcur) {
						if (0 < $key_num) {
							$exp_oldrow_param[$key_num] = $exp_newrow_param[$key_num];
						}
					}

					$old_rows[$key_o] = implode('=', $exp_oldrow_param);
				}
			}
		}

		file_put_contents($file, '');

		foreach ($old_rows as $key_o => $row_old_update) {
			if (2 < strlen($row_old_update)) {
				file_put_contents($file, $row_old_update . "\n", FILE_APPEND);
			}
		}
	}

	public function monitor_test_service()
	{
		$file123 = '/etc/brainy/data/monitor/qqqqqqqq';
		$service = $this->monitor_file_to_array($this->monitor_get_service());
		$service_info = $this->monitor_file_to_array2($this->monitor_load_service_info());
		$settings = $this->monitor_get_settings_new();
		$this->lan_include('ru');
		$lang = $this->lang;
		$mails = preg_split('/[\\s,;]/', $settings['emails_notify']);
		$subject = '';
		$text = '';

		foreach ($service as $key => $value) {
			if (!is_array($service_info[$value[0]])) {
				$service_info[$value[0]][0] = 0;
			}

			if ($this->monitor_get_service_status($value[2]) == 'off') {
				++$service_info[$value[0]][0];
			}
			else {
				$service_info[$value[0]][0] = 0;
				$service_info[$value[0]][1] = 0;
			}

			if (intval($settings['settings_error_restart']) <= $service_info[$value[0]][0]) {
				if ($value[3] == 1) {
					$this->monitor_restart_service($value[0]);
					$service = $value[0];
					$service = $this->getnameservice_full($service);

					if (($value[5] == 1) && ($service_info[$value[0]][1] == 0)) {
						if ($this->monitor_get_service_status($value[2]) == 'off') {
							if (strlen($subject) < 2) {
								$subject = $lang['monitor_server'] . ' ' . gethostbyname(gethostname()) . '. ';
							}

							$countdown = $lang['monitor_service_try_restart_failed'];
							$countdown = str_replace('countdown', $service_info[$value[0]][0], $countdown);
							$text .= $lang['service'] . ' ' . $service . ' ' . $countdown . "\n";
							$subject .= $lang['service'] . ' ' . $service . ' ' . $lang['not_available'] . '. ' . $lang['monitor_service_try_restart_failed_short'] . "\n";
							$service_info[$value[0]][1] = 1;
						}
						else {
							if (strlen($subject) < 2) {
								$subject = $lang['monitor_server'] . ' ' . gethostbyname(gethostname()) . '. ';
							}

							$countdown = $lang['monitor_service_try_restart_ok'];
							$countdown = str_replace('countdown', $service_info[$value[0]][0], $countdown);
							$text .= $lang['service'] . ' ' . $service . ' ' . $countdown . "\n";
							$subject .= $lang['service'] . ' ' . $service . ' ' . $lang['was_not_available'] . '. ' . $lang['monitor_service_try_restart_ok_short'] . "\n";
							$service_info[$value[0]][0] = 0;
							$service_info[$value[0]][1] = 0;
						}
					}

					if (($value[5] == 1) && ($service_info[$value[0]][1] == 1)) {
						if ($this->monitor_get_service_status($value[2]) == 'on') {
							if (strlen($subject) < 2) {
								$subject = $lang['monitor_server'] . ' ' . gethostbyname(gethostname()) . '. ';
							}

							$countdown = $lang['monitor_service_try_restart_ok'];
							$countdown = str_replace('countdown', $service_info[$value[0]][0], $countdown);
							$text .= $lang['service'] . ' ' . $service . ' ' . $countdown . "\n";
							$subject .= $lang['service'] . ' ' . $service . ' ' . $lang['was_not_available'] . '. ' . $lang['monitor_service_try_restart_ok_short'] . "\n";
							$service_info[$value[0]][0] = 0;
							$service_info[$value[0]][1] = 0;
						}
					}
				}
			}
		}

		$mailObj = new mail();

		if (0 < strlen($subject)) {
			foreach ($mails as $mail_notify) {
				$res = $mailObj->sendmail($mail_notify, 'You', $subject, $text);
			}
		}

		$this->monitor_save_service_info($service_info);
	}

	public function monitor_restart_service($service)
	{
		if ($service == 'clamav') {
			$service = 'clamd';
		}

		if ($service == 'httpd') {
			$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);

			if ($conf['back_server'] == 'apache2.2') {
				$apache_comm = 'httpd';
			}

			if ($conf['back_server'] == 'apache2.4') {
				$apache_comm = 'httpd';
			}

			$service = $apache_comm;
		}

		if ($service == 'mysql') {
			$service = 'mysqld';
		}

		if ($service == 'clamdscan') {
			$service = 'clamd@scan';
		}

		if ($service == 'cron') {
			$service = 'crond';
		}

		$this->monitor_comm_os($service, 'restart');
		sleep(5);
		$file123 = '/etc/brainy/data/monitor/qqqqqqqq';
	}

	public function monitor_send_email($service, $count)
	{
		$this->lan_include('ru');
		$lang = $this->lang;
		$settings = $this->monitor_get_settings_new();
		$mails = preg_split('/[\\s,;]/', $settings['emails_notify']);
		$subject = $lang['service'] . ' ' . $service . ' ' . $lang['not_available'];
		$text = $lang['service'] . ' ' . $service . ' ' . $lang['not_available'] . ' ' . $lang['after'] . ' ' . $count . ' ' . $lang['attemp_check'];
		$mailObj = new mail();

		foreach ($mails as $mail_notify) {
			$mailObj->sendmail($mail_notify, 'You', $subject, $text);
		}
	}

	public function monitor_send_email_disk($filesystem, $mount, $available)
	{
		$getConf = json_decode(file_get_contents($this->dataConf), 1);
		$lastrun = time() - 9999999;
		$deltaRemind = 3600;

		if (isset($getConf['lastemailDisk'])) {
			$lastrun = intval($getConf['lastemailDisk']);
		}

		if (isset($getConf['deltaRemind'])) {
			$deltaRemind = intval($getConf['deltaRemind']);
		}

		$now = time();

		if ($deltaRemind < ($now - $lastrun)) {
			$settings = $this->monitor_get_settings_new();
			$mails = preg_split('/[\\s,;]/', $settings['emails_notify']);
			$this->lan_include('ru');
			$lang = $this->lang;
			$subject = $lang['disk'] . ' ' . $mount . ' ' . $lang['overlimit'];
			$text = $lang['last_available'] . ' ' . $available . '% ' . $lang['in_file_system'] . ' ' . $filesystem . '. ' . $lang['mount'] . ' ' . $mount;
			$mailObj = new mail();

			foreach ($mails as $mail_notify) {
				$mailObj->sendmail($mail_notify, 'You', $subject, $text);
			}

			$getConf['lastemailDisk'] = time();
			file_put_contents($this->dataConf, json_encode($getConf), LOCK_EX);
		}
	}

	public function create_xml()
	{
		error_reporting(0);
		include_once '/etc/brainy/classes/network_tools.php';
		$network_tools = new network_tools();
		$load_average = $this->monitor_show_la();
		$disc_l = $this->monitor_get_disc();
		$setting = $this->monitor_get_settings_new();
		$result = $this->monitor_get_service();
		$result_service = $this->monitor_file_to_array($result);
		$result_stat = $this->monitor_array_to_Smarty($result_service);

		foreach ($disc_l as $key => $val) {
			foreach ($val as $key1 => $val1) {
				if ($key1 == 4) {
					$disc_l[$key][] = (100 - $val1) . '%';

					if ((100 - $val1) < $setting['settings_disk']) {
						$lim = '0';
					}
					else {
						$lim = '1';
					}

					$disc_l[$key][] = $lim;
				}
			}
		}

		if ($setting['settings_netconncalc'] == 1) {
			$all_connection = $network_tools->net_connections_n(1);
			$all_connection_syn = $network_tools->net_syncrec_n(0, 1);
			$arr_port = explode(',', $setting['all_connection_port']);
			$all_connect = 0;

			foreach ($arr_port as $key) {
				$all_connect += $network_tools->net_portconn_n($key, 1);
			}
		}
		else {
			$all_connection = 0;
			$all_connection_syn = 0;
			$arr_port = 0;
			$all_connect = 0;
		}

		$arr['load_average']['status'] = $load_average;
		$arr['all_connection']['status'] = $all_connection;
		$arr['all_connection_syn']['status'] = $all_connection_syn;
		$new_xml = '<?xml version="1.0"?>' . PHP_EOL;
		$new_xml .= '<document>' . PHP_EOL;

		foreach ($result_service as $serv) {
			$new_xml .= "\t" . '<' . $serv[0] . '>' . PHP_EOL;

			foreach ($result_stat as $stat => $stv) {
				if ($stv == $serv[0]) {
					$status = $result_stat[$stat + 2];
				}
			}

			if ($status) {
				$new_xml .= "\t\t" . '<status>' . $status . '</status>' . PHP_EOL;
			}
			else {
				$new_xml .= "\t\t" . '<status>off</status>' . PHP_EOL;
			}

			$status = NULL;
			$new_xml .= "\t" . '</' . $serv[0] . '>' . PHP_EOL;
		}

		foreach ($arr as $key => $val) {
			$new_xml .= "\t" . '<' . $key . '>' . PHP_EOL;

			foreach ($val as $key1 => $val1) {
				if (!is_array($val1)) {
					$new_xml .= "\t\t" . $val1 . PHP_EOL;
				}
			}

			$new_xml .= "\t" . '</' . $key . '>' . PHP_EOL;
		}

		$new_xml .= "\t" . '<port_connections>' . PHP_EOL;

		foreach ($arr_port as $port) {
			$new_xml .= "\t\t" . '<port_' . $port . '>';
			$new_xml .= $network_tools->net_portconn_n($port);
			$new_xml .= '</port_' . $port . '>' . PHP_EOL;
		}

		$new_xml .= "\t" . '</port_connections>' . PHP_EOL;
		$disc_firts_el = true;

		foreach ($disc_l as $key5 => $val5) {
			$new_xml .= "\t" . '<disk>' . PHP_EOL;
			$new_xml .= "\t\t" . '<name>' . $val5[0] . '</name>' . PHP_EOL;
			$new_xml .= "\t\t" . '<space>' . $val5[1] . '</space>' . PHP_EOL;
			$new_xml .= "\t\t" . '<free>' . $val5[2] . '</free>' . PHP_EOL;
			$new_xml .= "\t\t" . '<total>' . $val5[3] . '</total>' . PHP_EOL;
			$new_xml .= "\t\t" . '<engaged>' . $val5[4] . '</engaged>' . PHP_EOL;
			$new_xml .= "\t\t" . '<mount>' . $val5[5] . '</mount>' . PHP_EOL;
			$new_xml .= "\t\t" . '<available>' . $val5[6] . '</available>' . PHP_EOL;
			$new_xml .= "\t\t" . '<available_true>' . $val5[7] . '</available_true>' . PHP_EOL;
			$new_xml .= "\t" . '</disk>' . PHP_EOL;
		}

		$check_black = 0;
		$data_blacklist = $this->read_file_n('/etc/brainy/data/blacklist/scan');
		$data_black = '';

		foreach ($data_blacklist as $key_black => $val_black) {
			$val_data = explode('|', trim($val_black));

			if ($val_data[1]) {
				$data_black .= $val_data[0] . '-' . $val_data[1] . ';';
				$check_black = 1;
			}
		}

		$new_xml .= "\t" . '<blacklist>' . PHP_EOL;

		if ($check_black) {
			$new_xml .= "\t\t" . '<blacklist-server>' . $data_black . '</blacklist-server>' . PHP_EOL;
		}

		$new_xml .= "\t\t" . '<blacklist-check>' . $check_black . '</blacklist-check>' . PHP_EOL;
		$new_xml .= "\t" . '</blacklist>' . PHP_EOL;
		$new_xml .= '</document>' . PHP_EOL;
		file_put_contents('/etc/brainy/data/monitor/monitor.xml', $new_xml);
	}

	public function monitor_test_disk()
	{
		$disk = $this->monitor_get_disc();
		$settings = $this->monitor_get_settings_new();

		foreach ($disk as $key => $value) {
			if ((100 - $value[4]) < $settings['settings_disk']) {
				$this->monitor_send_email_disk($value[0], $value[5], 100 - $value[4]);
			}
		}
	}

	public function monitor_add_auto_scan($time)
	{
		$cron = new crontab();
		$array = $cron->get_minutes_hour_for_day($time);

		if (!isset($array['minutes'])) {
			return $array;
		}

		$cron->edit_config_script_cron('/etc/brainy/src/compiled/php5/bin/php -q /etc/brainy/ssh/monitor/scaner.php > /dev/null 2> /dev/null', $array['minutes'], $array['hour']);
	}

	public function monitor_delete_auto_scan()
	{
		$this->del_string_new('scaner.php', '/etc/brainy/conf/cron_exec_config');
		$this->del_string_new('scaner.php', '/etc/brainy/data/crontab/next_exec');
	}
}


?>
