<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class network_tools
{
	public $ip_tables_rules = array();
	public $conf_patch = '/etc/sysconfig/iptables';
	public $array_port = array(21, 22, 25, 53, 80, 110, 143, 443, 3306);
	public $array_port_syn = array(0 => 'Все', 21 => 21, 22 => 22, 25 => 25, 53 => 53, 80 => 80, 110 => 110, 143 => 143, 443 => 443, 3306 => 3306);
	public $net_port_n_correct = 0;
	public $list_block_port_candidate = array();

	public function __construct()
	{
		global $lang;
		$array_port_syn[0] = $lang['networktools_allports'];
	}

	public function net_connections()
	{
		$ip_server = trim(implode('', $this->ssh('hostname -i')));
		$out = $this->sudo_ssh('netstat -ntu | grep -E \'[0-9]+\' |awk \'{print $5}\' | grep -v \'127.0.0.1\' | grep -v \'' . $ip_server . '\' | grep -v \'::1\' | cut -d: -f1 | sort | uniq -c | sort -n');
		$n = count($out);
		$i = 0;

		while ($i < $n) {
			$out[$i] = trim($out[$i]);
			if (strstr($out[$i], 'Address') || strstr($out[$i], 'servers') || (substr_count($out[$i], '.') < 3)) {
				unset($out[$i]);
			}
			else {
				$out[$i] = explode(' ', $out[$i]);
			}

			++$i;
		}

		$out = array_values($out);
		return $out;
	}

	public function net_connections_n($cache = 0)
	{
		$file_cache = '/etc/brainy/data/network_tools/cachedata';
		$timecache = 150;
		$ip_server = trim(implode('', $this->ssh('hostname -i')));
		if (($cache == 0) || !is_file($file_cache)) {
			$out = $this->sudo_ssh('netstat -ntu | grep -E \'[0-9]+\' | awk \'{print $5}\' | grep -v \'127.0.0.1\' | grep -v \'' . $ip_server . '\' | grep -v \'::1\' | cut -d: -f1 | wc -l');
			file_put_contents($file_cache, serialize($out[0]));
			return $out[0];
		}

		if (is_file($file_cache)) {
			$timefile = filemtime($file_cache);

			if ((time() - $timefile) < $timecache) {
				$res = unserialize(file_get_contents($file_cache));
				return $res;
			}

			$out = $this->sudo_ssh('netstat -ntu | grep -E \'[0-9]+\' | awk \'{print $5}\'| grep -v \'127.0.0.1\' | grep -v \'' . $ip_server . '\' | grep -v \'::1\' | cut -d: -f1 | wc -l');
			file_put_contents($file_cache, serialize($out[0]));
			return $out[0];
		}
	}

	public function net_syncrec_connections($port = '0')
	{
		$port = intval($port);

		if ($port == 0) {
			$out = $this->sudo_ssh('netstat -na | grep SYN_REC | awk \'{print $5 " " $6 " " $7}\' |cut -d: -f1 | sort | uniq -c | sort -n');
		}
		else {
			$out = $this->sudo_ssh('netstat -na | grep :\'' . $port . ' \' | grep SYN_REC | awk \'{print $5 " " $6 " " $7}\' |cut -d: -f1 | sort | uniq -c | sort -n');
		}

		$n = count($out);
		$i = 0;

		while ($i < $n) {
			$out[$i] = trim($out[$i]);
			if (strstr($out[$i], 'Address') || strstr($out[$i], 'servers') || (substr_count($out[$i], '.') < 3)) {
				unset($out[$i]);
			}
			else {
				$out[$i] = explode(' ', $out[$i]);
			}

			++$i;
		}

		return $out;
	}

	public function net_syncrec_n($port = '0', $cache = 0)
	{
		$file_cache = '/etc/brainy/data/network_tools/cachedata_net_syncrec_n';
		$port = intval($port);
		$timecache = 150;
		if (($cache == 0) || !is_file($file_cache)) {
			if ($port == 0) {
				$out = implode('', $this->sudo_ssh('netstat -n -p | grep SYN_REC | wc -l '));
			}
			else {
				$out = implode('', $this->sudo_ssh('netstat -n -p | grep :\'' . $port . ' \' | grep SYN_REC | wc -l '));
			}

			file_put_contents($file_cache, serialize($out));
			return $out;
		}

		if (is_file($file_cache)) {
			$timefile = filemtime($file_cache);

			if ((time() - $timefile) < $timecache) {
				$res = unserialize(file_get_contents($file_cache));
				return $res;
			}

			if ($port == 0) {
				$out = implode('', $this->sudo_ssh('netstat -n -p | grep SYN_REC | wc -l '));
			}
			else {
				$out = implode('', $this->sudo_ssh('netstat -n -p | grep :\'' . $port . ' \' | grep SYN_REC | wc -l '));
			}

			file_put_contents($file_cache, serialize($out));
			return $out;
		}
	}

	public function net_portconn_n($port = '80', $cache = 0)
	{
		$file_cache = '/etc/brainy/data/network_tools/cachedata_net_portconn_n';
		$port = intval($port);
		$timecache = 150;
		if (($cache == 0) || !is_file($file_cache)) {
			$out = implode('', $this->sudo_ssh('netstat -na | grep :\'' . $port . ' \' | grep -v 0.0.0.0 | grep -v ::: | wc -l'));
			file_put_contents($file_cache, serialize($out));
			return $out;
		}

		if (is_file($file_cache)) {
			$timefile = filemtime($file_cache);

			if ((time() - $timefile) < $timecache) {
				$res = unserialize(file_get_contents($file_cache));
				return $res;
			}

			$out = implode('', $this->sudo_ssh('netstat -na | grep :\'' . $port . ' \' | grep -v 0.0.0.0 | grep -v ::: | wc -l'));
			file_put_contents($file_cache, serialize($out));
			return $out;
		}
	}

	public function net_portconn($port = '80')
	{
		$port = intval($port);
		$out = $this->sudo_ssh('netstat -na | grep :\'' . $port . ' \' | awk \'{print $5 " " $6 " " $7}\' | sort | uniq -c | sort -n');
		$out_n = implode('', $this->sudo_ssh('netstat -na | grep :\'' . $port . ' \' | wc -l'));
		$n = count($out);
		$i = 0;

		while ($i < $n) {
			if (strstr($out[$i], 'LISTEN')) {
				unset($out[$i]);
				--$out_n;
			}

			++$i;
		}

		$out = array_values($out);
		$this->net_port_n_correct = $out_n;
		return $out;
	}

	public function net_portconn_correct_n()
	{
		return $this->net_port_n_correct;
	}

	public function net_portconn_tmp($port = '80')
	{
		$port = intval($port);
		$out = $this->sudo_ssh('netstat -na | grep :\'' . $port . ' \' | awk \'{print $5 " " $6 " " $7}\' | cut -d: -f1 | sort | uniq -c | sort -n');
		$n = count($out);
		$i = 0;

		while ($i < $n) {
			$out[$i] = trim($out[$i]);
			if (strstr($out[$i], '0.0.0.0') || trim($out[$i] == '1')) {
				unset($out[$i]);
			}
			else {
				if (strstr($out[$i], 'Address') || strstr($out[$i], 'servers') || (substr_count($out[$i], '.') < 3)) {
					unset($out[$i]);
				}
				else {
					$out[$i] = explode(' ', $out[$i]);
				}
			}

			++$i;
		}

		$out = array_values($out);
		unset($this->list_block_port_candidate);
		$this->list_block_port_candidate = $out;
		return $out;
	}

	public function net_csf_ipdo($ip, $action)
	{
		if (!preg_match('/^[0-9\\-\\s\\.\\/_]+$/', $ip)) {
			return false;
		}

		if (!$this->check_value('strdot', $action)) {
			return false;
		}

		$out = implode('', $this->sudo_ssh('csf -' . $action . ' ' . $ip . ' &>/dev/stdout'));
		return $out;
	}

	public function net_iptables_rules()
	{
		$a0 = $this->sudo_ssh('iptables -S | grep "P " ' . '&> /dev/stdout');
		$a1 = $this->sudo_ssh('iptables -S | grep "N " ' . '&> /dev/stdout');
		$chains = '';
		$arr = array_merge($a0, $a1);
		$i = 0;

		while ($i < count($arr)) {
			$a = explode(' ', trim($arr[$i]));
			$chains[] = trim($a[1]);
			++$i;
		}

		foreach ($chains as $value) {
			$out[$value] = $this->sudo_ssh('iptables -L ' . $value . ' -n --line-numbers');

			foreach ($out[$value] as $key => $vvalue) {
				if ($key != 0) {
					$vvalue = preg_replace('/ {2,}/', ' ', $vvalue);
					$out[$value][$key] = explode(' ', $vvalue);
				}
			}
		}

		return $out;
	}

	public function net_iptables_delete_rule($chain, $line = NULL)
	{
		if (!$this->check_value('string', $chain)) {
			return false;
		}
		if ($line) {
			if (!preg_match('/^[a-zA-Z0-9\\-\\s\\.\\/_]+$/', $line)) {
				return false;
			}
		}

		$out = $this->sudo_ssh('iptables -D ' . $chain . ' ' . $line);
		return $out;
	}

	public function net_iptables_service($action)
	{
		if (!$this->check_value('string', $action)) {
			return false;
		}

		$out = $this->monitor_service_command('iptables', $action);
		return $out;
	}

	public function net_iptables_add_rules($rules)
	{
		$rules = str_replace('iptables ', '', $rules);
		return $this->sudo_ssh('iptables ' . $rules . ' &> /dev/stdout');
	}

	public function net_iptables_save_rules()
	{
		return $this->sudo_ssh('iptables-save > ' . $this->conf_patch);
	}

	public function net_iptables_restore_rules()
	{
		return $this->sudo_ssh('iptables-restore < ' . $this->conf_patch);
	}

	public function net_sort_port($first_port = '80')
	{
		$first_port = intval($first_port);
		$arr = $this->array_port;
		$del_val = $first_port;

		if (($key = array_search($del_val, $arr)) !== false) {
			unset($arr[$key]);
		}

		$arr = array_values($arr);
		array_unshift($arr, $first_port);
		return $arr;
	}

	public function net_sort_port_syn($first_port_key = '0')
	{
		$arr = $this->array_port_syn;
		$del_key = $first_port_key;

		foreach ($arr as $key => $val) {
			if ($key == $del_key) {
				unset($arr[$key]);
			}
		}

		if ($del_key == '0') {
			$val = 'Все';
		}
		else {
			$val = $del_key;
		}

		$arr = array($del_key => $val) + $arr;
		return $arr;
	}

	public function net_iptables_iplimit($n, $port, $type, $msg = '')
	{
		$n = intval($n);
		$port = intval($port);

		if ($type == 'LIST_ALL') {
			$out = $this->net_connections();
		}
		else if ($type == 'LIST_SYN') {
			$out = $this->net_syncrec_connections($port);
		}
		else if ($type == 'LIST_PORT') {
			$out = $this->net_portconn_tmp($port);
		}

		$l = count($out);
		$arr = array();
		$i = 0;

		while ($i < $l) {
			$c = $out[$i];

			if ($n <= $c[0]) {
				$arr[] = $c[1];
				$arr_out[] = $c[1] . $msg;
				$ip_addr = $c[1];
				if (!($ip_addr == '127.0.0.1') || ($ip_addr == 'localhost')) {
					$this->sudo_ssh('iptables -I INPUT 1 -s ' . $ip_addr . ' -j DROP');
				}
			}

			++$i;
		}

		return $arr_out;
	}

	public function net_iptables_drop_ip($addr)
	{
		if (!preg_match('/^[0-9\\/\\.]+$/', $addr) || ($addr == '127.0.0.1')) {
			return false;
		}

		return implode('', $this->sudo_ssh('iptables -I INPUT 1 -s ' . $addr . ' -j DROP'));
	}

	public function net_script_run($timeout = '10', $item, $size, $port = '80', $ch)
	{
		$timeout = intval($timeout);
		$size = intval($size);
		$port = intval($port);
		$item = intval($item);

		if (is_bool($ch) === false) {
			return false;
		}

		$var = 'item' . $item;
		$log = 'log' . $item;
		$this->load_vars();
		$var1 = explode(',', $this->module_vars['item1']);
		$var2 = explode(',', $this->module_vars['item2']);
		$var3 = explode(',', $this->module_vars['item3']);
		$stream_id = $out = '';
		$process_n = count($this->sudo_ssh(' ps -ef | grep "net_iptables.sh item=' . $item . '" | grep -v "grep" | grep -v " -c " | awk \'{print $2}\''));

		if (($item == 1) && ($process_n == 0)) {
			$stream[0]['comm'] = $GLOBALS['DOCUMENT_ROOT_PATH'] . 'ssh/net_iptables.sh item=' . $item . ' ' . $timeout . ' ' . $size . ' all NULL ' . $ch;
			$stream[0]['array_start'] = array($var => 'inprogress,#stream_id#');
			$stream[0]['array_success'] = array($var => 'success,#stream_id#');
			$stream[0]['array_unsuccess'] = array($var => 'unsuccess,#stream_id#');
			$stream_id = $this->create_stream($stream);
			$out = $this->read_stream($stream_id);
			$this->set_data(array($var => $stream_id));
		}

		if (($item == 2) && ($process_n == 0)) {
			$stream[0]['comm'] = $GLOBALS['DOCUMENT_ROOT_PATH'] . 'ssh/net_iptables.sh item=' . $item . ' ' . $timeout . ' ' . $size . ' all SYN_REC ' . $ch;
			$stream[0]['array_start'] = array($var => 'inprogress,#stream_id#');
			$stream[0]['array_success'] = array($var => 'success,#stream_id#');
			$stream[0]['array_unsuccess'] = array($var => 'unsuccess,#stream_id#');
			$stream_id = $this->create_stream($stream);
			$out = $this->read_stream($stream_id);
			$this->set_data(array($var => $stream_id));
		}

		if (($item == 3) && ($process_n == 0)) {
			$stream[0]['comm'] = $GLOBALS['DOCUMENT_ROOT_PATH'] . 'ssh/net_iptables.sh item=' . $item . ' ' . $timeout . ' ' . $size . ' ' . $port . ' NULL ' . $ch;
			$stream[0]['array_start'] = array($var => 'inprogress,#stream_id#');
			$stream[0]['array_success'] = array($var => 'success,#stream_id#');
			$stream[0]['array_unsuccess'] = array($var => 'unsuccess,#stream_id#');
			$stream_id = $this->create_stream($stream);
			$out = $this->read_stream($stream_id);
			$this->set_data(array($var => $stream_id));
		}

		return $out;
	}

	public function net_script_stop($item = 1)
	{
		if (!$this->check_value('number', $item)) {
			return false;
		}

		$var = 'item' . $item;
		$out = $this->sudo_ssh('ps -ef | grep "net_iptables.sh item=' . $item . '" | grep -v "grep" | grep -v " -c " | awk \'{print $2}\'');
		$i = 0;

		while ($i < count($out)) {
			$this->sudo_ssh('kill -9 ' . $out[$i]);
			++$i;
		}

		return $out;
	}

	public function net_script_action_stop($type)
	{
		if (!$this->check_value('string', $type)) {
			return false;
		}

		if ($type == 'LIST_ALL') {
			$item = 1;
		}

		if ($type == 'LIST_SYN') {
			$item = 2;
		}

		if ($type == 'LIST_PORT') {
			$item = 3;
		}

		$var = 'item' . $item;
		$out = $this->sudo_ssh(' ps -ef | grep "net_iptables.sh item=' . $item . '" | grep -v "grep" | grep -v " -c " | awk \'{print $2}\'');
		$i = 0;

		while ($i < count($out)) {
			$this->sudo_ssh('kill -9 ' . $out[$i]);
			++$i;
		}

		return $out;
	}

	public function net_script_run_check($type = '')
	{
		$out = array();

		if ($type == '') {
			$arr = array('item=1', 'item=2', 'item=3');
			$i = 0;

			while ($i < count($arr)) {
				array_push($out, implode('', $this->sudo_ssh('ps -ef | grep "net_iptables.sh ' . $arr[$i] . '" | grep -v "grep" | wc -l')));
				++$i;
			}
		}
		else {
			if ($type == 'LIST_ALL') {
				$item = 'item=1';
			}

			if ($type == 'LIST_SYN') {
				$item = 'item=2';
			}

			if ($type == 'LIST_PORT') {
				$item = 'item=3';
			}

			array_push($out, implode('', $this->sudo_ssh('ps -ef | grep "net_iptables.sh ' . $item . '" | grep -v "grep" | wc -l')));
		}

		return $out;
	}

	public function net_script_read($arr)
	{
		$this->load_vars();
		$i = 0;

		while ($i < count($arr)) {
			$item = 'item' . ($i + 1);
			$stream_id = $this->module_vars[$item];
			$out = $this->read_stream($stream_id);

			if (sizeof($out)) {
				unset($out[0]);
				$out = array_values($out);
			}

			$result[] = $out;
			++$i;
		}

		return $result;
	}

	public function net_script_get_pid()
	{
		$this->load_vars();
		$var1 = $this->module_vars['item1'];
		$var2 = $this->module_vars['item2'];
		$var3 = $this->module_vars['item3'];
		return array($var1, $var2, $var3);
	}

	public function net_script_start($type, $timeout, $size, $port = 0, $ch)
	{
		$timeout = intval($timeout);
		$size = intval($size);
		$port = intval($port);
		$id = 0;

		if ($type == 'LIST_ALL') {
			$id = 1;
		}
		else if ($type == 'LIST_SYN') {
			$id = 2;
		}
		else if ($type == 'LIST_PORT') {
			$id = 3;
		}

		if ($port == 0) {
			$port = 'all';
		}

		if ($id == 0) {
			return false;
		}

		$this->net_script_run($timeout, $id, $size, $port, $ch);
	}

	public function net_script_section_get_id($type)
	{
		global $lang;
		$status_id = '';
		$button_id = '';

		if ($type == 'LIST_ALL') {
			$status_id = 'status_shell_all';
			$button_id = 'btn_shell_all';
		}
		else if ($type == 'LIST_SYN') {
			$status_id = 'status_shell_syn';
			$button_id = 'btn_shell_syn';
		}
		else if ($type == 'LIST_PORT') {
			$status_id = 'status_shell_port';
			$button_id = 'btn_shell_port';
		}

		return array($status_id, $button_id);
	}

	public function net_script_shell_encode($status_id, $button_id, $status_msg, $button_msg)
	{
		$mess['statusid'] = $status_id;
		$mess['buttonid'] = $button_id;
		$mess['statusmsg'] = $status_msg;
		$mess['buttonmsg'] = $button_msg;
		return $mess;
	}

	public function net_script_set_pid($arr_pid, $arr_item, $run_check, $params)
	{
		global $lang;
		$signal = 'click';
		$timeout = $params[0];
		$size = $params[1];
		$port = intval($params[2]);
		$ch_all = $params[3];
		$ch_syn = $params[4];
		$ch_port = $params[5];
		list($msg_shell_run, $msg_shell_status) = $this->net_set_msg_shell($run_check, $arr_pid, $lang);

		if ($port == 0) {
			$port = 'all';
		}

		$el_id = 0;
		$var_item = 'item1';

		if ($arr_item[0] == $signal) {
			$id = 1;

			if ($run_check[0] == 0) {
				$this->net_script_run($timeout, $id, $size, 'all', $ch_all);
				$this->load_vars();
				$arr_pid[0] = $this->module_vars['item1'];
				$msg_shell_run[0] = $lang[btn_run_check_stop];
				$msg_shell_status[0] = $lang[msg_run_script_status] . $lang[msg_run_script_start];
			}
			else {
				$this->net_script_stop($id);
				$msg_shell_run[0] = $lang[btn_run_check_start];
				$msg_shell_status[0] = $lang[msg_run_script_status] . $lang[msg_run_check_stop];
			}
		}

		$el_id = 1;

		if ($arr_item[1] == $signal) {
			$id = 2;

			if ($run_check[1] == 0) {
				$this->net_script_run($timeout, $id, $size, 'all', $ch_syn);
				$this->load_vars();
				$arr_pid[1] = $this->module_vars['item2'];
				$msg_shell_run[1] = $lang[btn_run_check_stop];
				$msg_shell_status[1] = $lang[msg_run_script_status] . $lang[msg_run_script_start];
			}
			else {
				$this->net_script_stop($id);
				$msg_shell_run[1] = $lang[btn_run_check_start];
				$msg_shell_status[1] = $lang[msg_run_script_status] . $lang[msg_run_check_stop];
			}
		}

		$el_id = 2;

		if ($arr_item[2] == $signal) {
			$id = 3;

			if ($run_check[2] == 0) {
				$this->net_script_run($timeout, $id, $size, $port, $ch_port);
				$this->load_vars();
				$arr_pid[2] = $this->module_vars['item3'];
				$msg_shell_run[2] = $lang[btn_run_check_stop];
				$msg_shell_status[2] = $lang[msg_run_script_status] . $lang[msg_run_script_start];
			}
			else {
				$this->net_script_stop($id);
				$msg_shell_run[2] = $lang[btn_run_check_start];
				$msg_shell_status[2] = $lang[msg_run_script_status] . $lang[msg_run_check_stop];
			}
		}

		return array($msg_shell_run, $msg_shell_status);
	}

	public function net_set_msg_shell($run_check, $arr_pid)
	{
		global $lang;
		$msg_shell_run = array($run_check[0] == 0 ? $lang[btn_run_check_start] : $lang[btn_run_check_stop], $run_check[1] == 0 ? $lang[btn_run_check_start] : $lang[btn_run_check_stop], $run_check[2] == 0 ? $lang[btn_run_check_start] : $lang[btn_run_check_stop]);
		$msg_shell_status = array($run_check[0] != 0 ? $lang[msg_run_script_status] . $lang[msg_run_script_start] : $lang[msg_run_script_status] . $lang[msg_run_script_stop], $run_check[1] != 0 ? $lang[msg_run_script_status] . $lang[msg_run_script_start] : $lang[msg_run_script_status] . $lang[msg_run_script_stop], $run_check[2] != 0 ? $lang[msg_run_script_status] . $lang[msg_run_script_start] : $lang[msg_run_script_status] . $lang[msg_run_script_stop]);
		return array($msg_shell_run, $msg_shell_status);
	}

	public function net_set_checkbox($ch1, $ch2, $ch3)
	{
		return array($ch1 == 'true' ? 'checked=\'true\'' : '', $ch2 == 'true' ? 'checked=\'true\'' : '', $ch3 == 'true' ? 'checked=\'true\'' : '');
	}

	public function net_iptables_status($res, $status)
	{
		global $lang;

		if (!$this->check_value('text', $status)) {
			$mess['status'] = $lang['networktools_rule_wrongformat'];
			return $mess;
		}

		$mess['info'] = $res;
		$mess['status'] = implode('<br>', $status);
		return $mess;
	}

	public function net_load_list_ip($type, $port = '0')
	{
		if (!$this->check_value('string', $type)) {
			return false;
		}

		$port = intval($port);

		if ($type == 'LIST_ALL') {
			$section_id = 'id_div_all';
			$status_id = 'status_' . $type;
			$list_ip = $this->net_connections();
		}
		else if ($type == 'LIST_SYN') {
			$section_id = 'id_div_syn';
			$status_id = 'status_' . $type;
			$list_ip = $this->net_syncrec_connections($port);
		}
		else if ($type == 'LIST_PORT') {
			$section_id = 'id_div_port';
			$status_id = 'status_' . $type;
			$list_ip = $this->net_portconn_tmp($port);
		}

		return array($list_ip, $section_id, $status_id);
	}

	public function net_load_list_ip_encode($out, $n)
	{
		$mess['list'] = $out;
		$mess['n'] = $n;
		return $mess;
	}

	public function net_script_load_code_stream($type)
	{
		$item = '';

		if ($type == 'LIST_ALL') {
			$item = 'item1';
		}
		else if ($type == 'LIST_SYN') {
			$item = 'item2';
		}
		else if ($type == 'LIST_PORT') {
			$item = 'item3';
		}

		if (!$item) {
			return false;
		}

		$this->load_vars();
		$stream_id = explode(',', $this->module_vars[$item]);
		$out = implode('', $this->read_stream($stream_id[1]));
		return $out;
	}
}


?>
