<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class packet_manager
{
	public function pm_core($service, $command, $getstreamonline = NULL)
	{
		if (($command != 'install') && ($command != 'delete') && ($command != 'update')) {
			return 0;
		}

		if (!$this->check_value('string', $service)) {
			return false;
		}

		$service = escapeshellcmd($service);
		$out = $this->pm_list($service);
		$thiss = $out[0];

		switch ($command) {
		case 'install':
			$outt = $this->config_read('/etc/brainy/data/packet_manager/main');
			$progress = explode(',', $outt['install_status_' . $service]);
			$pprogress = $progress[0];
			$sstream_id = $progress[1];
			$last_install_time = $outt['last_install_time_' . $service];
			$time = time();

			if (!$last_install_time) {
				$last_install_time = $time;
			}

			if (($thiss['installed'] == 0) && (($pprogress != 'inprogress') || ((60 * 5) < ($time - $last_install_time)))) {
				$stream[]['comm'] = $thiss['install_process'];
				$stream[]['comm'] = 'chkconfig --level 345 ' . $service . ' on';
				$stream[0]['array_start'] = array('install_status_' . $service => 'inprogress,#stream_id#', 'last_install_time_' . $service => $time, 'last_log_' . $service => '#stream_id#', 'cur_status_' . $service => 'inprogress,#stream_id#');
				$stream[0]['test'] = $thiss['install_success'];
				$stream[0]['array_succes'] = array('install_status_' . $service => 'success,#stream_id#', 'last_install_time_' . $service => $time, 'last_log_' . $service => '#stream_id#', 'cur_status_' . $service => 'success,#stream_id#', $service => '1');
				$stream[0]['array_unsucces'] = array('install_status_' . $service => 'unsucces,#stream_id#', 'last_install_time_' . $service => $time, 'last_log_' . $service => '#stream_id#', 'cur_status_' . $service => 'unsuccess,#stream_id#');

				if ($getstreamonline == 1) {
					$stream_id = $this->create_stream_online($stream, 'packet_manager');
				}
				else {
					$stream_id = $this->create_stream($stream);
				}

				$outt = $this->config_read('/etc/brainy/data/packet_manager/main');
				$progress = explode(',', $outt['install_status_' . $service]);
				$pprogress = $progress[0];
				$stream_id = $progress[1];
			}
			else {
				$stream_id = $sstream_id;
			}

			break;

		case 'delete':
			$outt = $this->config_read('/etc/brainy/data/packet_manager/main');
			$progress = explode(',', $outt['delete_status_' . $service]);
			$pprogress = $progress[0];
			$sstream_id = $progress[1];
			$last_delete_time = $outt['last_delete_time_' . $service];
			$time = time();

			if (!$last_delete_time) {
				$last_delete_time = $time;
			}

			if (($thiss['installed'] == 1) && (($pprogress != 'inprogress') || ((60 * 5) < ($time - $last_delete_time)))) {
				$stream[0]['comm'] = $thiss['delete_process'];
				$stream[0]['array_start'] = array('delete_status_' . $service => 'inprogress,#stream_id#', 'last_delete_time_' . $service => $time, 'last_log_' . $service => '#stream_id#', 'cur_status_' . $service => 'inprogress,#stream_id#');
				$stream[0]['test'] = $thiss['delete_success'];
				$stream[0]['array_succes'] = array('delete_status_' . $service => 'success,#stream_id#', 'last_delete_time_' . $service => $time, 'last_log_' . $service => '#stream_id#', 'cur_status_' . $service => 'success,#stream_id#', $service => '0');
				$stream[0]['array_unsucces'] = array('delete_status_' . $service => 'unsucces,#stream_id#', 'last_delete_time_' . $service => $time, 'last_log_' . $service => '#stream_id#', 'cur_status_' . $service => 'unsucces,#stream_id#');

				if ($getstreamonline == 1) {
					$stream_id = $this->create_stream_online($stream, 'packet_manager');
				}
				else {
					$stream_id = $this->create_stream($stream);
				}

				$outt = $this->config_read('/etc/brainy/data/packet_manager/main');
				$progress = explode(',', $outt['delete_status_' . $service]);
				$pprogress = $progress[0];
				$stream_id = $progress[1];
			}
			else {
				$stream_id = $sstream_id;
			}

			break;
		}

		$core_status['stream_id'] = $stream_id;

		if ($getstreamonline == 1) {
			$out1 = $this->read_stream($stream_id);
			$core_status['raw_info'] = implode("\n", $out1);
		}

		return $core_status;
	}

	public function pm_if_installed($path)
	{
		if (file_exists($path)) {
			return '1';
		}

		return '0';
	}

	public function pm_onoff($service, $command)
	{
		if (($command != 'start') && ($command != 'stop') && ($command != 'killall') && ($command != 'restart')) {
			return 0;
		}

		if (!$this->check_value('string', $service)) {
			return false;
		}

		$service = escapeshellcmd($service);
		$comm = 'service \'' . $service . '\' ' . $command;

		if ($command == 'killall') {
			global $lang;

			if (preg_match('/^(postgres)+/i', $service)) {
				$service = 'postgres';
			}

			$comm = 'killall -9 ' . $service;
			$this->sudo_ssh($comm);
			return $lang['common_killall_ok'];
		}

		$out = $this->monitor_service_command($service, $command);
		return $out;
	}

	public function pm_autoload($service, $command)
	{
		global $lang;

		if (($command != 'add') && ($command != 'rm')) {
			return 0;
		}

		if (!$this->check_value('stringservice', $service)) {
			return false;
		}

		if ($GLOBALS['v2'] == 'yes') {
			if ($service == 'clamd') {
				$service = 'clamd@scan';
			}
		}

		switch ($command) {
		case 'add':
			if (stripos($GLOBALS['OS_VERSION'], 'centos7') !== false) {
				$out = implode('', $this->sudo_ssh('systemctl enable \'' . $service . '\''));
			}
			else {
				$out = implode('', $this->sudo_ssh('chkconfig --level 345 ' . $service . ' on'));
			}

			break;

		case 'rm':
			if (stripos($GLOBALS['OS_VERSION'], 'centos7') !== false) {
				$out = implode('', $this->sudo_ssh('systemctl disable \'' . $service . '\''));
			}
			else {
				$out = implode('', $this->sudo_ssh('chkconfig --level 123456 ' . $service . ' off'));
			}

			break;
		}

		return $out;
	}

	public function pm_if_running($daemon_name)
	{
		if (!$daemon_name) {
			return 0;
		}

		if (!$this->check_value('string', $daemon_name)) {
			return false;
		}

		$daemon_name = escapeshellcmd($daemon_name);
		$out = implode('', $this->sudo_ssh('service \'' . $daemon_name . '\' status'));

		if ((0 < substr_count($out, 'running')) && (substr_count($out, 'not running') < 1)) {
			return 1;
		}

		return 0;
	}

	public function pm_if_autoload($daemon_name)
	{
		if (!$daemon_name) {
			return 0;
		}

		if (!$this->check_value('stringservice', $daemon_name)) {
			return false;
		}

		$daemon_name = escapeshellcmd($daemon_name);

		if (stripos($GLOBALS['OS_VERSION'], 'centos7') !== false) {
			$out = implode('', $this->sudo_ssh('systemctl is-enabled \'' . $daemon_name . '\''));

			if (0 < substr_count($out, 'enabled')) {
				return 1;
			}

			return 0;
		}

		$out = implode('', $this->sudo_ssh('chkconfig | grep \'' . $daemon_name . '\''));

		if (0 < substr_count($out, 'on')) {
			return 1;
		}

		return 0;
	}

	public function pm_list($string = NULL)
	{
		global $lang;

		if (!$this->check_value('string', $string)) {
			return false;
		}

		$out = $this->read_file_n($GLOBALS['DOCUMENT_ROOT_PATH'] . 'data/packet_manager/packet_list', $string);

		foreach ($out as $key => $value) {
			$foo = explode('#', $value);

			foreach ($foo as $kkey => $vvalue) {
				$foo1 = explode('++', $vvalue);

				if (1 < count($foo1)) {
					if (strstr($foo1[1], ',')) {
						$t = explode(',', $foo1[1]);

						if (stripos($GLOBALS['OS_VERSION'], 'debian8') !== false) {
							$foo1[1] = $t[2];
						}
						else if (stripos($GLOBALS['OS_VERSION'], 'centos7') !== false) {
							$foo1[1] = $t[1];
						}
						else if (stripos($GLOBALS['OS_VERSION'], 'centos6') !== false) {
							$foo1[1] = $t[0];
						}
					}

					$foo[$kkey] = $foo1;
				}
			}

			$newmass[$key] = $foo;
		}

		foreach ($newmass as $key => $value) {
			$itogmass[$key]['title'] = $value[0];
			$getlangdesc = str_replace('lang.', '', $value[1]);

			if (isset($lang['packet_manager_' . $getlangdesc])) {
				$itogmass[$key]['descr'] = $lang['packet_manager_' . $getlangdesc];
			}
			else {
				$itogmass[$key]['descr'] = $value[1];
			}

			$pathdetect = explode('::', $value[2]);

			foreach ($pathdetect as $curpath) {
				$curos = explode('[]:', $curpath);

				$itogmass[$key]['path'] = $curos[1];
				break;
			}

			$insdetect = explode('::', $value[4][0]);

			foreach ($insdetect as $cur) {
				$curos = explode('[]:', $cur);

				if ($curos[0] == $GLOBALS['OS_VERSION']) {
					$itogmass[$key]['install_process'] = $curos[1];
				}
			}

			$deldetect = explode('::', $value[5][0]);

			foreach ($deldetect as $cur) {
				$curos = explode('[]:', $cur);

				if ($curos[0] == $GLOBALS['OS_VERSION']) {
					$itogmass[$key]['delete_process'] = $curos[1];
				}
			}

			$itogmass[$key]['daemon'] = $value[3][0];
			$itogmass[$key]['daemon_name'] = $value[3][1];
			$itogmass[$key]['install_success'] = $value[4][1];
			$itogmass[$key]['delete_success'] = $value[5][1];
			$itogmass[$key]['locked'] = $value[6];
			$itogmass[$key]['autoload'] = 0;
			$ins = $this->pm_get_cur_status($itogmass[$key]['daemon_name'], $itogmass[$key]['path']);
			$itogmass[$key]['installed'] = $ins['progress'];
			$itogmass[$key]['cur_stream'] = $ins['stream_id'];

			if ($itogmass[$key]['daemon'] == 1) {
				$itogmass[$key]['running'] = intval($this->pm_if_running($itogmass[$key]['daemon_name']));
				$itogmass[$key]['autoload'] = intval($this->pm_if_autoload($itogmass[$key]['daemon_name']));
			}
		}

		return $itogmass;
	}

	public function pm_get_lastlog($service)
	{
		if (!$this->check_value('string', $service)) {
			return false;
		}

		$out = $this->config_read('/etc/brainy/data/packet_manager/main');
		$res = $out['last_log_' . $service];

		if (!$res) {
			return 0;
		}

		return $res;
	}

	public function pm_get_cur_status($service, $path)
	{
		$outt = $this->config_read('/etc/brainy/data/packet_manager/main');
		$progress = explode(',', $outt['cur_status_' . $service]);
		$pprogress = $progress[0];
		$sstream_id = $progress[1];

		if ($pprogress != 'inprogress') {
			$pprogress = intval($this->pm_if_installed($path));
			$sstream_id = $progress[1];
		}

		$itog['progress'] = $pprogress;
		$itog['stream_id'] = $sstream_id;
		return $itog;
	}
}


?>
