<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class php_ini
{
	public $path_data = '/etc/brainy/data/php_ini/main';
	public $path_custom_ini = '/home/';
	public $path_domains = '/etc/brainy/data/server_control/vhosts';

	public function get_custom_ini($sites, $user)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		if (!$this->check_value('domain', $sites)) {
			return false;
		}

		$arr['user'] = $user;
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$arr1 = explode(PHP_EOL, trim($this->read_file($this->path_data)));

		foreach ($arr1 as $value) {
			$arr['data'][explode('=', $value)[0]] = '';
			$arr['sintaxis'][explode('=', $value)[0]] = explode('=', $value)[1];
		}

		if (is_file($confUser['rootdir'] . '/data/' . $sites . '.ini')) {
			$arr_user_ini = $this->config_read($confUser['rootdir'] . '/data/' . $sites . '.ini');

			if (count($arr_user_ini) < count($arr['sintaxis'])) {
				$arr['data'] = array_merge($arr['data'], $arr_user_ini);
			}
			else {
				$arr['data'] = $arr_user_ini;
			}
		}

		return $arr;
	}

	public function user_ini_conwert($domain)
	{
		$info = $this->show_info_sites($domain);
		$ini_param = $this->get_custom_ini($info['domain'], $info['user']);
		$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);

		if (array_diff($ini_param['data'], array(''))) {
			if ((($info['bridge'] == 'mod_php') || ($info['bridge'] == 'mod_ruid')) && ($conf['back_server'] != 'nginx')) {
				if (is_file($info['dir'] . '/.user.ini')) {
					$this->ssh('rm -Rf ' . $info['dir'] . '/.user.ini');
				}

				$arr_str[] = '#begin custom php ini';

				foreach ($ini_param['data'] as $key => $val) {
					if (preg_match('/^(off)|(on)$/i', trim($val))) {
						$arr_str[] = 'php_flag ' . $key . ' ' . ucfirst($val);
					}
					else {
						if ($val || ($val === '0')) {
							$arr_str[] = 'php_value ' . $key . ' ' . $val;
						}
					}
				}

				$arr_str[] = '#end custom php ini';

				if (!is_file($info['dir'] . '/.htaccess')) {
					$this->write_file(implode(PHP_EOL, $arr_str), $info['dir'] . '/.htaccess', 'wa', $info['user']);
				}
				else {
					$this->del_strings_between_str('#begin custom php ini', '#end custom php ini', $info['dir'] . '/.htaccess');
					$this->write_file(implode(PHP_EOL, $arr_str), $info['dir'] . '/.htaccess', 'wa', $info['user']);
				}
			}

			if (($info['bridge'] == 'fastcgi') || ($info['bridge'] == 'suphp') || ($info['bridge'] == 'cgi') || ($conf['back_server'] == 'nginx') || ($info['bridge'] == 'fpm')) {
				if (is_file($info['dir'] . '/.htaccess')) {
					$this->del_strings_between_str('#begin custom php ini', '#end custom php ini', $info['dir'] . '/.htaccess');
				}

				foreach ($ini_param['data'] as $key => $val) {
					if ($val || ($val === '0')) {
						$arr_str[] = $key . ' = ' . $val;
					}
				}

				$this->write_file(implode(PHP_EOL, $arr_str), $info['dir'] . '/.user.ini', 'r', $info['user']);
			}
		}
		else {
			if (is_file($info['dir'] . '/.htaccess')) {
				$this->del_strings_between_str('#begin custom php ini', '#end custom php ini', $info['dir'] . '/.htaccess');
			}

			if (is_file($info['dir'] . '/.user.ini')) {
				$this->ssh('rm -Rf ' . $info['dir'] . '/.user.ini');
			}
		}
	}

	public function remove_ini_params($sites, $user = '')
	{
		global $lang;

		if (!$this->check_value('domain', $sites)) {
			return false;
		}

		if (!$this->check_user($user)) {
			return false;
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);

		if (is_file($confUser['rootdir'] . '/data/' . $sites . '.ini')) {
			$this->ssh('rm -f ' . $confUser['rootdir'] . '/data/' . $sites . '.ini');
			$arr['message'] = $lang['php_ini_remove_ini_succ'];
		}
		else {
			$arr['message'] = $lang['php_ini_remove_ini_not'];
		}

		$this->user_ini_conwert($sites);
		return $arr;
	}

	public function save_ini_params($sites, $params, $user = '')
	{
		global $lang;

		if (!$this->check_value('domain', $sites)) {
			return false;
		}

		if (!$this->check_value('user', $user)) {
			return false;
		}

		$array_ini = json_decode($params, true);
		$sintaxis = $this->get_custom_ini($sites, $user);

		foreach ($array_ini as $key => $val) {
			if (!$this->check_value('string2', $key)) {
				$arr['message'] = $lang['php_ini_not_str_char'];
			}

			foreach ($sintaxis['sintaxis'] as $key1 => $val1) {
				if ($key == $key1) {
					if ($val) {
						if (!preg_match('/^[0-9a-z_ \\,-\\.\\:\\/]+$/i', $val)) {
							$arr['message'] = $lang['php_ini_not_str_char'];
						}
					}
				}
			}
		}

		$info = $this->show_info_sites($sites);
		if ((($info['bridge'] == 'fastcgi') || ($info['bridge'] == 'suphp') || ($info['bridge'] == 'cgi') || ($info['bridge'] == 'fpm')) && ($info['php'] == 'php52w')) {
			$arr['message'] = $lang['php_ini_not_unfortunately'] . $info['bridge'];
		}

		if ($arr['message']) {
			return $arr;
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);

		if (!is_dir($confUser['rootdir'] . '/data/')) {
			$this->ssh('mkdir ' . $confUser['rootdir'] . '/data/');
			$this->ssh('chown -R ' . $user . '.' . $user . ' ' . $confUser['rootdir'] . '/data/');
		}

		$this->config_save_my($confUser['rootdir'] . '/data/' . $sites . '.ini', $array_ini, 'add', $user);
		$arr['message'] = $lang['php_ini_cuccesfylly'];
		$this->user_ini_conwert($sites);
		return $arr;
	}

	public function show_user_site($user)
	{
		global $lang;

		if (!$this->check_value('user', $user)) {
			return false;
		}

		$conf = $GLOBALS['DATA_VHOSTS'] . $sites . '.conf';
		$params = $this->config_read($conf);
		return $params;
	}

	public function show_info_sites($sites)
	{
		global $lang;

		if (!$this->check_value('domain', $sites)) {
			return false;
		}

		$conf = $GLOBALS['DATA_VHOSTS'] . $sites . '.conf';
		$params = $this->config_read($conf);
		return $params;
	}
}


?>
