<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class postgresql
{
	public $acces_user = '/var/lib/pgsql/data/pg_hba.conf';

	public function save_privilegies($data)
	{
		global $lang;
		$data = (array) json_decode($data);
		$user_db = $data['user_db'];
		$name_db = $data['name_db'];

		if (!$this->check_enabled_postgres()) {
			$arr_out['code'] = 10;
			$arr_out['message'] = $lang['postgresql_error_stop_service'];
		}

		if ($data['remote_accesec'] == 1) {
			$ip = $data['ip'];
			$method_acceses = $data['method_acceses'];

			if (!preg_match('/^([0-9]+[.]+){3}[0-9]+[\\/]+[0-9]+$/i', $ip)) {
				$arr_out['code'] = 8;
				$arr_out['message'] = $lang['postgresql_error_ip'];
			}

			if (!preg_match('/^[a-z0-9]+$/i', $method_acceses)) {
				$arr_out['code'] = 9;
				$arr_out['message'] = $lang['postgresql_error_method'];
			}
		}

		if (!preg_match('/^[a-z_0-9]+$/i', $name_db)) {
			$arr_out['code'] = 5;
			$arr_out['message'] = $lang['postgresql_error_name_db'];
		}

		if (!preg_match('/^[a-z_0-9]+$/i', $user_db)) {
			$arr_out['code'] = 4;
			$arr_out['message'] = $lang['postgresql_error_user_db'];
		}
		if ($arr_out) {
			return $arr_out;
		}

		$out = $this->ssh_user('postgres', 'psql -A -q -t -c "grant all privileges on database ' . $name_db . ' to postgres, ' . $user_db . ';"');
		$out = $this->ssh_user('postgres', 'psql -A -q -t -c "ALTER DATABASE ' . $name_db . ' OWNER TO ' . $user_db . ';"');

		if ($data['remote_accesec'] == 1) {
			$this->ssh('echo \'host    ' . $name_db . '        ' . $user_db . '       ' . $ip . '             ' . $method_acceses . '\' >>' . $this->acces_user);
			$this->ssh('/bin/systemctl restart postgresql.service');

			if (!$this->check_enabled_postgres()) {
				$this->del_string_new($name_db . '        ' . $user_db . '       ' . $ip, $this->acces_user);
				$this->ssh('/bin/systemctl restart postgresql.service');
				$arr_out['code'] = 12;
				$arr_out['message'] = $lang['postgresql_error_remote_data'];
				return $arr_out;
			}
		}

		$arr_out['code'] = 0;
		$arr_out['message'] = $lang['postgresql_succesfully'];
		return $arr_out;
	}

	public function phppgadmin()
	{
		if (is_file('/etc/phpPgAdmin/config.inc.php')) {
			return true;
		}

		return false;
	}

	public function rm_privilegies($data)
	{
		global $lang;
		$data = (array) json_decode($data);
		$user_db = $data['user_db'];
		$name_db = $data['name_db'];
		$ip = $data['ip'];
		var_dump();

		if (!preg_match('/^[a-z_0-9]+$/i', $name_db)) {
			$arr_out['code'] = 5;
			$arr_out['message'] = $lang['postgresql_error_name_db'];
		}

		if (!preg_match('/^[a-z_0-9 ,]+$/i', $user_db)) {
			$arr_out['code'] = 4;
			$arr_out['message'] = $lang['postgresql_error_user_db'];
		}
		if ($arr_out) {
			return $arr_out;
		}

		if ($ip != 'localhost') {
			if (!preg_match('/^([0-9]+[.]+){3}[0-9]+[\\/]+[0-9]+$/i', $ip)) {
				$arr_out['code'] = 8;
				$arr_out['message'] = $lang['postgresql_error_ip'];
			}
			if ($arr_out) {
				return $arr_out;
			}

			$this->del_string_new($name_db . '        ' . $user_db . '       ' . $ip, $this->acces_user);
			$this->ssh('/bin/systemctl restart postgresql.service');

			if (!$this->check_enabled_postgres()) {
				$arr_out['code'] = 10;
				$arr_out['message'] = $lang['postgresql_error_stop_service'];
			}
			else {
				$arr_out['code'] = 0;
				$arr_out['message'] = $lang['postgresql_succesfully'];
			}
		}
		else {
			$array_userdb = explode(', ', $user_db);

			foreach ($array_userdb as $val_user_db) {
				$this->ssh_user('postgres', 'psql -A -q -t -c "ALTER DATABASE ' . $name_db . ' OWNER TO postgres;"');
				$this->ssh_user('postgres', 'psql -A -q -t -c "revoke all privileges on database ' . $name_db . ' from ' . $val_user_db . ';"');
			}

			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['postgresql_succesfully'];
		}

		return $arr_out;
	}

	public function view_acceses($user)
	{
		global $lang;

		if (!$this->check_value('user', $user)) {
			$arr_out['code'] = 1;
			$arr_out['message'] = $lang['postgresql_error_user'];
		}
		if ($arr_out) {
			return $arr_out;
		}

		$user = strtolower($user);
		$out = $this->ssh_user('postgres', 'psql -A -q -t -c "select regexp_matches(datname, \'' . $user . '_*\'),datname, datacl from pg_database;"');
		$array_acceses = $this->read_file_n($this->acces_user);

		foreach ($out as $val) {
			$out_val = explode('|', $val);
			$db = $out_val[1];
			$foo = explode(',', $out_val[2]);
			$user_db = '';

			foreach ($foo as $val_foo) {
				if (preg_match('/^(' . $user . '_)+/i', $val_foo)) {
					$user_db[] = explode('=', $val_foo)[0];
				}
			}

			foreach ($array_acceses as $key => $val_1) {
				$array = explode(' ', preg_replace('/[ ]{1,}|\\t+/i', ' ', trim($val_1)));

				foreach ($user_db as $val_user_db) {
					$ip = '';
					$method = '';

					if (($array[2] == $val_user_db) && ($array[1] == $db)) {
						$ip = $array[3];
						$method = $array[4];
						$array_db_remote[] = array('db' => $db, 'user_db' => $val_user_db, 'ip' => $ip, 'method' => $method);
					}
				}
			}

			if (!$ip && !$method) {
				$ip = 'localhost';
				$method = 'md5';
				if ($db && $user_db) {
					$array_db[] = array('db' => $db, 'user_db' => implode(', ', $user_db), 'ip' => $ip, 'method' => $method);
				}
			}
		}

		if (!$array_db_remote) {
			$array_db_remote = array();
		}

		if (!$array_db) {
			$array_db = array();
		}

		return array_merge($array_db, $array_db_remote);
	}

	public function show_db($user)
	{
		if (!$this->check_value('user', $user)) {
			$arr_out['code'] = 1;
			$arr_out['message'] = $lang['postgresql_error_user'];
		}
		if ($arr_out) {
			return $arr_out;
		}

		$user = strtolower($user);
		$out = $this->ssh_user('postgres', 'psql -A -q -t -c "select regexp_matches(datname, \'' . $user . '_*\'),datname, datacl from pg_database;"');

		foreach ($out as $val) {
			$db = explode('|', $val)[1];

			if (preg_match('/^(' . $user . '_)+/i', $db)) {
				$array_db[] = $db;
			}
		}

		return $array_db;
	}

	public function show_user_db($user)
	{
		if (!$this->check_value('user', $user)) {
			$arr_out['code'] = 1;
			$arr_out['message'] = $lang['postgresql_error_user'];
		}
		if ($arr_out) {
			return $arr_out;
		}

		$out = $this->ssh_user('postgres', 'psql -A -q -t -c "\\du ' . $user . '_*"');

		foreach ($out as $val) {
			if ($val) {
				$array_user_db[] = explode('|', $val)[0];
			}
		}

		return $array_user_db;
	}

	public function check_install_postgres()
	{
		$out = $this->ssh('rpm -qa | grep postgresql-server');

		if (!$out) {
			return 0;
		}

		return 1;
	}

	public function check_enabled_postgres()
	{
		switch ($GLOBALS['OS_VERSION']) {
		case 'centos7':
			$out = implode('', $this->ssh('/bin/systemctl status postgresql.service'));
			$preg = '/(active \\(running\\))+/i';
			break;

		case 'centos6':
			$out = implode('', $this->ssh('service postgresql status'));
			$preg = '/(is running)+/i';
			break;
		}

		if (preg_match($preg, $out)) {
			return true;
		}

		return false;
	}

	public function edit_db($data)
	{
		global $lang;
		$data = (array) json_decode($data);
		$user = $data['user'];
		$controll = $data['controll'];
		$name_db = $data['name_db'];

		if (!$this->check_value('user', $user)) {
			$arr_out['code'] = 1;
			$arr_out['message'] = $lang['postgresql_error_user'];
		}

		if (!$this->check_enabled_postgres()) {
			$arr_out['code'] = 10;
			$arr_out['message'] = $lang['postgresql_error_stop_service'];
		}

		switch ($controll) {
		case 'add_db':
			if (!preg_match('/^[a-z0-9]{2,9}$/i', $name_db)) {
				$arr_out['code'] = 5;
				$arr_out['message'] = $lang['postgresql_error_name_db'];
			}

			$query = 'CREATE DATABASE ' . $user . '_' . $name_db . ';';
			break;

		case 'remove_db':
			if (!preg_match('/^[a-z_0-9]+$/i', $name_db)) {
				$arr_out['code'] = 5;
				$arr_out['message'] = $lang['postgresql_error_name_db'];
			}

			$query = 'DROP DATABASE "' . $name_db . '";';
			break;
		}

		$this->ssh_user('postgres', 'psql -A -q -t -c "' . $query . '"');
		$arr_out['code'] = 0;
		$arr_out['message'] = $lang['postgresql_succesfully'];
		return $arr_out;
	}

	public function edit_user($data)
	{
		global $lang;
		$data = (array) json_decode($data);
		$user = $data['user'];
		$controll = $data['controll'];

		if (!$this->check_value('user', $user)) {
			$arr_out['code'] = 1;
			$arr_out['message'] = $lang['postgresql_error_user'];
		}

		if (!$this->check_enabled_postgres()) {
			$arr_out['code'] = 10;
			$arr_out['message'] = $lang['postgresql_error_stop_service'];
		}

		switch ($controll) {
		case 'add_user':
			$login = $data['login'];

			if (!preg_match('/^[a-z0-9]{2,9}$/i', $login)) {
				$arr_out['code'] = 2;
				$arr_out['message'] = $lang['postgresql_error_login'];
			}

			$password = $data['password'];

			if (!preg_match('/^.{1,}$/i', $password)) {
				$arr_out['code'] = 3;
				$arr_out['message'] = $lang['postgresql_error_password'];
			}

			$password = escapeshellcmd($password);
			$query = 'CREATE USER ' . $user . '_' . $login . ' WITH PASSWORD \'' . $password . '\';';
			break;

		case 'remove_user':
			$user_db = $data['user_db'];

			if (!preg_match('/^[a-z_0-9]+$/i', $user_db)) {
				$arr_out['code'] = 4;
				$arr_out['message'] = $lang['postgresql_error_user_db'];
			}

			$query = 'DROP USER ' . $user_db . ' ;';
			break;

		case 'change_pass':
			$user_db = $data['user_db'];

			if (!preg_match('/^[a-z_0-9]+$/i', $user_db)) {
				$arr_out['code'] = 4;
				$arr_out['message'] = $lang['postgresql_error_user_db'];
			}

			$password = $data['password'];

			if (!preg_match('/^.{1,}$/i', $password)) {
				$arr_out['code'] = 3;
				$arr_out['message'] = $lang['postgresql_error_password'];
			}

			$query = 'ALTER USER ' . $user_db . ' WITH PASSWORD \'' . $password . '\';';
			break;
		}

		$this->ssh_user('postgres', 'psql -A -q -t -c "' . $query . '"');
		$arr_out['code'] = 0;
		$arr_out['message'] = $lang['postgresql_succesfully'];
		return $arr_out;
	}
}


?>
