<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class properties
{
	public $path_authkey = '/root/.ssh/authserv';
	public $path_keyshare = '/root/.ssh/';

	public function brending($files)
	{
		global $lang;

		foreach ($files as $file) {
			if (($file['error'] == 0) && preg_match('/(png)|(jpeg)|(gif)|(jpg)$/i', trim($file['type']))) {
				if (move_uploaded_file($file['tmp_name'], '/etc/brainy' . $GLOBALS['template_path'] . 'img/logo.png')) {
					$size = getimagesize('/etc/brainy' . $GLOBALS['template_path'] . 'img/logo.png');
					$rate = (int) $size[1] / 100;
					$new_size['width'] = (int) $size[0] / $rate;
					$new_size['heigt'] = (int) $size[1] / $rate;
					$im1 = imagecreatetruecolor($new_size['width'], $new_size['heigt']);

					switch ($file['type']) {
					case 'image/png':
						$im = imagecreatefrompng('/etc/brainy' . $GLOBALS['template_path'] . 'img/logo.png');
						$black = ImageColorAllocate($im1, 0, 0, 0);
						$trans = imagecolortransparent($im1, $black);
						imageAlphaBlending($im1, false);
						imageSaveAlpha($im1, true);
						ImageFill($im1, 0, 0, $trans);
						imagecopyresampled($im1, $im, 0, 0, 0, 0, $new_size['width'], $new_size['heigt'], $size[0], $size[1]);
						imagepng($im1, '/etc/brainy' . $GLOBALS['template_path'] . 'img/logo.png');
						break;

					case 'image/gif':
						$im = imagecreatefromgif('/etc/brainy' . $GLOBALS['template_path'] . 'img/logo.png');
						$black = ImageColorAllocate($im1, 0, 0, 0);
						$trans = imagecolortransparent($im1, $black);
						ImageFill($im1, 0, 0, $trans);
						imagecopyresampled($im1, $im, 0, 0, 0, 0, $new_size['width'], $new_size['heigt'], $size[0], $size[1]);
						imagegif($im1, '/etc/brainy' . $GLOBALS['template_path'] . 'img/logo.png');
						break;

					case 'image/jpeg':
					case 'image/jpg':
						$im = imagecreatefromjpeg('/etc/brainy' . $GLOBALS['template_path'] . 'img/logo.png');
						imagecopyresampled($im1, $im, 0, 0, 0, 0, $new_size['width'], $new_size['heigt'], $size[0], $size[1]);
						imagejpeg($im1, '/etc/brainy' . $GLOBALS['template_path'] . 'img/logo.png');
						break;
					}

					imagedestroy($im1);
					$arr['code'] = 0;
					$arr['message'] = $lang['properties_succec_load'];
				}
				else {
					$arr['code'] = 405;
					$arr['message'] = $lang['properties_error_move'];
				}
			}
			else {
				$arr['code'] = 404;
				$arr['message'] = $lang['properties_error_load'];
			}
		}

		return $arr;
	}

	public function createindex($data)
	{
		global $lang;

		if (!$this->check_value('number', $data)) {
			return false;
		}

		if ($data == 1) {
			$data = 0;
		}
		else {
			$data = 1;
		}

		$this->config_save($GLOBALS['PROPERTIES_CONF'], array('create_index_html' => $data), 'add');
		$arr['message'] = $lang['properties_chanche_ok'];
		$arr['status'] = $data;
		return $arr;
	}

	public function usertoworkspace($data)
	{
		global $lang;

		if (!$this->check_value('number', $data)) {
			return false;
		}

		if ($data == 1) {
			$data = 0;
		}
		else {
			$data = 1;
		}

		$this->config_save($GLOBALS['PROPERTIES_CONF'], array('workspace' => $data), 'add');
		$arr['message'] = $lang['properties_chanche_ok'];
		$arr['status'] = $data;
		return $arr;
	}

	public function get_forbidden_users()
	{
		return $this->read_file('/etc/brainy/conf/forbidden_users');
	}

	public function forbidden_users_add($data)
	{
		global $lang;
		$array_data = explode(PHP_EOL, trim($data));

		foreach ($array_data as $val_data) {
			if (!$this->check_params('user', $val_data)) {
				$array_out['code'] = 1;
				$array_out['message'] = $lang['properties_error_user'] . $val_data;

				return $array_out;
			}
			if ($val_data) {
				$array_add[] = $val_data;
			}
		}

		$this->write_file(implode(PHP_EOL, $array_add), '/etc/brainy/conf/forbidden_users');
		$array_out['code'] = 0;
		$array_out['message'] = $lang['properties_successfully'];
		return $array_out;
	}

	public function usertoworkspacevalue($workspaceValue)
	{
		global $lang;

		if (!$this->check_params('string', $workspaceValue)) {
			$res['code'] = -1;
			$res['message'] = $lang['properties_template_title_wrongchoice'];
			return $res;
		}

		$this->config_save($GLOBALS['PROPERTIES_CONF'], array('workspace_value' => $workspaceValue), 'add');
		$arr['message'] = $lang['properties_chanche_ok'];
		$arr['status'] = $workspaceValue;
		return $arr;
	}

	public function getlimitsconf_forkbomb_cent()
	{
		$path_limits = '/etc/security/limits.d/';
		$resfile = scandir($path_limits);

		foreach ($resfile as $curfile) {
			if (is_file($path_limits . $curfile) && ($curfile != '..') && ($curfile != '.')) {
				if (stripos($curfile, 'nproc') !== false) {
					$list_conf = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($path_limits . $curfile));

					foreach ($list_conf as $key => $curconf) {
						$parse_field = preg_split('/[\\s]/', $curconf);
						$parse_field = array_filter($parse_field);
						$parse_field = array_values($parse_field);

						return $parse_field[3];
					}
				}
			}
		}
	}

	public function getlimitsconf_forkbomb()
	{
		switch ($GLOBALS['OS_VERSION']) {
		case 'centos7':
			$res = $this->getlimitsconf_forkbomb_cent();
			break;

		case 'centos6':
			$res = $this->getlimitsconf_forkbomb_cent();
			break;
		}

		return $res;
	}

	public function save_limitsconf_forkbomb_cent($value)
	{
		$value = intval($value);
		$path_limits = '/etc/security/limits.d/';
		$resfile = scandir($path_limits);
		$qsave = 0;

		foreach ($resfile as $curfile) {
			if (is_file($path_limits . $curfile) && ($curfile != '..') && ($curfile != '.')) {
				if (stripos($curfile, 'nproc') !== false) {
					$list_conf = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($path_limits . $curfile));

					foreach ($list_conf as $key => $curconf) {
						if ($curconf[0] == '*') {
							$parse_field = preg_split('/[\\s]/', $curconf);
							$parse_field_filt = array_filter($parse_field);
							$parse_field_filt = array_values($parse_field_filt);

							foreach ($parse_field as $key2 => $item) {
								if ($parse_field[$key2] == $parse_field_filt[3]) {
									$parse_field[$key2] = $value;
								}
							}

							$list_conf[$key] = implode(' ', $parse_field);
							$qsave = 1;
							break;
						}

						break;
					}

					if ($qsave == 1) {
						break;
					}
				}
			}
		}

		file_put_contents($path_limits . $curfile, '');

		foreach ($list_conf as $key => $item) {
			file_put_contents($path_limits . $curfile, $item . "\n", FILE_APPEND);
		}
	}

	public function save_limitsconf_forkbomb($value)
	{
		$value = intval($value);

		switch ($GLOBALS['OS_VERSION']) {
		case 'centos7':
			$res = $this->save_limitsconf_forkbomb_cent($value);
			break;

		case 'centos6':
			$res = $this->save_limitsconf_forkbomb_cent($value);
			break;
		}

		global $lang;
		$res['code'] = 0;
		$res['message'] = $lang['properties_protect_forkbomb_value_hint_saveok'];
		return $res;
	}

	public function keyauth_gen()
	{
		$time = time();
		$comm = 'echo -e  \'y' . "\n" . '\' | ssh-keygen -f ' . $this->path_authkey . $time . ' -t rsa -N \'\'';
		$this->ssh($comm);
		$out['status'] = 'done';
		$key_pub = trim(file_get_contents($this->path_authkey . $time . '.pub'));
		file_put_contents($this->path_keyshare . 'authorized_keys', $key_pub . "\n", FILE_APPEND);
		$out['key1'] = $key_pub;
		$out['key2'] = file_get_contents($this->path_authkey . $time);
		$this->ssh('rm -f ' . $this->path_authkey . $time);
		return $out;
	}

	public function authkey_showkeys()
	{
		$res_key = $this->ssh('cd /root/.ssh && find .  -name \'authserv*.pub\'');

		foreach ($res_key as $key => $cur) {
			$res_key[$key] = str_replace('./', '', $cur);
		}

		rsort($res_key);
		return $res_key;
	}

	public function authkey_viewkey($namekey)
	{
		$res = file_get_contents($this->path_keyshare . $namekey);
		return trim($res);
	}

	public function authkey_remove($namekey)
	{
		global $lang;
		$key_pub = file_get_contents($this->path_keyshare . $namekey);
		$list_authkey = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($this->path_keyshare . 'authorized_keys'));

		foreach ($list_authkey as $key => $cur) {
			if (trim($cur) == trim($key_pub)) {
				unset($list_authkey[$key]);
			}
		}

		file_put_contents($this->path_keyshare . 'authorized_keys', '');

		foreach ($list_authkey as $key => $cur) {
			if (5 < strlen($cur)) {
				file_put_contents($this->path_keyshare . 'authorized_keys', $cur . "\n", FILE_APPEND);
			}
		}

		$this->ssh('rm -f ' . $this->path_keyshare . $namekey);
		$resdo = $lang['properties_keyauth_removeconfirmsuccess'];
		return $resdo;
	}

	public function getListTemplate()
	{
		$resfile = scandir($GLOBALS['TPL_PATH']);
		$listTpl = array();
		$i = 0;

		foreach ($resfile as $curitem) {
			if (is_dir($GLOBALS['TPL_PATH'] . $curitem) && ($curitem != '..') && ($curitem != '.')) {
				$listTpl[$i]['name'] = $curitem;
				$listTpl[$i]['set'] = 0;

				if (stripos($GLOBALS['template_path'], '/' . $curitem . '/') !== false) {
					$listTpl[$i]['set'] = 1;
				}

				++$i;
			}
		}

		asort($listTpl);
		return $listTpl;
	}

	public function setTemplate($template)
	{
		global $lang;

		if (!$this->check_params('string', $template)) {
			$res['code'] = -1;
			$res['message'] = $lang['properties_template_title_wrongchoice'];
			return $res;
		}

		$arrval = array('template' => '/tpl/' . $template . '/');
		$this->config_save($GLOBALS['PROPERTIES_CONF'], $arrval, 'add');
		$res['code'] = 0;
		$res['message'] = $lang['properties_template_setok'];
		return $res;
	}
}


?>
