<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class Server
{
	public $main_check_real_file_code_lic_serv = 'gdhghfCCCDFJH34592HNVJnZ*@#&*)!@#&vchjwwopkCMKn29045698sccnMN2WJDJBKQJHBXB2858usdih12uh86u08948590=svjiISCh34)#$*5';
	public $deflink = '';
	public $deflink_noindex = '';
	public $lang = '';
	public $module_vars = '';
	public $module_header = '';
	public $requested_vars = '';
	public $user = array();
	public $domains = '';

	public function load_globals()
	{
		global $lang;
		$dir = $GLOBALS['GLOBALS_PATH'];
		$retval = array();

		if (substr($dir, -1) != '/') {
			$dir .= '/';
		}

		exit($lang['properties_cannot_open'] . ' ' . $dir . ' ' . $lang['properties_cannot_for_read']);
		($d = @dir($dir)) || true;

		while (false !== $entry = $d->read()) {
			if ($entry[0] == '.') {
				continue;
			}

			if (is_readable($dir . $entry)) {
				if (strripos($dir . $entry, '.php')) {
					$retval[] = $dir . $entry;
				}
			}
		}

		$d->close();

		foreach ($retval as $class) {
			require_once $class;
		}

		require_once $GLOBALS['API_PATH'];
	}

	public function get_real_server_ip()
	{
		$out = $this->sudo_ssh('hostname -I');
		$ip_list_arr = explode(' ', $out[0]);

		foreach ($ip_list_arr as $curip) {
			return $curip;
		}

		return $ip_list_arr[0];
	}

	public function mass_rename($dir, $pattern_from, $pattern_to)
	{
		if (!$dir || !$pattern_from || !$pattern_to) {
			return 0;
		}

		$out = $this->sudo_ssh('ls -l ' . $dir . '/*' . $pattern_from . '* 2>/dev/null | awk \'{print $9}\'');

		foreach ($out as $value) {
			$filename = strrchr($value, '/');
			$new_filename = str_replace($pattern_from, $pattern_to, $filename);

			if (file_exists($dir . $filename)) {
				rename($dir . $filename, $dir . $new_filename);
			}
		}

		$out = $this->sudo_ssh('ls -d ' . $dir . '/*' . $pattern_from . '* 2>/dev/null | awk \'{print $1}\'');

		foreach ($out as $value) {
			$filename = strrchr($value, '/');
			$new_filename = str_replace($pattern_from, $pattern_to, $filename);

			if (is_dir($dir . $filename)) {
				$this->rename_dir($dir . $filename, $dir . $new_filename);
			}
		}

		return 1;
	}

	public function load_cl()
	{
		global $lang;
		$dir = $GLOBALS['CLASSES_PATH'];
		$retval = array();

		if (substr($dir, -1) != '/') {
			$dir .= '/';
		}

		exit($lang['properties_cannot_open'] . ' ' . $dir . ' ' . $lang['properties_cannot_for_read']);
		($d = @dir($dir)) || true;

		while (false !== $entry = $d->read()) {
			if ($entry[0] == '.') {
				continue;
			}

			if (is_readable($dir . $entry)) {
				if (strripos($dir . $entry, '.php')) {
					$retval[] = $dir . $entry;
				}
			}
		}

		$d->close();

		foreach ($retval as $class) {
			require_once $class;
		}

		require_once '/etc/brainy/lib/punycode/idna_convert.php';
	}

	public function load()
	{
		global $lang;
		$dir = $GLOBALS['CLASSES_PATH'];
		$retval = array();

		if (substr($dir, -1) != '/') {
			$dir .= '/';
		}

		exit($lang['properties_cannot_open'] . ' ' . $dir . ' ' . $lang['properties_cannot_for_read']);
		($d = @dir($dir)) || true;

		while (false !== $entry = $d->read()) {
			if ($entry[0] == '.') {
				continue;
			}

			if (is_readable($dir . $entry)) {
				if (strripos($dir . $entry, '.php')) {
					$retval[] = $dir . $entry;
				}
			}
		}

		$d->close();

		foreach ($retval as $class) {
			require_once $class;
		}

		if (!isset($main_check_real_file_code)) {
			exit('License error!');
		}

		if ($this->main_check_real_file_code_lic_serv != $main_check_real_file_code) {
			exit('License error!');
		}

		$this->load_globals();
		require_once '/etc/brainy/lib/punycode/idna_convert.php';
	}

	public function load_includes()
	{
		global $lang;
		$dir = $GLOBALS['INCLUDES_PATH'];
		$retval = array();

		if (substr($dir, -1) != '/') {
			$dir .= '/';
		}

		exit($lang['properties_cannot_open'] . ' ' . $dir . ' ' . $lang['properties_cannot_for_read']);
		($d = @dir($dir)) || true;

		while (false !== $entry = $d->read()) {
			if ($entry[0] == '.') {
				continue;
			}

			if (is_readable($dir . $entry)) {
				if (strripos($dir . $entry, '.php')) {
					$retval[] = $dir . $entry;
				}
			}
		}

		$d->close();

		foreach ($retval as $include) {
			include_once $include;
		}
	}

	public function define()
	{
		if (!isset($_SERVER['SERVER_ADDR'])) {
			$_SERVER['SERVER_ADDR'] = 'localhost';
		}

		if (isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] == 'on')) {
			$this->deflink_noindex = 'https://' . $_SERVER['SERVER_ADDR'] . ':8000';
			$this->deflink = 'index.php';
		}
		else {
			$this->deflink_noindex = 'http://' . $_SERVER['SERVER_ADDR'] . ':8002';
			$this->deflink = 'index.php';
		}
	}

	public function lan_include($language)
	{
		global $lang;

		if (!file_exists($GLOBALS['LANGS_PATH'] . $language . '/')) {
			$language = 'ru';
		}

		$dir = $GLOBALS['LANGS_PATH'] . $language . '/';
		$lan = array();

		if (substr($dir, -1) != '/') {
			$dir .= '/';
		}

		exit($lang['properties_cannot_open'] . ' ' . $dir . ' ' . $lang['properties_cannot_for_read']);
		($d = @dir($dir)) || true;

		while (false !== $entry = $d->read()) {
			if ($entry[0] == '.') {
				continue;
			}

			if (is_readable($dir . $entry)) {
				if (strripos($dir . $entry, '.php')) {
					$retval[] = $dir . $entry;
				}
			}
		}

		foreach ($retval as $translation) {
			include_once $translation;
			$lan = array_merge($lan, $lang);
		}

		$lang = $lan;
		$this->lang = $lan;
	}

	public function locate($lang)
	{
		global $lang;
		$ini_file = $GLOBALS['CONF_PATH'] . 'brainy.ini';
		$config = parse_ini_file($ini_file, true);
		$dir_admin = $GLOBALS['MODULES_PATH'];
		$dir_client = $GLOBALS['CLIENT_MODULES_PATH'];
		$retval_admin = array();
		$retval_client = array();
		$retval_diff = array();
		$retval = array();

		if (substr($dir_admin, -1) != '/') {
			$dir_admin .= '/';
		}

		exit($lang['properties_cannot_open'] . ' ' . $dir_admin . ' ' . $lang['properties_cannot_for_read']);
		($d = @dir($dir_admin)) || true;

		while (false !== $entry = $d->read()) {
			if ($entry[0] == '.') {
				continue;
			}

			if (is_readable($dir_admin . $entry)) {
				if (strripos($dir_admin . $entry, '.php')) {
					$retval_admin[$dir_admin . $entry] = $entry;
				}
			}
		}

		$d->close();

		if (substr($dir_client, -1) != '/') {
			$dir_client .= '/';
		}

		exit($lang['properties_cannot_open'] . ' ' . $dir_client . ' ' . $lang['properties_cannot_for_read']);
		($d = @dir($dir_client)) || true;

		while (false !== $entry = $d->read()) {
			if ($entry[0] == '.') {
				continue;
			}

			if (is_readable($dir_client . $entry)) {
				if (strripos($dir_client . $entry, '.php')) {
					$retval_client[$dir_client . $entry] = $entry;
				}
			}
		}

		$d->close();
		$retval_diff = array_diff($retval_client, $retval_admin);
		$retval = array_merge($retval_admin, $retval_diff);
		$output = '';

		foreach ($retval as $module) {
			$do = explode('.php', $module);
			$do = $do[0];

			if ($_SESSION['lan'] == 'en') {
				$output .= '<a href="' . $this->deflink . '?do=' . $do . '">' . $lang[$do] . '</a></br>';
			}
			else {
				$output .= '<a href="' . $this->deflink . '?do=' . $do . '">' . $lang[$do] . '</a></br>';
			}
		}

		return $output;
	}

	public function check_auth()
	{
		$filea = '/etc/brainy/au.txt';
		session_start();
		session_regenerate_id();

		if (isset($_SESSION['username2']) && isset($_SESSION['pass2'])) {
			$login = $this->decryptmainfunc($_SESSION['username2'], $GLOBALS['cryptkeymain']);
			$password = $this->decryptmainfunc($_SESSION['pass2'], $GLOBALS['cryptkeymain']);
			$tryauth = $this->CheckPass_auth($login, $password);

			if ($tryauth == false) {
				session_unset();
				header('Location: ' . $this->deflink);
				exit();
			}
		}

		if (isset($_SESSION['user']) && isset($_SESSION['pass'])) {
			$mass = $this->config_read('/etc/brainy/data/properties/main');

			if (isset($mass['abort_root']) && ($mass['abort_root'] == 'yes') && ($_SESSION['user'] == 'root')) {
				session_unset();
				header('Location: ' . $this->deflink);
				exit();
			}

			$salt = crypt($_SESSION['user'], $_SESSION['user']);
			$id = $_SERVER['REMOTE_ADDR'] . $_SESSION['user'];
			$id = md5($id . $salt);

			if ($_SESSION['user'] == 'root') {
				$conf['username'] = 'root';
			}
			else {
				$conf = $this->config_read($GLOBALS['USERS_PATH'] . $_SESSION['user']);
			}

			$ip = crypt($_SERVER['REMOTE_ADDR'], $salt);
			if (($this->user['username'] == '') || !$this->user['username']) {
				$this->user['username'] = $_SESSION['user'];
			}

			$hostacc = new hostacc();
			$grouprights = $hostacc->hostacc_grouprights($this->user['group']);
			$this->user['group_properties'] = $grouprights;

			if ($this->user['username'] == 'root') {
				$this->user['group'] = 'admin';
				$this->user['group_properties']['root'] = 'y';
			}

			$this->user['name'] = $this->user['username'];
			$this->user['h_disk'] = round($this->user['disk'] / (1024 * 1024), 2);
			$this->user['h_bandwidth'] = round($this->user['bandwidth'] / (1024 * 1024), 2);
			$this->user['h_r_disk'] = round($this->user['r_disk'] / (1024 * 1024), 2);
			$this->user['h_traffic'] = round($this->user['traffic'] / (1024 * 1024), 2);
			$this->user['workspace'] = round($this->user['workspace'] / (1024 * 1024), 2);

			if ($_SESSION['pass'] != $id) {
				return 0;
			}

			if ($_SESSION['ip'] != $ip) {
				return 0;
			}

			if (($_SESSION['pass'] == $id) && ($_SESSION['ip'] == $ip)) {
				$this->user = $conf;
			}
		}
		else {
			return 0;
		}

		return 1;
	}

	public function CheckPass_auth($login, $pass)
	{
		$comm1 = 'sudo cat /etc/shadow | grep ^';
		$comm1 .= $login . ':';
		$res1 = exec($comm1, $retval);
		$shadow = explode('$', $res1);
		$encrypter = $shadow[1];
		$salt = $shadow[2];
		$passhash = explode(':', $shadow[3]);
		$passhash = $passhash[0];
		$comm2 = 'python -c \'import crypt; print crypt.crypt(';
		$comm2 .= '"';
		$comm2 .= $this->strip_doublequotes_cmd($this->escape_slash_echoe($this->strip_quotes_cmd_auth($pass)));
		$comm2 .= '", "$';
		$comm2 .= $encrypter;
		$comm2 .= '$';
		$comm2 .= $salt;
		$comm2 .= '")';
		$comm2 .= '\'';
		$res2 = exec($comm2, $retval);
		$res2 = explode('$', $res2);
		$res2 = $res2[3];
		if ((strlen($login) < 2) || (strlen($pass) < 2)) {
			return false;
		}

		if ((strlen($passhash) < 2) || (strlen($res2) < 2)) {
			return false;
		}

		if ($passhash == $res2) {
			return true;
		}

		return false;
	}

	public function auth()
	{
		$filea = '/etc/brainy/au.txt';
		session_start();
		session_regenerate_id();

		if (isset($_SESSION['username2']) && isset($_SESSION['pass2'])) {
			$login = $this->decryptmainfunc($_SESSION['username2'], $GLOBALS['cryptkeymain']);
			$password = $this->decryptmainfunc($_SESSION['pass2'], $GLOBALS['cryptkeymain']);
			$tryauth = $this->CheckPass_auth($login, $password);

			if ($tryauth == false) {
				session_unset();
				header('Location: ' . $this->deflink);
				exit();
			}
		}

		if (isset($_SESSION['user']) && isset($_SESSION['pass'])) {
			$salt = crypt($_SESSION['user'], $_SESSION['user']);
			$id = $_SERVER['REMOTE_ADDR'] . $_SESSION['user'];
			$id = md5($id . $salt);

			if ($_SESSION['user'] == 'root') {
				$conf['username'] = 'root';
			}
			else {
				$conf = $this->config_read($GLOBALS['USERS_PATH'] . $_SESSION['user']);
			}

			$ip = crypt($_SERVER['REMOTE_ADDR'], $salt);

			if ($_SESSION['pass'] != $id) {
				header('Location: ' . $this->deflink);
				exit();
			}

			if ($_SESSION['ip'] != $ip) {
				header('Location: ' . $this->deflink);
				exit();
			}

			if (($_SESSION['pass'] == $id) && ($_SESSION['ip'] == $ip)) {
				$this->user = $conf;
			}
		}
		else {
			header('Location: ' . $this->deflink);
			exit();
		}

		if (($this->user['username'] == '') || !$this->user['username']) {
			$this->user['username'] = $_SESSION['user'];
		}

		$hostacc = new hostacc();

		if (isset($this->user['group'])) {
			$grouprights = $hostacc->hostacc_grouprights($this->user['group']);
			$this->user['group_properties'] = $grouprights;
		}

		if ($this->user['username'] == 'root') {
			$this->user['group'] = 'admin';
			$this->user['group_properties']['root'] = 'y';
		}

		$this->user['name'] = $this->user['username'];

		if (isset($this->user['disk'])) {
			$this->user['h_disk'] = round($this->user['disk'] / (1024 * 1024), 2);
		}

		if (isset($this->user['bandwidth'])) {
			$this->user['h_bandwidth'] = round($this->user['bandwidth'] / (1024 * 1024), 2);
		}

		if (isset($this->user['r_disk'])) {
			$this->user['h_r_disk'] = round($this->user['r_disk'] / (1024 * 1024), 2);
		}

		if (isset($this->user['traffic'])) {
			$this->user['h_traffic'] = round($this->user['traffic'] / (1024 * 1024), 2);
		}
	}

	public function access()
	{
	}

	public function get_calling_function()
	{
		$caller = debug_backtrace();
		$caller = $caller[2];
		$r = $caller['function'] . '()';

		if (isset($caller['class'])) {
			$r .= ' in ' . $caller['class'];
		}

		if (isset($caller['object'])) {
			$r .= ' (' . get_class($caller['object']) . ')';
		}

		return $r;
	}

	public function ssh($comm)
	{
		file_put_contents('/etc/brainy/data/apacserver/logssh_' . date('Y.m.d') . '.txt', date('d.m.Y H:i:s') . '---' . $comm . ' --- FUNC: ' . $this->get_calling_function() . "\n", FILE_APPEND);
		exec($comm, $retval);
		return $retval;
	}

	public function sudo_ssh($comm, $cachetime = NULL)
	{
		$cachetime = intval($cachetime);

		if (0 < $cachetime) {
			if (file_exists('/etc/brainy/cache/' . $comm)) {
				$filetime = filemtime('/etc/brainy/cache/' . $comm);
			}
			else {
				$filetime = NULL;
			}

			$ch_time = time() - $filetime;

			if (($ch_time < $cachetime) && $filetime) {
				$retval = file_get_contents('/etc/brainy/cache/' . $comm);
				$retval = json_decode($retval);
			}
		}

		if (($cachetime == 0) || ($cachetime <= $ch_time) || !$filetime) {
			exec($comm, $retval);

			if (0 < $cachetime) {
				file_put_contents('/etc/brainy/cache/' . $comm, json_encode($retval));
			}
		}

		return $retval;
	}

	public function sudo_safe_ssh($comm)
	{
		exec(escapeshellcmd($comm), $retval);
		return $retval;
	}

	public function sudo_safe_ssh_dynamic($comm, $dynamic = NULL, $noquotes = 1)
	{
		if (is_array($dynamic)) {
			foreach ($dynamic as $key => $value) {
				$value = escapeshellcmd($value);

				if ($noquotes == 0) {
					$dynamic[$key] = '\'' . $value . '\'';
				}

				$to_replace[$key] = '#dynamic' . ($key + 1) . '#';
			}
		}
		else {
			$dynamic = escapeshellcmd($dynamic);

			if ($noquotes == 0) {
				$dynamic = '\'' . $dynamic . '\'';
			}

			$to_replace = '#dynamic#';
		}

		$comm = str_replace($to_replace, $dynamic, $comm);
		file_put_contents('/root/10', $comm);
		exec($comm, $retval);
		return $retval;
	}

	public function sudo_nohup($comm)
	{
		$comm = 'nohup ' . $comm;
		exec($comm, $retval);
		return $retval;
	}

	public function gen_pass($length)
	{
		$alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
		$pass = array();
		$alphaLength = strlen($alphabet) - 1;
		$i = 0;

		while ($i < $length) {
			$n = rand(0, $alphaLength);
			$pass[] = $alphabet[$n];
			++$i;
		}

		return implode($pass);
	}

	public function ssh_user($user, $comm)
	{
		global $lang;
		$ssh_user = 'sudo -i -u ' . $user . ' whoami';
		exec($ssh_user, $retval);

		if ($retval[0] == $user) {
			$ssh_user = 'sudo -i -u ' . $user . ' ' . $comm;
			unset($retval);
			exec($ssh_user, $retval);
			return $retval;
		}

		$retval = $lang['properties_no_user'] . ' "' . $user . '" ' . $lang['properties_in_unix'];
		return $retval;
	}

	public function create_stream($comm, $fileParam = NULL)
	{
		$this->check_auth();
		global $lang;

		if (is_array($comm)) {
			$comm[0]['userowner'] = $this->user['username'];
			$test_comm = urlencode(json_encode($comm));
		}
		else {
			$test_comm = $comm;
		}

		$curr_time = time();
		$dir = $GLOBALS['STREAMS_PATH'];

		if (substr($dir, -1) != '/') {
			$dir .= '/';
		}

		exit($lang['properties_cannot_open'] . ' ' . $dir . ' ' . $lang['properties_cannot_for_read']);
		($d = @dir($dir)) || true;

		while (false !== $entry = $d->read()) {
			if ($entry[0] == '.') {
				continue;
			}

			if (is_readable($dir . $entry)) {
				$change_time = filectime($dir . $entry);
				$change_time = $change_time + 60;

				if ($curr_time < $change_time) {
					$var_get = file($dir . $entry);
					$old_comm = array_shift($var_get);

					if (trim($test_comm) == trim($old_comm)) {
						$message = $lang['properties_in_too_fast'];
					}
				}
			}
		}

		if (empty($message)) {
			$path = debug_backtrace();

			if (2 < count($path)) {
				$place = $path[1];
			}
			else {
				$place = $path[0];
			}

			$file = explode('.', basename($place['file']));
			$file = $file[0];
			$func = $place['function'];

			if ($func == 'create_stream') {
				$func = $place['line'];
			}

			$time = time();
			$time .= mt_rand(10000, 99999);
			$name = $GLOBALS['STREAMS_PATH'] . $file . '_' . $func . '_' . $time;

			exit($lang['properties_no_open_file']);
			($stream_file = fopen($name, 'w')) || true;
			fclose($stream_file);

			if (is_array($comm)) {
				if (!isset($fileParam)) {
					$command = 'echo "' . urlencode(json_encode($comm)) . $name . '" >>' . $name;
					exec($command);
				}

				$arr_first = $comm[0]['array_start'];

				foreach ($arr_first as $keyfirst => $valfirst) {
					$arr_sec[$keyfirst] = str_replace('#stream_id#', basename($name), $valfirst);
				}

				$this->config_save('/etc/brainy/data/' . $file . '/main', $arr_sec, 'add');
				$chmod = 'chmod 755 /etc/brainy/src/compiled/php5/bin/php';
				exec($chmod);

				if (!isset($fileParam)) {
					$command = 'nohup /etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/child.php ' . urlencode(json_encode($comm)) . ' ' . $file . ' ' . $name . ' > /dev/null 2>/dev/null &';
				}
				else {
					$command = 'nohup /etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/child.php ' . urlencode(json_encode($fileParam)) . ' ' . $file . ' ' . $name . ' > /dev/null 2>/dev/null &';
				}

				exec($command);
			}
			else {
				$command = 'nohup ' . $comm . ' >> ' . $name . ' 2>>' . $name . ' &';
				shell_exec($command);
			}

			$name = basename($name);
			return $name;
		}

		return $message;
	}

	public function create_stream_online($comm, $module_name)
	{
		global $lang;

		if (is_array($comm)) {
			$test_comm = urlencode(json_encode($comm));
		}
		else {
			$test_comm = $comm;
		}

		$curr_time = time();
		$dir = $GLOBALS['STREAMS_PATH'];

		if (substr($dir, -1) != '/') {
			$dir .= '/';
		}

		exit($lang['properties_cannot_open'] . $dir . $lang['properties_cannot_for_read']);
		($d = @dir($dir)) || true;

		while (false !== $entry = $d->read()) {
			if ($entry[0] == '.') {
				continue;
			}

			if (is_readable($dir . $entry)) {
				$change_time = filectime($dir . $entry);
				$change_time = $change_time + 60;

				if ($curr_time < $change_time) {
					$varget = file($dir . $entry);
					$old_comm = array_shift($varget);

					if (trim($test_comm) == trim($old_comm)) {
						$message = $lang['properties_in_too_fast'];
					}
				}
			}
		}

		if (empty($message)) {
			$path = debug_backtrace();

			if (2 < count($path)) {
				$place = $path[1];
			}
			else {
				$place = $path[0];
			}

			$file = explode('.', basename($place['file']));
			$file = $file[0];
			$file = $module_name;
			$func = $place['function'];

			if ($func == 'create_stream') {
				$func = $place['line'];
			}

			$time = time();
			$time .= mt_rand(10000, 99999);
			$name = $GLOBALS['STREAMS_PATH'] . $file . '_' . $func . '_' . $time;

			exit($lang['properties_no_open_file']);
			($stream_file = fopen($name, 'w')) || true;
			fclose($stream_file);

			if (is_array($comm)) {
				$command = 'echo "' . urlencode(json_encode($comm)) . $name . '"';
				$o = $this->sudo_ssh($command);
				$arr_first = $comm[0]['array_start'];

				foreach ($arr_first as $keyfirst => $valfirst) {
					$arr_sec[$keyfirst] = str_replace('#stream_id#', basename($name), $valfirst);
				}

				$this->config_save('/etc/brainy/data/' . $file . '/main', $arr_sec, 'add');
				$chmod = 'chmod 755 /etc/brainy/src/compiled/php5/bin/php';
				$this->sudo_ssh($chmod);
				$command = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/scripts/child.php ' . urlencode(json_encode($comm)) . ' ' . $file . ' ' . $name;
				$this->sudo_ssh($command);
				echo file_get_contents($name);
			}
			else {
				$command = 'echo "' . $comm;
				exec($command);
				$command = $comm;
				$o = $this->sudo_ssh($command);
				echo implode('/n', $o);
			}

			$name = basename($name);
			return $name;
		}

		return $message;
	}

	public function read_stream($stream, $full = 0)
	{
		if (!empty($stream)) {
			$retval = file($GLOBALS['STREAMS_PATH'] . $stream);

			if ($full == 0) {
				unset($retval[0]);
			}
		}

		return $retval;
	}

	public function list_stream($all)
	{
		global $lang;
		$curr_time = time();
		$path = debug_backtrace();

		if (2 < count($path)) {
			$place = $path[1];
		}
		else {
			$place = $path[0];
		}

		$file = explode('.', basename($place['file']));
		$file = $file[0];
		$dir = $GLOBALS['STREAMS_PATH'];

		if (substr($dir, -1) != '/') {
			$dir .= '/';
		}

		exit($lang['properties_cannot_open'] . ' ' . $dir . ' ' . $lang['properties_cannot_for_read']);
		($d = @dir($dir)) || true;

		while (false !== $entry = $d->read()) {
			if ($entry[0] == '.') {
				continue;
			}

			if (is_readable($dir . $entry)) {
				if (strripos($dir . $entry, $file)) {
					if ($all == 1) {
						$retval[$dir . $entry]['id'] = $entry;
						$retval[$dir . $entry]['date'] = date('Y-m-d H:i:s', end(explode('_', $entry)));
					}
					else {
						$change_time = filectime($dir . $entry);
						$change_time = $change_time + 15;

						if ($curr_time < $change_time) {
							$retval[$dir . $entry] = $entry;
						}
					}
				}
			}
		}

		return $retval;
	}

	public function load_vars($file = NULL)
	{
		$dir = $GLOBALS['DATA_PATH'] . $_GET['do'];
		$dir .= '/';

		if (!empty($file)) {
			if (file_exists($dir . $file)) {
				$this->module_vars = parse_ini_file($dir . $file);
			}
		}
		else if (file_exists($dir . 'main')) {
			$this->module_vars = parse_ini_file($dir . 'main');
		}
	}

	public function request_vars($module_name, $file)
	{
		$dir = $GLOBALS['DATA_PATH'] . $module_name;
		$dir .= '/';

		if (!empty($file)) {
			$this->requested_vars = parse_ini_file($dir . $file);
		}
		else {
			$this->requested_vars = parse_ini_file($dir . 'main');
		}
	}

	public function debug($res)
	{
		if ($res == 0) {
			set_error_handler('user_log', 32767 & ~8);
		}
		else {
			restore_error_handler();
		}
	}

	public function set_data($arr, $file = NULL)
	{
		global $lang;
		$path = debug_backtrace();

		if (2 < count($path)) {
			$place = $path[1];
		}
		else {
			$place = $path[0];
		}

		$dir = explode('.', basename($place['file']));
		$dir = $dir[0];
		$dir = $GLOBALS['DATA_PATH'] . $_GET['do'];

		if (!$this->check_params('dir', $dir)) {
			return false;
		}

		$create_dir = 'mkdir -m 755 -p ' . $dir;
		exec($create_dir);

		if (empty($file)) {
			$file = $dir . '/main';
		}
		else {
			$file = $dir . '/' . $file;
		}

		if (is_file($file)) {
			$conf = parse_ini_file($file, true);
		}
		else {
			exit($lang['properties_no_open_file']);
			($stream_file = fopen($file, 'a+')) || true;
			fclose($stream_file);
			$conf = parse_ini_file($file, true);
		}

		if (!$this->check_params('file', $file)) {
			return false;
		}

		$comm = 'chmod 755 ' . $file;
		exec($comm);
		$new_conf = array_merge($conf, $arr);
		$res = array();

		foreach ($new_conf as $key => $val) {
			if (is_array($val)) {
				$res[] = '[' . $key . ']';

				foreach ($val as $skey => $sval) {
					$res[] = $skey . '=' . (is_numeric($sval) ? $sval : '"' . $sval . '"');
				}
			}
			else {
				$res[] = $key . '=' . (is_numeric($val) ? $val : '"' . $val . '"');
			}
		}

		$dataToSave = implode("\r\n", $res);

		if ($fp = fopen($file, 'w')) {
			$startTime = microtime(true);

			do {
				$canWrite = flock($fp, LOCK_EX);

				if (!$canWrite) {
					usleep(round(rand(0, 100) * 1000));
				}

			} while (!$canWrite && ((microtime(true) - $startTime) < 5));

			if ($canWrite) {
				fwrite($fp, $dataToSave);
				flock($fp, LOCK_UN);
			}

			fclose($fp);
		}
	}

	public function config_read($addr)
	{
		global $lang;

		if (is_file($addr)) {
			$conf = file_get_contents($addr);
			$res1 = preg_split('/\\r\\n|\\r|\\n/', trim($conf));
			$arr_param_ins = array();

			foreach ($res1 as $key1 => $val) {
				$mas_n = explode('=', $val, 2);
				$arr_param_ins[$mas_n[0]] = str_replace('"', '', $mas_n[1]);
			}

			return $arr_param_ins;
		}

		return false;
	}

	public function config_save_my($addr, $arr, $arg = 'add', $user = NULL)
	{
		if (!$this->check_params('dir', $addr)) {
			return false;
		}

		if (!$this->check_params('user', $user)) {
			return false;
		}

		$fp = fopen($addr, 'a+');
		flock($fp, LOCK_EX);
		$conf = parse_ini_file($addr);

		if (!empty($user)) {
			$comm = 'chown ' . $user . ':' . $user . ' ' . $addr;
			exec($comm);
		}

		$res = array();

		if ($arg == 'add') {
			$new = array_merge($conf, $arr);

			foreach ($new as $key => $val) {
				if (0 < strlen($key)) {
					if (is_array($val)) {
						$res[] = '[' . $key . ']';

						foreach ($val as $skey => $sval) {
							$res[] = $skey . '=' . (is_numeric($sval) ? $sval : '' . $sval . '');
						}
					}
					else {
						$val_escape = str_replace('"', '\\"', $val);
						$res[] = $key . '=' . (is_numeric($val) ? $val : '"' . $val_escape . '"');
					}
				}
			}
		}
		else {
			foreach ($arr as $key => $val) {
				if (0 < strlen($key)) {
					if (is_array($val)) {
						$res[] = '[' . $key . ']';

						foreach ($val as $skey => $sval) {
							$res[] = $skey . '=' . (is_numeric($sval) ? $sval : '' . $sval . '');
						}
					}
					else {
						$res[] = $key . '=' . (is_numeric($val) ? $val : '' . $val . '');
					}
				}
			}
		}

		ftruncate($fp, 0);
		fwrite($fp, implode("\r\n", $res));
		fflush($fp);
		flock($fp, LOCK_UN);
		fclose($fp);
		return $res;
	}

	public function config_save($addr, $arr, $arg = 'add', $user = NULL)
	{
		if (!$this->check_params('dir', $addr)) {
			return false;
		}

		if (!$this->check_params('user', $user)) {
			return false;
		}

		$fp = fopen($addr, 'a+');
		flock($fp, LOCK_EX);
		$cur = parse_ini_file($addr);
		$conf = $cur;

		if (!empty($user)) {
			$comm = 'chown ' . $user . ':' . $user . ' ' . $addr;
			exec($comm);
		}

		if ($arg == 'add') {
			if (!is_array($conf)) {
				$conf = array();
			}

			if (!is_array($arr)) {
				$arr = array();
			}

			$new = array_merge($conf, $arr);

			foreach ($new as $key => $val) {
				if (0 < strlen($key)) {
					if (is_array($val)) {
						$res[] = '[' . $key . ']';

						foreach ($val as $skey => $sval) {
							$res[] = $skey . '=' . (is_numeric($sval) ? $sval : '' . $sval . '');
						}
					}
					else {
						$val_escape = str_replace('"', '\\"', $val);
						$res[] = $key . '=' . (is_numeric($val) ? $val : '"' . $val_escape . '"');
					}
				}
			}

			if (!is_array($res)) {
				$res = array();
			}
		}
		else {
			foreach ($arr as $key => $val) {
				if (0 < strlen($key)) {
					if (is_array($val)) {
						$res[] = '[' . $key . ']';

						foreach ($val as $skey => $sval) {
							$res[] = $skey . '=' . (is_numeric($sval) ? $sval : '' . $sval . '');
						}
					}
					else {
						$res[] = $key . '=' . (is_numeric($val) ? $val : '' . $val . '');
					}
				}
			}
		}

		ftruncate($fp, 0);
		fwrite($fp, implode("\r\n", $res));
		fflush($fp);
		flock($fp, LOCK_UN);
		fclose($fp);
		return $res;
	}

	public function parse_config_read($addr, $mass, $del, $comm)
	{
		$result = array();
		$conf_common = file($addr);

		foreach ($conf_common as $conf_string) {
			if (in_array($conf_string[0], $comm)) {
				continue;
			}

			$conf_exp = explode($del, $conf_string);
			$param = trim($conf_exp[0]);
			$value = trim($conf_exp[1]);

			if (in_array($value, $mass)) {
				$result[$value][] = $param;
			}
		}

		return $result;
	}

	public function parse_config_read_param($addr, $mass, $del, $comm, $delquota = NULL)
	{
		$result = array();
		$conf_common = file($addr);

		foreach ($conf_common as $conf_string) {
			if (in_array($conf_string[0], $comm)) {
				continue;
			}

			$conf_exp = explode($del, $conf_string, 2);

			if (count($conf_exp) < 2) {
				if ($del == ' ') {
					$conf_exp = explode("\t", $conf_string, 2);
				}
			}

			$param = trim($conf_exp[0]);
			$value = trim(array_pop($conf_exp));

			if (in_array($param, $mass)) {
				if ($delquota == 1) {
					$value = trim($value, '"');
				}

				$result[$param] = $value;
			}
		}

		return $result;
	}

	public function parse_config_save($addr, $mass, $del, $comm)
	{
		$keys = array_keys($mass);
		$fp = fopen($addr, 'a+');
		flock($fp, LOCK_EX);
		$conf_common = file($addr);
		$i = 0;

		while ($i < count($conf_common)) {
			$conf_current = $conf_common[$i];

			if (in_array($conf_current[0], $comm)) {
				continue;
			}

			$conf_exp = explode($del, $conf_current);
			$param = $conf_exp[0];
			$value = $conf_exp[1];

			if (in_array($param, $keys)) {
				$conf_current = $param;
				$conf_current .= $del;
				$conf_current .= $mass[$param];
				$conf_current .= PHP_EOL;
				$conf_common[$i] = $conf_current;
			}

			$conf_common[$i] = $conf_current;
			++$i;
		}

		$dataToSave = implode('', $conf_common);
		ftruncate($fp, 0);
		fwrite($fp, $dataToSave);
		fflush($fp);
		flock($fp, LOCK_UN);
		fclose($fp);
	}

	public function parse_config_save_uncomm($addr, $mass, $del, $comm)
	{
		$keys = array_keys($mass);
		$conf_common = file($addr);
		$i = 0;

		while ($i < count($conf_common)) {
			$conf_current = trim($conf_common[$i]);

			if (in_array($conf_current[0], $comm)) {
				$conf_brute = substr($conf_current, 1);
				$conf_clean = trim($conf_brute);
				$arr_clean = explode($del, $conf_clean);
				$param_test = $arr_clean[0];
				$value_test = $arr_clean[1];

				if (in_array($param, $keys)) {
					$conf_current = substr($conf_current, 1);
					$conf_current = trim($conf_current);
				}
				else {
					continue;
				}
			}

			$conf_exp = explode($del, $conf_current);
			$param = $conf_exp[0];
			$value = $conf_exp[1];

			if (in_array($param, $keys)) {
				$conf_current = $param;
				$conf_current .= $del;
				$conf_current .= $mass[$param];
				$conf_common[$i] = trim($conf_current);
			}

			$conf_common[$i] = trim($conf_current);
			++$i;
		}

		$dataToSave = implode(PHP_EOL, $conf_common);

		if ($fp = fopen($addr, 'w')) {
			$startTime = microtime(true);

			do {
				$canWrite = flock($fp, LOCK_EX);

				if (!$canWrite) {
					usleep(round(rand(0, 100) * 1000));
				}

			} while (!$canWrite && ((microtime(true) - $startTime) < 5));

			if ($canWrite) {
				fwrite($fp, $dataToSave);
				flock($fp, LOCK_UN);
			}

			fclose($fp);
		}
	}

	public function parse_config_save_phpini($addr, $mass, $del)
	{
		if (!$this->check_params('dir', $addr)) {
			return false;
		}

		$data = $mass;

		foreach ($data as $key => $value) {
			if (($value == 'Array') || ($value == ' ') || ($value == '')) {
				$str[] = ';' . trim($key . $del);
			}
			else {
				$str[] = $key . $del . $value;
			}

			$search[] = trim($key . $del);
		}

		$i = 0;

		while ($i < count($str)) {
			$num = $this->sudo_ssh('cat ' . $addr . ' | sed -n \'/' . $search[$i] . '/{=}\'');
			$numbers[] = $num;

			if (is_array($num)) {
				foreach ($num as $number) {
					$this->sudo_ssh('sed -i "' . $number . 's@.*@@g" ' . $addr);
				}

				$number = array_pop($num);
				$this->sudo_ssh('sed -i ' . $number . 'd ' . $addr);
				$this->sudo_ssh('sed -i ' . $number . 'i\'' . $str[$i] . '\' ' . $addr);
			}
			else {
				$this->sudo_ssh('sed -i \'' . $num . 's/.*/\\\'' . $str[$i] . '\\\'/\' ' . $addr);
			}

			++$i;
		}

		return $str;
	}

	public function read_file($file)
	{
		if (is_file($file)) {
			$a = file_get_contents($file);
		}

		return $a;
	}

	public function read_file_n($file, $entry = NULL)
	{
		if (is_file($file)) {
			$a = file($file);

			if (!empty($entry)) {
				foreach ($a as $str) {
					$pos = strripos($str, $entry);

					if ($pos === false) {
					}
					else {
						$res[] = $str;
					}
				}

				return $res;
			}

			return $a;
		}
	}

	public function del_string_from_file($file, $arrdata)
	{
		$strings = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($file));

		foreach ($strings as $key => $curitem) {
			$q = 1;

			foreach ($arrdata as $curfind) {
				$q = 0;
				break;
			}

			if ($q == 1) {
				unset($strings[$key]);
			}
		}

		file_put_contents($file, '');

		foreach ($strings as $key => $curitem) {
			if (1 < strlen($curitem)) {
				file_put_contents($file, $curitem . "\n", FILE_APPEND);
			}
		}
	}

	public function del_strings_between_str($firststr, $laststr, $file)
	{
		$firststr = str_replace('/', '\\/', $firststr);
		$laststr = str_replace('/', '\\/', $laststr);
		$firststr = str_replace('&', '\\&', $firststr);
		$laststr = str_replace('&', '\\&', $laststr);
		$firststr = str_replace('?', '\\?', $firststr);
		$laststr = str_replace('?', '\\?', $laststr);
		$firststr = str_replace('?', '\\*', $firststr);
		$laststr = str_replace('?', '\\*', $laststr);
		$comm = 'awk "/' . $firststr . '/ {print NR} " ' . $file;
		$firstline = $this->ssh($comm)[0];
		$comm = 'awk "/' . $laststr . '/ {print NR} " ' . $file;
		$lastline = $this->ssh($comm)[0];
		$comm = 'sed -i "' . $firstline . ',' . $lastline . 'd" ' . $file;
		$res = $this->ssh($comm);
		return $firststr;
	}

	public function del_string_new($entry, $file)
	{
		if (!$this->check_params('dir', $file)) {
			return false;
		}

		if (is_file($file)) {
			$fh = fopen($file, 'r');
			flock($fh, LOCK_EX | LOCK_SH);
			$ssh_open = 'chmod 777 ' . $file;
			exec($ssh_open);
			$ssh_close = 'chmod 644 ' . $file;
			exec($ssh_close);
			$entry = str_replace('/', '\\/', $entry);
			$entry = str_replace('*', '\\*', $entry);
			$comm = 'sed -i "/' . $entry . '/ d" ' . $file;
			$sudo_comm = $comm;
			exec($sudo_comm);
			$ssh_open = 'chmod 777 ' . $file;
			exec($ssh_open);
			$ssh_close = 'chmod 644 ' . $file;
			exec($ssh_close);

			if (0 < filesize($file)) {
				$a = fread($fh, filesize($file));
			}

			fclose($fh);
		}

		return $a;
	}

	public function del_string($entry, $file)
	{
		if (!$this->check_params('dir', $file)) {
			return false;
		}

		$entry = $this->strip_quotes_cmd($entry);

		if (is_file($file)) {
			$ssh_open = 'chmod 777 ' . $file;
			exec($ssh_open);
			$ssh_close = 'chmod 644 ' . $file;
			exec($ssh_close);
			$comm = 'sed -i "/^' . $entry . '/ d" ' . $file;
			$sudo_comm = $comm;
			exec($sudo_comm);
			$ssh_open = 'chmod 777 ' . $file;
			exec($ssh_open);
			$ssh_close = 'chmod 644 ' . $file;
			exec($ssh_close);
			$fh = fopen($file, 'r');
			$a = fread($fh, filesize($file));
			fclose($fh);
		}

		return $a;
	}

	public function del_string_n($num, $file)
	{
		$num = intval($num);

		if (!$this->check_params('dir', $file)) {
			return false;
		}

		if (is_file($file)) {
			$ssh_open = 'chmod 777 ' . $file;
			exec($ssh_open);
			++$num;
			$comm = 'sed -i ' . $num . 'd ' . $file;
			$sudo_comm = $comm;
			exec($sudo_comm);
			$ssh_close = 'chmod 644 ' . $file;
			exec($ssh_close);
			$fh = fopen($file, 'r');
			$a = fread($fh, filesize($file));
			fclose($fh);
		}

		return $a;
	}

	public function write_file($entry, $file, $param = NULL, $user = NULL, $unsafe = 0)
	{
		if (!$this->check_params('dir', $file)) {
			return false;
		}

		if (!$this->check_params('user', $user)) {
			return false;
		}

		if (!is_file($file)) {
			$ssh_touch = 'touch ' . $file;
			exec($ssh_touch);
		}

		$fh = fopen($file, 'r');
		flock($fh, LOCK_EX | LOCK_SH);
		$ssh_open = 'chmod 777 ' . $file;
		exec($ssh_open);

		if (!empty($user)) {
			$ssh_user = 'sudo -S -u ' . $user . ' whoami';
			exec($ssh_user, $retval);

			if ($retval[0] == $user) {
				$ssh_user = 'chown ' . $user . ':' . $user . ' ' . $file;
				exec($ssh_user);
			}
		}

		if (0 < filesize($file)) {
			$a = fread($fh, filesize($file));
		}

		if ($param == 'wb') {
			$entry = $entry . trim($a);
		}

		if ($param == 'wa') {
			$entry = trim($a) . PHP_EOL . $entry;
		}

		file_put_contents($file, $entry, LOCK_EX);
		$ssh_close = 'chmod 644 ' . $file;
		exec($ssh_close);

		if (0 < filesize($file)) {
			$a = fread($fh, filesize($file));
		}

		fclose($fh);
		return $a;
	}

	public function write_file_clean($entry, $file, $param, $user)
	{
		$entry = $this->strip_quotes_cmd($entry);

		if (!$this->check_params('dir', $file)) {
			return false;
		}

		if (!$this->check_params('user', $user)) {
			return false;
		}

		if (!is_file($file)) {
			$ssh_touch = 'touch ' . $file;
			exec($ssh_touch);
		}

		$ssh_open = 'chmod 777 ' . $file;
		exec($ssh_open);

		if (!empty($user)) {
			$ssh_user = 'sudo -S -u ' . $user . ' whoami';
			exec($ssh_user, $retval);

			if ($retval[0] == $user) {
				$ssh_user = 'chown ' . $user . ':' . $user . ' ' . $file;
				exec($ssh_user);
			}
		}

		$fh = fopen($file, 'r');
		$a = fread($fh, filesize($file));
		fclose($fh);
		clearstatcache();

		if ($param == 'wb') {
			$entry = $entry . trim($a);
		}

		if ($param == 'wa') {
			$entry = trim($a) . $entry;
		}

		$entry = trim($entry);
		$comm = 'echo \'' . $entry . '\' >' . $file;
		$sudo_comm = $comm;
		exec($sudo_comm);
		$ssh_close = 'chmod 644 ' . $file;
		exec($ssh_close);
		$fh = fopen($file, 'r');
		$a = fread($fh, filesize($file));
		fclose($fh);
		clearstatcache();
		return $a;
	}

	public function user_dir($user)
	{
		global $lang;

		if (is_file($GLOBALS['USERS_PATH'] . $user)) {
			$conf = parse_ini_file($GLOBALS['USERS_PATH'] . $user);
			$ans = $conf['basedir'] . $user;
		}
		else {
			$ans = $lang['properties_no_user'] . ' ' . $user;
		}

		return $ans;
	}

	public function get_users()
	{
		$ans = array();

		if ($handle = opendir($GLOBALS['USERS_PATH'])) {
			while (false !== $file = readdir($handle)) {
				if (($file != '.') && ($file != '..') && ($file != 'root')) {
					$ans[] = $file;
				}
			}

			closedir($handle);
		}

		sort($ans);
		return $ans;
	}

	public function check_user($user)
	{
		$users = $this->get_users();
		if (($user == 'root') || in_array($user, $users)) {
			return '1';
		}

		return '0';
	}

	public function insert_string_n($num, $entry, $file)
	{
		if (!$this->check_params('dir', $file)) {
			return false;
		}

		$num = intval($num);
		$entry = $this->strip_quotes_cmd($entry);

		if (is_file($file)) {
			$ssh_open = 'chmod 777 ' . $file;
			exec($ssh_open);
			++$num;
			$comm = 'sed -i ' . $num . 'i' . $entry . ' ' . $file;
			$sudo_comm = $comm;
			exec($sudo_comm);
			$ssh_close = 'chmod 644 ' . $file;
			exec($ssh_close);
			$fh = fopen($file, 'r');
			$a = fread($fh, filesize($file));
			fclose($fh);
		}

		return $a;
	}

	public function insert_before_string($searchstring, $inserting, $file)
	{
		if (is_file($file)) {
			$searchstring = str_replace('&', '\\&', $searchstring);
			$searchstring = str_replace('/', '\\/', $searchstring);
			$inserting = str_replace('&', '\\&', $inserting);
			$inserting = str_replace('/', '\\/', $inserting);
			$inserting = str_replace("\n", '\\' . "\n", $inserting);
			$comm = 'sed -i \'/' . $searchstring . '/ i \\ ' . $inserting . '\' ' . $file;
			$this->ssh($comm);
		}
	}

	public function replace_string_n($num, $entry, $file)
	{
		if (!$this->check_params('dir', $file)) {
			return false;
		}

		$entry = $this->strip_quotes_cmd($entry);
		$num = intval($num);

		if (is_file($file)) {
			$ssh_open = 'chmod 777 ' . $file;
			exec($ssh_open);
			++$num;
			$comm = 'sed -i \'' . $num . 's/.*/' . $entry . '/\' ' . $file;
			$comm = str_replace('&', '\\&', $comm);
			$sudo_comm = $comm;
			exec($sudo_comm);
			$ssh_close = 'chmod 644 ' . $file;
			exec($ssh_close);
			$fh = fopen($file, 'r');
			$a = fread($fh, filesize($file));
			fclose($fh);
		}

		return $a;
	}

	public function get_stat($path)
	{
		if (!$this->check_params('dir', $path)) {
			return false;
		}

		$a = array();
		$comm = 'stat -c \'%U\' ' . $path;
		$a['own'] = exec($comm, $retval);
		$comm = 'stat -c \'%a\' ' . $path;
		$a['mod'] = exec($comm, $retval);
		return $a;
	}

	public function set_stat($path, $own, $mod)
	{
		if (!$this->check_params('dir', $path)) {
			return false;
		}

		if (!$this->check_params('user', $own)) {
			return false;
		}

		$mod = intval($mod);

		if (!empty($own)) {
			$comm = 'chown ' . $own . ' ' . $path;
			exec($comm);
		}

		if (!empty($mod)) {
			$comm = 'chmod ' . $mod . ' ' . $path;
			exec($comm);
		}
	}

	public function filelist($path, $pattern = NULL, $type = NULL)
	{
		if (!$this->check_params('dir', $path)) {
			return false;
		}

		global $lang;
		$res = array();

		if ($handle = opendir($path)) {
			if (substr($path, -1) != '/') {
				$path .= '/';
			}

			if ($type == 'f') {
				while (false !== $file = readdir($handle)) {
					if ($file[0] == '.') {
						continue;
					}

					if (is_file($path . $file)) {
						$res[] = $file;
					}
				}
			}
			else if ($type == 'd') {
				while (false !== $file = readdir($handle)) {
					if ($file[0] == '.') {
						continue;
					}

					if (!is_file($path . $file)) {
						$res[] = $file;
					}
				}
			}
			else {
				while (false !== $file = readdir($handle)) {
					if ($file[0] == '.') {
						continue;
					}

					$res[] = $file;
				}
			}

			closedir($handle);
		}

		if (($pattern == '*') || empty($pattern)) {
			return $res;
		}

		$pos = strripos($pattern, '!');

		if ($pos === false) {
			$pos = strripos($pattern, '*');

			if ($pos === false) {
				$res = $lang['properties_no_template'];
				return $res;
			}

			$place = explode('*', $pattern);

			if (empty($place[0])) {
				$i = 0;

				while ($i < count($res)) {
					if (substr($res[$i], -strlen($place[1])) != $place[1]) {
						$res[$i] = '';
					}

					++$i;
				}
			}
			else if (empty($place[1])) {
				$i = 0;

				while ($i < count($res)) {
					if (mb_substr($res[$i], 0, strlen($place[0])) != $place[0]) {
						$res[$i] = '';
					}

					++$i;
				}
			}
			else {
				$res = $lang['properties_no_template'];
				return $res;
			}
		}
		else {
			return $res;
			$pattern = str_replace('!', '', $pattern);
			$pos = strripos($pattern, '*');

			if ($pos === false) {
				$res = $lang['properties_no_template'];
				return $res;
			}

			$place = explode('*', $pattern);

			if (empty($place[1])) {
				$i = 0;

				while ($i < count($res)) {
					if (substr($res[$i], -strlen($place[1])) != $place[1]) {
					}
					else {
						$res[$i] = '';
					}

					++$i;
				}
			}
			else if (empty($place[0])) {
				$i = 0;

				while ($i < count($res)) {
					if (substr($res[$i], -strlen($place[1])) != $place[1]) {
					}
					else {
						$res[$i] = '';
					}

					++$i;
				}
			}
			else {
				$res = $lang['properties_no_template'];
				return $res;
			}
		}

		$res = array_diff($res, array(''));
		sort($res);
		return $res;
	}

	public function arraySep2dim($in, $separator)
	{
		$result = array();

		foreach ($in as $key => $value) {
			$ptr = &$result;

			foreach (explode($separator, $key) as $token) {
				$ptr = &$ptr[$token];
			}

			$ptr = (is_array($value) ? $this->arraySep2dim($value, $separator) : $value);
		}

		return $result;
	}

	public function new_filelist($path, $pattern, $type = NULL, $depth = NULL)
	{
		$namepart = '';

		if (!$this->check_params('dir', $path)) {
			return false;
		}

		if (!$this->check_params('string', $type)) {
			return false;
		}

		$depth = intval($depth);

		if (substr($path, -1) != '/') {
			$path .= '/';
		}

		$pos = strripos($pattern, '!');

		if ($pos === false) {
			$comm = 'find ' . $path;

			if (!empty($depth)) {
				$comm .= ' -maxdepth ' . $depth;
			}
			else {
				$depth = 1;
				$comm .= ' -maxdepth ' . $depth;
			}

			if (!empty($type)) {
				$comm .= ' -type ' . $type;
			}

			$comm .= ' -name "' . $pattern . '"';
			$ans = $this->sudo_ssh($comm);
			$n = 0;

			foreach ($ans as $str) {
				$str = str_replace($path, '', $str);
				$exp = explode('/', $str);
				$pop = array_pop($exp);
				$pars = trim(implode('/', $exp));
				$list[$n]['path'] = '/' . $pars . '/' . $pop;
				$list[$n]['path'] = str_replace('//', '/', $list[$n]['path']);
				$list[$n]['name'] = str_replace('/', '', $pop);
				$res[$pars . '/'][] = $pop;
				++$n;
			}

			$ret = $this->arraySep2dim($res, '/');
			$output['three'] = $ret;
			$output['list'] = $list;
		}
		else {
			$comm = 'find ' . $path;

			if (!empty($depth)) {
				$comm .= ' -maxdepth ' . $depth;
			}
			else {
				$depth = 1;
				$comm .= ' -maxdepth ' . $depth;
			}

			if (!empty($type)) {
				$comm .= ' -type ' . $type;
			}

			$ans0 = $this->sudo_ssh($comm);
			$pattern = str_replace('!', '', $pattern);
			$len = count($pattern);
			$array[$len] = array($array[$len], $array[0])[1];
			$array[0] = array($array[$len], $array[0])[0];
			$namepart .= ' -name "' . $pattern . '"';
			$comm .= $namepart;
			$ans1 = $this->sudo_ssh($comm);
			$ans = array_diff($ans0, $ans1);
			$n = 0;

			foreach ($ans as $str) {
				$str = str_replace($path, '', $str);
				$exp = explode('/', $str);
				$pop = array_pop($exp);
				$pars = trim(implode('/', $exp));
				$list[$n]['path'] = '/' . $pars . '/' . $pop;
				$list[$n]['path'] = str_replace('//', '/', $list[$n]['path']);
				$list[$n]['name'] = str_replace('/', '', $pop);
				$res[$pars . '/'][] = $pop;
				++$n;
			}

			$ret = $this->arraySep2dim($res, '/');
			$output['three'] = $ret;
			$output['list'] = $list;
		}

		return $output;
	}

	public function rename_file_m($oldname, $newname, $user)
	{
		if (!$this->check_params('dir', $oldname)) {
			return false;
		}

		if (!$this->check_params('dir', $newname)) {
			return false;
		}

		if (!$this->check_params('user', $user)) {
			return false;
		}

		$dir = $GLOBALS['DATA_PATH'] . $_GET['do'];

		if (is_file($dir . '/' . $oldname)) {
			$comm = 'mv ' . $dir . '/' . $oldname . ' ' . $dir . '/' . $newname;
			exec($comm);
		}
		else {
			$comm = 'touch ' . $dir . '/' . $newname;
			exec($comm);
		}

		if (!empty($user)) {
			$comm = 'chown ' . $user . ':' . $user . ' ' . $newname;
			exec($comm);
		}
	}

	public function remove_file_m($name)
	{
		if (!$this->check_params('dir', $name)) {
			return false;
		}

		$dir = $GLOBALS['DATA_PATH'] . $_GET['do'];

		if (is_file($dir . '/' . $name)) {
			$comm = 'rm -f ' . $dir . '/' . $name;
			exec($comm);
		}
	}

	public function load_vars_m($file = NULL)
	{
		$dir = $GLOBALS['DATA_PATH'] . $_GET['do'];
		$dir .= '/';

		if (!empty($file)) {
			$module_vars = parse_ini_file($dir . $file);
		}
		else {
			$module_vars = parse_ini_file($dir . 'main');
		}

		return $module_vars;
	}

	public function request_vars_m($module_name, $file)
	{
		$dir = $GLOBALS['DATA_PATH'] . $module_name;
		$dir .= '/';

		if (!empty($file)) {
			if (is_file($dir . $file)) {
				$requested_vars = parse_ini_file($dir . $file);
			}
		}
		else {
			$requested_vars = parse_ini_file($dir . 'main');
		}

		return $requested_vars;
	}

	public function rename_file_a($oldpath, $newpath, $user)
	{
		if (!$this->check_params('dir', $oldpath)) {
			return false;
		}

		if (!$this->check_params('dir', $newpath)) {
			return false;
		}

		if (!$this->check_params('user', $user)) {
			return false;
		}

		if (is_file($oldpath)) {
			$comm = 'mv ' . $oldpath . ' ' . $newpath;
			exec($comm);
		}
		else {
			$comm = 'touch ' . $newpath;
			exec($comm);
		}

		if (!empty($user)) {
			$comm = 'chown ' . $user . ':' . $user . ' ' . $newpath;
			exec($comm);
		}
	}

	public function remove_file_a($path)
	{
		if (!$this->check_params('dir', $path)) {
			return false;
		}

		if (is_file($path)) {
			$comm = 'rm -f ' . $path;
			exec($comm);
		}
	}

	public function rename_dir($oldpath, $newpath, $user = NULL)
	{
		if (!$this->check_params('dir', $oldpath)) {
			return false;
		}

		if (!$this->check_params('dir', $newpath)) {
			return false;
		}

		if (file_exists($oldpath)) {
			$comm = 'mv ' . $oldpath . ' ' . $newpath;
			$out = $this->sudo_ssh($comm);
		}
		else {
			$comm = 'mkdir ' . $newpath;
			$out = $this->sudo_ssh($comm);
		}

		if (!empty($user)) {
			$comm = 'chown ' . $user . ':' . $user . ' ' . $newpath;
			$this->sudo_ssh($comm);
		}
	}

	public function remove_dir($path)
	{
		if (!$this->check_params('dir', $path)) {
			return false;
		}

		if (is_file($path)) {
			$comm = 'rm -rf ' . $path;
			exec($comm);
		}
	}

	public function get_user_data($user)
	{
		if (!$this->check_params('user', $user)) {
			return false;
		}

		global $lang;

		if (is_file($GLOBALS['USERS_PATH'] . $user)) {
			$res = parse_ini_file($GLOBALS['USERS_PATH'] . $user, true);
		}
		else {
			$res = $lang['properties_no_data_user'] . ' ' . $user . '!';
		}

		return $res;
	}

	public function to_brainy_log($message)
	{
		$message = $this->strip_quotes_cmd($message);

		if (!is_file($GLOBALS['BRAINY_LOG_PATH'])) {
			$comm = 'touch ' . $GLOBALS['BRAINY_LOG_PATH'];
			exec($comm);
		}

		$time = time();
		$comm = 'echo \'' . $time . ' ' . $message . '\' >>' . $GLOBALS['BRAINY_LOG_PATH'];
		exec($comm);
	}

	public function safe_b64encode($string)
	{
		$data = base64_encode($string);
		$data = str_replace(array('+', '/', '='), array('-', '_', ''), $data);
		return $data;
	}

	public function safe_b64decode($string)
	{
		$data = str_replace(array('-', '_'), array('+', '/'), $string);
		$mod4 = strlen($data) % 4;

		if ($mod4) {
			$data .= substr('====', $mod4);
		}

		return base64_decode($data);
	}

	public function cryptmainfunc($value, $key)
	{
		if (!$value) {
			return false;
		}

		$text = $value;
		$iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
		$iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
		$crypttext = mcrypt_encrypt(MCRYPT_RIJNDAEL_256, $key, $text, MCRYPT_MODE_ECB, $iv);
		return trim($this->safe_b64encode($crypttext));
	}

	public function decryptmainfunc($value, $key)
	{
		if (!$value) {
			return false;
		}

		$crypttext = $this->safe_b64decode($value);
		$iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
		$iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
		$decrypttext = mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $key, $crypttext, MCRYPT_MODE_ECB, $iv);
		return trim($decrypttext);
	}

	public function set_server_email($email)
	{
		global $lang;
		$out['mess'] = $lang['properties_server_email_fail'];

		if (!$this->check_params('email', $email)) {
			return $out['mess'];
		}

		$arr = array('server_email' => $email);
		$this->config_save('/etc/brainy/data/properties/main', $arr);

		if ($email) {
			$email_set = 'root: ' . $email;
		}
		else {
			$email_set = '#root: ' . $email;
		}

		$this->ssh('sed -i "/root:/c' . $email_set . '" /etc/aliases');
		$out['mess'] = $lang['properties_server_email_success'];
		return $out['mess'];
	}

	public function get_server_email()
	{
		$mass = $this->config_read('/etc/brainy/data/properties/main');
		$out['server_email'] = $mass['server_email'];

		if (!$out['server_email']) {
			$out['server_email'] = 'root@' . gethostname();
		}

		return $out['server_email'];
	}

	public function detectVersionNginxB()
	{
		$pathConfNginxB = '/etc/nginxb/';

		if (!is_file('/etc/nginxb/nginx.conf')) {
			$pathConfNginxB = '/etc/brainy/src/compiled/nginxb/';
		}

		return $pathConfNginxB;
	}

	public function set_server_port($port)
	{
		global $lang;
		$mess = $lang['properties_server_port_error'];
		if (preg_match('/^\\+?\\d+$/', $port) && ((int) $port < 65000) && (90 < (int) $port)) {
			$arr = $this->server_ports_list_active();
			$key = (string) array_search($port, $arr);

			if ($key == '') {
				$this->ssh('sed -i \'s/listen .*/listen ' . $port . '\\;/\' ' . $this->detectVersionNginxB() . 'sites-available/brainy.conf');
				$ip = trim(implode("\n", $this->ssh('hostname -I')));
				$mess = $lang['properties_server_port_ok'] . ' http://' . $ip . ':' . $port;
				$webpanel = $this->get_webpanel();

				if ($webpanel) {
					$webserver = new webserver();
					$webserver->webserver_convert_domain($webpanel);
				}

				$this->ssh('systemctl restart nginxb');
			}
			else {
				return $lang['properties_server_port_busy'];
			}
		}

		return $mess;
	}

	public function set_server_portssl($port)
	{
		global $lang;
		$mess = $lang['properties_server_port_error'];
		if (preg_match('/^\\+?\\d+$/', $port) && ((int) $port < 65000) && (90 < (int) $port)) {
			$arr = $this->server_ports_list_active();
			$key = (string) array_search($port, $arr);

			if ($key == '') {
				$this->ssh('sed -i \'s/listen .*/listen ' . $port . ' ssl http2\\;/\' ' . $this->detectVersionNginxB() . 'sites-available/brainyssl.conf');
				$ip = trim(implode("\n", $this->ssh('hostname -I')));
				$mess = $lang['properties_server_port_ok'] . ' https://' . $ip . ':' . $port;
				$this->ssh('systemctl restart nginxb');
			}
			else {
				return $lang['properties_server_port_busy'];
			}
		}

		return $mess;
	}

	public function get_server_port()
	{
		$str = trim(implode("\n", $this->ssh('cat ' . $this->detectVersionNginxB() . 'sites-available/brainy.conf | grep "listen " | xargs | awk \'{print $2}\' | xargs')));
		$str = substr($str, 0, -1);
		return $str;
	}

	public function get_server_portssl()
	{
		$str = trim(implode("\n", $this->ssh('cat ' . $this->detectVersionNginxB() . 'sites-available/brainyssl.conf | grep "listen " | xargs | awk \'{print $2}\' | xargs')));
		return $str;
	}

	public function abort_root($b = 'yes', $c = 0)
	{
		global $lang;
		$c = '';
		$uss = $this->get_users();

		foreach ($uss as $us) {
			$out = $this->config_read('/etc/brainy/data/users/' . $us);
			$gr = $out['group'];

			if (isset($gr) && ($gr != '')) {
				$out = $this->config_read('/etc/brainy/data/groups/' . $gr);

				if (isset($out['root']) && ($out['root'] == 'y')) {
					$c = 'yes';
					$user = $us;
					break;
				}
			}
		}

		$res = array('code' => 0, 'message' => $lang['properties_abort_root_warning']);

		if ($c != 'yes') {
			$res['code'] = 1;
			return $res;
		}

		$arr = array('abort_root' => $b);

		if (($b == 'yes') && ($c == 0)) {
			$res['message'] = $lang['properties_server_abort_root_close'] . '';
			$this->config_save('/etc/brainy/data/properties/main', $arr);
			unset($_SESSION['user']);
			session_destroy();
		}
		else if (($b == 'no') && ($c == 0)) {
			$res['message'] = $lang['properties_server_abort_root_open'] . '';
			$this->config_save('/etc/brainy/data/properties/main', $arr);
		}
		else if (($b == 'yes') && ($c != 0)) {
			$res['message'] = 'Access to the panel for the root user is closed.';
			$this->config_save('/etc/brainy/data/properties/main', $arr);
		}
		else if (($b == 'no') && ($c != 0)) {
			$res['message'] = 'Access to the panel for the root user is open.';
			$this->config_save('/etc/brainy/data/properties/main', $arr);
		}
		else {
			$res['message'] = 'Error params.';
		}

		return $res;
	}

	public function get_abort_root()
	{
		$mass = $this->config_read('/etc/brainy/data/properties/main');

		if (isset($mass['abort_root']) && ($mass['abort_root'] == 'yes')) {
			return 1;
		}

		return 0;
	}

	public function server_ports_list_active()
	{
		$out = $this->ssh('netstat -plnta | awk \'{print $4}\' | grep -v \'server\' | grep -v \'Local\'');

		foreach ($out as $value) {
			$s1 = array(':::', '::', ':::1:', '::1:', ':1:');
			$s2 = array(':', ':', ':', ':', ':');
			$str = str_replace($s1, $s2, $value);
			$a = explode(':', $str);
			$arr[] = $a[1];
		}

		return $arr;
	}

	public function properties_get()
	{
		$out['server_email'] = $this->get_server_email();
		$time = trim(implode('', $this->sudo_ssh('date')));
		preg_match('/([A-Z]{1,})( [A-Z]{1,} {1})\\s*(.{1,})/i', $time, $mas);
		unset($mas[0]);
		$mas[2] = $mas[2] . ' ';
		$time = implode('', $mas);
		$out['time'] = $time;
		$out['locale'] = trim(implode('', $this->sudo_ssh('echo $LANG')));
		$out['hostname'] = trim(implode('', $this->sudo_ssh('hostname')));

		if ($this->user['username'] == 'root') {
			$conf = parse_ini_file($GLOBALS['PROPERTIES_CONF']);
			$out['language'] = $conf['language'];
		}

		$foo = explode(' ', $out['time']);
		$out['tz_date'] = $foo[0] . ' ' . $foo[1] . ' ' . $foo[2] . ' ' . $foo[3] . ' ' . $foo[5] . ' ' . $foo[6];
		$out['tz_time'] = $foo[4];
		$foofoo = explode(':', $out['tz_time']);
		$out['tz_time_m'] = $foofoo[1];
		$out['tz_time_s'] = $foofoo[2];
		$out['tz_time_h'] = $foofoo[0];
		$out['tz_timezone'] = $foo[5];
		$out['timezone_path'] = str_replace('-> /usr/share/zoneinfo', '', strstr(trim(implode('', $this->sudo_ssh('ls -al /etc/localtime'))), '->'));
		$out['timezone_name'] = str_replace('/', '', strrchr($out['timezone_path'], '/'));
		$locale = $this->sudo_ssh('locale');
		$out['locale'] = trim(str_replace('LANG=', '', $locale[0]));
		return $out;
	}

	public function properties_get_timezones()
	{
		$out = $this->new_filelist('/usr/share/zoneinfo/', '*', 'f', 2);
		return $out['list'];
	}

	public function properties_system_config_date()
	{
		$ok = $this->load_vars_m();
		$out = $this->new_filelist('yum -y install system-config-date');
		$this->set_data(array('system-date' => 'on'));
		return $out;
	}

	public function properties_set_hostname($hostname)
	{
		$oldName = gethostname();

		if (!$this->check_params('string', $hostname)) {
			return false;
		}

		$chech = 0;
		$host_name = trim(implode('', $this->sudo_ssh('hostname')));
		$out = implode('', $this->sudo_safe_ssh_dynamic('hostname #dynamic#', $hostname, 0));
		$file_hosts = $this->read_file_n('/etc/hosts');
		$i = 0;

		while ($i <= count($file_hosts)) {
			$mas = explode(' ', preg_replace('/ +/', ' ', $file_hosts[$i]));

			if ($mas[1] == $host_name) {
				$mas[1] = $hostname;
				$str = explode('.', $hostname);
				$mas[2] = $str[0];
				$file_hosts[$i] = implode(' ', $mas) . PHP_EOL;
				$chech = 1;
			}

			++$i;
		}

		if ($chech != 1) {
			$ip = new ipmanager();
			$ip = $ip->ipmanager_ipv4();
			$mas[0] = $ip[0]['ip'];
			$mas[1] = $hostname;
			$str = explode('.', $hostname);
			$mas[2] = $str[0];
			$arr = implode(' ', $mas) . PHP_EOL;
			array_push($file_hosts, $arr);
		}

		$this->write_file(implode('', $file_hosts), '/etc/hosts');
		$this->sudo_ssh('sysctl kernel.hostname=' . $hostname);
		$check_kernel_hostname = implode('', $this->sudo_ssh('cat /etc/sysctl.conf | grep \'kernel.hostname=\''));

		if (!$check_kernel_hostname) {
			$this->sudo_ssh('echo \'kernel.hostname=' . $hostname . '\' >> /etc/sysctl.conf');
		}
		else {
			$this->sudo_ssh('sed --in-place --follow-symlinks -i "s@kernel.hostname=.*@kernel.hostname=' . $hostname . '@g" /etc/sysctl.conf');
		}

		return $out;
	}

	public function properties_set_webpanel($hostname)
	{
		global $lang;
		$array_host = $this->config_read($GLOBALS['DATA_VHOSTS'] . $hostname . '.conf');

		if (!$this->check_value('domain', $hostname)) {
			$arr_out['code'] = 1230;
			$arr_out['message'] = $lang['properties_error_domain'];
		}

		if ($array_host['user'] && $hostname) {
			$arr_out['code'] = 2;
			$arr_out['message'] = $lang['properties_weppanel_alredy_exist'] . $array_host['user'];
		}
		if ($arr_out) {
			return $arr_out;
		}

		$webserver = new webserver();
		$file_webpanel = '/etc/brainy/data/server_control/webpanel';
		$out_file = $this->get_webpanel();

		if ($out_file) {
			$webserver->removePanelHost($out_file);
		}

		$this->ssh('rm -rf /etc/brainy/src/ssl/webpanel.crt_v2');

		if (!$hostname) {
			$conf = $this->config_read('/etc/brainy/data/certs_control/service_cert.conf');
			unset($conf['webpanel']);
			$this->config_save('/etc/brainy/data/certs_control/service_cert.conf', $conf, 'new');
			$webserver->webservers_reloadconf();
		}

		$this->write_file($hostname, $file_webpanel);

		if ($hostname) {
			$webserver->add_default_host('', $hostname);
			$webserver->webserver_convert_domain($hostname);
		}

		$arr_out['code'] = 0;
		$arr_out['message'] = $lang['properties_successfully'];
		return $arr_out;
	}

	public function get_webpanel()
	{
		$out_file = trim(file_get_contents('/etc/brainy/data/server_control/webpanel'));
		return $out_file;
	}

	public function properties_set_timezone($timezone)
	{
		if (!$this->check_params('dir', $timezone)) {
			return false;
		}

		$this->sudo_ssh('ln -sf /usr/share/zoneinfo' . $timezone . ' /etc/localtime');
		return '1';
	}

	public function change_rootpass($newpass)
	{
		$newpass = $this->strip_quotes_cmd($newpass);

		if ($newpass) {
			$this->sudo_ssh('usermod  -p $(echo \'' . $newpass . '\' | openssl passwd -1 -stdin) root');
		}
	}

	public function force_ntp_enable()
	{
		if ($this->check_service_installed('ntpd') == 1) {
			$out = $this->monitor_comm_os('ntpd', 'restart');
			return implode('', $out);
		}

		$outt = $this->load_vars_m();
		$lmt = $outt['last_install_timestamp'];
		$ntp_status = $outt['ntp'];

		if (($ntp_status == 'installation_in_progress') && ((time() - $lmt) < (60 * 5))) {
		}
		else {
			$arr = array('ntp' => 'installation_in_progress', 'last_install_timestamp' => time());
			$this->set_data($arr);
			$this->sudo_ssh('yum -y install ntp');
			$this->sudo_ssh('echo \'SYNC_HWCLOCK=yes\' >> /etc/sysconfig/ntpd');
			$this->chkconfiguni('ntpd', 1);
			$this->monitor_comm_os('ntpd', 'start');
			$arr = array('ntp' => 'installed');
			$this->set_data($arr);
		}

		return 'OK';
	}

	public function ntp_onoff($onoff)
	{
		if (($onoff != 'start') && ($onoff != 'stop')) {
			exit();
		}

		switch ($onoff) {
		case 'start':
			$this->sudo_ssh('chkconfig ntpd on');
			break;

		case 'stop':
			$this->sudo_ssh('chkconfig ntpd off');
			break;
		}

		$out = (, $onoff);
		return implode('', $out);
	}

	public function properties_ntp_check_status()
	{
		if ($this->check_service_installed('ntpd') == 1) {
			$stat = $this->monitor_get_service_status('ntpd');

			if ($stat == 'off') {
				return '2';
			}

			return '1';
		}

		return '3';
	}

	public function change_time($newtime)
	{
		if (!$this->check_params('string', $newtime)) {
			return false;
		}

		$out = $this->sudo_ssh('date -s \'' . $newtime . '\'');
		return implode('', $out);
	}

	public function mysql_query_do($db, $query)
	{
		global $lang;
		$root = parse_ini_file($GLOBALS['MYSQL_CONF_PATH'], true);
		$root = $root['root'];
		$con = new mysqli('127.0.0.1', 'root', $root, $db);

		if (mysqli_connect_errno()) {
			return $lang['properties_no_connect_db'] . ' ' . mysqli_connect_error();
		}

		$result = $con->query($query);

		if (!$result) {
			return $lang['properties_wrong_query'] . ' ' . mysqli_error($con);
		}

		if (!is_bool($result)) {
			if (0 < mysqli_num_rows($result)) {
				$resarr = $result->fetch_all();
				return $resarr;
			}
		}
	}

	public function mysql_query_do_nodb($query)
	{
		global $lang;
		$root = parse_ini_file($GLOBALS['MYSQL_CONF_PATH'], true);
		$root = $root['root'];
		$con = new mysqli('127.0.0.1', 'root', $root);

		if (mysqli_connect_errno()) {
			return $lang['properties_no_connect_db'] . ' ' . mysqli_connect_error();
		}

		$result = $con->query($query);

		if (!$result) {
			return $lang['properties_wrong_query'] . ' ' . mysqli_error($con);
		}

		if (!is_bool($result)) {
			if (0 < mysqli_num_rows($result)) {
				$resarr = $result->fetch_all();
				return $resarr;
			}
		}

		return 0;
	}

	public function mysql_query_doimport($db, $sqlfile)
	{
		global $lang;
		$root = parse_ini_file($GLOBALS['MYSQL_CONF_PATH'], true);
		$root = $root['root'];
		$con = new mysqli('127.0.0.1', 'root', $root, $db);

		if (mysqli_connect_errno()) {
			return $lang['properties_no_connect_db'] . ' ' . mysqli_connect_error();
		}

		$import = 'mysql -uroot -p' . $root . ' ' . $db . ' < ' . $sqlfile;
		$res = $this->ssh($import);

		if (stripos($res, 'ERROR') !== false) {
			return $lang['properties_wrong_query'] . ' ' . $sqlfile . ' import To: ' . $db;
		}

		return 0;
	}

	public function check_entered_data($datatype = NULL, $doublesm = NULL, $addparam = NULL)
	{
		global $lang;
		$out['code'] = 0;

		foreach ($datatype as $key => $value) {
			if (0 < $out['code']) {
				break;
			}

			switch ($key) {
			case 'mysql_login':
				if (!isset($addparam['cur_user'])) {
					$addparam = array();
					$addparam['cur_user'] = '';
				}

				if (($value == '') || !$value || ($value == '_' . $addparam['cur_user'])) {
					$out['code'] = 100;
					$out['message'] = $lang['properties_login_falled'];
				}

				if (15 < strlen($value)) {
					$out['code'] = 101;
					$out['message'] = $lang['properties_login_letters'];
				}

				if (is_array($doublesm['mysql_login'])) {
					if (in_array($value, $doublesm['mysql_login'])) {
						$out['code'] = 102;
						$out['message'] = $lang['properties_login_already_exists'];
					}
				}

				break;

			case 'mysql_password':
				if (($value == '') || !$value) {
					$out['code'] = 100;
					$out['message'] = $lang['properties_pwd_filled'];
				}

				break;

			case 'mysql_db':
				if (!isset($addparam['cur_user'])) {
					$addparam = array();
					$addparam['cur_user'] = '';
				}

				if (($value == '') || !$value || ($value == '_' . $addparam['cur_user'])) {
					$out['code'] = 100;
					$out['message'] = $lang['properties_db_filled'];
				}

				if (in_array($value, $doublesm['mysql_db'])) {
					$out['code'] = 102;
					$out['message'] = $lang['mysql_add_db_exists'] . '(' . $value . ')';
				}

				break;
			}
		}

		return $out;
	}

	public function ipmanager_listips()
	{
		$ifcomm2 = '/sbin/ip addr list';
		$newips = $this->sudo_ssh($ifcomm2);
		$nat_dev = '';
		$mass = $this->config_read('/etc/brainy/data/ipmanager/nat');

		if (isset($mass['dev']) && $mass['active']) {
			$nat_dev = $mass['dev'];
		}

		$i = 0;

		foreach ($newips as $value) {
			preg_match_all('@inet ([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})/[0-9]{1,2}.*scope (host|global).*([a-z0-9:]+)$@Usi', $value, $out);
			if ($out[1][0] && ($out[1][0] != '127.0.0.1')) {
				$newipmass[$i]['ip'] = $out[1][0];
				$newipmass[$i]['availability'] = $out[2][0];
				$newipmass[$i]['int'] = $out[3][0];
				$newipmass[$i]['nat'] = 0;

				if ($nat_dev == $out[3][0]) {
					$newipmass[$i]['nat'] = 1;
				}

				++$i;
			}
		}

		return $newipmass;
	}

	public function ipmanager_listipsv6()
	{
		$ifcomm2 = 'ip addr list';
		$newips = $this->sudo_ssh($ifcomm2);
		$i = 0;

		foreach ($newips as $value) {
			preg_match_all('@inet ([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})/[0-9]{1,2}.*scope (host|global).*([a-z0-9:]+)$@Usi', $value, $out);
			if ($out[1][0] && ($out[1][0] != '127.0.0.1')) {
				$newipmass[$i]['ip'] = $out[1][0];
				$newipmass[$i]['availability'] = $out[2][0];
				$newipmass[$i]['int'] = $out[3][0];
				++$i;
			}
		}

		return $newipmass;
	}

	public function getexistpid_array($streamfull)
	{
		$this->check_auth();
		$comm['userowner'] = $this->user['username'];

		if (($this->user['username'] != 'root') && ($this->user['group_properties']['root'] != 'y')) {
			$streamfull = $this->strip_quotes_cmd($this->user['username']);
			$grep = 'ps aux | grep \'' . $streamfull . '\'';
			$grep .= ' | awk \'{printf "%s|%s###", $2, $0}\' ';
			exec($grep, $res);
			$rowarr = explode('###', $res[0]);
			$pidsuser_arr = array();

			foreach ($rowarr as $row) {
				if (strpos($row, 'grep') === false) {
					$pidarr = explode('|', $row);

					if (1 < count($pidarr)) {
						$pidsuser_arr[] = $pidarr[0];
					}
				}
			}

			return $pidsuser_arr;
		}

		$streamfull = $this->strip_quotes_cmd($streamfull);
		$grep = 'ps aux | grep \'' . $streamfull . '\'';
		$grep .= ' | awk \'{printf "%s|%s###", $2, $0}\' ';
		exec($grep, $res);
		$rowarr = explode('###', $res[0]);
		$pid = -1;
		$full_list = array();

		foreach ($rowarr as $row) {
			if (strpos($row, 'grep') === false) {
				$pidarr = explode('|', $row);

				if (1 < count($pidarr)) {
					$full_list[] = $pidarr[0];
				}
			}
		}

		return $full_list;
	}

	public function getexistpid($streamfull)
	{
		$this->check_auth();
		$comm['userowner'] = $this->user['username'];

		if (($this->user['username'] != 'root') && ($this->user['group_properties']['root'] != 'y')) {
			$streamfull = $this->strip_quotes_cmd($streamfull);
			$grep = 'ps aux | grep \'' . $streamfull . '\'';
			$grep .= ' | awk \'{printf "%s|%s###", $2, $0}\' ';
			exec($grep, $res);
			$rowarr = explode('###', $res[0]);
			$pidsuser_arr = array();

			foreach ($rowarr as $row) {
				if (strpos($row, 'grep') === false) {
					$pidarr = explode('|', $row);

					if (1 < count($pidarr)) {
						$pidsuser_arr[] = $pidarr[0];
					}
				}
			}
		}

		$streamfull = $this->strip_quotes_cmd($streamfull);
		$grep = 'ps aux | grep \'' . $streamfull . '\'';
		$grep .= ' | awk \'{printf "%s|%s###", $2, $0}\' ';
		exec($grep, $res);
		$rowarr = explode('###', $res[0]);
		$pid = -1;
		$full_list = array();

		foreach ($rowarr as $row) {
			if (strpos($row, 'grep') === false) {
				$pidarr = explode('|', $row);

				if (1 < count($pidarr)) {
					$pid = $pidarr[0];
				}
			}
		}

		if (($this->user['username'] != 'root') && ($this->user['group_properties']['root'] != 'y')) {
			if (in_array($pid, $pidsuser_arr) != false) {
				return $pid;
			}

			return -1;
		}

		return $pid;
	}

	public function getstatusbypid($pid)
	{
		$pid = intval($pid);
		$grep = 'ps aux | grep ' . $pid;
		$res = $this->sudo_ssh($grep);

		foreach ($res as $key => $value) {
			if (strripos($value, 'grep ' . $pid)) {
				unset($res[$key]);
			}
		}

		if (0 < count($res)) {
			$ans = true;
		}
		else {
			$ans = false;
		}

		return $ans;
	}

	public function get_langs()
	{
		$out = $this->filelist('/etc/brainy/langs/', '*', 'd');
		return $out;
	}

	public function get_langs_array()
	{
		$array_lang = $this->get_langs();

		foreach ($array_lang as $val_array) {
			$file_include = $GLOBALS['LANGS_PATH'] . $val_array . '/common.php';

			if (file_exists($file_include)) {
				include $file_include;
				$array_lang_return[$val_array] = $lang['current_lang'];
			}
		}

		return $array_lang_return;
	}

	public function find_vhosts($param)
	{
		$param = $this->strip_quotes_cmd($param);
		$dir = '/etc/brainy/data/vhosts/';
		$param = str_replace('\'', '"', $param);
		$out = $this->sudo_ssh('grep -rl \'' . $param . '\' ' . $dir . ' --fixed-strings');

		foreach ($out as $key => $value) {
			$out[$key] = str_replace(array($dir, '.conf'), '', $value);
		}

		return $out;
	}

	public function find_files_text($dir, $param)
	{
		$param = $this->strip_quotes_cmd($param);
		$out = $this->sudo_ssh('grep -rl \'' . $param . '\' ' . $dir);
		return $out;
	}

	public function kill_stream($stream_id)
	{
		if (!$this->check_params('string', $stream_id)) {
		}

		if (2 < strlen($stream_id)) {
			$out = $this->getexistpid_array($stream_id);

			if (is_array($out)) {
				foreach ($out as $curpid) {
					$this->sudo_ssh('kill -9 ' . $curpid);
				}
			}
		}
		else {
			$out = array();
		}

		return $out;
	}

	public function config_read_remote($url)
	{
		$conf = file_get_contents($url, FILE_USE_INCLUDE_PATH);
		$res1 = explode("\n", trim($conf));
		$arr_param_ins = array();

		foreach ($res1 as $key1 => $val) {
			$mas_n = explode('=', $val, 2);

			foreach ($mas_n as $key_n => $val_n) {
			}

			$arr_param_ins[$mas_n[0]] = str_replace('"', '', $val_n);
		}

		return $arr_param_ins;
	}

	public function strip_quotes_new_cmd($comm)
	{
		$comm = str_replace('\'', '\\\'', $comm);
		return $comm;
	}

	public function strip_quotes_cmd($comm)
	{
		$comm = str_replace('\'', '\\'\\\'\'', $comm);
		return $comm;
	}

	public function strip_quotes_cmd_auth($comm)
	{
		$comm = str_replace('\'', '\\'\'', $comm);
		return $comm;
	}

	public function strip_doublequotes_cmd($comm)
	{
		$comm = str_replace('"', '\\"', $comm);
		return $comm;
	}

	public function escape_slash_echoe($comm)
	{
		$comm = str_replace('\\', '\\\\', $comm);
		return $comm;
	}

	public function escape_slash_cmd($comm)
	{
		$comm = str_replace('/', '\\/', $comm);
		return $comm;
	}

	public function check_value($type, $data)
	{
		if (is_array($data)) {
			foreach ($data as $key => $val) {
				return false;
			}

			return true;
		}

		return $this->check_params($type, $data);
	}

	public function check_params($type, $val)
	{
		$val = trim($val);

		if (!$val) {
			return true;
		}

		switch ($type) {
		case 'ip':
			return inet_pton($val);
		case 'domain':
			$puny = new idna_convert();
			$val = $puny->encode(trim($val));
			if (preg_match('/^([a-zA-Z0-9\\-]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9\\-])?\\.)+[a-zA-Z0-9\\-]{1,20}[\\.]?$/', $val) && (substr_count($val, '.') != 0)) {
				return true;
			}

			break;

		case 'domain_star':
			$puny = new idna_convert();
			$val = $puny->encode(trim($val));
			if (preg_match('/^([a-zA-Z0-9\\-\\*]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9\\-])?\\.)+[a-zA-Z0-9\\-\\*]{1,20}[\\.]?$/', $val) || (substr_count($val, '.') == 0)) {
				return true;
			}

			break;

		case 'file':
			return is_file($val);
		case 'filename':
			if (preg_match('/^[a-zA-Z0-9_\\-\\.а-я\\!]+$/Usi', $val)) {
				return true;
			}

			break;

		case 'number':
			if (preg_match('|^[\\d]+$|', $val)) {
				return true;
			}

			break;

		case 'string':
			if (preg_match('/^[а-яёЁa-zA-Z0-9_\\-\\.\\+\\: ]+$/iu', $val)) {
				return true;
			}

			break;

		case 'string2':
			if (preg_match('/^[a-zA-Z0-9_ ;,\\-\\.\\+\\:]+$/', $val)) {
				return true;
			}

			break;

		case 'string3':
			if (preg_match('/^[a-zA-Z0-9_\\-\\.\\+\\: \\/]+$/', $val)) {
				return true;
			}

			break;

		case 'strdot':
			if (preg_match('/^[a-zA-Z0-9_\\-\\.]+$/', $val)) {
				return true;
			}

			break;

		case 'strdotx2':
			if (preg_match('/^[a-zA-Z0-9:\\/_\\-\\.]+$/', $val)) {
				return true;
			}

			break;

		case 'email':
			if (preg_match('/^([a-zA-Z0-9_\\.\\-]+)@([a-zA-Z0-9_\\.\\-]+)\\.([a-zA-Z0-9\\.\\-]{2,20})$/', $val)) {
				return true;
			}

			break;

		case 'user':
			$res = $this->check_user($val);

			if ($res) {
				return $res;
			}

			if (preg_match('/^[a-zA-Z0-9_\\-\\.\\+\\:]+$/', $val)) {
				return true;
			}

			break;

		case 'user_exist':
			$res = $this->check_user($val);
			return $res;
		case 'user_string':
			if (preg_match('/^[a-zA-Z0-9_\\-\\.\\+\\:]+$/', $val)) {
				return true;
			}

			break;

		case 'dir':
			if (preg_match('/^[a-zA-Z0-9_\\-\\.\\/\\!\\:@]+$/', $val) && (stripos($val, '..') === false)) {
				return true;
			}

			break;

		case 'filename_without_dot':
			if (preg_match('/^[a-zA-Z0-9_\\-]+$/', $val)) {
				return true;
			}

			break;

		case 'date':
			if (preg_match('/^[0-9]{2}[-]{1}[0-9]{2}[-]{1}[0-9]{4}$/', $val)) {
				return true;
			}

			break;

		case 'text':
			if (preg_match('/^[a-z0-9а-яЁё \\-\\:\\.\\+\\;\\/\\=\'\\"_,@\\*\\!]+$/iu', preg_replace('/(\\r)|(\\n)|(\\n\\r)|(\\r\\n)|(\\t)/i', '', $val))) {
				return true;
			}

			break;

		case 'textCache':
			if (preg_match('/^[a-z0-9 \\:\\?\\-\\.\\+\\;\\/\\=_,@\\*\\!\\[\\]\\|]+$/iu', preg_replace('/(\\r)|(\\n)|(\\n\\r)|(\\r\\n)|(\\t)/i', '', $val))) {
				return true;
			}

			break;

		case 'stringservice':
			if (preg_match('/^[а-яёЁa-zA-Z0-9_;,@\\-\\.\\+\\: \\/]+$/', $val)) {
				return true;
			}

			break;
		}
	}

	public function put_fastsearch($domain = 1, $email = 1)
	{
		$mailclient = new mailclient();
		$webserver = new webserver();
		$users = $this->get_users();
		$allData = array();

		foreach ($users as $curUser) {
			if ($domain == 1) {
				$domains = $webserver->get_virt_hosts($curUser, 0);
				$i = 0;

				foreach ($domains as $curDom) {
					$allData[$curUser]['domains'][$i]['domain'] = $curDom['domain'];
					$allData[$curUser]['domains'][$i]['aliases'] = $curDom['aliases'];
					$allData[$curUser]['domains'][$i]['ip'] = $curDom['ip'];
					$allData[$curUser]['domains'][$i]['bridge'] = $curDom['bridge'];
					$allData[$curUser]['domains'][$i]['php'] = $curDom['php'];
					$allData[$curUser]['domains'][$i]['aliases'] = $curDom['aliases'];
					$allData[$curUser]['domains'][$i]['aliases'] = $curDom['aliases'];
					++$i;
				}
			}

			if ($email == 1) {
				$emails = $mailclient->get_email($curUser);

				foreach ($emails as $curEmail) {
					$allData[$curUser]['email'][] = $curEmail;
				}
			}
		}

		if (!file_exists('/etc/brainy/data/fastsearch/index')) {
			$this->ssh('mkdir -p /etc/brainy/data/fastsearch && touch /etc/brainy/data/fastsearch/index');
		}

		file_put_contents('/etc/brainy/data/fastsearch/index', json_encode($allData, 1), LOCK_EX);
	}

	public function get_fastsearch($data, $group_propertis, $user)
	{
		$num_select = 5;
		$loadData = json_decode(file_get_contents('/etc/brainy/data/fastsearch/index'), 1);
		$res = array();
		$puny = new idna_convert();
		if (($user == 'root') || ($group_propertis == 'y')) {
			if (isset($loadData[$data])) {
				$res['hostacc'][$data][] = $data;
			}

			foreach ($loadData as $keyUser => $curUser) {
				foreach ($curUser['domains'] as $curDom) {
					if (stripos($puny->decode(trim($curDom['domain'])), $data) !== false) {
						$res['domains'][$keyUser][] = $puny->decode(trim($curDom['domain']));
					}
				}

				foreach ($curUser['email'] as $curEmail) {
					if (stripos($puny->decode(trim($curEmail)), $data) !== false) {
						$res['email'][$keyUser][] = $puny->decode(trim($curEmail));
					}
				}
			}
		}
		else {
			$array_out1 = array_unique($this->ssh('cat /etc/brainy/data/fastsearch/index |grep -F \'' . $user . ' \' | awk \'{print $1}\' | grep -F \'' . $data . '\' '));
			$array_out = $this->ssh('cat /etc/brainy/data/fastsearch/index | grep -F \'' . $user . ' \' | awk \' / \'[0-9a-z@\\.-_]*' . $data . '[0-9a-z@\\.-_]*\'/ {print \'$1\'\'$2\'}\' | head -' . $num_select);
		}

		return $res;
	}

	public function managehtaccess_access_panel($login, $pass, $action)
	{
		global $lang;
		$action = (int) $action;

		if (!$this->check_params('string', $login)) {
			return false;
		}

		if ($action == 2) {
			if (!is_file($this->detectVersionNginxB() . 'sites-available/brainy.conf')) {
				if (!is_file('/etc/brainy/.htaccess')) {
					$res = 0;
					return $res;
				}

				$config_ht = file_get_contents('/etc/brainy/.htaccess');

				if ((stripos($config_ht, 'AuthUserFile') !== false) && (stripos($config_ht, 'AuthName') !== false)) {
					$res = 1;
				}
				else {
					$res = 0;
				}
			}
			else {
				$resN = file_get_contents($this->detectVersionNginxB() . 'nginx.conf');
				$res = 0;

				if (stripos($resN, '#auth_basic ') === false) {
					$res = 1;
				}
			}

			return $res;
		}

		if ($action == 1) {
			if (strlen($pass) < 5) {
				$res['code'] = 1;
				$res['message'] = $lang['properties_manage_htaccess_pass_short'];
				return $res;
			}

			if (preg_match('/\'+/i', $pass)) {
				$res['code'] = 2;
				$res['message'] = $lang['properties_error_symbol'];
				return $res;
			}

			$pass = escapeshellcmd($pass);

			if (!is_file($this->detectVersionNginxB() . 'sites-available/brainy.conf')) {
				$comm = '/etc/brainy/src/compiled/brainy/bin/htpasswd -bc /etc/brainy/.htpasswd ' . $login . ' ' . $pass;
				$comm = $this->strip_quotes_cmd($comm);
				$this->ssh($comm);
				$htaccess_val = 'AuthType Basic' . "\n" . 'AuthName "Restricted Access"' . "\n" . 'AuthUserFile  /etc/brainy/.htpasswd' . "\n" . 'Require user ' . $login . "\n";
				$config_ht = file_get_contents('/etc/brainy/.htaccess', LOCK_EX);
				file_put_contents('/etc/brainy/.htaccess', $htaccess_val . $config_ht, LOCK_EX);
			}
			else {
				$pathConfNginxB = $this->detectVersionNginxB();
				$escPathNginxb = $this->escape_slash_cmd($pathConfNginxB);
				$comm = 'htpasswd -bc ' . $pathConfNginxB . '.htpasswd ' . $login . ' ' . $pass;
				$this->ssh($this->strip_quotes_cmd($comm));
				$upd_to = '\\auth_basic \\"Restricted Area\\";';
				$this->ssh('sed -i "/auth_basic /c' . $upd_to . '" ' . $pathConfNginxB . 'nginx.conf');
				$upd_to = 'auth_basic_user_file ' . $escPathNginxb . '.htpasswd;';
				$this->ssh('sed -i "/auth_basic_user_file/c' . $upd_to . '" ' . $pathConfNginxB . 'nginx.conf');
				$this->monitor_comm_os('nginxb', 'reload');
			}

			$res['code'] = 0;
			$res['message'] = $lang['properties_manage_htaccess_set_ok'];
			return $res;
		}

		if ($action == 0) {
			if (!is_file($this->detectVersionNginxB() . 'sites-available/brainy.conf')) {
				$this->ssh('rm -f /etc/brainy/.htpasswd');
				$this->ssh('sed -i \'/^AuthType.*/d\' /etc/brainy/.htaccess');
				$this->ssh('sed -i \'/^AuthName.*/d\' /etc/brainy/.htaccess');
				$this->ssh('sed -i \'/^AuthUserFile.*/d\' /etc/brainy/.htaccess');
				$this->ssh('sed -i \'/^Require\\ user.*/d\' /etc/brainy/.htaccess');
			}
			else {
				$pathConfNginxB = $this->detectVersionNginxB();
				$escPathNginxb = $this->escape_slash_cmd($pathConfNginxB);
				$upd_to = '\\#auth_basic \\"Restricted Area\\";';
				$this->ssh('sed -i "/auth_basic /c' . $upd_to . '" ' . $pathConfNginxB . 'nginx.conf');
				$upd_to = '#auth_basic_user_file ' . $escPathNginxb . '.htpasswd;';
				$this->ssh('sed -i "/auth_basic_user_file/c' . $upd_to . '" ' . $pathConfNginxB . 'nginx.conf');
				$this->monitor_comm_os('nginxb', 'reload');
			}

			$res['code'] = 0;
			$res['message'] = $lang['properties_manage_htaccess_del_ok'];
			return $res;
		}
	}

	public function htaccess_ip_access($denyips, $allowips, $action)
	{
		global $lang;
		$action = (int) $action;

		if ($action == 2) {
			$ips_den_arr = array();
			$ips_allow_arr = array();
			$res_deny = $this->ssh('grep \'deny\' ' . $this->detectVersionNginxB() . 'conf.d/properties.conf');
			$res_allow = $this->ssh('grep \'allow\' ' . $this->detectVersionNginxB() . 'conf.d/properties.conf');

			foreach ($res_deny as $ip_den) {
				if (stripos($ip_den, '#') === false) {
					$ip_den = str_replace(';', '', $ip_den);
					$ips_den_arr_exp = explode(' ', trim($ip_den));
					$ips_den_arr[] = $ips_den_arr_exp[count($ips_den_arr_exp) - 1];
				}
			}

			foreach ($res_allow as $ip_allow) {
				if (stripos($ip_allow, '#') === false) {
					$ip_allow = str_replace(';', '', $ip_allow);
					$ips_allow_arr_exp = explode(' ', trim($ip_allow));
					$ips_allow_arr[] = $ips_allow_arr_exp[count($ips_allow_arr_exp) - 1];
				}
			}

			$resips['deny'] = $ips_den_arr;
			$resips['allow'] = $ips_allow_arr;
			return $resips;
		}

		if ($action == 1) {
			$denyips = preg_split('/[\\s,;]/', $denyips);
			$allowips = preg_split('/[\\s,;]/', $allowips);
			$allowips = array_filter($allowips);
			$access_vals = '';

			foreach ($allowips as $ip) {
				if (0 < strlen($ip)) {
					if (trim($ip) != 'all') {
						if (!preg_match('/^[0-9]{1,3}(\\.{1}[0-9]{1,3}){3}(\\/[0-9]+)?$/iu', trim($ip))) {
							$res['code'] = 5;
							$res['message'] = $lang['properties_manage_htaccess_accessip_wrongformat'];

							return $res;
						}
					}

					$access_vals .= 'allow ' . trim($ip) . ';' . "\n";
				}
			}

			if (count($allowips) == 0) {
				foreach ($denyips as $ip) {
					if (0 < strlen($ip)) {
						if (trim($ip) != 'all') {
							if (!preg_match('/^[0-9]{1,3}(\\.{1}[0-9]{1,3}){3}(\\/[0-9]+)?$/iu', trim($ip))) {
								$res['code'] = 5;
								$res['message'] = $lang['properties_manage_htaccess_accessip_wrongformat'];

								return $res;
							}
						}

						$access_vals .= 'deny ' . trim($ip) . ';' . "\n";
					}
				}
			}
			else {
				$access_vals .= 'deny all;' . "\n";
			}

			if ((stripos($access_vals, 'allow') === false) && (stripos($access_vals, 'deny all') !== false)) {
				$res['code'] = 3;
				$res['message'] = $lang['properties_manage_htaccess_accessip_selfblock'];
				return $res;
			}

			$this->ssh('sed -i \'/^deny /d\' ' . $this->detectVersionNginxB() . 'conf.d/properties.conf');
			$this->ssh('sed -i \'/^allow /d\' ' . $this->detectVersionNginxB() . 'conf.d/properties.conf');
			$config_ht = file_get_contents($this->detectVersionNginxB() . 'conf.d/properties.conf', LOCK_EX);
			file_put_contents($this->detectVersionNginxB() . 'conf.d/properties.conf', $access_vals . $config_ht, LOCK_EX);
			$this->monitor_comm_os('brainy', 'restart');
			$res['code'] = 0;
			$res['message'] = $lang['properties_manage_htaccess_accessip_setok'];
			return $res;
		}
	}

	public function getmaindomain_byalias($domain)
	{
		if (!$this->check_value('domain', $domain)) {
			return false;
		}

		$puny = new idna_convert();
		$domain = $puny->encode(trim($domain));
		$comm = 'grep -rl \'"' . $domain . '"\' /etc/brainy/data/vhosts';
		$res = $this->ssh($comm);

		if (0 < strlen($res[0])) {
			return $res[0];
		}

		$comm = 'grep -rl \',' . $domain . '"\' /etc/brainy/data/vhosts';
		$res = $this->ssh($comm);

		if (0 < strlen($res[0])) {
			return $res[0];
		}

		$comm = 'grep -rl \'"' . $domain . ',\' /etc/brainy/data/vhosts';
		$res = $this->ssh($comm);

		if (0 < strlen($res[0])) {
			return $res[0];
		}

		$comm = 'grep -rl \',' . $domain . ',\' /etc/brainy/data/vhosts';
		$res = $this->ssh($comm);

		if (0 < strlen($res[0])) {
			return $res[0];
		}
	}

	public function check_service_installed($service)
	{
		if (stripos($service, '-fpm') !== false) {
			$resExt = $this->monitor_get_service_status($service, 1);

			if (stripos($resExt, 'at least one pool section must be specified in config file') !== false) {
				return 0;
			}
		}

		if (!is_file('/etc/init.d/' . $service) && !is_file('/lib/systemd/system/' . $service . '.service') && !is_file('/usr/lib/systemd/system/' . $service . '.service')) {
			return 0;
		}

		return 1;
	}

	public function chkconfiguni($service, $stat, $level = 0)
	{
		$os_version = $GLOBALS['OS_VERSION'];

		switch ($os_version) {
		case 'debian8':
			if ($stat == 0) {
				$stat = 'disable';
			}

			if ($stat == 1) {
				$stat = 'enable';
			}

			if ($level != 0) {
				$this->ssh('chkconfig --level ' . $level . ' ' . $service . ' on');
			}
			else {
				$this->ssh('systemctl ' . $stat . ' ' . $service);
			}

			break;

		case 'debian9':
			if ($stat == 0) {
				$stat = 'disable';
			}

			if ($stat == 1) {
				$stat = 'enable';
			}

			$this->ssh('systemctl ' . $stat . ' ' . $service);
			break;

		case 'ubuntu':
			if ($stat == 0) {
				$stat = 'disable';
			}

			if ($stat == 1) {
				$stat = 'enable';
			}

			$this->ssh('systemctl ' . $stat . ' ' . $service);
			break;

		case 'centos7':
			if ($stat == 0) {
				$stat = 'disable';
			}

			if ($stat == 1) {
				$stat = 'enable';
			}

			if ($level != 0) {
				$this->ssh('chkconfig --level ' . $level . ' ' . $service . ' on');
			}
			else {
				$this->ssh('systemctl ' . $stat . ' ' . $service);
			}

			break;
		}

		if ($stat == 1) {
			$stat = 'on';
		}

		if ($level != 0) {
			$this->ssh('chkconfig --level ' . $level . ' ' . $service . ' ' . $stat);
		}
		else {
			$this->ssh('chkconfig ' . $service . ' ' . $stat);
		}

		break;
	}

	public function monitor_comm_os_prepare($service, $command)
	{
		$os_ver = $GLOBALS['OS_VERSION'];

		switch ($os_ver) {
		case 'debian8':
			return 'systemctl ' . $command . ' ' . $service;
		case 'centos7':
			return 'systemctl ' . $command . ' ' . $service;
		}

		return ($os_ver = $GLOBALS['OS_VERSION']) . $command;
	}

	public function monitor_comm_os($service, $command)
	{
		$os_ver = $GLOBALS['OS_VERSION'];

		switch ($os_ver) {
		case 'debian8':
			if ($service == 'brainy') {
				$stat = implode(',', $this->create_stream('bash -c \'(sleep 5 ; systemctl ' . $command . ' nginxb)&\''));
			}
			else {
				$stat = implode(',', $this->sudo_ssh('systemctl ' . $command . ' ' . $service));
			}

			break;

		case 'centos7':
			if ($service == 'brainy') {
				$stat = implode(',', $this->create_stream('bash -c \'(sleep 5 ; systemctl ' . $command . ' nginxb)&\''));
			}
			else {
				$stat = implode(',', $this->sudo_ssh('systemctl ' . $command . ' ' . $service));
			}

			break;

		default:
			$stat = implode(',', $this->sudo_ssh('/sbin/service ' . $service . ' ' . $command));
		}

		return $stat;
	}

	public function monitor_service_command($service, $command)
	{
		global $lang;
		$stat = $this->monitor_comm_os($service, $command);

		if ($command == 'restart') {
			$res_stat = $this->monitor_get_service_status($service, 1);

			if ($res_stat == 'on') {
				return $lang['monitor_service_restart_ok'];
			}

			$this->ssh('killall -9 ' . $service);
			$stat = $this->monitor_comm_os($service, $command);
			$res_stat = $this->monitor_get_service_status($service, 1);

			if ($res_stat == 'on') {
				return $lang['monitor_service_restart_ok'];
			}

			return $lang['monitor_service_restart_failed'] . '<br/>' . $res_stat;
		}

		if ($command == 'start') {
			$res_stat = $this->monitor_get_service_status($service, 1);

			if ($res_stat == 'on') {
				return $lang['monitor_service_start_ok'];
			}

			return $lang['monitor_service_start_failed'] . '<br/>' . $res_stat;
		}

		if ($command == 'stop') {
			return $lang['monitor_service_stop_ok'];
		}
	}

	public function monitor_get_service_status($command, $extendinfo = 0)
	{
		$os_ver = $GLOBALS['OS_VERSION'];
		$q = 0;

		if (stripos($command, ' ') !== false) {
			if ((0 < stripos($command, 'brainy')) && (stripos($command, 'brainysqld') === false)) {
				$q = 1;
				$result = $this->sudo_ssh($command);
				$count = count($result);
				$i = 0;

				while ($i < 10) {
					if (0 < stripos($result[$i], '-k start')) {
						return 'on';
					}

					++$i;
				}

				if (5 < count($result)) {
					return 'on';
				}

				return 'off';
			}

			if ($q == 0) {
				$stat = implode(',', $this->ssh($command));
				$stat_ext = implode('<br/>', $this->ssh($command));
				if ((0 < substr_count($stat, 'running')) || ((stripos($stat, 'active') !== false) && (stripos($stat, 'inactive') === false) && (stripos($stat, 'failed') === false))) {
					return 'on';
				}

				if ($extendinfo == 0) {
					return 'off';
				}

				return $stat_ext;
			}
		}

		if ($q == 0) {
			switch ($os_ver) {
			case 'debian8':
				$stat = implode(',', $this->sudo_ssh('systemctl is-active ' . $command));
				$stat_ext = implode('<br/>', $this->sudo_ssh('systemctl status ' . $command));
				break;

			case 'centos7':
				$stat = implode(',', $this->sudo_ssh('systemctl is-active ' . $command));
				$stat_ext = implode('<br/>', $this->sudo_ssh('systemctl status ' . $command));
				break;
			}

			if (((, 'csf') !== false) || (stripos($command, 'iptables') !== false)) {
				$q = 1;
				$result = $this->sudo_ssh('/sbin/service ' . $command . ' status | grep \'DROP\'');

				if (20 < count($result)) {
					return 'on';
				}

				return 'off';
			}

			if ($q == 0) {
				$stat = implode(',', $this->sudo_ssh('/sbin/service ' . $command . ' status'));
				$stat_ext = implode('<br/>', $this->sudo_ssh('/sbin/service ' . $command . ' status'));
			}

			if ((0 < substr_count($stat, 'running')) || ((stripos($stat, 'active') !== false) && (stripos($stat, 'inactive') === false) && (stripos($stat, 'failed') === false))) {
				return 'on';
			}

			if ($extendinfo == 0) {
				return 'off';
			}

			return $stat_ext;
		}
	}

	public function monitor_get_service_status_n()
	{
		$out = file_get_contents('/etc/brainy/data/monitor/monitor.xml');
		$out1 = simplexml_load_string($out);
		$out1 = json_decode(json_encode($out1), true);
		return $out1;
	}

	public function brainysql_query($query, $db)
	{
		global $lang;
		$vars = $this->config_read('/etc/brainy/conf/brainy.ini');
		$password = $vars['root_password'];
		$connect = new mysqli('127.0.0.1', 'root', $password, $db, '8889');

		if (mysqli_connect_error()) {
			trigger_error($lang['msg_mail_err_mysql_connect'] . mysqli_connect_error(), 256);
		}
		else {
			return $connect->query($query);
		}
	}

	public function monitor_runscaner_now()
	{
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php -q /etc/brainy/ssh/monitor/scaner.php > /dev/null 2> /dev/null');
	}

	public function stopApacheServiceAll()
	{
		$this->ssh('service httpd stop');
		$this->ssh('service nginx stop');
		$this->ssh('service php52-fpm stop');
		$this->ssh('service php53-fpm stop');
		$this->ssh('service php54-fpm stop');
		$this->ssh('service php55-fpm stop');
		$this->ssh('service php56-fpm stop');
		$this->ssh('service php70-fpm stop');
		$this->ssh('service php71-fpm stop');
		$this->ssh('service php72-fpm stop');
	}

	public function logAction($data, $namelog = '', $type = 'default')
	{
		$confProp = $this->config_read('/etc/brainy/data/properties/prop.conf');

		if ($confProp['debug'] == 1) {
			$path = debug_backtrace();

			if (2 < count($path)) {
				$place = $path[1];
			}
			else {
				$place = $path[0];
			}

			$func = $place['function'];
			$fileLogDelFPMConf = '';

			switch ($type) {
			case 'default':
				$fileLogDelFPMConf = '/etc/brainy/data/streams/logact_' . $namelog . date('d.M.Y') . '.log';
				break;
			}

			(, date('d.m.Y h:i:s') . ' - FUNC: ' . $func . ' : ' . $data . "\n", FILE_APPEND);
		}
	}

	public function traf_man_mn($m)
	{
		switch ($m) {
		case 'Jan':
			return 1;
		case 'Feb':
			return 2;
		case 'Mar':
			return 3;
		case 'Apr':
			return 4;
		case 'May':
			return 5;
		case 'Jun':
			return 6;
		case 'Jul':
			return 7;
		case 'Aug':
			return 8;
		case 'Sep':
			return 9;
		case 'Oct':
			return 10;
		case 'Nov':
			return 11;
		case 'Dec':
			return 12;
		}
	}

	public function AF_Socket($type, $path, $path_user)
	{
		global $lang;
		define('INET_SERVER', '127.0.0.1');
		define('INET_PORT_SERVICE', '1891');
		$ret = '';
		$socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);

		if ($socket == false) {
			$ret = $lang['server_tcp_socket_err_create'];
		}

		$result = socket_connect($socket, INET_SERVER, INET_PORT_SERVICE);

		if ($result == false) {
			$ret = $lang['server_tcp_socket_err_conn'];
		}

		$in = $type . ' ' . $path . ' ' . $path_user . "\n";
		$arr = array('code' => 2, 'mess' => $ret);

		if (!$ret) {
			socket_write($socket, $in, strlen($in));

			while ($out = socket_read($socket, 2048)) {
				if (trim($out) != '0') {
					$arr['code'] = 0;
				}
				else {
					$arr['code'] = 1;
				}

				$arr['mess'] = $out;
			}
		}

		socket_close($socket);
		return $arr;
	}

	public function UDS_Socket_v2($message)
	{
		global $lang;
		$ret = '';
		$dir_uds = '/var/run/brainy/brainy.sock';
		$socket = socket_create(AF_UNIX, SOCK_STREAM, 0);

		if ($socket == false) {
			$errorcode = socket_last_error();
			$errormsg = socket_strerror($errorcode);
			$ret = 'Create socket fauled';
		}

		$result = socket_connect($socket, $dir_uds);

		if ($result == false) {
			$errorcode = socket_last_error();
			$errormsg = socket_strerror($errorcode);
			$ret = 'Connection fauled';
		}

		$in = $message;
		$arr = array('code' => 2, 'mess' => $ret);

		if (!$ret) {
			if (!socket_send($socket, $message, strlen($message), 0)) {
				$errorcode = socket_last_error();
				$errormsg = socket_strerror($errorcode);

				if (trim($out) != '0') {
					$arr['code'] = 0;
				}
				else {
					$arr['code'] = 1;
				}

				$arr['mess'] = $out;
			}
			else {
			}
		}

		socket_close($socket);
		return $arr;
	}

	public function TCP_Socket_v2($message)
	{
		global $lang;
		define('INET_SERVER_2', '127.0.0.1');
		define('INET_PORT_SERVICE_2', '1892');
		$ret = '';
		$socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);

		if ($socket == false) {
			$ret = 'Create socket fauled';
		}

		$result = socket_connect($socket, INET_SERVER_2, INET_PORT_SERVICE_2);

		if ($result == false) {
			$ret = 'Connection fauled';
		}

		$in = $message;
		$arr = array('code' => 2, 'mess' => $ret);

		if (!$ret) {
			socket_write($socket, $in, strlen($in));

			while ($out = socket_read($socket, 2048)) {
				if (trim($out) != '0') {
					$arr['code'] = 0;
				}
				else {
					$arr['code'] = 1;
				}

				$arr['mess'] = $out;
			}
		}

		socket_close($socket);
		return $arr;
	}

	public function sendSshQuery($conn, $command)
	{
		$stream = ssh2_exec($conn, $command);
		stream_set_blocking($stream, true);
		$stream_out = ssh2_fetch_stream($stream, SSH2_STREAM_STDIO);
		$res = stream_get_contents($stream_out);
		fclose($stream);
		return $res;
	}
}


?>
