<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class smart_mon
{
	public $file_stream_bad_blocks = '/etc/brainy/data/smart_mon/streams_bad_blocks.txt';
	public $file_passed_tests = '/etc/brainy/data/smart_mon/passed_tests.txt';
	public $file_mail_list = '/etc/brainy/data/smart_mon/mail_list.txt';
	public $file_smartd_conf = '/etc/smartmontools/smartd.conf';

	public function get_drive_list()
	{
		$out = $this->ssh('fdisk -l | grep "Disk /dev/sd"');

		foreach ($out as $key => $value) {
			$res['drive_list'][] = $value;
		}

		return $res;
	}

	public function get_smart($drive_path)
	{
		if (!$this->check_value('dir', $drive_path)) {
			return false;
		}

		$out = $this->ssh('smartctl -a ' . substr($drive_path, 5, 8));
		$need_sec = false;

		foreach ($out as $key => $value) {
			if ($value == 'Vendor Specific SMART Attributes with Thresholds:') {
				$need_sec = true;
				continue;
			}

			if ($value == '') {
				$need_sec = false;
				continue;
			}
			if ($need_sec) {
				$res['smart_attr'][] = preg_split('/ +/', trim($value), 10);
			}
		}

		$smartSupport = 1;

		foreach ($out as $key => $value) {
			if (stripos($value, 'does not support SMART') !== false) {
				$smartSupport = 0;
			}
		}

		$res['smartSupport'] = $smartSupport;
		$need_sec = false;

		foreach ($out as $key => $value) {
			if ($value == '=== START OF INFORMATION SECTION ===') {
				$need_sec = true;
				continue;
			}

			if ($value == '') {
				$need_sec = false;
				continue;
			}
			if ($need_sec) {
				$res['inf_sect'][] = preg_split('/:/', trim($value), 2);
			}
		}

		return $res;
	}

	public function timetosec($time)
	{
		$sec = 0;

		foreach (array_reverse(explode(':', $time)) as $k => $v) {
			$sec += pow(60, $k) * $v;
		}

		return $sec;
	}

	public function check_stream_bad_blocks()
	{
		$streams = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($this->file_stream_bad_blocks));
		$line = 0;
		global $lang;

		foreach ($streams as $val) {
			++$line;

			if ($val == '') {
				continue;
			}

			$cur_stream = explode('|', $val);
			$stream_id = $cur_stream[0];
			$out[$stream_id]['data'] = $cur_stream[1];
			$out[$stream_id]['drive'] = $cur_stream[2];
			$out[$stream_id]['start_block'] = $cur_stream[3];
			$out[$stream_id]['end_block'] = $cur_stream[4];
			$pid = $this->getexistpid($stream_id);

			if ($pid != -1) {
				$stream_info = $this->read_stream($stream_id);

				if (stripos($stream_info[count($stream_info)], 'Checking for') !== false) {
					$last_stream_info = explode('elapsed', $stream_info[count($stream_info)]);
					$data = explode('%', $last_stream_info[count($last_stream_info) - 2]);
					$percent = preg_replace('/[^0-9.]/iu', '', $data[0]);

					if (stripos($data, 'errors') !== false) {
						$data2 = explode('errors', $data[0])[1];

						if (1 < strlen($data2)) {
							$percent = preg_replace('/[^0-9.]/iu', '', $data2);
						}
					}

					$out[$stream_id]['percent'] = (100 * ((($percent * $out[$stream_id]['end_block']) / 100) - $out[$stream_id]['start_block'])) / ($out[$stream_id]['end_block'] - $out[$stream_id]['start_block']);
					$out[$stream_id]['percent'] = round($out[$stream_id]['percent'], 2, PHP_ROUND_HALF_DOWN);

					if ($out[$stream_id]['percent'] < 0) {
						$out[$stream_id]['percent'] = 0;
					}

					$percent = $out[$stream_id]['percent'];
					$el = explode(',', $data[1]);
					$out[$stream_id]['elapsed'] = trim($el[1]);
					$elap = trim($el[1]);
					$remaining_sec = round(((100 - $percent) * $this->timetosec($elap)) / $percent, 0, PHP_ROUND_HALF_DOWN);
					$out[$stream_id]['timeleftfull'] = gmdate('H:i:s', $remaining_sec);
					$out[$stream_id]['speed'] = round((($out[$stream_id]['end_block'] - $out[$stream_id]['start_block']) * 1024 * $percent) / ($this->timetosec($elap) * 104857600), 2);
					$out[$stream_id]['pid'] = $pid;
				}
			}

			if ($pid == -1) {
				$stream_info = $this->read_stream($stream_id);
				$out[$stream_id]['bad_blocks'] = $stream_info[count($stream_info)];

				if ((stripos($out[$stream_id]['bad_blocks'], 'Interrupted') !== false) && (filesize('/etc/brainy/data/smart_mon/' . substr($out[$stream_id]['drive'], 5, 3)) == 0)) {
					file_put_contents($this->file_passed_tests, $stream_id . '|' . $out[$stream_id]['data'] . '|' . $out[$stream_id]['drive'] . '|' . substr($out[$stream_id]['bad_blocks'], 0, -1) . ' No bad blocks found ' . "\n", FILE_APPEND | LOCK_EX);
				}

				if ((stripos($out[$stream_id]['bad_blocks'], 'Interrupted') !== false) && (filesize('/etc/brainy/data/smart_mon/' . substr($out[$stream_id]['drive'], 5, 3)) != 0)) {
					file_put_contents($this->file_passed_tests, $stream_id . '|' . $out[$stream_id]['data'] . '|' . $out[$stream_id]['drive'] . '|' . substr($out[$stream_id]['bad_blocks'], 0, -1) . ' Bad blocks were found ' . "\n", FILE_APPEND | LOCK_EX);
				}

				if (stripos($out[$stream_id]['bad_blocks'], 'Interrupted') === false) {
					file_put_contents($this->file_passed_tests, $stream_id . '|' . $out[$stream_id]['data'] . '|' . $out[$stream_id]['drive'] . '|' . $out[$stream_id]['bad_blocks'], FILE_APPEND | LOCK_EX);
				}

				$out[$stream_id]['bad_blocks'] = str_replace('Pass completed', $lang['smart_mon_passcomplete'], $out[$stream_id]['bad_blocks']);
				$out[$stream_id]['bad_blocks'] = str_replace('No bad blocks found', $lang['smart_mon_nobadblock'], $out[$stream_id]['bad_blocks']);
				$out[$stream_id]['bad_blocks'] = str_replace('bad blocks found', $lang['smart_mon_badblockfound'], $out[$stream_id]['bad_blocks']);
				$out[$stream_id]['bad_blocks'] = str_replace('errors', $lang['smart_mon_errors'], $out[$stream_id]['bad_blocks']);
				$out[$stream_id]['bad_blocks'] = str_replace('Interrupted at block', $lang['smart_mon_interruptedatblock'], $out[$stream_id]['bad_blocks']);
				$this->del_string_new($stream_id, $this->file_stream_bad_blocks);
				$passed_tests = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($this->file_passed_tests));
				$i = 0;

				while ($i <= sizeof($passed_tests) - 12) {
					$first_passed_test_line = explode('|', @$passed_tests[$i]);
					$first_passed_test_id = $first_passed_test_line[0];
					$this->del_string_new($first_passed_test_id, $this->file_passed_tests);
					++$i;
				}

				$mail_list = preg_split('/[\\s,;]/', file_get_contents($this->file_mail_list));
				global $lang;

				foreach ($mail_list as $val) {
					if ($val == '') {
						continue;
					}

					mail($val, $lang['smart_mon_testfinish'] . $out[$stream_id]['drive'], $lang['smart_mon_hostname'] . gethostname() . '. ' . $lang['smart_mon_drivename'] . $out[$stream_id]['drive'] . '. ' . $out[$stream_id]['bad_blocks']);
				}
			}
		}

		return $out;
	}

	public function runtest_bad_blocks($drive_path, $start, $end)
	{
		if (!$this->check_value('number', $start)) {
			return false;
		}

		if (!$this->check_value('number', $end)) {
			return false;
		}

		$streams = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($this->file_stream_bad_blocks));

		foreach ($streams as $val) {
			$cur_stream = explode('|', $val);

			return -1;
		}

		$stream[]['comm'] = 'badblocks -sv ' . substr($drive_path, 5, 8) . ' ' . $end . ' ' . $start . ' -o /etc/brainy/data/smart_mon/' . substr($drive_path, 10, 3);
		$stream[0]['thread'] = '2';
		$stream[0]['array_start'] = array('auto' => 'inprogress,#stream_id#');
		$stream[0]['array_succes'] = array('auto' => 'succes,#stream_id#');
		$stream[0]['array_unsucces'] = array('auto' => 'unsucces,#stream_id#', 'error' => '#error#');
		$stream_id = $this->create_stream($stream);
		file_put_contents($this->file_stream_bad_blocks, $stream_id . '|' . date('d.m.Y H:i:s') . '|' . substr($drive_path, 5, 8) . '|' . $start . '|' . $end . "\n", FILE_APPEND | LOCK_EX);
		return $stream_id;
	}

	public function show_passed_tests()
	{
		$streams = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($this->file_passed_tests));
		$count = count($streams);
		global $lang;
		$i = $count - 1;

		while (0 <= $i) {
			$val = $streams[$i];

			if ($val == '') {
				continue;
			}

			$cur_stream = explode('|', $val);
			$stream_id = $cur_stream[0];
			$out[$stream_id]['data'] = $cur_stream[1];
			$out[$stream_id]['drive'] = $cur_stream[2];
			$out[$stream_id]['result'] = str_replace('Pass completed', $lang['smart_mon_passcomplete'], $cur_stream[3]);
			$out[$stream_id]['result'] = str_replace('No bad blocks found', $lang['smart_mon_nobadblock'], $out[$stream_id]['result']);
			$out[$stream_id]['result'] = str_replace('bad blocks found', $lang['smart_mon_badblockfound'], $out[$stream_id]['result']);
			$out[$stream_id]['result'] = str_replace('errors', $lang['smart_mon_errors'], $out[$stream_id]['result']);
			$out[$stream_id]['result'] = str_replace('Interrupted at block', $lang['smart_mon_interruptedatblock'], $out[$stream_id]['result']);
			--$i;
		}

		return $out;
	}

	public function Smart_On($drive_path)
	{
		if (!$this->check_value('dir', $drive_path)) {
			return false;
		}

		if ($GLOBALS['VIRT_TYPE'] != 'baremetal') {
			global $lang;
			return $lang['smart_mon_statonoff_notbare'];
		}

		$out = $this->ssh('smartctl -s on ' . substr($drive_path, 5, 8));
		$res = explode('\\.', $out[4]);
		global $lang;
		$res2 = str_replace('SMART Enabled', $lang['smart_mon_smartenabled'], $res[0]);
		return $res2;
	}

	public function Smart_Off($drive_path)
	{
		if (!$this->check_value('dir', $drive_path)) {
			return false;
		}

		if ($GLOBALS['VIRT_TYPE'] != 'baremetal') {
			global $lang;
			return $lang['smart_mon_statonoff_notbare'];
		}

		$out = $this->ssh('smartctl -s off ' . substr($drive_path, 5, 8));
		$res = explode('.', $out[4]);
		global $lang;
		$res[0] = str_replace('SMART Disabled', $lang['smart_mon_smartdisabled'], $res[0]);
		return $res[0];
	}

	public function show_mail_list()
	{
		$mail_list = preg_split('/[\\s,;]/', file_get_contents($this->file_mail_list));
		return $mail_list;
	}

	public function save_mail_list($mail_list)
	{
		$mail_list_exp = preg_split('/[\\s,;]/', $mail_list);
		global $lang;

		foreach ($mail_list_exp as $curmail) {
			$res['code'] = 1;
			$res['message'] = $lang['smart_mon_listemailfail'];

			return $res;
		}

		$res['code'] = 0;
		$res['message'] = $lang['smart_mon_Settings_Saved'];
		file_put_contents($this->file_mail_list, $mail_list);
		return $res;
	}

	public function stop_test($pid)
	{
		if (!$this->check_value('string', $pid)) {
			return false;
		}

		$out = $this->ssh('ps awx | awk \'{print $1,$9}\' |grep ' . $pid);
		$res = explode(' ', $out[0]);
		$drive = $res[1];
		$out = $this->ssh('ps awx | awk \'{print $1,$7}\' |grep ' . $drive);
		$res = explode(' ', $out[0]);
		$out = $this->ssh('kill ' . $res[0]);
		return $res[0];
	}

	public function update_start_end_blocks($drive_path)
	{
		$res = explode(' ', $drive_path);
		return ($res[4] / 1024) - 1;
	}

	public function show_smartd_settings($drive_path)
	{
		if (!$this->check_value('dir', $drive_path)) {
			return false;
		}

		$res['period'] = 'not_set';
		$drive = substr($drive_path, 5, 8);
		$task_exists = false;
		$str = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($this->file_smartd_conf));

		if ($GLOBALS['VIRT_TYPE'] != 'baremetal') {
			$res['baremetal'] = 0;
		}
		else {
			$res['baremetal'] = 1;
		}

		foreach ($str as $s) {
			$task_exists = true;
			$task_str = $s;
			break;
		}

		if ($task_exists) {
			$task_str_exp = explode(' ', $task_str);
			$period = $task_str_exp[7];
			$res[p] = $task_str;
			$period_exp = explode('/', $period);

			if ($period_exp[2][0] == '0') {
				$res[period_day] = $period_exp[2][1];
			}
			else {
				$res[period_day] = $period_exp[2];
			}

			$res[period_week] = $period_exp[3];

			if ($period_exp[4][0] == '0') {
				$res[period_hour] = $period_exp[4][1];
			}
			else {
				$res[period_hour] = $period_exp[4][0] . $period_exp[4][1];
			}

			$res[period] = 'day';

			if ($period_exp[2] !== '..') {
				$res[period] = 'month';
			}

			if ($period_exp[3] !== '.') {
				$res[period] = 'week';
			}

			$res[mail_list] = explode(',', $task_str_exp[9]);
		}

		return $res;
	}

	public function smartd_save_settings($drive, $period, $hour, $week, $day, $mail_list)
	{
		if (!$this->check_value('dir', $drive)) {
			return false;
		}

		if (!$this->check_value('number', $hour)) {
			return false;
		}

		if (!$this->check_value('number', $week)) {
			return false;
		}

		if (!$this->check_value('number', $day)) {
			return false;
		}

		$mail_list_exp = preg_split('/[\\s,;]/', $mail_list);
		global $lang;

		foreach ($mail_list_exp as $curmail) {
			$res['code'] = 1;
			$res['message'] = $lang['smart_mon_listemailfail'];

			return $res;
		}

		$res['code'] = 0;
		$res['message'] = $lang['smart_mon_Settings_Saved'];

		foreach ($mail_list_exp as $mail) {
			if ($mail_list_str == '') {
				$mail_list_str = $mail;
			}
			else if ($mail !== '') {
				$mail_list_str = $mail_list_str . ',' . $mail;
			}
		}

		if ($hour < 10) {
			$hour = '0' . $hour;
		}

		if ($day < 10) {
			$day = '0' . $day;
		}

		$this->del_string_new('DEVICESCAN', $this->file_smartd_conf);
		$this->del_string_new($drive, $this->file_smartd_conf);

		if ($period == 'day') {
			$conf_str = $drive . ' -a -o on -S on -s (S/../.././' . $hour . ') -m ' . $mail_list_str . ' -M daily';
		}

		if ($period == 'week') {
			$conf_str = $drive . ' -a -o on -S on -s (S/../../' . $week . '/' . $hour . ') -m ' . $mail_list_str . ' -M daily';
		}

		if ($period == 'month') {
			$conf_str = $drive . ' -a -o on -S on -s (S/../' . $day . '/./' . $hour . ') -m ' . $mail_list_str . ' -M daily';
		}

		file_put_contents($this->file_smartd_conf, $conf_str . "\n", FILE_APPEND | LOCK_EX);
		$this->ssh('service smartd restart');
		return $res;
	}

	public function check_smartd_installed()
	{
		$out = $this->ssh('ls /usr/sbin | grep "smartd"');

		if ($out[0] == 'smartd') {
			return true;
		}

		return false;
	}

	public function install_smartmontools()
	{
		$out = $this->ssh('yum -y install smartmontools');
		return 0;
	}
}


?>
