<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class ssh
{
	public $sshd_config_path = '/etc/ssh/sshd_config';
	public $sshd_config_file_path = '/etc/brainy/data/sshd/params';
	public $sshd_config_backup = '/etc/brainy/conf/backup/sshd';
	public $arr_params = array();

	public function ssh_current_load_config()
	{
		$out = $this->sudo_ssh('/usr/sbin/sshd -T');
		$i = 0;

		while ($i < count($out)) {
			$line = trim($out[$i]);
			list($var1, $var2) = explode(' ', $out[$i]);
			$var1 = mb_strtolower($var1);
			$arr[$var1] = $var2;
			++$i;
		}

		return $arr;
	}

	public function ssh_load_etc_config()
	{
		$fname = $this->sshd_config_path;
		if (file_exists($fname) && is_readable($fname)) {
			$out = file($fname);
			$n = count($out);
			$i = 0;

			while ($i < $n) {
				if (!trim($out[$i])) {
					unset($out[$i]);
				}
				else if (strstr($out[$i], '#')) {
					unset($out[$i]);
				}
				else {
					list($var1, $var2) = explode(' ', $out[$i]);
					$var1 = mb_strtolower(trim($var1));
					$params[$var1] = array(trim($var1), trim($var2));
				}

				++$i;
			}

			return $params;
		}

		return false;
	}

	public function ssh_load_file_params()
	{
		global $lang;
		$fname = $this->sshd_config_file_path;
		if (file_exists($fname) && is_readable($fname)) {
			$out = file($fname);
			$n = count($out);
			$parm_current = $this->ssh_current_load_config();
			$arr_etc = $this->ssh_load_etc_config();
			$i = 0;

			while ($i < $n) {
				if (!trim($out[$i])) {
					unset($out[$i]);
				}
				else if (strstr($out[$i], '#')) {
					unset($out[$i]);
				}
				else {
					list($var1, $var2, $var3, $var4) = explode('|', $out[$i]);
					$var3_old = $var3;
					$var3 = mb_strtolower(trim($var3));
					$element = ($parm_current[$var3] ? $parm_current[$var3] : '');
					$element_etc = ($arr_etc[$var3] ? $arr_etc[$var3][1] : '');

					if ($element_etc) {
						if ($element_etc == 'yes') {
							$select_option0 = array('yes', $lang['msg_select_yes']);
							$select_option1 = array('no', $lang['msg_select_no']);
							$select_option2 = array('default', $lang['msg_select_default']);
						}
						else {
							$select_option0 = array('no', $lang['msg_select_no']);
							$select_option1 = array('yes', $lang['msg_select_yes']);
							$select_option2 = array('default', $lang['msg_select_default']);
						}
					}
					else {
						$select_option0 = array('default', $lang['msg_select_default']);
						$select_option1 = array('yes', $lang['msg_select_yes']);
						$select_option2 = array('no', $lang['msg_select_no']);
					}

					$select_pos = array($select_option0, $select_option1, $select_option2);
					$params[$var3] = array(trim($var1), trim($var2), trim($var3_old), trim($var4), trim($element), trim($element_etc), $select_pos);
				}

				++$i;
			}

			return $params;
		}

		return false;
	}

	public function ssh_service($action)
	{
		global $lang;

		if (!$this->check_value('string', $action)) {
			return 0;
		}

		if (stripos($GLOBALS['OS_VERSION'], 'centos7') !== false) {
			if ($action == 'status') {
				if (stripos(implode(',', $this->sudo_ssh('systemctl is-active sshd')), 'inactive') !== false) {
					$out[] = $lang['ssh_stat_stop'];
				}
				else {
					$out[] = $lang['ssh_stat_run'];
				}
			}
			else {
				$this->sudo_ssh('systemctl ' . $action . ' sshd');

				if (stripos(implode(',', $this->sudo_ssh('systemctl is-active sshd')), 'inactive') !== false) {
					$out[] = $lang['ssh_stat_stop'];
				}
				else {
					$out[] = $lang['ssh_stat_run'];
				}
			}
		}
		else {
			$out = $this->monitor_get_service_status('service sshd status', 1);

			if ($out == 'on') {
				$out = $lang['ssh_stat_run'];
			}
			else {
				$out = $lang['ssh_stat_stop'] . ' ' . $out;
			}
		}

		return $out;
	}

	public function ssh_set_new_params($str_params)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-\\.\\;\\=]+$/', $str_params)) {
			return false;
		}

		global $lang;
		$arr_user = $this->ssh_string2array($str_params);
		$fname = $this->sshd_config_file_path;
		if (file_exists($fname) && is_readable($fname)) {
			$out = file($fname);
			$n = count($out);
			$parm_current = $this->ssh_current_load_config();
			$arr_etc = $this->ssh_load_etc_config();
			$i = 0;

			while ($i < $n) {
				if (!trim($out[$i])) {
					unset($out[$i]);
				}
				else if (strstr($out[$i], '#')) {
					unset($out[$i]);
				}
				else {
					list($var1, $var2, $var3, $var4) = explode('|', $out[$i]);
					$var3_old = $var3;
					$var3 = mb_strtolower(trim($var3));
					$element = ($parm_current[$var3] ? $parm_current[$var3] : '');
					$element_user = ($arr_user[$var3] ? $arr_user[$var3][1] : '');

					if ($element_user == 'yes') {
						$select_option0 = array('yes', $lang['msg_select_yes']);
						$select_option1 = array('no', $lang['msg_select_no']);
						$select_option2 = array('default', $lang['msg_select_default']);
					}
					else if ($element_user == 'no') {
						$select_option0 = array('no', $lang['msg_select_no']);
						$select_option1 = array('yes', $lang['msg_select_yes']);
						$select_option2 = array('default', $lang['msg_select_default']);
					}
					else {
						$select_option0 = array('default', $lang['msg_select_default']);
						$select_option1 = array('yes', $lang['msg_select_yes']);
						$select_option2 = array('no', $lang['msg_select_no']);
					}

					$select_pos = array($select_option0, $select_option1, $select_option2);
					$params[$var3] = array(trim($var1), trim($var2), trim($var3_old), trim($var4), trim($element), trim($element_user), $select_pos);
				}

				++$i;
			}

			return $params;
		}

		return false;
	}

	public function ssh_string2array($str_params)
	{
		$arr = explode(';', $str_params);
		$i = 0;

		while ($i < count($arr)) {
			list($x0, $x1) = explode('=', trim($arr[$i]));
			$key = mb_strtolower(trim($x0));
			$out[$key] = array(trim($x0), trim($x1));
			++$i;
		}

		return $out;
	}

	public function ssh_config_save($params)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-\\.\\;\\=]+$/', $params)) {
			return false;
		}

		$addr = $this->sshd_config_backup . '/sshd_config';
		$del = ' ';
		$comm = array('#');
		$mass = $this->ssh_string2array($params);
		$oldPort = $this->getSshPort();
		$this->setSshPort($mass['port'][1], $oldPort);
		$this->_ssh_save_config($params, $del, $comm);
		$this->ssh_service('restart');
	}

	public function getSshPort()
	{
		$mass = array('Port');
		$del = ' ';
		$comm = array('#');
		return $this->parse_config_read_param('/etc/ssh/sshd_config', $mass, $del, $comm)['Port'];
	}

	public function setSshPort($port, $portold)
	{
		global $lang;
		if (!is_numeric($port) || !is_numeric($portold)) {
			$res['code'] = -1;
			$res['message'] = $lang['properties_ssh_port_formatfailed'];
			return $res;
		}

		if (is_file('/etc/csf/csf.conf')) {
			$mass = array('TCP_IN', 'TCP_OUT', 'TCP6_IN', 'TCP6_OUT');
			$del = '=';
			$comm = array('#');
			$resCSF = $this->parse_config_read_param('/etc/csf/csf.conf', $mass, $del, $comm);

			foreach ($resCSF as $key => $curconf) {
				$resCSF[$key] = str_replace(',' . $portold . ',', ',' . $port . ',', $curconf);
			}

			foreach ($resCSF as $key => $curconf) {
				$this->ssh('sed -i "/^' . $key . '/c' . $key . ' = \\"' . $curconf . '\\"" /etc/csf/csf.conf');
			}

			$this->ssh('csf -r');
		}
		else {
			$this->ssh('iptables -A INPUT -m state --state NEW -m tcp -p tcp --dport ' . $port . ' -j ACCEPT');
			$this->ssh('service iptables save');
		}

		$this->ssh('sed -i "/^Port/cPort ' . $port . '" /etc/ssh/sshd_config');
		$this->ssh('sed -i "/^#Port/cPort ' . $port . '" /etc/ssh/sshd_config');
		$this->monitor_comm_os('sshd', 'restart');
		$res['code'] = 0;
		$res['message'] = $lang['properties_ssh_port_saveok'];
		return $res;
	}

	public function _ssh_save_config($params, $del = NULL, $comm = NULL)
	{
		if (!preg_match('/^[a-zA-Z0-9_\\-\\.\\;\\=]+$/', $params)) {
			return false;
		}

		$addr = $this->sshd_config_path;
		$arr_params = $this->ssh_string2array($params);
		$h = file($addr);

		while (list($var, $z) = each($h)) {
			$flag = false;
			$el = '';

			foreach ($arr_params as $key => $val) {
				$search0 = $val[0] . ' ';
				$search1 = '#' . $val[0] . ' ';
				$flag = true;
				$el0 = $val[0];
				$el = trim($val[1]);
				if (($el == 'default') || ($el == '')) {
					$flag = false;
				}

				break;
			}

			if ($flag) {
				$new_file[] = $el0 . ' ' . $el . "\n";
			}
			else {
				$new_file[] = $z;
			}
		}

		$filename = $this->sshd_config_backup . '/sshd_config.' . time();
		$h = fopen($filename, 'w+');

		while (list($key, $val) = each($new_file)) {
			fwrite($h, $val);
		}

		fclose($h);
		unset($h);
		if (file_exists($filename) && is_readable($filename)) {
			$this->sudo_ssh('cp -p ' . $filename . ' /etc/ssh/sshd_config');
			return true;
		}

		return false;
	}

	public function ssh_config_restore()
	{
		$arr = $this->ssh_load_restore_file();
		$file_restore = $this->sshd_config_backup . '/' . $arr[0];
		$this->sudo_ssh('cp -p ' . $file_restore . ' /etc/ssh/sshd_config');
	}

	public function ssh_load_restore_file()
	{
		$dir = $this->sshd_config_backup . '/';
		$var = $this->sudo_ssh('ls ' . $dir . ' | grep \'sshd_config.\' | sort &>/dev/stdout');
		return $var;
	}

	public function ssh_load_etc_expert()
	{
		$addr = $this->sshd_config_path;
		$h = file($addr);
		return $h;
	}

	public function ssh_save_config_expert($val)
	{
		$user = $this->user;

		if (!$this->check_value('user', $user['username'])) {
			return false;
		}

		$addr = $this->sshd_config_path;
		$arr = explode("\n", str_replace("\r", '', $val));
		$h = fopen($addr, 'w+');
		flock($h, LOCK_EX);

		while (list($key, $val) = each($arr)) {
			fwrite($h, $val . "\n");
		}

		flock($h, LOCK_UN);
		fclose();
	}

	public function ssh_restore($res, $status)
	{
		$resmass['info'] = $res;
		$resmass['status'] = $status;
		return $resmass;
	}
}


?>
