<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class traffic_usage
{
	private $db_file_patch = '/etc/brainy/data/traffic_usage';
	private $db_file_ext = '.tdb';
	public $dir_users_path = '/etc/brainy/data/users';
	public $mail_log_exim = '/var/log/exim/main.log';
	public $logs_access = '_access';
	public $db_data_users;

	public function traf_load_users()
	{
		return $this->get_users();
	}

	public function traf_load_db_date($db_date = '', $gr)
	{
		if (!$this->check_value('strdot', $db_date)) {
			return false;
		}

		if (!$this->check_value('strdot', $gr)) {
			return false;
		}

		$t = time();
		$filename = intval(date('m', $t)) . '.' . date('Y', $t);

		if ($db_date != '') {
			$p = explode('.', $db_date);
			$filename = intval($p[0]) . '.' . $p[1];
		}

		if ($gr == 'y') {
			$users = $this->get_users();
		}
		else {
			$users[] = $gr;
		}

		$out = '';
		$dir = $this->db_file_patch . '/' . $filename;

		if (file_exists($dir)) {
			$i = 0;

			while ($i < count($users)) {
				$f_data = file($dir);
				$b = false;
				$z = 0;

				while ($z < count($f_data)) {
					if (strstr($f_data[$z], $users[$i] . ':')) {
						$p = explode(':', $f_data[$z]);
						$el = explode('/', $p[1]);
						$all = intval($el[0]) + intval($el[1]) + intval($el[2]);
						$out[] = array($users[$i], intval($el[0]), intval($el[1]), intval($el[2]), $all);
						$b = true;
						break;
					}

					++$z;
				}

				if (!$b) {
					$out[] = array($users[$i], 0, 0, 0, 0);
				}

				++$i;
			}
		}
		else {
			$i = 0;

			while ($i < count($users)) {
				$out[] = array($users[$i], 0, 0, 0, 0);
				++$i;
			}
		}

		$this->db_data_users = $out;
		return $out;
	}

	public function traf_get_db_data()
	{
		return $this->db_data_users;
	}

	public function traf_load_traffic($user)
	{
		if (!$this->check_user($user)) {
			return 0;
		}

		$file = $this->dir_users_path . '/' . $user;
		$out = $this->config_read($file);
		$arr = explode('/', $out['traffic']);
		array_unshift($arr, $user);
		return $arr;
	}

	public function traf_set_date_scaning($user, $time = '0')
	{
		if (!$this->check_user($user)) {
			return 0;
		}

		$file = $this->dir_users_path . '/' . $user;
		$arr['traffic_date'] = $time;
		$this->traf_config_save($file, $arr, 'add');
	}

	public function traf_get_date_scaning($user)
	{
		if (!$this->check_user($user)) {
			return 0;
		}

		$file = $this->dir_users_path . '/' . $user;
		$out = $this->config_read($file);
		$n = ($out['traffic_date'] == '' ? 0 : $out['traffic_date']);
		return $n;
	}

	public function traf_site_list($user = '')
	{
		if ($user == '') {
			return array();
		}

		if (!$this->check_user($user)) {
			return 0;
		}

		$w = new Webserver();
		$hosts = $w->get_virt_hosts_quick($user);

		if (sizeof($hosts)) {
			$i = 0;

			while ($i < count($hosts)) {
				$n = $this->traf_get_date_scaning($user);
				$arr[$hosts[$i]] = $n;
				++$i;
			}

			return $arr;
		}

		return array();
	}

	public function traf_log_read($user = '')
	{
		if ($user == '') {
			return NULL;
		}

		if (!$this->check_user($user)) {
			return 0;
		}

		$out_apache = array();
		$out_mail = array();
		$out_ftp = array();
		$time = time();
		$out_apache = $this->traf_log_read_webserver($user, $time);
		echo 'WEBSERVER: ';
		print_r($user . "\n");
		print_r($out_apache);
		$out_ftp = $this->traf_log_read_ftp($user, $time);
		echo 'FTP: ';
		print_r($user . "\n");
		print_r($out_ftp);
		$file = $this->dir_users_path . '/' . $user;
		$mess = $this->config_read($file);
		$yo = date('Y', time());
		$mn = date('m', time());
		$db_dir = $this->db_file_patch . '/';
		$this->sudo_ssh('mkdir -p ' . $db_dir . ' &>/dev/null');
		$i = 0;

		while ($i < count($out_apache)) {
			if ($out_apache[$i] != 0) {
				$db_file = $db_dir . ($i + 1) . '.' . $yo;

				if (file_exists($db_file)) {
					$arr = file($db_file);
					$b = false;
					$z = 0;

					while ($z < count($arr)) {
						if (strstr($arr[$z], $user . ':')) {
							$p = explode(':', $arr[$z]);
							$params = explode('/', $p[1]);
							$n = intval($params[0]) + $out_apache[$i];
							$arr[$z] = $user . ':' . $n . '/' . $params[1] . '/' . $params[2];
							$h = fopen($db_file, 'w+');
							flock($h, LOCK_EX);
							$x = 0;

							while ($x < count($arr)) {
								fwrite($h, $arr[$x]);
								++$x;
							}

							flock($h, LOCK_UN);
							fclose($h);
							unset($h);
							$b = true;
							break;
						}

						++$z;
					}

					if (!$b) {
						$n = $out_apache[$i];
						$arr[] = $user . ':' . $n . '/0/0' . "\n";
						$h = fopen($db_file, 'w+');
						flock($h, LOCK_EX);
						$x = 0;

						while ($x < count($arr)) {
							fwrite($h, $arr[$x]);
							++$x;
						}

						flock($h, LOCK_UN);
						fclose($h);
						unset($h);
					}
				}
				else {
					$param = $user . ':' . $out_apache[$i] . '/0/0' . "\n";
					$h = fopen($db_file, 'w+');
					flock($h, LOCK_EX);
					fwrite($h, $param);
					flock($h, LOCK_UN);
					fclose($h);
					unset($h);
				}
			}

			++$i;
		}

		$i = 0;

		while ($i < count($out_ftp)) {
			if ($out_ftp[$i] != 0) {
				$db_file = $db_dir . ($i + 1) . '.' . $yo;

				if (file_exists($db_file)) {
					$arr = file($db_file);
					$b = false;
					$z = 0;

					while ($z < count($arr)) {
						if (strstr($arr[$z], $user . ':')) {
							$p = explode(':', $arr[$z]);
							$params = explode('/', $p[1]);
							$n = intval($params[2]) + $out_ftp[$i];
							$arr[$z] = $user . ':' . $params[0] . '/' . $params[1] . '/' . $n . "\n";
							$h = fopen($db_file, 'w+');
							$x = 0;

							while ($x < count($arr)) {
								fwrite($h, $arr[$x]);
								++$x;
							}

							fclose($h);
							unset($h);
							$b = true;
							break;
						}

						++$z;
					}

					if (!$b) {
						$n = $out_ftp[$i];
						$arr[] = $user . ':0/0/' . $n . "\n";
						$h = fopen($db_file, 'w+');
						$x = 0;

						while ($x < count($arr)) {
							fwrite($h, $arr[$x]);
							++$x;
						}

						fclose($h);
						unset($h);
					}
				}
				else {
					$param = $user . ':0/0/' . $out_ftp[$i] . "\n";
					$h = fopen($db_file, 'w+');
					fwrite($h, $param);
					fclose($h);
					unset($h);
				}
			}

			++$i;
		}

		$db_file = $db_dir . intval($mn) . '.' . $yo;

		if (is_file($db_file)) {
			$arr = file($db_file);
			$a_ = '';
			$b = false;
			$z = 0;

			while ($z < count($arr)) {
				if (strstr($arr[$z], $user . ':')) {
					$p = explode(':', $arr[$z]);
					$params = $p[1];
					$file = $this->dir_users_path . '/' . $user;
					$a_['traffic'] = trim($params);
					$this->traf_config_save($file, $a_, 'add');
					$b = true;
					break;
				}

				++$z;
			}

			if (!$b) {
				$a_ = '';
				$file = $this->dir_users_path . '/' . $user;
				$a_['traffic'] = '0/0/0';
				$this->traf_config_save($file, $a_, 'add');
			}
		}
		else {
			$a_ = '';
			$file = $this->dir_users_path . '/' . $user;
			$a_['traffic'] = '0/0/0';
			$this->traf_config_save($file, $a_, 'add');
		}
	}

	public function traf_log_read_webserver($user = '', $time)
	{
		if ($user == '') {
			return NULL;
		}

		if (!$this->check_user($user)) {
			return 0;
		}

		$time_last = $this->traf_get_date_scaning($user);
		$domains_list = $this->traf_site_list($user);
		$n = 0;
		$arr_mn_n = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
		$webserver = new webserver();
		$back_server = $webserver->detect_back_server();

		if ($back_server['service'] == 'nginx') {
			$logs_path = $GLOBALS['NGINX_VHOSTLOGS'];
		}
		else {
			$logs_path = $GLOBALS['HTTPD_VHOSTLOGS'];
		}

		$date = new DateTime(NULL);
		$offset_webserver = date('Z');

		foreach ($domains_list as $key => $val) {
			$domain = $key;
			$log_file = $logs_path . '/' . $domain . $this->logs_access;

			if (is_file($log_file)) {
				$file_time = filemtime($log_file);

				if ($file_time < $time_last) {
					continue;
				}

				if ($f = fopen($log_file, 'r')) {
					if (!feof($f)) {
						$log = fgets($f);
						$regex = '/^(\\S+) (\\S+) (\\S+) \\[([^:]+):(\\d+:\\d+:\\d+) ([^\\]]+)\\] \\"(\\S+) (.*?) (\\S+)\\" (\\S+) (\\S+) "([^"]*)" "([^"]*)"$/';
						preg_match($regex, $log, $a);
						$arr_date = explode('/', $a[4]);
						$arr_time = explode(':', $a[5]);
						$int_month = $this->traf_man_mn($arr_date[1]);
						$linux_time = mktime($arr_time[0], $arr_time[1], $arr_time[2], $int_month, $arr_date[0], $arr_date[2]) + $offset_webserver;

						$arr_mn_n += $int_month - 1;

						continue;
					}

					fclose($f);
					unset($f);
				}
			}
		}

		return $arr_mn_n;
	}

	public function traf_log_read_mail($time, $mail_log_all = NULL)
	{
		$user_list = $this->traf_load_users();

		foreach ($user_list as $key => $user) {
			$n = 0;
			$arr_mn_n = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
			$time_last = $this->traf_get_date_scaning($user);
			$domains_list = $this->traf_site_list($user);
			$date = new DateTime(NULL);
			$offset_webserver = date('Z');

			foreach ($domains_list as $cur_dom => $last_upd) {
				$prev_row_log = '';

				foreach ($mail_log_all as $id_row => $one_row_log) {
					$regex = '/^(\\S+) (\\S+) (\\S+) (\\S+) (.*)@' . $cur_dom . '(.*) H=(.*)P=(.*)X=(.*)A=(.*)S=(.*)id=(.*)/i';
					preg_match($regex, $one_row_log, $a);

					if (sizeof($a)) {
						$a[6] = $cur_dom;
					}

					if (!sizeof($a)) {
						$regex = '/^(\\S+) (\\S+) (\\S+) (\\S+) (\\S+) (.*)@' . $cur_dom . '(.*) R=(.*)T=(.*)/i';
						preg_match($regex, $one_row_log, $a);

						if (sizeof($a)) {
							$regex = '/^(\\S+) (\\S+) (\\S+) (\\S+) (\\S+) H=(.*)P=(.*)X=(.*)S=(.*)id=(.*)/i';
							preg_match($regex, $prev_row_log, $a);

							if (sizeof($a)) {
								$a[11] = $a[9];
							}
						}
					}

					if (sizeof($a)) {
						$arr_date = explode('-', $a[1]);
						$arr_time = explode(':', $a[2]);
						$int_month = $arr_date[1];
						$linux_time = mktime($arr_time[0], $arr_time[1], $arr_time[2], $arr_date[1], $arr_date[2], $arr_date[0]) + $offset_webserver;

						if ($time_last < $linux_time) {
							$arr_mn_n += $int_month - 1;
						}
						else {
							print_r($time_last . "\n");
							print_r($linux_time . "\n");
						}
					}

					$prev_row_log = $one_row_log;
				}
			}

			$out_mail = $arr_mn_n;
			$file = $this->dir_users_path . '/' . $user;
			$mess = $this->config_read($file);
			$yo = date('Y', time());
			$mn = date('m', time());
			$db_dir = $this->db_file_patch . '/';
			$i = 0;

			while ($i < count($out_mail)) {
				if ($out_mail[$i] != 0) {
					$db_file = $db_dir . ($i + 1) . '.' . $yo;

					if (file_exists($db_file)) {
						$arr = file($db_file);
						$b = false;
						$z = 0;

						while ($z < count($arr)) {
							if (strstr($arr[$z], $user . ':')) {
								$p = explode(':', $arr[$z]);
								$params = explode('/', $p[1]);
								$n = intval($params[1]) + $out_mail[$i];
								$arr[$z] = $user . ':' . $params[0] . '/' . $n . '/' . $params[2];
								$h = fopen($db_file, 'w+');
								$x = 0;

								while ($x < count($arr)) {
									fwrite($h, $arr[$x]);
									++$x;
								}

								fclose($h);
								unset($h);
								$b = true;
								break;
							}

							++$z;
						}

						if (!$b) {
							$n = $out_mail[$i];
							$arr[] = $user . ':0/' . $n . '/0' . "\n";
							$h = fopen($db_file, 'w+');
							$x = 0;

							while ($x < count($arr)) {
								fwrite($h, $arr[$x]);
								++$x;
							}

							fclose($h);
							unset($h);
						}
					}
					else {
						$param = $user . ':0/' . $out_mail[$i] . '/0' . "\n";
						$h = fopen($db_file, 'w+');
						fwrite($h, $param);
						fclose($h);
						unset($h);
					}
				}

				++$i;
			}

			$this->traf_set_date_scaning($user, time());
		}

		return $arr_mn_n;
	}

	public function parse_log_ftp($time_last, $log_row, &$arr_mn_n, $offset_webserver)
	{
		$regex = '/^(\\S+) (\\S+) (\\S+) \\[([^:]+):(\\d+:\\d+:\\d+) ([^\\]]+)\\] \\"(\\S+) (.*?)\\" (\\S+) (\\S+)$/';
		preg_match($regex, $log_row, $a);

		if (sizeof($a)) {
			$arr_date = explode('/', $a[4]);
			$arr_time = explode(':', $a[5]);
			$int_month = $this->traf_man_mn($arr_date[1]);
			$linux_time = mktime($arr_time[0], $arr_time[1], $arr_time[2], $int_month, $arr_date[0], $arr_date[2]) + $offset_webserver;

			if ($time_last < $linux_time) {
				$arr_mn_n += $int_month - 1;
			}
		}
	}

	public function traf_log_read_ftp($user, $time)
	{
		if ($user == '') {
			return NULL;
		}

		if (!$this->check_user($user)) {
			return 0;
		}

		$time_last = $this->traf_get_date_scaning($user);
		$date = new DateTime(NULL);
		$offset_webserver = date('Z');
		$ftp = new ftp();
		$getservname = $ftp->getservicename();

		switch ($getservname['typeftp']) {
		case 'pure-ftpd':
			$mass = array('AltLog');
			$del = ' ';
			$comm = array('#');
			$ftp_filelog = $this->parse_config_read_param($GLOBALS['PURE_FTPD_PATH'], $mass, $del, $comm);
			$ftp_filelog = $ftp_filelog['AltLog'];
			$ftp_filelog = str_replace('clf:', '', $ftp_filelog);
			break;

		case 'proftpd':
			$mass = array('ExtendedLog');
			$del = ' ';
			$comm = array('#');
			$ftp_pathfileuser = $this->parse_config_read_param($GLOBALS['PRO_FTPD_PATH'], $mass, $del, $comm);
			$ftp_filelog = $ftp_pathfileuser['ExtendedLog'];
			$ftp_filelog = explode(' ', $ftp_filelog)[0];
			break;
		}

		$arr_mn_n = array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

		if ($getservname['typeftp'] == 'pure-ftpd') {
			$comm = 'cat ' . $ftp_filelog . ' | grep "/' . $user . '/"';
			$rows_logs = $this->ssh($comm);

			foreach ($rows_logs as $log_row) {
				$this->parse_log_ftp($time_last, $log_row, $arr_mn_n, $offset_webserver);
			}
		}

		if ($getservname['typeftp'] == 'proftpd') {
			$comm = 'cat ' . $ftp_filelog . ' | grep "STOR\\|RETR"';
			$rows_logs = $this->ssh($comm);
			$subuser = $ftp->ftp_getuser_proftpd_all($user);

			foreach ($rows_logs as $log_row) {
				foreach ($subuser as $onesub) {
					if (0 < strpos($log_row, ' ' . $onesub . ' [')) {
						$this->parse_log_ftp($time_last, $log_row, $arr_mn_n, $offset_webserver);
					}
				}
			}
		}

		return $arr_mn_n;
	}

	public function traf_load_db($date)
	{
		if (!$this->check_value('strdot', $db_date)) {
			return false;
		}

		$f = $this->db_file_patch . '/' . $date . $this->db_file_ext;

		if (is_file($f)) {
			$db = file($f);
			$this->db_data = $db;
			return true;
		}

		$dir = $this->db_file_patch;
		$this->sudo_ssh('mkdir ' . $dir);
		$h = fopen($f, 'w+');
		fwrite($h, '');
		fclose($h);
		$db = file($f);
		$this->db_data = $db;
		unset($h);
		return true;
	}

	public function traf_n2mn($n)
	{
		switch ($n) {
		case 0:
			return 'Jan';
		case 1:
			return 'Feb';
		case 2:
			return 'Mar';
		case 3:
			return 'Apr';
		case 4:
			return 'May';
		case 5:
			return 'Jun';
		case 6:
			return 'Jul';
		case 7:
			return 'Aug';
		case 8:
			return 'Sep';
		case 9:
			return 'Oct';
		case 10:
			return 'Nov';
		case 11:
			return 'Dec';
		}
	}

	private function traf_config_save($file, $arr_c, $type)
	{
		$fp = fopen($file, 'a+');
		flock($fp, LOCK_EX);
		$cur = parse_ini_file($file);
		$arr = $arr_c;

		if ($type == 'add') {
			$out = array();

			foreach ($cur as $key => $val) {
				if (!$key) {
					continue;
				}

				$b = false;

				foreach ($arr as $key_c => $val_c) {
					$out[$key_c] = $val_c;
					$b = true;
					unset($arr[$key_c]);
					break;
				}

				if (!$b) {
					$out[$key] = $val;
				}
			}

			if (sizeof($arr)) {
				foreach ($arr as $key_p => $val_p) {
					$out[$key_p] = $val_p;
				}
			}
		}
		else if ($type == 'del') {
			$out = array();

			foreach ($cur as $key => $val) {
				if (!$key) {
					continue;
				}

				$b = false;

				foreach ($arr as $key_c => $val_c) {
					unset($arr[$key_c]);
					$b = true;
					break;
				}

				if (!$b) {
					$out[$key] = $val;
				}
			}
		}
		else if (sizeof($arr)) {
			foreach ($arr as $key_p => $val_p) {
				$out[$key_p] = $val_p;
			}
		}

		ftruncate($fp, 0);
		$res = array();

		foreach ($out as $key => $val) {
			if (is_array($val)) {
				$res[] = '[' . $key . ']';

				foreach ($val as $skey => $sval) {
					$res[] = $skey . '=' . (is_numeric($sval) ? $sval : '' . $sval . '');
				}
			}
			else {
				$val_escape = str_replace('"', '\\"', $val);
				$res[] = $key . '=' . (is_numeric($val) ? $val : '"' . $val_escape . '"');
			}
		}

		fwrite($fp, implode("\r\n", $res));
		fflush($fp);
		flock($fp, LOCK_UN);
		fclose($fp);
		return $res;
	}

	public function traf_load_list_db_only_date($type, $cur_date)
	{
		if (!$this->check_value('date', $cur_date)) {
			return false;
		}

		$t = explode('-', $cur_date);
		$time = mktime(0, 0, 0, $t[1], $t[0], $t[2]);

		if ($type == 'PREV') {
			$d = date('m.Y', strtotime('-1 months'));
		}
		else if ($type == 'NEXT') {
			$d = date('m.Y', strtotime('+1 months'));
		}

		return $d;
	}

	public function traf_sort($arr, $sort = 'NAME')
	{
		foreach ($arr as $key => $val) {
			if (sizeof($val) != 5) {
				return false;
			}

			if (!$this->check_user($val[0])) {
				return false;
			}

			if (!$this->check_value('number', $val[1])) {
				return false;
			}

			if (!$this->check_value('number', trim($val[2]))) {
				return false;
			}

			if (!$this->check_value('number', $val[3])) {
				return false;
			}

			return false;
		}

		if ($sort == 'NAME') {
			function mysort($a, $b)
			{
				return $b[0] < $a[0];
			}
		}
		else if ($sort == 'APACHE') {
			function mysort($a, $b)
			{
				return $a[1] < $b[1];
			}
		}
		else if ($sort == 'MAIL') {
			function mysort($a, $b)
			{
				return $a[2] < $b[2];
			}
		}
		else if ($sort == 'FTP') {
			function mysort($a, $b)
			{
				return $a[3] < $b[3];
			}
		}
		else if ($sort == 'ALL') {
			function mysort($a, $b)
			{
				return $a[4] < $b[4];
			}
		}

		usort($arr, 'mysort');
		return $arr;
	}

	public function traf_sum_users()
	{
		$t1 = 0;
		$t2 = 0;
		$t3 = 0;
		$t4 = 0;
		$dt = $this->db_data_users;

		foreach ($dt as $key => $item) {
			$t1 += $item[1];
			$t2 += $item[2];
			$t3 += $item[3];
			$t4 += $item[4];
		}

		global $smarty;
		$cron = new crontab();
		$period = $cron->crontab_check_is_job('traffic.php');
		$period = $cron->getperiodcron_human($period);
		$smarty->assign('traff_periodupdate', $period);
		$out = array('ИТОГО:', $t1, $t2, $t3, $t4);
		return $out;
	}

	private function _traffic_sort_menu($type, $date_file)
	{
		$out = $this->traffic_sort_type($type, $date_file);
		return $out;
	}

	public function traffic_load_list_db()
	{
		$dir = $this->db_file_patch . '/';
		$out = $this->sudo_ssh('ls ' . $dir . ' | sed \'s/\\..*$//\' | sort -n &>/dev/stdout');
		return $out;
	}

	public function traf_crontab_check()
	{
		$crontab = new crontab();
		$sss = $crontab->crontab_check_brainy_status_command('');
		return $sss;
	}
}


?>
