<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class transfer
{
	public $mintimeout_waitendstream_trans = 15;
	public $backup_jobs = 'backups_jobs';
	public $backup_emails = 'backups_email';
	public $backup_email_file = 'emails';
	public $backup_email_forward = 'emails_forward';
	public $backup_dns_zone = 'dns_zones';
	public $user_tmp = 'tmp';
	public $dir_backup_configs = 'tmp/backups_config';
	public $listdirJail = array('bin', 'dev', 'etc', 'lib64', 'usr', 'lib', 'opt', 'var', 'proc');
	public $pathTophpInter = '/etc/brainy/src/compiled/php5/bin/php';
	public $portConn = 22;

	public function __construct()
	{
		if (stripos($this->backup_jobs, $this->dir_backup_configs) === false) {
			$this->mysql_dir_backup = $this->dir_backup_configs . '/' . $this->mysql_dir_backup;
			$this->backup_jobs = $this->dir_backup_configs . '/' . $this->backup_jobs;
		}

		if (stripos($GLOBALS['BACKUP_DIR_AUTOINS'], $this->dir_backup_configs) === false) {
			$GLOBALS['BACKUP_DIR_AUTOINS'] = $this->dir_backup_configs . '/' . $GLOBALS['BACKUP_DIR_AUTOINS'];
			$GLOBALS['TRANSFER_MYSQL_DIR'] = $this->dir_backup_configs . '/' . $GLOBALS['TRANSFER_MYSQL_DIR'];
			$GLOBALS['BACKUP_DIR_FTPS'] = $this->dir_backup_configs . '/' . $GLOBALS['BACKUP_DIR_FTPS'];
			$GLOBALS['BACKUP_VHOSTS_DIR'] = $this->dir_backup_configs . '/' . $GLOBALS['BACKUP_VHOSTS_DIR'];
			$GLOBALS['BACKUP_USER_INFO_FILE'] = $this->dir_backup_configs . '/' . $GLOBALS['BACKUP_USER_INFO_FILE'];
		}
	}

	public function getconfig($user_data, $serialdata)
	{
		$arr_conf['rsa_key'] = file_get_contents($GLOBALS['TRANSFER_KEY_RSA_PATH'] . $GLOBALS['TRANSFER_KEY_RSA_PUB']);
		$arr_conf['rsa_key_private'] = file_get_contents($GLOBALS['TRANSFER_KEY_RSA_PATH'] . $GLOBALS['TRANSFER_KEY_RSA_NAME']);
		return $arr_conf;
	}

	public function generatekeyrsa($user_data, $serialdata)
	{
		$comm = 'echo -e  \'y' . "\n" . '\' | ssh-keygen -f ' . $GLOBALS['TRANSFER_KEY_RSA_PATH'] . $GLOBALS['TRANSFER_KEY_RSA_NAME_TEMP'] . ' -t rsa -N \'\'';
		$this->ssh($comm);
		$out['status'] = 'done';
		$out['raw_info'] = file_get_contents($GLOBALS['TRANSFER_KEY_RSA_PATH'] . $GLOBALS['TRANSFER_KEY_RSA_PUB_TEMP']);
		$out['raw_info_priv'] = file_get_contents($GLOBALS['TRANSFER_KEY_RSA_PATH'] . $GLOBALS['TRANSFER_KEY_RSA_NAME_TEMP']);
		return $out;
	}

	public function savekeyrsa($user_data, $serialdata)
	{
		$decode = json_decode($serialdata, true);
		$keyrsa = $decode['keyrsa'];
		$keyrsaprivate = $decode['keyrsaprivate'];
		file_put_contents($GLOBALS['TRANSFER_KEY_RSA_PATH'] . $GLOBALS['TRANSFER_KEY_RSA_PUB'], $keyrsa);
		file_put_contents($GLOBALS['TRANSFER_KEY_RSA_PATH'] . $GLOBALS['TRANSFER_KEY_RSA_NAME'], $keyrsaprivate);
		$comm = 'chmod 0600 ' . $GLOBALS['TRANSFER_KEY_RSA_PATH'] . $GLOBALS['TRANSFER_KEY_RSA_NAME'];
		$this->ssh($comm);
		$out['status'] = 'done';
		$out['raw_info'] = 1;
		return $out;
	}

	public function check_connect_remote($user_data, $serialdata)
	{
		$decode = json_decode($serialdata, true);
		global $lang;

		if ($decode['typeconn'] == 'key') {
			if ($decode['typetrans'] != 'fromremote') {
				$ip = $decode['ip'];
			}
			else {
				$ip = $decode['ipfrom'];
			}

			$params['auth_username'] = $decode['loginremote'];
			$params['auth_keyval'] = $decode['keyval'];
			$params['auth_typeauth'] = 'key';
			$params['auth_ip'] = $decode['ip'];
			$params['auth_pass'] = $decode['passremote'];
			$home_remote = api_send($params['auth_username'], $params['auth_pass'], 'hostacc', 'gethomedir', $params, $ip, $params['auth_keyval']);

			if (strlen($ip) < 1) {
				$res_check['status'] = -1;
				$res_check['message'] = $lang['transfer_ip_field_wrong'] . $lang['transfer_nosuccecf_remote'];
				return $res_check;
			}

			if (stripos($home_remote, 'Connection Error') !== false) {
				$res_check['status'] = -1;
				$res_check['message'] = $lang['transfer_nosuccecf_remote'];
				return $res_check;
			}

			if (intval($home_remote['code']) == 0) {
				$res_check['status'] = 1;
				$res_check['message'] = $lang['transfer_nosuccecf_remote'];
				return $res_check;
			}

			$res_check['status'] = -1;
			$res_check['message'] = $lang['transfer_nosuccecf_remote'];
			return $res_check;
		}

		if ($decode['typeconn'] == 'pass') {
			if ($decode['typetrans'] != 'fromremote') {
				$ip = $decode['ip'];
			}
			else {
				$ip = $decode['ipfrom'];
			}

			if (strlen($ip) < 1) {
				$res_check['status'] = -1;
				$res_check['message'] = $lang['transfer_ip_field_wrong'] . $lang['transfer_nosuccecf_remote'];
				return $res_check;
			}

			$comm = 'ssh-keygen -R \'' . $this->strip_quotes_cmd($ip) . '\' && ssh-keyscan -H \'' . $this->strip_quotes_cmd($ip) . '\' >>  ~/.ssh/known_hosts';
			$this->ssh($comm);
			$user = $decode['loginremote'];
			$pass = $decode['passremote'];
			$checkaccess = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' uname';
			$checkaccess = $this->ssh($checkaccess);

			if (0 < count($checkaccess)) {
				$res_check['status'] = 1;
				$res_check['message'] = $lang['transfer_nosuccecf_remote'];
				return $res_check;
			}

			$res_check['status'] = -1;
			$res_check['message'] = $lang['transfer_nosuccecf_remote'];
			return $res_check;
		}
	}

	public function preparestream_fromremote(&$stream, $dir_name_pid, $backup, $user_trans, $rootRights, $dbs, $mysql_users, $home_remote, $domainIPs)
	{
		$this->ssh('cp ' . $home_remote . '/' . $dir_name_pid . '/' . $GLOBALS['BACKUP_USER_INFO_FILE'] . ' ' . $GLOBALS['USERS_PATH'] . '/' . $dir_name_pid);
		$param = array('usergroup' => $rootRights, 'username' => $dir_name_pid);
		$this->ssh('chown -R ' . $user_trans . '.' . $user_trans . ' ' . $home_remote . '/' . $user_trans . '/ ');
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restoreuser\' -p=\'' . json_encode($param) . '\'');
		$param = array('usergroup' => $rootRights, 'username' => $dir_name_pid, 'path_to_dump' => $home_remote . '/' . $user_trans . '/' . $GLOBALS['TRANSFER_MYSQL_DIR']);
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restoredbuser\' -p=\'' . json_encode($param) . '\'');
		$param = array('usergroup' => $rootRights, 'username' => $dir_name_pid, 'path_to_dump' => $home_remote . '/' . $user_trans . '/' . $GLOBALS['TRANSFER_MYSQL_DIR']);
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restoredb\' -p=\'' . json_encode($param) . '\'');
		$this->ssh('cp ' . $home_remote . '/' . $user_trans . '/' . $GLOBALS['BACKUP_DIR_AUTOINS'] . '/' . $dir_name_pid . '.conf ' . $home_remote . '/' . $user_trans . '/' . $GLOBALS['BACKUP_DIR_AUTOINS'] . '/' . $dir_name_pid . '_appid* ' . $GLOBALS['DATA_PATH_AUTOINS_USERS_APP'] . '/');
		$param = array('username' => $dir_name_pid);
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restore_backups_jobs\' -p=\'' . json_encode($param) . '\'');
		$param = array('usergroup' => $rootRights, 'username' => $dir_name_pid);
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restoreftpacc\' -p=\'' . json_encode($param) . '\'');
		$param = array('username' => $dir_name_pid, 'ip' => $domainIPs);
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restorevhosts\' -p=\'' . json_encode($param) . '\'');
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'change_ips_domains\' -p=\'' . json_encode($param) . '\'');
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'addzones\' -p=\'' . json_encode($param) . '\'');
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restore_emails_user\' -p=\'' . json_encode($param) . '\'');
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restore_email_forward\' -p=\'' . json_encode($param) . '\'');
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restore_dns_user\' -p=\'' . json_encode($param) . '\'');
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restore_dkimkeys_user\' -p=\'' . json_encode($param) . '\'');
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restore_webserver_includes_user\' -p=\'' . json_encode($param) . '\'');
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'vhostsrebuild\' -p=\'' . json_encode($param) . '\'');
		$this->ssh('crontab -u ' . $user_trans . ' ' . $home_remote . '/' . $user_trans . '/crontab');
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'hostaccsetjailhost\' -p=\'' . json_encode($param) . '\'');
		$this->ssh('/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'hostaccsetjailphp\' -p=\'' . json_encode($param) . '\'');
		$this->ssh('rm -rf ' . $home_remote . $dir_name_pid . '/' . $GLOBALS['BACKUP_USER_INFO_FILE']);
		$this->ssh('rm -rf ' . $home_remote . $dir_name_pid . '/' . $this->dir_backup_configs);
	}

	public function getHomeDirUser($user)
	{
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$homeDir = $GLOBALS['HOME_PATH'];

		if (isset($confUser['rootdir'])) {
			$home_remote = str_replace($user, '', $confUser['rootdir']);
			$homeDir = str_replace('//', '/', $home_remote);
		}

		return $homeDir;
	}

	public function preparestream_toremote(&$stream, $dir_name_pid, $backup, $user_trans)
	{
		$mysql_conn = new dbusage();
		$backup->backup_autoins_config_user($dir_name_pid);
		$backup->backup_user_info($dir_name_pid);
		$backup->backup_ftps_acc($dir_name_pid);
		$backup->backup_vhosts($dir_name_pid);
		$backup->backup_backups_jobs($dir_name_pid);
		$backup->backup_emails_user($dir_name_pid);
		$backup->backup_email_forward($dir_name_pid);
		$backup->backup_dns_user($dir_name_pid);
		$backup->backup_dkimkeys_user($dir_name_pid);
		$backup->backup_webserver_includes_user($dir_name_pid);
		$dbs = $mysql_conn->mysql_get_dbs($user_trans);
		$dbs = array_values(array_filter($dbs));
		$mysql_users = $mysql_conn->mysql_get_users($user_trans);
		$mysql_users = array_values(array_filter($mysql_users));
		$homeDir = $this->getHomeDirUser($dir_name_pid);
		$mysql_users[] = $dir_name_pid;
		$res = $backup->makedump_sql_arr_users($mysql_users, $homeDir . $dir_name_pid . '/' . $GLOBALS['TRANSFER_MYSQL_DIR'], $mysql_conn, $dbs, $dir_name_pid);
		$res_dump_do = $backup->makedump_sql_arr($dbs, $homeDir . $dir_name_pid . '/' . $GLOBALS['TRANSFER_MYSQL_DIR'], $dir_name_pid);
		$this->ssh('echo \'createtranshint\' >>/dev/null');
		$this->ssh('echo \'#curusertrans_block1#' . $user_trans . '#curusertrans_block2#\' >>/dev/null');

		foreach ($res_dump_do as $curdump) {
			$this->ssh($curdump);
		}
	}

	public function makeQueryStringPass($pass, $user, $ip, $comm)
	{
		$query = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' ssh \'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ip) . '\' \'' . $comm . '\'';
		return $query;
	}

	public function makeQueryStringKey()
	{
	}

	public function transferToRemote($user, $pass, $typeConn, $home_remote, $dir_name_pid, $rootRights, $bwlimit, $ip, $domainsip, $log = '')
	{
		$backup = new backup();
		$user_trans = $dir_name_pid;
		global $lang;
		$connection = NULL;
		$resConn = false;
		$comm = 'ssh-keygen -R \'' . $this->strip_quotes_cmd($ip) . '\' && ssh-keyscan -H \'' . $this->strip_quotes_cmd($ip) . '\' >>  ~/.ssh/known_hosts';
		$this->ssh($comm);
		$home_remote = $this->getHomeDirUser($dir_name_pid);

		if ($typeConn == 'pass') {
			$arr_auth_remote_server['auth_username'] = $user;
			$arr_auth_remote_server['auth_pass'] = $pass;
			$arr_auth_remote_server['auth_typeauth'] = 'pass';
			$connection = ssh2_connect($ip, $this->portConn);
			$resConn = ssh2_auth_password($connection, $user, $pass);
		}

		if ($typeConn == 'key') {
			$pathPrivateKey = $GLOBALS['TRANSFER_KEY_RSA_PATH'] . $GLOBALS['TRANSFER_KEY_RSA_NAME'];
			$pathPublicKey = $pathPrivateKey . $GLOBALS['BACKUP_KEY_RSA_MASK_PUB'];
			$connection = ssh2_connect($ip, 22);
			$resConn = ssh2_auth_pubkey_file($connection, 'root', $pathPublicKey, $pathPrivateKey);
		}

		if ($resConn !== false) {
			$qConnRemote = true;
		}
		else {
			$res['code'] = 200;
			$res['message'] = $lang['transfer_startFailedConn'];
			return $res;
		}

		$stream = array();
		$this->preparestream_toremote($stream, $dir_name_pid, $backup, $user_trans);
		$this->sendSshQuery($connection, 'mkdir -p ' . $home_remote . '/' . $dir_name_pid);
		$exclJail = $backup->createExcludePathJail('rsync');

		if ($typeConn == 'pass') {
			$this->ssh('sshpass -p \'' . $pass . '\' rsync --bwlimit=' . $bwlimit . ' -azh --exclude ' . $exclJail . ' -e \'ssh\'' . ' --delete ' . $home_remote . '/' . $dir_name_pid . '/ ' . $user . '@' . $ip . ':' . $home_remote . '/' . $dir_name_pid);
		}

		if ($typeConn == 'key') {
			$this->ssh('rsync --bwlimit=' . $bwlimit . ' -azh --exclude ' . $exclJail . ' -e \'ssh -i ' . $GLOBALS['TRANSFER_KEY_RSA_PATH'] . $GLOBALS['TRANSFER_KEY_RSA_NAME'] . '\'' . ' --delete ' . $home_remote . $dir_name_pid . '/ ' . $user . '@' . $ip . ':' . $home_remote . '/' . $dir_name_pid);
		}

		$this->sendSshQuery($connection, 'chown -R ' . $user_trans . '.' . $user_trans . ' ' . $home_remote . '/' . $user_trans . '/ ');
		$this->sendSshQuery($connection, 'cp ' . $home_remote . '/' . $dir_name_pid . '/' . $GLOBALS['BACKUP_USER_INFO_FILE'] . ' ' . $GLOBALS['USERS_PATH'] . '/' . $dir_name_pid);
		$param = array('usergroup' => $rootRights, 'username' => $dir_name_pid);
		$this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restoreuser\' -p=\'' . json_encode($param) . '\'');
		$this->sendSshQuery($connection, 'rm -rf ' . $home_remote . '/' . $dir_name_pid . '/' . $GLOBALS['BACKUP_USER_INFO_FILE']);
		$param = array('usergroup' => $rootRights, 'username' => $dir_name_pid, 'path_to_dump' => $home_remote . '/' . $dir_name_pid . '/' . $GLOBALS['TRANSFER_MYSQL_DIR']);
		$this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restoredbuser\' -p=\'' . json_encode($param) . '\'');
		$param = array('usergroup' => $rootRights, 'username' => $dir_name_pid, 'path_to_dump' => $home_remote . '/' . $user_trans . '/' . $GLOBALS['TRANSFER_MYSQL_DIR']);
		$this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restoredb\' -p=\'' . json_encode($param) . '\'');
		$this->sendSshQuery($connection, 'cp ' . $home_remote . '/' . $user_trans . '/' . $GLOBALS['BACKUP_DIR_AUTOINS'] . '/' . $dir_name_pid . '.conf ' . $home_remote . '/' . $user_trans . '/' . $GLOBALS['BACKUP_DIR_AUTOINS'] . '/' . $dir_name_pid . '_appid* ' . $GLOBALS['DATA_PATH_AUTOINS_USERS_APP'] . '/');
		$param = array('username' => $dir_name_pid);
		$this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restore_backups_jobs\' -p=\'' . json_encode($param) . '\'');
		$param = array('usergroup' => $rootRights, 'username' => $dir_name_pid);
		$this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restoreftpacc\' -p=\'' . json_encode($param) . '\'');
		$param = array('username' => $dir_name_pid, 'ip' => $domainsip);
		$this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restorevhosts\' -p=\'' . json_encode($param) . '\'');
		$this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'change_ips_domains\' -p=\'' . json_encode($param) . '\'');
		$this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'vhostsrebuild\' -p=\'' . json_encode($param) . '\'');
		$this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'addzones\' -p=\'' . json_encode($param) . '\'');
		$this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restore_emails_user\' -p=\'' . json_encode($param) . '\'');
		$this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restore_email_forward\' -p=\'' . json_encode($param) . '\'');
		$this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restore_dns_user\' -p=\'' . json_encode($param) . '\'');
		$this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restore_dkimkeys_user\' -p=\'' . json_encode($param) . '\'');
		$this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'restore_webserver_includes_user\' -p=\'' . json_encode($param) . '\'');
		$this->sendSshQuery($connection, 'rm -rf ' . $home_remote . '/' . $user_trans . '/' . $this->dir_backup_configs);
		$this->sendSshQuery($connection, 'crontab -u ' . $user_trans . ' ' . $home_remote . '/' . $user_trans . '/crontab');
		$this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'hostaccsetjailhost\' -p=\'' . json_encode($param) . '\'');
		$this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'hostaccsetjailphp\' -p=\'' . json_encode($param) . '\'');
		$this->ssh('rm -rf ' . $home_remote . $dir_name_pid . '/' . $GLOBALS['BACKUP_USER_INFO_FILE']);
		$this->ssh('rm -rf ' . $home_remote . $dir_name_pid . '/' . $this->dir_backup_configs);
	}

	public function transferfromremote($user, $pass, $typeConn, $home_remote, $dir_name_pid, $rootRights, $bwlimit, $ip, $domainsip, $log = '')
	{
		$backup = new backup();
		$user_trans = $dir_name_pid;
		global $lang;
		$connection = NULL;
		$resConn = false;
		$comm = 'ssh-keygen -R \'' . $this->strip_quotes_cmd($ip) . '\' && ssh-keyscan -H \'' . $this->strip_quotes_cmd($ip) . '\' >>  ~/.ssh/known_hosts';
		$this->ssh($comm);
		$keyValPrivate = '';
		$ipfrom = $ip;

		if ($typeConn == 'pass') {
			$arr_auth_remote_server['auth_username'] = $user;
			$arr_auth_remote_server['auth_pass'] = $pass;
			$arr_auth_remote_server['auth_typeauth'] = 'pass';
			$connection = ssh2_connect($ip, $this->portConn);
			$resConn = ssh2_auth_password($connection, $user, $pass);
		}

		if ($typeConn == 'key') {
			$pathPrivateKey = $GLOBALS['TRANSFER_KEY_RSA_PATH'] . $GLOBALS['TRANSFER_KEY_RSA_NAME'];
			$pathPublicKey = $pathPrivateKey . $GLOBALS['BACKUP_KEY_RSA_MASK_PUB'];
			$keyValPrivate = file_get_contents($pathPrivateKey);
			$pass = '';
			$arr_auth_remote_server['auth_username'] = $user;
			$arr_auth_remote_server['auth_pass'] = $pass;
			$arr_auth_remote_server['auth_ip'] = $ipfrom;
			$arr_auth_remote_server['auth_typeauth'] = 'pass';
			$connection = ssh2_connect($ip, 22);
			$resConn = ssh2_auth_pubkey_file($connection, 'root', $pathPublicKey, $pathPrivateKey);
		}

		if ($resConn !== false) {
			$qConnRemote = true;
		}
		else {
			$res['code'] = 200;
			$res['message'] = $lang['transfer_startFailedConn'];
			return $res;
		}

		$stream = array();
		$param = array('user' => $user_trans);
		$home_remote = trim($this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'gethomedir\' -p=\'' . json_encode($param) . '\''));
		$param = array('username' => $user_trans);
		$param = array_merge($param, $arr_auth_remote_server);
		$res = api_send($user, $pass, 'backup', 'fullbackupdatauser', $param, $ipfrom, $keyValPrivate);
		$dbs = api_send($user, $pass, 'mysql', 'getdblist', $param, $ipfrom, $keyValPrivate);
		$dbs = array_values(array_filter($dbs));
		$mysql_users = api_send($user, $pass, 'mysql', 'getdbuserlist', $param, $ipfrom, $keyValPrivate);
		$mysql_users = array_values(array_filter($mysql_users));
		$mysql_users[] = $user_trans;
		$param = array('mysql_users' => $mysql_users, 'path_to_dump' => $home_remote . $dir_name_pid . '/' . $GLOBALS['TRANSFER_MYSQL_DIR'], 'dbs' => $dbs, 'username' => $user_trans);
		$param = array_merge($param, $arr_auth_remote_server);
		$res = api_send($user, $pass, 'backup', 'makedumpdbuser', $param, $ipfrom, $keyValPrivate);
		$param = array('path_to_dump' => $home_remote . $dir_name_pid . '/' . $GLOBALS['TRANSFER_MYSQL_DIR'], 'dbs' => $dbs, 'username' => $user_trans);
		$param = array_merge($param, $arr_auth_remote_server);
		$res_dump_do = api_send($user, $pass, 'backup', 'makedumpdb', $param, $ipfrom, $keyValPrivate);

		foreach ($res_dump_do as $curdump) {
			$this->sendSshQuery($connection, $curdump);
		}

		$this->ssh('mkdir -p ' . $home_remote . '/' . $dir_name_pid);
		$exclJail = $backup->createExcludePathJail('rsync');

		if ($typeConn == 'pass') {
			$commRsync = 'sshpass -p \'' . $this->strip_quotes_cmd($pass) . '\' rsync --bwlimit=' . $bwlimit . ' -azh --exclude ' . $exclJail . ' -e \'ssh \'' . ' --delete ' . '\'' . $this->strip_quotes_cmd($user) . '@' . $this->strip_quotes_cmd($ipfrom) . ':' . $this->strip_quotes_cmd($home_remote) . '/' . $dir_name_pid . '/\'' . ' ' . $home_remote . $dir_name_pid;
		}

		if ($typeConn == 'key') {
			$commRsync = 'rsync --bwlimit=' . $bwlimit . ' -azh --exclude ' . $exclJail . ' -e \'ssh -i ' . $GLOBALS['TRANSFER_KEY_RSA_PATH'] . $GLOBALS['TRANSFER_KEY_RSA_NAME'] . '\'' . ' --delete ' . ' ' . $user . '@' . $ipfrom . ':' . $home_remote . '/' . $dir_name_pid . '/' . ' ' . $home_remote . $dir_name_pid;
		}

		$this->ssh($commRsync);
		$this->preparestream_fromremote($stream, $dir_name_pid, $backup, $user_trans, $rootRights, $dbs, $mysql_users, $home_remote, $domainsip);
		$this->sendSshQuery($connection, 'rm -rf ' . $home_remote . '/' . $user_trans . '/' . $GLOBALS['BACKUP_USER_INFO_FILE']);
		$this->sendSshQuery($connection, 'rm -rf ' . $home_remote . '/' . $user_trans . '/' . $this->dir_backup_configs);
	}

	public function transfer_stream($user_data, $serialdata, $backup)
	{
		global $lang;
		$backup = new backup();
		$decode = json_decode($serialdata, true);
		$time = time();

		if (!is_dir($GLOBALS['DATA_PATH_AUTOINS_USERS_APP'])) {
			$comm = 'mkdir -p ' . $GLOBALS['DATA_PATH_AUTOINS_USERS_APP'];
			$this->ssh($comm);
		}

		if ($decode['command'] != 'starttrans') {
			$arr_transferplist = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($GLOBALS['TRANSFER_STREAMS'] . $user_data['name'] . '_transfer.conf'));
			$list_transfer_hist = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($GLOBALS['TRANSFER_LOG']));
			$res = array();

			if (1 < count($arr_transferplist)) {
				$i = 0;

				foreach ($arr_transferplist as $streamid) {
					if (strlen($streamid) < 3) {
						continue;
					}

					$pid = $this->getexistpid($streamid);

					if ($pid == -1) {
						$backupcreate = 2;
					}
					else {
						$backupcreate = 1;
						$res[] = $streamid;
					}

					switch ($backupcreate) {
					case 1:
						$out1 = $this->read_stream($streamid);
						$arr_res = preg_split('/\\r\\n|\\r|\\n/', $out1[count($out1) - 1]);
						$arr_progress_cur = preg_split('/\\r\\n|\\r|\\n\\t|\\s+/', $arr_res[count($arr_res) - 1]);
						$arr_progress_cur = array_values(array_filter($arr_progress_cur));
						$fullstr = implode("\n", $out1);
						$flag_start = '#curusertrans_block1#';
						$flag_end = '#curusertrans_block2#';
						$st = strripos($fullstr, $flag_start);
						$end = strripos($fullstr, $flag_end);
						$username_cur_transfer = substr($fullstr, $st + strlen($flag_start), $end - $st - strlen($flag_start));
						$resmass[$i]['status'] = 'inprogress';
						$resmass[$i]['stream_id'] = $streamid;
						$resmass[$i]['raw_info'] = implode("\n", $out1);
						$resmass[$i]['raw_process'] = $arr_progress_cur;
						$resmass[$i]['username_cur_transfer'] = $username_cur_transfer;
						break;

					case 2:
						$out1 = $this->read_stream($streamid);
						$fullstr = implode("\n", $out1);
						$flag_start = '#resoperlog_userrestore#';
						$flag_end = '#resoperlog_userrestore_end#';
						$st = strripos($fullstr, $flag_start);
						$end = strripos($fullstr, $flag_end);
						$user_log = substr($fullstr, $st, $end - $st);
						$resmass[$i]['status'] = 'done';
						$resmass[$i]['stream_id'] = $streamid;
						$resmass[$i]['raw_info'] = implode("\n", $out1);
						$resmass[$i]['raw_process'] = '';
						$count_hist = count($list_transfer_hist);
						$ah = 0;

						while ($ah < $count_hist) {
							$row = $list_transfer_hist[$ah];
							$row_exp = explode('|', $row);

							if ($row_exp[0] == $streamid) {
								$start_time = strtotime($row_exp[1]);
								$end_time = time();
								$diff = $end_time - $start_time;

								if ($this->mintimeout_waitendstream_trans < $diff) {
									$list_transfer_hist .= $ah;
								}
								else {
									$res[] = $streamid;
									break;
								}
							}

							++$ah;
						}

						if ($this->mintimeout_waitendstream_trans < $diff) {
							file_put_contents($GLOBALS['TRANSFER_LOG'], '', LOCK_EX);

							foreach ($list_transfer_hist as $curhist) {
								file_put_contents($GLOBALS['TRANSFER_LOG'], $curhist . "\n", FILE_APPEND | LOCK_EX);
							}
						}

						break;
					}
				}

				if (count($res) < 1) {
					$resmass[0]['status'] = $lang['transfer_status'];
					$resmass[0]['raw_info'] = $lang['no stream transfer'];
				}
			}
			else {
				$resmass[0]['status'] = $lang['transfer_status'];
				$resmass[0]['raw_info'] = $lang['transfer_no_stream_transfer2'];
			}

			$resmass[0]['raw_list_trans_hist'] = $list_transfer_hist;

			foreach ($res as $item) {
				$key = array_search($item, $arr_transferplist);

				if ($key !== false) {
					unset($arr_transferplist[$key]);
				}
			}

			if (!is_dir($GLOBALS['TRANSFER_STREAMS'])) {
				$comm = 'mkdir -p ' . $GLOBALS['TRANSFER_STREAMS'];
				$this->ssh($comm);
			}

			file_put_contents($GLOBALS['TRANSFER_STREAMS'] . '/' . $user_data['name'] . '_transfer.conf', '', LOCK_EX);

			foreach ($res as $item) {
				if (1 < strlen($item)) {
					file_put_contents($GLOBALS['TRANSFER_STREAMS'] . '/' . $user_data['name'] . '_transfer.conf', $item . "\n", FILE_APPEND | LOCK_EX);
				}
			}

			return $resmass;
		}

		$stat = $this->check_connect_remote($user_data, $serialdata);

		if ($stat['status'] == -1) {
			$res[0] = -111;
			return $res;
		}

		if ($decode['command'] == 'starttrans') {
			$typeconn = $decode['typeconn'];
			$typetrans = $decode['typetrans'];
			$users_trans = $decode['users_trans'];
			$dir_name_pid_arr = array();
			$ip_arr = array();
			$cc = 0;

			foreach ($users_trans as $user_trans) {
				if (1 < strlen($user_trans)) {
					if ($typetrans == 'toremote') {
						$connection = NULL;
						$resConn = false;
						$typeConn = '';
						$ip = $decode['ip'];
						$ipfrom = $decode['ipfrom'];
						$dir_name_pid = $user_trans;
						$dir_name_pid_arr[] = $dir_name_pid;
						$ip_arr[] = $ip;
						$user = $decode['loginremote'];

						if ($typeconn == 'pass') {
							$typeConn = 'pass';
							$bwlimit = 90000;
							$pass = $decode['passremote'];
							$arr_auth_remote_server['auth_username'] = $user;
							$arr_auth_remote_server['auth_pass'] = $pass;
							$arr_auth_remote_server['auth_ip'] = $ipfrom;
							$arr_auth_remote_server['auth_typeauth'] = 'pass';
							$connection = ssh2_connect($ip, $this->portConn);
							$resConn = ssh2_auth_password($connection, $user, $pass);
						}

						if ($typeconn == 'key') {
							$typeConn = 'key';
							$pathPrivateKey = $GLOBALS['TRANSFER_KEY_RSA_PATH'] . $GLOBALS['TRANSFER_KEY_RSA_NAME'];
							$pathPublicKey = $pathPrivateKey . $GLOBALS['BACKUP_KEY_RSA_MASK_PUB'];
							$connection = ssh2_connect($ip, 22);
							$resConn = ssh2_auth_pubkey_file($connection, 'root', $pathPublicKey, $pathPrivateKey);
						}

						if ($resConn === true) {
							$qConnRemote = true;
						}
						else {
							$res['code'] = 200;
							$res['message'] = $lang['transfer_startFailedConn'];

							return $res;
						}

						$home_remote = $this->getHomeDirUser($dir_name_pid);
						$exist_remote_homedir_trans_user = $this->sendSshQuery($connection, 'ls -l ' . $home_remote . '/' . $dir_name_pid . '/');

						if ((0 < strlen($exist_remote_homedir_trans_user)) && (stripos($exist_remote_homedir_trans_user, 'total 0') === false)) {
							$resmass[$cc]['status'] = 'done';
							$resmass[$cc]['raw_info'] = 'transfer_log_message_user_exist';
							$resmass[$cc]['raw_process'] = 'transfer_log_message_user_exist';
							++$cc;
							continue;
						}

						$param = array('user' => $user, 'pass' => $pass, 'typeConn' => $typeConn, 'home_remote' => $home_remote, 'dir_name_pid' => $dir_name_pid, 'rootRights' => $user_data['group_properties']['root'], 'bwlimit' => $bwlimit, 'ip' => $ip, 'domainsip' => $decode['domainsip']);
						$stream[]['comm'] = 'echo \'createtranshint\' >>/dev/null';
						$stream[]['comm'] = 'echo \'#curusertrans_block1#' . $user_trans . '#curusertrans_block2#\' >>/dev/null';
						$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'transfertoremote\' -p=\'' . json_encode($param) . '\'';
						$stream[]['comm'] = 'echo \'#curusertrans_block1end#' . $user_trans . '#curusertrans_block2end#\' >>/dev/null';
					}

					if ($typetrans == 'fromremote') {
						$connection = NULL;
						$resConn = false;
						$typeConn = '';
						$ip = $decode['ip'];
						$ipfrom = $decode['ipfrom'];
						$dir_name_pid = $user_trans;
						$dir_name_pid_arr[] = $dir_name_pid;
						$ip_arr[] = $ip;
						$user = $decode['loginremote'];
						$bwlimit = 90000;

						if ($typeconn == 'pass') {
							$typeConn = 'pass';
							$pass = $decode['passremote'];
							$arr_auth_remote_server['auth_username'] = $user;
							$arr_auth_remote_server['auth_pass'] = $pass;
							$arr_auth_remote_server['auth_ip'] = $ipfrom;
							$arr_auth_remote_server['auth_typeauth'] = 'pass';
							$connection = ssh2_connect($ipfrom, $this->portConn);
							$resConn = ssh2_auth_password($connection, $user, $pass);
						}

						if ($typeconn == 'key') {
							$typeConn = 'key';
							$pathPrivateKey = $GLOBALS['TRANSFER_KEY_RSA_PATH'] . $GLOBALS['TRANSFER_KEY_RSA_NAME'];
							$pathPublicKey = $pathPrivateKey . $GLOBALS['BACKUP_KEY_RSA_MASK_PUB'];
							$connection = ssh2_connect($ipfrom, 22);
							$resConn = ssh2_auth_pubkey_file($connection, 'root', $pathPublicKey, $pathPrivateKey);
						}

						if ($resConn === true) {
							$qConnRemote = true;
						}
						else {
							$res['code'] = 200;
							$res['message'] = $lang['transfer_startFailedConn'];

							return $res;
						}

						$param = array('user' => $user_trans);
						$home_remote = trim($this->sendSshQuery($connection, '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'gethomedir\' -p=\'' . json_encode($param) . '\''));
						$comm = 'ls -l ' . $home_remote . '/' . $dir_name_pid . '/';
						$exist_homedir_trans_user = $this->ssh($comm)[0];

						if (0 < strlen($exist_homedir_trans_user)) {
							$resmass[$cc]['status'] = 'done';
							$resmass[$cc]['raw_info'] = 'transfer_log_message_user_exist';
							$resmass[$cc]['raw_process'] = 'transfer_log_message_user_exist';
							++$cc;
							continue;
						}

						$param = array('user' => $user, 'pass' => $pass, 'typeConn' => $typeConn, 'home_remote' => $home_remote, 'dir_name_pid' => $dir_name_pid, 'rootRights' => $user_data['group_properties']['root'], 'bwlimit' => $bwlimit, 'ip' => $ipfrom, 'domainsip' => $decode['domainsip']);
						$stream[]['comm'] = 'echo \'createtranshint\' >>/dev/null';
						$stream[]['comm'] = 'echo \'#curusertrans_block1#' . $user_trans . '#curusertrans_block2#\' >>/dev/null';
						$stream[]['comm'] = '/etc/brainy/src/compiled/php5/bin/php /etc/brainy/ssh/backup.php -a=\'transferfromremote\' -p=\'' . json_encode($param) . '\'';
						$stream[]['comm'] = 'echo \'#curusertrans_block1end#' . $user_trans . '#curusertrans_block2end#\' >>/dev/null';
						++$cc;
					}
				}
			}

			$qexist_user = 0;

			if (isset($stream)) {
				$stream[0]['array_start'] = array('transfer_#stream_id#_#stream_pid#' => '1', 'transfer_name_#stream_id#_#stream_pid#' => $user_data['name'], 'starttime_#stream_id#_#stream_pid#' => $time);
				$stream[0]['test'] = '';
				$stream[0]['array_success'] = array('transfer_#stream_id#_#stream_pid#' => '2', 'endtime_#stream_id#_#stream_pid#' => $time);
				$stream[0]['array_unsucces'] = array('transfer_#stream_id#_#stream_pid#' => '3', 'endtime_#stream_id#_#stream_pid#' => $time);
				$transParamFile = '/etc/brainy/data/streams/trans_param_' . time() . '_' . rand(100, 99999);
				$stream[]['comm'] = 'rm -f ' . $transParamFile;
				file_put_contents($transParamFile, json_encode($stream, 1));
			}
			else {
				$stream[0]['test'] = 'userexist';
				$qexist_user = 1;
			}

			$stream_id = $this->create_stream($stream, $transParamFile);

			if ($qexist_user == 1) {
				file_put_contents('/etc/brainy/data/streams/' . $stream_id, $lang['child_human_logtrans_userexist'] . $dir_name_pid);
			}

			$out1 = $this->read_stream($stream_id);

			if (!is_dir($GLOBALS['TRANSFER_STREAMS'])) {
				$comm = 'mkdir -p ' . $GLOBALS['TRANSFER_STREAMS'];
				$this->ssh($comm);
			}

			file_put_contents($GLOBALS['TRANSFER_STREAMS'] . '/' . $user_data['name'] . '_transfer.conf', $stream_id . "\n", FILE_APPEND | LOCK_EX);
			$list_transfer_hist = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($GLOBALS['TRANSFER_LOG']));
			$count_hist = count($list_transfer_hist);
			$j = 0;
			$ah = 0;

			while ($ah < $count_hist) {
				if (50 < $j) {
					break;
				}

				$row_save[] = $list_transfer_hist[$ah];
				++$j;
				++$ah;
			}

			file_put_contents($GLOBALS['TRANSFER_LOG'], '', LOCK_EX);
			$cc = 0;

			foreach ($dir_name_pid_arr as $dirname_cur) {
				if (isset($resmass[$cc]['raw_process'])) {
					$err = $resmass[$cc]['raw_process'];
				}
				else {
					$err = '';
				}

				file_put_contents($GLOBALS['TRANSFER_LOG'], $stream_id . '|' . date('d.m.Y H:i:s') . '|' . $dirname_cur . '|' . $ipfrom . '|' . $ip . '|' . $err . '|' . "\n", FILE_APPEND | LOCK_EX);
				++$cc;
			}

			foreach ($row_save as $curhist) {
				if (5 < strlen($curhist)) {
					file_put_contents($GLOBALS['TRANSFER_LOG'], $curhist . "\n", FILE_APPEND | LOCK_EX);
				}
			}

			$list_transfer_hist = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($GLOBALS['TRANSFER_LOG']));
			$resmass[0]['raw_list_trans_hist'] = $list_transfer_hist;
			$cc = 0;

			foreach ($dir_name_pid_arr as $dirname_cur) {
				$resmass[$cc]['status'] = 'inprogress';
				$resmass[$cc]['stream_id'] = $stream_id;

				if (!isset($resmass[$cc]['raw_process'])) {
					$resmass[$cc]['raw_process'] = '1%';
				}

				$resmass[$cc]['raw_info'] = implode("\n", $out1);
				++$cc;
			}

			return $resmass;
		}
	}

	public function getlistips_fromremote($serialdata)
	{
		$decode = json_decode($serialdata, true);
		$params['auth_ip'] = $decode['ip'];

		if ($decode['typeconn'] == 'pass') {
			$params['auth_username'] = $decode['loginremote'];
			$params['auth_pass'] = $decode['passremote'];
			$params['auth_typeauth'] = 'pass';
		}
		else {
			$params['auth_username'] = $decode['loginremote'];
			$params['auth_keyval'] = $decode['keyval'];
			$params['auth_typeauth'] = 'key';
		}

		global $lang;

		if (strlen($decode['ip']) < 1) {
			$res_check[0] = array(-1);
			$res_check['status'] = -1;
			$res_check['message'] = $lang['transfer_ip_field_wrong'] . $lang['transfer_nosuccecf_remote'];
			return $res_check;
		}

		$res = api_send($params['auth_username'], $params['auth_pass'], 'ipmanager', 'getallipsliststat', $params, $decode['ip'], $params['auth_keyval']);

		if (!is_array($res)) {
			if (stripos($res, 'Connection Error') !== false) {
				$res_check[0] = array(-1);
				$res_check['status'] = -1;
				$res_check['message'] = $lang['transfer_nosuccecf_remote'];
				return $res_check;
			}
		}

		if (is_array($res)) {
			if ($res['code'] == 1) {
				$res_check[0] = array(-1);
				$res_check['status'] = -1;
				$res_check['message'] = $lang['transfer_nosuccecf_remote'];
				return $res_check;
			}
		}

		if ($res == -1) {
			$res1[0] = array(-1);
			$res1['message'] = $lang['transfer_nosuccecf_remote'];
			return $res1;
		}

		return $res;
	}

	public function getlistuser_fromremote($userdata, $serialdata)
	{
		$decode = json_decode($serialdata, true);
		$params['auth_username'] = $decode['loginremote'];
		$params['auth_keyval'] = $decode['keyval'];
		$params['auth_pass'] = $decode['passremote'];
		$params['auth_ip'] = $decode['ip'];
		$ip = $decode['ip'];
		global $lang;
		$home_remote = api_send($params['auth_username'], $params['auth_pass'], 'hostacc', 'gethomedir', $params, $decode['ip'], $params['auth_keyval']);

		if ($home_remote == -1) {
			$res['listusers'] = array(-1);
			return $res;
		}

		if (strlen($decode['ip']) < 1) {
			$res_check['listusers'] = array(-1);
			$res_check['status'] = -1;
			$res_check['message'] = $lang['transfer_ip_field_wrong'] . $lang['transfer_nosuccecf_remote'];
			return $res_check;
		}

		$listusers_res = api_send($params['auth_username'], $params['auth_pass'], 'hostacc', 'getuserlist', $params, $decode['ip'], $params['auth_keyval']);

		if (!is_array($listusers_res)) {
			if (stripos($listusers_res, 'Connection Error') !== false) {
				$res_check['listusers'] = array(-1);
				$res_check['status'] = -1;
				$res_check['message'] = $lang['transfer_nosuccecf_remote'];
				return $res_check;
			}
		}

		array_multisort($listusers_res, SORT_ASC, SORT_STRING);

		if (0 < count($listusers_res)) {
			$count = count($listusers_res);
			$i = 0;

			while ($i < $count) {
				$listusers_res[$i] = str_replace($home_remote, '', $listusers_res[$i]);
				$listusers_res[$i] = str_replace('/', '', $listusers_res[$i]);
				++$i;
			}

			if (($key = array_search('brainy', $listusers_res)) !== false) {
				unset($listusers_res[$key]);
			}

			if (($key = array_search('log', $listusers_res)) !== false) {
				unset($listusers_res[$key]);
			}

			asort($listusers_res);
			$listusers_res = array_values($listusers_res);
			$res['listusers'] = $listusers_res;
			return $res;
		}

		$res['listusers'] = array(-1);
		return $res;
	}
}


?>
