<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class web_static
{
	public $conf_site_path = '/etc/brainy/data/users/root';
	public $dir_site_path = '/etc/brainy/data/users';
	public $module_params_path = '/etc/brainy/data/web_statistics';
	public $module_params_name = 'web_statics';
	public $server_name;
	public $array_site;
	public $array_site_st;
	public $programm = array('webanalizer', 'awstats');
	public $dir_analizer_conf_default_path = '/etc/brainy/data/web_statistics/webalizer.conf';
	public $dir_analizer_data_path = '/etc/brainy/data/web_stats';
	public $dir_awstats_conf_default_path = '/etc/brainy/data/web_statistics/awstats.model.conf';
	public $js_comand = array('yes', 'no', 'default', '');

	public function fixJSON($json)
	{
		$regex = "\t\t" . '~' . "\n\t\t\t" . '"[^"\\\\]*(?:\\\\.|[^"\\\\]*)*"' . "\n\t\t\t" . '(*SKIP)(*F)' . "\n\t\t" . '  | \'([^\'\\\\]*(?:\\\\.|[^\'\\\\]*)*)\'' . "\n\t\t" . '~x';
		return preg_replace_callback($regex, function($matches) {
			return '"' . preg_replace('~\\\\.(*SKIP)(*F)|"~', '\\"', $matches[1]) . '"';
		}, $json);
	}

	public function webstatic_load_user()
	{
		$dir = $this->dir_site_path;
		$out = $this->get_users();
		return $out;
	}

	public function webstatic_load_site_list($user = '')
	{
		if ($user == '') {
			return array();
		}

		if (!$this->check_value('user', $user)) {
			return false;
		}

		$w = new webserver();
		$hosts = $w->get_virt_hosts_quick($user);

		if (sizeof($hosts)) {
			$i = 0;

			while ($i < count($hosts)) {
				$arr[$hosts[$i]] = 0;
				++$i;
			}

			return $arr;
		}

		return array();
	}

	public function webstatic_server_name()
	{
		return $this->server_name;
	}

	public function webstatic_site_list()
	{
		return $this->array_site;
	}

	public function webstatic_list_programm()
	{
		return $this->programm;
	}

	public function webstatic_site_decode($res)
	{
		$res = explode('|', $res);
		$web = explode(';', $res[0]);
		$aw = explode(';', $res[1]);
		$i = 0;

		while ($i < count($web)) {
			$arr_web = explode('=', $web[$i]);
			$arr_aw = explode('=', $aw[$i]);
			$out[$arr_web[0]] = array($arr_web[1], $arr_aw[1]);
			++$i;
		}

		return $out;
	}

	public function webstatic_site_decode_savefile($user = '', $res, $web, $awstat, $newsite_web, $newsite_awstat)
	{
		if ($user == '') {
			return NULL;
		}

		if (!$this->check_user($user)) {
			return 0;
		}
		if ($web) {
			if (!in_array($web, $this->js_comand)) {
				return false;
			}
		}
		if ($awstat) {
			if (!in_array($awstat, $this->js_comand)) {
				return false;
			}
		}
		if ($newsite_web) {
			if (!in_array($newsite_web, $this->js_comand)) {
				return false;
			}
		}
		if ($newsite_awstat) {
			if (!in_array($newsite_awstat, $this->js_comand)) {
				return false;
			}
		}

		$file = $this->dir_site_path . '/' . $user;

		if (is_array($res)) {
			foreach ($res as $key => $val) {
				if (!$this->check_value('domain', $key)) {
					return false;
				}

				foreach ($val as $key1) {
					return false;
				}
			}
		}

		$arr[$this->module_params_name] = str_replace('"', '\\'', json_encode($res));
		$arr['change_webalizer'] = $web;
		$arr['change_awstat'] = $awstat;
		$arr['newsite_webalizer'] = $newsite_web;
		$arr['newsite_awstat'] = $newsite_awstat;
		$this->config_save($file, $arr, 'add');
	}

	public function webstatic_site_decode_savefile_user($user = '', $res)
	{
		if ($user == '') {
			return NULL;
		}

		if (!$this->check_user($user)) {
			return 0;
		}

		$file = $this->dir_site_path . '/' . $user;

		if (sizeof($res)) {
			$arr[$this->module_params_name] = str_replace('"', '\\'', json_encode($res));
		}
		else {
			$arr[$this->module_params_name] = '';
		}

		$this->config_save($file, $arr, 'add');
	}

	public function webstatic_load_prog_check($user = '')
	{
		if ($user == '') {
			return NULL;
		}

		$file = $this->dir_site_path . '/' . $user;
		$out = $this->config_read($file);

		if ($out['change_webalizer'] == 'yes') {
			$arr[] = 'checked=\'true\'';
		}
		else {
			$arr[] = '';
		}

		if ($out['change_awstat'] == 'yes') {
			$arr[] = 'checked=\'true\'';
		}
		else {
			$arr[] = '';
		}

		return $arr;
	}

	public function webstatic_load_site_check($user = '')
	{
		if (!$this->check_user($user)) {
			return 0;
		}

		if ($user == '') {
			return NULL;
		}

		$file = $this->dir_site_path . '/' . $user;
		$out = $this->config_read($file);

		if ($out['newsite_webalizer'] == 'yes') {
			$arr[] = 'checked=\'true\'';
		}
		else {
			$arr[] = '';
		}

		if ($out['newsite_awstat'] == 'yes') {
			$arr[] = 'checked=\'true\'';
		}
		else {
			$arr[] = '';
		}

		return $arr;
	}

	public function webstatic_load_prog_check_ajax($user = '')
	{
		if ($user == '') {
			return NULL;
		}

		if (!$this->check_user($user)) {
			return 0;
		}

		$file = $this->dir_site_path . '/' . $user;
		$out = $this->config_read($file);
		$arr['change_webalizer'] = $out['change_webalizer'];
		$arr['change_awstat'] = $out['change_awstat'];
		if (!isset($arr['change_webalizer']) || !isset($arr['change_awstat'])) {
			$arr['user'] = 'new';
			$file = $this->module_params_path . '/main';
			$arr_check_default = $this->config_read($file);
			$arr['change_webalizer'] = $arr_check_default['change_webalizer_newuser'];
			$arr['change_awstat'] = $arr_check_default['change_awstat_newuser'];
		}
		else {
			$arr['user'] = 'old';
		}

		return $arr;
	}

	public function webstatic_load_site_check_ajax($user = '')
	{
		if ($user == '') {
			return NULL;
		}

		if (!$this->check_user($user)) {
			return 0;
		}

		$file = $this->dir_site_path . '/' . $user;
		$out = $this->config_read($file);
		$arr['newsite_webalizer'] = $out['newsite_webalizer'];
		$arr['newsite_awstat'] = $out['newsite_awstat'];
		if (!isset($arr['newsite_webalizer']) || !isset($arr['newsite_awstat'])) {
			$arr['user'] = 'new';
			$file = $this->module_params_path . '/main';
			$arr_check_default = $this->config_read($file);
			$arr['newsite_webalizer'] = $arr_check_default['change_site_webalizer_newuser'];
			$arr['newsite_awstat'] = $arr_check_default['change_site_awstat_newuser'];
		}
		else {
			$arr['user'] = 'old';
		}

		return $arr;
	}

	public function webstatic_load_site_list_check($res)
	{
	}

	public function webstatic_json($out, $prog, $site)
	{
		$arr['site'] = $out;
		$arr['webstatic'] = $prog['change_webalizer'];
		$arr['awstat'] = $prog['change_awstat'];
		$arr['site_webstatic'] = $site['newsite_webalizer'];
		$arr['site_awstat'] = $site['newsite_awstat'];
		return $arr;
	}

	public function webstatic_scan_newuser()
	{
		$arr = $this->webstatic_load_user();
		$i = 0;

		while ($i < count($arr)) {
			$file = $this->dir_site_path . '/' . $arr[$i];
			$us = $this->config_read($file);
			$b = false;

			foreach ($us as $key => $val) {
				$b = true;
				break;
			}

			if (!$b) {
				$out[] = $arr[$i];
			}

			++$i;
		}

		return $out;
	}

	public function webstatic_save_all_yesuser($a)
	{
		$file = $this->module_params_path . '/main';
		$poss_arr = array('yes', 'no', '');

		foreach ($a as $value) {
			return 0;
		}

		$arr['change_webalizer_site_all'] = $a[0];
		$arr['change_awstat_site_all'] = $a[1];
		$arr['change_webalizer_site_newonly'] = $a[2];
		$arr['change_awstat_site_newonly'] = $a[3];
		$this->web_config_save($file, $arr, 'add');
		return $arr;
	}

	public function web_save_config_new_params_all_user($param_web, $param_aw)
	{
		if ($param_web) {
			if (!in_array($param_web, $this->js_comand)) {
				return false;
			}
		}
		if ($param_aw) {
			if (!in_array($param_aw, $this->js_comand)) {
				return false;
			}
		}

		$users = $this->webstatic_load_user();
		$i = 0;

		while ($i < count($users)) {
			$us = $this->webstatic_checked_olduser($users[$i]);
			$json = str_replace('"', '', trim($this->array_site_st));
			$json = $this->fixJSON($json);
			$st = json_decode($json);

			foreach ($st as $key => $val) {
				if ($param_web != 'default') {
					$val[0] = $param_web;
				}

				if ($param_aw != 'default') {
					$val[1] = $param_aw;
				}

				$out[$key] = array($val[0], $val[1]);
			}

			$file = $this->dir_site_path . '/' . $users[$i];
			$a[$this->module_params_name] = str_replace('"', '\\'', json_encode($out));
			$dd = $this->web_config_save($file, $a, 'add');
			unset($out);
			++$i;
		}
	}

	public function webstatic_save_new_alluser($web, $awstat, $site_web, $site_awstat)
	{
		if ($web) {
			if (!in_array($web, $this->js_comand)) {
				return false;
			}
		}
		if ($awstat) {
			if (!in_array($awstat, $this->js_comand)) {
				return false;
			}
		}
		if ($site_web) {
			if (!in_array($site_web, $this->js_comand)) {
				return false;
			}
		}
		if ($site_awstat) {
			if (!in_array($site_awstat, $this->js_comand)) {
				return false;
			}
		}

		$file = $this->module_params_path . '/main';
		$arr['change_webalizer_newuser'] = $web;
		$arr['change_awstat_newuser'] = $awstat;
		$arr['change_site_webalizer_newuser'] = $site_web;
		$arr['change_site_awstat_newuser'] = $site_awstat;
		$this->web_config_save($file, $arr, 'add');
	}

	public function webstatic_load_all_yesuser()
	{
		$file = $this->module_params_path . '/main';

		if (!is_file($file)) {
			return array();
		}

		$out = $this->config_read($file);

		if ($out['change_webalizer_site_all'] == 'no') {
			$arr[] = '0';
		}
		else if ($out['change_webalizer_site_all'] == 'yes') {
			$arr[] = '1';
		}
		else if ($out['change_webalizer_site_all'] == 'default') {
			$arr[] = '2';
		}
		else {
			$arr[] = '';
		}

		if ($out['change_awstat_site_all'] == 'no') {
			$arr[] = '0';
		}
		else if ($out['change_awstat_site_all'] == 'yes') {
			$arr[] = '1';
		}
		else if ($out['change_awstat_site_all'] == 'default') {
			$arr[] = '2';
		}
		else {
			$arr[] = '';
		}

		if ($out['change_webalizer_site_newonly'] == 'yes') {
			$arr[] = 'checked=\'true\'';
		}
		else {
			$arr[] = '';
		}

		if ($out['change_awstat_site_newonly'] == 'yes') {
			$arr[] = 'checked=\'true\'';
		}
		else {
			$arr[] = '';
		}

		return $arr;
	}

	public function webstatic_load_default_newuser()
	{
		$file = $this->module_params_path . '/main';

		if (!is_file($file)) {
			return array();
		}

		$out = $this->config_read($file);

		if ($out['change_webalizer_newuser'] == 'yes') {
			$arr[] = 'checked=\'true\'';
		}
		else {
			$arr[] = '';
		}

		if ($out['change_awstat_newuser'] == 'yes') {
			$arr[] = 'checked=\'true\'';
		}
		else {
			$arr[] = '';
		}

		if ($out['change_site_webalizer_newuser'] == 'yes') {
			$arr[] = 'checked=\'true\'';
		}
		else {
			$arr[] = '';
		}

		if ($out['change_site_awstat_newuser'] == 'yes') {
			$arr[] = 'checked=\'true\'';
		}
		else {
			$arr[] = '';
		}

		return $arr;
	}

	public function webstatic_axaj_save_alluser($lang)
	{
		global $lang;
		$arr['status'] = $lang['webstat_save_configure'];
		return $arr;
	}

	public function webstatic_reload_sites($user = '')
	{
		global $lang;

		if ($user == '') {
			$out['code'] = 1;
			$out['mess'] = 'user not found';
			return $out;
		}

		$arr = $this->webstatic_load_site_list($user);

		if (!sizeof($arr)) {
			$this->webstatic_site_decode_savefile_user($user, array());
			$out['code'] = 2;
			$out['mess'] = 'hosts not found';
			return $out;
		}

		$this->webstatic_checked_olduser($user);
		$json = str_replace('"', '', trim($this->array_site_st));
		$json = $this->fixJSON($json);
		$st = json_decode($json, true);
		$check_user = $this->webstatic_load_site_check_ajax($user);

		if (!sizeof($st)) {
			foreach ($arr as $key => $val) {
				$st[$key] = array($check_user['newsite_webalizer'], $check_user['newsite_awstat']);
			}

			$this->webstatic_site_decode_savefile_user($user, $st);
		}
		else if (sizeof($st) < sizeof($arr)) {
			$c = array_diff_key($arr, $st);

			if (sizeof($c)) {
				$b = '';

				foreach ($c as $key => $val) {
					$b[$key] = array($check_user['newsite_webalizer'], $check_user['newsite_awstat']);
				}

				$st = array_merge($st, $b);
			}

			$this->webstatic_site_decode_savefile_user($user, $st);
		}
		else if (sizeof($arr) < sizeof($st)) {
			$c = array_diff_key($arr, $st) + array_diff_key($st, $arr);
			$st = array_diff_key($st, $c);
			$this->webstatic_site_decode_savefile_user($user, $st);
		}

		$out['code'] = 0;
		$out['mess'] = 'return new array sites for webstatistics';
		$out['data'] = $st;
		$out['hosts'] = $arr;
		$out['user'] = $check_user['user'];
		return $out;
	}

	public function webstatic_compare_site_user($user = '', $save = true)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		$res = $this->webstatic_reload_sites($user);

		if ($res['code'] != 0) {
			return array();
		}

		$st = $res['data'];
		$check_user_prog = $this->webstatic_load_prog_check_ajax($user);
		$arr_check_default = $this->webstatic_load_default_newuser($user);

		if ($res['user'] == 'old') {
			$list = $st;
			$b = false;
		}
		else {
			$list = $res['hosts'];
			$b = true;
		}

		$puny = new idna_convert();
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);

		foreach ($list as $key_c => $val_c) {
			$domain_pass_webalizer = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_stats/' . $key_c . '/index.html';
			$domain_pass_awstat = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/aw_stats/' . $key_c . '/index.html';
			$domain_pass = array($domain_pass_webalizer, $domain_pass_awstat);
			$arr_pass = $this->webstatic_html_pass($domain_pass);

			if ($res['user'] == 'old') {
				$out[$key_c] = array(0 => 'old', 1 => $check_user_prog['change_webalizer'] == 'yes' ? 'checked=\'true\'' : '', 2 => $check_user_prog['change_awstat'] == 'yes' ? 'checked=\'true\'' : '', 3 => $val_c[0] == 'yes' ? 'checked=\'true\'' : '', 4 => $val_c[1] == 'yes' ? 'checked=\'true\'' : '', 5 => '', 6 => '', 7 => $arr_pass[0], 8 => $arr_pass[1], 'domain_decode' => $puny->decode($key_c));
			}
			else {
				$out[$key_c] = array(0 => 'new', 1 => $arr_check_default[0], 2 => $arr_check_default[1], 3 => $arr_check_default[2], 4 => $arr_check_default[3], 5 => '', 6 => '', 7 => $arr_pass[0], 8 => $arr_pass[1], 'domain_decode' => $puny->decode($key_c));
				$out_save[$key_c] = array($arr_check_default[2] ? 'yes' : 'no', $arr_check_default[3] ? 'yes' : 'no');
			}
		}

		if ($b) {
			$file = $this->dir_site_path . '/' . $user;
			$arr_save['change_webalizer'] = $arr_check_default[0] ? 'yes' : 'no';
			$arr_save['change_awstat'] = $arr_check_default[1] ? 'yes' : 'no';
			$arr_save['newsite_webalizer'] = $arr_check_default[2] ? 'yes' : 'no';
			$arr_save['newsite_awstat'] = $arr_check_default[3] ? 'yes' : 'no';
			$this->web_config_save($file, $arr_save, 'add');
		}

		return $out;
	}

	public function webstatic_checked_olduser($user = '')
	{
		if ($user == '') {
			return false;
		}

		if (!$this->check_user($user)) {
			return 0;
		}

		$file = $this->dir_site_path . '/' . $user;
		$a = file($file);
		$i = 0;

		while ($i < count($a)) {
			$t = explode('=', $a[$i]);
			$arr[$t[0]] = $t[1];
			++$i;
		}

		$b = false;

		foreach ($arr as $key => $val) {
			$b = true;
			break;
		}

		$this->array_site = $arr['vhost_list'];

		if ($b) {
			$this->array_site_st = $arr[$this->module_params_name];
			return true;
		}

		$this->array_site_st = array();
		return false;
	}

	public function webstatic_prog_useronly($res)
	{
		foreach ($res as $key => $val) {
			$out = array($val[1], $val[2]);
			break;
		}

		return $out;
	}

	public function webstatic_html_pass($arr_domain)
	{
		if (file_exists($arr_domain[0])) {
			$out[] = 1;
		}
		else {
			$out[] = 0;
		}

		if (file_exists($arr_domain[1])) {
			$out[] = 1;
		}
		else {
			$out[] = 0;
		}

		return $out;
	}

	public function web_config_save($file, $arr_c, $type)
	{
		$fp = fopen($file, 'a+');
		flock($fp, LOCK_EX);
		$cur = parse_ini_file($file);
		$arr = $arr_c;

		if ($type == 'add') {
			$out = array();

			foreach ($cur as $key => $val) {
				if (!$key) {
					continue;
				}

				$b = false;

				foreach ($arr as $key_c => $val_c) {
					$out[$key_c] = $val_c;
					$b = true;
					unset($arr[$key_c]);
					break;
				}

				if (!$b) {
					$out[$key] = $val;
				}
			}

			if (sizeof($arr)) {
				foreach ($arr as $key_p => $val_p) {
					$out[$key_p] = $val_p;
				}
			}
		}
		else if ($type == 'del') {
			$out = array();

			foreach ($cur as $key => $val) {
				if (!$key) {
					continue;
				}

				$b = false;

				foreach ($arr as $key_c => $val_c) {
					unset($arr[$key_c]);
					$b = true;
					break;
				}

				if (!$b) {
					$out[$key] = $val;
				}
			}
		}
		else if (sizeof($arr)) {
			foreach ($arr as $key_p => $val_p) {
				$out[$key_p] = $val_p;
			}
		}

		ftruncate($fp, 0);
		$res = array();

		foreach ($out as $key => $val) {
			if (is_array($val)) {
				$res[] = '[' . $key . ']';

				foreach ($val as $skey => $sval) {
					$res[] = $skey . '=' . (is_numeric($sval) ? $sval : '' . $sval . '');
				}
			}
			else {
				$val_escape = str_replace('"', '\\"', $val);
				$res[] = $key . '=' . (is_numeric($val) ? $val : '"' . $val_escape . '"');
			}
		}

		fwrite($fp, implode("\r\n", $res));
		fflush($fp);
		flock($fp, LOCK_UN);
		fclose($fp);
		return $res;
	}

	public function webstatic_json_save_params_user($info, $prog, $status)
	{
		$arr['info'] = $info;
		$arr['prog'] = $prog;
		$arr['status'] = $status;
		return $arr;
	}

	public function web_webalizer_create_site_user($user = '', $key = '')
	{
		if (($user == '') || ($key == '')) {
			return false;
		}

		if (!$this->check_user($user)) {
			return 0;
		}

		$hostacc = new hostacc();
		$workspace = $hostacc->getWorkspace($user);

		if (0 < strlen($workspace)) {
			$workspace = $workspace . '/';
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);

		if (!file_exists($confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/webalizer')) {
			$path = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/webalizer';
			$this->sudo_ssh('mkdir -p ' . $path);
		}

		if (!file_exists($confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_lib')) {
			$path_lib = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_lib';
			$this->sudo_ssh('mkdir -p ' . $path_lib);
		}

		if (!file_exists($confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/webalizer/' . $key . '.conf')) {
			$path_log = $confUser['rootdir'] . '/' . $workspace . 'log/' . $key . '_access_webaliz';
			$path_output = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_stats/' . $key;
			$path_lib_hist = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_lib/' . $key . '.hist';
			$path_lib_curr = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_lib/' . $key . '.current';
			$host_name = $key;
			$params = array('LogFile' => $path_log, 'OutputDir' => $path_output, 'HostName' => $host_name, 'HistoryName' => $path_lib_hist, 'IncrementalName' => $path_lib_curr);
			$out = $this->web_webalizer_save_config($params, $key);
			$h = fopen($confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/webalizer/' . $key . '.conf', 'w+');
			$i = 0;

			while ($i < count($out)) {
				fwrite($h, trim($out[$i]) . "\n");
				++$i;
			}

			fclose($h);
			unset($h);
		}

		$dir = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_stats/' . $key;
		$this->sudo_ssh('mkdir -p ' . $dir);
		return true;
	}

	public function web_webalizer_create_conf_user($user = '')
	{
		if ($user == '') {
			return NULL;
		}

		if (!$this->check_user($user)) {
			return 0;
		}

		$hostacc = new hostacc();
		$workspace = $hostacc->getWorkspace($user);

		if (0 < strlen($workspace)) {
			$workspace = $workspace . '/';
		}

		$us = $this->webstatic_checked_olduser($user);
		$json = str_replace('"', '', trim($this->array_site_st));
		$json = $this->fixJSON($json);
		$st = json_decode($json);
		$dir = $this->dir_analizer_conf_default_path;
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);

		if (!file_exists($confUser['rootdir'])) {
			return 'error';
		}

		if (!file_exists($confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/webalizer')) {
			$path = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/webalizer';
			$this->sudo_ssh('mkdir -p ' . $path);
		}

		if (!file_exists($confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_lib')) {
			$path_lib = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_lib';
			$this->sudo_ssh('mkdir -p ' . $path_lib);
		}

		foreach ($st as $key => $val) {
			$path_log = $confUser['rootdir'] . '/' . $workspace . 'log/' . $key . '_' . date('m.Y') . '_access';
			$path_log_webaliz = $confUser['rootdir'] . '/' . $workspace . 'log/' . $key . '_access_webaliz';
			$path_output = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_stats/' . $key;
			$path_lib_hist = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_lib/' . $key . '.hist';
			$path_lib_curr = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_lib/' . $key . '.current';
			$host_name = $key;
			$params = array('LogFile' => $path_log_webaliz, 'OutputDir' => $path_output, 'HostName' => $host_name, 'HistoryName' => $path_lib_hist, 'IncrementalName' => $path_lib_curr);
			$out = $this->web_webalizer_save_config($params, $key);
			$h = fopen($confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/webalizer/' . $key . '.conf', 'w+');
			$i = 0;

			while ($i < count($out)) {
				fwrite($h, trim($out[$i]) . "\n");
				++$i;
			}

			fclose($h);
			unset($h);
		}

		$this->web_webalizer_create_log($user, $st);
		return $st;
	}

	public function web_webalizer_create_log($user = '', $st)
	{
		if ($user == '') {
			return NULL;
		}

		if (!$this->check_user($user)) {
			return 0;
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$dir = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_stats';

		foreach ($st as $key => $val) {
			$v = $dir . '/' . $key;

			if (!is_file($v)) {
				$this->sudo_ssh('mkdir -p ' . $v);
			}
		}
	}

	public function web_webalizer_create_process($user = '', $st)
	{
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$dir = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/webalizer';
		$hostacc = new hostacc();
		$workspace = $hostacc->getWorkspace($user);

		if (0 < strlen($workspace)) {
			$workspace = $workspace . '/';
		}

		$conf = $dir . '/' . $key . '.conf';

		if ($val[0] == 'yes') {
			$path_log = $confUser['rootdir'] . '/' . $workspace . 'log/' . $key . '_' . date('m.Y') . '_access';
			$path_log_webaliz = $confUser['rootdir'] . '/' . $workspace . 'log/' . $key . '_access_webaliz';
			$path_last_row_anal = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_lib/' . $key . '.lastrowanal';
			$logs_read = file_get_contents($path_log);
			$ifind_lastanal = 0;

			if (is_file($path_last_row_anal)) {
				$last_row_read = file_get_contents($path_last_row_anal);
				$ifind_lastanal = stripos($logs_read, $last_row_read) + strlen($last_row_read);
			}
			else {
				$ifind_lastanal = 0;
			}

			file_put_contents($path_log_webaliz, substr($logs_read, $ifind_lastanal));
			$arr_logs_read = preg_split('/\\r\\n|\\r|\\n/', file_get_contents($path_log));
			file_put_contents($path_last_row_anal, $arr_logs_read[count($arr_logs_read) - 2] . $arr_logs_read[count($arr_logs_read) - 1]);
			$out = $this->sudo_ssh('webalizer -c ' . $conf . ' &>/dev/stdout');
		}

		$path = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_stats/' . $key . '/';
		$html = $this->sudo_ssh('ls ' . $path . ' | grep .html &>/dev/stdout');
		$i = 0;

		$arr_file = file($path . $html[$i]);
		$z = 0;

		while ($z < count($arr_file)) {
			if (strstr($arr_file[$z], '<A HREF="')) {
				if (strstr($arr_file[$z], '<A HREF="#')) {
					$res[] = $arr_file[$z];
				}
				else {
					$str = str_replace('<A HREF="', '<A HREF="' . '\\index.php?do=web_statistics&subaction=view_user_alizer&user=' . $user . '&site=' . $key . '&page=', $arr_file[$z]);
					$res[] = $str;
				}
			}
			else {
				$res[] = $arr_file[$z];
			}

			++$z;
		}

		$h = fopen($path . $html[$i], 'w+');
		$z = 0;

		while ($z < count($res)) {
			fwrite($h, $res[$z]);
			++$z;
		}

		fclose($h);
		unset($h);
		unset($res);
		++$i;
	}

	public function web_webalizer_save_config($params, $site)
	{
		$dir = $this->dir_analizer_conf_default_path;
		$line = array();
		$h = file($dir);

		while (list($var, $z) = each($h)) {
			$b = false;
			$el = '';

			foreach ($params as $key => $val) {
				$search0 = $key . ' ';
				$search1 = '#' . $key . ' ';
				$b = true;
				$el = $key;
				$el0 = trim($val);
				unset($params[$key]);
				break;
			}

			if ($b) {
				$line[] = $el . ' ' . $val;
			}
			else {
				$line[] = $z;
			}
		}

		return $line;
	}

	public function webalizer_load_html_site($user, $site, $page = '')
	{
		if ($site) {
			if (!$this->check_value('domain', $site)) {
				return false;
			}
		}

		if (!$page) {
			$page = 'index.html';
		}

		if (!$this->check_user($user)) {
			return 0;
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$dir = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_stats/' . $site . '/' . $page;

		if (file_exists($dir)) {
			$out = file_get_contents($dir);
			preg_match_all('/(img|src)=("|\')[^"\'>]+/i', $out, $media);
			$arr_img = preg_replace('/(img|src)("|\'|="|=\')(.*)/i', '$3', $media[0]);
			$i = 0;

			while ($i < count($arr_img)) {
				$img = file_get_contents($confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/web_stats/' . $site . '/' . $arr_img[$i]);
				$out = str_replace($arr_img[$i], 'data:image/png;base64,' . base64_encode($img), $out);
				++$i;
			}
		}

		return $out;
	}

	public function web_webalizer_get_st()
	{
		$json = str_replace('"', '', trim($this->array_site_st));
		$json = $this->fixJSON($json);
		return json_decode($json);
	}

	public function web_awstats_create_site_user($user = '', $key = '')
	{
		if (($user == '') || ($key == '')) {
			return false;
		}

		if (!$this->check_user($user)) {
			return 0;
		}

		$puny = new idna_convert();
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$dir_conf = '/etc/brainy/src/webstatics/awstats';
		$file_conf = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/awstats/' . 'awstats.' . $key . '.conf';

		if (!file_exists($confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/awstats')) {
			$path = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/awstats';
			$this->sudo_ssh('mkdir -p ' . $path);
		}

		if (!file_exists($dir_conf)) {
			$path = $dir_conf;
			$this->sudo_ssh('mkdir -p ' . $path);
		}

		if (!file_exists($confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/aw_stats')) {
			$path_lib = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/aw_stats';
			$this->sudo_ssh('mkdir -p ' . $path_lib);
		}

		$hostacc = new hostacc();
		$workspace = $hostacc->getWorkspace($user);

		if (0 < strlen($workspace)) {
			$workspace = $workspace . '/';
		}

		if (!file_exists($file_conf)) {
			$path_log = '"' . $confUser['rootdir'] . '/' . $workspace . 'log/' . $key . '_' . date('m.Y') . '_access"';
			$path_output = '"' . $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/aw_stats/' . $key . '"';
			$host_name = '"' . $puny->decode($key) . '"';
			$params = array('LogFile' => $path_log, 'DirData' => $path_output, 'SiteDomain' => $host_name, 'HostAliases' => $host_name);
			$out = $this->web_awstats_save_config($params, $key);
			$h = fopen($file_conf, 'w+');
			$i = 0;

			while ($i < count($out)) {
				fwrite($h, trim($out[$i]) . "\n");
				++$i;
			}

			fclose($h);
			unset($h);
		}

		return true;
	}

	public function web_awstats_save_config($params, $site)
	{
		$dir = $this->dir_awstats_conf_default_path;
		$line = array();
		$h = file($dir);

		while (list($var, $z) = each($h)) {
			$b = false;
			$el = '';

			foreach ($params as $key => $val) {
				$search0 = $key . '=';
				$search1 = '#' . $key . '=';
				$b = true;
				$el = $key;
				$el0 = trim($val);
				unset($params[$key]);
				break;
			}

			if ($b) {
				$line[] = $el . '=' . $val;
			}
			else {
				$line[] = $z;
			}
		}

		return $line;
	}

	public function web_awstats_del_config($key)
	{
		$file_conf = '/etc/brainy/src/webstatics/awstats/' . 'awstats.' . $key . '.conf';
		$this->sudo_ssh('rm -f ' . $file_conf);
	}

	public function web_awstats_create_process($user, $key)
	{
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$dir = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/aw_stats/' . $key;
		$this->sudo_ssh('mkdir -p ' . $dir);
		$conf_key = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/awstats/awstats.' . $key . '.conf';
		$this->sudo_ssh('/etc/brainy/src/awstats/awstats.pl -config=' . $conf_key);
	}

	public function web_awstats_create_html($user, $key)
	{
		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$dir = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/aw_stats/' . $key;
		$conf_key = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/awstats/awstats.' . $key . '.conf';
		$this->sudo_ssh('/etc/brainy/src/awstats/awstats.pl -config=' . $conf_key . ' -output > ' . $dir . '/index.html');
	}

	public function awstats_load_html_site($user, $site, $page = '', $date)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		if (!$this->check_value('domain', $site)) {
			return false;
		}

		if (!$this->check_value('string', $page)) {
			return false;
		}

		$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
		$dir = $confUser['rootdir'] . $GLOBALS['WEB_STAT_DIR'] . '/aw_stats/' . $site . '/index.html';
		if (file_exists($dir) || ($page != '')) {
			if ($page && ($page == 'form')) {
				$str = '';

				foreach ($date as $key => $val) {
					$str .= ' -' . $key . '=' . $val . ' ';
				}

				$out = implode("\n", $this->sudo_ssh('perl /etc/brainy/src/awstats/awstats.pl ' . $str . ' &>/dev/stdout'));
			}
			else {
				if ($page && ($page != 'close')) {
					$str = '';
					$v = split(',', $page);
					$i = 0;

					while ($i < count($v)) {
						$arr = explode(':', $v[$i]);
						$str .= ' -' . $arr[0] . '=' . $arr[1] . ' ';
						++$i;
					}

					$out = implode("\n", $this->sudo_ssh('perl /etc/brainy/src/awstats/awstats.pl ' . $str . ' &>/dev/stdout'));
				}
				else {
					$out = file_get_contents($dir);
				}
			}

			$out = str_replace('target="awstatsbis"', ' ', $out);
			$out = str_replace('<form name="FormDateFilter"', '<form name="FormDateFilter" method="post" ', $out);
			preg_match_all('/(img|src)=("|\')[^"\'>]+/i', $out, $media);
			$arr_img = preg_replace('/(img|src)("|\'|="|=\')(.*)/i', '$3', $media[0]);
			$i = 0;

			while ($i < count($arr_img)) {
				$img = file_get_contents('/etc/brainy/src' . $arr_img[$i]);
				$out = str_replace($arr_img[$i], 'data:image/png;base64,' . base64_encode($img), $out);
				++$i;
			}

			preg_match_all('/(a|href)=("|\')[^"\'>]+/i', $out, $media);
			$arr_html = preg_replace('/(a|href)("|\'|="|=\')(.*)/i', '$3', $media[0]);
			$i = 0;

			while ($i < count($arr_html)) {
				if (strstr($arr_html[$i], 'awstats.pl?')) {
					$a = explode('?', $arr_html[$i]);
					$x = $a[1];
					$v = str_replace('amp;', '', $x);
					$v = str_replace('=', ':', $v);
					$v = str_replace('&', ',', $v);

					if (strstr($v, 'javascript:parent.window.close')) {
						$v = 'close';
					}
				}
				else {
					$v = $arr_html[$i];

					if (strstr($v, 'javascript:parent.window.close')) {
						$v = 'close';
					}
				}

				if (!strstr($arr_html[$i], '#')) {
					$out = str_replace($arr_html[$i], '/index.php?do=web_statistics&subaction=view_user_awstats&user=' . $user . '&site=' . $site . '&params=' . $v, $out);
				}

				++$i;
			}

			preg_match_all('/(form|action)=("|\')[^"\'>]+/i', $out, $media);
			$arr_form = preg_replace('/(form|action)("|\'|="|=\')(.*)/i', '$3', $media[0]);
			$i = 0;

			while ($i < count($arr_form)) {
				if (strstr($arr_form[$i], '_awstatsss_')) {
					$a = explode('?', $arr_form[$i]);
					$x = $a[1];
					$v = str_replace('amp;', '', $x);
					$v = str_replace('=', ':', $v);
					$v = str_replace('&', ',', $v);
				}
				else {
					$v = $arr_form[$i];
				}

				if (!strstr($arr_form[$i], '#')) {
					$out = str_replace($arr_form[$i], '/index.php?do=web_statistics&subaction=view_user_awstats&user=' . $user . '&site=' . $site . '&params=form', $out);
				}

				++$i;
			}
		}

		return $out;
	}

	public function web_check_cron()
	{
		$crontab = new crontab();
		$sss = $crontab->crontab_check_brainy_status_command('');
		return $sss;
	}

	public function get_period_update()
	{
		$file_out_array = explode(PHP_EOL, trim(file_get_contents('/etc/brainy/conf/cron_exec_config')));

		foreach ($file_out_array as $val_array) {
			list($comand, $time_exec) = explode('|', trim($val_array));

			list($minutes, $hour) = explode(',', trim($time_exec));

			if (!preg_match('/[0-9]/iu', $hour)) {
				$minutes = preg_replace('/\\*|\\//iu', '', $minutes);

				return $minutes;
			}

			$hour = preg_replace('/\\*|\\//iu', '', $hour);
			$minutes = $minutes + ($hour * 60);

			return $minutes;
		}

		if (!$minutes) {
			return 0;
		}
	}

	public function save_reriod_update($data)
	{
		global $lang;
		$cron = new crontab();
		$this->del_string_new('web_statistics.php', '/etc/brainy/conf/cron_exec_config');
		$this->del_string_new('web_statistics.php', '/etc/brainy/data/crontab/next_exec');

		if ($data == 0) {
			$arr_out['code'] = 0;
			$arr_out['message'] = $lang['web_statistics_remove_update'];
			return $arr_out;
		}

		$array = $cron->get_minutes_hour_for_day($data);

		if (!isset($array['minutes'])) {
			return $array;
		}

		$cron->edit_config_script_cron('/etc/brainy/src/compiled/php5/bin/php -q /etc/brainy/scripts/web_statistics.php >/dev/null 2>/dev/null', $array['minutes'], $array['hour']);
		$arr_out['code'] = 0;
		$arr_out['message'] = $lang['webstat_save_configure'];
		return $arr_out;
	}

	public function getperiodupdate()
	{
		global $smarty;
		$cron = new crontab();
		$period = $cron->crontab_check_is_job('web_statistics.php');
		$period = $cron->getperiodcron_human($period);
		$smarty->assign('period_update', $period);
	}
}


?>
