<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class Webserver
{
	public $serv_datapath = '/etc/brainy/data/server_control/';
	public $tplVhost = '/etc/brainy/conf/vhosts/vhosts.tpl';
	public $tplWebCacheData = '/etc/brainy/data/apacserver/data';
	public $tplVhostLocal = '/etc/brainy/conf/vhosts/vhosts.local.tpl';
	public $logConfRotate = '/etc/brainy/data/logging/logwebserverrot';

	public function webserver_server_status()
	{
		global $lang;
		$arr = $this->config_read('/etc/brainy/data/server_control/main');

		if ($arr['front_server'] == 'nginx') {
			$url = 'http://' . $_SERVER['SERVER_ADDR'] . ':8080/server-status';
		}
		else {
			$url = 'http://' . $_SERVER['SERVER_ADDR'] . '/server-status';
		}

		$out = file_get_contents($url);

		if ($out == '') {
			$out = $lang['server_control_not_start'];
		}

		return $out;
	}

	public function check_user_fpm($phpw, $user)
	{
		$counter = 0;
		$out = $this->webserver_getdomains($user);

		if (is_array($out)) {
			foreach ($out as $value) {
				$foo = $this->config_read('/etc/brainy/data/vhosts/' . $value . '.conf');
				if ((($foo['bridge'] == 'fastcgi') || ($foo['bridge'] == 'php-fpm')) && ($foo['php'] == $phpw)) {
					++$counter;
				}
			}
		}

		return $counter;
	}

	public function webserver_change_openphps($phpw, $plusminus = NULL)
	{
		$out = $this->config_read('/etc/brainy/data/server_control/main');
		$already_open_phps = explode(',', $out['open_phps']);

		switch ($plusminus) {
		case 'minus':
			foreach ($already_open_phps as $key => $value) {
				unset($already_open_phps[$key]);
				break;
			}

			break;

		case 'plus':
			foreach ($phpw as $key => $value) {
				if (!in_array($value, $already_open_phps)) {
					$already_open_phps[] = $value;
				}
			}

			break;
		}

		$phps = $this->webserver_php_list();

		if (in_array('nophpw', $already_open_phps)) {
			$newm[] = 'nophpw';
		}

		foreach ($phps as $key => $value) {
			if (in_array($key, $already_open_phps)) {
				$newm[] = $key;
			}
		}

		$newm = array_filter($newm);
		$newm = array_values($newm);
		$newm = implode(',', $newm);
		$out['open_phps'] = $newm;
		$this->write_php_ini($out, $GLOBALS['SERVER_CONTROL_MAIN']);
		return 1;
	}

	public function webserver_bridges_list()
	{
		$out1 = $this->config_read('/etc/brainy/data/server_control/main');
		$open_bridges = explode(',', $out1['open_bridges']);
		$out = $this->config_read('/etc/brainy/data/server_control/bridges');

		foreach ($out as $key => $value) {
			$out_rr = explode('|', $value);
			$out_exeption = explode(',', $out_rr[1]);
			$foo = explode(',', $out_rr[0]);

			if (preg_match('/^apache/i', $out1['back_server'])) {
				$srv = 'apache';
			}
			else {
				$srv = 'nginx';
			}

			if (preg_match('/' . $srv . '/i', $out_rr[0])) {
				$newm[$key]['webserver'] = $srv;

				if (in_array($key, $open_bridges)) {
					$newm[$key]['access'] = 1;
					$newm[$key]['exeption'] = $out_rr[1];
				}
				else {
					$newm[$key]['access'] = 0;
					$newm[$key]['exeption'] = $out_rr[1];
				}

				if ($out1['default_bridge'] == $key) {
					$newm[$key]['default'] = 1;
				}
				else {
					$newm[$key]['default'] = 0;
				}
			}
		}

		return $newm;
	}

	public function webserver_set_default_bridge($bridge, $reload = 0)
	{
		global $lang;

		if (!$this->check_value('strdot', $bridge)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);
		$conf['default_bridge'] = $bridge;
		$this->write_php_ini($conf, $GLOBALS['SERVER_CONTROL_MAIN']);

		if ($reload == 0) {
			$this->webservers_reloadconf(1);
		}
	}

	public function webserver_set_open_bridges($bridges, $reload = 0)
	{
		if (!$this->check_value('strdot', $bridges)) {
			return 0;
		}

		$open = implode(',', $bridges);
		$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);
		$conf['open_bridges'] = $open;
		$this->write_php_ini($conf, $GLOBALS['SERVER_CONTROL_MAIN']);

		if ($reload == 1) {
			$this->webservers_reloadconf(1);
		}
	}

	public function webserver_set_acces_phps($acces, $reload = 0)
	{
		if (($acces == 1) || ($acces == 'yes')) {
			$acces = '1';
		}
		else {
			$acces = '0';
		}

		$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);
		$conf['acces_phps'] = $acces;
		$this->config_save($GLOBALS['SERVER_CONTROL_MAIN'], $conf);

		if ($reload == 0) {
			$this->webservers_reloadconf(1);
		}
	}

	public function webserver_set_acces_bridges($acces, $reload = 0)
	{
		$acces = $this->strip_quotes_cmd($acces);
		if (($acces == 1) || ($acces == 'yes')) {
			$acces = '1';
		}
		else {
			$acces = '0';
		}

		$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);
		$conf['acces_bridges'] = $acces;
		$this->config_save($GLOBALS['SERVER_CONTROL_MAIN'], $conf);

		if ($reload == 0) {
			$this->webservers_reloadconf(1);
		}
	}

	public function webserver_php_list()
	{
		$out1 = $this->config_read('/etc/brainy/data/server_control/main');
		$open_phps = explode(',', $out1['open_phps']);
		$out = $this->config_read('/etc/brainy/data/server_control/servers_php');

		foreach ($out as $key => $value) {
			$foo = explode('|', $value);
			$newm[$key]['fpm-port'] = $foo[1];
			$newm[$key]['name'] = $foo[0];

			if (in_array($key, $open_phps)) {
				$newm[$key]['access'] = 1;
			}
			else {
				$newm[$key]['access'] = 0;
			}

			if ($out1[$key] != '') {
				$newm[$key]['installed'] = 1;
			}
			else {
				$newm[$key]['installed'] = 0;
			}

			if ($out1['default_php'] == $key) {
				$newm[$key]['default'] = 1;
			}
			else {
				$newm[$key]['default'] = 0;
			}
		}

		return $newm;
	}

	public function webserver_setup_bridges($bridges, $reload = 0)
	{
		if (!$this->check_value('strdot', $bridges)) {
			return 0;
		}

		$os_version = $GLOBALS['OS_VERSION'];
		$arch_version = $GLOBALS['ARCH_VERSION'];
		$args = array();
		$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);

		if ($conf['back_server'] == 'apache2.2') {
			$apache_path = $GLOBALS['APACHE22_PATH'];

			if ($os_version == 'debian8') {
				$apache_modules = $GLOBALS['APACHE22_MODULES_DEBIAN'];
			}
			else if ($arch_version == 'i686') {
				$apache_modules = $GLOBALS['APACHE22_MODULES_i386'];
			}
			else {
				$apache_modules = $GLOBALS['APACHE22_MODULES'];
			}

			$apache_comm = 'httpd';
		}

		if ($conf['back_server'] == 'apache2.4') {
			$apache_path = $GLOBALS['APACHE24_PATH'];

			if ($os_version == 'debian8') {
				$apache_modules = $GLOBALS['APACHE24_MODULES_DEBIAN'];
			}
			else if ($arch_version == 'i686') {
				$apache_modules = $GLOBALS['APACHE24_MODULES_i386'];
			}
			else {
				$apache_modules = $GLOBALS['APACHE24_MODULES'];
			}

			$apache_comm = 'httpd';
		}

		if (2 < strlen($apache_modules)) {
			$comm = 'find ' . $apache_modules . ' -name "libphp.so" -exec rm {} \\;';
			exec($comm);
			$comm = 'find ' . $apache_modules . ' -name "libphp5.so" -exec rm {} \\;';
			exec($comm);
		}

		$comm = 'find ' . $GLOBALS['SSH_PATH'] . ' -type f -exec chmod 755 {} \\;';
		exec($comm);
		$comm = 'find ' . $GLOBALS['SSH_PATH'] . ' -type f -exec chmod 755 {} \\;';
		exec($comm);

		foreach ($bridges as $bridge) {
			if ($bridge == 'mod_php') {
				$comm = 'cp ' . $GLOBALS['MOD_PHP_RES_CONF'] . ' ' . $apache_path . 'conf.d/mod_php.conf';
				exec($comm);
				$this->ssh('rm -f ' . $apache_path . 'conf.d/mod_ruid.conf');
				$args['mod_php'] = 'yes';
			}
			else if ($bridge == 'fastcgi') {
				if ($conf['back_server'] == 'apache2.2') {
					$comm = 'cp ' . $GLOBALS['FASTCGI_RES_CONF'] . ' ' . $apache_path . 'conf.d/fastcgi.conf';
					exec($comm);
				}

				if ($conf['back_server'] == 'apache2.4') {
					$comm = 'rm -f ' . $apache_path . 'conf.d/fastcgi.conf';
					exec($comm);
				}

				$args['fastcgi'] = 'yes';
			}
			else if ($bridge == 'mod_ruid') {
				$comm = 'cp ' . $GLOBALS['MOD_RUID_RES_CONF'] . ' ' . $apache_path . 'conf.d/mod_ruid.conf';
				exec($comm);
				$this->ssh('rm -f ' . $apache_path . 'conf.d/mod_php.conf');
				$args['mod_ruid'] = 'yes';
			}
			else if ($bridge == 'suphp') {
				$comm = 'chmod +s /usr/sbin/suphp';
				exec($comm);
				$comm = 'cp ' . $GLOBALS['MOD_SUPHP_RES_CONF'] . ' ' . $GLOBALS['SUPHP_CONF'];
				exec($comm);

				if ($conf['back_server'] == 'apache2.2') {
					$comm = 'cp ' . $GLOBALS['BRIDGES_SUPHP_CONF'] . ' ' . $apache_path . 'conf.d/mod_suphp.conf';
					exec($comm);
				}

				$args['suphp'] = 'yes';
			}
			else if ($bridge == 'cgi') {
				$args['cgi'] = 'yes';
			}
			else if ($bridge == 'fpm') {
				$comm = 'cp ' . $GLOBALS['FPM_RES_CONF'] . ' ' . $GLOBALS['NGINX_CONF'];
				exec($comm);
				$args['fpm'] = 'yes';
			}
			else if ($bridge == 'nophp') {
				$args['nophp'] = 'yes';
			}
		}

		unset($conf['mod_php']);
		unset($conf['fastcgi']);
		unset($conf['mod_ruid']);
		unset($conf['suphp']);
		unset($conf['cgi']);
		unset($conf['fpm']);
		unset($conf['nophp']);
		$fin = array_merge($conf, $args);
		$this->write_php_ini($fin, $GLOBALS['SERVER_CONTROL_MAIN']);

		if ($reload == 0) {
			$this->webservers_reloadconf(1);
		}

		return $args;
	}

	public function webserver_set_default_php($phpw, $reload = 0)
	{
		if (!$this->check_value('strdot', $phpw)) {
			return 0;
		}

		$os_version = $GLOBALS['OS_VERSION'];
		$arch_version = $GLOBALS['ARCH_VERSION'];
		if (($os_version == 'debian8') || ($arch_version != 'x86_64')) {
			$php_libdir = 'lib';
		}
		else {
			$php_libdir = 'lib64';
		}

		$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);

		if ($conf['back_server'] == 'apache2.2') {
			$apache_path = $GLOBALS['APACHE22_PATH'];

			if ($os_version == 'debian8') {
				$apache_modules = $GLOBALS['APACHE22_MODULES_DEBIAN'];
			}
			else if ($arch_version == 'i686') {
				$apache_modules = $GLOBALS['APACHE22_MODULES_i386'];
			}
			else {
				$apache_modules = $GLOBALS['APACHE22_MODULES'];
			}

			$apache_comm = 'httpd';
		}

		if ($conf['back_server'] == 'apache2.4') {
			$apache_path = $GLOBALS['APACHE24_PATH'];

			if ($os_version == 'debian8') {
				$apache_modules = $GLOBALS['APACHE24_MODULES_DEBIAN'];
			}
			else if ($arch_version == 'i686') {
				$apache_modules = $GLOBALS['APACHE24_MODULES_i386'];
			}
			else {
				$apache_modules = $GLOBALS['APACHE24_MODULES'];
			}

			$apache_comm = 'httpd';
		}

		$conf['default_php'] = $phpw;
		$this->write_php_ini($conf, $GLOBALS['SERVER_CONTROL_MAIN']);
		global $smarty;
		$php_path_vers = str_replace('w', '', $phpw);

		if (stripos($phpw, 'php5') !== false) {
			$this->ssh('rm -f ' . $apache_modules . 'libphp*');

			if (0 < strlen($apache_modules)) {
				$comm = 'ln -s /usr/bin/' . $php_path_vers . '/' . $php_libdir . '/httpd/modules/libphp5.so ' . $apache_modules . 'libphp5.so';
				exec($comm);
			}

			$args['php_bin'] = '/usr/bin/' . $php_path_vers . '/bin';
			$this->monitor_service_command($php_path_vers . '-fpm', 'restart');
			$this->webservers_reloadconf(1);
		}

		if (stripos($phpw, 'php7') !== false) {
			$this->ssh('rm -f ' . $apache_modules . 'libphp*');

			if (0 < strlen($apache_modules)) {
				$comm = 'ln -s /usr/bin/' . $php_path_vers . '/' . $php_libdir . '/httpd/modules/libphp7.so ' . $apache_modules . 'libphp7.so';
				exec($comm);
				$comm = 'ln -s /usr/bin/' . $php_path_vers . '/' . $php_libdir . '/httpd/modules/libphp7-zts.so ' . $apache_modules . 'libphp7-zts.so';
				exec($comm);
			}

			$comm = 'sed -i \'s@php5_module@php7_module@g\' /etc/httpd/conf.d/mod_php.conf';
			exec($comm);
			$comm = 'sed -i \'s@libphp5@libphp7@g\' /etc/httpd/conf.d/mod_php.conf';
			exec($comm);
			$comm = 'sed -i \'s@php5_module@php7_module@g\' /etc/httpd/conf.d/mod_ruid.conf';
			exec($comm);
			$comm = 'sed -i \'s@libphp5@libphp7@g\' /etc/httpd/conf.d/mod_ruid.conf';
			exec($comm);
			$args['php_bin'] = '/usr/bin/' . $php_path_vers . '/bin';
			$this->monitor_service_command($php_path_vers . '-fpm', 'restart');
			$this->webservers_reloadconf(1);
			exec($comm);
		}
		else if ($phpw == 'nophpw') {
			$comm = 'rm -r -f /etc/httpd/conf.d/*php*';
			$this->sudo_ssh($comm);
		}

		$smarty->assign($args);
		$template = '/etc/brainy/conf/bridges/mod_suphp.conf';
		$out = $smarty->fetch($template);
		$file = '/etc/suphp.conf';
		$phpw_vers_folder = str_replace('w', '', $phpw);
		$comm = 'rm -f /usr/bin/php';
		exec($comm);
		$comm = 'ln -s /usr/bin/' . $phpw_vers_folder . '/bin/php /usr/bin/php';
		exec($comm);
		file_put_contents($file, $out);

		if ($reload == 0) {
			$this->webservers_reloadconf(1);
		}
	}

	public function webservers_reloadconf($restart = 0)
	{
		$conf = $this->config_read('/etc/brainy/data/server_control/main');
		$servers_list = $this->webserver_get_serverlist();

		foreach ($servers_list['servers'] as $key => $item) {
			if ((stripos($conf['back_server'], $item) !== false) || (stripos($conf['front_server'], $item) !== false)) {
				$servers_reload[] = $servers_list[$item]['service'];
			}
		}

		$oper = 'reload';

		foreach ($servers_reload as $item) {
			$item = trim($item);

			if ($restart == 1) {
				$oper = 'restart';
			}

			$this->monitor_service_command($item, $oper);
		}

		sleep(2);
		$this->check_apache_semafor();
	}

	public function webserver_add_domain($domain = NULL, $aliases = NULL, $dir = NULL, $user = NULL, $bridge = NULL, $phpw = NULL, $ip = NULL)
	{
		global $lang;
		$os_version = $GLOBALS['OS_VERSION'];
		$puny = new idna_convert();
		$domain = $puny->encode(trim($domain));
		$black_domain = new black_domain();
		$black_domain_list = $black_domain->get_black_domain();

		if (in_array($domain, $black_domain_list)) {
			return array('code' => 230, 'message' => $lang['black_domain_black']);
		}

		$webpanel = $this->get_webpanel();

		if ($webpanel == $domain) {
			return array('code' => 208, 'message' => $lang['properties_weppanel_alredy_exist2'] . $array_host['user']);
		}

		if (!$this->check_user($user)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		if (isset($ip)) {
			if (!inet_pton($ip)) {
				return array('code' => 204, 'message' => $lang['server_control_error_user']);
			}
		}

		if (0 < strlen($bridge)) {
			if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $bridge)) {
				return array('code' => 205, 'message' => $lang['server_control_error_user']);
			}
		}

		if (0 < strlen($phpw)) {
			if (!preg_match('/^[a-zA-Z0-9_\\-]+$/', $phpw)) {
				return array('code' => 205, 'message' => $lang['server_control_error_user']);
			}
		}

		$dir = trim($dir);

		if (0 < strlen($dir)) {
			if (!$this->check_params('dir', $dir)) {
				return array('code' => 206, 'message' => $lang['server_control_error_user']);
			}
		}

		$domain = strtolower($domain);
		$main_dom = $domain;
		$aliases = strtolower($aliases);
		$user_info = $this->config_read($GLOBALS['USERS_PATH'] . '/' . $user);

		if ($user_info['suspended_sites'] == 1) {
			$outm['code'] = 200;
			$outm['message'] = $lang['hostacc_suspended_sites'];
			return $outm;
		}

		$allcursitesuser = $this->get_virt_hosts($user);
		$all_sites_count = count($allcursitesuser);

		if ($user_info['sites'] != 0) {
			if ($user_info['sites'] <= $all_sites_count) {
				$outm['code'] = 301;
				$outm['message'] = $lang['server_control_overlimit_domains'] . $user_info['sites'];
				return $outm;
			}
		}

		$foo = $this->config_read('/etc/brainy/data/server_control/main');
		$checker = $foo;
		$open_bridges = $checker['open_bridges'];
		$open_phps = $checker['open_phps'];
		$acces_bridges = $checker['acces_bridges'];
		$acces_phps = $checker['acces_phps'];
		$default_bridge = $checker['default_bridge'];
		$default_php = $checker['default_php'];

		if (($bridge != 'fpm') && ($bridge != 'nophp') && ($bridge != 'nophpw')) {
			if (!$bridge || ($acces_bridges != 1) || (substr_count($open_bridges, $bridge) == 0)) {
				$bridge = $default_bridge;
				$outm['code'] = 201;
				$outm['message'] = $lang['server_control_bridg_default1'] . $default_bridge . $lang['server_control_all_version'] . $open_bridges;
			}
		}

		if (!$phpw || ($acces_phps != 1) || (substr_count($open_phps, $phpw) == 0)) {
			$phpw = $default_php;
			$outm['code'] = 200;
			$outm['message'] = $lang['server_control_phpvers_default1'] . $default_php . $lang['server_control_all_version'] . $open_phps;
		}

		$dir = rtrim($dir, '/');

		if (!$domain) {
			$outm['code'] = 100;
			$outm['message'] = $lang['server_control_dom_d_f_s_c'];
			return $outm;
		}

		if (!$dir) {
			$outm['code'] = 101;
			$outm['message'] = $lang['server_control_dom_d_f_s'];
			return $outm;
		}

		if (preg_match('/\\*/i', $domain)) {
			$outm['code'] = 104;
			$outm['message'] = $lang['server_control_star'];
			return $outm;
		}

		if (!$this->check_value('domain', $domain)) {
			$outm['code'] = 104;
			$outm['message'] = $lang['server_control_dom_d_f_i'];
			return $outm;
		}

		if (!$this->check_params('dir', $dir)) {
			return array('code' => 206, 'message' => $lang['server_control_error_user']);
		}

		$already_domains = ' awk -F: \'{print $1}\' /etc/brainy/data/server_control/vhosts';
		$already_domains = $this->ssh($already_domains);
		$vhosts = $this->get_virt_hosts($user);

		foreach ($vhosts as $vhost) {
			$already_domains[] = $vhost['domain'];
		}

		if (in_array($domain, $already_domains) == true) {
			$outm['code'] = 102;
			$outm['message'] = $lang['server_control_d_already'];
			return $outm;
		}

		$conf = $this->config_read('/etc/brainy/data/server_control/main');
		$aliases_m = preg_split('/[\\s,;]/', $aliases);
		$aliases_m = array_filter($aliases_m);
		$aliases_m = array_values($aliases_m);
		$user_info = $this->config_read($GLOBALS['USERS_PATH'] . '/' . $user);

		if ($user_info['dns_zones'] != 0) {
			if ($user_info['dns_zones'] < ($user_info['r_dnszones'] + 1)) {
				$outm['code'] = 391;
				$outm['message'] = $lang['server_control_overlimit_dnz_zones'] . $user_info['dns_zones'];
				return $outm;
			}
		}

		foreach ($aliases_m as $key_al => $value) {
			$value = $puny->encode(trim($value));
			$aliases_m[$key_al] = $value;

			if (in_array($value, $already_domains) == true) {
				$outm['code'] = 102;
				$outm['message'] = $lang['server_control_alias_alr_exist'];

				return $outm;
			}

			$outm['code'] = 104;
			$outm['message'] = $lang['server_control_n_f_a'] . $value;

			return $outm;
		}

		$user_info = new user_info();
		$user_info->edit_user($user, 'add_domain', $domain);
		$conf_aliases = implode(' ', $aliases_m);
		$aliases = implode('+', $aliases_m);
		$mailclient = new mailclient();
		$mailclient->mailclient_addDomainToDb($domain);
		$conf_domain = $domain;
		$domain = $domain . ':' . $aliases;
		$users = $this->config_read('/etc/brainy/data/users/' . $user);

		if (!$ip) {
			$ip = explode(' ', $users['ip']);
			$ip = $ip[0];
		}

		$ssites = explode(',', $users['vhost_list']);

		if ($ssites[0]) {
			$ssites[] = $domain;
		}
		else {
			$ssites[0] = $domain;
		}

		$users['vhost_list'] = implode(',', $ssites);
		$this->config_save('/etc/brainy/data/users/' . $user, $users, 'add');
		$file_old = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$args_old = $this->config_read($file_old);
		$back_service = $this->detect_back_server();

		if ($back_service['service'] == 'nginx') {
			$bridge_nginx = $bridge;
			$bridge_apache = $args_old['bridge_apache'];
		}
		else if (isset($args_old['bridge_nginx'])) {
			$bridge_nginx = $args_old['bridge_nginx'];
		}
		else {
			$args_old;
			$bridge_apache = $bridge;
		}

		if (strlen($bridge_nginx) < 2) {
			$bridge_nginx = 'fpm';
		}

		if (strlen($bridge_apache) < 2) {
			$bridge_apache = 'cgi';
		}

		$mod_security = new mod_security();
		$webserv_type = $mod_security->status_webserver();
		$modsec_stat = $mod_security->default_modsec_stat_webserv_get($webserv_type);
		$hostacc = new hostacc();
		$workspace = $hostacc->getWorkspace($user);

		if (0 < strlen($workspace)) {
			$workspace = $workspace . '/';
		}

		$apacConf = $this->config_read('/etc/brainy/data/apacserver/data');
		$arr_vhost = array('ip' => $ip, 'domain' => $conf_domain, 'aliases' => $conf_aliases, 'dir' => $users['rootdir'] . '/' . $workspace . $dir, 'bridge' => $bridge, 'php' => $phpw, 'user' => $user, 'bridge_apache' => $bridge_apache, 'bridge_nginx' => $bridge_nginx, 'modsec_stat' => $modsec_stat, 'logaccess' => 1, 'logerror' => 1, 'http_redirect' => 0, 'www_redirect' => '', 'dir_ps' => '', 'pass_root_domain' => 0, 'cacheext' => $apacConf['cache'], 'cacheextExp' => $apacConf['expires'], 'cachestat' => $apacConf['cachestat'], 'gzipstat' => $apacConf['gzipstat']);
		$this->config_save('/etc/brainy/data/vhosts/' . $conf_domain . '.conf', $arr_vhost, 'add');
		$comm = 'mkdir -p ' . $users['rootdir'] . '/' . $workspace . $dir;
		$this->sudo_ssh($comm);
		$comm = 'chown -R ' . $user . ':' . $user . ' ' . $users['rootdir'] . '/' . $workspace . $dir;
		$this->sudo_ssh($comm);
		$conf_prorerties = $this->config_read($GLOBALS['PROPERTIES_CONF']);

		if ($conf_prorerties['create_index_html'] == 1) {
			if (!file_exists($users['rootdir'] . '/' . $workspace . $dir . '/index.html') && !file_exists($users['rootdir'] . '/' . $workspace . $dir . '/index.php') && !file_exists($users['rootdir'] . '/' . $workspace . $dir . '/index.htm')) {
				global $smarty;
				$mass = $this->config_read('/etc/brainy/data/ipmanager/nat');

				if (isset($mass['active']) && ($mass['active'] == 'yes')) {
					$smarty_arg['server_addr'] = $mass['ip'];
				}
				else {
					$smarty_arg['server_addr'] = $arr_vhost['ip'];
				}

				$smarty->assign($smarty_arg);
				$out_tpl = $smarty->fetch('/etc/brainy' . $GLOBALS['template_path'] . 'server_control/default_index.tpl');
				$this->write_file($out_tpl, $users['rootdir'] . '/' . $workspace . $dir . '/index.html', 'r', $user);
			}
		}

		file_put_contents('/etc/brainy/data/server_control/vhosts', $conf_domain . ':' . $user . "\n", FILE_APPEND | LOCK_EX);

		foreach ($aliases_m as $value) {
			file_put_contents('/etc/brainy/data/server_control/vhosts', $value . ':' . $user . "\n", FILE_APPEND | LOCK_EX);
		}

		$wcf = new webserver_config();
		$wcf->scan_for_redirect_hosts($conf_domain, $user);
		$ans = $this->webserver_convert_domain($conf_domain);
		$bind = new bindserver();
		$bind->bindserver_deleteZone($conf_domain, $user);
		$domains_edit[] = $main_dom;
		$vhost_arr = preg_split('/[\\s,;]/', $aliases);

		foreach ($vhost_arr as $vhost_alias_cur) {
			$domains_edit[] = $vhost_alias_cur;
		}

		$bind->bindserver_addzones($user, $domains_edit);

		if (3 < strlen($ip)) {
			$this->del_string_new($ip . '|', $GLOBALS['IPMANAGER_LISTIPS']);
			file_put_contents($GLOBALS['IPMANAGER_LISTIPS'], $ip . '|1' . "\n", FILE_APPEND);
		}

		$hostacc->hostacc_count_sites($user, 1);
		$hostacc->hostacc_count_dns_zones($user, 1);
		$this->webservers_reloadconf();
		if (($outm['code'] == 200) || ($outm['code'] == 201)) {
			return $outm;
		}

		$outm['code'] = 0;
		$outm['message'] = $lang['server_control_s_added'];
		return $outm;
	}

	public function removePanelHost($oldName)
	{
		$this->ssh('rm -f /etc/httpd/vhost.d/' . $oldName . '.conf');
		$this->ssh('rm -f /etc/httpd/vhost.d/ssl.' . $oldName . '.conf');
		$this->ssh('rm -f /etc/nginx/sites-available/' . $oldName . '.conf');
		$this->ssh('rm -f /etc/nginx/sites-available/ssl.' . $oldName . '.conf');
		$this->ssh('rm -f /etc/brainy/data/vhosts/' . $oldName . '.conf');
		$this->ssh('rm -f /etc/brainy/data/vhosts/' . $oldName . '.conf');
		$this->ssh('rm -rf /etc/brainy/src/ssl/' . $oldName . '_*');
	}

	public function add_default_host($use_ips = NULL, $webpan_check = NULL)
	{
		$file = $this->ipmanager_listips();
		$list_ip = '';
		$ipm = new ipmanager();

		if (is_null($use_ips)) {
			$dh = opendir($GLOBALS['DATA_VHOSTS']);
			$use_ips = array();

			while (false !== $filename = readdir($dh)) {
				if ($filename[0] == '.') {
					continue;
				}

				$domains[] = substr($filename, 0, strrpos($filename, '.'));
				$confdom = parse_ini_file($GLOBALS['DATA_VHOSTS'] . '/' . $filename);

				if ($confdom['default_ssl'] == 1) {
					$not_default = 1;
					$use_ips[] = $confdom['ip'];
				}
			}
		}

		$mainip[] = $ipm->getmainip();

		foreach ($mainip as $key => $value) {
			if (!in_array($value, $use_ips)) {
				$list_ip .= $value . ' ';
			}
		}

		$domainPanel = $this->get_webpanel();

		if ($domainPanel) {
			$conf = $this->config_read('/etc/brainy/data/certs_control/service_cert.conf');

			if (!array_key_exists('webpanel', $conf)) {
				$this->config_save('/etc/brainy/data/certs_control/service_cert.conf', array('webpanel' => '/etc/brainy/src/ssl/webpanel.crt'), 'add');
			}
		}

		if (0 < strlen($list_ip)) {
			$arr = array('ip' => trim($list_ip), 'domain' => 'default', 'dir' => '/var/www/html', 'php' => 'nophpw', 'crt' => '/etc/brainy/src/ssl/webserver.crt', 'key' => '/etc/brainy/src/ssl/webserver.key', 'ssl' => '1');
			$this->config_save('/etc/brainy/data/vhosts/!!default.conf', $arr);
			if ($domainPanel && $webpan_check) {
				$arr = array('ip' => trim($list_ip), 'domain' => $domainPanel, 'dir' => '/var/www/html', 'php' => 'nophpw', 'crt' => '/etc/brainy/src/ssl/webpanel.crt', 'key' => '/etc/brainy/src/ssl/webpanel.key', 'ssl' => '1');
				$this->config_save('/etc/brainy/data/vhosts/' . $domainPanel . '.conf', $arr);
				$certs = new certs();
				$certs->generate_cert('webpanel', 'webpanel');
			}
		}
		else {
			if ($domainPanel && $webpan_check) {
				$arr = array('ip' => trim(implode(' ', $mainip)), 'domain' => $domainPanel, 'dir' => '/var/www/html', 'php' => 'nophpw', 'crt' => '/etc/brainy/src/ssl/webpanel.crt', 'key' => '/etc/brainy/src/ssl/webpanel.key', 'ssl' => '1');
				$this->config_save('/etc/brainy/data/vhosts/' . $domainPanel . '.conf', $arr);
				$certs = new certs();
				$certs->generate_cert('webpanel', 'webpanel');
			}
		}
	}

	public function checkFPM_conf($user, $domain_del = '')
	{
		$this->logAction('ENTER checkFPM USER: ' . $user . ' Domain: ' . $domain_del);
		global $smarty;
		global $lang;
		$puny = new idna_convert();
		$domain_del = $puny->encode(trim($domain_del));

		if (!$this->check_user($user)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		if (0 < strlen($domain_del)) {
			if (!$this->check_value('domain', $domain_del)) {
				return array('code' => 204, 'message' => $lang['server_control_error_user']);
			}
		}

		$listphps_conf = parse_ini_file($this->serv_datapath . 'phps');
		$phps_list = explode(',', $listphps_conf['phplist']);
		$phps_list_w = explode(',', $listphps_conf['phplistw']);
		$phpusing = array();
		$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);
		$user_info = $this->config_read($GLOBALS['USERS_PATH'] . '/' . $user);
		$dom_users = $this->webserver_getdomains($user);

		if (is_array($dom_users)) {
			foreach ($dom_users as $dom) {
				$args = parse_ini_file($GLOBALS['DATA_VHOSTS'] . $dom . '.conf');

				if ($user_info['jailstatsetphp'] == 1) {
					if ($conf['back_server'] != 'nginx') {
						$bridge = 'fastcgi';
						$args['bridge'] = $bridge;
						$args['bridge_apache'] = $bridge;
					}
					else {
						$bridge = 'fpm';
						$args['bridge'] = $bridge;
						$args['bridge_nginx'] = $bridge;
					}
				}

				$bridge = $args['bridge'];

				if ($conf['back_server'] != 'nginx') {
					$bridge = $args['bridge_apache'];
				}
				else {
					$bridge = $args['bridge_nginx'];

					if (strlen($bridge) < 2) {
						$bridge = 'fpm';
					}
				}

				if (($conf['back_server'] != 'nginx') && ($conf['front_server'] == 'nginx')) {
					if ($bridge == 'fpm') {
						$bridge_def_na = $args['bridge_apache'];

						if (strlen($bridge_def_na) < 1) {
							$bridge_def_na = $conf['default_bridge'];
						}
					}
					else {
						$bridge_def_na = $bridge;
					}
				}
				else {
					$bridge_def_na = '';
				}

				if (((($bridge == 'fastcgi') || ($bridge_def_na == 'fastcgi')) && ($conf['back_server'] == 'apache2.4')) || ((($bridge == 'fpm') || ($bridge_def_na == 'fpm')) && ($conf['back_server'] == 'nginx'))) {
					if ((($bridge == 'fpm') || ($bridge_def_na == 'fpm')) && ($conf['back_server'] == 'nginx')) {
						$args['listenowner'] = 'nginx';
						$args['listengroup'] = 'nginx';
					}
					else {
						$args['listenowner'] = 'apache';
						$args['listengroup'] = 'apache';
					}

					$smarty->assign($args);

					if ($args['php'] != 'php52w') {
						if ($domain_del != $dom) {
							$phpusing[$args['php']] = $args['php'];
						}
					}
				}
			}
		}

		$this->logAction('PHPUSING ' . json_encode($phpusing));

		if (0 < strlen($domain_del)) {
			$fast_file = '/etc/php52w/php-fpm.conf';
			$this->del_strings_between_str('start_' . $args['user'] . '_start', 'end_' . $args['user'] . '_end', $fast_file);
			$this->monitor_service_command('php52-fpm', 'reload');
		}

		foreach ($phps_list_w as $keyp => $curphp) {
			if (!in_array($curphp, $phpusing)) {
				$path_php = $listphps_conf['php_path'];
				$path_php = str_replace('phpver', $phps_list[$keyp], $path_php);
				$this->logAction('DEL CONF FPM ' . $path_php . ' --- ' . $user);
				$fast_file = $path_php . '/php-fpm.d/' . $user . '.conf';
				$this->ssh('rm -rf ' . $fast_file);

				if ($GLOBALS['v2'] == 'yes') {
					$this->ssh('rm -f ' . $path_php . '/php-fpm.' . $user . '.conf');
					$this->monitor_service_command($phps_list[$keyp] . 'w-fpm@' . $user, 'reload');
				}
				else {
					$this->monitor_service_command($phps_list[$keyp] . '-fpm', 'reload');
				}
			}
		}
	}

	public function webserver_convert_domain($domain, $modsec = 2)
	{
		$modSecGlobal = $modsec;

		if ($modsec == 2) {
			$mod_security = new mod_security();
			$webserv_type = $mod_security->status_webserver();

			if ($webserv_type == 'all') {
				$control = $mod_security->get_config_mod_security('nginx');
			}
			else {
				$control = $mod_security->get_config_mod_security();
			}

			$modSecGlobal = ($control['SecRuleEngine'] == 'On' ? 1 : 0);
		}

		if ($this->get_webpanel()) {
			$domainPanel = $this->get_webpanel();
		}

		$portNginxPanel = '';

		if ($domain == $domainPanel) {
			$portNginxPanel = $this->get_server_port();
		}

		global $smarty;
		global $lang;
		$os_version = $GLOBALS['OS_VERSION'];
		$apac = new apacserver();
		$puny = new idna_convert();
		$domain = $puny->encode(trim($domain));

		if (!$this->check_value('domain_star', $domain)) {
			if ($domain != '!!default') {
				return array('code' => 204, 'message' => $lang['server_control_error_user']);
			}
		}

		$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);
		$domain = trim($domain);
		$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';

		if (!is_file($file)) {
			return 0;
		}

		$args = $this->config_read($file);

		if (!isset($args['logaccess'])) {
			$args['logaccess'] = 1;
		}

		if (!isset($args['logerror'])) {
			$args['logerror'] = 1;
		}

		$args['portnginxpanel'] = $portNginxPanel;
		$args['nat'] = 0;
		$args['ip_nat'] = '127.0.0.1';
		$nat_conf = $this->config_read('/etc/brainy/data/ipmanager/nat');

		if (isset($nat_conf['active'])) {
			if ($nat_conf['active'] == 'yes') {
				$args['ip_nat'] = $nat_conf['ip'];
				$args['nat'] = 1;
			}
		}

		$args['aliases'] = str_replace(',', ' ', $args['aliases']);

		if (!sizeof($args)) {
			return array('code' => 200, 'message' => $lang['server_control_error_user']);
		}

		$user_info = $this->config_read($GLOBALS['USERS_PATH'] . '/' . $args['user']);
		$domDirConf = $args['dir'];
		$username = $args['user'];
		$comm = 'chown -R ' . $username . '.' . $username . ' ' . $user_info['rootdir'] . '/' . $domDirConf;
		$this->ssh($comm);
		$mas_ip_port = explode(' ', $args['ip']);
		$args['ip_mas'] = $mas_ip_port;
		$args['ip_nginx'] = $mas_ip_port[0];
		$bridge = $args['bridge'];

		if ($conf['back_server'] != 'nginx') {
			$bridge = $args['bridge_apache'];
		}
		else {
			$bridge = $args['bridge_nginx'];

			if (strlen($bridge) < 2) {
				$bridge = 'fpm';
			}
		}

		$bridgeForceJail = '';

		if ($user_info['jailstatsetphp'] == 1) {
			if ($conf['back_server'] != 'nginx') {
				$bridge = 'fastcgi';
				$bridgeForceJail = $bridge;
				$args['bridge'] = $bridge;
				$args['bridge_apache'] = $bridge;
				$this->config_save($file, array('bridge' => $bridge, 'bridge_apache' => $bridge), 'add');
			}
			else {
				$bridge = 'fpm';
				$bridgeForceJail = $bridge;
				$args['bridge'] = $bridge;
				$args['bridge_nginx'] = $bridge;
				$this->config_save($file, array('bridge' => $bridge, 'bridge_nginx' => $bridge), 'add');
			}
		}

		if (($conf['back_server'] != 'nginx') && ($conf['front_server'] == 'nginx')) {
			if ($bridge == 'fpm') {
				$bridge_def_na = $args['bridge_apache'];

				if (strlen($bridge_def_na) < 1) {
					$bridge_def_na = $conf['default_bridge'];
				}
			}
			else {
				$bridge_def_na = $bridge;
			}
		}
		else {
			$bridge_def_na = '';
		}

		$ssl = $args['ssl'];
		$phpw = $args['php'];

		if ($phpw == 'nophpw') {
			$bridge = 'nophpw';
			$bridge_def_na = 'nophpw';
			$args['bridge_apache'] = 'nophpw';
			$args['bridge_nginx'] = 'nophpw';
		}

		if (($bridge == 'mod_php') || ($bridge == 'mod_ruid')) {
			$phpw = $conf['default_php'];
		}

		if (($bridge == 'mod_php') && ($conf['default_bridge'] == 'mod_ruid')) {
			$bridge = 'mod_ruid';
		}

		if (($bridge == 'mod_ruid') && ($conf['default_bridge'] == 'mod_php')) {
			$bridge = 'mod_php';
		}

		$usersconf = $this->config_read('/etc/brainy/data/users/' . $args['user']);
		$rootdiruser = $usersconf['rootdir'];

		if (intval($usersconf['jailstatsetphp']) == 1) {
			$args['chrootfast'] = $rootdiruser;
			$args['sethandlerpath'] = str_replace($rootdiruser . '/', '', $args['dir']);
		}
		else {
			$args['chrootfast'] = '';
			$args['sethandlerpath'] = '$document_root';
		}

		$dir = explode('/', $args['dir']);
		$sep = array_pop($dir);
		$args['sep_dir'] = implode('/', $dir) . '/' . $sep;
		$php_list_arr = $this->webserver_php_list();
		$php_vers_now = str_replace('w', '', $phpw);
		$args['php_bin'] = '/usr/bin/' . $php_vers_now . '/bin';
		$args['php_etc'] = '/etc/' . $phpw . '/php.ini';
		$args['port'] = $php_list_arr[$phpw]['fpm-port'];

		if (stripos($phpw, 'php5') !== false) {
			$args['phpx_script'] = 'php5-script';
		}

		if (stripos($phpw, 'php7') !== false) {
			$args['phpx_script'] = 'php7-script';
		}

		$fpm_addr = $php_vers_now . '-fpm';
		$args['php_dir'] = '/etc/' . $phpw;
		$this->ssh('mkdir  -p ' . $args['dir']);
		$this->ssh('chown -R ' . $username . ':' . $username . ' ' . $args['dir']);
		if (($bridge == 'fastcgi') || ($bridge_def_na == 'fastcgi')) {
			$comm = 'mkdir  -p ' . $args['dir'] . '/cgi-bin';
			$username = $args['user'];
			$this->sudo_ssh($comm);
			$fast_tpl = '/etc/brainy/conf/bridges/php.fastcgi';
			$smarty->assign($args);
			$smarty->clearCompiledTemplate($fast_tpl);
			$fast_out = $smarty->fetch($fast_tpl);
			$fast_file = $args['dir'] . '/cgi-bin/php.fastcgi';
			$ssh_open = 'chmod 777 ' . $fast_file;
			$this->sudo_ssh($ssh_open);
			file_put_contents($fast_file, $fast_out);
			$ssh_open = 'chown -R ' . $username . ':' . $username . ' ' . $args['dir'] . '/cgi-bin';
			$this->sudo_ssh($ssh_open);
			$ssh_close = 'chmod 755 ' . $fast_file;
			$this->sudo_ssh($ssh_close);
		}

		$fpm_counter = $this->check_user_fpm('php52w', $args['user']);
		if (((($bridge == 'fastcgi') || ($bridge_def_na == 'fastcgi')) && ($conf['back_server'] == 'apache2.4')) || ((($bridge == 'fpm') || ($bridge_def_na == 'fpm')) && ($conf['back_server'] == 'nginx'))) {
			if ((($bridge == 'fpm') || ($bridge_def_na == 'fpm')) && ($conf['back_server'] == 'nginx')) {
				$args['listenowner'] = 'nginx';
				$args['listengroup'] = 'nginx';
			}
			else {
				$args['listenowner'] = 'apache';
				$args['listengroup'] = 'apache';
			}

			$phpxx = str_replace('w', '', $phpw);
			$args['phpxx'] = $phpxx;
			$smarty->assign($args);

			if ($phpw != 'php52w') {
				$fast_tpl = '/etc/brainy/conf/bridges/phpfpm_pool_user.conf';
				$smarty->clearCompiledTemplate($fast_tpl);
				$fast_out = $smarty->fetch($fast_tpl);
				$fast_file = $args['php_dir'] . '/php-fpm.d/' . $args['user'] . '.conf';
				$slice_tpl = '/etc/brainy/conf/bridges/php-fpm._user.config';
				$smarty->clearCompiledTemplate($slice_tpl);
				$slice_out = $smarty->fetch($slice_tpl);
				$slice_file = $args['php_dir'] . '/php-fpm.' . $args['user'] . '.conf';

				if (0 < strlen($args['user'])) {
					if (is_dir($args['php_dir'] . '/php-fpm.d/')) {
						file_put_contents($fast_file, $fast_out);

						if ($GLOBALS['v2'] == 'yes') {
							file_put_contents($slice_file, $slice_out);
							$phpxx_tpl = '/etc/brainy/src/third_party/systemctl/phpXX-fpm@.service';
							$smarty->clearCompiledTemplate($phpxx_tpl);
							$phpxx_out = $smarty->fetch($phpxx_tpl);
							$phpxx_file = '/usr/lib/systemd/system/' . $args['php'] . '-fpm@' . $args['user'] . '.service';
							file_put_contents($phpxx_file, $phpxx_out);
							$conf_user = $this->config_read($GLOBALS['USERS_PATH'] . $args['user']);
							$ctl_task = $conf_user['ctl_max_user_task'];
							$ctl_memory = $conf_user['ctl_max_user_memory'];
							$ctl_cpu = $conf_user['ctl_max_user_cpu'];

							if (0 < intval($ctl_task)) {
								$update = 'TasksMax=' . intval($ctl_task);
								$this->ssh('sed -i "/#TasksMax/c' . $update . '" ' . $phpxx_file);
							}

							if (0 < intval($ctl_cpu)) {
								$update = 'CPUQuota=' . intval($ctl_cpu) . '%';
								$this->ssh('sed -i "/#CPUQuota/c' . $update . '" ' . $phpxx_file);
							}

							if (0 < intval($ctl_memory)) {
								$update = 'MemoryLimit=' . intval($ctl_memory) . 'M';
								$this->ssh('sed -i "/#MemoryLimit/c' . $update . '" ' . $phpxx_file);
							}

							$this->ssh('systemctl daemon-reload');
						}
					}
				}

				if ($GLOBALS['v2'] == 'yes') {
					$this->ssh('systemctl stop ' . $args['phpxx'] . '-fpm');
					$this->ssh('systemctl disable ' . $args['phpxx'] . '-fpm');
					$fpm_primary = '/usr/lib/systemd/system/' . $args['php'] . '-fpm.service';
					$this->ssh('rm -f ' . $fpm_primary);
					$this->ssh('systemctl daemon-reload');
					$this->ssh('systemctl restart ' . $args['php'] . '-fpm@' . $args['user'] . '.service');
					$this->ssh('systemctl enable ' . $args['php'] . '-fpm@' . $args['user'] . '.service');
				}
				else {
					$this->monitor_service_command(str_replace('w', '', $phpw) . '-fpm', 'reload');
				}

				$fast_file = '/etc/php52w/php-fpm.conf';

				if ($fpm_counter == 0) {
					$this->del_strings_between_str('start_' . $args['user'] . '_start', 'end_' . $args['user'] . '_end', $fast_file);
				}

				$this->monitor_service_command('php52-fpm', 'reload');
			}
			else {
				$fast_tpl = '/etc/brainy/conf/bridges/phpfpm52.conf';
				$smarty->clearCompiledTemplate($fast_tpl);
				$fast_out = $smarty->fetch($fast_tpl);
				$fast_file = $args['php_dir'] . '/php-fpm.conf';

				if (is_file($fast_file)) {
					$this->del_strings_between_str('start_' . $args['user'] . '_start', 'end_' . $args['user'] . '_end', $fast_file);
					$this->insert_before_string('</workers>', $fast_out, $fast_file);
				}

				$this->monitor_service_command(str_replace('w', '', $phpw) . '-fpm', 'reload');
			}
		}
		else {
			$fast_file = '/etc/php52w/php-fpm.conf';

			if ($fpm_counter == 0) {
				$this->del_strings_between_str('start_' . $args['user'] . '_start', 'end_' . $args['user'] . '_end', $fast_file);
			}

			$this->monitor_service_command('php52-fpm', 'reload');
		}

		if (($bridge == 'cgi') || ($bridge_def_na == 'cgi')) {
			$comm = 'mkdir  -p ' . $args['dir'] . '/cgi-bin';
			$username = $args['user'];
			$this->sudo_ssh($comm);
			$fast_tpl = '/etc/brainy/conf/bridges/php.cgi';
			$smarty->assign($args);
			$smarty->clearCompiledTemplate($fast_tpl);
			$fast_out = $smarty->fetch($fast_tpl);
			$fast_file = $args['dir'] . '/cgi-bin/php.cgi';
			file_put_contents($fast_file, $fast_out);
			$ssh_open = 'chown -R ' . $username . ':' . $username . ' ' . $args['dir'] . '/cgi-bin';
			$this->sudo_ssh($ssh_open);
			$ssh_close = 'chmod 755 ' . $fast_file;
			$this->sudo_ssh($ssh_close);
		}

		$src_acsess = '/etc/brainy/data/webserver_config/user_includes/' . $args['user'] . '/';
		$tplWebCacheDataValue = $this->config_read($this->tplWebCacheData);
		$dirconf = '/etc/httpd/vhost.d/';

		if ($conf['back_server'] == 'nginx') {
			$dirconf = '/etc/nginx/sites-available/';
		}

		if (($conf['back_server'] != 'nginx') && ($conf['front_server'] == 'nginx')) {
			$web_server = 'apache_nginx';
		}

		if ($web_server == 'apache_nginx') {
			if ($ssl == 0) {
				$this->ssh('rm -f  /etc/nginx/sites-available/ssl' . $domain . '.conf');
				$this->ssh('rm -f  /etc/httpd/vhost.d/ssl.' . $domain . '.conf');
			}
		}
		else if ($ssl == 0) {
			$this->ssh('rm -f  ' . $dirconf . 'ssl.' . $domain . '.conf');
		}

		$i = 0;

		while ($i <= $ssl) {
			if ($web_server) {
				$mas_arg[$i]['main_port'] = 8080;
			}
			else if ($i == 1) {
				$mas_arg[$i]['main_port'] = 443;
			}
			else {
				$mas_arg[$i]['main_port'] = 80;
			}

			$mas_arg[$i]['user'] = $args['user'];
			$mas_arg[$i]['portnginxpanel'] = $portNginxPanel;
			$mas_arg[$i]['dir'] = $args['dir'];
			$mas_arg[$i]['crt'] = $args['crt'];
			$mas_arg[$i]['key'] = $args['key'];
			$mas_arg[$i]['username'] = $args['user'];
			$mas_arg[$i]['domain'] = $args['domain'];
			$mas_arg[$i]['aliases'] = $args['aliases'];
			$mas_arg[$i]['web_server'] = $web_server;
			$mas_arg[$i]['patf_nginx_access'] = $src_acsess . $domain . '.nginx';
			$mas_arg[$i]['patf_nginx_access_loct'] = $src_acsess . $domain . '_location.nginx';
			$mas_arg[$i]['patf_apache_access'] = $src_acsess . $domain . '.apache';
			$mas_arg[$i]['ip_nginx'] = $args['ip_nginx'];
			$q = 0;

			while ($q <= 6) {
				$mas_arg[$i]['letencrypt' . $q] = $args['letencrypt' . $q];
				++$q;
			}

			$mas_arg[$i]['suspended'] = $args['suspended_sites'];
			$mas_arg[$i]['back_server'] = $conf['back_server'];
			$mas_arg[$i]['front_server'] = $conf['front_server'];
			$mas_arg[$i]['port'] = $args['port'];
			$mas_arg[$i]['php'] = $args['php'];
			$mas_arg[$i]['ssl'] = $i;
			$mas_arg[$i]['sep_dir'] = $args['sep_dir'];
			$mas_arg[$i]['chein'] = $args['chein'];
			$mas_arg[$i]['ssl_options'] = $args['ssl_options'];

			if (substr($domain, 0, 9) == '!!default') {
				if ($i == 1) {
					$mas_arg[$i]['file'] = $dirconf . '!!ssl.' . substr($domain, 2) . '.conf';
				}
				else {
					$mas_arg[$i]['file'] = $dirconf . $domain . '.conf';
				}
			}
			else if ($i == 1) {
				if ($args['default_ssl'] == 1) {
					$mas_arg[$i]['file'] = $dirconf . '!!ssl.' . $domain . '.conf';
					$this->ssh('mv ' . $dirconf . '!!ssl.default.conf ' . $dirconf . 'ssl.default.conf');
				}
				else {
					$mas_arg[$i]['file'] = $dirconf . 'ssl.' . $domain . '.conf';
				}
			}
			else {
				$mas_arg[$i]['file'] = $dirconf . $domain . '.conf';

				if ($args['default_ssl'] == 1) {
					$mas_arg[$i]['file'] = $dirconf . '!!!' . $domain . '.conf';
				}
			}

			$mas_arg[$i]['bridge'] = $args['bridge'];
			$mas_arg[$i]['bridge_apache'] = $args['bridge_apache'];
			$mas_arg[$i]['bridge_nginx'] = $args['bridge_nginx'];

			if (1 < strlen($bridgeForceJail)) {
				$mas_arg[$i]['bridge_apache'] = $bridgeForceJail;
				$mas_arg[$i]['bridge_nginx'] = $bridgeForceJail;
			}

			if ($conf['back_server'] != 'nginx') {
				$mas_arg[$i]['dir_logs'] = $GLOBALS['HTTPD_VHOSTLOGS'];
			}
			else {
				$mas_arg[$i]['dir_logs'] = $GLOBALS['NGINX_VHOSTLOGS'];
			}

			if ($conf['back_server'] != 'nginx') {
				$mas_arg[$i]['dirconf'] = '/etc/httpd/vhost.d/';
			}
			else {
				$mas_arg[$i]['dirconf'] = '/etc/nginx/sites-available/';
			}

			$mas_arg[$i]['access_log'] = $mas_arg[$i]['dir_logs'] . $domain . '_access';
			$mas_arg[$i]['error_log'] = $mas_arg[$i]['dir_logs'] . $domain . '_error';
			$mas_arg[$i]['ip_mas'] = $args['ip_mas'];
			$mas_arg[$i]['ip_nat'] = $args['ip_nat'];
			$mas_arg[$i]['nat'] = $args['nat'];
			$mas_arg[$i]['suspended_sites'] = $user_info['suspended_sites'];
			$mas_arg[$i]['php_bin'] = $args['php_bin'];
			$mas_arg[$i]['php_etc'] = $args['php_etc'];
			$mas_arg[$i]['phpx_script'] = $args['phpx_script'];

			if (!isset($args['modsec_stat'])) {
				$mas_arg[$i]['modsec_stat'] = -1;
			}
			else {
				$mas_arg[$i]['modsec_stat'] = $args['modsec_stat'];
			}

			$mas_arg[$i]['modsecglobal'] = $modSecGlobal;
			$mas_arg[$i]['sethandlerpath'] = $args['sethandlerpath'];
			$mas_arg[$i]['homediruser'] = $user_info['rootdir'];
			$mas_arg[$i]['jailstatsetphp'] = $user_info['jailstatsetphp'];
			$mas_arg[$i]['logaccess'] = $args['logaccess'];
			$mas_arg[$i]['logerror'] = $args['logerror'];
			$mas_arg[$i]['http_redirect'] = $args['http_redirect'];
			$mas_arg[$i]['www_redirect'] = $apac->apacserver_load_list_www_redirect($domain);
			$mas_arg[$i]['dir_ps'] = $apac->apacserver_get_ps($domain);
			$mas_arg[$i]['pass_root_domain'] = $args['pass_root_domain'];

			if (isset($args['cacheext'])) {
				$mas_arg[$i]['cacheext'] = $args['cacheext'];
			}
			else {
				$mas_arg[$i]['cacheext'] = $tplWebCacheDataValue['cache'];
			}

			if (isset($args['cacheextExp']) && (0 < strlen($args['cacheextExp']))) {
				$mas_arg[$i]['cacheextExp'] = $args['cacheextExp'];
				$mas_arg[$i]['cachestat'] = $args['cachestat'];
				$mas_arg[$i]['gzipstat'] = $args['gzipstat'];
			}
			else {
				$mas_arg[$i]['cacheextExp'] = $tplWebCacheDataValue['expires'];
				$mas_arg[$i]['cachestat'] = $tplWebCacheDataValue['cachestat'];
				$mas_arg[$i]['gzipstat'] = $tplWebCacheDataValue['gzipstat'];
			}

			++$i;
		}

		$username = $args['user'];
		$user_config = $this->config_read($GLOBALS['USERS_PATH'] . $username);

		if ($web_server == 'apache_nginx') {
			$i = $ssl + 1;

			while ($i <= $ssl + $ssl + 1) {
				if (((($i - $ssl) + $ssl) - 1) == 1) {
					$mas_arg[$i]['main_port'] = 443;
					$mas_arg[$i]['ssl'] = 1;
				}
				else {
					$mas_arg[$i]['main_port'] = 80;
					$mas_arg[$i]['ssl'] = 0;
				}

				$mas_arg[$i]['domain'] = $args['domain'];
				$mas_arg[$i]['aliases'] = $args['aliases'];
				$mas_arg[$i]['back_server'] = $conf['back_server'];
				$mas_arg[$i]['front_server'] = $conf['front_server'];
				$mas_arg[$i]['username'] = $args['user'];
				$mas_arg[$i]['port'] = $args['port'];
				$mas_arg[$i]['php'] = $args['php'];
				$mas_arg[$i]['portnginxpanel'] = $portNginxPanel;

				if (substr($domain, 0, 9) == '!!default') {
					if (((($i - $ssl) + $ssl) - 1) == 1) {
						$mas_arg[$i]['file'] = '/etc/nginx/sites-available/!!ssl.' . substr($domain, 2) . '.conf';
					}
					else {
						$mas_arg[$i]['file'] = '/etc/nginx/sites-available/' . $domain . '.conf';
					}
				}
				else if (((($i - $ssl) + $ssl) - 1) == 1) {
					if ($args['default_ssl'] == 1) {
						$mas_arg[$i]['file'] = '/etc/nginx/sites-available/' . '!!ssl.' . $domain . '.conf';
						$this->ssh('mv ' . '/etc/nginx/sites-available/' . '!!ssl.default.conf ' . '/etc/nginx/sites-available/' . 'ssl.default.conf');
					}
					else {
						$mas_arg[$i]['file'] = '/etc/nginx/sites-available/ssl.' . $domain . '.conf';
					}
				}
				else {
					$mas_arg[$i]['file'] = '/etc/nginx/sites-available/' . $domain . '.conf';

					if ($args['default_ssl'] == 1) {
						$mas_arg[$i]['file'] = '/etc/nginx/sites-available/' . '!!!' . $domain . '.conf';
					}
				}

				$mas_arg[$i]['patf_nginx_access'] = $src_acsess . $domain . '.nginx';
				$mas_arg[$i]['patf_nginx_access_loct'] = $src_acsess . $domain . '_location.nginx';
				$mas_arg[$i]['patf_apache_access'] = $src_acsess . $domain . '.apache';
				$mas_arg[$i]['suspended_sites'] = $args['suspended_sites'];
				$mas_arg[$i]['ip_nginx'] = $args['ip_nginx'];
				$mas_arg[$i]['web_server'] = $web_server;
				$mas_arg[$i]['dir'] = $args['dir'];
				$mas_arg[$i]['crt'] = $args['crt'];
				$mas_arg[$i]['key'] = $args['key'];
				$mas_arg[$i]['ssl_options'] = $args['ssl_options'];
				$mas_arg[$i]['user'] = $args['user'];
				$mas_arg[$i]['chein'] = $args['chein'];
				$mas_arg[$i]['sep_dir'] = $args['sep_dir'];
				$mas_arg[$i]['bridge'] = $args['bridge'];
				$mas_arg[$i]['username'] = $args['user'];
				$mas_arg[$i]['bridge_apache'] = $args['bridge_apache'];
				$mas_arg[$i]['bridge_nginx'] = $args['bridge_nginx'];

				if (1 < strlen($bridgeForceJail)) {
					$mas_arg[$i]['bridge_apache'] = $bridgeForceJail;
					$mas_arg[$i]['bridge_nginx'] = $bridgeForceJail;
				}

				$mas_arg[$i]['dir_logs'] = $GLOBALS['NGINX_VHOSTLOGS'];
				$mas_arg[$i]['dirconf'] = '/etc/nginx/sites-available/';
				$mas_arg[$i]['access_log'] = $mas_arg[$i]['dir_logs'] . $domain . '_access';
				$mas_arg[$i]['error_log'] = $mas_arg[$i]['dir_logs'] . $domain . '_error';
				$mas_arg[$i]['ip_mas'] = $args['ip_mas'];
				$mas_arg[$i]['ip_nat'] = $args['ip_nat'];
				$mas_arg[$i]['nat'] = $args['nat'];
				$mas_arg[$i]['suspended_sites'] = $user_config['suspended_sites'];
				$mas_arg[$i]['php_bin'] = $args['php_bin'];
				$mas_arg[$i]['php_etc'] = $args['php_etc'];
				$mas_arg[$i]['phpx_script'] = $args['phpx_script'];

				if (!isset($args['modsec_stat'])) {
					$mas_arg[$i]['modsec_stat'] = -1;
				}
				else {
					$mas_arg[$i]['modsec_stat'] = $args['modsec_stat'];
				}

				$mas_arg[$i]['modsecglobal'] = $modSecGlobal;
				$mas_arg[$i]['sethandlerpath'] = $args['sethandlerpath'];
				$mas_arg[$i]['homediruser'] = $user_info['rootdir'];
				$mas_arg[$i]['jailstatsetphp'] = $user_info['jailstatsetphp'];
				$mas_arg[$i]['logaccess'] = $args['logaccess'];
				$mas_arg[$i]['logerror'] = $args['logerror'];
				$mas_arg[$i]['http_redirect'] = $args['http_redirect'];
				$mas_arg[$i]['www_redirect'] = $apac->apacserver_load_list_www_redirect($domain);
				$mas_arg[$i]['dir_ps'] = $apac->apacserver_get_ps($domain);
				$mas_arg[$i]['pass_root_domain'] = $args['pass_root_domain'];

				if (isset($args['cacheext'])) {
					$mas_arg[$i]['cacheext'] = $args['cacheext'];
				}
				else {
					$mas_arg[$i]['cacheext'] = $tplWebCacheDataValue['cache'];
				}

				if (isset($args['cacheextExp']) && (0 < strlen($args['cacheextExp']))) {
					$mas_arg[$i]['cacheextExp'] = $args['cacheextExp'];
					$mas_arg[$i]['cachestat'] = $args['cachestat'];
					$mas_arg[$i]['gzipstat'] = $args['gzipstat'];
				}
				else {
					$mas_arg[$i]['cacheextExp'] = $tplWebCacheDataValue['expires'];
					$mas_arg[$i]['cachestat'] = $tplWebCacheDataValue['cachestat'];
					$mas_arg[$i]['gzipstat'] = $tplWebCacheDataValue['gzipstat'];
				}

				++$i;
			}
		}

		$tpl = $this->tplVhost;

		if (is_file($this->tplVhostLocal)) {
			$tpl = $this->tplVhostLocal;
		}

		if ($conf['back_server'] != 'nginx') {
			if ($web_server) {
				$main_port = 8080;
			}
			else if ($ssl == 1) {
				$main_port = 443;
			}
			else {
				$main_port = 80;
			}

			$str = '';
		}

		if ($domain != 'default') {
			if (!is_dir($src_acsess)) {
				$this->ssh('mkdir -p ' . $src_acsess);
			}

			if (!is_file($src_acsess . $domain . '.nginx')) {
				$this->ssh('touch ' . $src_acsess . $domain . '.nginx');
			}

			if (!is_file($src_acsess . $domain . '.apache')) {
				$this->ssh('touch ' . $src_acsess . $domain . '.apache');
			}
		}

		foreach ($mas_arg as $key) {
			foreach ($key as $key1 => $value) {
				$smarty->clearAllAssign();
				$smarty->assign($key);
				$smarty->clearCompiledTemplate($tpl);
				$out = $smarty->fetch($tpl);

				if (!is_dir($key['dir_logs'])) {
					$this->ssh('mkdir -p ' . $key['dir_logs']);
				}

				if (!is_file($key['file'])) {
					$this->ssh('mkdir -p ' . $key['dirconf']);
					$this->ssh('touch ' . $key['file']);
				}

				file_put_contents($key['file'], $out);
				$fh = fopen($key['file'], 'r');
				$a = fread($fh, filesize($key['file']));
				fclose($fh);
			}
		}

		$out_record = $this->ssh('cat -n /var/named/named.' . $domain . ' | grep \'' . $domain . '\' | awk \'{print $1" "$2" "$3}\' | grep -E \'A{1}$\' | awk \'{print $1" "$2}\' | sed \'s/.$//\'');

		foreach ($out_record as $val_record) {
			list($num_str, $val_rec) = explode(' ', $val_record);
			$all_record_A[$num_str] = $val_rec;
		}

		$all_record_A = array_reverse($all_record_A, true);
		$bind = new bindserver();
		$vhosts = $this->get_virt_hosts($username);

		foreach ($vhosts as $vhost) {
			if ($vhost['domain'] === $domain) {
				$vhost_arr = preg_split('/[\\s,;]/', $vhost['aliases']);

				foreach ($vhost_arr as $vhost_alias_cur) {
					if (!in_array($vhost_alias_cur, $all_record_A) && $vhost_alias_cur) {
						$bind->bindserver_addAddrToZone($domain, $vhost_alias_cur . '.', 'A', $args['ip']);
					}
				}

				foreach ($all_record_A as $key_record_A => $val_record_A) {
					if (!in_array($val_record_A, $vhost_arr) && $val_record_A) {
						if (($domain !== $val_record_A) && !preg_match('/\\*/iu', $val_record_A)) {
							$this->ssh($bind::PATH_TO_SCRIPT . 'named.sh --edit --zone ' . $domain . ' --line ' . $key_record_A . ' --delete 2>&1');
						}
					}
				}
			}
		}

		if (!empty($web_server) && ($ssl == 1)) {
			if (substr($domain, 0, 9) == '!!default') {
				$this->ssh('rm -f  /etc/httpd/vhost.d/!!ssl.' . substr($domain, 2) . '.conf');
			}
			else {
				$this->ssh('rm -f  /etc/httpd/vhost.d/ssl.' . $domain . '.conf');
			}
		}

		$php_ini = new php_ini();
		$php_ini->user_ini_conwert($domain);
		$this->checkFPM_conf($args['user']);
		$this->webservers_reloadconf();
		$this->monitor_service_command($fpm_addr, 'restart');
		return $mas_arg;
	}

	public function webserver_domain_modsecstat($domain = NULL, $user = NULL, $stat = 0)
	{
		global $lang;
		$puny = new idna_convert();
		$domain = $puny->encode(trim($domain));

		if (!$this->check_user($user)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		if (!$domain) {
			$outm['code'] = 100;
			$outm['message'] = $lang['server_control_dom_d_f_s_c'];
			return $outm;
		}

		if (0 < strlen($domain)) {
			if (!$this->check_value('domain', $domain)) {
				return array('code' => 205, 'message' => $lang['server_control_error_user']);
			}
		}

		$config_user = $this->config_read($GLOBALS['USERS_PATH'] . $user);

		if (!sizeof($config_user)) {
			return array('code' => 210, 'message' => $lang['server_control_error_user']);
		}

		$arr_vhost = array('modsec_stat' => intval($stat));
		$this->config_save('/etc/brainy/data/vhosts/' . $domain . '.conf', $arr_vhost, 'add');
		$this->webserver_convert_domain($domain);
		$outm['code'] = 0;
		$outm['message'] = $lang['server_control_mod_modsec_stat_change'];
		return $outm;
	}

	public function webserver_edit_domain($domain = NULL, $aliases = NULL, $dir = NULL, $user = NULL, $ip = NULL, $dbridges = NULL, $versions = NULL)
	{
		global $lang;
		$puny = new idna_convert();
		$domain = $puny->encode(trim($domain));

		if (!$this->check_user($user)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		if (isset($ip)) {
			if (!inet_pton($ip)) {
				return array('code' => 204, 'message' => $lang['server_control_error_user']);
			}
		}

		if (0 < strlen($domain)) {
			if (!$this->check_value('domain', $domain)) {
				return array('code' => 205, 'message' => $lang['server_control_error_user']);
			}
		}

		if (0 < sizeof($dbridges)) {
			if (!$this->check_value('strdot', $dbridges)) {
				return array('code' => 207, 'message' => $lang['server_control_error_user']);
			}
		}

		if (0 < strlen($versions)) {
			if (!$this->check_value('strdot', $versions)) {
				return array('code' => 208, 'message' => $lang['server_control_error_user']);
			}
		}

		if (0 < strlen($dir)) {
			if (!$this->check_value('dir', $dir)) {
				return array('code' => 209, 'message' => $lang['server_control_error_user']);
			}
		}

		$config_user = $this->config_read($GLOBALS['USERS_PATH'] . $user);

		if (!sizeof($config_user)) {
			return array('code' => 210, 'message' => $lang['server_control_error_user']);
		}

		$config_server = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);

		if ($config_user['suspended_sites'] == 1) {
			$outm['code'] = 200;
			$outm['message'] = $lang['hostacc_suspended_sites'];
			return $outm;
		}

		if (!$dbridges) {
			$dbridges = $config_server['default_bridge'];
			$outm['code'] = 201;
			$outm['message'] = $lang['server_control_bridg_default'] . $config_server['default_bridge'] . $lang['server_control_all_version'] . $config_server['open_bridges'];
		}

		if (!in_array($dbridges, explode(',', $config_server['open_bridges']))) {
			$outm['code'] = 107;
			$outm['message'] = $lang['server_control_not_bridg'] . $config_server['open_bridges'];
			return $outm;
		}

		if (!$versions) {
			$versions = $config_server['default_php'];
			$outm['code'] = 200;
			$outm['message'] = $lang['server_control_phpvers_default'] . $config_server['default_php'] . $lang['server_control_all_version'] . $config_server['open_phps'];
		}

		if (!in_array($versions, explode(',', $config_server['open_phps']))) {
			$outm['code'] = 108;
			$outm['message'] = $lang['server_control_not_php'] . $config_server['open_phps'];
			return $outm;
		}

		$ips = explode(' ', $config_user['ip']);

		if (!in_array($ip, $ips)) {
			$outm['code'] = 130;
			$outm['message'] = $lang['server_control_is_not_ip'];
			return $outm;
		}

		$already_domains = ' awk -F: \'{print $1}\' /etc/brainy/data/server_control/vhosts';
		$already_domains = $this->ssh($already_domains);
		$domain = strtolower($domain);
		$aliases = strtolower($aliases);
		$foodir = strlen($dir);

		if ($dir[$foodir - 1] == '/') {
			$dir[$foodir - 1] = '';
		}

		if (!$domain) {
			$outm['code'] = 100;
			$outm['message'] = $lang['server_control_dom_d_f_s_c'];
			return $outm;
		}

		if (!$dir) {
			$outm['code'] = 101;
			$outm['message'] = $lang['server_control_dom_d_f_s'];
			return $outm;
		}

		if (!$this->check_value('domain', $domain)) {
			$outm['code'] = 104;
			$outm['message'] = $lang['server_control_dom_d_f_i'];
			return $outm;
		}

		if (!$this->check_value('dir', $dir)) {
			return array('code' => 206, 'message' => $lang['server_control_error_user']);
		}

		$aliases_m = preg_split('/[\\s,;]/', $aliases);
		$aliases_m = array_filter($aliases_m);
		$aliases_m = array_values($aliases_m);
		$al_counter = 0;
		$users = $this->config_read('/etc/brainy/data/users/' . $user);
		$w_aliases = $users['vhost_list'];
		$w_aliases = explode(',', $w_aliases);
		$vhosts = $this->get_virt_hosts($user);

		foreach ($vhosts as $vhost) {
			$already_domains[] = $vhost['domain'];

			if ($vhost['domain'] === $domain) {
				$new_aliases = $vhost['aliases'] . ',' . $vhost['domain'];
				$new_maindom = $vhost['domain'];
			}
		}

		$new_aliases = preg_split('/[\\s,;]/', $new_aliases);

		foreach ($aliases_m as $key_al => $value) {
			$value = $puny->encode(trim($value));
			$aliases_m[$key_al] = $value;

			if ((in_array($value, $already_domains) == true) && (in_array($value, $new_aliases) == false)) {
				$outm['code'] = 102;
				$outm['message'] = $lang['server_control_are'];

				return $outm;
			}

			if ($new_maindom == $value) {
				$outm['code'] = 105;
				$outm['message'] = $lang['server_control_n_f_e'];

				return $outm;
			}

			$outm['code'] = 104;
			$outm['message'] = $lang['server_control_n_f_a'];

			return $outm;
		}

		$conf_aliases = implode(' ', $aliases_m);
		$aliases = implode(',', $aliases_m);
		$file_old = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$args_old = $this->config_read($file_old);
		$back_service = $this->detect_back_server();

		if ($back_service['service'] == 'nginx') {
			$bridge_nginx = $dbridges;
			$bridge_apache = $args_old['bridge_apache'];
		}
		else {
			$bridge_nginx = $args_old['bridge_nginx'];
			$bridge_apache = $dbridges;
		}

		$hostacc = new hostacc();
		$workspace = $hostacc->getWorkspace($user);

		if (0 < strlen($workspace)) {
			$workspace = $workspace . '/';
		}

		$arr_vhost = array('ip' => $ip, 'domain' => $domain, 'aliases' => $aliases, 'dir' => $users['rootdir'] . '/' . $workspace . $dir, 'bridge' => $dbridges, 'php' => $versions, 'user' => $user, 'bridge_apache' => $bridge_apache, 'bridge_nginx' => $bridge_nginx);
		$users = $this->config_read('/etc/brainy/data/users/' . $user);
		$ssites = explode(',', $users['vhost_list']);

		foreach ($ssites as $key => $value) {
			$doms_mass = explode(':', $value);

			if ($doms_mass[0] == $domain) {
				$ssites[$key] = $doms_mass[0] . ':' . implode('+', $aliases_m);
			}
		}

		$users['vhost_list'] = implode(',', $ssites);
		$this->config_save('/etc/brainy/data/users/' . $user, $users, 'add');
		$this->config_save('/etc/brainy/data/vhosts/' . $domain . '.conf', $arr_vhost, 'add');
		$this->webserver_convert_domain($domain);
		$hostacc = new hostacc();
		$workspace = $hostacc->getWorkspace($user);

		if (0 < strlen($workspace)) {
			$workspace = $workspace . '/';
		}

		$conf_prorerties = $this->config_read($GLOBALS['PROPERTIES_CONF']);

		if ($conf_prorerties['create_index_html'] == 1) {
			if (!file_exists($users['rootdir'] . '/' . $workspace . $dir . '/index.html') && !file_exists($users['rootdir'] . '/' . $workspace . $dir . '/index.php') && !file_exists($users['rootdir'] . '/' . $workspace . $dir . '/index.htm')) {
				global $smarty;
				$smarty_arg['server_addr'] = $arr_vhost['ip'];
				$smarty->assign($smarty_arg);
				$out_tpl = $smarty->fetch('/etc/brainy' . $GLOBALS['template_path'] . 'server_control/default_index.tpl');
				$this->write_file($out_tpl, $users['rootdir'] . '/' . $workspace . $dir . '/index.html', 'r', $user);
			}
		}

		foreach ($new_aliases as $value) {
			$this->del_string($value . ':' . $user, '/etc/brainy/data/server_control/vhosts');
		}

		foreach ($aliases_m as $value) {
			file_put_contents('/etc/brainy/data/server_control/vhosts', $value . ':' . $user . "\n", FILE_APPEND | LOCK_EX);
		}

		if (($outm['code'] == 200) || ($outm['code'] == 201)) {
			return $outm;
		}

		$outm['code'] = 0;
		$outm['message'] = $lang['server_control_d_s_e'];
		return $outm;
	}

	public function webserver_remove_domain($domain, $user, $delfolder = 0)
	{
		global $lang;
		$os_version = $GLOBALS['OS_VERSION'];
		$puny = new idna_convert();
		$domain = $puny->encode(trim($domain));

		if (!$this->check_user($user)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		if (!$this->check_value('domain', $domain)) {
			return array('code' => 204, 'message' => $lang['server_control_error_user']);
		}

		$user_info = $this->config_read($GLOBALS['USERS_PATH'] . '/' . $user);
		$mails = new mailclient();

		if ($mails->mailclient_checkexistemail_bydomain($domain) == true) {
			$outm['code'] = 199;
			$outm['message'] = $lang['server_control_email_exist'];
			return $outm;
		}

		$cloudflare = new cloudflare();
		$data_cloudflare = $cloudflare->get_data_cloudflare($domain);

		if ($data_cloudflare['id_domain']) {
			$data_cloudflare['oper'] = 'remove_domain';
			$data_cloudflare = json_encode($data_cloudflare);
			$cloudflare->edit_domain($data_cloudflare);
		}

		if (is_file('/etc/brainy/data/vhosts/' . $domain . '.conf')) {
			$vhostconf = parse_ini_file('/etc/brainy/data/vhosts/' . $domain . '.conf');
		}

		if (!$domain) {
			$arr['code'] = 3;
			$arr['message'] = $lang['server_control_not_paf_domain'];
			return $arr;
		}

		if (!$vhostconf) {
			$arr['code'] = 2;
			$arr['message'] = $lang['server_control_not_domain'];
			return $arr;
		}

		if ($vhostconf['user'] != $user) {
			$arr['code'] = 2;
			$arr['message'] = $lang['server_control_deldomadeny'];
			return $arr;
		}

		if ($delfolder == 1) {
			$this->ssh('rm -rf ' . $vhostconf['dir']);
			$this->ssh('rm -rf ' . $user_info['rootdir'] . '/' . $vhostconf['dir']);
		}

		$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);
		$file = $GLOBALS['USERS_PATH'] . $user;
		$users = $this->config_read($file);

		if (!sizeof($users)) {
			return array('code' => 205, 'message' => $lang['server_control_error_user']);
		}

		$sites = explode(',', $users['vhost_list']);
		$counter = count($sites);
		$i = 0;

		while ($i < $counter) {
			$site = explode(':', $sites[$i]);
			$cur_dom = $site[0];

			if ($cur_dom == $domain) {
				$this->del_string($cur_dom . ':' . $user, '/etc/brainy/data/server_control/vhosts');
				$foo = explode('+', $site[1]);

				foreach ($foo as $value) {
					$this->del_string($value . ':' . $user, '/etc/brainy/data/server_control/vhosts');
				}

				unset($sites[$i]);
			}

			++$i;
		}

		if (0 < count($sites)) {
			$users['vhost_list'] = implode(',', $sites);
		}
		else {
			$users['vhost_list'] = '';
		}

		$mailclient = new mailclient();
		$mailclient->mailclient_removeDomainDb($domain);
		$list_domains = file('/etc/brainy/data/server_control/vhosts');
		$this->config_save($file, $users, 'add');
		$comm = 'rm -f /etc/httpd/vhost.d/' . $domain . '.conf';
		$this->sudo_ssh($comm);
		$comm = 'rm -f /etc/nginx/sites-available/' . $domain;
		$this->sudo_ssh($comm);
		$comm = 'rm -f /etc/httpd/vhost.d/@000-' . $user . '.' . $domain . '*';
		$this->sudo_ssh($comm);
		$comm = 'rm -f ' . $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
		$this->sudo_ssh($comm);
		$comm = 'rm -f /etc/nginx/sites-available/' . $domain . '.conf';
		$this->sudo_ssh($comm);
		$comm = 'rm -f /etc/httpd/vhost.d/ssl.' . $domain . '.conf';
		$this->sudo_ssh($comm);
		$comm = 'rm -f /etc/nginx/sites-available/ssl.' . $domain . '.conf';
		$this->sudo_ssh($comm);
		$this->ssh('rm -f /etc/httpd/vhost_logs/' . $domain . '_access');
		$this->ssh('rm -f /etc/httpd/vhost_logs/' . $domain . '_error');
		$this->ssh('rm -f /etc/nginx/vhost_logs/' . $domain . '_access');
		$this->ssh('rm -f /etc/nginx/vhost_logs/' . $domain . '_error');
		$src_acsess = '/etc/brainy/data/webserver_config/user_includes/' . $user . '/';
		$this->ssh('rm -f ' . $src_acsess . $domain . '.apache');
		$this->ssh('rm -f ' . $src_acsess . $domain . '.nginx');
		$list_domains = file('/etc/brainy/data/server_control/vhosts');
		$bind = new bindserver();
		$bind->bindserver_deleteZone($domain, $user);
		$user_info = new user_info();
		$user_info->edit_user($user, 'remove_domain', $domain);
		$aliases = preg_split('/[\\s,;]/', $vhostconf['aliases']);
		$i = 0;

		while ($i < count($aliases)) {
			$bind->bindserver_deleteZone($aliases[$i], $user);
			$this->del_string_new($aliases[$i], '/etc/brainy/data/server_control/vhosts');
			++$i;
		}

		$ip = $vhostconf['ip'];

		if (3 < strlen($ip)) {
			$ipmanager = new ipmanager();
			$nn = $ipmanager->ipmanager_check_ip_status($ip);
		}

		$hostacc = new hostacc();
		$hostacc->hostacc_count_sites($user, 1);
		$this->webservers_reloadconf();
		$this->checkFPM_conf($user, $domain);
		$dns_zonesCount = $hostacc->hostacc_count_dns_zones($user);
		$webstat = new web_static();
		$user_info = $this->config_read($GLOBALS['USERS_PATH'] . '/' . $user);
		$json_web = str_replace('"', '', $user_info['web_statics']);
		$json_web = $webstat->fixJSON($json_web);
		$st_web = json_decode($json_web, true);

		foreach ($st_web as $key_web => $curstat) {
			if ($key_web == $domain) {
				unset($st_web[$key_web]);
			}
		}

		$arr_webstatupd['web_statics'] = str_replace('"', '\\'', json_encode($st_web));
		$arr_webstatupd['r_dnszones'] = $dns_zonesCount;
		$this->config_save($GLOBALS['USERS_PATH'] . '/' . $user, $arr_webstatupd, 'add');
		$certs = new certs();
		$certs->removeFromSNI($domain);
		$arr['code'] = 0;
		$arr['message'] = $lang['server_control_domain_sus_delete'];
		return $arr;
	}

	public function user_hosts_stat($user)
	{
		global $lang;

		if (!$this->check_user($user)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		if (is_file($GLOBALS['USERS_PATH'] . $user)) {
			$conf = $this->config_read($GLOBALS['USERS_PATH'] . $user, true);
			$sites = explode(',', $conf['sites']);

			foreach ($sites as $site) {
				if (is_file($GLOBALS['DATA_VHOSTS'] . $site . '.conf')) {
					$res[$site] = $this->config_read($GLOBALS['DATA_VHOSTS'] . $site . '.conf');
				}
			}
		}
		else {
			$res = $lang['server_control_n_f_u'] . ' ' . $user . '!';
		}

		return $res;
	}

	public function get_all_sites($cur_user, $www = NULL, $decode = 0)
	{
		global $lang;
		$puny = new idna_convert();

		if (!$this->check_user($cur_user)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		if (0 < strlen($www)) {
			if (!$this->check_value('domain_star', $www)) {
				return array('code' => 204, 'message' => $lang['server_control_error_user']);
			}
		}

		$users = $this->request_vars_m('users', $cur_user);
		$sites = explode(',', $users['vhost_list']);
		$i = 0;

		while ($i < count($sites)) {
			if (!!trim($sites[$i])) {
				$aliases = explode(':', $sites[$i]);

				if ($decode == 0) {
					$sites_m[] = $aliases[0];
				}
				else {
					$sites_m[] = $puny->decode(trim($aliases[0]));
				}

				if ($aliases[1]) {
					$alias_m = explode('+', $aliases[1]);
				}
				else {
					$alias_m = NULL;
				}

				if (is_array($alias_m)) {
					foreach ($alias_m as $value) {
						if ($decode == 0) {
							$sites_m[] = $value;
						}
						else {
							$sites_m[] = $puny->decode(trim($value));
						}
					}
				}
			}

			++$i;
		}

		if ($www == 1) {
			if (is_array($sites_m)) {
				foreach ($sites_m as $key => $value) {
					if (preg_match('/^www\\./iu', $value)) {
						unset($sites_m[$key]);
					}
				}
			}
		}

		if (is_array($sites_m)) {
			return array_values($sites_m);
		}

		return $sites_m;
	}

	public function remove_star_array($array)
	{
		foreach ($array as $key => $val) {
			if (preg_match('/[\\*]/i', $val)) {
				unset($array[$key]);
			}
		}

		return $array;
	}

	public function get_virt_hosts($cur_user, $decode = 0)
	{
		global $lang;
		$puny = new idna_convert();

		if (!$this->check_user($cur_user)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		$users = $this->request_vars_m('users', $cur_user);
		$sites = explode(',', $users['vhost_list']);
		$back_service = $this->detect_back_server();
		$newm = array();
		$count_alias = 0;
		$hostacc = new hostacc();
		$workspace = $hostacc->getWorkspace($cur_user);

		if (0 < strlen($workspace)) {
			$workspace = $workspace . '/';
		}

		$i = 0;

		while ($i < count($sites)) {
			if (1 < strlen(trim($sites[$i]))) {
				$site_conf = explode(':', $sites[$i]);
				$site_conf1 = $site_conf[0];
				$site = $GLOBALS['DATA_VHOSTS'] . $site_conf1 . '.conf';
				$site = $this->config_read($site);

				if ($decode == 1) {
					$newm[$i]['domainOrig'] = $site['domain'];
					$newm[$i]['domain'] = $puny->decode(trim($site['domain']));
					$aliases_m = preg_split('/[\\s,;]/', $site['aliases']);
					$count_alias += count($aliases_m);

					foreach ($aliases_m as $keym => $value) {
						$value = $puny->decode(trim($value));
						$aliases_m[$keym] = $value;
					}

					if ((0 < count($aliases_m)) && (0 < strlen($aliases_m[0]))) {
						$newm[$i]['aliases'] = implode(', ', $aliases_m);
					}
				}
				else {
					$aliases_m = preg_split('/[\\s,;]/', $site['aliases']);
					$count_alias += count($aliases_m);
					$newm[$i]['domain'] = $site['domain'];

					if ((0 < count($aliases_m)) && (0 < strlen($aliases_m[0]))) {
						$newm[$i]['aliases'] = implode(', ', $aliases_m);
					}
				}

				$newm[$i]['ip'] = $site['ip'];
				$newm[$i]['dir'] = $site['dir'];

				if ($back_service['service'] == 'nginx') {
					$newm[$i]['bridge'] = $site['bridge_nginx'];
				}
				else {
					$newm[$i]['bridge'] = $site['bridge_apache'];
				}

				$newm[$i]['php'] = $site['php'];
				$newm[$i]['rootdir'] = $users['rootdir'] . '/' . $workspace;
				$newm[$i]['modsec_stat'] = $site['modsec_stat'];

				if (stripos($site['dir'], $users['rootdir'] . '/' . $workspace) !== false) {
					$newm[$i]['enddir'] = str_replace($users['rootdir'] . '/' . $workspace, '', $site['dir']);
				}
				else {
					$newm[$i]['enddir'] = str_replace($users['rootdir'] . '/', '', $site['dir']);
				}

				if (isset($site['ssl'])) {
					$newm[$i]['ssl'] = $site['ssl'];
				}
			}

			++$i;
		}

		if (0 < count($sites)) {
			if (1 < strlen(trim($sites[0]))) {
				$newm[0]['count_alias'] = $count_alias;
			}
		}

		return $newm;
	}

	public function get_virt_hosts_quick($cur_user)
	{
		global $lang;

		if (!$this->check_user($cur_user)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		$users = $this->request_vars_m('users', $cur_user);

		if (!sizeof($users)) {
			return array('code' => 204, 'message' => $lang['server_control_error_user']);
		}

		$sites = explode(',', $users['vhost_list']);
		$newm = array();
		$i = 0;

		while ($i < count($sites)) {
			if (!!trim($sites[$i])) {
				$site_conf = explode(':', $sites[$i]);
				$newm[] = $site_conf[0];
			}

			++$i;
		}

		return $newm;
	}

	public function count_virt_hosts($cur_user)
	{
		global $lang;

		if (!$this->check_user($cur_user)) {
			return 0;
		}

		$out = $this->get_virt_hosts($cur_user);
		return count($out);
	}

	public function user_ips_list($cur_user)
	{
		global $lang;

		if (!$this->check_user($cur_user)) {
			return array('code' => 203, 'message' => $lang['server_control_error_user']);
		}

		$read = $this->config_read('/etc/brainy/data/users/' . $cur_user);

		if (!sizeof($read)) {
			return array('code' => 204, 'message' => $lang['server_control_error_user']);
		}

		$ips = explode(' ', $read['ip']);
		return $ips;
	}

	public function safefilerewrite($fileName, $dataToSave)
	{
		if ($fp = fopen($fileName, 'w')) {
			$startTime = microtime(true);

			do {
				$canWrite = flock($fp, LOCK_EX);

				if (!$canWrite) {
					usleep(round(rand(0, 100) * 1000));
				}

			} while (!$canWrite && ((microtime(true) - $startTime) < 5));

			if ($canWrite) {
				fwrite($fp, $dataToSave);
				flock($fp, LOCK_UN);
			}

			fclose($fp);
		}
	}

	public function show_bash($arr)
	{
		foreach ($arr as $elem) {
			foreach ($elem as $str) {
				echo $str;
				echo '</br>';
			}
		}
	}

	public function write_ini_file($assoc_arr, $path, $has_sections = false)
	{
		global $lang;

		if (!is_file($path)) {
			return false;
		}

		$content = '';

		if ($has_sections) {
			foreach ($assoc_arr as $key => $elem) {
				$content .= '[' . $key . ']' . "\n";

				foreach ($elem as $key2 => $elem2) {
					if (is_array($elem2)) {
						$i = 0;

						while ($i < count($elem2)) {
							$content .= $key2 . '[] = "' . $elem2[$i] . '"' . "\n";
							++$i;
						}
					}
					else if ($elem2 == '') {
						$content .= $key2 . ' = ' . "\n";
					}
					else {
						$content .= $key2 . ' = "' . $elem2 . '"' . "\n";
					}
				}
			}
		}
		else {
			foreach ($assoc_arr as $key => $elem) {
				if (is_array($elem)) {
					$i = 0;

					while ($i < count($elem)) {
						$content .= $key . '[] = "' . $elem[$i] . '"' . "\n";
						++$i;
					}
				}
				else if ($elem == '') {
					$content .= $key . ' = ' . "\n";
				}
				else {
					$content .= $key . ' = "' . $elem . '"' . "\n";
				}
			}
		}

		if (!($handle = fopen($path, 'w'))) {
			return false;
		}

		flock($handle, LOCK_EX);
		$success = fwrite($handle, $content);
		flock($handle, LOCK_UN);
		fclose($handle);
		return $success;
	}

	public function write_php_ini($array, $file)
	{
		if (!is_file($file) || !sizeof($array)) {
			return false;
		}

		$res = array();

		foreach ($array as $key => $val) {
			if (is_array($val)) {
				$res[] = '[' . $key . ']';

				foreach ($val as $skey => $sval) {
					$res[] = $skey . '=' . (is_numeric($sval) ? $sval : '"' . $sval . '"');
				}
			}
			else {
				$res[] = $key . '=' . (is_numeric($val) ? $val : '"' . $val . '"');
			}
		}

		$this->safefilerewrite($file, implode("\r\n", $res));
		return true;
	}

	public function detect_webserver_path_service_conf()
	{
		$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);
		$servers_list = $this->webserver_get_serverlist();
		$res = array();
		$res['path'] = 'noservice';
		$res['service'] = 'noservice';
		$res['frontservice'] = 'noservice';
		$res['frontpath'] = 'noservice';

		foreach ($servers_list['servers'] as $item) {
			if (stripos($item, '+') === false) {
				if (stripos($item, $conf['back_server']) !== false) {
					$res['path'] = trim($servers_list[$item]['path']);
					$res['service'] = trim($servers_list[$item]['service']);
				}

				if (stripos($item, $conf['front_server']) !== false) {
					$res['frontpath'] = trim($servers_list[$item]['path']);
					$res['frontservice'] = trim($servers_list[$item]['service']);
				}
			}
		}

		return $res;
	}

	public function detect_back_server()
	{
		$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);
		$webserv_conf = $this->detect_webserver_path_service_conf();
		$back_server['path'] = $webserv_conf['path'];
		$back_server['service'] = $webserv_conf['service'];
		$back_server['front'] = $conf['front_server'];
		$back_server['php'] = '';

		foreach ($conf as $key => $param) {
			if ((stripos($key, 'php5') !== false) || (stripos($key, 'php7') !== false)) {
				$back_server .= 'php';
			}
		}

		return $back_server;
	}

	public function php_install($php_arr_do, $getstreamonline = NULL, $megapack = NULL)
	{
		return $this->php_reinstall($php_arr_do, $getstreamonline, $megapack);
	}

	public function php_reinstall($php_arr_do, $getstreamonline = NULL, $megapack = NULL)
	{
		$php_arr_do = json_decode($php_arr_do, 1);
		$os_version = $GLOBALS['OS_VERSION'];
		$foo = $this->config_read('/etc/brainy/data/server_control/main');
		$this->module_vars = $foo;
		$one = $this->module_vars['php'];
		$one = explode(',', $one);

		if ($one[0] == 'inprogress') {
			$foo = $this->config_read('/etc/brainy/data/server_control/main');
			$this->module_vars = $foo;
			$one = $this->module_vars['php'];
			$one = explode(',', $one);

			if (is_array($this->read_stream($one[1]))) {
				$stream_output = implode("\n", $this->read_stream($one[1]));
			}
			else {
				$stream_output = '';
			}

			$one_exts = $this->module_vars['php_exts'];
			$one_exts = explode(',', $one_exts);

			if (is_array($this->read_stream($one_exts[1]))) {
				$stream_output_exts = implode("\n", $this->read_stream($one_exts[1]));
			}
			else {
				$stream_output_exts = '';
			}

			$arr = array('stream_output' => $stream_output . $stream_output_exts, 'stream_status' => $one[0], 'stream_id' => $one[1], 'stream_status_exts' => $one_exts[0], 'stream_id_exts' => $one_exts[1]);
			return $arr;
		}

		$runproc = 0;

		foreach ($php_arr_do as $keyarr => $phpcur) {
			if (stripos($keyarr, 'php') !== false) {
				$runproc = 1;

				if (!$this->check_value('string', $keyarr)) {
					return false;
				}

				$array_php[] = $keyarr;
			}
		}

		if ($runproc == 1) {
			$stream[0]['array_start'] = array('php' => 'inprogress,#stream_id#,#stream_pid#');
			$stream[0]['array_succes'] = array('php' => 'succes,#stream_id#');
			$stream[0]['array_unsucces'] = array('php' => 'unsucces,#stream_id#', 'php_error' => '#error#');
			$stream[] = array('comm' => '/etc/brainy/src/compiled/php5/bin/php ' . $GLOBALS['DOCUMENT_ROOT_PATH'] . '/ssh/webserver.php ' . '-a=install -s=php -m=modifyphp -p=' . implode(',', $array_php), 'test' => 'no');

			if ($getstreamonline == 1) {
				$stream_id = $this->create_stream_online($stream, 'server_control');
			}
			else {
				$stream_id = $this->create_stream($stream);
			}
		}

		$foo = $this->config_read('/etc/brainy/data/server_control/main');
		$this->module_vars = $foo;
		$one = $this->module_vars['php'];
		$one = explode(',', $one);

		if ($one[0] == 'unsucces') {
		}
		else if ($one[0] == 'succes') {
		}

		if (is_array($this->read_stream($one[1]))) {
			$stream_output = implode("\n", $this->read_stream($one[1]));
		}
		else {
			$stream_output = '';
		}

		$arr = array('stream_output' => $stream_output, 'stream_status' => $one[0], 'stream_id' => $one[1]);
		return $arr;
	}

	public function webserver_get_serverlist()
	{
		$out = $this->read_file_n('/etc/brainy/data/server_control/servers');
		$out_main = $this->config_read('/etc/brainy/data/server_control/main');

		foreach ($out as $key => $value) {
			$foo = explode('|', $value);
			$newmass['titles'][$key] = $foo[1];
			$newmass['servers'][$key] = $foo[0];

			foreach ($foo as $fkey => $fparam) {
				$exp_data = explode('=', $fparam);

				if (1 < count($exp_data)) {
					$newmass[$foo[0]][$exp_data[0]] = $exp_data[1];
				}
			}
		}

		if (1 < strlen($out_main['front_server'])) {
			$newmass['check_srv'] = $out_main['back_server'] . '+' . $out_main['front_server'];
		}
		else {
			$newmass['check_srv'] = $out_main['back_server'];
		}

		return $newmass;
	}

	public function webserver_install($action, $getstreamonline = NULL)
	{
		$subaction = implode(',', $action['typephp_ins']);

		if (!$this->check_value('string2', $subaction)) {
			return false;
		}

		if (!$this->check_value('string2', $action['typeserv_ins'])) {
			return false;
		}

		$action = $action['typeserv_ins'];
		$type_serv_dec = explode('+', $action);
		global $smarty;
		$os_version = $GLOBALS['OS_VERSION'];
		$server_list = $this->webserver_get_serverlist();

		if (in_array($action, $server_list['servers'])) {
			$stream[] = array('comm' => '/etc/brainy/src/compiled/php5/bin/php ' . $GLOBALS['DOCUMENT_ROOT_PATH'] . '/ssh/webserver.php ' . '-a=install -s=' . $action . ' -p=' . $subaction, 'test' => 'Successfully done');
			$stream[0]['array_start'] = array('one' => 'inprogress,#stream_id#', 'content' => $type_serv_dec[0]);
			$stream[0]['array_succes'] = array('one' => 'succes,#stream_id#', 'content' => $type_serv_dec[0], 'back_server' => $type_serv_dec[0]);
			$stream[0]['array_unsucces'] = array('one' => 'unsucces,#stream_id#', 'error' => '#error#', 'content' => $type_serv_dec[0]);

			if ($getstreamonline == 1) {
				$stream_id = $this->create_stream_online($stream, 'server_control');
			}
			else {
				$stream_id = $this->create_stream($stream);
			}
		}

		if (($foo = $this->config_read('/etc/brainy/data/server_control/main')) === false) {
			$arr['stream_status'] = 'error';
			$arr['stream_output'] = 'no read data from server_control/main';
			return $arr;
		}

		$this->module_vars = $foo;
		$one = $this->module_vars['one'];
		$content = $this->module_vars['content'];
		$one = explode(',', $one);
		$file111 = '/etc/brainy/lib/sss';

		if ($one[0] == 'unsucces') {
			$arr['stream_status'] = 'unsucces';
			$arr['stream_output'] = implode("\n", $this->read_stream($one[1]));
		}
		else if ($one[0] == 'succes') {
			$arr['stream_status'] = 'succes';
			$arr['stream_output'] = implode("\n", $this->read_stream($one[1]));
		}
		else if ($one[0] == 'inprogress') {
			$arr['stream_status'] = 'inprogress';
			$arr['stream_output'] = implode("\n", $this->read_stream($one[1]));
		}
		else {
			$arr['stream_status'] = 'error';
			$arr['stream_output'] = 'no read data from server_control/main';
		}

		return $arr;
	}

	public function delete($subservice)
	{
		$subservice = json_decode($subservice, 1);
		$serv_list_act = '';
		$ap_del = '';
		$ng_del = '';

		foreach ($subservice as $key => $item) {
			if ($item == 1) {
				if (!$this->check_value('string', $key)) {
					return false;
				}

				if ((stripos($key, 'apache') === false) && (stripos($key, 'nginx') === false)) {
					$serv_list_act .= $key . ',';
				}
				else {
					if (stripos($key, 'apache') !== false) {
						$ap_del = $key;
					}

					if (stripos($key, 'nginx') !== false) {
						$ng_del = $key;
					}
				}
			}
		}

		if ((1 < strlen($serv_list_act)) || (0 < strlen($ap_del)) || (0 < strlen($ng_del))) {
			$stream[0]['array_start'] = array('delete' => 'inprogress,#stream_id#');
			$stream[0]['array_succes'] = array('delete' => 'succes,#stream_id#');
			$stream[0]['array_unsucces'] = array('delete' => 'unsucces,#stream_id#', 'error' => '#error#');

			if (1 < strlen($serv_list_act)) {
				$stream[] = array('comm' => '/etc/brainy/src/compiled/php5/bin/php ' . $GLOBALS['DOCUMENT_ROOT_PATH'] . '/ssh/webserver.php ' . '-a=delete -s=php -p=\'' . $serv_list_act . '\'', 'test' => 'no');
			}

			if (0 < strlen($ap_del)) {
				$stream[] = array('comm' => '/etc/brainy/src/compiled/php5/bin/php ' . $GLOBALS['DOCUMENT_ROOT_PATH'] . '/ssh/webserver.php ' . '-a=delete -s=\'' . $ap_del . '\'', 'test' => 'no');
			}

			if (0 < strlen($ng_del)) {
				$stream[] = array('comm' => '/etc/brainy/src/compiled/php5/bin/php ' . $GLOBALS['DOCUMENT_ROOT_PATH'] . '/ssh/webserver.php ' . '-a=delete -s=\'' . $ng_del . '\'', 'test' => 'no');
			}

			$stream_id = $this->create_stream($stream);
		}

		$foo = $this->config_read('/etc/brainy/data/server_control/main');
		$this->module_vars = $foo;
		$one = $this->module_vars['delete'];
		$one = explode(',', $one);
		$stream_output = implode("\n", $this->read_stream($one[1]));
		$arr = array('stream_output' => $stream_output, 'stream_status' => $one[0]);
		return $arr;
	}

	public function update_cache_avail_extphp()
	{
		$os_version = $GLOBALS['OS_VERSION'];
		$php_vers = explode(',', $GLOBALS['WEBSERVER_PHP_VERSION']);

		foreach ($php_vers as $phpcur) {
			$path = $GLOBALS['WEBSERVER_PHP_PATH'];
			$path = str_replace('phpversion', $phpcur, $path);
			$active_module_m[$phpcur] = $this->ssh($path . ' -m');

			if ($os_version == 'debian8') {
				$this->ssh('apt-get clean all');
				$all_pkg = $this->ssh('apt-cache search ^' . $phpcur . 'w* | awk \'{print $1}\'');
				$install_pkg = $this->ssh('dpkg -l | grep ' . $phpcur . 'w  | grep -v \'libphp\' | awk \'{print $2}\'');
				$pkg_no = array_diff($all_pkg, $install_pkg);

				if (is_array($install_pkg)) {
					array_unshift($install_pkg, 'Installed Packages');
				}

				if (is_array($pkg_no) && (0 < sizeof($pkg_no))) {
					array_push($install_pkg, 'Available Packages');
					$install_pkg = array_merge($install_pkg, $pkg_no);
				}

				$avail_ext_toins[$phpcur] = $install_pkg;
			}
			else {
				$this->ssh('yum clean all');
				$avail_ext_toins[$phpcur] = $this->ssh('yum list ' . $phpcur . 'w*');
			}
		}

		file_put_contents($GLOBALS['WEBSERVER_CACHE_EXTPHP'], json_encode($avail_ext_toins, 1), LOCK_EX);
	}

	public function extensions_info()
	{
		$os_version = $GLOBALS['OS_VERSION'];
		$php_vers = explode(',', $GLOBALS['WEBSERVER_PHP_VERSION']);
		$active_module_m = array();
		$avail_ext_toins = array();
		$already_ext_installed = array();
		$already_ext_installed_fixed = array();
		$ext_notins_yet = array();
		$ext_can_off = array();
		$ext_already_off = array();

		foreach ($php_vers as $phpcur) {
			$path = $GLOBALS['WEBSERVER_PHP_PATH'];
			$path = str_replace('phpversion', $phpcur, $path);
			$active_module_m[$phpcur] = $this->ssh($path . ' -m');
		}

		if (is_file($GLOBALS['WEBSERVER_CACHE_EXTPHP'])) {
			$avail_ext_toins = json_decode(file_get_contents($GLOBALS['WEBSERVER_CACHE_EXTPHP']), 1);
		}

		foreach ($php_vers as $phpcur) {
			foreach ($active_module_m[$phpcur] as $key_act_mod => $val_act_mod) {
				$pos = strripos($val_act_mod, ']');
				if (($pos !== false) || (strlen($val_act_mod) < 2) || (20 < strlen($val_act_mod))) {
					unset($active_module_m[$phpcur][$key_act_mod]);
					continue;
				}

				$active_module_m[$phpcur][$key_act_mod] = str_replace(' ', '', $active_module_m[$phpcur][$key_act_mod]);
				$active_module_m[$phpcur][$key_act_mod] = strtolower(str_replace('_', '-', $active_module_m[$phpcur][$key_act_mod]));
			}
		}

		$flag_installed = 'Installed';
		$flag_availabled = 'Available';
		$q = 0;

		foreach ($php_vers as $phpcur) {
			foreach ($avail_ext_toins[$phpcur] as $key_avail_toins => $val_avail_toins) {
				if (stripos($val_avail_toins, $flag_availabled) !== false) {
					break;
				}

				if ($q == 0) {
					if (stripos($val_avail_toins, $flag_installed) !== false) {
						$q = 1;
					}
				}
				else if (stripos($val_avail_toins, $phpcur) !== false) {
					$already_ext_installed[$phpcur][] = explode('.', $val_avail_toins, 2)[0];
				}
			}
		}

		$q = 0;

		foreach ($php_vers as $phpcur) {
			foreach ($avail_ext_toins[$phpcur] as $key_avail_toins => $val_avail_toins) {
				if ($q == 0) {
					if (stripos($val_avail_toins, $flag_availabled) !== false) {
						$q = 1;
					}
				}
				else if (stripos($val_avail_toins, $phpcur) !== false) {
					$ext_notins_yet[$phpcur][] = explode('.', $val_avail_toins, 2)[0];
				}
			}
		}

		foreach ($php_vers as $phpcur) {
			$find_ini_conf_ext = $this->ssh('find /etc/' . $phpcur . 'w/php.d/ -name \'*.ini\'');

			foreach ($find_ini_conf_ext as $cur_phpini_file) {
				$ext_name = basename($cur_phpini_file);

				if (stripos($ext_name, '-') !== false) {
					$ext_name = explode('-', $ext_name, 2)[1];
				}

				$ext_name = explode('.', $ext_name, 2)[0];
				$ext_can_off[$phpcur][] = $ext_name;

				if (is_file($cur_phpini_file)) {
					$entryes = file($cur_phpini_file);
				}

				if (is_array($entryes)) {
					if (preg_match('/\\.so/iu', $entryes[0])) {
						$ifcomment = $entryes[0];
					}
					else {
						$ifcomment = $entryes[1];
					}
				}
				else {
					$ifcomment = array();
					$ifcomment[0] = '';
				}

				if ($ifcomment[0] == ';') {
					$ext_already_off[$phpcur][] = $ext_name;
				}

				$qins = 0;

				if (is_array($already_ext_installed[$phpcur])) {
					foreach ($already_ext_installed[$phpcur] as $key_alreadyins => $val_alreadyinc_cur) {
						$qins = 1;
						break;
					}
				}

				if ($qins == 0) {
					$already_ext_installed_fixed[$phpcur][] = $phpcur . 'w-' . $ext_name;
				}
			}
		}

		foreach ($php_vers as $phpcur) {
			$active_module_m[$phpcur] = array_unique($active_module_m[$phpcur]);
		}

		$all_ext = array();

		foreach ($php_vers as $phpcur) {
			$all_ext[$phpcur] = $active_module_m[$phpcur];

			if (is_array($ext_notins_yet[$phpcur])) {
				foreach ($ext_notins_yet[$phpcur] as $cur_not_ins) {
					$mod_name1 = explode('-', $cur_not_ins, 2)[1];

					if (0 < strlen($mod_name1)) {
						$all_ext[$phpcur][] = $mod_name1;
					}
				}
			}

			if (is_array($ext_already_off[$phpcur])) {
				foreach ($ext_already_off[$phpcur] as $cur_alreadyoff) {
					$all_ext[$phpcur][] = $cur_alreadyoff;
				}
			}

			if (is_array($already_ext_installed[$phpcur])) {
				foreach ($already_ext_installed[$phpcur] as $key => $cur_ext_ins) {
					$cur_ext_ins_1 = explode('-', $cur_ext_ins, 2)[1];

					if (0 < strlen($cur_ext_ins_1)) {
						if (!in_array($cur_ext_ins_1, $all_ext)) {
							$all_ext[$phpcur][] = $cur_ext_ins_1;
						}
					}
				}
			}
		}

		foreach ($php_vers as $phpcur) {
			sort($all_ext[$phpcur]);
		}

		$conf_ins_phps = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);

		foreach ($php_vers as $phpcur) {
			if (!isset($conf_ins_phps[$phpcur . 'w'])) {
				continue;
			}

			foreach ($all_ext[$phpcur] as $key_ext => $val_ext) {
				$q_ins = 0;
				$q_can_ins = 0;
				$q_can_off = 0;
				$q_already_ins = 0;
				$q_notins_yet = 0;

				if (is_array($already_ext_installed[$phpcur])) {
					foreach ($already_ext_installed[$phpcur] as $ext_ins_cur) {
						$q_ins = 1;
						$q_already_ins = 1;
						break;
					}
				}

				if (is_array($already_ext_installed_fixed[$phpcur])) {
					foreach ($already_ext_installed_fixed[$phpcur] as $ext_ins_cur) {
						$q_ins = 1;
						break;
					}
				}

				if ($q_ins == 0) {
					$q_ins = 1;

					if (is_array($ext_notins_yet[$phpcur])) {
						foreach ($ext_notins_yet[$phpcur] as $ext_notins_cur) {
							$q_notins_yet = 1;
							break;
						}
					}

					if ($q_notins_yet == 1) {
						$q_ins = 0;
					}
				}

				if (($q_already_ins == 0) && ($q_notins_yet == 0)) {
					$ext_arr[$phpcur . 'w'][$val_ext]['rem_ins'] = 0;
				}
				else {
					$ext_arr[$phpcur . 'w'][$val_ext]['rem_ins'] = 1;
				}

				if ($q_ins == 0) {
					$ext_arr[$phpcur . 'w'][$val_ext]['installed'] = 0;
					$ext_arr[$phpcur . 'w'][$val_ext]['enabled'] = 0;
				}
				else {
					$ext_arr[$phpcur . 'w'][$val_ext]['installed'] = 1;

					if (is_array($ext_can_off[$phpcur])) {
						foreach ($ext_can_off[$phpcur] as $ext_can_off_cur) {
							$q_can_off = 1;
							break;
						}
					}

					if ($q_can_off == 0) {
						$ext_arr[$phpcur . 'w'][$val_ext]['not_enabling'] = 1;
					}
					else {
						$ext_arr[$phpcur . 'w'][$val_ext]['not_enabling'] = 0;

						if (!is_array($ext_already_off[$phpcur])) {
							$ext_already_off[$phpcur] = array();
						}

						if (in_array($val_ext, $ext_already_off[$phpcur]) == true) {
							$ext_arr[$phpcur . 'w'][$val_ext]['enabled'] = 0;
						}
						else {
							$ext_arr[$phpcur . 'w'][$val_ext]['enabled'] = 1;
						}
					}
				}
			}
		}

		return $ext_arr;
	}

	public function reinstall_ext_php($data_ext, $getstreamonline = NULL, $php_ver_ext_all = NULL)
	{
		$os_version = $GLOBALS['OS_VERSION'];
		$foo = $this->config_read('/etc/brainy/data/server_control/main');
		$this->module_vars = $foo;
		$one = $this->module_vars['php_exts'];
		$one = explode(',', $one);

		if ($one[0] == 'inprogress') {
			$one = $this->module_vars['php'];
			$one = explode(',', $one);

			if (is_array($this->read_stream($one[1]))) {
				$stream_output = implode("\n", $this->read_stream($one[1]));
			}
			else {
				$stream_output = '';
			}

			$one_exts = $this->module_vars['php_exts'];
			$one_exts = explode(',', $one_exts);

			if (is_array($this->read_stream($one_exts[1]))) {
				$stream_output_exts = implode("\n", $this->read_stream($one_exts[1]));
			}
			else {
				$stream_output_exts = '';
			}

			$arr = array('stream_output' => $stream_output . $stream_output_exts, 'stream_status' => $one_exts[0], 'stream_id' => $one_exts[1], 'stream_status_exts' => $one_exts[0], 'stream_id_exts' => $one_exts[1]);
			return $arr;
		}

		$exts = '';

		if (0 < count($php_ver_ext_all)) {
			if (!is_file($GLOBALS['WEBSERVER_CACHE_EXTPHP'])) {
				$this->update_cache_avail_extphp();
			}

			$avail_ext_toins = json_decode(file_get_contents($GLOBALS['WEBSERVER_CACHE_EXTPHP']), 1);

			foreach ($php_ver_ext_all as $php_ver) {
				foreach ($avail_ext_toins[$php_ver] as $key_avail_toins => $val_avail_toins) {
					if (stripos($val_avail_toins, $php_ver) !== false) {
						if ($os_version == 'debian8') {
							$exts .= explode('.', '^' . $val_avail_toins, 2)[0] . '* ';
						}
						else {
							$exts .= explode('.', $val_avail_toins, 2)[0] . '* ';
						}
					}
				}
			}
		}

		if ($getstreamonline == 1) {
			print_r($exts);
		}

		if (!empty($data_ext) || !empty($exts)) {
			$stream = array();

			if (5 < strlen($data_ext)) {
				$exts = explode(':', $data_ext);
				$exts = array_diff($exts, array('', 0, NULL, ',', ' '));
				$exts = implode(',', $exts);

				if ($os_version == 'debian8') {
					$exts = str_replace('*', '', $exts);
				}
			}

			if (!empty($exts)) {
				$stream[0]['array_start'] = array('php_exts' => 'inprogress,#stream_id#');
				$stream[0]['array_succes'] = array('php_exts' => 'succes,#stream_id#');
				$stream[0]['array_unsucces'] = array('php_exts' => 'unsucces,#stream_id#', 'php_exts_error_0' => '#error#');
				$stream[] = array('comm' => '/etc/brainy/src/compiled/php5/bin/php ' . $GLOBALS['DOCUMENT_ROOT_PATH'] . '/ssh/webserver.php ' . '-a=reinstall -s=php_exts -m=' . $exts, 'test' => 'no');

				if ($getstreamonline == 1) {
					$stream_id = $this->create_stream_online($stream, 'server_control');
				}
				else {
					$stream_id = $this->create_stream($stream);
				}
			}
		}

		$foo = $this->config_read('/etc/brainy/data/server_control/main');
		$this->module_vars = $foo;
		$one = $this->module_vars['php_exts'];
		$one = explode(',', $one);

		if (is_array($this->read_stream($one[1]))) {
			$stream_output = implode("\n", $this->read_stream($one[1]));
		}
		else {
			$stream_output = '';
		}

		$arr = array('stream_output' => $stream_output, 'stream_status' => $one[0]);
		return $arr;
	}

	public function get_extphp_list()
	{
		$os_version = $GLOBALS['OS_VERSION'];
		$out = file_get_contents($GLOBALS['WEBSERVER_CACHE_EXTPHP']);

		if ($os_version == 'debian8') {
			preg_match_all('|php[0-9]+w-(.*)+(?=")|Usi', $out, $out1);
		}
		else {
			preg_match_all('/php[0-9]+w-(.*)(\\.x86_64|\\.noarch)+/iUs', $out, $out1);
		}

		foreach ($out1[0] as $key => $value) {
			if ($os_version == 'debian8') {
				preg_match('|(php[0-9]+w)-(.*)|Usi', $value, $out2);
			}
			else {
				preg_match('/(php[0-9]+w)-(.*)(\\.x86_64|\\.noarch)+/Usi', $value, $out2);
				unset($out2[3]);
			}

			$newm[$out2[1]]['name'][] = $value;
			$newm[$out2[1]]['short_name'][] = $out2[1] . '-' . $out2[1];
		}

		return $newm;
	}

	public function ajax_ext_php($data_ext, $getstreamonline = NULL)
	{
		$os_version = $GLOBALS['OS_VERSION'];

		if (!empty($data_ext)) {
			$stream = array();
			$exts = str_replace('undefined', '', $data_ext);
			$exts = explode(':', $exts);
			$exts = array_diff($exts, array('', 0, NULL, ',', ' '));
			$exts = implode(',', $exts);

			if ($os_version == 'debian8') {
				$exts = str_replace('*', '', $exts);
			}

			if (!empty($exts)) {
				$stream[0]['array_start'] = array('php_exts' => 'inprogress,#stream_id#');
				$stream[0]['array_succes'] = array('php_exts' => 'succes,#stream_id#');
				$stream[0]['array_unsucces'] = array('php_exts' => 'unsucces,#stream_id#', 'php_exts_error_1' => '#error#');
				$stream[] = array('comm' => '/etc/brainy/src/compiled/php5/bin/php ' . $GLOBALS['DOCUMENT_ROOT_PATH'] . '/ssh/webserver.php ' . '-a=install -s=php_exts -m=' . $exts, 'test' => 'no');

				if ($getstreamonline == 1) {
					$stream_id = $this->create_stream_online($stream, 'server_control');
				}
				else {
					$stream_id = $this->create_stream($stream);
				}
			}
		}

		$foo = $this->config_read('/etc/brainy/data/server_control/main');
		$this->module_vars = $foo;
		$one = $this->module_vars['php_exts'];
		$one = explode(',', $one);
		$stream_output = implode("\n", $this->read_stream($one[1]));
		$arr = array('stream_output' => $stream_output, 'stream_status' => $one[0]);
		return $arr;
	}

	public function get_info()
	{
		$module_vars = $this->config_read($GLOBALS['SERVER_CONTROL_PATH'] . 'main');
		$common = array();

		if (isset($module_vars['back_server'])) {
			$common['back_server'] = $module_vars['back_server'];
		}

		if (isset($module_vars['front_server'])) {
			$common['front_server'] = $module_vars['front_server'];
		}

		$servers_list = $this->webserver_get_serverlist();
		$php_list = $this->webserver_php_list();
		$common['apache_path'] = $servers_list[$common['back_server']]['path'];
		$common['apache_service'] = $servers_list[$common['back_server']]['service'];

		if (isset($module_vars['default_bridge'])) {
			$common['user_data']['default_bridge'] = $module_vars['default_bridge'];
		}

		if (isset($module_vars['open_bridges'])) {
			$common['user_data']['open_bridges'] = explode(',', $module_vars['open_bridges']);
		}

		if (isset($module_vars['default_php'])) {
			$common['user_data']['default_php'] = $module_vars['default_php'];
		}

		if (isset($module_vars['open_phps'])) {
			$common['user_data']['open_phps'] = explode(',', $module_vars['open_phps']);
		}

		if (isset($module_vars['suphp'])) {
			$common['user_data']['suphp'] = $module_vars['suphp'];
		}

		if (isset($module_vars['mod_php'])) {
			$common['user_data']['mod_php'] = $module_vars['mod_php'];
		}

		if (isset($module_vars['mod_ruid2'])) {
			$common['user_data']['mod_ruid2'] = $module_vars['mod_ruid2'];
		}

		if (isset($module_vars['cgi'])) {
			$common['user_data']['cgi'] = $module_vars['cgi'];
		}

		if (isset($module_vars['fcgi'])) {
			$common['user_data']['fcgi'] = $module_vars['fcgi'];
		}

		if (isset($module_vars['fpm'])) {
			$common['user_data']['fpm'] = $module_vars['fpm'];
		}

		if (isset($module_vars['nophp'])) {
			$common['user_data']['nophp'] = $module_vars['nophp'];
		}

		if (isset($module_vars['acces_bridges'])) {
			$common['user_data']['acces_bridges'] = $module_vars['acces_bridges'];
		}

		if (isset($module_vars['acces_phps'])) {
			$common['user_data']['acces_phps'] = $module_vars['acces_phps'];
		}

		$mod_security = new mod_security();
		$webserv_type = $mod_security->status_webserver();

		if ($webserv_type == 'all') {
			$control = $mod_security->get_config_mod_security('nginx');
		}
		else {
			$control = $mod_security->get_config_mod_security();
		}

		$common['user_data']['modsec_stat_webserv'] = $control['SecRuleEngine'] == 'On' ? 1 : 0;

		foreach ($php_list as $key => $item) {
			if (isset($module_vars[$key])) {
				$common['phparr'][str_replace('w', '', $key)] = $module_vars[$key];
			}
			else {
				$common['phparr'][str_replace('w', '', $key)] = 0;
			}
		}

		if (isset($module_vars['mod_php'])) {
			$common['mod_php'] = $module_vars['mod_php'];
		}

		if (isset($module_vars['php_cgi'])) {
			$common['php_cgi'] = $module_vars['php_cgi'];
		}

		if (isset($module_vars['php_fcgi'])) {
			$common['php_fcgi'] = $module_vars['php_fcgi'];
		}

		if (isset($module_vars['mod_ruid2'])) {
			$common['mod_ruid2'] = $module_vars['mod_ruid2'];
		}

		if (isset($module_vars['fpm'])) {
			$common['fpm'] = $module_vars['fpm'];
		}

		if (isset($module_vars['suphp'])) {
			$common['suphp'] = $module_vars['suphp'];
		}

		if (isset($module_vars['nophp'])) {
			$common['nophp'] = $module_vars['nophp'];
		}

		if (isset($common['phparr'])) {
			foreach ($common['phparr'] as $key => $value) {
				if (empty($value)) {
					$common['phparr'][$key] = 0;
				}
			}
		}

		return $common;
	}

	public function check_apache_semafor()
	{
		$out_error = implode('', $this->ssh('tail /var/log/httpd/error_log -n 8 | grep \'space left\''));

		if (preg_match('/space left/i', $out_error)) {
			file_put_contents('/var/log/brainy/test_semafores', 'webservercl_clear_ok');
			$this->ssh('/etc/brainy/ssh/webserver.sh');
		}
	}

	public function apache_control($action, $forced = NULL)
	{
		$webserv_conf = $this->detect_webserver_path_service_conf();
		$apache_path = $webserv_conf['path'];
		$apache_service = $webserv_conf['service'];

		if ($action == 'apache_restart') {
			$out_apache = $this->monitor_service_command($apache_service, 'restart');
			$this->check_apache_semafor();
			return $out_apache;
		}

		if ($action == 'apache_force restart') {
			$comm = 'killall -9 ' . $apache_service;
			$this->sudo_ssh($comm);
			sleep(5);
			$out_apache = $this->monitor_service_command($apache_service, 'restart');
			$this->check_apache_semafor();
			return $out_apache;
		}

		if ($action == 'apache_start') {
			$out_apache = $this->monitor_service_command($apache_service, 'start');
			return $out_apache;
		}

		if ($action == 'apache_stop') {
			$out_apache = $this->monitor_service_command($apache_service, 'stop');
			return $out_apache;
		}
	}

	public function nginx_control($action)
	{
		if ($action == 'nginx_restart') {
			$out_nginx = $this->monitor_service_command('nginx', 'restart');
			return $out_nginx;
		}

		if ($action == 'nginx_force restart') {
			$comm = 'sudo -i service nginx stop';
			$this->sudo_ssh($comm);
			$out_nginx = $this->monitor_service_command('nginx', 'restart');
			return $out_nginx;
		}

		if ($_GET['action'] == 'nginx_start') {
			$out_nginx = $this->monitor_service_command('nginx', 'start');
			return $out_nginx;
		}

		if ($_GET['action'] == 'nginx_stop') {
			$out_nginx = $this->monitor_service_command('nginx', 'stop');
			return $out_nginx;
		}
	}

	public function start_fpm($php)
	{
		global $lang;
		$php_now = str_replace('w', '', $php);
		$version = $php_now . '-fpm';
		$res = $this->monitor_service_command($version, 'start');
		$ans[0] = $lang['server_control_fpm_startok'] . ' ' . $version;
		return $ans;
	}

	public function fpm_control($version, $action)
	{
		global $lang;

		if (!$this->check_value('string', $version)) {
			return false;
		}

		if (!$this->check_value('string', $action)) {
			return false;
		}

		$version_pathconf = str_replace('-fpm', '', $version);
		$file = '/etc/' . $version_pathconf . '/php-fpm.d/www.conf';
		$version_now = str_replace('w', '', $version);
		$version = $version_now;

		if ($action == 'start') {
			$res = $this->monitor_service_command($version, $action);
			$ans[0] = $lang['server_control_start_ok'] . ' ' . $version . ' ' . $lang['server_control_fpm_ok_mess'];
		}

		if ($action == 'stop') {
			$comm = 'pgrep -f ' . $file;
			$res = $this->sudo_ssh($comm);

			if (is_array($res)) {
				$comm = 'kill ' . $res[0];
				$this->sudo_ssh($comm);
				$ans[0] = $lang['server_control_s_ok'] . ' ' . $version . ' ' . $lang['server_control_fpm_ok_mess'];
			}
			else {
				$comm = 'kill ' . $res;
				$this->sudo_ssh($comm);
				$ans[0] = $lang['server_control_s_ok'] . ' ' . $version . ' ' . $lang['server_control_fpm_ok_mess'];
			}

			$res = $this->monitor_service_command($version, $action);
		}

		if ($action == 'restart') {
			$comm = 'pgrep -f ' . $file;
			$res = $this->sudo_ssh($comm);

			if (is_array($res)) {
				$comm = 'kill ' . $res[0];
				$this->sudo_ssh($comm);
			}
			else {
				$comm = 'kill ' . $res;
				$this->sudo_ssh($comm);
			}

			$res = $this->monitor_service_command($version, $action);
			$ans[0] = $lang['server_control_s_ok'] . ' ' . $version . ' ' . $lang['server_control_fpm_ok_mess'];
			$ans[1] = $lang['server_control_start_ok'] . ' ' . $version . ' ' . $lang['server_control_fpm_ok_mess'];
		}

		return $ans;
	}

	public function client_options_accept($data_ext)
	{
		$this->webserver_change_openphps($data_ext['group_php_acces']);
		$this->webserver_set_open_bridges($data_ext['access_bridges'], 1);
		$this->webserver_setup_bridges($data_ext['access_bridges'], 1);
		$this->webserver_set_default_php($data_ext['group_php'], 1);
		$this->webserver_set_default_bridge($data_ext['group_bridges_default'], 1);
		$this->webserver_set_acces_bridges($data_ext['group_bridges_allow'], 1);
		$this->webserver_set_acces_phps($data_ext['group_php_allow'], 1);
		sleep(1);
		$this->webservers_reloadconf(1);
		return 1;
	}

	public function php_main_get_values($data)
	{
		$pathphp_w = str_replace('.', '', $data) . 'w';
		$addr = '/etc/brainy/data/backup_conf/' . $pathphp_w . '/php_user.ini';

		if (!empty($data)) {
			$params = array('max_execution_time', 'upload_max_filesize', 'disable_functions', 'error_reporting', 'display_errors', 'open_basedir', 'allow_url_fopen', 'allow_url_include', 'memory_limit', 'mbstring.func_overload', 'mbstring.internal_encoding', 'session.save_path');
			$conf = $this->parse_config_read_param($addr, $params, ' = ', array(';'));

			foreach ($params as $param) {
				if (!isset($conf[$param][0])) {
					$conf[$param] = '';
				}

				if (strripos($conf[$param], ';')) {
					$part = explode(';', $conf[$param]);
					$conf[$param] = $part[0];
				}

				$res[$param] = $conf[$param];
			}

			$res['phpfullconf'] = file_get_contents($addr);
			global $smarty;
			$smarty->assign('max_execution_time', $res['max_execution_time']);
			$smarty->assign('upload_max_filesize', $res['upload_max_filesize']);
			$smarty->assign('disable_functions', $res['disable_functions']);
			$smarty->assign('error_reporting', $res['error_reporting']);
			$smarty->assign('display_errors', $res['display_errors']);
			$smarty->assign('open_basedir', $res['open_basedir']);
			$smarty->assign('allow_url_fopen', $res['allow_url_fopen']);
			$smarty->assign('allow_url_include', $res['allow_url_include']);
			$smarty->assign('memory_limit', $res['memory_limit']);
			$smarty->assign('mbstring_func_overload', $res['mbstring.func_overload']);
			$smarty->assign('mbstring_internal_encoding', $res['mbstring.internal_encoding']);
			$smarty->assign('session_save_path', $res['session.save_path']);
			$smarty->assign('phpfullconf', $res['phpfullconf']);
			return $res;
		}
	}

	public function ext_php_delete($data_ext)
	{
		$os_version = $GLOBALS['OS_VERSION'];

		if (!empty($data_ext)) {
			$exts = explode(':', $data_ext);
			$exts = array_diff($exts, array('', 0, NULL, ',', ' '));
			$exts = implode(',', $exts);

			if ($os_version == 'debian8') {
				$exts = str_replace('*', '', $exts);
			}

			if (!empty($exts)) {
				$stream[0]['array_start'] = array('php_exts' => 'inprogress,#stream_id#');
				$stream[0]['array_succes'] = array('php_exts' => 'succes,#stream_id#');
				$stream[0]['array_unsucces'] = array('php_exts' => 'unsucces,#stream_id#', 'php_exts_error_2' => '#error#');
				$stream[] = array('comm' => '/etc/brainy/src/compiled/php5/bin/php ' . $GLOBALS['DOCUMENT_ROOT_PATH'] . '/ssh/webserver.php ' . '-a=delete -s=php_exts -m=' . $exts, 'test' => 'no');
				$this->create_stream($stream);
			}
		}

		$foo = $this->config_read('/etc/brainy/data/server_control/main');
		$this->module_vars = $foo;
		$one = $this->module_vars['php_exts'];
		$one = explode(',', $one);

		if ($one[0] == 'unsucces') {
			$arr['stream_status'] = 'unsucces';
			$arr['stream_output'] = implode("\n", $this->read_stream($one[1]));
		}
		else if ($one[0] == 'succes') {
			$arr['stream_status'] = 'succes';
			$arr['stream_output'] = implode("\n", $this->read_stream($one[1]));
		}
		else if ($one[0] == 'inprogress') {
			$arr['stream_status'] = 'inprogress';
			$arr['stream_output'] = implode("\n", $this->read_stream($one[1]));
		}
		else if ($one[0] == 'old') {
			$arr['stream_status'] = 'old';
		}

		return $arr;
	}

	public function ext_php_include($data_ext, $data_ext_off, $version)
	{
		$data_ext = explode(':', $data_ext);
		$data_ext_off = explode(':', $data_ext_off);
		if (!empty($data_ext) || !empty($data_ext_off)) {
			foreach ($data_ext_off as $need_to_out_current) {
				$need_to_out_transformed = explode('-', $need_to_out_current);
				$need_to_out_transformed = $need_to_out_transformed[1];
				$find_ini_conf_ext = $this->ssh('find /etc/' . $version . '/php.d/ -name \'*-' . $need_to_out_transformed . '.ini\'');

				if (!$find_ini_conf_ext) {
					$find_ini_conf_ext = $this->ssh('find /etc/' . $version . '/php.d/ -name \'' . $need_to_out_transformed . '.ini\'');
				}

				$need_to_out_path = $find_ini_conf_ext[0];
				$id_row = 1;

				if (file_exists($need_to_out_path)) {
					$entryes = file($need_to_out_path);

					if (preg_match('/\\.so/iu', $entryes[0])) {
						$ifcomment = $entryes[0];
						$id_row = 0;
					}
					else {
						$ifcomment = $entryes[1];
					}

					if (strripos($ifcomment, '.so') === false) {
						$ifcomment = $entryes[0];
						$id_row = 0;
					}

					if ($ifcomment[0] != ';') {
						$entryes[$id_row] = ';' . $ifcomment;
						$this->safefilerewrite($need_to_out_path, implode('', $entryes));
					}
				}
			}

			foreach ($data_ext as $need_to_in_current) {
				$need_to_in_transformed = explode('-', $need_to_in_current);
				$need_to_in_transformed = $need_to_in_transformed[1];

				if ($need_to_in_transformed) {
					$find_ini_conf_ext = $this->ssh('find /etc/' . $version . '/php.d/ -name \'*-' . $need_to_in_transformed . '.ini\'');

					if (!$find_ini_conf_ext) {
						$find_ini_conf_ext = $this->ssh('find /etc/' . $version . '/php.d/ -name \'' . $need_to_in_transformed . '.ini\'');
					}

					$need_to_in_path = $find_ini_conf_ext[0];
					$id_row = 1;

					if (file_exists($need_to_in_path)) {
						$entryes = file($need_to_in_path);

						if (preg_match('/\\.so/iu', $entryes[0])) {
							$ifcomment = $entryes[0];
							$id_row = 0;
						}
						else {
							$ifcomment = $entryes[1];
						}

						if (strripos($ifcomment, '.so') === false) {
							$ifcomment = $entryes[0];
							$id_row = 0;
						}

						if ($ifcomment[0] == ';') {
							$entryes[$id_row] = str_replace(';', '', $ifcomment);
							$this->safefilerewrite($need_to_in_path, implode('', $entryes));
						}
					}
				}
			}
		}

		$this->reload_any_backend();
	}

	public function reload_any_backend()
	{
		$this->webservers_reloadconf(1);
	}

	public function reload_any_frontend()
	{
		$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);

		if ($conf['front_server'] == 'nginx') {
			$service = 'nginx';
		}

		$this->monitor_service_command($service, 'reload');
	}

	public function apache_conf($data, $action)
	{
		$foo = $this->config_read('/etc/brainy/data/server_control/main');
		$this->module_vars = $foo;
		$common = $this->get_info();
		$apache_conf = $common['apache_path'] . 'conf/httpd.conf';

		if (!empty($data) && ($data != 'undefined')) {
			$apache_temp = $data;

			if (!empty($apache_temp)) {
				file_put_contents($apache_conf, $apache_temp);
				file_put_contents($GLOBALS['HTTPD_CONF_USER'], $apache_temp);
			}
		}

		$apache_temp = file_get_contents($apache_conf);
		$apache_output = htmlspecialchars($apache_temp);
		return $apache_output;
	}

	public function nginx_conf($data, $action)
	{
		$foo = $this->config_read('/etc/brainy/data/server_control/main');
		$this->module_vars = $foo;
		$nginx_conf = $GLOBALS['NGINX_CONF'];

		if (!empty($data) && ($data != 'undefined')) {
			$nginx_temp = $data;

			if (!empty($nginx_temp)) {
				file_put_contents($nginx_conf, $nginx_temp);
				file_put_contents($GLOBALS['NGINX_CONF_USER'], $nginx_temp);
			}
		}

		if ($action == 'yes') {
			$comm = 'cp -f ' . $GLOBALS['NGINX_CONF_RES'] . ' ' . $GLOBALS['NGINX_CONF'];
			$this->sudo_ssh($comm);
		}

		$nginx_temp = file_get_contents($nginx_conf);
		$nginx_output = htmlspecialchars($nginx_temp);
		return $nginx_output;
	}

	public function php_copy_ini($array_php)
	{
		if (is_array($array_php)) {
			foreach ($array_php as $val) {
				if (is_file('/etc/brainy/data/backup_conf/' . $val . '/php.ini')) {
					$this->ssh('yes | cp -f /etc/brainy/data/backup_conf/' . $val . '/php.ini /etc/' . $val . '/php.ini');
				}
			}
		}
	}

	public function php_conf($data, $action, $version)
	{
		if (!$this->check_value('string', $version)) {
			return false;
		}

		$foo = $this->config_read('/etc/brainy/data/server_control/main');
		$this->module_vars = $foo;
		$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);
		$php_conf = '/etc/' . $version . 'w/php.ini';
		$php_conf_user = '/etc/brainy/data/backup_conf/' . $version . 'w/php_user.ini';

		if (!empty($data) && ($data != 'undefined') && ($data != 'null')) {
			$php_temp = base64_decode($data);
			$php_temp = urldecode($php_temp);
			if (!!($php_temp && ($php_temp != 'undefined') && ($php_temp != 'null'))) {
				file_put_contents($php_conf, $php_temp);
				file_put_contents($php_conf_user, $php_temp);
			}
		}

		if ($action == 'yes') {
			$comm = 'yes | cp -f /etc/brainy/data/backup_conf/' . $version . 'w/php.ini /etc/' . $version . 'w/php.ini';
			$this->sudo_ssh($comm);
			$comm = 'yes | cp -f /etc/brainy/data/backup_conf/' . $version . 'w/php.ini /etc/brainy/data/backup_conf/' . $version . 'w/php_user.ini';
			$this->sudo_ssh($comm);
		}

		if (is_file($php_conf)) {
			$php_temp = file_get_contents($php_conf);
		}
		else {
			$php_temp = '';
		}

		$this->monitor_service_command($version . '-fpm', 'reload');
		$php_output = htmlspecialchars($php_temp);
		return $php_output;
	}

	public function save_main_php_conf($version, $data)
	{
		$vers_format = str_replace('.', '', $version) . 'w';
		$addr = '/etc/' . $vers_format . '/php.ini';
		$addr_user = '/etc/brainy/data/backup_conf/' . $vers_format . '/php_user.ini';

		if (!empty($version) && !empty($data)) {
			$posted = base64_decode($data);
			$posted = urldecode($posted);
			$posted = explode(':::', $posted);
			$post_array['max_execution_time'] = $posted[0];
			$post_array['upload_max_filesize'] = $posted[1];
			$post_array['disable_functions'] = $posted[2];
			$post_array['error_reporting'] = $posted[3];
			$post_array['display_errors'] = $posted[4];
			$post_array['open_basedir'] = $posted[5];
			$post_array['allow_url_fopen'] = $posted[6];
			$post_array['allow_url_include'] = $posted[7];
			$post_array['memory_limit'] = $posted[8];
			$post_array['mbstring.func_overload'] = $posted[9];
			$post_array['mbstring.internal_encoding'] = $posted[10];
			$post_array['session.save_path'] = $posted[11];
			$ans = $this->parse_config_save_phpini($addr, $post_array, ' = ');
			$ans2 = $this->parse_config_save_phpini($addr_user, $post_array, ' = ');
		}
	}

	public function webserver_getdomains($user)
	{
		if (!$this->check_user($user)) {
			return 0;
		}

		$res = parse_ini_file($GLOBALS['USERS_PATH'] . $user);

		if (!sizeof($res)) {
			return 0;
		}

		$res = explode(',', $res['vhost_list']);

		foreach ($res as $site) {
			$site = trim($site);

			if (!empty($site)) {
				$site = explode(':', $site);
				$ret[] = $site[0];
			}
		}

		if (is_array($ret)) {
			$ret = array_unique($ret);
		}

		return $ret;
	}

	public function test_fpm_installed()
	{
		$res = $this->extensions_info();

		if (is_array($res)) {
			foreach ($res as $verskey => $version) {
				foreach ($version as $extkey => $value) {
					if (($extkey == 'fpm') && ($value['installed'] == '1')) {
						$fpms[$verskey] = 1;
					}
				}
			}
		}

		if (!empty($fpms)) {
			return $fpms;
		}

		return '0';
	}

	public function rebuild_virt_host()
	{
		global $lang;
		$not_default = 0;
		$dh = opendir($GLOBALS['DATA_VHOSTS']);
		$this->ssh('rm -rf /etc/httpd/vhost.d/*');
		$this->ssh('rm -rf /etc/nginx/sites-available/*');
		$ip_use_ssl = array();

		while (false !== $filename = readdir($dh)) {
			if ($filename[0] == '.') {
				continue;
			}

			$domains[] = substr($filename, 0, strrpos($filename, '.'));
			$confdom = parse_ini_file($GLOBALS['DATA_VHOSTS'] . '/' . $filename);

			if ($confdom['default_ssl'] == 1) {
				$not_default = 1;
				$ip_use_ssl[] = $confdom['ip'];
			}
		}

		$this->add_default_host($ip_use_ssl);
		$mod_security = new mod_security();
		$webserv_type = $mod_security->status_webserver();

		if ($webserv_type == 'all') {
			$control = $mod_security->get_config_mod_security('nginx');
		}
		else {
			$control = $mod_security->get_config_mod_security();
		}

		$modSecGlobal = ($control['SecRuleEngine'] == 'On' ? 1 : 0);

		if (is_array($domains)) {
			foreach ($domains as $domain) {
				$this->webserver_convert_domain($domain, $modSecGlobal);
			}
		}

		$httpddir = '/etc/httpd/vhost.d/';
		$nginxdir = '/etc/nginx/sites-available/';
		$resarr = $this->ssh('find ' . $httpddir . ' -type f -name \'!!ssl*\'');

		if (0 < count($resarr)) {
			$this->ssh('mv \'' . $httpddir . '!!ssl.default.conf\' \'' . $httpddir . 'ssl.default.conf\'');
		}

		$resarr = $this->ssh('find ' . $nginxdir . ' -type f -name \'!!ssl*\'');

		if (0 < count($resarr)) {
			$this->ssh('mv \'' . $nginxdir . '!!ssl.default.conf\' \'' . $nginxdir . 'ssl.default.conf\'');
		}

		$this->rebuildnamevirt_apache();
		$web_panel = trim($this->get_webpanel());

		if ($web_panel) {
			$this->webserver_convert_domain($web_panel);
		}

		$out['code'] = 0;
		$out['message'] = $lang['server_control_n'];
		return $out;
	}

	public function rotateLogType($pathOrig, $pathTo, $timeLast, $deltaDel, $offset_webserver, $timestart, $typeLog = 0)
	{
		if (is_file($pathOrig)) {
			$file_time = filemtime($pathOrig);

			if ($file_time < $timeLast) {
				return NULL;
			}

			$iCountStr = 0;

			if ($f = fopen($pathOrig, 'r')) {
				$arrDelRows = array();

				if (!feof($f)) {
					$log = fgets($f);

					if ($typeLog == 0) {
						$regex = '/^(\\S+) (\\S+) (\\S+) \\[([^:]+):(\\d+:\\d+:\\d+) ([^\\]]+)\\] \\"(\\S+) (.*?) (\\S+)\\" (\\S+) (\\S+) "([^"]*)" "([^"]*)"$/';
					}

					if ($typeLog == 1) {
						$regex = '/^\\[(\\S+) (\\S+) (\\S+) (\\d+:\\d+:\\d+).(\\d+) (\\d+)] (.*?)$/';
					}

					preg_match($regex, $log, $a);

					if (strlen($log) < 2) {
						continue;
					}

					if ($typeLog == 0) {
						$arr_date = explode('/', $a[4]);
						$arr_time = explode(':', $a[5]);
						$int_month = $this->traf_man_mn($arr_date[1]);
						$linux_time = mktime($arr_time[0], $arr_time[1], $arr_time[2], $int_month, $arr_date[0], $arr_date[2]) + $offset_webserver;
					}

					if ($typeLog == 1) {
						$arr_time = explode(':', $a[4]);
						$int_month = $this->traf_man_mn($a[2]);
						$linux_time = mktime($arr_time[0], $arr_time[1], $arr_time[2], $int_month, $a[3], $a[6]) + $offset_webserver;
					}

					if ((($linux_time + $deltaDel) - $timestart) < 0) {
						$arrDelRows[] = $iCountStr;
					}

					++$iCountStr;

					file_put_contents($pathTo, $log, FILE_APPEND);

					continue;
				}

				fclose($f);
				unset($f);
				$firstRowDel = $arrDelRows[0] + 1;
				$lastRowDel = $arrDelRows[count($arrDelRows) - 1] + 1;
				$this->ssh('sed -i \'' . $firstRowDel . ',' . $lastRowDel . 'd\' ' . $pathOrig);
			}
		}
	}

	public function generate_userlog()
	{
		$deltaDel = 72 * 3600;
		$resConfLog = json_decode(file_get_contents($this->logConfRotate), 1);
		$timeLast = 0;
		if (is_array($resConfLog) && isset($resConfLog['lasttime'])) {
			$timeLast = $resConfLog['lasttime'];
		}

		$timestart = time();
		$dh = opendir($GLOBALS['DATA_VHOSTS']);

		while (false !== $filename = readdir($dh)) {
			if ($filename[0] == '.') {
				continue;
			}

			$domains[] = substr($filename, 0, strrpos($filename, '.'));
		}

		$hostacc = new hostacc();
		$back_server = $this->detect_back_server();

		foreach ($domains as $domain) {
			$file = $GLOBALS['DATA_VHOSTS'] . $domain . '.conf';
			$args = $this->config_read($file);
			$user = $args['user'];
			$confUser = $this->config_read($GLOBALS['USERS_PATH'] . $user);
			$workspace = $hostacc->getWorkspace($user);

			if (0 < strlen($workspace)) {
				$workspace = $workspace . '/';
			}

			$dir_logs = $GLOBALS['HTTPD_VHOSTLOGS'];

			if ($back_server['service'] == 'nginx') {
				$dir_logs = $GLOBALS['NGINX_VHOSTLOGS'];
			}

			if (!is_dir($confUser['rootdir'] . '/' . $workspace . 'log/')) {
				$comm = 'mkdir -p ' . $confUser['rootdir'] . '/' . $workspace . 'log/';
				$this->ssh($comm);
			}

			$fileAccess = $dir_logs . $domain . '_access';
			$fileError = $dir_logs . '/' . $domain . '_error';

			if (isset($user) && (1 < strlen($user))) {
				$fileCopyAccess = $confUser['rootdir'] . '/' . $workspace . 'log/' . $domain . '_' . date('m.Y') . '_access';
				$fileCopyError = $confUser['rootdir'] . '/' . $workspace . 'log/' . $domain . '_' . date('m.Y') . '_error';
			}
			else {
				$dir_def = '/var/log/brainy';
				$comm = 'mkdir -p ' . $dir_def . '/' . $workspace . 'log/';
				$this->ssh($comm);
				$fileCopyAccess = $dir_def . '/' . $workspace . 'log/' . $domain . '_' . date('m.Y') . '_access';
				$fileCopyError = $dir_def . '/' . $workspace . 'log/' . $domain . '_' . date('m.Y') . '_error';
			}

			$offset_webserver = 0;
			$this->rotateLogType($fileAccess, $fileCopyAccess, $timeLast, $deltaDel, $offset_webserver, $timestart, 0);
			$this->rotateLogType($fileError, $fileCopyError, $timeLast, $deltaDel, $offset_webserver, $timestart, 1);
			$this->ssh('chown -R ' . $user . '.' . $user . ' ' . $confUser['rootdir'] . '/' . $workspace . 'log/');
		}

		$resConfLog['lasttime'] = $timestart;
		file_put_contents($this->logConfRotate, json_encode($resConfLog));
		$this->monitor_comm_os('httpd', 'reload');
		$this->monitor_comm_os('nginx', 'reload');
		$resConfLog = json_decode(file_get_contents($this->logConfRotate), 1);
	}

	public function addAddrToZone($domain, $name, $type, $value)
	{
		if (!$this->check_value('domain', $domain)) {
			return false;
		}

		$bind = new bindserver();
		$bind->bindserver_addAddrToZone($domain, $name, $type, $value);
		return true;
	}

	public function convert_domain_user($username)
	{
		if (!$this->check_user($username)) {
			return false;
		}

		$users = $this->request_vars_m('users', $username);

		if (!sizeof($users)) {
			return false;
		}

		$sites = explode(',', $users['vhost_list']);
		$i = 0;

		while ($i < count($sites)) {
			if (!!trim($sites[$i])) {
				$site_conf = explode(':', $sites[$i]);
				$site_conf1 = $site_conf[0];
				$this->webserver_convert_domain($site_conf1);
			}

			++$i;
		}

		return true;
	}

	public function rebuildnamevirt_apache()
	{
		$conf = $this->config_read($GLOBALS['SERVER_CONTROL_MAIN']);
		$webserv_conf = $this->detect_webserver_path_service_conf();
		$apache_path = $webserv_conf['path'];
		$webserver = $webserv_conf['service'];
		$front = $webserv_conf['frontservice'];

		if ($webserver == 'httpd') {
			$ipmanager = new ipmanager();
			$listips = $ipmanager->ipmanager_ipv4();
			file_put_contents($apache_path . '/conf/namevirt.host', '');

			foreach ($listips as $key => $val) {
				if ($front == 'nginx') {
					file_put_contents($apache_path . '/conf/namevirt.host', 'NameVirtualHost ' . $val['ip'] . ':8080' . "\n", FILE_APPEND);
				}
				else {
					file_put_contents($apache_path . '/conf/namevirt.host', 'NameVirtualHost ' . $val['ip'] . ':80' . "\n", FILE_APPEND);
					file_put_contents($apache_path . '/conf/namevirt.host', 'NameVirtualHost ' . $val['ip'] . ':443' . "\n", FILE_APPEND);
				}
			}
		}

		$this->webservers_reloadconf();
	}

	public function checkFPMby_proc()
	{
		$comm = 'ps aux | grep \'fpm\' | grep \'.conf\' | awk \'{print $1}\'';
		$res = $this->ssh($comm);
		$check_alread[] = 'apache';
		$check_alread[] = 'root';

		foreach ($res as $curuser) {
			if (!in_array($curuser, $check_alread)) {
				$check_alread[] = $curuser;
				$this->checkFPM_conf($curuser);
			}
		}
	}

	public function getUserByDomain($domain)
	{
		$handle = fopen('/etc/brainy/data/server_control/vhosts', 'r');

		if (!feof($handle)) {
			$str = fgets($handle, 4096);
			$user = trim(explode(':', $str)[1]);
			break;
		}

		fclose($handle);
		return $user;
	}

	public function getUserDomainLogStat($user)
	{
		$vhosts = $this->get_virt_hosts($user);
		$i = 0;
		$logDom = array();

		foreach ($vhosts as $vhost) {
			$logDom[$i]['domain'] = $vhost['domain'];
			$confDom = $this->config_read($GLOBALS['DATA_VHOSTS'] . $vhost['domain'] . '.conf');

			if (!isset($confDom['logaccess'])) {
				$logDom[$i]['logaccess'] = 1;
			}
			else {
				$logDom[$i]['logaccess'] = $confDom['logaccess'];
			}

			if (!isset($confDom['logerror'])) {
				$logDom[$i]['logerror'] = 1;
			}
			else {
				$logDom[$i]['logerror'] = $confDom['logerror'];
			}

			++$i;
		}

		return $logDom;
	}

	public function setUserDomLogStat($user, $domain, $stat = 1, $logtype = 1)
	{
		global $lang;

		if (!$this->check_value('domain', $domain)) {
			$outm['code'] = 104;
			$outm['message'] = $lang['server_control_dom_d_f_i'];
			return $outm;
		}

		if (!$this->check_value('user', $user)) {
			$outm['code'] = 105;
			$outm['message'] = $lang['server_control_LogDomainDomainWrongUsername'];
			return $outm;
		}

		if ($logtype == 1) {
			$arr_vhost['logaccess'] = intval($stat);
		}

		if ($logtype == 2) {
			$arr_vhost['logerror'] = intval($stat);
		}

		$this->config_save($GLOBALS['DATA_VHOSTS'] . $domain . '.conf', $arr_vhost, 'add');
		$outm['code'] = 0;
		$outm['message'] = $lang['server_control_LogDomainDomainSetOk'];
		$rrrr = $this->webserver_convert_domain($domain);
		return $outm;
	}

	public function set_apache_module($module)
	{
		$arr = array('module' => $module);
		$this->config_save('/etc/brainy/data/server_control/mpm', $arr, 'add');
		$res['code'] = 0;
		$res['mess'] = 'MPM ' . $module . ' установлен по умолчанию.';
		$res['httpd'] = '';
		$arr = $this->config_read('/etc/brainy/data/server_control/main');

		if (isset($arr['back_server']) && ($arr['back_server'] == 'apache2.4')) {
			if ($this->activate_apache_mpm()) {
				$res['code'] = 0;
				$res['mess'] = 'MPM ' . $module . ' успешно применен для текущего Apache.';
				$this->sudo_ssh('systemctl restart apache');
				$out = implode("\n", $this->sudo_ssh('httpd -V | grep \'MPM:\' &>/dev/stdout'));
				$res['httpd'] = '' . $out;
			}
			else {
				$res['code'] = 1;
				$res['mess'] = 'Произошла ошибка при активации нового MPM ' . $module;
			}
		}

		return $res;
	}

	public function get_apache_module()
	{
		$arr = $this->config_read('/etc/brainy/data/server_control/mpm');
		$mpm = 'Worker';

		if (isset($arr['module'])) {
			$mpm = $arr['module'];
		}

		return $mpm;
	}

	public function activate_apache_mpm()
	{
		$arr = $this->config_read('/etc/brainy/data/server_control/main');
		if (!(isset($arr['back_server']) && ($arr['back_server'] == 'apache2.4'))) {
			return false;
		}

		$arr = $this->config_read('/etc/brainy/data/server_control/mpm');

		if (!isset($arr['module'])) {
			return false;
		}

		$mpm = $arr['module'];

		if ($mpm == 'Event') {
			$this->sudo_ssh('echo \'LoadModule mpm_event_module modules/mod_mpm_event.so\' > /etc/httpd/conf.modules.d/00-mpm.conf');
		}
		else if ($mpm == 'Prefork') {
			$this->sudo_ssh('echo \'LoadModule mpm_prefork_module modules/mod_mpm_prefork.so\' > /etc/httpd/conf.modules.d/00-mpm.conf');
		}
		else if ($mpm == 'Worker') {
			$this->sudo_ssh('echo \'LoadModule mpm_worker_module modules/mod_mpm_worker.so\' > /etc/httpd/conf.modules.d/00-mpm.conf');
		}
		else {
			return false;
		}

		return true;
	}

	public function webserver_set_mpm()
	{
		$arr = $this->config_read('/etc/brainy/data/server_control/mpm');

		if (isset($arr['module'])) {
			$this->activate_apache_mpm();
		}
		else {
			$arr = array('module' => 'Prefork', 'inst' => 'yes');
			$this->config_save('/etc/brainy/data/server_control/mpm', $arr, 'add');
			$this->activate_apache_mpm();
		}
	}

	public function getUserDomainHTTP2($user)
	{
		$vhosts = $this->get_virt_hosts($user);
		$i = 0;
		$dom = array();

		foreach ($vhosts as $vhost) {
			$dom[$i]['domain'] = $vhost['domain'];
			$confHTTP2 = $this->config_read($GLOBALS['DATA_VHOSTS'] . $vhost['domain'] . '.conf');

			if (!isset($confHTTP2['http2apache'])) {
				$dom[$i]['http2apache'] = 0;
			}
			else {
				$dom[$i]['http2apache'] = $confHTTP2['http2apache'];
			}

			if (!isset($confHTTP2['http2nginx'])) {
				$dom[$i]['http2nginx'] = 0;
			}
			else {
				$dom[$i]['http2nginx'] = $confHTTP2['http2nginx'];
			}

			++$i;
		}

		return $dom;
	}

	public function setUserDomHTTP2($user, $domain, $stat = 0, $webtype = 1)
	{
		global $lang;

		if (!$this->check_value('domain', $domain)) {
			$outm['code'] = 104;
			$outm['message'] = $lang['server_control_dom_d_f_i'];
			return $outm;
		}

		if (!$this->check_value('user', $user)) {
			$outm['code'] = 105;
			$outm['message'] = $lang['http2_control_DomainWrongUser'];
			return $outm;
		}

		$arr_vhost['http2apache'] = intval($stat);
		$arr_vhost['http2nginx'] = intval($stat);
		$outm['message'] = $lang['http2_control_nginxDomainSetOk'];
		$this->config_save($GLOBALS['DATA_VHOSTS'] . $domain . '.conf', $arr_vhost, 'add');
		$outm['code'] = 0;
		$rrr = $this->webserver_convert_domain($domain);
		return $outm;
	}

	public function setHTTP2hostAll($user, $stat = 0)
	{
		global $lang;

		if (!$this->check_value('domain', $domain)) {
			$outm['code'] = 104;
			$outm['message'] = $lang['server_control_dom_d_f_i'];
			return $outm;
		}

		if (!$this->check_value('user', $user)) {
			$outm['code'] = 105;
			$outm['message'] = $lang['http2_control_DomainWrongUser'];
			return $outm;
		}

		$arr_vhost['http2hostall'] = intval($stat);
		$outm['message'] = $lang['http2_control_host_all'];
		$this->config_save($GLOBALS['USERS_PATH'] . $user, $arr_vhost, 'add');
		$outm['code'] = 0;
		return $outm;
	}

	public function getHTTP2hostAll($user)
	{
		$dom = array();
		$HTTP2 = $this->config_read($GLOBALS['USERS_PATH'] . $user);

		if (!isset($HTTP2['http2hostall'])) {
			$dom['http2hostall'] = 0;
		}
		else {
			$dom['http2hostall'] = $HTTP2['http2hostall'];
		}

		return $dom;
	}
}


?>
