<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class webserver_config
{
	private $src_acsess = '/etc/brainy/data/webserver_config/user_includes/';

	public function show_sites($user)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		$domain = new Webserver();
		return $domain->get_virt_hosts($user);
	}

	public function show_sites_decode($user)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		$domain = new Webserver();
		return $domain->get_virt_hosts($user, 1);
	}

	public function server()
	{
		$server = $this->config_read('/etc/brainy/data/server_control/main');

		if (($server['back_server'] != 'nginx') && ($server['front_server'] == 'nginx')) {
			return 'apache_nginx';
		}

		if ($server['back_server'] == 'nginx') {
			return 'nginx';
		}

		return 'apache';
	}

	public function show_nginx_accsses($user, $sites, $url_file)
	{
		if (!$this->check_value('user', $user)) {
			return false;
		}

		if (!$this->check_value('domain', $sites)) {
			return false;
		}

		$out['show_nginx_accsses'] = $this->read_file($this->src_acsess . $user . '/' . $sites . '.' . $url_file);
		$out['show_url'] = $this->src_acsess . $user . '/' . $sites . '.' . $url_file;
		$loct = '_location';

		if ($this->server() == 'apache_nginx') {
			$loct = '_location_proxy';
		}

		$out['type'] = $this->server();
		$out['show_nginx_accsses_loct'] = $this->read_file($this->src_acsess . $user . '/' . $sites . $loct . '.' . $url_file);
		$out['show_url_loct'] = $this->src_acsess . $user . '/' . $sites . $loct . '.' . $url_file;
		return $out;
	}

	public function save_nginx_accsses($user, $sites, $str1, $url_file, $str_loct1)
	{
		global $lang;
		$str = str_replace('%3F', '&', $str1);
		$str_loct = str_replace('%3F', '&', $str_loct1);

		if (!$this->check_value('user', $user)) {
			return false;
		}

		if (!$this->check_value('domain', $sites)) {
			return false;
		}

		$type = $this->server();
		$loct = '_location';

		if ($type == 'apache_nginx') {
			$loct = '_location_proxy';
		}

		$str_setting = $this->read_file($this->src_acsess . $user . '/' . $sites . '.' . $url_file);
		if (($url_file == 'nginx') || ($url_file == 'nginx.ssl')) {
			$str_setting_loct = $this->read_file($this->src_acsess . $user . '/' . $sites . $loct . '.' . $url_file);
		}

		$this->write_file(trim($str), $this->src_acsess . $user . '/' . $sites . '.' . $url_file);
		if (($url_file == 'nginx') || ($url_file == 'nginx.ssl')) {
			$this->write_file(trim($str_loct), $this->src_acsess . $user . '/' . $sites . $loct . '.' . $url_file);
		}

		$webserver = new webserver();
		$webserver->webserver_convert_domain($sites);
		if (($url_file == 'nginx') || ($url_file == 'nginx.ssl')) {
			$return_ssh = $this->sudo_ssh('nginx -t &>/dev/stdout');
			$reg = '/\\bsuccessful\\b/i';
		}
		else {
			$return_ssh = $this->ssh('httpd -t 2>/dev/stdout');
			$reg = '/\\bSyntax OK\\b/i';
		}

		if (preg_match_all($reg, implode(' ', $return_ssh))) {
			$out['mess'] = '';
			$out['save'] = 1;
			$out['text'] = $lang['webserver_config_ok'];
			$this->ssh('service nginx reload');
			$this->ssh('service httpd reload');
			return $out;
		}

		$out['mess'] = "\n\n" . implode("\n", $return_ssh);
		$this->write_file($str_setting, $this->src_acsess . $user . '/' . $sites . '.' . $url_file);
		if (($url_file == 'nginx') || ($url_file == 'nginx.ssl')) {
			$this->write_file($str_setting_loct, $this->src_acsess . $user . '/' . $sites . $loct . '.' . $url_file);
		}

		$out['save'] = $str_setting;
		$out['text'] = $lang['webserver_config_eror'];
		$this->ssh('service nginx reload');
		$this->ssh('service httpd reload');
		return $out;
	}

	public function user_redirect_hosts_files($domain, $old_user = '', $new_user = '')
	{
		if (!$this->check_value('user', $old_user)) {
			return false;
		}

		if (!$this->check_value('user', $new_user)) {
			return false;
		}

		if (!$this->check_value('domain', $sites)) {
			return false;
		}

		$arr = array('.apache', '.nginx', '_location.nginx');
		$f_old = $this->src_acsess . $old_user . '/' . $domain;
		$f_new = $this->src_acsess . $new_user . '/' . $domain;
		$i = 0;

		while ($i < count($arr)) {
			rename($f_old . $arr[$i], $f_new . $arr[$i]);
			unlink($f_old . $arr[$i]);
			++$i;
		}

		return true;
	}

	public function scan_for_redirect_hosts($domain, $user)
	{
		$dir = $this->src_acsess;
		$all_users = $this->get_users();
		$arr = array();
		$arr['new_user'] = $user;
		$arr['old_user'] = '';

		foreach ($all_users as $us) {
			$files = scandir($dir . $us);
			$b = 0;

			foreach ($files as $file) {
				if ((strpos($file, $domain . '.nginx') === 0) || (strpos($file, $domain . '.apache') === 0) || (strpos($file, $domain . '_location.nginx') === 0)) {
					$arr['file'][] = $file;
					$b = 1;
				}
			}

			$arr['old_user'] = $us;
			break;
		}

		if (($arr['old_user'] != $arr['new_user']) || ($arr['old_user'] != '')) {
			$this->user_redirect_hosts_files($domain, $arr['old_user'], $arr['new_user']);
		}

		return $arr;
	}
}


?>
