<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

class YDiskBackup
{
	protected $auth_token;
	protected $backup_src_dir;
	protected $disk_dest_resrouce;
	protected $is_overwrite_enabled = false;
	protected $is_md5_check_enabled = true;
	protected $is_quiet_mod_enanled = false;
	public $disk;

	public function __construct($auth_token, $backup_src_dir, $disk_dest_resource, $force_overwrite = false, $verify_md5 = true, $be_quiet = false)
	{
		$this->auth_token = $auth_token;
		$this->backup_src_dir = $backup_src_dir;
		$this->disk_dest_resrouce = $disk_dest_resource;
		$this->disk = new Arhitector\Yandex\Disk();
		$this->disk->setAccessToken($auth_token);
		$this->is_md5_check_enabled = $verify_md5;
		$this->is_overwrite_enabled = $force_overwrite;
		$this->is_quiet_mod_enanled = $be_quiet;
		return $this;
	}

	public function run()
	{
		$this->iterateDirectory('');
	}

	public function getExistDir($dir)
	{
		try {
			if (0 < $this->disk->total_space) {
				$res = $this->disk->getResource($dir);

				if ($res->has() === true) {
					return $res->isDir();
				}

				$res->create();
				$res = $this->disk->getResource($dir);

				if ($res->has() === true) {
					return $res->isDir();
				}

				return false;
			}
		}
		catch (Arhitector\Yandex\Client\Exception\UnauthorizedException $exc) {
			return -1;
		}
	}

	public function isConn()
	{
		try {
			if (0 < $this->disk->total_space) {
				return 1;
			}
		}
		catch (Arhitector\Yandex\Client\Exception\UnauthorizedException $exc) {
			return -1;
		}
	}

	public function backupFile($src_path, $dest_resource)
	{
		$this->info('Backing ' . $src_path . ' up to ' . $dest_resource . '...');
		$res = $this->disk->getResource($dest_resource);

		if (($res->has() === true) && ($this->is_overwrite_enabled === false) && ($this->is_md5_check_enabled === false)) {
			$this->info('The resource ' . $dest_resource . ' exists. Please use overwrite flag to force upload');
			return NULL;
		}

		if ($res->has() === false) {
			$result = $res->upload($src_path);
			$this->info('Upload request status: ' . $result);
		}
		else if ($this->is_md5_check_enabled) {
			$src_file_md5 = md5_file($src_path);
			$dest_file_md5 = $res->get('md5');

			if (strcmp($src_file_md5, $dest_file_md5) !== 0) {
				$this->warn('Failed md5 check: src [' . $src_file_md5 . '] dest [' . $dest_file_md5 . ']');

				if ($this->is_overwrite_enabled) {
					$result = $res->upload($src_path, true);
					$this->info('Overwrite upload request status: ' . $result);
				}
				else {
					$this->warn('Please consider using overwrite flag to force upload.');
				}
			}
			else {
				$this->info('File is alreay on Disk and md5 is equal, skipping.');
			}
		}
		else {
			$this->info('File exists on Disk, md5 check is disabled, skipping.');
		}
	}

	protected function iterateDirectory($cur_rel_path)
	{
		$cur_dir = $this->backup_src_dir . $cur_rel_path;
		$dir_handle = opendir($cur_dir);
		$this->info('Iterating directory: ' . $cur_dir);

		while ($file = readdir($dir_handle)) {
			if ($file[0] == '.') {
				continue;
			}

			$file_next = $cur_dir . DIRECTORY_SEPARATOR . $file;
			$target_resource_path = $this->disk_dest_resrouce . $cur_rel_path . '/' . $file;

			if (is_dir($file_next)) {
				$res = $this->disk->getResource($target_resource_path);

				if ($res->has() === false) {
					$this->info('The Dir resource \'' . $target_resource_path . '\' doesn\'t exist. Going to create one');
					$res->create();
				}

				$this->iterateDirectory($cur_rel_path . DIRECTORY_SEPARATOR . $file);
			}
			else {
				$this->backupFile($file_next, $target_resource_path);
			}
		}
	}

	public function log($level, $message, array $context = array())
	{
		if ($this->is_quiet_mod_enanled) {
			return NULL;
		}

		$pid = 'N/A';

		if (function_exists('getmypid')) {
			$pid = getmypid();
		}

		echo date('Y-m-d H:i:s') . ' (' . $pid . ')' . ' [' . $level . '] ' . $message . (count($context) ? '. Context: ' . var_export($context, true) : '') . "\n";
	}

	public function info($message, array $context = array())
	{
		return $this->log('INFO', $message, $context);
	}

	public function warn($message, array $context = array())
	{
		return $this->log('WARN', $message, $context);
	}
}

error_reporting(0);
require_once __DIR__ . '/ydisk/vendor/autoload.php';

?>
