<?php
### Brainy Control Panel
### Decoded IonCube by pimnik98 
### Декодировал Пиминов Никита 
### vk.com/piminov_remont
### Скрипт скачан с портала X-Scripts.Ru

require_once '/etc/brainy/lib/ydisk.php';

if (isset($argv[1])) {
	require_once '/etc/brainy/conf/globals.php';

	if ($GLOBALS['DEMO'] == '1') {
		exit();
	}

	$param = $argv[1];
	if (($param == 'cronrun') || ($param == 'listdb')) {
		require_once '/etc/brainy/lib/punycode/idna_convert.php';
		require_once $GLOBALS['CLASSES_PATH'] . '/server.php';
		require_once $GLOBALS['CLASSES_PATH'] . '/certs.php';
		require_once $GLOBALS['CLASSES_PATH'] . '/backup.php';
		require_once $GLOBALS['CLASSES_PATH'] . '/dbusage.php';
		require_once $GLOBALS['CLASSES_PATH'] . '/mailclient.php';
		require_once $GLOBALS['CLASSES_PATH'] . '/bindserver.php';
		require_once $GLOBALS['CLASSES_PATH'] . '/webserver.php';
		require_once $GLOBALS['CLASSES_PATH'] . '/hostacc.php';
		require_once $GLOBALS['CLASSES_PATH'] . '/ftp.php';
		require_once $GLOBALS['CLASSES_PATH'] . '/certs.php';
		$server = new server();
		$server->load_globals();
		$backup = new backup();
		$mysql = new dbusage();
	}

	if ($param == 'cronrun') {
		$user_data['group_properties']['root'] = 'y';
		$user_data['name'] = 'root';
		error_reporting(0);
		$conf = $server->config_read('/etc/brainy/data/properties/prop.conf');

		if (isset($conf['language'])) {
			$langload = $conf['language'];
		}
		else {
			$langload = 'ru';
		}

		$server->lan_include($langload);
		$backup->run_cron_backup($user_data, $mysql);
		$backup->getlistbackups_arch_local($user_data, '|', 900, NULL, 'default', 'default');
		exit();
	}

	if ($param == 'listdb') {
		$backup->getListAllDB();
		exit();
	}
}

$backup = new backup();
$mysql = new dbusage();
$webserver = new webserver();
$user_group = $server->user['group'];
$unix_user = $server->user['name'];
$user_data = $server->user;
session_write_close();
$subdo = htmlspecialchars($_GET['subdo']);
$subaction = htmlspecialchars($_GET['subaction']);
$typeservftp = htmlspecialchars($_GET['typeservftp']);
$serialdata = $_POST['serialdata'];
$jDecode = json_decode($serialdata, 1);
$pageselBackups = intval($jDecode['pageselBackups']);
$ippBackups = 10;
$pageGenActiongetlistbackup = 'getlistbackup';

if ($subaction == 'getlistbackup') {
	if (isset($_COOKIE['perpage_' . $pageGenActiongetlistbackup])) {
		$ippBackups = intval($_COOKIE['perpage_' . $pageGenActiongetlistbackup]);
	}

	if (isset($jDecode['ippBackups']) && (intval($jDecode['ippBackups']) != 0)) {
		$ippBackups = intval($jDecode['ippBackups']);
		setcookie('perpage_' . $pageGenActiongetlistbackup, $ippBackups);
	}
}

$pageselConf = intval($jDecode['pageselConf']);
$ippConf = 10;
$pageGenActiongetlistconf = 'getlistconf';

if (isset($_COOKIE['perpage_' . $pageGenActiongetlistconf])) {
	$ippConf = intval($_COOKIE['perpage_' . $pageGenActiongetlistconf]);
}

if (isset($jDecode['ippConf']) && (intval($jDecode['ippConf']) != 0)) {
	$ippConf = intval($jDecode['ippConf']);
	setcookie('perpage_' . $pageGenActiongetlistconf, intval($ippConf));
}

$rootRights = 0;
if (($server->user['group_properties']['root'] == 'y') || ($server->user['group_properties']['users_management'] == 'y')) {
	$rootRights = 1;
}

$tpl->clean = 1;

switch ($subaction) {
case 'saveconfig':
	$user_data = $server->user;

	if ($GLOBALS['DEMO'] == '1') {
		$out['status'] = 'demo1';
		$out['raw_info'] = $lang['common_demo_message'];
		$out = json_encode($out);
	}
	else {
		$out = json_encode($backup->saveconfig($user_data, $serialdata));
	}

	print_r($out);
	break;

case 'getlistconf':
	$backup_list_config = $backup->getconfig_filelist($user_data, $serialdata);
	$decode = json_decode($serialdata, true);
	$page = intval($pageselConf);
	$counter = count($backup_list_config) - 1;
	$url = '/?do=backup';
	$first = $page * $ippConf;
	$backup_list_config = array_slice($backup_list_config, $first, $ippConf);
	$paginator = $tpl->page_generator($page, $ippConf, $counter, $url, $pageGenActiongetlistconf, 1);
	$smarty->assign('paginator', $paginator);
	$smarty->assign('backup_list_config', $backup_list_config);
	$out['raw_info'] = $tpl->load_tpl('backup_listconf.tpl');
	$out['status'] = 'done';
	print_r(json_encode($out));
	break;

case 'loadconfig':
	$user_data = $server->user;
	$smarty->assign('user_group', $user_group);
	$decode = json_decode($serialdata, true);
	$exp_fileconf = explode('_', $decode['backup_configfile']);
	$checkpermloadc = $backup->checkperm_path($user_data, $decode['backup_configfile'], '_');

	if ($decode['backup_configfile'] == 'empty') {
	}
	else if ($checkpermloadc['res'] == 1) {
		$out = $backup->getconfig($user_data, $serialdata);
		$smarty->assign('workspace', $out['workspace']);
		$smarty->assign('conf', $out);

		if (isset($decode['vars'])) {
			if ($decode['vars'] == 1) {
				$out['raw_info'] = $out;
			}
			else {
				$out['raw_info'] = $tpl->load_tpl('backup_config.tpl');
			}
		}
		else {
			$out['raw_info'] = $tpl->load_tpl('backup_config.tpl');
		}

		$out['status'] = 'done';
	}
	else {
		$out = array();
		$backup->getconfigmain($out);
		$smarty->assign('conf', $out);
		$out['raw_info'] = $tpl->load_tpl('backup_config.tpl');
		$out['status'] = 'done';
	}

	print_r(json_encode($out));
	break;

case 'createarch':
	$user_data = $server->user;
	$out = json_encode($backup->createarch_local2($user_data, $serialdata, $mysql));
	print_r($out);
	break;

case 'backup_delete_config':
	$user_data = $server->user;
	$out = json_encode($backup->backup_delete_config($user_data, $serialdata));
	print_r($out);
	break;

case 'getlistbackup':
	$user_data = $server->user;
	$smarty->assign('user_group', $user_group);
	$smarty->assign('backupdir', $GLOBALS['BACKUP_DIR']);
	$decode = json_decode($serialdata, true);
	$userSel = '';

	if (isset($decode['usersel'])) {
		$userSel = $decode['usersel'];
	}

	if ((strlen($decode['colorder']) < 1) || (strlen($decode['typeorder']) < 1)) {
		$confUser = parse_ini_file($backup->dirConfig . $user_data['name']);

		if (isset($confUser['ordercol'])) {
			$smarty->assign('ordercol', $confUser['ordercol']);
			$smarty->assign('orderasc', $confUser['orderasc']);
			$out = $backup->getlistbackups_arch_local($user_data, $decode['search'], $decode['timecache'], NULL, $confUser['ordercol'], $confUser['orderasc'], $userSel);
		}
		else {
			$smarty->assign('ordercol', 'date');
			$smarty->assign('orderasc', 'desc');
			$out = $backup->getlistbackups_arch_local($user_data, $decode['search'], $decode['timecache'], NULL, 'date', 'desc', $userSel);
		}
	}
	else {
		$smarty->assign('ordercol', $decode['colorder']);
		$smarty->assign('orderasc', $decode['typeorder']);
		$out = $backup->getlistbackups_arch_local($user_data, $decode['search'], $decode['timecache'], NULL, $decode['colorder'], $decode['typeorder'], $userSel);
	}

	foreach ($out as $key1 => $cur1) {
		foreach ($cur1 as $key2 => $cur2) {
			if (count($cur2) < 1) {
				unset($out[$key1][$key2]);
				unset($out[$key1]);
			}
		}
	}

	$page = intval($pageselBackups);
	$url = '/?do=backup';
	$first = $page * $ippBackups;
	$timelist = $out[0]['timelist'];
	$countlist_backups = $out[0]['countlist_backups'];

	if (isset($out['countlist_backups'])) {
		unset($out['countlist_backups']);
	}

	if (isset($out[0]['timelist'])) {
		unset($out[0]);
	}

	$counter = count($out);
	$out = array_slice($out, $first, $ippBackups);
	$outData = array('timelist' => $timelist, 'countlist_backups' => $countlist_backups);
	$paginator = $tpl->page_generator($page, $ippBackups, $counter, $url, $pageGenActiongetlistbackup, 1);
	$smarty->assign('paginator', $paginator);
	$smarty->assign('backups', $out);
	$smarty->assign('backupsData', $outData);
	$ipmanager = new ipmanager();
	$ipList = $ipmanager->ipmanager_listips();
	$smarty->assign('ipList', $ipList);
	$out['raw_info'] = $tpl->load_tpl('backuplist.tpl');
	$out['status'] = 'done';
	print_r(json_encode($out));
	break;

case 'backup_restore':
	$user_data = $server->user;
	$out = $backup->restorebackup($user_data, $serialdata);
	$smarty->assign('backuphist', $out[0]['raw_list_backup_hist']);
	$smarty->assign('user_group', $user_group);
	$out[0]['raw_list_backup_hist'] = $tpl->load_tpl('backup_hist.tpl');
	print_r(json_encode($out));
	break;

case 'generatekey':
	$user_data = $server->user;
	$out = $backup->generatekeyrsa($user_data, $serialdata);
	print_r(json_encode($out));
	break;

case 'saversa':
	$user_data = $server->user;
	$out = $backup->savekeyrsa($user_data, $serialdata);
	print_r(json_encode($out));
	break;

case 'check_connect_remote':
	$user_data = $server->user;
	$decode = json_decode($serialdata, true);
	$file_conf = $decode['uniq_name'];
	$nameconfig = $decode['taskconf'];
	$gdrive_vecode = $decode['gdrive_vercode'];
	$out = $backup->check_connect_remote($user_data, $file_conf, $nameconfig, $gdrive_vecode);
	print_r(json_encode($out));
	break;

case 'backup_manager_files':
	$user_data = $server->user;
	$check_perm = $backup->backup_manager_check_permis($user_data, $serialdata);

	if ($check_perm['status'] == 1) {
		$smarty->assign('backups_manager', $check_perm);
		session_write_close();
		$out['raw_info'] = $tpl->load_tpl('backup_manager.tpl');
		$out['status'] = 'done';
	}
	else {
		$out['raw_info'] = $lang['backup_manager_files_no_perm'];
		$out['status'] = 'done';
	}

	print_r(json_encode($out));
	break;

case 'backup_manager_db':
	$user_data = $server->user;
	$out_res = $backup->getlist_backups_db($user_data, $serialdata);
	$smarty->assign('backup_db', $out_res);
	$out['raw_info'] = $tpl->load_tpl('backup_db.tpl');
	$out['status'] = 'done';
	print_r(json_encode($out));
	break;

case 'backup_db_download':
	if ($GLOBALS['DEMO'] == '1') {
		$res['status'] = 'demo';
		$res['raw_info'] = $lang['common_demo_message'];
		$out = $res;
	}
	else {
		$user_data = $server->user;
		$out_res = $backup->prepare_dbs_download_remote($user_data, $serialdata);
		$smarty->assign('backup_db', $out_res);
	}

	print_r(json_encode($out_res));
	break;

case 'backup_full_download':
	$user_data = $server->user;
	$out_res = $backup->prepare_full_download($user_data, $serialdata);
	$smarty->assign('backup_full', $out_res);
	print_r(json_encode($out_res));
	break;

case 'backup_full_download_arch':
	$user_data = $server->user;
	$out_res = $backup->prepare_full_download($user_data, $serialdata);
	$smarty->assign('backup_full', $out_res);
	print_r(json_encode($out_res));
	break;

case 'backupremove':
	if ($GLOBALS['DEMO'] == '1') {
		$res['status'] = 'demo';
		$res['raw_info'] = $lang['common_demo_message'];
		$out_res = $res;
	}
	else {
		$user_data = $server->user;
		$out_res = $backup->removebackup($user_data, $serialdata);
	}

	print_r(json_encode($out_res));
	break;

case 'removemassbackup':
	if ($GLOBALS['DEMO'] == '1') {
		$res['status'] = 'demo';
		$res['raw_info'] = $lang['common_demo_message'];
		$out_res = $res;
	}
	else {
		$user_data = $server->user;
		$out_res = $backup->removemassbackups($user_data, json_decode($_POST['dataser'], 1));
	}

	print_r(json_encode($out_res));
	break;

case 'restorefromfile':
	if ($GLOBALS['DEMO'] == '1') {
		$res['status'] = 'demo';
		$res['raw_info'] = $lang['common_demo_message'];
		$out_res = $res;
	}
	else if ($_FILES['restonefile_load_input']['error'] == 1) {
		$out_res['code'] = 1;
		$out_res['mess'] = $lang['backup_list_maxpostover'];
	}
	else {
		$out_res = $backup->restorefromfile($user_data, $_FILES['restonefile_load_input']['name'], $_FILES['restonefile_load_input']['tmp_name'], $_FILES['restonefile_load_input']['size'], $_POST['input_path_backupone'], $_POST['input_enterpass_1'], $_POST['input_enterpass_2'], $_POST['input_enterpass_3'], $_POST['typerestval'], $_POST['input_path_backupone_url'], $_POST['input_path_backupone_ftp'], $_POST['input_enterpass_4']);
	}

	print_r(json_encode($out_res));
	break;

case 'checkhistory':
	if (($rootRights == 1) && isset($_POST['usersel']) && (1 < strlen($_POST['usersel']))) {
		$user_data['name'] = $_POST['usersel'];
	}

	$out_res = $backup->checkhistory_restore($user_data);
	$smarty->assign('backuphist', $out_res['raw_list_backup_hist']);
	$out['raw_list_backup_hist'] = $tpl->load_tpl('backup_hist.tpl');
	print_r(json_encode($out));
	break;

case 'checkhistory_backup':
	if (($rootRights == 1) && isset($_POST['usersel']) && (1 < strlen($_POST['usersel']))) {
		$user_data['name'] = $_POST['usersel'];
	}

	$out_res = $backup->checkhistory_backup($user_data);
	$smarty->assign('backuphist', $out_res['raw_list_backup_hist']);
	$out['raw_list_backup_hist'] = $tpl->load_tpl('backup_hist_backup.tpl');
	print_r(json_encode($out));
	break;

case 'removetokens':
	$out_res = $backup->removetokens($user_data['name'], $user_data['group_properties']['root'], $_GET['config']);
	print_r(json_encode($out_res));
	break;

case 'gethintconn':
	$out_res = $backup->getHintConn($_GET['typerepo']);
	print_r(json_encode($out_res));
	break;

case 'restoremass':
	if ($rootRights == 1) {
		$out_res = $backup->restoreMass($_POST['arrRest'], $_POST['ip'], $_POST['email']);
		print_r(json_encode($out_res));
	}

	break;

case 'cancelbackup':
	if (($rootRights == 1) && isset($_POST['usersel']) && (1 < strlen($_POST['usersel']))) {
		$user_data['name'] = $_POST['usersel'];
	}

	$out_res = $backup->cancelBackup($_POST['stream'], $user_data['name'], $rootRights);
	print_r(json_encode($out_res));
	break;

case 'cancelrestore':
	if (($rootRights == 1) && isset($_POST['usersel']) && (1 < strlen($_POST['usersel']))) {
		$user_data['name'] = $_POST['usersel'];
	}

	$out_res = $backup->cancelRestore($_POST['stream'], $user_data['name'], $rootRights);
	print_r(json_encode($out_res));
	break;

	if (($server->user['group_properties']['backup'] == 'n') && ($server->user['group_properties']['root'] != 'y')) {
		return $tpl->out = $smarty->fetch($GLOBALS['DOCUMENT_ROOT_PATH'] . $GLOBALS['template_path'] . '/common/access_denied.tpl');
	}

	$backup_list_config = $backup->getconfig_filelist($user_data, $serialdata);
	$smarty->assign('backup_list_config', $backup_list_config);
	$smarty->assign('user_group', $user_group);
	$crontab = new crontab();
	$sss = $crontab->crontab_check_brainy_status_command('');
	$arr['crond_status'] = $sss['crond_status'];
	$arr['crond_command_status'] = 1;
	$smarty->assign('cronstat', $arr);

	if (!is_file('~/.ssh/known_hosts')) {
		$server->ssh('mkdir -p ~/.ssh/');
		$server->ssh('touch ~/.ssh/known_hosts');
	}

	$out = array();
	$backup->getconfigmain($out);
	$smarty->assign('conf', $out);

	if ($server->user['group_properties']['root'] != 'y') {
		$hostacc = new hostacc();
		$workspace = $hostacc->getWorkspace($unix_user);

		if (0 < strlen($workspace)) {
			$workspace = $workspace . '/';
		}

		$confUser = $server->config_read($GLOBALS['USERS_PATH'] . $server->user['username']);
		$smarty->assign('workspace', $confUser['rootdir'] . '/' . $workspace);
	}
	else {
		$smarty->assign('workspace', '');
	}

	$arr['users'][] = 'root';
	$arr['users'] = array_merge($arr['users'], $server->get_users());
	$out2 = $tpl->load_tpl('backup.tpl', $arr);
	$tpl->out = $out2;
}

?>
