<?php
error_reporting(0);
require_once "/etc/brainy/classes/server.php";
require_once "/etc/brainy/classes/bindserver.php";
require_once "/etc/brainy/classes/black_domain.php";
require_once "/etc/brainy/lib/punycode/idna_convert.php";
require_once "/etc/brainy/classes/hostacc.php";
class bindcluster extends bindserver
{
    private $token = "";
    private $error = 200;
    private $error_text = "OK";
    public function bindcluster()
    {
        $this->token = $this->bindserver_getToken();
    }
    public function bindserver_getToken()
    {
        $this->load_vars("/etc/brainy/data/bindserver/data");
        return $this->module_vars["token"];
    }
    public function bindcluster_validToken($token)
    {
        if ($token == $this->token && $token != "") {
            return true;
        }
        return false;
    }
    public function bindcluster_repeater()
    {
        $answer = array();
        if ($this->bindcluster_validToken($_POST["token"])) {
            $answer["success"] = 2;
            if (!empty($_POST["act"])) {
                $answer["result"] = $this->bindcluster_run($_POST);
            }
        } else {
            $this->error = 207;
            $this->error_text = "Invalid token";
        }
        $this->bindcluster_showAnswerJson($answer);
    }
    public function bindcluster_run($param)
    {
        $this->bindcluster_log($param);
        $this->bindserver_named_options();
        if ($param["user"] == "root") {
            switch ($param["act"]) {
                case "add_zones":
                    return $this->bindserver_addZone("root", $param["zone"], $param["ip"]);
                case "delete_btn":
                    return $this->bindserver_deleteZone($param["zone"], "root");
                case "get_zones":
                    return $this->bindserver_getZoneTable_forCluster($param);
                case "get_zones2":
                    return $this->bindserver_getZone_forCluster($param);
                case "get_zones_array":
                    return $this->bindserver_getZoneByUser("root");
            }
        }
        switch ($param["act"]) {
            case "save_zone_to_file":
                $this->bindserver_addZone("root", $param["zone"], "1.1.1.1");
                return $this->bindserver_saveZone($param["zone"], $param["text"]);
            case "edit_zone":
                return implode("\n", $this->bindserver_editZone($param["zone"]));
            case "save_defns_table":
                return $this->bindserver_saveDefaultNsTable($param["zone"]);
            case "rebuilt_defns":
                return $this->bindserver_rebuiltDefaultNs();
            case "add_defns":
                return $this->bindserver_addDefaultNs($param["host"], $param["ip"]);
            case "delete_defns":
                return $this->bindserver_deleteDefaultNs($param["host"]);
            case "save_defns":
                return $this->bindserver_saveDefaultNs($param["oldhost"], $param["host"], $param["ip"], $param["rebuild"]);
            case "get_defaultns_array":
                return $this->bindserver_getDefaultNsArray();
            case "get_defaultns_ip":
                return $this->bindserver_getDefaultNsIP($param["host"]);
        }
        return false;
    }
    public function bindcluster_log($param)
    {
        file_put_contents("bindcluster.log", implode(" ", $param) . "\n", FILE_APPEND);
    }
    public function bindcluster_showAnswerJson($params)
    {
        header("Content-type: application/json; charset=utf-8");
        header("HTTP/1.1 " . $this->error . " " . $this->error_text);
        $json = $params;
        if ($this->error != 200) {
            $json["error"] = $this->error;
            $json["error_text"] = $this->error_text;
        }
        echo json_encode($json);
    }
}
$bind = new bindcluster();
$bind->bindcluster_repeater();

?>